<?php
/**
* Este arquivo é parte do projeto NFePHP - Nota Fiscal eletrônica em PHP.
*
* Este programa é um software livre: você pode redistribuir e/ou modificá-lo
* sob os termos da Licença Pública Geral GNU como é publicada pela Fundação
* para o Software Livre, na versão 3 da licença, ou qualquer versão posterior.
* e/ou
* sob os termos da Licença Pública Geral Menor GNU (LGPL) como é publicada pela
* Fundação para o Software Livre, na versão 3 da licença, ou qualquer versão posterior.
*
* Este programa é distribuído na esperança que será útil, mas SEM NENHUMA
* GARANTIA; nem mesmo a garantia explícita definida por qualquer VALOR COMERCIAL
* ou de ADEQUAÇÃO PARA UM PROPÓSITO EM PARTICULAR,
* veja a Licença Pública Geral GNU para mais detalhes.
*
* Você deve ter recebido uma cópia da Licença Publica GNU e da
* Licença Pública Geral Menor GNU (LGPL) junto com este programa.
* Caso contrário consulte
* <http://www.fsfla.org/svnwiki/trad/GPLv3>
* ou
* <http://www.fsfla.org/svnwiki/trad/LGPLv3>.
*
* @package     NFePHP
* @name        DamdfeNFePHP.class.php
* @version     1.0.0
* @license     http://www.gnu.org/licenses/gpl.html GNU/GPL v.3
* @license     http://www.gnu.org/licenses/lgpl.html GNU/LGPL v.3
* @copyright   2009-2014 &copy; NFePHP
* @link        http://www.nfephp.org/
* @author      Leandro C. Lopez <leandro dot castoldi at gmail dot com>
*
*        CONTRIBUIDORES (por ordem alfabetica):
*
*/
require_once('qrcode/qrcode.class.php');

//define o caminho base da instalação do sistema
if (!defined('PATH_ROOT')) {
	define('PATH_ROOT', dirname(dirname( __FILE__ )) . DIRECTORY_SEPARATOR);
}
//ajuste do tempo limite de resposta do processo
set_time_limit(1800);
//definição do caminho para o diretorio com as fontes do FDPF
if (!defined('FPDF_FONTPATH')) {
	define('FPDF_FONTPATH','font/');
}
//classe extendida da classe FPDF para montagem do arquivo pdf
require_once('PdfNFePHP.class.php');
//classe com as funções communs entre DANFE e DACTE
require_once('CommonNFePHP.class.php');

class DamdfeNFePHP extends CommonNFePHP {

	//publicas
	public $logoAlign='L'; //alinhamento do logo
	public $yDados=0;
	public $debugMode=0; //ativa ou desativa o modo de debug
	//privadas
	protected $pdf; // objeto fpdf()
	protected $xml; // string XML NFe
	protected $logomarca=''; // path para logomarca em jpg
	protected $errMsg=''; // mesagens de erro
	protected $errStatus=FALSE;// status de erro TRUE um erro ocorreu FALSE sem erros
	protected $orientacao='P'; //orientação da DANFE P-Retrato ou L-Paisagem
	protected $papel='A4'; //formato do papel
	protected $destino = 'I'; //destivo do arquivo pdf I-borwser, S-retorna o arquivo, D-força download, F-salva em arquivo local
	protected $pdfDir=''; //diretorio para salvar o pdf com a opção de destino = F
	protected $fontePadrao='Times'; //Nome da Fonte para gerar o DANFE
	protected $version = '1.0.0';
	protected $wPrint; //largura imprimivel
	protected $hPrint; //comprimento imprimivel
	protected $formatoChave="#### #### #### #### #### #### #### #### #### #### ####";
	//variaveis da carta de correção
	protected $id;
	protected $chMDFe;
	protected $tpAmb;
	protected $cOrgao;
	protected $xCondUso;
	protected $dhEvento;
	protected $cStat;
	protected $xMotivo;
	protected $CNPJDest = '';
	protected $dhRegEvento;
	protected $nProt;
	protected $tpEmis;
	//objetos
	private $dom;
	private $procEventoNFe;
	private $evento;
	private $infEvento;
	private $retEvento;
	private $rinfEvento;
	
	protected $infMDFeSupl;
	protected $qrCodMDFeLido = '';

	/**
	*__construct
	* @package NFePHP
	* @name __construct
	* @version 1.0.0
	* @param string $xmlfile Arquivo XML da MDFe
	* @param string $sOrientacao (Opcional) Orientação da impressão P-retrato L-Paisagem
	* @param string $sPapel Tamanho do papel (Ex. A4)
	* @param string $sPathLogo Caminho para o arquivo do logo
	* @param string $sDestino Estabelece a direção do envio do documento PDF I-browser D-browser com download S-
	* @param string $sDirPDF Caminho para o diretorio de armazenamento dos arquivos PDF
	* @param string $fonteDAMDFE Nome da fonte alternativa do DAnfe
	* @param number $mododebug 0-Não 1-Sim e 2-nada (2 default)
	*/

	public function __construct($xmlfile = '',
								$sOrientacao = '',
								$sPapel = '',
								$sPathLogo = '',
								$sDestino = 'I',
								$sDirPDF = '',
								$fontePDF = '',
								$mododebug = 2) {

		if(is_numeric($mododebug)){
			$this->debugMode = $mododebug;
		}
		if($this->debugMode){
			//ativar modo debug
			error_reporting(E_ALL);ini_set('display_errors', 'On');
		}else{
			//desativar modo debug
			error_reporting(0);ini_set('display_errors', 'Off');
		}
		$this->orientacao   = $sOrientacao;
		$this->papel        = $sPapel;
		$this->pdf          = '';
		//$this->xml          = $xmlfile;
		$this->logomarca    = $sPathLogo;
		$this->destino      = $sDestino;
		$this->pdfDir       = $sDirPDF;
		// verifica se foi passa a fonte a ser usada
		if (empty($fontePDF)) {
			$this->fontePadrao = 'Times';
		}else{
			$this->fontePadrao = $fontePDF;
		}
		//se for passado o xml
		if (empty($xmlfile)){
			$this->errMsg = 'Um caminho para o arquivo xml da MDFe deve ser passado!';
			$this->errStatus = true;
			exit();
		}
		if ( !is_file($xmlfile) ){
			$this->errMsg = 'Um caminho para o arquivo xml da MDFe deve ser passado!';
			$this->errStatus = true;
			exit();
		}
		$docxml = file_get_contents($xmlfile);
		$this->dom = new DomDocument;
		$this->dom->loadXML($docxml);

		$this->mdfeProc		= $this->dom->getElementsByTagName("mdfeProc")->item(0);
		$this->infMDFe		= $this->dom->getElementsByTagName("infMDFe")->item(0);

		$this->emit			= $this->infMDFe->getElementsByTagName("emit")->item(0);
		$this->CNPJ			= $this->emit->getElementsByTagName("CNPJ")->item(0)->nodeValue;
		$this->IE			= $this->emit->getElementsByTagName("IE")->item(0)->nodeValue;
		$this->xNome		= $this->emit->getElementsByTagName("xNome")->item(0)->nodeValue;

		$this->enderEmit	= $this->emit->getElementsByTagName("enderEmit")->item(0);
		$this->xLgr			= $this->enderEmit->getElementsByTagName("xLgr")->item(0)->nodeValue;
		$this->nro			= $this->enderEmit->getElementsByTagName("nro")->item(0)->nodeValue;
		$this->xBairro		= $this->enderEmit->getElementsByTagName("xBairro")->item(0)->nodeValue;
		$this->UF			= $this->enderEmit->getElementsByTagName("UF")->item(0)->nodeValue;
		$this->xMun			= $this->enderEmit->getElementsByTagName("xMun")->item(0)->nodeValue;
		$this->fone			= $this->enderEmit->getElementsByTagName("fone")->item(0)->nodeValue;
		$this->CEP			= $this->enderEmit->getElementsByTagName("CEP")->item(0)->nodeValue;

		$this->ide			= $this->infMDFe->getElementsByTagName("ide")->item(0);
		$this->tpAmb		= $this->ide->getElementsByTagName("tpAmb")->item(0)->nodeValue;
		$this->mod			= $this->ide->getElementsByTagName("mod")->item(0)->nodeValue;
		$this->serie		= $this->ide->getElementsByTagName("serie")->item(0)->nodeValue;
		$this->dhEmi		= $this->ide->getElementsByTagName("dhEmi")->item(0)->nodeValue;
		$this->UFIni		= $this->ide->getElementsByTagName("UFIni")->item(0)->nodeValue;
		$this->UFFim		= $this->ide->getElementsByTagName("UFFim")->item(0)->nodeValue;
		$this->nMDF			= $this->ide->getElementsByTagName("nMDF")->item(0)->nodeValue;
		$this->tpEmis		= $this->ide->getElementsByTagName("tpEmis")->item(0)->nodeValue;

		$this->tot			= $this->infMDFe->getElementsByTagName("tot")->item(0);
		//$this->qNFe		= $this->tot->getElementsByTagName("qNFe")->item(0)->nodeValue;
		$this->qNFe			= (empty($this->tot->getElementsByTagName("qNFe")->item(0)->nodeValue))? '0': $this->tot->getElementsByTagName("qNFe")->item(0)->nodeValue;
		$this->qMDFe		= (empty($this->tot->getElementsByTagName("qMDFe")->item(0)->nodeValue))? '0': $this->tot->getElementsByTagName("qMDFe")->item(0)->nodeValue;
		$this->qCTe			= (empty($this->tot->getElementsByTagName("qCTe")->item(0)->nodeValue))? '0': $this->tot->getElementsByTagName("qCTe")->item(0)->nodeValue;
		$this->qCT			= (empty($this->tot->getElementsByTagName("qCT")->item(0)->nodeValue))? '0': $this->tot->getElementsByTagName("qCT")->item(0)->nodeValue;
		$this->qNF			= (empty($this->tot->getElementsByTagName("qNF")->item(0)->nodeValue))? '0': $this->tot->getElementsByTagName("qNF")->item(0)->nodeValue;
		$this->qCarga		= $this->tot->getElementsByTagName("qCarga")->item(0)->nodeValue;

		$this->infModal		= $this->infMDFe->getElementsByTagName("infModal")->item(0);
		$this->rodo			= $this->infModal->getElementsByTagName("rodo")->item(0);
		$this->infANTT		= $this->rodo->getElementsByTagName("infANTT")->item(0);
		if($this->infANTT!=''){
			$this->RNTRC	= (empty($this->infANTT->getElementsByTagName("RNTRC")->item(0)->nodeValue))? '': $this->infANTT->getElementsByTagName("RNTRC")->item(0)->nodeValue;
		}else{
			$this->RNTRC	= '';
		}
		$this->veicTracao	= $this->rodo->getElementsByTagName("veicTracao")->item(0);
		$this->veicReboque1 = $this->rodo->getElementsByTagName("veicReboque")->item(0);
		$this->veicReboque2 = $this->rodo->getElementsByTagName("veicReboque")->item(1);
		$this->placa1		= $this->veicTracao->getElementsByTagName("placa")->item(0)->nodeValue;
		$this->prop1		= $this->veicTracao->getElementsByTagName("prop")->item(0);

		$this->vei_rntrc1	= '';
		$this->vei_rntrc2	= '';
		$this->vei_rntrc3	= '';
		$this->tp_carroceria= 'Outros';
		$tpCar = '01';
		if(!empty($this->veicTracao->getElementsByTagName("tpCar")->item(0)->nodeValue)){
			$tpCar = $this->veicTracao->getElementsByTagName("tpCar")->item(0)->nodeValue;
		}

		if(!empty($this->prop1)){
			$this->vei_rntrc1 = $this->prop1->getElementsByTagName("RNTRC")->item(0)->nodeValue;
		}else{
			$this->vei_rntrc1 = $this->RNTRC;
		}

		if(!empty($this->veicReboque1)){
			$this->placa2	= $this->veicReboque1->getElementsByTagName("placa")->item(0)->nodeValue;
			$this->prop2	= $this->veicReboque1->getElementsByTagName("prop")->item(0);
			if(!empty($this->prop2)){
				$this->vei_rntrc2 = $this->prop2->getElementsByTagName("RNTRC")->item(0)->nodeValue;
			}else{
				$this->vei_rntrc1 = $this->RNTRC;
			}
			if(!empty($this->veicReboque1->getElementsByTagName("tpCar")->item(0)->nodeValue)){
				$tpCar = $this->veicReboque1->getElementsByTagName("tpCar")->item(0)->nodeValue;
			}
		}else{
			$this->placa2	= '';
		}

		if(!empty($this->veicReboque2)){
			$this->placa3	= $this->veicReboque2->getElementsByTagName("placa")->item(0)->nodeValue;
			$this->prop3	= $this->veicReboque2->getElementsByTagName("prop")->item(0);
			if(!empty($this->prop3)){
				$this->vei_rntrc3  = $this->prop3->getElementsByTagName("RNTRC")->item(0)->nodeValue;
			}else{
				$this->vei_rntrc1  = $this->RNTRC;
			}
		}else{
			$this->placa3	= '';
		}
		if ($tpCar != '00'){
			//$this->tp_carroceria = utf8_encode(busca_dados_combo('tipo_carroceriar',$tpCar));
			$this->tp_carroceria = 'Outros';
			if ($tpCar=='04'){
				$this->tp_carroceria = 'Container';
			}
			if ($tpCar=='05'){
				$this->tp_carroceria = 'Pallet';
			}
		}
		$this->obs			= empty($this->infMDFe->getElementsByTagName("infAdic")->item(0)->nodeValue) ? '' : $this->infMDFe->getElementsByTagName("infAdic")->item(0)->nodeValue;
		$this->obs			= str_replace(';',"\n",$this->obs);
		$this->infDoc		= $this->infMDFe->getElementsByTagName("infDoc")->item(0);
		if(!empty($this->infDoc)){
			$this->infMunDescarga = $this->infDoc->getElementsByTagName("infMunDescarga");
			$this->infNFe	= $this->infDoc->getElementsByTagName("infNFe");
			//var_dump($this->infNFe->item(0)->nodeValue);
		}else{
			$this->infMunDescarga = array();
			$this->infNFe	= array();
		}

		$this->chMDFe		= str_replace('MDFe','',$this->infMDFe->getAttribute("Id")); //$this->mdfeProc->getElementsByTagName("chMDFe")->item(0)->nodeValue;
		if(is_object($this->mdfeProc)){
			$this->nProt	= (empty($this->mdfeProc->getElementsByTagName("nProt")->item(0)->nodeValue))? '': $this->mdfeProc->getElementsByTagName("nProt")->item(0)->nodeValue;
			$this->dhRecbto = $this->mdfeProc->getElementsByTagName("dhRecbto")->item(0)->nodeValue;
		}
		$this->infMDFeSupl = $this->dom->getElementsByTagName("infMDFeSupl")->item(0);
		$this->qrCodMDFeLido = $this->__simpleGetValue($this->infMDFeSupl, "qrCodMDFe");
		
	}//fim __construct

	/**
	*
	*/
	private function __buildMDFe(){
		$this->pdf = new PdfNFePHP($this->orientacao, 'mm', $this->papel);
		if( $this->orientacao == 'P' ){
			// margens do PDF
			$margSup = 7;
			$margEsq = 7;
			$margDir = 7;
			// posição inicial do relatorio
			$xInic = 7;
			$yInic = 7;
			if($this->papel =='A4'){ //A4 210x297mm
				$maxW = 210;
				$maxH = 297;
			}
		}else{
			// margens do PDF
			$margSup = 7;
			$margEsq = 7;
			$margDir = 7;
			// posição inicial do relatorio
			$xInic = 7;
			$yInic = 7;
			if($papel =='A4'){ //A4 210x297mm
				$maxH = 210;
				$maxW = 297;
			}
		}//orientação

		//largura imprimivel em mm
		$this->wPrint = $maxW-($margEsq+$xInic);
		//comprimento imprimivel em mm
		$this->hPrint = $maxH-($margSup+$yInic);
		// estabelece contagem de paginas
		$this->pdf->AliasNbPages();
		// fixa as margens
		$this->pdf->SetMargins($margEsq,$margSup,$margDir);
		$this->pdf->SetDrawColor(0,0,0);
		$this->pdf->SetFillColor(255,255,255);
		// inicia o documento
		$this->pdf->Open();
		// adiciona a primeira página
		$this->pdf->AddPage($this->orientacao, $this->papel);
		$this->pdf->SetLineWidth(0.1);
		$this->pdf->SetTextColor(0,0,0);
		//montagem da página
		$pag = 1;
		$x = $xInic;
		$y = $yInic;
		//coloca o cabeçalho
		$y = $this->__headerMDFe($x,$y,$pag);
		$y+= 12;
		//coloca os dados da MDFe
		$y = $this->__bodyMDFe($x,$y);
		$y+= 32;
		$y = $this->__obsMDFe($x,$y);
		$y+= 37;
		$y = $this->__documentosOriginariosMDFe($x,$y);
		$y+= 40;
		//coloca o rodapé
		$y = $this->__footerMDFe($x,$y);
	} //fim __buildCCe

	/**
	*
	* @param type $x
	* @param type $y
	* @param type $pag
	* @return type
	*/
	private function __headerMDFe($x,$y,$pag='1',$totPag = '1'){
		$oldX = $x;
		$oldY = $y;
		if($this->orientacao == 'P'){
			$maxW = $this->wPrint;
		}else{
			if($pag == 1){
				// primeira página
				$maxW = $this->wPrint - $this->wCanhoto;
			}else{
				// páginas seguintes
				$maxW = $this->wPrint;
			}
		}
		//##################################################################
		//coluna esquerda identificação do emitente
		$w = round($maxW*0.70);
		if($this->orientacao == 'P'){
			$aFont = array( 'font' => $this->fontePadrao,
							'size' => 6,
							'style' => '');
		}else{
			$aFont = $this->formatNegrito;
		}
		$w1 = $w;
		$h = 16;
		$oldY+= $h;
		$this->__textBox($x, $y, $w , $h + 1);
		if(is_file($this->logomarca)){
			$logoInfo = getimagesize($this->logomarca);
			//largura da imagem em mm
			$logoWmm = ($logoInfo[0] / 72) * 25.4;
			//altura da imagem em mm
			$logoHmm = ($logoInfo[1] / 72) * 25.4;
			if($this->logoAlign == 'L'){
				$nImgW = round($w / 6, 0);
				$nImgH = round($logoHmm * ($nImgW / $logoWmm), 0);
				$xImg = $x + 1;
				$yImg = round(($h - $nImgH) / 2, 0) + $y;
				//estabelecer posições do texto
				$x1 = round($xImg + $nImgW + 3, 0);
				$y1 = $y+1;
				$tw = round(2 * $w / 3, 0);
			}
			if($this->logoAlign == 'C'){
				$nImgH = round($h / 3, 0);
				$nImgW = round($logoWmm * ($nImgH / $logoHmm), 0);
				$xImg = round(($w - $nImgW) / 2 + $x, 0);
				$yImg = $y + 3;
				$x1 = $x;
				$y1 = round($yImg + $nImgH + 1, 0);
				$tw = $w;
			}
			if($this->logoAlign == 'R'){
				$nImgW = round($w / 3, 0);
				$nImgH = round($logoHmm * ($nImgW / $logoWmm), 0);
				$xImg = round($x + ($w - (1 + $nImgW)), 0);
				$yImg = round(($h - $nImgH) / 2, 0) + $y;
				$x1 = $x;
				$y1 = round($h / 3 + $y, 0);
				$tw = round(2 * $w / 3, 0);
			}
			$this->pdf->Image($this->logomarca, $xImg, $yImg, $nImgW, $nImgH, 'jpeg');
		}else{
			$x1 = $x;
			$y1 = 23;
			$tw = $w;
		}

		//Nome emitente
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 9,
						'style' => 'B');
		$texto = $this->__simpleGetValue($this->emit, "xNome");
		$this->__textBox($x1, $y1, $tw, 8, $texto, $aFont, 'T', 'L', 0, '');

		//endereço
		$y1 = $y1+3;
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 7,
						'style' => '');

		//endereço
		$cnpj = 'CNPJ:'.$this->__format($this->CNPJ,"###.###.###/####-##");
		$lgr = $this->xLgr;
		$nro = ', '.$this->nro;
		//$cpl = $this->cpl;
		$bairro = $this->xBairro;
		$CEP = $this->CEP;
		$CEP = 'CEP: '.$this->__format($CEP,"##.###-###");
		$mun = $this->xMun;
		$UF = $this->UF;
		$ie = $this->__simpleGetValue($this->emit, "IE");

		$fone = $this->formatFone($this->fone);
		//$fone=$this->__format($fone, "(##) ####-####");
		$rntrc  = $this->RNTRC;
		$texto = $lgr . "," . $nro .
				"\n" . $bairro . " - " . $mun . " - " . $UF . " - " . $CEP .
				"\n  Fone/Fax: " . $fone.
				"\n" .$cnpj . ' I.E.: ' . $ie . ' RNTRC: '.$rntrc;
		$this->__textBox($x1, $y1 + 2, $tw + 5, 8, $texto, $aFont, 'T', 'L', 0, '');

		$qr_code = 'http://dfe-portal.svrs.rs.gov.br/mdfe/QRCode?chMDFe='.$this->chMDFe.'&tpAmb='.$this->tpAmb;
		if ($this->qrCodMDFeLido!=''){
			$qr_code = $this->qrCodMDFeLido;
		}
		$qrcode = new QRcode($qr_code, 'M'); // error level : L, M, Q, H

		$xImgQR = $x1+$tw+5+30;
		$yImgQR = $y;
		$nImgWQR = 32;

		$qrcode->displayFPDF($this->pdf, $xImgQR, $yImgQR, $nImgWQR);

		//nova linha
		$y1+= 13;
		$x1 = $x;
		$w1 = $w;
		$h = 5;
		$this->__textBox($x, $y1, $w, $h + 1);
		$texto = "DAMDFE";
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => 'B');
		$this->__textBox($x+1, $y1, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => '');
		$texto = "- Documento Auxiliar de Manifesto Eletrônico de Documentos Fiscais";
		$this->__textBox($x+18, $y1, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$y1+= 6;
		$h = 9;
		$this->__textBox($x1, $y1, $w, $h);

		//modelo
		$wa = 14;
		$xa = $x1;
		$texto = 'Modelo';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($x1, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$texto = $this->mod;
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;

		//serie
		$texto = ('Série');//SÉRIE';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$texto = $this->__simpleGetValue($this->ide, "serie");
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;
		$wa = 20;

		//numero
		$texto = ('Número');
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$texto = $this->nMDF;
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;
		$wa = 13;

		//folha
		$texto = 'Folha';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		//$texto = $pag.'/'.$totPag;
		$texto = $pag.'/{nb}';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa+2, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;
		$wa = 38;

		//data emissaõ
		$texto = 'Data e Hora de Emissão';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$data = explode('T', $this->dhEmi);
		$texto = $this->__ymd2dmy($data[0]).' '.$data[1];
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);

		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;
		$wa = 18;

		//uf carrega
		$texto = 'UF Carreg.';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$texto = $this->UFIni;
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);
		$xa+= $wa;
		$wa = 19;

		//uf Descarreg
		$texto = 'UF Descarreg.';
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 8,
						'style' => '');
		$this->__textBox($xa, $y1+0.5, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		$texto = $this->UFFim;
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($xa, $y1 + 4, $wa, $h, $texto, $aFont, 'T', 'C', 0, '');
		//$this->pdf->Line($xa + $wa, $y1, $xa + $wa, $y1 + $h);

		//modelo
		$w = round($maxW*0.50);
		$y1+= 9;
		$x1 = $x;
		$w1 = $w;
		$h = 5;
		$this->__textBox($x, $y1, $w, $h + 1);
		$texto = ("Modelo Rodoviário de Carga");
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => 'B');
		$this->__textBox($x+1, $y1, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		//$this->__textBox($x+$w, $y1, $w, $h + 1);
		$texto = utf8_encode("CONTROLE DO FISCO");
		$aFont = array( 'font' => 'Courier',
						'size' => 8,
						'style' => '');
		$this->__textBox($x+1+$w, $y1+1, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$w = round($maxW*0.50);
		$y1+= 6;
		$x1 = $x;
		$w1 = $w;
		$wa = $w/3;
		$h = 10;
		$this->__textBox($x, $y1, $w, $h + 1);

		$texto = utf8_encode("Qtd. CTe");
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => 'B');
		$this->__textBox($x+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');
		$this->pdf->Line($x1 + $wa, $y1, $x1 + $wa, $y1 + $h+1);

		$x1+= $wa;
		$texto = utf8_encode("Qtd. NFe");
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => 'B');
		$this->__textBox($x1+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');
		$this->pdf->Line($x1 + $wa, $y1, $x1 + $wa, $y1 + $h+1);

		$x1+= $wa;
		$texto = utf8_encode("Peso total(Kg)");
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => 'B');
		$this->__textBox($x1+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');

		$y1+=5;
		$x1 = $x;
		$texto=$this->qCTe;
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => '');
		$this->__textBox($x+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');

		$x1+= $wa;
		$texto=$this->qNFe;
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => '');
		$this->__textBox($x1+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');

		$x1+= $wa;
		$texto=number_format($this->qCarga, 3, ',', '.');
		$aFont = array( 'font' => $this->fontePadrao,
						'size' => 10,
						'style' => '');
		$this->__textBox($x1+1, $y1, $wa, $h, $texto, $aFont, 'T', 'L', 0, '');

		//outra caixa
		$y = $y1-5;
		//$h = 23;
		//$h1 = 15;
		//$h1 = $h - 4;
		$this->__textBox($x+$w, $y, $w, $h+4);
		$bW = 85;
		$bH = 10;
		//codigo de barras
		$this->pdf->SetFillColor(0, 0, 0);
		$this->pdf->Code128($x + $w +5, $y + 2, $this->chMDFe, $bW, $bH);

		$y1+= 9;
		$y = $y1;
		$h1 = $h;
		$this->__textBox($x, $y, $w, $h1+1);
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$texto = ('Protocolo de Autorização');
		$this->__textBox($x, $y, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		if (is_object($this->mdfeProc)){
			//$tsHora = $this->__convertTime($this->dhRecbto);
			$data = explode('T', $this->dhRecbto);
			$data = $this->__ymd2dmy($data[0]).' '.$data[1];
			$texto = ($this->nProt.' às '.$data);//date('d/m/Y   H:i:s',$tsHora));
		}else {
			$data = explode('T', $this->dhEmi);
			$data = $this->__ymd2dmy($data[0]).' '.$data[1];
			$texto = ("EMISSÃO EM CONTINGÊNCIA. Obrigatóriia a autorização em ".
						"\n"."168 horas após a emissão - ".$data);
		}
		$this->__textBox($x, $y + 4, $w, $h, $texto, $aFont, 'T', 'C', 0, '');

		$y = $y1;
		$this->__textBox($x+$w, $y , $w, $h1+1);
		$texto = 'Chave de Acesso';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x+$w, $y , $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$texto = $this->__format( $this->chMDFe, $this->formatoChave );
		$this->__textBox($x+$w+1, $y + 4, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$texto = 'Consulte em ';
		$this->__textBox($x+$w+1, $y + 4+3, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$texto = 'https://dfe-portal.svrs.rs.gov.br/Mdfe/consulta';
		$this->__textBox($x+$w+16, $y + 4+3, $w, $h, $texto, $aFont, 'T', 'L', 0, '');

		//$y += 4;
		$y1 = $y;
		$x = $oldX;
		$this->pdf->SetTextColor(0,0,0);

		return $y;
	}// fim __headerMDFe

	/**
	*
	* @param type $x
	* @param int $y
	*/
	/**
	* DamdfeNFePHP::__bodyMDFe()
	*
	* @param mixed $x
	* @param mixed $y
	* @return void
	*/
	private function __bodyMDFe($x,$y){
		$maxW = $this->wPrint;

		$x1 = $x+20;

		$x1 = $x;
		$x2 = $maxW;

		$x1 = $x;
		$yold = $y;
		$x2 = round($maxW/2,0);

		$this->__textBox($x1,$y,$x2,35);

		$texto = 'Veículo';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$y+= 5;
		$x2 = round(($maxW/2)*0.35,0);

		$this->__textBox($x1,$y,$x2,15);

		$texto = 'Placa';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->__format($this->placa1, "#######");
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+3,$x2,10,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->__format($this->placa2, "#######");
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+6.5,$x2,10,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->__format($this->placa3, "#######");
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+10,$x2,10,$texto,$aFont,'T','L',0,'',false);

		$x1+= $x2;
		$x2 = round(($maxW/2)*0.65,0);

		$this->__textBox($x1,$y,$x2,15);

		$texto = 'RNTRC';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->vei_rntrc1;
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+3,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->vei_rntrc2;
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+6.5,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$texto = $this->vei_rntrc3;
		$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
		$this->__textBox($x1,$y+10,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$x1 = $x;
		$y+= 15;
		$x2 = round($maxW/2,0);

		$this->__textBox($x1,$y,$x2,15);

		$texto = 'Vale Pedágio';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$y+= 5;
		$x2 = round($x2/3,0);
		$this->__textBox($x1,$y,$x2,10);

		$texto = 'Responsável CNPJ';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$x1+= $x2;
		$this->__textBox($x1,$y,$x2,10);

		$texto = 'Fornecedora CNPJ';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$x1+= $x2;
		$this->__textBox($x1,$y,$x2 - 1,10);

		$texto = 'Nº Comprovante';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2 - 1,8,$texto,$aFont,'T','L',0,'',false);

		$x1 = round($maxW/2,0)+7;
		$y = $yold;
		$x2 = round($maxW/2,0);

		$this->__textBox($x1,$y,$x2,35);

		$texto = 'Condutor';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$y+= 5;
		$x2 = 30;

		$this->__textBox($x1,$y,$x2,30);

		$texto = 'CPF';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$this->condutor = $this->veicTracao->getElementsByTagName('condutor');
		$yold = $y;
		for($i = 0; $i < $this->condutor->length; $i++){
			if($i < 6){
				$y+= 4;
				$cpf = $this->condutor->item($i)->getElementsByTagName('CPF')->item(0)->nodeValue;
				$texto = $this->__format($cpf, "###.###.###-##");
				$aFont = array('font'=>$this->fontePadrao,'size'=>10,'style'=>'B');
				$this->__textBox($x1 + 1,$y,$x2 - 1,10,$texto,$aFont,'T','L',0,'',false);
			}
		}

		$y = $yold;
		$x1+= $x2;
		$x2+= 38;

		$this->__textBox($x1,$y,$x2,30);

		$texto = 'Nome';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x1,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		for($i = 0; $i < $this->condutor->length; $i++){
			if($i < 6){
				$y+= 4;
				$texto = $this->condutor->item($i)->getElementsByTagName('xNome')->item(0)->nodeValue;
				$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
				$this->__textBox($x1 + 1,$y,$x2 - 1,8, substr($texto,0,47),$aFont,'T','L',0,'',false);
			}
		}

		return $yold;
	}//fim __bodyMDFe

	/**
	*
	* @param type $x
	* @param type $y
	*/
	private function __obsMDFe($x,$y){
		$maxW = $this->wPrint;
		$x2 = $maxW;
		$this->__textBox($x,$y,$x2,40);

		$texto = 'Observações ';
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'');
		$this->__textBox($x,$y,$x2,8,$texto,$aFont,'T','L',0,'',false);

		$y+=5;

		$texto = $this->obs;
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x,$y,$x2,8,substr($texto,0,1780),$aFont,'T','L',0,'',false);

		return $y;
	}//fim __obsMDFe

	private function __footerMDFe($x,$y){
		$maxW = $this->wPrint;
		$x2 = $maxW;

		$y = $this->hPrint;
		if($this->orientacao == 'P') {
			$y+=8;
		}

		$texto = "Impresso em  ". date('d/m/Y')." ".date('H:i:s');
		$w = $maxW-4;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'');
		$this->__textBox($x, $y, $w, 4, $texto, $aFont, 'T', 'L', 0, '');
		$texto = "Freeline Informática Ltda (www.freeline.inf.br)";//." (NFePHP ver. " . $this->version.")";
		//Powered by NFePHP (GNU/GPLv3 GNU/LGPLv3) © www.nfephp.org";
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'');
		//$this->__textBox($x, $y, $w, $h, $text, $aFont, $vAlign, $hAlign, $border, $link, $force, $hmax, $hini)
		$this->__textBox($x, $y, $w, 4, $texto, $aFont, 'T', 'R', 0, 'http://www.nfephp.org');
		return $y;
	}//fim __footerMDFe

	private function __documentosOriginariosMDFe($x,$y){
		$oldX = $x;
		$oldY = $y;
		$maxW = $this->wPrint;
		$w = $maxW;
		$h = 135;

		$texto = ('Informações da Composição da Carga');
		$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
		$this->__textBox($x, $y, $w, $h, $texto, $aFont, 'T', 'C', 1, '');
		$descr1 = ('Informações dos documentos fiscais vinculados ao manifesto');
		$descr2 = ('Unidade de transporte');
		$descr3 = ('Unidade de carga');
		$descr4 = 'Descarga';
		$y+= 3.5;

		$this->pdf->Line($x, $y, $w + 7, $y);
		$texto = $descr1;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.45, $h, $texto, $aFont, 'T', 'L', 0, '');
		$yIniDados = $y;
		$x+= $w*0.45;

		$texto = $descr2;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.20, $h, $texto, $aFont, 'T', 'L', 0, '');
		$x+= $w*0.20;

		$texto = $descr3;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.15, $h, $texto, $aFont, 'T', 'L', 0, '');
		$x+= $w*0.15;

		$texto = $descr4;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.20, $h, $texto, $aFont, 'T', 'L', 0, '');
		$x+= $w*0.20;

		/*$this->pdf->Line($x, $y, $x, $y +($h-3.8));

		$texto = $descr1;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.42, $h, $texto, $aFont, 'T', 'L', 0, '');
		$yIniDados = $y;
		$x+= $w*0.30;

		$texto = $descr4;
		$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
		$this->__textBox($x, $y, $w * 0.08, $h, $texto, $aFont, 'T', 'L', 0, '');
		$x+= $w*0.20;
		*/

		$auxX = $oldX;
		$yIniDados+= 0;//3.5;

		$count=1;
		$pag=1;

		foreach($this->infMunDescarga as $i=>$v){
			$w_tp_doc = $w*0.04;
			$w_cnpj_cpf = $w*0.14;
			$w_nr_doc = $w*0.27;
			$w_descarga = $w*0.20;
			$w_unid_t = $w*0.20;
			$w_unid_c = $w*0.15;

			$nfe = false;
			$mdfe = false;
			$cte = false;
			$nf = false;
			$ct = false;

			//if($auxX > $w*0.90){
			//	$yIniDados = $yIniDados + 4;
			//	$auxX = $oldX;
			//}

			if(($this->infMunDescarga->item($i)->getElementsByTagName('infNFe')->length) > 0){
				$nfe = true;
				$total_inf = $this->infMunDescarga->item($i)->getElementsByTagName('infNFe')->length;
			}else if(($this->infMunDescarga->item($i)->getElementsByTagName('infCTe')->length) > 0){
				$cte = true;
				$total_inf = $this->infMunDescarga->item($i)->getElementsByTagName('infCTe')->length;
			}else if(($this->infMunDescarga->item($i)->getElementsByTagName('infMDFe')->length) > 0){
				$mdfe = true;
				$total_inf = $this->infMunDescarga->item($i)->getElementsByTagName('infMDFe')->length;
			}else if(($this->infMunDescarga->item($i)->getElementsByTagName('infNF')->length) > 0){
				$nf = true;
				$total_inf = $this->infMunDescarga->item($i)->getElementsByTagName('infNF')->length;
			}else if(($this->infMunDescarga->item($i)->getElementsByTagName('infCT')->length) > 0){
				$ct = true;
				$total_inf = $this->infMunDescarga->item($i)->getElementsByTagName('infCT')->length;
			}else{
				$total_inf = 0;
			}

			for($j=0; $j<$total_inf; $j++){
				//if($auxX > $w*0.90){
					$yIniDados = $yIniDados + 4;
					$auxX = $oldX;
				//}

				if($nfe){
					$texto = 'NFe';
					$w_nr_doc = 0;
					$w_cnpj_cpf = $w*0.41;
				}else if($cte){
					$texto = 'CTe';
					$w_nr_doc = 0;
					$w_cnpj_cpf = $w*0.41;
				}else if($mdfe){
					$texto = 'MDFe';
					$w_nr_doc = 0;
					$w_cnpj_cpf = $w*0.41;
				}else if($nf){
					$texto = 'NF';
				}else if($ct){
					$texto = 'CT';
				}else{
					$texto = 'S/N';
				}

				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_tp_doc, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_tp_doc;
				$idUnidTransp = '';
				if($nfe){
					$texto = $this->__format( $this->infMunDescarga->item($i)->getElementsByTagName('infNFe')->item($j)->nodeValue, $this->formatoChave );
					//$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "chNFe");
					$idUnidTransp = ' '.$this->__simpleGetValue($this->infMunDescarga->item($i)->getElementsByTagName('infNFe')->item($j), "idUnidTransp");
				}else if($cte){
					$texto = $this->__format( $this->infMunDescarga->item($i)->getElementsByTagName('infCTe')->item($j)->nodeValue, $this->formatoChave );
					$idUnidTransp = ' '.$this->__simpleGetValue($this->infMunDescarga->item($i)->getElementsByTagName('infCTe')->item($j), "idUnidTransp");
					//$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "chCTe");
				}else if($mdfe){
					$texto = $this->__format( $this->infMunDescarga->item($i)->getElementsByTagName('infMDFe')->item($j)->nodeValue, $this->formatoChave );
					$idUnidTransp = ' '.$this->__simpleGetValue($this->infMunDescarga->item($i)->getElementsByTagName('infMDFe')->item($j), "idUnidTransp");
					//$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "chMDFe");
				}else if($nf){
					$texto = $this->__format($this->__simpleGetValue($this->infMunDescarga->item($i), "CNPJ"),"###.###.###/####-##");
					$idUnidTransp = ' '.$this->__simpleGetValue($this->infMunDescarga->item($i)->getElementsByTagName('infNF')->item($j), "idUnidTransp");
				}else if($ct){
					$texto = $this->__format($this->__simpleGetValue($this->infMunDescarga->item($i), "CNPJ"),"###.###.###/####-##");
					$idUnidTransp = ' '.$this->__simpleGetValue($this->infMunDescarga->item($i)->getElementsByTagName('infCT')->item($j), "idUnidTransp");
				}else{
					$texto = $this->__format($this->CNPJ,"###.###.###/####-##");
					//$texto=$this->__format($this->__simpleGetValue($this->infMunDescarga->item($i), "CNPJ"),"###.###.###/####-##");
				}

				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_cnpj_cpf, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_cnpj_cpf;

				//$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "cMunDescarga");
				if($nfe){
					$texto = '';
				}else if($cte){
					$texto = '';
				}else if($mdfe){
					$texto = '';
				}else if($nf){
					$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "nNF");
					$texto.='/'.$this->__simpleGetValue($this->infMunDescarga->item($i), "serie");
				}else if($ct){
					$texto = $this->__simpleGetValue($this->infMunDescarga->item($i), "nCT");
					$texto.='/'.$this->__simpleGetValue($this->infMunDescarga->item($i), "serie");
				}else{
					$texto = 'S/N';
				}
				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_nr_doc, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_nr_doc;

				$texto = 'Rodoviário Tração';
				if ($this->placa2!=''){
					$texto = 'Rodoviário Reboque ';
				}
				$texto.=$idUnidTransp;

				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_unid_t, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_unid_t;

				$texto = $this->tp_carroceria;
				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_unid_c, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_unid_c;

				$cuf = (substr($this->__simpleGetValue($this->infMunDescarga->item($i), "cMunDescarga"),0,2));
				$uf = busca_dados_combo('cod_uf',$cuf);
				$texto = trim(substr($this->__simpleGetValue($this->infMunDescarga->item($i), "xMunDescarga"),0,24)).'/'.$uf;

				$aFont = array( 'font' => $this->fontePadrao,
								'size' => 8,
								'style' => '');
				$this->__textBox($auxX, $yIniDados, $w_descarga, $h, $texto, $aFont, 'T', 'L', 0, '');
				$auxX+= $w_descarga;
				$count++;

				if($count == 33){
					$x = 7;
					$y = 7;
					$this->__footerMDFe($x,$y);
					$this->pdf->AddPage($this->orientacao, $this->papel);
					$this->pdf->SetLineWidth(0.1);
					$this->pdf->SetTextColor(0,0,0);
					$pag+= 1;

					//coloca o cabeçalho
					$this->__headerMDFe($x,$y,$pag);

					$h = 217;
					$y = 71;

					$texto = ('Informações da Composição da Carga');
					$aFont = array('font'=>$this->fontePadrao,'size'=>8,'style'=>'B');
					$this->__textBox($x, $y, $w, $h, $texto, $aFont, 'T', 'C', 1, '');
					$descr1 = ('Informações dos documentos fiscais vinculados ao manifesto');
					$descr2 = ('Unidade de transporte');
					$descr3 = ('Unidade de carga');
					$descr4 = 'Descarga';
					$y+= 3.5;
					$this->pdf->Line($x, $y, $w + 7, $y);
					$texto = $descr1;
					$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
					$this->__textBox($x, $y, $w * 0.45, $h, $texto, $aFont, 'T', 'L', 0, '');
					$yIniDados = $y;
					$x+= $w * 0.45;

					$texto = $descr2;
					$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
					$this->__textBox($x, $y, $w * 0.20, $h, $texto, $aFont, 'T', 'L', 0, '');
					$x+= $w * 0.20;

					$texto = $descr3;
					$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
					$this->__textBox($x, $y, $w * 0.15, $h, $texto, $aFont, 'T', 'L', 0, '');
					$x+= $w * 0.15;

					$texto = $descr4;
					$aFont = array('font'=>$this->fontePadrao, 'size'=>6, 'style'=>'B');
					$this->__textBox($x, $y, $w * 0.20, $h, $texto, $aFont, 'T', 'L', 0, '');
					$x+= $w * 0.20;

					$auxX = $oldX;
					$yIniDados+= 0;

					//$y=60;
					//$yIniDados=$y;
					$count=-19;
				}
			}
		}
		return $y;
	}//fim __documentosOriginariosMDFe

	protected function formatFone($fone){
		$foneLen = strlen($fone);
		if($foneLen > 0){
			if((strlen($fone) > 11) || (substr($fone,0,1) == '0') ){
				$fone=$fone;
			}else if(strlen($fone) == 10){
				$fone=$this->__format($fone, '(##) ####-####');
			}else if(strlen($fone) == 11){
				$fone=$this->__format($fone, '(##) #####-####');
			}else{
				$fone='';
			}
		}else{
			$fone = '';
		}
		return $fone;
	}//fim formatFone

	/**
	*
	* @param type $nome
	* @param string $destino
	* @param type $printer
	* @return type
	*/
	public function printMDFe($nome='',$destino='I',$printer=''){
		//monta
		$command = '';
		if ($nome == ''){
			$file = $this->pdfDir.'mdfe.pdf';
		}else{
			$file = $this->pdfDir.$nome;
		}
		if (($destino != 'I' || $destino != 'S') && $destino != 'F'){
			$destino = 'I';
		}
		if ($printer != ''){
			$command = "-P $printer";
		}
		$this->__buildMDFe();
		$arq = $this->pdf->Output($file,$destino);
		if ( $destino == 'S' ){
			//aqui pode entrar a rotina de impressão direta
			$command = "lpr $command $file";
			system($comando,$retorno);
		}
		return $arq;
	}//fim printMDFe

} //fim MDFeNFePHP

?>