<?php
	require_once('header.inc');
	require_once('base_class.inc');

	function atualizarDadosCnpjReceita($cnpj){
		//$cnpj = limpa_numero($_REQUEST['CNPJ']);
		$cnpj = limpa_numero($cnpj);

		//$cnpj = '28633024000105';
		//$cnpj = '83188342000104';

		$retorno = array();

		$curl = extension_loaded('curl');
		if($curl){
			$options = array(
				CURLOPT_RETURNTRANSFER => true,     // return web page
				CURLOPT_HEADER         => false,    // don't return headers
				CURLOPT_FOLLOWLOCATION => true,     // follow redirects
				CURLOPT_ENCODING       => "",       // handle all encodings
				CURLOPT_USERAGENT      => $_SERVER['HTTP_USER_AGENT'], // who am i
				CURLOPT_AUTOREFERER    => true,     // set referer on redirect
				CURLOPT_CONNECTTIMEOUT => 5,      // timeout on connect
				CURLOPT_TIMEOUT        => 5,      // timeout on response
				CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
				CURLOPT_SSL_VERIFYPEER => false     // Disabled SSL Cert checks
			);

			$ch = curl_init("https://www.receitaws.com.br/v1/cnpj/".$cnpj);
			curl_setopt_array($ch, $options);
			$response = curl_exec($ch);
			$err = curl_errno($ch);
			$errmsg = curl_error($ch);
			//$header = curl_getinfo($ch);
			curl_close($ch);

			$receita = json_decode($response, true);

			if(($response != false) && ($err == 0)){
				if($receita['status'] == 'OK'){
					$res_pessoa = 0;
					$res_end = 0;
					$res_tel = 0;

					$campos = '';
					$campos_end = '';
					$campos_end_1 = '';
					$campos_tel = '';

					$pessoa = base64_decode_si($_REQUEST['Pessoa']);

					$nome_razao = UpperDados($receita['nome']);
					if (($nome_razao != '') && ($nome_razao != '********')){
						$campos.= ' Nome_Razao="'.$nome_razao.'", Nome_Listas="'.$nome_razao.'", Nome_Fantasia="'.$nome_razao.'",';
					}

					$nome_fantasia = UpperDados($receita['fantasia']);
					if (($nome_fantasia != '') && ($nome_fantasia != '********')){
					    $campos.=' Nome_Fantasia="'.$nome_fantasia.'",';
					}

					$email = $receita['email'];
					if (($email != '') && ($email != '********')){
						$campos.= ' EMail="'.$email.'",';
					}

				    $campos_end_1.= ' Codigo_Pais="1058", Nome_Pais="BRASIL",';
				    $end_logradouro = UpperDados($receita['logradouro']);
				    if (($end_logradouro != '') && ($end_logradouro != '********')){
						$campos_end.= ' Logradouro="'.$end_logradouro.'",';
					}else{
						$campos_end_1.= ' Logradouro="ND",';
					}
					$end_numero = $receita['numero'];
					if (($end_numero != '') && ($end_numero != '********')){
					    $campos_end.= ' Numero="'.$end_numero.'",';
					}
					$end_complemento = $receita['complemento'];
					if (($end_complemento != '') && ($end_complemento != '********')){
						$campos_end.= ' Complemento="'.$end_complemento.'",';
					}
					$end_cep = mcep($receita['cep']);
					if (($end_cep != '') && ($end_cep != '********')){
					    $campos_end.= ' CEP="'.$end_cep.'",';
				    }

				    $end_bairro = $receita['bairro'];
				    if (($end_bairro!='')&&($end_bairro!='********')){
					    $campos_end.= ' Bairro="'.$end_bairro.'",';
				    }else{
						$campos_end_1.= ' Bairro="CENTRO",';
				    }

				    $end_uf = $receita['uf'];
				    if (($end_uf != '') && ($end_uf != '********')){
					    $campos_end.= ' UF="'.$end_uf.'",';
				    }

					$end_municipio = $receita['municipio'];
					if (($end_municipio != '') && ($end_municipio != '********')){
						$con_cidade = 'SELECT Codigo_Cidade FROM cidade '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Nome="'.$end_municipio.'"'.
										' AND UF="'.$end_uf.'"';
						$res_cidade = consulta_sql($con_cidade);
						$reg_cidade = consulta_ler_linha($res_cidade);
						consulta_limpa($res_cidade);
						$cod_cidade = $reg_cidade[0];

						$campos_end.=' Codigo_Cidade="'.$cod_cidade.'", Nome_Cidade="'.$end_municipio.'",';
					}
					if (($end_uf == '') || ($end_uf == '********') || ($end_municipio == '') || ($end_municipio == '********')){
						$campos_end = '';
					}
					$telefone = mtelefone($receita['telefone']);
					if (($telefone != '') && ($telefone != '********')){
						$campos_tel.= ' Numero_Telefone="'.$telefone.'" ';
					}

					if ((substr($campos, -1)) == ','){
						$campos = substr($campos, 0, -1);
					}

					if ($campos != ''){
						$upt_pessoa = 'UPDATE t_pessoa SET '.
										$campos.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$pessoa.'"';
						$res_pessoa = consulta_sql($upt_pessoa,true,1);
					}

					if ($campos_end != ''){
						$con_seq = 'SELECT Seq_Endereco FROM t_pessoa_endereco '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Pessoa="'.$pessoa.'"'.
									' AND Situacao="A" order by Seq_Endereco LIMIT 1';
						$res_seq = consulta_sql($con_seq);
						$reg_seq = consulta_ler_linha($res_seq);
						consulta_limpa($res_seq);
						$seq = $reg_seq[0];

						if (($seq == 0) || ($seq == '')){
							$con_seq = 'SELECT MAX(Seq_Endereco) FROM t_pessoa_endereco '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$pessoa.'"';
							$res_seq = consulta_sql($con_seq);
							$reg_seq = consulta_ler_linha($res_seq);
							consulta_limpa($res_seq);
							$seq = ($reg_seq[0] + 1);

							$con_ins = 'INSERT INTO t_pessoa_endereco '.
										'(Dominio, Pessoa, Seq_Endereco, Tipo_Endereco, Situacao) '.
										' VALUES ("'.$_SESSION["Dominio"].'","'.$pessoa.'","'.$seq.'","1", "A")';
							consulta_sql($con_ins);
						}

						$campos_end = $campos_end_1.$campos_end;
						if ((substr($campos_end, -1)) == ','){
							$campos_end = substr($campos_end, 0, -1);
						}

						$upt_end = 'UPDATE t_pessoa_endereco SET '.$campos_end.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Pessoa="'.$pessoa.'"'.
									' AND Seq_Endereco="'.$seq.'"';
						$res_end = consulta_sql($upt_end,true,1);
					}

					if ($campos_tel != ''){
						$con_seq = 'SELECT Seq_Telefone FROM t_pessoa_telefone '.
								 ' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								 ' AND Pessoa="'.$pessoa.'"'.
								 ' AND Numero_Telefone="'.$telefone.'"'.
								 ' AND Situacao = "A"';
						$res_seq = consulta_sql($con_seq);
						$reg_seq = consulta_ler_linha($res_seq);
						consulta_limpa($res_seq);
						$seq = $reg_seq[0];

						if (($seq == 0) || ($seq == '')){
							$con_seq = 'SELECT MAX(Seq_Telefone) FROM t_pessoa_telefone '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$pessoa.'"';
							$res_seq = consulta_sql($con_seq);
							$reg_seq = consulta_ler_linha($res_seq);
							consulta_limpa($res_seq);
							$seq = $reg_seq[0] + 1;

							$con_ins = 'INSERT INTO t_pessoa_telefone '.
										'(Dominio, Pessoa, Seq_Telefone, Situacao) '.
										' VALUES ("'.$_SESSION["Dominio"].'","'.$pessoa.'",'.
										'"'.$seq.'","A")';
							consulta_sql($con_ins);

							$campos_tel = 'Tipo_Telefone="1",'.$campos_tel;
							if ((substr($campos_tel, -1))==','){
								$campos_tel = substr($campos_tel, 0, -1);
							}
							$upt_tel = 'UPDATE t_pessoa_telefone SET '.$campos_tel.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$pessoa.'"'.
										' AND Seq_Telefone="'.$seq.'"';
							$res_tel = consulta_sql($upt_tel,true,1);
						}
					}

					$mensagem = '';
					if (($res_pessoa > 0) || ($res_end > 0) || ($res_tel > 0)){
						$mensagem = 'Cadastro importado com sucesso! ';
					}else{
						$mensagem = 'Registros já atualizados!';
					}

					$retorno['status'] = true;
					$retorno['mensagem'] = $mensagem;
				}else if($receita['status'] == 'ERROR'){
					$retorno['status'] = false;
					$retorno['mensagem'] = $receita['message'];
				}else{
					$retorno['status'] = false;
					$retorno['mensagem'] = 'Erro desconhecido!';
				}
			}else{
				$retorno['status'] = false;
				//$retorno['mensagem'] = $err.' - '.$errmsg;
				$retorno['mensagem'] = 'Informações não encontradas!';
			}
		}else{
			$retorno['status'] = false;
			$retorno['mensagem'] = 'Extensão CURL não carregada!';
		}
		return $retorno;
	}

	if (session::usr_conectado($_REQUEST['USER_ID'])){
		$cnpj = limpa_numero($_REQUEST['CNPJ']);
		$retorno = atualizarDadosCnpjReceita($cnpj);
		echo json_encode($retorno);
	}
?>