<?php
	require_once(dirname(__FILE__).'/cfe_funcoes.php');

	/////////////////////////////////////////////
	////////////////CFe//////////////////
	/////////////////////////////////////////////

	function cfe_gera_arquivo_cfe($nr_nota){
		$param_unid_fisco = BuscaParam('NFE_UNIDADE_FISCO');
		$param_unid_kg = BuscaParam('NFE_EXT_UNIDADE_KG');

		//reavalia persistncias da nota e dos itens
		nota_fiscal_valida_persistencia($nr_nota);
		nota_fiscal_item_valida_persistencia($nr_nota);

		//consulta corpo da nota
		$con_nota = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);

		$cfe_pasta_raiz = cfe_pasta_raiz();
		$arquivo_err = $cfe_pasta_raiz.'retorno/'.$reg_nota->Nr_Nota.'-sat-ret.err ';
		if(file_exists($arquivo_err)){
			unlink($arquivo_err);
		}

		$versao_cfe = config_pad('cfe_versao');

		//cria objeto xml
		$xml = new XML();

		//adiciona dados da nota
		$r = &$xml->createRoot("CFe");

		$cf_inf = &$r->addChild("infCFe");
		$cf_inf->addAttribute('versaoDadosEnt', $versao_cfe, true);

		//chave da NFe

		$ide = &$cf_inf->addChild("ide");

		/* $con_empresa = 'SELECT CPF_CNPJ FROM pessoa '.
		' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
		' AND Pessoa = "'.$_SESSION["Empresa_Codigo"].'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa); */

		//$chave = $reg_nota->NFe_Chave;
		//CNPJ software house
		$cnpj_ide = '83.188.342/0001-04';
		$ide->addAttribute('CNPJ', limpa_numero($cnpj_ide), false);

		//Assinatura do Aplicativo Comercial
		$ide->addAttribute('signAC', BuscaParamEmpresa('SAT_ASSINATURA'), false);

		//Nmero do Caixa ao qual o SAT est conectado
		$ide->addAttribute('numeroCaixa', fill_full($reg_nota->Serie, 3), false);

		//adiciona dados do emitente
		$emit = &$cf_inf->addChild("emit");

		//cnpj do emitente

		//pega da srie
		$con_serie = 'SELECT NFe_Ambiente FROM nota_fiscal_serie '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Modelo="'.$reg_nota->Modelo.'"'.
					' AND Serie="'.$reg_nota->Serie.'"'.
					' AND SubSerie="'.$reg_nota->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);

		$ambiente = $reg_serie[0];
		if($ambiente == '1'){
			$empresa_cnpj = $reg_nota->Empresa_CNPJ;
			$inscricao_estadual = $reg_nota->Empresa_Insc_Estadual;
			$im = $reg_nota->Empresa_IM;
		}else{
			$empresa_cnpj = '11.111.111/1111-11';
			$inscricao_estadual = '111.111.111.111';
			$im = '123123';
		}
		$emit->addAttribute('CNPJ', limpa_numero($empresa_cnpj), false);

		//IE
		$emit->addAttribute('IE', preenche_texto(substr(limpa_numero2($inscricao_estadual), 0, 14), 14), false);

		//IM
		if((limpa_numero($reg_nota->Empresa_IM) != '')){
			$emit->addAttribute('IM', substr(limpa_numero($im),0,15), false);
		}

		//regime Simples Nacional
		if($reg_nota->Empresa_CRT == 'S'){
			$regime = '1'; //simples nacional
		}else{
			$regime = '3'; //normal
		}

		//Cdigo de Regime Tributrio
		//$emit->addAttribute('cRegTrib', $regime, false);

		//Indicador de rateio do Desconto sobre subtotal entre itens sujeitos  tributao pelo ISSQN.
		$emit->addAttribute('indRatISSQN', 'N', false);


		$dest = &$cf_inf->addChild("dest");
		//adiciona dados do destinatrio
		if (($reg_nota->Dest_CPF_CNPJ!='')&&
			($reg_nota->Dest_CPF_CNPJ!='000.000.000-00')&&
			($reg_nota->Dest_CPF_CNPJ!='00.000.000/0000-00')){

			if(strlen(limpa_numero($reg_nota->Dest_CPF_CNPJ)) == 14){
				//cnpj do emitente
				$dest->addAttribute('CNPJ', limpa_numero($reg_nota->Dest_CPF_CNPJ), false);
			}else{
				//cpf emitente
				$dest->addAttribute('CPF', limpa_numero($reg_nota->Dest_CPF_CNPJ), false);
			}
			//nome/razao
			if($ambiente == '2'){
				$dest->addAttribute('xNome', 'CF-E EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL', false);
			}else if ($reg_nota->Dest_Razao!=''){
				$dest->addAttribute('xNome', cfe_retira_texto_excesso($reg_nota->Dest_Razao,0,60), false);
			}
		}else if($ambiente == '2'){
			$dest->addAttribute('xNome', 'CF-E EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL', false);
		}

		//Tipo operao Interna/interestdual/com o exterior
		$idDest = '1';
		if ((substr($reg_nota->Nat_Op_CFOP,0,1) == '2')||
			(substr($reg_nota->Nat_Op_CFOP,0,1) == '6')){
			$idDest = '2';
		}else if((substr($reg_nota->Nat_Op_CFOP,0,1) == '3') ||
				 (substr($reg_nota->Nat_Op_CFOP,0,1) == '4') ||
				 (substr($reg_nota->Nat_Op_CFOP,0,1) == '7') ||
				 (substr($reg_nota->Nat_Op_CFOP,0,1) == '8')){
			$idDest = '3';
		}

		$finalidade = $reg_nota->Finalidade;

		$total_produtos = 0;
		$val_impo_total = 0;
		$valor_total_item = 0;
		$total_diferido = 0;
		//consulta itens da NF
		$con_itens = 'SELECT * FROM nota_fiscal_item'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"'.
					' ORDER BY Seq_Item '.
					' LIMIT 500';
		$res_itens = consulta_sql($con_itens);
		$nrw_itens = consulta_num_registros($res_itens);
		//para cada item da nota
		for($itens=0;$itens<$nrw_itens;$itens++){
			$reg_itens = consulta_ler_objeto($res_itens);

			//adiciona dados dos itens ao arquivo
			$det = &$cf_inf->addChild("det");
			//seq do item na NF
			$det->addAttribute('nItem', ($itens+1), true);
			//dados do produto
			$prod = &$det->addChild("prod");
			//cdigo do produto/servio
			if($reg_itens->Codigo_Produto == ''){ //no  um produto (caso de complementao)
				$prod->addAttribute('cProd', 'CFOP'.limpa_numero($reg_itens->CFOP), false);
			}else{
				$prod->addAttribute('cProd', $reg_itens->Codigo_Produto, false);
			}

			if(valida_ean($reg_itens->Barra_Produto)){
				$prod->addAttribute('cEAN', $reg_itens->Barra_Produto, false);
			}else{
				//$prod->addAttribute('cEAN', '', false);
			}

			$descricao = trim(cfe_retira_texto_excesso($reg_itens->Prod_Descricao,0,120));
			if($ambiente == '2'){
				$descricao = 'CF-E EMITIDO EM AMBIENTE DE HOMOLOGACAO - SEM VALOR FISCAL';
			}
			$prod->addAttribute('xProd', $descricao, false);

			//ncm
			if($reg_itens->Prod_Depart == 0){ //servio
				$prod->addAttribute('NCM', '99', false);
			}else{ //produto
				$prod->addAttribute('NCM', substr(limpa_numero($reg_itens->Prod_NCM), 0, 8), false);

				//cest
				if(($reg_itens->ICMS_CST=='10')||
					($reg_itens->ICMS_CST=='30')||
					($reg_itens->ICMS_CST=='60')||
					($reg_itens->ICMS_CST=='70')||
					($reg_itens->ICMS_CST=='90')||
					($reg_itens->ICMS_CST=='201')||
					($reg_itens->ICMS_CST=='202')||
					($reg_itens->ICMS_CST=='203')||
					($reg_itens->ICMS_CST=='500')||
					($reg_itens->ICMS_CST=='900')){
					$cod_cest = limpa_numero($reg_itens->Prod_CEST);
					if ($cod_cest!=''){
						if (($ambiente == '2') || ($versao_cfe!='0.07')){ //0.08 em diante 01/01/2019
							$prod->addAttribute('CEST', substr($cod_cest, 0, 7), false);
						}
					}
				}
			}

			//cfop
			$prod->addAttribute('CFOP', limpa_numero($reg_itens->CFOP), false);

			//unidade de medida
			$valor_unitario = $reg_itens->Valor_Unitario;
			$Qtd = $reg_itens->Quantidade_Estoque;
			$unid_medida = trim($reg_itens->Unidade_Estoque);

			if($param_unid_fisco == 'S'){
				$con_uni = 'SELECT Unidade_Fisco FROM unidade_medida '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Unidade="'.trim($reg_itens->Unidade_Estoque).'"';
				$res_uni = consulta_sql($con_uni);
				$reg_uni = consulta_ler_linha($res_uni);
				consulta_limpa($res_uni);
				if($reg_uni[0]!=''){
					$unid_medida = $reg_uni[0];
				}
			}

			if ($param_unid_kg == 'S'){
				if (($idDest == 3)||
					(limpa_numero($reg_itens->CFOP)=='1501')||
					(limpa_numero($reg_itens->CFOP)=='2501')||
					(limpa_numero($reg_itens->CFOP)=='5501')||
					(limpa_numero($reg_itens->CFOP)=='5502')||
					(limpa_numero($reg_itens->CFOP)=='5504')||
					(limpa_numero($reg_itens->CFOP)=='5505')||
					(limpa_numero($reg_itens->CFOP)=='6501')||
					(limpa_numero($reg_itens->CFOP)=='6502')||
					(limpa_numero($reg_itens->CFOP)=='6504')||
					(limpa_numero($reg_itens->CFOP)=='6505')){
					if ((limpa_numero($reg_itens->Prod_NCM)=='12019000')||
						(limpa_numero($reg_itens->Prod_NCM)=='15071000')||
						(limpa_numero($reg_itens->Prod_NCM)=='15079011')||
						(limpa_numero($reg_itens->Prod_NCM)=='15079019')||
						(limpa_numero($reg_itens->Prod_NCM)=='15079090')||
						(limpa_numero($reg_itens->Prod_NCM)=='17011300')||
						(limpa_numero($reg_itens->Prod_NCM)=='17011400')||
						(limpa_numero($reg_itens->Prod_NCM)=='17019900')||
						(limpa_numero($reg_itens->Prod_NCM)=='18010000')||
						(limpa_numero($reg_itens->Prod_NCM)=='18031000')||
						(limpa_numero($reg_itens->Prod_NCM)=='18032000')||
						(limpa_numero($reg_itens->Prod_NCM)=='18040000')||
						(limpa_numero($reg_itens->Prod_NCM)=='18050000')||
						(limpa_numero($reg_itens->Prod_NCM)=='21011110')||
						(limpa_numero($reg_itens->Prod_NCM)=='21011190')||
						(limpa_numero($reg_itens->Prod_NCM)=='21011200')||
						(limpa_numero($reg_itens->Prod_NCM)=='23040010')||
						(limpa_numero($reg_itens->Prod_NCM)=='23040090')||
						(limpa_numero($reg_itens->Prod_NCM)=='52010010')||
						(limpa_numero($reg_itens->Prod_NCM)=='52010020')||
						(limpa_numero($reg_itens->Prod_NCM)=='52010090')||
						(limpa_numero($reg_itens->Prod_NCM)=='74031100')||
						(limpa_numero($reg_itens->Prod_NCM)=='74031200')||
						(limpa_numero($reg_itens->Prod_NCM)=='74031300')||
						(limpa_numero($reg_itens->Prod_NCM)=='74031900')||
						(limpa_numero($reg_itens->Prod_NCM)=='75021010')||
						(limpa_numero($reg_itens->Prod_NCM)=='75021090')||
						(limpa_numero($reg_itens->Prod_NCM)=='76011000')||
						(limpa_numero($reg_itens->Prod_NCM)=='78011011')||
						(limpa_numero($reg_itens->Prod_NCM)=='78011019')||
						(limpa_numero($reg_itens->Prod_NCM)=='78011090')||
						(limpa_numero($reg_itens->Prod_NCM)=='78019100')||
						(limpa_numero($reg_itens->Prod_NCM)=='78019900')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011111')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011119')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011191')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011199')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011210')||
						(limpa_numero($reg_itens->Prod_NCM)=='79011290')||
						(limpa_numero($reg_itens->Prod_NCM)=='79012010')||
						(limpa_numero($reg_itens->Prod_NCM)=='79012090')||
						(limpa_numero($reg_itens->Prod_NCM)=='80011000')){
						$unid_medida = 'TON';
					}else if(trim($reg_itens->Unidade_Estoque)=='TO'){
						//passar para KG
						$unid_medida = 'KG';
						$Qtd = ($reg_itens->Quantidade_Estoque * 1000);
						$valor_unitario = ($reg_itens->Valor_Unitario / 1000);
					}
					if(trim($reg_itens->Unidade_Estoque) == 'UN'){
						$unid_medida = 'UN';
					}
				}
			}

			$prod->addAttribute('uCom', trim($unid_medida), false);

			if($Qtd <= 0){
				$valor_unitario = 0;
			}

			if(($Qtd == 0) && ($finalidade == 1)){
				$Qtd = 1;
				$valor_unitario = $reg_itens->Valor_Unitario;
			}
			//quantidade
			$prod->addAttribute('qCom', cfe_numero($Qtd, 4), false); //4 digitos

			$combustivel = false;
			if(trim($reg_itens->Comb_ANP) != ''){//tem ANP
				$combustivel = true;
			}

			//valor unitrio
			if($combustivel){
				$prod->addAttribute('vUnCom', cfe_numero($valor_unitario, 3), false); //3 digitos
			}else{
				$prod->addAttribute('vUnCom', cfe_numero($valor_unitario, 2), false); //2 digitos
			}

			$prod->addAttribute('indRegra', 'T', false);

			//desconto
			if($reg_itens->Valor_Desconto > 0){
				$prod->addAttribute('vDesc', cfe_numero($reg_itens->Valor_Desconto, 2), false);
			}

			//outros
			if($reg_itens->Valor_Outros > 0){
				$prod->addAttribute('vOutro', cfe_numero($reg_itens->Valor_Outros, 2), false);
			}
			if ($versao_cfe=='0.07'){
				if (($reg_itens->Prod_CEST!='')&&(($reg_itens->ICMS_CST=='60')||($reg_itens->ICMS_CST=='500'))){
					$obsFiscoDet = &$prod->addChild("obsFiscoDet");
					$obsFiscoDet->addAttribute('xCampoDet', 'Cod. CEST', true);
					$obsFiscoDet->addAttribute('xTextoDet', limpa_numero($reg_itens->Prod_CEST), false);
				}
			}
			/* $obs_fisco = &$det->addChild("obsFiscoDet");
			$obs_fisco->addAttribute('vTotTrib', cfe_numero($val_impo,2), false); */


			//adiciona dados dos impostos (ICMS,IPI,PIS,COFINS,ISS)

			$imposto = &$det->addChild("imposto");

			if($reg_itens->Perc_Tributos > 0){
				$total_item = $reg_itens->Valor_Total - $reg_itens->ICMS_Desonerado_Valor;
				if((substr($reg_itens->CFOP,0,1) == '3') && ($reg_itens->Valor_Agregado > 0)){
					$total_item = $reg_itens->Valor_Agregado;
				}else{
					$total_item+= $reg_itens->ICMSST_Valor;
					$total_item+= $reg_itens->Valor_Frete;
					$total_item+= $reg_itens->Valor_Outros;
					$total_item+= $reg_itens->IPI_Valor;
				}

				$val_impoF = ($total_item) * ($reg_itens->Perc_TributosF / 100);
				$val_impoE = ($total_item) * ($reg_itens->Perc_TributosE / 100);
				$val_impoM = ($total_item) * ($reg_itens->Perc_TributosM / 100);

				$val_impoF = arredonda_numero_menos($val_impoF * 100) / 100;
				$val_impoE = arredonda_numero_menos($val_impoE * 100) / 100;
				$val_impoM = arredonda_numero_menos($val_impoM * 100) / 100;
				$val_impo = $val_impoF + $val_impoE + $val_impoM;

				if($val_impo > 0){
					if($reg_nota->TipoES == '1'){
						$imposto->addAttribute('vItem12741', cfe_numero($val_impo, 2), false);
						$val_impo_total+= $val_impo;
					}
				}
			}

			if($reg_itens->Prod_Depart == 0){ // servio
				//if($reg_nota->NFe_Versao != '2.00'){
				$icms = &$imposto->addChild("ICMS");

				$icms_cst = &$icms->addChild("ICMS40");//servico no tem icms (isento)
				$icms_cst->addAttribute('Orig', '0', false);
				$icms_cst->addAttribute('CST', '40', false);
			}else if($reg_itens->Prod_Depart != 0){ // produto
				$icms = &$imposto->addChild("ICMS");
				$cst = $reg_itens->ICMS_CST;
				if(($regime == '3') && (($cst == '00') || ($cst == '20') || ($cst == '90'))){
					$icms_cst = &$icms->addChild("ICMS00");
					$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
					$icms_cst->addAttribute('CST', $cst, false);
					$icms_cst->addAttribute('pICMS', $reg_itens->ICMS_Percentual, false);
				}else if(($regime == '3') && (($cst == '40') || ($cst == '41') || ($cst == '60'))){
					$icms_cst = &$icms->addChild("ICMS40");
					$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
					$icms_cst->addAttribute('CST', $cst, false);
				}
				/*else if(($regime == '1') && (($cst == '102') ||($cst == '300') || ($cst == '400') || ($cst == '500'))){
				$cst2= '40';
				if ($cst=='400'){ $cst2= '41'; }
				if ($cst=='500'){ $cst2= '60'; }
				$icms_cst = &$icms->addChild("ICMS40");
				$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
				$icms_cst->addAttribute('CST', $cst2, false);
				}else if(($regime == '1') && ($cst == '900')){
				$icms_cst = &$icms->addChild("ICMS00");
				$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
				$icms_cst->addAttribute('CST', '90', false);
				$icms_cst->addAttribute('pICMS', $reg_itens->ICMS_Percentual, false);
				}
				*/

				else if(($regime == '1') && (($cst == '102') || ($cst == '300') || ($cst == '400') || ($cst == '500'))){
					$icms_cst = &$icms->addChild("ICMSSN102");
					$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
					$icms_cst->addAttribute('CSOSN', $cst, false);
				}else if(($regime == '1') && ($cst == '900')){
					$icms_cst = &$icms->addChild("ICMSSN900");
					$icms_cst->addAttribute('Orig', $reg_itens->Origem, false);
					$icms_cst->addAttribute('CSOSN', $cst, false);
					$icms_cst->addAttribute('pICMS', $reg_itens->ICMS_Percentual, false);
				}
			}
			//pis
			$pis = &$imposto->addChild("PIS");
			if(($reg_itens->PIS_CST == '01') || ($reg_itens->PIS_CST == '02') || ($reg_itens->PIS_CST == '05')){
				$pis_cst = &$pis->addChild("PISAliq");
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				//base
				$pis_cst->addAttribute('vBC', cfe_numero($reg_itens->PIS_BC, 2), false);
				//aliq
				$pis_cst->addAttribute('pPIS', cfe_numero(($reg_itens->PIS_Aliquota / 100), 4), false);
				//valor
				//$pis_cst->addAttribute('vPIS', cfe_numero($reg_itens->PIS_Valor), false);
			}else if(($reg_itens->PIS_CST == '03')){
				$pis_cst = &$pis->addChild("PISQtde");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				//qtd trib
				$pis_cst->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque, 4), false); //4 casas
				//valor por unidade
				$pis_cst->addAttribute('vAliqProd', cfe_numero($reg_itens->PIS_ValorUnidade, 4), false); //4 casas
				//valor
				//$pis_cst->addAttribute('vPIS', cfe_numero($reg_itens->PIS_Valor), false);
			}else if(($reg_itens->PIS_CST == '04') || ($reg_itens->PIS_CST == '06') ||
						($reg_itens->PIS_CST == '07') || ($reg_itens->PIS_CST == '08') ||
						($reg_itens->PIS_CST == '09')){
				$pis_cst = &$pis->addChild("PISNT");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
			}else if(($reg_itens->PIS_CST == '49')){
				$pis_cst = &$pis->addChild("PISSN");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
			}else if(($reg_itens->PIS_CST >= 49)){ // 99 - outros
				$pis_cst = &$pis->addChild("PISOutr");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				if($reg_itens->PIS_ValorUnidade > 0){
					//qtd trib
					$pis_cst->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque, 4), false); //4 casas
					//valor por unidade
					$pis_cst->addAttribute('vAliqProd', cfe_numero($reg_itens->PIS_ValorUnidade, 4), false); //4 casas
				}else{
					//base
					$pis_cst->addAttribute('vBC', cfe_numero($reg_itens->PIS_BC, 2), false);
					//aliq
					$pis_cst->addAttribute('pPIS', cfe_numero(($reg_itens->PIS_Aliquota / 100), 4), false);
				}
				//valor
				//$pis_cst->addAttribute('vPIS', cfe_numero($reg_itens->PIS_Valor), false);
			}
			//pis st
			if(($reg_itens->PIS_ST_ValorUnidade > 0) || ($reg_itens->PIS_ST_Aliquota > 0)){
				$pis_st = &$imposto->addChild("PISST");
				if($reg_itens->PIS_ST_ValorUnidade >0){
					//qtd trib
					$pis_st->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$pis_st->addAttribute('vAliqProd', cfe_numero($reg_itens->PIS_ST_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$pis_st->addAttribute('vBC', cfe_numero($reg_itens->PIS_ST_BC), false);
					//aliq
					$pis_st->addAttribute('pPIS', cfe_numero(($reg_itens->PIS_ST_Aliquota / 100), 4), false);
				}
				//valor
				//$pis_st->addAttribute('vPIS', cfe_numero($reg_itens->PIS_ST_Valor), false);
			}
				//cofins
			$cofins = &$imposto->addChild("COFINS");
			//por aliquota
			if(($reg_itens->COFINS_CST=='01') || ($reg_itens->COFINS_CST=='02') || ($reg_itens->COFINS_CST=='05')){
				$cofins_cst = &$cofins->addChild("COFINSAliq");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				//base
				$cofins_cst->addAttribute('vBC', cfe_numero($reg_itens->COFINS_BC), false);
				//aliq
				$cofins_cst->addAttribute('pCOFINS', cfe_numero(($reg_itens->COFINS_Aliquota / 100), 4), false);
				//valor
				//$cofins_cst->addAttribute('vCOFINS', cfe_numero($reg_itens->COFINS_Valor), false);
			}else if($reg_itens->COFINS_CST=='03'){
				$cofins_cst = &$cofins->addChild("COFINSQtde");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				//qtd trib
				$cofins_cst->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
				//valor por unidade
				$cofins_cst->addAttribute('vAliqProd', cfe_numero($reg_itens->COFINS_ValorUnidade,4), false); //4 casas
				//valor
				//$cofins_cst->addAttribute('vCOFINS', cfe_numero($reg_itens->COFINS_Valor), false);
				}else if(($reg_itens->PIS_CST == '04') || ($reg_itens->PIS_CST == '06') ||
					($reg_itens->PIS_CST == '07') || ($reg_itens->PIS_CST == '08') ||
					($reg_itens->PIS_CST == '09')){
					$cofins_cst = &$cofins->addChild("COFINSNT");
					//cst
					$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				}else if($reg_itens->PIS_CST == '49'){
					$cofins_cst = &$cofins->addChild("COFINSSN");
					//cst
					$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				}else if($reg_itens->COFINS_CST>=49){ //outros
					$cofins_cst = &$cofins->addChild("COFINSOutr");
					//cst
					$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				if($reg_itens->COFINS_ValorUnidade >0){
					//qtd trib
					$cofins_cst->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$cofins_cst->addAttribute('vAliqProd', cfe_numero($reg_itens->COFINS_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$cofins_cst->addAttribute('vBC', cfe_numero($reg_itens->COFINS_BC, 2), false);
					//aliq
					$cofins_cst->addAttribute('pCOFINS', cfe_numero(($reg_itens->COFINS_Aliquota / 100), 4), false);
				}
				//valor
				//$cofins_cst->addAttribute('vCOFINS', cfe_numero($reg_itens->COFINS_Valor), false);
			}else{ //no tributado
				$cofins_cst = &$cofins->addChild("COFINSNT");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
			}

			//cofins st
			if(($reg_itens->COFINS_ST_ValorUnidade >0) || ($reg_itens->COFINS_ST_Aliquota>0)){
				$cofins_st = &$imposto->addChild("COFINSST");
				if($reg_itens->COFINS_ST_ValorUnidade >0){
					//qtd trib
					$cofins_st->addAttribute('qBCProd', cfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$cofins_st->addAttribute('vAliqProd', cfe_numero($reg_itens->COFINS_ST_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$cofins_st->addAttribute('vBC', cfe_numero($reg_itens->COFINS_ST_BC, 2), false);
					//aliq
					$cofins_st->addAttribute('pCOFINS', cfe_numero($reg_itens->COFINS_ST_Aliquota, 4), false);

				}
				//valor
				//$cofins_st->addAttribute('vCOFINS', cfe_numero($reg_itens->COFINS_ST_Valor), false);
			}

			//iss
			if($reg_itens->Prod_Depart == 0){ //somente servico tem iss
				$iss = &$imposto->addChild("ISSQN");

				//Valor das dedues para ISSQN
				$iss->addAttribute('vDeducISSQN', '', false);
				//base
				//$iss->addAttribute('vBC', cfe_numero($reg_itens->ISS_BC), false);
				//aliquota
				$iss->addAttribute('vAliq', cfe_numero($reg_itens->ISS_Aliquota), false);
				//valor
				//$iss->addAttribute('vISSQN', cfe_numero($reg_itens->ISS_Valor), false);
				//municipio fato gerador
				$iss->addAttribute('cMunFG', $reg_itens->ISS_Cidade_FG, false);
				//servico
				$iss->addAttribute('cListServ', limpa_numero($reg_itens->Servico_Codigo), false);

				//Codigo de tributao pelo ISSQN do municipio
				$iss->addAttribute('cServTribMun', limpa_numero($reg_itens->Servico_Codigo), false);

				//Natureza da Operao de ISSQN
				$iss->addAttribute('cNatOp', limpa_numero($reg_itens->Servico_Codigo), false);

				//Indicador de Incentivo Fiscal do ISSQN
				$iss->addAttribute('indIncFisc', limpa_numero($reg_itens->Servico_Codigo), false);

			}

			$obs = cfe_formata_txt($reg_itens->Observacao);
			//consulta obs do item
			$con_obs = 'SELECT * FROM nota_fiscal_obs'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
						' AND TipoObs="P" '.
						' GROUP BY Texto_Completo '.
						' ORDER BY Seq_Obs ';
			$res_obs = consulta_sql($con_obs);
			$nrw_obs = consulta_num_registros($res_obs);
			//para cada obs
			for($o=0;$o<$nrw_obs;$o++){
				$reg_obs = consulta_ler_objeto($res_obs);
				//adiciona a desc detalhada deste item
				if($obs!=''){
					$obs.=';';
				}
				$obs.= cfe_formata_txt($reg_obs->Texto_Completo);
			}
			consulta_limpa($res_obs);
				//se tiver desc detalhada
			if($obs != ''){
				//adiciona as informaes adiconadis do item
				$det->addAttribute('infAdProd', trim(cfe_retira_texto_excesso($obs,0,500)), false);
			}
		}
		consulta_limpa($res_itens);

		//adiciona os totais da NF
		$totais = &$cf_inf->addChild("total");

		//totais do ISS (somente se tiver servios)
		if($reg_nota->Total_Servicos > 0){
			$iss_tot = &$totais->addChild("ISSQNtot");

			//total dos servicos
			$iss_tot->addAttribute('vServ', cfe_numero($reg_nota->Total_Servicos), false);
			//base
			$iss_tot->addAttribute('vBC', cfe_numero($reg_nota->Total_ISS_BC), false);
			//valor
			$iss_tot->addAttribute('vISS', cfe_numero($reg_nota->Total_ISS_Valor), false);
			//pis
			$iss_tot->addAttribute('vPIS', cfe_numero($reg_nota->Total_ISS_PIS_Valor), false);
			//cofins
			$iss_tot->addAttribute('vCOFINS', cfe_numero($reg_nota->Total_ISS_COFINS_Valor), false);
		}

		//Vadesc_acr_entrlor aproximado dos tributos do CFe-SAT  Lei 12741/12.
		$totais->addAttribute('vCFeLei12741', cfe_numero($val_impo_total,2), false);

		/*
		//Grupo de valores de entrada de Desconto/Acrscimo sobre Subtotal
		$desc_acr_entr = &$cf_inf->addChild("DescAcrEntr");

		//Valor de Entrada de Desconto sobre Subtotal
		$desc_acr_entr->addAttribute('vDescSubtot', cfe_numero($reg_nota->Total_ICMS_BC+$total_diferido), false);
		//Valor de Entrada de Acrscimo sobre Subtotal
		$desc_acr_entr->addAttribute('vAcresSubtot', cfe_numero($reg_nota->Total_ICMS_BC+$total_diferido), false);
		*/
		//Grupo de informaes sobre Pagamento do CFe
		$pgto = &$cf_inf->addChild("pgto");

		$valor_troco = 0;
		$valor_troco_total = 0;
		//consulta meios pagamentos da nota fiscal
		$con_parc = 'select * from nota_fiscal_finaliza '.
		' where Dominio = "'.$_SESSION['Dominio'].'"'.
		' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' and Nr_Nota = "'.$nr_nota.'"'.
		' order by Seq';
		$res_parc = consulta_sql($con_parc);
		$nrw_parc = consulta_num_registros($res_parc);
		//se tiver faturas
		if($nrw_parc >0){
			//para cada fatura
			for($f=0;$f<$nrw_parc;$f++){
				$reg_parc = consulta_ler_objeto($res_parc);

				$meio_pagto = $reg_parc->Finaliza;
				$valor_troco = $reg_parc->Troco;
				$valor_troco_total+= $valor_troco;

				//Grupo de informaes dos Meios de Pagamento empregados na quitao do CF-e
				$mp = &$pgto->addChild("MP");

				if($meio_pagto == 4){
					$meio_pagto = 5;
				}else if($meio_pagto == 3){
					if($reg_parc->CartaoTipo == 'DEB'){
						$meio_pagto = 4;
					}
				}else if($meio_pagto > 13){
					$meio_pagto = 99;
				}

				//Cdigo do Meio de Pagamento empregado para quitao do CF-e
				$mp->addAttribute('cMP', fill_full($meio_pagto, 2), false);

				$valor_pag = arredonda_numero_menos(($reg_parc->Valor - $reg_parc->Troco)*100)/100;
				//Valor do Meio de Pagamento empregado para quitao do CF-e
				$mp->addAttribute('vMP', cfe_numero($valor_pag, 2), false);

				if($reg_parc->Finaliza == 3){
					$bandeira = 999;
					$banco_cartao = UpperDados($reg_parc->CartaoBandeira);

					if(strpos($banco_cartao, 'SICREDI') !== false){
						$bandeira = 1;
					}else if((strpos($banco_cartao, 'SICREDI') !== false) && (strpos($banco_cartao, 'RS') !== false)){
						$bandeira = 2;
					}else if((strpos($banco_cartao, 'AMEX') !== false) || (strpos($banco_cartao, 'AMERICAN EXPRESS') !== false)){
						$bandeira = 3;
					}else if((strpos($banco_cartao, 'CAPITAL') !== false) || (strpos($banco_cartao, 'GE') !== false)){
						$bandeira = 4;
					}else if(strpos($banco_cartao, 'SAFRA') !== false){
						$bandeira = 5;
					}else if(strpos($banco_cartao, 'TOPZIO') !== false){
						$bandeira = 6;
					}else if(strpos($banco_cartao, 'TRIANGULO') !== false){
						$bandeira = 7;
					}else if(strpos($banco_cartao, 'BIGCARD') !== false){
						$bandeira = 8;
					}else if(strpos($banco_cartao, 'BOURBON') !== false){
						$bandeira = 9;
					}else if(strpos($banco_cartao, 'CABAL') !== false){
						$bandeira = 10;
					}else if((strpos($banco_cartao, 'CETELEM') !== false) || (strpos($banco_cartao, 'CFI') !== false)){
						$bandeira = 11;
					}else if(strpos($banco_cartao, 'CIELO') !== false){
						$bandeira = 12;
					}else if((strpos($banco_cartao, 'CREDI') !== false) && (strpos($banco_cartao, '21') !== false)){
						$bandeira = 13;
					}else if(strpos($banco_cartao, 'ECX CARD') !== false){
						$bandeira = 14;
					}else if(strpos($banco_cartao, 'EMBRATEC') !== false){
						$bandeira = 15;
					}else if(strpos($banco_cartao, 'EMBRATEC') !== false){
						$bandeira = 15;
					}else if(strpos($banco_cartao, 'EMPRIO') !== false){
						$bandeira = 16;
					}else if(strpos($banco_cartao, 'FREEDDOM') !== false){
						$bandeira = 17;
					}else if(strpos($banco_cartao, 'FUNCIONAL') !== false){
						$bandeira = 18;
					}else if(strpos($banco_cartao, 'HIPERCARD') !== false){
						$bandeira = 19;
					}else if(strpos($banco_cartao, 'MAPA') !== false){
						$bandeira = 20;
					}else if((strpos($banco_cartao, 'NOVO PAG ADM') !== false) || (strpos($banco_cartao, 'MEIOS ELETRNICOS') !== false)){
						$bandeira = 21;
					}else if(strpos($banco_cartao, 'PERNAMBUCANAS') !== false){
						$bandeira = 22;
					}else if(strpos($banco_cartao, 'POLICARD') !== false){
						$bandeira = 23;
					}else if(strpos($banco_cartao, 'PROVAR') !== false){
						$bandeira = 24;
					}else if(strpos($banco_cartao, 'REDECARD') !== false){
						$bandeira = 25;
					}else if(strpos($banco_cartao, 'RENNER') !== false){
						$bandeira = 26;
					}else if((strpos($banco_cartao, 'RP') !== false) && (strpos($banco_cartao, 'CONVNIOS') !== false)){
						$bandeira = 27;
					}else if(strpos($banco_cartao, 'SANTINVEST') !== false){
						$bandeira = 28;
					}else if(strpos($banco_cartao, 'SODEXHO') !== false){
						$bandeira = 29;
					}else if(strpos($banco_cartao, 'SOROCRED') !== false){
						$bandeira = 30;
					}else if(strpos($banco_cartao, 'TECBAN') !== false){
						$bandeira = 31;
					}else if(strpos($banco_cartao, 'TICKET') !== false){
						$bandeira = 32;
					}else if(strpos($banco_cartao, 'TRIVALE') !== false){
						$bandeira = 33;
					}else if((strpos($banco_cartao, 'UNICARD') !== false) || (strpos($banco_cartao, 'TRICARD') !== false)){
						$bandeira = 34;
					}

					$mp->addAttribute('cAdmC', fill_full($bandeira, 3), false);
				}
			}
		}
		consulta_limpa($res_parc);

		//consulta observaes da nota e dos itens
		//agrupada por descrio completa
		//ordenado por seq item e seq_obs
		$obs = '';
		if($valor_troco_total > 0){
			$obs = 'Troco: '.to_money($valor_troco_total, false);
		}
		$nr_proc_ref = 0;
		$con_obs = 'SELECT * FROM nota_fiscal_obs'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"'.
					' AND TipoObs="A" '.
					' GROUP BY Texto_Completo '.
					' ORDER BY Seq_Item, Seq_Obs';
		$res_obs = consulta_sql($con_obs);
		$nrw_obs = consulta_num_registros($res_obs);
		//para cada obs
		for($o=0;$o<$nrw_obs;$o++){
			$reg_obs = consulta_ler_objeto($res_obs);
			//adicona  obs do corpo da nota
			if($obs != ''){
				$obs.= ';';
			}
			if(($reg_obs->Seq_Item == 0) && ($reg_obs->Seq_Obs == 15)){
				//$obs.= cfe_formata_txt($reg_obs->Texto_Completo);
			}else{
				$obs.= cfe_formata_txt($reg_obs->Texto_Completo);
			}
		}
		consulta_limpa($res_obs);

		//se tem obs do corpo da nota
		if($obs!=''){
			//adicona  obs da nfe
			$inf_adic = &$cf_inf->addChild("infAdic");

			$inf_adic->addAttribute('infCpl', trim(cfe_retira_texto_excesso($obs, 0, 5000)), false);
		}

		//finaliza arquivo na pasta tmp
		$xml->toFile($cfe_pasta_raiz.'tmp/', $reg_nota->Nr_Nota."-sat.xml");
		$retorno = '';
		$salvou = file_exists($cfe_pasta_raiz.'tmp/'.$reg_nota->Nr_Nota."-sat.xml");

		//se consegui salvar
		if($salvou){
			$retorno = $reg_nota->Nr_Nota;
			//$retorno = '';
			//echo 'gerou arquivo';
		}else{
			cfe_exibe_erro('FRE-012','Falha na gerao do arquvo "'.$reg_nota->Nr_Nota.'-sat.xml" na pasta "tmp"!<BR>'.
			'Verifique a estrutura de pastas no servidor!',$nr_nota);
		}
		return $retorno;
	}

	/////////////////////////////////////////////
	////////////////CFe//////////////////
	/////////////////////////////////////////////


	/////////////////////////////////////////////
	/////////////////CANCELAMENTO////////////////
	/////////////////////////////////////////////

	function cfe_gera_arquivo_cancela($nr_nota){
		$con_nota = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);

		$ano_mes = cfe_ano_mes();
		$versao_cfe = config_pad('cfe_versao');
		$cfe_pasta_raiz = cfe_pasta_raiz();

		$arquivo_cancelamento = $cfe_pasta_raiz.'retorno/'.$reg_nota->Nr_Nota.'-sat-canc.xml';

		if(file_exists($arquivo_cancelamento)){
			unlink($arquivo_cancelamento);
		}

		$xml = new XML();

		//adiciona dados
		$cf_inf = &$xml->createRoot("CFeCanc");
		$inf_canc = &$cf_inf->addChild("infCFe");
		$inf_canc->addAttribute('chCanc', 'CFe'.$reg_nota->NFe_Chave, true);

		$ide = &$inf_canc->addChild("ide");

		//CNPJ software house
		$cnpj_ide = '83.188.342/0001-04';
		$ide->addAttribute('CNPJ', limpa_numero($cnpj_ide), false);

		//Assinatura do Aplicativo Comercial
		$ide->addAttribute('signAC', BuscaParamEmpresa('SAT_ASSINATURA'), false);

		//Nmero do Caixa ao qual o SAT est conectado
		$ide->addAttribute('numeroCaixa', fill_full($reg_nota->Serie, 3), false);

		$emit = &$inf_canc->addChild("emit");
		$dest = &$inf_canc->addChild("dest");
		$total = &$inf_canc->addChild("total");

		//cria arquivo de consulta do lote da NF-e na pasta tmp
		$xml->toFile($cfe_pasta_raiz.'tmp/', $reg_nota->Nr_Nota.'-sat-canc.xml');
		$retorno = file_exists($cfe_pasta_raiz.'tmp/'.$reg_nota->Nr_Nota.'-sat-canc.xml');

		//se consegui salvar
		if(!$retorno){
			cfe_exibe_erro('FRE-012','Falha na gerao do arquivo "'.$reg_nota->Nr_Nota.'-sat.xml" na pasta "tmp"!<BR>'.
			'Verifique a estrutura de pastas no servidor!',$nr_nota);
		}
		return $retorno;
	}

	function cfe_gera_arquivo_auxiliar($nr_nota){
		$con_nfe = 'select * from nota_fiscal '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		$ano_mes = cfe_ano_mes($reg_nfe->DH_Emissao);

		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("outrasInfDANFe");
		if (dataf($reg_nfe->DH_SaidaNota)=='00/00/0000'){
			$data = data_atual('date');  //se tiver vazio realmente ento vai pegar apenas quando emitir o danf-e
			$hora = nr2hora(hora_atual());
		}else{
			$data = substr($reg_nfe->DH_SaidaNota,0,10);
			$hora = substr($reg_nfe->DH_SaidaNota,11);
		}

		$nf_inf->addAttribute('horasaida', $hora , false);
		$nf_inf->addAttribute('dSaiEnt', $data , false);

		//cria arquivo de consulta do lote da NF-e na pasta tmp
		$xml->toFile(cfe_pasta_raiz().'tmp/', $reg_nfe->NFe_Chave.'-auxNFe.xml');
		cfe_copia_arquivo('tmp','danfe/'.$ano_mes,$reg_nfe->NFe_Chave.'-auxNFe.xml','',false);

		return (cfe_pasta_raiz().'danfe/'.$ano_mes.'/'.$reg_nfe->NFe_Chave.'-auxNFe.xml');
	}

	/////////////////////////////////////////////
	/////////////////CANCELAMENTO////////////////
	/////////////////////////////////////////////


	/////////////////////////////////////////////
	/////////////LOTE DE NOTA FISCAL/////////////
	/////////////////////////////////////////////

	/*  function nfe_gera_arquivo_lote($lista_nfs){
	$nrand = rand(500,1500);

	$xml = new XML();
	//adiciona dados da nota
	$cf_inf = &$xml->createRoot("MontarLoteNFe");
	foreach($lista_nfs as $key => $nr_nota){
	$cf_inf->addAttribute('ArquivoNFe', $nr_nota.'-nfe.xml' , false);
	}

	$xml->toFile(cfe_pasta_raiz().'tmp/', $nrand.'-montar-lote.xml');
	//$copiou = cfe_copia_arquivo('tmp','envio_lote',$nrand.'-montar-lote.xml','',false);

	//if($copiou){
	return $nrand;
	//}else{
	//   return 0;
	//}
	} */
	/////////////////////////////////////////////
	/////////////LOTE DE NOTA FISCAL/////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	///////////CONSULTA SIT SEM RECIBO///////////
	/////////////////////////////////////////////

	/* function nfe_gera_arquivo_sit_nfe($chave_nfe,$tpAmb){

	$xml = new XML();
	//adiciona dados da nota
	$cf_inf = &$xml->createRoot("consSitNFe");
	$cf_inf->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/nfe' , true);

	$versao = '3.10';
	//if(data2nr(data_atual('data'))>=data2nr('01/07/2012')){
	//if(substr($chave_nfe,0,2) != '41'){
	//   $versao = '2.01';
	//}
	//}
	$cf_inf->addAttribute('versao', $versao , true);

	$cf_inf->addAttribute('tpAmb', $tpAmb , false);
	$cf_inf->addAttribute('xServ', 'CONSULTAR' , false);
	$cf_inf->addAttribute('chNFe', $chave_nfe , false);

	$xml->toFile(cfe_pasta_raiz().'tmp/', $chave_nfe.'-ped-sit.xml');
	return cfe_copia_arquivo('tmp','envio',$chave_nfe.'-ped-sit.xml','',false);
	} */
	/////////////////////////////////////////////
	///////////CONSULTA SIT SEM RECIBO///////////
	/////////////////////////////////////////////
?>
