<?php
   require_once(dirname(__FILE__).'/ie.php'); 
   
	function cfe_modulo11($nr_original){
		$soma = 0;
		$k= 2;
		for($i=strlen($nr_original);$i>0;$i--){
			$soma+= ($nr_original[$i-1] * $k);
			$k++;
			if($k>9){
				$k = 2;
			}
		}
		$digito = 11 - ($soma%11);
		if($digito >= 10){
			$digito = 0;
		}
		return $digito;
	}

	function cfe_copia_arquivo($origem,$destino,$arquivo,$nr_nota='',$renomeia=false,$apaga=true){
		$cfe_pasta_raiz = cfe_pasta_raiz();
		//determina nome do arquivo de origem
		$arq_ori = $cfe_pasta_raiz.$origem.'/'.$arquivo;
		//determina nome do arquivo de destino
		$arq_des = $cfe_pasta_raiz.$destino.'/'.$arquivo;
		//se renomeia
		if($renomeia){
			//arquivo de destino  com a data/hora no incio do mesmo
			$data_hora = data_atual('date').nr2hora(hora_atual());
			$data_hora = str_replace('-','',$data_hora);
			$data_hora = str_replace(':','',$data_hora);
			$arq_des = $cfe_pasta_raiz.$destino.'/'.$data_hora.'_'.$arquivo;
		}
		//verifica se arquivo de origem existe
		if(file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if(!(file_exists($cfe_pasta_raiz.$destino))){
				//seno cria ela (ano_mes)
				rmkdir($cfe_pasta_raiz.$destino."/",0777);
			}
			//verifica se destino existe
			if(file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if($copiou){
				//se a instruo for de apagar o arquivo de origem
				if($apaga){
					//apaga o arquivo de origem
					unlink($arq_ori);
				}
				return true;
			}else{
				cfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
				'Verifique a estrutura de pastas do servidor!',$nr_nota);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			cfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
			'Verifique a estrutura de pastas do servidor!',$nr_nota);
			return false;
		}
	}

	function cfe_gera_chave($reg_nfe,$modalidade=0){
		$con_serie = 'SELECT NFe_Ambiente,NFe_TipoEmissao,NFe_FormatoDANFe FROM nota_fiscal_serie '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Modelo="'.$reg_nfe->Modelo.'"'.
					' AND Serie="'.$reg_nfe->Serie.'"'.
					' AND SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);

		//gera chave de acesso  NF-e (caso ainda no possua)
		//so 44 dgitos
		// 02 cdigo UF do emitente
		// 04 ano mes de emisso
		// 14 cnpj emitente
		// 02 Modelo (55)
		// 09 serie
		// 06 nr documento
		// 06 aleatrio
		// 01 digitos Mod 11

		//pega uf da empresa e consulta cadastro pra saber o numero de referencia
		$con_uf = 'SELECT Codigo_UF FROM uf '.
				' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
				' AND UF="'.$reg_nfe->Empresa_UF.'"';
		$res_uf = consulta_sql($con_uf);
		$reg_uf = consulta_ler_linha($res_uf);
		consulta_limpa($res_uf);

		$ano_mes = cfe_ano_mes($reg_nfe->DH_Emissao,'AAMM');

		$cnpj = limpa_numero($reg_nfe->Empresa_CNPJ);
		$serie = limpa_numero($reg_nfe->Serie);
		
		if($reg_nfe->NFe_Chave == ''){
			$nr_random = fill_full(rand(1,99),3).fill_full(rand(10,599),3);
		}else{
			$nr_random = substr($reg_nfe->NFe_Chave,37,6);
		}

		$chave_nfe = fill_full($reg_uf[0],2).$ano_mes.
		fill_full($cnpj,14).fill_full($reg_nfe->Modelo,2).
		fill_full($serie,9).fill_full($reg_nfe->NrDoc,6).
		$nr_random;

		$dig_nfe = cfe_modulo11($chave_nfe);
		$chave_nfe.= $dig_nfe;

		$upd_nota = 'Update nota_fiscal set'.
					' NFe_Chave="'.$chave_nfe.'",'.
					' NFe_Ambiente="'.$reg_serie[0].'", '.
					' NFe_TipoEmissao="'.$reg_serie[1].'", '.
					' NFe_FormatoDANFe="'.$reg_serie[2].'", '.
					' NFe_Versao="'.config_pad('nfe_versao').'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$reg_nfe->Nr_Nota.'" '.
					' AND NFe_Chave="'.$reg_nfe->NFe_Chave.'"';
		consulta_sql($upd_nota,true,1);
	}

	function cfe_ano_mes($data='',$tipo='AAAAMM'){  //foramto 0000-00-00
		if($data==''){
			$data = data_atual('date');
		}
		if($tipo=='AAAAMM'){
			return $data[0].$data[1].
					$data[2].$data[3].
					$data[5].$data[6];
		}else{
			return $data[2].$data[3].
					$data[5].$data[6];
		}
	}

	function cfe_retira_texto_excesso($texto,$inicio,$tamanho_max){
		//descobre quantos carates < > " ' & existem no texto
		// o limite vai ser menor se existirem esses caracteres
		//por que no xml eles ocupam mais do que uma posio

		//primeiro tira os primeiros $tamanjho de caracteres caracteres)
		$texto = trim(substr(trim($texto),$inicio,$tamanho_max));
		$texto_final = '';
		//$conta_menor = substr_count($texto_final,'>');
		$tamanho  = strlen($texto);
		$tamanho_total = 0;
		for($t=0;$t<$tamanho;$t++){
			$tamanho_car = 1;
			if(($texto[$t]=='<')||($texto[$t]=='>')){
				$tamanho_car = 4;
			}else if(($texto[$t]=='"')||($texto[$t]=="'")){
				$tamanho_car = 6;
			}else if($texto[$t]=='&'){
				$tamanho_car = 5;
			}
			$tamanho_total+=$tamanho_car;
			if($tamanho_total<=$tamanho_max){
				$texto_final.= $texto[$t];
			}
		}
		return trim($texto_final);
	}  

	function cfe_abre_arquivo_succ($arquivo){
		//abre arquivo na pasta de retorno
		$arquivo = cfe_pasta_raiz().'retorno/'.$arquivo;

		$linhas = '';
		$arquivo_arr = file($arquivo);
		foreach($arquivo_arr as $key => $value){
			set_time_limit(30);
				$linhas.= $value;
		}
		if ($linhas==''){
			sleep(100);
			$arquivo_arr = file($arquivo);
			foreach($arquivo_arr as $key => $value){
				set_time_limit(30);
				$linhas.= $value;
			}
		}
		return $linhas;
	}

	function cfe_abre_arquivo_err($arquivo){
		//abre arquivo de erro na pasta de retorno
		$cfe_pasta_raiz = cfe_pasta_raiz();
		$temp_file = $cfe_pasta_raiz.'temp_xml/'.$arquivo;
		$arq_base  = $cfe_pasta_raiz.'retorno/'.$arquivo;

		sleep(1);

		if(file_exists($temp_file)){
			unlink($temp_file);
		}
		//echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
		copy($arq_base, $temp_file);

		$linhas_erro = '';
		$array_of_list_values = file($temp_file);
		foreach($array_of_list_values as $key => $value){
			set_time_limit(30);
			$linhas_erro.= $value;
		}
		unset($array_of_list_values);
		unlink($temp_file);
		//le todo o contedo da pasta
		return nl2br($linhas_erro);
	}

	function cfe_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/cf_e/'.$_SESSION["Empresa_Codigo"].'/';
	}
	
	function cfe_pasta_raiz2($dominio,$empresa){
		return '../arquivos_clientes/'.$dominio.'/cf_e/'.$empresa.'/';
	}

	function cfe_pasta_raiz3(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/';
	}

	function cfe_busca_arquivo($nr_nota,$tipo="xml"){
		$con_nfe = 'SELECT NFe_Chave FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		$nm_arq = $reg_nfe->NFe_Chave."-CFe.xml";
		$url_arq = cfe_pasta_raiz().'SEFAZ/CF-es/'.cfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Autorizados/'.$nm_arq;      

		return $url_arq;
	}

	function cfe_busca_arquivo_cancela($nr_nota){
		$con_nfe = 'SELECT DH_Emissao, NFe_Chave FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		$nm_arq = $reg_nfe->NFe_Chave.'-CFe-canc.xml';
		$url_arq = cfe_pasta_raiz().'SEFAZ/CF-es/'.cfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Cancelados/'.$nm_arq;

		return $url_arq;
	}



	/* function nfe_exibe_download($ano_mes, $nm_arq){
	$url_arq = cfe_pasta_raiz().'SEFAZ/NF-es/'.$ano_mes.'/Recebidas/'.$nm_arq;

	$url_arq = 'Arquivo da NF-e: <a href="'.$url_arq.'" target="_blank">'.$nm_arq.'</a>';
	if(!file_exists(cfe_pasta_raiz().'SEFAZ/NF-es/'.$ano_mes.'/Recebidas/'.$nm_arq)){
	$url_arq = '';
	}

	return $url_arq;
	} */

	function cfe_exibe_erro($codigo,$mensagem,$nr_nota){
		//exibe o erro na tela
		echo '<p><font size="2" face="Verdana"><b>'.$codigo.'</b><BR>'.$mensagem.'</font></p><BR><BR>';
		//retorna o status dessa nota para "P"
		if($nr_nota != 0){
			cfe_retorna_cfe($nr_nota);
		}
	}

	function cfe_exibe_processamento($fase,$cmpl=''){
		if($fase == '1'){
			echo '<p><font size="2" face="Verdana">Gerando Arquivo CF-e... (1/3)</font></p>';
		}
		if($fase == '2'){
			echo '<p><font size="2" face="Verdana">Consultando Dados... (2/3)</font></p>';
		}
		if($fase == '3'){
			echo '<p><font size="2" face="Verdana">CF-e '.$cmpl.'!  (3/3)</font></p>';
		}      

		if($fase == 'R'){
			echo '<p><font size="2" face="Verdana">Reprocessando o CF-e!</font></p>';
		}
		if($fase == 'C1'){
			$operacao = 'Cancelamento';         
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' do CF-e!</font></p>';
		}
		if($fase == 'C2_A'){         
			$operacao = 'Cancelamento';         
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML de '.$operacao.'...</font></p>';
		}
		if($fase == 'C2_B'){         
			$operacao = 'Cancelamento';         
			echo '<p><font size="2" face="Verdana">'.$operacao.' do CF-e Homologado!</font></p>';
		}
		if($fase == 'C3'){
			echo '<p><font size="2" face="Verdana">Retornando Estoque do Produto...</font></p>';
		}
		if($fase == 'C4'){
			echo '<p><font size="2" face="Verdana">Retornando saldo das NFs Referenciadas...</font></p>';
		}
		if($fase == 'C5'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos '.busca_nome_pedido_orc().'s Referenciados...</font></p>';
		}
		if($fase == 'C6'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins Referenciados...</font></p>';
		}
		if($fase == 'C6_B'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins de Resduos Referenciados...</font></p>';
		}
		if($fase == 'C7_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo Movimento de Estoque...</font></p>';
		}
		if($fase == 'C7'){         
			$operacao = 'Cancelado';         
			echo '<p><font size="2" face="Verdana">CF-e '.$operacao.' com Sucesso!</font></p>';
		}
		if($fase == 'FS-DA'){
			echo '<p><font size="2" face="Verdana">NF-es validadas com sucesso! Formulrio de Segurana Autorizado!</font></p>';
		}
		if($fase == 'OFF-LINE'){
			echo '<p><font size="2" face="Verdana">NFC-es validadas com sucesso! Emisso em Contingncia OFF-LINE!</font></p>';
		}
		if($fase == 'C8_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo a Conta...</font></p>';
		}

		if($fase == 'C1_G'){
			if($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' da Conta!</font></p>';
		}
		if($fase == 'C7_G'){
			if($cmpl=='I'){
				$operacao = 'Inutilizada';
			}else{
				$operacao = 'Cancelada';
			}
			echo '<p><font size="2" face="Verdana">A Conta foi '.$operacao.' com Sucesso!</font></p>';
		}

		flush(); @ob_flush();
		flush(); @ob_flush();
	}

	function cfe_formata_txt($texto){
		$texto2='';
		$texto1 = strtr(trim($texto), array(";" => ':', "  " => ' ', "'" => '', '"' => '', '' => '-'));
		$texto1 = strtr(trim($texto1), array("\r\n" => ';', "\r" => ';', "\n" => ';'));
		while($texto1!=$texto2){
			$texto2 = $texto1;
			$texto1 = strtr(trim($texto1), array("  " => ' ', ";;" => ';'));
		}
		return $texto1;
	}


	function cfe_numero($valor,$qtd_zeros=2){
		$valor = (($valor + 1) - 1);
		return number_format($valor,$qtd_zeros,".","");
	}

	function cfe_valida_dados_cfe($nr_nota){
		///valida minimamente os dados da NF-e para minimizar Rejeies na SEFAZ
		$erros = '';

		//conuslta Nota Fiscal

		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		//validao emitente

		//CNPJ
		//if(strlen($reg_nfe->Empresa_CNPJ)<18){
		//    $erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da empresa  invlido!';
		//}
		//vlidar o CNPJ (funo)
		if(!CalculaCNPJ($reg_nfe->Empresa_CNPJ)){
			$erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da Empresa  invlido!';
		}

		//nome
		if(strlen($reg_nfe->Empresa_Razao)<3){
			$erros.='<BR>A Razo Social "'.$reg_nfe->Empresa_Razao.'" da empresa  invlida!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Empresa_Fantasia!='')&&(strlen($reg_nfe->Empresa_Fantasia)<3)){
			$erros.='<BR>O nome fantasia da Empresa  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Empresa_Logradouro)<2){
			$erros.='<BR>O logradouro da Empresa  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Empresa_Bairro)<2){
			$erros.='<BR>O bairro da Empresa  invlido!';
		}
		//CEP
		if(($reg_nfe->Empresa_CEP!='')&&(strlen($reg_nfe->Empresa_CEP)<9)){
			$erros.='<BR>O CEP "'.$reg_nfe->Empresa_CEP.'" da Empresa  invlido!';
		}
		//cidade nome
		if(strlen($reg_nfe->Empresa_Nome_Cidade)<2){
			$erros.='<BR>O nome de cidade da Empresa  invlido!';
		}
		//Cidade nr
		if(($reg_nfe->Empresa_Codigo_Cidade<=0)&&(strlen($reg_nfe->Empresa_Codigo_Cidade)>7)){ //1000000
			$erros.='<BR>O cdigo de cidade da Empresa  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Empresa_Nome_Pais)<2){
			$erros.='<BR>O nome de pas da Empresa  invlido!';
		}
		//pais nr
		if($reg_nfe->Empresa_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas da Empresa  invlido!';
		}
		//telefone
		if(strlen($reg_nfe->Empresa_Telefone_Nr)<14){
			$erros.='<BR>O telefone "'.$reg_nfe->Empresa_Telefone_Nr.'" da Empresa  invlido!';
		}
		//UF
		if(strlen($reg_nfe->Empresa_UF)<2){
			$erros.='<BR>A UF da Empresa  invlida!';
		}
		//IE
		if(limpa_mascara($reg_nfe->Empresa_Insc_Estadual) != ''){
			if(strtoupper($reg_nfe->Empresa_Insc_Estadual) != 'ISENTO'){
				if(!(ChkInscEstadual($reg_nfe->Empresa_Insc_Estadual, $reg_nfe->Empresa_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" da Empresa  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}

		//IM/CNAE  //se informar IM informe o CNAE da empresa
		//if($reg_nfe->Empresa_IM!=''){
		//    if(strlen($reg_nfe->Empresa_CNAE)<=0){
		//        $erros.='<BR>O CNAE da Empresa  invlido!';
		//    }
		//}

		//validao destinatrio
		//CNPJ
		if($reg_nfe->Dest_UF!='EX'){  //no valida caso seja estrangeiro
			if(strlen($reg_nfe->Dest_CPF_CNPJ)==14){
				if(!CalculaCPF($reg_nfe->Dest_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
				}
			}else if(strlen($reg_nfe->Dest_CPF_CNPJ)==18){
				if(!CalculaCNPJ($reg_nfe->Dest_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
				}
			}else{
				$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
			}
		}
		//nome
		if(strlen($reg_nfe->Dest_Razao)<3){
			$erros.='<BR>O razo social do Cliente/Fornecedor  invlido!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Dest_Fantasia!='')&&(strlen($reg_nfe->Dest_Fantasia)<3)){
			$erros.='<BR>O nome fantasia do Cliente/Fornecedor  invlido!';
		}

		//logradouro
		if(strlen($reg_nfe->Dest_Logradouro)<2){
			$erros.='<BR>O logradouro do Cliente/Fornecedor  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Dest_Bairro)<2){
			$erros.='<BR>O bairro do Cliente/Fornecedor  invlido!';
		}
		//CEP
		//if(strlen($reg_nfe->Dest_UF)!='EX'){
		//    if(strlen($reg_nfe->Dest_CEP)<9){
		//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Cliente/Fornecedor  invlido!';
		//    }
		//}
		//cidade nome
		if(strlen($reg_nfe->Dest_Nome_Cidade)<2){
			$erros.='<BR>O nome de cidade do Cliente/Fornecedor  invlido!';
		}
		//Cidade nr
		if($reg_nfe->Dest_Codigo_Cidade<=0){
			$erros.='<BR>O cdigo de cidade do Cliente/Fornecedor  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Dest_Nome_Pais)<2){
			$erros.='<BR>O nome de pas do Cliente/Fornecedor  invlido!';
		}
		//pais nr
		if($reg_nfe->Dest_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas do Cliente/Fornecedor  invlido!';
		}
		/*
		//telefone
		if(strlen($reg_nfe->Dest_Telefone_Nr)<14){
		$erros.='<BR>O telefone "'.$reg_nfe->Dest_Telefone_Nr.'" do Cliente/Fornecedor  invlido!';
		}*/
		//UF
		if(strlen($reg_nfe->Dest_UF)<2){
			$erros.='<BR>A UF do Cliente/Fornecedor  invlida!';
		}
		//IE
		if(limpa_mascara($reg_nfe->Dest_Insc_Estadual) != ''){
			if(strtoupper($reg_nfe->Dest_Insc_Estadual) != 'ISENTO'){
				$ie_validar = $reg_nfe->Dest_Insc_Estadual;
				if(substr($ie_validar,0,2)=='NC'){
					$ie_validar = substr($ie_validar,2,20);
				}
				if(!(ChkInscEstadual($ie_validar, $reg_nfe->Dest_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$ie_validar.'" do Cliente/Fornecedor  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}

		//transportadora
		//CNPJ
		//somente se tivera transportadora definida na NF

		if($reg_nfe->Transportadora>0){
			if(($reg_nfe->Transp_CPF_CNPJ!='00.000.000/0000-00') ||
				($reg_nfe->Transp_CPF_CNPJ!='000.000.000-00')){

				if(strlen($reg_nfe->Transp_CPF_CNPJ)==14){
					if(!CalculaCPF($reg_nfe->Transp_CPF_CNPJ)){
						$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
					}
				}else if(strlen($reg_nfe->Transp_CPF_CNPJ)==18){
					if(!CalculaCNPJ($reg_nfe->Transp_CPF_CNPJ)){
						$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
					}
				}else{
					$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
				}
			}

			//nome
			if(strlen($reg_nfe->Transp_Nome)<3){
				$erros.='<BR>O nome da Transportadora  invlido!';
			}

			//UF
			if(strlen($reg_nfe->Transp_UF)<2){
				$erros.='<BR>A UF da Transportadora  invlida!';
			}

			//IE
			if(limpa_mascara($reg_nfe->Transp_IE) != ''){
				if(strtoupper($reg_nfe->Transp_IE) != 'ISENTO'){
					if(!(ChkInscEstadual($reg_nfe->Transp_IE, $reg_nfe->Transp_UF))){
						$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Transp_IE.'" da Transportadora  invlida para "'.$reg_nfe->Transp_UF.'"!';
					}
				}
			}

		}
		//consulta Nota Fiscal Item
		$con_item = 'SELECT * FROM nota_fiscal_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrw_item;$i++){
			$reg_item = consulta_ler_objeto($res_item);
			//valida dados do produto
			//Codigo
			//descrio
			if(strlen($reg_item->Prod_Descricao)<2){
				$erros.= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": Descrio do Produto  invlido!';
			}

			//Unidade de medida
			if(strlen($reg_item->Unidade_NF)<1){ //pode sim ter 1 dig
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A unidade de medida  invlida!';
			}
			//NCM (se com IPI ou CFOP comea com 3 ou 7 tem que ter 8 digitos, seno s dois  suficiente)
			if(($reg_item->IPI_Valor>0)||((substr($reg_item->CFOP,0)==3)||(substr($reg_item->CFOP,0)==7))){
				if(strlen($reg_item->Prod_NCM)<10){
					$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuir todos os dez dgitos para operaes com exterior ou com incidncia de IPI!';
				}
			}else if(strlen($reg_item->Prod_NCM)<2){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuiir ao menos os dois primeiros dgitos (gnero) para esta operao!';
			}
			//Origem da Mercadoria (se CFOP = 3) a origem deve ser 1
			if(substr($reg_item->CFOP,0)==3){
				if($reg_item->Origem!='1'){
					$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A origem de mercadoria  invlida! para operaes de importao a origem deve ser obrigatoriamente "2 - Estrangeira"';
				}
			}
			//CSTs de ICMS, IPI, PIS e COFINS (validar se Os CST existem na lista de CSTs)
			if(busca_dados_combo('icms_cst_'.$reg_nfe->Empresa_CRT,$reg_item->ICMS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do ICMS "'.$reg_item->ICMS_CST.'"  invlido!';
			}
			if(busca_dados_combo('ipi_cst',$reg_item->IPI_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do IPI "'.$reg_item->IPI_CST.'"  invlido!';
			}

			if(busca_dados_combo('pis_cst_nf_'.$reg_nfe->TipoES,$reg_item->PIS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do PIS "'.$reg_item->PIS_CST.'"  invlido!';
			}
			if(busca_dados_combo('cofins_cst_nf_'.$reg_nfe->TipoES,$reg_item->COFINS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do COFINS "'.$reg_item->COFINS_CST.'"  invlido!';
			}
		}
		consulta_limpa($res_item);

		if($erros!=''){
			$upd_nota = 'Update nota_fiscal '.
						' set Situacao="P" '.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota="'.$nr_nota.'" '.
						' AND Situacao="I"';
			$res_upd = consulta_sql($upd_nota,true,1);  //retorna para P pois no vai fazer a NFe
			cfe_exibe_erro('FRE-602','A Nota Fiscal <b>"'.$reg_nfe->NrDoc.'/'.$reg_nfe->Serie.'"</b> contm dados invlidos!'.
			'<BR>Corrija os dados e tente o envio navamente!'.$erros.'<BR><BR>',0);

		}
		return ($erros=='');
	}

	//copia arquivo de trnsferencia
	function cfe_copia_arquivo2($origem,$destino,$arquivo_o,$arquivo_d,$ano_mes){
		//determina nome do arquivo de origem
		$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$origem.'/SEFAZ/NF-es/'.$ano_mes.'/Autorizados';

		$arq_ori = $pasta_ori.'/'.$arquivo_o;

		//echo 'Arqui Ori'.$arq_ori.'<BR>';
		$ano_mes2 =  cfe_ano_mes();
		//determina nome do arquivo de destino
		$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$destino.'/SEFAZ/NF-es/'.$ano_mes2.'/Recebidas';

		$arq_des = $pasta_des.'/'.$arquivo_d;
		//se renomeia
		//echo 'Arqui Dest'.$arq_des.'<BR>';

		//verifica se arquivo de origem existe
		if(file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if(!(file_exists($pasta_des))){
				//seno cria ela (ano_mes)
				rmkdir($pasta_des."/",0777);
			}

			//verifica se destino existe
			if(file_exists($arq_des)){
			//apaga arquivo de destino caso exista alguma coisa
			unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);

			//se fez a copia corretamente
			if($copiou){
				return true;
			}else{

				cfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
				'Verifique a estrutura de pastas do servidor!',0);

				return false;
			}

		}else{ //seno

			//exibe erro de arquivo inexistente
			cfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
			'Verifique a estrutura de pastas do servidor!',0);
			return false;
		}
	}

	//muda a pasta ano mes da pasta recebidas (edio da data de entrada)
	function cfe_copia_arquivo3($empresa,$data1,$data2,$arquivo){
		//determina nome do arquivo de origem

		$ano_mes1 = cfe_ano_mes($data1);
		$ano_mes2 = cfe_ano_mes($data2);

		if($ano_mes2!=$ano_mes1){

			$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$empresa.'/SEFAZ/NF-es/'.$ano_mes1.'/Recebidas';

			$arq_ori = $pasta_ori.'/'.$arquivo;

			//echo 'Arqui Ori'.$arq_ori.'<BR>';

			//determina nome do arquivo de destino
			$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$empresa.'/SEFAZ/NF-es/'.$ano_mes2.'/Recebidas';

			$arq_des = $pasta_des.'/'.$arquivo;
			//se renomeia
			//echo 'Arqui Dest'.$arq_des.'<BR>';

			//verifica se arquivo de origem existe
			if(file_exists($arq_ori)){
				//verifica se pasta de destino existe
				if(!(file_exists($pasta_des))){
					//seno cria ela (ano_mes)
					rmkdir($pasta_des."/",0777);
				}

				//verifica se destino existe
				if(file_exists($arq_des)){
					//apaga arquivo de destino caso exista alguma coisa
					unlink($arq_des);
				}
				//efetiva acopia do arquivo
				//echo $arq_ori.'-'.$arq_des.'<BR>';
				$copiou = copy($arq_ori, $arq_des);

				//se fez a copia corretamente
				if($copiou){
					unlink($arq_ori);
					return true;
				}else{

					cfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
					'Verifique a estrutura de pastas do servidor!',0);

					return false;
				}
			}else{ //seno
				//exibe erro de arquivo inexistente
				cfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
				'Verifique a estrutura de pastas do servidor!',0);
				return false;
			}
		}else{
			return true;
		}
	}

	function consulta_status_e_servico($tp_amb=2){

		$con_uf_empresa = 'SELECT Codigo_Cidade FROM pessoa_endereco '.
			' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
			' AND Pessoa = "'.$_SESSION['Empresa_Codigo'].'" '.
			' AND Situacao <> "E" '.
			' ORDER BY Seq_Endereco ASC limit 1';
		$res_uf_empresa = consulta_sql($con_uf_empresa);
		$reg_uf_empresa = consulta_ler_linha($res_uf_empresa);
		consulta_limpa($res_uf_empresa);

		$ano_mes = cfe_ano_mes();

		$versao_c = '1.07';
		$versao = config_pad('nfe_versao');

		if($versao == '2.00'){
			$versao_c = '2.00';
		}
		if($versao == '3.10'){
			$versao_c = '3.10';
		}

		$xml = new XML();

		$root = &$xml->createRoot("consStatServ");
		$root->addAttribute('versao', $versao_c, true);
		$root->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/nfe', true);

		$root->addAttribute('tpAmb', $tp_amb, false);
		//$root->addAttribute('tpAmb', '1', false);
		$root->addAttribute('cUF',  substr($reg_uf_empresa[0],0,2), false);
		//$root->addAttribute('tpEmis',  '3', false);
		$root->addAttribute('xServ',  'STATUS', false);

		$ano_mes = data_atual('date');
		$hora = nr2hora(hora_atual());

		$ano_mes_hora  = str_replace('-','',$ano_mes).'T'.str_replace(':','',$hora);
		//$ano_mes_hora = 'Outro';
		$xml->toFile(cfe_pasta_raiz().'tmp/', $ano_mes_hora.'-ped-sta.xml');
		$salvou = cfe_copia_arquivo('tmp','envio',$ano_mes_hora.'-ped-sta.xml','',false);

		$dh_sefaz = '';

		$data_sefaz = '';
		$hora_sefaz = '';

		$tentativa = 0;

		$diferenca_data = '';
		$diferenca_hora = '';

		$dh_sefaz = '';
		$tempo_medio_sefaz= '';
		$descricao_sefaz= '';
		$codigo_sefaz= '';

		//se consegui salvar
		if($salvou){
			$ok = false;
			while(!($ok)){
				//set_time_limit(60);
				if ((file_exists(cfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml'))||
					(file_exists(cfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err'))){
					$ok = true;
					sleep(5);

					if(file_exists(cfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml')){

						$xml = new XML();
						$xml->fromFile(cfe_pasta_raiz().'retorno/',$ano_mes_hora.'-sta.xml', true);

						if($xml->root->name == 'retConsStatServ'){
							foreach($xml->root->atts as $key2 => $value){
								if($xml->root->atts[$key2]->name== 'dhRecbto'){
									$dh_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'tMed'){
									$tempo_medio_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'xMotivo'){
									$descricao_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'cStat'){
									$codigo_sefaz = &$xml->root->atts[$key2]->value;
								}
							}
							if(($codigo_sefaz=='107')&&($dh_sefaz!='')){
								//AAAA-MM-DDTHH:MM:SS

								$data_pc = data2nr(data_atual('data'));
								$hora_pc = hora_atual();
								$data_sefaz = substr($dh_sefaz,0,10);
								$hora_sefaz = substr($dh_sefaz,11);
								$data_sefaz = data2nr(dataf($data_sefaz));
								$hora_sefaz = hora2nr($hora_sefaz);
								$diferenca_data = 24*60*60*($data_sefaz-$data_pc);
								$diferenca_hora = ($hora_sefaz-$hora_pc);

								$diferenca = $diferenca_data+($diferenca_hora);

								$update = 'update uf set '.
									' DH_SEFAZ = '.$diferenca.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND Codigo_UF = "'.substr($reg_uf_empresa[0],0,2).'"';
								consulta_sql($update);

								unlink(cfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml');

								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz.'.<BR><BR>Data/Hora: '.dataf((substr($dh_sefaz,0,10))).' '.substr($dh_sefaz,11).'<BR>Tempo mdio: '.$tempo_medio_sefaz.'s';
								//return true;
							}else{
								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz;
							}
						}else{
							$mensagem = 'Falha na estrutura do arquivo XML de retorno!';
							//return false;
						}
					}else if(file_exists(cfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err')){
						//exibe mensagem do arquivo de erro
						$conteudo_arquivo = cfe_abre_arquivo_err($ano_mes_hora.'-ped-sta.err');
						$mensagem = 'Falha no Processamento do Arquivo '.$conteudo_arquivo.'!';
					}else{
						$mensagem = 'Falha no Processamento do Arquivo!';
						//return false;
					}
				}
			}//while
		}else{
			$mensagem = 'Consulta abortada por favor tente mais tarde!';
		}
		return $mensagem;
	}
	/*
	function calcula_horario_verao($data,$uf){

	$fuso_horario = 3;

	if( ($uf=='MT') ||
	($uf=='MS') ||
	($uf=='AM') ||
	($uf=='RO') ||
	($uf=='AC') ||
	($uf=='RR') ||
	($uf=='51') ||
	($uf=='50') ||
	($uf=='13') ||
	($uf=='11') ||
	($uf=='12') ||
	($uf=='14') ){
	$fuso_horario = 4;
	}

	if( ($uf=='RS') ||
	($uf=='SC') ||
	($uf=='PR') ||
	($uf=='SP') ||
	($uf=='RJ') ||
	($uf=='ES') ||
	($uf=='MG') ||
	($uf=='GO') ||
	($uf=='MT') ||
	($uf=='MS') ||
	($uf=='DF') ||
	($uf=='TO') ||

	($uf=='43') ||
	($uf=='42') ||
	($uf=='41') ||
	($uf=='35') ||
	($uf=='33') ||
	($uf=='32') ||
	($uf=='31') ||
	($uf=='52') ||
	($uf=='51') ||
	($uf=='50') ||
	($uf=='53') ||
	($uf=='17')){
	//esses estados aderem ao horario de versao

	$ano = $data[0].$data[1].$data[2].$data[3];

	//adio de feriados mveis ao calendrio
	$data_procura = data2nr(dataf($data));
	//Pscoa
	//echo ''.$ano;

	$data_pascoa = date("d/m/Y", easter_date($ano));
	list ($dia_pascoa, $mes_pascoa, $ano_pascoa) = explode ("/", $data_pascoa);
	//echo 'Dia pascoa';
	$data_pascoa = fill_full($dia_pascoa,2).'/'.fill_full($mes_pascoa,2).'/'.$ano;
	//echo '<BR>';
	//Domigo de Carnaval
	$dom_carnaval = data2nr($data_pascoa) - 49;

	//echo 'Dom Carnaval'.nr2data($dom_carnaval).'<BR>';

	//terceiro domingo  de agosto
	$dia_outubro = 1;
	for($m = 1; $m <= 15; $m++)
	{
	if(date ("w", mktime (0, 0, 0, 10, $m, $ano)) == 0)
	{
	//soma 14 dias ao primeiro domingo
	$dia_outubro = $m + 14;
	break;
	}
	}
	//echo 'Dom Ago'.$dia_outubro.'/10/'.$ano.'<BR>';

	$dom_outubro = data2nr($dia_outubro.'/10/'.$ano);

	$dia_fevereiro = 1;
	for($m = 1; $m <= 15; $m++)
	{
	if(date ("w", mktime (0, 0, 0, 2, $m, $ano)) == 0)
	{
	//soma 14 dias ao primeiro domingo
	$dia_fevereiro = $m + 14;
	break;
	}
	}

	$dom_fevereiro = data2nr($dia_fevereiro.'/02/'.$ano);

	if($dom_fevereiro == $dom_carnaval){
	$dom_fevereiro+= 7;//proxima semana
	}

	//echo 'data_procura'.nr2data($data_procura).'<BR>'.
	// echo   ';'.nr2data($dom_fevereiro).';'.
	//        ';'.nr2data($dom_outubro).'<BR>';

	$esta_verao = (!(($data_procura>=$dom_fevereiro) &&
	($data_procura<$dom_outubro)));

	}else{
	//os demais no fazem isso
	$esta_verao = false;
	}

	if($esta_verao){
	$fuso_horario--;
	}

	return '-0'.$fuso_horario.':00';

	}*/

	function cfe_busca_ambiente_evento(){
		$retorno = '2';
		$con_serie = 'SELECT NFe_Ambiente FROM nota_fiscal_serie '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' AND Modelo = "59" '.
					' AND Situacao = "A" '.
					' LIMIT 1';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);

		if($reg_serie[0] == '1'){
			$retorno = '1';
		}
		return $retorno;
	}

	function nota_fiscal_busca_ipi_origem($empresa,$nr_nota,$produto){
		$con_origem =  'SELECT Nota_Empresa, Nota_Nr_Nota FROM nota_fiscal_refenciada '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$empresa.'" '.
						' AND Nr_Nota = "'.$nr_nota.'" '.
						' AND ((Tipo_Doc="N") OR (Tipo_Doc="E"))';
		$res_origem = consulta_sql($con_origem);
		$nrw_origem = consulta_num_registros($res_origem);
		$total_ipi = 0;
		for($o=0;$o<$nrw_origem;$o++){
			$reg_origem = consulta_ler_linha($res_origem);

			//consulta item da nota
			$con_item_o =  'SELECT SUM(Quantidade_Estoque) FROM nota_fiscal_item '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND Empresa = "'.$reg_origem[0].'" '.
							' AND Nr_Nota = "'.$reg_origem[1].'" '.
							' AND Id_Produto = "'.$produto.'"';
			$res_item_o = consulta_sql($con_item_o);
			$reg_item_o = consulta_ler_linha($res_item_o);
			consulta_limpa($res_item_o);
			$total_ipi+= $reg_item_o[0];
		}
		consulta_limpa($res_origem);
		return $total_ipi;
	}

	function cfe_copia_arquivo_renomeia($pasta, $origem, $destino){
		$a_origem  = cfe_pasta_raiz().$pasta.'/'.$origem;
		$a_destino = cfe_pasta_raiz().$pasta.'/'.$destino;
		if(file_exists($a_destino)){
			unlink($a_destino);
		}
		//rename($a_origem,$a_destino);
		//echo 'Arquivo:'.$a_origem.'-'.$a_destino;
		copy($a_origem,$a_destino);
	}

	function XML_BuscaTag($xml,$tag,$campo=true){
		if($campo){
			$xml_o = $xml;
			$posI = strpos(' '.$xml,'<'.$tag);
			$xml  = substr($xml, ($posI-1)+(strlen('<'.$tag)) );
			$posI2 = strpos($xml,'/>');
			if($posI2>0){
				$valor = '';
			}else{
				$posI3 = strpos(' '.$xml,'>');
				$xml  = substr($xml,$posI3);

				$posF  = strpos($xml,'</'.$tag.'>');
				$valor = substr($xml,0,$posF);
			}

			/*if($tag=='emit'){
			echo '<textarea rows="10" cols="100">'.
			'$valor:'.$valor.
			'$xml_o:'.$xml.
			'$tag:'.$tag.
			'$posI:'.$posI.
			'$posI2:'.$posI2.
			'$posI4:'.$posI3.
			'$posF:'.$posF.
			'</textarea>';

			} */
		}else{
			$posI = strpos($xml,' '.$tag.'="');
			$xml  = substr($xml,$posI);

			$posI = strpos(' '.$xml,'="');
			$xml  = substr($xml,$posI+1);

			$posF  = strpos($xml,'"');
			$valor = substr($xml,0,$posF);
		}
		return $valor;
	}

	function gzdecodeFree($data,&$filename='',&$error='',$maxlength=null){
		$len = strlen($data);
		if($len < 18 || strcmp(substr($data,0,2),"\x1f\x8b")) {
			$error = "Not in GZIP format.";
			return null;  // Not GZIP format (See RFC 1952)
		}
		$method = ord(substr($data,2,1));  // Compression method
		$flags  = ord(substr($data,3,1));  // Flags
		if($flags & 31 != $flags) {
			$error = "Reserved bits not allowed.";
			return null;
		}
		// NOTE: $mtime may be negative (PHP integer limitations)
		$mtime = unpack("V", substr($data,4,4));
		$mtime = $mtime[1];
		$xfl   = substr($data,8,1);
		$os    = substr($data,8,1);
		$headerlen = 10;
		$extralen  = 0;
		$extra     = "";
		if($flags & 4) {
			// 2-byte length prefixed EXTRA data in header
			if($len - $headerlen - 2 < 8) {
				return false;  // invalid
			}
			$extralen = unpack("v",substr($data,8,2));
			$extralen = $extralen[1];
			if($len - $headerlen - 2 - $extralen < 8) {
				return false;  // invalid
			}
			$extra = substr($data,10,$extralen);
			$headerlen += 2 + $extralen;
		}
		$filenamelen = 0;
		$filename = "";
		if($flags & 8) {
			// C-style string
			if($len - $headerlen - 1 < 8) {
				return false; // invalid
			}
			$filenamelen = strpos(substr($data,$headerlen),chr(0));
			if($filenamelen === false || $len - $headerlen - $filenamelen - 1 < 8) {
				return false; // invalid
			}
			$filename = substr($data,$headerlen,$filenamelen);
			$headerlen += $filenamelen + 1;
		}
		$commentlen = 0;
		$comment = "";
		if($flags & 16) {
			// C-style string COMMENT data in header
			if($len - $headerlen - 1 < 8) {
				return false;    // invalid
			}
			$commentlen = strpos(substr($data,$headerlen),chr(0));
			if($commentlen === false || $len - $headerlen - $commentlen - 1 < 8) {
				return false;    // Invalid header format
			}
			$comment = substr($data,$headerlen,$commentlen);
			$headerlen += $commentlen + 1;
		}
		$headercrc = "";
		if($flags & 2) {
			// 2-bytes (lowest order) of CRC32 on header present
			if($len - $headerlen - 2 < 8) {
				return false;    // invalid
			}
			$calccrc = crc32(substr($data,0,$headerlen)) & 0xffff;
			$headercrc = unpack("v", substr($data,$headerlen,2));
			$headercrc = $headercrc[1];
			if($headercrc != $calccrc) {
				$error = "Header checksum failed.";
				return false;    // Bad header CRC
			}
			$headerlen += 2;
		}
		// GZIP FOOTER
		$datacrc = unpack("V",substr($data,-8,4));
		$datacrc = sprintf('%u',$datacrc[1] & 0xFFFFFFFF);
		$isize = unpack("V",substr($data,-4));
		$isize = $isize[1];
		// decompression:
		$bodylen = $len-$headerlen-8;
		if($bodylen < 1) {
			// IMPLEMENTATION BUG!
			return null;
		}
		$body = substr($data,$headerlen,$bodylen);
		$data = "";
		if($bodylen > 0) {
			switch ($method) {
				case 8:
					// Currently the only supported compression method:
					$data = gzinflate($body,$maxlength);
				break;
				default:
					$error = "Unknown compression method.";
				return false;
			}
		}  // zero-byte body content is allowed
		// Verifiy CRC32
		$crc   = sprintf("%u",crc32($data));
		$crcOK = $crc == $datacrc;
		$lenOK = $isize == strlen($data);
		if(!$lenOK || !$crcOK) {
			$error = ( $lenOK ? '' : 'Length check FAILED. ') . ( $crcOK ? '' : 'Checksum FAILED.');
			return false;
		}
		return $data;
	}

	

?>