<?php
	//Fase 1 - Gerao Arquivo XML da NF-e
	//Fase 2 - Retorno Numero do Lote ou Erro
	//Fase 3 - Retorno Nmero do Recibo ou Erro
	//Fase 4 - Consulta Situao NF-e (caso j no tenha a situao na pasta)
	//Fase 5 - Retorno Consulta Situao (protocolo)
	//Fase 6 - Fechamento da NF-e e Finalizao do Processo como um todo.

	require_once(dirname(__FILE__).'/cfe_arquivos.php');

	function cfe_processa($nr_nota){
		$notas_proc = '';
		//verifica o status da nf gravando no banco o novo status (de  I Iniciado Processo)
		$upd_nota = 'UPDATE nota_fiscal '.
					' SET Situacao="I" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" '.
					' AND Situacao="P"';
		$res_upd = consulta_sql($upd_nota,true,1);
		//se pode fazer nf-e
		if($res_upd == 1){
			$con_nfe = 'select * from nota_fiscal '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Nota="'.$nr_nota.'" ';
			$res_nfe = consulta_sql($con_nfe);
			$reg_nfe = consulta_ler_objeto($res_nfe);
			consulta_limpa($res_nfe);

			if(BuscaParam('NF_DH_SAIDA') != 'V'){ //se no for pra ficar vazio
				if(dataf($reg_nfe->DH_SaidaNota)=='00/00/0000'){ //se estiver vazio
					//coloca a data e hora da saida da nota
					$up_nota_d = 'Update nota_fiscal set '.
					' DH_EntSai = now(), '.
					' DH_SaidaNota = DH_EntSai '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' and Nr_Nota = "'.$nr_nota.'" ';
					$res_nota_d = consulta_sql($up_nota_d,true,1);
				}
			}

			//inicia o processoa do CFe
			return cfe_processa_fase1($nr_nota);
			//return false;
		}else{ //seno
		// exibe erro na tela dezindo que nenhuma nota aberta se encontra na lista selecionada
		cfe_exibe_erro('FRE-001','Nota selecionada no pode ser enviada! Verifique novamente a lista, aparentemente outro usurio j fez o envio desta NF-e!',0);
		return false;
		}
	}

	function cfe_retorna_cfe($nr_nota){
		if($nr_nota != ''){
			//retorna o status dessa nota para "P"
			$upd_nota = 'Update nota_fiscal set'.
				' NFe_Versao_SF="", '.
				' NFe_Situacao="", '.
				' NFe_Lote="", '.
				' NFe_Recibo="", '.
				' NFe_Protocolo="", '.
				' NFe_Protocolo_DH="0000-00-00 00:00:00", '.
				' NFe_Protocolo_Sig="",'.
				' NFe_Protocolo_C="", '.
				' NFe_Protocolo_C_DH="0000-00-00 00:00:00", '.
				' NFe_Protocolo_C_Sig="", '.
				//' NFe_Contigencia_DH="0000-00-00 00:00:00", '.
				//' NFe_Contigencia_Motivo="", '.
				' NFe_Protocolo_Motivo="", '.
				' Situacao="P" '.
				' where Dominio="'.$_SESSION['Dominio'].'"'.
				' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
				' and Nr_Nota="'.$nr_nota.'" '.
				' and Situacao="I"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function cfe_processa_fase1($nr_nota){ //gerao do lote
		cfe_exibe_processamento('1');
		//consulta a nota no banco de dados e gera os arquivos XML na pasta tmp
		$cf_e = cfe_gera_arquivo_cfe($nr_nota);
		//se a chave do cfe no for vazia
		if($cf_e != ''){  //no teve erro no processo de gerao do arquivo
			$cfe_pasta_raiz = cfe_pasta_raiz();
			$arquivo_sucesso = $cfe_pasta_raiz.'retorno/'.$cf_e.'-sat.txt';
		if(file_exists($arquivo_sucesso)){
			$copiou = true;//nnao gera denovo porque ja tem o retorno na pasta
		}else{
			$copiou = cfe_copia_arquivo('tmp','envio',$cf_e.'-sat.xml',$nr_nota);
		}
		if($copiou){ //sem erro na cpia para a pasta envio
			return cfe_processa_fase2($nr_nota);
		}else{
			return false;
		}
		}else{
			return false;
		}
	}

	function cfe_processa_fase2($nr_nota){
		cfe_exibe_processamento('2');

		//consulta dados do CF-e
		$con_nfe = 'SELECT Nr_Nota, DH_Emissao, Modelo, Serie, SubSerie FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		//fica testando at ter o retorno
		$ok = false;
		$cfe_pasta_raiz = cfe_pasta_raiz();
		$arquivo_sucesso = $cfe_pasta_raiz.'retorno/'.$reg_nfe->Nr_Nota.'-sat.txt';
		$arquivo_erro = $cfe_pasta_raiz.'retorno/'.$reg_nfe->Nr_Nota.'-sat-ret.err';

		while(!($ok)){
			set_time_limit(60);
			if((file_exists($arquivo_erro)) || (file_exists($arquivo_sucesso))){
				$ok = true;
				//espera 5 segundos
				sleep(5);
				//avalia se tem arquivo de retorno de erro

				//$ano_mes = cfe_ano_mes($reg_nfe->DH_Emissao);
				if(file_exists($arquivo_sucesso)){
					$arquivo = $reg_nfe->Nr_Nota.'-sat.txt';
					$conteudo_arquivo = cfe_abre_arquivo_succ($arquivo);

					$sat = explode('|', $conteudo_arquivo);

					$numeroSessao = $sat[0];
					$EEEEE = $sat[1];
					$CCCC = $sat[2];
					$mensagem = $sat[3];
					$cod = $sat[4];
					$mensagemSEFAZ = $sat[5];
					$arquivoCFeBase64 = $sat[6];
					$timeStamp = $sat[7];
					$chaveConsulta = substr($sat[8], 3);
					$valorTotalCFe = $sat[9];
					$CPFCNPJValue = $sat[10];
					$assinaturaQRCODE = $sat[11];
					$NrDoc = substr($chaveConsulta, 31, 6);

					$timestamp_format = $timeStamp[0].$timeStamp[1].$timeStamp[2].$timeStamp[3].'-'.
					$timeStamp[4].$timeStamp[5].'-'.
					$timeStamp[6].$timeStamp[7].' '.
					$timeStamp[8].$timeStamp[9].':'.
					$timeStamp[10].$timeStamp[11].':'.
					$timeStamp[12].$timeStamp[13];
					$ano_mes = cfe_ano_mes($timestamp_format);   

					$ok = ($EEEEE == '06000');

					if($ok){
						cfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes, $arquivo, $nr_nota, true);
						//2017-09-27 16:31:45
						//20170927163145                  
						ignore_user_abort(true);
						$con_serie = 'SELECT NFe_Ambiente, NFe_TipoEmissao, NFe_FormatoDANFe FROM nota_fiscal_serie '.
									' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Modelo="'.$reg_nfe->Modelo.'"'.
									' AND Serie="'.$reg_nfe->Serie.'"'.
									' AND SubSerie="'.$reg_nfe->SubSerie.'"';
						$res_serie = consulta_sql($con_serie);
						$reg_serie = consulta_ler_linha($res_serie);
						consulta_limpa($res_serie);

						$ambiente = $reg_serie[0];
						$cfe_tipoemissao = $reg_serie[1];
						$cfe_formatodanfe = $reg_serie[2];
						$versao_cfe = config_pad('cfe_versao');

						$upd_nota = 'UPDATE nota_fiscal SET'.
									' NrDoc="'.$NrDoc.'", '.
									' DH_Emissao="'.$timestamp_format.'", '.
									' DH_EntSai="'.$timestamp_format.'", '.
									' NFe_Protocolo_DH="'.$timestamp_format.'", '.
									' NFe_Chave="'.$chaveConsulta.'", '.
									' NFe_Ambiente="'.$ambiente.'", '.
									' NFe_TipoEmissao="'.$cfe_tipoemissao.'", '.
									' NFe_FormatoDANFe="'.$cfe_formatodanfe.'", '.
									' NFe_Versao="'.$versao_cfe.'", '.
									' NFe_Situacao="100" '.
									' WHERE Dominio ="'.$_SESSION['Dominio'].'" '.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
									' AND Nr_Nota="'.$nr_nota.'" '.
									' AND Situacao="I"';
						consulta_sql($upd_nota,true,1);

						$arquivo_aut_caminho = $cfe_pasta_raiz.'SEFAZ/CF-es/'.$ano_mes.'/Autorizados';
						$arquivo_aut = $chaveConsulta.'-CFe.xml';
						$arquivo_aut_conteudo = base64_decode_si($arquivoCFeBase64);

						rmkdir($arquivo_aut_caminho);

						$Handle = fopen($arquivo_aut_caminho.'/'.$arquivo_aut, 'w');
						$Data = $arquivo_aut_conteudo;
						fwrite($Handle, utf8_encode_si($Data));
						fclose($Handle);

						return cfe_processa_fase3($nr_nota);
					}else{
						$ano_mes = cfe_ano_mes();
						cfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes, $arquivo, $nr_nota, true);

						cfe_exibe_erro('FRE-003','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat.txt"!'.
						$conteudo_arquivo, $nr_nota);
						return false;
					}
				}else if(file_exists($arquivo_erro)){
					$ano_mes = cfe_ano_mes();
					$arquivo = $reg_nfe->Nr_Nota.'-sat-ret.err';
					$conteudo_arquivo = cfe_abre_arquivo_err($arquivo);
					cfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes, $arquivo, $nr_nota, true);

					cfe_exibe_erro('FRE-002','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat.txt"!'.
					$conteudo_arquivo, $nr_nota);
					return false;
				}else{
					cfe_exibe_erro('FRE-103','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat.txt"!','');
					return false;
				}
			}
		}
	}

	function cfe_processa_fase3($nr_nota){
		$desc_cfe = 'Autorizado';
		$status_cfe = 'F';

		cfe_exibe_processamento('3', $desc_cfe);

		$upd_nota = 'UPDATE nota_fiscal SET'.
					' Situacao="'.$status_cfe.'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'" '.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
					' AND Nr_Nota="'.$nr_nota.'" '.
					' AND Situacao="I" ';
		$res_nota = consulta_sql($upd_nota,true,1);
		if($res_nota == 1){
			gera_mov_saida($_SESSION["Empresa_Codigo"], $nr_nota, 'F');
			nota_fiscal_mov_estoque($nr_nota,'F');
			nota_fiscal_gera_contas($nr_nota);
			nota_fiscal_estoque_reserva($nr_nota,'F');
			//gera_estoque_romaneio($_SESSION["Empresa_Codigo"],$nr_nota,'F');
			nota_fiscal_associa_dav($nr_nota);
			devolucao_pedido($nr_nota,'-');
			nota_fiscal_gera_pedido_devolucao($nr_nota);

			$con_nota = 'select * from nota_fiscal '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Nota ="'.$nr_nota.'"';
			$res_nota = consulta_sql($con_nota);
			$reg_nota = consulta_ler_objeto($res_nota);
			consulta_limpa($res_nota);

			//adicionada funo para add em pessoa a data da Ultima venda
			nota_fiscal_atualiza_data_ultima_venda( $reg_nota->DH_EntSai , $reg_nota->Destinatario,  $reg_nota->Vendedor , $reg_nota->Modelo, $reg_nota->Nat_Op_Gera_Contas,  $reg_nota->Empresa , $nr_nota );

			if ($reg_nota->Modelo=='59'){
				//consulta as parcelas a vista
				$data_baixa = data_atual('date');

				//consulta valor de parcelas caso tenha alguma
				$con_parcelas = 'select * from nota_fiscal_parcela '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								' and Nr_Nota = "'.$nr_nota.'"'.
								' and Parcela>0 '. //parcela zero(parte a vista do cupom no vai gerar nada)
								' and DT_Vencimento <="'.data_atual('date').'" '. //parcela zero(parte a vista do cupom no vai gerar nada)
								' order by Parcela';
				$res_parcelas = consulta_sql($con_parcelas);
				$nrw_parcelas = consulta_num_registros($res_parcelas);
				for($p=0;$p<$nrw_parcelas;$p++){
					$reg_parcelas = consulta_ler_objeto($res_parcelas);
					//cria cada parcela conforme cada vencto
					//echo $reg_parcelas->Nr_Contas.'-';
					financeiro_baixa_conta($_SESSION['Empresa_Codigo'], $reg_parcelas->Nr_Contas, 1, //chave da tabela
											$_SESSION['Empresa_Codigo'], $data_baixa, $data_baixa, //empresa e data do caixa
											0, 0, $reg_parcelas->Valor_Parcela, //descontos e acrescimos (o valor totla  o valor com o valor do acerscimo e do esconto automtico)
											0, 'S', //jusros usado na baixa
											0, 0, //pontualizade e prodtesto
											0, '', 0, 0, '', //dados do meio de pagamaneto
											'', '','',//$obs_caixa,
											'', 0, true);
					$upd_forma = 'UPDATE contas_pr set'.  //fechamento automatico  em dinheiro
								' Finalizadora = "1"'.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
								' and Nr_Contas="'.$reg_parcelas->Nr_Contas.'"'.
								' and Seq="1"';
					consulta_sql($upd_forma);
				}
				consulta_limpa($res_parcelas);

			}


			return true;
		}else{
			cfe_exibe_erro('FRE-004','Falha no Fechamento da Nota!', $nr_nota);
			return false;
		}
	}


	function cfe_cancela($nr_nota){
		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);      

		$cfe_pasta_raiz = cfe_pasta_raiz();
		if ($reg_nfe->Situacao!='F'){
			return true;
		}else{
			$cf_e = cfe_gera_arquivo_cancela($nr_nota);
			if($cf_e){
				$arquivo_cancelamento = $reg_nfe->Nr_Nota.'-sat-canc.xml';
				$copiou = cfe_copia_arquivo('tmp','envio',$arquivo_cancelamento,$nr_nota);

				if($copiou){
					$ok = false;
					$arquivo_sucesso = $cfe_pasta_raiz.'retorno/'.$reg_nfe->Nr_Nota.'-sat-canc.txt';
					//$arquivo_erro = $cfe_pasta_raiz.'retorno/'.$reg_nfe->Nr_Nota.'-sit-canc-ret.err';
					$arquivo_erro = $cfe_pasta_raiz.'retorno/'.$reg_nfe->Nr_Nota.'-sat-canc.err';
					//$ok = true;
					while(!($ok)){
						set_time_limit(60);
						if((file_exists($arquivo_sucesso)) || (file_exists($arquivo_erro))){
							$ok = true;
							sleep(5);

							if(file_exists($arquivo_sucesso)){
								$arquivo = $reg_nfe->Nr_Nota.'-sat-canc.txt';
								$conteudo_arquivo = cfe_abre_arquivo_succ($arquivo);

								$sat = explode('|', $conteudo_arquivo);

								$numeroSessao = $sat[0];
								$EEEEE = $sat[1];
								$CCCC = $sat[2];
								$mensagem = $sat[3];
								$cod = $sat[4];
								$mensagemSEFAZ = $sat[5];
								$arquivoCFeBase64 = $sat[6];
								$timeStamp = $sat[7];
								$chaveConsulta = substr($sat[8], 3);
								$valorTotalCFe = $sat[9];
								$CPFCNPJValue = $sat[10];
								$assinaturaQRCODE = $sat[11];
								$NrDoc = substr($chaveConsulta, 31, 6);

								$timestamp_format = $timeStamp[0].$timeStamp[1].$timeStamp[2].$timeStamp[3].'-'.
								$timeStamp[4].$timeStamp[5].'-'.
								$timeStamp[6].$timeStamp[7].' '.
								$timeStamp[8].$timeStamp[9].':'.
								$timeStamp[10].$timeStamp[11].':'.
								$timeStamp[12].$timeStamp[13];
								$ano_mes = cfe_ano_mes($timestamp_format);                     

								$ok = ($EEEEE == '07000');

								if($ok){
									cfe_copia_arquivo('retorno','SEFAZ/Cancelamento/'.$ano_mes, $arquivo, $nr_nota, true);                        

									$arquivo_canc_conteudo = base64_decode_si($arquivoCFeBase64);

									$arquivo_canc_caminho = $cfe_pasta_raiz.'SEFAZ/CF-es/'.$ano_mes.'/Cancelados';

									$posi = strpos($arquivo_canc_conteudo, 'chCanc') + 11;
									$chave = substr($arquivo_canc_conteudo, $posi, 44);

									$arquivo_canc = $chave.'-CFe-canc.xml';

									rmkdir($arquivo_canc_caminho);

									$Handle = fopen($arquivo_canc_caminho.'/'.$arquivo_canc, 'w');
									$Data = $arquivo_canc_conteudo;
									fwrite($Handle, utf8_encode_si($Data));
									fclose($Handle);

									$upd_nota = 'UPDATE nota_fiscal SET'.                                   
												' NFe_Situacao="135" '.
												' WHERE Dominio ="'.$_SESSION['Dominio'].'" '.
												' AND Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
												' AND Nr_Nota="'.$nr_nota.'" '.
												' AND Situacao="F"';
									$res_nota = consulta_sql($upd_nota,true,1);                        
									if($res_nota == 1){
										return true;
									}else{
										cfe_exibe_erro('FRE-014','Falha no Cancelamento do CF-e!', $nr_nota);
										return false;
									}
								}else{
									$ano_mes = cfe_ano_mes();
									cfe_copia_arquivo('retorno','SEFAZ/Cancelamento/'.$ano_mes, $arquivo, $nr_nota, true);

									cfe_exibe_erro('FRE-003','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat-canc.txt"!'.
									$conteudo_arquivo, $nr_nota);
									return false;
								}
							}else if(file_exists($arquivo_erro)){
								$ano_mes = cfe_ano_mes();
								$arquivo = $reg_nfe->Nr_Nota.'-sat-canc.err';
								$conteudo_arquivo = cfe_abre_arquivo_err($arquivo);
								cfe_copia_arquivo('retorno','SEFAZ/Cancelamento/'.$ano_mes, $arquivo, $nr_nota, true);

								cfe_exibe_erro('FRE-002','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat.txt"!'.
								$conteudo_arquivo, $nr_nota);
								return false;
							}else{
								cfe_exibe_erro('FRE-103','Falha no Processamento do Arquivo "'.$reg_nfe->Nr_Nota.'-sat-canc.txt"!','');
								return false;
							}
						}
					}
				}else{
					//cfe_exibe_erro('FRE-101','Falha no Processamento do Arquivo "'.$reg_nota->Nr_Nota.'-sat-canc.xml"!','');
					return false;
				}

			}else{
				return false;
			}
		}
		//return $cf_e;
	}
?>