<?
	require_once(dirname(__FILE__).'/ie.php');

	function cte_ano_mes($data='',$tipo='AAAAMM'){  //formato 0000-00-00
		if ($data==''){
			$data = data_atual('date');
		}
		if ($tipo=='AAAAMM'){
			return $data[0].$data[1].
					$data[2].$data[3].
					$data[5].$data[6];
		}else{
			return $data[2].$data[3].
					$data[5].$data[6];
		}
	}

	function cte_modulo11($nr_original){
		$soma = 0;
		$k= 2;
		for ($i=strlen($nr_original);$i>0;$i--){
			$soma+= ($nr_original[$i-1] * $k);
			$k++;
			if ($k>9){
				$k = 2;
			}
		}
		$digito = 11 - ($soma%11);
		if ($digito >= 10){
			$digito = 0;
		}
		return $digito;
	}

	function cte_retira_texto_excesso($texto,$inicio,$tamanho_max){
		//descobre quantos carates < > " ' & existem no texto
		// o limite vai ser menor se existirem esses caracteres
		//por que no xml eles ocupam mais do que uma posio
		//primeiro tira os primeiros $tamanjho de caracteres caracteres)
		$texto = trim(substr(trim($texto),$inicio,$tamanho_max));
		$texto_final = '';
		//$conta_menor = substr_count($texto_final,'>');
		$tamanho  = strlen($texto);
		$tamanho_total = 0;
		for ($t=0;$t<$tamanho;$t++){
			$tamanho_car = 1;
			if (($texto[$t]=='<')||($texto[$t]=='>')){
				$tamanho_car = 4;
			}else if (($texto[$t]=='"')||($texto[$t]=="'")){
				$tamanho_car = 6;
			}else if ($texto[$t]=='&'){
				$tamanho_car = 5;
			}
			$tamanho_total+=$tamanho_car;
			if ($tamanho_total<=$tamanho_max){
				$texto_final.= $texto[$t];
			}
		}
		return trim($texto_final);
	}

	function cte_copia_arquivo($origem,$destino,$arquivo,$nr_nota='',$renomeia=false,$apaga=true){
		//determina nome do arquivo de origem
		$arq_ori = cte_pasta_raiz().$origem.'/'.$arquivo;

		//determina nome do arquivo de destino
		$arq_des = cte_pasta_raiz().$destino.'/'.$arquivo;
		//se renomeia
		if ($renomeia){
			//arquivo de destino  com a data/hora no incio do mesmo
			$data_hora = data_atual('date').nr2hora(hora_atual());
			$data_hora = str_replace('-','',$data_hora);
			$data_hora = str_replace(':','',$data_hora);
			$arq_des = cte_pasta_raiz().$destino.'/'.$data_hora.'_'.$arquivo;
		}
		//verifica se arquivo de origem existe
		if (file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if (!(file_exists(cte_pasta_raiz().$destino))){
				//seno cria ela (ano_mes)
				rmkdir(cte_pasta_raiz().$destino."/",0777);
			}
			//verifica se destino existe
			if (file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if ($copiou){
				//se a instruo for de apagar o arquivo de origem
				if ($apaga){
					//apaga o arquivo de origem
					unlink($arq_ori);
				}
				return true;
			}else{
				cte_exibe_erro('FRE-004',
								'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',
								$nr_nota);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			cte_exibe_erro('FRE-003',
							'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
								'Verifique a estrutura de pastas do servidor!',
							$nr_nota);
			return false;
		}
	}

	function cte_abre_arquivo_err($arquivo){
		//abre arquivo de erro na pasta de retorno
		$temp_file = cte_pasta_raiz().'temp_xml/'.$arquivo;
		$arq_base  = cte_pasta_raiz().'retorno/'.$arquivo;
		sleep(1);

		if (file_exists($temp_file)){
			unlink($temp_file);
		}
		//echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
		copy($arq_base, $temp_file);
		$linhas_erro = '';
		$array_of_list_values = file($temp_file);
		foreach ($array_of_list_values as $key => $value){
			set_time_limit(30);
			$linhas_erro.= $value;
		}
		unset($array_of_list_values);
		unlink($temp_file);
		//le todo o contedo da pasta
		return nl2br($linhas_erro);
	}

	function cte_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ct_e/'.$_SESSION["Empresa_Codigo"].'/';
	}

	// function nfe_pasta_raiz(){
	// 	return cte_pasta_raiz();
	// }
	
	function cte_pasta_raiz2($dominio,$empresa){
		return '../arquivos_clientes/'.$dominio.'/ct_e/'.$empresa.'/';
	}

	function cte_pasta_raiz3(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/';
	}

	function ct_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ct/'.$_SESSION["Empresa_Codigo"].'/';
	}

	function cte_busca_arquivo($nr_nota,$tipo="xml"){
		$con_nfe = 'SELECT DH_Emissao,CTe_Protocolo,CTe_Versao FROM nota_frete '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		if($tipo == "pdf"){
			$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Dacte/';
			$nm_arq = $reg_nfe->CTe_Protocolo.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.pdf';
			$cte_pdf_caminho=$url_arq;
			if(!is_dir($cte_pdf_caminho)){
				rmkdir($cte_pdf_caminho);
			}
		}else{
			$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Autorizados/';
			$nm_arq = $reg_nfe->CTe_Protocolo.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.xml';
		}
		$url_arq.=$nm_arq;
		return $url_arq;
	}

	function cte_busca_arquivo_cancela($nr_nota){
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$versao = $reg_nfe->CTe_Versao;
		if($versao=='1.10'){
			$versao = '1.07';
		}
		if (($reg_nfe->CTe_Situacao=='101')||($reg_nfe->CTe_Situacao=='151')){
			$nm_arq = $reg_nfe->CTe_Protocolo_C.'_v'.fill_full($versao,5).'-procCancCTe.xml';
			$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Canceladas/'.$nm_arq;
		}else if (($reg_nfe->CTe_Situacao=='135')||($reg_nfe->CTe_Situacao=='136')||($reg_nfe->CTe_Situacao=='155')){
			$nm_arq = $reg_nfe->CTe_Protocolo_C.'_v'.fill_full('2.00',5).'-procEventoCTe.xml';
			$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Canceladas/'.$nm_arq;
		}else{
			$url_arq = '';
		}
		return $url_arq;
	}

	function cte_busca_arquivo_inutiliza($nr_nota){
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$versao = $reg_nfe->CTe_Versao;
		if($versao=='1.10'){
			$versao = '1.07';
		}
		if ($reg_nfe->CTe_Situacao=='102'){
			$nm_arq = $reg_nfe->CTe_Protocolo_C.'_v'.fill_full($versao,5).'-procInutCTe.xml';
			$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_nfe->Cancela_DH,'AAAAMM').'/Inutilizadas/'.$nm_arq;
		}else{
			$url_arq = '';
		}
		return $url_arq;
	}

	function cte_busca_arquivo_cce($nr_nota,$evento='',$tipo = "xml"){
		$con_evento =  'SELECT * from nota_frete_evento '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Conhec="'.$nr_nota.'" ';
		if ($evento==''){
			$con_evento.=  ' and Situacao="F" order by Seq_Evento DESC limit 1';
		}else{
			$con_evento.=  ' and Seq_Evento="'.$evento.'"';
		}
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		if ($reg_evento->CCe_Protocolo!=''){
			if($tipo == "xml"){
				$nm_arq = $reg_evento->CCe_Protocolo.'_v'.fill_full($reg_evento->Versao_Evento,5).'-procEventoCTe.xml';
				$url_arq = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_evento->DH_Evento,'AAAAMM').'/CCe/'.$nm_arq;
			}else{
				$nfe_pdf_caminho = cte_pasta_raiz().'SEFAZ/CT-es/'.cte_ano_mes($reg_evento->DH_Evento,'AAAAMM').'/Dacte/';
				if(!is_dir($nfe_pdf_caminho)){
					rmkdir($nfe_pdf_caminho);
				}
				$nm_arq = $reg_evento->CCe_Protocolo.'_v'.fill_full($reg_evento->Versao_Evento,5).'-procEventoCTe.pdf';
				$url_arq = $nfe_pdf_caminho.$nm_arq;
			}
		}else{
			$url_arq = '';
		}
		return $url_arq;
	}

	function cte_exibe_erro($codigo,$mensagem,$nr_nota){
		//exibe o erro na tela
		echo '<p><font size="2" face="Verdana"><b>'.$codigo.'</b><BR>'.$mensagem.'</font></p><BR><BR>';
		//retorna o status dessa nota para "P"
		cte_retorna_cte($nr_nota);
	}

	function cte_exibe_processamento($fase,$cmpl=''){
		//exibe o erro na tela
		if ($fase == '1'){
			echo '<p><font size="2" face="Verdana">Gerando Arquivo de CT-e... (1/6)</font></p>';
		}
		if ($fase == '2'){
			echo '<p><font size="2" face="Verdana">Validando e Assinando Arquivo XML... (2/6)</font></p>';
		}
		if ($fase == '3'){
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML... (3/6)</font></p>';
		}
		if ($fase == '4'){
			$tentativa = '';
			if ($cmpl>1){
				$tentativa = '(Tentativa '.$cmpl.')';
			}
			echo '<p><font size="2" face="Verdana">Verificando Autorizao de Uso...'.$tentativa.' (4/6)</font></p>';
		}
		if ($fase == '5'){
			echo '<p><font size="2" face="Verdana">Fechando Documento... (5/6)</font></p>';
		}
		if ($fase == '6'){
			echo '<p><font size="2" face="Verdana">CT-e '.$cmpl.'! (6/6)</font></p>';
		}
		if ($fase == 'R'){
			echo '<p><font size="2" face="Verdana">Reprocessando o CT-e!</font></p>';
		}
		if ($fase == 'C1'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' de CT!</font></p>';
		}
		if ($fase == 'C2_A'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML de '.$operacao.'...</font></p>';
		}
		if ($fase == 'C2_B'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
				$artigo = 'a';
			}else{
				$operacao = 'Cancelamento';
				$artigo = 'o';
			}
			echo '<p><font size="2" face="Verdana">'.$operacao.' de CT Homologado!</font></p>';
		}
		if ($fase == 'C3'){
			echo '<p><font size="2" face="Verdana">Retornando Estoque do Produto...</font></p>';
		}
		if ($fase == 'C4'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos CTs Referenciados...</font></p>';
		}
		if ($fase == 'C5'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos '.busca_nome_pedido_orc().'s Referenciados...</font></p>';
		}
		if ($fase == 'C6'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins Referenciados...</font></p>';
		}
		if ($fase == 'C6_B'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins de Resduos Referenciados...</font></p>';
		}
		if ($fase == 'C7_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo Contas...</font></p>';
		}
		if ($fase == 'C7'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizado';
			}else{
				$operacao = 'Cancelado';
			}
			echo '<p><font size="2" face="Verdana">Conhecimento de Frete '.$operacao.' com Sucesso!</font></p>';
		}
		if ($fase == 'FS-DA'){
			echo '<p><font size="2" face="Verdana">CT-es validados com sucesso! Formulrio de Segurana Autorizado!</font></p>';
		}
		if ($fase == 'C8_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo a Conta...</font></p>';
		}
		if ($fase == 'C1_G'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' da Conta!</font></p>';
		}
		if ($fase == 'C7_G'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizada';
			}else{
				$operacao = 'Cancelada';
			}
			echo '<p><font size="2" face="Verdana">A Conta foi '.$operacao.' com Sucesso!</font></p>';
		}
		flush(); @ob_flush();
		flush(); @ob_flush();
	}

	function cte_formata_txt($texto){
		$texto2='';
		$texto1 = strtr(trim($texto), array(";" => ':', "  " => ' ', "'" => '', '"' => '', '' => '-'));
		$texto1 = strtr(trim($texto1), array("\r\n" => ';', "\r" => ';', "\n" => ';'));
		while ($texto1!=$texto2){
			$texto2 = $texto1;
			$texto1 = strtr(trim($texto1), array("  " => ' ', ";;" => ';'));
		}
		return $texto1;
	}

		/*function rmkdir($path, $mode = 0777) {
		$path = rtrim(preg_replace(array("/\\\\/", "/\/{2,}/"), "/", $path), "/");
		$e = explode("/", ltrim($path, "/"));
		if(substr($path, 0, 1) == "/") {
		$e[0] = "/".$e[0];
		}
		$c = count($e);
		$cp = $e[0];
		for($i = 1; $i < $c; $i++) {
		if(!is_dir($cp) && !@mkdir($cp, $mode)) {
		return false;
		}
		$cp .= "/".$e[$i];
		}
		return @mkdir($path, $mode);
		}*/

	function cte_gera_chave($reg_nfe,$modalidade=0){
		//consulta srie da NF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie = 'select CTe_Ambiente,CTe_TipoEmissao,CTe_FormatoDACTe '.
					' from nota_frete_serie '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Modelo="'.$reg_nfe->Modelo.'"'.
					' and Serie="'.$reg_nfe->Serie.'"'.
					' and SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		//gera chave de acesso  NF-e (caso ainda no possua)
		//so 44 dgitos
		// 02 cdigo UF do emitente
		// 04 ano mes de emisso
		// 14 cnpj emitente
		// 02 Modelo (55)
		// 03 serie
		// 09 nr documento
		// 01 forma emisso
		// 08 aleatrio
		// 01 digitos Mod 11
		if ($modalidade=='5'){
			$reg_serie[1] = $modalidade;
		}
		//pega uf da empresa e consulta cadastro pra saber o numero de referencia
		$con_uf = 'select Codigo_UF from uf '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and UF="'.$reg_nfe->Empresa_UF.'"';
		$res_uf = consulta_sql($con_uf);
		$reg_uf = consulta_ler_linha($res_uf);
		consulta_limpa($res_uf);
		$ano_mes = cte_ano_mes($reg_nfe->DH_Emissao,'AAMM');
		$cnpj    = limpa_numero($reg_nfe->Empresa_CNPJ);
		$serie   = limpa_numero($reg_nfe->Serie);
		$nr_random = '';
		$chave_ok = false;
		while (!$chave_ok){
			$nr_random = fill_full(rand(10, 999), 4).
			fill_full(rand(100,5999),4);
			$chave_ok = ($nr_random!='00000000') && ($nr_random!='11111111') &&
						($nr_random!='22222222') && ($nr_random!='33333333') &&
						($nr_random!='44444444') && ($nr_random!='55555555') &&
						($nr_random!='66666666') && ($nr_random!='77777777') &&
						($nr_random!='88888888') && ($nr_random!='99999999') &&
						($nr_random!='12345678') && ($nr_random!='23456789') &&
						($nr_random!='34567890') && ($nr_random!='45678901') &&
						($nr_random!='56789012') && ($nr_random!='67890123') &&
						($nr_random!='78901234') && ($nr_random!='89012345') &&
						($nr_random!='90123456') && ($nr_random!='01234567');
		}
		$chave_nfe = fill_full($reg_uf[0],2).$ano_mes.
		fill_full($cnpj,14).fill_full($reg_nfe->Modelo,2).
		fill_full($serie,3).fill_full($reg_nfe->NrDoc,9).
		fill_full($reg_serie[1],1).$nr_random;
		$dig_nfe = cte_modulo11($chave_nfe);
		$chave_nfe.= $dig_nfe;
		$upd_nota = 'Update nota_frete set'.
					' CTe_Chave="'.$chave_nfe.'",'.
					' CTe_Ambiente="'.$reg_serie[0].'", '.
					' CTe_TipoEmissao="'.$reg_serie[1].'", '.
					' CTe_FormatoDANFe="1", '.
					' CTe_Versao="'.config_pad('cte_versao').'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$reg_nfe->Nr_Conhec.'" '.
					' and CTe_Chave=""';
		consulta_sql($upd_nota,true,1);
		//consulta ultimo registro dessa modalidade de contingencia <> 1
		//dh contingencia e motivo
		if ($reg_serie[1]!='1'){
			$con_cont = 'select * from nota_frete_contingencia'.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Modalidade="'.$reg_serie[1].'"'.
						' order by DH_Inicio desc';
			$res_cont = consulta_sql($con_cont);
			$reg_cont = consulta_ler_objeto($res_cont);
			consulta_limpa($res_cont);
			$upd_nota = 'Update nota_frete set'.
						' CTe_Contigencia_DH="'.$reg_cont->DH_Inicio.'", '.
						' CTe_Contigencia_Motivo="'.$reg_cont->Motivo.'" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Conhec="'.$reg_nfe->Nr_Conhec.'" '.
						' and Situacao="I"'.
						' and CTe_Contigencia_DH="0000-00-00 00:00:00"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function ct_gera_chave($reg_nfe){
		//consulta srie da NF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie = 'select Layout_Impressao '.
					' from nota_frete_serie '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Modelo="'.$reg_nfe->Modelo.'"'.
					' and Serie="'.$reg_nfe->Serie.'"'.
					' and SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		$upd_nota = 'Update nota_frete set'.
					' Layout_Impressao="'.$reg_serie[0].'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$reg_nfe->Nr_Conhec.'" '.
					' and ( (Situacao="A")'.
					'    or (Situacao="P") )';
		consulta_sql($upd_nota,true,1);
	}

	function cte_numero($valor,$qtd_zeros=2){
		$valor = (($valor + 1) - 1);
		$valor = number_format($valor,$qtd_zeros,".","");
		return $valor;
	}

	function cte_valida_dados_cte($nr_nota){
		///valida minimamente os dados da NF-e para minimizar Rejeies na SEFAZ
		$erros = '';
		//conuslta Nota Fiscal
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//validao emitente
		//CNPJ
		//if(strlen($reg_nfe->Empresa_CNPJ)<18){
		//    $erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da empresa  invlido!';
		//}
		//vlidar o CNPJ (funo)
		if(!CalculaCNPJ($reg_nfe->Empresa_CNPJ)){
			$erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da Empresa  invlido!';
		}
		//nome
		if(strlen($reg_nfe->Empresa_Razao)<3){
			$erros.='<BR>A Razo Social "'.$reg_nfe->Empresa_Razao.'" da empresa  invlida!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Empresa_Fantasia!='')&&(strlen($reg_nfe->Empresa_Fantasia)<3)){
			$erros.='<BR>O nome fantasia da Empresa  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Empresa_Logradouro)<3){
			$erros.='<BR>O logradouro da Empresa  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Empresa_Bairro)<3){
			$erros.='<BR>O bairro da Empresa  invlido!';
		}
		//CEP
		if(($reg_nfe->Empresa_CEP!='')&&(strlen($reg_nfe->Empresa_CEP)<9)){
			$erros.='<BR>O CEP "'.$reg_nfe->Empresa_CEP.'" da Empresa  invlido!';
		}
		//cidade nome
		if(strlen($reg_nfe->Empresa_Nome_Cidade)<3){
			$erros.='<BR>O nome de cidade da Empresa  invlido!';
		}
		//Cidade nr
		if(($reg_nfe->Empresa_Codigo_Cidade<=0)&&(strlen($reg_nfe->Empresa_Codigo_Cidade)>7)){ //1000000
			$erros.='<BR>O cdigo de cidade da Empresa  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Empresa_Nome_Pais)<3){
			$erros.='<BR>O nome de pas da Empresa  invlido!';
		}
		//pais nr
		if($reg_nfe->Empresa_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas da Empresa  invlido!';
		}
		//telefone
		if(strlen($reg_nfe->Empresa_Telefone_Nr)<14){
			$erros.='<BR>O telefone "'.$reg_nfe->Empresa_Telefone_Nr.'" da Empresa  invlido!';
		}
		//UF
		if(strlen($reg_nfe->Empresa_UF)<2){
			$erros.='<BR>A UF da Empresa  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Empresa_Insc_Estadual) != ''){
			if (strtoupper($reg_nfe->Empresa_Insc_Estadual) != 'ISENTO'){
				if (!(ChkInscEstadual($reg_nfe->Empresa_Insc_Estadual, $reg_nfe->Empresa_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" da Empresa  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}
		if(strlen(limpa_numero($reg_nfe->Rodo_Registro_ANTT))!=8){
			$erros.='<BR>O Registro RNTRC do Emitente  invlido!';
		}
		//validao emitente
		//CNPJ
		if($reg_nfe->Rem_UF!='EX'){  //no valida caso seja estrangeiro
			if(strlen($reg_nfe->Rem_CPF_CNPJ)==14){
				if(!CalculaCPF($reg_nfe->Rem_CPF_CNPJ)){
					$erros.='<BR>O CPF "'.$reg_nfe->Dest_CPF_CNPJ.'" do Remetente  invlido!';
				}
			}else if(strlen($reg_nfe->Rem_CPF_CNPJ)==18){
				if(!CalculaCNPJ($reg_nfe->Rem_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Remetente  invlido!';
				}
			}else{
				$erros.='<BR>O CNPJ "'.$reg_nfe->Rem_CPF_CNPJ.'" do Remetente  invlido!';
			}
		}
		//nome
		if(strlen($reg_nfe->Rem_Razao)<3){
			$erros.='<BR>O razo social do Remetente  invlido!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Rem_Fantasia!='')&&(strlen($reg_nfe->Rem_Fantasia)<3)){
			$erros.='<BR>O nome fantasia do Remetente  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Rem_Logradouro)<3){
			$erros.='<BR>O logradouro do Remetente  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Rem_Bairro)<3){
			$erros.='<BR>O bairro do Remetente  invlido!';
		}
		//CEP
		//if(strlen($reg_nfe->Dest_UF)!='EX'){
		//    if(strlen($reg_nfe->Dest_CEP)<9){
		//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Cliente/Fornecedor  invlido!';
		//    }
		//}
		//cidade nome
		if(strlen($reg_nfe->Rem_Nome_Cidade)<3){
			$erros.='<BR>O nome de cidade do Remetente  invlido!';
		}
		//Cidade nr
		if($reg_nfe->Rem_Codigo_Cidade<=0){
			$erros.='<BR>O cdigo de cidade do Remtente  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Rem_Nome_Pais)<3){
			$erros.='<BR>O nome de pas do Remetente  invlido!';
		}
		//pais nr
		if($reg_nfe->Rem_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas do Remetente  invlido!';
		}
		/*
		//telefone
		if(strlen($reg_nfe->Rem_Telefone_Nr)<14){
		$erros.='<BR>O telefone "'.$reg_nfe->Dest_Telefone_Nr.'" do Cliente/Fornecedor  invlido!';
		}*/
		//UF
		if(strlen($reg_nfe->Rem_UF)<2){
			$erros.='<BR>A UF do Remetente  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Rem_Insc_Estadual) != ''){
			if (strtoupper($reg_nfe->Rem_Insc_Estadual) != 'ISENTO'){
				if (!(ChkInscEstadual($reg_nfe->Rem_Insc_Estadual, $reg_nfe->Rem_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Rem_Insc_Estadual.'" do Remetente  invlida para "'.$reg_nfe->Rem_UF.'"!';
				}
			}
		}
		//validao destinatrio
		//CNPJ
		if($reg_nfe->Dest_UF!='EX'){  //no valida caso seja estrangeiro
			if(strlen($reg_nfe->Dest_CPF_CNPJ)==14){
				if(!CalculaCPF($reg_nfe->Dest_CPF_CNPJ)){
					$erros.='<BR>O CPF "'.$reg_nfe->Dest_CPF_CNPJ.'" do Destinatrio  invlido!';
				}
			}else if(strlen($reg_nfe->Dest_CPF_CNPJ)==18){
				if(!CalculaCNPJ($reg_nfe->Dest_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Destinatrio  invlido!';
				}
			}else{
				$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Destinatrio  invlido!';
			}
		}
		//nome
		if(strlen($reg_nfe->Dest_Razao)<3){
			$erros.='<BR>O razo social do Destinatrio  invlido!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Dest_Fantasia!='')&&(strlen($reg_nfe->Dest_Fantasia)<3)){
			$erros.='<BR>O nome fantasia do Destinatrio  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Dest_Logradouro)<3){
			$erros.='<BR>O logradouro do Destinatrio  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Dest_Bairro)<3){
			$erros.='<BR>O bairro do Destinatrio  invlido!';
		}
		//CEP
		//if(strlen($reg_nfe->Dest_UF)!='EX'){
		//    if(strlen($reg_nfe->Dest_CEP)<9){
		//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Cliente/Fornecedor  invlido!';
		//    }
		//}
		//cidade nome
		if(strlen($reg_nfe->Dest_Nome_Cidade)<3){
			$erros.='<BR>O nome de cidade do Destinatrio  invlido!';
		}
		//Cidade nr
		if($reg_nfe->Dest_Codigo_Cidade<=0){
			$erros.='<BR>O cdigo de cidade do Destinatrio  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Dest_Nome_Pais)<3){
			$erros.='<BR>O nome de pas do Destinatrio  invlido!';
		}
		//pais nr
		if($reg_nfe->Dest_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas do Destinatrio  invlido!';
		}
		/*
		//telefone
		if(strlen($reg_nfe->Dest_Telefone_Nr)<14){
		$erros.='<BR>O telefone "'.$reg_nfe->Dest_Telefone_Nr.'" do Cliente/Fornecedor  invlido!';
		}*/
		//UF
		if(strlen($reg_nfe->Dest_UF)<2){
			$erros.='<BR>A UF do Destinatrio  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Dest_Insc_Estadual) != ''){
			if (strtoupper($reg_nfe->Dest_Insc_Estadual) != 'ISENTO'){
				if (!(ChkInscEstadual($reg_nfe->Dest_Insc_Estadual, $reg_nfe->Dest_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" do Destinatrio  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}
		//validao tomador
		//CNPJ
		if($reg_nfe->Tom_UF!='EX'){  //no valida caso seja estrangeiro
			if(strlen($reg_nfe->Tom_CPF_CNPJ)==14){
				if(!CalculaCPF($reg_nfe->Tom_CPF_CNPJ)){
					$erros.='<BR>O CPF "'.$reg_nfe->Tom_CPF_CNPJ.'" do Tomador  invlido!';
				}
			}else if(strlen($reg_nfe->Tom_CPF_CNPJ)==18){
				if(!CalculaCNPJ($reg_nfe->Tom_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Tom_CPF_CNPJ.'" do Tomador  invlido!';
				}
			}else{
				$erros.='<BR>O CNPJ "'.$reg_nfe->Tom_CPF_CNPJ.'" do Tomador  invlido!';
			}
		}
		//nome
		if(strlen($reg_nfe->Tom_Razao)<3){
			$erros.='<BR>O razo social do Tomador  invlido!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Tom_Fantasia!='')&&(strlen($reg_nfe->Tom_Fantasia)<3)){
			$erros.='<BR>O nome fantasia do Tomador  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Tom_Logradouro)<3){
			$erros.='<BR>O logradouro do Tomador  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Tom_Bairro)<3){
			$erros.='<BR>O bairro do Tomador  invlido!';
		}
		//CEP
		//if(strlen($reg_nfe->Dest_UF)!='EX'){
		//    if(strlen($reg_nfe->Dest_CEP)<9){
		//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Tomador  invlido!';
		//    }
		//}
		//cidade nome
		if(strlen($reg_nfe->Tom_Nome_Cidade)<3){
			$erros.='<BR>O nome de cidade do Tomador  invlido!';
		}
		//Cidade nr
		if($reg_nfe->Tom_Codigo_Cidade<=0){
			$erros.='<BR>O cdigo de cidade do Tomador  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Tom_Nome_Pais)<3){
			$erros.='<BR>O nome de pas do Tomador  invlido!';
		}
		//pais nr
		if($reg_nfe->Tom_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas do Tomador  invlido!';
		}
		/*
		//telefone
		if(strlen($reg_nfe->Dest_Telefone_Nr)<14){
		$erros.='<BR>O telefone "'.$reg_nfe->Dest_Telefone_Nr.'" do Cliente/Fornecedor  invlido!';
		}*/
		//UF
		if(strlen($reg_nfe->Tom_UF)<2){
			$erros.='<BR>A UF do Tomador  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Tom_Insc_Estadual) != ''){
			if (strtoupper($reg_nfe->Tom_Insc_Estadual) != 'ISENTO'){
				if (!(ChkInscEstadual($reg_nfe->Tom_Insc_Estadual, $reg_nfe->Tom_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Tom_Insc_Estadual.'" do Tomador  invlida para "'.$reg_nfe->Tom_UF.'"!';
				}
			}
		}
		if((strlen($reg_nfe->Conta_Frete)!=12)&&(strlen($reg_nfe->Conta_Frete)!=0)){
			$erros.='<BR>Conta Frete (CIOT)  invlida!';
		}
		if ($reg_nfe->Rodo_Veiculo>0){
			if((strlen(limpa_mascara($reg_nfe->Rodo_Renavam))!=9)&&
				(strlen(limpa_mascara($reg_nfe->Rodo_Renavam))!=11)){
				$erros.='<BR>O Renavam do Veiculo  invlido!';
			}
			if(strlen($reg_nfe->Rodo_Placa)!=8){
				$erros.='<BR>A Placa do Veiculo  invlida!';
			}
			if(strlen($reg_nfe->Rodo_Placa_UF)!=2){
				$erros.='<BR>A UF da Placa do Veculo  invlida!';
			}
			if($reg_nfe->Rodo_Tara<=0){
				$erros.='<BR>A Tara do Veiculo  invlida!';
			}
			if($reg_nfe->Rodo_Peso_Bruto_Max<=$reg_nfe->Rodo_Tara){
				$erros.='<BR>O Peso Bruto Mximo do Veculo  invlido!';
			}
			if($reg_nfe->Rodo_Cubagem_Max<=0){
				$erros.='<BR>A Cubagem Mxima do Veculo  invlida!';
			}
			if($reg_nfe->Rodo_Rodado==''){
				$erros.='<BR>O Tipo de Rodado do Veculo  invlido!';
			}
			if($reg_nfe->Rodo_Carroceria==''){
				$erros.='<BR>O Tipo de Carroceria do Veculo  invlido!';
			}
			if ($reg_nfe->Rodo_Reboque_Placa!=''){
				if((strlen(limpa_mascara($reg_nfe->Rodo_Reboque_ANTT))!=9)&&
					(strlen(limpa_mascara($reg_nfe->Rodo_Reboque_ANTT))!=11)){
					$erros.='<BR>O Renavam do Reboque 1 do Veiculo  invlido!';
				}
				if(strlen($reg_nfe->Rodo_Reboque_Placa)!=8){
					$erros.='<BR>A Placa do Reboque 1 do Veiculo  invlida!';
				}
				if(strlen($reg_nfe->Rodo_Reboque_UF)!=2){
					$erros.='<BR>A UF da Placa do Reboque 1 do Veculo  invlida!';
				}
			}

			if ($reg_nfe->Rodo_Reboque2_Placa!=''){
				if((strlen(limpa_mascara($reg_nfe->Rodo_Reboque2_ANTT))!=9)&&
					(strlen(limpa_mascara($reg_nfe->Rodo_Reboque2_ANTT))!=11)){
					$erros.='<BR>O Renavam do Reboque 2 do Veiculo  invlido!';
				}
				if(strlen($reg_nfe->Rodo_Reboque2_Placa)!=8){
					$erros.='<BR>A Placa do Reboque 2 do Veiculo  invlida!';
				}
				if(strlen($reg_nfe->Rodo_Reboque2_UF)!=2){
					$erros.='<BR>A UF da Placa do Reboque 2 do Veculo  invlida!';
				}
			}
			if ($reg_nfe->Rodo_Proprio=='N'){
				if($reg_nfe->Rodo_Prop_UF!='EX'){  //no valida caso seja estrangeiro
					if(strlen($reg_nfe->Rodo_Prop_CPF_CNPJ  )==14){
						if(!CalculaCPF($reg_nfe->Rodo_Prop_CPF_CNPJ  )){
							$erros.='<BR>O CPF "'.$reg_nfe->Rodo_Prop_CPF_CNPJ  .'" do Proprietrio do Veculo  invlido!';
						}
					}else if(strlen($reg_nfe->Rodo_Prop_CPF_CNPJ  )==18){
						if(!CalculaCNPJ($reg_nfe->Rodo_Prop_CPF_CNPJ  )){
							$erros.='<BR>O CNPJ "'.$reg_nfe->Rodo_Prop_CPF_CNPJ  .'" do Proprietrio do Veculo  invlido!';
						}
					}else{
						$erros.='<BR>O CNPJ "'.$reg_nfe->Rodo_Prop_CPF_CNPJ  .'" do Proprietrio do Veculo  invlido!';
					}
				}
				//nome
				if(strlen($reg_nfe->Rodo_Prop_Nome)<3){
					$erros.='<BR>O razo social do Proprietrio do Veculo  invlido!';
				}
				if(strlen(limpa_numero($reg_nfe->Rodo_Veiculo_ANTT))!=8){
					$erros.='<BR>O Registro RNTRC do Proprietrio do Veculo  invlido!';
				}
				if(strlen($reg_nfe->Rodo_Prop_UF )<2){
					$erros.='<BR>A UF do Proprietrio do Veculo  invlida!';
				}
				//IE
				if (limpa_mascara($reg_nfe->Rodo_Prop_Insc_Estadual  ) != ''){
					if (strtoupper($reg_nfe->Rodo_Prop_Insc_Estadual  ) != 'ISENTO'){
						if (!(ChkInscEstadual($reg_nfe->Rodo_Prop_Insc_Estadual  , $reg_nfe->do_Prop_UF))){
							$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Tom_Insc_Estadual.'" do do Proprietrio do Veculo  invlida para "'.$reg_nfe->Tom_UF.'"!';
						}
					}
				}
			}
		}
		if ($reg_nfe->Rodo_Motorista>0){
			if(!CalculaCPF($reg_nfe->Rodo_Moto_CPF_CNPJ)){
				$erros.='<BR>O CPF "'.$reg_nfe->Rodo_Moto_CPF_CNPJ.'" do Motorista  invlido!';
			}
			if(strlen($reg_nfe->Rodo_Moto_Nome)<3){
				$erros.='<BR>O Nome do Motorista  invlido!';
			}
		}
		/*
		//consulta Nota Fiscal Item
		$con_item = 'select * from nota_fiscal_item '.
		' where Dominio = "'.$_SESSION['Dominio'].'"'.
		' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' and Nr_Nota = "'.$nr_nota.'"';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrw_item;$i++){
		$reg_item = consulta_ler_objeto($res_item);
		//valida dados do produto
		//Codigo
		//descrio
		if(strlen($reg_item->Prod_Descricao)<3){
		$erros.= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": Descrio do Produto  invlido!';
		}

		//Unidade de medida
		if(strlen($reg_item->Unidade_NF)<1){ //pode sim ter 1 dig
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A unidade de medida  invlida!';
		}
		//NCM (se com IPI ou CFOP comea com 3 ou 7 tem que ter 8 digitos, seno s dois  suficiente)
		if(($reg_item->IPI_Valor>0)||((substr($reg_item->CFOP,0)==3)||(substr($reg_item->CFOP,0)==7))){
		if(strlen($reg_item->Prod_NCM)<10){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuir todos os dez dgitos para operaes com exterior ou com incidncia de IPI!';
		}
		}else if(strlen($reg_item->Prod_NCM)<2){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuiir ao menos os dois primeiros dgitos (gnero) para esta operao!';
		}
		//Origem da Mercadoria (se CFOP = 3) a origem deve ser 1
		if(substr($reg_item->CFOP,0)==3){
		if($reg_item->Origem!='1'){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A origem de mercadoria  invlida! para operaes de importao a origem deve ser obrigatoriamente "2 - Estrangeira"';
		}
		}
		//CSTs de ICMS, IPI, PIS e COFINS (validar se Os CST existem na lista de CSTs)
		if(busca_dados_combo('icms_cst_'.$reg_nfe->Empresa_CRT,$reg_item->ICMS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do ICMS "'.$reg_item->ICMS_CST.'"  invlido!';
		}
		if(busca_dados_combo('ipi_cst',$reg_item->IPI_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do IPI "'.$reg_item->IPI_CST.'"  invlido!';
		}

		if(busca_dados_combo('pis_cst_nf_'.$reg_nfe->TipoES,$reg_item->PIS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do PIS "'.$reg_item->PIS_CST.'"  invlido!';
		}
		if(busca_dados_combo('cofins_cst_nf_'.$reg_nfe->TipoES,$reg_item->COFINS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do COFINS "'.$reg_item->COFINS_CST.'"  invlido!';
		}
		}
		consulta_limpa($res_item);
		*/
		if ($erros!=''){
			$upd_nota = 'Update nota_frete '.
						'set Situacao="P" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Conhec="'.$nr_nota.'" '.
						' and Situacao="I"';
			$res_upd = consulta_sql($upd_nota,true,1);  //retorna para P pois no vai fazer a NFe
			cte_exibe_erro('FRE-602',
							'O Conhecimento de Frete <b>"'.$reg_nfe->NrDoc.'/'.$reg_nfe->Serie.'"</b> contm dados invlidos!'.
								'<BR>Corrija os dados e tente o envio navamente!'.$erros.'<BR><BR>',
							0);
		}
		return ($erros=='');
	}

	//copia arquivo de trnsferencia
	function cte_copia_arquivo2($origem,$destino,$arquivo_o,$arquivo_d,$ano_mes){
		//determina nome do arquivo de origem
		$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ct_e/'.$origem.'/SEFAZ/CT-es/'.$ano_mes.'/Autorizados';
		$arq_ori = $pasta_ori.'/'.$arquivo_o;
		//echo 'Arqui Ori'.$arq_ori.'<BR>';
		$ano_mes2 =  cte_ano_mes();
		//determina nome do arquivo de destino
		$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ctf_e/'.$destino.'/SEFAZ/CT-es/'.$ano_mes2.'/Recebidas';
		$arq_des = $pasta_des.'/'.$arquivo_d;
		//se renomeia
		//echo 'Arqui Dest'.$arq_des.'<BR>';
		//verifica se arquivo de origem existe
		if (file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if (!(file_exists($pasta_des))){
				//seno cria ela (ano_mes)
				rmkdir($pasta_des."/",0777);
			}
			//verifica se destino existe
			if (file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if ($copiou){
				return true;
			}else{
				cte_exibe_erro('FRE-004',
								'Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',
								0);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			cte_exibe_erro('FRE-003',
							'Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
								 'Verifique a estrutura de pastas do servidor!',
							0);
			return false;
		}
	}
	
	//muda a pasta ano mes da pasta recebidas (edio da data de entrada)
	function ctfe_copia_arquivo3($empresa,$data1,$data2,$arquivo){
		//determina nome do arquivo de origem
		$ano_mes1 = cte_ano_mes($data1);
		$ano_mes2 = cte_ano_mes($data2);
		if ($ano_mes2!=$ano_mes1){
			$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ct_e/'.$empresa.'/SEFAZ/CT-es/'.$ano_mes1.'/Recebidas';
			$arq_ori = $pasta_ori.'/'.$arquivo;
			//echo 'Arqui Ori'.$arq_ori.'<BR>';
			//determina nome do arquivo de destino
			$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/ct_e/'.$empresa.'/SEFAZ/CT-es/'.$ano_mes2.'/Recebidas';
			$arq_des = $pasta_des.'/'.$arquivo;
			//se renomeia
			//echo 'Arqui Dest'.$arq_des.'<BR>';
			//verifica se arquivo de origem existe
			if (file_exists($arq_ori)){
				//verifica se pasta de destino existe
				if (!(file_exists($pasta_des))){
					//seno cria ela (ano_mes)
					rmkdir($pasta_des."/",0777);
				}
				//verifica se destino existe
				if (file_exists($arq_des)){
					//apaga arquivo de destino caso exista alguma coisa
					unlink($arq_des);
				}
				//efetiva acopia do arquivo
				//echo $arq_ori.'-'.$arq_des.'<BR>';
				$copiou = copy($arq_ori, $arq_des);
				//se fez a copia corretamente
				if ($copiou){
					unlink($arq_ori);
					return true;
				}else{
					cte_exibe_erro('FRE-004',
									'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
										'Verifique a estrutura de pastas do servidor!',
									0);
					return false;
				}
			}else{ //seno
				//exibe erro de arquivo inexistente
				cte_exibe_erro('FRE-003',
								'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',
								0);
				return false;
			}
		}else{
			return true;
		}
	}
	
	///// FUNO PARA VERIFICAR A DATA DE VALIDADE DO CERTIFICADO E EMITIR UM AVISO
	function cte_validade_do_certificado(){
		//Gera um arquivo uninfe-cons-inf.xml na pasta de envio ()
		//O retorno  gerado aps o envio com o nome uninfe-ret-cons-inf.xml
		//Tendo esse arquivo de retorno vc ter os dados do uninfe
		//inclusive data ini e data fin
		//tendo data val faz uma comparao com a data atual e se
		//tiver faltando 30 dias emite um aviso no primeiro login do dia.
		$xml2 = new XML();
		$root = &$xml2->createRoot("ConsInf");
		$root->addAttribute('xServ', 'CONS-ICT', false);
		$ano_mes_hora  = 'uninfe-cons-inf.xml';
		$xml2->toFile(cte_pasta_raiz().'tmp/', $ano_mes_hora);
		$salvou = cte_copia_arquivo('tmp','envio',$ano_mes_hora,'',false);
		//$salvou = true;
		$ano_mes = cte_ano_mes();
		$data_atual = data_atual('data');
		$dias_falta = 0;
		$tentativa = 0;
		$validade = '';
		//se consegui salvar
		if($salvou){
			$ok = false;
			while (!($ok)){
				set_time_limit(60);
				if ((file_exists(cte_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
					$ok = true;
					sleep(1);
				}else{
					sleep(1);
					$tentativa++;
				}
				if($ok){
					$xml = new XML();
					$xml->fromFile(cte_pasta_raiz().'retorno','uninfe-ret-cons-inf.xml', true);
					if ($xml->root->name == 'retConsInf'){
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name== 'DadosCertificado'){
								$dados_cert = &$xml->root->childs[$key];
								foreach($dados_cert->atts as $key3 => $value2){
									if ($dados_cert->atts[$key3]->name== 'dValFin'){
										$validade = $dados_cert->atts[$key3]->value;
									}
								}
							}
						}
					}
				}
				if($tentativa>=10){
					$ok = true;
				}
			}
			if($validade==''){
				$dias_falta = 'NE';//Data no encontrada
			}else {
				$dt_validade = substr($validade,0,10);
				$dias_falta = (data2nr($dt_validade)-data2nr($data_atual));
				if ((file_exists(cte_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
					unlink(cte_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
				}
			}
			//$hr_validade
			//$dias_falta = 5;
		}
		$consulta = 'Update param set Conteudo = "'.data_atual('date').'"'.
					' where Dominio="'.$_SESSION["Dominio"].'"'.
					' and Chave = "VALIDA_CERTIFICADO"';
		$ok = consulta_sql($consulta,true,1);
		//unlink(nfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
		return $dias_falta;
	}

	function cce_ct_gera_chave($nr_conhec,$evento){
		$con_nota = 'SELECT CTe_Chave FROM nota_frete '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Conhec="'.$nr_conhec.'" ';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);
		$con_evento =  'SELECT Seq_Evento FROM nota_frete_evento '.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Conhec="'.$nr_conhec.'" '.
						' AND Seq_Evento="'.$evento.'"';
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		$con_lote = 'SELECT MAX(CCe_Lote) FROM nota_frete_evento '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"';
		$res_lote = consulta_sql($con_lote);
		$reg_lote = consulta_ler_linha($res_lote);
		consulta_limpa($res_lote);
		//tpEvento + chave da NF-e + nSeqEvento
		$chave_cce = '110110'.$reg_nota->CTe_Chave.fill_full($reg_evento->Seq_Evento,2);
		$cod_orgao = substr($reg_nota->CTe_Chave,0,2);
		$lote = $reg_lote[0] + 1;
		$upd_nota = 'UPDATE nota_frete_evento SET'.
					' Versao_Evento="'.config_pad('ct_cce_versao').'" ,'.
					' Id_Evento="'.$chave_cce.'", '.
					' CCe_Lote="'.$lote.'", '.
					' Cod_Orgao="'.$cod_orgao.'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Conhec="'.$nr_conhec.'" '.
					' AND Seq_Evento="'.$evento.'"'.
					' AND Id_Evento=""';
		consulta_sql($upd_nota,true,1);
	}

	function cte_busca_ambiente_evento(){
		$retorno = '2';
		$con_serie ='select CTe_Ambiente from nota_frete_serie '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' and Modelo = "57" '.
					' and Situacao = "A" limit 1';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		if ($reg_serie[0]=='1'){
			$retorno = '1';
		}
		return $retorno;
	}

	function cte_busca_validade_pagamento($nrdoc, $empresa, $tomador){
		$resposta['vencto'] = '0000-00-00';
		$resposta['pagto'] = '0000-00-00';
		$con_ordem = 'select Empresa, Nr_Ordem  from nota_frete_pagto_notas nfpn '.
					' where nfpn.Dominio = "'.$_SESSION['Dominio'].'" '.
					' and nfpn.Nota_Empresa = "'.$empresa.'" '.
					' and nfpn.Nota_Nr_Conhec = "'.$nrdoc.'" ';
		$res_ordem = consulta_sql($con_ordem);
		$nrw_ordem = consulta_num_registros($res_ordem);
		$reg_ordem = consulta_ler_linha($res_ordem);
		consulta_limpa($res_ordem);
		if($nrw_ordem>0){
			$con_ordem = 'select * from nota_frete_pagto_notas nfpn '.
						' where nfpn.Dominio = "'.$_SESSION['Dominio'].'" '.
						' and nfpn.Empresa = "'.$reg_ordem[0].'" '.
						' and nfpn.Nr_Ordem = "'.$reg_ordem[1].'" '.
						' ORDER BY nfpn.Seq';
			$res_ordem = consulta_sql($con_ordem);
			$nrw_ordem = consulta_num_registros($res_ordem);
			$nrdoc1 = '';
			$nrdocx = '';
			$serie = '';
			$modelo = '';
			$ctrc = '';
			for($nfs=0;$nfs<$nrw_ordem;$nfs++){
				$reg_ordem = consulta_ler_objeto($res_ordem);
				if($nfs==0){
					$nrdoc1 = $reg_ordem->NrDoc;
					$serie = $reg_ordem->Serie;
					$modelo = $reg_ordem->Modelo;
				}
				$nrdocx = $reg_ordem->NrDoc;
			}
			if($nrdocx==$nrdoc1){
				$ctrc = $nrdoc1;
			}else{
				$ctrc = $nrdoc1.'-'.$nrdocx;
			}
			consulta_limpa($res_ordem);
			/* Troca de Data_Recebe por DT_Pagto realizado em 31-03-2023 por @aldenir */
			$con_datas = 'select DT_Vencto, DT_Pagto '.
						' from contas_pr '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and TipoPR = "R" '.
						' and TipoEmissao = "P" '.
						' and Pessoa = "'.$tomador.'" '.
						' and Modelo = "'.$modelo.'" '.
						' and Serie = "'.$serie.'" '.
						' and Nr_Doc = "'.$ctrc.'" ';
			$res_datas = consulta_sql($con_datas);
			$nrw_datas = consulta_num_registros($res_datas);
			if($nrw_datas!=0){
				$reg_datas = consulta_ler_linha($res_datas);
				$resposta['vencto'] = $reg_datas[0];
				$resposta['pagto'] = $reg_datas[1];
			}
			consulta_limpa($res_datas);
		}
		return $resposta;
	} 
	
	function busca_dados_cce_cte($empresa = ''){
		$retorno = array();
		if($empresa == ""){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$sql_dados_cli = 'SELECT pes.Nome_Razao, pes.Email, pes_end.Logradouro, pes_end.Numero, pes_end.Complemento, '.
						' pes_end.Bairro, pes_end.CEP, pes_end.Nome_Cidade,pes_end.UF, pes_tel.Numero_Telefone FROM pessoa pes '.
						' LEFT JOIN pessoa_endereco pes_end ON pes.Dominio = pes_end.Dominio AND pes.Pessoa = pes_end.Pessoa '.
						' LEFT JOIN pessoa_telefone pes_tel ON pes.Dominio = pes_tel.Dominio AND pes.Pessoa = pes_tel.Pessoa '.
						' WHERE pes.Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND pes.Pessoa = "'.$empresa.'"  '.
						' AND pes_end.Seq_Endereco = 1 '.
						' AND pes_tel.Seq_Telefone = 1 '.
						' LIMIT 1';
		$res_dados_cli = consulta_sql($sql_dados_cli);
		$reg_dados_cli = consulta_ler_objeto($res_dados_cli);
		$retorno['razao'] = $reg_dados_cli->Nome_Razao;
		$retorno['logradouro'] = $reg_dados_cli->Logradouro;
		$retorno['numero'] = $reg_dados_cli->Numero;
		$retorno['complemento'] = $reg_dados_cli->Complemento;
		$retorno['bairro'] = $reg_dados_cli->Bairro;
		$retorno['CEP'] = $reg_dados_cli->CEP;
		$retorno['municipio'] = $reg_dados_cli->Nome_Cidade;
		$retorno['UF'] = $reg_dados_cli->UF;
		$retorno['telefone'] = $reg_dados_cli->Numero_Telefone;
		$retorno['email'] = $reg_dados_cli->Email;
		$retorno = array_map("utf8_encode_si", $retorno);
		return $retorno;
	}

	function cte_busca_arquivo_backup($nr_nota){
		$con_nfe =  'SELECT CTe_Chave, DH_Emissao FROM nota_frete '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Conhec = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//arquivos_clientes/2/nf_e/1/backup/Autorizados/201805/41180576676436000167550010000991051000853750-procNFe.xml
		$nm_arq = fill_full($reg_nfe->CTe_Chave, 44).'-procCTe.xml';
		$url_arq = cte_pasta_raiz().'backup/Autorizados/'.cte_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/'.$nm_arq;
		return $url_arq;
	}

	function cte_busca_arquivo_cce_backup($nr_nota, $evento = ''){
		$con_evento='SELECT CTe_Chave, DH_Emissao FROM nota_frete '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Conhec = "'.$nr_nota.'"';
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		if($evento == ''){
			$con_seq_evento='SELECT Seq_Evento FROM nota_frete_evento '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Conhec = "'.$nr_nota.'"'.
							' ORDER BY Seq_Evento DESC '.
							' LIMIT 1';
			$res_seq_evento = consulta_sql($con_seq_evento);
			$reg_seq_evento = consulta_ler_objeto($res_seq_evento);
			consulta_limpa($res_seq_evento);
			$evento = '1';
			if(isset($reg_seq_evento)){
				$evento = $reg_seq_evento->Seq_Evento;
			}
		}
		
		//arquivos_clientes/2/nf_e/1/backup/Autorizados/201805/41180576676436000167550010000991051000853750_01-procEventoNFe.xml
		$nm_arq = $reg_evento->CTe_Chave.'_'.fill_full($evento, 2).'-procEventoCTe.xml';
		$pasta_arq = cte_pasta_raiz().'backup/Autorizados/'.cte_ano_mes($reg_evento->DH_Emissao,'AAAAMM').'/';
		$url_arq = $pasta_arq.$nm_arq;
		if (!file_exists($url_arq)){
			//41240245232028000192570010000017781013126740_110110_001-procEventoCTe
			$nm_arq = $reg_evento->CTe_Chave.'_110110_'.fill_full($evento, 3).'-procEventoCTe.xml';			
		}
		$url_arq = $pasta_arq.$nm_arq;
		return $url_arq;
	}

	
?>