<?
	//Fase 1 - Gerao Arquivo XML da NF-e
	//Fase 2 - Retorno Numero do Lote ou Erro
	//Fase 3 - Retrono Nmero do Recibo ou Erro
	//Fase 4 - Consulta Situao NF-e (caso j no tenha a situao na pasta)
	//Fase 5 - Retorno Consulta Situao (protocolo)
	//Fase 6 - Fechamento da NF-e e Finalizao do Processo como um todo.

	require_once(dirname(__FILE__).'/cte_arquivos.php');

	function cte_processa($nr_nota){
		$notas_proc = '';
		//verifica o status da nf gravando no banco o novo status (de  I Iniciado Processo)
		$upd_nota = 'Update nota_frete '.
					'set Situacao="I" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" '.
					' and Situacao="P"';
		$res_upd = consulta_sql($upd_nota,true,1);
		//se pode fazer nf-e
		if ($res_upd==1){
			$con_nfe = 'select * from nota_frete '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Conhec="'.$nr_nota.'" ';
			$res_nfe = consulta_sql($con_nfe);
			$reg_nfe = consulta_ler_objeto($res_nfe);
			consulta_limpa($res_nfe);
			//se a chave da NFe no est definida
			if ($reg_nfe->CTe_Chave == ''){
				cte_gera_chave($reg_nfe);
			}
			//inicia o processoa da NFe
			return cte_processa_fase1($nr_nota);
		//return false;
		}else{ //seno
			// exibe erro na tela dezindo que nenhuma nota aberta se encontra na lista selecionada
			cte_exibe_erro('FRE-001',
							'Conhecimento de Frete selecionado no pode ser enviada! Verifique novamente a lista, aparentemente outro usurio j fez o envio deste CT-e!',
							0);
			return false;
		}
	}

	function cte_retorna_cte($nr_nota){
		if ($nr_nota != ''){
			//retorna o status dessa nota para "P"
			$upd_nota = 'Update nota_frete set'.
						' CTe_Versao_SF="", '.
						' CTe_Situacao="", '.
						' CTe_Lote="", '.
						' CTe_Recibo="", '.
						' CTe_Protocolo="", '.
						' CTe_Protocolo_DH="0000-00-00 00:00:00", '.
						' CTe_Protocolo_Sig="",'.
						' CTe_Protocolo_C="", '.
						' CTe_Protocolo_C_DH="0000-00-00 00:00:00", '.
						' CTe_Protocolo_C_Sig="", '.
						//' NFe_Contigencia_DH="0000-00-00 00:00:00", '.
						//' NFe_Contigencia_Motivo="", '.
						' CTe_Protocolo_Motivo="", '.
						' Situacao="P" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Conhec="'.$nr_nota.'" '.
						' and Situacao="I"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function cte_processa_fase1($nr_nota){ //gerao do lote
		cte_exibe_processamento('1');
		//consulta a nota no banco de dados e gera os arquivos XML na pasta tmp
		$nf_e = cte_gera_arquivo_cte($nr_nota);  //$nf_e['nr_nota']; $nf_e['chave_nfe'];
		//se a chave da nfe for vazia
		if ($nf_e!=''){  //no teve erro no processo de gerao do arquivo
			$copiou = cte_copia_arquivo('tmp','envio',$nf_e.'-cte.xml',$nr_nota);
			if ($copiou){ //sem erro na cpia para a pasta envio
				return cte_processa_fase2($nr_nota);
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	function cte_processa_fase2($nr_nota,$parar=false){
		if (!($parar)){
			cte_exibe_processamento('2');
		}
		//consulta dados da NF-e
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//fica testando at ter o retrono do lote ou arquivo de erro
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-cte.err'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-num-lot.xml'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-pro-rec.xml'))){
				$ok = true;
				//espera 5 segundos
				sleep(5);
				//avalia se tem arquivo de retrono de erro do lote
				$ano_mes = cte_ano_mes($reg_nfe->DH_Emissao);
				if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-cte.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = cte_abre_arquivo_err($reg_nfe->CTe_Chave.'-cte.err');
					//copia arquivo de erro para a patas erros
					cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Chave.'-cte.err',$nr_nota,true);
					cte_exibe_erro('FRE-006',
									'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Chave.'-cte.xml"!'.$conteudo_arquivo,
									$nr_nota);
					return false;
				}else if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-pro-rec.xml')){
					return cte_processa_fase5($nr_nota,1);
				}else{
					//seno  por que gerou o arquivo de lote
					//abre o arquivo de lote para pegar o nmero do lote
					$nr_lote = 0;
					$xml = new XML();
					$xml->fromFile(cte_pasta_raiz().'retorno/', $reg_nfe->CTe_Chave.'-num-lot.xml', true);
					//le nr do lote no arquivo
					if ($xml->root->name == 'DadosLoteNfe'){
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'NumeroLoteGerado'){
								$nr_lote = fill_full($xml->root->atts[$key]->value,15);
							}
						}
					}
					//se leu arquivo de lote
					if ($nr_lote >0){
						//copia arquivo de lote para a pasta de lotes enviados
						cte_copia_arquivo('retorno','SEFAZ/Lotes/'.$ano_mes,$reg_nfe->CTe_Chave.'-num-lot.xml','');
						//salva nr do lote na NF-e
						$upd_nota = 'Update nota_frete set'.
									' CTe_Lote="'.$nr_lote.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Conhec="'.$nr_nota.'" '.
									' and Situacao="I"';
						consulta_sql($upd_nota,true,1);
						//incializa novo processo
						return cte_processa_fase3($nr_nota);
					}else{  //seno
						if ($parar){// se vai tentar denovo
							//copia arquivo de lote para a pasta de erros
							cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Chave.'-num-lot.xml','',true);
							cte_exibe_erro('FRE-007',
											'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Chave.'-num-lot.xml"!'.
												'No foi possvel ler o nmero do lote de CT-e!',
											$nr_nota);
							return false;
						}else{
							//tenta denovo (s mais essa vez
							return cte_processa_fase2($nr_nota,true);
						}
					}
				}
			}
		}
	}

	function cte_processa_fase3($nr_nota){
		cte_exibe_processamento('3');
		$ok = false;
		//consulta nr dados da NF-e
		$con_nfe = 'select * from nota_frete '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec = "'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = cte_ano_mes($reg_nfe->DH_Emissao);
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Lote.'-rec.err'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Lote.'-env-lot.err'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Lote.'-rec.xml'))){
				$ok = true;
				//espera 5 segundos
				sleep(10);
				//avalia se tem arquivo de retrono de erro do lote
				if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Lote.'-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = cte_abre_arquivo_err($reg_nfe->CTe_Lote.'-rec.err');
					cte_exibe_erro('FRE-008',
									'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Lote.'-rec.err"!'.$conteudo_arquivo,
									$nr_nota);
					cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Lote.'-rec.err','',true);
					return false;
				}else if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Lote.'-env-lot.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = cte_abre_arquivo_err($reg_nfe->CTe_Lote.'-env-lot.err');
					cte_exibe_erro('FRE-008',
									'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Lote.'-env-lot.err"!'.$conteudo_arquivo,
									$nr_nota);
					cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Lote.'-env-lot.err','',true);
					return false;
				}else{
					//seno  por que gerou o arquivo de recibo
					//abre o arquivo de recibo para pegar o status e motivo do recibo
					$xml = new XML();
					$xml->fromFile(cte_pasta_raiz().'retorno/', $reg_nfe->CTe_Lote.'-rec.xml', true);
					//le nr do lote no arquivo
					$status='';
					$motivo='';
					if ($xml->root->name == 'retEnviCte'){
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if ($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name == 'infRec'){
								$inf_rec = &$xml->root->childs[$key];
							}
						}
					}
					//se o stauts for de lote processado
					if ($status == '103'){
						//tenta ler o nr do recibo
						$nr_recibo = 0;
						foreach($inf_rec->atts as $key => $value){
							if ($inf_rec->atts[$key]->name == 'nRec'){
								$nr_recibo = $inf_rec->atts[$key]->value;
							}
						}
						//fecha arquivo
						//se leu o numero do recibo
						if ($nr_recibo > 0){   //salva nr do recibo na NF-e
							cte_copia_arquivo('retorno','SEFAZ/Recibos/'.$ano_mes,$reg_nfe->CTe_Lote.'-rec.xml','',false);
							$upd_nota = 'Update nota_frete set'.
										' CTe_Recibo="'.$nr_recibo.'" '.
										' where Dominio ="'.$_SESSION['Dominio'].'"'.
										' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' and Nr_Conhec="'.$nr_nota.'" '.
										' and Situacao="I"';
							consulta_sql($upd_nota,true,1);
							//faz uma espera inicial de 15 segundos (nova norma)
							sleep(15);
							//no precisa fazer a consulta pois ela foi feita automaticamente
							if (file_exists(cte_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								return cte_processa_fase5($nr_nota,1);
							}else{
								return cte_processa_fase4($nr_nota,1);
							}
						}else{  //seno
							cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Lote.'-rec.xml','',true);
							cte_exibe_erro('FRE-009',
											'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Lote.'-rec.xml"!'.
												'No foi possvel ler o nmero do recibo de CT-e!',
											$nr_nota);
							return false;
						}
					}else{
						//fecha arquivo
						//copia arquivo de lote para a pasta de erros
						cte_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->CTe_Lote.'-rec.xml','',true);
						cte_exibe_erro('FRE-010',
										'Rejeio do Arquivo de CT-e pela SEFAZ!'.
											'"'.$status.'" - '.$motivo.'<BR><BR>'.
											'Corrija os dados deste conhecimento de frete e faa o envio novamente!',
										$nr_nota);
						return false;
					}
				}
			}
		}
	}

	function cte_processa_fase4($nr_nota,$tentativa){
		cte_exibe_processamento('4',$tentativa);
		//consulta dados da NF-e
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		cte_gera_arquivo_consulta($nr_nota);
		//copia da pasta tmp para a pasta envio
		$copiou = cte_copia_arquivo('tmp','envio',$reg_nfe->CTe_Recibo.'-ped-rec.xml','');
		if ($copiou){
			return cte_processa_fase5($nr_nota,$tentativa);
		}else{
			return false;
		}
	}

	function cte_processa_fase5($nr_nota,$tentativa=1){
		//consulta dados NF-e
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = cte_ano_mes($reg_nfe->DH_Emissao);
		//fica tentando at encontra o arquivo de retorno
		$ok = false;
		//consulta nr dados da NF-e
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-pro-rec.xml'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Recibo.'-pro-rec.xml'))||
				(file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Recibo.'-pro-rec.err'))){
				$ok = true;
				set_time_limit(60);
				sleep(10);
				set_time_limit(60);
				if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Recibo.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = cte_abre_arquivo_err($reg_nfe->CTe_Recibo.'-pro-rec.err');
					cte_exibe_erro('FRE-011',
									'Falha no Processamento do Arquivo "'.$reg_nfe->CTe_Recibo.'-pro-rec.err"!'.$conteudo_arquivo,
									'');
					return false;
				}else{
					//abre arquivo de retorno da consulta
					$status='';
					$motivo='';
					if (file_exists(cte_pasta_raiz().'retorno/'.$reg_nfe->CTe_Chave.'-pro-rec.xml')){
						$nm_arq = $reg_nfe->CTe_Chave.'-pro-rec.xml';
						$xml = new XML();
						$xml->fromFile(cte_pasta_raiz().'retorno/', $reg_nfe->CTe_Chave.'-pro-rec.xml', true);
						//le nr do lote no arquivo
						if ($xml->root->name == 'retCTe'){
							foreach($xml->root->atts as $key => $value){
								if ($xml->root->atts[$key]->name == 'cStat'){
									$status = $xml->root->atts[$key]->value;
								}
								if ($xml->root->atts[$key]->name == 'xMotivo'){
									$motivo = $xml->root->atts[$key]->value;
								}
							}
							foreach($xml->root->childs as $key => $value){
								if ($xml->root->childs[$key]->name == 'protCTe'){
									$prot_nfe = &$xml->root->childs[$key];
								}
							}
						}
						if ($status=='100') {$status = '104';}
						if ($status=='150') {$status = '104';}
					}else{
						$nm_arq = $reg_nfe->CTe_Recibo.'-pro-rec.xml';
						$xml = new XML();
						$xml->fromFile(cte_pasta_raiz().'retorno/', $reg_nfe->CTe_Recibo.'-pro-rec.xml', true);
						//le nr do lote no arquivo
						if ($xml->root->name == 'retConsReciCTe'){
							foreach($xml->root->atts as $key => $value){
								if ($xml->root->atts[$key]->name == 'cStat'){
									$status = $xml->root->atts[$key]->value;
								}
								if ($xml->root->atts[$key]->name == 'xMotivo'){
									$motivo = $xml->root->atts[$key]->value;
								}
							}
							foreach($xml->root->childs as $key => $value){
								if ($xml->root->childs[$key]->name == 'protCTe'){
									$prot_nfe = &$xml->root->childs[$key];
								}
							}
						}
					}
					//pega status do lote
					if ($status == '105'){  //lote ainda no processado aguarda e tenta denovo
						//fecha arquivo da consulta
						//copia para a pasta erros
						cte_copia_arquivo('retorno','erros/'.$ano_mes,$nm_arq,'',true);
						//aguarda mais 10 segundos
						sleep(10);
						return cte_processa_fase4($nr_nota,$tentativa+1);
					}else if ($status == '104'){
						//le dados do protocolo de recebimento da NFe
						ignore_user_abort(1);
						$status = '';
						$motivo = '';
						$protocolo_nr = '';
						$protocolo_dh = '';
						$protocolo_pr = '';
						$protocolo_dv = '';
						$txt_inf_prot = '';
						foreach($prot_nfe->childs as $key => $value){
							if ($prot_nfe->childs[$key]->name == 'infProt'){
								$txt_inf_prot = $prot_nfe->childs[$key]->toString();
								foreach($prot_nfe->childs[$key]->atts as $key2 => $value){
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'cStat'){
										$status = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'xMotivo'){
										$motivo = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'verAplic'){
										$protocolo_pr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'dhRecbto'){
										$protocolo_dh = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'nProt'){
										$protocolo_nr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'digVal'){
										$protocolo_dv = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
								}
							}
						}
						//grava dados do protocolo da NF-e
						set_time_limit(60);
						$upd_nota = 'Update nota_frete set'.
									' CTe_Situacao="'.$status.'", '.
									' CTe_Protocolo_Motivo="'.$motivo.'", '.
									' CTe_Versao_SF="'.$protocolo_pr.'", '.
									' CTe_Protocolo_DH="'.str_replace('T',' ',$protocolo_dh).'", '.
									' CTe_Protocolo="'.$protocolo_nr.'", '.
									' CTe_Protocolo_Sig="'.$protocolo_dv.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Conhec="'.$nr_nota.'" '.
									' and Situacao="I"';
						consulta_sql($upd_nota,true,1);
						set_time_limit(60);
						//le statsu da NF-e
						if (($status == '100')||($status == '150')){
							//fecha arquivo da consulta
							sleep(10);
							set_time_limit(60);
							//copia para a pasta de recibos
							cte_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes,$nm_arq,'',false);
							//foi autorizada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de aurorizada
							//abre o arquivo da NF-e da pasta backup/autorizadas
							//echo cte_pasta_raiz().'backup/Autorizados/'.$ano_mes.
							//     $reg_nfe->CTe_Chave.'-cte.xml';
							$texto_nfe = xml_fromFile(cte_pasta_raiz().'backup/Autorizados/'.$ano_mes,$reg_nfe->CTe_Chave.'-cte.xml');
							//echo $texto_nfe;
							//arquivo assinado est na pasta de nfes autorizadas
							//a autorizao j foi lida anteriormente ($prot_nfe)
							$string = '<?xml version="1.0" encoding="utf-8"?>'.
										'<cteProc xmlns="http://www.portalfiscal.inf.br/cte" versao="'.$reg_nfe->CTe_Versao.'">'.
										$texto_nfe.
										'<protCTe versao="'.$reg_nfe->CTe_Versao.'" xmlns="http://www.portalfiscal.inf.br/cte">'.
										$txt_inf_prot.
										'</protCTe>'.
										'</cteProc>';
							$Handle = fopen(cte_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							cte_copia_arquivo('tmp','SEFAZ/CT-es/'.$ano_mes.'/Autorizados',$protocolo_nr.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.xml','',false);
							set_time_limit(60);
							return cte_processa_fase6($nr_nota,true);
						}else if (($status == '301')||
									($status == '302')){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de recibos
							cte_copia_arquivo('retorno','SEFAZ/Denegacao/'.$ano_mes,$nm_arq,'',false);
							//foi denegada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de denegadas
							$texto_nfe = xml_fromFile(
							cte_pasta_raiz().'backup/Denegados/'.$ano_mes,
							$reg_nfe->CTe_Chave.'-den.xml');
							//arquivo assinado est na pasta de nfes autorizadas
							//a autorizao j foi lida anteriormente ($prot_nfe)
							$string = '<?xml version="1.0" encoding="utf-8"?>'.
										'<cteProc xmlns="http://www.portalfiscal.inf.br/cte" versao="'.$reg_nfe->CTe_Versao.'">'.
										$texto_nfe.
										'<protCTe versao="'.$reg_nfe->CTe_Versao.'" xmlns="http://www.portalfiscal.inf.br/cte">'.
										$txt_inf_prot.
										'</protCTe>'.
										'</cteProc>';
							$Handle = fopen(cte_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							cte_copia_arquivo('tmp','SEFAZ/CT-es/'.$ano_mes.'/Denegadas',$protocolo_nr.'_v'.fill_full($reg_nfe->CTe_Versao,5).'-procCTe.xml','',false);
							//exibe mensagem na tela sobre a denegao de uso
							cte_exibe_erro('FRE-013',
											'A SEFAZ no autorizou o uso de CT-e!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Conforme determina a legislao, essa nota no poder ser utilizada!'.
												'Entre em contato com a SEFAZ do seu Estado para obter mais informaes!',
											'');
							set_time_limit(60);
							return cte_processa_fase6($nr_nota,false);
						}else if ($status == '204'){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de erros
							cte_copia_arquivo('retorno','erros/'.$ano_mes,$nm_arq,'',true);
							//exibe mensagem na tela sobre a denegao de uso
							cte_exibe_erro('FRE-014',
											'Falha no processamento do Lote de CT-e!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Faa o reenvio da nota fiscal para concluir o processamento!',
											'');
							$upd_nota = 'Update nota_frete set '.
										' CTe_Recibo = "", '.
										' CTe_Protocolo="" '.
										' where Dominio ="'.$_SESSION['Dominio'].'"'.
										' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' and Nr_Conhec="'.$nr_nota.'" '.
										' and Situacao="I"';
							consulta_sql($upd_nota,true,1);
							set_time_limit(60);
							return false;
						}else{
							//outro tipo de rejeio
							cte_copia_arquivo('retorno','erros/'.$ano_mes,$nm_arq ,'',true);
							cte_exibe_erro('FRE-015',
											'Rejeio do Arquivo de CT-e pela SEFAZ!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Corrija os dados desta nota e faa o envio novamente!',
											$nr_nota);
							//funo retorna false (no fez a nota corretamente)
							return false;
						}
					}else{
						$conteudo_arquivo = cte_abre_arquivo_err($nm_arq );
						cte_exibe_erro('FRE-012',
										'Falha no Processamento do Arquivo "'.$nm_arq .'"!'.$conteudo_arquivo,
										'');
						return false;
					}
				}
			}
		}
	}

	function cte_processa_fase6($nr_nota,$ok){
		//fecha a nota
		set_time_limit(60);
		cte_exibe_processamento('5');
		if ($ok){
			$status_nf = 'F';
			$desc_nfe = 'Autorizado';
		}else{
			//apenas muda o status (CT-e Denegada)
			$status_nf = 'C';
			$desc_nfe = 'Denegado';
		}
		$upd_nota = 'Update nota_frete set'.
					' Situacao="'.$status_nf.'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" '.
					' and Situacao="I"';
		$res_nota = consulta_sql($upd_nota,true,1);
		set_time_limit(60);
		if (($res_nota==1)&&($ok)){
			/*nota_frete_mov_estoque($nr_nota,'F');
			nota_frete_gera_contas($nr_nota);
			nota_frete_estoque_reserva($nr_nota,'F');
			devolucao_pedido($nr_nota,'-');*/
		}else if ($res_nota==1){
			//volta saldo como se estivesse inutilizando
			nota_frete_cancela($nr_nota, 'D',$_SESSION["Empresa_Codigo"]);
		}
		cte_exibe_processamento('6',$desc_nfe);
		return $ok;
	}

	function cte_cancela($nr_nota,$op){
		$con_nfe = 'select * from nota_frete '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Conhec="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		if ($reg_nfe->CTe_Chave == ''){
			nota_frete_valida_persistencia($nr_nota,$_SESSION["Empresa_Codigo"]);
			cte_gera_chave($reg_nfe);
		}
		if ($op=='C'){
			$nf_e = cte_gera_arquivo_cancela($nr_nota);
		}else{
			$nf_e = cte_gera_arquivo_inutiliza($nr_nota);
		}
		return $nf_e;
	}
?>