<?php
	/**
	 * Funo que recebe duas data completas (dd/mm/aaaa hh:mm:ss). Transforma ambas as datas em nmeros. Retorna com a subtrao entre o tempo final e o tempo inicial. 
	 *
	 * @param [string] $data inicial , data final
	 * @return int
	 * @author Maurcio Moller <mauricio@freeline.inf.br>
	 */
	
	function intervalo2nr($start, $end){
		$dataStart = substr($start, 0, 10);
		$horaStart = substr($start, 11, 8);
		$dataEnd = substr($end, 0, 10);
		$horaEnd = substr($end, 11, 8);
		return (
				(hora2nr($horaEnd) + (data2nr(dataf($dataEnd)) * 24 * 60 * 60)) -
				(hora2nr($horaStart) + (data2nr(dataf($dataStart)) * 24 * 60 * 60))
				);
	}
	/**
	 * Funo que recebe uma data (dd/mm/aaaa) e retorna nmero. 
	 *
	 * @param [string] $data
	 * @return int
	 * @author Maurcio Moller <mauricio@freeline.inf.br>
	 */
	function data2nr($data){
		$mes = $data[3].$data[4];
		$dia = $data[0].$data[1];
		$ano = $data[6].$data[7].$data[8].$data[9];
		$jd = GregorianToJD($mes,$dia,$ano);
		$rjd =($jd-2415019);
		return $rjd;
	}
	/**
	 * Funo que retorna a data em formato para o Usurio ver(dd/mm/aaaa). 
	 *
	 * @param [string] $data
	 * @return [string]
	 * @author Maurcio Moller <mauricio@freeline.inf.br>
	 */
	function dataf($data){
		$texto = "00/00/0000";
		if ($data != ''){
			$texto = fill_full($data[8].$data[9],2).'/'.fill_full($data[5].$data[6],2).'/'.fill_full($data[0].$data[1].$data[2].$data[3],4);
		}
		return $texto;
	}
	/**
	 * Funo que retorna a data em formato para o banco de dados (aaaa-mm-dd). 
	 *
	 * @param [string] $data
	 * @return [string]
	 * @author Maurcio Moller <mauricio@freeline.inf.br>
	 */
	function datad($data){
		$texto = "0000-00-00";
		if ($data != ""){
			$texto = fill_full($data[6].$data[7].$data[8].$data[9],4).'-'.fill_full($data[3].$data[4],2).'-'.fill_full($data[0].$data[1],2);
		}
		return $texto;
	}

	function nr2data($rjd){
		$jd =($rjd+2415019);
		$data_americana = jdtogregorian($jd);
		$data_americana = str_replace('/1/','/01/',$data_americana);
		$data_americana = str_replace('/2/','/02/',$data_americana);
		$data_americana = str_replace('/3/','/03/',$data_americana);
		$data_americana = str_replace('/4/','/04/',$data_americana);
		$data_americana = str_replace('/5/','/05/',$data_americana);
		$data_americana = str_replace('/6/','/06/',$data_americana);
		$data_americana = str_replace('/7/','/07/',$data_americana);
		$data_americana = str_replace('/8/','/08/',$data_americana);
		$data_americana = str_replace('/9/','/09/',$data_americana);
		if (strlen($data_americana)==9){
			$data_americana='0'.$data_americana;
		}
		$data = $data_americana[3].$data_americana[4].'/'.
		$data_americana[0].$data_americana[1].'/'.
		$data_americana[6].$data_americana[7].$data_americana[8].$data_americana[9];
		return $data;
	}

	function hora2nr($hora){
		$nr = 0;
		$negativo = (substr($hora, 0, 1) == '-');
		$hora_arr = explode(':', $hora);
		$horas = ltrim($hora_arr[0], '-'); // Remover sinal negativo caso exista
		$minutos = isset($hora_arr[1]) ? $hora_arr[1] : 0;
		$segundos = isset($hora_arr[2]) ? $hora_arr[2] : 0;
		$nr = ($horas * 3600) + ($minutos * 60) + $segundos;
		if($negativo){
			$nr *= -1;
		}
		return $nr;
	}

	function nr2hora($nr, $mostraSegundos = true){
		$hours = '00';
		$minutes = '00';
		$seconds = '00';
		$prefixo = '';
		if($nr < 0){
			$nr*= -1;
			$prefixo = '-';
		}
		if($nr > 0){
			$hours = str_pad(floor($nr / 3600), 2, '0', STR_PAD_LEFT);
			$minutes = str_pad(floor(($nr / 60) % 60), 2, '0', STR_PAD_LEFT);
			$seconds = str_pad($nr % 60, 2, '0', STR_PAD_LEFT);
		}
		$hora = $prefixo.$hours.':'.$minutes;
		if($mostraSegundos)
			$hora.= ':'.$seconds;
		return $hora;
	}

	function dia_semana($jdr){
		$jd = ($jdr+2415019);
		return jddayofweek($jd,0);
	}

	function inicio_semana($dia,$comeco=0){
		if ($comeco==0){
			return $dia - dia_semana($dia);
		}else{
			$dia_sem = dia_semana($dia);
			if ($dia_sem < $comeco){
				$dia_sem = 7 + ($dia_sem-$comeco);
			}else{
				$dia_sem-= $comeco;
			}
			return $dia-$dia_sem;
		}
	}

	function dia_semana_ext($dia,$tipo,$maiusculo){
		$dia_sem = dia_semana($dia);
		switch ($dia_sem){
				case '0' : $dia_ext = 'Domingo'; break;
				case '1' : $dia_ext = 'Segunda'; break;
				case '2' : $dia_ext = 'Tera'; break;
				case '3' : $dia_ext = 'Quarta'; break;
				case '4' : $dia_ext = 'Quinta'; break;
				case '5' : $dia_ext = 'Sexta'; break;
				case '6' : $dia_ext = 'Sbado'; break;
				default  : $dia_ext = 'ND'; break;
		}
		if ($tipo=='ABREVIADO'){
			$dia_ext = substr($dia_ext,0,3);
		}else if ($tipo=='LETRA'){
			$dia_ext = substr($dia_ext,0,1);
		}
		if ($maiusculo){
			$dia_ext = strtoupper($dia_ext);
		}
		return $dia_ext;
	}

	function data_atual($tipo=''){
		$date = getdate();
		$data = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
		if ($tipo=='date'){
			return $data;
		}else if ($tipo=='data'){
			return dataf($data);
		}else{
			return data2nr(dataf($data));
		}
	}

	function hora_atual($tipo=''){
		$date = getdate();
		$hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);
		if($tipo == 'hora'){
			return $hora;
		}else{
			return hora2nr($hora);
		}
	}

	function DataExtenso($data,$maiusculo=false){
		$mes_extenso = '';
		$mes_num = $data[3].$data[4];
		if ($mes_num == '01'){
			$mes_extenso = 'Janeiro';
		}else if ($mes_num == '02'){
			$mes_extenso = 'Fevereiro';
		}else if ($mes_num == '03'){
			$mes_extenso = 'Maro';
		}else if ($mes_num == '04'){
			$mes_extenso = 'Abril';
		}else if ($mes_num == '05'){
			$mes_extenso = 'Maio';
		}else if ($mes_num == '06'){
			$mes_extenso = 'Junho';
		}else if ($mes_num == '07'){
			$mes_extenso = 'Julho';
		}else if ($mes_num == '08'){
			$mes_extenso = 'Agosto';
		}else if ($mes_num == '09'){
			$mes_extenso = 'Setembro';
		}else if ($mes_num == '10'){
			$mes_extenso = 'Outubro';
		}else if ($mes_num == '11'){
			$mes_extenso = 'Novembro';
		}else if ($mes_num == '12'){
			$mes_extenso = 'Dezembro';
		}
		$extenso = $data[0].$data[1].' de '.$mes_extenso.' de '.$data[6].$data[7].$data[8].$data[9];
		if ($maiusculo){
			$extenso = strtoupper($extenso);
		}
		return $extenso;
	}

	function MesAnoExtenso($data,$maiusculo=false){
		$mes_extenso = '';
		$mes_num = $data[3].$data[4];
		if ($mes_num == '01'){
			$mes_extenso = 'Janeiro';
		}else if ($mes_num == '02'){
			$mes_extenso = 'Fevereiro';
		}else if ($mes_num == '03'){
			$mes_extenso = 'Maro';
		}else if ($mes_num == '04'){
			$mes_extenso = 'Abril';
		}else if ($mes_num == '05'){
			$mes_extenso = 'Maio';
		}else if ($mes_num == '06'){
			$mes_extenso = 'Junho';
		}else if ($mes_num == '07'){
			$mes_extenso = 'Julho';
		}else if ($mes_num == '08'){
			$mes_extenso = 'Agosto';
		}else if ($mes_num == '09'){
			$mes_extenso = 'Setembro';
		}else if ($mes_num == '10'){
			$mes_extenso = 'Outubro';
		}else if ($mes_num == '11'){
			$mes_extenso = 'Novembro';
		}else if ($mes_num == '12'){
			$mes_extenso = 'Dezembro';
		}
		$extenso = $mes_extenso.'/'.$data[6].$data[7].$data[8].$data[9];
		if ($maiusculo){
			$extenso = strtoupper($extenso);
		}
		return $extenso;
	}

	function MesExtenso($mes_num,$maiusculo=false){
		$mes_extenso = '';
		if ($mes_num == '01'){
			$mes_extenso = 'Janeiro';
		}else if ($mes_num == '02'){
			$mes_extenso = 'Fevereiro';
		}else if ($mes_num == '03'){
			$mes_extenso = 'Maro';
		}else if ($mes_num == '04'){
			$mes_extenso = 'Abril';
		}else if ($mes_num == '05'){
			$mes_extenso = 'Maio';
		}else if ($mes_num == '06'){
			$mes_extenso = 'Junho';
		}else if ($mes_num == '07'){
			$mes_extenso = 'Julho';
		}else if ($mes_num == '08'){
			$mes_extenso = 'Agosto';
		}else if ($mes_num == '09'){
			$mes_extenso = 'Setembro';
		}else if ($mes_num == '10'){
			$mes_extenso = 'Outubro';
		}else if ($mes_num == '11'){
			$mes_extenso = 'Novembro';
		}else if ($mes_num == '12'){
			$mes_extenso = 'Dezembro';
		}
		$extenso = $mes_extenso;
		if ($maiusculo){
			$extenso = strtoupper($extenso);
		}
		return $extenso;
	}

	function dsort($array){
		foreach($array as $valor){
			// PASSANDO PARA O FORMATO INGLS (YYYY-mm-dd)
			$valor = substr($valor, -4) ."-". substr($valor, 3, 2) ."-". substr($valor, 0, 2);
			// ADICIONANDO NO ARRAY O UNIXTIME DA DATA
			$udatas[] = strtotime($valor);
		}
		// ORDENANDO OS VALORES DE FORMA CRESCENTE
		sort($udatas);

		// PASSANDO AS DATAS ORDENADAS PARA O FORMATO BRASILEIRO
		for($i=count($udatas)-1; $i>=0; $i--){
			$datas[] = date("d-m-Y", $udatas[$i]);
		}
		return $datas;
	}

	function diffDate($d1, $d2, $type='', $sep='-'){
		$d1 = explode($sep, $d1);
		$d2 = explode($sep, $d2);
		switch ($type){
			case 'A':
				$X = 31536000;
			break;
			case 'M':
				$X = 2592000;
			break;
			case 'D':
				$X = 86400;
			break;
			case 'H':
				$X = 3600;
			break;
			case 'MI':
				$X = 60;
			break;
			default:
				$X = 1;
		}
		return floor( ( ( mktime(0, 0, 0, $d2[1], $d2[2], $d2[0]) - mktime(0, 0, 0, $d1[1], $d1[2], $d1[0] ) ) / $X ) );
	}

	/**
	* dias_do_intervalo()
	*
	* @param mixed $data_ini Formato: dd/mm/AAAA
	* @param mixed $data_fim Formato: dd/mm/AAAA
	* @return Array no formato AAAA-mm-dd
	*/
	function dias_do_intervalo($data_ini, $data_fim){
		$dateStart = $data_ini;
		$dateStart = implode('-', array_reverse(explode('/', substr($dateStart, 0, 10)))).substr($dateStart, 10);
		$dateStart = new DateTime($dateStart);
		//End date
		$dateEnd   = $data_fim;
		$dateEnd   = implode('-', array_reverse(explode('/', substr($dateEnd, 0, 10)))).substr($dateEnd, 10);
		$dateEnd   = new DateTime($dateEnd);
		//Prints days according to the interval
		$dateRange = array();
		while($dateStart <= $dateEnd){
			$dateRange[] = $dateStart->format('Y-m-d');
			$dateStart = $dateStart->modify('+1day');
		}
		return var_dump($dateRange);
	}
	
	function data_valida_do_mes($data){ //data foramto AAAA-DD-MM
		$ano = substr($data,0,4);
		$mes = substr($data,5,2);
		$dia = substr($data,8,2);
		if ($mes>12){
			$mes = 12;
		}
		if ($mes<1){
			$mes = '01';
		}
		if ($dia>28){
			if (!(checkdate($mes,$dia,$ano))){
				$dia--;  //31->30
			}
			if (!(checkdate($mes,$dia,$ano))){
				$dia--;  //30->29
			}
			if (!(checkdate($mes,$dia,$ano))){
				$dia--;  //29->28
			}
		}
		return fill_full($ano,4).'-'.fill_full($mes,2).'-'.fill_full($dia,2);
	}

	function calcula_horario_verao($data,$uf){
		$fuso_horario = 3;
		if( ($uf=='MT') ||
			($uf=='MS') ||
			($uf=='AM') ||
			($uf=='RO') ||
			($uf=='AC') ||
			($uf=='RR') ||
			($uf=='51') ||
			($uf=='50') ||
			($uf=='13') ||
			($uf=='11') ||
			($uf=='12') ||
			($uf=='14') ){
			$fuso_horario = 4;
		}
		if( ($uf=='RS') ||
			($uf=='SC') ||
			($uf=='PR') ||
			($uf=='SP') ||
			($uf=='RJ') ||
			($uf=='ES') ||
			($uf=='MG') ||
			($uf=='GO') ||
			($uf=='MT') ||
			($uf=='MS') ||
			($uf=='DF') ||
			($uf=='TO') ||
			($uf=='43') ||
			($uf=='42') ||
			($uf=='41') ||
			($uf=='35') ||
			($uf=='33') ||
			($uf=='32') ||
			($uf=='31') ||
			($uf=='52') ||
			($uf=='51') ||
			($uf=='50') ||
			($uf=='53') ||
			($uf=='17')){
			//esses estados aderem ao horario de versao
			$ano = $data[0].$data[1].$data[2].$data[3];
			//adio de feriados mveis ao calendrio
			$data_procura = data2nr(dataf($data));
			//Pscoa
			//echo ''.$ano;
			$data_pascoa = date("d/m/Y", easter_date($ano));
			list ($dia_pascoa, $mes_pascoa, $ano_pascoa) = explode ("/", $data_pascoa);
			//echo 'Dia pascoa';
			$data_pascoa = fill_full($dia_pascoa,2).'/'.fill_full($mes_pascoa,2).'/'.$ano;
			//echo '<BR>';
			//Domigo de Carnaval
			$dom_carnaval = data2nr($data_pascoa) - 49;
			//echo 'Dom Carnaval'.nr2data($dom_carnaval).'<BR>';
			//terceiro domingo  de agosto
			$dia_outubro = 1;
			for($m = 1; $m <= 15; $m++){
				if(date ("w", mktime (0, 0, 0, 10, $m, $ano)) == 0){
					//soma 14 dias ao primeiro domingo
					$dia_outubro = $m + 14;
					break;
				}
			}
			//echo 'Dom Ago'.$dia_outubro.'/10/'.$ano.'<BR>';
			$dom_outubro = data2nr($dia_outubro.'/10/'.$ano);
			$dia_fevereiro = 1;
			for($m = 1; $m <= 15; $m++){
				if(date ("w", mktime (0, 0, 0, 2, $m, $ano)) == 0){
					//soma 14 dias ao primeiro domingo
					$dia_fevereiro = $m + 14;
					break;
				}
			}
			$dom_fevereiro = data2nr($dia_fevereiro.'/02/'.$ano);
			if ($dom_fevereiro == $dom_carnaval){
				$dom_fevereiro+= 7;//proxima semana
			}
			//echo 'data_procura'.nr2data($data_procura).'<BR>'.
			// echo   ';'.nr2data($dom_fevereiro).';'.
			//        ';'.nr2data($dom_outubro).'<BR>';
			$esta_verao = (!(($data_procura>=$dom_fevereiro) &&
							($data_procura<$dom_outubro)));
		}else{
			//os demais no fazem isso
			$esta_verao = false;
		}
		if($esta_verao){
			// $fuso_horario--;
		}
		return '-0'.$fuso_horario.':00';
	}

	function valida_data($data, $formato = "d/m/Y"){
		date_default_timezone_set('UTC');
		$d = DateTime::createFromFormat($formato, $data);
		return ($d && $d->format($formato) === $data);
	}
	
	function calcula_data_realizado($data_hora){
		$data_relizado = '';
		$data_atual = data_atual('num');
		$hora_atual = hora_atual('num');

		$data_pedid = data2nr(dataf($data_hora));
		$hora_pedid = hora2nr(substr($data_hora,11,8));

		$dh_atual = ($data_atual*24*60*60) + $hora_atual;
		$dh_pedid = ($data_pedid*24*60*60) + $hora_pedid;
		$dif = $dh_atual - $dh_pedid;
		$t3 = 3*60;//3 Minutos
		$t60 = 60*60;//1 hora
		$t24 = 24*60*60;//1 dia

		if ($dif<$t3){
			$data_relizado = '<b>'.substr($hora_pedid,0,5).'</b>'.
							'</br>'.
							' agora  pouco ';
		}else if ($dif<$t60){
			$data_relizado = '<b>'.substr($hora_pedid,0,5).'</b>'.
							'</br>'.
							round($dif/60,0).' minutos atrs ';
		}else if ($dif<$t24){
			$horas = round($dif/3600,0);
			if ($horas==1){
				$data_relizado = '<b>'.substr($hora_pedid,0,5).'</b>'.
								'</br>'.
								' 1 hora atrs ';
			}else{
				$data_relizado = '<b>'.substr($hora_pedid,0,5).'</b>'.
								'</br>'.
								$horas.' horas atrs ';
			}
		}else{
			$dias = $data_atual - $data_pedid;
			if ($dias==1){
				$data_relizado = '<b>'.substr($hora_pedid,0,5).'</b>'.
							'</br>'.
							' ontem ';
			}else{
				$data_relizado = '<b>'.nr2data($data_pedid).'</b>'.
							'</br>'.
							$dias.' dias atrs ';
			}
		}

		return $data_relizado;
	}

?>