<?php
	class Da {
		/**
		* Find erros in XML validate with schema XSD
		* @param string $xml XML content
		* @param string $xsd real path to scheme file
		* @return boolean
		* @throws ValidatorException
		*/
		public static function isValid($xml, $xsd){
			if (!self::isXML($xml)) {
				return false;
				//throw ValidatorException::isNotXml();
			}
			libxml_use_internal_errors(true);
			libxml_clear_errors();
			$dom = new DOMDocument('1.0', 'utf-8');
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = false;
			$dom->loadXML($xml, LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG);
			libxml_clear_errors();
			if (! $dom->schemaValidate($xsd)) {
				$errors = array();
				foreach (libxml_get_errors() as $error) {
					$errors[] = $error->message;
				}
				return false;
				//throw ValidatorException::xmlErrors($errors);
			}
			return true;
		}
		/**
		* Check if string is a XML
		* @param string $content
		* @return boolean
		*/
		public static function isXML($content){
			$content = trim($content);
			if (empty($content)) {
				return false;
			}
			if ((stripos($content, '<!DOCTYPE html>') !== false) || 
				(stripos($content, '</html>') !== false)){
				return false;
			}
			libxml_use_internal_errors(true);
			libxml_clear_errors();
			simplexml_load_string($content);
			$errors = libxml_get_errors();
			libxml_clear_errors();
			return empty($errors);
		}

		public static function Danfe($nr_nota, $destino = 'I', $nf_cancelada = 'N'){
			$imagem_empresa = busca_imagem_empresa("logo_nfe.jpg", "../../", $_SESSION['Empresa_Codigo']);
			$canhoto_posicao = BuscaParam('CANHOTO_POSICAO');
			$arquivo_nfe_xml = nfe_busca_arquivo($nr_nota, "xml");
			if(file_exists($arquivo_nfe_xml)){
				$arquivo_nfe_pdf = nfe_busca_arquivo($nr_nota, "pdf");
				$docxml = file_get_contents($arquivo_nfe_xml);
				//$isXML = Validator::isXML($docxml);
				$isXML = self::isXML($docxml);
				//$xml_valido = $danfe->simpleConsistencyCheck();
				//var_dump($xml_valido);
				if($isXML){
					//echo 'válido';
					$danfe = new DanfeNFePHP($docxml, 'P', 'A4', $imagem_empresa, 'I', '', $canhoto_posicao, $nf_cancelada);
					$danfe->montaDANFE();
					if($destino == 'I'){
					$danfe->printDANFE(basename($arquivo_nfe_pdf), 'I');
					}
					//ao visualizar esta página, substitui o pdf na pasta Danfe
					$danfe->printDANFE($arquivo_nfe_pdf, 'F');
				}else{
					//echo 'inválido';
					$arquivo_nfe_xml_bkp = nfe_busca_arquivo_backup($nr_nota);
					if(file_exists($arquivo_nfe_xml_bkp)){
						$docxml_bkp = file_get_contents($arquivo_nfe_xml_bkp);
						//$isXML_bkp = Validator::isXML($docxml_bkp);
						$isXML_bkp = self::isXML($docxml_bkp);
						if($isXML_bkp){
							$danfe_bkp = new DanfeNFePHP($docxml_bkp, 'P', 'A4', $imagem_empresa,'I', '', $canhoto_posicao, $nf_cancelada);
							$danfe_bkp->montaDANFE();
							//faz uma copia do arquivo corrompido
							copy($arquivo_nfe_xml, str_replace('.xml', '_bkp_'.date('Ymd-His').'.xml', $arquivo_nfe_xml));
							//substitui o arquivo corrompido pelo backup
							copy($arquivo_nfe_xml_bkp, $arquivo_nfe_xml);
							if($destino == 'I'){
								$danfe_bkp->printDANFE(basename($arquivo_nfe_pdf), 'I');
							}
							//ao visualizar esta página, substitui o pdf na pasta Danfe
							$danfe_bkp->printDANFE($arquivo_nfe_pdf, 'F');
						}
					}else{
						if($destino == 'I'){
							exit('XMLs inconsistentes!<br><b>'.$arquivo_nfe_xml.'</b><br><b>'.$arquivo_nfe_xml_bkp.'</b>');
						}
					}
					//var_dump($xml_bkp);
					//var_dump(file_exists($xml_bkp));
					//echo 'erro'.$nr_nota;
				}
			}else{
				//echo "<b>Arquivo '".$arquivo_nfe_xml."' não encontrado!</b>";
			}
		}

		public static function Dacce($nr_nota, $seq_evento = '1', $destino = 'I'){
			$imagem_empresa = busca_imagem_empresa("logo_nfe.jpg", "../../", $_SESSION['Empresa_Codigo']);
			$arquivo_nfe_cce_xml = nfe_busca_arquivo_cce($nr_nota, $seq_evento);
			$arquivo_nfe_cce_pdf = nfe_busca_arquivo_cce($nr_nota, $seq_evento, 'pdf');
			if(file_exists($arquivo_nfe_cce_xml)){
				$aEnd = busca_dados_cce($_SESSION['Empresa_Codigo']);
				$docxml = file_get_contents($arquivo_nfe_cce_xml);
				//$isXML = Validator::isXML($docxml);
				$isXML = self::isXML($docxml);
				if($isXML){
					//echo 'válido';
					$cce = new DacceNFePHP($docxml, 'P', 'A4', $imagem_empresa, 'I', $aEnd, '', 'Times', 1);
					if($destino == 'I'){
						$cce->printCCe(basename($arquivo_nfe_cce_pdf), 'I');
					}
					//ao visualizar esta página, substitui o pdf na pasta Danfe
					$cce->printCCe($arquivo_nfe_cce_pdf, 'F');
				}else{
					//echo 'inválido!';
					$arquivo_cce_xml_backup = nfe_busca_arquivo_cce_backup($nr_nota, $seq_evento);
					$arquivo_cce_pdf_backup = str_replace('.xml', '.pdf', $arquivo_cce_xml_backup);
					if(file_exists($arquivo_cce_xml_backup)){
						$docxml_bkp = file_get_contents($arquivo_cce_xml_backup);
						$isXML_bkp = self::isXML($docxml_bkp);
						//$isXML_bkp = Validator::isXML($docxml_bkp);
						if($isXML_bkp){
							$cce_bkp = new DacceNFePHP($docxml_bkp, 'P', 'A4', $imagem_empresa, 'I', $aEnd, '', 'Times', 1);
							//$xml_bkp_valido = $cce_bkp->validXML();
							//faz uma copia do arquivo corrompido
							copy($arquivo_nfe_cce_xml, str_replace('.xml', '_bkp_'.date('Ymd-His').'.xml', $arquivo_nfe_cce_xml));
							//substitui o arquivo corrompido pelo backup
							copy($arquivo_cce_xml_backup, $arquivo_nfe_cce_xml);
							if($destino == 'I'){
								$cce_bkp->printCCe(basename($arquivo_cce_pdf_backup), 'I');
							}
							//ao visualizar esta página, substitui o pdf na pasta Danfe
							$cce_bkp->printCCe($arquivo_nfe_cce_pdf, 'F');
						}else{
							if($destino == 'I'){
								exit('XMLs inconsistentes!<br><b>'.$arquivo_nfe_cce_xml.'</b><br><b>'.$arquivo_cce_xml_backup.'</b>');
							}
						}
					}
				}
			}else{
				//echo "<b>'".$arquivo_nfe_cce_xml."' não encontrado!</b>";
			}
		}
	}
	
	class DaCT {
		/**
		* Find erros in XML validate with schema XSD
		* @param string $xml XML content
		* @param string $xsd real path to scheme file
		* @return boolean
		* @throws ValidatorException
		*/
		public static function isValid($xml, $xsd){
			if (!self::isXML($xml)) {
				return false;
				//throw ValidatorException::isNotXml();
			}
			libxml_use_internal_errors(true);
			libxml_clear_errors();
			$dom = new DOMDocument('1.0', 'utf-8');
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = false;
			$dom->loadXML($xml, LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG);
			libxml_clear_errors();
			if (! $dom->schemaValidate($xsd)) {
				$errors = array();
				foreach (libxml_get_errors() as $error) {
					$errors[] = $error->message;
				}
				return false;
				//throw ValidatorException::xmlErrors($errors);
			}
			return true;
		}
		/**
		* Check if string is a XML
		* @param string $content
		* @return boolean
		*/
		public static function isXML($content){
			$content = trim($content);
			if (empty($content)) {
				return false;
			}
			if ((stripos($content, '<!DOCTYPE html>') !== false) || 
				(stripos($content, '</html>') !== false)){
				return false;
			}
			libxml_use_internal_errors(true);
			libxml_clear_errors();
			simplexml_load_string($content);
			$errors = libxml_get_errors();
			libxml_clear_errors();
			return empty($errors);
		}

		public static function DaCte($nr_nota, $destino = 'I', $nf_cancelada = 'N'){
			$imagem_empresa = busca_imagem_empresa("logo_nfe.jpg", "../../", $_SESSION['Empresa_Codigo']);
			$canhoto_posicao = BuscaParam('CANHOTO_POSICAO');
			$arquivo_nfe_xml = cte_busca_arquivo($nr_nota, "xml");
			if(file_exists($arquivo_nfe_xml)){
				//echo '<BR>file_exists '.$arquivo_nfe_xml;
				$arquivo_nfe_pdf = cte_busca_arquivo($nr_nota, "pdf");
				$docxml = file_get_contents($arquivo_nfe_xml);
				//$isXML = Validator::isXML($docxml);
				$isXML = self::isXML($docxml);
				//$xml_valido = $danfe->simpleConsistencyCheck();
				//var_dump($xml_valido);
				if($isXML){
					//echo 'válido';
					//echo '<BR>isXML '.$arquivo_nfe_xml;
					$dacte = new DacteNFePHP($docxml, "P", "A4", $imagem_empresa, 'I');
					//echo '<BR>DacteNFePHP ';
					$dacte->montaDACTE();
					//echo '<BR>montaDACTE ';
					if($destino == 'I'){						
						//echo '<BR>printDACTE I  ';
						$dacte->printDACTE($arquivo_nfe_pdf, "I");
					}
					//"F" salva o arquivo pdf na pasta		
					//echo '<BR>printDACTE F  ';
					$dacte->printDACTE($arquivo_nfe_pdf, "F");			
					
					
				}else{
					//echo 'inválido';
					$arquivo_nfe_xml_bkp = cte_busca_arquivo_backup($nr_nota);
					if(file_exists($arquivo_nfe_xml_bkp)){
						$docxml_bkp = file_get_contents($arquivo_nfe_xml_bkp);
						//$isXML_bkp = Validator::isXML($docxml_bkp);
						$isXML_bkp = self::isXML($docxml_bkp);
						if($isXML_bkp){
							$danfe_bkp = new DacteNFePHP($docxml_bkp, 'P', 'A4', $imagem_empresa,'I');
							$danfe_bkp->montaDACTE();
							//faz uma copia do arquivo corrompido
							copy($arquivo_nfe_xml, str_replace('.xml', '_bkp_'.date('Ymd-His').'.xml', $arquivo_nfe_xml));
							//substitui o arquivo corrompido pelo backup
							copy($arquivo_nfe_xml_bkp, $arquivo_nfe_xml);
							if($destino == 'I'){
								$danfe_bkp->printDACTE(basename($arquivo_nfe_pdf), 'I');
							}
							//ao visualizar esta página, substitui o pdf na pasta Danfe
							$danfe_bkp->printDACTE($arquivo_nfe_pdf, 'F');
						}
					}else{
						if($destino == 'I'){
							exit('XMLs inconsistentes!<br><b>'.$arquivo_nfe_xml.'</b><br><b>'.$arquivo_nfe_xml_bkp.'</b>');
						}
					}
					//var_dump($xml_bkp);
					//var_dump(file_exists($xml_bkp));
					//echo 'erro'.$nr_nota;
				}
			}else{
				//echo "<b>Arquivo '".$arquivo_nfe_xml."' não encontrado!</b>";
			}
		}

		public static function Dacce($nr_nota, $seq_evento = '1', $destino = 'I'){
			$imagem_empresa = busca_imagem_empresa("logo_nfe.jpg", "../../", $_SESSION['Empresa_Codigo']);
			//echo '<BR>cte_busca_arquivo_cce n'.$nr_nota.'S'.$seq_evento;
			$arquivo_nfe_cce_xml = cte_busca_arquivo_cce($nr_nota, $seq_evento);
			$arquivo_nfe_cce_pdf = cte_busca_arquivo_cce($nr_nota, $seq_evento, 'pdf');
			//echo '<BR>arquivo_nfe_cce_xml '.$arquivo_nfe_cce_xml;
			if(file_exists($arquivo_nfe_cce_xml)){
				//echo '<BR>file_exists '.$arquivo_nfe_cce_xml;
				$aEnd = busca_dados_cce_cte($_SESSION['Empresa_Codigo']);
				$docxml = file_get_contents($arquivo_nfe_cce_xml);
				//$isXML = Validator::isXML($docxml);
				$isXML = self::isXML($docxml);
				if($isXML){
					//echo '<BR>isXML '.$arquivo_nfe_cce_xml;
					//echo 'válido';
					//echo '<BR>DacceCTePHP ';
					$cce = new DacceCTePHP($docxml, 'P', 'A4', $imagem_empresa, 'I', $aEnd, '', 'Times', 1);
					
					if($destino == 'I'){
						//echo '<BR>printCCe I ';
						$cce->printCCe(basename($arquivo_nfe_cce_pdf), 'I');
					}
					//ao visualizar esta página, substitui o pdf na pasta Danfe
					//echo '<BR>printCCe F ';
					$cce->printCCe($arquivo_nfe_cce_pdf, 'F');
				}else{
					//echo 'inválido!';
					$arquivo_cce_xml_backup = cte_busca_arquivo_cce_backup($nr_nota, $seq_evento);
					$arquivo_cce_pdf_backup = str_replace('.xml', '.pdf', $arquivo_cce_xml_backup);
					if(file_exists($arquivo_cce_xml_backup)){
						$docxml_bkp = file_get_contents($arquivo_cce_xml_backup);
						$isXML_bkp = self::isXML($docxml_bkp);
						//$isXML_bkp = Validator::isXML($docxml_bkp);
						if($isXML_bkp){
							$cce_bkp = new DacceCTePHP($docxml_bkp, 'P', 'A4', $imagem_empresa, 'I', $aEnd, '', 'Times', 1);
							//$xml_bkp_valido = $cce_bkp->validXML();
							//faz uma copia do arquivo corrompido
							copy($arquivo_nfe_cce_xml, str_replace('.xml', '_bkp_'.date('Ymd-His').'.xml', $arquivo_nfe_cce_xml));
							//substitui o arquivo corrompido pelo backup
							copy($arquivo_cce_xml_backup, $arquivo_nfe_cce_xml);
							if($destino == 'I'){
								$cce_bkp->printCCe(basename($arquivo_cce_pdf_backup), 'I');
							}
							//ao visualizar esta página, substitui o pdf na pasta Danfe
							$cce_bkp->printCCe($arquivo_nfe_cce_pdf, 'F');
						}else{
							if($destino == 'I'){
								exit('XMLs inconsistentes!<br><b>'.$arquivo_nfe_cce_xml.'</b><br><b>'.$arquivo_cce_xml_backup.'</b>');
							}
						}
					}
				}
			}else{
				//echo "<b>'".$arquivo_nfe_cce_xml."' não encontrado!</b>";
			}
		}
	}
?>