<?php
	function projeto_inativa_filhos($empresa, $projeto, $seq){
		$upd_projeto_item = 'UPDATE projeto_item SET '.
						  ' Valor_Total = 0 '.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Empresa = "'.$empresa.'"'.
						  ' AND Projeto = "'.$projeto.'"'.
						  ' AND Seq = "'.$seq.'"'.
						  ' AND Tipo="G"';
		consulta_sql($upd_projeto_item);

		$con_projeto_item = 'SELECT Empresa, Projeto, Seq, Item, Centro_Custo FROM projeto_item '.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Empresa = "'.$empresa.'"'.
						  ' AND Projeto = "'.$projeto.'"'.
						  ' AND Seq_Pai = "'.$seq.'"';
		$res_projeto_item = consulta_sql($con_projeto_item);
		while($reg_projeto_item = consulta_ler_objeto($res_projeto_item)){
			$upd_projeto_item = 'UPDATE projeto_item SET '.
							 ' Situacao = "I" '.
							 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							 ' AND Empresa = "'.$reg_projeto_item->Empresa.'"'.
							 ' AND Projeto = "'.$reg_projeto_item->Projeto.'"'.
							 ' AND Seq = "'.$reg_projeto_item->Seq.'"';
			consulta_sql($upd_projeto_item);

			$upd_projeto_item = 'UPDATE projeto_item SET '.
							 ' Valor_Total = 0 '.
							 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							 ' AND Empresa = "'.$reg_projeto_item->Empresa.'"'.
							 ' AND Projeto = "'.$reg_projeto_item->Projeto.'"'.
							 ' AND Seq = "'.$reg_projeto_item->Seq.'"'.
							 ' AND Tipo="G"';
			consulta_sql($upd_projeto_item);

			$con_seq = 'UPDATE custo_onde SET Situacao="I" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Codigo_Onde = "'.$reg_projeto_item->Centro_Custo.'"';
			$res_seq = consulta_sql($con_seq);

			projeto_inativa_filhos($reg_projeto_item->Empresa, $reg_projeto_item->Projeto, $reg_projeto_item->Seq);
		}
		consulta_limpa($res_projeto_item);
	}

	function projeto_ativa_pais($empresa, $projeto, $seq){
		$con_projeto_item = 'SELECT Seq_Pai FROM projeto_item '.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Empresa = "'.$empresa.'"'.
						  ' AND Projeto = "'.$projeto.'"'.
						  ' AND Seq = "'.$seq.'"';
		$res_projeto_item = consulta_sql($con_projeto_item);
		$reg_projeto_item = consulta_ler_objeto($res_projeto_item);
		consulta_limpa($res_projeto_item);

		$seq_pai = $reg_projeto_item->Seq_Pai;

		if($seq_pai > 0){
			$con_projeto_item = 'SELECT Empresa, Projeto, Seq, Centro_Custo FROM projeto_item '.
							 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							 ' AND Empresa = "'.$empresa.'"'.
							 ' AND Projeto = "'.$projeto.'"'.
							 ' AND Seq = "'.$seq_pai.'" ';
			$res_projeto_item = consulta_sql($con_projeto_item);
			while($reg_projeto_item = consulta_ler_objeto($res_projeto_item)){
				$upd_projeto_item = 'UPDATE projeto_item SET '.
									' Situacao = "A" '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
									' AND Empresa = "'.$reg_projeto_item->Empresa.'"'.
									' AND Projeto = "'.$reg_projeto_item->Projeto.'"'.
									' AND Seq = "'.$reg_projeto_item->Seq.'"';
				consulta_sql($upd_projeto_item);
				
				$con_seq = 'UPDATE custo_onde SET Situacao="A" '.
						   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' AND Codigo_Onde = "'.$reg_projeto_item->Centro_Custo.'"';
				$res_seq = consulta_sql($con_seq);

				projeto_ativa_pais($reg_projeto_item->Empresa, $reg_projeto_item->Projeto, $reg_projeto_item->Seq);
			}
			consulta_limpa($res_projeto_item);
		}
   }

   function projeto_atualiza_total_pai($empresa, $projeto, $seq_pai){
		$itemSeq = '0';
		$itemSeqPai = '0';

		$con_item = 'SELECT Seq, Seq_Pai FROM projeto_item '.
			  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
			  ' AND Empresa = "'.$empresa.'"'.
			  ' AND Projeto = "'.$projeto.'"'.
			  ' AND Situacao <>  "E"'.
			  ' AND Situacao <>  "I"'.
			  ' AND Seq = "'.$seq_pai.'"';
		$res_item = consulta_sql($con_item);
		$reg_item = consulta_ler_linha($res_item);
		consulta_limpa($res_item);

		if(isset($reg_item)){
			$itemSeq = $reg_item[0];
			$itemSeqPai = $reg_item[1];
		}

		$con_soma = 'SELECT IFNULL(SUM(Valor_Total), 0) FROM projeto_item '.
                  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                  ' AND Empresa = "'.$empresa.'"'.
                  ' AND Projeto = "'.$projeto.'"'.
                  ' AND Situacao <>  "E"'.
                  ' AND Situacao <>  "I"'.
                  ' AND Seq_Pai = "'.$seq_pai.'"';
		$res_soma = consulta_sql($con_soma);
		$reg_soma = consulta_ler_linha($res_soma);
		consulta_limpa($res_soma);

		$update = 'UPDATE projeto_item SET '.
				' Valor_Total = "'.$reg_soma[0].'" '.
				' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Projeto = "'.$projeto.'"'.
				' AND Seq = "'.$itemSeq.'"';
		consulta_sql($update);

		if($itemSeqPai > 0){
			projeto_atualiza_total_pai($empresa, $projeto, $itemSeqPai);
		}
	}

	function projeto_atualiza_total($empresa, $projeto, $seq = 0){
		if($seq == 0){ //recalcular projeto inteiro
			$con_total = 'SELECT MIN(Seq) FROM projeto_item '.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Empresa = "'.$empresa.'"'.
					  ' AND Projeto = "'.$projeto.'"'.
					  ' AND Situacao <> "E"'.
					  ' AND Situacao <> "I"'.
					  ' AND Tipo = "I" '.
					  ' GROUP BY Seq_Pai';
			$res_total = consulta_sql($con_total);
			while($reg_total = consulta_ler_linha($res_total)){
				projeto_atualiza_total($_SESSION["Empresa_Codigo"], $projeto, $reg_total[0]);
			}
			consulta_ler_linha($res_total);
		}else{ //recalcular projeto a partir de um item
			$con_projeto_item = 'SELECT Seq, Item, Situacao, Seq_Pai FROM projeto_item '.
							 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							 ' AND Empresa = "'.$empresa.'"'.
							 ' AND Projeto = "'.$projeto.'"'.
							 ' AND Seq = "'.$seq.'"';
			$res_projeto_item = consulta_sql($con_projeto_item);
			$reg_projeto_item = consulta_ler_objeto($res_projeto_item);
			consulta_limpa($res_projeto_item);

			if($reg_projeto_item->Situacao == 'A'){
				projeto_ativa_pais($empresa, $projeto, $reg_projeto_item->Seq);//ativar pais
			}else if($reg_projeto_item->Situacao == 'I'){
				projeto_inativa_filhos($empresa, $projeto, $reg_projeto_item->Seq); //desativar filhos
			}

			if($reg_projeto_item->Seq_Pai > 0){
				projeto_atualiza_total_pai($empresa, $projeto,$reg_projeto_item->Seq_Pai);
			}

			$con_soma = 'SELECT IFNULL(SUM(Valor_Total), 0) FROM projeto_item '.
                     ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                     ' AND Empresa = "'.$empresa.'"'.
                     ' AND Projeto = "'.$projeto.'"'.
                     ' AND Situacao <>  "E"'.
                     ' AND Situacao <>  "I"'.
                     ' AND Seq_Pai = "0"';
			$res_soma = consulta_sql($con_soma);
			$reg_soma = consulta_ler_linha($res_soma);
			consulta_limpa($res_soma);

			$update = 'UPDATE projeto SET '.
				   ' Valor_Orcado = "'.$reg_soma[0].'", '.
				   ' Valor_Total = (Valor_Orcado + Valor_Aditivos) '.
				   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' AND Empresa = "'.$empresa.'"'.
				   ' AND Projeto = "'.$projeto.'"';
			consulta_sql($update);
		}
	}

	function projeto_importa_planilha($projeto, $arquivo){
		$retorno = array();

		if(file_exists($arquivo)){
			$sheet = 1;
			$dados = projeto_busca_dados_planilha($arquivo, $sheet);

			if(!empty($dados['Avisos'])){
				$retorno['Status'] = false;
				$retorno['Mensagem'] = 'Importao no realizada!';
				$retorno['Avisos'] = $dados['Avisos'];
			}else{
				if(!empty($dados['Dados'])){
					foreach($dados['Dados'] as $chave => $registro){
						$item = $registro['Item'];
						$item_pai = $registro['Item_Pai'];
						$descricao = $registro['Descricao'];
						$qtd = $registro['Qtd'];
						$unidade = $registro['Unidade'];
						$custo_mo = $registro['Custo_MO'];
						$custo_mat_emp = $registro['Custo_Mat_Emp'];
						$valor_unit = $registro['Valor_Unitario'];
						$valor_total = $registro['Valor_Total'];
						$conta_gerencial = $registro['Conta_Gerencial'];
						$nao_alocavel = $registro['Nao_Alocavel'];
						$grupo = $registro['Grupo'];
						$inativo = $registro['Inativo'];
						$nivel = $registro['Nivel'];

						$tipo = ($grupo === true) ? 'G' : 'I';
						$situacao = ($inativo === true) ? 'I' : 'A';

						$seq_pai = '0';
						if($item_pai != ''){
							$con_item_pai = 'SELECT Seq FROM projeto_item '.
										 ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										 ' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
										 ' AND Projeto = "'.$projeto.'" '.
										 ' AND Item = "'.$item_pai.'"';
							$res_item_pai = consulta_sql($con_item_pai);
							$reg_item_pai = consulta_ler_linha($res_item_pai);
							consulta_limpa($res_item_pai);

							if(isset($reg_item_pai)){
								$seq_pai = $reg_item_pai[0];
							}
						}

						$centro_custo = '0';

						$con_item = 'SELECT Seq, Centro_Custo FROM projeto_item '.
								  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								  ' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								  ' AND Projeto = "'.$projeto.'" '.
								  ' AND Item = "'.$item.'"';
						$res_item = consulta_sql($con_item);
						$nrw_item = consulta_num_registros($res_item);
						if($nrw_item > 0){ // se item j existe no projeto
							$reg_item = consulta_ler_linha($res_item);
							$seq = $reg_item[0];
							$centro_custo = $reg_item[1];
						}else{
							//consulta maior
							$con_seq = 'SELECT IFNULL(MAX(Seq), 0) FROM projeto_item '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
									' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Projeto = "'.$projeto.'"';
							$res_seq = consulta_sql($con_seq);
							$reg_seq = consulta_ler_linha($res_seq);
							consulta_limpa($res_seq);

							$seq = ($reg_seq[0] + 1);

							$con_ins = 'INSERT INTO projeto_item ( '.
										' Dominio, '.
										' Empresa, '.
										' Projeto, '.
										' Seq, '.
										' Item '.
										') VALUES ( '.
										' "'.$_SESSION["Dominio"].'",'.
										' "'.$_SESSION["Empresa_Codigo"].'",'.
										' "'.$projeto.'",'.
										' "'.$seq.'",'.
										' "'.$item.'"'.
										' )';
							consulta_sql($con_ins);

							if($seq_pai == '0'){
								$con_pai = 'SELECT Centro_Custo FROM projeto '.
										   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										   ' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
										   ' AND Projeto = "'.$projeto.'"';
								$res_pai = consulta_sql($con_pai);
								$reg_pai = consulta_ler_linha($res_pai);
								consulta_limpa($res_pai);
							}else{
								$con_pai = 'SELECT Centro_Custo FROM projeto_item '.
										   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										   ' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
										   ' AND Projeto = "'.$projeto.'"'.
										   ' AND Seq = "'.$seq_pai.'"';
								$res_pai = consulta_sql($con_pai);
								$reg_pai = consulta_ler_linha($res_pai);
								consulta_limpa($res_pai);
							}

							$codigo_centro_custo = '';
							if(isset($reg_pai)){
								$codigo_centro_custo = $reg_pai[0];
							}

							$cod_contabil = '';
							$cod_referencia = '';
							$lista_empresa = $_SESSION["Empresa_Codigo"];

							$con_custo_ref = 'SELECT COUNT(*) FROM custo_onde '.
										  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										  ' AND Codigo_Onde_Pai = "'.$codigo_centro_custo.'"';
							$res_custo_ref = consulta_sql($con_custo_ref);
							$reg_custo_ref = consulta_ler_linha($res_custo_ref);
							consulta_limpa($res_custo_ref);

							$con_custo_refp = 'SELECT Codigo_Referencia, Empresas FROM custo_onde '.
										   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										   ' AND Codigo_Onde = "'.$codigo_centro_custo.'"';
							$res_custo_refp = consulta_sql($con_custo_refp);
							$reg_custo_refp = consulta_ler_linha($res_custo_refp);
							consulta_limpa($res_custo_refp);

							if(isset($reg_custo_refp)){
								if($reg_custo_refp[0] != ''){
									$cod_referencia = $reg_custo_refp[0].'.'.fill_full($reg_custo_ref[0] + 1, 2);
								}
								if($reg_custo_refp[1] != ''){
									$lista_empresa = $reg_custo_refp[1];
								}
							}

							$con_custo_onde = 'SELECT IFNULL(MAX(Codigo_Onde), 0) FROM custo_onde '.
												' WHERE Dominio = "'.$_SESSION['Dominio'].'" ';
							$res_custo_onde = consulta_sql($con_custo_onde);
							$reg_custo_onde = consulta_ler_linha($res_custo_onde);
							consulta_limpa($res_custo_onde);
							$codigo_onde = ($reg_custo_onde[0] + 1);
							$insert = 'INSERT INTO custo_onde ( '.
								   ' Dominio, '.
								   ' Codigo_Onde, '.
								   ' Codigo_Onde_Pai, '.
								   ' Descricao, '.
								   ' Situacao, '.
								   ' Empresas, '.
								   ' Codigo_Contabil, '.
								   ' Codigo_Referencia '.
								   ' ) VALUES ( '.
								   ' "'.$_SESSION['Dominio'].'", '.
								   ' "'.$codigo_onde.'", '.
								   ' "'.$codigo_centro_custo.'", '.
								   ' "'.$descricao.'", '.
								   ' "A", '.
								   ' "'.$lista_empresa.'", '.
								   ' "'.$cod_contabil.'", '.
								   ' "'.$cod_referencia.'" '.
								   ' )';
							consulta_sql($insert);

							$centro_custo = $codigo_onde;
						}
						consulta_limpa($res_item);

						$update = 'UPDATE projeto_item SET '.
								' Seq_Pai = "'.$seq_pai.'", '.
								' Centro_Custo = "'.$centro_custo.'", '.
								' Descricao = "'.$descricao.'", '.
								' UnidadeMedida = "'.$unidade.'", '.
								' Qtd = "'.$qtd.'", '.
								' Valor_MaoObra = "'.$custo_mo.'", '.
								' Valor_Material = "'.$custo_mat_emp.'", '.
								' Valor_Unitario = "'.$valor_unit.'", '.
								' Valor_Total = "'.$valor_total.'", '.
								' Tipo = "'.$tipo.'", '.
								' Conta_Gerencial = "'.$conta_gerencial.'", '.
								' Nao_Alocavel = "'.$nao_alocavel.'", '.
								' Situacao = "'.$situacao.'" '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Projeto = "'.$projeto.'"'.
								' AND Seq = "'.$seq.'"';
						consulta_sql($update);
					}

					//atualiza totais do projeto
					projeto_atualiza_total($_SESSION["Empresa_Codigo"], $projeto);

					$retorno['Status'] = true;
					$retorno['Mensagem'] = 'Planilha importada com sucesso!';
				}else{
					$retorno['Status'] = false;
					$retorno['Mensagem'] = 'Dados inconsistentes!';
				}
			}
		}else{
			$retorno['Status'] = false;
			$retorno['Mensagem'] = 'Arquivo "'.basename($arquivo).'" no encontrado!';
		}

		return $retorno;
	}

	function projeto_busca_dados_planilha($arquivo, $sheet = 1){
		$lista_dados = array();
		$avisos = array();
		$a = 0;

		$reader = new SpreadsheetReader($arquivo);

		$sheets = $reader->Sheets();

		$ok = true;
		if(count($sheets) <2){
			$ok = false;
			$avisos[$a]['Mensagem'] = 'Quantidade de abas invlida!';
			$a++;
		}

		if($ok){
			$reader->ChangeSheet($sheet);
			$linha_ini = 0;
			foreach($reader as $chave => $registro){
				if(($chave > 0) && ((strlen(implode($registro)) > 0))){
					if((LowerDados(utf8_decode_si($registro[0])) == 'item') &&
						(LowerDados(utf8_decode_si($registro[1])) == 'descrio')){
						$linha_ini = $chave; //linha do cabealho
					}

					if(($linha_ini > 0) && ($linha_ini != $chave)){
						$item = UpperDados(trim(utf8_decode_si($registro[0])), false);
						$itemfmt = explode(".", $item);
						for($i=1;$i<count($itemfmt);$i++){
							if(strlen($itemfmt[$i]) != 1){
								$itemfmt[$i] = ltrim($itemfmt[$i],'0');
							}
						}
						$itemfmt_velho = implode(".", $itemfmt);
					  
						$item = $itemfmt_velho;
						$descricao = UpperDados(trim(utf8_decode_si($registro[1])), false);
						//$descricao2 = $registro[2];
						//$descricao3 = $registro[3];
						$unidade = UpperDados(trim(utf8_decode_si($registro[2])), false);
						$qtd = $registro[3];
						$custo_mo = $registro[4];
						$custo_mat_emp = $registro[5];
						$valor_unit = $registro[6];
						$valor_total = $registro[7];
						$conta_gerencial = $registro[8];
						$nao_alocavel = UpperDados(trim(utf8_decode_si($registro[9])), false);

						if($item != ''){
							$item = str_replace(',', '.', $item);
							if(strpos($item, '.') === false){
								$item.= '.0';
							}
							$item_pai = substr($item, 0, strrpos($item, '.'));
							if(strpos($item_pai, '.') === false){
								$item_pai = '';
							}
							$grupo = ($unidade == '');
							$inativo = ((stripos(($descricao), 'excluso')) !== false);
							$nao_alocavel  = strtoupper($nao_alocavel);
							if($nao_alocavel == ''){
								$nao_alocavel = 'N';
							}else if($nao_alocavel == 'R'){
								$nao_alocavel = 'R';
							}else{
								$nao_alocavel = 'S';
							}
							if($grupo === true){
								$unidade = '';
								$qtd = 0;
								$custo_mo = 0;
								$custo_mat_emp = 0;
								$valor_unit = 0;
								$valor_total = 0; //reseta valor total do grupo
								$conta_gerencial = '';
								$nao_alocavel = 'N';
							}

							$descricao = trim(str_ireplace(array(' - Excluso', 'Excluso'), array('', ''), $descricao));

							if(!isset($lista_dados[$item])){
								$lista_dados[$item]['Item'] = $item;
								$lista_dados[$item]['Item_Pai'] = $item_pai;
								$lista_dados[$item]['Descricao'] = $descricao;
								$lista_dados[$item]['Unidade'] = $unidade;
								$lista_dados[$item]['Qtd'] = $qtd;
								$lista_dados[$item]['Custo_MO'] = $custo_mo;
								$lista_dados[$item]['Custo_Mat_Emp'] = $custo_mat_emp;
								$lista_dados[$item]['Valor_Unitario'] = $valor_unit;
								$lista_dados[$item]['Valor_Total'] = $valor_total;
								$lista_dados[$item]['Conta_Gerencial'] = $conta_gerencial;
								$lista_dados[$item]['Nao_Alocavel'] = $nao_alocavel;
								$lista_dados[$item]['Grupo'] = $grupo;
								$lista_dados[$item]['Inativo'] = $inativo;
								$lista_dados[$item]['Nivel'] = substr_count($item, '.');
							}else{
								$avisos[$a]['Mensagem'] = 'Item <b>"'.$item.' - '.$descricao.'"</b> duplicado!';
								$a++;
							}
						}
					}
				}
			}

			if(!empty($lista_dados)){
				$lista_dados = array_orderby($lista_dados, 'Nivel', SORT_ASC);
			}
		}

		return array(
			'Dados' => $lista_dados,
			'Avisos' => $avisos
		);
	}
?>