<?php
	function boleto_ocorrencia_descricao($erro){
		$erro = fill_full($erro, 2);
		$retorno = '';
		if($erro == "03"){
			$retorno = '03 - Entrada Rejeitada';
		}else if($erro == "26"){
			$retorno = '26 - Instruo Rejeitada';
		}else if($erro == "30"){
			$retorno = '30 - Alterao de Dados Rejeitada';
		}else if($erro == "44"){
			$retorno = '44 - Ttulo pago com cheque devolvido';
		}
		return $retorno;
	}

	function pagamento_ocorrencia_descricao($erro){
		$erro = fill_full($erro, 2);
		$retorno = '';
		if($erro == "00"){ $retorno = "PAGAMENTO EFETUADO"; }else
		if($erro == "AE"){ $retorno = "DATA DE PAGAMENTO ALTERADA"; }else
		if($erro == "AG"){ $retorno = "NMERO DO LOTE INVLIDO"; }else
		if($erro == "AH"){ $retorno = "NMERO SEQUENCIAL DO REGISTRO NO LOTE INVLIDO"; }else
		if($erro == "AI"){ $retorno = "PRODUTO DEMONSTRATIVO DE PAGAMENTO NO CONTRATADO"; }else
		if($erro == "AJ"){ $retorno = "TIPO DE MOVIMENTO INVLIDO"; }else
		if($erro == "AL"){ $retorno = "CDIGO DO BANCO FAVORECIDO INVLIDO"; }else
		if($erro == "AM"){ $retorno = "AGNCIA DO FAVORECIDO INVLIDA"; }else
		if($erro == "AN"){ $retorno = "CONTA CORRENTE DO FAVORECIDO INVLIDA"; }else
		if($erro == "AO"){ $retorno = "NOME DO FAVORECIDO INVLIDO"; }else
		if($erro == "AP"){ $retorno = "DATA DE PAGAMENTO / DATA DE VALIDADE / HORA DE LANAMENTO / ARRECADAO / APURAO INVLIDA"; }else
		if($erro == "AQ"){ $retorno = "QUANTIDADE DE REGISTROS MAIOR QUE 999999"; }else
		if($erro == "AR"){ $retorno = "VALOR ARRECADADO / LANAMENTO INVLIDO"; }else
		if($erro == "BC"){ $retorno = "NOSSO NMERO INVLIDO"; }else
		if($erro == "BD"){ $retorno = "PAGAMENTO AGENDADO"; }else
		if($erro == "BE"){ $retorno = "PAGAMENTO AGENDADO COM FORMA ALTERADA PARA OP"; }else
		if($erro == "BI"){ $retorno = "CNPJ / CPF DO FAVORECIDO NO SEGMENTO J-52 ou B INVLIDO"; }else
		if($erro == "BL"){ $retorno = "VALOR DA PARCELA INVLIDO"; }else
		if($erro == "CD"){ $retorno = "CNPJ / CPF INFORMADO DIVERGENTE DO CADASTRADO"; }else
		if($erro == "CE"){ $retorno = "PAGAMENTO CANCELADO"; }else
		if($erro == "CF"){ $retorno = "VALOR DO DOCUMENTO INVLIDO"; }else
		if($erro == "CG"){ $retorno = "VALOR DO ABATIMENTO INVLIDO"; }else
		if($erro == "CH"){ $retorno = "VALOR DO DESCONTO INVLIDO"; }else
		if($erro == "CI"){ $retorno = "CNPJ / CPF / IDENTIFICADOR / INSCRIO ESTADUAL / INSCRIO NO CAD / ICMS INVLIDO"; }else
		if($erro == "CJ"){ $retorno = "VALOR DA MULTA INVLIDO"; }else
		if($erro == "CK"){ $retorno = "TIPO DE INSCRIO INVLIDA"; }else
		if($erro == "CL"){ $retorno = "VALOR DO INSS INVLIDO"; }else
		if($erro == "CM"){ $retorno = "VALOR DO COFINS INVLIDO"; }else
		if($erro == "CN"){ $retorno = "CONTA NO CADASTRADA"; }else
		if($erro == "CO"){ $retorno = "VALOR DE OUTRAS ENTIDADES INVLIDO"; }else
		if($erro == "CP"){ $retorno = "CONFIRMAO DE OP CUMPRIDA"; }else
		if($erro == "CQ"){ $retorno = "SOMA DAS FATURAS DIFERE DO PAGAMENTO"; }else
		if($erro == "CR"){ $retorno = "VALOR DO CSLL INVLIDO"; }else
		if($erro == "CS"){ $retorno = "DATA DE VENCIMENTO DA FATURA INVLIDA"; }else
		if($erro == "DA"){ $retorno = "NMERO DE DEPEND. SALRIO FAMILIA INVALIDO"; }else
		if($erro == "DB"){ $retorno = "NMERO DE HORAS SEMANAIS INVLIDO"; }else
		if($erro == "DC"){ $retorno = "SALRIO DE CONTRIBUIO INSS INVLIDO"; }else
		if($erro == "DD"){ $retorno = "SALRIO DE CONTRIBUIO FGTS INVLIDO"; }else
		if($erro == "DE"){ $retorno = "VALOR TOTAL DOS PROVENTOS INVLIDO"; }else
		if($erro == "DF"){ $retorno = "VALOR TOTAL DOS DESCONTOS INVLIDO"; }else
		if($erro == "DG"){ $retorno = "VALOR LQUIDO NO NUMRICO"; }else
		if($erro == "DH"){ $retorno = "VALOR LIQ. INFORMADO DIFERE DO CALCULADO"; }else
		if($erro == "DI"){ $retorno = "VALOR DO SALRIO-BASE INVLIDO"; }else
		if($erro == "DJ"){ $retorno = "BASE DE CLCULO IRRF INVLIDA"; }else
		if($erro == "DK"){ $retorno = "BASE DE CLCULO FGTS INVLIDA"; }else
		if($erro == "DL"){ $retorno = "FORMA DE PAGAMENTO INCOMPATVEL COM HOLERITE"; }else
		if($erro == "DM"){ $retorno = "E-MAIL DO FAVORECIDO INVLIDO"; }else
		if($erro == "DV"){ $retorno = "DOC / TED DEVOLVIDO PELO BANCO FAVORECIDO"; }else
		if($erro == "D0"){ $retorno = "FINALIDADE DO HOLERITE INVLIDA"; }else
		if($erro == "D1"){ $retorno = "MS DE COMPETENCIA DO HOLERITE INVLIDA"; }else
		if($erro == "D2"){ $retorno = "DIA DA COMPETENCIA DO HOLETITE INVLIDA"; }else
		if($erro == "D3"){ $retorno = "CENTRO DE CUSTO INVLIDO"; }else
		if($erro == "D4"){ $retorno = "CAMPO NUMRICO DA FUNCIONAL INVLIDO"; }else
		if($erro == "D5"){ $retorno = "DATA INCIO DE FRIAS NO NUMRICA"; }else
		if($erro == "D6"){ $retorno = "DATA INCIO DE FRIAS INCONSISTENTE"; }else
		if($erro == "D7"){ $retorno = "DATA FIM DE FRIAS NO NUMRICO"; }else
		if($erro == "D8"){ $retorno = "DATA FIM DE FRIAS INCONSISTENTE"; }else
		if($erro == "D9"){ $retorno = "NMERO DE DEPENDENTES IR INVLIDO"; }else
		if($erro == "EM"){ $retorno = "CONFIRMAO DE OP EMITIDA"; }else
		if($erro == "EX"){ $retorno = "DEVOLUO DE OP NO SACADA PELO FAVORECIDO"; }else
		if($erro == "E0"){ $retorno = "TIPO DE MOVIMENTO HOLERITE INVLIDO"; }else
		if($erro == "E1"){ $retorno = "VALOR 01 DO HOLERITE / INFORME INVLIDO"; }else
		if($erro == "E2"){ $retorno = "VALOR 02 DO HOLERITE / INFORME INVLIDO"; }else
		if($erro == "E3"){ $retorno = "VALOR 03 DO HOLERITE / INFORME INVLIDO"; }else
		if($erro == "E4"){ $retorno = "VALOR 04 DO HOLERITE / INFORME INVLIDO"; }else
		if($erro == "FC"){ $retorno = "PAGAMENTO EFETUADO ATRAVS DE FINANCIAMENTO COMPROR"; }else
		if($erro == "FD"){ $retorno = "PAGAMENTO EFETUADO ATRAVS DE FINANCIAMENTO DESCOMPROR"; }else
		if($erro == "HA"){ $retorno = "ERRO NO LOTE"; }else
		if($erro == "HM"){ $retorno = "ERRO NO REGISTRO HEADER DE ARQUIVO"; }else
		if($erro == "IB"){ $retorno = "VALOR DO DOCUMENTO INVLIDO"; }else
		if($erro == "IC"){ $retorno = "VALOR DO ABATIMENTO INVLIDO"; }else
		if($erro == "ID"){ $retorno = "VALOR DO DESCONTO INVLIDO"; }else
		if($erro == "IE"){ $retorno = "VALOR DA MORA INVLIDO"; }else
		if($erro == "IF"){ $retorno = "VALOR DA MULTA INVLIDO"; }else
		if($erro == "IG"){ $retorno = "VALOR DA DEDUO INVLIDO"; }else
		if($erro == "IH"){ $retorno = "VALOR DO ACRSCIMO INVLIDO"; }else
		if($erro == "II"){ $retorno = "DATA DE VENCIMENTO INVLIDA"; }else
		if($erro == "IJ"){ $retorno = "COMPETNCIA / PERODO REFERNCIA / PARCELA INVLIDA"; }else
		if($erro == "IK"){ $retorno = "TRIBUTO NO LIQUIDVEL VIA SISPAG OU NO CONVENIADO COM ITA"; }else
		if($erro == "IL"){ $retorno = "CDIGO DE PAGAMENTO / EMPRESA /RECEITA INVLIDO"; }else
		if($erro == "IM"){ $retorno = "TIPO X FORMA NO COMPATVEL"; }else
		if($erro == "IN"){ $retorno = "BANCO/AGENCIA NO CADASTRADOS"; }else
		if($erro == "IO"){ $retorno = "DAC / VALOR / COMPETNCIA / IDENTIFICADOR DO LACRE INVLIDO"; }else
		if($erro == "IP"){ $retorno = "DAC DO CDIGO DE BARRAS INVLIDO"; }else
		if($erro == "IQ"){ $retorno = "DVIDA ATIVA OU NMERO DE ETIQUETA INVLIDO"; }else
		if($erro == "IR"){ $retorno = "PAGAMENTO ALTERADO"; }else
		if($erro == "IS"){ $retorno = "CONCESSIONRIA NO CONVENIADA COM ITA"; }else
		if($erro == "IT"){ $retorno = "VALOR DO TRIBUTO INVLIDO"; }else
		if($erro == "IU"){ $retorno = "VALOR DA RECEITA BRUTA ACUMULADA INVLIDO"; }else
		if($erro == "IV"){ $retorno = "NMERO DO DOCUMENTO ORIGEM / REFERNCIA INVLIDO"; }else
		if($erro == "IX"){ $retorno = "CDIGO DO PRODUTO INVLIDO"; }else
		if($erro == "LA"){ $retorno = "DATA DE PAGAMENTO DE UM LOTE ALTERADA"; }else
		if($erro == "LC"){ $retorno = "LOTE DE PAGAMENTOS CANCELADO"; }else
		if($erro == "NA"){ $retorno = "PAGAMENTO CANCELADO POR FALTA DE AUTORIZAO"; }else
		if($erro == "NB"){ $retorno = "IDENTIFICAO DO TRIBUTO INVLIDA"; }else
		if($erro == "NC"){ $retorno = "EXERCCIO (ANO BASE) INVLIDO"; }else
		if($erro == "ND"){ $retorno = "CDIGO RENAVAM NO ENCONTRADO/INVLIDO"; }else
		if($erro == "NE"){ $retorno = "UF INVLIDA"; }else
		if($erro == "NF"){ $retorno = "CDIGO DO MUNICPIO INVLIDO"; }else
		if($erro == "NG"){ $retorno = "PLACA INVLIDA"; }else
		if($erro == "NH"){ $retorno = "OPO/PARCELA DE PAGAMENTO INVLIDA"; }else
		if($erro == "NI"){ $retorno = "TRIBUTO J FOI PAGO OU EST VENCIDO"; }else
		if($erro == "NR"){ $retorno = "OPERAO NO REALIZADA"; }else
		if($erro == "PD"){ $retorno = "AQUISIO CONFIRMADA (EQUIVALE A OCORRNCIA 02 NO LAYOUT DE RISCO SACADO)"; }else
		if($erro == "RJ"){ $retorno = "REGISTRO REJEITADO"; }else
		if($erro == "RS"){ $retorno = "PAGAMENTO DISPONVEL PARA ANTECIPAO NO RISCO SACADO - MODALIDADE RISCO SACADO PS AUTORIZADO"; }else
		if($erro == "SS"){ $retorno = "PAGAMENTO CANCELADO POR INSUFICINCIA DE SALDO / LIMITE DIRIO DE PAGTO"; }else
		if($erro == "TA"){ $retorno = "LOTE NO ACEITO - TOTAIS DO LOTE COM DIFERENA"; }else
		if($erro == "TI"){ $retorno = "TITULARIDADE INVLIDA"; }else
		if($erro == "X1"){ $retorno = "FORMA INCOMPATVEL COM LAYOUT 010"; }else
		if($erro == "X2"){ $retorno = "NMERO DA NOTA FISCAL INVLIDO"; }else
		if($erro == "X3"){ $retorno = "IDENTIFICADOR DE NF/CNPJ INVLIDO"; }else
		if($erro == "X4"){ $retorno = "FORMA 32 INVLIDA"; }else
		if($erro == "ZA"){ $retorno = "AGNCIA / CONTA DO FAVORECIDO SUBSTIUDA"; }else
		if($erro == "ZB"){ $retorno = "Divergncia entre o primeiro e ltimo nome do beneficirio versus primeiro e ltimo nome na Receita Federal"; }else
		if($erro == "ZC"){ $retorno = "Confirmao de Antecipao de Valor"; }
		return $retorno;
	}

	function financeiro_gera_boleto_pdf(&$pdf, $empresa, $nr_contas, $seq){
		$dominios = array();
		$dominios['2'] = '2';
		$dominios['103'] = '103';
		$dominios['205'] = '205';
		$dominios['271'] = '271';
		$empresa_m = $empresa;
		if($_SESSION['Dominio'] == $dominios['2']){
			$empresa_m = '1';
		}
		if(($_SESSION['Dominio'] == 470)||($_SESSION['Dominio'] == 471)){
			$empresa_m = '1';
		}

		$canhoto = false;
		if(($_SESSION['Dominio'] =='359')&&( $_SESSION['Empresa_Codigo'] ==  '1')){
			$canhoto = true;
		}
		//consulta vencto e se j gerou barra do boleto
		$con_pago = 'SELECT DT_Pagto, Boleto_Barra FROM contas_pr'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Nr_Contas = "'.$nr_contas.'"'.
					' AND Seq = "'.$seq.'"';
		$res_pago = consulta_sql($con_pago);
		$reg_pago = consulta_ler_linha($res_pago);
		consulta_limpa($res_pago);
		//se no tem nr do boleto
		if ($reg_pago[1] == ''){
			//se tiver pago e no gerou somente sai da funo
			if($reg_pago[0] != '0000-00-00'){
				return false;
			}else{ //se no tiver pago
				//faz a gerao do cdigo segundo a empresa do contas a receber
				$ok = financeiro_gera_boleto_barra($empresa,$nr_contas,$seq);
			}
		}else{
			$ok = financeiro_gera_boleto_barra($empresa,$nr_contas,$seq);
		}
		//se no gerou somente sai (no deve ter conta definida na empresa
		//nesse caso o que vai aparecer  uma duplicata
		if($ok){
			//faz a consulta novamente e determina que boleto bancrio gerou
			$con_contas = 'SELECT * FROM contas_pr'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$empresa.'"'.
							' AND Nr_Contas = "'.$nr_contas.'"'.
							' AND Seq = "'.$seq.'"';
			$res_contas = consulta_sql($con_contas);
			$reg_contas = consulta_ler_objeto($res_contas);
			consulta_limpa($res_contas);
			//consulta dados da pessoa e pessoa_endereco do destinatrio e da empresa
			//Consulta a empresa
			$con_empresa = 'SELECT * FROM pessoa '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$empresa_m.'"';
			$res_empresa = consulta_sql($con_empresa);
			$reg_empresa = consulta_ler_objeto($res_empresa);
			consulta_limpa($res_empresa);
			//Consulta endereo da empresa
			$con_endereco_emp = 'SELECT * FROM pessoa_endereco '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Pessoa = "'.$empresa_m.'"'.
								' AND Situacao = "A" '.
								' ORDER BY Seq_Endereco';
			$res_endereco_emp = consulta_sql($con_endereco_emp);
			$reg_endereco_emp = consulta_ler_objeto($res_endereco_emp);
			consulta_limpa($res_endereco_emp);
			//consulta o telefone
			$con_telefone_emp = 'SELECT Seq_Telefone, Numero_Telefone FROM pessoa_telefone '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Pessoa = "'.$empresa_m.'"'.
								' AND Situacao = "A" '.
								' ORDER BY Seq_Telefone';
			$res_telefone_emp = consulta_sql($con_telefone_emp);
			$reg_telefone_emp = consulta_ler_linha($res_telefone_emp);
			consulta_limpa($res_telefone_emp);
			//Consulta o cliente
			$con_cliente = 'SELECT * FROM pessoa '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_contas->Pessoa.'"';
			$res_cliente = consulta_sql($con_cliente);
			$reg_cliente = consulta_ler_objeto($res_cliente);
			consulta_limpa($res_cliente);
			//Consulta endereo do cliente

			$ok_ender =  false;
			$con_endereco_cli = 'SELECT * FROM pessoa_endereco '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Pessoa = "'.$reg_contas->Pessoa.'"'.
								' AND Situacao = "A" '.
								' AND Tipo_Endereco="4"'.
								' ORDER BY Seq_Endereco';
			$res_endereco_clit = consulta_sql($con_endereco_cli);
			$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
			consulta_limpa($res_endereco_clit);
			if ($reg_endereco_clit->UF!=''){
				$ok_ender = (Zathura() );
			}else{
				$con_endereco_cli = 'SELECT * FROM pessoa_endereco '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
									' AND Pessoa = "'.$reg_contas->Pessoa.'"'.
									' AND Situacao = "A" '.
									' ORDER BY Seq_Endereco';
			}

			if(($reg_contas->Nr_Nota > 0)&&($ok_ender==false)){
				if (($reg_contas->Modelo == '01') || ($reg_contas->Modelo == '55') ||
					($reg_contas->Modelo == '65') || ($reg_contas->Modelo == '97') ||
					($reg_contas->Modelo == '98') || ($reg_contas->Modelo == '59')){
					$con_nf = 'SELECT Dest_Endereco FROM nota_fiscal '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Empresa = "'.$reg_contas->Empresa.'"'.
								' AND Nr_Nota = "'.$reg_contas->Nr_Nota.'"';
					$res_nf = consulta_sql($con_nf);
					$reg_nf = consulta_ler_linha($res_nf);
					consulta_limpa($res_nf);
					if($reg_nf[0] > 0){
						$con_endereco_cli = 'SELECT * FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_contas->Pessoa.'"'.
											' AND Seq_Endereco = "'.$reg_nf[0].'"';
					}
				}
			}
			$res_endereco_cli = consulta_sql($con_endereco_cli);
			$reg_endereco_cli = consulta_ler_objeto($res_endereco_cli);
			consulta_limpa($res_endereco_cli);

			//consulta o telefone
			$con_telefone_cli = 'SELECT Seq_Telefone, Numero_Telefone FROM pessoa_telefone '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Pessoa = "'.$reg_contas->Pessoa.'"'.
								' AND Situacao = "A" '.
								' ORDER BY Seq_Telefone';
			$res_telefone_cli = consulta_sql($con_telefone_cli);
			$reg_telefone_cli = consulta_ler_linha($res_telefone_cli);
			consulta_limpa($res_telefone_cli);
			$pdf_p = &$pdf;
			//gera a impresso segundo o banco/carteira/convenio
			$pdf->AddPage();

			if($reg_contas->Boleto_Banco == '001'){  //banco brasil
				financeiro_gera_boleto_pdf_bb($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if(($reg_contas->Boleto_Banco == '033')||($reg_contas->Boleto_Banco=='353')){
				financeiro_gera_boleto_pdf_santander($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '104'){  //caixa
				financeiro_gera_boleto_pdf_caixa($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '237'){  //bradesco
				financeiro_gera_boleto_pdf_bradesco($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '341'){  //itau
				financeiro_gera_boleto_pdf_itau($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '399'){  //hsbc
				financeiro_gera_boleto_pdf_hsbc($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '748'){  //sicredi
                //Modificao para Adri Doce 21/09/2020
                if($canhoto){
                    financeiro_gera_boleto_pdf_sicred_canhoto($pdf_p,$reg_contas,
                                                $reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
                                                $reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
                }else{
                    financeiro_gera_boleto_pdf_sicred($pdf_p,$reg_contas,
                                                $reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
                                                $reg_cliente,$reg_endereco_cli,$reg_telefone_cli);    
                }
			}else if($reg_contas->Boleto_Banco == '756'){  //sicoob
				financeiro_gera_boleto_pdf_sicoob($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '085'){  //cecred
				financeiro_gera_boleto_pdf_cecred($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}else if($reg_contas->Boleto_Banco == '041'){  //banrisul
				financeiro_gera_boleto_pdf_banrisul($pdf_p,$reg_contas,
												$reg_empresa,$reg_endereco_emp,$reg_telefone_emp,
												$reg_cliente,$reg_endereco_cli,$reg_telefone_cli);
			}
			//coloca observes
			$pdf->SetFont('Courier','',8);
			$pdf->x=8;
			$pdf->y=10;

			$con_remessa = 'SELECT Mensagens, Informativo, Nr_Envio FROM banco_envio_det '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Contas_Empresa = "'.$empresa.'"'.
							' AND Contas_Nr_Contas = "'.$nr_contas.'"'.
							' AND Contas_Seq = "'.$seq.'"'.
							' ORDER BY Nr_Envio DESC '.
							' LIMIT 1';
			$res_remessa = consulta_sql($con_remessa);
			$reg_remessa = consulta_ler_linha($res_remessa);
			consulta_limpa($res_remessa);
			if($reg_contas->Boleto_Banco == '748'){

				if( $canhoto){
					//Adri Doce Boleto com canhoto 22/09/2020
					$pdf->SetFont('Arial','B',8);
					$ln = 44;						$col = 8;						$tam = 192;
					$pdf->x=$col ;
					$pdf->y=$ln ;

					//$y=$pdf->y;
					$pdf->Cell($tam, 5,  'INFORMATIVO', 0, 0,'C');
					$ln+=8; //$col+=8;
					$pdf->x =$col;
					$pdf->y =$ln;

					$pdf->SetFont('Courier','',8);
					$ln+=8;// $col+=8;

					$pdf->y =$ln;

					if(trim($reg_remessa[1]) != ''){

						$y=$pdf->y;
						$ln+=3; //$col+=8;
						$pdf->Cell($tam ,3,  trim(str_replace(';','
', UpperDados(utf8_decode_si($reg_remessa[1])))), 0, 0,'L');
						$pdf->y= $ln;    
					}else if ($reg_remessa[2] == ''){
						$pdf->MultiCell($tam ,3,  trim(str_replace(';','
', BuscaParam('BOLETO_INFORMATIVO'))), 0,'L');
						$ln+=3;// $col+=8;
						$pdf->y= $ln; //$y+3;
						//$pdf->x= $col;
					}
				}else{
					$pdf->SetFont('Arial','B',8);
					$pdf->x=8;
					$pdf->y=9.3;

					$y=$pdf->y;
					$pdf->MultiCell(192,5,  'INFORMATIVO', 0,'C');
					$pdf->y=$y+8;
					$pdf->x=8;

					$pdf->SetFont('Courier','',8);
					$pdf->x=8;
					$pdf->y=16;

					if(trim($reg_remessa[1]) != ''){
						$y=$pdf->y;
						$pdf->MultiCell(192,3,  trim(str_replace(';','
', UpperDados(utf8_decode_si($reg_remessa[1])))), 0,'L');
						$pdf->y=$y+3;
						$pdf->x=8;
					}else if ($reg_remessa[2] == ''){
						$y=$pdf->y;
						$pdf->MultiCell(192,3,  trim(str_replace(';','
', BuscaParam('BOLETO_INFORMATIVO'))), 0,'L');
						$pdf->y=$y+3;
						$pdf->x=8;
					}

				}
				
			}
			$pdf->SetFont('Arial','B',8);
			$pdf->x=8;
			$pdf->y=108;

			if($reg_contas->Boleto_Banco == '001'){
				$pdf->y=108-68;
			}
			if(($reg_contas->Boleto_Banco == '033') || ($reg_contas->Boleto_Banco == '353')){
				$pdf->y=108-68;
			}
			if($reg_contas->Boleto_Banco == '104'){
				$pdf->y=108-65+26;
			}
			if($reg_contas->Boleto_Banco == '748'){
				if($canhoto){
					//$pdf->SetFont('Arial','',6);
					$alt= 3; $ln=138;
					$pdf->x=8;
					$pdf->y=$ln;

					//texto livre
					$pdf->SetFont('Arial','B',6);

					$y=$pdf->y;
					$pdf->Cell(100, $alt, 'Aps vencimento, cobrar multa de '.formata_qtd($reg_contas->Multa_Perc,2,false).'% ', 0,0,'L');
					//$pdf->y=$y+5;

					//$pdf->Cell( 190,$alt, 'Recebimento atravs do cheque n             	 do Banco ', 0,0,'L');
					$ln+=3;
					$pdf->y=$ln;
					$pdf->x=8;
					//$pdf->Cell( 100,$alt, 'Esta quitao somente ter validade aps pagamento do cheque pelo banco Sacado ', 0,0,'L');

					$pdf->Cell(100,$alt, 'Remeter a cartrio '.$reg_contas->Dias_Protesto.' dias aps o vencimento.', 0,0,'L');

					$y= $pdf->y;
					$pdf->y=$y+5;
					$pdf->x=8;
					$pdf->SetFont('Arial','B',8);

				}else{
					$pdf->y=108-4;
				}
			}
			if($reg_contas->Boleto_Banco == '341'){
				$pdf->y=108-10;
			}
			if($reg_contas->Boleto_Banco == '085'){
				$pdf->y=108-51;
			}
			if($reg_contas->Boleto_Banco == '041'){
				$pdf->y=108-65;
			}
			$BOLETO_OBS = BuscaParam('BOLETO_OBS');

			for($c=0;$c<=1;$c++){
				if(($reg_contas->Boleto_Banco == '748') && ($reg_contas->Dominio != '1')){
					if( $reg_contas->Dominio == '359') {
						$pdf->y=205;
					}
					if($reg_contas->Modelo!=99){
						$tipo = 'NF';
					}else{
						$tipo = 'Doc';
					}

					if($canhoto){
						$y=$pdf->y;
						$pdf->Cell( 100,7, 'Ref. '. $tipo.' '.$reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo, 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x=$col;
					}else{
						$y=$pdf->y;
						$pdf->Cell(100,7, 'Ref. '.$tipo.' '.$reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo, 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x=8;
					}
				}
				$valor_juros = ($reg_contas->Valor*((($reg_contas->Juros_Perc)/100)/30));
				if($valor_juros < 0.01){
					$valor_juros = 0;
				}
				$valor_juros = arredonda_numero_menos($valor_juros*100)/100;
				if($_SESSION["Dominio"] == '44'){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Aps vencimento cobrar multa de 2% e juros de 1% ao ms.', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else if ($_SESSION["Dominio"] == $dominios['205']){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Aps vencimento, cobrar multa de '.formata_qtd($reg_contas->Multa_Perc,2,false).'% e juros de '.formata_qtd($reg_contas->Juros_Perc,2,true).'% ao ms', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else if ((($reg_contas->Juros_Perc>0)&&(formata_qtd($valor_juros,2,true) != '0,00')) && ($_SESSION['Dominio'] != $dominios['271'])){
					$y=$pdf->y;
					if ($_SESSION["Dominio"] == '2'){
						$pdf->Cell(100,7, 'Aps o vencimento cobrar juros'.
											' de mora de '.formata_qtd($reg_contas->Juros_Perc,2,true).
											'% a.m.', 0,0,'L');
					}else if(  ($_SESSION['Dominio'] == 358 ) ){
						/**Modificacao para o dominio  358 
						 * ($_SESSION['Dominio'] == 359) &&( $_SESSION['Empresa_Codigo'] == '3031')
						 */
						$pdf->Cell(100,7, 'Aps o vencimento cobrar R$ '.formata_qtd($valor_juros,2,true) .' por dia de atraso.', 0,0,'L');
					}else if(  ($_SESSION['Dominio'] == 470 )|| ($_SESSION['Dominio'] == 471 )){
						//APS 1 DIA(S) CORRIDO(S) DO VENCIMENTO COBRAR JUROS DE......... 5,90% AO MS
						//BAIXAR APS 58 DIAS CORRIDOS DO VENCIMENTO
						$pdf->Cell(100,7, 'APS 1 DIA(S) CORRIDO(S) DO VENCIMENTO COBRAR JUROS DE......... '.formata_qtd($reg_contas->Juros_Perc,2,true) .'% AO MS', 0,0,'L');
					}else{
						$pdf->Cell(100,7, 'Aps o vencimento cobrar mora diria de'.
											' R$ '.formata_qtd($valor_juros,2,true), 0,0,'L');
					}
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else if ($_SESSION["Dominio"] == '2'){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Aps o vencimento cobrar juros'.
										' de mora de '.formata_qtd(2,2,true).
										'% a.m.', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}
				if(($_SESSION["Dominio"]=='44') || ($_SESSION["Dominio"] == $dominios['205']) || ($_SESSION["Dominio"] == $dominios['271'])){

				}else if(  ($_SESSION['Dominio'] == 358 ) ){
					/**Usando o Dominio 359 como teste. Modificacao para o Dominio  358 
					 * ($_SESSION['Dominio'] == 359) &&( $_SESSION['Empresa_Codigo'] == '3031')
					*/
					if ($reg_contas->Multa_Perc >0){
						$y=$pdf->y;
						$valor_multa =  $reg_contas->Valor_Original * ($reg_contas->Multa_Perc/100);
						//
						$pdf->Cell(100,7, 'Aps o vencimento cobrar multa de R$ '.formata_qtd($valor_multa, 2 , true)   , 0,0,'L');
						//$pdf->Cell(100,7, 'Aps o vencimento cobrar multa de '.formata_qtd($reg_contas->Multa_Perc,2,false).'% modfiicado em 18-01-2023', 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x=8;
					}
				}else if ($reg_contas->Multa_Perc >0){
					//if( $canhoto){
						$y=$pdf->y;
						$pdf->Cell(100,7, 'Aps o vencimento cobrar multa de '.formata_qtd($reg_contas->Multa_Perc,2,false).'%', 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x= 8 ;
					// }else{
					// 	$y=$pdf->y;
					// 	$pdf->Cell(100,7, 'Aps o vencimento cobrar multa de ' .formata_qtd($reg_contas->Multa_Perc,2,false).'%', 0,0,'L');
					// 	$pdf->y=$y+4.5;
					// 	$pdf->x=8;
					// }
					
				}
				if ($reg_contas->Desconto_Pontual > 0){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Desconto de Pontualidade: '.formata_qtd($reg_contas->Desconto_Pontual,2,false).'%', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else{
					$con_pes_cli = 'SELECT PercDescBoleto FROM pessoa_cliente '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
									' AND Pessoa = "'.$reg_contas->Pessoa.'"';
					$res_pes_cli = consulta_sql($con_pes_cli);
					$reg_pes_cli = consulta_ler_linha($res_pes_cli);
					consulta_limpa($res_pes_cli);
					
					$valor_descto = ($reg_contas->Valor*((($reg_pes_cli[0])/100)));
					if($valor_descto < 0.01){
						$valor_descto = 0;
					}
					$valor_descto = arredonda_numero_menos($valor_descto*100)/100;
					
					if ($valor_descto>0){
						$y=$pdf->y;
						$pdf->Cell(100,7, 'Pagar c/ Desconto de R$ '.formata_qtd($valor_descto,2,true).' at o vencimento.', 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x=8;
					}
				}
				if($_SESSION["Dominio"] == $dominios['271']){
					if(($reg_contas->Multa_Perc > 0) || ($reg_contas->Juros_Perc > 0)){
						$msg_multa_juros = '';
						if($reg_contas->Juros_Perc > 0){
							$msg_multa_juros = formata_qtd($reg_contas->Juros_Perc,2,true).'% JUROS AO MS';
						}
						if($reg_contas->Multa_Perc > 0){
							if($msg_multa_juros != ''){
								$msg_multa_juros.= ' E ';
							}
							$msg_multa_juros.= 'MULTA DE '.formata_qtd($reg_contas->Multa_Perc,2,false).'%';
						}
						$y=$pdf->y;
						$pdf->Cell(100,7, 'APS VENC, COBRAR: '.$msg_multa_juros, 0,0,'L');
						$pdf->y=$y+4.5;
						$pdf->x=8;
					}
				}

				if(($_SESSION["Dominio"] == '44') || ($_SESSION["Dominio"] == '62')){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Remeter a cartrio 30 dias aps o vencimento.', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else if($_SESSION["Dominio"] == '2'){
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Protestar aps 10 dias do vencimento', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
					//----------------
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Protestar por falta de aceite e/ou pagamento.', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}else if ($reg_contas->Dias_Protesto > 0){
					$y=$pdf->y;

					//BAIXAR APS 58 DIAS CORRIDOS DO VENCIMENTO

					if($_SESSION["Dominio"] == $dominios['99']){
						$pdf->Cell(100,7, 'TTULO SUJEITO A PROTESTO APS '.$reg_contas->Dias_Protesto.' DIAS VENCIDOS.', 0,0,'L');
					}if($_SESSION["Dominio"] == $dominios['271']){
						$pdf->Cell(100,7, 'NEGATIVAR NO SERASA APS '.$reg_contas->Dias_Protesto.' DIAS CORRIDOS DO VENCIMENTO.', 0,0,'L');
					}else if($_SESSION["Dominio"] == $dominios['103']){
						$pdf->Cell(100,7, 'Remeter ao SERASA '. $reg_contas->Dias_Protesto.' dias aps o vencimento.', 0,0,'L');
					}else if($_SESSION["Dominio"] == $dominios['205']){
						// $pdf->Cell(100,7, $reg_contas->Dias_Protesto.' dias de atraso enviar para SERASA, com acrscimo de R$ 27,99 de taxas.', 0,0,'L');
						// $pdf->y=$y+4.5;
						// $pdf->x=8;
						// $pdf->Cell(100,7, '30 dias de atraso enviar para Cartrio, com acrscimo de R$ 182,00 de taxas.', 0,0,'L');
					    $pdf->Cell(100,7, 'Aps '.$reg_contas->Dias_Protesto.' dias enviar para protesto', 0,0,'L');
					}else if(($_SESSION["Dominio"] == 470)||($_SESSION["Dominio"] == 471)){
						$pdf->Cell(100,7, 'BAIXAR APS '. $reg_contas->Dias_Protesto.' DIAS CORRIDOS DO VENCIMENTO', 0,0,'L');
					}else{
						if($canhoto){
							$ln += 4.5;
							$y=$ln;
							$pdf->Cell(100,7, 'Remeter a cartrio '.$reg_contas->Dias_Protesto.' dias aps o vencimento.', 0,0,'L');
						
						}else if(  ($_SESSION['Dominio'] == 358 ) ){
							//modificacao para o dominio 358 realizado em 18/01/2023 por @isabel
							//($_SESSION['Dominio'] == 359) &&( $_SESSION['Empresa_Codigo'] == '3031')
							$pdf->Cell(125,6, 'No '.$reg_contas->Dias_Protesto.' dia corrido aps o vencimento ser enviado AUTOMATICAMENTE para o SERASA.', 0,0,'L');
						}else if( ($_SESSION['Dominio'] == '115' ) && ( $reg_contas->Boleto_Banco == '085' ) ){
							//Adicionado em 04/08/2023 para DOMINIO 115 BANCO 085  por @isabel
							$pdf->Cell(125,6, 'Protestar aps '.$reg_contas->Dias_Protesto.' dias corridos do vencimento.', 0,0,'L');
						}else{
							$pdf->Cell(100,7, 'Remeter a cartrio '.$reg_contas->Dias_Protesto.' dias aps o vencimento.', 0,0,'L');
						}
						
					}
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}

				if (($_SESSION["Dominio"] == $dominios['2']) && ($empresa != '1')){
					$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
									' AND Pessoa = "'.$empresa.'"';
					$res_empresa = consulta_sql($cons_empresa);
					$reg_empresa = consulta_ler_linha($res_empresa);
					consulta_limpa($res_empresa);
					$y=$pdf->y;
					$pdf->Cell(100,7, 'Ttulo cedido pela filial de '.$reg_empresa[0].'.', 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}
				if($_SESSION["Dominio"] == $dominios['271']){
					//$y=$pdf->y;
					//$pdf->Cell(100,7, 'MANTER DESCONTO AT O VENCIMENTO', 0,0,'L');
					//$pdf->y=$y+4.5;
					//$pdf->x=8;
					//$y=$pdf->y;
					//$pdf->Cell(100,7, 'Aps vencimento, cobrar 1,00% juros ao ms e multa de 2,00%', 0,0,'L');
					//$pdf->y=$y+4.5;
					//$pdf->x=8;
				}
				if ($BOLETO_OBS!=''){
					// $y=$pdf->y;
					// $pdf->Cell(100,7, $BOLETO_OBS, 0,0,'L');
					// $pdf->y=$y+4.5;
					// $pdf->x=8;


					//
					$y=($pdf->y+0);
					$pdf->MultiCell(125,4,   $BOLETO_OBS , '1','L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}
				if ($_SESSION["Dominio"] == 2){
					//$y=$pdf->y;
					//$pdf->Cell(100,7, 'PAGUE COM PIX E CONCORRA A BRINDES MENSAIS!', 0,0,'L');
					//$pdf->y=$y+4.5;
					//$pdf->x=8;
					$y=$pdf->y;
					$pdf->Cell(100,7, 'CHAVE PIX  76.676.436/0001-67 ' , 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}
				if(  ($_SESSION['Dominio'] == 358 ) ){
					//($_SESSION['Dominio'] == 359) &&( $_SESSION['Empresa_Codigo'] == '3031')
					//modificacao para o dominio 358 realizado em 18/01/2023 por @isabel
					$atencao = 'ATENO: Pagamento somente na rede bancria. No autorizado o recebimento em mos.';
					$y=$pdf->y;
					$pdf->Cell(125,6, $atencao, 0,0,'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;

					$caixa ='Sr. Caixa, aps o 25 dia corrido do vencimento, NO autorizado o recebimento pela rede bancria.';
					// $y=$pdf->y;
					// $pdf->Cell(125,4,  $caixa , 1,0,'L');
					// $pdf->y=$y+4.5;
					// $pdf->x=8;
					$y=$pdf->y;
					$pdf->MultiCell(125, 5,  $caixa , '0','L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
					
				}
				$dominio_alves = (($_SESSION['Dominio']=='xx')||($_SESSION['Dominio']=='62'));
				if (($reg_contas->Observacao_Boleto !='') &&(!$dominio_alves)){
					$pdf->SetFont('Arial','',8);
					$pdf->y=$pdf->y+2;

					$y=$pdf->y;
					$pdf->MultiCell(120,5, $reg_contas->Observacao_Boleto, '','L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
					
					$pdf->SetFont('Arial','B',8);
				}
				/**Modificado para Dominio 62 (usando Dominio 2 como teste) em 15/08/2023 por @isabel */
                $exibe_alves = false;
				$valor_atual_reajuste = 0;
                if( $dominio_alves ){
                    if( $reg_contas->Parcela > 1){
                        //busca data de reajuste da Parcela anterior e o valor de reajuste
                        $cons_parc_ant= 'SELECT DT_Reajuste, Acrescimo_Pre_Aprovado FROM contas_pr '.
                                        ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
                                        ' AND Empresa= "'.$reg_contas->Empresa.'" '.
                                        ' AND Pessoa = "'.$reg_contas->Pessoa.'"'.
                                        ' AND Nr_Nota= "'.$reg_contas->Nr_Nota.'"'.
                                        ' AND Modelo = "'.$reg_contas->Modelo.'"'.
                                        ' AND Serie = "'.$reg_contas->Serie.'"'.
                                        ' AND Nr_Doc = "'.$reg_contas->Nr_Doc.'"'.  
                                        ' AND Parcela="'.($reg_contas->Parcela -1).'"';
                        $res_parc_ant = consulta_sql($cons_parc_ant);
                        $reg_parc_ant = consulta_ler_linha($res_parc_ant);
                        consulta_limpa($res_parc_ant);
                        if($reg_contas->DT_Reajuste !=$reg_parc_ant[0] ){
                            $exibe_alves = true;
							$valor_atual_reajuste = $reg_contas->Acrescimo_Pre_Aprovado-$reg_parc_ant[1] ;
							if( $valor_atual_reajuste <0){
								$valor_atual_reajuste = 0;
							}
                        }
                    }
                }
				if(  $exibe_alves  && ( $valor_atual_reajuste > 0) ){
					$pdf->SetFont('Arial','',8);
					$pdf->y=$pdf->y+2;
					$y=$pdf->y;
					$pdf->MultiCell(120,5, $reg_contas->Observacao_Boleto. ' ( R$ '.formata_qtd( $valor_atual_reajuste ,2,true).')' , '','L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
					$pdf->SetFont('Arial','B',8);
				}
				$pdf->y=$pdf->y+1;
				//consulta remessa.
				if (trim($reg_remessa[0])!=''){
					$y=$pdf->y;
					$pdf->MultiCell(100,5,  trim(str_replace(';','
', $reg_remessa[0])), 0,'L');
					//$pdf->MultiCell($w, $h, $nm_reduzida,                                   $border, 'L');
					$pdf->y=$y+4.5;
					$pdf->x=8;
				}
				$pdf->x=8;
				$pdf->y=207;
				if($reg_contas->Boleto_Banco=='001'){
					$pdf->y=207+1;
				}
				if(($reg_contas->Boleto_Banco=='033')||($reg_contas->Boleto_Banco=='353')){
					$pdf->y=207+1;
				}
				if($reg_contas->Boleto_Banco=='104'){
					$pdf->y=207-3+26;
				}
				if($reg_contas->Boleto_Banco=='748'){
					$pdf->y=207-4;
				}
				if($reg_contas->Boleto_Banco=='341'){
					$pdf->y=207-4;
				}
				if($reg_contas->Boleto_Banco=='085'){
					$pdf->y=158-4;
				}
				if($reg_contas->Boleto_Banco=='041'){
					$pdf->y=207-3;
				}
				if( $reg_contas->Dominio == '359') {
					$c+=2; 
				}
			}
		}
		return $ok;
	}

	function financeiro_gera_boleto_barra($empresa,$nr_contas,$seq,$conta_boleto=0){
		$dominios = array();
		$dominios['2'] = '2';
		$empresa_m = $empresa;
		if($_SESSION['Dominio'] == $dominios['2']){
			$empresa_m = '1';
		}
		if(($_SESSION['Dominio'] == 470)||($_SESSION['Dominio'] == 471)){
			$empresa_m = '1';
		}
		//conuslta a empresa (para saber qual a conta de boleto bancrio)
		$con_contas = 'select * from contas_pr '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$empresa.'"'.
						' and Nr_Contas="'.$nr_contas.'"'.
						' and Seq="'.$seq.'"';
		$res_contas = consulta_sql($con_contas);
		$reg_contas = consulta_ler_objeto($res_contas);
		consulta_limpa($res_contas);
		$barra_boleto = '';
		$nosso_numero = 0;
		$banco    = '';
		$conta    = '';
		$agencia  = '';
		$convenio = '';
		$variacao = '';
		$carteira = '';
		$nummoeda = "9";
		//calcula seu numero
		if($reg_contas->Boleto_SeuNumero<=0){
			financeiro_gera_boleto_seunumero($empresa, $nr_contas, $seq);
		}
		if (($reg_contas->Boleto_Carteira=='11')&& //nessa carteira quem gera o nosooNumero  o Banco
			($reg_contas->Boleto_Banco=='001')){
			$ok_conta = true;
			$banco    = $reg_contas->Boleto_Banco;
			$conta    = $reg_contas->Boleto_NrConta;
			$agencia  = $reg_contas->Boleto_NrAgencia;
			$convenio = $reg_contas->Boleto_NrConvenio;
			$variacao = $reg_contas->Boleto_Carteira_Variacao;
			$carteira = $reg_contas->Boleto_Carteira;
			$nosso_numero = $reg_contas->Boleto_NossoNumero;
			$reg_emp[0] = $reg_contas->Boleto_Conta;
		}else if ($reg_contas->Boleto_NossoNumero>0){
			$ok_conta = true;
			$banco    = $reg_contas->Boleto_Banco;
			$conta    = $reg_contas->Boleto_NrConta;
			$agencia  = $reg_contas->Boleto_NrAgencia;
			$convenio = $reg_contas->Boleto_NrConvenio;
			$variacao = $reg_contas->Boleto_Carteira_Variacao;
			$carteira = $reg_contas->Boleto_Carteira;
			$nosso_numero = $reg_contas->Boleto_NossoNumero;
			$reg_emp[0] = $reg_contas->Boleto_Conta;
		}else{
			if ($conta_boleto==0){
				$con_emp = 'select Boleto_Conta from pessoa_empresa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$empresa_m.'"';
				$res_emp = consulta_sql($con_emp);
				$reg_emp = consulta_ler_linha($res_emp);
				consulta_limpa($res_emp);

			}else{
				$reg_emp[0] = $conta_boleto;
			}
			//se conta no for > 0
			if ($reg_emp[0] <= 0){
				//retorna false
				$ok_conta = false;
			}else{//seno
				//consulta conta da empresa
				$con_cnt = 'select * from pessoa_conta '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$empresa_m.'"'.
							' and Seq_Conta="'.$reg_emp[0].'"';
				$res_cnt = consulta_sql($con_cnt);
				$reg_cnt = consulta_ler_objeto($res_cnt);
				consulta_limpa($res_cnt);
				$ok_conta = false;

				if ($reg_cnt->Banco == '001'){
					//barra dessas carteiras
					if (($reg_cnt->Carteira=='17')||
						($reg_cnt->Carteira=='18')||
						($reg_cnt->Carteira=='19')){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco = $reg_cnt->Banco;
							$conta    = fill_full($reg_cnt->Numero_Conta,8);
							$agencia  = fill_full($reg_cnt->Agencia,4);
							$convenio = $reg_cnt->Convenio;
							$variacao = $reg_cnt->Variacao;
							$carteira = $reg_cnt->Carteira;
							if ($variacao==''){
								$variacao= '19';
							}
							$ok_conta = true;
						}
					}else if ($reg_cnt->Carteira=='11'){
						$nosso_numero = 0;
						$banco = $reg_cnt->Banco;
						$conta    = fill_full($reg_cnt->Numero_Conta,8);
						$agencia  = fill_full($reg_cnt->Agencia,4);
						$convenio = $reg_cnt->Convenio;
						$variacao = $reg_cnt->Variacao;
						$carteira = $reg_cnt->Carteira;
						if ($variacao==''){
							$variacao= '19';
						}
						$ok_conta = true;

					}
				}else if (($reg_cnt->Banco == '033')||($reg_cnt->Banco == '353')){
					//barra dessas carteiras -santander 
					if (($reg_cnt->Carteira=='01')||
						($reg_cnt->Carteira=='02')||
						($reg_cnt->Carteira=='04')){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco = $reg_cnt->Banco;
							$conta    = fill_full($reg_cnt->Numero_Conta,7);
							$agencia  = fill_full($reg_cnt->Agencia,4);
							$convenio = fill_full($reg_cnt->Convenio,7);
							$variacao = $reg_cnt->Variacao;

							$carteira = $reg_cnt->Carteira;
							if ($variacao==''){
								$variacao= '1';
							}
							$ok_conta = true;
						}
					}
				}else if ($reg_cnt->Banco == '104'){ //se conta for do CAIXA e carteria SR
					//barra dessas carteiras
					if ($reg_cnt->Carteira=='SR'){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco    = $reg_cnt->Banco;
							$conta    = fill_full($reg_cnt->Numero_Conta,6);
							$agencia  = $reg_cnt->Agencia;
							$convenio = fill_full($reg_cnt->Convenio,7);
							$variacao = $reg_cnt->Variacao;
							$carteira = 'SR';
							//$variacao= 'CNR';
							$ok_conta = true;
						}
					}
					if ($reg_cnt->Carteira=='RG'){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco    = $reg_cnt->Banco;
							//Modificacao realizada para cendentes maiores que 11000000 [Isabel]
							//$conta    = fill_full($reg_cnt->Numero_Conta,6);
							$conta    = $reg_cnt->Numero_Conta; 
							if( $conta> 1100000){
								$conta    = fill_full($reg_cnt->Numero_Conta,7);
							}else{
								$conta    = fill_full($reg_cnt->Numero_Conta,6);
							}
							//[/Isabel]							
							$agencia  = $reg_cnt->Agencia;
							$convenio = fill_full($reg_cnt->Convenio,7);
							$variacao = $reg_cnt->Variacao;
							$carteira = 'RG';
							//$variacao= 'CNR';
							$ok_conta = true;
						}
					}
				}else if ($reg_cnt->Banco == '399'){ //se conta for do HSBC e carteria 2 = CNR
					//barra dessas carteiras
					if (($reg_cnt->Carteira=='02')||
						($reg_cnt->Carteira=='2')){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco = $reg_cnt->Banco;
							$conta    = $reg_cnt->Numero_Conta;
							$agencia  = $reg_cnt->Agencia;
							$convenio = fill_full($reg_cnt->Convenio,7);
							$variacao = $reg_cnt->Variacao;
							$carteira = '2';
							//$variacao= 'CNR';
							$ok_conta = true;
						}
					}
				}else if ($reg_cnt->Banco == '237'){ //se conta for bradesco e carteria = 09
					if (($reg_cnt->Carteira=='06')||
						($reg_cnt->Carteira=='6')||
						($reg_cnt->Carteira=='03')||
						($reg_cnt->Carteira=='3')||
						($reg_cnt->Carteira=='09')||
						($reg_cnt->Carteira=='9')){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco = $reg_cnt->Banco;
							$conta    = fill_full($reg_cnt->Numero_Conta,7);
							$agencia  = fill_full($reg_cnt->Agencia,4);
							$convenio = fill_full($reg_cnt->Convenio,7);
							$carteira = fill_full($reg_cnt->Carteira,2);
							$variacao= '0';
							$ok_conta = true;
						}
					}
				}else if ($reg_cnt->Banco == '341'){ //se conta for itau e carteria = 09
					$carteira= $reg_cnt->Variacao.
					fill_full($reg_cnt->Carteira,2);

					if (($carteira=='175')||
						($carteira=='174')||
						($carteira=='104')||
						($carteira=='178')||
						($carteira=='108')||
						($carteira=='109')||
						($carteira=='112')||
						($carteira=='157')){
						$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
						if ($nosso_numero>0){
							$banco = $reg_cnt->Banco;
							$conta    = fill_full($reg_cnt->Numero_Conta,5);
							$agencia  = fill_full($reg_cnt->Agencia,4);
							$convenio = $reg_cnt->Convenio;
							$carteira = fill_full($reg_cnt->Carteira,2);
							$variacao = $reg_cnt->Variacao;
							$ok_conta = true;
						}
					}
				}else if ($reg_cnt->Banco == '748'){ //se conta for sicredi
					$variacao = substr(fill_full($reg_cnt->Variacao,1),0,1); ;//byte_idt
					if ($variacao=='0'){
						$variacao = '2';//pelo cedente
					}
					$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta,true,$variacao);
					if ($nosso_numero>0){
						$banco    = $reg_cnt->Banco;
						$conta    = fill_full($reg_cnt->Numero_Conta,5);
						$agencia  = fill_full($reg_cnt->Agencia,4);
						$convenio = substr(fill_full($reg_cnt->Convenio,2),0,2); //posto
						$carteira = fill_full($reg_cnt->Carteira,2); //dois digitos 3(SICRED) e 1 (simples)
						$variacao = substr(fill_full($reg_cnt->Variacao,1),0,1); ;//byte_idt
						if ($variacao=='0'){
							$variacao = '2';//pelo cedente
						}
						$ok_conta = true;
					}else{
						$variacao ='';//byte_idt
					}
				}else if ($reg_cnt->Banco == '756'){ //se conta for bancoob  sicoob
					$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
					if ($nosso_numero>0){
						$banco    = $reg_cnt->Banco;
						$conta    = fill_full($reg_cnt->Numero_Conta,6);
						$agencia  = fill_full($reg_cnt->Agencia,4);
						$convenio = fill_full($reg_cnt->Convenio,6);
						$carteira = substr($reg_cnt->Carteira,0,1);
						$variacao = fill_full($reg_cnt->Variacao,2); //modalidade cobrana
						if ($carteira==''){
							$carteira = '1';
						}
						$ok_conta = true;
					}
				}else if ($reg_cnt->Banco == '085'){ //se conta for cecred
					$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
					if ($nosso_numero>0){
						$banco    = $reg_cnt->Banco;
						$conta    = fill_full($reg_cnt->Numero_Conta,7);
						$agencia  = fill_full($reg_cnt->Agencia,4);
						$convenio = fill_full($reg_cnt->Convenio,6);
						$carteira = $reg_cnt->Carteira;
						$variacao = fill_full($reg_cnt->Variacao,2); //modalidade cobrana
						if ($carteira==''){
							$carteira = '1';
						}
						$carteira = fill_full($carteira,2);
						$ok_conta = true;
					}
				}else if ($reg_cnt->Banco == '041'){ //se conta for banrisul
					$nosso_numero = financeiro_gera_boleto_nossonumero($empresa,$reg_cnt->Seq_Conta);
					if ($nosso_numero>0){
						$banco    = $reg_cnt->Banco;
						$conta    = fill_full($reg_cnt->Numero_Conta,7);
						$agencia  = fill_full($reg_cnt->Agencia,4);
						$convenio = fill_full($reg_cnt->Convenio,7);
						$carteira = substr($reg_cnt->Carteira,0,1);
						$variacao = fill_full($reg_cnt->Variacao,2); //modalidade cobrana
						if ($carteira==''){
							$carteira = '1';
						}
						$ok_conta = true;
					}
				}
			}
		}

		if ($ok_conta){
			//se conta for do BB e carteira 17 18 e 19
			if ($banco == '001'){
				// echo $banco.'-'.$carteira;
				//barra dessas carteiras
				if (($carteira=='17')||
					($carteira=='18')||
					($carteira=='19')||
					($carteira=='21')||
					($carteira=='11')){
					//gera barra boleto
					//para o banco do brasil
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$livre_zeros='000000';
					//para convenio  diferente (tem convenio com 6 7 e 8 digitos)
					if (strlen($convenio) == 8) {
						// Nosso nmero de at 9 dgitos
						$nosso_numero = fill_full($nosso_numero,9);
						$dv = financeiro_gera_boleto_bb_modulo_11("$banco$nummoeda$fator_vencimento$valor$livre_zeros$convenio$nosso_numero$carteira");
						$barra_boleto="$banco$nummoeda$dv$fator_vencimento$valor$livre_zeros$convenio$nosso_numero$carteira";
					}else if (strlen($convenio) == 7) {
						// Nosso nmero de at 10 dgitos
						$nosso_numero = fill_full($nosso_numero,10);
						$dv = financeiro_gera_boleto_bb_modulo_11("$banco$nummoeda$fator_vencimento$valor$livre_zeros$convenio$nosso_numero$carteira");
						$barra_boleto="$banco$nummoeda$dv$fator_vencimento$valor$livre_zeros$convenio$nosso_numero$carteira";
					}else if (strlen($convenio) == 6) {
						//echo '6=';
						//echo $variacao;
						if (($carteira=='17')||($carteira=='19')){
							$nosso_numero = fill_full($nosso_numero,5,0);
							$dv = financeiro_gera_boleto_bb_modulo_11("$banco$nummoeda$fator_vencimento$valor$convenio$nosso_numero$agencia$conta$carteira");
							$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$convenio$nosso_numero$agencia$conta$carteira";
						}else if ($carteira=='21'){
							$nosso_numero = fill_full($nosso_numero,17,0);
							$dv = financeiro_gera_boleto_bb_modulo_11("$banco$nummoeda$fator_vencimento$valor$convenio$nosso_numero$variacao");
							$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$convenio$nosso_numero$variacao";
						}
					}
				}
			}else if (($banco == '033')||($banco == '353')){ //se conta for do HSBC e carteria 2 = CNR
				//barra dessas carteiras
				if (($carteira=='01')||
					($carteira=='02')||
					($carteira=='04')){
					//gera barra para o hsbc
					$nosso_numero = fill_full($nosso_numero,12);
					$dig_nosso_numero = financeiro_gera_boleto_caixa_modulo_11($nosso_numero);
					//$nosso_numero.= $dig_nosso_numero;
					$vencjuliano = financeiro_gera_boleto_hsbc_dataJuliano(dataf($reg_contas->DT_Vencto));
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					// 43 numeros para o calculo do digito verificador do codigo de barras
					$dv='';
					$barra = "$banco$nummoeda$fator_vencimento$valor".'9'."$convenio$nosso_numero$dig_nosso_numero".'0'."$variacao$carteira";
					$dv = financeiro_gera_boleto_hsbc_digitoVerificador_barra($barra, 9, 0);
					// Numero para o codigo de barras com 44 digitos
					$barra_boleto = substr($barra,0,4) . $dv . substr($barra,4);
				}
			}else if ($banco == '104'){ //se conta for caixa e carteria = 09
				if ($carteira=='SR'){
					//gera barra para caixa
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$cedente = $conta. financeiro_gera_boleto_caixa_modulo_11($conta);
					$nnum = fill_full($nosso_numero,15);
					$nnum = substr($nnum,0,3).'2'.
							substr($nnum,3,3).'4'.
							substr($nnum,6,9);
					$nrdiv= financeiro_gera_boleto_caixa_modulo_11($cedente.$nnum);
					$dv='';
					$campoLivre = $cedente.$nnum.$nrdiv;
					$dv = financeiro_gera_boleto_caixa_digitoVerificador_barra("$banco$nummoeda$dv$fator_vencimento$valor$cedente$nnum$nrdiv");
					$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$cedente$nnum$nrdiv";
				}
				if ($carteira=='RG'){
					//gera barra para caixa
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$cedente = $conta. financeiro_gera_boleto_caixa_modulo_11($conta);
					$nnum = fill_full($nosso_numero,15);
					$nnum = substr($nnum,0,3).'1'.
					substr($nnum,3,3).'4'.
					substr($nnum,6,9);
					$nrdiv= financeiro_gera_boleto_caixa_modulo_11($cedente.$nnum);
					$dv='';
					$campoLivre = $cedente.$nnum.$nrdiv;
					$dv = financeiro_gera_boleto_caixa_digitoVerificador_barra("$banco$nummoeda$dv$fator_vencimento$valor$cedente$nnum$nrdiv");
					$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$cedente$nnum$nrdiv";
				}

			}else if ($banco == '399'){ //se conta for do HSBC e carteria 2 = CNR
				//barra dessas carteiras
				if (($carteira=='02')||
					($carteira=='2')){
					//gera barra para o hsbc
					$nosso_numero = fill_full($nosso_numero,13);
					$vencjuliano = financeiro_gera_boleto_hsbc_dataJuliano(dataf($reg_contas->DT_Vencto));
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					// 43 numeros para o calculo do digito verificador do codigo de barras
					$dv='';
					$barra = "$banco$nummoeda$fator_vencimento$valor$convenio$nosso_numero$vencjuliano$carteira";
					$dv = financeiro_gera_boleto_hsbc_digitoVerificador_barra($barra, 9, 0);
					// Numero para o codigo de barras com 44 digitos
					$barra_boleto = substr($barra,0,4) . $dv . substr($barra,4);
				}
			}else if ($banco == '237'){ //se conta for bradesco e carteria = 09
				if (($carteira=='06')||
					($carteira=='6')||
					($carteira=='03')||
					($carteira=='3')||
					($carteira=='09')||
					($carteira=='9')){
					//gera barra para o hsbc
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$nnum = $carteira.fill_full($nosso_numero,11);
					$dv='';
					$dv = financeiro_gera_boleto_bradesco_digitoVerificador_barra("$banco$nummoeda$dv$fator_vencimento$valor$agencia$nnum$conta"."0", 9, 0);
					$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$agencia$nnum$conta"."0";
				}
			}else if ($banco == '341'){ //se conta for itau e carteria = 09
				$carteira2 = $variacao.
				fill_full($carteira,2);
				if (($carteira2=='175')||
					($carteira2=='174')||
					($carteira2=='104')||
					($carteira2=='178')||
					($carteira2=='108')||
					($carteira2=='109')||
					($carteira2=='112')||
					($carteira2=='157')){
					//gera barra para o hsbc
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$nosso_numero = fill_full($nosso_numero,8);
					$codigo_barras = $banco.$nummoeda.$fator_vencimento.$valor.$variacao.$carteira.$nosso_numero.
					financeiro_gera_boleto_itau_modulo_10($agencia.$conta.$variacao.$carteira.$nosso_numero).
					$agencia.$conta.financeiro_gera_boleto_itau_modulo_10($agencia.$conta).'000';
					$dv = financeiro_gera_boleto_itau_digitoVerificador_barra($codigo_barras);
					$barra_boleto = substr($codigo_barras,0,4).$dv.substr($codigo_barras,4,43);
				}
			}else if ($banco == '748'){ //se conta for sicredi
				$filler1 = 1;
				$filler2 = 0;
				$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
				$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
				$valor = fill_full(round($valor_liq*100),10);
				$nnum = fill_full($nosso_numero,8);
				$dv_nosso_numero = financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero("$agencia$convenio$conta$nnum");
				$nossonumero_dv = "$nnum$dv_nosso_numero";
				//formao do campo livre
				$campolivre = "$carteira$nossonumero_dv$agencia$convenio$conta$filler1$filler2";
				$campolivre_dv = $campolivre . financeiro_gera_boleto_sicredi_digitoVerificador_campolivre($campolivre);
				// 43 numeros para o calculo do digito verificador do codigo de barras
				$dv = financeiro_gera_boleto_sicredi_digitoVerificador_barra("$banco$nummoeda$fator_vencimento$valor$campolivre_dv", 9, 0);
				$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$campolivre_dv";
			}else if ($banco == '756'){ //se conta for bancoob
				if ($carteira=='1'){
					//$nosso_numero     = fill_full($nosso_numero,8);
					$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
					$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
					$valor = fill_full(round($valor_liq*100),10);
					$nnum = fill_full($nosso_numero,7);
					$convenio10 = fill_full($convenio,9);//mesma coisa que numero da conta
					$convenio10_dv = financeiro_gera_boleto_sicoob_modulo_11($convenio10);
					$dv_nosso_numero = financeiro_gera_boleto_sicoob_digitoVerificador_nossonumero("$agencia$convenio10$convenio10_dv$nnum");
					$nossonumero_dv = "$nnum$dv_nosso_numero";
					//formao do campo livre
					$numeroparcela = $reg_contas->Parcela;
					if ($numeroparcela <= 0){
						$numeroparcela = 1;
					}
					$numeroparcela = fill_full($numeroparcela,3);
					$campolivre = "$carteira$agencia$variacao$convenio$convenio10_dv$nossonumero_dv$numeroparcela";
					//$campolivre_dv = $campolivre . financeiro_gera_boleto_sicredi_digitoVerificador_campolivre($campolivre);
					// 43 numeros para o calculo do digito verificador do codigo de barras
					$dv = financeiro_gera_boleto_sicoob_digitoVerificador_barra("$banco$nummoeda$fator_vencimento$valor$campolivre", 9, 0);
					//756 95 5910 0000001000 1 3007 01 0148733 00005790 001
					$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$campolivre";
				}

			}else if ($banco == '085'){ //se conta for cecred
				$dig_conta = financeiro_gera_boleto_cecred_modulo_11($conta);
				$nnum_conta = fill_full($conta.$dig_conta,8);
				$nosso_numero     = fill_full($nosso_numero,9);
				$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
				$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
				$valor = fill_full(round($valor_liq*100),10);
				$dv='';
				$barra = "$banco$nummoeda$fator_vencimento$valor$convenio$nnum_conta$nosso_numero$carteira";
				$dv = financeiro_gera_boleto_cecred_digitoVerificador_barra($barra);
				// Numero para o codigo de barras com 44 digitos
				$barra_boleto = substr($barra,0,4) . $dv . substr($barra,4);
			}else if ($banco == '041'){ //se conta for banrisul
				/* $reg_contas->DT_Vencto = '2000-07-04';
				$reg_contas->Valor = 550;
				$reg_contas->Desconto_Pre_Aprovado = 0;
				$reg_contas->Acrescimo_Pre_Aprovado = 0;
				$banco = '041';
				$moeda = '9';
				$carteira = '2';
				$agencia = '1102';
				$convenio = '9000150';
				$nosso_numero = '22832563'; */
				$nosso_numero     = fill_full($nosso_numero,8);
				$fator_vencimento = financeiro_gera_boleto_bb_fator_vencimento(dataf($reg_contas->DT_Vencto));
				$valor_liq = $reg_contas->Valor-$reg_contas->Desconto_Pre_Aprovado+$reg_contas->Acrescimo_Pre_Aprovado;
				$valor = fill_full(round($valor_liq*100),10);
				$dv='';
				$campolivre = "$carteira"."1"."$agencia$convenio$nosso_numero"."40";
				$campolivre_dv = financeiro_gera_boleto_banrisul_modulo_10_11($campolivre, 7);
				$campolivre_dv = $campolivre.$campolivre_dv;
				// 43 numeros para o calculo do digito verificador do codigo de barras
				//$dv = financeiro_gera_boleto_banrisul_digitoVerificador_barra("$banco$nummoeda$fator_vencimento$valor$campolivre_dv", 9, 0);
				//$barra_boleto = "$banco$nummoeda$dv$fator_vencimento$valor$campolivre";
				//outra tentativa
				$barra = "$banco$nummoeda$fator_vencimento$valor$campolivre_dv";
				$dv = financeiro_gera_boleto_banrisul_digitoVerificador_barra($barra, 9, 0);
				// Numero para o codigo de barras com 44 digitos
				$barra_boleto = substr($barra,0,4) . $dv . substr($barra,4);
			}
			//se conseguiu gerar o boleto
			if ($barra_boleto != ''){
				//salva na tabela de contas
				$upt_contas = 'Update contas_pr set '.
								' Boleto_Banco="'.$banco.'", '.
								' Boleto_Conta="'.$reg_emp[0].'", '.
								' Boleto_NrAgencia="'.$agencia.'", '.
								' Boleto_NrConta="'.$conta.'", '.
								' Boleto_NrConvenio="'.$convenio.'", '.
								' Boleto_Carteira="'.$carteira.'", '.
								' Boleto_Carteira_Variacao="'.$variacao.'", '.
								' Boleto_NossoNumero= "'.$nosso_numero.'", '.
								' Boleto_Barra= "'.str_replace('X','0',$barra_boleto).'" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa="'.$empresa.'"'.
								' and Nr_Contas="'.$nr_contas.'"'.
								' and Seq="'.$seq.'"';
				consulta_sql($upt_contas);
				return true;
			}else{//seno
				//retrona que no fez
				return false;
			}
		}else{
			return false;
		}
	}

	function financeiro_gera_boleto_seunumero($empresa, $nr_contas, $seq){
		$dominios = array();
		$dominios['2'] = '2';
		$empresa_m = $empresa;
		if($_SESSION['Dominio'] == $dominios['2']){
			$empresa_m = '1';
		}
		if(($_SESSION['Dominio'] == 470)||($_SESSION['Dominio'] == 471)){
			$empresa_m = '1';
		}
		$numero_ant = BuscaParamEmpresa('Seu_Numero', $empresa_m);
		$seu_numero = ($numero_ant+1);
		$upd_num = 'UPDATE contas_pr SET Boleto_SeuNumero = "'.$seu_numero.'"'.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'"'.
					' AND Nr_Contas="'.$nr_contas.'"'.
					' AND Seq="'.$seq.'"';
		consulta_sql($upd_num);
		$upd = 'pessoa_empresa SET'.
				' Seu_Numero = "'.$seu_numero.'"'.
				' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				' AND Pessoa = "'.$empresa_m.'"';
		consulta_sql('UPDATE t_'.$upd);
		consulta_sql('UPDATE '.$upd);
		return $seu_numero;
	}
		
	function financeiro_gera_boleto_seunumero2($empresa, $nr_contas, $seq){
		$numero_ant = BuscaParamEmpresa('Seu_Numero', '1');
		$seu_numero = ($numero_ant+1);
		$upd_num = 'UPDATE contas_pr SET Boleto_SeuNumero = "'.$seu_numero.'"'.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'"'.
					' AND Nr_Contas="'.$nr_contas.'"'.
					' AND Seq="'.$seq.'"';
		consulta_sql($upd_num);
		$upd = 'pessoa_empresa SET'.
				' Seu_Numero = "'.$seu_numero.'"'.
				' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				' AND Pessoa = "1"';
		consulta_sql('UPDATE t_'.$upd);
		consulta_sql('UPDATE '.$upd);
		return $seu_numero;
	}

	function financeiro_gera_boleto_nossonumero($empresa,$seq_conta,$reinicia=false,$variacao=''){
		$dominios = array();
		$dominios['2'] = '2';
		$empresa_m = $empresa;
		if($_SESSION['Dominio'] == $dominios['2']){
			$empresa_m = '1';
		}
		if(($_SESSION['Dominio'] == 470)||($_SESSION['Dominio'] == 471)){
			$empresa_m = '1';
		}
		//conuslta nosso nr do boleto
		$con_cnt = 'select Nosso_Numero from empresa_boleto_banco '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Pessoa="'.$empresa_m.'"'.
					' and Seq_Conta="'.$seq_conta.'"';
		$res_cnt = consulta_sql($con_cnt);
		$reg_cnt = consulta_ler_linha($res_cnt);
		consulta_limpa($res_cnt);
		//se o nosso numero lido for zero
		if ($reg_cnt[0]<=0){
			//insere na tabela o registro pra que funciuone o update depois
			$con_cnt = 'INSERT INTO empresa_boleto_banco '.
						' (Dominio, Pessoa, Seq_Conta) '.
						' VALUES ('.
						'"'.$_SESSION['Dominio'].'", '.
						'"'.$empresa_m.'", '.
						'"'.$seq_conta.'")';
			consulta_sql($con_cnt);
		}
		$ok = false;
		$tentativas = 0;
		$nosso_numero = $reg_cnt[0];
		$numero_antes = $nosso_numero;
		if ($reinicia){
			if ($nosso_numero<=0){
				$nosso_numero = substr(data_atual('date'),2,2).$variacao.fill_full(1,5);
			}else{
				if (substr(data_atual('date'),2,2)>substr($nosso_numero,0,2)){
					$nosso_numero = substr(data_atual('date'),2,2).$variacao.fill_full(1,5);
				}
			}
		}
		//se tanta incriment-lo at 10 vezes
		while (!($ok)){
			$nosso_numero++;
			$upt_cnt = 'Update empresa_boleto_banco set '.
						' Nosso_Numero="'.$nosso_numero.'"'.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$empresa_m.'"'.
						' and Seq_Conta="'.$seq_conta.'"'.
						' and Nosso_Numero="'.$numero_antes.'"';
			$ok = consulta_sql($upt_cnt,true,1);
			$numero_antes++;
			if (!($ok)){
				$tentativas++;
				if ($tentativas>=10){
					$ok = true;
				}
			}
		}
		if ($tentativas>=10){
			return 0;
		}else{
			return $nosso_numero;
		}
	}

	function gera_arquivo_remessa_boleto($nr_envio){
		$dominios = array();
		$dominios['2'] = '2';
		$dominios['271'] = '271';
		$empresa_m = $_SESSION['Empresa_Codigo'];
		if($_SESSION['Dominio'] == $dominios['2']){
			$empresa_m = '1';
		}
		if(($_SESSION['Dominio'] == 470)||($_SESSION['Dominio'] == 471)){
			$empresa_m = '1';
		}
		$fim_linha = "
";
		$retorno = array();
		$cabecalho = '';
		$conteudo1 = '';
		$conteudo2 = '';
		$conteudo3 = '';
		$rodape = '';
		$qtd_registros = 0;
		$tem_envio = false;
		$arquivo_montado = '';
		$con_conta = 'select Banco, Agencia, Conta,Nr_Conta from banco_envio  '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and Nr_Envio = "'.$nr_envio.'"';
		$res_conta = consulta_sql($con_conta);
		$reg_conta = consulta_ler_linha($res_conta);
		consulta_limpa($res_conta);
		$nr_lote = 0;
		$con_lote = 'select max(Nr_Lote) from banco_envio  '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' and Banco = "'.$reg_conta[0].'"'.
					' and Agencia = "'.$reg_conta[1].'"'.
					' and Conta = "'.$reg_conta[2].'"'.
					' and Nr_Conta = "'.$reg_conta[3].'"';
		$res_lote = consulta_sql($con_lote);
		$reg_lote = consulta_ler_linha($res_lote);
		consulta_limpa($res_lote);
		$nr_lote = ($reg_lote[0]+1);
		$data_remessa = limpa_numero(data_atual('data'));
		//BUSCA CNPJ EMPRESA
		$con_pessoa = 'select CPF_CNPJ from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and Pessoa = "'.$empresa_m.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$cpf_cnpj = limpa_numero($reg_pessoa[0]);
		$con_sql1 = 'select * from banco_envio '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' and Nr_Envio = "'.$nr_envio.'"';
		$res_sql1 = consulta_sql($con_sql1);
		$nrw_sql1 = consulta_num_registros($res_sql1);
		if($nrw_sql1>0){
			$reg_sql1 = consulta_ler_objeto($res_sql1);
			$retorno['remessa'] = $reg_sql1->Nr_Envio;
			$retorno['conta'] = $reg_sql1->Nr_Conta;
			$retorno['lote'] = $nr_lote;
			if($reg_sql1->Nr_Lote>0){
				$retorno['lote'] = $reg_sql1->Nr_Lote;
				$nr_lote = $reg_sql1->Nr_Lote;
			}
			$cons_pessoa_conta = 'select * from pessoa_conta '.
								' where Dominio = "'.$_SESSION['Dominio'].'" '.
								' and Pessoa = "'.$empresa_m.'" '.
								' and Seq_Conta = "'.$reg_sql1->Nr_Conta.'"';
			$res_pessoa_conta = consulta_sql($cons_pessoa_conta);
			$reg_pessoa_conta = consulta_ler_objeto($res_pessoa_conta);
			consulta_limpa($res_pessoa_conta);
			$cons_empresa = 'select CPF_CNPJ, Nome_Razao from pessoa '.
							' where Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = "'.$empresa_m.'"';
			$res_empresa = consulta_sql($cons_empresa);
			$reg_empresa = consulta_ler_linha($res_empresa);
			consulta_limpa($res_empresa);
			$sql = 'select * from banco_envio_det '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' and Nr_Envio = "'.$reg_sql1->Nr_Envio.'"'.
					' order by DT_Vencto, Empresa, Contas_Nr_Contas, Contas_Seq';
			$res_sql = consulta_sql($sql);
			$nrw_sql = consulta_num_registros($res_sql);
			$sequencia = 1;
			if($nrw_sql>0){
				if($reg_sql1->Banco=='001'){ //se banco do brasil
					$cabecalho.= '001'.                                                        // Banco
						'0000'.                                                       // Lote
						'0'.                                                          // Id. de Header
						'         '.                                                  // Brancos
						'2'.                                                          // Tipo Inscrio CGC
						limpa_numero($reg_empresa[0]).                                // CGC da Empresa
						fill_full(limpa_numero($reg_pessoa_conta->Convenio), 9).      // Convenio da Empresa
						'0014'.                                                       // Produto : Cobranca Cedente
						fill_full(limpa_numero($reg_pessoa_conta->Carteira), 2).      // Carteira
						fill_full(limpa_numero($reg_pessoa_conta->Variacao), 3).      // Variao Carteira
						'  '.                                                         // brancos
						fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5).       // Agencia da Empresa
						financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Agencia). // Dig. Agencia
						fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12).        // Conta da Empresa
						financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Numero_Conta).// Dig. Conta
						' ' .                                                         // Dig. Agencia/Conta (Branco)
						preenche_texto(formata_texto_limpo($reg_empresa[1]), 30).                          // Nome Empresa
						preenche_texto('BANCO DO BRASIL', 30).                        // Nome Banco
						preenche_texto(' ', 10).                                      // Brancos
						'1'.                                                          // 1-Remessa/2-Retorno
						limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
						limpa_numero(nr2hora(hora_atual('nr'))).                      // Hora de Gerao do Arquivo //??
						fill_full($nr_lote, 6).      // Nmero do Arquivo
						'030'.                       // Verso do Layout
						'00000'.                     // Densidade
						preenche_texto(' ', 54).     // Brancos
						'000'.                       // Brancos
						preenche_texto(' ', 12).     // Brancos
						$fim_linha;
					//Header do Lote
					$cabecalho.= '001'.                                                        // Banco
						'0001'.                                                       // Lote
						'1'.                                                          // Id. de Header de Lote
						'R'.                                                          // Operao - R - Remessa
						'01'.                                                         // Tipo de Servio - 01 - Incluso
						'  '.                                                         // Branco
						'020'.                                                        // Verso do LAyout do Lote
						' '.                                                          // Branco
						'2'.                                                          // Tipo Inscrio CGC
						fill_full(limpa_numero($reg_empresa[0]),15).                  // CGC da Empresa
						fill_full(limpa_numero($reg_pessoa_conta->Convenio), 9).      // Convenio da Empresa
						'0014'.                                                       // Produto : Cobranca Cedente
						fill_full(limpa_numero($reg_pessoa_conta->Carteira), 2).      // Carteira
						fill_full(limpa_numero($reg_pessoa_conta->Variacao), 3).      // Variao Carteira
						'  '.                                                         // brancos (TS para TESTE)
						fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5).       // Agencia da Empresa
						financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Agencia). // Dig. Agencia
						fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12).        // Conta da Empresa
						financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Numero_Conta).// Dig. Conta
						' ' .                                                         // Dig. Agencia/Conta (Branco)
						preenche_texto($reg_empresa[1], 30).                          // Nome Empresa
						preenche_texto(' ', 40).     // Mensagem 1
						preenche_texto(' ', 40).     // Mensagem 2
						fill_full($nr_lote, 8).      // Nmero do Arquivo
						limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
						'00000000'.                  // Data do Credito //??
						preenche_texto(' ', 33).     // Brancos
						$fim_linha;
					$arquivo_montado.= $cabecalho;
					//$sequencia++;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						$tipo_sacado = '1';
						if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = ( Zathura()  );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = 'S';
						}else{
							$postagem = 'N';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$cod_carteira = '2';
							$cod_id_emissao = '2';
							$cod_id_distr = '2';
							if ($_SESSION["Dominio"]==87){
								$cod_carteira = '1';
							}
							if ($_SESSION["Dominio"]==358){
								$cod_carteira = '7';
							}
							if (Zathura() ){
								$cod_carteira = '7';
							}							
							if ($reg_pr->Boleto_Carteira=='11'){
								$nosso_numero = '';
								$cod_carteira = '1';
								$cod_id_emissao = '1';
								$cod_id_distr = '1';
							}else if (strlen($reg_pr->Boleto_NrConvenio)==8){
								$nosso_numero = $reg_pr->Boleto_NrConvenio.
												fill_full($reg_pr->Boleto_NossoNumero,9);
							}else if (strlen($reg_pr->Boleto_NrConvenio)==7){
								$nosso_numero = $reg_pr->Boleto_NrConvenio.
												fill_full($reg_pr->Boleto_NossoNumero,10);
							}else if (strlen($reg_pr->Boleto_NrConvenio)==6){
								$nosso_numero = fill_full($reg_pr->Boleto_NrConvenio,6).
												fill_full($reg_pr->Boleto_NossoNumero,5);
												$nosso_numero = $nosso_numero.
												financeiro_gera_boleto_bb_modulo_11($nosso_numero);
							}else if (strlen($reg_pr->Boleto_NrConvenio)==4){
								$nosso_numero = fill_full($reg_pr->Boleto_NrConvenio,4).
												fill_full($reg_pr->Boleto_NossoNumero,7);
												$nosso_numero = $nosso_numero.
												financeiro_gera_boleto_bb_modulo_11($nosso_numero);
							}
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_juros  = (($reg_pr->Juros_Perc       * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_multa  = (($reg_pr->Multa_Perc       * $reg_sql->Valor_Liquido ) /100);
							$conteudo1 = '001'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'P'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5).          // Agencia da Empresa
										financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Agencia). // Dig. Agencia
										fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12).           // Conta da Empresa
										financeiro_gera_boleto_bb_modulo_11($reg_pessoa_conta->Numero_Conta).   // Dig. Conta
										' ' .                                                            // Dig. Agencia/Conta (Branco)
										preenche_texto($nosso_numero,20).                                // Nosso Nmero
										$cod_carteira.               // Cdigo da Carteira 2 - Carteira Viculada; 7 = Carteira 17
										'1'.                         // Forma Cadastro 1 = Com Cadastro
										'2'.                         // Tipo Documento 1 = Tradicional
										$cod_id_emissao.             // Identificao de Emisso - 2 - Cliente emite
										$cod_id_distr.               // Identificao de Distrib - 2 - Cliente
										preenche_texto($nr_fatura,15).                                   // Nr da Fatura
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Vencimento
										fill_full(round($reg_sql->Valor_Liquido*100),15).                // Valor do Ttulo
										'00000 '.                                                        // Agencia Cobranca - Zeros pega pelo CEP
										'02'.                                                            // Espcie do Ttulo - Duplicata MErcantil por Indicao (Obrigatorio DM no pode)
										'N'.                                                             // Aceito no aceito
										limpa_numero(dataf($reg_pr->DH_Criacao)).                        // Data de Emisso
										'1'.                                                             // Cdigo da Mora - 1 Valor Por Dia
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Juros de Mora
										fill_full(round($valor_juros*100),15);                           // Valor do Juros

							if  ($valor_descto > 0){  //desconto de antecipao
								$conteudo1.=
										'3'.                                                             // Identificao Tipo de Desconto - 3 - Valor Por Antecipacao Dia Corrido.
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Desconto
										fill_full(round($valor_descto*100),15);                          // Valor Desconto Concedido
							}else{
								$conteudo1.=
										'0'.                                                             // Cdigo Desconto  0 - Sem Desconto
										fill_full('0', 8).                                               // Data de Desconto
										fill_full('0', 15);                                              // Valor Desconto Concedido
							}
							$conteudo1.= fill_full('0', 15).                                             // Valor IOF
										fill_full('0', 15).                                              // Valor Abatimento
										preenche_texto($nr_fatura,25);                                   // Nr da Fatura

							if ($_SESSION['Dominio']=='-103'){
								if (($reg_pr->Dias_Protesto>0)&&($reg_pr->Dias_Protesto<100)){
									$conteudo1.= 
										'1'.                                                      		// Cdigo do Protesto 1 - Dias Corridos
										fill_full($reg_pr->Dias_Protesto,2);                   			// Dias para Protesto
								}else if ($reg_pr->Dias_Protesto>0){
									$conteudo1.= 
										'1'.                                                      		// Cdigo do Protesto 1 - Dias Corridos
										'99';                                                     		// Dias para Protesto
								}else{
									$conteudo1.= 
										'3'.                                                      		// Cdigo do Protesto 3 - No Protestar
										'00';                                                     		// Dias para Protesto
								}
							}else if( $_SESSION['Dominio']=='83' ){
								//Modificacao realizada para DOMINIO  83 em 05/05/2023 por @isabel
								//Nova modificacao  em  15/05/2023
								//$dias_protesto = buscaParam('FAT_PROTESTO');
    							$conteudo1.=
										'1'.
										fill_full($reg_pr->Dias_Protesto,2);
							}else{
								$conteudo1.= 
										'3'.                                                        	// Cdigo do Protesto 3 - No Protestar
										'00';                                                        	// Dias para Protesto
							}
							$conteudo1.= '2'.                                                           // Cdigo para Baixa/Devoluo 2 No Baixa
										'000'.                                                          // Dias para Baixa Devoluo
										'09'.                                                           // Cdigo da Moeda
										fill_full('0', 10).                                             // Nr do Contr. de Op. de Crdito
										' '.                                                            // Brancos
										$fim_linha;
							$sequencia++;
							$conteudo1.= '001'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'Q'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full($tipo_sacado,1).                   // Tipo Incrio do Cliente
										fill_full(limpa_numero($reg_sacado[0]),15).  // CGC/CPF Cliente
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40).           // Nome Cliente
										preenche_texto(formata_texto_limpo($endereco_log),40).            // Endereco do Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[6]),15).         // Bairro Cliente
										fill_full(limpa_numero(formata_texto_limpo($reg_endereco[5])),8). // CEP Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[3]),15).         // Cidade Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[4]),2).         // Estado Cliente
										'0'.                         // Tipo Incrio Avalista
										fill_full('0', 15).          // CPF Avalista
										preenche_texto(' ', 40).     // Nome Avalista
										'000'.                       // Banco Cobranca
										preenche_texto(' ', 20).     // Nosso Nmero no Banco Cobranca
										preenche_texto(' ', 8).      // Brancos
										$fim_linha;
							$sequencia++;
							if ($valor_multa>0){
								$conteudo1.=
										'001'.                       // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'R'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full('0', 24).          // Desconto 2
										fill_full('0', 24).          // Desconto 3
										'1'.                         // Cod Multa
										limpa_numero(dataf($reg_pr->DT_Vencto)). //Data base da multa
										fill_full(round($valor_multa*100),15).   //Valor Multa
										preenche_texto(' ', 10).     // inf Banco Sacado
										preenche_texto(' ', 40).     // Mensagem 3
										preenche_texto(' ', 40).     // Mensagem 4
										fill_full('0', 28).          // Inf Dbito
										preenche_texto(' ', 33).     // Brancos
										$fim_linha;
								$sequencia++;
							}//fim multa
							$arquivo_montado.= $conteudo1;
						}//fim com registro
					}//fim do looping
					$rodape =       	'001'.                       // Banco
										'0001'.                      // Lote
										'5'.                         // Id. de Detalhe
										preenche_texto(' ', 9).      // Brancos
										fill_full($sequencia+1, 6).  // Seq no Lote
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										preenche_texto(' ', 8).      // Brancos
										preenche_texto(' ', 117).    // Brancos
										$fim_linha;
					$rodape.=          	'001'.                       // Banco
										'9999'.                      // Lote
										'9'.                         // Id. de Trailer do Arquivo
										preenche_texto(' ', 9).      // Branco
										fill_full('1', 6).           // Lotes do Arquivo
										fill_full(($sequencia+3), 6).// Qtd de Registros do Lote
										fill_full('0', 6).           // Qtd de Registros com Oper = E
										preenche_texto(' ', 205);    // Brancos


					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='104'){ //se caixa

					// [Isabel]
					// Modificacao realizada em 15/05/2023 para Cedentes maiores de 999999
					// Documento 67.118 v029 pgina 66
					if( ($reg_pessoa_conta->Numero_Conta >=1 ) && ($reg_pessoa_conta->Numero_Conta <=999999)  ){
						$layout_header_arq = '101';
						$layout_header_lote = '060';
						$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 6).'0';
						$campo_lote_14 = fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 6);

					}else{
						//explicacao pagina 68 e 70
						$layout_header_arq = '107';
						$layout_header_lote = '067';
						$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 7);
						$campo_lote_14 = fill_full('0', 6);

					}
					$agencia = fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5);
					//Modificado em 06/04/2023 para codigo de CEDENTE comeando com 11 
					//Verificar novas documentacoes da Caixa Economica Federal [Isabel]
					//$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 6);
					// if( $reg_pessoa_conta->Numero_Conta > 1100000){ 
					// 	$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 7);
					// }else{
					// 	$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 6);
					// }
					//[/Isabel]
					$dig_agencia = financeiro_gera_boleto_caixa_modulo_11($agencia);
					$dig_agencia_conta = financeiro_gera_boleto_caixa_modulo_11($agencia.
										$dig_agencia.
										$conta);
					$cabecalho.= 		'104'.                        								  // Banco
										'0000'.                       								  // Lote
										'0'.                                                          // Id. de Header
										preenche_texto(' ', 9).                                       // Brancos
										'2'.                                                          // Tipo Inscrio CGC
										fill_full(limpa_numero($reg_empresa[0]),14).                  // CGC da Empresa
										fill_full('0', 20).                                           // Zeros
										$agencia.                                                     // Agencia da Empresa
										$dig_agencia.                                                 // Dig. Agencia
										$conta.                                                       // Conta da Empresa
										fill_full('0', 7).                                            // Zeros ( campos 11 e 12 ) [Isabel - 15/05/2023]
									//	'0' .                                                         // Zero [Isabel - 15/05/2023]
										preenche_texto(formata_texto_limpo($reg_empresa[1]), 30).     // Nome Empresa
										preenche_texto('CAIXA ECONOMICA FEDERAL', 30).                // Nome Banco
										preenche_texto(' ', 10).                                      // Brancos
										'1'.                                                          // 1-Remessa/2-Retorno
										limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
										limpa_numero(nr2hora(hora_atual('nr'))).                      // Hora de Gerao do Arquivo //??
										fill_full($nr_lote, 6).      								  // Nmero do Arquivo //NSA
										$layout_header_arq.                       					  // Verso do Layout [Isabel - 15/05/2023]
										'00000'.                     								  // Densidade
										preenche_texto(' ', 20).     								  // Brancos
										preenche_texto('REMESSA-PRODUCAO', 20).                       // REMESSA-TESTE Brancos
										preenche_texto(' ', 4).     								  // Brancos
										preenche_texto(' ', 25).     								  // Brancos
										$fim_linha;
					//Header do Lote
					$cabecalho.=		'104'.                                                        // Banco
										'0001'.                                                       // Lote
										'1'.                                                          // Id. de Header de Lote
										'R'.                                                          // Operao - R - Remessa
										'01'.                                                         // Tipo de Servio - 01 - Cobranca Registrada
										'00'.                                                         // Zeros
										$layout_header_lote.                                          // Verso do LAyout do Lote [Isabel - 15/05/2023] 
										' '.                                                          // Brancos
										'2'.                                                          // Tipo Inscrio CGC
										fill_full(limpa_numero($reg_empresa[0]),15).                  // CGC da Empresa
										$conta.                                                       // Codigo da Conta
										fill_full('0',13).                                            // zeros [Isabel - 15/05/2023 era 14 ficou 13] 
										$agencia.                                                     // Agencia da Empresa
										$dig_agencia.                                                 // Dig. Agencia
										$campo_lote_14.                                               // Conta da Empresa [Isabel - 15/05/2023 conta ] 
										fill_full('0',7).                                             // Modelo Personalizado
										'0' .                                                         // Zeros
										preenche_texto(formata_texto_limpo($reg_empresa[1]), 30).     // Nome Empresa
										preenche_texto(' ', 40).     								  // Mensagem 1
										preenche_texto(' ', 40).     								  // Mensagem 2
										fill_full($nr_lote, 8).      								  // Nmero do Arquivo
										limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
										'00000000'.                  								  // Data do Credito //??
										preenche_texto(' ', 33).     								  // Brancos
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					//$sequencia++;
					$valor_boletos = 0;
					$qtd_boletos=0;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao, EMail from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						$tipo_sacado = '1';
						if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						$email_sacado = $reg_sacado[2];
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = (Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = '3';
						}else{
							$postagem = '0';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$nosso_numero = fill_full($reg_pr->Boleto_Carteira_Variacao,2).
											fill_full($reg_pr->Boleto_NossoNumero,15);
											$variacao = fill_full($reg_pr->Boleto_Carteira_Variacao,2);
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_juros  = (($reg_pr->Juros_Perc       * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_multa  = (($reg_pr->Multa_Perc       * $reg_sql->Valor_Liquido ) /100);
							$valor_boletos+= $reg_sql->Valor_Liquido;
							$qtd_boletos++;
							$aceite='N';
							if ($_SESSION['Dominio']=='119'){
								$aceite='S';
							}
							//Segmento P (Obrigatrio) - Dados do Ttulo
							$conteudo1 = '104'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'P'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										$agencia.                    // Agencia da Empresa
										$dig_agencia.                // Dig. Agencia
										$conta.                      // Conta da Empresa
										fill_full('0', 7).           // Zeros
										fill_full('0', 2).           // Zeros [Isabel em 15-05-2023 era 3 ficou 2]
										'0'. 						 // [Isabel em 15-05-2023 campo 13.3P]
										preenche_texto($nosso_numero,17).// Nosso Nmero
										'1'.                         // Cdigo da Carteira Cobrana Simples
										'1'.                         // Forma Cadastro 1 = Com Cadastro
										'2'.                         // Tipo Documento 1 = Tradicional  2 Escritural
										'2'.                         // Identificao de Emisso - 2 - Cliente emite
										'0'.                         // Identificao de Distrib - 0 Pelo cedente 2 - Cliente
										preenche_texto($nr_fatura,11).                                   // Nr da Fatura
										preenche_texto(' ',4).                                           // Brancos
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Vencimento
										fill_full(round($reg_sql->Valor_Liquido*100),15).                // Valor do Ttulo
										'000000'.                                                        // Agencia Cobranca - Zeros pega pelo CEP
										'03'.                                                            // Espcie do Ttulo - Duplicata MErcantil por Indicao (Obrigatorio DM no pode)
										$aceite.                                                         // Aceito no aceito
										limpa_numero(dataf($reg_pr->DH_Criacao));                        // Data de Emisso

							if ($valor_juros>=0.01){
								$conteudo1.=
										'1'.                                                             // Cdigo da Mora - 1 Valor Por Dia
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Juros de Mora
										fill_full(round($valor_juros*100),15);                           // Valor do Juros

							}else{
								$conteudo1.=
										'3'.                                                             // Cdigo da Mora - 1 Valor Por Dia
										'00000000'.                                                      // Data de Juros de Mora
										fill_full('0',15);                                               // Valor do Juros
							}
							/*
							if  ($valor_descto > 0){  //desconto de antecipao
							$conteudo1.=
							'3'.                                                             // Identificao Tipo de Desconto - 3 - Valor Por Antecipacao Dia Corrido.
							limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Desconto
							fill_full(round($valor_descto*100),15);                          // Valor Desconto Concedido
							}else{
							*/
							$conteudo1.=
										'0'.                                                             // Cdigo Desconto  0 - Sem Desconto
										fill_full('0', 8).                                               // Data de Desconto
										fill_full('0', 15);                                              // Valor Desconto Concedido
							//}
							$protesto="3";
							$dias_protesto="00";
							if(($_SESSION['Dominio'] == "79") || ($_SESSION['Dominio'] == "128")){
								if($reg_pr->Dias_Protesto > 1){
									$protesto="1";
									if($reg_pr->Dias_Protesto > 90){
										$dias_protesto="90";
									}else{
										$dias_protesto=fill_full($reg_pr->Dias_Protesto, 2);
									}
								}
							}else{
								/**Modificado em 07/08/2023 por Isabel para que se tem dias de Protesto no banco  104 aparecer independente do Dominio */
								if($reg_pr->Dias_Protesto > 1){
									$protesto="1";
									$dias_protesto=fill_full($reg_pr->Dias_Protesto, 2);
								}
							}
							

							$conteudo1.= fill_full('0', 15).                                              // Valor IOF
										fill_full('0', 15).                                              // Valor Abatimento
										preenche_texto($nr_fatura,25).                                   // Nr da Fatura
										$protesto.                                                       // Cdigo do Protesto 3 - No Protestar
										$dias_protesto.                                                  // Dias para Protesto
										'1'.                                                             // Cdigo para Baixa/Devoluo 2 No Baixa
										'120'.                                                           // Dias para Baixa Devoluo (sem protesto e sem baixa o banco nao aceita)
										'09'.                                                            // Cdigo da Moeda
										fill_full('0', 10).                                              // Nr do Contr. de Op. de Crdito
										' '.                                                             // Brancos
										$fim_linha;
										$sequencia++;

							$conteudo1.= '104'.                       // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'Q'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full($tipo_sacado,1).                   // Tipo Incrio do Cliente
										fill_full(limpa_numero($reg_sacado[0]),15).  // CGC/CPF Cliente
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40).           // Nome Cliente
										preenche_texto(formata_texto_limpo($endereco_log),40).            // Endereco do Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[6]),15).         // Bairro Cliente
										fill_full(limpa_numero($reg_endereco[5]),8). // CEP Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[3]),15).         // Cidade Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[4]),2).         // Estado Cliente
										'0'.                         // Tipo Incrio Avalista
										fill_full('0', 15).          // CPF Avalista
										preenche_texto(' ', 40).     // Nome Avalista
										'   '.                       // Banco Cobranca
										preenche_texto(' ', 20).     // Nosso Nmero no Banco Cobranca
										preenche_texto(' ', 8).      // Brancos
										$fim_linha;
							$sequencia++;
							if ($valor_multa<0.001){
								$valor_multa=0;
							}
							//if (($valor_multa>0.001)||($email_sacado!='')){
							$cod_multa = '0';
							if ($valor_multa>0.001){
								$cod_multa = '1';
							}
							$conteudo1.=
										'104'.                       // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'R'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full('0', 24).          // Desconto 2
										fill_full('0', 24).          // Desconto 3
										$cod_multa.                         // Cod Multa
										limpa_numero(dataf($reg_pr->DT_Vencto)). //Data base da multa
										fill_full(round($valor_multa*100),15).   //Valor Multa
										preenche_texto(' ', 10).     // inf Banco Sacado
										preenche_texto(' ', 40).     // Mensagem 3
										preenche_texto(' ', 40).     // Mensagem 4
										preenche_texto($email_sacado, 50).     // Email
										preenche_texto(' ', 11).     // Brancos
										$fim_linha;
							$sequencia++;
							//}//fim multa
							$arquivo_montado.= $conteudo1;
						}//fim com registro
					}//fim do looping
					//$qtd_boletos = $sequencia-1;
					$rodape =          '104'.                       // Banco
										'0001'.                      // Lote
										'5'.                         // Id. de Detalhe
										preenche_texto(' ', 9).      // Brancos
										fill_full($sequencia+1, 6).  // Seq no Lote
										fill_full($qtd_boletos, 06).          // Somente Arquivo de Retorno
										fill_full(round($valor_boletos*100), 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										preenche_texto(' ', 31).      // Brancos
										preenche_texto(' ', 117).    // Brancos
										$fim_linha;
					$rodape.=          '104'.                       // Banco
										'9999'.                      // Lote
										'9'.                         // Id. de Trailer do Arquivo
										preenche_texto(' ', 9).      // Branco
										fill_full('1', 6).           // Lotes do Arquivo
										fill_full(($sequencia+3), 6).// Qtd de Registros do Lote
										preenche_texto(' ', 6).      // Qtd de Registros com Oper = E
										preenche_texto(' ', 205);    // Brancos
					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='748'){ //se banco sicredi
					$cabecalho.= 		'01REMESSA01'.preenche_texto('COBRANCA',15).
										fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),5).
										limpa_numero($reg_empresa[0]).
										preenche_texto('',31).
										'748'.preenche_texto('SICREDI',15).
										limpa_numero(data_atual('date')).
										preenche_texto('',8).
										fill_full($nr_lote,7).
										preenche_texto('',273).
										'2.00'.
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					$sequencia++;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						if(strlen(limpa_numero($reg_sacado[0]))==11){
							$tipo_sacado = '1';
						}else if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = (Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = 'S';
						}else{
							$postagem = 'N';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$data_criacao = data2nr(dataf($reg_pr->DH_Criacao));
							$data_vencto = data2nr(dataf($reg_pr->DT_Vencto));
							$data_minima = $data_vencto - 7;
							if ($data_criacao>$data_minima){
								$data_criacao = $data_minima;
							}
							$data_criacao = datad(nr2data($data_criacao));
							$valor_juros = 0;
							if ($reg_sql->Mora_Perc>0){
								if ($reg_sql->Mora_Perc==0.03){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.01)/30;
								}else if ($reg_sql->Mora_Perc==0.06){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.02)/30;
								}else if ($reg_sql->Mora_Perc==0.11){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.035)/30;
								}else{
									$valor_juros = ($reg_sql->Valor_Liquido * $reg_sql->Mora_Perc/100);
								}
								$valor_juros = arredonda_numero_menos($valor_juros*100);
							}
							$cd_protesto = '0';
							$dias_protesto = '0';
							if (($_SESSION['Dominio']==49)||($_SESSION['Dominio']==99)||($_SESSION['Dominio']==420)){
								/* Modificacao realizada em 20-04-2022 para Dominio 420 ficar igual ao 49 por @isabel*/
								if ($reg_sql->Dias_Protesto>=3){
									$cd_protesto = '06';
									$dias_protesto = $reg_sql->Dias_Protesto;
									if ($reg_sql->Dias_Protesto>90){
										$dias_protesto = '90';
									}
								}
							}
							$numero_documento = $reg_pr->Boleto_SeuNumero;
							//modificacao para MT TOOLS em 05/06/2020 (Anna-Whatsapp)
							if ( ($_SESSION['Dominio']==99)||($_SESSION['Dominio']=='11')){
								$numero_documento = substr($reg_pr->Nr_Doc.'-'.$reg_pr->Parcela,0,10);
							}
							$desconto_dia = 0;
							$data_descto = '0000-00-00';
							$valor_descto = 0;
							
							if ($reg_pr->Desconto_Pontual>0){
								$desconto_dia = (($reg_pr->Desconto_Pontual/30) * $reg_sql->Valor_Liquido)/100;
								$desconto_dia = arredonda_numero_menos($desconto_dia*100);
							}else{
								$con_pes_cli = 'SELECT PercDescBoleto FROM pessoa_cliente '.
												' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
												' AND Pessoa = "'.$reg_pr->Pessoa.'"';
								$res_pes_cli = consulta_sql($con_pes_cli);
								$reg_pes_cli = consulta_ler_linha($res_pes_cli);
								consulta_limpa($res_pes_cli);
								if ($reg_pes_cli[0]>0){
									$valor_descto = ($reg_pr->Valor*((($reg_pes_cli[0])/100)));
									if($valor_descto < 0.01){
										$valor_descto = 0;
									}
									$valor_descto = arredonda_numero_menos($valor_descto*100);
									
									if ($valor_descto>0){
										$data_descto = $reg_pr->DT_Vencto;
									}
								}
								
							}
							
							$conteudo1 = '1AAA'.
										preenche_texto('',12).
										'AAA'.
										preenche_texto('',28).
										fill_full($reg_pr->Boleto_NossoNumero,8).
										financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero($reg_pr->Boleto_NrAgencia.
										fill_full($reg_pr->Boleto_NrConvenio,2).
										$reg_pr->Boleto_NrConta.
										fill_full($reg_pr->Boleto_NossoNumero,8)). //fill_full($reg_pr->Boleto_NossoNumero,9).//nosso numero sicredi (9)
										preenche_texto('',6).
										limpa_numero(datad(dataf($reg_pr->DH_Criacao))).
										preenche_texto('',1).
										$postagem.
										preenche_texto('',1).
										$reg_sql->Tipo_Emissao.
										preenche_texto('',2). //numero da parcela do carne
										preenche_texto('',2). //numero total de parcelas do carne
										preenche_texto('',4).
										fill_full(round($desconto_dia*100),10). //valor de desconto por dia de antecipacao
										fill_full(round($reg_sql->Multa_Perc*100),4). //% multa por pagamento em atraso
										preenche_texto('',12).
										preenche_texto('01',2).//instrucao (2)
										preenche_texto($numero_documento,10).
										substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2).
										fill_full(round($reg_sql->Valor_Liquido*100),13).
										preenche_texto('',9).
										'A'. //especie de documento
										'N'. //aceite do titulo
										substr(limpa_numero(dataf($data_criacao)),0,4).substr(limpa_numero(dataf($data_criacao)),6,2).
										fill_full($cd_protesto,2). //instrucao de protesto automatico
										fill_full($dias_protesto,2). //nr de dias para protesto auto
										fill_full($valor_juros,13).   //round($reg_sql->Mora_Perc*100)
										fill_full(limpa_numero(dataf($data_descto)),6). //data limite para concessao de desconto
										fill_full($valor_descto,13). //valor % do desconto
										fill_full('0',13).
										fill_full('0',13). //valor do abatimento
										preenche_texto($tipo_sacado,1). //tipo de pessoa do sacado 1-Fisica 2-Juridica
										fill_full('0',1).
										fill_full(limpa_numero($reg_sacado[0]),14). //CIC CGC do sacado
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40). //nome do sacado
										preenche_texto(formata_texto_limpo($endereco_log),40). //endereco do sacado
										fill_full('0',5). //codigo do sacado na cooperativa cedente (5)
										fill_full('0',6).
										preenche_texto('',1).
										fill_full(limpa_numero($reg_endereco[5]),8).
										fill_full($cod_pes,5).//codigo do sacado junto ao cliente (5) (zeros quando inexistente)
										//fill_full('0',14). //CIC CGC do sacador avalista (14)
										preenche_texto('',14).
										//Modificado por @isabel em 12/05/2023 para cliente 292 Banco 748 
										preenche_texto('',41). //nome do sacador avalista (41)
										fill_full($sequencia,6).
										$fim_linha;
							$sequencia++;

							/*else if($reg_sql->Tipo_Cobranca=='B'){ //sem registro
							$chave5_numero = fill_full($reg_pr->Boleto_NossoNumero,8).
							financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero($reg_pr->Boleto_NrAgencia.
							fill_full($reg_pr->Boleto_NrConvenio,2).
							$reg_pr->Boleto_NrConta.
							fill_full($reg_pr->Boleto_NossoNumero,8));
							$chave5_filler = 2;
							$tipo_registro = 'C';

							$conteudo1 = '1C'.
							preenche_texto('',1).
							'A'.
							preenche_texto('',12).
							'AAB'.
							preenche_texto('',28).
							fill_full($reg_pr->Boleto_NossoNumero,8).
							financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero($reg_pr->Boleto_NrAgencia.
							fill_full($reg_pr->Boleto_NrConvenio,2).
							$reg_pr->Boleto_NrConta.
							fill_full($reg_pr->Boleto_NossoNumero,8)). //fill_full($reg_pr->Boleto_NossoNumero,9). //nosso numero sicredi (9)
							preenche_texto('',1). //brancos
							'B'. //tipo de impressao - completa
							preenche_texto('',13).
							$postagem.
							preenche_texto('',2). //brancos
							preenche_texto('',2). //numero da parcela do carne
							preenche_texto('',2). //numero total de parcelas do carne
							preenche_texto('',4). //brancos
							fill_full('0',10). //valor de desconto por dia de antecipacao
							fill_full(round($reg_sql->Multa_Perc*100),4). //% multa por pagamento em atraso
							preenche_texto('',12). //brancos
							preenche_texto('01',2). //'01'. //instrucao (2)
							preenche_texto($reg_pr->Boleto_SeuNumero,10).
							substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2).
							fill_full(round($reg_sql->Valor_Liquido*100),13).
							preenche_texto('',9). //brancos
							'A'. //especie de documento
							preenche_texto('',1). //brancos
							substr(limpa_numero(dataf($reg_pr->DH_Criacao)),0,4).substr(limpa_numero(dataf($reg_pr->DH_Criacao)),6,2).
							preenche_texto('',4). //brancos
							fill_full(round($reg_sql->Mora_Perc*100),13).
							preenche_texto('',6). //data limite para concessao de desconto
							fill_full('0',13). //valor % do desconto
							fill_full('0',26). //zeros
							$tipo_sacado. //tipo de pessoa do sacado 1-Fisica 2-Juridica
							preenche_texto('',1).
							fill_full(limpa_numero($reg_sacado[0]),14). //CIC CGC do sacado
							preenche_texto($reg_sacado[1],40). //nome do sacado
							preenche_texto($endereco_log,40). //endereco do sacado
							fill_full('0',5). //codigo do sacado na cooperativa cedente (5)
							fill_full('0',6).
							preenche_texto('',1).
							fill_full(limpa_numero($reg_endereco[5]),8).
							preenche_texto($reg_endereco[3],25).
							preenche_texto($reg_endereco[4],2).
							fill_full($cod_pes,5). //codigo do sacado junto ao cliente (5)
							preenche_texto('',28).
							fill_full($sequencia,6).
							$fim_linha;

							$sequencia++;
							}*/
							$arquivo_montado.= $conteudo1;
							$msg_tmp = explode(';',$reg_sql->Mensagens);
							$qtd_msg = sizeof($msg_tmp);
							$resto_msg = (4 - $qtd_msg);
							$txt_instrucoes = '';
							//for($m=0;$m<($qtd_msg)-1;$m++){
							for($m=0;$m<sizeof($msg_tmp);$m++){
								if($msg_tmp[$m]!=''){
									$txt_instrucoes.= preenche_texto(formata_texto_limpo($msg_tmp[$m]),80);
								}else{
									$txt_instrucoes.= preenche_texto(' ',80);
								}
							}
							if($resto_msg>0){
								for($r=0;$r<$resto_msg;$r++){
									$txt_instrucoes.= preenche_texto('',80);
								}
							}
							if (trim($txt_instrucoes)!=''){
								$conteudo2 =				
										preenche_texto('2',1).
										preenche_texto('',11).
										fill_full($reg_pr->Boleto_NossoNumero,8).
										financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero($reg_pr->Boleto_NrAgencia.
										fill_full($reg_pr->Boleto_NrConvenio,2).
										$reg_pr->Boleto_NrConta.
										fill_full($reg_pr->Boleto_NossoNumero,8)).
										$txt_instrucoes.
										preenche_texto($numero_documento,10). //seu numero
										preenche_texto('',43).
										fill_full($sequencia,6).
										$fim_linha;
								$arquivo_montado.= $conteudo2;
								$sequencia++;
							}
							if(trim($reg_sql->Informativo!='')){
								$txt_base = str_replace('
								',';',$reg_sql->Informativo);
								$txt_informa = explode(";",$txt_base);
								$qtd_informa = sizeof($txt_informa);
								$linha_atual = 0;
								$qtd_atual = 0;
								foreach($txt_informa as $key => $valor){
									if($qtd_atual==4){
										$qtd_atual = 0;
										$linha_atual++;
									}
									if($qtd_atual==0){
										$txt_informa2[$linha_atual][0] = '';
										$txt_informa2[$linha_atual][1] = '';
										$txt_informa2[$linha_atual][2] = '';
										$txt_informa2[$linha_atual][3] = '';
									}
									$txt_informa2[$linha_atual][$qtd_atual] = $valor;
									$qtd_atual++;
								}
								$qtd_atual = 0;
								$conteudo3 = '';
								foreach($txt_informa2 as $key2 => $valor2){
									if($valor2[0]!=''){
										$qtd_atual1 = fill_full($qtd_atual+1,2);
										$desc_valor1 = preenche_texto(formata_texto_limpo($valor2[0]),80);
									}else{
										$qtd_atual1 = fill_full($qtd_atual+1,2);
										$desc_valor1 = preenche_texto(' ',80);
									}
									if($valor2[1]!=''){
										$qtd_atual2 = fill_full($qtd_atual+2,2);
										$desc_valor2 = preenche_texto(formata_texto_limpo($valor2[1]),80);
									}else{
										$qtd_atual2 = fill_full($qtd_atual+2,2);
										$desc_valor2 = preenche_texto(' ',80);
									}
									if($valor2[2]!=''){
										$qtd_atual3 = fill_full($qtd_atual+3,2);
										$desc_valor3 = preenche_texto(formata_texto_limpo($valor2[2]),80);
									}else{
										$qtd_atual3 = fill_full($qtd_atual+3,2);
										$desc_valor3 = preenche_texto(' ',80);
									}
									if($valor2[3]!=''){
										$qtd_atual4 = fill_full($qtd_atual+4,2);
										$desc_valor4 = preenche_texto(formata_texto_limpo($valor2[3]),80);
									}else{
										$qtd_atual4 = fill_full($qtd_atual+4,2);
										$desc_valor4 = preenche_texto(' ',80);
									}
									$conteudo3.= 			
										'5'.
										'E'.
										fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),5).
										$chave5_numero.
										preenche_texto(' ',$chave5_filler).
										$tipo_registro.
										$qtd_atual1. //fill_full($qtd_atual+1,2).
										$desc_valor1. //preenche_texto($valor2[0],80).
										$qtd_atual2. //fill_full($qtd_atual+2,2).
										$desc_valor2. //preenche_texto($valor2[1],80).
										$qtd_atual3. //fill_full($qtd_atual+3,2).
										$desc_valor3. //preenche_texto($valor2[2],80).
										$qtd_atual4. //fill_full($qtd_atual+4,2).
										$desc_valor4. //preenche_texto($valor2[3],80).
										preenche_texto('',47).
										fill_full($sequencia,6).
										$fim_linha;

									$qtd_atual+=4;
									$sequencia++;
								}
								$arquivo_montado.= $conteudo3;
							}
						}
					}
					$rodape = 			'9'.
										'1'.
										'748'.
										fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),5).
										preenche_texto('',384).
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='341'){ //se banco itau
					$agencia = fill_full(substr($reg_pessoa_conta->Agencia,0,4),4);
					$conta   = fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),5);
					$dig_agencia_conta = financeiro_gera_boleto_itau_modulo_10($agencia.$conta);
					$data6 = limpa_numero(data_atual('data'));
					$data6 = substr($data6,0,4).substr($data6,6,2);
					$cabecalho.= 		'01REMESSA01'.preenche_texto('COBRANCA',15).
										$agencia.
										'00'.
										$conta.
										$dig_agencia_conta.
										preenche_texto('',8).
										preenche_texto(formata_texto_limpo($reg_empresa[1]),30).
										'341'.preenche_texto('BANCO ITAU SA',15).
										$data6.
										preenche_texto('',294).
										fill_full($sequencia,6).
										$fim_linha;

					$arquivo_montado.= $cabecalho;
					$sequencia++;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						if(strlen(limpa_numero($reg_sacado[0]))==11){
							$tipo_sacado = '1';
						}else if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = (Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = 'S';
						}else{
							$postagem = 'N';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						if(($reg_pr->Boleto_Carteira=='12')||($reg_pr->Boleto_Carteira=='09')||($reg_pr->Boleto_Carteira=='08')){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$data_criacao = data2nr(dataf($reg_pr->DH_Criacao));
							$data_vencto = data2nr(dataf($reg_pr->DT_Vencto));
							$data_minima = $data_vencto - 7;
							if ($data_criacao>$data_minima){
								$data_criacao = $data_minima;
							}
							$data_criacao = datad($data_criacao);
							$instrucao1 = '00';
							$instrucao2 = '00';
							$valor_juros = 0;
							if ($reg_sql->Mora_Perc>0){
								if ($reg_sql->Mora_Perc==0.03){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.01)/30;
								}else if ($reg_sql->Mora_Perc==0.06){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.02)/30;
								}else if ($reg_sql->Mora_Perc==0.11){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.035)/30;
								}else{
									$valor_juros = ($reg_sql->Valor_Liquido * $reg_sql->Mora_Perc/100);
								}
								$valor_juros = arredonda_numero_menos($valor_juros*100);
							}
							if ($valor_juros>=1){
								$instrucao1='44';
							}
							$dias_protesto=0;
							if (($_SESSION['Dominio']==83)||( Zathura() )){
								if ($reg_pr->Dias_Protesto>0){
									$instrucao2 = '35';
									$dias_protesto=$reg_pr->Dias_Protesto;
									if ($instrucao1=='00'){
										$instrucao1 = '35';
										$instrucao2 = '00';
									}

								}
							}
							if (($_SESSION['Dominio']==470)||( ($_SESSION['Dominio']==471) )){
								if ($reg_pr->Dias_Protesto>0){
									$instrucao2 = '91';
									$dias_protesto=$reg_pr->Dias_Protesto;
									if ($instrucao1=='00'){
										$instrucao1 = '91';
										$instrucao2 = '00';
									}

								}
							}
							$agencia = fill_full($reg_pr->Boleto_NrAgencia,4);
							$conta = fill_full($reg_pr->Boleto_NrConta,5);
                            
                            $carteira = fill_full($reg_pr->Boleto_Carteira,2);                           
                              
							
							$variacao = $reg_pr->Boleto_Carteira_Variacao;
							$nosso_numero = fill_full($reg_pr->Boleto_NossoNumero,8);
							$dig_nosso_numero  = financeiro_gera_boleto_itau_modulo_10($agencia.$conta.$variacao.$carteira.$nosso_numero);
							$dig_agencia_conta = financeiro_gera_boleto_itau_modulo_10($agencia.$conta);
							$conteudo1 = '1'.  //TIPO DE REGISTRO IDENTIFICAO DO REGISTRO TRANSAO 001 001 9(01) 1
										'02'.//CDIGO DE INSCRIO TIPO DE INSCRIO DA EMPRESA 002 003 9(02) NOTA 1
										fill_full(limpa_numero($reg_empresa[0]),14). //NMERO DE INSCRIO No DE INSCRIO DA EMPRESA (CPF/CNPJ) 004 017 9(14) NOTA 1
										$agencia.  //AGNCIA AGNCIA MANTENEDORA DA CONTA 018 021 9(04)
										'00'.  //ZEROS COMPLEMENTO DE REGISTRO 022 023 9(02) 00
										$conta.  //CONTA NMERO DA CONTA CORRENTE DA EMPRESA 024 028 9(05)
										$dig_agencia_conta. //DAC DGITO DE AUTO CONFERNCIA AG/CONTA EMPRESA 029 029 9(01)
										preenche_texto('',4). //BRANCOS COMPLEMENTO DE REGISTRO 030 033 X(04)
										'0000'.  //INSTRUO/ALEGAO CD.INSTRUO/ALEGAO A SER CANCELADA 034 037 9(04) NOTA 27
										preenche_texto(formata_texto_limpo($nr_fatura),25).//USO DA EMPRESA IDENTIFICAO DO TTULO NA EMPRESA 038 062 X(25) NOTA 2
										$nosso_numero. //NOSSO NMERO IDENTIFICAO DO TTULO NO BANCO 063 070 9(08) NOTA 3
										fill_full('0',13). //QTDE DE MOEDA QUANTIDADE DE MOEDA VARIVEL 071 083 9(08)V9(5) NOTA 4
										$variacao.$carteira. //No DA CARTEIRA NMERO DA CARTEIRA NO BANCO 084 086 9(03) NOTA 5
										preenche_texto('',21). //USO DO BANCO IDENTIFICAO DA OPERAO NO BANCO 087 107 X(21)
										'I'. //CARTEIRA CDIGO DA CARTEIRA 108 108 X(01) NOTA 5
										'01'. //CD. DE OCORRNCIA IDENTIFICAO DA OCORRNCIA 109 110 9(02) NOTA 6
										preenche_texto(formata_texto_limpo($nr_fatura),10).  //No DO DOCUMENTO No DO DOCUMENTO DE COBRANA (DUPL.,NP ETC.) 111 120 X(10) NOTA 18
										substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2).  //VENCIMENTO DATA DE VENCIMENTO DO TTULO 121 126 9(06) NOTA 7
										fill_full(round($reg_sql->Valor_Liquido*100),13). //VALOR DO TTULO VALOR NOMINAL DO TTULO 127 139 9(11)V9(2) NOTA 8
										'341'.  //CDIGO DO BANCO No DO BANCO NA CMARA DE COMPENSAO 140 142 9(03) 341
										fill_full('0',5). //AGNCIA COBRADORA AGNCIA ONDE O TTULO SER COBRADO 143 147 9(05) NOTA 9
										'01'. //ESPCIE ESPCIE DO TTULO 148 149 X(02) NOTA 10
										'N'.  //ACEITE IDENTIFICAO DE TTULO ACEITO OU NO ACEITO 150 150 X(01) A=ACEITE
										substr(limpa_numero(dataf($reg_pr->DH_Criacao)),0,4).substr(limpa_numero(dataf($reg_pr->DH_Criacao)),6,2).//DATA DE EMISSO DATA DA EMISSO DO TTULO 151 156 9(06) NOTA 31
										$instrucao1.//INSTRUO 1 1a INSTRUO DE COBRANA 157 158 X(02) NOTA 11
										$instrucao2.//INSTRUO 2 2a INSTRUO DE COBRANA 159 160 X(02) NOTA 11
										fill_full($valor_juros,13). //JUROS DE 1 DIA VALOR DE MORA POR DIA DE ATRASO 161 173 9(11)V9(2) NOTA 12
										'000000'.//DESCONTO AT DATA LIMITE PARA CONCESSO DE DESCONTO 174 179 9(06) DDMMAA
										fill_full('0',13). //VALOR DO DESCONTO VALOR DO DESCONTO A SER CONCEDIDO 180 192 9(11)V9(2) NOTA 13
										fill_full('0',13). //VALOR DO I.O.F. VALOR DO I.O.F. RECOLHIDO P/ NOTAS SEGURO 193 205 9(11)V((2) NOTA 14
										fill_full('0',13). //ABATIMENTO VALOR DO ABATIMENTO A SER CONCEDIDO 206 218 9(11)V9(2) NOTA 13
										fill_full($tipo_sacado,2).  //CDIGO DE INSCRIO IDENTIFICAO DO TIPO DE INSCRIO/PAGADOR 219 220 9(02) 01=CPF
										fill_full(limpa_numero($reg_sacado[0]),14). //NMERO DE INSCRIO No DE INSCRIO DO PAGADOR (CPF/CNPJ) 221 234 9(14)
										preenche_texto(formata_texto_limpo($reg_sacado[1]),30). //NOME NOME DO PAGADOR 235 264 X(30) NOTA 15
										preenche_texto('',10).             //BRANCOS COMPLEMENTO DE REGISTRO 265 274 X(10) NOTA 15
										preenche_texto(formata_texto_limpo($endereco_log),40).  //LOGRADOURO RUA, NMERO E COMPLEMENTO DO PAGADOR 275 314 X(40)
										preenche_texto(formata_texto_limpo($reg_endereco[6]),12). //BAIRRO BAIRRO DO PAGADOR 315 326 X(12)
										fill_full(limpa_numero($reg_endereco[5]),8). //CEP CEP DO PAGADOR 327 334 9(08)
										preenche_texto(formata_texto_limpo($reg_endereco[3]),15). //CIDADE CIDADE DO PAGADOR 335 349 X(15)
										preenche_texto(formata_texto_limpo($reg_endereco[4]),2). //ESTADO UF DO PAGADOR 350 351 X(02)
										preenche_texto('',30).//SACADOR/AVALISTA NOME DO SACADOR OU AVALISTA 352 381 X(30) NOTA 16
										preenche_texto('',4).//BRANCOS COMPLEMENTO DO REGISTRO 382 385 X(04)
										'000000'. //DATA DE MORA DATA DE MORA 386 391 9(06) DDMMAA
										fill_full($dias_protesto,2).//'00'.     //PRAZO QUANTIDADE DE DIAS 392 393 9(02) NOTA 11 (A)
										' '.      //BRANCOS COMPLEMENTO DO REGISTRO 394 394 X(01)
										fill_full($sequencia,6). //NMERO SEQENCIAL No SEQENCIAL DO REGISTRO NO ARQUIVO 395 400 9(06)
										$fim_linha;
							$sequencia++;
							$arquivo_montado.= $conteudo1;
							$msg_tmp = explode(';',$reg_sql->Mensagens);
							$qtd_msg = sizeof($msg_tmp);
							$resto_msg = (4 - $qtd_msg);
							$txt_instrucoes = '';
							$tem_envio = true;
						}
					}//fim looping
					$rodape =			'9'.
										preenche_texto('',393).
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if(($reg_sql1->Banco=='033')||($reg_sql1->Banco=='353')){ //se banco SANTANDER remessa
					$agencia = fill_full(substr($reg_pessoa_conta->Agencia,0,4),4);
					$conta   = fill_full(substr($reg_pessoa_conta->Numero_Conta,0,7),7);
					$dig_agencia_conta = financeiro_gera_boleto_caixa_modulo_11($agencia.$conta);
					$codigo_transmissao   = fill_full(substr($reg_pessoa_conta->Obs,0,20),20);
					$compl_conta = fill_full($reg_pessoa_conta->Numero_Conta,10);
					$compl_conta = substr($compl_conta,8,2);
					$data6 = limpa_numero(data_atual('data'));
					$data6 = substr($data6,0,4).substr($data6,6,2);
					$cabecalho.= 		'01REMESSA01'.preenche_texto('COBRANA',15).
										$codigo_transmissao.
										preenche_texto(formata_texto_limpo($reg_empresa[1]),30).
										$reg_sql1->Banco.preenche_texto('SANTANDER',15).
										$data6.
										fill_full('0',16).
										preenche_texto('',275).
										fill_full('0',3).
										fill_full($sequencia,6).
										$fim_linha;

					$arquivo_montado.= $cabecalho;
					$sequencia++;
					$valor_total = 0;
					$qtd_titulos = 0;
					// Linha do Header
					$qtd_titulos++;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo.'.'.$reg_pr->Parcela;
						$nr_fatura2 = fill_full($reg_pr->Contas_Nr_Contas,9).fill_full($reg_pr->Modelo,1);
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						if(strlen(limpa_numero($reg_sacado[0]))==11){
							$tipo_sacado = '1';
						}else if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = (Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						if(($reg_pr->Boleto_Carteira=='01')||($reg_pr->Boleto_Carteira=='04')){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							if ($_SESSION['Dominio']==11){
								$chave5_numero = preenche_texto($reg_pr->Nr_Doc.'.'.$reg_pr->Parcela,10);
							}
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$data_criacao = data2nr(dataf($reg_pr->DH_Criacao));
							$data_vencto = data2nr(dataf($reg_pr->DT_Vencto));
							$data_minima = $data_vencto - 7;
							if ($data_criacao>$data_minima){
								$data_criacao = $data_minima;
							}
							$data_criacao = datad($data_criacao);
							$instrucao1 = '08';
							$instrucao2 = '00';
							$dias_protesto=0;
							if (($_SESSION['Dominio']==83)||( Zathura() )){
								if ($reg_pr->Dias_Protesto>0){
									$instrucao2 = '06';
									$dias_protesto=$reg_pr->Dias_Protesto;
								}
							}
							$tp_multa='0';
							if ($reg_sql->Multa_Perc>0){
								$tp_multa='4';
							}
							$valor_juros = 0;
							if($reg_sql->Mora_Perc > 0){
								$valor_juros = $reg_sql->Valor_Liquido * ($reg_sql->Mora_Perc); // Mora ao dia
								if($valor_juros < 0.01){
									$valor_juros = 0;
								}
								$valor_juros = arredonda_numero_menos($valor_juros);
							}
							if ($valor_juros >= 1){
								$instrucao1 = $instrucao2;  //se tem protesto na fatura, ento tem que coloca na instruo 1 quando tem juros
								$instrucao2 = '00';
							}
							$agencia = fill_full($reg_pr->Boleto_NrAgencia,4);
							$dig_agencia = financeiro_gera_boleto_caixa_modulo_11($agencia);
							$convenio = fill_full($reg_pr->Boleto_NrConvenio,9);
							$dig_convenio = financeiro_gera_boleto_caixa_modulo_11($convenio);
							//$conta = fill_full($reg_pr->Boleto_NrConta,9);
							//$compl_conta = substr($conta,7,2);
							$conta = fill_full($reg_pr->Boleto_NrConta,5);                          
							
							$variacao = $reg_pr->Boleto_Carteira_Variacao;
							$nosso_numero = fill_full($reg_pr->Boleto_NossoNumero,7);
							$dig_nosso_numero = financeiro_gera_boleto_caixa_modulo_11(fill_full($nosso_numero,12));
							//$dig_nosso_numero  = financeiro_gera_boleto_caixa_modulo_11($agencia.$conta.$variacao.$carteira.$nosso_numero);
							$dig_agencia_conta = financeiro_gera_boleto_caixa_modulo_11($agencia.$conta);
							$ag_cob = fill_full($agencia.$dig_agencia,5);
                            //Modificacao  para Dimel 83 conforme e-mail  - 27-07-2020
                            //No boleto carteira 01 para o layout  a POSTAGEM
                            //No arquivo de remessa carteira 05 para o layout  a POSTAGEM 
							if (($_SESSION['Dominio']=='83')||( Zathura() )){
								$postagem = '5';
								$ag_cob = fill_full('0',5);
							}else{
								$postagem = '5';
							}
							$conteudo1 = '1'.  //TIPO DE REGISTRO IDENTIFICAO DO REGISTRO TRANSAO 001 001 9(01) 1
										'02'.//CDIGO DE INSCRIO TIPO DE INSCRIO DA EMPRESA 002 003 9(02) NOTA 1
										fill_full(limpa_numero($reg_empresa[0]),14). //NMERO DE INSCRIO No DE INSCRIO DA EMPRESA (CPF/CNPJ) 004 017 9(14) NOTA 1
										$codigo_transmissao.  //AGNCIA(4) +Conta Movimento(8) e Conta Combrana (8)
										preenche_texto(formata_texto_limpo($nr_fatura),25).//USO DA EMPRESA IDENTIFICAO DO TTULO NA EMPRESA 038 062 X(25) NOTA 2
										$nosso_numero.$dig_nosso_numero. //NOSSO NMERO IDENTIFICAO DO TTULO NO BANCO 063 070 9(08) NOTA 3
										'000000'. //data segundo desconto
										' '. //branco
										$tp_multa.//tp multa (4 - com multa)
										fill_full(round($reg_sql->Multa_Perc*100),4). //Perc Multa
										fill_full('0',2). //unidade de moeda
										fill_full('0',13). //valor outra unidade
										preenche_texto('',4). //brancos
										fill_full('0',6). //data multa
										$postagem.//'5'. //Codigo carteira
										'01'.//ocorrencia
										$chave5_numero.  //No DO DOCUMENTO No DO DOCUMENTO DE COBRANA (DUPL.,NP ETC.) 111 120 X(10) NOTA 18
										substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2).  //VENCIMENTO DATA DE VENCIMENTO DO TTULO 121 126 9(06) NOTA 7
										fill_full(round($reg_sql->Valor_Liquido*100),13). //VALOR DO TTULO VALOR NOMINAL DO TTULO 127 139 9(11)V9(2) NOTA 8
										$reg_pr->Boleto_Banco.  //CDIGO DO BANCO No DO BANCO NA CMARA DE COMPENSAO 140 142 9(03) 341
										$ag_cob. //AGNCIA COBRADORA AGNCIA ONDE O TTULO SER COBRADO 143 147 9(05) NOTA 9
										'01'. //ESPCIE ESPCIE DO TTULO 148 149 X(02) NOTA 10
										'N'.  //ACEITE IDENTIFICAO DE TTULO ACEITO OU NO ACEITO 150 150 X(01) A=ACEITE
										substr(limpa_numero(dataf($reg_pr->DH_Criacao)),0,4).substr(limpa_numero(dataf($reg_pr->DH_Criacao)),6,2).//DATA DE EMISSO DATA DA EMISSO DO TTULO 151 156 9(06) NOTA 31
										$instrucao1.//INSTRUO 1 1a INSTRUO DE COBRANA 157 158 X(02) NOTA 11
										$instrucao2.//INSTRUO 2 2a INSTRUO DE COBRANA 159 160 X(02) NOTA 11
										fill_full($valor_juros,13). //JUROS DE 1 DIA VALOR DE MORA POR DIA DE ATRASO 161 173 9(11)V9(2) NOTA 12
										'000000'.//DESCONTO AT DATA LIMITE PARA CONCESSO DE DESCONTO 174 179 9(06) DDMMAA
										fill_full('0',13). //VALOR DO DESCONTO VALOR DO DESCONTO A SER CONCEDIDO 180 192 9(11)V9(2) NOTA 13
										fill_full('0',13). //VALOR DO I.O.F. VALOR DO I.O.F. RECOLHIDO P/ NOTAS SEGURO 193 205 9(11)V((2) NOTA 14
										fill_full('0',13). //ABATIMENTO VALOR DO ABATIMENTO A SER CONCEDIDO 206 218 9(11)V9(2) NOTA 13
										fill_full($tipo_sacado,2).  //CDIGO DE INSCRIO IDENTIFICAO DO TIPO DE INSCRIO/PAGADOR 219 220 9(02) 01=CPF
										fill_full(limpa_numero($reg_sacado[0]),14). //NMERO DE INSCRIO No DE INSCRIO DO PAGADOR (CPF/CNPJ) 221 234 9(14)
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40). //NOME NOME DO PAGADOR 235 264 X(30) NOTA 15
										preenche_texto(formata_texto_limpo($endereco_log),40).  //LOGRADOURO RUA, NMERO E COMPLEMENTO DO PAGADOR 275 314 X(40)
										preenche_texto(formata_texto_limpo($reg_endereco[6]),12). //BAIRRO BAIRRO DO PAGADOR 315 326 X(12)
										fill_full(limpa_numero($reg_endereco[5]),8). //CEP CEP DO PAGADOR 327 334 9(08)
										preenche_texto(formata_texto_limpo($reg_endereco[3]),15). //CIDADE CIDADE DO PAGADOR 335 349 X(15)
										preenche_texto(formata_texto_limpo($reg_endereco[4]),2). //ESTADO UF DO PAGADOR 350 351 X(02)
										preenche_texto('',30).//SACADOR/AVALISTA NOME DO SACADOR OU AVALISTA 352 381 X(30) NOTA 16
										' './/BRANCOS
										'I'.
										$compl_conta.
										preenche_texto('',6).//BRANCOS
										fill_full($dias_protesto,2).//'00'.     //PRAZO QUANTIDADE DE DIAS protensto
										' '.      //BRANCOS COMPLEMENTO DO REGISTRO 394 394 X(01)
										fill_full($sequencia,6). //NMERO SEQENCIAL No SEQENCIAL DO REGISTRO NO ARQUIVO 395 400 9(06)
										$fim_linha;
							$sequencia++;
							$valor_total+= $reg_sql->Valor_Liquido;
							$qtd_titulos++;
							$arquivo_montado.= $conteudo1;
							//$msg_tmp = explode(';',$reg_sql->Mensagens);
							//$qtd_msg = sizeof($msg_tmp);
							//$resto_msg = (4 - $qtd_msg);
							//$txt_instrucoes = '';
							$tem_envio = true;
						}//fim carteira com registro
					}//fim looping
					// Linha do Trailler
					$qtd_titulos++;
					$rodape = 			'9'.
										fill_full($qtd_titulos,6).
										fill_full(round($valor_total*100),13). //VALOR DO TTULO VALOR NOMINAL DO TTULO 127 139 9(11)V9(2) NOTA 8
										fill_full('0',374).     // preenche_texto('',374).
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='237'){ //se banco Bradesco
					$agencia = fill_full(substr($reg_pessoa_conta->Agencia,0,4),4);
					$conta   = fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),5);
					$dig_agencia_conta = financeiro_gera_boleto_itau_modulo_10($agencia.$conta);
					$convenio = fill_full(substr($reg_pessoa_conta->Convenio,0,20),20);
					$data6 = limpa_numero(data_atual('data'));
					$data6 = substr($data6,0,4).substr($data6,6,2);
					$cabecalho.= 		'01REMESSA01'.preenche_texto('COBRANCA',15).
										$convenio.
										preenche_texto(formata_texto_limpo($reg_empresa[1]),30).
										'237'.preenche_texto('BRADESCO',15).
										$data6.
										preenche_texto('',8).
										'MX'.
										fill_full($nr_lote,7).
										preenche_texto('',277).
										'000001'.
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					$sequencia++;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						if(strlen(limpa_numero($reg_sacado[0]))==11){
							$tipo_sacado = '1';
						}else if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = (Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = 'S';
						}else{
							$postagem = 'N';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						if(($reg_pr->Boleto_Carteira=='12')||($reg_pr->Boleto_Carteira=='09')||($reg_pr->Boleto_Carteira=='08')){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							$data_criacao = data2nr(dataf($reg_pr->DH_Criacao));
							$data_vencto = data2nr(dataf($reg_pr->DT_Vencto));
							$data_minima = $data_vencto - 7;
							if ($data_criacao>$data_minima){
								$data_criacao = $data_minima;
							}
							$data_criacao = datad($data_criacao);
							$instrucao1 = '00';
							$instrucao2 = '00';
							$tp_multa='0';
							if ($reg_sql->Multa_Perc>0){
								$tp_multa='2';
							}
							$valor_juros = 0;
							if ($reg_sql->Mora_Perc>0){
								if ($reg_sql->Mora_Perc==0.03){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.01)/30;
								}else if ($reg_sql->Mora_Perc==0.06){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.02)/30;
								}else if ($reg_sql->Mora_Perc==0.11){
									$valor_juros = ($reg_sql->Valor_Liquido * 0.035)/30;
								}else{
									$valor_juros = ($reg_sql->Valor_Liquido * $reg_sql->Mora_Perc/100);
								}
								$valor_juros = arredonda_numero_menos($valor_juros*100);
							}
							//if ($valor_juros>=1){
							//    $instrucao1='44';
							//}
							/*
							$dias_protesto=0;
							if ($_SESSION['Dominio']==83){
							if ($reg_pr->Dias_Protesto>0){
							$instrucao2 = '35';
							$dias_protesto=$reg_pr->Dias_Protesto;
							if ($instrucao1=='00'){
							$instrucao1 = '35';
							$instrucao2 = '00';
							}
							}
							}*/
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$agencia = fill_full($reg_pr->Boleto_NrAgencia,5); //4
							$conta = fill_full($reg_pr->Boleto_NrConta,7);
							//$conta = ltrim($conta,'0');
							//$convenio = fill_full($reg_pr->Boleto_NrConvenio,20);
							$carteira = fill_full($reg_pr->Boleto_Carteira,2);
							$variacao = $reg_pr->Boleto_Carteira_Variacao;
							$carteira2 = $variacao.$carteira;
							$nosso_numero = fill_full($reg_pr->Boleto_NossoNumero,11);
							$dig_nosso_numero  = financeiro_gera_boleto_bradesco_digitoVerificador_nossonumero($carteira.$nosso_numero);
							$dig_agencia_conta = financeiro_gera_boleto_bradesco_modulo_10($agencia.$conta);
							$dig_conta = financeiro_gera_boleto_bradesco_digitoVerificador_nossonumero($conta);
							$conteudo1 = '1'. //IDENTIFICAO DO REGISTRO
										fill_full('0',19). //CAMPOS OPCIONAIS
										'0'. //ZERO
										$carteira2. //CARTEIRA
										$agencia. //AGENCIA
										$conta. //CONTA CORRENTE
										$dig_conta. //IDENTIFICAO DA EMPRESA BENEFECIRIA NO BANCO
										preenche_texto($reg_pr->Boleto_SeuNumero,25). //NMERO CONTROLE DO PARTICIPANTE
										'000'. //CDIGO DO BANCO - PREENCHER COM ZEROS
										$tp_multa. //CAMPO DE MULTA
										fill_full(round($reg_sql->Multa_Perc*100),4). //PERCENTUAL DE MULTA
										$nosso_numero.$dig_nosso_numero. //IDENTIFICAO DO TTULO DO BANCO. DGITO DE AUTO CONFERNCIA DO NMERO BANCRIO
										fill_full(round($valor_descto*100),10). //DESCONTO BONIFICAO POR DIA
										'2'. //TIPO BOLETO (QUEM EMITE). 1 = BANCO EMITE E PROCESSA O REGISTRO. 2 = CLIENTE EMITE E O BANCO SOMENTE PROCESSA O REGISTRO
										' '. //IDENTIFICAO SE EMITE BOLETO PARA DBITO AUTOMTICO
										preenche_texto('',10). //BRANCOS
										' '. //INDICADOR RATEIO CRDITO
										'2'. //AVISO DBITO AUTOMTICO.
										'  '. //BRANCO
										'01'.  //IDENTIFICAO DA OCORRNCIA
										$chave5_numero.  //No DO DOCUMENTO
										substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2).  //VENCIMENTO DATA DE VENCIMENTO DO TTULO
										fill_full(round($reg_sql->Valor_Liquido*100),13). //VALOR DO TTULO
										'000'. //PREENCHER COM ZEROS
										'00000'. //PREENCHER COM ZEROS
										'01'. //ESPCIE ESPCIE DO TTULO
										'N'. //ACEITE IDENTIFICAO DE TTULO. SEMPRE N
										substr(limpa_numero(dataf($reg_pr->DH_Criacao)),0,4).substr(limpa_numero(dataf($reg_pr->DH_Criacao)),6,2).//DATA DE EMISSO DATA DA EMISSO DO TTULO
										$instrucao1.//INSTRUO 1 1a INSTRUO DE COBRANA
										$instrucao2.//INSTRUO 2 2a INSTRUO DE COBRANA
										fill_full($valor_juros,13). //MORA POR DIA DE ATRASO
										'000000'.//DESCONTO AT DATA LIMITE PARA CONCESSO DE DESCONTO DDMMAA
										fill_full('0',13). //VALOR DO DESCONTO VALOR DO DESCONTO A SER CONCEDIDO
										fill_full('0',13). //VALOR DO I.O.F. VALOR DO I.O.F. RECOLHIDO P/ NOTAS SEGURO
										fill_full('0',13). //ABATIMENTO VALOR DO ABATIMENTO A SER CONCEDIDO
										fill_full($tipo_sacado,2).  //CDIGO DE INSCRIO IDENTIFICAO DO TIPO DE INSCRIO/PAGADOR 01=CPF
										fill_full(limpa_numero($reg_sacado[0]),14). //NMERO DE INSCRIO No DE INSCRIO DO PAGADOR (CPF/CNPJ)
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40). //NOME NOME DO PAGADOR 235 264 X(30) NOTA 15
										preenche_texto(formata_texto_limpo($endereco_log),40).  //LOGRADOURO RUA, NMERO E COMPLEMENTO DO PAGADOR
										preenche_texto('',12). //1 MENSAGEM
										fill_full(limpa_numero($reg_endereco[5]),8). //CEP CEP DO PAGADOR
										preenche_texto('',60).//SACADOR/AVALISTA NOME DO SACADOR/AVALISTA OU 2 MENSAGEM
										fill_full($sequencia,6). //NMERO SEQENCIAL No SEQENCIAL DO REGISTRO
										$fim_linha;
							$sequencia++;
							$arquivo_montado.= $conteudo1;
							$msg_tmp = explode(';',$reg_sql->Mensagens);
							$qtd_msg = sizeof($msg_tmp);
							$resto_msg = (4 - $qtd_msg);
							$txt_instrucoes = '';
							$tem_envio = true;
						}
					}//fim looping
					$rodape = 			'9'.
										preenche_texto('',393).
										fill_full($sequencia,6).
										$fim_linha;

					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='085'){ //cecred
					//$agencia = fill_full(substr($reg_pessoa_conta->Agencia,0,4),5);
					//$conta   = fill_full(substr($reg_pessoa_conta->Numero_Conta,0,5),12);
					$agencia = fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5);
					$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12);
					$dig_agencia_conta = financeiro_gera_boleto_cecred_modulo_10($agencia.$conta);
					$dig_agencia = financeiro_gera_boleto_cecred_modulo_11($agencia);
					$dig_conta = financeiro_gera_boleto_cecred_modulo_11($conta);
					$convenio = fill_full(substr($reg_pessoa_conta->Convenio,0,20),20);
					$conta_nossonum = fill_full($reg_pessoa_conta->Numero_Conta,7);
					$dig_conta = financeiro_gera_boleto_cecred_modulo_11($conta_nossonum);
					$data6 = limpa_numero(data_atual('data'));
					//$data6 = substr($data6,0,4).substr($data6,6,2);
					$data_geracao = limpa_numero(dataf($reg_sql1->Data_Processo));
					//$data_geracao = substr($data_geracao,0,4).substr($data_geracao,6,2);
					//Header arquivo
					$cabecalho.=		'085'.
										'0000'.
										'0'.preenche_texto('',9).
										'2'.
										fill_full(limpa_numero($reg_empresa[0]),14).
										preenche_texto(substr($reg_pessoa_conta->Convenio,0,20),20).
										$agencia.
										$dig_agencia.
										$conta.
										$dig_conta.
										' '.
										preenche_texto(formata_texto_limpo($reg_empresa[1]),30).
										preenche_texto(formata_texto_limpo('CECRED'),30).
										preenche_texto('',10).
										'1'. //codigo remessa
										$data6.
										limpa_numero(nr2hora(hora_atual('nr'))).
										fill_full($nr_lote,6).
										'087'. //versao layout
										'00000'.  // Densidade
										preenche_texto(' ', 20).     // Brancos
										preenche_texto(' ', 20).     // Brancos
										preenche_texto(' ', 29).     // Brancos
										$fim_linha;
					//Header do Lote
					$cabecalho.= 		'085'.                                                        // Banco
										'0001'.                                                       // Lote
										'1'.                                                          // Id. de Header de Lote
										'R'.                                                          // Operao - R - Remessa
										'01'.                                                         // Tipo de Servio - 01 - Incluso
										'  '.                                                         // Branco
										'045'.                                                        // Verso do LAyout do Lote
										' '.                                                          // Branco
										'2'.                                                          // Tipo Inscrio CGC
										fill_full(limpa_numero($reg_empresa[0]),15).                  // CGC da Empresa
										preenche_texto(substr($reg_pessoa_conta->Convenio,0,20),20).  // Convenio da Empresa
										fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5).       // Agencia da Empresa
										financeiro_gera_boleto_cecred_modulo_11($reg_pessoa_conta->Agencia). // Dig. Agencia
										fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12).        // Conta da Empresa
										financeiro_gera_boleto_cecred_modulo_11($reg_pessoa_conta->Numero_Conta).// Dig. Conta
										' '.                                                          // Dig. Agencia/Conta (Branco)
										preenche_texto($reg_empresa[1], 30).                          // Nome Empresa
										preenche_texto(' ', 40).     // Mensagem 1
										preenche_texto(' ', 40).     // Mensagem 2
										fill_full($nr_lote, 8).      // Nmero do Arquivo
										$data_geracao.  // Data Gerao do Arquivo
										'00000000'.                  // Data do Credito //??
										preenche_texto(' ', 33).     // Brancos
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$nosso_numero_bol = fill_full($reg_pr->Boleto_NossoNumero,9);
							$nosso_numero  = $conta_nossonum.$dig_conta.$nosso_numero_bol;
							$cod_carteira = '1';
							$cod_id_emissao = '2';
							$cod_id_distr = '2';
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_juros  = (($reg_pr->Juros_Perc       * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_multa  = (($reg_pr->Multa_Perc       * $reg_sql->Valor_Liquido ) /100);
							if($valor_juros>=0.01){
								$cod_juros = '1';
								$data_juros = limpa_numero(dataf($reg_pr->DT_Vencto));
								$vl_juros = fill_full(arredonda_numero_menos($valor_juros*100),15);
							}else{
								$cod_juros = '3';
								$data_juros = '00000000';
								$vl_juros = fill_full(0,15);
							}
							$conteudo1 = 
										'085'.
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'P'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full(limpa_numero($reg_pessoa_conta->Agencia), 5).            			// Agencia da Empresa
										financeiro_gera_boleto_cecred_modulo_11($reg_pessoa_conta->Agencia).   		// Dig. Agencia
										fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12).      			// Conta da Empresa
										financeiro_gera_boleto_cecred_modulo_11($reg_pessoa_conta->Numero_Conta).  	// Dig. Conta
										' '.                                            // Dig. Agencia/Conta (Branco)
										preenche_texto($nosso_numero,20).               // Nosso Nmero
										$cod_carteira.                         			// Cdigo da Carteira
										'1'.                         					// Forma Cadastro 1 = Com Cadastro
										'1'.                         					// Tipo Documento 1 = Tradicional
										$cod_id_emissao.            	 				// Identificao de Emisso - ' = Cooperativa Emite 2 - Cliente emite
										$cod_id_distr.               					// Identificao de Distrib - 1 = Cooperativa Distribui 2 = Cooperado Distribui 3 = Banco envia e-mail 4 = Banco envia SMS
										preenche_texto($nr_fatura,15).  				// Nr da Fatura
										limpa_numero(dataf($reg_pr->DT_Vencto)).        // Data de Vencimento
										fill_full(round($reg_sql->Valor_Liquido*100),15).// Valor do Ttulo
										'00000 '.                           			// Agencia Cobranca - Zeros
										'02'.                              			 	// Espcie do Ttulo - Duplicata MErcantil por Indicao (Obrigatorio DM no pode)
										'N'.                                      		// Aceito no aceito
										limpa_numero(dataf($reg_pr->DH_Criacao)).		// Data de Emisso
										$cod_juros.                                     // Cdigo da Mora - 1 Valor Por Dia
										$data_juros.  									// Data de Juros de Mora
										$vl_juros;    									// Valor do Juros
							if($valor_descto > 0){  //desconto de antecipao
								$conteudo1.= '3'.                                     	// Identificao Tipo de Desconto - 3 - Valor Por Antecipacao Dia Corrido.
										limpa_numero(dataf($reg_pr->DT_Vencto)). 		// Data de Desconto
										fill_full(round($valor_descto*100),15);  		// Valor Desconto Concedido
							}else{
								$conteudo1.= '0'.                                    	// Cdigo Desconto  0 - Sem Desconto
										fill_full('0', 8).                       		// Data de Desconto
										fill_full('0', 15);                      		// Valor Desconto Concedido
							}
							$conteudo1.= fill_full('0', 15).               				// Valor IOF
										fill_full('0', 15).                            	// Valor Abatimento
										preenche_texto($nr_fatura,25);                 	// Nr da Fatura
                            //solicitacao em 09/06/2020 para retirar o protesto encaminhado para o banco, mas manter a informao
							if(($_SESSION["Dominio"] != $dominios['-271']) && ($reg_pr->Dias_Protesto>0)&&($reg_pr->Dias_Protesto<100)){
								$conteudo1.= '1'.                                   	// Cdigo do Protesto 1 - Dias Corridos
										fill_full($reg_pr->Dias_Protesto,2);   			// Dias para Protesto
							//Modificado para Hardt em 03/11/2021 por @isabel
							}else if( (($_SESSION['Dominio'] == '205') || ($_SESSION['Dominio'] == 'xx')  )&&($reg_pr->Boleto_Banco == '085') ){
								$conteudo1.= '3'.                           			// Cdigo do Protesto 3 - No Protestar
										'00';                         					// Dias para Protesto
							}else{
								$conteudo1.= '3'.                           			// Cdigo do Protesto 3 - No Protestar
										'00';                         					// Dias para Protesto
							}
							$conteudo1.= '2'.                           // Cdigo para Baixa/Devoluo 2 No Baixa
										preenche_texto(' ',3).          // Dias para Baixa Devoluo
										'09'.                           // Cdigo da Moeda
										fill_full('0', 10).             // Nr do Contr. de Op. de Crdito
										' '.                            // Brancos
										$fim_linha;
							$sequencia++;
							$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
											' where Dominio = "'.$_SESSION["Dominio"].'"'.
											' and Pessoa = "'.$reg_sql->Pessoa.'"';
							$res_sacado = consulta_sql($cons_sacado);
							$reg_sacado = consulta_ler_linha($res_sacado);
							consulta_limpa($res_sacado);
							$tipo_sacado = '1';
							if(strlen(limpa_numero($reg_sacado[0]))==14){
								$tipo_sacado = '2';
							}
							//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
							//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
							//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
							//				' and Situacao="A"'.
							//				' order by Seq_Endereco LIMIT 1';
							$ok_ender = false;				
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' AND Tipo_Endereco="4"'.
											' ORDER BY Seq_Endereco';
							$res_endereco_clit = consulta_sql($cons_endereco);
							$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
							consulta_limpa($res_endereco_clit);
							if ($reg_endereco_clit->UF!=''){
								$ok_ender = (Zathura() );				
							}else{			
								$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
												' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
												' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
												' AND Situacao = "A" '.
												' ORDER BY Seq_Endereco';
							}						
							if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
							//if ($reg_pr->Nr_Nota>0){
								if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
									($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
									($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
									$con_nf = 'select Dest_Endereco from nota_fiscal '.
												' where Dominio="'.$_SESSION["Dominio"].'"'.
												' and Empresa="'.$reg_pr->Empresa.'"'.
												' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
									$res_nf = consulta_sql($con_nf);
									$reg_nf = consulta_ler_linha($res_nf);
									consulta_limpa($res_nf);
									if ($reg_nf[0]>0){
										$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
														' where Dominio="'.$_SESSION["Dominio"].'"'.
														' and Pessoa="'.$reg_pr->Pessoa.'"'.
														' and Seq_Endereco="'.$reg_nf[0].'"';

									}
								}
							}
							$res_endereco = consulta_sql($cons_endereco);
							$reg_endereco = consulta_ler_linha($res_endereco);
							consulta_limpa($res_endereco);
							$endereco_log = $reg_endereco[0];
							if($reg_endereco[1]!=''){
								$endereco_log.=', '.$reg_endereco[1];
							}else{
								$endereco_log.=', S/N';
							}
							if($reg_endereco[2]!=''){
								$endereco_log.=' '.$reg_endereco[2];
							}
							//Registro Detalhe - Segmento Q
							$conteudo1.= '085'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'Q'.
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full($tipo_sacado,1).                   // Tipo Incrio do Cliente
										fill_full(limpa_numero($reg_sacado[0]),15).  // CGC/CPF Cliente
										preenche_texto($reg_sacado[1],40).           // Nome Cliente
										preenche_texto($endereco_log,40).            // Endereco do Cliente
										preenche_texto($reg_endereco[6],15).         // Bairro Cliente
										fill_full(limpa_numero($reg_endereco[5]),8). // CEP Cliente
										preenche_texto($reg_endereco[3],15).         // Cidade Cliente
										preenche_texto($reg_endereco[4],2).         // Estado Cliente
										'0'.                         // Tipo Incrio Avalista
										fill_full('0', 15).          // CPF Avalista
										preenche_texto(' ', 40).     // Nome Avalista
										'000'.                       // Banco Cobranca
										preenche_texto(' ', 20).     // Nosso Nmero no Banco Cobranca
										preenche_texto(' ', 8).      // Brancos
										$fim_linha;
							$sequencia++;
							//Registro Detalhe - Segmento R - Valor de Multa
							$perc_multa = $reg_pr->Multa_Perc;
							if($perc_multa>0.01){
								$conteudo1.= '085'.                  // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'R'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full('0', 24).          // Desconto 2
										fill_full('0', 24).          // Desconto 3
										'2'.                         // Cod Multa - 1 Valor Fixo - 2 Percentual
										limpa_numero(dataf($reg_pr->DT_Vencto)). //Data base da multa
										fill_full(round($reg_pr->Multa_Perc*100),15).   //Valor/Percentual Multa
										preenche_texto(' ', 10).     // inf Banco Sacado
										preenche_texto(' ', 40).     // Mensagem 3
										preenche_texto(' ', 40).     // Mensagem 4
										fill_full('0', 28).          // Inf Dbito
										preenche_texto(' ', 33).     // Brancos
										$fim_linha;
								$sequencia++;
							}//fim multa
							$arquivo_montado.= $conteudo1;
						}//fim com registro
					}//fim looping
					$rodape = 			'085'.                       // Banco
										'0001'.                      // Lote
										'5'.                         // Id. de Detalhe
										preenche_texto(' ', 9).      // Brancos
										fill_full($sequencia+1, 6).  // Seq no Lote
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										preenche_texto(' ', 8).      // Brancos
										preenche_texto(' ', 117).    // Brancos
										$fim_linha;
					$rodape.= 			'085'.                       // Banco
										'9999'.                      // Lote
										'9'.                         // Id. de Trailer do Arquivo
										preenche_texto(' ', 9).      // Branco
										fill_full('1', 6).           // Lotes do Arquivo
										fill_full(($sequencia+3), 6).// Qtd de Registros do Lote
										fill_full('0', 6).           // Qtd de Registros com Oper = E
										preenche_texto(' ', 205).	 // Brancos
										$fim_linha;    
					$arquivo_montado.= $rodape;
					$sequencia++;
					//fim banco cecred
				}else if($reg_sql1->Banco=='041'){ //banrisul
					$agencia = fill_full(limpa_numero($reg_pessoa_conta->Agencia), 4);
					$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 9);
					$convenio = fill_full(substr($reg_pessoa_conta->Convenio,0,7),7);
					$carteira = fill_full(limpa_numero($reg_pessoa_conta->Carteira), 1);
					$data_geracao = limpa_numero(dataf($reg_sql1->Data_Processo));
					$data_geracao = substr($data_geracao,0,4).substr($data_geracao,6,2);
					$cod_cedente = $agencia.$convenio.financeiro_gera_boleto_banrisul_modulo_10_11($agencia.$convenio);
					//Header arquivo
					$cabecalho.= 		preenche_texto('01REMESSA',9).
										preenche_texto('',17). //brancos
										$cod_cedente.
										preenche_texto('',7). //brancos
										preenche_texto(formata_texto_limpo2($reg_empresa[1]),30). //nome da empresa
										preenche_texto('041BANRISUL',11).
										preenche_texto('',7). //brancos
										$data_geracao.        //data geracao
										preenche_texto('',9). //brancos
										preenche_texto('',4). //codigo do servico
										preenche_texto('',1). //brancos
										preenche_texto('',1). //tipo de processamento
										preenche_texto('',1). //brancos
										preenche_texto('',10). //codigo do cliente
										preenche_texto('',268). //brancos
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					$sequencia++;
					$valor_total=0;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						$nosso_numero = $reg_pr->Boleto_NossoNumero;
						$nosso_numero_dv = financeiro_gera_boleto_banrisul_modulo_10_11($nosso_numero, 7);
						$nosso_numero = fill_full($nosso_numero.$nosso_numero_dv,10);
						$aceite = 'N';
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						if(strlen(limpa_numero($reg_sacado[0]))==11){
							$tipo_sacado = '1';
						}else if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = ( Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
											' where Dominio="'.$_SESSION["Dominio"].'"'.
											' and Empresa="'.$reg_pr->Empresa.'"'.
											' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$valor_multa  = (($reg_pr->Multa_Perc       * $reg_sql->Valor_Liquido ) /100);
							$valor_juros  = (($reg_pr->Juros_Perc       * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$instrucao1 = '23';
							$dias_protesto = '00';
							if(($reg_pr->Dias_Protesto>3)&&($reg_pr->Dias_Protesto<100)){
								$instrucao1 = '09';
								if($reg_pr->Dias_Protesto > 90){
									$dias_protesto = '90';
								}else{
									$dias_protesto = fill_full($reg_pr->Dias_Protesto, 2);
								}
							}
							$instrucao2 = '00';
							/* $valor_juros = 0;
							if($reg_sql->Mora_Perc>0){
							if($reg_sql->Mora_Perc==0.03){
							$valor_juros = ($reg_sql->Valor_Liquido * 0.01)/30;
							}else if ($reg_sql->Mora_Perc==0.06){
							$valor_juros = ($reg_sql->Valor_Liquido * 0.02)/30;
							}else if ($reg_sql->Mora_Perc==0.11){
							$valor_juros = ($reg_sql->Valor_Liquido * 0.035)/30;
							}else{
							$valor_juros = ($reg_sql->Valor_Liquido * $reg_sql->Mora_Perc/100);
							}
							if($valor_juros<0.01){
							$valor_juros = 0;
							}
							$valor_juros = arredonda_numero_menos($valor_juros*100);
							}
							if($valor_juros>=1){
							$instrucao2 = '18';
							if($instrucao1=='00'){
							$instrucao1 = '18';
							$instrucao2 = '00';
							}
							} */
							$valor_multa  = (($reg_pr->Multa_Perc * $reg_sql->Valor_Liquido ) /100);
							if($valor_multa > 0){
								$instrucao2 = '18';
								if($instrucao1=='00'){
									$instrucao1 = '18';
									$instrucao2 = '00';
								}
							}
							$descto_pontual = 0;
							if($reg_pr->Desconto_Pontual > 0.001){
								$descto_pontual = $reg_pr->Desconto_Pontual;
							}
							if($valor_descto > 0){
								$valor_descto = round($valor_descto*100);
							}
							$conteudo1 = '1'. //TIPO DE REGISTRO: 1
										preenche_texto('',16). //brancos
										$cod_cedente.     //CDIGO DE CEDENTE
										preenche_texto('',7). //brancos
										preenche_texto($reg_pr->Boleto_SeuNumero,25). //preenche_texto(formata_texto_limpo($nr_fatura),25). IDENTIFICAO DO TTULO PARA O BENEFICIRIO
										$nosso_numero.    //NOSSO NMERO - IDENTIFICAO DO TTULO PARA O BANCO
										preenche_texto('',32). //MENSAGEM NO BLOQUETO
										preenche_texto('',3). //brancos
										'1'. //TIPO DE CARTEIRA
										'01'. //CD. DE OCORRNCIA IDENTIFICAO DA OCORRNCIA 109 110
										preenche_texto('VIDE038050',10). //Seu Nmero com at 13 dgitos: Informe VIDE038050 nas posies 111-120; Informe o seu nmero com at 13 dgitos nas posies 038-050.
										substr(limpa_numero(dataf($reg_pr->DT_Vencto)),0,4).substr(limpa_numero(dataf($reg_pr->DT_Vencto)),6,2). //DATA DE VENCIMENTO DO TTULO DDMMAA
										fill_full(round($reg_sql->Valor_Liquido*100),13).  //VALOR DO TTULO
										'041'. // BANCO COBRADOR: 041
										preenche_texto('',5). //brancos
										'08'. //TIPO DE DOCUMENTO
										$aceite.
										substr(limpa_numero(dataf($reg_pr->DH_Criacao)),0,4).substr(limpa_numero(dataf($reg_pr->DH_Criacao)),6,2). //DATA DA EMISSO DO TTULO
										$instrucao1. //CDIGO DA 1 INSTRUO
										$instrucao2. // CDIGO DA 2 INSTRUO
										'0'. //Cdigo da Mora - 0  Valor dirio; 1  Taxa mensal
										fill_full(round($valor_juros*100),12).
										'000000'.//DESCONTO AT DATA LIMITE
										fill_full('0',13). //VALOR DO DESCONTO
										fill_full('0',13). //VALOR DO I.O.F.
										fill_full('0',13). //VALOR DO ABATIMENTO
										fill_full($tipo_sacado,2).
										fill_full(limpa_numero($reg_sacado[0]),14). //NMERO DE INSCRIO DO PAGADOR
										preenche_texto(formata_texto_limpo2($reg_sacado[1]),35). //NOME DO PAGADOR
										preenche_texto('',5). //brancos
										preenche_texto(formata_texto_limpo2($endereco_log),40).  //LOGRADOURO RUA, NMERO E COMPLEMENTO DO PAGADOR
										preenche_texto('',7); //brancos
							if($valor_multa > 0){
								$conteudo1.= 
										fill_full(round(($reg_pr->Multa_Perc*100)/10),3).   //Valor Multa    // Valor do Juros
										'00';  // NMERO DE DIAS PARA MULTA - 00 = APS O VENCIMENTO
							}else{
								$conteudo1.= 
										preenche_texto('',3). //brancos. // TAXA PARA MULTA APS O VENCIMENTO
										preenche_texto('',2); //brancos  // NMERO DE DIAS PARA MULTA APS O VENCIMENTO
							}
							$conteudo1.= fill_full(limpa_numero($reg_endereco[5]),8). //CEP DO PAGADOR
										preenche_texto(formata_texto_limpo2($reg_endereco[3]),15). //CIDADE DO PAGADOR
										preenche_texto(formata_texto_limpo2($reg_endereco[4]),2). //UF DO PAGADOR
										fill_full($descto_pontual,4). //TAXA AO DIA PARA PAGAMENTO ANTECIPADO
										preenche_texto('',1). //brancos
										fill_full($valor_descto,13). //VALOR PARA CLCULO DO DESCONTO
										$dias_protesto. //NMERO DE DIAS PARA PROTESTO OU DE DEVOLUO AUTOMTICA
										preenche_texto(' ',23). //brancos
										fill_full($sequencia,6).
										$fim_linha;
							$sequencia++;
							$valor_total+= $reg_sql->Valor_Liquido;
							$arquivo_montado.= $conteudo1;
						}
					}//fim for
					$rodape = 			'9'.
										preenche_texto('',26).
										fill_full(round($valor_total*100),13).
										preenche_texto('',354).
										fill_full($sequencia,6).
										$fim_linha;
					$arquivo_montado.= $rodape;
					$sequencia++;
				}else if($reg_sql1->Banco=='756'){ //se bancoob/sicoob
					//igual da caixa
					$agencia = fill_full(limpa_numero($reg_pessoa_conta->Agencia), 4);
					$conta =  fill_full(limpa_numero($reg_pessoa_conta->Numero_Conta), 12);
					$dig_agencia = financeiro_gera_boleto_sicoob_modulo_11($agencia);
					if( $_SESSION['Dominio']=='420'){
						$dig_conta = 0;
					}else{
						$dig_conta = financeiro_gera_boleto_sicoob_modulo_11($conta);
					}				
					$dig_agencia_conta = financeiro_gera_boleto_sicoob_modulo_11($agencia.
																				$dig_agencia.
																				$conta);
					$convenio10 = fill_full(limpa_numero($reg_pessoa_conta->Convenio),9);
					$convenio10_dv = financeiro_gera_boleto_sicoob_modulo_11($convenio10);
					$variacao = fill_full(limpa_numero($reg_pessoa_conta->Variacao), 2);
					$cabecalho.= 		'756'.                                                        // Banco
										'0000'.                                                       // Lote
										'0'.                                                          // Id. de Header
										preenche_texto(' ', 9).                                       // Brancos
										'2'.                                                          // Tipo Inscrio CGC CNPJ
										fill_full(limpa_numero($reg_empresa[0]),14).                  // CGC da Empresa
										preenche_texto(' ', 20).                                      // Zeros
										fill_full($agencia,5).                                        // Agencia da Empresa
										$dig_agencia.                                                 // Dig. Agencia
										$conta.                                                       // Conta da Empresa
										$dig_conta.
										'0'.                                                          // Dig Agencia-Conta: Zero
										preenche_texto($reg_empresa[1], 30).                          // Nome Empresa
										preenche_texto('SICOOB', 30).                				  // Nome Banco
										preenche_texto(' ', 10).                                      // Brancos
										'1'.                                                          // 1-Remessa/2-Retorno
										limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
										limpa_numero(nr2hora(hora_atual('nr'))).                      // Hora de Gerao do Arquivo //??
										fill_full($nr_lote, 6).      								  // Nmero do Arquivo
										'081'.                       								  // Verso do Layout
										'00000'.                     								  // Densidade
										preenche_texto(' ', 20).     								  // Brancos
										preenche_texto(' ', 20).     								  // Brancos
										preenche_texto(' ', 29).     								  // Brancos
										$fim_linha;
					//Header do Lote
					$cabecalho.= 		'756'.                                                        // Banco
										'0001'.                                                       // Lote
										'1'.                                                          // Id. de Header de Lote
										'R'.                                                          // Operao - R - Remessa
										'01'.                                                         // Tipo de Servio - 01 - Cobranca Registrada
										preenche_texto(' ', 2).                                       // Brancos
										'040'.                                                        // Verso do LAyout do Lote
										' '.                                                          // Brancos
										'2'.                                                          // Tipo Inscrio CGC
										fill_full(limpa_numero($reg_empresa[0]),15).                  // CGC da Empresa
										preenche_texto(' ', 20).                                      // Zeros
										fill_full($agencia,5).                                        // Agencia da Empresa
										$dig_agencia.                                                 // Dig. Agencia
										$conta.                                                       // Conta da Empresa
										$dig_conta.
										' '.                                                          // Dig Agencia-Conta: Branco
										preenche_texto(formata_texto_limpo($reg_empresa[1]), 30).     // Nome Empresa
										preenche_texto(' ', 40).     								  // Mensagem 1
										preenche_texto(' ', 40).    								  // Mensagem 2
										fill_full($nr_lote, 8).     								  // Nmero do Arquivo
										limpa_numero(dataf($reg_sql1->Data_Processo)).                // Data Gerao do Arquivo
										'00000000'.                  								  // Data do Credito //??
										preenche_texto(' ', 33).     								  // Brancos
										$fim_linha;
					$arquivo_montado.= $cabecalho;
					//$sequencia++;
					$valor_boletos = 0;
					$qtd_boletos=0;
					for($b=0;$b<$nrw_sql;$b++){
						$reg_sql = consulta_ler_objeto($res_sql);
						//consulta contas pr
						$cons_pr = 'select * from contas_pr '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$reg_sql->Contas_Empresa.'"'.
									' and Nr_Contas = "'.$reg_sql->Contas_Nr_Contas.'"'.
									' and Seq = "'.$reg_sql->Contas_Seq.'"';
						$res_pr = consulta_sql($cons_pr);
						$reg_pr = consulta_ler_objeto($res_pr);
						consulta_limpa($res_pr);
						$cons_sacado = 'select CPF_CNPJ, Nome_Razao, EMail from pessoa '.
										' where Dominio = "'.$_SESSION["Dominio"].'"'.
										' and Pessoa = "'.$reg_sql->Pessoa.'"';
						$res_sacado = consulta_sql($cons_sacado);
						$reg_sacado = consulta_ler_linha($res_sacado);
						consulta_limpa($res_sacado);
						$tipo_sacado = '1';
						if(strlen(limpa_numero($reg_sacado[0]))==14){
							$tipo_sacado = '2';
						}
						$email_sacado = $reg_sacado[2];
						//$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
						//				' where Dominio = "'.$_SESSION['Dominio'].'" '.
						//				' and Pessoa="'.$reg_sql->Pessoa.'"'.
						//				' and Situacao="A"'.
						//				' order by Seq_Endereco LIMIT 1';
						$ok_ender = false;				
						$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
										' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
										' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
										' AND Situacao = "A" '.
										' AND Tipo_Endereco="4"'.
										' ORDER BY Seq_Endereco';
						$res_endereco_clit = consulta_sql($cons_endereco);
						$reg_endereco_clit = consulta_ler_objeto($res_endereco_clit);
						consulta_limpa($res_endereco_clit);
						if ($reg_endereco_clit->UF!=''){
							$ok_ender = ( Zathura() );				
						}else{			
							$cons_endereco = 'SELECT Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro FROM pessoa_endereco '.
											' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
											' AND Pessoa = "'.$reg_sql->Pessoa.'"'.
											' AND Situacao = "A" '.
											' ORDER BY Seq_Endereco';
						}						
						if(($reg_pr->Nr_Nota > 0)&&($ok_ender==false)){
						//if ($reg_pr->Nr_Nota>0){
							if (($reg_pr->Modelo=='01')||($reg_pr->Modelo=='55')||
								($reg_pr->Modelo=='65')||($reg_pr->Modelo=='97')||
								($reg_pr->Modelo=='98')||($reg_pr->Modelo=='59')){
								$con_nf = 'select Dest_Endereco from nota_fiscal '.
										' where Dominio="'.$_SESSION["Dominio"].'"'.
										' and Empresa="'.$reg_pr->Empresa.'"'.
										' and Nr_Nota="'.$reg_pr->Nr_Nota.'"';
								$res_nf = consulta_sql($con_nf);
								$reg_nf = consulta_ler_linha($res_nf);
								consulta_limpa($res_nf);
								if ($reg_nf[0]>0){
									$cons_endereco = 'select Logradouro, Numero, Complemento, Nome_Cidade, UF, CEP, Bairro from pessoa_endereco '.
													' where Dominio="'.$_SESSION["Dominio"].'"'.
													' and Pessoa="'.$reg_pr->Pessoa.'"'.
													' and Seq_Endereco="'.$reg_nf[0].'"';
								}
							}
						}
						$res_endereco = consulta_sql($cons_endereco);
						$reg_endereco = consulta_ler_linha($res_endereco);
						consulta_limpa($res_endereco);
						$endereco_log = $reg_endereco[0];
						if($reg_endereco[1]!=''){
							$endereco_log.=', '.$reg_endereco[1];
						}else{
							$endereco_log.=', S/N';
						}
						if($reg_endereco[2]!=''){
							$endereco_log.=' '.$reg_endereco[2];
						}
						if($reg_sql->Tipo_Emissao=='A'){
							$postagem = '3';
						}else{
							$postagem = '0';
						}
						if($reg_sql->Pessoa>=100000){
							$cod_pes = 0;
						}else{
							$cod_pes = $reg_sql->Pessoa;
						}
						$nr_fatura = $reg_pr->Nr_Doc.'/'.$reg_pr->Serie.'-'.$reg_pr->Modelo;
						if($reg_sql->Tipo_Cobranca=='A'){ //com registro
							$tem_envio = true;
							$chave5_numero = preenche_texto($reg_pr->Boleto_SeuNumero,10);
							$chave5_filler = 1;
							$tipo_registro = 'A';
							//$nosso_numero = fill_full($reg_pr->Boleto_Carteira_Variacao,2).
							//                fill_full($reg_pr->Boleto_NossoNumero,15);
							//$nosso_numero = fill_full($reg_pr->Boleto_NossoNumero,10);
							$convenio10 = fill_full($reg_pr->Boleto_NrConvenio,9);
							$convenio10_dv = financeiro_gera_boleto_sicoob_modulo_11($convenio10);
							$nnum = fill_full($reg_pr->Boleto_NossoNumero,7);
							$dv_nosso_numero = financeiro_gera_boleto_sicoob_digitoVerificador_nossonumero("$agencia$convenio10$convenio10_dv$nnum");
							$nossonumero_dv = $nnum.$dv_nosso_numero;
							$variacao = fill_full($reg_pr->Boleto_Carteira_Variacao,2);
							$carteira = $reg_pr->Boleto_Carteira;
							$valor_descto = (($reg_pr->Desconto_Pontual * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_juros  = (($reg_pr->Juros_Perc       * $reg_sql->Valor_Liquido ) /100)/30;
							$valor_multa  = (($reg_pr->Multa_Perc       * $reg_sql->Valor_Liquido ) /100);
							$valor_boletos+= $reg_sql->Valor_Liquido;
							$qtd_boletos++;
							$aceite='N';
							$conteudo1 = '756'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'P'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full($agencia,5).       // Agencia da Empresa
										$dig_agencia.                // Dig. Agencia
										$conta.                      // Conta da Empresa
										$dig_conta.                  // Dig. Conta
										' '.                         // Dig Agencia-Conta: Branco
										//fill_full('0', 3).           // Zeros
										fill_full($nossonumero_dv,10). // Nosso Nmero
										fill_full($reg_pr->Parcela,2). //Parcela
										$variacao.                    //Modalidade
										'1'.                          // Tipo Formulario - 01=auto copiativo | 03=auto envelopavel | 04=A4 sem envelopamento | 06=A4 sem envelopamento 3 vias
										preenche_texto(' ',5).                                           //Brancos
										$carteira.                    //Codigo da Carteira
										'0'.                          //Cadastramento - Preencher com 0
										' '.                          //Tipo de documento - Preencher em branco
										'2'.                          //Identificao de emisso do boleto: 1 - Siccob emite | 2 - Beneficiario emite
										'2'.                          //Identificao de distribuio do boleto: 1 - Siccob distribui | 2 - Beneficiario distribui
										preenche_texto($nr_fatura,15).                                   // Nr da Fatura                                      //Brancos
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Vencimento
										fill_full(round($reg_sql->Valor_Liquido*100),15).                // Valor do Ttulo
										'00000 '.                                                         // Agencia Cobranca - Zeros pega pelo CEP e Dgito (preencher branco)
										'03'.                                                            // Espcie do Ttulo - Duplicata MErcantil por Indicao (Obrigatorio DM no pode)
										$aceite.                                                         // A-Aceite | N-no aceite
										limpa_numero(dataf($reg_pr->DH_Criacao));                        // Data de Emisso

							if($valor_juros>=0.01){
								$conteudo1.=
										'1'.                                                             // Cdigo da Mora - 1 Valor Por Dia
										limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Juros de Mora
										fill_full(round($valor_juros*100),15);                           // Valor do Juros

							}else{
								$conteudo1.=
										'0'.                                                             // Cdigo da Mora - 1 Valor Por Dia
										'00000000'.                                                      // Data de Juros de Mora
										fill_full('0',15);                                               // Valor do Juros
							}
							/*
							if  ($valor_descto > 0){  //desconto de antecipao
							$conteudo1.=
							'3'.                                                             // Identificao Tipo de Desconto - 3 - Valor Por Antecipacao Dia Corrido.
							limpa_numero(dataf($reg_pr->DT_Vencto)).                         // Data de Desconto
							fill_full(round($valor_descto*100),15);                          // Valor Desconto Concedido
							}else{
							*/
							$conteudo1.=
										'0'.                                                             // Cdigo Desconto  0 - Sem Desconto
										fill_full('0', 8).                                               // Data de Desconto
										fill_full('0', 15);                                              // Valor Desconto Concedido
										//}

							$protesto="3";
							$dias_protesto="00";
							if(($_SESSION['Dominio'] == "79") || ($_SESSION['Dominio'] == "128")){
								if($reg_pr->Dias_Protesto > 1){
									$protesto="1";
									if($reg_pr->Dias_Protesto > 90){
										$dias_protesto="90";
									}else{
										$dias_protesto=fill_full($reg_pr->Dias_Protesto, 2);
									}
								}
							}
							$conteudo1.= fill_full('0', 15).                                              // Valor IOF
										fill_full('0', 15).                                              // Valor Abatimento
										preenche_texto($nr_fatura,25).                                   // Nr da Fatura
										$protesto.                                                       // Cdigo do Protesto 3 - No Protestar
										$dias_protesto.                                                  // Dias para Protesto
										'0'.                                                             // Cdigo para Baixa/Devoluo (Preencher com zero)
										'   '.                                                           // Dias para Baixa Devoluo (preencher em branco)
										'09'.                                                            // Cdigo da Moeda
										fill_full('0', 10).                                              // Nr do Contr. de Op. de Crdito
										' '.                                                             // Brancos
										$fim_linha;
							$sequencia++;
							$conteudo1.= '756'.                      // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'Q'.                         // Operao - Q
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento | 1-Entrada de titulos
										fill_full($tipo_sacado,1).                   // Tipo Inscrio do Cliente
										fill_full(limpa_numero($reg_sacado[0]),15).  // CGC/CPF Cliente
										preenche_texto(formata_texto_limpo($reg_sacado[1]),40).           // Nome Cliente
										preenche_texto(formata_texto_limpo($endereco_log),40).            // Endereco do Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[6]),15).         // Bairro Cliente
										fill_full(limpa_numero($reg_endereco[5]),8). // CEP Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[3]),15).         // Cidade Cliente
										preenche_texto(formata_texto_limpo($reg_endereco[4]),2).         // Estado Cliente
										'0'.                         // Tipo Incrio Avalista
										fill_full('0', 15).          // CPF Avalista
										preenche_texto(' ', 40).     // Nome Avalista
										'000'.                       // Banco Cobranca
										preenche_texto(' ', 20).     // Nosso Nmero no Banco Cobranca
										preenche_texto(' ', 8).      // Brancos
										$fim_linha;
							$sequencia++;
							if($valor_multa>0.001){
									$cod_multa = '0';
								if ($valor_multa>0.001){
									$cod_multa = '1';
								}
								$conteudo1.=
										'756'.                       // Banco
										'0001'.                      // Lote
										'3'.                         // Id. de Detalhe
										fill_full($sequencia, 5).    // Seq no Lote
										'R'.                         // Operao - R - Remessa
										' '.                         // Branco
										'01'.                        // Cdigo de Movimento
										fill_full('0', 24).          // Desconto 2
										fill_full('0', 24).          // Desconto 3
										$cod_multa.                  // Cod Multa
										limpa_numero(dataf($reg_pr->DT_Vencto)). //Data base da multa
										fill_full(round($valor_multa*100),15).   //Valor Multa
										preenche_texto(' ', 10).     // inf Banco Sacado
										preenche_texto(' ', 40).     // Mensagem 3
										preenche_texto(' ', 40).     // Mensagem 4
										preenche_texto(' ', 20).     // Mensagem 4
										fill_full('0', 8).           //Cod Ocorrencia Pagador
										fill_full('0', 8).           //Dados debito | Banco/Agencia
										' '.                         //DV agencia Debito
										fill_full('0', 12).          //Dados debito | CONTA
										' '.                         //DV Conta
										' '.                         //DV agencia/conta Debito
										'0'.                         //Aviso Debito Automatico (Preencher com zero)
										preenche_texto(' ', 9).     // Brancos
										$fim_linha;
								$sequencia++;
							}//fim multa
							$arquivo_montado.= $conteudo1;
						}//fim com registro
					}//fim do looping
					//$qtd_boletos = $sequencia-1;
					$rodape =          	'756'.                       // Banco
										'0001'.                      // Lote
										'5'.                         // Id. de Detalhe
										preenche_texto(' ', 9).      // Brancos
										fill_full($sequencia+1, 6).  // Qtd registros no Lote
										fill_full($qtd_boletos, 6).          // Qtd de boletos
										fill_full(round($valor_boletos*100), 17). // Valor total cobrana simples
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										fill_full('0', 06).          // Somente Arquivo de Retorno
										fill_full('0', 17).          // Somente Arquivo de Retorno
										preenche_texto(' ', 8).      // Brancos
										preenche_texto(' ', 117).    // Brancos
										$fim_linha;

										$rodape.=          '756'.                       // Banco
										'9999'.                      // Lote
										'9'.                         // Id. de Trailer do Arquivo
										preenche_texto(' ', 9).      // Branco
										fill_full('1', 6).           // Lotes do Arquivo
										fill_full(($sequencia+3), 6).// Qtd de Registros do Lote
										fill_full('0', 6).           // Zeros
										preenche_texto(' ', 205);    // Brancos
					$arquivo_montado.= $rodape;
					$sequencia++;
				}
			}
			if(!($tem_envio)){
				$retorno['lote'] = 0;
				$arquivo_montado = '';
			}
		}else{
			$retorno['remessa'] = -1;
			$retorno['conta'] = -1;
			$retorno['lote'] = -1;
		}
		consulta_limpa($res_sql);
		consulta_limpa($res_sql1);
		//echo $arquivo_montado;
		$retorno['arquivo'] = $arquivo_montado;
		return $retorno;
	}

	//funcao nao usada
	function cria_txt_boleto($arquivo_montado, $pasta){
		$path = "../../../arquivos_clientes/".$_SESSION['Dominio']."/boletos/".$_SESSION['Empresa_Codigo']."/".$pasta;
		rmkdir($path);
		//       $dia = substr(data_atual('data'),0,2);
		//       $mes = substr(data_atual('data'),3,2);
		$data = data_atual('date');
		$dia = $data[8].$data[9];
		$mes = $data[5].$data[6];
		if($mes<='09'){
			$mes = $data[6];
		}else{
			if($mes=='10'){
				$mes = 'O';
			}else if($mes=='11'){
				$mes = 'N';
			}else if($mes=='12'){
				$mes = 'D';
			}
		}
		$cons_pessoa_conta = 'select Numero_Conta '.
							' from pessoa_conta '.
							' where Dominio = "'.$_SESSION['Dominio'].'" '.
							' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'" '.
							' and Banco = "748"'.
							' order by Seq_Conta limit 1';
		$res_pessoa_conta = consulta_sql($cons_pessoa_conta);
		$reg_pessoa_conta = consulta_ler_linha($res_pessoa_conta);
		consulta_limpa($res_pessoa_conta);
		$nome_arquivo = fill_full(substr($reg_pessoa_conta[0],0,5),5).$mes.$dia.'.CRM';
		if(file_exists($path.'/'.$nome_arquivo)){
			//unlink($path.'/'.$nome_arquivo);
			$nm_arq = explode('.',$nome_arquivo);
			$ok = true;
			for($a=2;$a<10;$a++){
				if($ok){
					if(!(file_exists($path.'/'.$nm_arq.'.RM'.$a))){
						$Handle = fopen($path.'/'.$nm_arq.'.RM'.$a, 'w');
						$ok = false;
					}
				}
			}
			if($ok){
				if(!(file_exists($path.'/'.$nm_arq.'.RM0'))){
					$Handle = fopen($path.'/'.$nm_arq.'.RM0', 'w');
				}
			}
		}else{
			$Handle = fopen($path.'/'.$nome_arquivo, 'w');
		}
		fwrite($Handle, $arquivo_montado['arquivo']);
		fclose($Handle);
	}
	require_once(dirname(__FILE__).'/financeiro_boletos_funcoes.php');
	require_once(dirname(__FILE__).'/financeiro_boletos_impressao.php');

?>