<?
	//funes do bb
	function financeiro_gera_boleto_bb_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		for ($i = strlen($num); $i > 0; $i--) {
			$numeros[$i] = substr($num,$i-1,1);
			$parcial10[$i] = $numeros[$i] * $fator;
			$numtotal10 .= $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			}else {
				$fator = 2;
			}
		}
		$soma = 0;
		for ($i = strlen($numtotal10); $i > 0; $i--) {
			$numeros[$i] = substr($numtotal10,$i-1,1);
			$soma += $numeros[$i];
		}
		$resto = $soma % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}
	
	function financeiro_gera_boleto_bb_modulo_11($num, $base=9, $r=0) {
		$soma = 0;
		$fator = 2;
		for ($i = strlen($num); $i > 0; $i--) {
			$numeros[$i] = substr($num,$i-1,1);
			$parcial[$i] = $numeros[$i] * $fator;
			$soma += $parcial[$i];
			if ($fator == $base) {
				$fator = 1;
			}
			$fator++;
		}
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			//corrigido
			if ($digito == 10) {
				$digito = "X";
			}
			if (strlen($num) == "43") {
				//ento estamos checando a linha digitvel
				if ($digito == "0" or $digito == "X" or $digito > 9) {
					$digito = 1;
				}
			}
			return $digito;
		}elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}

	function financeiro_gera_boleto_bb_fator_vencimento($data) {
		$data_a = explode("/",$data);
		$ano = $data_a[2];
		$mes = $data_a[1];
		$dia = $data_a[0];


		$max = data2nr('22/02/2025');
		$ven = data2nr($data);
		if ($ven>=$max){
			return abs($ven - $max)+1000;
		}else{
			return(abs((financeiro_gera_boleto_bb_dateToDays("1997","10","07")) - (financeiro_gera_boleto_bb_dateToDays($ano, $mes, $dia))));
		}		
	}

	function financeiro_gera_boleto_bb_dateToDays($year,$month,$day) {
		$century = substr($year, 0, 2);
		$year = substr($year, 2, 2);
		if ($month > 2) {
			$month -= 3;
		}else{
			$month += 9;
			if ($year) {
				$year--;
			}else{
				$year = 99;
				$century --;
			}
		}
		return ( floor((  146097 * $century)    /  4 ) +
		floor(( 1461 * $year)        /  4 ) +
		floor(( 153 * $month +  2) /  5 ) +
		$day +  1721119);
	}
	//fim funes BB


	//Funes HSBC
	function financeiro_gera_boleto_hsbc_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_hsbc_modulo_11($num, $base=9, $r=0)  {
		/**
		*   Autor:
		*           Pablo Costa <pablo@users.sourceforge.net>
		*
		*   Funo:
		*    Calculo do Modulo 11 para geracao do digito verificador
		*    de boletos bancarios conforme documentos obtidos
		*    da Febraban - www.febraban.org.br
		*
		*   Entrada:
		*     $num: string numrica para a qual se deseja calcularo digito verificador;
		*     $base: valor maximo de multiplicacao [2-$base]
		*     $r: quando especificado um devolve somente o resto
		*
		*   Sada:
		*     Retorna o Digito verificador.
		*
		*   Observaes:
		*     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		*     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		*/
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		}elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}

	function financeiro_gera_boleto_caixa_modulo_11($num, $base=9, $r=0) {
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		if ($r == 0) {
			$digito = $soma % 11;
			$digito = 11 - $digito;
			if($digito > 9) $digito = 0;
				return $digito;
		}elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}

	function financeiro_gera_boleto_hsbc_modulo_11_invertido($num){ // Calculo de Modulo 11 "Invertido" (com pesos de 9 a 2  e no de 2 a 9)
		$ftini = 2;
		$ftfim = 9;
		$fator = $ftfim;
		$soma = 0;
		for ($i = strlen($num); $i > 0; $i--) {
			$soma += substr($num,$i-1,1) * $fator;
			if(--$fator < $ftini) $fator = $ftfim;
		}
		$digito = $soma % 11;
		if($digito > 9) $digito = 0;
			return $digito;
	}

	function financeiro_gera_boleto_hsbc_dataJuliano($data) {
		$dia = (int)substr($data,0,2);
		$mes = (int)substr($data,3,2);
		$ano = (int)substr($data,6,4);
		$dataf = strtotime("$ano/$mes/$dia");
		$datai = strtotime(($ano-1).'/12/31');
		$dias  = (int)(($dataf - $datai)/(60*60*24));
		return str_pad($dias,3,'0',STR_PAD_LEFT).substr($data,9,4);
	}

	function financeiro_gera_boleto_hsbc_digitoVerificador_nossonumero($numero) {
		$resto2 = financeiro_gera_boleto_hsbc_modulo_11($numero, 9, 1);
		$digito = 11 - $resto2;
		if ($digito == 10 || $digito == 11) {
			$dv = 0;
		}else{
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_hsbc_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_hsbc_modulo_11($numero, 9, 1);
		if ($resto2 == 0 || $resto2 == 1 || $resto2 == 10) {
			$dv = 1;
		}else{
			$dv = 11 - $resto2;
		}
		return $dv;
	}
	
	function financeiro_gera_boleto_caixa_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_caixa_modulo_11($numero, 9, 1);
		if ($resto2 == 0 || $resto2 == 1) {
			$dv = 1;
		}else{
			$dv = 11 - $resto2;
		}
		return $dv;
	}

	function financeiro_gera_boleto_hsbc_geraNossoNumero($ndoc,$cedente,$venc,$tipoid) {
		$digitos = financeiro_gera_boleto_hsbc_modulo_11_invertido($ndoc).$tipoid;
		$ndoc = $ndoc.$digitos;
		$venc = substr($venc,0,2).substr($venc,3,2).substr($venc,8,2);
		$res = $ndoc + $cedente + $venc;
		return $digitos . financeiro_gera_boleto_hsbc_modulo_11_invertido($res);
	}	
	//fim fues hsbc

	//funes bradesco
	function financeiro_gera_boleto_bradesco_digitoVerificador_nossonumero($numero) {
		$resto2 = financeiro_gera_boleto_bradesco_modulo_11($numero, 7, 1);
		$digito = 11 - $resto2;
		if($digito<0.01){
			$digito=0;
		}
		if ($digito == 10){
			$dv = "P";
		}else if($resto2==0){
			$dv = 0;
		}else{
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_bradesco_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_bradesco_modulo_11($num, $base=7, $r=0)  {
		/**
		*   Autor:
		*           Pablo Costa <pablo@users.sourceforge.net>
		*
		*   Funo:
		*    Calculo do Modulo 11 para geracao do digito verificador
		*    de boletos bancarios conforme documentos obtidos
		*    da Febraban - www.febraban.org.br
		*
		*   Entrada:
		*     $num: string numrica para a qual se deseja calcularo digito verificador;
		*     $base: valor maximo de multiplicacao [2-$base]
		*     $r: quando especificado um devolve somente o resto
		*
		*   Sada:
		*     Retorna o Digito verificador.
		*
		*   Observaes:
		*     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		*     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		*/
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		} elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}

	function financeiro_gera_boleto_bradesco_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_bradesco_modulo_11($numero, 9, 1);
		if ($resto2 == 0 || $resto2 == 1 || $resto2 == 10) {
			$dv = 1;
		}else{
			$dv = 11 - $resto2;
		}
		return $dv;
	}
	//fim funes bradesco

	//funes itau
	function financeiro_gera_boleto_itau_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_itau_modulo_11($numero, 9, 1);
		$digito = 11 - $resto2;
		if ($digito == 0 || $digito == 1 || $digito == 10  || $digito == 11) {
			$dv = 1;
		} else {
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_itau_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--){
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_itau_modulo_11($num, $base=9, $r=0)  {
		/**
		*   Autor:
		*           Pablo Costa <pablo@users.sourceforge.net>
		*
		*   Funo:
		*    Calculo do Modulo 11 para geracao do digito verificador
		*    de boletos bancarios conforme documentos obtidos
		*    da Febraban - www.febraban.org.br
		*
		*   Entrada:
		*     $num: string numrica para a qual se deseja calcularo digito verificador;
		*     $base: valor maximo de multiplicacao [2-$base]
		*     $r: quando especificado um devolve somente o resto
		*
		*   Sada:
		*     Retorna o Digito verificador.
		*
		*   Observaes:
		*     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		*     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		*/
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		}else if ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}
	//fim funes itau

	//funes sicredi
	function financeiro_gera_boleto_sicredi_digitoVerificador_nossonumero($numero) {
		$resto2 = financeiro_gera_boleto_sicredi_modulo_11($numero, 9, 1);
		// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
		$digito = 11 - $resto2;
		if ($digito > 9 ) {
			$dv = 0;
		}else{
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_sicredi_digitoVerificador_campolivre($numero) {
		$resto2 = financeiro_gera_boleto_sicredi_modulo_11($numero, 9, 1);
		// esta rotina sofreu algumas alteraes para ajustar no layout do SICREDI
		if ($resto2 <=1){
			$dv = 0;
		}else{
			$dv = 11 - $resto2;
		}
		return $dv;
	}

	function financeiro_gera_boleto_sicredi_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_sicredi_modulo_11($numero, 9, 1);
		// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
		$digito = 11 - $resto2;
		if ($digito <= 1 || $digito >= 10 ) {
			$dv = 1;
		} else {
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_sicredi_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_sicredi_modulo_11($num, $base=9, $r=0)  {
		/**
		*   Autor:
		*           Pablo Costa <pablo@users.sourceforge.net>
		*
		*   Funo:
		*    Calculo do Modulo 11 para geracao do digito verificador
		*    de boletos bancarios conforme documentos obtidos
		*    da Febraban - www.febraban.org.br
		*
		*   Entrada:
		*     $num: string numrica para a qual se deseja calcularo digito verificador;
		*     $base: valor maximo de multiplicacao [2-$base]
		*     $r: quando especificado um devolve somente o resto
		*
		*   Sada:
		*     Retorna o Digito verificador.
		*
		*   Observaes:
		*     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		*     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		*/
		//        echo '
		//inicio
		//$num'.$num;
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		//        echo 'Soma:'.$soma;
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			return $digito;
		} elseif ($r == 1){
			// esta rotina sofrer algumas alteraes para ajustar no layout do SICREDI
			$r_div = (int)($soma/11);
			//            echo '$r_div'.$r_div;
			$digito = ($soma - ($r_div * 11));
			//            echo '$digito'.$digito;
			return $digito;
		}
		//echo '
		//fim
		//';
	}
	//fim  funes sicredi

	//funes bancoob
	function financeiro_gera_boleto_bancoob_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		for ($i = strlen($num); $i > 0; $i--) {
			$numeros[$i] = substr($num,$i-1,1);
			$parcial10[$i] = $numeros[$i] * $fator;
			$numtotal10 .= $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			}else {
				$fator = 2;
			}
		}

		$soma = 0;
		for ($i = strlen($numtotal10); $i > 0; $i--) {
			$numeros[$i] = substr($numtotal10,$i-1,1);
			$soma += $numeros[$i];
		}
		$resto = $soma % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	/*
	#################################################
	FUNO DO MDULO 11 RETIRADA DO PHPBOLETO

	MODIFIQUEI ALGUMAS COISAS...

	ESTA FUNO PEGA O DGITO VERIFICADOR:

	NOSSONUMERO
	AGENCIA
	CONTA
	CAMPO 4 DA LINHA DIGITVEL
	#################################################
	*/

	function financeiro_gera_boleto_bancoob_modulo_11($num, $base=9, $r=0) {
		$soma = 0;
		$fator = 2;
		for ($i = strlen($num); $i > 0; $i--) {
			$numeros[$i] = substr($num,$i-1,1);
			$parcial[$i] = $numeros[$i] * $fator;
			$soma += $parcial[$i];
			if ($fator == $base) {
				$fator = 1;
			}
			$fator++;
		}
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			//corrigido
			if ($digito == 10) {
				$digito = "X";
			}
			/*
			alterado por mim, Daniel Schultz

			Vamos explicar:

			O mdulo 11 s gera os digitos verificadores do nossonumero,
			agencia, conta e digito verificador com codigo de barras (aquele que fica sozinho e triste na linha digitvel)
			s que  foi um rolo...pq ele nao podia resultar em 0, e o pessoal do phpboleto se esqueceu disso...

			No BB, os dgitos verificadores podem ser X ou 0 (zero) para agencia, conta e nosso numero,
			mas nunca pode ser X ou 0 (zero) para a linha digitvel, justamente por ser totalmente numrica.

			Quando passamos os dados para a funo, fica assim:

			Agencia = sempre 4 digitos
			Conta = at 8 dgitos
			Nosso nmero = de 1 a 17 digitos

			A unica varivel que passa 17 digitos  a da linha digitada, justamente por ter 43 caracteres

			Entao vamos definir ai embaixo o seguinte...

			se (strlen($num) == 43) { no deixar dar digito X ou 0 }
			*/
			if (strlen($num) == "43") {
				//ento estamos checando a linha digitvel
				if ($digito == "0" or $digito == "X" or $digito > 9) {
					$digito = 1;
				}
			}
			return $digito;
		}elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}
	//fim funes bancoob

	//inicio funcoes cecred
	function financeiro_gera_boleto_cecred_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if($fator == 2) {
				$fator = 1;
			}else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_cecred_modulo_11($num, $base=9, $r=0) {
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = 0;
			}
			return $digito;
		} elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}

	function financeiro_gera_boleto_cecred_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_cecred_modulo_11($numero, 9, 1);
		$digito = 11 - $resto2;
		if($digito == 0 || $digito == 10  || $digito == 11) {
			$dv = 1;
		}else{
			$dv = $digito;
		}
		return $dv;
	}

	//inicio funcoes banrisul
	function financeiro_gera_boleto_banrisul_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			} else {
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		if($numtotal10 < 10){
			$resto = $numtotal10;
		}else{
			$resto = $numtotal10 % 10;
		}
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_banrisul_modulo_11_2($num, $base=9, $r=0){
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		//echo '<BR><BR>Soma: '.$soma;
		/* Calculo do modulo 11 */
		if($soma<11){
			$digito = $soma;
		}else{
			if ($r == 0) {
				//$soma *= 10;
				$digito = $soma % 11;
				//echo '<BR>$digito: '.$digito;               
				$digito = 11 - $digito;
				if ($digito == 0) {
					$digito = 0;
				}
				//echo '<BR>$digito: '.$digito;
			} elseif ($r == 1){
				$r_div = (int)($soma/11);
				//echo '<BR>$r_div: '.$r_div;
				$digito = ($soma - ($r_div * 11));
				if ($digito == 0) {
					$digito = 0;
				}
				//echo '<BR>$digito: '.$digito;               
			}
		}
		return $digito;
	}

	function financeiro_gera_boleto_banrisul_modulo_11($num, $base=9, $r=0){
		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		//echo '<BR><BR>Soma: '.$soma;
		/* Calculo do modulo 11 */
		//echo '<BR>Soma: '.$soma;
		if($soma<11){
			$digito = $soma;
			$digito = 11 - $digito;
		}else{
			if ($r == 0) { //resto
				//$soma *= 10;
				$digito = $soma % 11;
				//echo '<BR>$digito: '.$digito;                                             
				//echo '<BR>$digito: '.$digito;
			} elseif ($r == 1){
				$r_div = (int)($soma/11);
				//echo '<BR>$r_div: '.$r_div;
				$digito = ($soma - ($r_div * 11));
				if ($digito == 0) {
					$digito = 0;
				}
				//echo '<BR>$digito: '.$digito;               
			}
		}
		return $digito;
	}

	function financeiro_gera_boleto_banrisul_modulo_10_11($num, $base=7) {
		$dig10='';
		$dig11='';
		$dig10 = financeiro_gera_boleto_banrisul_modulo_10($num);
		//echo '<BR>Dig10: '.$dig10;
		//if($dig10){
		//echo '<BR>Ir para 11: '.$num.$dig10;
		$dig11 = financeiro_gera_boleto_banrisul_modulo_11($num.$dig10, $base);
		//echo '<BR>Dig11: '.$dig11;
		if($dig11==1){
			if($dig10==9){
				$dig10 = 0;
			}else{
				$dig10++;
			}
			//echo '<BR>Num: '.$num.$dig10;
			$dig11 = financeiro_gera_boleto_banrisul_modulo_11($num.$dig10, $base);
		}
		if($dig11>1){
			$dig11 = 11 - $dig11;
		}
		//echo '<BR>Dig11 2: '.$dig11;
		return $dig10.$dig11;
		//}
	}

	function financeiro_gera_boleto_banrisul_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_banrisul_modulo_11($numero, 9, 1);
		if ($resto2 == 0 || $resto2 == 1 || $resto2 == 10) {
			$dv = 1;
		} else {
			$dv = 11 - $resto2;
		}
		return $dv;
	}

	function financeiro_gera_boleto_banrisul_digitoVerificador_campolivre($numero) {
		$resto2 = financeiro_gera_boleto_banrisul_modulo_11($numero, 9, 1);
		if ($resto2 <=1){
			$dv = 0;
		}else{
			$dv = 11 - $resto2;
		}
		return $dv;
	}
	//fim funcoes banrisul

	//funes sicoob
	function financeiro_gera_boleto_sicoob_digitoVerificador_nossonumero($numero) {        
		/*$resto2 = financeiro_gera_boleto_sicoob_modulo_11($numero, 9, 1);
		$digito = 11 - $resto2;
		if ($digito > 9 ) {
		$dv = 0;
		} else {
		$dv = $digito;
		}
		return $dv;
		*/
		//numero tem que vir formatado como: agencia(4dig) conta(10dig) nossonumero(7dig)
		//       echo $numero;
		$cont=0;
		$calculoDv=0;
		for($num=0;$num<=strlen($numero);$num++){
			$cont++;
			if($cont == 1){
				$constante = 3;
			}
			if($cont == 2){
				$constante = 1;
			}
			if($cont == 3){
				$constante = 9;
			}
			if($cont == 4){
				$constante = 7;
				$cont = 0;
			}
			$calculoDv = $calculoDv + (substr($numero,$num,1) * $constante);
		}

		$resto = $calculoDv % 11;
		if($resto == 0 || $resto == 1){
			$dv = 0;
		}else{
			$dv = 11 - $resto;
		}
		return $dv;
	}

	function financeiro_gera_boleto_sicoob_digitoVerificador_barra($numero) {
		$resto2 = financeiro_gera_boleto_sicoob_modulo_11($numero, 9, 1);
		$digito = 11 - $resto2;
		if ($digito == 0 || $digito == 1 || $digito == 10  || $digito == 11) {
			$dv = 1;
		}else{
			$dv = $digito;
		}
		return $dv;
	}

	function financeiro_gera_boleto_sicoob_modulo_10($num) {
		$numtotal10 = 0;
		$fator = 2;
		// Separacao dos numeros
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo (falor 10)
			// 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita
			$temp = $numeros[$i] * $fator;
			$temp0=0;
			foreach (preg_split('//',$temp,-1,PREG_SPLIT_NO_EMPTY) as $k=>$v){ $temp0+=$v; }
			$parcial10[$i] = $temp0; //$numeros[$i] * $fator;
			// monta sequencia para soma dos digitos no (modulo 10)
			$numtotal10 += $parcial10[$i];
			if ($fator == 2) {
				$fator = 1;
			}else{
				$fator = 2; // intercala fator de multiplicacao (modulo 10)
			}
		}
		// vrias linhas removidas, vide funo original
		// Calculo do modulo 10
		$resto = $numtotal10 % 10;
		$digito = 10 - $resto;
		if ($resto == 0) {
			$digito = 0;
		}
		return $digito;
	}

	function financeiro_gera_boleto_sicoob_modulo_11($num, $base=9, $r=0)  {
		/**
		*   Autor:
		*           Pablo Costa <pablo@users.sourceforge.net>
		*
		*   Funo:
		*    Calculo do Modulo 11 para geracao do digito verificador
		*    de boletos bancarios conforme documentos obtidos
		*    da Febraban - www.febraban.org.br
		*
		*   Entrada:
		*     $num: string numrica para a qual se deseja calcularo digito verificador;
		*     $base: valor maximo de multiplicacao [2-$base]
		*     $r: quando especificado um devolve somente o resto
		*
		*   Sada:
		*     Retorna o Digito verificador.
		*
		*   Observaes:
		*     - Script desenvolvido sem nenhum reaproveitamento de cdigo pr existente.
		*     - Assume-se que a verificao do formato das variveis de entrada  feita antes da execuo deste script.
		*/

		$soma = 0;
		$fator = 2;
		/* Separacao dos numeros */
		for ($i = strlen($num); $i > 0; $i--) {
			// pega cada numero isoladamente
			$numeros[$i] = substr($num,$i-1,1);
			// Efetua multiplicacao do numero pelo falor
			$parcial[$i] = $numeros[$i] * $fator;
			// Soma dos digitos
			$soma += $parcial[$i];
			if ($fator == $base) {
				// restaura fator de multiplicacao para 2
				$fator = 1;
			}
			$fator++;
		}
		/* Calculo do modulo 11 */
		if ($r == 0) {
			$soma *= 10;
			$digito = $soma % 11;
			if ($digito == 10) {
				$digito = "X"; //0
			}
			//[Thiago]
			if (strlen($num) == "43") {
				//ento estamos checando a linha digitvel
				if ($digito == "0" || $digito == "X" || $digito > 9) {
					$digito = 1;
				}
			}
			//[Thiago]            
			return $digito;
		} elseif ($r == 1){
			$resto = $soma % 11;
			return $resto;
		}
	}
	//fim funes sicoob

	function financeiro_boleto_monta_linha_digitavel($linha) {
		// Posio 	Contedo
		// 1 a 3    Nmero do banco
		// 4        Cdigo da Moeda - 9 para Real
		// 5        Digito verificador do Cdigo de Barras
		// 6 a 19   Valor (12 inteiros e 2 decimais)
		// 20 a 44  Campo Livre definido por cada banco

		// 1. Campo - composto pelo cdigo do banco, cdigo da moda, as cinco primeiras posies
		// do campo livre e DV (modulo10) deste campo
		$p1 = substr($linha, 0, 4);
		$p2 = substr($linha, 19, 5);
		$p3 = financeiro_gera_boleto_bb_modulo_10("$p1$p2");
		$p4 = "$p1$p2$p3";
		$p5 = substr($p4, 0, 5);
		$p6 = substr($p4, 5);
		$campo1 = "$p5.$p6";

		// 2. Campo - composto pelas posioes 6 a 15 do campo livre
		// e livre e DV (modulo10) deste campo
		$p1 = substr($linha, 24, 10);
		$p2 = financeiro_gera_boleto_bb_modulo_10($p1);
		$p3 = "$p1$p2";
		$p4 = substr($p3, 0, 5);
		$p5 = substr($p3, 5);
		$campo2 = "$p4.$p5";

		// 3. Campo composto pelas posicoes 16 a 25 do campo livre
		// e livre e DV (modulo10) deste campo
		$p1 = substr($linha, 34, 10);
		$p2 = financeiro_gera_boleto_bb_modulo_10($p1);
		$p3 = "$p1$p2";
		$p4 = substr($p3, 0, 5);
		$p5 = substr($p3, 5);
		$campo3 = "$p4.$p5";

		// 4. Campo - digito verificador do codigo de barras
		$campo4 = substr($linha, 4, 1);

		// 5. Campo composto pelo valor nominal pelo valor nominal do documento, sem
		// indicacao de zeros a esquerda e sem edicao (sem ponto e virgula). Quando se
		// tratar de valor zerado, a representacao deve ser 000 (tres zeros).
		$campo5 = substr($linha, 5, 14);

		return "$campo1 $campo2 $campo3 $campo4 $campo5";
	}


	function financeiro_boleto_monta_linha_digitavel_cod_barra($linha_digitavel) {
		// Posio Contedo
		// 0 a 4
		// 32 a 1
		// 33 a 14
		// 5 a 5
		// 10 a 10
		// 21 a 10
		$p1 = substr($linha_digitavel, 0, 4);
		$p2 = substr($linha_digitavel, 32, 1);
		$p3 = substr($linha_digitavel, 33, 14);
		$p4 = substr($linha_digitavel, 4, 5);
		$p5 = substr($linha_digitavel, 10, 10);
		$p6 = substr($linha_digitavel, 21, 10);
		$resultado = $p1.$p2.$p3.$p4.$p5.$p6;
		return "$resultado";
	}
?>