<?
	function financeiro_gera_carne_nota_pdf(&$pdf,$reg_contas,$reg_nota,$sequencia=1,$rodape=true,$modelo_carne=''){
		$label = label_vendedor_ou_rep_comercial('S');
		if ($reg_nota==0){
			if ($reg_contas->Nr_Nota>0){
				$con_nota = 'select * from nota_fiscal '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Nr_Nota = "'.$reg_contas->Nr_Nota.'"'.
							' and Empresa = "'.$reg_contas->Empresa.'"';
				$res_nota = consulta_sql($con_nota);
				$reg_nota = consulta_ler_objeto($res_nota);
				consulta_limpa($res_nota);
			}
		}
		$tem_meios = false;
		if ($reg_nota==0){
			$con_total_parcela = 'select sum(Valor) from contas_pr '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$reg_contas->Empresa.'"'.
								' and Seq=1'.
								' and TipoEmissao = "'.$reg_contas->TipoEmissao.'"'.
								' and Pessoa = "'.$reg_contas->Pessoa.'"'.
								' and Modelo = "'.$reg_contas->Modelo.'"'.
								' and Serie = "'.$reg_contas->Serie.'"'.
								' and Sub_Serie = "'.$reg_contas->Sub_Serie.'"'.
								' and TipoPR = "R"'.
								' and Nr_Doc = "'.$reg_contas->Nr_Doc.'"';
			$res_total_parcela = consulta_sql($con_total_parcela);
			$reg_total_parcela = consulta_ler_linha($res_total_parcela);
			consulta_limpa($res_total_parcela);
			//consulta empresa
			$con_empresa = 'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_contas->Empresa.'"';
			$res_empresa = consulta_sql($con_empresa);
			$reg_empresa = consulta_ler_objeto($res_empresa);
			consulta_limpa($res_empresa);
			$con_empresa_e = 'select * from pessoa_endereco '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Empresa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Endereco';
			$res_empresa_e = consulta_sql($con_empresa_e);
			$reg_empresa_e = consulta_ler_objeto($res_empresa_e);
			consulta_limpa($res_empresa_e);
			$con_empresa_t = 'select * from pessoa_telefone '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Empresa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Telefone';
			$res_empresa_t = consulta_sql($con_empresa_t);
			$reg_empresa_t = consulta_ler_objeto($res_empresa_t);
			consulta_limpa($res_empresa_t);
			//consulta pessoa
			$con_cliente = 'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_contas->Pessoa.'"';
			$res_cliente = consulta_sql($con_cliente);
			$reg_cliente = consulta_ler_objeto($res_cliente);
			consulta_limpa($res_cliente);
			$con_cliente_e = 'select * from pessoa_endereco '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Pessoa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Endereco';
			$res_cliente_e = consulta_sql($con_cliente_e);
			$reg_cliente_e = consulta_ler_objeto($res_cliente_e);
			consulta_limpa($res_cliente_e);
			$con_cliente_t = 'select * from pessoa_telefone '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_contas->Pessoa.'"'.
							' and Situacao<>"E" '.
							' order by Seq_Telefone';
			$res_cliente_t = consulta_sql($con_cliente_t);
			$reg_cliente_t = consulta_ler_objeto($res_cliente_t);
			consulta_limpa($res_cliente_t);
		}else{
			$con_total_parcela = 'select sum(Valor_Parcela) from nota_fiscal_parcela '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$reg_nota->Empresa.'"'.
								' and Nr_Nota = "'.$reg_nota->Nr_Nota.'"'.
								' and Parcela>0';
			$res_total_parcela = consulta_sql($con_total_parcela);
			$reg_total_parcela = consulta_ler_linha($res_total_parcela);
			consulta_limpa($res_total_parcela);
			$con_total_finaliza = 'select sum(Valor) from nota_fiscal_finaliza '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa = "'.$reg_nota->Empresa.'"'.
									' and Nr_Nota = "'.$reg_nota->Nr_Nota.'"'.
									' and Finaliza <> 4';
			$res_total_finaliza = consulta_sql($con_total_finaliza);
			$reg_total_finaliza = consulta_ler_linha($res_total_finaliza);
			consulta_limpa($res_total_finaliza);
			$tem_meios = ($reg_total_finaliza[0]>0);
		}

		if ($reg_nota==0){
			$empresa = $reg_empresa->Nome_Razao;
		}else{
			$empresa = $reg_nota->Empresa_Razao;
		}
		//consulta empresa
		$con_empresa = 'select * from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_contas->Empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		$base_y = 0;
		//$modelo_carne = BuscaParam('MODELO_CARNE');
		//echo 'S'.$modelo_carne.'-';
		if ($modelo_carne==''){
			$modelo_carne = BuscaParam('MODELO_CARNE');
		}
		//echo $modelo_carne;
		/**
		 * 1 - Detalhado
		 * 2 - Resumido
		 * 3 - Recibo
		 * 4 - Detalhado duas colunas
		 */
		if ($reg_nota==0){
			$cliente = $reg_cliente->Pessoa;
		}else{
			$cliente = $reg_nota->Destinatario;
		}
		$ret = financeiro_gera_carne_frase_limite_credito( $cliente );
		$add_cab = 0;
		//$ret['Frase_Liberado'] = '';
		if ($ret['Frase_Liberado']!=''){
			$add_cab = 11;
		}
		if ($modelo_carne == '1'){
			$tamanho_total = 70;
			$qtd_max = 6;
		}else if ($modelo_carne == '3'){
			$tamanho_total = 65;
			$qtd_max = 12;
		}else{
			$tamanho_total = 4;
			$qtd_max = 12; //cada ano  uma pgina diferente
		}
		while ($sequencia>$qtd_max){
			$sequencia-= $qtd_max;
		}
		if ($sequencia==$qtd_max){
			$rodape = true;
		}
		//echo 'C'.$sequencia.';<BR>';
		if ($sequencia == 1){ //se for primra pagina
			$pdf->AddPage();
			$pdf->SetAutoPageBreak(false,30);
			$pdf->SetFont('Arial','',8);
			
			//cacalho do carne
			if ($modelo_carne=='1'){
				$pdf->SetFont('Arial','',8);
				$pdf->y= (15 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, $empresa, 0,'C');

				$pdf->SetFont('Arial','B',12);
				$pdf->y= (25 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 6, '*** Carn de Pagamento ***', 0,'C');

				$pdf->SetFont('Arial','B',8);
				if ($reg_nota==0){
					$end_empresa = $reg_cliente->Pessoa.' - '.$reg_cliente->Nome_Razao;
					$cliente = $reg_cliente->Pessoa;
				}else{
					$end_empresa = $reg_nota->Destinatario.' - '.$reg_nota->Dest_Razao;
					$cliente = $reg_nota->Destinatario;
				}
				$end_empresa = $pdf->prepara_texto($end_empresa,150);

				$pdf->y= (33 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, $end_empresa, 0,'C');

				$pdf->SetFont('Arial','',8);

				$linha = 33;

				if ($ret['Frase_Liberado']!=''){
					//comeando a impresssao do limite de Credito em 07/02/2024 por @isabel
					$linha+= 7;
					$inicio = 10;
					$largura = 50;
					$borda='0';
					

					//Linha do Limite liberado				
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  $ret['Frase_Liberado'], $borda,'L');
					
					$inicio+=$largura;
					$largura = 35;
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Liberado'], $borda,'L');

					//Linha do Limite Disponivel				
					$linha+=4;
					$inicio = 10;
					$largura = 50;
					$pdf->y= ($linha + ($base_y));
					$pdf->x= $inicio;
					$pdf->MultiCell($largura, 4, $ret['Frase_Disponivel'], $borda,'L');

					$inicio+=$largura;
					$largura = 35;
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Disponivel'], $borda,'L');
				}
				
				$linha+=7;				
				$pdf->y= ($linha+ ($base_y));
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Nr Documento: ', $borda,'L');

				
				$pdf->y= ($linha + ($base_y));
				$pdf->x= 60;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, $reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo, $borda,'L');
				}else{
					$pdf->MultiCell(35, 4, $reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo, $borda,'L');
				}

				$linha+=4;
				$pdf->y= ($linha + ($base_y));
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Total Documento: ', 0,'L');

				$pdf->y= ($linha + ($base_y));
				$pdf->x= 60;
				$pdf->MultiCell(35, 4, 'R$ '.formata_qtd($reg_total_parcela[0],2,true), 0,'L');

				$linha+=4;
				$pdf->y= ($linha + ($base_y));
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Data de Emisso: ', 0,'L');

				$pdf->y= ($linha + ($base_y));
				$pdf->x= 60;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, dataf($reg_contas->DH_Criacao), 0,'L');
				}else{
					$pdf->MultiCell(35, 4, dataf($reg_nota->DH_Emissao), 0,'L');
				}

				//$pdf->y= (52 + ($base_y));
				//$pdf->x= 1;
				//$pdf->MultiCell(95, 4, '', 'B','L');

				$inicio_y = (49 + $add_cab+ ($base_y));
			}else if ($modelo_carne=='3'){

				$con_empresa_e = 'select * from pessoa_endereco '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Empresa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Endereco';
				$res_empresa_e = consulta_sql($con_empresa_e);
				$reg_empresa_e = consulta_ler_objeto($res_empresa_e);
				consulta_limpa($res_empresa_e);
				$con_empresa_t = 'select * from pessoa_telefone '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Empresa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Telefone';
				$res_empresa_t = consulta_sql($con_empresa_t);
				$reg_empresa_t = consulta_ler_objeto($res_empresa_t);
				consulta_limpa($res_empresa_t);
				$endereco_emp =  $reg_empresa_e->Logradouro.', ';
				if ($reg_empresa_e->Numero!=''){
					$endereco_emp.=  $reg_empresa_e->Numero;
				}else{
					$endereco_emp.=  'S/N';
				}

				$pdf->SetFont('Arial','B',8);
				$pdf->y= (1 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, $reg_empresa->Nome_Fantasia, 0,'L');

				$pdf->SetFont('Arial','',8);
				$pdf->y= (1 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(95, 5, $reg_empresa->Nome_Razao, 'L','L');

				$pdf->y= (6 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(95, 5, $endereco_emp, 'L','L');

				$pdf->y= (11 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(95, 5, $reg_empresa_e->CEP.' '.$reg_empresa_e->Nome_Cidade.' - '.$reg_empresa_e->UF , 'L','L');

				$pdf->y= (16 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 5, 'Venda', 'T','L');

				$pdf->y= (16 + ($base_y));
				$pdf->x= 30;
				$pdf->MultiCell(95, 5, 'Valor', 0,'L');

				$pdf->y= (16 + ($base_y));
				$pdf->x= 70;
				$pdf->MultiCell(95, 5, 'Emisso', 0,'L');

				$pdf->y= (16 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(95, 5, $reg_empresa->CPF_CNPJ, 'L','L');

				$pdf->y= (21 + ($base_y));
				$pdf->x= 1;
				if ($reg_nota==0){
					$pdf->MultiCell(30, 5, $reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo, 0,'L');
				}else{
					$pdf->MultiCell(30, 5, $reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo, 0,'L');
				}

				$pdf->y= (21 + ($base_y));
				$pdf->x= 30;
				$pdf->MultiCell(40, 5, 'R$ '.formata_qtd($reg_total_parcela[0],2,true), 0,'L');

				$pdf->y= (21 + ($base_y));
				$pdf->x= 70;
				if ($reg_nota==0){
					$pdf->MultiCell(25, 5, dataf($reg_contas->DH_Criacao), 0,'L');
				}else{
					$pdf->MultiCell(25, 5, dataf($reg_nota->DH_Emissao), 0,'L');
				}
				$pdf->y= (21 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(95, 5, ' ', 'L','L');
				
				if($reg_contas->Vendedor>0){
					$pdf->SetFont('Arial','',8);
					$con_vendedor = 'select Nome_Listas from pessoa '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Pessoa = "'.$reg_contas->Vendedor.'"';
					$res_vendedor = consulta_sql($con_vendedor);
					$reg_vendedor = consulta_ler_linha($res_vendedor);
					consulta_limpa($res_vendedor);
					$con_vendedor2 = 'select Empresa_Representante,Nr_CORE from pessoa_vendedor '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Pessoa = "'.$reg_contas->Vendedor.'"';
					$res_vendedor2 = consulta_sql($con_vendedor2);
					$reg_vendedor2 = consulta_ler_linha($res_vendedor2);
					consulta_limpa($res_vendedor2);

					$end_empresa = $label.': '.$reg_vendedor[0];
					$pdf->x= 1;

					/*if (BuscaParam('VENDEDOR-TIPO')=='2'){
					$end_empresa = 'Rep. Coml. '.$reg_vendedor2[0].' - '.$reg_vendedor[0].' - CORE Nr '.$reg_vendedor2[1];
					}*/

					$end_empresa = empresa_representante($reg_contas->Vendedor,'S');
					$end_empresa = $pdf->prepara_texto($end_empresa,95);

					$pdf->y= (26 + ($base_y));
					$pdf->x= 1;
					$pdf->MultiCell(190, 4, 'Vendedor: '. $end_empresa, 0,'L');
				}

				//consulta pessoa
				$con_cliente = 'select * from pessoa '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Pessoa.'"';
				$res_cliente = consulta_sql($con_cliente);
				$reg_cliente = consulta_ler_objeto($res_cliente);
				consulta_limpa($res_cliente);

				$con_cliente_e = 'select * from pessoa_endereco '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Pessoa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Endereco';
				$res_cliente_e = consulta_sql($con_cliente_e);
				$reg_cliente_e = consulta_ler_objeto($res_cliente_e);
				consulta_limpa($res_cliente_e);

				$con_cliente_t = 'select * from pessoa_telefone '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg_contas->Pessoa.'"'.
								' and Situacao<>"E" '.
								' order by Seq_Telefone';
				$res_cliente_t = consulta_sql($con_cliente_t);
				$reg_cliente_t = consulta_ler_objeto($res_cliente_t);
				consulta_limpa($res_cliente_t);

				$end_empresa = $reg_cliente->Pessoa.' - '.$reg_cliente->Nome_Razao;
				$end_empresa = $pdf->prepara_texto($end_empresa,110);

				$pdf->y= (31 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, 'Sacado: '.$end_empresa, 0,'L');

				$endereco_emp =  $reg_cliente_e->Logradouro.', ';
				if ($reg_cliente_e->Numero!=''){
					$endereco_emp.=  $reg_cliente_e->Numero;
				}else{
					$endereco_emp.=  'S/N';
				}
				if ($reg_cliente_e->Complemento!=''){
					$endereco_emp.=  ' - '.$reg_cliente_e->Complemento;
				}

				$pdf->y= (36 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, 'Endereo: '.$endereco_emp, 0,'L');

				$pdf->y= (41 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, 'Cidade: '.$reg_cliente_e->Nome_Cidade, 0,'L');

				$pdf->y= (41 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(100, 4, 'Estado: '.$reg_cliente_e->UF, 0,'L');

				$pdf->y= (46 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, 'CPF/CNPJ: '.$reg_cliente->CPF_CNPJ, 0,'L');

				$pdf->y= (46 + ($base_y));
				$pdf->x= 100;
				$pdf->MultiCell(100, 4, 'RG: '.$reg_cliente->RG, 0,'L');

				$extenso = extenso($reg_total_parcela[0], true);
				$pdf->y= (51 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, 'Valor Extenso: '.$extenso, 0,'L');


				$pdf->SetFont('Arial','B',8);
				$pdf->y= (61 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 3, 'DECLARAO', 0,'C');

				$texto_declaracao = 'Declaro estar de acordo com as informaes constantes na duplicata firmada nesta data,'.
									' e ter recebido os produtos constantes no cupom fiscal acima mencionado me comprometendo com'.
									' essa Empressa eventual alterao de endereo ou qualquer um dos dados cadastrais no prazo de'.
									' 15(quinze) dias, de qualquer uma das parcelas deste, Outrossim, declaro estar ciente de que'.
									' o atraso, igual, ou superior a 30 (trinta) dias o ttulo acarretar minha inscrio no'.
									' Servio de Proteo ao Crdito - SPC - e registro em cartrio, independente de qualquer comunicao de cobrana.'.
									' Reconheo a exatido desta Duplicata de Venda Mercantil, na importncia acima que pagarei'.
									' conforme parcelas relacionadas abaixo  '.$reg_empresa->Nome_Fantasia.' ou a sua ordem.';

				$pdf->SetFont('Arial','',8);
				$pdf->y= (65 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, $texto_declaracao, 0,'L');

				if ($reg_contas->Observacao!=''){
					$pdf->SetFont('Arial','',8);
					$pdf->y= (90 + ($base_y));
					$pdf->x= 1;
					$pdf->MultiCell(190, 4, $reg_contas->Observacao, 0,'L');
				}

				$pdf->y= (110 + ($base_y));
				$pdf->x= 31;
				$pdf->MultiCell(10, 4, 'Parc.', 'TB','C');

				$pdf->y= (110 + ($base_y));
				$pdf->x= 41;
				$pdf->MultiCell(20, 4, 'Vencto', 'TB','C');

				$pdf->y= (110 + ($base_y));
				$pdf->x= 61;
				$pdf->MultiCell(20, 4, 'Pagto', 'TB','C');

				$pdf->y= (110 + ($base_y));
				$pdf->x= 81;
				$pdf->MultiCell(30, 4, 'Valor', 'TB','R');

				$pdf->y= (110 + ($base_y));
				$pdf->x= 111;
				$pdf->MultiCell(14, 4, 'Situacao', 'TB','L'); //110

				$pdf->y= (200 + ($base_y));
				$pdf->x= 1;
				if ($reg_nota==0){
					$pdf->MultiCell(40, 5, $reg_empresa_e->Nome_Cidade.', '.dataf($reg_contas->DH_Criacao) , 0,'L');
				}else{
					$pdf->MultiCell(40, 5, $reg_empresa_e->Nome_Cidade.', '.dataf($reg_nota->DH_Emissao) , 0,'L');
				}

				$pdf->y= (205 + ($base_y));
				$pdf->x= 40;
				$pdf->MultiCell(150, 5, 'Nome do Cliente por Extenso' , 'T','L');

				$pdf->y= (220 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(60, 5, 'Emitente' , 'T','C');

				$pdf->y= (220 + ($base_y));
				$pdf->x= 65;
				$pdf->MultiCell(60, 5, 'Data do Aceite' , 'T','C');

				$pdf->y= (220 + ($base_y));
				$pdf->x= 130;
				$pdf->MultiCell(60, 5, 'Sacado' , 'T','C');

				$inicio_y = (110 + ($base_y));
			}else if ($modelo_carne=='4'){
				$pdf->SetFont('Arial','',8);

				$pdf->y= (15 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, $empresa, 0,'C');

				$pdf->SetFont('Arial','B',14);
				$pdf->y= (25 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 6, '*** Carn de Pagamento ***', 0,'C');

				$pdf->SetFont('Arial','B',14);
				if ($reg_nota==0){
					$end_empresa = $reg_cliente->Pessoa.' - '.$reg_cliente->Nome_Razao;
					$cliente = $reg_cliente->Pessoa;
				}else{
					$end_empresa = $reg_nota->Destinatario.' - '.$reg_nota->Dest_Razao;
					$cliente = $reg_nota->Destinatario;
				}
				$end_empresa = $pdf->prepara_texto($end_empresa,150);

				$pdf->y= (33 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, $end_empresa, 0,'C');

				$pdf->SetFont('Arial','',8);

				//comeando a impresssao do limite de Credito em 07/02/2024 por @isabel
				$linha = 33;

				if ($ret['Frase_Liberado']!=''){
					//comeando a impresssao do limite de Credito em 07/02/2024 por @isabel
					$linha+= 7;
					$inicio = 70;
					$largura = 40;
					$borda='0';
					

					//Linha do Limite liberado				
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  $ret['Frase_Liberado'], $borda,'L');
					
					$inicio+=$largura;
					$largura = 35;
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Liberado'], $borda,'L');

					//Linha do Limite Disponivel				
					$linha+=4;
					$inicio = 70;
					$largura = 40;
					$pdf->y= ($linha + ($base_y));
					$pdf->x= $inicio;
					$pdf->MultiCell($largura, 4, $ret['Frase_Disponivel'], $borda,'L');

					$inicio+=$largura;
					$largura = 35;
					$pdf->y= ($linha + ($base_y));
					$pdf->x=$inicio;
					$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Disponivel'], $borda,'L');
				}


				$pdf->SetFont('Arial','',8);

				$linha+=7;

				$pdf->y= ($linha + ($base_y));//40
				$pdf->x= 70;
				$pdf->MultiCell(40, 4, 'Nr Documento: ', $borda,'L');

				$pdf->y= ($linha + ($base_y));
				$pdf->x= 110;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, $reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo, $borda,'L');
				}else{
					$pdf->MultiCell(35, 4, $reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo, $borda,'L');
				}

				$linha+=4;
				$pdf->y= ($linha + ($base_y));//44
				$pdf->x= 70;
				$pdf->MultiCell(40, 4, 'Total Documento: ', $borda,'L');

				$pdf->y= ($linha+ ($base_y));//44
				$pdf->x= 110;
				$pdf->MultiCell(35, 4, 'R$ '.formata_qtd($reg_total_parcela[0],2,true), $borda,'L');

				$linha+=4;

				$pdf->y= ($linha + ($base_y));
				$pdf->x= 70;
				$pdf->MultiCell(40, 4, 'Data de Emisso: ', $borda,'L');
				
				$pdf->y= ($linha + ($base_y));//48
				$pdf->x= 110;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, dataf($reg_contas->DH_Criacao), $borda,'L');
				}else{
					$pdf->MultiCell(35, 4, dataf($reg_nota->DH_Emissao), $borda,'L');
				}
				
				$inicio_y = (49 + $add_cab+ ($base_y));
			}else {
				$pdf->SetFont('Arial','',8);
				$pdf->y= (15 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, $empresa, 0,'C');

				$pdf->y= (19 + ($base_y));
				$pdf->x= 1;
				if ($reg_nota==0){
					$end_empresa = $reg_empresa->CPF_CNPJ;
				}else{
					$end_empresa = $reg_nota->Empresa_CNPJ;
				}
				$pdf->MultiCell(95, 4, 'CNPJ N: '. $end_empresa, 0,'C');

				$pdf->y= (23 + ($base_y));
				$pdf->x= 1;
				if ($reg_nota==0){
					$end_empresa = $reg_empresa_t->Numero_Telefone;
				}else{
					$end_empresa = $reg_nota->Empresa_Telefone_Nr;
				}
				$pdf->MultiCell(95, 4, 'Telefone: '.$end_empresa, 0,'C');

				$pdf->SetFont('Arial','B',12);

				$pdf->y= (30 + ($base_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 7, '*** Carn de Pagamento  ***', 0,'C');

				if($reg_contas->Vendedor>0){
					$pdf->SetFont('Arial','',8);

					$con_vendedor = 'select Nome_Listas from pessoa '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Pessoa = "'.$reg_contas->Vendedor.'"';
					$res_vendedor = consulta_sql($con_vendedor);
					$reg_vendedor = consulta_ler_linha($res_vendedor);
					consulta_limpa($res_vendedor);

					$con_vendedor2 = 'select Empresa_Representante,Nr_CORE from pessoa_vendedor '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Pessoa = "'.$reg_contas->Vendedor.'"';
					$res_vendedor2 = consulta_sql($con_vendedor2);
					$reg_vendedor2 = consulta_ler_linha($res_vendedor2);
					consulta_limpa($res_vendedor2);
					
					$end_empresa = $label.': '.$reg_vendedor[0];
					$pdf->x= 1;

					/*if (BuscaParam('VENDEDOR-TIPO')=='2'){
					$end_empresa = 'Rep. Coml. '.$reg_vendedor2[0].' - '.$reg_vendedor[0].' - CORE Nr '.$reg_vendedor2[1];
					}*/

					$end_empresa = empresa_representante($reg_contas->Vendedor,'S');
					$end_empresa = $pdf->prepara_texto($end_empresa,95);
					$pdf->y= (39 + ($base_y));
					$pdf->MultiCell(95, 4, $end_empresa, 0,'C');
				}

				$pdf->SetFont('Arial','B',8);
				if ($reg_nota==0){
					$end_empresa = $reg_cliente->Pessoa.' - '.$reg_cliente->Nome_Razao;
					$cliente = $reg_cliente->Pessoa;
				}else{
					$end_empresa = $reg_nota->Destinatario.' - '.$reg_nota->Dest_Razao;
					$cliente =  $reg_nota->Destinatario ;
				}
				$end_empresa = $pdf->prepara_texto($end_empresa,110);
				$linha=43;

				$pdf->y= ($linha + ($base_y));//43
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, $end_empresa, 0,'C');

				$pdf->SetFont('Arial','',8);
				
				
				//comeando a impresssao do limite de Credito em 07/02/2024 por @isabel				
				$linha+= 4;
				$inicio = 15;
				$largura = 45;
				$borda='0';
				$ret = financeiro_gera_carne_frase_limite_credito( $cliente );

				//Linha do Limite liberado				
				$pdf->y= ($linha + ($base_y));
				$pdf->x=$inicio;
				$pdf->MultiCell($largura, 4,  $ret['Frase_Liberado'], $borda,'L');
				
				$inicio+=$largura;
				$largura = 35;
				$pdf->y= ($linha + ($base_y));
				$pdf->x=$inicio;
				$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Liberado'], $borda,'L');

				//Linha do Limite Disponivel				
				$linha+=4;
				$inicio = 15;
				$largura = 45;
				$pdf->y= ($linha + ($base_y));
				$pdf->x= $inicio;
				$pdf->MultiCell($largura, 4, $ret['Frase_Disponivel'], $borda,'L');

				$inicio+=$largura;
				$largura = 35;
				$pdf->y= ($linha + ($base_y));
				$pdf->x=$inicio;
				$pdf->MultiCell($largura, 4,  'R$ '.$ret['Valor_Disponivel'], $borda,'L');

				$linha+=4;
				$pdf->y= ( $linha  + ($base_y) );//43+4
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Nr Documento: ', $borda,'L');

				$pdf->y= ($linha + ($base_y) ); //43+4
				$pdf->x= 60;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, $reg_contas->Nr_Doc.'/'.$reg_contas->Serie.'-'.$reg_contas->Modelo,$borda,'L');
				}else{
					$pdf->MultiCell(35, 4, $reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo,$borda,'L');
				}

				$linha+=4;

				$pdf->y= ($linha + ($base_y) );//43+8
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Total Documento: ', $borda,'L');

				$pdf->y= ($linha + ($base_y) ); //43+8
				$pdf->x= 60;
				$pdf->MultiCell(35, 4, 'R$ '.formata_qtd($reg_total_parcela[0],2,true), $borda,'L');

				$linha+=4;
				$pdf->y= ( $linha + ($base_y)); //43+12
				$pdf->x= 20;
				$pdf->MultiCell(40, 4, 'Data de Emisso: ', $borda,'L');

				$pdf->y= ( $linha  + ($base_y));//43+12
				$pdf->x= 60;
				if ($reg_nota==0){
					$pdf->MultiCell(35, 4, dataf($reg_contas->DH_Criacao), $borda,'L');
				}else{
					$pdf->MultiCell(35, 4, dataf($reg_nota->DH_Emissao), $borda,'L');
				}

				$linha+=4;
				$pdf->y= ( $linha + ($base_y) );//43+16
				$pdf->x= 1;
				$pdf->MultiCell(10, 4, 'Parc.', 'TB','C');

				$pdf->y= ($linha + ($base_y)); //43+16
				$pdf->x= 11;
				$pdf->MultiCell(20, 4, 'Vencto', 'TB','C');

				$pdf->y= ( $linha + ($base_y) );//43+16
				$pdf->x= 31;
				$pdf->MultiCell(20, 4, 'Pagto', 'TB','C');

				$pdf->y= ( $linha + ($base_y));  //43+16
				$pdf->x= 51;
				$pdf->MultiCell(30, 4, 'Valor', 'TB','R');

				$pdf->y= ( $linha + ($base_y)); //43+16
				$pdf->x= 81;
				$pdf->MultiCell(14, 4, 'Situacao', 'TB','L'); //110

				$inicio_y = ($linha + ($base_y) ); //43+16
			}
		}else{

			if ($modelo_carne == '1'){
				$inicio_y = (49 + $add_cab+ ($base_y));
			}else if ($modelo_carne == '3'){
				$inicio_y = (110 + ($base_y));
			}else if ($modelo_carne == '4'){
				$inicio_y = (49 + $add_cab+ ($base_y));//52
			}else {
				$inicio_y = (24 + ($base_y) + 43);//16+43
			}
		}

		if ($modelo_carne == '1'){
			$inicio_y = $inicio_y + (($sequencia-1)*38);//40
		}else if ($modelo_carne == '4'){
			$linha_parcela = ($sequencia);
			if(($linha_parcela%2)!=0){
				$linha_parcela++;
			}
			$linha_parcela = ($linha_parcela/2)-1;
			$inicio_y = $inicio_y + ($linha_parcela*38);

		}else if ($modelo_carne == '3'){
			$inicio_y = $inicio_y + (($sequencia-1)*4);
		}else {
			$inicio_y = $inicio_y + (($sequencia-1)*4);//4
		}
		$pdf->SetAutoPageBreak(false,30);//false, 30
		$cod_barras = financeiro_gera_carne_monta_barras($reg_contas,$modelo_carne);
		$cod_linhad = financeiro_gera_carne_monta_linha_dig($cod_barras);
		
		if ($modelo_carne == '1'){
			if (($reg_contas->DT_Pagto!='0000-00-00')&&($rodape)&&($tem_meios)){
			}else{
				$pdf->SetFont('Arial','',8);

				$pdf->y= $inicio_y;
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, '', 'B','L');

				$inicio_y+=2;

				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 1;
				$pdf->MultiCell(15, 4, 'Nr '.fill_full($reg_contas->Parcela,3), 0,'C');

				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 16;
				$pdf->MultiCell(40, 4, 'Vencimento: '.dataf($reg_contas->DT_Vencto), 0,'L');

				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 56;
				$pdf->MultiCell(55, 4, 'Valor: R$ '.formata_qtd($reg_contas->Valor,2,true), 0,'L');

				//cdigo de barras
				$pdf->x = 9;
				$pdf->y = (8 + ($inicio_y));
				$pdf->i25(9, (8 + ($inicio_y)), $cod_barras, 0.8, 20);

				$pdf->SetFont('Arial','',8);

				$pdf->y= (28 + ($inicio_y));
				$pdf->x= 3;
				$pdf->MultiCell(95, 4, $cod_linhad, 0,'C');

				if ($reg_contas->DT_Pagto!='0000-00-00'){
					$pdf->y= (32 + ($inicio_y));
					$pdf->x= 1;
					$situacao = '';
					if ($reg_contas->Valor_Pago<$reg_contas->Valor){
						$situacao = 'Parcial ';
					}
					$pdf->MultiCell(95, 4, 'Pago '.$situacao.'em: '.dataf($reg_contas->DT_Pagto), 0,'C');
				}
			}
		}else if ($modelo_carne == '3'){
			$pdf->SetFont('Arial','',8);
			//echo '$inicio_y'.$inicio_y.'Parcela'.$reg_contas->Parcela.'<BR>';

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 31;
			$pdf->MultiCell(10, 4, fill_full($reg_contas->Parcela,3), 0,'C');

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 41;
			$pdf->MultiCell(20, 4, dataf($reg_contas->DT_Vencto), 0,'C');
			$situacao = 'Aberto';
			if ($reg_contas->DT_Pagto!='0000-00-00'){
				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 61;
				$pdf->MultiCell(20, 4, dataf($reg_contas->DT_Pagto), 0,'C');
				$situacao = 'Pago';
				if ($reg_contas->Valor_Pago<$reg_contas->Valor){
					$situacao = 'Parcial';
				}
			}
			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 81;
			$pdf->MultiCell(30, 4, 'R$ '.formata_qtd($reg_contas->Valor,2,true), 0,'R');

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 111;
			$pdf->MultiCell(14, 4, $situacao, 0,'L');

			if ($rodape){
				$inicio_y = 230;

				$pdf->y= (8 + ($inicio_y));
				$pdf->x= 50;
				$pdf->MultiCell(95, 4, ' ', 'T','L');

				$pdf->x = 60;
				$pdf->y = (14 + ($inicio_y));
				$pdf->i25(60, (14 + ($inicio_y)), $cod_barras, 0.8, 12);

				$pdf->SetFont('Arial','',8);

				$pdf->y= (28 + ($inicio_y));
				$pdf->x= 52;
				$pdf->MultiCell(95, 4, $cod_linhad, 0,'C');
			}
		}else if ($modelo_carne == '4'){
			if (($reg_contas->DT_Pagto!='0000-00-00')&&($rodape)&&($tem_meios)){
			}else{
				$pdf->SetFont('Arial','',8);
				$x_base = 0;
				if(($sequencia%2)==0){
					$x_base = 95;
				}
				
				$pdf->y= $inicio_y;
				$pdf->x= 1;
				$pdf->MultiCell(190, 4, '', 'B','L');

				$inicio_y+=2;
				$pdf->SetFont('Arial','',10);
				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 1 + $x_base;
				$pdf->MultiCell(15, 4, 'Nr '.fill_full($reg_contas->Parcela,3), 0,'C');

				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 16 + $x_base;
				$pdf->MultiCell(35, 4, 'Vencto: '.dataf($reg_contas->DT_Vencto), 0,'L');

				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 51 + $x_base;
				$pdf->MultiCell(45, 4, 'Valor: R$ '.formata_qtd($reg_contas->Valor,2,true), 0,'L');

				$pdf->SetFont('Arial','',8);
				//cdigo de barras
				$pdf->x = 9 + $x_base;
				$pdf->y = (8 + ($inicio_y));
				$pdf->i25(9+$x_base, (8 + ($inicio_y)), $cod_barras, 0.8, 20);

				$pdf->SetFont('Arial','',8);

				$pdf->y= (28 + ($inicio_y));
				$pdf->x= 3 + $x_base;
				$pdf->MultiCell(95, 4, $cod_linhad, 0,'C');

				if ($reg_contas->DT_Pagto!='0000-00-00'){
					$pdf->y= (32 + ($inicio_y));
					$pdf->x= 1 + $x_base;

					$situacao = '';
					if ($reg_contas->Valor_Pago<$reg_contas->Valor){
						$situacao = 'Parcial ';
					}
					$pdf->MultiCell(95, 4, 'Pago '.$situacao.'em: '.dataf($reg_contas->DT_Pagto), 0,'C');
				}
			}
		}else{
			$pdf->SetFont('Arial','',8);
			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 1;
			$pdf->MultiCell(10, 4, fill_full($reg_contas->Parcela,3), 0,'C');

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 11;
			$pdf->MultiCell(20, 4, dataf($reg_contas->DT_Vencto), 0,'C');
			$situacao = 'Aberto';
			if ($reg_contas->DT_Pagto!='0000-00-00'){
				$pdf->y= (4 + ($inicio_y));
				$pdf->x= 31;
				$pdf->MultiCell(20, 4, dataf($reg_contas->DT_Pagto), 0,'C');
				$situacao = 'Pago';
				if ($reg_contas->Valor_Pago<$reg_contas->Valor){
					$situacao = 'Parcial';
				}
			}

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 51;
			$pdf->MultiCell(30, 4, 'R$ '.formata_qtd($reg_contas->Valor,2,true), 0,'R');

			$pdf->y= (4 + ($inicio_y));
			$pdf->x= 81;
			$pdf->MultiCell(14, 4, $situacao, 0,'L');

			if ($rodape){
				$inicio_y = $inicio_y + (($qtd_max-1)*4) - (($sequencia-1)*4);
				$pdf->SetFont('Arial','',8);

				$pdf->y= (8 + ($inicio_y));
				$pdf->x= 1;
				$pdf->MultiCell(95, 4, ' ', 'T','L');

				$pdf->x = 9;
				$pdf->y = (14 + ($inicio_y));
				$pdf->i25(9, (14 + ($inicio_y)), $cod_barras, 0.8, 12);

				$pdf->SetFont('Arial','',8);
				$pdf->y= (28 + ($inicio_y));
				$pdf->x= 3;
				$pdf->MultiCell(95, 4, $cod_linhad, 0,'C');
			}
		}
	}

	function financeiro_gera_carne_monta_barras($reg_contas,$modelo_carne='1'){
		$barras = fill_full($reg_contas->Empresa,6).
				fill_full($reg_contas->Pessoa,10).
				fill_full($reg_contas->Nr_Contas,15);
		if ($modelo_carne == '1'){
			$barras.= fill_full($reg_contas->Seq,2);
		}
		return $barras;
	}

	function financeiro_gera_carne_monta_barras_26($reg_contas,$modelo_carne='1'){
		$barras = fill_full($reg_contas->Empresa,6).
					fill_full($reg_contas->Pessoa,8).
					fill_full($reg_contas->Nr_Contas,10);
		if ($modelo_carne == '1'){
			$barras.= fill_full($reg_contas->Seq,2);
		}
		return $barras;
	}

	function financeiro_gera_carne_monta_linha_dig($barras){
		$linha = substr($barras,0,4).' '.
				substr($barras,4,4).' '.
				substr($barras,8,4).' '.
				substr($barras,12,4).' '.
				substr($barras,16,4).' '.
				substr($barras,20,4).' '.
				substr($barras,24,4).' '.
				substr($barras,28,4).' '.
				substr($barras,32,4);
				//$linha = $barras;
		return $linha;
	}

	/**
	 * Funo para descobrir  o limite de credito do cliente e encaminhar para a impressao
	 *
	 * @param [integer] $pessoa
	 * @param [string] $inicio_linha (como deve iniciar a linha )
	 * @param [string] $fim_linha (como deve terminar a linha )
	 * @param [string] $tipo (txt ou pdf )
	 * @return [string] $frase ( linha a ser impressa)
	 * @author Mauricio <mauricio@freeline.inf.br>
	 * @author Isabel <isabel@freeline.inf.br>
	 */
	function financeiro_gera_carne_frase_limite_credito( $pessoa, $inicio_linha='', $fim_linha='', $tipo=''){

		$resposta = array();

		if( ($pessoa!='') && ($pessoa>0)){
			$con_limite = 'SELECT Limite_Credito_Total, Limite_Credito_Utilizado FROM pessoa_cliente '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Pessoa = "'.$pessoa.'"';
			$res_limite = consulta_sql($con_limite);
			$reg_limite = consulta_ler_linha($res_limite);
			consulta_limpa($res_limite);

			$utilizado = busca_limite_credito_utilizado($pessoa);

			if( ($reg_limite[0] - $utilizado) < 0 ){
				$disponivel =0;
			}else{
				$disponivel = $reg_limite[0] - $utilizado;
			}

			$resposta['Liberado'] ='Limite de Crdito Liberado: R$ '.formata_qtd($reg_limite[0],2,true);
			$resposta['Disponivel'] ='Limite de Crdito Disponvel: R$ '.formata_qtd($disponivel,2,true);

			$resposta['Valor_Liberado'] =formata_qtd(($reg_limite[0]),2,true);
			$resposta['Valor_Disponivel'] =formata_qtd(($disponivel),2,true);

			$resposta['Frase_Liberado'] ='Limite de Crdito Liberado: ';
			$resposta['Frase_Disponivel'] ='Limite de Crdito Disponvel: ';



		}
		

		/*if( $tipo=='txt'){
			$resposta.= $inicio_linha.'Limite de Crdito Liberado: R$ '.formata_qtd($reg_limite[0],2,true).$fim_linha;
			$resposta.= $inicio_linha.'Limite de Crdito Disponvel: R$ '.formata_qtd(busca_limite_credito_utilizado($pessoa),2,true).$fim_linha;

		}else{
			$resposta.= 'teste';

		}*/

		

		return $resposta;

	}


?>