<?php
	function unlink2($file, $maxAttempts = 3, $intervalSec = 1){
		$counter = 0;
		while(!@unlink($file) && $counter++ < $maxAttempts){
			sleep($intervalSec);
		}
		if($counter > $maxAttempts){
			return false;
		}
		return true;
	}

	function rename2($actualName, $newName, $maxAttempts = 3, $intervalSec = 1){
		$counter = 0;
		while(!@rename($actualName, $newName) && $counter++ < $maxAttempts){
			sleep($intervalSec);
		}
		if($counter > $maxAttempts){
			return false;
		}
		return true;
	}

	function trunca_numero($number, $decimals) {
		$power = pow(10, $decimals);
		if($number > 0){
			return floor($number * $power) / $power;
		}else{
			return ceil($number * $power) / $power;
		}
	}

	function fill_full($str, $length){
		$key=trim(substr($str,0,$length));
		if ((strlen($key) < $length)){
			$complemento='';
			for ($x=(strlen($key)+1); $x<=$length; $x++)
				$complemento.='0';
			$key=$complemento.$key;
		}
		return $key;
	}
	
	function fill_full2($str, $length){
		$key=trim(substr($str,0,$length));
		if ((strlen($key) < $length)){
			$complemento='';
			for ($x=(strlen($key)+1); $x<=$length; $x++)
				$complemento = '0'.$complemento;
			$key=$key.$complemento;
		}
		return $key;
	}

	function formata_valor($valortxt){
		$semr = str_replace('R','',$valortxt);
		$semsifra = str_replace('$','',$semr);
		$semespaco = str_replace(' ','',$semsifra);
		$semponto = str_replace('.','',$semespaco);
		return str_replace(',','.',$semponto);
	}

	function floordec($zahl,$decimals=2){
		return floor($zahl*pow(10,$decimals))/pow(10,$decimals);
	}

	function floor_dec($number,$precision,$separator="."){
		$numberpart=explode($separator,$number);
		$numberpart[1]=substr_replace($numberpart[1],$separator,$precision,0);
		if($numberpart[0]>=0){
			$numberpart[1]=floor($numberpart[1]);
		}else{
			$numberpart[1]=ceil($numberpart[1]);
		}
		$ceil_number= array($numberpart[0],$numberpart[1]);
		return implode($separator,$ceil_number);
	}
	
	function to_money($num, $aspas = true){
		$sinal_negativo = '';
		if($num < 0){
			$num*= (-1);
			$sinal_negativo = '-';
		}
		$num = str_replace(",", ".", $num);
		if($num == ''){
			$num = '0';
		}
		$num = number_format($num, 2, ",", ".");
		if($aspas){
			return $sinal_negativo.'"R$ '.$num.'"';
		}else{
			return $sinal_negativo.'R$ '.$num;
		}
	}

	function pt2vr($valortxt){
		return str_replace('.',',',$valortxt);
	}
	
	function vr2pt($valortxt){
		return str_replace(',','.',$valortxt);
	}

	function str2nr($str){
		if(trim($str) == ''){
			return 0;
		}
		return $str;
	}

	function nr2str_null($nr){
		if ($nr == 0){
			return '';
		}else {
			return $nr;
		}
	}

	function valor2nr($valor,$decimais=2){
		if (strpos(' '.$valor,'.')==0){
			$inteiro = $valor;
			$decimal = '';
		}else{
			$inteiro = substr($valor,0,(strpos($valor,'.')));
			$decimal = substr($valor,strpos($valor,'.'));
			if (strlen($decimal) > ($decimais+1)){
				$decimal = substr($decimal,0,($decimais+1));
			}
			if ($decimal == '.'.fill_full('0',$decimais)){
				$decimal = '';
			}else{
				$decimal = str_replace('.',',',$decimal);
			}
		}
		return $inteiro.$decimal;
	}

	function formata_qtd($valor,$decimais=2,$fixo=false){
		$neg = '';
		if ($valor!=''){
			if ($valor<0){
				$valor = $valor * (-1);
				$neg = '-';
			}
		}
		if (strpos(' '.$valor,'.')==0){
			$inteiro = $valor;
			if (!($fixo)){
				$decimal = '';
			}else{
				$decimal = ','.fill_full('0',$decimais);
			}
		}else{
			$inteiro = substr($valor,0,(strpos($valor,'.')));
			$decimal = substr($valor,strpos($valor,'.'));
			if (strlen($decimal) > ($decimais+1)){
				$decimal = substr($decimal,0,($decimais+1));
			}
			if ($decimal == '.'.fill_full('0',$decimais)){
				if (!($fixo)){
					$decimal = '';
				}else{
					$decimal = ','.fill_full('0',$decimais);
				}
			}else{
				$decimal = str_replace('.','',$decimal);
				if ($fixo){
					while (strlen($decimal) < $decimais){
						$decimal.='0';
					}
				}
				$decimal = ','.$decimal;
			}
		}
		//echo '<BR>';
		//echo $inteiro;
		//echo '<BR>';
		$inteiro = str_replace('R$','',to_money($inteiro));
		//echo '<BR>';
		$inteiro = str_replace(' ','',$inteiro);
		//echo '<BR>';
		$inteiro = str_replace(',00','',$inteiro);
		//echo '<BR>';
		$inteiro = str_replace('"','',$inteiro);
		//echo '<BR>';
		return $neg.$inteiro.$decimal;
	}

	function formata_qtd2($valor,$decimais=2,$fixo=false){
		$neg = '';
		if ($valor!=''){
			if ($valor<0){
				$valor = $valor * (-1);
				$neg = '-';
			}
		}
		if (strpos(' '.$valor,'.')==0){
			$inteiro = $valor;
			if (!($fixo)){
				$decimal = '';
			}else{
				$decimal = fill_full('0',$decimais);
				for($casa=$decimais;$casa>0;$casa--){
					if ($decimal[$casa-1] == '0'){
						$decimal[$casa-1]='';
					}else{
						$casa = 0;
					}
				}
				if ($decimal!=''){
					$decimal = ','.$decimal;
				}
			}
		}else{
			$inteiro = substr($valor,0,(strpos($valor,'.')));
			$decimal = substr($valor,strpos($valor,'.'));
			if (strlen($decimal) > ($decimais+1)){
				$decimal = substr($decimal,0,($decimais+1));
			}
			if ($decimal == '.'.fill_full('0',$decimais)){
				if (!($fixo)){
					$decimal = '';
				}else{
					$decimal = fill_full('0',$decimais);
				}
			}else{
				$decimal = str_replace('.','',$decimal);
				if ($fixo){
					while (strlen($decimal) < $decimais){
						$decimal.='0';
					}
				}
				$decimal = $decimal;
			}
			//echo 'Dec'.$decimal.'<BR>';
			if ($decimal!=''){
				for($casa=$decimais;$casa>0;$casa--){
					//echo 'Dec'.$casa.' - '.$decimal[$casa-1].'<BR>';
					if ($decimal[$casa-1] == '0'){
						$decimal[$casa-1]='';
					}else{
						$casa = 0;
					}
				}
			}
			if ($decimal!=''){
				$decimal = ','.$decimal;
			}
		}
		$inteiro = str_replace('R$','',to_money($inteiro));
		$inteiro = str_replace(' ','',$inteiro);
		$inteiro = str_replace(',00','',$inteiro);
		$inteiro = str_replace('"','',$inteiro);
		return $neg.$inteiro.$decimal;
	}

	function formata_qtd3($valor,$decimais=2,$fixo=false){
		$neg = '';
		if ($valor!=''){
			if ($valor<0){
				$valor = $valor * (-1);
				$neg = '-';
			}
		}
		if (strpos(' '.$valor,'.')==0){
			$inteiro = $valor;
			if (!($fixo)){
				$decimal = '';
			}else{
				$decimal = fill_full('0',$decimais);
				for($casa=$decimais;$casa>0;$casa--){
					if ($decimal[$casa-1] == '0'){
						$decimal[$casa-1]='';
					}else{
						$casa = 0;
					}
				}
				if ($decimal!=''){
					$decimal = ','.$decimal;
				}
			}
		}else{
			$inteiro = substr($valor,0,(strpos($valor,'.')));
			$decimal = substr($valor,strpos($valor,'.'));
			if (strlen($decimal) > ($decimais+1)){
				$decimal = substr($decimal,0,($decimais+1));
			}
			if ($decimal == '.'.fill_full('0',$decimais)){
				if (!($fixo)){
					$decimal = '';
				}else{
					$decimal = fill_full('0',$decimais);
				}
			}else{
				$decimal = str_replace('.','',$decimal);
				if ($fixo){
					while (strlen($decimal) < $decimais){
						$decimal.='0';
					}
				}
				$decimal = $decimal;
			}
			//echo 'Dec'.$decimal.'<BR>';
			if ($decimal!=''){
				for($casa=$decimais;$casa>0;$casa--){
					//echo 'Dec'.$casa.' - '.$decimal[$casa-1].'<BR>';
					if ($decimal[$casa-1] == '0'){
						$decimal[$casa-1]='';
					}else{
						$casa = 0;
					}
				}
			}
			if ($decimal==''){
				$decimal = '00';
			}
			$decimal = trim($decimal);
			//echo 'Dwecimais:'.$decimal.'<BR>';
			if (strlen($decimal)==1){
				$decimal = $decimal.'0';
			}
			if ($decimal!=''){
				$decimal = ','.$decimal;
			}
		}
		$inteiro = str_replace('R$','',to_money($inteiro));
		$inteiro = str_replace(' ','',$inteiro);
		$inteiro = str_replace(',00','',$inteiro);
		$inteiro = str_replace('"','',$inteiro);
		return $neg.$inteiro.$decimal;
	}

	function formata_qtd6($valor,$decimais=2,$fixo=false){
		return str_replace(',000000',',00',formata_qtd($valor,6,$fixo));
	}


	function preenche_texto($texto,$tamanho){
		if (strlen($texto)>$tamanho){
			return substr($texto,0,$tamanho);
		}else{
			while(strlen($texto)<$tamanho){
				$texto = $texto.' ';
			}
			return $texto;
		}
	}

	function preenche_texto_esquerda($texto,$tamanho){
		if (strlen($texto)>$tamanho){
			return substr($texto,0,$tamanho);
		}else{
			while(strlen($texto)<$tamanho){
				$texto = ' '.$texto;
			}
			return $texto;
		}
	}
	
	function preenche_texto_centro($texto,$tamanho){
		$ant=' ';
		$dep='';
		
		if (strlen($texto)>$tamanho){
			return substr($texto,0,$tamanho);
		}else{
			while(strlen($texto)<$tamanho){
				$texto = $ant.$texto.$dep;
				$tmp = $dep;
				$dep = $ant;
				$ant = $tmp;
			}
			return $texto;
		}
	}

	function arredonda_numero_real($n){
		$inteiro = round($n);
		return $inteiro;
	}

	function arredonda_numero($n){
		if ($n>0.001){
			$tmp = valor2nr($n+0.00000001);
		}else{
			$tmp = valor2nr($n);
		}
		$num = strpos($tmp,',');
		if ($num>0){
			$inteiro = (substr($tmp,0,(strpos($tmp,','))))+1;
		}else{
			$inteiro = $tmp;
		}
		return $inteiro;
	}

	function arredonda_numero_menos($n){
		if ($n>0.001){
			$tmp = valor2nr($n+0.00000001);
		}else{
			$tmp = valor2nr($n);
		}
		$num = strpos($tmp,',');
		if ($num>0){
			$inteiro = (substr($tmp,0,(strpos($tmp,','))));
		}else{
			$inteiro = $tmp;
		}
		return $inteiro;
	}

	function strSemAcentos($string="", $mesma=1){
		//retira carteres epeciais
		$LATIN_UC_CHARS = "`";
		$LATIN_LC_CHARS = "AAAAAAECEEEEIIIIDNOOOOOOUUUUYaaaaaaeceeeeiiiionoooooouuuuy 2  '''";
		$resultado = strtr($string, $LATIN_UC_CHARS, $LATIN_LC_CHARS);
		if($mesma == 0){
			if($resultado==$string){
				$resultado="";
			}
		}
		return $resultado; # sem mudana retorna nada
	}

	function creditos_vl($creditos,$prefixo='R$ '){
		if ($_SESSION['tp_cred']=='M'){
			$resultado = $prefixo.str_replace('R$ ','',str_replace('"','',to_money($creditos/100)));
		}else{
			$resultado = valor2nr($creditos);
		}
		return $resultado;
	}

	function formata_texto($texto,$maiusculas=true){
		if ($maiusculas){
			$LATIN_UC_CHARS = "";
			$LATIN_LC_CHARS = "";
			$texto = strtr($texto, $LATIN_LC_CHARS, $LATIN_UC_CHARS);
			$texto = strtoupper($texto);
		}
		//$texto = str_replace('"','\'',str_replace('\\','-',str_replace('\\\'','\'',$texto)));
		//echo '-'.$texto.'-';
		$texto = str_replace('"',"'",
							//str_replace("\\","\\\\",
							str_replace("\\'","'",
										$texto));
		return $texto;
	}
		
	function formata_texto_limpo($texto,$maiusculas=true){
		$texto = formata_texto2($texto,$maiusculas);
		// $acentos = "".
		//            "";
		// $normal  = "ABCDEFGHIJKLMNOPQRSTUVXWYZ".
		//            "abcdefghijklmnopqrstuvxwyz";
		$LATIN_UC_CHARS = "AAAAAAACEEEEIIIIDNOOOOOOUUUUY".
							"aaaaaaaceeeeiiiidnoooooouuuuy";
		$LATIN_LC_CHARS = "".
							"";
		$texto = strtr($texto, $LATIN_LC_CHARS, $LATIN_UC_CHARS);
		//$texto = strtr($texto, $normal, $acentos);
		return $texto;
	}

	function formata_texto_limpo2($texto,$maiusculas=true){
		$texto = formata_texto3($texto,$maiusculas);
		// $acentos = "".
		//            "";
		// $normal  = "ABCDEFGHIJKLMNOPQRSTUVXWYZ".
		//            "abcdefghijklmnopqrstuvxwyz";
		$LATIN_UC_CHARS = "AAAAAAACEEEEIIIIDNOOOOOOUUUUY".
							"aaaaaaaceeeeiiiidnoooooouuuuy";
		$LATIN_LC_CHARS = "".
							"";
		$texto = strtr($texto, $LATIN_LC_CHARS, $LATIN_UC_CHARS);
		//$texto = strtr($texto, $normal, $acentos);
		return $texto;
	}

	function formata_texto2($texto,$maiusculas=true){
		if ($maiusculas){
			$LATIN_UC_CHARS = "";
			$LATIN_LC_CHARS = "";
			$texto = strtr($texto, $LATIN_LC_CHARS, $LATIN_UC_CHARS);
			$texto = strtoupper($texto);
		}
		//$texto = str_replace('"','\'',str_replace('\\','-',str_replace('\\\'','\'',$texto)));
		//echo '-'.$texto.'-';
		$aceitos = "".
					"".
					"ABCDEFGHIJKLMNOPQRSTUVXWYZ".
					"abcdefghijklmnopqrstuvxwyz".
					"0123456789".
					"'!@#$%&*()-+=<>,.:?/{}[]";
		$texto = trim(str_replace('"',"'",
					  str_replace("\\'","'",
					  str_replace(";",":",
					  $texto)) ) );
		$texto_final = '';
		$letra_antes = '';
		for ($t=0;$t<strlen($texto);$t++){
			$letra = $texto[$t];
			if (($letra!=' ')&& ($letra!='\\')){
				$pos = strpos(' '.$aceitos,$letra);
				if (!($pos > 0)){
					$letra = ' ';
				}
			}
			if (($letra_antes == ' ') &&
				($letra == ' ')){
				$letra = '';
			}
			$texto_final.= $letra;
			$letra_antes = $letra;
		}
		return $texto_final;
	}

	function formata_texto3($texto,$maiusculas=true){
		if ($maiusculas){
			$LATIN_UC_CHARS = "";
			$LATIN_LC_CHARS = "";
			$texto = strtr($texto, $LATIN_LC_CHARS, $LATIN_UC_CHARS);
			$texto = strtoupper($texto);
		}
		//$texto = str_replace('"','\'',str_replace('\\','-',str_replace('\\\'','\'',$texto)));
		//echo '-'.$texto.'-';
		$aceitos = "".
					"".
					"ABCDEFGHIJKLMNOPQRSTUVXWYZ".
					"abcdefghijklmnopqrstuvxwyz".
					"0123456789";
		$texto = trim(str_replace('"',"'",
					  str_replace("\\'","'",
					  str_replace(";",":",
					  $texto)) ) );
		$texto_final = '';
		$letra_antes = '';
		for ($t=0;$t<strlen($texto);$t++){
			$letra = $texto[$t];
			if (($letra!=' ')&& ($letra!='\\')){
				$pos = strpos(' '.$aceitos,$letra);
				if (!($pos > 0)){
					$letra = ' ';
				}
			}
			if (($letra_antes == ' ') &&
				($letra == ' ')){
				$letra = '';
			}
			$texto_final.= $letra;
			$letra_antes = $letra;
		}
		return $texto_final;
	}

	function UpperNome($nome){
		$nome = ucwords(strtolower($nome));
		$nome = str_replace(' Das ', ' das ',$nome);
		$nome = str_replace(' Dos ', ' dos ',$nome);
		$nome = str_replace(' De ', ' de ',$nome);
		$nome = str_replace(' Do ', ' do ',$nome);
		$nome = str_replace(' Da ', ' da ',$nome);
		$nome = str_replace(' A ', ' a ',$nome);
		$nome = str_replace(' O ', ' o ',$nome);
		$nome = str_replace(' E ', ' e ',$nome);
		$nome = str_replace(' Os ', ' os ',$nome);
		$nome = str_replace(' As ', ' as ',$nome);
		$nome = str_replace(' Em ', ' em ',$nome);
		$nome = str_replace(' Na ', ' na ',$nome);
		$nome = str_replace(' No ', ' no ',$nome);
		$nome = str_replace(' Nas ', ' nas ',$nome);
		$nome = str_replace(' Nos ', ' nos ',$nome);
		$nome = str_replace(' At ', ' at ',$nome);
		$nome = str_replace(' Ate ', ' ate ',$nome);
		$nome = str_replace(' Aos ', ' aos ',$nome);
		$nome = str_replace(' Ao ', ' ao ',$nome);
		return $nome;
	}

	function UpperDados($str_ori,$str_maiuscula=true){
		return formata_texto($str_ori,$str_maiuscula);
	}

	function LowerDados($str){
		return (is_utf8($str)) ? mb_strtolower($str, 'UTF-8') : strtolower($str);
	}

	function limpa_numero($valor){
		$resultado = '';
		for ($c=0;$c< strlen($valor);$c++){
			if (is_numeric($valor[$c])){
				$resultado.= $valor[$c];
			}
		}
		return $resultado;
	}

	function limpa_numero2($valor){
		$resultado = '';
		for ($c=0;$c< strlen($valor);$c++){
			if (($valor[$c]==' ')||
				($valor[$c]=='.')||
				($valor[$c]=='-')||
				($valor[$c]=='/')||
				($valor[$c]=='\\')){
				//
			}else{
				$resultado.= $valor[$c];
			}
		}
		return $resultado;
	}

	function mcep($cep2){
		//limpa deixando somente numeros
		$cep = '';
		for ($c=0;$c< strlen($cep2);$c++){
			if (is_numeric($cep2[$c])){
				$cep.= $cep2[$c];
			}
		}
		if (strlen($cep)<=8){
			$cep = fill_full2($cep,8);
		}
		$cep2 = $cep;
		$cep = '';
		for ($c=0;$c<8;$c++){
			if ($c==5){
				$cep.='-';
			}
			$cep.= $cep2[$c];
		}
		return $cep;
	}

	function mncm($ncm2){
		//limpa deixando somente numeros
		$ncm = '';
		for ($c=0;$c< strlen($ncm2);$c++){
			if (is_numeric($ncm2[$c])){
				$ncm.= $ncm2[$c];
			}
		}
		if (strlen($ncm)>4){
			$ncm2 = $ncm;
			$ncm = '';
			for ($c=0;$c<strlen($ncm2);$c++){
				if (($c==4)||($c==6)){
					$ncm.='.';
				}
				$ncm.= $ncm2[$c];
			}
		}
		return $ncm;
	}
		
	function mcest($ncm2){
		//limpa deixando somente numeros
		$ncm = '';
		for ($c=0;$c<strlen($ncm2);$c++){
			if (is_numeric($ncm2[$c])){
				$ncm.= $ncm2[$c];
			}
		}
		if (strlen($ncm)==7){
			$ncm2 = $ncm;
			$ncm = '';
			for ($c=0;$c<strlen($ncm2);$c++){
				if (($c==2)||($c==5)){
					$ncm.='.';
				}
				$ncm.= $ncm2[$c];
			}
		}
		return $ncm;
	}

	function mplaca($placa2){
		//limpa deixando somente numeros
		$placa = '';
		for ($c=0;$c<strlen($placa2);$c++){
			if (($placa2[$c]!='-')&&($placa2[$c]!='')){
				$placa.= $placa2[$c];
			}
		}
		if (strlen($placa)==7){
			$placa2 = $placa;
			$placa = '';
			for ($c=0;$c<7;$c++){
				if ($c==3){
					$placa.='-';
				}
				$placa.= $placa2[$c];
			}
		}else{
			$placa = '';
		}
		return $placa;
	}


	function mcpf($cpf2){
		//limpa deixando somente numeros
		$cpf = '';
		for ($c=0;$c< strlen($cpf2);$c++){
			if (is_numeric($cpf2[$c])){
				$cpf.= $cpf2[$c];
			}
		}
		if (strlen($cpf)<=11){
			$cpf = fill_full($cpf,11);
		}else if (strlen($cpf)<=14){
			$cpf = fill_full($cpf,14);
		}
		$cpf2 = $cpf;
		$cpf = '';
		if (strlen($cpf2)==11){
			for ($c=0;$c<11;$c++){
				if (($c==3)||($c==6)){
					$cpf.='.';
				}
				if ($c==9){
					$cpf.='-';
				}
				$cpf.= $cpf2[$c];
			}
		}else{
			for ($c=0;$c<14;$c++){
				if (($c==2)||($c==5)){
					$cpf.='.';
				}
				if ($c==8){
					$cpf.='/';
				}
				if ($c==12){
					$cpf.='-';
				}
				$cpf.= $cpf2[$c];
			}
		}
		return $cpf;
	}

	function mtelefone($tel){
		$tel = limpa_numero($tel);
		if ((substr($tel,0,3)=='116')||
			(substr($tel,0,3)=='117')||
			(substr($tel,0,3)=='118')||
			(substr($tel,0,3)=='119')||

			(substr($tel,0,3)=='126')||
			(substr($tel,0,3)=='127')||
			(substr($tel,0,3)=='128')||
			(substr($tel,0,3)=='129')||

			(substr($tel,0,3)=='136')||
			(substr($tel,0,3)=='137')||
			(substr($tel,0,3)=='138')||
			(substr($tel,0,3)=='139')||

			(substr($tel,0,3)=='146')||
			(substr($tel,0,3)=='147')||
			(substr($tel,0,3)=='148')||
			(substr($tel,0,3)=='149')||

			(substr($tel,0,3)=='156')||
			(substr($tel,0,3)=='157')||
			(substr($tel,0,3)=='158')||
			(substr($tel,0,3)=='159')||

			(substr($tel,0,3)=='166')||
			(substr($tel,0,3)=='167')||
			(substr($tel,0,3)=='168')||
			(substr($tel,0,3)=='169')||

			(substr($tel,0,3)=='176')||
			(substr($tel,0,3)=='177')||
			(substr($tel,0,3)=='178')||
			(substr($tel,0,3)=='179')||

			(substr($tel,0,3)=='186')||
			(substr($tel,0,3)=='187')||
			(substr($tel,0,3)=='188')||
			(substr($tel,0,3)=='189')||

			(substr($tel,0,3)=='196')||
			(substr($tel,0,3)=='197')||
			(substr($tel,0,3)=='198')||
			(substr($tel,0,3)=='199')||

			(substr($tel,0,3)=='216')||
			(substr($tel,0,3)=='217')||
			(substr($tel,0,3)=='218')||
			(substr($tel,0,3)=='219')||

			(substr($tel,0,3)=='226')||
			(substr($tel,0,3)=='227')||
			(substr($tel,0,3)=='228')||
			(substr($tel,0,3)=='229')||

			(substr($tel,0,3)=='246')||
			(substr($tel,0,3)=='247')||
			(substr($tel,0,3)=='248')||
			(substr($tel,0,3)=='249')||

			(substr($tel,0,3)=='276')||
			(substr($tel,0,3)=='277')||
			(substr($tel,0,3)=='278')||
			(substr($tel,0,3)=='279')||

			(substr($tel,0,3)=='286')||
			(substr($tel,0,3)=='287')||
			(substr($tel,0,3)=='288')||
			(substr($tel,0,3)=='289')

		){
			//(##) #####-####
			$tel2 = $tel;
			$tel = '';
			for ($t=0;$t<11;$t++){
				if ($t==0){
					$tel.='(';
				}
				if ($t==2){
					$tel.=') ';
				}
				if ($t==7){
					$tel.='-';
				}
				if(isset($tel2[$t])){
					$tel.= $tel2[$t];
				}
			}
		}else if (substr($tel,0,1)=='0'){
			$tel = '';
		}else{
			/** Modificado em 31/01/2022 por @isabel  para aceitar telefones celulares com 9 digitos xx 9xxxx-xxxx */
			$tam = strlen( $tel );
			if( $tam == 11){
				//(##) 9####-####
				$tel2 = $tel;
				$tel = '';
				for ($t=0;$t<12;$t++){
					if ($t==0){
						$tel.='(';
					}
					if ($t==2){
						$tel.=') ';
					}
					if ($t==7){
						$tel.='-';
					}
					if(isset($tel2[$t])){
						$tel.= $tel2[$t];
					}
				}

			}else {
				//(##) ####-####
				$tel2 = $tel;
				$tel = '';
				for ($t=0;$t<10;$t++){
					if ($t==0){
						$tel.='(';
					}
					if ($t==2){
						$tel.=') ';
					}
					if ($t==6){
						$tel.='-';
					}
					if(isset($tel2[$t])){
						$tel.= $tel2[$t];
					}
				}
			}
		}
		return $tel;
	}

	function anti_injection_array($array){
		$retorno = array();
		foreach($array as $chave => $valor){
			if(is_array($valor)){
				$retorno[$chave] = $valor;
			}else{

				$valor = str_replace("\\",  '/', $valor  );
				/**Modificado pelo desenvolvedor @mauricio em 03/08/2023 para Dominio 83 permitir digitar '*' no campo Nome_Listas   */
				// remove palavras que contenham sintaxe sql
				$valor =  preg_replace("/( from |select |insert |delete | where |drop table|show tables|#|--|\\\\)/","",$valor);
				$valor = trim($valor);//limpa espaos vazio
				$valor = strip_tags($valor);//tira tags html e php
				$valor = addslashes($valor);//Adiciona barras invertidas a uma string
				$retorno[$chave] = $valor;
			}
		}
		return $retorno;
	}

	function extenso($valor = 0, $maiusculas = false) {
		$singular = array("centavo", "real", "mil", "milho", "bilho", "trilho", "quatrilho");
		$plural = array("centavos", "reais", "mil", "milhes", "bilhes", "trilhes","quatrilhes");
		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos",
					"quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta",
					"sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze",
					"dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "trs", "quatro", "cinco", "seis",
					"sete", "oito", "nove");
		$z = 0;
		$rt = "";
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd &&
			$ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
			if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t];
					if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) &&
						($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
		if(!$maiusculas){
			return($rt ? $rt : "zero");
		}else{
			if ($rt) $rt= str_replace(" E "," e ",ucwords($rt));
				return (($rt) ? ($rt) : "Zero");
		}
	}

	function numero_extensoM($valor = 0, $maiusculas = false) {
		$singular = array("", "xxx", "mil", "milho", "bilho", "trilho", "quatrilho");
		$plural = array("", "xxx", "mil", "milhes", "bilhes", "trilhes","quatrilhes");

		$c = array("", "cem", "duzentos", "trezentos", "quatrocentos",
					"quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta",
					"sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze",
					"dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "um", "dois", "trs", "quatro", "cinco", "seis",
					"sete", "oito", "nove");
		$z = 0;
		$rt = "";
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd &&
			$ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
			if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t];
					if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) &&
						($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
		if(!$maiusculas){
			return($rt ? $rt : "zero");
		}else{
			//if ($rt) $rt=ereg_replace(" E "," e ",ucwords($rt));
			if ($rt) $rt=str_replace(" E "," e ",ucwords($rt));
			return (($rt) ? ($rt) : "Zero");
		}
	}

	function numero_extensoF($valor = 0, $maiusculas = false) {
		$singular = array("", "xxx", "mil", "milho", "bilho", "trilho", "quatrilho");
		$plural = array("", "xxx", "mil", "milhes", "bilhes", "trilhes","quatrilhes");
		$c = array("", "cem", "duzentas", "trezentas", "quatrocentas",
		"quinhentas", "seiscentas", "setecentas", "oitocentas", "novecentas");
		$d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta",
		"sessenta", "setenta", "oitenta", "noventa");
		$d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze",
		"dezesseis", "dezesete", "dezoito", "dezenove");
		$u = array("", "uma", "duas", "trs", "quatro", "cinco", "seis",
		"sete", "oito", "nove");
		$z = 0;
		$rt = "";
		$valor = number_format($valor, 2, ".", ".");
		$inteiro = explode(".", $valor);
		for($i=0;$i<count($inteiro);$i++)
			for($ii=strlen($inteiro[$i]);$ii<3;$ii++)
				$inteiro[$i] = "0".$inteiro[$i];
		$fim = count($inteiro) - ($inteiro[count($inteiro)-1] > 0 ? 1 : 2);
		for ($i=0;$i<count($inteiro);$i++) {
			$valor = $inteiro[$i];
			$rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
			$rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
			$ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";
			$r = $rc.(($rc && ($rd || $ru)) ? " e " : "").$rd.(($rd &&
			$ru) ? " e " : "").$ru;
			$t = count($inteiro)-1-$i;
			$r .= $r ? " ".($valor > 1 ? $plural[$t] : $singular[$t]) : "";
			if ($valor == "000")$z++; elseif ($z > 0) $z--;
				if (($t==1) && ($z>0) && ($inteiro[0] > 0)) $r .= (($z>1) ? " de " : "").$plural[$t];
					if ($r) $rt = $rt . ((($i > 0) && ($i <= $fim) &&
						($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
		}
		if(!$maiusculas){
			return($rt ? $rt : "zero");
		}else{
			//if ($rt) $rt=ereg_replace(" E "," e ",ucwords($rt));
			if ($rt) $rt=str_replace(" E "," e ",ucwords($rt));
			return (($rt) ? ($rt) : "Zero");
		}
	}

	function numero_extenso($valor = 0, $maiusculas = false, $genero='M'){
		if ($genero=='M'){
			$numero_ext = numero_extensoM($valor, $maiusculas);
		}else{
			$numero_ext = numero_extensoF($valor, $maiusculas);
		}
		$numero_ext = str_replace(' de ',' ',trim($numero_ext).' ');
		$numero_ext = str_replace(' De ',' ',trim($numero_ext).' ');
		$numero_ext = str_replace('xxx e ','vrgula ',trim($numero_ext).' ');
		$numero_ext = str_replace('xxx' ,'',trim($numero_ext).' ');
		$numero_ext = trim($numero_ext);
		if ($valor<1){
			$numero_ext= 'zero vrgula '.$numero_ext;
		}
		return $numero_ext;
	}

	function romano($N){
		$N1 = $N;
		$Y = "";
		while ($N/1000 >= 1) {$Y .= "M"; $N = $N-1000;}
		if ($N/900 >= 1) {$Y .= "CM"; $N=$N-900;}
		if ($N/500 >= 1) {$Y .= "D"; $N=$N-500;}
		if ($N/400 >= 1) {$Y .= "CD"; $N=$N-400;}
		while ($N/100 >= 1) {$Y .= "C"; $N = $N-100;}
		if ($N/90 >= 1) {$Y .= "XC"; $N=$N-90;}
		if ($N/50 >= 1) {$Y .= "L"; $N=$N-50;}
		if ($N/40 >= 1) {$Y .= "XL"; $N=$N-40;}
		while ($N/10 >= 1) {$Y .= "X"; $N = $N-10;}
		if ($N/9 >= 1) {$Y .= "IX"; $N=$N-9;}
		if ($N/5 >= 1) {$Y .= "V"; $N=$N-5;}
		if ($N/4 >= 1) {$Y .= "IV"; $N=$N-4;}
		while ($N >= 1) {$Y .= "I"; $N = $N-1;}
		return $Y;
	}

	function valida_ean($vEan){
		$resultado = False;
		$Temp2 = 0;
		$Temp3 = '';
		$Temp2 = '';
		$Digito = '';
		$n_limpo = limpa_numero($vEan);  ///tira letras e pontos que no podem ter
		if ($vEan!=$n_limpo){
			$resultado = False;
		}else{
			if ((strlen($vEan) == 8)  || (strlen($vEan) == 12) ||
				(strlen($vEan) == 13) || (strlen($vEan) == 14)){
				$Temp4 = '31313131313131313';
						//12345678901234567
				$Temp4  = substr($Temp4, (strlen($Temp4)-strlen($vEan)-1),strlen($vEan)-1);
				$Digito = substr($vEan,(strlen($vEan)-1),1);
				$Temp3  = substr($vEan,0,strlen($vEan)-1);
				for ($Temp1=0;$Temp1<strlen($Temp3);$Temp1++){
					$Temp2+= ($Temp3[$Temp1]* $Temp4[$Temp1]);
				}
				while ($Temp2>=10){
					$Temp2 = round($Temp2-10);
				}
				if ($Temp2<=0){
					$Temp2 = 0;
				}
				$Temp2 = round(10 - $Temp2);
				if ($Temp2>=10){
					$Temp2 = 0;
				}
				$resultado = ($Temp2 == $Digito);
			}
		}
		//if ($resultado){
		//   echo '<BR>Deu certo '.$vEan;
		//}else{
		//   echo '<BR>Deu erro '.$vEan.' - '.$Temp2.'-'.$Digito;
		//}
		return $resultado;
	}

	function array_orderby(){
		$args = func_get_args();
		$data = array_shift($args);
		foreach ($args as $n => $field) {
			if (is_string($field)) {
				$tmp = array();
			foreach ($data as $key => $row)
				$tmp[$key] = $row[$field];
				$args[$n] = $tmp;
			}
		}
		$args[] = &$data;
		call_user_func_array('array_multisort', $args);
		return array_pop($args);
	}

	function gera_dig_barras8($codigo){
		$codigo7 = fill_full($codigo,7);
		$soma = 0;
		$factor = 3;
		for ($i = 6; $i>=0; $i--) {
			$soma+= $codigo7[$i] * $factor;
			$factor = 4 - $factor;
		}
		$cc = ((1000 - $soma) % 10);
		return $codigo7.$cc;
	}

	function limpa_zeros($codigo){
		if (strlen($codigo)>1){
			$ok = ($codigo[0]!='0');
		}else{
			$ok = true;
		}
		while(!$ok){
			$codigo = substr($codigo,1, strlen($codigo));
			if (strlen($codigo)>1){
				$ok = ($codigo[0]!='0');
			}else{
				$ok = true;
			}
		}
		return $codigo;
	}
	
	function nome_cartao($nome){
		$nome = strSemAcentos($nome);
		$nome = str_replace(';','',$nome);
		$nome = str_replace(' ','',$nome);
		$nome = str_replace('-','',$nome);
		$nome = str_replace('_','',$nome);
		$nome = str_replace(':','',$nome);
		$nome = str_replace('.','',$nome);
		$nome = str_replace(',','',$nome);
		return $nome;
	}
	
	function hexToBin($hex){
		$string='';
		for ($i=0; $i < strlen($hex)-1; $i+=2){
			$string .= chr((hexdec($hex[$i].$hex[$i+1])));
		}
		return $string;
	}

	if (isset($_REQUEST)){
		$_REQUEST = anti_injection_array($_REQUEST);
	}

?>