<?

function limpa_mascara($valor){
	$resultado = str_replace('-', '', $valor);
	$resultado = str_replace('/', '', $resultado);
	$resultado = str_replace(',', '', $resultado);
	$resultado = str_replace('.', '', $resultado);
	$resultado = str_replace('(', '', $resultado);
	$resultado = str_replace(')', '', $resultado);
	$resultado = str_replace(' ', '', $resultado);
	return $resultado;
}

function ChkIESC($numie){
	$b = 0;
	$i = 0;
	$soma = 0;

	$dig = 0;

	$ie = limpa_mascara($numie);

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	// $i = $soma % 11;
	$i = $soma - (11 * (intval($soma / 11)));
	if ($i <= 1) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEMG($iemg){
	$npos = 0;
	$i = 0;
	$ptotal = 0;
	$psoma = 0;
	$dig1 = '';
	$dig2 = '';
	$ie = '';
	$insc = '';
	$nresto = 0;


	$ie = limpa_mascara($iemg);
	if ($ie == '') {
		return true;
	}
	if (($ie[0] . $ie[1]) == 'PR') {
		return true;
	}
	if (($ie[0] . $ie[1] . $ie[2] . $ie[3] . $ie[4]) == 'ISENT') {
		return true;
	}
	if (strlen($ie) != 13) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$dig1 = $ie[11];
	$dig2 = $ie[12];
	$insc = $ie[0] . $ie[1] . $ie[2] . '0' .
		$ie[3] . $ie[4] . $ie[5] . $ie[6] . $ie[7] . $ie[8] . $ie[9] . $ie[10];

	$npos = 12;
	$i = 1;
	$ptotal = 0;
	while ($npos > 0) {
		$i++;
		$psoma = $insc[$npos - 1] * $i;
		if ($psoma >= 10) {
			$psoma = $psoma - 9;
		}
		$ptotal += $psoma;
		if ($i == 2) {
			$i = 0;
		}
		$npos = $npos - 1;
	}
	//nresto = ptotal % 10;
	$nresto = $ptotal - (10 * (intval($ptotal / 10)));
	if ($nresto == 0) {
		$nresto = 10;
	}
	$nresto = 10 - $nresto;
	if ($nresto != $dig1) {
		return false;
	}
	$npos = 12;
	$i = 1;
	$ptotal = 0;
	while ($npos > 0) {
		$i++;
		if ($i == 12) {
			$i = 2;
		}
		$ptotal += ($ie[$npos - 1] * $i);
		$npos--;
	}
	//nresto = ptotal % 11;
	$nresto = $ptotal - (11 * (intval($ptotal / 11)));
	if (($nresto == 0) || ($nresto == 1)) {
		$nresto = 11;
	}
	$nresto = 11 - $nresto;
	if ($nresto != $dig2) {
		return false;
	}
	return true;
}

function ChkIEAC($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	if (!(strlen($ie) == 13)) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 4;
	$soma = 0;
	for ($i = 0; $i < 11; $i++) {
		$soma += ($ie[$i] * $b);
		$b--;
		if ($b == 1) {
			$b = 9;
		}
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig >= 10) {
		$dig = 0;
	}
	if ($dig != $ie[11]) {
		return false;
	}
	$b = 5;
	$soma = 0;
	for ($i = 0; $i < 12; $i++) {
		$soma += ($ie[$i] * $b);
		$b--;
		if ($b == 1) {
			$b = 9;
		}
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig >= 10) {
		$dig = 0;
	}
	if ($dig != $ie[12]) {
		return false;
	}
	return true;
}

function ChkIEAL($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	if (($ie[0] . $ie[1]) != '24') {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 8; $i++) {
		$soma += ($ie[$i] * $b);
		$b--;
	}
	$soma = $soma * 10;
	//soma2 = soma - (soma%11);
	$soma2 = (11 * (intval($soma / 11)));

	$dig = $soma - $soma2;
	if ($dig > 9) {
		$dig = 0;
	}
	if ($dig == $ie[8]) {
		return true;
	} else {
		return false;
	}
}

function ChkIEAM($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 8; $i++) {
		$soma = $soma + ($ie[$i] * $b);
		$b--;
	}
	if ($soma < 11) {
		$i = 11 - $soma;
	} else {
		//i = soma % 11;
		$i = ($soma - (11 * (intval($soma / 11))));
	}
	if ($i <= 1) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $ie[8]) {
		return true;
	} else {
		return false;
	}
}

function ChkIEAP($ie){
	$p = 0;
	$d = 0;
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$p = 0;
	$d = 0;
	$i = $ie[0] . $ie[1] . $ie[2] . $ie[3] .
		$ie[4] . $ie[5] . $ie[6] . $ie[7];
	if (($i >= 3000001) && ($i <= 3017000)) {
		$p = 5;
		$d = 0;
	} else if (($i >= 3017001) && ($i <= 3019022)) {
		$p = 9;
		$d = 1;
	}
	$b = 9;
	$soma = $p;
	for ($i = 0; $i < 8; $i++) {
		$soma += ($ie[$i] * $b);
		$b--;
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig == 10) {
		$dig = 0;
	} else if ($dig == 11) {
		$dig = $d;
	}

	if ($dig == $ie[8]) {
		return true;
	} else {
		return false;
	}
}

function ChkIEBA($nie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$NumMod = 0;
	$dig = 0;
	$ie = '';
	$nie = limpa_numero($nie);
	if (strlen($nie) == 8) {
		$ie = $nie[0] . $nie[1] . $nie[2] . $nie[3] .
			$nie[4] . $nie[5] . $nie[6] . $nie[7];
		if (!(is_numeric($ie))) {
			return false;
		}
		$b = 7;
		$soma = 0;
		for ($i = 0; $i < 8; $i++) {
			$nro =  $ie[$i];
			if ($i < 6) {
				$soma += ($nro * $b);
				$b--;
			}
		}
		if (($ie[0] == 0) ||
			($ie[0] == 1) ||
			($ie[0] == 2) ||
			($ie[0] == 3) ||
			($ie[0] == 4) ||
			($ie[0] == 5) ||
			($ie[0] == 8)
		) {
			$NumMod = 10;
		} else {
			$NumMod = 11;
		}
		//i = (soma % NumMod);
		$i = ($soma - ($NumMod * (intval($soma / $NumMod))));
		if ($NumMod == 10) {
			if ($i == 0) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		} else {
			if ($i <= 1) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		}
		if ($dig != $nro) {
			return false;
		}
		$b = 8;
		$soma = 0;
		for ($i = 0; $i < 8; $i++) {
			$nro =  $ie[$i];
			if ($i < 6) {
				$soma += ($nro * $b);
				$b--;
			}
		}
		$soma += ($nro * 2);
		//i = soma % NumMod;
		$i = ($soma - ($NumMod * (intval($soma / $NumMod))));
		if ($NumMod == 10) {
			if ($i == 0) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		} else {
			if ($i <= 1) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		}
		if ($dig == $ie[6]) {
			return true;
		} else {
			return false;
		}
	} else if (strlen($nie) == 9) {
		$ie = $nie[0] . $nie[1] . $nie[2] . $nie[3] .
			$nie[4] . $nie[5] . $nie[6] . $nie[7] . $nie[8];
		if (!(is_numeric($ie))) {
			return false;
		}
		$b = 8;
		$soma = 0;
		for ($i = 0; $i < 9; $i++) {
			$nro =  $ie[$i];
			if ($i < 7) {
				$soma += ($nro * $b);
				$b--;
			}
		}

		if (($ie[1] == 0) ||
			($ie[1] == 1) ||
			($ie[1] == 2) ||
			($ie[1] == 3) ||
			($ie[1] == 4) ||
			($ie[1] == 5) ||
			($ie[1] == 8)
		) {
			$NumMod = 10;
		} else {
			$NumMod = 11;
		}
		//i = (soma % NumMod);
		$i = ($soma - ($NumMod * (intval($soma / $NumMod))));
		if ($NumMod == 10) {
			if ($i == 0) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		} else {
			if ($i <= 1) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		}
		if ($dig != $nro) {
			return false;
		}
		$b = 9;
		$soma = 0;
		for ($i = 0; $i < 9; $i++) {
			$nro =  $ie[$i];
			if ($i < 7) {
				$soma += ($nro * $b);
				$b--;
			}
		}
		$soma += ($nro * 2);
		//i = soma % NumMod;
		$i = ($soma - ($NumMod * (intval($soma / $NumMod))));
		if ($NumMod == 10) {
			if ($i == 0) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		} else {
			if ($i <= 1) {
				$dig = 0;
			} else {
				$dig = $NumMod - $i;
			}
		}

		if ($dig == $ie[7]) {
			return true;
		} else {
			return false;
		}
	}
}

function ChkIECE($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$nie = '';

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$nie = $ie;
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro = $nie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig >= 10) {
		$dig = 0;
	}
	if ($dig == $ie[8]) {
		return true;
	} else {
		return false;
	}
}

function ChkIEDF($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$nie = '';
	if (strlen($ie) != 13) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 4;
	$soma = 0;
	for ($i = 0; $i < 12; $i++) {
		$nro = $ie[$i];
		if ($i < 11) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 9;
			}
		}
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig >= 10) {
		$dig = 0;
	}
	if ($dig != $nro) {
		return false;
	}
	$b = 5;
	$soma = 0;
	for ($i = 0; $i < 13; $i++) {
		$nro = $ie[$i];
		if ($i < 12) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 9;
			}
		}
	}
	//dig = 11 - (soma % 11);
	$dig = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($dig >= 10) {
		$dig = 0;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEES($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));
	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEGO($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$n = 0;
	$s = '';
	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$s = $ie[0] . $ie[1];
	if (($s == '10') || ($s == '11') || ($s == '20') || ($s == '29')) {

		//n = (CharToInt(ie)-(CharToInt(ie)%10))/10;

		$n = ($ie - ($ie - (10 * (intval($ie / 10))))) / 10;


		if ($n == 11094402) {
			if (($ie[8] == 0) || ($ie[8] == 1)) {
				return false;
			}
		}

		$b = 9;
		$soma = 0;
		for ($i = 0; $i < 9; $i++) {
			$nro =  $ie[$i];
			if ($i < 8) {
				$soma += ($nro * $b);
				$b--;
			}
		}
		//i = (soma % 11);
		$i = ($soma - (11 * (intval($soma / 11))));

		if (($i == 0) || ($i == 1)) {
			$dig = 0;
		} else {
			$dig = 11 - $i;
		}
		if ($dig == $nro) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

function ChkIEMA($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}

	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEMT($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$nie = '';

	if (strlen($ie) < 9) {
		return false;
	}
	$nie = $ie;
	if (strlen($nie) < 11) {
		while (strlen($nie) < 11) {
			$nie = '0' . $nie;
		}
	}
	if (!(is_numeric($nie))) {
		return false;
	}
	$b = 3;
	$soma = 0;
	for ($i = 0; $i < 11; $i++) {
		$nro = $nie[$i];
		if ($i < 10) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 9;
			}
		}
	}
	//i = (soma % 11);
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEMS($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	if (($ie[0] . $ie[1]) != '28') {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEPA($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	if (($ie[0] . $ie[1]) != '15') {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEPB($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEPR($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$ie =  limpa_mascara($ie);
	if (strlen($ie) != 10) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$b = 3;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 7;
			}
		}
	}
	//i = (soma % 11);
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig != $nro) {
		return false;
	}

	$b = 4;
	$soma = 0;
	for ($i = 0; $i < 10; $i++) {
		$nro =  $ie[$i];
		if ($i < 9) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 7;
			}
		}
	}
	//i = (soma % 11);
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig != $nro) {
		return false;
	} else {
		return true;
	}
}

function ChkIEPE($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 14) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$b = 5;
	$soma = 0;
	for ($i = 0; $i < 14; $i++) {
		$nro =  $ie[$i];
		if ($i < 13) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 0) {
				$b = 9;
			}
		}
	}
	//i = 11 - (soma % 11);
	$i = 11 - ($soma - (11 * (intval($soma / 11))));

	if ($i > 9) {
		$dig = $i - 10;
	} else {
		$dig = $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}


function ChkIEPE2($ie){

	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}

	$b = 8;
	$soma = 0;
	for ($i = 0; $i < 8; $i++) {
		$nro =  $ie[$i];
		if ($i < 7) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = 11 - (soma % 11);
	$i = 11 - ($soma - (11 * (intval($soma / 11))));

	if ($i > 9) {
		$dig = 0;
	} else {
		$dig = $i;
	}
	if ($dig != $nro) {
		return false;
	}

	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = 11 - (soma % 11);
	$i = 11 - ($soma - (11 * (intval($soma / 11))));

	if ($i > 9) {
		$dig = 0;
	} else {
		$dig = $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIEPI($numie){
	$b = 0;
	$i = 0;
	$soma = 0;

	$dig = 0;

	$ie = limpa_mascara($numie);

	if (strlen($ie) != 9) {
		return false;
	}

	if (!is_numeric($ie)) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i <= 1) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIERJ($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	$ie = limpa_mascara($ie);

	if (strlen($ie) != 8) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 2;
	$soma = 0;
	for ($i = 0; $i < 8; $i++) {
		$nro =  $ie[$i];
		if ($i < 7) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 7;
			}
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));
	if ($i <= 1) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIERN($ie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;

	$ie = limpa_mascara($ie);

	if (strlen($ie) != 9) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	$soma = $soma * 10;
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));
	if ($i == 10) {
		$dig = 0;
	} else {
		$dig = $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIERS($numie){
	$b = 0;
	$i = 0;
	$soma = 0;

	$dig = 0;

	$ie = limpa_mascara($numie);

	if (strlen($ie) != 10) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$i = $ie[0] . $ie[1] . $ie[2];
	//if (($i >= 1 )&&($i <= 467)){
	$b = 2;
	$soma = 0;
	for ($i = 0; $i < 10; $i++) {
		$nro =  $ie[$i];
		if ($i < 9) {
			$soma += ($nro * $b);
			$b--;
			if ($b == 1) {
				$b = 9;
			}
		}
	}
	//i = 11 - (soma % 11);
	$i = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($i >= 10) {
		$dig = 0;
	} else {
		$dig = $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
	// }else{
	//    return false;
	//  }
}

function ChkIERO($numie){
	$b = 0;
	$i = 0;
	$soma = 0;

	$dig = 0;

	$ie = limpa_mascara($numie);

	if (strlen($ie) != 9) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 6;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if (($i < 8) && ($i >= 3)) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = 11 - (soma % 11);
	$i = 11 - ($soma - (11 * (intval($soma / 11))));
	if ($i >= 10) {
		$dig = $i - 10;
	} else {
		$dig = $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIERO2($SIE){
	$i = 1;
	$x = 0;
	$y = 6;
	$z = 0;
	$j = 0;
	$s = '';


	$s = limpa_mascara($SIE);
	if (strlen($s) < 14) {
		while (strlen($s) < 14) {
			$s = '0' . $s;
		}
	}
	for ($i = 0; $i < 13; $i++) {
		$x = $s[$i] * $y;
		$z += $x;
		if ($y  > 2) {
			$y--;
		} else {
			$y = 9;
		}
	}
	//x = z % 11;
	$x = ($z - (11 * (intval($z / 11))));

	$y = 11 - $x;
	if ($y > 9) {
		$y = $y - 10;
	}

	if ($y == $s[13]) {
		return true;
	} else {
		return false;
	}
}

function ChkIERR($ie){

	$i = 0;
	$soma = 0;
	$dig = 0;

	if (strlen($ie) != 9) {
		return false;
	}
	if (!(is_numeric($ie))) {
		return false;
	}
	if (($ie[0] . $ie[1]) != '24') {
		return false;
	}
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * ($i + 1));
		}
	}
	//dig = soma % 9;

	$dig = ($soma - (9 * (intval($soma / 9))));

	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIESP($ie){
	$i = 0;
	$soma = 0;
	$dig = 0;
	$s = '';

	if (strlen($ie) == 0) {
		return false;
	}
	$letra = $ie[0];

	if (($letra == 'P') || ($letra == 'p')) {
		if (strlen($ie) < 10) {
			return false;
		}
		$s = limpa_mascara(substr($ie, 1));
		if (strlen($s) != 9) {
			return false;
		}
		if (!(is_numeric($s))) {
			return false;
		}
		$soma = ($s[0] * 1) + ($s[1] * 3) +
			($s[2] * 4) + ($s[3] * 5) +
			($s[4] * 6) + ($s[5] * 7) +
			($s[6] * 8) + ($s[7] * 10);

		//dig = (soma % 11);
		$dig = ($soma - (11 * (intval($soma / 11))));

		if ($dig >= 10) {
			$dig = 0;
		}
		if ($s[8] == $dig) {
			return true;
		} else {
			return false;
		}
	} else {
		$s = limpa_mascara($ie);
		if (strlen($s) != 12) {
			return false;
		}
		if (!(is_numeric($s))) {
			return false;
		}
		$soma = ($s[0] * 1) + ($s[1] * 3) +
			($s[2] * 4) + ($s[3] * 5) +
			($s[4] * 6) + ($s[5] * 7) +
			($s[6] * 8) + ($s[7] * 10);

		//dig = (soma % 11);
		$dig = ($soma - (11 * (intval($soma / 11))));

		if ($dig >= 10) {
			$dig = 0;
		}
		if ($s[8] != $dig) {
			return false;
		}
		$soma = ($s[0] * 3)  + ($s[1] * 2) +
			($s[2] * 10) + ($s[3] * 9) +
			($s[4] * 8)  + ($s[5] * 7) +
			($s[6] * 6)  + ($s[7] * 5) +
			($s[8] * 4)  + ($s[9] * 3) +
			($s[10] * 2);
		//dig = (soma %11);
		$dig = ($soma - (11 * (intval($soma / 11))));

		if ($dig >= 10) {
			$dig = 0;
		}
		if ($s[11] == $dig) {
			return true;
		} else {
			return false;
		}
	}
}

function ChkIESE($numie){
	$b = 0;
	$i = 0;
	$soma = 0;

	$dig = 0;

	$ie = limpa_mascara($numie);

	if (strlen($ie) != 9) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$b = 9;
	$soma = 0;
	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i < 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));

	if ($i <= 1) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		return false;
	}
}

function ChkIETO1($numie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$s = '';
	$ie = limpa_mascara($numie);

	if (strlen($ie) != 11) {
		return false;
	}

	if (!(is_numeric($ie))) {
		return false;
	}
	$s = $ie[2] . $ie[3];
	$b = 9;
	$soma = 0;
	if (($s == '01') || ($s == '02') || ($s == '03') || ($s == '99')) {
		for ($i = 0; $i < 11; $i++) {
			$nro =  $ie[$i];
			if (($i < 10) && ($i != 2) && ($i != 3)) {
				$soma += ($nro * $b);
				$b--;
			}
		}
		//i = soma % 11;
		$i = ($soma - (11 * (intval($soma / 11))));
		if ($i < 2) {
			$dig = 0;
		} else {
			$dig = 11 - $i;
		}
		if ($dig == $nro) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

function ChkIETO2($numie){
	$b = 0;
	$i = 0;
	$soma = 0;
	$dig = 0;
	$s = '';
	$ie = limpa_mascara($numie);

	if (strlen($ie) != 9) {
		echo "tam";
		return false;
	}

	if (!(is_numeric($ie))) {
		echo "num";
		return false;
	}
	$b = 9;
	$soma = 0;

	for ($i = 0; $i < 9; $i++) {
		$nro =  $ie[$i];
		if ($i != 8) {
			$soma += ($nro * $b);
			$b--;
		}
	}
	//echo 's'.$soma.'a';
	//i = soma % 11;
	$i = ($soma - (11 * (intval($soma / 11))));
	if ($i < 2) {
		$dig = 0;
	} else {
		$dig = 11 - $i;
	}
	if ($dig == $nro) {
		return true;
	} else {
		echo "dig" . $dig . "-" . $nro;
		return false;
	}
}

function ChkInscEstadual($ie, $duf){

	if (substr($ie, 0, 2) == 'NC') {
		$ie = substr($ie, 2);
	}

	if ($duf == 'AC') {
		return ChkIEAC($ie);
	} else if ($duf == 'AL') {
		return ChkIEAL($ie);
	} else if ($duf == 'AP') {
		return ChkIEAP($ie);
	} else if ($duf == 'AM') {
		return ChkIEAM($ie);
	} else if ($duf == 'BA') {
		return ChkIEBA($ie);
	} else if ($duf == 'CE') {
		return ChkIECE($ie);
	} else if ($duf == 'DF') {
		return ChkIEDF($ie);
	} else if ($duf == 'ES') {
		return ChkIEES($ie);
	} else if ($duf == 'GO') {
		return ChkIEGO($ie);
	} else if ($duf == 'MA') {
		return ChkIEMA($ie);
	} else if ($duf == 'MG') {
		return ChkIEMG($ie);
	} else if ($duf == 'MT') {
		return ChkIEMT($ie);
	} else if ($duf == 'MS') {
		return ChkIEMS($ie);
	} else if ($duf == 'PA') {
		return ChkIEPA($ie);
	} else if ($duf == 'PB') {
		return ChkIEPB($ie);
	} else if ($duf == 'PR') {
		return ChkIEPR($ie);
	} else if ($duf == 'PE') {
		return ChkIEPE($ie) || ChkIEPE2($ie);
	} else if ($duf == 'PI') {
		return ChkIEPI($ie);
	} else if ($duf == 'RJ') {
		return ChkIERJ($ie);
	} else if ($duf == 'RN') {
		return ChkIERN($ie);
	} else if ($duf == 'RS') {
		return ChkIERS($ie);
	} else if ($duf == 'RO') {
		return (ChkIERO($ie) || ChkIERO2($ie));
	} else if ($duf == 'RR') {
		return ChkIERR($ie);
	} else if ($duf == 'SC') {
		return ChkIESC($ie);
	} else if ($duf == 'SP') {
		return ChkIESP($ie);
	} else if ($duf == 'SE') {
		return ChkIESE($ie);
	} else if ($duf == 'TO') {
		return ChkIETO1($ie) || ChkIETO2($ie);
	} else {
		return true;
	}
}
