<?php

	function CIOT_echo($grupo = "", $mensagem = ""){
		if($grupo == 'titulo'){
			echo '<font size="2" face="Verdana"><b>'.$mensagem.'</b></font><br>';
		}else if($grupo == 'erro'){
			echo '<font size="1" face="Verdana">'.$mensagem.'</font><br>';
		}else if($grupo == 'concluido'){
			if($mensagem == ""){
				$mensagem = "Concludo";
			}
			echo '<font size="1" face="Verdana"> <b> - '.$mensagem.'</b></font><br><br>';
		}else{
			echo '<font size="1" face="Verdana"> - '.$mensagem.'</font><br>';
		}
		flush(); @ob_flush();
		flush(); @ob_flush();
	}
	
	function CIOT_Busca_CaminhoPrint(){
		$ret = 'https://apims.extratta.com.br/Ciot/ServicesFull/Reports/DeclaracaoTransporte/';
		if ($_SESSION['Dominio']==2){
			$ret = 'http://apiho.extratta.com.br:1000/Ciot/ServicesFull/Reports/DeclaracaoTransporte/'; //328001016506/14406
		}
		return $ret;
	}

	function CIOT_Inicializa($empresa){
		$token = BuscaParamEmpresa('CIOT_Extrata_ID',$empresa);
		$host  = 'http://api.extratta.com.br:4000';//host deastivado dem 01/07/2023
		$host  = 'https://api.extratta.com.br:2002';
		$con_empresa =	'select CPF_CNPJ from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$cnpj = limpa_numero($reg_empresa[0]);
		if ($_SESSION['Dominio']==2){
			$cnpj = '05725265000170';//gro de outro homologacao
			$host = 'http://apiho.extratta.com.br:50063';
		}
		$con['token'] = $token;
		$con['host']  = $host;
		$con['cnpj']  = $cnpj;
		return $con;
	}

	function CIOT_Transmite($post,$host,$log=false){
		$headers[] = "Connection: keep-alive";
		$headers[] = "Keep-Alive: 300";

		$header_put = array(
						"Cache-Control: no-cache",
						"Content-Type:application/json"
						);
		$ch = curl_init();
		$postJSON = json_encode($post);
		if ($log){
			CIOT_echo("mensagem", "<b>Host:</b> ".$host."");
			CIOT_echo("mensagem", "<b>Dados:</b> <BR>".str_replace(',',',<BR>',str_replace('[{','[<BR>{',$postJSON)));
		}

		$hostF = 'http://freeline.inf.br/simplesweb/docusign/php7app/Integracao/extratta/extratta_envio.php';
		$postF = array(
			'arquivo' => base64_encode($postJSON),
			'servico' => base64_encode($host),
		);
		
		curl_setopt($ch, CURLOPT_URL, $hostF);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		curl_setopt($ch, CURLOPT_POST,1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postF);
		// curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		// curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		// curl_setopt($ch, CURLOPT_POSTFIELDS, $postJSON);
		// curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		// 				'Content-Type: application/json',
		// 				'Content-Length: ' . strlen($postJSON))
		// 				);

		$pagina = curl_exec($ch);
		$cod_resp = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		if ($log){
			CIOT_echo("mensagem", "<b>Retorno (".$cod_resp."):</b> ".str_replace(',',',<BR>',str_replace('[{','[<BR>{',utf8_decode($pagina)))."");
		}

		$ret['pagina'] = $pagina;
		$ret['cod'] = $cod_resp;

		return $ret;
	}

	function CIOT_ConsultaPedagio($empresa, $nr_manifesto, $operadora,$tp_veiculo,$nr_eixos,$log){
		$retorno['valor'] = 0;
		$retorno['id'] = '';
		$retorno['ok'] = false;

		CIOT_echo("titulo", "Iniciando Consulta ao Valor do Pedgio...");

		$con = CIOT_Inicializa($empresa);
		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$cidades = array();

		$con_rota = 'select Codigo_Cidade from manifesto_carga_rota '.
					' where Dominio    = "'.$_SESSION['Dominio'].'"'.
					' and Empresa      = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"'.
					' order by Seq_Rota';
		$res_rota = consulta_sql($con_rota);
		$nrw_rota = consulta_num_registros($res_rota);
		for ($r=0;$r<$nrw_rota;$r++) {
			$reg_rota = consulta_ler_linha($res_rota);
			$cid['IbgeCidade'] = $reg_rota[0];
			$cidades[$r] = $cid;
		}
		consulta_limpa($res_rota);

		$post['CNPJAplicacao'] = $cnpj;
		$post['Token'] = $token;
		$post['CNPJEmpresa'] = $cnpj;
		$post['TipoVeiculo'] = $tp_veiculo;
		$post['QtdEixos'] = $nr_eixos;
		$post['ExibirDetalhes'] = false;
		//$post['Billing']= "";
		//$post['TipoRota']= 1;
		$post['Localizacoes'] = $cidades;

		$ret = CIOT_Transmite($post,$host.'/Viagem/ConsultarCustoPedagioRota',$log);
		$retd = json_decode($ret['pagina']);

		if ($retd->Status!=1){
			CIOT_echo("erro", "Falha no Envio dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno['valor'] = $retd->CustoTotal;
			$retorno['id']    = $retd->IdentificadorHistorico;
			$retorno['ok']    = true;
			CIOT_echo("mensagem", "Consulta Realizada - Valor: ".to_money($retorno['valor'],false)." - Id: ".$retorno['id']."!");
		}

		if ($retorno['ok']){
			//0: Desabilitado (padro);
			//1: Moedeiro: Carga no carto moedeiro Extratta (Descontinuado pela ANTT);
			//2: Via Fcil (Sem Parar);
			//3: Move Mais;
			//4: Veloe;
			//5: Tag Extratta;
			//6: ConectCar;
			//7: Taggy Edenred.
			$upd_vendas =	'Update manifesto_carga set '.
							' Valor_Pedagio          = "'.$retorno['valor'].'",'.
							' CIOT_Pedagio_Id        = "'.$retorno['id'].'",'.
							' CIOT_Pedagio_Operadora = "'.$operadora.'"'.
							' Where Dominio    = "'.$_SESSION['Dominio'].'"'.
							' and Empresa      = "'.$empresa.'"'.
							' and Nr_Manifesto = "'.$nr_manifesto.'"';
			consulta_sql($upd_vendas);
		}
		return $retorno;
	}

	function CIOT_Envia_Motorista($con,$empresa, $nr_manifesto,$log){
		$retorno = false;

		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);

		$con_motorista ='select * from pessoa_transportador_motorista '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Empresa.'"'.
						' and Seq_Motorista = "'.$reg_carga->Rodo_Motorista.'"';
		$res_motorista = consulta_sql($con_motorista);
		$reg_motorista = consulta_ler_objeto($res_motorista);
		consulta_limpa($res_motorista);

		$con_motoristap =	'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and CPF_CNPJ = "'.$reg_motorista->CPF.'"';
		$res_motoristap = consulta_sql($con_motoristap);
		$reg_motoristap = consulta_ler_objeto($res_motoristap);
		consulta_limpa($res_motoristap);

		CIOT_echo("titulo", "Iniciando Envio dos Dados do Motorista (".$reg_motorista->CPF.")...");

		$con_motoristae =	'select * from pessoa_endereco '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_motoristap->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Endereco';
		$res_motoristae = consulta_sql($con_motoristae);
		$reg_motoristae = consulta_ler_objeto($res_motoristae);
		consulta_limpa($res_motoristae);

		$con_motoristat =	'select * from pessoa_telefone '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_motoristap->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Telefone';
		$res_motoristat = consulta_sql($con_motoristat);
		$reg_motoristat = consulta_ler_objeto($res_motoristat);
		consulta_limpa($res_motoristat);

		$cpf  = limpa_numero($reg_motorista->CPF);
		$nome = $reg_motorista->Nome;
		$rg   = $reg_motorista->RG;
		$rg_o = $reg_motorista->RG_Orgao;
		$cnh  = $reg_motorista->CNH;
		$cnhT = $reg_motorista->CNH_Tipo;
		$cnhD = $reg_motorista->CNH_Validade;
		$cont = $reg_motorista->Tipo_Contrato;
		$sexo = $reg_motoristap->Tipo_Pessoa;
		if ($cont==0){ $cont = 3; }
		if ($cnhT==''){ $cont = 'C'; }
		if ($sexo==''){ $cont = 'M'; }
		if ($sexo=='J'){ $cont = 'M'; }
		if ($rg==''){ $rg = $reg_motoristap->RG; }
		if ($rg_o==''){ $rg_o = $reg_motoristap->RG_Orgao; }
		if ($rg_o==''){ $rg_o = 'SSP-'.$reg_motoristae->UF; }

		$post['CNPJAplicacao']		= $cnpj;
		$post['Token'] 				= $token;
		$post['CPFCNPJUsuario']		= $cpf;
		$post['CNPJEmpresa']		= $cnpj;

		$post['Nome']				= strSemAcentos($nome);
		$post['RG']					= strSemAcentos($rg);
		$post['RGOrgaoExpedidor']	= strSemAcentos($rg_o);
		$post['CPF']				= $cpf;
		$post['Sexo']				= $sexo;

		$post['CNH']				= $cnh;
		$post['CNHCategoria']		= $cnhT;
		$post['ValidadeCNH']		= $cnhD;

		if ($reg_motoristap->Numero_Telefone!=''){$post['Celular'] = limpa_numero($reg_motoristat->Numero_Telefone);}
		$post['TipoContrato']		= $cont;
		if ($reg_motoristap->EMail!=''){		$post['Email']		= strSemAcentos($reg_motoristap->EMail);}

		$post['CEP']				= limpa_numero($reg_motoristae->CEP);
		$post['Endereco']			= strSemAcentos($reg_motoristae->Logradouro);
		if ($reg_motoristap->Complemento!=''){	$post['Complemento']= strSemAcentos($reg_motoristae->Complemento);}
		if ($reg_motoristap->Numero!=''){		$post['Numero']		= strSemAcentos($reg_motoristae->Numero);}
		$post['Bairro']				= strSemAcentos($reg_motoristae->Bairro);
		$post['IBGECidade']			= $reg_motoristae->Codigo_Cidade;
		$post['IBGEEstado']			= substr($reg_motoristae->CEP,0,2);
		$post['BACENPais']			= $reg_motoristae->Codigo_Pais;

		if ($reg_motoristap->RG_Mae!=''){$post['NomeMae'] = strSemAcentos($reg_motoristap->RG_Mae);}
		if ($reg_motoristap->RG_Pai!=''){$post['NomePai'] = strSemAcentos($reg_motoristap->RG_Pai);}

		if (($reg_motoristap->Data_Nascimento!='')&&
			($reg_motoristap->Data_Nascimento!='0000-00-00')){
			$post['DataNascimento'] = $reg_motoristap->Data_Nascimento;
		}

		$ret = CIOT_Transmite($post,$host.'/Motorista/Integrar',$log);
		$retd = json_decode($ret['pagina']);

		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha no Envio dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno = true;
			CIOT_echo("mensagem", "Motorista Enviado com Sucesso");
		}
		return $retorno;
	}

	function CIOT_BuscaTipos($serv,$tag_id,$token,$host,$cnpj,$tp,$log){
		$post['CNPJAplicacao']	= $cnpj;
		$post['Token']			= $token;
		$post['DataBase']		= data_atual('date');
		CIOT_echo("mensagem", "Buscando Tipo Veculo ".$tag_id.":".$tp."...");
		$ret = CIOT_Transmite($post,$host.'/'.$serv,$log);
		$retd = json_decode($ret['pagina']);
		$retorno = '';
		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha na Buscados dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$lista = $retd->Objeto;
			foreach($lista as $codigo => $valor){
				$tipo = $lista[$codigo];
				if ($tipo['Nome']==$tp){
					$retorno = $tipo[$tag_id];
				}
			}
		}
		return $retorno;
	}

	function CIOT_Envia_Veiculo($con,$empresa, $nr_manifesto,$log){
		$retorno = false;
		$retorno1 = false;
		$retorno2 = false;
		CIOT_echo("titulo", "Iniciando Envio dos Dados do Veculo...");

		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);

		$con_veiculo =	'select * from pessoa_transportador_veiculo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Empresa.'"'.
						' and Seq_Veiculo = "'.$reg_carga->Rodo_Veiculo.'"';
		$res_veiculo = consulta_sql($con_veiculo);
		$reg_veiculo = consulta_ler_objeto($res_veiculo);
		consulta_limpa($res_veiculo);
		$proprietario = $reg_veiculo->Codigo_Proprietario;
		if ($proprietario<0){
			$proprietario = $empresa;
		}
		$con_proprietario =	'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and CPF_CNPJ = "'.$proprietario.'"';
		$res_proprietario = consulta_sql($con_proprietario);
		$reg_proprietario = consulta_ler_objeto($res_proprietario);
		consulta_limpa($res_proprietario);

		$cpf  = limpa_numero($reg_proprietario->CPF_CNPJ);
		$cont = $reg_veiculo->Tipo_Contrato;
		if ($cont==0){ $cont = 3; }
		$tracao = true;
		if ($reg_veiculo->Reboque_Placa!=''){
			$tp_tra = 'Cavalo 4x2';
			if ($reg_veiculo->Veiculo_Eixos>2){
				$tp_tra = 'Cavalo 6x2';
			}
			if ($reg_veiculo->Veiculo_Eixos>3){
				$tp_tra = 'Cavalo 6x4';
			}
		}else{
			$tp_tra = 'Toco';
			if ($reg_veiculo->Tipo_Rodado=='01'){
				$tp_tra = 'Tuck';
			}
			if ($reg_veiculo->Tipo_Rodado=='04'){
				$tp_tra = 'Van';
			}
			if ($reg_veiculo->Tipo_Rodado=='05'){
				$tp_tra = 'Utilitrio';
			}
			if ($reg_veiculo->Tipo_Rodado=='06'){
				$tp_tra = 'Outros';
			}
		}

		$tp_bau = 'Aberto';
		if ($reg_veiculo->Tipo_Carroceria=='02'){
			$tp_bau = 'Ba';
		}
		if ($reg_veiculo->Tipo_Carroceria=='03'){
			$tp_bau = 'Graneleiro';
		}
		if ($reg_veiculo->Tipo_Carroceria=='04'){
			$tp_bau = 'Porta Container';
		}
		if ($reg_veiculo->Tipo_Carroceria=='05'){
			$tp_bau = 'Sider';
		}

		$post['CNPJAplicacao']		= $cnpj;
		$post['Token'] 				= $token;
		$post['CNPJEmpresa']		= $cnpj;
		//$post['CPFCNPJProprietario']= $cpf;

		$post['Placa']				= str_replace('-','',$reg_veiculo->Placa);
		$post['Chassi']				= strSemAcentos($reg_veiculo->Veiculo_Nr_Chassis);
		$post['Renavam']			= strSemAcentos($reg_veiculo->Veiculo_RENAVAN);

		$anos  = explode('/',$reg_veiculo->Veiculo_Ano.'//');
		$anosf = fill_full($anos[0],4);
		$anosm = fill_full($anos[1],4);

		if ($anosf!='0000'){
			$post['AnoFabricacao']	= $anosf;
		}
		if ($anosm!='0000'){
			$post['AnoModelo']		= $anosm;
		}
		$post['Marca']				= strSemAcentos($reg_veiculo->Veiculo_Marca);
		$post['Modelo']				= strSemAcentos($reg_veiculo->Veiculo_Modelo);
		$post['ComTracao']			= $tracao;
		$post['TipoContrato']		= $cont;
		$post['QuantidadeEixos']	= $reg_veiculo->Veiculo_Eixos;
		//$post['IdTipoTracao']		= CIOT_BuscaTipos('Veiculo/ConsultarTipoCarreta','IdTipoCarreta',$token,$host,$cnpj,$tp_bau,$log);
		$post['IdTipoCavalo']		= CIOT_BuscaTipos('Veiculo/ConsultarTipoCavalo', 'IdTipoCavalo', $token,$host,$cnpj,$tp_tra,$log);
		CIOT_echo("titulo", "Trao: ".$reg_veiculo->Placa);
		$ret = CIOT_Transmite($post,$host.'/Veiculo/Integrar',$log);
		$retd = json_decode($ret['pagina']);

		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha no Envio dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno = true;
			CIOT_echo("mensagem", "Veiculo Enviado com Sucesso");
		}
		$retorno1 = true;
		$retorno2 = true;

		
		//reboque 1
		if ($reg_veiculo->Reboque_Placa!=''){
			CIOT_echo("titulo", "Reboque: ".$reg_veiculo->Reboque_Placa);
			$IdTipoCarreta = CIOT_BuscaTipos('Veiculo/ConsultarTipoCarreta','IdTipoCarreta',$token,$host,$cnpj,$tp_bau,$log);
			$tracao = true;
			$post = '';
			$eixos = $reg_veiculo->Reboque_Eixos;
			if ($eixos==0){
				$eixos = 1;
			}
			$post['CNPJAplicacao']		= $cnpj;
			$post['Token'] 				= $token;
			$post['CNPJEmpresa']		= $cnpj;
			//$post['CPFCNPJProprietario']= $cpf;

			$post['Placa']				= str_replace('-','',$reg_veiculo->Reboque_Placa);
			$post['Chassi']				= strSemAcentos($reg_veiculo->Veiculo_Nr_Chassis);
			$post['Renavam']			= strSemAcentos($reg_veiculo->Reboque_RENAVAN);
			if ($anosf!='0000'){
				$post['AnoFabricacao']	= $anosf;
			}
			if ($anosm!='0000'){
				$post['AnoModelo']		= $anosm;
			}
			$post['Marca']				= strSemAcentos($reg_veiculo->Veiculo_Marca);
			$post['Modelo']				= strSemAcentos($reg_veiculo->Veiculo_Modelo);
			$post['ComTracao']			= $tracao;
			if (!$tracao){
				$post['IdTipoCarreta']	= $IdTipoCarreta;
			}
			$post['TipoContrato']		= $cont;
			$post['QuantidadeEixos']	= $eixos;
			$ret = CIOT_Transmite($post,$host.'/Veiculo/Integrar',$log);
			$retd = json_decode($ret['pagina']);

			if (!$retd->Sucesso){
				CIOT_echo("erro", "Falha no Envio dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
			}else{
				$retorno2 = true;
				CIOT_echo("mensagem", "Veiculo Enviado com Sucesso");
			}
		}else{
			$retorno1 = true;
		}
		//reboque 2
		if ($reg_veiculo->Reboque2_Placa!=''){
			CIOT_echo("titulo", "Reboque: ".$reg_veiculo->Reboque2_Placa);
			$tracao = true;
			$post = '';
			$eixos = $reg_veiculo->Reboque2_Eixos;
			if ($eixos==0){
				$eixos = 1;
			}
			$post['CNPJAplicacao']		= $cnpj;
			$post['Token'] 				= $token;
			$post['CNPJEmpresa']		= $cnpj;
			//$post['CPFCNPJProprietario']= $cpf;

			$post['Placa']				= str_replace('-','',$reg_veiculo->Reboque2_Placa);
			$post['Chassi']				= strSemAcentos($reg_veiculo->Veiculo_Nr_Chassis);
			$post['Renavam']			= strSemAcentos($reg_veiculo->Reboque2_RENAVAN);
			if ($anosf!='0000'){
				$post['AnoFabricacao']	= $anosf;
			}
			if ($anosm!='0000'){
				$post['AnoModelo']		= $anosm;
			}
			$post['Marca']				= strSemAcentos($reg_veiculo->Veiculo_Marca);
			$post['Modelo']				= strSemAcentos($reg_veiculo->Veiculo_Modelo);
			$post['ComTracao']			= $tracao;
			if (!$tracao){
				$post['IdTipoCarreta']	= $IdTipoCarreta;
			}
			$post['TipoContrato']		= $cont;
			$post['QuantidadeEixos']	= $eixos;
			$ret = CIOT_Transmite($post,$host.'/Veiculo/Integrar',$log);
			$retd = json_decode($ret['pagina']);

			if (!$retd->Sucesso){
				CIOT_echo("erro", "Falha no Envio dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
			}else{
				$retorno2 = true;
				CIOT_echo("mensagem", "Veiculo Enviado com Sucesso");
			}
		}else{
			$retorno2 = true;
		}
		
		return (($retorno)&&($retorno1)&&($retorno2));
	}

	function CIOT_EnviaProprietario($con,$empresa, $nr_manifesto,$log){
		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);
		CIOT_echo("titulo", "Iniciando Envio dos Dados do Proprietrio/Contratado (".$reg_carga->Contratado.")...");

		$con_proprietario =	'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_carga->Contratado.'"';
		$res_proprietario = consulta_sql($con_proprietario);
		$reg_proprietario = consulta_ler_objeto($res_proprietario);
		consulta_limpa($res_proprietario);

		$con_proprietarioe ='select * from pessoa_endereco '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_proprietario->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Endereco';
		$res_proprietarioe = consulta_sql($con_proprietarioe);
		$reg_proprietarioe = consulta_ler_objeto($res_proprietarioe);
		consulta_limpa($res_proprietarioe);

		$con_proprietariot ='select * from pessoa_telefone '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_proprietario->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Telefone';
		$res_proprietariot = consulta_sql($con_proprietariot);
		$reg_proprietariot = consulta_ler_objeto($res_proprietariot);
		$reg_proprietariot2 = consulta_ler_objeto($res_proprietariot);
		consulta_limpa($res_proprietariot);

		$con_veiculo =	'select * from pessoa_transportador_veiculo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Empresa.'"'.
						' and Seq_Veiculo = "'.$reg_carga->Rodo_Veiculo.'"';
		$res_veiculo = consulta_sql($con_veiculo);
		$reg_veiculo = consulta_ler_objeto($res_veiculo);
		consulta_limpa($res_veiculo);

		$cont = $reg_veiculo->Tipo_Contrato;
		if ($cont<=0){ $cont = 3; }

		$pf_pj = 1;
		if (strlen($reg_proprietario->CPF_CNPJ)>14){
			$pf_pj = 2;
		}

		$post['CNPJAplicacao']	= $cnpj;
		$post['Token']			= $token;
		$post['CNPJEmpresa']	= $cnpj;
		$post['CnpjCpf']		= limpa_numero($reg_proprietario->CPF_CNPJ);
		$post['RazaoSocial']	= strSemAcentos($reg_proprietario->Nome_Razao);
		$post['NomeFantasia']	= strSemAcentos($reg_proprietario->Nome_Fantasia);
		if ($pf_pj==1){
			$post['RG']			= $reg_proprietario->RG;
			$post['RGOrgaoExpedidor']=$reg_proprietario->RG_Orgao;
			if ($post['RGOrgaoExpedidor']==''){
				$post['RGOrgaoExpedidor'] = 'SSP-'.$reg_proprietarioe->UF;
			}
		}
		$post['RNTRC']			= limpa_numero($reg_veiculo->Registro_ANTT);
		if ($pf_pj==2){
			$post['IE']			= limpa_numero($reg_proprietarioe->Insc_Estadual);
		}
		$post['TipoContrato']	= $cont;
		if ($pf_pj==1){
			if ($reg_proprietario->Data_Nascimento!='0000-00-00'){
				$post['DataNascimento'] = $reg_proprietario->Data_Nascimento;
			}
		}
		//$post['INSS']			= $reg_proprietario->CPF_CNPJ;
		//$post['Referencia1']	= $reg_proprietario->CPF_CNPJ;
		//$post['Referencia2']	= $reg_proprietario->CPF_CNPJ;
		$post['HabilitarContratoCiotAgregado']	= false;
		//print_r($reg_proprietarioe);

		$contatos = array();
		$enderecos = array();
		if ($reg_proprietario->EMail!=''){
			$contatos['Email']	= strSemAcentos($reg_proprietario->EMail);
		}
		$contatos['Telefone']	= limpa_numero($reg_proprietariot->Numero_Telefone);
		if ($reg_proprietariot2->Numero_Telefone!=''){
			$contatos['Celular']		= limpa_numero($reg_proprietariot2->Numero_Telefone);
		}

		$enderecos['CEP']		= limpa_numero($reg_proprietarioe->CEP);
		$enderecos['Endereco']	= strSemAcentos($reg_proprietarioe->Logradouro);
		if ($reg_proprietarioe->Complemento!=''){
			$enderecos['Complemento']	= strSemAcentos($reg_proprietarioe->Complemento);
		}
		if ($reg_proprietarioe->Numero!=''){
			$enderecos['Numero']		= strSemAcentos($reg_proprietarioe->Numero);
		}
		$enderecos['Bairro']	= strSemAcentos($reg_proprietarioe->Bairro);
		//$enderecos['Bairro']= $reg_proprietarioe->Codigo_Cidade;
		$enderecos['IBGECidade']= $reg_proprietarioe->Codigo_Cidade;
		$enderecos['IBGEEstado']= substr($reg_proprietarioe->Codigo_Cidade,0,2);
		$enderecos['BACENPais']	= $reg_proprietarioe->Codigo_Pais;
		$Aenderecos[0] = $enderecos;
		$Acontatos[0] = $contatos;
		$post['Contatos']		= ($Acontatos);
		$post['Enderecos']		= ($Aenderecos);
		if ($pf_pj==1){
			if ($reg_proprietario->RG_Mae!=''){
				$post['NomeMae']		= strSemAcentos($reg_proprietario->RG_Mae);
			}
			if ($reg_proprietario->RG_Pai!=''){
				$post['NomePai']		= strSemAcentos($reg_proprietario->RG_Pai);
			}
		}

		$ret = CIOT_Transmite($post,$host.'/Proprietario/Integrar',$log);
		$retd = json_decode($ret['pagina']);
		$retorno = false;
		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha na Buscados dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno = true;
			CIOT_echo("mensagem", "Veiculo Enviado com Sucesso");
		}
		return $retorno;
	}

	function CIOT_EnviaCliente($con,$empresa, $nr_manifesto, $cod_cliente,$log){
		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		CIOT_echo("titulo", "Iniciando Envio dos Dados do Cliente (".$cod_cliente.")...");

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);

		$con_proprietario =	'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$cod_cliente.'"';
		$res_proprietario = consulta_sql($con_proprietario);
		$reg_proprietario = consulta_ler_objeto($res_proprietario);
		consulta_limpa($res_proprietario);

		$con_proprietarioe ='select * from pessoa_endereco '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_proprietario->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Endereco';
		$res_proprietarioe = consulta_sql($con_proprietarioe);
		$reg_proprietarioe = consulta_ler_objeto($res_proprietarioe);
		consulta_limpa($res_proprietarioe);

		$con_proprietariot ='select * from pessoa_telefone '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_proprietario->Pessoa.'"'.
							' and Situacao = "A" order by Seq_Telefone';
		$res_proprietariot = consulta_sql($con_proprietariot);
		$reg_proprietariot = consulta_ler_objeto($res_proprietariot);
		consulta_limpa($res_proprietariot);

		$con_veiculo =	'select * from pessoa_transportador_veiculo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$res_carga->Empresa.'"'.
						' and Seq_Veiculo = "'.$res_carga->Rodo_Veiculo.'"';
		$res_veiculo = consulta_sql($con_veiculo);
		$reg_veiculo = consulta_ler_objeto($res_veiculo);
		consulta_limpa($res_veiculo);

		$cont = $reg_veiculo->Tipo_Contrato;

		$pf_pj = 1;
		if (strlen($reg_proprietario->CPF_CNPJ)>14){
			$pf_pj = 2;
		}

		$post['CNPJAplicacao']	= $cnpj;
		$post['Token']			= $token;
		$post['CNPJEmpresa']	= $cnpj;

		$post['IBGECidade']		= $reg_proprietarioe->Codigo_Cidade;
		$post['IBGEEstado']		= substr($reg_proprietarioe->Codigo_Cidade,0,2);
		$post['BACENPais']		= $reg_proprietarioe->Codigo_Pais;

		$post['RazaoSocial']	= strSemAcentos($reg_proprietario->Nome_Razao);
		$post['NomeFantasia']	= strSemAcentos($reg_proprietario->Nome_Fantasia);

		$post['TipoPessoa']		= $pf_pj;
		$post['CNPJCPF']		= limpa_numero($reg_proprietario->CPF_CNPJ);
		if ($pf_pj==1){
			$post['RG']			= strSemAcentos($reg_proprietario->RG);
			$post['RGOrgaoExpedidor']= strSemAcentos($reg_proprietario->RG_Orgao);
			if ($post['RGOrgaoExpedidor']==''){
				$post['RGOrgaoExpedidor'] = 'SSP-'.$reg_proprietarioe->UF;
			}
		}
		if ($pf_pj==2){
			$post['IE']			= limpa_numero($reg_proprietarioe->Insc_Estadual);
		}
		if ($reg_proprietariot->Numero_Telefone!=''){
			$post['Celular']	= limpa_numero($reg_proprietariot->Numero_Telefone);
		}
		if ($reg_proprietario->EMail!=''){
			$post['Email']		= strSemAcentos($reg_proprietario->EMail);
		}

		$post['CEP']			= limpa_numero($reg_proprietarioe->CEP);
		$post['Endereco']		= strSemAcentos($reg_proprietarioe->Logradouro);
		if ($reg_proprietarioe->Complemento!=''){
			$post['Complemento']= strSemAcentos($reg_proprietarioe->Complemento);
		}
		if ($reg_proprietarioe->Numero!=''){
			$post['Numero']		= strSemAcentos($reg_proprietarioe->Numero);
		}
		$post['Bairro']			= strSemAcentos($reg_proprietarioe->Bairro);

		$ret = CIOT_Transmite($post,$host.'/Cliente/Integrar',$log);
		$retd = json_decode($ret['pagina']);
		$retorno = false;
		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha na Buscados dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno = true;
			CIOT_echo("mensagem", "Veiculo Enviado com Sucesso");
		}
		return $retorno;
	}

	function CIOT_EnviaViagem($empresa, $nr_manifesto,$tProp,$tVeic,$tMoto,$tOrigem,$tDestino,$Viagem,$log){
		$con = CIOT_Inicializa($empresa);
		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_manifesto.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);

		$con_proprietario =	'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$reg_carga->Contratado.'"';
		$res_proprietario = consulta_sql($con_proprietario);
		$reg_proprietario = consulta_ler_objeto($res_proprietario);
		consulta_limpa($res_proprietario);
		if ($tProp){
			$ok1 = CIOT_EnviaProprietario($con,$empresa, $nr_manifesto,$log);
		}else{
			$ok1 = true;
		}

		$con_motorista ='select * from pessoa_transportador_motorista '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Empresa.'"'.
						' and Seq_Motorista = "'.$reg_carga->Rodo_Motorista.'"';
		$res_motorista = consulta_sql($con_motorista);
		$reg_motorista = consulta_ler_objeto($res_motorista);
		consulta_limpa($res_motorista);
		if ($tMoto){
			$ok2 = CIOT_Envia_Motorista($con,$empresa, $nr_manifesto,$log);
		}else{
			$ok2 = true;
		}

		$con_origem =	'select * from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Origem.'"';
		$res_origem = consulta_sql($con_origem);
		$reg_origem = consulta_ler_objeto($res_origem);
		consulta_limpa($res_origem);
		if ($tOrigem){
			$ok3 = CIOT_EnviaCliente($con,$empresa, $nr_manifesto, $reg_carga->Origem,$log);
		}else{
			$ok3 = true;
		}

		$con_destino =	'select * from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Destino.'"';
		$res_destino = consulta_sql($con_destino);
		$reg_destino = consulta_ler_objeto($res_destino);
		consulta_limpa($res_destino);
		if ($tDestino){
			$ok4 = CIOT_EnviaCliente($con,$empresa, $nr_manifesto, $reg_carga->Destino,$log);
		}else{
			$ok4 = true;
		}

		$con_veiculo =	'select * from pessoa_transportador_veiculo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_carga->Empresa.'"'.
						' and Seq_Veiculo = "'.$reg_carga->Rodo_Veiculo.'"';
		$res_veiculo = consulta_sql($con_veiculo);
		$reg_veiculo = consulta_ler_objeto($res_veiculo);
		consulta_limpa($res_veiculo);
		if ($tVeic){
			$ok5 = CIOT_Envia_Veiculo($con,$empresa, $nr_manifesto,$log);
		}else{
			$ok5 = true;
		}

		CIOT_echo("titulo", "Iniciando Envio dos Dados da Viagem...");

		$carretas = array();
		$qtd_carretas = 0;
		$tDocumentosFiscais = '';
		$nDocumentosFiscais = 0;
		if ($reg_veiculo->Reboque_Placa!=''){
			$carretas[$qtd_carretas]= str_replace('-','',$reg_veiculo->Reboque_Placa);
			$qtd_carretas++;
		}
		if ($reg_veiculo->Reboque2_Placa!=''){
			$carretas[$qtd_carretas]= str_replace('-','',$reg_veiculo->Reboque2_Placa);
			$qtd_carretas++;
		}

		if ($ok1&&$ok2&&$ok3&&$ok4&&$ok5){
			if (!$Viagem){
				CIOT_echo("mensagem", "Envio do Dados da Viagem No Realizado - Motivo: Opo do Usurio!");
			}else{
				$vl_prod = 0;
				$data_coleta='';
				$data_entrega='';
				$peso = 0;

				$con_notas ='select Modelo,Serie,SubSerie,NrDoc,ValorDoc,Peso_Bruto from manifesto_carga_nota_fiscal '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Nr_Manifesto = "'.$nr_manifesto.'"';
				$res_notas = consulta_sql($con_notas);
				$nrw_notas = consulta_num_registros($res_notas);
				for ($k=0;$k<$nrw_notas;$k++) {
					$reg_notas = consulta_ler_objeto($res_notas);
					//print_r($reg_notas);
					$doc = array();
					$peso+= round($reg_notas->Peso_Bruto);
					$nf = (($reg_notas->Modelo=='01')||($reg_notas->Modelo=='55')||($reg_notas->Modelo=='59')||($reg_notas->Modelo=='65'));
					$ct = (($reg_notas->Modelo=='07')||($reg_notas->Modelo=='08')||($reg_notas->Modelo=='57'));
					if ($nf){
						$vl_prod = $reg_notas->ValorDoc;
						//$doc['IdViagemDocumentoFiscal'] = $res_carga->Seq;
						$doc['NumeroDocumento'] = $reg_notas->NrDoc;
						$doc['Serie']			= $reg_notas->Serie;
						$doc['PesoSaida']		= round($reg_notas->Peso_Bruto);
						$doc['Valor']			= $reg_notas->ValorDoc+0;
						$doc['TipoDocumento']	= 4;
					}else if ($ct){
						$con_nf='select * from nota_frete '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa	= "'.$reg_carga->Empresa.'"'.
								' and Modelo	= "'.$reg_notas->Modelo.'"'.
								' and Serie		= "'.$reg_notas->Serie.'"'.
								' and SubSerie	= "'.$reg_notas->SubSerie.'"'.
								' and NrDoc		= "'.$reg_notas->NrDoc.'"';
						$res_nf = consulta_sql($con_nf);
						$reg_nf = consulta_ler_objeto($res_nf);
						consulta_limpa($res_nf);
						$vl_prod = $reg_nf->Total_Produtos;

						$data_entrega = $reg_nf->DT_Prevista;
						$data_coleta  = $reg_nf->DT_Coleta;
						if ($reg_nf->DT_Coleta=='0000-00-00'){
							$data_coleta = '';
						}
						if ($reg_nf->DT_Prevista=='0000-00-00'){
							$data_entrega = '';
						}
						$doc['NumeroDocumento'] = $reg_notas->NrDoc;
						$doc['Serie']			= $reg_notas->Serie;
						$doc['PesoSaida']		= round($reg_notas->Peso_Bruto);
						$doc['Valor']			= $reg_notas->ValorDoc+0;
						$doc['TipoDocumento']	= 1;
					}else{
						$doc['NumeroDocumento'] = $reg_notas->NrDoc;
						//$doc['Serie']			= $res_carga->Serie;
						//$doc['PesoSaida']		= round($res_carga->Peso_Bruto,0);
						//$doc['Valor']			= $res_carga->ValorDoc;
						$doc['TipoDocumento']	= 0;
					}
					//$tDoc = json_decode($doc);
					//if($nDocumentosFiscais>0){$tDocumentosFiscais.= ',';}
					$tDocumentosFiscais[$nDocumentosFiscais]= $doc;
					$nDocumentosFiscais++;
				}
				consulta_limpa($res_notas);
				//IdViagemDocumentoFiscal-NumeroDocumento-Serie-PesoSaida-Valor-TipoDocumento

				//$post['IdViagem']		= $reg_carga->CIOT_Pedagio_Id;
				$post['CNPJAplicacao']	= $cnpj;
				$post['Token']			= $token;
				$post['CNPJEmpresa']	= $cnpj;

				$post['CPFCNPJClienteDestino']		= limpa_numero($reg_origem->CPF_CNPJ);
				$post['CPFCNPJClienteOrigem']		= limpa_numero($reg_destino->CPF_CNPJ);
				//$post['CPFCNPJClienteTomador']	= $cnpj_t;
				$post['CPFCNPJProprietario']		= limpa_numero($reg_proprietario->CPF_CNPJ);
				//$post['NomeProprietario']			= $cnpj;
				//$post['RNTRC']					= $cnpj;
				//$post['CNPJFilial']				= limpa_numero($reg_carga->Empresa_CNPJ);
				//$post['RazaoSocialFilial']		= $reg_carga->Empresa_Razao;
				$post['CPFMotorista']				= limpa_numero($reg_motorista->CPF);
				//$post['IdCarga']					= $cnpj;
				$post['Placa']						= str_replace('-','',$reg_veiculo->Placa);
				if ($data_coleta!=''){
					$post['DataColeta']				= $data_coleta;
				}
				if ($data_entrega!=''){
					$post['DataPrevisaoEntrega']	= $data_entrega;
				}
				$post['StatusViagem']				= 1;
				//$post['StatusIntegracao']			= $cnpj;
				if ($qtd_carretas>0){
					$post['Carretas']				= $carretas;
				}
				//$post['DocumentoCliente']			= $res_carga->NrDoc.'/'.$res_carga->Serie.'-'.$res_carga->Modelo;
				$post['PesoSaida']					= round($peso);
				if ($reg_carga->Valor_Pedagio>0){
					$post['ValorPedagio']			= $reg_carga->Valor_Pedagio+0;
					$post['PedagioBaixado']			= false;
				}
				if ($vl_prod>0){
					$post['ValorMercadoria']		= $vl_prod+0;
				}
				if ($reg_carga->Valor_Servico_Prestado>0){
					$post['ValorFrete']				= $reg_carga->Valor_Servico_Prestado+0;
				}
				if ($reg_carga->Valor_IRRF>0){
					$post['IRRPF']					= $reg_carga->Valor_IRRF+0;
				}
				if (($reg_carga->Valor_Prev_Social+$reg_carga->Valor_INSS)>0){
					$post['INSS']					= $reg_carga->Valor_Prev_Social+$reg_carga->Valor_INSS;
				}
				if ($reg_carga->Valor_SEST_SENAT>0){
					$post['SESTSENAT']				= $reg_carga->Valor_SEST_SENAT+0;
				}
				$post['NumeroDocumento']			= $reg_carga->NrDoc;//.'/'.$res_carga->Serie.'-'.$res_carga->Modelo;
				$post['DataEmissao']				= datad(dataf($reg_carga->DH_Emissao));
				$post['Produto']					= strSemAcentos($reg_carga->ProdPred_Descricao);
				$post['Unidade']					= 0;//0-Peso/1-Saca
				$post['Quantidade']					= round($peso);
				//$post['Coleta']					= $cnpj;
				//$post['Entrega']					= $cnpj;
				//$post['NumeroCartao']				= $cnpj;
				$post['HabilitarDeclaracaoCiot']	= true;
				$post['NaturezaCarga']				= $reg_carga->CIOT_NaturezaCarga;
				//$post['NumeroControle']			= $cnpj;
				$post['ForcarCiotNaoEquiparado']	= true;
				$post['CEPOrigem']					= limpa_numero($reg_carga->ProdPred_CEP_Origem);
				$post['CEPDestino']					= limpa_numero($reg_carga->ProdPred_CEP_Destino);
				$post['CodigoTipoCarga']			= $reg_carga->ProdPred_Tipo_Carga;
				if ($reg_carga->Distancia>0){
					$post['DistanciaViagem']		= round($reg_carga->Distancia+1-1,0);
				}

				//$post['DadosPagamento']			= $cnpj;//FormaPagamento-CodigoBacen-Agencia-Conta
				//$post['DadosANTT']				= $cnpj;//AltoDesempenho-DestinacaoComercial-FreteRetorno-CEPRetorno-DistanciaRetorno

				$regra = array();
				$regra['TaxaAntecipacao']			= '0';
				$regra['ToleranciaPeso']			= '0';
				$regra['TarifaTonelada']			= '0';
				$regra['TipoQuebraMercadoria']		= '0';
				$regras[] = $regra;
				$post['ViagemRegra']				= $regras;
				//$post['ViagemRegra']				= $cnpj;//IdViagemRegra-TaxaAntecipacao-ToleranciaPeso-TarifaTonelada-TipoQuebraMercadoria
				//$post['ViagemEstabelecimentos']	= $cnpj;//IdViagemEstabelecimento-IdEstabelecimento-TipoEventoViagem

				$evento = array();
				$evento['TipoEvento']			= '1';//saldo
				$evento['ValorPagamento']		= round(($reg_carga->Valor_Servico_Prestado-$reg_carga->Valor_Adiantamento),2)+0;
				$evento['Status']				= '0';
				$evento['HabilitarPagamentoCartao'] = false;
				$eventos[] = $evento;
				if ($reg_carga->Valor_Adiantamento>0){
					$evento = array();
					$evento['TipoEvento']			= '0';//valor adiantamento
					$evento['ValorPagamento']		= $reg_carga->Valor_Adiantamento+0;
					$evento['Status']				= '1';
					$evento['HabilitarPagamentoCartao'] = false;
					$eventos[] = $evento;
				}
				$post['ViagemEventos']			= $eventos;
				//$post['ViagemDocumentos']			= $cnpj;
				//$post['ViagemOutrosDescontos']	= $cnpj;
				//$post['ViagemOutrosAcrescimos']	= $cnpj;
				if ($reg_carga->CIOT_Pedagio_Id!=''){
					$Pedagio = array();
					$Pedagio['Fornecedor']			= $reg_carga->CIOT_Pedagio_Operadora;
					$Pedagio['IdentificadorHistorico'] = $reg_carga->CIOT_Pedagio_Id;
					$post['Pedagio']				= $Pedagio;
				}
				if ($nDocumentosFiscais>0){
					$post['DocumentosFiscais']		= $tDocumentosFiscais;//IdViagemDocumentoFiscal-NumeroDocumento-Serie-PesoSaida-Valor-TipoDocumento-----
				}

				$retorno['ok']							= false;
				$retorno['Idviagem'] 					= '';
				$retorno['IdsViagemEstabelecimento']	= '';
				$retorno['IRRPF']						= '';
				$retorno['INSS']						= '';
				$retorno['SESTSENAT']					= '';

				$ret = CIOT_Transmite($post,$host.'/Viagem/Integrar',$log);
				$retd = json_decode($ret['pagina']);
				if (!$retd->Sucesso){
					CIOT_echo("erro", "Falha na Buscados dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
				}else{
					$retorno['ok']						= true;
					$retorno['Idviagem']				= $retd->Objeto->IdViagem;
					//$retorno['IdsViagemEstabelecimento']= $retd->IdsViagemEstabelecimento;
					$retorno['IRRPF']					= $retd->Objeto->IRRPF;
					$retorno['INSS']					= $retd->Objeto->INSS;
					$retorno['SESTSENAT']				= $retd->Objeto->SESTSENAT;

					$retorno['Ciot']					= $retd->Objeto->CIOT->Dados->Ciot;
					$retorno['Verificador']				= $retd->Objeto->CIOT->Dados->Verificador;
					$retorno['Senha']					= $retd->Objeto->CIOT->Dados->Senha;

					CIOT_echo("mensagem", "Viagem Enviada com Sucesso");

					$valores = '';
					if ($retorno['IRRPF']>0){		$valores.=' Valor_IRRF = "'.$retorno['IRRPF'].'",';}
					if ($retorno['INSS']>0){		$valores.=' Valor_INSS = "'.$retorno['INSS'].'", Valor_Prev_Social = 0, ';}
					if ($retorno['SESTSENAT']>0){	$valores.=' Valor_SEST_SENAT = "'.$retorno['SESTSENAT'].'",';}
					$upd_vendas =	'Update manifesto_carga set '.
									$valores.
									' CIOT_Viagem		= "'.$retorno['Idviagem'].'",'.
									' Rodo_CIOT			= "'.$retorno['Ciot'].'",'.
									' CIOT_Dig			= "'.$retorno['Verificador'].'",'.
									' CIOT_Numero		= "'.$retorno['Senha'].'"'.
									' Where Dominio		= "'.$_SESSION['Dominio'].'"'.
									' and Empresa		= "'.$empresa.'"'.
									' and Nr_Manifesto	= "'.$nr_manifesto.'"';
					consulta_sql($upd_vendas);
				}
			}
		}else{
			CIOT_echo("erro", "Falha na Transmisso dos Cadastros! Corrija os Dados e Tente Novamente!");
		}
		return $retorno;
	}
	
	function CIOT_CancelaViagem($empresa, $nr_nota_fiscal){
		$con = CIOT_Inicializa($empresa);
		$token = $con['token'];
		$host  = $con['host'];
		$cnpj  = $con['cnpj'];

		$con_carga ='select * from manifesto_carga '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Nr_Manifesto = "'.$nr_nota_fiscal.'"';
		$res_carga = consulta_sql($con_carga);
		$reg_carga = consulta_ler_objeto($res_carga);
		consulta_limpa($res_carga);
		CIOT_echo("titulo", "Iniciando Cancelamento da Viagem...");
		
		$post['CNPJAplicacao']	= $cnpj;
		$post['Token']			= $token;

		//$post['DataEvento']	= $data;
		$post['CodigoViagem']	= $reg_carga->CIOT_Viagem;
		
		$log = false;

		$ret = CIOT_Transmite($post,$host.'/Viagem/CancelarViagem',$log);
		$retd = json_decode($ret['pagina']);
		if (!$retd->Sucesso){
			CIOT_echo("erro", "Falha na Transmisso dos Dados: <B>".utf8_decode($retd->Mensagem)."</B>");
		}else{
			$retorno['ok']						= true;
			CIOT_echo("mensagem", "Viagem Cancelada com Sucesso");

			$upd_vendas =	'Update manifesto_carga set '.
							' CIOT_Viagem		= "",'.
							' Rodo_CIOT			= "",'.
							' CIOT_Dig			= "",'.
							' CIOT_Numero		= ""'.
							' Where Dominio		= "'.$_SESSION['Dominio'].'"'.
							' and Empresa		= "'.$empresa.'"'.
							' and Nr_Manifesto	= "'.$nr_nota_fiscal.'"';
			consulta_sql($upd_vendas);
		}
		return $retorno;
	}
?>