<?php
	require_once(dirname(__FILE__).'/importacao.php');

	/*
	https://developers.mercadolivre.com.br/pt_br/registre-o-seu-aplicativo/

	https://developers.mercadolivre.com.br/devcenter

	falecomequiparia@gmail.com

	ID: 1009946881829307
	Secret Key: O2UJmXtl1B7CED7W6OK4mA5gLiZF7Hes

	https://api.mercadolibre.com/oauth/token?grant_type=authorization_code&client_id=1009946881829307&client_secret=O2UJmXtl1B7CED7W6OK4mA5gLiZF7Hes&code=TG-5d4dc2670640540006cb2732-356684895&redirect_uri=http://localhost:9090/mercado_livre/examples/example_login.php

	Access Token: APP_USR-1009946881829307-080919-34257899a595f7529ba42382987ad7a5-356684895

	https://api.mercadolibre.com/users/me?access_token=$ACCESS_TOKEN
	Id Seller: 356684895
	*/

	function tratarDadosPedido($result){
		$listaGeral = array();
		$registros = $result['body']['results'];
		$i = 0;
		foreach($registros as $registro){
			$comprador = array();
			$compradorTelefones = array();
			$dadosComprador = $registro['buyer'];
			$dadosCompradorTelefones = $dadosComprador['phone'];
			$dadosCompradorTelefones2 = $dadosComprador['alternative_phone'];
			$dadosFrete = $registro['shipping'];
			$dadosFreteEndereco = isset($dadosFrete['receiver_address']) ? $dadosFrete['receiver_address'] : array();
			$telefone = '';
			$ddd = trim($dadosCompradorTelefones['area_code']);
			$numero = trim($dadosCompradorTelefones['number']);
			if(!empty($ddd)){
				$telefone = '('.$ddd.') ';
			}
			$telefone.= $numero;
			$telefone2 = '';
			$ddd2 = trim($dadosCompradorTelefones2['area_code']);
			$numero2 = trim($dadosCompradorTelefones2['number']);
			if(!empty($numero2)){
				if(!empty($ddd2)){
					$telefone2 = '('.$ddd2.') ';
				}
				$telefone2.= $numero2;
			}
			$comprador['id'] = $dadosComprador['id'];
			$comprador['nickname'] = utf8_decode_si($dadosComprador['nickname']);
			$comprador['email'] = utf8_decode_si($dadosComprador['email']);
			$comprador['nome'] = utf8_decode_si($dadosComprador['first_name']);
			$comprador['sobrenome'] = utf8_decode_si($dadosComprador['last_name']);
			$comprador['cpf_cnpj'] = mcpf($dadosComprador['billing_info']['doc_number']);
			$comprador['telefone'] = array(
										$telefone,
										$telefone2,
										);

			$comprador['endereco'] = array();

			$cep = '';
			$numero = '';
			$rua = '';
			$complemento = '';
			$uf = '';
			$cidade = '';

			if(!empty($dadosFreteEndereco)){
				$cep = mcep($dadosFreteEndereco['zip_code']);
				$numero = $dadosFreteEndereco['street_number'];
				$rua = utf8_decode_si($dadosFreteEndereco['street_name']);
				$complemento = utf8_decode_si($dadosFreteEndereco['comment']);
				$uf = substr($dadosFreteEndereco['state']['id'], 3);
				$cidade = utf8_decode_si($dadosFreteEndereco['city']['name']);
				$bairro = utf8_decode_si($dadosFreteEndereco['neighborhood']['name']);
				if(empty($bairro)){
					$bairro = 'xxx';
				}
				$comprador['endereco']['cep'] = $cep;
				$comprador['endereco']['numero'] = $numero;
				$comprador['endereco']['rua'] = $rua;
				$comprador['endereco']['complemento'] = $complemento;
				$comprador['endereco']['uf'] = $uf;
				$comprador['endereco']['cidade'] = $cidade;
				$comprador['endereco']['bairro'] = $bairro;
			}

			$itens = array();

			foreach($registro['order_items'] as $chaveItem => $registroItem){
				$codigo = trim($registroItem['item']['seller_sku']);

				if(empty($codigo)){
					$codigo = '';
				}

				$itens[$chaveItem]['codigo'] = $codigo;
				$itens[$chaveItem]['titulo'] = utf8_decode_si(trim($registroItem['item']['title']));
				$itens[$chaveItem]['quantidade'] = $registroItem['quantity'];
				$itens[$chaveItem]['preco_unitario'] = $registroItem['unit_price'];
				//$itens[$chaveItem]['preco_unitario_full'] = $registroItem['full_unit_price'];
			}

			$freteCusto = 0;
			$freteDescricao = $dadosFrete['tracking_method'].' ('.$dadosFrete['tracking_number'].')';
			if(isset($dadosFrete['shipping_option'])){
				$freteCusto = $dadosFrete['shipping_option']['cost'];
				$freteDescricao.= ' - '.$dadosFrete['shipping_option']['name'];
			}

			$listaGeral[$i]['id'] = $registro['id'];
			$listaGeral[$i]['data_criacao'] = $registro['date_created'];
			$listaGeral[$i]['data_fechamento'] = $registro['date_closed'];
			$listaGeral[$i]['comprador'] = $comprador;
			$listaGeral[$i]['itens'] = $itens;
			$listaGeral[$i]['frete'] = $freteCusto;
			$listaGeral[$i]['frete_descricao'] = utf8_decode_si($freteDescricao);
			$i++;
		}

		return $listaGeral;
	}

	function importarDadosCliente($dados){
		$codigo = 0;
		$con_pessoa = 'SELECT Pessoa FROM t_pessoa '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Id_Mercado_Livre = "'.$dados['id'].'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);

		if(isset($reg_pessoa)){
			if($reg_pessoa[0] > 0){
				$codigo = $reg_pessoa[0];
			}
		}

		$dados_pessoa = array();

		$cpf_cnpj = mcpf(limpa_numero($dados['cpf_cnpj']));
		$dados_pessoa['cdPessoa'] = $codigo;
		$dados_pessoa['tpCod'] = 'P'; // Importado cliente
		$dados_pessoa['nCpfCnpj'] = $cpf_cnpj;
		if($codigo == 0){
			if(($cpf_cnpj != '00.000.000/0000-00') && ($cpf_cnpj!='000.000.000-00')){
				$con_cpf = 'SELECT Pessoa FROM t_pessoa '.
				' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
				' AND CPF_CNPJ = "'.$cpf_cnpj.'"'.
				' LIMIT 1';
				$res_cpf = consulta_sql($con_cpf);
				$nrw_cpf = consulta_num_registros($res_cpf);
				$reg_cpf = consulta_ler_linha($res_cpf);
				consulta_limpa($res_cpf);
			}else{
				$nrw_cpf = 0;
			}

			if($nrw_cpf > 0){
				$codigo = $reg_cpf[0];
			}else{
				$con_pessoa = 'SELECT IFNULL(MAX(Pessoa), 0) FROM t_pessoa '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
				$res_pessoa = consulta_sql($con_pessoa);
				$reg_pessoa = consulta_ler_linha($res_pessoa);
				consulta_limpa($res_pessoa);
				$codigo = ($reg_pessoa[0] + 1);
				if($codigo <= 100){
					$codigo = 101;
				}
			}

			$tipo_pessoa = 'M';

			if(strlen($dados_pessoa['nCpfCnpj']) == 18){
				$tipo_pessoa = 'J';
			}

			$ins_pessoa = 'INSERT INTO t_pessoa ( '.
							' Dominio, '.
							' Pessoa, '.
							' Tipo_Pessoa, '.
							' CPF_CNPJ, '.
							' DataHora_Cadastro, '.
							' DataHora_Alteracao '.
							') VALUES ( '.
							' "'.$_SESSION['Dominio'].'", '.
							' "'.$codigo.'", '.
							' "'.$tipo_pessoa.'", '.
							' "'.$cpf_cnpj.'", '.
							' now(), '.
							' now() '.
							' )';
			consulta_sql($ins_pessoa);
			$upt_pessoa = 'UPDATE t_pessoa SET'.
						  ' Usuario_Alteracao  = "'.base64_decode_si($_SESSION["USER_ID"]).'"'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"';
			consulta_sql($upt_pessoa,true,1);
			$dados_pessoa['cdPessoa']  = $codigo;
		}
		$compradorNome = $dados['nome'].' '.$dados['sobrenome'];
		if(!empty($dados['nickname'])){
			$compradorNome.= ' ('.$dados['nickname'].')';
		}

		$dados_pessoa['Cadastros'] = 'SNNNN';
		$dados_pessoa['xFantasia'] = $compradorNome;
		$dados_pessoa['xRazao'] = $compradorNome;
		$dados_pessoa['xListas'] = $compradorNome;
		$dados_pessoa['xEmail'] = $dados['email'];
		$dados_pessoa['nFone'] = $dados['telefone'][0];
		$dados_pessoa['nFone2'] = $dados['telefone'][1];
		$dados_pessoa['nFone3'] = '';
		$dadosCompradorEndereco = $dados['endereco'];

		if(!empty($dadosCompradorEndereco)){
			$dados_pessoa['cMunicipio'] = '';
			$dados_pessoa['xMunicipio'] = $dadosCompradorEndereco['cidade'];
			$dados_pessoa['cIE'] = '';
			$dados_pessoa['cIM'] = '';
			$dados_pessoa['cCNAE'] = '';
			$dados_pessoa['cSUFRAMA'] = '';
			$dados_pessoa['nCep'] = mcep(limpa_numero($dadosCompradorEndereco['cep']));
			$dados_pessoa['cPais'] = '1058';
			$dados_pessoa['xPais'] = 'Brasil';
			$dados_pessoa['UF'] = $dadosCompradorEndereco['uf'];
			$dados_pessoa['xBairro'] = $dadosCompradorEndereco['bairro'];
			$dados_pessoa['xEnder'] = $dadosCompradorEndereco['rua'];
			$dados_pessoa['xNr'] = $dadosCompradorEndereco['numero'];
			$dados_pessoa['xCompl'] = $dadosCompradorEndereco['complemento'];
		}

		$dados_pessoa['situacao_cad'] = '';
		$cod_pessoa = importacao_cadastra_pessoa($dados_pessoa, false);
		$con_ins = 'UPDATE t_pessoa SET '.
					' Id_Mercado_Livre = "'.$dados['id'].'", '.
					' Liberado = "N", '.
					' DataHora_Alteracao = now() '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Pessoa = "'.$cod_pessoa.'"';
		consulta_sql($con_ins);
		$upt_pessoa = 'UPDATE t_pessoa SET'.
					  ' Usuario_Alteracao  = "'.base64_decode_si($_SESSION["USER_ID"]).'"'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$cod_pessoa.'"';
		consulta_sql($upt_pessoa,true,1);
		liberacao_pessoa($cod_pessoa, false);
		return $cod_pessoa;
	}

	function importarPedidos($result){
		// id: Identificador nico da ordem.
		// date_created: Data de criao da ordem.
		// date_closed: Data de confirmao da ordem. Quando uma ordem muda pela primeira vez de status  definida como: confirmed / paid e descontada do estoque do item.
		// expiration_date: Prazo limite para o usurio qualificar; aps essa data, o feedback se torna visvel, os pagamentos so emitidos (caso houver) e os encargos so criados.
		// status: Status da ordem. Ver os valores possveis.
		// status_detail: Detalhe do status, caso a ordem seja cancelada.
		// code: Cdigo do status.
		// description: Descrio do status.
		// comprador: Informaes do comprador.
		// vendedor: Informaes do vendedor.
		// order_items: Publicaes na ordem.
		// payments: Pagamentos relacionados  ordem.
		// feedback: Informaes de feedback relacionadas  ordem.
		// shipping: Configurao do envio para esta ordem.
		// total_amount: Valor total da ordem.
		// currency_id: ID de moeda.
		// tags: Lista das tags selecionadas pelo vendedor, como entregue, pago.

		$dados = tratarDadosPedido($result);
		$val_juros = formata_qtd(BuscaParam('FAT_JUROS'), 2, false);
		$fatura_tipo = BuscaParam('TIPO_FATURA');
		$totalPedidosImportados = 0;
		$vendedor = '0';
		if($_SESSION['Dominio'] == '41'){
			$vendedor = '2004';
		}

		foreach($dados as $registro){
			/* if($totalPedidosImportados >= 4){
			break;
			} */

			$idMercadoLivre = $registro['id'];

			$conPedido = 'SELECT COUNT(*) FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
						' AND Id_Mercado_Livre = "'.$idMercadoLivre.'"';
			$resPedido = consulta_sql($conPedido);
			$regPedido = consulta_ler_linha($resPedido);
			consulta_limpa($resPedido);

			// Ignora a importao se o pedido j estiver importado
			if($regPedido[0] > 0){
				continue;
			}

			$dadosComprador = $registro['comprador'];
			$codigoPessoa = importarDadosCliente($dadosComprador);
			$conPedido = 'SELECT IFNULL(MAX(Numero_Pedido), 0), max(CRE) FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"';
			$resPedido = consulta_sql($conPedido);
			$regPedido = consulta_ler_linha($resPedido);
			consulta_limpa($resPedido);

			$nrPedido =  ($regPedido[0] + 1);

			$insert = 	'INSERT INTO pedido ( '.
						' Dominio, '.
						' Empresa, '.
						' Numero_Pedido, '.
						' DH_Emissao, '.
						' DH_Digitacao, '.
						' Pessoa, '.
						' Forma_Pagto, '.
						' Status, '.
						' Usuario_Criacao, '.
						' Tipo_Pedido, '.
						' Fatura_Protesto, '.
						' Fatura_Juros, '.
						' Vendedor '.
						' ) VALUES ( '.
						' "'.$_SESSION['Dominio'].'", '.
						' "'.$_SESSION['Empresa_Codigo'].'", '.
						' "'.$nrPedido.'", '.
						' now(), '.
						' "'.$registro['data_criacao'].'", '.
						' "'.$codigoPessoa.'", '.
						' 1, '.
						' "E", '.
						' "MERCADO_LIVRE", '.
						' "1", '.
						' "S", '.
						' "'.$val_juros.'", '.
						' "'.$vendedor.'", '.
						' "'.($regPedido[1] + 1).'" '.
						' )';
			$ok = (consulta_sql($insert, true, 1) > 0);

			if($ok){
				$situacao = 'A';
				$observacao = 'Frete: '.$registro['frete_descricao'];
				$endereco = '1';
				$valorFrete = $registro['frete'];
				$update = 'UPDATE pedido SET '.
							' Fatura_Tipo = "'.$fatura_tipo.'", '.
							' Local_Fatura = "'.$endereco.'", '.
							' Local_Entrega = "'.$endereco.'", '.
							' Valor_Frete = "'.$valorFrete.'", '.
							' Id_Mercado_Livre = "'.$idMercadoLivre.'" '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nrPedido.'"';
				consulta_sql($update);
				$lib_tipo = BuscaParam('LIBERA_AUTOMAT_PEDID');
				$liberarPedido = false;
				$estoquePedido = 'N';
				if($lib_tipo == 'S'){
					$estoquePedido = 'S';
					$liberarPedido = true;
				}
				$seq = 0;
				$obsItens = '';
				foreach($registro['itens'] as $registroItem){
					$idProduto = 0;

					$codigoProduto = $registroItem['codigo'];
					$titulo = addslashes($registroItem['titulo']);
					$quantidade = $registroItem['quantidade'];
					$valorUnitario = $registroItem['preco_unitario'];

					if(!empty($codigoProduto)){
						$con_pro = 'SELECT Id_Produto FROM produto '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Codigo_Produto = "'.$codigoProduto.'" '.
									' AND Situacao <> "E"';
						$res_pro = consulta_sql($con_pro);
						$reg_pro = consulta_ler_linha($res_pro);
						consulta_limpa($res_pro);

						if(isset($reg_pro)){
							$idProduto = $reg_pro[0];
						}else{
							$con_pro = 'SELECT Id_Produto FROM produto '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Codigo_Produto = "'.$codigoProduto.'"';
							$res_pro = consulta_sql($con_pro);
							$reg_pro = consulta_ler_linha($res_pro);
							consulta_limpa($res_pro);
							if(isset($reg_pro)){
								$idProduto = $reg_pro[0];
							}
						}
					}
					// Se no encontrar o produto, ignorar insero
					if($idProduto == 0){
						$obsItens.= 'Produto "'.addslashes($titulo).'" no encontrado'. PHP_EOL;
						continue;
					}
					//$custo = 0;

					/* $conCusto = 'SELECT Preco_Custo, DH_Custo FROM produto_saldo_filial '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' AND Local_Armaz = "0" '.
					' AND Id_Produto = "'.$idProduto.'"';
					$resCusto = consulta_sql($conCusto);
					$regCusto = consulta_ler_linha($resCusto);
					consulta_limpa($resCusto);

					if(isset($regCusto)){
					$custo = $regCusto[0];
					} */
					$seq++;
					$insert = 'INSERT INTO pedido_item ( '.
								' Dominio, '.
								' Empresa, '.
								' Numero_Pedido, '.
								' Seq_Item, '.
								' Status '.
								') VALUES ( '.
								' "'.$_SESSION['Dominio'].'", '.
								' "'.$_SESSION['Empresa_Codigo'].'", '.
								' "'.$nrPedido.'", '.
								' "'.$seq.'", '.
								' "E" '.
								' )';
					consulta_sql($insert);

					$update = 'UPDATE pedido_item SET '.
								' Status = "'.$situacao.'", '.
								' ID_Produto = "'.$idProduto.'", '.
								' Qtd = "'.$quantidade.'", '.
								' Valor_Unitario = "'.$valorUnitario.'", '.
								' Valor_Total = "'.($valorUnitario * $quantidade).'", '.
								//' Preco_Custo = "'.$custo.'", '.
								' Estoque = "'.$estoquePedido.'" '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
								' AND Numero_Pedido = "'.$nrPedido.'" '.
								' AND Seq_Item = "'.$seq.'"';
					consulta_sql($update);
				}
				pedido_recalculo($nrPedido);
				if($obsItens != ''){
					$observacao = $observacao . PHP_EOL . trim($obsItens);
				}

				$update = 'UPDATE pedido SET '.
							' Observacao = "'.UpperDados($observacao).'", '.
							' Status = "'.$situacao.'", '.
							' Estoque = "'.$estoquePedido.'" '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nrPedido.'"';
				consulta_sql($update);
				if($liberarPedido){
					//liberar_pedido($nrPedido);
				}
			}

			$totalPedidosImportados++;
		}

		return $totalPedidosImportados;
	}
	
?>