<?php
	require_once('../../includes/funcoes/importacao.php');
	require_once('../../includes/funcoes/formatacao_valor.php');

	function echo_pa($grupo = "", $mensagem = ""){
		if($grupo == 'titulo'){
			echo '<font size="2" face="Verdana"><b>'.$mensagem.'</b></font><br>';
		}else if($grupo == 'erro'){
			echo '<font size="1" face="Verdana"> ('.$mensagem.')</font><br>';
		}else if($grupo == 'concluido'){
			if($mensagem == ""){
				$mensagem = "Concludo";
			}
			echo '<font size="1" face="Verdana"> <b> - '.$mensagem.'</b></font><br><br>';
		}else{
			echo '<font size="1" face="Verdana"> - '.$mensagem.'</font><br>';
		}
		flush(); @ob_flush();
		flush(); @ob_flush();
	}

	function utc_to_timestamp($data_utc){
		//$data_utc = 'Thu, 20 Apr 2017 11:19:33 GMT'
		$data_utc = trim($data_utc);
		$date = strtotime($data_utc);
		return date("Y-m-d H:i:s", $date);
	}

	function url_apos($url){
		return str_replace(' ', '%20', $url);
	}

	function busca_ultima_alteracao($funcao){
		$consulta = 'SELECT IFNULL(MAX(data), "0000-00-00 00:00:00") as data FROM sync '.
					' WHERE dominio = "'.$_SESSION["Dominio"].'" '.
					' AND empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND funcao = "'.$funcao.'"'.
					' AND isSucesso = "1"';
		$resultado = consulta_sql($consulta);
		$registro = consulta_ler_objeto($resultado);
		consulta_limpa($resultado);
		return $registro->data;
	}

	function atualiza_ultima_alteracao($funcao){
		$retorno = true;
		$con_max = 'SELECT IFNULL(MAX(id), "0") as id FROM sync '.
					' WHERE dominio = "'.$_SESSION["Dominio"].'" '.
					' AND empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND funcao = "'.$funcao.'"'.
					' AND isSucesso = "0"';
		$res_max = consulta_sql($con_max);
		$reg_max = consulta_ler_objeto($res_max);
		consulta_limpa($res_max);
		if($reg_max->id > 0){
			$consulta = 'UPDATE sync SET '.
						' isSucesso = "1" '.
						' WHERE id = "'.$reg_max->id.'"';
			$retorno = consulta_sql($consulta);
		}
		return $retorno;
	}

	function insere_ultima_alteracao($funcao, $http_code){
		$sucesso = '0';
		if($http_code == 200){
			$sucesso = '1';
		}
		$insert = 'INSERT INTO sync ( '.
					' dominio, '.
					' empresa, '.
					' funcao, '.
					' isSucesso, '.
					' data '.
					' ) VALUES ( '.
					' "'.$_SESSION["Dominio"].'", '.
					' "'.$_SESSION["Empresa_Codigo"].'", '.
					' "'.$funcao.'", '.
					' "'.$sucesso.'", '.
					' now() '.
					' ) ';
		return consulta_sql($insert);
	}

	function is_multi_array($array){
		return (count($array) != count($array, 1));
	}

	function is_timestamp($date){
		if((substr($date,4,1) == "-") && (substr($date,7,1) == "-") && (substr($date,13,1) == ":") && (substr($date,16,1) == ":")){
			$retorno = true;
		}else{
			$retorno = false;
		}
		return $retorno;
	}

	function mostra_retorno($dados){
		$mensagem = $dados['msg'];
		if($dados['success']){
			echo_pa('', $mensagem);
		}else if((!$dados['success']) && (!empty($dados['errors']))){
			$mensagem.= '<br>';
			foreach($dados['errors'] as $key => $value){
				$mensagem.= $key.' - '.$value.'<br>';
			}
			echo_pa('erro', $mensagem);
		}else{
			echo_pa('erro', 'Erro desconhecido!');
			var_dump2($dados);
		}
	}

	function valida_conexao(){
		$valida = busca_dados_pa('categorias');
		if($valida['status'] == '200'){
			$retorno = true;
		}else{
			$retorno = false;
		}
		return $retorno;
	}

	function busca_dados_pa($entidade = "",$id = ""){
		$dados = array();
		$host = BuscaParam('MP_HOST');
		$application_token = BuscaParam('MP_ATOKEN');
		$company_token = BuscaParam('MP_CTOKEN');

		$header = array(
						"Cache-Control: no-cache",
						"ApplicationToken: ".$application_token,
						"CompanyToken: ".$company_token
					);
		//echo $host.$entidade
		$ch = curl_init($host.$entidade);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
		curl_setopt($ch, CURLOPT_HTTPGET, true);
		curl_setopt($ch, CURLOPT_HEADER , 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
		$response = curl_exec($ch);
		$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($response, 0, $header_size);
		$body = substr($response, $header_size);
		//var_dump2($header);
		if(!$body){
			die('Error: "' . curl_error($ch) . '" - Code: ' . curl_errno($ch));
		}
		curl_close($ch);
		$retorno['header'] = $header;
		$retorno['body'] = json_decode($body,true);
		$retorno['status'] = $http_code;
		if(strpos($header, 'MEUSPEDIDOS_LIMITOU_REGISTROS') !== false){
			$alterado_apos = busca_ultima_alteracao($retorno['body']);
			$nova_consulta = busca_dados_pa($entidade, "", $alterado_apos);
			$retorno['body'] = array_merge($retorno['body'], $nova_consulta['body']);
		}
		/* if(!empty($retorno['body'])){
		atualiza_param_alteracao($entidade, busca_ultima_alteracao($retorno['body']));
		} */
		return $retorno;
	}

	function insere_dados_pa($entidade = "", $dados){
		$host = BuscaParam('PA_HOST');
		$x_auth_token = BuscaParam('PA_X_AUTH_TOKEN');
		$mp_id = 0;
		$meus_pedidos_url = "";
		$ultima_alteracao = "";
		$retorno = false;
		$header_post = array(
							//"Cache-Control: no-cache",
							"Content-Type:application/json",
							"X-AUTH-TOKEN: ".$x_auth_token
						);

		$postData = $dados;
		$postDataJson = json_encode($postData);
		$postUrl = $host.$entidade;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $postUrl);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_post);
		curl_setopt($ch, CURLOPT_HEADER , 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST' );
		//curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);
		$response = curl_exec($ch);
		$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($response, 0, $header_size);
		$header_arr = explode(PHP_EOL, $header);
		$body = substr($response, $header_size);
		$body = json_decode($body,true);
		//var_dump2($header_arr);
		//var_dump2($body);
		insere_ultima_alteracao($entidade, $http_code);
		return array(
						'http_code' => $http_code,
						'body' => $body
					);
	}

	function atualiza_dados_pa($entidade, $id, $dados){
		$host = BuscaParam('MP_HOST');
		$application_token = BuscaParam('MP_ATOKEN');
		$company_token = BuscaParam('MP_CTOKEN');
		$ultima_alteracao = "";
		$retorno = false;
		$header_put = array(
							"Cache-Control: no-cache",
							"Content-Type:application/json",
							"ApplicationToken: ".$application_token,
							"CompanyToken: ".$company_token
						);
		//$dados['local'] so parmetros/dados locais, que sero usados no bd do $imples Web
		//$dados['mp'] so parmetros/dados que iro ser usados na API externa
		$postData = $dados['mp'];
		$postDataJson = json_encode($postData);
		$postUrl = $host.$entidade.'/'.$id;
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $postUrl);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $header_put);
		curl_setopt($ch, CURLOPT_HEADER , 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT' );
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postDataJson);
		$response = curl_exec($ch);
		$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$header = substr($response, 0, $header_size);
		$body = substr($response, $header_size);
		$body = json_decode($body, true);
		$header_arr = explode(PHP_EOL, $header);
		//var_dump2($header);
		//var_dump2($body);
		if($http_code == '200'){
			foreach($header_arr as $header_val){
				if(strpos($header_val,'Date') !== false) {
					$ultima_alteracao = trim(substr($header_val, 5));
				}
			}
			$retorno = atualiza_param_alteracao($entidade, $ultima_alteracao);
		}else if($http_code == '404'){
			if(isset($body['mensagem'])){
				$retorno['404'] = $body['mensagem'];
			}
		}else{
			if(isset($body['erros'])){
				$retorno['erros'] = $body['erros'];
			}
		}
		return $retorno;
	}

	function busca_dados_transp_local($pessoa){
		$mp_transp = array();
		$telefones = array();
		$observacoes = array();
		$con_nome = 'SELECT Nome_Razao '.
					' FROM pessoa '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
					' AND Pessoa = "'.$pessoa.'"'.
					' AND Situacao = "A"';
		$res_nome = consulta_sql($con_nome);
		$reg_nome = consulta_ler_objeto($res_nome);
		consulta_limpa($res_nome);
		$con_endereco = 'SELECT UF, Nome_Cidade '.
						' FROM pessoa_endereco '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Pessoa = "'.$pessoa.'"'.
						' AND Seq_Endereco = "1"'.
						' AND Situacao = "A"';
		$res_endereco = consulta_sql($con_endereco);
		$reg_endereco = consulta_ler_objeto($res_endereco);
		consulta_limpa($res_endereco);
		$mp_transp['nome']=utf8_encode_si($reg_nome->Nome_Razao);
		$mp_transp['cidade']=utf8_encode_si($reg_endereco->Nome_Cidade);
		$mp_transp['estado']=$reg_endereco->UF;
		$con_obs = 'SELECT Observacao '.
					' FROM pessoa_obs '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
					' AND Pessoa = "'.$pessoa.'"'.
					' AND Situacao <> "E"'.
					' ORDER BY Seq_Obs';
		$res_obs = consulta_sql($con_obs);
		$nrw_obs = consulta_num_registros($res_obs);
		for($ob=0;$ob<$nrw_obs;$ob++){
			$reg_obs = consulta_ler_objeto($res_obs);
			$observacoes[$ob] = $reg_obs->Observacao;
		}
		consulta_limpa($res_obs);
		$mp_transp['informacoes_adicionais']=utf8_encode_si(implode(';',$observacoes));
		$con_telefone = 'SELECT Numero_Telefone '.
						' FROM pessoa_telefone '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Pessoa = "'.$pessoa.'"'.
						' AND Situacao = "A"'.
						' ORDER BY Seq_Telefone';
		$res_telefone = consulta_sql($con_telefone);
		$nrw_telefone = consulta_num_registros($res_telefone);
		for($tl=0;$tl<$nrw_telefone;$tl++){
			$reg_telefone = consulta_ler_objeto($res_telefone);
			$telefones[$tl]['numero'] = $reg_telefone->Numero_Telefone;
		}
		consulta_limpa($res_telefone);
		$mp_transp['telefones']=$telefones;
		//$mp_transp['excluido']=false;
		return $mp_transp;
	}

	function busca_dados_cli_local($pessoa){
		$mp_cli = array();
		$telefones = array();
		$observacoes = array();
		$contatos = array();
		$con_pessoa = 'SELECT Nome_Razao, Nome_Fantasia, Tipo_Pessoa, CPF_CNPJ, EMail, Situacao '.
						' FROM pessoa '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Pessoa = "'.$pessoa.'"';
						//' AND Situacao = "A"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_objeto($res_pessoa);
		consulta_limpa($res_pessoa);
		$mp_cli['razao_social']=utf8_encode_si($reg_pessoa->Nome_Razao);
		$mp_cli['nome_fantasia']=utf8_encode_si($reg_pessoa->Nome_Fantasia);
		if($reg_pessoa->Tipo_Pessoa != "J"){
			$tipo = "F";
		}else{
			$tipo = "J";
		}
		$mp_cli['tipo']=$tipo;
		if($reg_pessoa->Situacao == "A"){
			$mp_cli['cnpj']=limpa_numero($reg_pessoa->CPF_CNPJ);
			$con_endereco = 'SELECT UF, Nome_Cidade, Insc_Estadual, Insc_SUFRAMA, Logradouro, Complemento, Bairro, CEP, Numero '.
							' FROM pessoa_endereco '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
							' AND Pessoa = "'.$pessoa.'"'.
							' AND Seq_Endereco = "1"'.
							' AND Situacao = "A"';
			$res_endereco = consulta_sql($con_endereco);
			$reg_endereco = consulta_ler_objeto($res_endereco);
			consulta_limpa($res_endereco);
			$mp_cli['inscricao_estadual']=utf8_encode_si($reg_endereco->Insc_Estadual);
			$mp_cli['suframa']=utf8_encode_si($reg_endereco->Insc_SUFRAMA);
			$mp_cli['rua']=utf8_encode_si($reg_endereco->Logradouro.", ".$reg_endereco->Numero);
			$mp_cli['complemento']=utf8_encode_si($reg_endereco->Complemento);
			$mp_cli['bairro']=utf8_encode_si($reg_endereco->Bairro);
			$mp_cli['cep']=limpa_numero($reg_endereco->CEP);
			$mp_cli['cidade']=utf8_encode_si($reg_endereco->Nome_Cidade);
			$mp_cli['estado']=$reg_endereco->UF;
			$con_obs = 'SELECT Observacao '.
						' FROM pessoa_obs '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Pessoa = "'.$pessoa.'"'.
						' AND Situacao <> "E"'.
						' ORDER BY Seq_Obs';
			$res_obs = consulta_sql($con_obs);
			$nrw_obs = consulta_num_registros($res_obs);
			for($ob=0;$ob<$nrw_obs;$ob++){
				$reg_obs = consulta_ler_objeto($res_obs);
				$observacoes[$ob] = $reg_obs->Observacao;
			}
			consulta_limpa($res_obs);
			$mp_cli['observacao'] = utf8_encode_si(implode(';', $observacoes));
			if($reg_pessoa->EMail != ""){
				$email = filter_var($reg_pessoa->EMail, FILTER_SANITIZE_EMAIL);
				if(!filter_var($email, FILTER_VALIDATE_EMAIL) === false){
					$mp_cli['emails'][0]['email']=utf8_encode_si($email);
				}
			}
			$con_telefone = 'SELECT Numero_Telefone '.
							' FROM pessoa_telefone '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
							' AND Pessoa = "'.$pessoa.'"'.
							' AND Situacao = "A"'.
							' ORDER BY Seq_Telefone';
			$res_telefone = consulta_sql($con_telefone);
			$nrw_telefone = consulta_num_registros($res_telefone);
			for($tl=0;$tl<$nrw_telefone;$tl++){
				$reg_telefone = consulta_ler_objeto($res_telefone);
				$telefones[$tl]['numero'] = $reg_telefone->Numero_Telefone;
			}
			consulta_limpa($res_telefone);
			$mp_cli['telefones']=$telefones;
			/* $con_contato = 'SELECT Nome, Tipo_Contato, EMail, Numero_Telefone '.
			' FROM pessoa_contato '.
			' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
			' AND Pessoa = "'.$pessoa.'"'.
			' AND Situacao = "A"'.
			' ORDER BY Seq_Contato';
			$res_contato = consulta_sql($con_contato);
			$nrw_contato = consulta_num_registros($res_contato);

			for($ct=0;$ct<$nrw_contato;$ct++){
			$reg_contato = consulta_ler_objeto($res_contato);
			$contatos[$ct]['nome']=utf8_encode_si($reg_contato->Nome);

			$con_cargo = 'SELECT Descricao '.
			' FROM tipo_contato '.
			' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
			' AND Codigo_Tipo_Contato = "'.$reg_contato->Tipo_Contato.'"'.
			' AND Situacao = "A"';
			$res_cargo = consulta_sql($con_cargo);
			$reg_cargo = consulta_ler_objeto($res_cargo);
			consulta_limpa($res_cargo);

			$contatos[$ct]['cargo']=utf8_encode_si($reg_cargo->Descricao);
			if($reg_contato->EMail != ""){
			$email = filter_var($reg_contato->EMail, FILTER_SANITIZE_EMAIL);
			if(!filter_var($email, FILTER_VALIDATE_EMAIL) === false){
			$contatos[$ct]['emails'][0]['email']=utf8_encode_si($email);
			}
			}
			$contatos[$ct]['telefones'][0]['numero']=$reg_contato->Numero_Telefone;
			}
			consulta_limpa($res_contato);

			$mp_cli['contatos']=$contatos; */
		}else{
			$mp_cli['excluido']=true;
		}
		return $mp_cli;
	}

	function busca_dados_prod_local($id_produto){
		$pa_prod = array();
		$con_prod = 'SELECT * '.
					' FROM produtos_android '.
					' WHERE dominio="'.$_SESSION["Dominio"].'" '.
					' AND id = "'.$id_produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_objeto($res_prod);
		consulta_limpa($res_prod);
		$pa_prod['id_erp']=$reg_prod->id;
		$pa_prod['descricao']=utf8_encode_si($reg_prod->descricao);
		$pa_prod['referencia']=utf8_encode_si($reg_prod->referencia);
		$pa_prod['codigo_barras']=utf8_encode_si($reg_prod->codigo_barras);
		$pa_prod['codigo_interno']=utf8_encode_si($reg_prod->codigo_interno);
		$pa_prod['codigo_fabrica']=utf8_encode_si($reg_prod->codigo_interno);
		$pa_prod['referencia']=utf8_encode_si($reg_prod->referencia);
		$pa_prod['referencia']=utf8_encode_si($reg_prod->referencia);
		$pa_prod['preco_tabela']=number_format($reg_prod->Preco_Venda1, 2, '.', '');
		$pa_prod['st']=null;
		$pa_prod['grade_cores']=null;
		$pa_prod['grade_tamanhos']=null;
		$pa_prod['moeda']='0'; //Real ("0"), Dolar ("1") ou Euro ("2").
		$pa_prod['unidade']=$reg_prod->Unidade_Venda;
		$pa_prod['saldo_estoque']=number_format($reg_prod->Estoque_Atual, 2, '.', '');
		$pa_prod['observacoes']=utf8_encode_si($reg_prod->Descricao_Detalhada);
		if($reg_prod->Situacao == "A"){
			$ativo = true;
		}else{
			$ativo = false;
		}
		$pa_prod['ativo']=$ativo;
		if($reg_prod->Situacao == "E"){
			$pa_prod['excluido']=true;
		}
		$con_depart = 'SELECT Id_MP '.
						' FROM produto_departamento '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Codigo_Depart = "'.$reg_prod->Codigo_Depart.'"'.
						' AND Situacao = "A"';
		$res_depart = consulta_sql($con_depart);
		$reg_depart = consulta_ler_objeto($res_depart);
		consulta_limpa($res_depart);
		if($reg_depart->Id_MP > 0){
			$pa_prod['categoria_id']=$reg_depart->Id_MP;
		}
		return $pa_prod;
	}

	function inserir_atualizar_cliente_local($dados, $pessoa = ""){
		$atualizar = false;
		$inserir = false;
		$retorno = array();
		if($pessoa != ""){
			$atualizar = true;
		}else{
			$inserir = true;
		}
		if($atualizar){
			$situacao = "A";
			if($dados['excluido']){
				$situacao = "I";
				$dados['id'] = 0;
			}
			$update = 'UPDATE t_pessoa SET'.
						' Nome_Razao="'.UpperDados(utf8_decode_si($dados['razao_social'])).'", '.
						' Nome_Fantasia="'.UpperDados(utf8_decode_si($dados['nome_fantasia'])).'", '.
						' Nome_Listas="'.UpperDados(utf8_decode_si($dados['nome_fantasia'])).'", '.
						' Tipo_Pessoa="'.$dados['tipo'].'", '.
						' CPF_CNPJ="'.mcpf($dados['cnpj']).'", '.
						' EMail="'.utf8_decode_si($dados['emails'][0]['email']).'", '.
						' DataHora_Alteracao=now(), '.
						' Situacao="'.$situacao.'", '.
						' Id_Cli_MP="'.$dados['id'].'" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Pessoa = "'.$pessoa.'"';
			$retorno[] = consulta_sql($update);
			$upt_pessoa = 'UPDATE t_pessoa SET'.
						  ' Usuario_Alteracao  = "'.base64_decode_si($_SESSION["USER_ID"]).'"'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$pessoa.'"';
			consulta_sql($upt_pessoa,true,1);
		}
		if($inserir){
			//exclui os registros que por algum motivo j possuem o id do Meus Pedidos
			$update = 'UPDATE pessoa SET'.
					' Id_Cli_MP="0", '.
					' Situacao="I" '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Cli_MP = "'.$dados['id'].'"';
			$retorno[] = consulta_sql($update);
			$update = 'UPDATE t_pessoa SET'.
					' Id_Cli_MP="0", '.
					' Situacao="I" '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Cli_MP = "'.$dados['id'].'"';
			$retorno[] = consulta_sql($update);
			$con_max_pes = 'SELECT MAX(Pessoa) '.
					' FROM t_pessoa '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"';
			$res_max_pes = consulta_sql($con_max_pes);
			$reg_max_pes = consulta_ler_linha($res_max_pes);
			consulta_limpa($res_max_pes);
			$pessoa = ($reg_max_pes[0]+1);
			$insert = 'INSERT INTO t_pessoa ( '.
						' Dominio, '.
						' Pessoa, '.
						' Nome_Razao, '.
						' Nome_Fantasia, '.
						' Nome_Listas, '.
						' Tipo_Pessoa, '.
						' CPF_CNPJ, '.
						' EMail, '.
						' DataHora_Cadastro, '.
						' DataHora_Alteracao, '.
						' Liberado, '.
						' Situacao, '.
						' Cadastros, '.
						' Id_Cli_MP '.
						') '.
						' VALUES ( '.
						' "'.$_SESSION['Dominio'].'", '.
						' "'.$pessoa.'", '.
						' "'.UpperDados(utf8_decode_si($dados['razao_social'])).'", '.
						' "'.UpperDados(utf8_decode_si($dados['nome_fantasia'])).'", '.
						' "'.UpperDados(utf8_decode_si($dados['razao_social'])).'", '.
						' "'.$dados['tipo'].'", '.
						' "'.mcpf($dados['cnpj']).'", '.
						' "'.utf8_decode_si($dados['emails'][0]['email']).'", '.
						' now(), '.
						' now(), '.
						' "S", '.
						' "A", '.
						' "SNNNNNNNNN", '.
						' "'.$dados['id'].'" '.
						')';
			$retorno[] = consulta_sql($insert);
			$upt_pessoa = 'UPDATE t_pessoa SET'.
						  ' Usuario_Alteracao  = "'.base64_decode_si($_SESSION["USER_ID"]).'"'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$pessoa.'"';
			consulta_sql($upt_pessoa,true,1);
		}
		if(!$dados['excluido']){
			$con_cod_cid = 'SELECT Codigo_Cidade '.
							' FROM cidade '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND UF="'.$dados['estado'].'"'.
							' AND Nome="'.utf8_decode_si($dados['cidade']).'"'.
							' AND Situacao="A"';
			$res_cod_cid = consulta_sql($con_cod_cid);
			$reg_cod_cid = consulta_ler_linha($res_cod_cid);
			consulta_limpa($res_cod_cid);
			$log_num = explode(',', $dados['rua']);
			$logradouro = trim($log_num[0]);
			$numero = trim($log_num[1]);
			if(($dados['estado'] != "") && ($dados['cidade'] != "") && ($dados['bairro'] != "")){
				$delete = 'DELETE FROM t_pessoa_endereco'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Pessoa = "'.$pessoa.'"'.
							' AND Seq_Endereco = "1"';
				$retorno[] = consulta_sql($delete);
				$insert = 'INSERT INTO t_pessoa_endereco ( '.
							' Dominio, '.
							' Pessoa, '.
							' Seq_Endereco, '.
							' Tipo_Endereco, '.
							' CEP, '.
							' Codigo_Pais, '.
							' Nome_Pais, '.
							' UF, '.
							' Codigo_Cidade, '.
							' Nome_Cidade, '.
							' Bairro, '.
							' Logradouro, '.
							' Numero, '.
							' Complemento, '.
							' Insc_Estadual, '.
							' Insc_SUFRAMA, '.
							' Situacao '.
							') '.
							' VALUES ( '.
							' "'.$_SESSION['Dominio'].'", '.
							' "'.$pessoa.'", '.
							' "1", '.
							' "1", '.
							' "'.mcep($dados['cep']).'", '.
							' "1058", '.
							' "BRASIL", '.
							' "'.$dados['estado'].'", '.
							' "'.$reg_cod_cid[0].'", '.
							' "'.utf8_decode_si($dados['cidade']).'", '.
							' "'.utf8_decode_si($dados['bairro']).'", '.
							' "'.utf8_decode_si($logradouro).'", '.
							' "'.$numero.'", '.
							' "'.utf8_decode_si($dados['complemento']).'", '.
							' "'.utf8_decode_si($dados['inscricao_estadual']).'", '.
							' "'.utf8_decode_si($dados['suframa']).'", '.
							' "A" '.
							');';
				$retorno[] = consulta_sql($insert);
			}
			$delete = 'DELETE FROM t_pessoa_obs'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Pessoa = "'.$pessoa.'"';
			$retorno[] = consulta_sql($delete);
			if($dados['observacao'] != ""){
				$insert = 'INSERT INTO t_pessoa_obs ( '.
							' Dominio, '.
							' Pessoa, '.
							' Seq_Obs, '.
							' DataHora, '.
							' Observacao, '.
							' Situacao '.
							') '.
							' VALUES ( '.
							' "'.$_SESSION['Dominio'].'", '.
							' "'.$pessoa.'", '.
							' "1", '.
							' now(), '.
							' "'.utf8_decode_si($dados['observacao']).'", '.
							' "A" '.
							');';
				$retorno[] = consulta_sql($insert);
			}
			if(isset($dados['telefones'])){
				$delete = 'DELETE FROM t_pessoa_telefone'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Pessoa = "'.$pessoa.'"';
				$retorno[] = consulta_sql($delete);
				$seq_telefone = 1;
				foreach($dados['telefones'] as $telefone){
					$insert = 'INSERT INTO t_pessoa_telefone ( '.
								' Dominio, '.
								' Pessoa, '.
								' Seq_Telefone, '.
								' Tipo_Telefone, '.
								' Numero_Telefone, '.
								' Situacao '.
								') '.
								' VALUES ( '.
								' "'.$_SESSION['Dominio'].'", '.
								' "'.$pessoa.'", '.
								' "'.$seq_telefone.'", '.
								' "1", '.
								' "'.$telefone['numero'].'", '.
								' "A" '.
								');';
					$retorno[] = consulta_sql($insert);
					$seq_telefone++;
				}
			}
			/* if(isset($dados['contatos'])){
			$delete = 'DELETE FROM t_pessoa_contato'.
			' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
			' AND Pessoa = "'.$pessoa.'"';
			$retorno[] = consulta_sql($delete);
			$seq_contato = 1;
			foreach($dados['contatos'] as $contato){
			$insert = 'INSERT INTO t_pessoa_contato ( '.
			' Dominio, '.
			' Pessoa, '.
			' Seq_Contato, '.
			' Nome, '.
			' Tipo_Telefone, '.
			' Numero_Telefone, '.
			' EMail, '.
			' Situacao '.
			') '.
			' VALUES ( '.
			' "'.$_SESSION['Dominio'].'", '.
			' "'.$pessoa.'", '.
			' "'.$seq_contato.'", '.
			' "'.utf8_decode_si($contato['nome']).'", '.
			' "1", '.
			' "'.$contato['telefones'][0]['numero'].'", '.
			' "'.utf8_decode_si($contato['emails'][0]['email']).'", '.
			' "A" '.
			');';
			$retorno[] = consulta_sql($insert);
			$seq_contato++;
			}
			} */
			$delete = 'DELETE FROM t_pessoa_cliente'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Pessoa = "'.$pessoa.'"';
			$retorno[] = consulta_sql($delete);
			$insert = 'INSERT INTO t_pessoa_cliente ( '.
						' Dominio, '.
						' Pessoa, '.
						' Vendedor, '.
						' Situacao '.
						') '.
						' VALUES ( '.
						' "'.$_SESSION['Dominio'].'", '.
						' "'.$pessoa.'", '.
						' 1, '.
						' "A" '.
						');';
			$retorno[] = consulta_sql($insert);
		}
		//passa todas as informaes inseridas para as tabelas definitivas
		liberacao_pessoa($pessoa);
		atualiza_param_alteracao('clientes', $dados['ultima_alteracao']);
		if(in_array(false, $retorno)){
			return false;
		}else{
			return true;
		}
	}

	function inserir_pedido_local($dados){
		$retorno = "0";
		$ok = true;
		$con_ped = 'SELECT Numero_Pedido, Status,CRE '.
					' FROM pedido '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
					' AND Id_MP ="'.$dados['id'].'"';
		$res_ped = consulta_sql($con_ped);
		$nrw_ped = consulta_num_registros($res_ped);
		if($nrw_ped == 0){
			$con_max_ped = 'SELECT MAX(Numero_Pedido) '.
							' FROM pedido '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"';
			$res_max_ped = consulta_sql($con_max_ped);
			$reg_max_ped = consulta_ler_linha($res_max_ped);
			consulta_limpa($res_max_ped);

			$nr_pedido = ($reg_max_ped[0]+1);
			$cre = ($reg_max_ped[1]+1);
		}else{
			$reg_ped = consulta_ler_objeto($res_ped);
			if(($reg_ped->Status == "A") || ($reg_ped->Status == "L")){
				$nr_pedido = $reg_ped->Numero_Pedido;
				$cre = $reg_ped->CRE;
				$delete = 'DELETE FROM pedido'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($delete);
				$delete = 'DELETE FROM pedido_item'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($delete);
			}else{
				$ok = false;
			}
		}
		consulta_limpa($res_ped);
		if($ok){
			$insert = 'INSERT INTO pedido ( '.
						' Dominio, '.
						' Empresa, '.
						' Numero_Pedido, '.
						' DH_Emissao, '.
						' DH_Digitacao, '.
						' Status, CRE  '.
						') '.
						' VALUES ( '.
						' "'.$_SESSION['Dominio'].'", '.
						' "'.$_SESSION['Empresa_Codigo'].'", '.
						' "'.$nr_pedido.'", '.
						' now(), '.
						' now(), '.
						' "E", '.
						' "'.$cre.'" '.
						');';
			consulta_sql($insert);

			$con_pes = 'SELECT Pessoa FROM pessoa'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Cli_MP="'.$dados['cliente_id'].'"';
			$res_pes = consulta_sql($con_pes);
			$reg_pes = consulta_ler_linha($res_pes);
			consulta_limpa($res_pes);

			$pessoa = $reg_pes[0];

			$tipo_pedido = BuscaParam('TIPO_PEDIDO');

			$dt_validade = BuscaParam('VALIDADE_PAD');
			if($dt_validade <= 0){
				$dt_validade = '';
			}else{
				$dt_validade = datad(nr2data($dt_validade + data_atual()));
			}

			//$vendedor_get = busca_dados_mp("usuarios", $dados['vendedor_id'], "");
			$vendedor_get = busca_dados_pa("usuarios", $dados['criador_id'], "");
			$vendedor_mp = $vendedor_get['body'];

			$con_vend = 'SELECT Pessoa FROM pessoa'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND substr(Cadastros,3,1)="S"'.
						' AND EMail="'.$vendedor_mp['email'].'"'.
						' LIMIT 1';
			$res_vend = consulta_sql($con_vend);
			$nrw_vend = consulta_num_registros($res_vend);

			if($nrw_vend > 0){
				$reg_vend = consulta_ler_linha($res_vend);
				$vendedor = $reg_vend[0];
			}else{
				$vendedor = vendedor_cliente($pessoa);
			}
			consulta_limpa($res_vend);

			if($vendedor == 0){
				$vendedor = 1;
			}

			$con_transp = 'SELECT Pessoa FROM pessoa'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Transp_MP="'.$dados['transportadora_id'].'"';
			$res_transp = consulta_sql($con_transp);
			$reg_transp = consulta_ler_linha($res_transp);
			$transportadora = $reg_transp[0];
			consulta_limpa($res_transp);

			$con_pagto = 'SELECT Codigo_Pagto FROM forma_pagto'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_MP="'.$dados['forma_pagamento_id'].'"';
			$res_pagto = consulta_sql($con_pagto);
			$reg_pagto = consulta_ler_linha($res_pagto);
			$forma_pagto = $reg_pagto[0];
			consulta_limpa($res_pagto);

			$update = 'UPDATE pedido SET'.
						' Pessoa="'.$pessoa.'", '.
						//' DH_Emissao="'.$dados['data_emissao'].' '.nr2hora(hora_atual()).'", '.
						' Forma_Pagto="'.$forma_pagto.'", '.
						' Tipo_Pedido="'.$tipo_pedido.'", '.
						' DT_Validade="'.$dt_validade.'", '.
						' Vendedor="'.$vendedor.'", '.
						' Observacao="'.utf8_decode_si($dados['observacoes']).'", '.
						' Transportadora="'.$transportadora.'", '.
						' Id_MP="'.$dados['id'].'" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($update);

			$erro_item = false;

			//insero dos itens do pedido
			foreach($dados['items'] as $item){
				if(!$erro_item){
					if(!$item['excluido']){
						$con_prod = 'SELECT Id_Produto FROM produto'.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND Id_MP="'.$item['produto_id'].'"';
						$res_prod = consulta_sql($con_prod);
						$nrw_prod = consulta_num_registros($res_prod);
						if($nrw_prod > 0){
							$reg_prod = consulta_ler_linha($res_prod);
							consulta_limpa($res_prod);
							$id_produto = $reg_prod[0];
							$con_seq = 'SELECT MAX(Seq_Item) FROM pedido_item '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Numero_Pedido="'.$nr_pedido.'"';
							$res_seq = consulta_sql($con_seq);
							$reg_seq = consulta_ler_linha($res_seq);
							consulta_limpa($res_seq);
							$seq_item = ($reg_seq[0] + 1);
							$con_ins = 'INSERT INTO pedido_item ('.
										' Dominio, '.
										' Empresa, '.
										' Numero_Pedido, '.
										' Seq_Item, '.
										' ID_Produto, '.
										' Qtd, '.
										' Valor_Unitario, '.
										' Valor_Total, '.
										' Obs, '.
										' Status '.
										' ) '.
										' VALUES ( '.
										' "'.$_SESSION["Dominio"].'",'.
										' "'.$_SESSION["Empresa_Codigo"].'", '.
										' "'.$nr_pedido.'", '.
										' "'.$seq_item.'", '.
										' "'.$id_produto.'", '.
										' "'.$item['quantidade'].'", '.
										' "'.$item['preco_liquido'].'", '.
										' "'.$item['subtotal'].'", '.
										' "'.utf8_decode_si($item['observacoes']).'", '.
										' "A" '.
										' )';
							consulta_sql($con_ins);
						}else{
							$erro_item = true;
							var_dump2($item);
						}
					}
				}
			}
			if(!$erro_item){
				$update = 'UPDATE pedido SET'.
							' Status="L" '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"';
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($update);
				pedido_recalculo($nr_pedido);
				liberar_pedido($nr_pedido);
				$retorno = $nr_pedido;
			}else{
				//caso ocorra erro no item, excluir o que j foi cadastrado do pedido
				$delete = 'DELETE FROM pedido '.
							' WHERE Dominio='.$_SESSION['Dominio'].' '.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido="'.$nr_pedido.'"';
				consulta_sql($delete);
				$delete = 'DELETE FROM pedido_item '.
							' WHERE Dominio='.$_SESSION['Dominio'].' '.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido="'.$nr_pedido.'"';
				consulta_sql($delete);
				$retorno='-1';
			}
		}
		return $retorno;
	}

	function img_to_base64($url){
		return base64_encode(file_get_contents($url));
	}

	function integracao_meus_pedidos($envia_basicos){
		set_time_limit(0);
		$valida_conexao = valida_conexao();
		if($valida_conexao){
			$totais['grupos'] = 0;
			$totais['forma_pagamento'] = 0;
			$totais['unidades_medida']= 0 ;
			$totais['clientes_atualizados'] = 0;
			$totais['clientes_inseridos']= 0 ;
			$totais['produtos_atualizados'] = 0;
			$totais['produtos_inseridos'] = 0;
			$totais['imagens_produto'] = 0;
			$totais['pedidos'] = 0;
			$arr_depart = array();
			$arr_condpag = array();
			$arr_unidmed = array();
			$ok = true;
			$retorno = "";
			$advertencias = 0;
			//<grupos>
			if($envia_basicos){
				if($ok){
					echo_pa('titulo', 'Grupos');

					$con_prod_depart = 'SELECT Codigo_Depart, Descricao FROM produto_departamento '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Situacao = "A"'.
					' ORDER BY Codigo_Depart';
					$res_prod_depart = consulta_sql($con_prod_depart);
					$nrw_prod_depart = consulta_num_registros($res_prod_depart);
					for($ct=0; $ct<$nrw_prod_depart; $ct++){
						$reg_prod_depart = consulta_ler_objeto($res_prod_depart);
						$arr_depart[$ct] = array(
												'id_erp' => $reg_prod_depart->Codigo_Depart,
												'descricao' => utf8_encode_si($reg_prod_depart->Descricao)
											);
					}
					$insere = insere_dados_pa('grupos/enviar_grupos', $arr_depart);
					$http_code = $insere['http_code'];
					$dados = $insere['body'];
					mostra_retorno($dados);
					if($http_code == 200){
						$totais['grupos'] = $nrw_prod_depart;
					}else{
						$advertencias++;
						//$mensagem = "<span style='color:black'>Categoria '".$reg_prod_depart->Codigo_Depart." - ".$reg_prod_depart->Descricao."' inserida com sucesso!</span>";
						//echo_pa('categorias', $mensagem);
					}
					consulta_limpa($res_prod_depart);
					echo_pa('concluido', 'Concludo ('.$totais['grupos'].')');
				}
				//</grupos>
				//<formas_pagamento>
				if($ok){
					echo_pa('titulo', 'Formas de Pagamento');
					//Verificando se h Condies de Pagamento para enviar.
					$con_pagto = 'SELECT Codigo_Pagto, Descricao, Status '.
					' FROM forma_pagto '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
					//' AND Status = "A"'.
					' AND IntegradoUp = "N"'.
					' ORDER BY Codigo_Pagto';
					$res_pagto = consulta_sql($con_pagto);
					$nrw_pagto = consulta_num_registros($res_pagto);
					for($fp=0; $fp<$nrw_pagto; $fp++){
						$reg_pagto = consulta_ler_objeto($res_pagto);
						$arr_condpag[$reg_pagto->Codigo_Pagto] = array(
																		'id_erp' => $reg_pagto->Codigo_Pagto,
																		'descricao' => utf8_encode_si($reg_pagto->Descricao),
																		'is_ativo' => $reg_pagto->Status == 'A' ? true : false
																	);
					}
					$insere = insere_dados_pa('condicoes_pagamento/enviar_condicoes_pagamento', $arr_condpag);
					$http_code = $insere['http_code'];
					$dados = $insere['body'];
					mostra_retorno($dados);
					if($http_code == 200){
						$totais['forma_pagamento'] = $nrw_pagto;
						//atualiza IntegradoUp
						foreach($arr_condpag as $key => $value){
							$update = 'UPDATE forma_pagto SET '.
										' IntegradoUp = "S"'.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										' AND Codigo_Pagto = "'.$key.'"';
							consulta_sql($update);
						}
					}else{
						$advertencias++;
					}
					consulta_limpa($res_pagto);
					echo_pa('concluido', 'Concludo ('.$totais['forma_pagamento'].')');
				}
				//</formas_pagamento>

				//<unidades_medida>
				if($ok){
					echo_pa('titulo', 'Unidades de Medida');
					//Verificando se h Unidades de Medida para enviar.
					$con_unid = 'SELECT Unidade, Unidade as Sigla, Descricao, '.
								' case when unidade_medida.decimais > 0 then 1 else 0 '.
								' end as isFracionario '.
								' FROM unidade_medida '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' ORDER BY Unidade';
					$res_unid = consulta_sql($con_unid);
					$nrw_unid = consulta_num_registros($res_unid);
					for($un=0; $un<$nrw_unid; $un++){
						$reg_unid = consulta_ler_objeto($res_unid);
						$arr_unidmed[$reg_unid->Unidade] = array(
																'id_erp' => $reg_unid->Unidade,
																'descricao' => utf8_encode_si($reg_unid->Descricao),
																'is_fracionario' => ($reg_unid->isFracionario > 0) ? true : false,
																'sigla' => $reg_unid->Sigla,
															);
					}
					$insere = insere_dados_pa('unidades_medida/enviar_unidades_medida', $arr_unidmed);
					$http_code = $insere['http_code'];
					$dados = $insere['body'];
					mostra_retorno($dados);
					if($http_code == 200){
						$totais['unidades_medida'] = $nrw_unid;                  
					}else{
						$advertencias++;
					}
					consulta_limpa($res_unid);
					echo_pa('concluido', 'Concludo ('.$totais['unidades_medida'].')');
				}
				//</unidades_medida>
			}else{
				//<transportadoras>
				if($ok){
					echo_pa('titulo', 'Transportadoras');
					$con_transp = 'SELECT Pessoa, Nome_Razao '.
									' FROM pessoa '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
									' AND Situacao = "A"'.
									' AND substr(Cadastros,5,1)="S" '.
									' AND Id_Transp_MP = 0'.
									' ORDER BY Pessoa';
					$res_transp = consulta_sql($con_transp);
					$nrw_transp = consulta_num_registros($res_transp);
					for($tp=0; $tp<$nrw_transp; $tp++){
						if($ok){
							$reg_transp = consulta_ler_objeto($res_transp);
							$mp_transp = busca_dados_transp_local($reg_transp->Pessoa);
							$inserir = insere_dados_pa('transportadoras', array(
																		'local'=>array('Pessoa'=>$reg_transp->Pessoa),
																		'mp'=>$mp_transp
																	));
							if(isset($inserir['erros'])){
								$ok = false;
								$mensagem = "<span style='color:red'>Transportadora '".$reg_transp->Pessoa." - ".$reg_transp->Nome_Razao."' no inserida!</span>";
								echo_pa('transportadoras', $mensagem);
								$advertencias++;
								foreach($inserir['erros'] as $erro){
									$mensagem = utf8_decode_si('"'.$erro['campo'].'" - '.$erro['mensagem']."");
									echo_pa('erro', $mensagem);
								}
							}else{
								$totais['transportadoras']++;
								$mensagem = "<span style='color:black'>Transportadora '".$reg_transp->Pessoa." - ".$reg_transp->Nome_Razao."' inserida com sucesso!</span>";
								echo_pa('transportadoras', $mensagem);
							}
						}
					}
					consulta_limpa($res_transp);
					echo_pa('concluido', 'Concludo ('.$totais['transportadoras'].')');
				}
				//</transportadoras>
				//<produtos>
				if($ok){
					$insere_ultima_alteracao = insere_ultima_alteracao('enviarProdutos',200);
					$pa_ultima_alteracao = busca_ultima_alteracao('enviarProdutos');
					$con_prod_ins = 'SELECT Id_Produto, Codigo_Produto, Descricao_Completa FROM produto '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
									' AND DH_Alteracao > "'.$pa_ultima_alteracao.'"'.
									' ORDER BY Id_Produto';
					$res_prod_ins = consulta_sql($con_prod_ins);
					$nrw_prod_ins = consulta_num_registros($res_prod_ins);
					for($cpi=0; $cpi<$nrw_prod_ins; $cpi++){
						if($ok){
							$reg_prod_ins = consulta_ler_objeto($res_prod_ins);
							$mp_prod_ins = busca_dados_prod_local($reg_prod_ins->Id_Produto);
							$inserir = insere_dados_pa('produtos', array(
																'local'=>array('Id_Produto'=>$reg_prod_ins->Id_Produto, 'Codigo_Produto'=>$reg_prod_ins->Codigo_Produto),
																'mp'=>$mp_prod_ins
															));
							if(isset($inserir['erros'])){
								$ok = false;
								$mensagem = "<span style='color:red'>Produto '".$reg_prod_ins->Codigo_Produto." - ".$reg_prod_ins->Descricao_Completa."' no inserido!</span>";
								echo_pa('produtos', $mensagem);
								$advertencias++;
								foreach($inserir['erros'] as $erro){
									$mensagem = utf8_decode_si('"'.$erro['campo'].'" - '.$erro['mensagem']."");
									echo_pa('erro', $mensagem);
								}
							}else{
								$totais['produtos_inseridos']++;
								$mensagem = "<span style='color:black'>Produto '".$reg_prod_ins->Codigo_Produto." - ".$reg_prod_ins->Descricao_Completa."' inserido com sucesso!</span>";
								echo_pa('produtos', $mensagem);
							}
						}
					}
					consulta_limpa($res_prod_ins);
					$atualiza_ultima_alteracao = atualiza_ultima_alteracao('enviarProdutos');
					echo_pa('concluido', 'Concludo ('.($totais['produtos_inseridos']+$totais['produtos_atualizados']).')');
				}
				//</produtos>
				//<clientes>
				if($ok){
					echo_pa('titulo', 'Clientes');
					$mp_cli_alteracao = BuscaParam('MP_CLI_ALTERACAO');
					$mp_cli_get = busca_dados_pa('clientes', "", $mp_cli_alteracao);
					if(!empty($mp_cli_get['body'])){
						foreach($mp_cli_get['body'] as $cliente){
							if($ok){
								$con_cli = 'SELECT Pessoa '.
											' FROM pessoa '.
											' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
											' AND CPF_CNPJ = "'.mcpf($cliente['cnpj']).'"';
											//' AND Situacao = "A"';
								$res_cli = consulta_sql($con_cli);
								$nrw_cli = consulta_num_registros($res_cli);
								if($nrw_cli > 0){
									$reg_cli = consulta_ler_objeto($res_cli);
									//se o segundo parmetro for passado acontecer a atualizao dos registros localmente
									$atualizar_local = inserir_atualizar_cliente_local($cliente, $reg_cli->Pessoa);
									//var_dump2($atualizar_local);
									if(!$atualizar_local){
										$ok = false;
										$mensagem = "<span style='color:red'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' no atualizado localmente!</span>";
										echo_pa('clientes', $mensagem);
										$advertencias++;
									}
								}else{
									if(!$cliente['excluido']){
										//se o segundo parmetro no for passado acontecer a insero dos registros localmente
										$inserir_local = inserir_atualizar_cliente_local($cliente);
										//var_dump2($inserir_local);
										if(!$inserir_local){
											$ok = false;
											$mensagem = "<span style='color:red'>Cliente '".$cliente['nome_fantasia']."' no inserido localmente!</span>";
											echo_pa('clientes', $mensagem);
											$advertencias++;
										}
									}
								}
								consulta_limpa($res_cli);
							}
						}
					}
				}
				if($ok){
					$mp_cli_alteracao = BuscaParam('MP_CLI_EXPORTA');
					$con_cli = 'SELECT Pessoa, Nome_Razao, Id_Cli_MP, DataHora_Alteracao '.
								' FROM pessoa '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
								' AND substr(Cadastros,1,1) = "S" '.
								' AND DataHora_Alteracao > "'.$mp_cli_alteracao.'"'.
								//' AND Id_Cli_MP > 0'.
								//' AND Situacao <> "I"'.
								' ORDER BY DataHora_Alteracao';
					$res_cli = consulta_sql($con_cli);
					$nrw_cli = consulta_num_registros($res_cli);
					for($cca=0; $cca<$nrw_cli; $cca++){
						if($ok){
							$reg_cli = consulta_ler_objeto($res_cli);
							if($reg_cli->Id_Cli_MP > 0){
								//atualizar no MP os registros alterados localmente aps a ltima alterao do MP
								$mp_cli_alt = busca_dados_cli_local($reg_cli->Pessoa);
								$atualizar = atualiza_dados_pa('clientes', $reg_cli->Id_Cli_MP, array(
																		'local'=>array('Pessoa'=>$reg_cli->Pessoa),
																		'mp'=>$mp_cli_alt
																	));
								if(isset($atualizar['erros'])){
									$ok = false;
									$mensagem = "<span style='color:red'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' no atualizado!</span>";
									echo_pa('clientes', $mensagem);
									$advertencias++;
									foreach($atualizar['erros'] as $erro){
										$mensagem = utf8_decode_si('"'.$erro['campo'].'" - '.$erro['mensagem']."");
										echo_pa('erro', $mensagem);
									}
								}else if(isset($atualizar['404'])){
									$ok = false;
									$mensagem = "<span style='color:red'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' no encontrado!</span>";
									echo_pa('clientes', $mensagem);
									$advertencias++;
									$mensagem = utf8_decode_si($atualizar['404']);
									echo_pa('erro', $mensagem);
								}else{
									$totais['clientes_atualizados']++;
									$mensagem = "<span style='color:black'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' atualizado com sucesso!</span>";
									echo_pa('clientes', $mensagem);
								}
							}else{
								//inserir no MP os novos registros cadastrados localmente
								$mp_cli_ins = busca_dados_cli_local($reg_cli->Pessoa);

								$inserir = insere_dados_pa('clientes', array(
																	'local'=>array('Pessoa'=>$reg_cli->Pessoa),
																	'mp'=>$mp_cli_ins
																));

								if(isset($inserir['erros'])){
									$ok = false;
									$mensagem = "<span style='color:red'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' no inserido!</span>";
									echo_pa('clientes', $mensagem);
									$advertencias++;
									foreach($inserir['erros'] as $erro){
										$mensagem = utf8_decode_si('"'.$erro['campo'].'" - '.$erro['mensagem']."");
										echo_pa('erro', $mensagem);
									}
								}else{
									$totais['clientes_inseridos']++;
									$mensagem = "<span style='color:black'>Cliente '".$reg_cli->Pessoa." - ".$reg_cli->Nome_Razao."' inserido com sucesso!</span>";
									echo_pa('clientes', $mensagem);
								}
							}
							$mp_cli_alteracao = $reg_cli->DataHora_Alteracao;
						}
					}
					consulta_limpa($res_cli);
					$upt_cadastro = 'UPDATE param SET '.
									' Conteudo = "'.$mp_cli_alteracao.'" '.
									' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
									' AND Chave = "MP_CLI_EXPORTA"';
					$retorno = consulta_sql($upt_cadastro);
					//atualizar parametro
				}
				//</clientes>
				//<pedidos>
				if($ok){
					echo_pa('titulo', 'Pedidos');
					$mp_ped_alteracao = BuscaParam('MP_PED_ALTERACAO');
					$mp_ped_get = busca_dados_pa('pedidos', "", $mp_ped_alteracao);
					if(!empty($mp_ped_get['body'])){
						foreach($mp_ped_get['body'] as $pedido){
							if($ok){
								if($pedido['status'] == '2'){
									$pedido_local = inserir_pedido_local($pedido);
									if($pedido_local == "-1"){
										$ok = false;
										$mensagem = "<span style='color:red'>'".busca_nome_pedido_orc()." (".$pedido['numero'].") no inserido - Produto(s) invlidos!</span>";
										echo_pa('pedidos', $mensagem);
										$advertencias++;
									}else if($pedido_local == "0"){
										atualiza_param_alteracao('pedidos', $pedido['ultima_alteracao']);
										$mensagem = "<span style='color:orange'>'".busca_nome_pedido_orc()." (".$pedido['numero'].") no inserido - J cadastrado e fechado no sistema!</span>";
										echo_pa('pedidos', $mensagem);
										$advertencias++;
									}else{
										atualiza_param_alteracao('pedidos', $pedido['ultima_alteracao']);
										$totais['pedidos']++;
										$mensagem = "<span style='color:black'>'".busca_nome_pedido_orc().' "'.$pedido_local.'"'." inserido/atualizado com sucesso!</span>";
										echo_pa('pedidos', $mensagem);
									}
								}
							}
						}
					}
					echo_pa('concluido', 'Concludo ('.$totais['pedidos'].')');
				}
				//</pedidos>
			}
			if($ok){
				$retorno = "<br><span style='color:green'>Finalizado com sucesso!</span>";
			}else{
				$retorno = "<br><span style='color:orange'>Processo no finalizado!</span>";
			}
		}else{
			$retorno = "Falha na autenticao da API";
		}
		return $retorno;
	}
?>