<?
	require_once('../../includes/funcoes/importacao.php');
	require_once('../../includes/funcoes/formatacao_valor.php');

	function sint_bkp_arquivo($origem,$destino,$arquivo){
		//determina nome do arquivo de origem
		$arq_ori = $origem.'/'.$arquivo;
		//determina nome do arquivo de destino
		$arq_des = $destino.'/'.$arquivo;
		//verifica se arquivo de origem existe
		if (file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if (!(file_exists($destino))){
				//seno cria ela (ano_mes)
				rmkdir($destino."/",0777);
			}
			//verifica se destino existe
			if (file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);

			//se fez a copia corretamente
			if ($copiou){
				//apaga o arquivo de origem
				unlink($arq_ori);
				return true;
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	function pedido_integracao_sint(){
		//conectar magento
		echo '<font size="2" face="Verdana">Inciando processo de Importao..</font><BR>';
		flush(); @ob_flush();
		flush(); @ob_flush();
		$diretorio_cliente = BuscaParam('SINT_DIR_CLI').'\\';
		$diretorio_pedido = BuscaParam('SINT_DIR_PED').'\\';
		$nm_arquivo = 'CLIENTESEXPORTA.TXT';
		$diretorio_backup  = BuscaParam('SINT_DIR_BKP');
		$tamanho_codigo = 8;
		$arquivo_cliente = $diretorio_cliente.$nm_arquivo;
		if(file_exists($arquivo_cliente)){
			//pega arquivos de clients na pasta
			echo '<font size="2" face="Verdana">Importando Arquivo de Clientes (CLIENTESEXPORTA.TXT)...</font><BR>';
			flush(); @ob_flush();
			flush(); @ob_flush();

			$array_of_list_values = file($arquivo_cliente);
			foreach ($array_of_list_values as $list_value){
				//coloca na tabela sint_clientes
				$dados_clientes['Codigo_SINT']     = UpperDados(trim(substr($list_value,0,7)));
				$dados_clientes['Nome_Fantasia']   = UpperDados(trim(substr($list_value,7,20)));
				$dados_clientes['Codigo_Vendedor'] = UpperDados(trim(substr($list_value,27,5)));
				$dados_clientes['Nome_Razao']      = UpperDados(trim(substr($list_value,32,40)));
				$dados_clientes['CPF_CNPJ']        = UpperDados(trim(substr($list_value,73,18)));
				if ($dados_clientes['CPF_CNPJ']==''){
					$dados_clientes['CPF_CNPJ'] = '00.000.000/0000-00';
				}else if (substr($dados_clientes['CPF_CNPJ'],1,4)=='0000'){
					$dados_clientes['CPF_CNPJ']        = substr($list_value,72,11).substr($list_value,88,3);
				}
				if ($dados_clientes['Nome_Razao']==''){
					$dados_clientes['Nome_Razao'] = $dados_clientes['Nome_Fantasia'];
				}
				if ($dados_clientes['Nome_Fantasia']==''){
					$dados_clientes['Nome_Fantasia'] = $dados_clientes['Nome_Razao'];
				}
				$dados_clientes['Insc_Estadual']   = UpperDados(trim(substr($list_value,91,19)));
				$dados_clientes['Endereco']        = UpperDados(trim(substr($list_value,110,40)));
				$dados_clientes['Bairro']          = UpperDados(trim(substr($list_value,150,20)));
				$dados_clientes['Cidade']          = UpperDados(trim(substr($list_value,170,20)));
				$dados_clientes['UF']              = UpperDados(trim(substr($list_value,190,2)));
				$dados_clientes['CEP']             = UpperDados(trim(substr($list_value,192,9)));
				$dados_clientes['DDD']             = UpperDados(trim(substr($list_value,201,2)));
				$dados_clientes['Fone1']           = UpperDados(trim(substr($list_value,203,9)));
				$dados_clientes['Fone2']           = UpperDados(trim(substr($list_value,212,9)));
				$dados_clientes['Fax']             = UpperDados(trim(substr($list_value,221,9)));
				$dados_clientes['Contato']         = UpperDados(trim(substr($list_value,230,40)));
				$dados_clientes['Transportadora']  = UpperDados(trim(substr($list_value,270,20)));
				$dados_clientes['Observacao']      = UpperDados(trim(substr($list_value,290,20)));
				$dados_clientes['EMail']           = strtolower(UpperDados(trim(substr($list_value,310,40))));
				if ($dados_clientes['Fone1']!=''){
					$dados_clientes['Fone1'] = mtelefone($dados_clientes['DDD'].$dados_clientes['Fone1']);
				}
				if ($dados_clientes['Fone2']!=''){
					$dados_clientes['Fone2'] = mtelefone($dados_clientes['DDD'].$dados_clientes['Fone2']);
				}
				if ($dados_clientes['Fax']!=''){
					$dados_clientes['Fax'] = mtelefone($dados_clientes['DDD'].$dados_clientes['Fax']);
				}
				if ($dados_clientes['Bairro']==''){
					$dados_clientes['Bairro'] = 'CENTRO';
				}
				$ins_tmp = 'insert into sint_clientes '.
							'( Dominio, Codigo_SINT ) '.
							' VALUES ('.
							' "'.$_SESSION["Dominio"].'", '.
							' "'.$dados_clientes['Codigo_SINT'].'")';
							consulta_sql($ins_tmp);
				$upt_cadastro = 'Update sint_clientes set '.
								' Nome_Fantasia="'.$dados_clientes['Nome_Fantasia'].'", '.
								' Codigo_Vendedor="'.$dados_clientes['Codigo_Vendedor'].'", '.
								' Nome_Razao="'.$dados_clientes['Nome_Razao'].'", '.
								' CPF_CNPJ="'.$dados_clientes['CPF_CNPJ'].'", '.
								' Insc_Estadual="'.$dados_clientes['Insc_Estadual'].'", '.
								' Endereco="'.$dados_clientes['Endereco'].'", '.
								' Bairro="'.$dados_clientes['Bairro'].'", '.
								' Cidade="'.$dados_clientes['Cidade'].'", '.
								' UF="'.$dados_clientes['UF'].'", '.
								' CEP="'.$dados_clientes['CEP'].'", '.
								' DDD="'.$dados_clientes['DDD'].'", '.
								' Fone1="'.$dados_clientes['Fone1'].'", '.
								' Fone2="'.$dados_clientes['Fone2'].'", '.
								' Contato="'.$dados_clientes['Contato'].'", '.
								' Transportadora="'.$dados_clientes['Transportadora'].'", '.
								' Observacao="'.$dados_clientes['Observacao'].'", '.
								' EMail="'.$dados_clientes['EMail'].'" '.
								' where Dominio="'.$_SESSION["Dominio"].'" '.
								' and Codigo_SINT="'.$dados_clientes['Codigo_SINT'].'"';
				consulta_sql($upt_cadastro);
			}
			echo '<font size="2" face="Verdana">Importao do Arquivo de Clientes (CLIENTESEXPORTA.TXT) Finalizada!</font><BR>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			//coloca o arquivos de clientes no backup
			sint_bkp_arquivo($diretorio_cliente,$diretorio_backup,$nm_arquivo);
		}
		//busca arquivos de pedidos
		$diretorio = getDirList($diretorio_pedido);
		array_multisort($diretorio, SORT_ASC, SORT_REGULAR);
		$k = 0;
		$erros = 0;
		$acertos = 0;

		foreach($diretorio as $key => $arquivo){
			//para cada arquivo
			if ($arquivo != '.' && $arquivo != '..') {
				$arquivo_cliente = $diretorio_pedido.$arquivo;
				echo '<font size="2" face="Verdana">Importando Arquivo '.$arquivo.'...</font><BR>';
				flush(); @ob_flush();
				flush(); @ob_flush();
				$array_of_list_values = file($arquivo_cliente);
				$linha = 0;
				$itens = array();
				$nitem = 0;
				$pedido_com_erro = true;
				foreach ($array_of_list_values as $list_value){
					if ($linha==0){ //cabecalho
						//coloca dados na array do cabealho
						$dados_pedido['Numero_Pedido_SINT'] = UpperDados(trim(substr($list_value,1,7)));
						$dados_pedido['Versao_Fecha']       = UpperDados(trim(substr($list_value,8,3)));
						$dados_pedido['Cliente_SINT']       = UpperDados(trim(substr($list_value,11,7)));
						$dados_pedido['Data']               = UpperDados(trim(substr($list_value,18,8)));
						$dados_pedido['Hora']               = UpperDados(trim(substr($list_value,26,4)));
						$dados_pedido['Vendedor_SINT']      = UpperDados(trim(substr($list_value,30,5)));
						$dados_pedido['CondPagto']          = UpperDados(trim(substr($list_value,35,5)));
						$dados_pedido['Descto0']            = UpperDados(trim(substr($list_value,40,5)));
						$dados_pedido['Descto1']            = UpperDados(trim(substr($list_value,45,5)));
						$dados_pedido['Descto2']            = UpperDados(trim(substr($list_value,50,5)));
						$dados_pedido['Descto3']            = UpperDados(trim(substr($list_value,55,5)));
						$dados_pedido['Filial']             = UpperDados(trim(substr($list_value,60,6)));
						$dados_pedido['Codigo_Transp']      = UpperDados(trim(substr($list_value,66,3)));
						$dados_pedido['Nome_Transp']        = UpperDados(trim(substr($list_value,69,20)));
						$dados_pedido['Data_Prev']          = UpperDados(trim(substr($list_value,89,8)));
						if ($dados_pedido['Data_Prev']=='00002000'){
							$dados_pedido['Data_Prev'] = '';
						}
						if ($dados_pedido['Data_Prev']!=''){
							$data_rev = $dados_pedido['Data_Prev'];
							$data_rev = $data_rev[0].$data_rev[1].'/'.
										$data_rev[2].$data_rev[3].'/'.
										$data_rev[4].$data_rev[5].$data_rev[6].$data_rev[7];

							$dados_pedido['Data_Prev'] = datad($data_rev);
						}else{
							$dados_pedido['Data_Prev'] = '0000-00-00';
						}
						$dados_pedido['Data_Prev'].= ' 00:00:00';

						$data_rev = $dados_pedido['Data'];
						$data_rev = $data_rev[0].$data_rev[1].'/'.
									$data_rev[2].$data_rev[3].'/'.
									$data_rev[4].$data_rev[5].$data_rev[6].$data_rev[7];
						$hora_rev = $dados_pedido['Hora'];
									$hora_rev = $hora_rev[0].$hora_rev[1].':'.
									$hora_rev[2].$hora_rev[3].':00';

						$dados_pedido['data_emissao'] = datad($data_rev).' '.$hora_rev;

						$pedido_com_erro = false;

						//consulta pra saber o codigo da pessoa
						$con_cli_sint = 'select * from sint_clientes '.
										' where Dominio="'.$_SESSION["Dominio"].'" '.
										' and Codigo_SINT="'.$dados_pedido['Cliente_SINT'].'"';
						$res_cli_sint = consulta_sql($con_cli_sint);
						$reg_cli_sint = consulta_ler_objeto($res_cli_sint);
						consulta_limpa($res_cli_sint);
						$linha++;
						if ($reg_cli_sint->Codigo_SINT==''){
							$pedido_com_erro = true;
							echo '<font size="2" face="Verdana">Falha na Importao do Arquivo ('.$arquivo.'): Cliente '.$dados_pedido['Cliente_SINT'].' no localizado nos arquivos! Gere o arquivo de clientes (CLIENTESEXPORTA.TXT) para importar este pedido!</font><BR>';
							flush(); @ob_flush();
							flush(); @ob_flush();
						}else{
							if ($reg_cli_sint->Pessoa>0){
								$pessoa = $reg_cli_sint->Pessoa;
							}else{
								//cadastra no sistema o cliente
								//se pegou dados do cliente, atualiza dados do cliente
								$dados_pessoa['tpCod']='Correlacao';
								$dados_pessoa['tpRelacao'] = 'S';
								$dados_pessoa['cdPessoa'] = $reg_cli_sint->Codigo_SINT;
								$dados_pessoa['xRazao'] = $reg_cli_sint->Nome_Razao;
								$dados_pessoa['xFantasia'] = $reg_cli_sint->Nome_Fantasia;
								$dados_pessoa['xListas'] = $reg_cli_sint->Nome_Fantasia;
								$dados_pessoa['nCpfCnpj'] = $reg_cli_sint->CPF_CNPJ;
								$dados_pessoa['xEmail'] = $reg_cli_sint->EMail;								
								$dados_pessoa['cIE'] = $reg_cli_sint->Insc_Estadual;
								$dados_pessoa['xEnder'] = $reg_cli_sint->Endereco;
								$dados_pessoa['xNr'] = '';
								$dados_pessoa['xCompl'] = '';
								$dados_pessoa['xBairro'] = $reg_cli_sint->Bairro;
								$dados_pessoa['nCep'] = $reg_cli_sint->CEP;
								$dados_pessoa['nFone'] = $reg_cli_sint->Fone1;
								$dados_pessoa['nFone2'] = $reg_cli_sint->Fone2;
								$dados_pessoa['nFone3'] = $reg_cli_sint->Fax;
								$dados_pessoa['cPais'] = '1058';
								$dados_pessoa['xPais'] = 'BRASIL';
								$dados_pessoa['cMunicipio'] = '';//vai calcular se no foi informado (se EX vai tentar Cadastrar cidadde do Exterior)
								$dados_pessoa['xMunicipio'] = $reg_cli_sint->Cidade;
								$dados_pessoa['UF'] = $reg_cli_sint->UF;
								$pessoa = importacao_cadastra_pessoa($dados_pessoa);
								//atuliza pra da proxima vez pegar o mesmo cliente
								$upt_cadastro =  'Update sint_clientes set '.
												' Pessoa="'.$pessoa.'" '.
												' where Dominio="'.$_SESSION["Dominio"].'" '.
												' and Codigo_SINT="'.$reg_cli_sint->Codigo_SINT.'"';
								consulta_sql($upt_cadastro);
							}
							//consulta endereo
						}
					}else{
						//itens
						$dados_itens['Codigo_Produto'] = UpperDados(trim(substr($list_value,0,$tamanho_codigo)));
						$dados_itens['Qtd']            = UpperDados(trim(substr($list_value,$tamanho_codigo+0,6)));
						$dados_itens['Preco']          = UpperDados(trim(substr($list_value,$tamanho_codigo+6,7)));
						$dados_itens['Desconto']       = UpperDados(trim(substr($list_value,$tamanho_codigo+13,5)));
						$dados_itens['IPI']            = UpperDados(trim(substr($list_value,$tamanho_codigo+18,5)));

						if ($_SESSION["Dominio"]=='2'){
							$dados_itens['Codigo_Produto'] = str_replace('COWS','',$dados_itens['Codigo_Produto']);
						}
						$con_prod = 'select * from produto '.
									' where Dominio = "'.$_SESSION["Dominio"].'"'.
									' and Codigo_Produto = "'.$dados_itens['Codigo_Produto'].'"'.
									' and Situacao <> "E"'.
									' limit 1';
						$res_prod = consulta_sql($con_prod);
						$reg_prod = consulta_ler_objeto($res_prod);
						consulta_sql($con_prod);

						$dados_itens['Id_Produto']  = $reg_prod->Id_Produto;
						$dados_itens['barra_prod'] = '';

						$con_barra = 'select Codigo_Barras from produto_cod_barras '.
									' where Dominio="'.$_SESSION['Dominio'].'"'.
									' and Id_Produto ="'.$reg_prod->Id_Produto.'"'.
									' and Situacao = "A" LIMIT 1 ';
						$res_barra = consulta_sql($con_barra);
						$nrw_barra = consulta_num_registros($res_barra);
						if($nrw_barra>0){
							$reg_barra = consulta_ler_linha($res_barra);
							$dados_itens['barra_prod'] = $reg_barra[0];
						}
						consulta_limpa($res_barra);

						$nitem++;
						$itens[$nitem] = $dados_itens;

						if ($reg_prod->Id_Produto==0){
							$pedido_com_erro = true;
							echo '<font size="2" face="Verdana">Produto no cadastrado ('.$dados_itens['Codigo_Produto'].')!</font><BR>';
							flush(); @ob_flush();
							flush(); @ob_flush();
						}
					}//fim do tipo de linha
				}//fim looping arquivo

				if ($pedido_com_erro){
					$erros++;
				}else{
					$acertos++;
					//cria o pedido no web
					$con_pedido = 'select max(Numero_Pedido),max(CRE) from pedido '.
									' where Dominio="'.$_SESSION["Dominio"].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"';
					$res_pedido = consulta_sql($con_pedido);
					$reg_pedido = consulta_ler_linha($res_pedido);
					consulta_limpa($res_pedido);
					$nr_pedido = $reg_pedido[0];

					$ok = false;
					$tentativa = 0;

					while (!($ok)){
						$nr_pedido++;
						$cons_insere = 'Insert into pedido '.
										'(Dominio, Empresa, Numero_Pedido,  '.
										' DH_Emissao, DH_Digitacao, Pessoa, Local_Fatura, Vendedor, '.
										' Forma_Pagto, Status, Usuario_Criacao, Tipo_Pedido, Local_Entrega, DH_Entrega,CRE ) '.
										' values ('.
										' "'.$_SESSION["Dominio"].'", '.
										' "'.$_SESSION["Empresa_Codigo"].'", '.
										' "'.$nr_pedido.'", '.
										' now(), "'.$dados_pedido['data_emissao'].'", '.
										' "'.$pessoa.'", '.
										' "1", '.
										' "'.$_SESSION["Empresa_Codigo"].'", '.
										' 1, "E", "'.base64_decode_si($_REQUEST['USER_ID']).'", '.
										'"1","1","'.$dados_pedido['Data_Prev'].'", '.
										' "'.($reg_pedido[0]+1).'" '.
										') ';
						$ok = (consulta_sql($cons_insere,true,1) > 0 );
						$tentativa++;

						if(($tentativa==10) && ($ok==false)){
							$ok = true;
							$nr_pedido = '';
						}
					}

					//coloca os itens
					foreach($itens as $item => $item_id){
						$dados_itens = $itens[$item];

						$seq = $item;
						$con_ins = 'Insert into pedido_item '.
									'(Dominio, '.
									' Empresa, '.
									' Numero_Pedido, '.
									' Seq_Item, '.
									' ID_Produto, '.
									' Barra_Produto) '.
									' values ( '.
									' "'.$_SESSION["Dominio"].'", '.
									' "'.$_SESSION["Empresa_Codigo"].'",'.
									' "'.$nr_pedido.'",'.
									' "'.$seq.'",'.
									' "'.$dados_itens['Id_Produto'].'", '.
									' "'.$dados_itens['barra_prod'].'")';
						consulta_sql($con_ins);

						$updt_item = 'Update pedido_item set '.
									' Qtd = "'.($dados_itens['Qtd']*1).'", '.
									' Valor_Unitario = "'.($dados_itens['Preco']/100).'", '.
									' Valor_Desconto = "'.($dados_itens['Desconto']/100).'", '.
									' Valor_Total = ((Qtd*Valor_Unitario)-Valor_Desconto), '.
									' Estoque = "S", '.
									' Status = "A" '.
									' where Dominio="'.$_SESSION["Dominio"].'"'.
									' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' and Numero_Pedido ="'.$nr_pedido.'"'.
									' and Seq_Item ="'.$seq.'"';
						consulta_sql($updt_item);
					}
					//totaliza e libera pedido
					pedido_recalculo($nr_pedido);
					$cons_ped = 'SELECT DH_Emissao, Valor_Total_Liquido '.
								' FROM pedido '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' and Numero_Pedido = "'.$nr_pedido.'"';
					$res_ped = consulta_sql($cons_ped);
					$reg_ped = consulta_ler_linha($res_ped);
					consulta_limpa($res_ped);
					//insere parcela a vista
					$ins_parcela = 'Insert into pedido_parcela '.
									'( Dominio, Empresa, Numero_Pedido, Parcela, '.
									' DT_Vencimento, Valor_Parcela ) '.
									' values ('.
									' "'.$_SESSION["Dominio"].'", '.
									' "'.$_SESSION["Empresa_Codigo"].'", '.
									' "'.$nr_pedido.'", '.
									' "1", '.
									' "'.datad(dataf($reg_ped[0])).'", '.
									' "'.$reg_ped[1].'" '.
									') ';
					consulta_sql($ins_parcela);
					liberar_pedido($nr_pedido);
					//coloca o arquivos de clientes no backup
					sint_bkp_arquivo($diretorio_pedido,$diretorio_backup,$arquivo);
				}//fim no teve erro
			}// aquivo
		}//loing arquivos da pasta
		echo '<font size="2" face="Verdana">Importao Finalizada!</font><BR>';
		flush(); @ob_flush();
		flush(); @ob_flush();
		return (($erros==0)&&($acertos>0));
	}//fim funcao

?>