<?
	require_once(dirname(__FILE__).'/mdfe_funcoes.php');
	require_once(dirname(__FILE__).'/nfe_funcoes.php');

	/////////////////////////////////////////////
	////////////////NOTA FISCAL//////////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_mdfe($nr_nota){
		//reavalia persistncias da nota e dos itens
		manifesto_valida_persistencia($nr_nota,$_SESSION["Empresa_Codigo"]);
		//consulta corpo da nota
		$con_nota = 'select * from manifesto_carga '.
					' where Dominio="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);

		if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nota->MDFe_Chave.'-mdfe.err')){
			unlink(mdfe_pasta_raiz().'retorno/'.$reg_nota->MDFe_Chave.'-mdfe.err');
		}
		//cria objeto xml
		$xml = new XML();

		//adiciona dados da nota
		$r = &$xml->createRoot("MDFe");
		$r->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe', true);
		$nf_inf = &$r->addChild("infMDFe");
		//$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
		$nf_inf->addAttribute('Id', 'MDFe'.$reg_nota->MDFe_Chave, true);
		$nf_inf->addAttribute('versao', $reg_nota->MDFe_Versao, true);

		//chave da MDFe
		$ide = &$nf_inf->addChild("ide");
		$chave = $reg_nota->MDFe_Chave;
		//UF
		$ide->addAttribute('cUF', substr($chave,0,2) , false);

		//ambiente MDFe
		$ide->addAttribute('tpAmb', $reg_nota->MDFe_Ambiente, false);
		$tp_emit = '2';
		$con_doc_serie ='select * from nota_fiscal_serie  '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and ((Modelo="01") or (Modelo="55"))'.
						' and Situacao="A"';
		$res_doc_serie = consulta_sql($con_doc_serie);
		$nrw_doc_serie = consulta_num_registros($res_doc_serie);
		consulta_limpa($res_doc_serie);

		if ($nrw_doc_serie==0){
			$tp_emit = '1';
		}else{
			$con_car =	'select NFe_Chave from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Modelo="57"';
			$res_car = consulta_sql($con_car);
			$nrw_car = consulta_num_registros($res_car);
			consulta_limpa($res_car);
			if ($nrw_car>0){
				$tp_emit = '1';
			}
		}
		//tipo emissao
		$ide->addAttribute('tpEmit', $tp_emit, false);
		$tpTransp = '1';
		$modal = '1';  //1 -  Rodovirio 
		if (substr($reg_nota->Rodo_RNTRC,0,3)=='CTC'){
			$tpTransp = '3';
		}
		if( ($modal == '1') && ( $reg_nota->Rodo_Veiculo_Prop_CNPJ != '')){
			$ide->addAttribute('tpTransp', $tpTransp , false);
		}

		//modelo
		$ide->addAttribute('mod', substr($chave,20,2) , false);
		//serie
		$ide->addAttribute('serie', $reg_nota->Serie , false);
		//nr doc
		$ide->addAttribute('nMDF', $reg_nota->NrDoc , false);
		//Nmero aleatrio
		$ide->addAttribute('cMDF', substr($chave,35,8) , false);
		//digito verificador MDFe
		$ide->addAttribute('cDV', substr($chave,43,1), false);
		//modal
		$ide->addAttribute('modal', $modal , false);

		$uf = substr($reg_nota->MDFe_Chave,0,2);
		$data = substr($reg_nota->DH_Emissao,0,10);

		$dif_UTC = calcula_horario_verao($data,$uf);

		//data de emissao
		$ide->addAttribute('dhEmi', datad(dataf($reg_nota->DH_Emissao)).'T'.
									substr($reg_nota->DH_Emissao,11,8).$dif_UTC , false);
		//tipo emisso
		$ide->addAttribute('tpEmis', $reg_nota->MDFe_TipoEmissao, false);

		//MDFe_Processo  0 - Apolicativo Contribuinte
		$ide->addAttribute('procEmi', '0', false);

		//verso do sistema
		if ($reg_nota->Empresa_UF == 'PR'){
			$ide->addAttribute('verProc', '71411', false);
			//$ide->addAttribute('verProc', '03048-0', false);
		}else{
			$ide->addAttribute('verProc', 'SIMPLES V11.0.0', false);
		}

		//UFini
		$ide->addAttribute('UFIni', $reg_nota->Origem_UF, false);
		//UFini
		$ide->addAttribute('UFFim', $reg_nota->Destino_UF, false);

		//consulta cidades de carregamento
		$con_car =	'select Codigo_Cidade_Carrega,Nome_Cidade_Carrega from manifesto_carga_nota_fiscal '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' group by Codigo_Cidade_Carrega'.
					' order by Nome_Cidade_Carrega';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		//para cada cidade
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			$infMunCarrega = &$ide->addChild("infMunCarrega");
			$infMunCarrega->addAttribute('cMunCarrega', $reg_car->Codigo_Cidade_Carrega, false);
			$infMunCarrega->addAttribute('xMunCarrega', $reg_car->Nome_Cidade_Carrega, false);
		}
		consulta_limpa($res_car);

		//ufs do percuros
		$con_car =	'select UF, Seq_Percurso from manifesto_carga_percurso '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' group by UF order by Seq_Percurso';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		//para cada UF
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			$infPercurso = &$ide->addChild("infPercurso");
			$infPercurso->addAttribute('UFPer', $reg_car->UF, false);
		}
		consulta_limpa($res_car);
		//dhIniViagem AAAA-MM-DDTHH:MM:DD TZD
		//indCanalVerde   1
		//indCarregaPosterior  1
		//adiciona dados do emitente
		$emit = &$nf_inf->addChild("emit");
		if (strlen(limpa_numero($reg_nota->Empresa_CNPJ))==14){
			//cnpj do emitente
			$emit->addAttribute('CNPJ', limpa_numero($reg_nota->Empresa_CNPJ), false);
		}else{
			//cpf emitente
			$emit->addAttribute('CPF', limpa_numero($reg_nota->Empresa_CNPJ), false);
		}
		//IE
		$emit->addAttribute('IE', substr(limpa_numero2($reg_nota->Empresa_Insc_Estadual),0,14), false);
		//nome/razao
		$emit->addAttribute('xNome', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Razao,0,60)), false);
		if (($reg_nota->Empresa_Fantasia != '')&&
			(strlen($reg_nota->Empresa_CNPJ)>14)){
			//fantasia
			$emit->addAttribute('xFant', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Fantasia,0,60)), false);
		}
		//endereco do emitente
		$emit_end = &$emit->addChild("enderEmit");
		//logradouro
		$emit_end->addAttribute('xLgr', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Logradouro,0,60)), false);
		//numero
		if (trim($reg_nota->Empresa_Numero) != ''){
			$emit_end->addAttribute('nro', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Numero,0,60)), false);
		}else{
			$emit_end->addAttribute('nro', 'S/N', false);
		}
		//complemento
		if (trim($reg_nota->Empresa_Complemento) != ''){
			$emit_end->addAttribute('xCpl', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Complemento,0,60)), false);
		}
		//bairro
		$emit_end->addAttribute('xBairro', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Bairro,0,60)), false);
		//nr cidade
		$emit_end->addAttribute('cMun', $reg_nota->Empresa_Codigo_Cidade, false);
		//nome cidade
		$emit_end->addAttribute('xMun', trim(mdfe_retira_texto_excesso($reg_nota->Empresa_Nome_Cidade,0,60)), false);
		//CEP
		if (($reg_nota->Empresa_CEP != '00000-000')&&
			(limpa_numero($reg_nota->Empresa_CEP) != '')){
			$emit_end->addAttribute('CEP', limpa_numero($reg_nota->Empresa_CEP), false);
		}
		//uf
		$emit_end->addAttribute('UF', $reg_nota->Empresa_UF, false);
		//telefone
		if (limpa_numero($reg_nota->Empresa_Telefone_Nr) != ''){
			$emit_end->addAttribute('fone', mdfe_retira_texto_excesso(limpa_numero($reg_nota->Empresa_Telefone_Nr),0,20), false);
		}
		//todo email
		$veiculo = 0;
		//dados do modal rodoviario
		$tracao = limpa_numero2($reg_nota->Rodo_Veiculo_Placa);
		$reboque1 = limpa_numero2($reg_nota->Rodo_Reboque1_Placa);
		$reboque2 = limpa_numero2($reg_nota->Rodo_Reboque2_Placa);
		if ($reboque1!=''){
			$veiculo++;
		}
		if ($reboque2!=''){
			$veiculo++;
		}

		$con_veiculo =	'select * from pessoa_transportador_veiculo '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_nota->Empresa.'"'.
						' and Seq_Veiculo = "'.$reg_nota->Rodo_Veiculo.'"';
		$res_veiculo = consulta_sql($con_veiculo);
		$reg_veiculo = consulta_ler_objeto($res_veiculo);
		consulta_limpa($res_veiculo);

		$infModal = &$nf_inf->addChild("infModal");
		$infModal->addAttribute('versaoModal', $reg_nota->MDFe_Versao, true);

		$rodo = &$infModal->addChild("rodo");

		$infANTT = &$rodo->addChild("infANTT");
		//RNTRC do emitente
		if (limpa_numero($reg_nota->Rodo_RNTRC)!=''){
			$infANTT->addAttribute('RNTRC', limpa_numero($reg_nota->Rodo_RNTRC), false);
		}
		if (limpa_numero($reg_nota->Rodo_CIOT)!=''){
			//ciot
			$infCIOT = &$infANTT->addChild("infCIOT");
			$infCIOT->addAttribute('CIOT', limpa_numero($reg_nota->Rodo_CIOT), false);
			if ($reg_nota->Rodo_CIOT_Responsavel>0){
				$con_ciot_pess ='select CPF_CNPJ from pessoa  '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								//' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								' and Pessoa="'.$reg_nota->Rodo_CIOT_Responsavel.'"';
				$res_ciot_pess = consulta_sql($con_ciot_pess);
				$reg_ciot_pess = consulta_ler_objeto($res_ciot_pess);
				consulta_limpa($res_ciot_pess);
				if (strlen(limpa_numero($reg_ciot_pess->CPF_CNPJ))==14){
					//cnpj do emitente
					$infCIOT->addAttribute('CNPJ', limpa_numero($reg_ciot_pess->CPF_CNPJ), false);
				}else{
					//cpf emitente
					$infCIOT->addAttribute('CPF', limpa_numero($reg_ciot_pess->CPF_CNPJ), false);
				}
			}else{
				$infCIOT->addAttribute('CNPJ', limpa_numero($reg_nota->Empresa_CNPJ), false);
			}
		}

		$con_car =	'select * from manifesto_carga_ciot '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' order by Seq_CIOT';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		if ($nrw_car>0){
			$valePed = &$infANTT->addChild("valePed");
		}
		//para cada cidade
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			$disp = &$valePed->addChild("disp");
			$con_ciot_pess ='select CPF_CNPJ from pessoa  '.
							' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							//' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Pessoa="'.$reg_car->Fornecedor.'"';
			$res_ciot_pess = consulta_sql($con_ciot_pess);
			$reg_ciot_pess = consulta_ler_objeto($res_ciot_pess);
			consulta_limpa($res_ciot_pess);
			$disp->addAttribute('CNPJForn', limpa_numero($reg_ciot_pess->CPF_CNPJ), false);

			if (($reg_car->Pagador!=$_SESSION["Empresa_Codigo"])&&($reg_car->Pagador>0)){
				$con_ciot_pess ='select CPF_CNPJ from pessoa  '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								' and Pessoa="'.$reg_car->Pagador.'"';
				$res_ciot_pess = consulta_sql($con_ciot_pess);
				$reg_ciot_pess = consulta_ler_objeto($res_ciot_pess);
				consulta_limpa($res_ciot_pess);
				if (strlen(limpa_numero($reg_ciot_pess->CPF_CNPJ))==14){
					//cnpj do emitente
					$disp->addAttribute('CNPJPg', limpa_numero($reg_ciot_pess->CPF_CNPJ), false);
				}else{
					//cpf emitente
					$disp->addAttribute('CPFPg', limpa_numero($reg_ciot_pess->CPF_CNPJ), false);
				}
			}
			$disp->addAttribute('nCompra', $reg_ciot_pess->NrDocumento, false);
			$disp->addAttribute('vValePed', mdfe_numero($reg_ciot_pess->Valor), false);
		}
		consulta_limpa($res_car);

		$lista_tomador = array();
		$con_car =	'select Modelo, NFe_Chave from manifesto_carga_nota_fiscal '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' and Modelo="57"';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		$qtdTomador = 0;
		//para cada cidade
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			if ($reg_car->Modelo=='57'){
				$con_doc_serie ='select Tom_CPF_CNPJ,Tom_Razao from nota_frete  '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								' and CTe_Chave="'.$reg_car->NFe_Chave.'"'.
								' and Situacao="F"';
				$res_doc_serie = consulta_sql($con_doc_serie);
				$reg_doc_serie = consulta_ler_objeto($res_doc_serie);
				consulta_limpa($res_doc_serie);
				if ($reg_doc_serie->Tom_CPF_CNPJ!=''){
					$lista_tomador[$reg_doc_serie->Tom_CPF_CNPJ] = $reg_doc_serie->Tom_Razao;
					$qtdTomador++;
				}
			}
		}
		consulta_limpa($res_car);
		if ($qtdTomador==0){
			$con_doc_serie ='select CPF_CNPJ,Nome_Razao from pessoa  '.
							' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'"';
			$res_doc_serie = consulta_sql($con_doc_serie);
			$reg_doc_serie = consulta_ler_objeto($res_doc_serie);
			consulta_limpa($res_doc_serie);

			$CPF_CNPJ = $reg_doc_serie->CPF_CNPJ;
			$Razao = $reg_doc_serie->Nome_Razao;

			if (($CPF_CNPJ=='00.000.000/0000-00')||($CPF_CNPJ=='000.000.000-00')){
				$CPF_CNPJ = '';
			}
			if ($CPF_CNPJ!=''){
				$lista_tomador[$CPF_CNPJ] = $Razao;
			}
		}
		foreach($lista_tomador as $tomador => $nomeContr){
			$infContratante = &$infANTT->addChild("infContratante");
			//$infContratante->addAttribute('xNome', mdfe_retira_texto_excesso(limpa_numero($lista_tomador[$tomador]),0,60),false);
			if (strlen($tomador)==14){
				$infContratante->addAttribute('CPF', mdfe_retira_texto_excesso(limpa_numero($tomador),0,20),false);
			}else{
				$infContratante->addAttribute('CNPJ', mdfe_retira_texto_excesso(limpa_numero($tomador),0,20),false);
			}
		}
		
		

		$veic = &$rodo->addChild("veicTracao");
		$veic->addAttribute('cInt', $reg_nota->Rodo_Veiculo, false);
		$veic->addAttribute('placa', $tracao, false);
		if (strlen($reg_veiculo->Veiculo_RENAVAN)>=9){
			$RENAVAN = substr($reg_veiculo->Veiculo_RENAVAN,0,11);
			$veic->addAttribute('RENAVAN', $RENAVAN, false);
		}
		$veic->addAttribute('tara', round($reg_nota->Rodo_Veiculo_Tara), false);
		if ($veiculo==0){
			$veic->addAttribute('capKG', round($reg_nota->Rodo_Veiculo_Capacidade), false);
		}
		if ($reg_nota->Rodo_Veiculo_Prop_CNPJ!=''){
			$prop = &$veic->addChild("prop");
			if (strlen(limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ))==14){
				//cnpj do emitente
				$prop->addAttribute('CNPJ', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ), false);
			}else{
				//cpf emitente
				$prop->addAttribute('CPF', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ), false);
			}
			$prop->addAttribute('RNTRC', mdfe_retira_texto_excesso(limpa_numero($reg_nota->Rodo_Veiculo_Prop_RNTC),0,8) , false);
			$prop->addAttribute('xNome', mdfe_retira_texto_excesso($reg_nota->Rodo_Veiculo_Prop_Nome,0,60), false);
			$prop->addAttribute('IE', mdfe_retira_texto_excesso(limpa_numero2($reg_nota->Rodo_Veiculo_Prop_IE),0,8), false);
			$prop->addAttribute('UF', $reg_nota->Rodo_Veiculo_Prop_UF, false);
			$prop->addAttribute('tpProp', $reg_nota->Rodo_Veiculo_Prop_Tipo, false);
		}
		$condutor = &$veic->addChild("condutor");
		$condutor->addAttribute('xNome', mdfe_retira_texto_excesso($reg_nota->Rodo_Motorista_Nome,0,60), false);
		$condutor->addAttribute('CPF', limpa_numero($reg_nota->Rodo_Motorista_CPF), false);
		//ufs do percuros
		$con_car =	'select * from manifesto_carga_motoristas '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' order by Motorista';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		//para cada UF
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			$condutor = &$veic->addChild("condutor");
			$condutor->addAttribute('xNome', mdfe_retira_texto_excesso($reg_car->Motorista_Nome,0,60), false);
			$condutor->addAttribute('CPF', limpa_numero($reg_car->Motorista_CPF), false);
		}
		consulta_limpa($res_car);
		if (fill_full($reg_nota->Rodo_Veiculo_Rodado,2)!='00'){
			$veic->addAttribute('tpRod', fill_full($reg_nota->Rodo_Veiculo_Rodado,2), false);
		}else{
			$veic->addAttribute('tpRod', '01', false);
		}
		if ($reboque1 !=''){
			$veic->addAttribute('tpCar', '00', false);
		}else{
			$veic->addAttribute('tpCar', fill_full($reg_nota->Rodo_Veiculo_Carroceria,2), false);
		}
		$veic->addAttribute('UF', $reg_nota->Rodo_Veiculo_UF, false);

		if ($reboque1!=''){
			$veic = &$rodo->addChild("veicReboque");
			//$veic->addAttribute('cInt', $reg_nota->Rodo_Veiculo, false);
			$veic->addAttribute('placa', $reboque1, false);
			if (strlen($reg_veiculo->Reboque_Registro_ANTT)>=9){
				$RENAVAN = substr($reg_veiculo->Reboque_Registro_ANTT,0,11);
				$veic->addAttribute('RENAVAN', $RENAVAN, false);
			}
			$veic->addAttribute('tara', round($reg_nota->Rodo_Reboque1_Tara), false);
			$veic->addAttribute('capKG', round($reg_nota->Rodo_Reboque1_Capacidade), false);
			if ($reg_nota->Rodo_Veiculo_Prop_CNPJ!=''){
				$prop = &$veic->addChild("prop");
				if (strlen(limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ))==14){
					//cnpj do emitente
					$prop->addAttribute('CNPJ', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ ), false);
				}else{
					//cpf emitente
					$prop->addAttribute('CPF', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ ), false);
				}
				$prop->addAttribute('RNTRC', mdfe_retira_texto_excesso(limpa_numero($reg_nota->Rodo_Veiculo_Prop_RNTC),0,8) , false);
				$prop->addAttribute('xNome', mdfe_retira_texto_excesso($reg_nota->Rodo_Veiculo_Prop_Nome,0,60), false);
				$prop->addAttribute('IE', mdfe_retira_texto_excesso(limpa_numero2($reg_nota->Rodo_Veiculo_Prop_IE),0,8), false);
				$prop->addAttribute('UF', $reg_nota->Rodo_Veiculo_Prop_UF, false);
				$prop->addAttribute('tpProp', $reg_nota->Rodo_Veiculo_Prop_Tipo, false);
			}
			$veic->addAttribute('tpCar', fill_full($reg_nota->Rodo_Veiculo_Carroceria,2), false);
			$veic->addAttribute('UF', $reg_nota->Rodo_Reboque1_UF, false);
		}
		if ($reboque2!=''){
			$veic = &$rodo->addChild("veicReboque");
			//$veic->addAttribute('cInt', $reg_nota->Rodo_Veiculo, false);
			$veic->addAttribute('placa', $reboque2, false);
			if (strlen($reg_veiculo->Reboque2_Registro_ANTT)>=9){
				$RENAVAN = substr($reg_veiculo->Reboque2_Registro_ANTT,0,11);
				$veic->addAttribute('RENAVAN', $RENAVAN, false);
			}
			$veic->addAttribute('tara', round($reg_nota->Rodo_Reboque2_Tara), false);
			$veic->addAttribute('capKG', round($reg_nota->Rodo_Reboque2_Capacidade), false);
			if ($reg_nota->Rodo_Veiculo_Prop_CNPJ!=''){
				$prop = &$veic->addChild("prop");
				if (strlen(limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ))==14){
					//cnpj do emitente
					$prop->addAttribute('CNPJ', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ ), false);
				}else{
					//cpf emitente
					$prop->addAttribute('CPF', limpa_numero($reg_nota->Rodo_Veiculo_Prop_CNPJ ), false);
				}
				$prop->addAttribute('RNTRC', mdfe_retira_texto_excesso(limpa_numero($reg_nota->Rodo_Veiculo_Prop_RNTC),0,8) , false);
				$prop->addAttribute('xNome', mdfe_retira_texto_excesso($reg_nota->Rodo_Veiculo_Prop_Nome,0,60), false);
				$prop->addAttribute('IE', mdfe_retira_texto_excesso(limpa_numero2($reg_nota->Rodo_Veiculo_Prop_IE),0,8), false);
				$prop->addAttribute('UF', $reg_nota->Rodo_Veiculo_Prop_UF, false);
				$prop->addAttribute('tpProp', $reg_nota->Rodo_Veiculo_Prop_Tipo, false);
			}
			$veic->addAttribute('tpCar', fill_full($reg_nota->Rodo_Veiculo_Carroceria,2), false);
			$veic->addAttribute('UF', $reg_nota->Rodo_Reboque2_UF, false);
		}
		/*

		//ufs do percuros
		$con_car = 'select * from manifesto_carga_pedagio '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' order by Seq_Vale';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		//para cada UF

		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			if ($c==0){
				$vales = &$rodo->addChild("valePed");
			}
			$vale = &$vales->addChild("disp");
			$vale->addAttribute('CNPJForn', limpa_numero($reg_car->Fornecedora_CNPJ ), false);
			if ($reg_car->Pagadora_CNPJ!=''){
				$vale->addAttribute('CNPJPg', limpa_numero($reg_car->Pagadora_CNPJ ), false);
			}
			$vale->addAttribute('nCompra', limpa_numero($reg_car->Nr_Comprovante ), false);
		}
		consulta_limpa($res_car);
		*/

		//documentos
		$qCTe=0;
		$qCT=0;
		$qNFe=0;
		$qNF=0;
		$qMDFe=0;
		$vCarga=0;
		$qCarga=0;

		//consulta cidades de descarregamento
		$infDoc = &$nf_inf->addChild("infDoc");
		$con_car =	'select Codigo_Cidade_Descarga,Nome_Cidade_Descarga from manifesto_carga_nota_fiscal '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' group by Codigo_Cidade_Descarga'.
					' order by Nome_Cidade_Descarga';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		//para cada cidade
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			$infMunDescarga = &$infDoc->addChild("infMunDescarga");
			$infMunDescarga->addAttribute('cMunDescarga', $reg_car->Codigo_Cidade_Descarga, false);
			$infMunDescarga->addAttribute('xMunDescarga', $reg_car->Nome_Cidade_Descarga, false);
			//consulta CT-e com esse municipio
			$con_doc =	'select * from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Codigo_Cidade_Descarga= "'.$reg_car->Codigo_Cidade_Descarga.'"'.
						' and Modelo="57" '.
						' order by Seq_Nota';
			$res_doc = consulta_sql($con_doc);
			$nrw_doc = consulta_num_registros($res_doc);
			//para cada cidade
			for($d=0;$d<$nrw_doc;$d++){
				$reg_doc = consulta_ler_objeto($res_doc);
				//if ($d==0){
				$infCTe = &$infMunDescarga->addChild("infCTe");
				//}
				$qCTe++;
				$vCarga+=$reg_doc->ValorDoc;
				$qCarga+=$reg_doc->Peso_Bruto;
				$infCTe->addAttribute('chCTe', $reg_doc->NFe_Chave, false);
				manifesto_carga_adiciona_local($infCTe,$reg_doc,$veiculo,$tracao,$reboque1,$reboque2);
			}
			consulta_limpa($res_doc);

			//consulta CT com esse municipio
			$con_doc =	'select * from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Codigo_Cidade_Descarga= "'.$reg_car->Codigo_Cidade_Descarga.'"'.
						' and ((Modelo="07") or (Modelo="08")) '.
						' order by Seq_Nota';
			$res_doc = consulta_sql($con_doc);
			$nrw_doc = consulta_num_registros($res_doc);
			//para cada cidade
			for($d=0;$d<$nrw_doc;$d++){
				$reg_doc = consulta_ler_objeto($res_doc);
				//if ($d==0){
				$infCT = &$infMunDescarga->addChild("infCT");
				//}
				$qCT++;
				$vCarga+=$reg_doc->ValorDoc;
				$qCarga+=$reg_doc->Peso_Bruto;

				$infCT->addAttribute('nCT', $reg_doc->NrDoc, false);
				$infCT->addAttribute('serie', $reg_doc->Serie, false);
				if ($reg_doc->SubSerie!=''){
					$infCT->addAttribute('subser', $reg_doc->SubSerie, false);
				}
				$infCT->addAttribute('dEmi', $reg_doc->DT_Emissao, false);
				$infCT->addAttribute('vCarga', mdfe_numero($reg_doc->ValorDoc), false);

				manifesto_carga_adiciona_local($infCT,$reg_doc,$veiculo,$tracao,$reboque1,$reboque2);
			}
			consulta_limpa($res_doc);

			//consulta NF-e com esse municipio
			$con_doc =	'select * from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Codigo_Cidade_Descarga= "'.$reg_car->Codigo_Cidade_Descarga.'"'.
						' and Modelo="55" '.
						' order by Seq_Nota';
			$res_doc = consulta_sql($con_doc);
			$nrw_doc = consulta_num_registros($res_doc);
			//para cada cidade

			for($d=0;$d<$nrw_doc;$d++){
				$reg_doc = consulta_ler_objeto($res_doc);
				//if ($d==0){
				$infNFe = &$infMunDescarga->addChild("infNFe");
				//}
				$qNFe++;
				$vCarga+=$reg_doc->ValorDoc;
				$qCarga+=$reg_doc->Peso_Bruto;

				$infNFe->addAttribute('chNFe', $reg_doc->NFe_Chave, false);
				manifesto_carga_adiciona_local($infNFe,$reg_doc,$veiculo,$tracao,$reboque1,$reboque2);
			}
			consulta_limpa($res_doc);

			//consulta NF com esse municipio
			$con_doc =	'select * from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Codigo_Cidade_Descarga= "'.$reg_car->Codigo_Cidade_Descarga.'"'.
						' and ((Modelo="01") or (Modelo="04")) '.
						' order by Seq_Nota';
			$res_doc = consulta_sql($con_doc);
			$nrw_doc = consulta_num_registros($res_doc);
			//para cada cidade

			for($d=0;$d<$nrw_doc;$d++){
				$reg_doc = consulta_ler_objeto($res_doc);
				//if ($d==0){
				$infNF = &$infMunDescarga->addChild("infNF");
				//}
				$qNF++;
				$vCarga+=$reg_doc->ValorDoc;
				$qCarga+=$reg_doc->Peso_Bruto;
				$infNF->addAttribute('CNPJ', limpa_numero($reg_doc->Rem_CPF_CNPJ), false);
				$infNF->addAttribute('UF', $reg_doc->UF_Descarga, false);
				$infNF->addAttribute('nNF', $reg_doc->NrDoc, false);
				$infNF->addAttribute('serie', $reg_doc->Serie, false);
				$infNF->addAttribute('dEmi', $reg_doc->DT_Emissao, false);
				$infNF->addAttribute('vNF', mdfe_numero($reg_doc->ValorDoc), false);
				if ($reg_doc->PIN_SUFRAMA!=''){
					$infNF->addAttribute('PIN', $reg_doc->PIN_SUFRAMA, false);
				}
				manifesto_carga_adiciona_local($infNF,$reg_doc,$veiculo,$tracao,$reboque1,$reboque2);
			}
			consulta_limpa($res_doc);
			//consulta MDF-e com esse municipio
			$con_doc =	'select * from manifesto_carga_nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto = "'.$nr_nota.'"'.
						' and Codigo_Cidade_Descarga= "'.$reg_car->Codigo_Cidade_Descarga.'"'.
						' and Modelo="58" '.
						' order by Seq_Nota';
			$res_doc = consulta_sql($con_doc);
			$nrw_doc = consulta_num_registros($res_doc);
			//para cada cidade
			for($d=0;$d<$nrw_doc;$d++){
				$reg_doc = consulta_ler_objeto($res_doc);
				//if ($d==0){
				$infMDFe = &$infMunDescarga->addChild("infMDFe");
				//}
				$qMDFe++;
				$vCarga+=$reg_doc->ValorDoc;
				$qCarga+=$reg_doc->Peso_Bruto;
				$infMDFe->addAttribute('chMDFe', $reg_doc->NFe_Chave, false);
				manifesto_carga_adiciona_local($infMDFe,$reg_doc,$veiculo,$tracao,$reboque1,$reboque2);
			}
			consulta_limpa($res_doc);
		}
		consulta_limpa($res_car);
		//consulta cada documento dessas cidades
		if ($reg_nota->Seguradora>0){
			$seg = &$nf_inf->addChild("seg");
			$con_seg =	'select * from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$reg_nota->Seguradora.'"';
			$res_seg = consulta_sql($con_seg);
			$reg_seg = consulta_ler_objeto($res_seg);
			consulta_limpa($res_seg);
			$infResp = &$seg->addChild("infResp");
			$infResp->addAttribute('respSeg', '1', false);
			//if ($reg_nota->Seguradora>0){
			//	$infResp->addAttribute('CNPJ', limpa_numero($reg_seg->CPF_CNPJ), false);//}
			$infSeg = &$seg->addChild("infSeg");
			$infSeg->addAttribute('xSeg',mdfe_retira_texto_excesso($reg_seg->Nome_Razao,0,30), false);
			$infSeg->addAttribute('CNPJ',limpa_numero($reg_seg->CPF_CNPJ), false);
			if ($reg_nota->Nr_Apolice!=''){
				$seg->addAttribute('nApol', mdfe_retira_texto_excesso($reg_nota->Nr_Apolice,0,20),false);
			}
			if ($reg_nota->Lacres!=''){
				$lacres = str_replace(',',';',$reg_nota->Lacres);
				$lista_lacres = explode(';',$lacres);
				foreach($lista_lacres as $keyLacres => $valorLacres){
					if (trim($valorLacres)!=''){
						$seg->addAttribute('nAver', mdfe_retira_texto_excesso(trim($valorLacres),0,20),false);
					}
				}
			}
		}

		$prodPred = &$nf_inf->addChild("prodPred");
			$prodPred->addAttribute('tpCarga', str_pad($reg_nota->ProdPred_Tipo_Carga, 2, '0', STR_PAD_LEFT), false);
			$prodPred->addAttribute('xProd', mdfe_retira_texto_excesso(trim($reg_nota->ProdPred_Descricao),0,120),false);
			if ($reg_nota->ProdPred_EAN!=''){
				$prodPred->addAttribute('cEAN', mdfe_retira_texto_excesso(trim($reg_nota->ProdPred_EAN),0,14),false);
			}
			if ($reg_nota->ProdPred_NCM!=''){
				$prodPred->addAttribute('NCM', limpa_numero(trim($reg_nota->ProdPred_NCM)),false);
			}
		if ($reg_nota->ProdPred_Lotacao=='1'){
			$infLotacao = &$prodPred->addChild("infLotacao");
				$infLocalCarrega = &$infLotacao->addChild("infLocalCarrega");
					$infLocalCarrega->addAttribute('CEP', limpa_numero($reg_nota->ProdPred_CEP_Origem),false);
					//$infLocalCarrega->addAttribute('latitude', mdfe_numero($reg_nota->ProdPred_Lat_Origem,6),false);
					//$infLocalCarrega->addAttribute('longitude', mdfe_numero($reg_nota->ProdPred_Log_Origem,6),false);
				$infLocalDescarrega = &$infLotacao->addChild("infLocalDescarrega");
					$infLocalDescarrega->addAttribute('CEP', limpa_numero($reg_nota->ProdPred_CEP_Destino),false);
					//$infLocalDescarrega->addAttribute('latitude', mdfe_numero($reg_nota->ProdPred_Lat_Destino,6),false);
					//$infLocalDescarrega->addAttribute('longitude', mdfe_numero($reg_nota->ProdPred_Log_Destino,6),false);
		}

		//nAver
		//adiciona os totais do Manifesto
		$totais = &$nf_inf->addChild("tot");
		//qCTe
		if ($qCTe>0){
			$totais->addAttribute('qCTe', mdfe_numero(round($qCTe),0), false);
		}
		//qCT
		if ($qCT>0){
			$totais->addAttribute('qCT', mdfe_numero(round($qCT),0), false);
		}
		//qNFe
		if ($qNFe>0){
			$totais->addAttribute('qNFe', mdfe_numero(round($qNFe),0), false);
		}
		//qNFe
		if ($qNF>0){
			$totais->addAttribute('qNF', mdfe_numero(round($qNF),0), false);
		}
		//qMDFe
		if ($qMDFe>0){
			$totais->addAttribute('qMDFe', mdfe_numero(round($qMDFe),0), false);
		}
		//vCarga
		$totais->addAttribute('vCarga', mdfe_numero($vCarga), false);
		//cUnid
		$totais->addAttribute('cUnid', '01', false); //01=KG

		//qCarga
		$totais->addAttribute('qCarga', mdfe_numero($qCarga,4), false);
		/*
		if ($reg_nota->Lacres!=''){
		$lacres = str_replace(',',';',$reg_nota->Lacres);
		$lista_lacres = explode(';',$lacres);
		foreach($lista_lacres as $keyLacres => $valorLacres){
		if (trim($valorLacres)!=''){
		$lacRodo = &$nf_inf->addChild("lacres");
		$lacRodo->addAttribute('nLacre', trim($valorLacres), false);
		}
		}
		}
		*/
		$conteudo_xml = BuscaParamEmpresa('AUT_XML',$reg_nota->Empresa);
		$lista_aut_xml = array();
		if($conteudo_xml!=''){
			$lista_aut_xml = explode(';',$conteudo_xml);
		}
		if(count($lista_aut_xml)>0){
			$cont_aut = 0;
			foreach ($lista_aut_xml as $cpf_cnpj){
				if($cpf_cnpj != ''){
					if($cont_aut<=10){
						$cpf_cnpj = limpa_numero($cpf_cnpj);
						if(strlen($cpf_cnpj)==14){
							$aut = &$nf_inf->addChild("autXML");
							$aut->addAttribute('CNPJ', $cpf_cnpj, false);
							$cont_aut++;
						}else if(strlen($cpf_cnpj)==11){
							$aut = &$nf_inf->addChild("autXML");
							$aut->addAttribute('CPF', $cpf_cnpj, false);
							$cont_aut++;
						}
					}
				}
			}
		}
		//consulta observaes da nota e dos itens
		//agrupada por descrio completa
		//ordenado por seq item e seq_obs
		$obs = '';
		$con_obs =	'select * from manifesto_carga_obs'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' group by Texto_Completo '.
					' order by Seq_Obs';
		$res_obs = consulta_sql($con_obs);
		$nrw_obs = consulta_num_registros($res_obs);
		//para cada obs
		for($o=0;$o<$nrw_obs;$o++){
			$reg_obs = consulta_ler_objeto($res_obs);
			//adicona  obs do corpo da nota
			if ($obs!=''){
				$obs.=';';
			}
			$obs.= mdfe_formata_txt($reg_obs->Texto_Completo);
		}
		consulta_limpa($res_obs);
		//se tem obs do corpo da nota
		if ($obs!=''){
			//adicona  obs da mdfe
			$inf_adic = &$nf_inf->addChild("infAdic");
			//$inf_adic->addAttribute('infAdFisco', 'MD-5:593a30b3a58302b2375e947e7d36fefd', false);
			//texto na obs
			$inf_adic->addAttribute('infCpl', trim(mdfe_retira_texto_excesso($obs,0,5000)), false);
		}

		$infRespTec = &$nf_inf->addChild("infRespTec");
		$infRespTec->addAttribute('CNPJ', '83188342000104', false);
		$infRespTec->addAttribute('xContato', 'Denise Alves Molon', false);
		$infRespTec->addAttribute('email', 'freeline@freeline.inf.br', false);
		$infRespTec->addAttribute('fone', '4734730001', false);
		$hashCSRT= 'RESP';
		$idCSRT = '01';
		if($reg_nota->Empresa_UF == 'XX'){
			$hashCSRT = 'G8063VRTNDMO886SFNK5LDUDEI24XJ22YIPO';
		}
		if($hashCSRT!='RESP'){
			$hashCSRT = $hashCSRT.$reg_nota->MDFe_Chave;
			$hashCSRT_sha1 = sha1($hashCSRT, true);
			$hashCSRT_b64 = base64_encode($hashCSRT_sha1);
			$infRespTec->addAttribute('idCSRT', $idCSRT, false);
			$infRespTec->addAttribute('hashCSRT', $hashCSRT_b64, false);
		}

		//$qrCodMDFe = 'https://dfe-portal.svrs.rs.gov.br/mdfe/qrCode?chMDFe='.$reg_nota->MDFe_Chave.'&tpAmb='.$reg_nota->MDFe_Ambiente;
		//$infMDFeSupl = &$r->addChild("infMDFeSupl");
		//$infMDFeSupl->addAttribute('qrCodMDFe', $qrCodMDFe, false);

		//http://dfe-portal.svrs.rs.gov.br/mdfe/QRCode?chMDFe=43181207312871000190580010000334041421310776&tpAmb=1 
		//finaliza arquivo na pasta tmp
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $reg_nota->MDFe_Chave."-mdfe.xml");
		$retorno = '';
		$salvou = file_exists(mdfe_pasta_raiz().'tmp/'.$reg_nota->MDFe_Chave."-mdfe.xml");
		//se consegui salvar
		if ($salvou){
			$retorno = $reg_nota->MDFe_Chave;
			//$retorno = '';
			//echo 'gerou arquivo';
		}else{
			mdfe_exibe_erro('FRE-002','Falha na gerao do arquivo "'.$reg_nota->MDFe_Chave.'-mdfe.xml" na pasta "tmp"!<BR>'.
										'Verifique a estrutura de pastas no servidor!',$nr_nota);
		}
		return $retorno;
	}

	function manifesto_carga_adiciona_local($infCTe,$reg_car,$veiculo,
											$tracao,$reboque1,$reboque2){
		if ($reg_car->Local!=''){
			if ($veiculo>0){
				$tpUnidTransp = '2';
			}else{
				$tpUnidTransp = '1';
			}
			if ($veiculo==2){
				if ($reg_car->Local!='2'){
					$infUnidTransp = &$infCTe->addChild("infUnidTransp");
					$infUnidTransp->addAttribute('tpUnidTransp', $tpUnidTransp, false);
					$infUnidTransp->addAttribute('idUnidTransp', $reboque1, false);
					if ($reg_car->Lacres!=''){
						$lacres = str_replace(',',';',$reg_car->Lacres);
						$lista_lacres = explode(';',$lacres);
						foreach($lista_lacres as $keyLacres => $valorLacres){
							if (trim($valorLacres)!=''){
								$lacRodo = &$infUnidTransp->addChild("lacUnidTransp");
								$lacRodo->addAttribute('nLacre', trim($valorLacres), false);
							}
						}
					}
				}
				if ($reg_car->Local!='1'){
					$infUnidTransp = &$infCTe->addChild("infUnidTransp");
					$infUnidTransp->addAttribute('tpUnidTransp', $tpUnidTransp, false);
					$infUnidTransp->addAttribute('idUnidTransp', $reboque2, false);
					if ($reg_car->Lacres!=''){
						$lacres = str_replace(',',';',$reg_car->Lacres);
						$lista_lacres = explode(';',$lacres);
						foreach($lista_lacres as $keyLacres => $valorLacres){
							if (trim($valorLacres)!=''){
								$lacRodo = &$infUnidTransp->addChild("lacUnidTransp");
								$lacRodo->addAttribute('nLacre', trim($valorLacres), false);
							}
						}
					}
				}
			}else if ($veiculo==1){
				$infUnidTransp = &$infCTe->addChild("infUnidTransp");
				$infUnidTransp->addAttribute('tpUnidTransp', $tpUnidTransp, false);
				$infUnidTransp->addAttribute('idUnidTransp', $reboque1, false);
				if ($reg_car->Lacres!=''){
					$lacres = str_replace(',',';',$reg_car->Lacres);
					$lista_lacres = explode(';',$lacres);
					foreach($lista_lacres as $keyLacres => $valorLacres){
						if (trim($valorLacres)!=''){
							$lacRodo = &$infUnidTransp->addChild("lacUnidTransp");
							$lacRodo->addAttribute('nLacre', trim($valorLacres), false);
						}
					}
				}
			}else{
				$infUnidTransp = &$infCTe->addChild("infUnidTransp");
				$infUnidTransp->addAttribute('tpUnidTransp', $tpUnidTransp, false);
				$infUnidTransp->addAttribute('idUnidTransp', $tracao, false);
				if ($reg_car->Lacres!=''){
					$lacres = str_replace(',',';',$reg_car->Lacres);
					$lista_lacres = explode(';',$lacres);
					foreach($lista_lacres as $keyLacres => $valorLacres){
						if (trim($valorLacres)!=''){
							$lacRodo = &$infUnidTransp->addChild("lacUnidTransp");
							$lacRodo->addAttribute('nLacre', trim($valorLacres), false);
						}
					}
				}
			}
		}
	}
	/////////////////////////////////////////////
	////////////////NOTA FISCAL//////////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	///////////CONSULTA DE RECIBO////////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_consulta($nr_nota){
		$con_nfe =	'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("consReciMDFe");
		//$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
		//$nf_inf->addAttribute('xmlns:xsd', 'http://www.portalfiscal.inf.br/mdfe', true);
		$nf_inf->addAttribute('versao', $reg_nfe->MDFe_Versao, true);
		$nf_inf->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe', true);
		$nf_inf->addAttribute('tpAmb', $reg_nfe->MDFe_Ambiente, false);
		$nf_inf->addAttribute('nRec', $reg_nfe->MDFe_Recibo, false);
		//$nf_inf->addAttribute('cUf', substr($reg_nfe->MDFe_Chave,0,2), false);
		//$nf_inf->addAttribute('tpEmis', $reg_nfe->MDFe_TipoEmissao, false);
		//cria arquivo de consulta do lote da MDF-e na pasta tmp
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $reg_nfe->MDFe_Recibo."-ped-rec.xml");
	}
	/////////////////////////////////////////////
	///////////CONSULTA DE RECIBO////////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	/////////////////ARQUIVO AUXILIAR////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_auxiliar($nr_nota){
		$con_nfe =	'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao);
		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("outrasInfDAMDFe");
		$nf_inf->addAttribute('horasaida', substr($reg_nfe->DH_EntSai,11) , false);
		$nf_inf->addAttribute('dSaiEnt', substr($reg_nfe->DH_EntSai,0,10) , false);
		//cria arquivo de consulta do lote da MDF-e na pasta tmp
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $reg_nfe->MDFe_Protocolo.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-auxMDFe.xml');
		mdfe_copia_arquivo('tmp','damdfe/'.$ano_mes,$reg_nfe->MDFe_Protocolo.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-auxMDFe.xml','',false);
		return (mdfe_pasta_raiz().'damdfe/'.$ano_mes.'/'.$reg_nfe->MDFe_Protocolo.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-auxMDFe.xml');
	}
	/////////////////////////////////////////////
	/////////////////ARQUIVO AUXILIAR////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	/////////////////INUTILIZAO////////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_inutiliza($nr_nota){
		return true;
		/*
		$con_nfe = 'select * from manifesto_carga '.
		' where Dominio ="'.$_SESSION['Dominio'].'"'.
		' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		//if ($reg_nfe->Situacao

		$ano_mes = mdfe_ano_mes();

		$versao_c = '1.00';

		$chave_cancela = substr($reg_nfe->MDFe_Chave,0,2).
		substr($reg_nfe->MDFe_Chave,2,2).
		substr($reg_nfe->MDFe_Chave,6,14).
		substr($reg_nfe->MDFe_Chave,20,2).
		fill_full($reg_nfe->Serie,3).
		fill_full($reg_nfe->NrDoc,9).
		fill_full($reg_nfe->NrDoc,9);

		if (!(file_exists(mdfe_pasta_raiz().'retorno/'.$chave_cancela.'-inu.xml'))){
		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("inutMDFe");
		//$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance' , True);
		//$nf_inf->addAttribute('xmlns:xsd', 'http://www.w3.org/2001/XMLSchema' , True);
		$nf_inf->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe' , True);
		$nf_inf->addAttribute('versao', $versao_c , True);

		$inf_canc = &$nf_inf->addChild("infInut");
		$inf_canc->addAttribute('Id', 'ID'.$chave_cancela, True);
		$inf_canc->addAttribute('tpAmb', $reg_nfe->MDFe_Ambiente, False);
		$inf_canc->addAttribute('xServ', 'INUTILIZAR', False);
		$inf_canc->addAttribute('cUF', substr($reg_nfe->MDFe_Chave,0,2), False);
		$inf_canc->addAttribute('ano', substr($reg_nfe->MDFe_Chave,2,2), False);
		$inf_canc->addAttribute('CNPJ', substr($reg_nfe->MDFe_Chave,6,14), False);
		$inf_canc->addAttribute('mod', substr($reg_nfe->MDFe_Chave,20,2), False);
		$inf_canc->addAttribute('serie', $reg_nfe->Serie, False);
		$inf_canc->addAttribute('nMDFIni', $reg_nfe->NrDoc, False);
		$inf_canc->addAttribute('nMDFFin', $reg_nfe->NrDoc, False);
		$inf_canc->addAttribute('xJust', $reg_nfe->Cancela_Motivo_Descricao, False);
		$inf_canc->addAttribute('tpEmis', $reg_nfe->MDFe_TipoEmissao, False);
		//cria arquivo de consulta do lote da MDF-e na pasta tmp
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $chave_cancela.'-ped-inu.xml');
		mdfe_copia_arquivo('tmp','envio',$chave_cancela.'-ped-inu.xml','',false);
		}

		$ok = false;
		while (!($ok)){
		set_time_limit(30);
		if ((file_exists(mdfe_pasta_raiz().'retorno/'.$chave_cancela.'-inu.xml'))||
		(file_exists(mdfe_pasta_raiz().'retorno/'.$chave_cancela.'-inu.err'))){
		$ok = true;
		sleep(5);
		if (file_exists(mdfe_pasta_raiz().'retorno/'.$chave_cancela.'-inu.xml')){
		$status = '';
		$motivo = '';
		$protocolo_nr = '';
		$protocolo_dh = '';
		$protocolo_pr = '';
		$protocolo_dv = '';

		$xml = new XML();
		$xml->fromFile(mdfe_pasta_raiz().'retorno/', $chave_cancela.'-inu.xml', true);

		//le nr do lote no arquivo
		if ($xml->root->name == 'retInutMDFe'){
		$status = '2';
		foreach($xml->root->childs as $key => $value){
		if ($xml->root->childs[$key]->name== 'infInut'){
		$txt_inf_prot = $xml->root->childs[$key]->toString();
		$prot_nfe = &$xml->root->childs[$key];
		$status = '1';
		}
		}
		}
		if ($status == '1'){
		$status = '';
		foreach($prot_nfe->atts as $key => $value){
		if ($prot_nfe->atts[$key]->name == 'cStat'){
		$status = $prot_nfe->atts[$key]->value;
		}
		if ($prot_nfe->atts[$key]->name == 'xMotivo'){
		$motivo = $prot_nfe->atts[$key]->value;
		}
		if ($prot_nfe->atts[$key]->name == 'verAplic'){
		$protocolo_pr = $prot_nfe->atts[$key]->value;
		}
		if ($prot_nfe->atts[$key]->name == 'dhRecbto'){
		$protocolo_dh = $prot_nfe->atts[$key]->value;
		}
		if ($prot_nfe->atts[$key]->name == 'nProt'){
		$protocolo_nr = $prot_nfe->atts[$key]->value;
		}
		if ($prot_nfe->atts[$key]->name == 'digVal'){
		$protocolo_dv = $prot_nfe->atts[$key]->value;
		}
		}
		}

		if ($status == '102'){
		//copia arquivo para a pasta autorizada
		mdfe_copia_arquivo('retorno','SEFAZ/Inutilizacao/'.$ano_mes,$chave_cancela.'-inu.xml','',false);
		//cria arquivo de distribuio da MDFe cancelada
		$texto_nfe = xml_fromFile(
		mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes,
		$chave_cancela.'-ped-inu.xml');
		$string = '<?xml version="1.0" encoding="utf-8"?>'.
		'<procInutMDFe versao="'.$versao_c.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
		$texto_nfe.
		'<retInutMDFe versao="'.$versao_c.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
		$txt_inf_prot.
		'</retInutMDFe>'.
		'</procInutMDFe>';
		$Handle = fopen(mdfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($versao_c,5).'-procInutMDFe.xml', 'w');
		$Data = utf8_encode($string);
		fwrite($Handle, $Data);
		fclose($Handle);

		//salva dados da autorizao na tabela de NF
		mdfe_copia_arquivo('tmp','SEFAZ/MDF-es/'.$ano_mes.'/Inutilizadas',$protocolo_nr.'_v'.fill_full($versao_c,5).'-procInutMDFe.xml','',false);

		$upt_nota = 'Update manifesto_carga set'.
		' MDFe_Protocolo_C="'.$protocolo_nr.'", '.
		' MDFe_Protocolo_C_DH="'.$protocolo_dh.'", '.
		' MDFe_Protocolo_C_Sig="'.$protocolo_pr.'", '.
		' MDFe_Situacao="'.$status.'", '.
		' MDFe_Protocolo_C_Motivo="'.$motivo.'" '.
		' where Dominio ="'.$_SESSION['Dominio'].'"'.
		' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' and Nr_Manifesto="'.$nr_nota.'" ';
		consulta_sql($upt_nota);

		return true;
		}else {
		//salva arquivo na pasta de erros
		mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$chave_cancela.'-inu.xml','',true);

		//exibe motivo da Denegao da Autorizao
		mdfe_exibe_erro('FRE-104','A SEFAZ no autorizou a Inutilizao da Numerao desta MDF-e!'.
		'"'.$status.'" - '.$motivo,'');
		return false;
		}
		}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$chave_cancela.'-inu.err')){
		//exibe mensagem do arquivo de erro
		$conteudo_arquivo = mdfe_abre_arquivo_err($chave_cancela.'-inu.err');
		mdfe_exibe_erro('FRE-105','Falha no Processamento do Arquivo "'.$chave_cancela.'-inu.err"!'.
		$conteudo_arquivo,'');
		mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$chave_cancela.'-inu.err','',true);

		return false;
		}else{
		mdfe_exibe_erro('FRE-106','Falha no Processamento do Arquivo "'.$chave_cancela.'-inu.xml"!','');
		return false;
		}
		}
		}
		*/
		mdfe_exibe_erro('FRE-101','No  pssoivel inutilizar um MDF-e!','');
		return false;
	}
	/////////////////////////////////////////////
	/////////////////INUTILIZAO////////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	/////////////////CANCELAMENTO////////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_cancela($nr_nota){
		$con_nfe =	'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao);
		$versao_c = '1.00';
		//precisa ver a varivel anoMes (acho que vai com a data/hora do cancelamento)
		if (!(file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml'))){
			$xml = new XML();
			//adiciona dados da nota
			$evento = &$xml->createRoot("eventoMDFe");
			$evento->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe' , True);
			$evento->addAttribute('versao', '3.00' , True);
			$cdOrgao = substr($reg_nfe->MDFe_Chave,0,2);
			//if ( substr($reg_nfe->MDFe_Chave,34,1)=='3'){
			//	$cdOrgao = '91';
			//}
			$uf = substr($reg_nfe->MDFe_Chave,0,2);
			$data = substr($reg_nfe->Cancela_DH,0,10);
			$dif_UTC = calcula_horario_verao($data,$uf);
			$cid_enc = $reg_nfe->Encerra_Cidade;
			if ($cid_enc>=9000000){
				$cid_enc=9999999;
				$uf_enc = '99';
			}else{
				$uf_enc = substr($reg_nfe->Encerra_Cidade,0,2);
			}
			$inf_canc = &$evento->addChild("infEvento");
			$inf_canc->addAttribute('Id', 'ID110111'.$reg_nfe->MDFe_Chave.'01', True);
			$inf_canc->addAttribute('cOrgao', $cdOrgao, False);
			$inf_canc->addAttribute('tpAmb', $reg_nfe->MDFe_Ambiente, False);
			$inf_canc->addAttribute('CNPJ', substr($reg_nfe->MDFe_Chave,6,14), False);
			$inf_canc->addAttribute('chMDFe', $reg_nfe->MDFe_Chave, False);
			$inf_canc->addAttribute('dhEvento', str_replace(' ','T',$reg_nfe->Cancela_DH).$dif_UTC, False);
			$inf_canc->addAttribute('tpEvento', '110111', False);
			$inf_canc->addAttribute('nSeqEvento', '1', False);
			$det_evento = &$inf_canc->addChild("detEvento");
			$det_evento->addAttribute('versaoEvento', '3.00' , True);
			$evEnc = &$det_evento->addChild("evCancMDFe");
			$evEnc->addAttribute('descEvento', 'Cancelamento', False);
			$evEnc->addAttribute('nProt', $reg_nfe->MDFe_Protocolo, False);
			$evEnc->addAttribute('xJust', $reg_nfe->Cancela_Motivo_Descricao, False);
			//cria arquivo de consulta do lote da MDF-e na pasta tmp
			$xml->toFile(mdfe_pasta_raiz().'tmp/', '110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.xml');
			mdfe_copia_arquivo('tmp','envio','110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.xml','',false);
		}
		//echo 'teste';
		//return false;
		$retorno = false;
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(mdfe_pasta_raiz().'retorno/'.'110111'.$reg_nfe->MDFe_Chave.'01-eve.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.'110111'.$reg_nfe->MDFe_Chave.'01-eve.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.'110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.err'))){
				$ok = true;
				sleep(10);
				if (file_exists(mdfe_pasta_raiz().'retorno/'.'110111'.$reg_nfe->MDFe_Chave.'01-eve.xml')){
					$retorno = true;
					$status = 'e';
					$motivo = '';
					$protocolo_nr = '';
					$protocolo_dh = '';
					$protocolo_pr = '';
					$protocolo_dv = '';
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno/', '110111'.$reg_nfe->MDFe_Chave.'01-eve.xml', true);
					//le nr do lote no arquivo
					if ($xml->root->name == 'retEventoMDFe'){
						$status = '2';
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name== 'infEvento'){
								$inf_cce = &$xml->root->childs[$key];
								$txt_inf_prot = $xml->root->childs[$key]->toString();
								$status = '1';
							}
						}
					}
					if ($status == '1'){
						//$status = '';
						if ($status == '1'){
							$status = '';
							foreach($inf_cce->atts as $key => $value){
								if ($inf_cce->atts[$key]->name == 'cStat'){
									$status = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'xMotivo'){
									$motivo = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'nProt'){
									$protocolo_nr = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'dhRegEvento'){
									$protocolo_dh = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'verAplic'){
									$protocolo_pr = $inf_cce->atts[$key]->value;
								}
							}
							if (($status!='135')&&
								($status!='136')&&
								($status!='155')){
								$retorno = false;
							}
						}else{
							$status = 'ERR';
							$motivo = 'Informaes da Autorizao do Cancelamento no Encontradas!';
							$retorno = false;
						}
					}else{
						$status = '';
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if ($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						$retorno = false;
					}
					if($retorno){
						//remove arquivo da pasta e coloca na pasta de CCes
						mdfe_copia_arquivo('retorno','SEFAZ/Cancelamento/'.$ano_mes,'110111'.$reg_nfe->MDFe_Chave.'01-eve.xml','',false);
						//monta arquivo distribuio CC-e
						set_time_limit(30);
						sleep(5);
						$Versao_Evento = '1.00';
						$texto_cce = xml_fromFile(
						mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes,
						$reg_nfe->MDFe_Chave.'_110111_01-procEventoMDFe.xml');
						$string = '<?xml version="1.0" encoding="utf-8"?>'.
									//'<procEventoMDFe versao="'.$Versao_Evento.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
									$texto_cce;
									//'</procEventoMDFe>';
						$Handle = fopen(mdfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($Versao_Evento,5).'-procEventoMDFe.xml', 'w');
						$Data = utf8_encode($string);
						fwrite($Handle, $Data);
						fclose($Handle);
						//coloca arquivo ditribuio CCe na pasta de CCe do Ms
						mdfe_copia_arquivo('tmp','SEFAZ/MDF-es/'.$ano_mes.'/Cancelados',$protocolo_nr.'_v'.fill_full($Versao_Evento,5).'-procEventoMDFe.xml','',false);
						//faz update com o protocolo e dh no evento da MDF-e
						set_time_limit(30);
						$upt_nota = 'Update manifesto_carga set'.
									' MDFe_Protocolo_C="'.$protocolo_nr.'", '.
									' MDFe_Protocolo_C_DH="'.$protocolo_dh.'", '.
									' MDFe_Protocolo_C_Sig="'.$protocolo_pr.'", '.
									' MDFe_Situacao="'.$status.'", '.
									' MDFe_Protocolo_C_Motivo="Cancelamento - '.$motivo.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Manifesto="'.$nr_nota.'" ';
									//echo $upt_nota;
						consulta_sql($upt_nota);
						//$retorno = false;
					}else{
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Rejeio do Arquivo da MDF-e pela SEFAZ!'.
									$status.'-'.$motivo.'
								</div>';
						//remove arquivo da pasta e coloca na pasta de erros
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110111'.$reg_nfe->MDFe_Chave.'01-eve.xml','',true);
					}
				}else{
					//exibe mensagem do arquivo de erro
					if (file_exists(mdfe_pasta_raiz().'retorno/'.'110111'.$reg_nfe->MDFe_Chave.'01-eve.err')){
						$conteudo_arquivo = mdfe_abre_arquivo_err('110111'.$reg_nfe->MDFe_Chave.'01-eve.err');
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Falha no Processamento do Arquivo "'.'110111'.$reg_nfe->MDFe_Chave.'01-eve.err"!'.
									$conteudo_arquivo.'
								</div>';
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110111'.$reg_nfe->MDFe_Chave.'01-eve.err','',true);
					}else{
						$conteudo_arquivo = mdfe_abre_arquivo_err('110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.err');
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Falha no Processamento do Arquivo "'.'110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.err"!'.
									$conteudo_arquivo.'
								</div>';
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110111'.$reg_nfe->MDFe_Chave.'01-ped-eve.err','',true);
					}
					$retorno = false;
				}
			}
		}//fim while
		return $retorno;
	}
	/////////////////////////////////////////////
	/////////////////CANCELAMENTO////////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	/////////////////ENCERRAMENTO////////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_encerra($nr_nota){
		$con_nfe =	'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		$ano_mes = mdfe_ano_mes();
		$ano_mes_nf = mdfe_ano_mes($reg_nfe->DH_Emissao);
		$versao_c = '3.00';

		//precisa ver a varivel anoMes (acho que vai com a data/hora do cancelamento)
		if (!(file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml'))){
			$xml = new XML();
			//adiciona dados da nota
			$evento = &$xml->createRoot("eventoMDFe");

			$evento->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe' , True);
			$evento->addAttribute('versao', '3.00' , True);
			$cdOrgao = substr($reg_nfe->MDFe_Chave,0,2);
			//if ( substr($reg_nfe->MDFe_Chave,34,1)=='3'){
			//	$cdOrgao = '91';
			//}

			$uf = substr($reg_nfe->MDFe_Chave,0,2);
			$data = substr($reg_nfe->Cancela_DH,0,10);
			$dif_UTC = calcula_horario_verao($data,$uf);

			$cid_enc = $reg_nfe->Encerra_Cidade;
			if ($cid_enc>=9000000){
				$cid_enc=9999999;
				$uf_enc = '99';
			}else{
				$uf_enc = substr($reg_nfe->Encerra_Cidade,0,2);
			}

			$inf_canc = &$evento->addChild("infEvento");
			$inf_canc->addAttribute('Id', 'ID110112'.$reg_nfe->MDFe_Chave.'01', True);
			$inf_canc->addAttribute('cOrgao', $cdOrgao, False);
			$inf_canc->addAttribute('tpAmb', $reg_nfe->MDFe_Ambiente, False);
			$inf_canc->addAttribute('CNPJ', substr($reg_nfe->MDFe_Chave,6,14), False);
			$inf_canc->addAttribute('chMDFe', $reg_nfe->MDFe_Chave, False);
			$inf_canc->addAttribute('dhEvento', str_replace(' ','T',$reg_nfe->Cancela_DH).$dif_UTC, False);
			$inf_canc->addAttribute('tpEvento', '110112', False);
			$inf_canc->addAttribute('nSeqEvento', '1', False);

			$det_evento = &$inf_canc->addChild("detEvento");
			$det_evento->addAttribute('versaoEvento', '3.00' , True);

			$evEnc = &$det_evento->addChild("evEncMDFe");
			$evEnc->addAttribute('descEvento', 'Encerramento', False);
			$evEnc->addAttribute('nProt', $reg_nfe->MDFe_Protocolo, False);
			//$evEnc->addAttribute('xJust', $reg_nfe->Cancela_Motivo_Descricao, False);
			$evEnc->addAttribute('dtEnc', substr($reg_nfe->Encerra_Data,0,10), False);
			$evEnc->addAttribute('cUF', $uf_enc, False);
			$evEnc->addAttribute('cMun', $cid_enc, False);

			//cria arquivo de consulta do lote da MDF-e na pasta tmp
			$xml->toFile(mdfe_pasta_raiz().'tmp/', '110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.xml');

			mdfe_copia_arquivo('tmp','envio','110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.xml','',false);
		}
		//echo 'teste';
		//return false;

		$retorno = false;
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.err'))){
				$ok = true;
				sleep(10);
				if (file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml')){
					$retorno = true;
					$status = 'e';
					$motivo = '';
					$protocolo_nr = '';
					$protocolo_dh = '';
					$protocolo_pr = '';
					$protocolo_dv = '';
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno/', '110112'.$reg_nfe->MDFe_Chave.'01-eve.xml', true);
					//le nr do lote no arquivo
					if ($xml->root->name == 'retEventoMDFe'){
						$status = '2';
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name== 'infEvento'){
								$inf_cce = &$xml->root->childs[$key];
								$txt_inf_prot = $xml->root->childs[$key]->toString();
								$status = '1';
							}
						}
					}
					if ($status == '1'){
						//$status = '';
						if ($status == '1'){
							$status = '';
							foreach($inf_cce->atts as $key => $value){
								if ($inf_cce->atts[$key]->name == 'cStat'){
									$status = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'xMotivo'){
									$motivo = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'nProt'){
									$protocolo_nr = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'dhRegEvento'){
									$protocolo_dh = $inf_cce->atts[$key]->value;
								}
								if ($inf_cce->atts[$key]->name == 'verAplic'){
									$protocolo_pr = $inf_cce->atts[$key]->value;
								}
							}
							if (($status!='135')&&
								($status!='136')&&
								($status!='155')){
								$retorno = false;
							}
						}else{
							$status = 'ERR';
							$motivo = 'Informaes da Autorizao do Encerramento no Encontradas!';
							$retorno = false;
						}
					}else{
						$status = '';
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if ($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						$retorno = false;
					}

					if($retorno){
						//remove arquivo da pasta e coloca na pasta de CCes
						mdfe_copia_arquivo('retorno','SEFAZ/Encerramento/'.$ano_mes,'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml','',false);
						//monta arquivo distribuio CC-e
						set_time_limit(30);
						sleep(5);
						$Versao_Evento = '3.00';
						//42240112647163000140580010000028431049901749_110112_001-procEventoMDFe
						$nm_encerra = $reg_nfe->MDFe_Chave.'_110112_01-procEventoMDFe.xml';
						if (file_exists(mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf.'/'.$reg_nfe->MDFe_Chave.'_110112_001-procEventoMDFe.xml')){
							$nm_encerra = $reg_nfe->MDFe_Chave.'_110112_001-procEventoMDFe.xml';
						}
						$texto_cce = xml_fromFile(
												mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf,
												$nm_encerra);
						$string =	'<?xml version="1.0" encoding="utf-8"?>'.
									//'<procEventoMDFe versao="'.$Versao_Evento.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
									$texto_cce;
									//'</procEventoMDFe>';
						$Handle = fopen(mdfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($Versao_Evento,5).'-procEventoMDFe.xml', 'w');
						$Data = utf8_encode($string);
						fwrite($Handle, $Data);
						fclose($Handle);
						//coloca arquivo ditribuio CCe na pasta de CCe do Ms
						mdfe_copia_arquivo('tmp','SEFAZ/MDF-es/'.$ano_mes.'/Encerrados',$protocolo_nr.'_v'.fill_full($Versao_Evento,5).'-procEventoMDFe.xml','',false);
						//faz update com o protocolo e dh no evento da MDF-e
						set_time_limit(30);
						$upt_nota = 'Update manifesto_carga set'.
									' MDFe_Protocolo_C="'.$protocolo_nr.'", '.
									' MDFe_Protocolo_C_DH="'.$protocolo_dh.'", '.
									' MDFe_Protocolo_C_Sig="'.$protocolo_pr.'", '.
									' MDFe_Situacao="'.$status.'", '.
									' MDFe_Protocolo_C_Motivo="Encerramento - '.$motivo.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Manifesto="'.$nr_nota.'" ';
									//echo $upt_nota;
						consulta_sql($upt_nota);
						//$retorno = false;
					}else{
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Rejeio do Arquivo da MDF-e pela SEFAZ!'.
									$status.'-'.$motivo.'
								</div>';
						//remove arquivo da pasta e coloca na pasta de erros
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110112'.$reg_nfe->MDFe_Chave.'01-eve.xml','',true);
					}
				}else{
					//exibe mensagem do arquivo de erro
					if (file_exists(mdfe_pasta_raiz().'retorno/'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.err')){
						$conteudo_arquivo = mdfe_abre_arquivo_err('110112'.$reg_nfe->MDFe_Chave.'01-eve.err');
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Falha no Processamento do Arquivo "'.'110112'.$reg_nfe->MDFe_Chave.'01-eve.err"!'.
									$conteudo_arquivo.'
								</div>';
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110112'.$reg_nfe->MDFe_Chave.'01-eve.err','',true);

					}else{
						$conteudo_arquivo = mdfe_abre_arquivo_err('110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.err');
						echo	'<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
									Falha no Processamento do Arquivo "'.'110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.err"!'.
									$conteudo_arquivo.'
								</div>';
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,'110112'.$reg_nfe->MDFe_Chave.'01-ped-eve.err','',true);
					}
					$retorno = false;
				}
			}
		}//fim while
		return $retorno;
	}
	/////////////////////////////////////////////
	/////////////////ENCERRAMENTO////////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	/////////////LOTE DE NOTA FISCAL/////////////
	/////////////////////////////////////////////
	function mdfe_gera_arquivo_lote($lista_nfs){
		$nrand = rand(500,1500);
		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("MontarLoteMDFe");
		foreach($lista_nfs as $key => $nr_nota){
			$nf_inf->addAttribute('ArquivoMDFe', $nr_nota.'-mdfe.xml' , false);
		}
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $nrand.'-montar-lote.xml');
		//$copiou = mdfe_copia_arquivo('tmp','envio_lote',$nrand.'-montar-lote.xml','',false);
		//if ($copiou){
		return $nrand;
		//}else{
		//	return 0;
		//}
	}
	/////////////////////////////////////////////
	/////////////LOTE DE NOTA FISCAL/////////////
	/////////////////////////////////////////////

	/////////////////////////////////////////////
	///////////CONSULTA SIT SEM RECIBO///////////
	/////////////////////////////////////////////

	function mdfe_gera_arquivo_sit_mdfe($chave_mdfe,$tpAmb){
		$xml = new XML();
		//adiciona dados da nota
		$nf_inf = &$xml->createRoot("consSitMDFe");
		$nf_inf->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe' , true);
		$versao = '3.00';
		//if (data2nr(data_atual('data'))>=data2nr('01/07/2012')){
		//	if (substr($chave_mdfe,0,2) != '41'){
		//		$versao = '2.01';
		//	}
		//}
		$nf_inf->addAttribute('versao', $versao , true);
		$nf_inf->addAttribute('tpAmb', $tpAmb , false);
		$nf_inf->addAttribute('xServ', 'CONSULTAR' , false);
		$nf_inf->addAttribute('chMDFe', $chave_mdfe , false);
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $chave_mdfe.'-ped-sit.xml');
		return mdfe_copia_arquivo('tmp','envio',$chave_mdfe.'-ped-sit.xml','',false);
	}
	/////////////////////////////////////////////
	///////////CONSULTA SIT SEM RECIBO///////////
	/////////////////////////////////////////////

?>