<?
	require_once(dirname(__FILE__).'/ie.php');
	require_once(dirname(__FILE__).'/manifesto.php');


	function mdfe_ano_mes($data='',$tipo='AAAAMM'){  //foramto 0000-00-00
		if ($data==''){
			$data = data_atual('date');
		}
		if ($tipo=='AAAAMM'){
			return $data[0].$data[1].
					$data[2].$data[3].
					$data[5].$data[6];
		}else{
			return $data[2].$data[3].
					$data[5].$data[6];
		}
	}

	function mdfe_modulo11($nr_original){
		$soma = 0;
		$k= 2;
		for ($i=strlen($nr_original);$i>0;$i--){
			$soma+= ($nr_original[$i-1] * $k);
			$k++;
			if ($k>9){
				$k = 2;
			}
		}
		$digito = 11 - ($soma%11);
		if ($digito >= 10){
			$digito = 0;
		}
		return $digito;
	}

	function mdfe_retira_texto_excesso($texto,$inicio,$tamanho_max){
		//descobre quantos carates < > " ' & existem no texto
		// o limite vai ser menor se existirem esses caracteres
		//por que no xml eles ocupam mais do que uma posio
		//primeiro tira os primeiros $tamanjho de caracteres caracteres)
		$texto = trim(substr(trim($texto),$inicio,$tamanho_max));
		$texto_final = '';
		//$conta_menor = substr_count($texto_final,'>');
		$tamanho  = strlen($texto);
		$tamanho_total = 0;
		for ($t=0;$t<$tamanho;$t++){
			$tamanho_car = 1;
			if (($texto[$t]=='<')||($texto[$t]=='>')){
				$tamanho_car = 4;
			}else if (($texto[$t]=='"')||($texto[$t]=="'")){
				$tamanho_car = 6;
			}else if ($texto[$t]=='&'){
				$tamanho_car = 5;
			}
			$tamanho_total+=$tamanho_car;
			if ($tamanho_total<=$tamanho_max){
				$texto_final.= $texto[$t];
			}
		}
		return trim($texto_final);
	}

	function mdfe_copia_arquivo($origem,$destino,$arquivo,$nr_nota='',$renomeia=false,$apaga=true){
		//determina nome do arquivo de origem
		$arq_ori = mdfe_pasta_raiz().$origem.'/'.$arquivo;
		//determina nome do arquivo de destino
		$arq_des = mdfe_pasta_raiz().$destino.'/'.$arquivo;
		//se renomeia
		if ($renomeia){
			//arquivo de destino  com a data/hora no incio do mesmo
			$data_hora = data_atual('date').nr2hora(hora_atual());
			$data_hora = str_replace('-','',$data_hora);
			$data_hora = str_replace(':','',$data_hora);
			$arq_des = mdfe_pasta_raiz().$destino.'/'.$data_hora.'_'.$arquivo;
		}
		//verifica se arquivo de origem existe
		if (file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if (!(file_exists(mdfe_pasta_raiz().$destino))){
				//seno cria ela (ano_mes)
				rmkdir(mdfe_pasta_raiz().$destino."/",0777);
			}
			//verifica se destino existe
			if (file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if ($copiou){
				//se a instruo for de apagar o arquivo de origem
				if ($apaga){
					//apaga o arquivo de origem
					unlink($arq_ori);
				}
				return true;
			}else{
				mdfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
											'Verifique a estrutura de pastas do servidor!',$nr_nota);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			mdfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',$nr_nota);
			return false;
		}
	}

	function mdfe_abre_arquivo_err($arquivo){
		//abre arquivo de erro na pasta de retorno
		$temp_file = mdfe_pasta_raiz().'temp_xml/'.$arquivo;
		$arq_base  = mdfe_pasta_raiz().'retorno/'.$arquivo;
		sleep(1);
		if (file_exists($temp_file)){
			unlink($temp_file);
		}
		//echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
		copy($arq_base, $temp_file);
		$linhas_erro = '';
		$array_of_list_values = file($temp_file);
		foreach ($array_of_list_values as $key => $value){
			set_time_limit(30);
			$linhas_erro.= $value;
		}
		unset($array_of_list_values);
		unlink($temp_file);
		//le todo o contedo da pasta
		return nl2br($linhas_erro);
	}

	function mdfe_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf_e/'.$_SESSION["Empresa_Codigo"].'/';
	}
		
	function mdfe_pasta_raiz2($dominio,$empresa){
		return '../arquivos_clientes/'.$dominio.'/mdf_e/'.$empresa.'/';
	}

	function mdfe_pasta_raiz3(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/';
	}

	function mdf_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf/'.$_SESSION["Empresa_Codigo"].'/';
	}

	function mdfe_busca_arquivo($nr_nota, $tipo="xml"){
		$con_mdfe = 'select MDFe_Protocolo,MDFe_Versao,DH_Emissao from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_mdfe = consulta_sql($con_mdfe);
		$reg_mdfe = consulta_ler_objeto($res_mdfe);
		consulta_limpa($res_mdfe);
		if($tipo == "pdf"){
			$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_mdfe->DH_Emissao,'AAAAMM').'/Damdfe/';
			$nm_arq = $reg_mdfe->MDFe_Protocolo.'_v'.fill_full($reg_mdfe->MDFe_Versao,5).'-procMDFe.pdf';
			$mdfe_pdf_caminho=$url_arq;
			if(!is_dir($mdfe_pdf_caminho)){
				rmkdir($mdfe_pdf_caminho);
			}
		}else{
			$nm_arq = $reg_mdfe->MDFe_Protocolo.'_v'.fill_full($reg_mdfe->MDFe_Versao,5).'-procMDFe.xml';
			$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_mdfe->DH_Emissao,'AAAAMM').'/Autorizados/';
		}
		$url_arq.=$nm_arq;
		return $url_arq;
	}

	function mdfe_busca_arquivo_cancela($nr_nota){
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$versao = $reg_nfe->MDFe_Versao;
		if ($reg_nfe->Situacao=='C'){
			if (($reg_nfe->MDFe_Situacao=='101')||($reg_nfe->MDFe_Situacao=='151')){
				$nm_arq = $reg_nfe->MDFe_Protocolo_C.'_v'.fill_full($versao,5).'-procCancMDFe.xml';
				$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Cancelados/'.$nm_arq;
			}else if (($reg_nfe->MDFe_Situacao=='135')||($reg_nfe->MDFe_Situacao=='136')||($reg_nfe->MDFe_Situacao=='155')){
				$nm_arq = $reg_nfe->MDFe_Protocolo_C.'_v'.fill_full('1.00',5).'-procEventoMDFe.xml';
				$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Cancelados/'.$nm_arq;
			}else{
				$url_arq = '';
			}
		}else{
			if (($reg_nfe->MDFe_Situacao=='101')||($reg_nfe->MDFe_Situacao=='151')){
				$nm_arq = $reg_nfe->MDFe_Protocolo_C.'_v'.fill_full($versao,5).'-procCancMDFe.xml';
				$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_nfe->Cancela_DH,'AAAAMM').'/Encerrados/'.$nm_arq;
			}else if (($reg_nfe->MDFe_Situacao=='135')||($reg_nfe->MDFe_Situacao=='136')||($reg_nfe->MDFe_Situacao=='155')){
				$nm_arq = $reg_nfe->MDFe_Protocolo_C.'_v'.fill_full('1.00',5).'-procEventoMDFe.xml';
				$url_arq = mdfe_pasta_raiz().'SEFAZ/MDF-es/'.mdfe_ano_mes($reg_nfe->Cancela_DH,'AAAAMM').'/Encerrados/'.$nm_arq;
			}else{
				$url_arq = '';
			}
		}
		return $url_arq;
	}

	function mdfe_exibe_erro($codigo,$mensagem,$nr_nota){
		//exibe o erro na tela
		echo '<p><font size="2" face="Verdana"><b>'.$codigo.'</b><BR>'.$mensagem.'</font></p><BR><BR>';
		//retorna o status dessa nota para "P"
		mdfe_retorna_mdfe($nr_nota);
	}

	function mdfe_exibe_processamento($fase,$cmpl=''){
		//exibe o erro na tela
		if ($fase == '1'){
			echo '<p><font size="2" face="Verdana">Gerando Arquivo do MDF-e... (1/6)</font></p>';
		}
		if ($fase == '2'){
			echo '<p><font size="2" face="Verdana">Validando e Assinando Arquivo XML... (2/6)</font></p>';
		}
		if ($fase == '3'){
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML... (3/6)</font></p>';
		}
		if ($fase == '4'){
			$tentativa = '';
			if ($cmpl>1){
				$tentativa = '(Tentativa '.$cmpl.')';
			}
			echo '<p><font size="2" face="Verdana">Verificando Autorizao de Uso...'.$tentativa.' (4/6)</font></p>';
		}
		if ($fase == '5'){
			echo '<p><font size="2" face="Verdana">Fechando Documento... (5/6)</font></p>';
		}
		if ($fase == '6'){
			echo '<p><font size="2" face="Verdana">MDF-e '.$cmpl.'! (6/6)</font></p>';
		}
		if ($fase == 'R'){
			echo '<p><font size="2" face="Verdana">Reprocessando o MDF-e!</font></p>';
		}
		if ($fase == 'C1'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' do MDF!</font></p>';
		}
		if ($fase == 'C2_A'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML de '.$operacao.'...</font></p>';
		}
		if ($fase == 'C2_B'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizao';
				$artigo = 'a';
			}else{
				$operacao = 'Cancelamento';
				$artigo = 'o';
			}
			echo '<p><font size="2" face="Verdana">'.$operacao.' do MDF Homologad'.$artigo.'!</font></p>';
		}
		if ($fase == 'C7'){
			if ($cmpl=='I'){
				$operacao = 'Inutilizado';
			}else{
				$operacao = 'Cancelado';
			}
			echo '<p><font size="2" face="Verdana">Manifesto de Documento Fiscal '.$operacao.' com Sucesso!</font></p>';
		}
		if ($fase == 'FS-DA'){
			echo '<p><font size="2" face="Verdana">MDF-es validados com sucesso! Formulrio de Segurana Autorizado!</font></p>';
		}
		flush(); @ob_flush();
		flush(); @ob_flush();
	}

	function mdfe_formata_txt($texto){
		$texto2='';
		$texto1 = strtr(trim($texto), array(";" => ':', "  " => ' ', "'" => '', '"' => '', '' => '-'));
		$texto1 = strtr(trim($texto1), array("\r\n" => ';', "\r" => ';', "\n" => ';'));
		while ($texto1!=$texto2){
			$texto2 = $texto1;
			$texto1 = strtr(trim($texto1), array("  " => ' ', ";;" => ';'));
		}
		return $texto1;
	}

	function mdfe_gera_chave($reg_nfe,$modalidade=0){
		//consulta srie da MDF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie = 'select MDFe_Ambiente,MDFe_TipoEmissao,MDFe_FormatoDAMDFe '.
					' from manifesto_serie '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Modelo="'.$reg_nfe->Modelo.'"'.
					' and Serie="'.$reg_nfe->Serie.'"'.
					' and SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		//gera chave de acesso  MDF-e (caso ainda no possua)
		//so 44 dgitos
		// 02 cdigo UF do emitente
		// 04 ano mes de emisso
		// 14 cnpj emitente
		// 02 Modelo (55)
		// 03 serie
		// 09 nr documento
		// 01 forma emisso
		// 08 aleatrio
		// 01 digitos Mod 11
		if ($modalidade=='5'){
			$reg_serie[1] = $modalidade;
		}
		//pega uf da empresa e consulta cadastro pra saber o numero de referencia
		$con_uf = 'select Codigo_UF from uf '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and UF="'.$reg_nfe->Empresa_UF.'"';
		$res_uf = consulta_sql($con_uf);
		$reg_uf = consulta_ler_linha($res_uf);
		consulta_limpa($res_uf);
		$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao,'AAMM');
		$cnpj    = limpa_numero($reg_nfe->Empresa_CNPJ);
		$serie   = limpa_numero($reg_nfe->Serie);
		$nr_random = '';
		$chave_ok = false;
		while (!$chave_ok){
			$nr_random = fill_full(rand(10, 999), 4).
			fill_full(rand(100,5999),4);
			$chave_ok = ($nr_random!='00000000') && ($nr_random!='11111111') &&
						($nr_random!='22222222') && ($nr_random!='33333333') &&
						($nr_random!='44444444') && ($nr_random!='55555555') &&
						($nr_random!='66666666') && ($nr_random!='77777777') &&
						($nr_random!='88888888') && ($nr_random!='99999999') &&
						($nr_random!='12345678') && ($nr_random!='23456789') &&
						($nr_random!='34567890') && ($nr_random!='45678901') &&
						($nr_random!='56789012') && ($nr_random!='67890123') &&
						($nr_random!='78901234') && ($nr_random!='89012345') &&
						($nr_random!='90123456') && ($nr_random!='01234567');
		}
		$chave_nfe = fill_full($reg_uf[0],2).$ano_mes.
					fill_full($cnpj,14).fill_full($reg_nfe->Modelo,2).
					fill_full($serie,3).fill_full($reg_nfe->NrDoc,9).
					fill_full($reg_serie[1],1).$nr_random;
		$dig_nfe = mdfe_modulo11($chave_nfe);
		$chave_nfe.= $dig_nfe;
		$upd_nota = 'Update manifesto_carga set'.
					' MDFe_Chave="'.$chave_nfe.'",'.
					' MDFe_Ambiente="'.$reg_serie[0].'", '.
					' MDFe_TipoEmissao="'.$reg_serie[1].'", '.
					' MDFe_FormatoDAMDFe="'.$reg_serie[2].'", '.
					' MDFe_Versao="'.config_pad('mdfe_versao').'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$reg_nfe->Nr_Manifesto.'" '.
					' and MDFe_Chave=""';
		consulta_sql($upd_nota,true,1);
		//consulta ultimo registro dessa modalidade de contingencia <> 1
		//dh contingencia e motivo
		if ($reg_serie[1]!='1'){
			$con_cont = 'select * from nota_fiscal_contingencia'.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Modalidade="'.$reg_serie[1].'"'.
						' order by DH_Inicio desc';
			$res_cont = consulta_sql($con_cont);
			$reg_cont = consulta_ler_objeto($res_cont);
			consulta_limpa($res_cont);
			$upd_nota = 'Update manifesto_carga set'.
						' MDFe_Contigencia_DH="'.$reg_cont->DH_Inicio.'", '.
						' MDFe_Contigencia_Motivo="'.$reg_cont->Motivo.'" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto="'.$reg_nfe->Nr_Manifesto.'" '.
						' and Situacao="I"'.
						' and MDFe_Contigencia_DH="0000-00-00 00:00:00"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function mdf_gera_chave($reg_nfe){
		//consulta srie da MDF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie = 'select Layout_Impressao '.
					' from manifesto_serie '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Modelo="'.$reg_nfe->Modelo.'"'.
					' and Serie="'.$reg_nfe->Serie.'"'.
					' and SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		$upd_nota = 'Update manifesto_carga set'.
					' Layout_Impressao="'.$reg_serie[0].'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$reg_nfe->Nr_Manifesto.'" '.
					' and ( (Situacao="A")'.
					'    or (Situacao="P") )';
		consulta_sql($upd_nota,true,1);
	}

	function mdfe_numero($valor,$qtd_zeros=2){
		$valor = (($valor + 1) - 1);
		$valor = number_format($valor,$qtd_zeros,".","");
		return $valor;
	}

	function mdfe_valida_dados_mdfe($nr_nota){
		///valida minimamente os dados da MDF-e para minimizar Rejeies na SEFAZ
		$erros = '';
		//consulta Nota Fiscal
		$con_nota = 'select * from manifesto_carga '.
					' where Dominio="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);
		//validao da placa
		if(strlen($reg_nota->Rodo_Veiculo_Placa)==0){
			$erros.='<BR>Placa do Veculo "'.$reg_nota->Rodo_Veiculo_Placa.'" invlida!';
		}
		//validao da tara
		if(strlen($reg_nota->Rodo_Veiculo_Tara)==0){
			$erros.='<BR>Tara do veculo "'.$reg_nota->Rodo_Veiculo_Tara.'" invlida!';
		}
		if (($reg_nota->Rodo_Reboque1_Placa=="") && ($reg_nota->Rodo_Reboque2_Placa=="")){
			if($reg_nota->Rodo_Veiculo_Capacidade==""){
				$erros.='<BR>Capacidade em KG do Veculo "'.$reg_nota->Rodo_Veiculo_Capacidade.'" invlida!';
			}
		}
		if ($reg_nota->Rodo_Reboque1_Placa!=""){
			//cap e tar reqboques
			if($reg_nota->Rodo_Reboque1_UF==""){
				$erros.='<BR>UF da Placa do Primeiro Veculo "'.$reg_nota->Rodo_Reboque1_UF.'" invlida!';
			}else if($reg_nota->Rodo_Reboque1_Tara==""){
				$erros.='<BR>Tara do Primeiro Veculo "'.$reg_nota->Rodo_Reboque1_Tara.'" invlida!';
			}else if($reg_nota->Rodo_Reboque1_Capacidade==""){
				$erros.='<BR>Capacidade em KG do Primeiro Veculo "'.$reg_nota->Rodo_Reboque1_Capacidade.'" invlida!';
			}
		} 
		if ($reg_nota->Rodo_Reboque2_Placa!=""){
			//cap e tar reqboques
			if($reg_nota->Rodo_Reboque2_UF==""){
				$erros.='<BR>UF da Placa do Segundo Veculo "'.$reg_nota->Rodo_Reboque2_UF.'" invlida!';
			}else if($reg_nota->Rodo_Reboque2_Tara==""){
				$erros.='<BR>Tara do Segundo Veculo "'.$reg_nota->Rodo_Reboque2_Tara.'" invlida!';
			}else if($reg_nota->Rodo_Reboque2_Capacidade==""){
				$erros.='<BR>Capacidade em KG do Segundo Veculo "'.$reg_nota->Rodo_Reboque2_Capacidade.'" invlida!';
			}
		}
		if ($reg_nota->Rodo_Veiculo_Prop_CNPJ!=''){
			if($reg_nota->Rodo_Veiculo_Prop_RNTC==''){
				$erros.='<BR>RNTRC "'.$reg_nota->Rodo_Veiculo_Prop_RNTC.'" invlido!';
			}else if($reg_nota->Rodo_Veiculo_Prop_Nome==''){
				$erros.='<BR>Nome do proprietrio do veculo "'.$reg_nota->Rodo_Veiculo_Prop_Nome.'" invlido!';
			}else if($reg_nota->Rodo_Veiculo_Prop_UF==''){
				$erros.='<BR>UF do proprietrio do veculo "'.$reg_nota->Rodo_Veiculo_Prop_UF.'" invlida!';
			}
		}
		if(($reg_nota->Rodo_Motorista_CPF=="") || (limpa_numero($reg_nota->Rodo_Motorista_CPF)=="00000000000")){
			$erros.='<BR>CPF do motorista "'.$reg_nota->Rodo_Motorista_CPF.'" invlido!';
		}
		$con_car = 'select * from manifesto_carga_motoristas '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto = "'.$nr_nota.'"'.
					' order by Motorista';
		$res_car = consulta_sql($con_car);
		$nrw_car = consulta_num_registros($res_car);
		for($c=0;$c<$nrw_car;$c++){
			$reg_car = consulta_ler_objeto($res_car);
			if(($reg_car->Motorista_CPF=="")||(limpa_numero($reg_car->Motorista_CPF)=="00000000000")){
				$erros.='<BR>CPF "'.$reg_nota->Motorista_CPF.'" invlido!';
			}
		}
		consulta_limpa($res_car);
		//validao emitente
		/*
		//CNPJ
		//if(strlen($reg_nfe->Empresa_CNPJ)<18){
		//    $erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da empresa  invlido!';
		//}
		//vlidar o CNPJ (funo)
		if(!CalculaCNPJ($reg_nfe->Empresa_CNPJ)){
		$erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da Empresa  invlido!';
		}

		//nome
		if(strlen($reg_nfe->Empresa_Razao)<3){
		$erros.='<BR>A Razo Social "'.$reg_nfe->Empresa_Razao.'" da empresa  invlida!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Empresa_Fantasia!='')&&(strlen($reg_nfe->Empresa_Fantasia)<3)){
		$erros.='<BR>O nome fantasia da Empresa  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Empresa_Logradouro)<3){
		$erros.='<BR>O logradouro da Empresa  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Empresa_Bairro)<3){
		$erros.='<BR>O bairro da Empresa  invlido!';
		}
		//CEP
		if(($reg_nfe->Empresa_CEP!='')&&(strlen($reg_nfe->Empresa_CEP)<9)){
		$erros.='<BR>O CEP "'.$reg_nfe->Empresa_CEP.'" da Empresa  invlido!';
		}
		//cidade nome
		if(strlen($reg_nfe->Empresa_Nome_Cidade)<3){
		$erros.='<BR>O nome de cidade da Empresa  invlido!';
		}
		//Cidade nr
		if(($reg_nfe->Empresa_Codigo_Cidade<=0)&&(strlen($reg_nfe->Empresa_Codigo_Cidade)>7)){ //1000000
		$erros.='<BR>O cdigo de cidade da Empresa  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Empresa_Nome_Pais)<3){
		$erros.='<BR>O nome de pas da Empresa  invlido!';
		}
		//pais nr
		if($reg_nfe->Empresa_Codigo_Pais<=0){
		$erros.='<BR>O cdigo de pas da Empresa  invlido!';
		}
		//telefone
		if(strlen($reg_nfe->Empresa_Telefone_Nr)<14){
		$erros.='<BR>O telefone "'.$reg_nfe->Empresa_Telefone_Nr.'" da Empresa  invlido!';
		}
		//UF
		if(strlen($reg_nfe->Empresa_UF)<2){
		$erros.='<BR>A UF da Empresa  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Empresa_Insc_Estadual) != ''){
		if (strtoupper($reg_nfe->Empresa_Insc_Estadual) != 'ISENTO'){
		if (!(ChkInscEstadual($reg_nfe->Empresa_Insc_Estadual, $reg_nfe->Empresa_UF))){
		$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" da Empresa  invlida para "'.$reg_nfe->Dest_UF.'"!';
		}
		}
		}


		//IM/CNAE  //se informar IM informe o CNAE da empresa
		//if($reg_nfe->Empresa_IM!=''){
		//    if(strlen($reg_nfe->Empresa_CNAE)<=0){
		//        $erros.='<BR>O CNAE da Empresa  invlido!';
		//    }
		//}

		//validao destinatrio
		//CNPJ
		if($reg_nfe->Dest_UF!='EX'){  //no valida caso seja estrangeiro
		if(strlen($reg_nfe->Dest_CPF_CNPJ)==14){
		if(!CalculaCPF($reg_nfe->Dest_CPF_CNPJ)){
		$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
		}
		}else if(strlen($reg_nfe->Dest_CPF_CNPJ)==18){
		if(!CalculaCNPJ($reg_nfe->Dest_CPF_CNPJ)){
		$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
		}
		}else{
		$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
		}
		}
		//nome
		if(strlen($reg_nfe->Dest_Razao)<3){
		$erros.='<BR>O razo social do Cliente/Fornecedor  invlido!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Dest_Fantasia!='')&&(strlen($reg_nfe->Dest_Fantasia)<3)){
		$erros.='<BR>O nome fantasia do Cliente/Fornecedor  invlido!';
		}

		//logradouro
		if(strlen($reg_nfe->Dest_Logradouro)<3){
		$erros.='<BR>O logradouro do Cliente/Fornecedor  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Dest_Bairro)<3){
		$erros.='<BR>O bairro do Cliente/Fornecedor  invlido!';
		}
		//CEP
		//if(strlen($reg_nfe->Dest_UF)!='EX'){
		//    if(strlen($reg_nfe->Dest_CEP)<9){
		//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Cliente/Fornecedor  invlido!';
		//    }
		//}
		//cidade nome
		if(strlen($reg_nfe->Dest_Nome_Cidade)<3){
		$erros.='<BR>O nome de cidade do Cliente/Fornecedor  invlido!';
		}
		//Cidade nr
		if($reg_nfe->Dest_Codigo_Cidade<=0){
		$erros.='<BR>O cdigo de cidade do Cliente/Fornecedor  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Dest_Nome_Pais)<3){
		$erros.='<BR>O nome de pas do Cliente/Fornecedor  invlido!';
		}
		//pais nr
		if($reg_nfe->Dest_Codigo_Pais<=0){
		$erros.='<BR>O cdigo de pas do Cliente/Fornecedor  invlido!';
		}

		//UF
		if(strlen($reg_nfe->Dest_UF)<2){
		$erros.='<BR>A UF do Cliente/Fornecedor  invlida!';
		}
		//IE
		if (limpa_mascara($reg_nfe->Dest_Insc_Estadual) != ''){
		if (strtoupper($reg_nfe->Dest_Insc_Estadual) != 'ISENTO'){
		if (!(ChkInscEstadual($reg_nfe->Dest_Insc_Estadual, $reg_nfe->Dest_UF))){
		$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" do Cliente/Fornecedor  invlida para "'.$reg_nfe->Dest_UF.'"!';
		}
		}
		}
		//transportadora
		//CNPJ
		//somente se tivera transportadora definida na NF

		if ($reg_nfe->Transportadora>0){

		if (($reg_nfe->Transp_CPF_CNPJ!='00.000.000/0000-00') ||
		($reg_nfe->Transp_CPF_CNPJ!='000.000.000-00')){

		if(strlen($reg_nfe->Transp_CPF_CNPJ)==14){
		if(!CalculaCPF($reg_nfe->Transp_CPF_CNPJ)){
		$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
		}
		}else if(strlen($reg_nfe->Transp_CPF_CNPJ)==18){
		if(!CalculaCNPJ($reg_nfe->Transp_CPF_CNPJ)){
		$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
		}
		}else{
		$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
		}
		}

		//nome
		if(strlen($reg_nfe->Transp_Nome)<3){
		$erros.='<BR>O nome da Transportadora  invlido!';
		}

		//UF
		if(strlen($reg_nfe->Transp_UF)<2){
		$erros.='<BR>A UF da Transportadora  invlida!';
		}

		//IE
		if (limpa_mascara($reg_nfe->Transp_IE) != ''){
		if (strtoupper($reg_nfe->Transp_IE) != 'ISENTO'){
		if (!(ChkInscEstadual($reg_nfe->Transp_IE, $reg_nfe->Transp_UF))){
		$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Transp_IE.'" da Transportadora  invlida para "'.$reg_nfe->Transp_UF.'"!';
		}
		}
		}

		}
		//consulta Nota Fiscal Item
		$con_item = 'select * from nota_fiscal_item '.
		' where Dominio = "'.$_SESSION['Dominio'].'"'.
		' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' and Nr_Nota = "'.$nr_nota.'"';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrw_item;$i++){
		$reg_item = consulta_ler_objeto($res_item);
		//valida dados do produto
		//Codigo
		//descrio
		if(strlen($reg_item->Prod_Descricao)<3){
		$erros.= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": Descrio do Produto  invlido!';
		}

		//Unidade de medida
		if(strlen($reg_item->Unidade_NF)<1){ //pode sim ter 1 dig
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A unidade de medida  invlida!';
		}
		//NCM (se com IPI ou CFOP comea com 3 ou 7 tem que ter 8 digitos, seno s dois  suficiente)
		if(($reg_item->IPI_Valor>0)||((substr($reg_item->CFOP,0)==3)||(substr($reg_item->CFOP,0)==7))){
		if(strlen($reg_item->Prod_NCM)<10){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuir todos os dez dgitos para operaes com exterior ou com incidncia de IPI!';
		}
		}else if(strlen($reg_item->Prod_NCM)<2){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuiir ao menos os dois primeiros dgitos (gnero) para esta operao!';
		}
		//Origem da Mercadoria (se CFOP = 3) a origem deve ser 1
		if(substr($reg_item->CFOP,0)==3){
		if($reg_item->Origem!='1'){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A origem de mercadoria  invlida! para operaes de importao a origem deve ser obrigatoriamente "2 - Estrangeira"';
		}
		}
		//CSTs de ICMS, IPI, PIS e COFINS (validar se Os CST existem na lista de CSTs)
		if(busca_dados_combo('icms_cst_'.$reg_nfe->Empresa_CRT,$reg_item->ICMS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do ICMS "'.$reg_item->ICMS_CST.'"  invlido!';
		}
		if(busca_dados_combo('ipi_cst',$reg_item->IPI_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do IPI "'.$reg_item->IPI_CST.'"  invlido!';
		}

		if(busca_dados_combo('pis_cst_nf_'.$reg_nfe->TipoES,$reg_item->PIS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do PIS "'.$reg_item->PIS_CST.'"  invlido!';
		}
		if(busca_dados_combo('cofins_cst_nf_'.$reg_nfe->TipoES,$reg_item->COFINS_CST)==''){
		$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do COFINS "'.$reg_item->COFINS_CST.'"  invlido!';
		}
		}
		consulta_limpa($res_item);
		*/
		if ($erros!=''){
			$upd_nota = 'Update manifesto_carga '.
						' set Situacao="P" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto="'.$nr_nota.'" '.
						' and Situacao="I"';
			$res_upd = consulta_sql($upd_nota,true,1);  //retorna para P pois no vai fazer a MDFe
			mdfe_exibe_erro('FRE-602','O Manifesto <b>"'.$reg_nota->NrDoc.'/'.$reg_nota->Serie.'"</b> contm dados invlidos!'.
									'<BR>Corrija os dados e tente o envio navamente!'.$erros.'<BR><BR>',0);
		}
		return ($erros=='');
	}

	//copia arquivo de trnsferencia
	function mdfe_copia_arquivo2($origem,$destino,$arquivo_o,$arquivo_d,$ano_mes){
		//determina nome do arquivo de origem
		$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf_e/'.$origem.'/SEFAZ/MDF-es/'.$ano_mes.'/Autorizados';
		$arq_ori = $pasta_ori.'/'.$arquivo_o;
		//echo 'Arqui Ori'.$arq_ori.'<BR>';
		$ano_mes2 =  mdfe_ano_mes();
		//determina nome do arquivo de destino
		$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf_e/'.$destino.'/SEFAZ/MDF-es/'.$ano_mes2.'/Recebidas';
		$arq_des = $pasta_des.'/'.$arquivo_d;
		//se renomeia
		//echo 'Arqui Dest'.$arq_des.'<BR>';
		//verifica se arquivo de origem existe
		if (file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if (!(file_exists($pasta_des))){
				//seno cria ela (ano_mes)
				rmkdir($pasta_des."/",0777);
			}
			//verifica se destino existe
			if (file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if ($copiou){
				return true;
			}else{
				mdfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
										'Verifique a estrutura de pastas do servidor!',0);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			mdfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',0);
			return false;
		}
	}

	//muda a pasta ano mes da pasta recebidas (edio da data de entrada)
	function mdfe_copia_arquivo3($empresa,$data1,$data2,$arquivo){
		//determina nome do arquivo de origem
		$ano_mes1 = mdfe_ano_mes($data1);
		$ano_mes2 = mdfe_ano_mes($data2);
		if ($ano_mes2!=$ano_mes1){
			$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf_e/'.$empresa.'/SEFAZ/MDF-es/'.$ano_mes1.'/Recebidas';
			$arq_ori = $pasta_ori.'/'.$arquivo;
			//echo 'Arqui Ori'.$arq_ori.'<BR>';
			//determina nome do arquivo de destino
			$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/mdf_e/'.$empresa.'/SEFAZ/MDF-es/'.$ano_mes2.'/Recebidas';
			$arq_des = $pasta_des.'/'.$arquivo;
			//se renomeia
			//echo 'Arqui Dest'.$arq_des.'<BR>';
			//verifica se arquivo de origem existe
			if (file_exists($arq_ori)){
				//verifica se pasta de destino existe
				if (!(file_exists($pasta_des))){
					//seno cria ela (ano_mes)
					rmkdir($pasta_des."/",0777);
				}		
				//verifica se destino existe
				if (file_exists($arq_des)){
					//apaga arquivo de destino caso exista alguma coisa
					unlink($arq_des);
				}
				//efetiva acopia do arquivo
				//echo $arq_ori.'-'.$arq_des.'<BR>';
				$copiou = copy($arq_ori, $arq_des);
				//se fez a copia corretamente
				if ($copiou){
					unlink($arq_ori);
					return true;
				}else{
					mdfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
												'Verifique a estrutura de pastas do servidor!',0);
					return false;
				}
			}else{ //seno
				//exibe erro de arquivo inexistente
				mdfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
											'Verifique a estrutura de pastas do servidor!',0);
				return false;
			}
		}else{
			return true;
		}
	}
	
	///// FUNO PARA VERIFICAR A DATA DE VALIDADE DO CERTIFICADO E EMITIR UM AVISO
	function mdfe_validade_do_certificado(){
		//Gera um arquivo uninfe-cons-inf.xml na pasta de envio ()
		//O retorno  gerado aps o envio com o nome uninfe-ret-cons-inf.xml
		//Tendo esse arquivo de retorno vc ter os dados do uninfe
		//inclusive data ini e data fin
		//tendo data val faz uma comparao com a data atual e se
		//tiver faltando 30 dias emite um aviso no primeiro login do dia.
		$xml2 = new XML();
		$root = &$xml2->createRoot("ConsInf");
		$root->addAttribute('xServ', 'CONS-INF', false);
		$ano_mes_hora  = 'uninfe-cons-inf.xml';
		$xml2->toFile(mdfe_pasta_raiz().'tmp/', $ano_mes_hora);
		$salvou = mdfe_copia_arquivo('tmp','envio',$ano_mes_hora,'',false);
		//$salvou = true;
		$ano_mes = mdfe_ano_mes();
		$data_atual = data_atual('data');
		$dias_falta = 0;
		$tentativa = 0;
		$validade = '';
		//se consegui salvar
		if($salvou){
			$ok = false;
			while (!($ok)){
				set_time_limit(60);
				if ((file_exists(mdfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
					$ok = true;
					sleep(1);
				}else{
					sleep(1);
					$tentativa++;
				}
				if($ok){
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno','uninfe-ret-cons-inf.xml', true);
					if ($xml->root->name == 'retConsInf'){
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name== 'DadosCertificado'){
								$dados_cert = &$xml->root->childs[$key];
								foreach($dados_cert->atts as $key3 => $value2){
									if ($dados_cert->atts[$key3]->name== 'dValFin'){
										$validade = $dados_cert->atts[$key3]->value;
									}
								}
							}
						}
					}
				}
				if($tentativa>=10){
					$ok = true;
				}
			}
			if($validade==''){
				$dias_falta = 'NE';//Data no encontrada
			}else {
				$dt_validade = substr($validade,0,10);
				$dias_falta = (-data2nr($data_atual)+data2nr($dt_validade));
				if ((file_exists(mdfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
					unlink(mdfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
				}
			}
			//$hr_validade
			//$dias_falta = 5;
		}
		$consulta = 'Update param set Conteudo = "'.data_atual('date').'"'.
					' where Dominio="'.$_SESSION["Dominio"].'"'.
					' and Chave = "VALIDA_CERTIFICADO"';
		$ok = consulta_sql($consulta,true,1);
		//unlink(mdfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
		return $dias_falta;
	}

	function consulta_status_mdfe_servico($tp_amb=2){
		$con_uf_empresa = 'select Codigo_Cidade from pessoa_endereco '.
							' where Dominio = "'.$_SESSION['Dominio'].'" '.
							' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'" '.
							' and Situacao <> "E" '.
							' order by Seq_Endereco ASC limit 1';
		$res_uf_empresa = consulta_sql($con_uf_empresa);
		$reg_uf_empresa = consulta_ler_linha($res_uf_empresa);
		consulta_limpa($res_uf_empresa);
		$ano_mes = mdfe_ano_mes();
		$versao_c = '1.00';
		$xml = new XML();
		$root = &$xml->createRoot("consStatServ");
		$root->addAttribute('versao', $versao_c, true);
		$root->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/mdfe', true);
		$root->addAttribute('tpAmb', $tp_amb, false);
		//$root->addAttribute('tpAmb', '1', false);
		$root->addAttribute('cUF',  substr($reg_uf_empresa[0],0,2), false);
		//$root->addAttribute('tpEmis',  '3', false);
		$root->addAttribute('xServ',  'STATUS', false);
		$ano_mes = data_atual('date');
		$hora = nr2hora(hora_atual());
		$ano_mes_hora  = str_replace('-','',$ano_mes).'T'.str_replace(':','',$hora);
		//$ano_mes_hora = 'Outro';
		$xml->toFile(mdfe_pasta_raiz().'tmp/', $ano_mes_hora.'-ped-sta.xml');
		$salvou = mdfe_copia_arquivo('tmp','envio',$ano_mes_hora.'-ped-sta.xml','',false);
		$dh_sefaz = '';
		$data_sefaz = '';
		$hora_sefaz = '';
		$tentativa = 0;
		$diferenca_data = '';
		$diferenca_hora = '';
		$dh_sefaz = '';
		$tempo_medio_sefaz= '';
		$descricao_sefaz= '';
		$codigo_sefaz= '';
		//se consegui salvar
		if ($salvou){
			$ok = false;
			while (!($ok)){
				//set_time_limit(60);
				if ((file_exists(mdfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml'))||
					(file_exists(mdfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err'))){
					$ok = true;
					sleep(5);
					if (file_exists(mdfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml')){
						$xml = new XML();
						$xml->fromFile(mdfe_pasta_raiz().'retorno/',$ano_mes_hora.'-sta.xml', true);
						if ($xml->root->name == 'retConsStatServ'){
							foreach($xml->root->atts as $key2 => $value){
								if ($xml->root->atts[$key2]->name== 'dhRecbto'){
									$dh_sefaz = &$xml->root->atts[$key2]->value;
								}
								if ($xml->root->atts[$key2]->name== 'tMed'){
									$tempo_medio_sefaz = &$xml->root->atts[$key2]->value;
								}
								if ($xml->root->atts[$key2]->name== 'xMotivo'){
									$descricao_sefaz = &$xml->root->atts[$key2]->value;
								}
								if ($xml->root->atts[$key2]->name== 'cStat'){
									$codigo_sefaz = &$xml->root->atts[$key2]->value;
								}
							}
							if(($codigo_sefaz=='107')&&($dh_sefaz!='')){
								//AAAA-MM-DDTHH:MM:SS
								$data_pc = data2nr(data_atual('data'));
								$hora_pc = hora_atual();
								$data_sefaz = substr($dh_sefaz,0,10);
								$hora_sefaz = substr($dh_sefaz,11);
								$data_sefaz = data2nr(dataf($data_sefaz));
								$hora_sefaz = hora2nr($hora_sefaz);
								$diferenca_data = 24*60*60*($data_sefaz-$data_pc);
								$diferenca_hora = ($hora_sefaz-$hora_pc);
								$diferenca = $diferenca_data+($diferenca_hora);
								$update = 'update uf set DH_SEFAZ = '.$diferenca.
											' where Dominio = "'.$_SESSION['Dominio'].'"'.
											' and Codigo_UF = "'.substr($reg_uf_empresa[0],0,2).'"';
								consulta_sql($update);
								unlink(mdfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml');
								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz.'.<BR><BR>Data/Hora: '.dataf((substr($dh_sefaz,0,10))).' '.substr($dh_sefaz,11).'<BR>Tempo mdio: '.$tempo_medio_sefaz.'s';
								//return true;
							}else {
								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz;
							}
						}else{
							$mensagem = 'Falha na estrutura do arquivo XML de retorno!';
							//return false;
						}
					}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err')){
						//exibe mensagem do arquivo de erro
						$conteudo_arquivo = mdfe_abre_arquivo_err($ano_mes_hora.'-ped-sta.err');
						$mensagem = 'Falha no Processamento do Arquivo '.$conteudo_arquivo.'!';
					}else{
						$mensagem = 'Falha no Processamento do Arquivo!';
						//return false;
					}
				}
			}//while
		}else{
			$mensagem = 'Consulta abortada por favor tente mais tarde!';
		}
		return $mensagem;
	}

	function mdfe_calcula_horario_verao($data,$uf){
		$fuso_horario = 3;
		if (($uf=='MT') ||
			($uf=='MS') ||
			($uf=='AM') ||
			($uf=='RO') ||
			($uf=='AC') ||
			($uf=='RR') ||
			($uf=='51') ||
			($uf=='50') ||
			($uf=='13') ||
			($uf=='11') ||
			($uf=='12') ||
			($uf=='14') ){
			$fuso_horario = 4;
		}
		if (($uf=='RS') ||
			($uf=='SC') ||
			($uf=='PR') ||
			($uf=='SP') ||
			($uf=='RJ') ||
			($uf=='ES') ||
			($uf=='MG') ||
			($uf=='GO') ||
			($uf=='MT') ||
			($uf=='MS') ||
			($uf=='DF') ||
			($uf=='TO') ||
			($uf=='43') ||
			($uf=='42') ||
			($uf=='41') ||
			($uf=='35') ||
			($uf=='33') ||
			($uf=='32') ||
			($uf=='31') ||
			($uf=='52') ||
			($uf=='51') ||
			($uf=='50') ||
			($uf=='53') ||
			($uf=='17')   ){
			//esses estados aderem ao horario de versao
			$ano = $data[0].$data[1].$data[2].$data[3];
			//adio de feriados mveis ao calendrio
			$data_procura = data2nr(dataf($data));
			//Pscoa
			//echo ''.$ano;
			$data_pascoa = date("d/m/Y", easter_date($ano));
			list ($dia_pascoa, $mes_pascoa, $ano_pascoa) = explode ("/", $data_pascoa);
			//echo 'Dia pascoa';
			$data_pascoa = fill_full($dia_pascoa,2).'/'.fill_full($mes_pascoa,2).'/'.$ano;
			//echo '<BR>';
			//Domigo de Carnaval
			$dom_carnaval = data2nr($data_pascoa) - 49;
			//echo 'Dom Carnaval'.nr2data($dom_carnaval).'<BR>';
			//terceiro domingo  de agosto
			$dia_outubro = 1;
			for ($m = 1; $m <= 15; $m++){
				if (date ("w", mktime (0, 0, 0, 10, $m, $ano)) == 0){
					//soma 14 dias ao primeiro domingo
					$dia_outubro = $m + 14;
					break;
				}
			}
			//echo 'Dom Ago'.$dia_outubro.'/10/'.$ano.'<BR>';
			$dom_outubro = data2nr($dia_outubro.'/10/'.$ano);
			$dia_fevereiro = 1;
			for ($m = 1; $m <= 15; $m++){
				if (date ("w", mktime (0, 0, 0, 2, $m, $ano)) == 0){
					//soma 14 dias ao primeiro domingo
					$dia_fevereiro = $m + 14;
					break;
				}
			}
			$dom_fevereiro = data2nr($dia_fevereiro.'/02/'.$ano);
			if ($dom_fevereiro == $dom_carnaval){
				$dom_fevereiro+= 7;//proxima semana
			}
			//echo 'data_procura'.nr2data($data_procura).'<BR>'.
			// echo   ';'.nr2data($dom_fevereiro).';'.
			//        ';'.nr2data($dom_outubro).'<BR>';
			$esta_verao = (!(($data_procura>=$dom_fevereiro) &&
							($data_procura<$dom_outubro)));
		}else{
			//os demais no fazem isso
			$esta_verao = false;
		}
		if ($esta_verao){
			$fuso_horario--;
		}
		return '-0'.$fuso_horario.':00';
	}

	function mdfe_busca_ambiente_evento(){
		$retorno = '2';
		$con_serie = 'select MDFe_Ambiente from manifesto_serie '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' and Modelo = "55" '.
					' and Situacao = "A" limit 1';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		if ($reg_serie[0]=='1'){
			$retorno = '1';
		}
		return $retorno;
	}
?>