<?
	//Fase 1 - Gerao Arquivo XML da NF-e
	//Fase 2 - Retorno Numero do Lote ou Erro
	//Fase 3 - Retrono Nmero do Recibo ou Erro
	//Fase 4 - Consulta Situao NF-e (caso j no tenha a situao na pasta)
	//Fase 5 - Retorno Consulta Situao (protocolo)
	//Fase 6 - Fechamento da NF-e e Finalizao do Processo como um todo.

	require_once(dirname(__FILE__).'/mdfe_arquivos.php');

	function mdfe_processa($nr_nota){
		$notas_proc = '';
		//verifica o status da nf gravando no banco o novo status (de  I Iniciado Processo)
		$upd_nota = 'Update manifesto_carga '.
					' set Situacao="I" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" '.
					' and Situacao="P"';
		$res_upd = consulta_sql($upd_nota,true,1);
		//se pode fazer nf-e
		if ($res_upd==1){
			$con_nfe = 'select * from manifesto_carga '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto="'.$nr_nota.'" ';
			$res_nfe = consulta_sql($con_nfe);
			$reg_nfe = consulta_ler_objeto($res_nfe);
			consulta_limpa($res_nfe);
			//se a chave da NFe no est definida
			if ($reg_nfe->MDFe_Chave == ''){
				mdfe_gera_chave($reg_nfe);
			}
			//inicia o processoa da NFe
			return mdfe_processa_fase1($nr_nota);
			//return false;
		}else{ //seno
			// exibe erro na tela dezindo que nenhuma nota aberta se encontra na lista selecionada
			mdfe_exibe_erro('FRE-001','Manifesto de Documento Fiscal selecionado no pode ser enviada! Verifique novamente a lista, aparentemente outro usurio j fez o envio deste MDF-e!',0);
			return false;
		}
	}

	function mdfe_retorna_mdfe($nr_nota){
		if ($nr_nota != ''){
			//retorna o status dessa nota para "P"
			$upd_nota = 'Update manifesto_carga set'.
						' MDFe_Versao_Proc="", '.
						' MDFe_Situacao="", '.
						' MDFe_Lote="", '.
						' MDFe_Recibo="", '.
						' MDFe_Protocolo="", '.
						' MDFe_Protocolo_DH="0000-00-00 00:00:00", '.
						' MDFe_Protocolo_Sig="",'.
						' MDFe_Protocolo_C="", '.
						' MDFe_Protocolo_C_DH="0000-00-00 00:00:00", '.
						' MDFe_Protocolo_C_Sig="", '.
						//' MDFe_Contigencia_DH="0000-00-00 00:00:00", '.
						//' MDFe_Contigencia_Motivo="", '.
						' MDFe_Protocolo_Motivo="", '.
						' Situacao="P" '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Manifesto="'.$nr_nota.'" '.
						' and Situacao="I"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function mdfe_processa_fase1($nr_nota){ //gerao do lote
		mdfe_exibe_processamento('1');
		//consulta a nota no banco de dados e gera os arquivos XML na pasta tmp
		$nf_e = mdfe_gera_arquivo_mdfe($nr_nota);  //$nf_e['nr_nota']; $nf_e['chave_nfe'];
		//se a chave da nfe for vazia
		if ($nf_e!=''){  //no teve erro no processo de gerao do arquivo
			$copiou = mdfe_copia_arquivo('tmp','envio',$nf_e.'-mdfe.xml',$nr_nota);
			//$copiou = false;
			if ($copiou){ //sem erro na cpia para a pasta envio
				return mdfe_processa_fase2($nr_nota);
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	function mdfe_processa_fase2($nr_nota,$parar=false){
		if (!($parar)){
			mdfe_exibe_processamento('2');
		}
		//consulta dados da NF-e
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//fica testando at ter o retrono do lote ou arquivo de erro
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-mdfe.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-num-lot.xml')||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml')))){
				$ok = true;
				//espera 5 segundos
				sleep(5);
				//avalia se tem arquivo de retrono de erro do lote
				$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao);
				if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml')){
					return mdfe_processa_fase5($nr_nota,1);
				}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-mdfe.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Chave.'-mdfe.err');
					//copia arquivo de erro para a patas erros
					mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Chave.'-mdfe.err',$nr_nota,true);
					mdfe_exibe_erro('FRE-006','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Chave.'-mdfe.xml"!'.
					$conteudo_arquivo,$nr_nota);
					return false;
				}else{
					//seno  por que gerou o arquivo de lote
					//abre o arquivo de lote para pegar o nmero do lote
					$nr_lote = 0;
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno/', $reg_nfe->MDFe_Chave.'-num-lot.xml', true);
					//le nr do lote no arquivo
					if ($xml->root->name == 'DadosLoteNfe'){ //DadosLoteMDfe
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'NumeroLoteGerado'){
								$nr_lote = fill_full($xml->root->atts[$key]->value,15);
							}
						}
					}
					//se leu arquivo de lote
					if ($nr_lote >0){
						//copia arquivo de lote para a pasta de lotes enviados
						mdfe_copia_arquivo('retorno','SEFAZ/Lotes/'.$ano_mes,$reg_nfe->MDFe_Chave.'-num-lot.xml','');
						//salva nr do lote na NF-e
						$upd_nota = 'Update manifesto_carga set'.
									' MDFe_Lote="'.$nr_lote.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Manifesto="'.$nr_nota.'" '.
									' and Situacao="I"';
						consulta_sql($upd_nota,true,1);
						//incializa novo processo
						return mdfe_processa_fase3($nr_nota);
					}else{  //seno
						if ($parar){// se vai tentar denovo
							//copia arquivo de lote para a pasta de erros
							mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Chave.'-num-lot.xml','',true);
							mdfe_exibe_erro('FRE-007','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Chave.'-num-lot.xml"!'.
														'No foi possvel ler o nmero do lote de MDF-e!',$nr_nota);
							return false;
						}else{
							//tenta denovo (s mais essa vez
							return mdfe_processa_fase2($nr_nota,true);
						}
					}
				}
			}
		}
	}

	function mdfe_processa_fase3($nr_nota){
		mdfe_exibe_processamento('3');
		$ok = false;
		//consulta nr dados da NF-e
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao);
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-rec.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-env-lot.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-rec.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml'))){
				$ok = true;
				//espera 5 segundos
				sleep(10);
				//avalia se tem arquivo de retrono de erro do lote
				if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Lote.'-pro-rec.err');
					mdfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Lote.'-pro-rec.err"!'.
					$conteudo_arquivo,$nr_nota);
					mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Lote.'-pro-rec.err','',true);
					return false;
				}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Chave.'-pro-rec.err');
					mdfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Chave.'-pro-rec.err"!'.
					$conteudo_arquivo,$nr_nota);
					mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Chave.'-pro-rec.err','',true);
					return false;
				}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Lote.'-rec.err');
					mdfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Lote.'-rec.err"!'.
					$conteudo_arquivo,$nr_nota);
					mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Lote.'-rec.err','',true);
					return false;
				}else if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-env-lot.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Lote.'-env-lot.err');
					mdfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Lote.'-env-lot.err"!'.
					$conteudo_arquivo,$nr_nota);
					mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Lote.'-env-lot.err','',true);
					return false;
				}else if ((file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.xml'))||
				          (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml'))){
					return mdfe_processa_fase5($nr_nota,1);
				}else{
					//seno  por que gerou o arquivo de recibo
					//abre o arquivo de recibo para pegar o status e motivo do recibo
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno/', $reg_nfe->MDFe_Lote.'-rec.xml', true);
					//le nr do lote no arquivo
					$status='';
					$motivo='';
					if ($xml->root->name == 'retEnviMDFe'){
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if ($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name == 'infRec'){
								$inf_rec = &$xml->root->childs[$key];
							}
						}
					}
					//se o stauts for de lote processado
					if ($status == '103'){
						//tenta ler o nr do recibo
						$nr_recibo = 0;
						foreach($inf_rec->atts as $key => $value){
							if ($inf_rec->atts[$key]->name == 'nRec'){
								$nr_recibo = $inf_rec->atts[$key]->value;
							}
						}
						//fecha arquivo
						//se leu o numero do recibo
						if ($nr_recibo > 0){   //salva nr do recibo na NF-e
							mdfe_copia_arquivo('retorno','SEFAZ/Recibos/'.$ano_mes,$reg_nfe->MDFe_Lote.'-rec.xml','',false);
							$upd_nota = 'Update manifesto_carga set'.
										' MDFe_Recibo="'.$nr_recibo.'" '.
										' where Dominio ="'.$_SESSION['Dominio'].'"'.
										' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' and Nr_Manifesto="'.$nr_nota.'" '.
										' and Situacao="I"';
							consulta_sql($upd_nota,true,1);
							//faz uma espera inicial de 15 segundos (nova norma)
							sleep(15);
							//no precisa fazer a consulta pois ela foi feita automaticamente
							if (file_exists(mdfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								return mdfe_processa_fase5($nr_nota,1);
							}else{
								return mdfe_processa_fase4($nr_nota,1);
							}
						}else{  //seno
							mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Lote.'-rec.xml','',true);
							mdfe_exibe_erro('FRE-009','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Lote.'-rec.xml"!'.
														'No foi possvel ler o nmero do recibo de MDF-e!',$nr_nota);
							return false;
						}
					}else{
						//fecha arquivo
						//copia arquivo de lote para a pasta de erros
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->MDFe_Lote.'-rec.xml','',true);
						mdfe_exibe_erro('FRE-010','Rejeio do Arquivo de MDF-e pela SEFAZ!'.
						'"'.$status.'" - '.$motivo.'<BR><BR>'.
						'Corrija os dados deste manifesto e faa o envio novamente!',$nr_nota);
						return false;
					}
				}
			}
		}
	}

	function mdfe_processa_fase4($nr_nota,$tentativa){
		mdfe_exibe_processamento('4',$tentativa);
		//consulta dados da NF-e
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		mdfe_gera_arquivo_consulta($nr_nota);
		//copia da pasta tmp para a pasta envio
		$copiou = mdfe_copia_arquivo('tmp','envio',$reg_nfe->MDFe_Recibo.'-ped-rec.xml','');

		if ($copiou){
			return mdfe_processa_fase5($nr_nota,$tentativa);
		}else{
			return false;
		}
	}

	function mdfe_processa_fase5($nr_nota,$tentativa=1){
		//consulta dados NF-e
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = mdfe_ano_mes($reg_nfe->DH_Emissao);
		//fica tentando at encontra o arquivo de retorno
		$ok = false;
		//consulta nr dados da NF-e
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if ((file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Recibo.'-pro-rec.err'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Recibo.'-pro-rec.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.xml'))||
				(file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml')) ){
				$ok = true;
				set_time_limit(60);
				sleep(10);
				set_time_limit(60);
				if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Recibo.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = mdfe_abre_arquivo_err($reg_nfe->MDFe_Recibo.'-pro-rec.err');
					mdfe_exibe_erro('FRE-011','Falha no Processamento do Arquivo "'.$reg_nfe->MDFe_Recibo.'-pro-rec.err"!'.
					$conteudo_arquivo,'');
					return false;
				}else{
					//abre arquivo de retorno da consulta
					$nr_recibo = $reg_nfe->MDFe_Recibo;
					if ($reg_nfe->MDFe_Lote!=''){
						if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Lote.'-pro-rec.xml')){
							$nr_recibo = $reg_nfe->MDFe_Lote;
						}
					}
					if (file_exists(mdfe_pasta_raiz().'retorno/'.$reg_nfe->MDFe_Chave.'-pro-rec.xml')){
						$nr_recibo = $reg_nfe->MDFe_Chave;
					}
					$status='';
					$motivo='';
					$xml = new XML();
					$xml->fromFile(mdfe_pasta_raiz().'retorno/', $nr_recibo.'-pro-rec.xml', true);
					//le nr do lote no arquivo
					if (($xml->root->name == 'retConsReciMDFe')||($xml->root->name == 'retMDFe')){
						foreach($xml->root->atts as $key => $value){
							if ($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if ($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name == 'protMDFe'){
								$prot_nfe = &$xml->root->childs[$key];
							}
						}
					}
					//pega status do lote
					if ($status == '105'){  //lote ainda no processado aguarda e tenta denovo
						//fecha arquivo da consulta
						//copia para a pasta erros
						mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',true);
						//aguarda mais 10 segundos
						sleep(10);
						return mdfe_processa_fase4($nr_nota,$tentativa+1);
					}else if (($status == '104')||($status == '100')){
						//le dados do protocolo de recebimento da NFe
						ignore_user_abort(1);
						$status = '';
						$motivo = '';
						$protocolo_nr = '';
						$protocolo_dh = '';
						$protocolo_pr = '';
						$protocolo_dv = '';
						$txt_inf_prot = '';
						foreach($prot_nfe->childs as $key => $value){
							if ($prot_nfe->childs[$key]->name == 'infProt'){
								$txt_inf_prot = $prot_nfe->childs[$key]->toString();
								foreach($prot_nfe->childs[$key]->atts as $key2 => $value){
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'cStat'){
										$status = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'xMotivo'){
										$motivo = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'verAplic'){
										$protocolo_pr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'dhRecbto'){
										$protocolo_dh = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'nProt'){
										$protocolo_nr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if ($prot_nfe->childs[$key]->atts[$key2]->name == 'digVal'){
										$protocolo_dv = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
								}
							}
						}
						//grava dados do protocolo da NF-e
						set_time_limit(60);
						$upd_nota = 'Update manifesto_carga set'.
									' MDFe_Situacao="'.$status.'", '.
									' MDFe_Protocolo_Motivo="'.$motivo.'", '.
									' MDFe_Versao_Proc="'.$protocolo_pr.'", '.
									' MDFe_Protocolo_DH="'.str_replace('T',' ',$protocolo_dh).'", '.
									' MDFe_Protocolo="'.$protocolo_nr.'", '.
									' MDFe_Protocolo_Sig="'.$protocolo_dv.'" '.
									' where Dominio ="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' and Nr_Manifesto="'.$nr_nota.'" '.
									' and Situacao="I"';
						consulta_sql($upd_nota,true,1);
						set_time_limit(60);
						//le statsu da NF-e
						if (($status == '100')||($status == '150')){
							//fecha arquivo da consulta
							sleep(10);
							set_time_limit(60);
							//copia para a pasta de recibos
							mdfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',false);
							//foi autorizada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de aurorizada
							//abre o arquivo da NF-e da pasta backup/autorizadas
							//echo mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes.
							//     $reg_nfe->MDFe_Chave.'-mdfe.xml';
							$texto_nfe = xml_fromFile(mdfe_pasta_raiz().'backup/Autorizados/'.$ano_mes,$reg_nfe->MDFe_Chave.'-mdfe.xml');
							//echo $texto_nfe;
							//arquivo assinado est na pasta de nfes autorizadas
							//a autorizao j foi lida anteriormente ($prot_nfe)
							$string = '<?xml version="1.0" encoding="utf-8"?>'.
										'<mdfeProc xmlns="http://www.portalfiscal.inf.br/mdfe" versao="'.$reg_nfe->MDFe_Versao.'">'.
										$texto_nfe.
										'<protMDFe versao="'.$reg_nfe->MDFe_Versao.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
										$txt_inf_prot.
										'</protMDFe>'.
										'</mdfeProc>';
							$Handle = fopen(mdfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-procMDFe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							mdfe_copia_arquivo('tmp','SEFAZ/MDF-es/'.$ano_mes.'/Autorizados',$protocolo_nr.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-procMDFe.xml','',false);
							set_time_limit(60);
							return mdfe_processa_fase6($nr_nota,true);
						}else if (($status == '301')||
									($status == '302')){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de recibos
							mdfe_copia_arquivo('retorno','SEFAZ/Denegacao/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',false);
							//foi denegada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de denegadas
							$texto_nfe = xml_fromFile(mdfe_pasta_raiz().'backup/Denegados/'.$ano_mes,$reg_nfe->MDFe_Chave.'-den.xml');
							//arquivo assinado est na pasta de nfes autorizadas
							//a autorizao j foi lida anteriormente ($prot_nfe)
							$string = '<?xml version="1.0" encoding="utf-8"?>'.
										'<mdfeProc xmlns="http://www.portalfiscal.inf.br/mdfe" versao="'.$reg_nfe->MDFe_Versao.'">'.
										$texto_nfe.
										'<protMDFe versao="'.$reg_nfe->MDFe_Versao.'" xmlns="http://www.portalfiscal.inf.br/mdfe">'.
										$txt_inf_prot.
										'</protMDFe>'.
										'</mdfeProc>';
							$Handle = fopen(mdfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-procMDFe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							mdfe_copia_arquivo('tmp','SEFAZ/MDF-es/'.$ano_mes.'/Denegadas',$protocolo_nr.'_v'.fill_full($reg_nfe->MDFe_Versao,5).'-procMDFe.xml','',false);
							//exibe mensagem na tela sobre a denegao de uso
							mdfe_exibe_erro('FRE-013','A SEFAZ no autorizou o uso de MDF-e!'.
														'"'.$status.'" - '.$motivo.'<BR><BR>'.
														'Conforme determina a legislao, essa nota no poder ser utilizada!'.
														'Entre em contato com a SEFAZ do seu Estado para obter mais informaes!','');
							set_time_limit(60);
							return mdfe_processa_fase6($nr_nota,false);
						}else if ($status == '204'){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de erros
							mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',true);
							//exibe mensagem na tela sobre a denegao de uso
							mdfe_exibe_erro('FRE-014','Falha no processamento do Lote de MDF-e!'.
														'"'.$status.'" - '.$motivo.'<BR><BR>'.
														'Faa o reenvio da nota fiscal para concluir o processamento!','');
							$upd_nota = 'Update manifesto_carga set '.
										' MDFe_Recibo = "", '.
										' MDFe_Protocolo="" '.
										' where Dominio ="'.$_SESSION['Dominio'].'"'.
										' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' and Nr_Manifesto="'.$nr_nota.'" '.
										' and Situacao="I"';
							consulta_sql($upd_nota,true,1);
							set_time_limit(60);
							return false;		
						}else{
							//outro tipo de rejeio
							mdfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',true);
							mdfe_exibe_erro('FRE-015','Rejeio do Arquivo de MDF-e pela SEFAZ!'.
														'"'.$status.'" - '.$motivo.'<BR><BR>'.
														'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
							//funo retorna false (no fez a nota corretamente)
							return false;
						}
					}else{
						$conteudo_arquivo = mdfe_abre_arquivo_err($nr_recibo.'-pro-rec.xml');
						mdfe_exibe_erro('FRE-012','Rejeio do Arquivo de MDF-e pela SEFAZ!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
						return false;
					}
				}
			}
		}
	}

	function mdfe_processa_fase6($nr_nota,$ok){
		//fecha a nota
		set_time_limit(60);
		mdfe_exibe_processamento('5');
		if ($ok){
			$status_nf = 'F';
			$desc_nfe = 'Autorizado';
		}else{
			//apenas muda o status (MDF-e Denegada)
			$status_nf = 'C';
			$desc_nfe = 'Denegado';
		}
		$upd_nota = 'Update manifesto_carga set'.
					' Situacao="'.$status_nf.'" '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" '.
					' and Situacao="I"';
		$res_nota = consulta_sql($upd_nota,true,1);
		set_time_limit(60);
		if (($res_nota==1)&&($ok)){
			manifesto_fechamento($nr_nota, $_SESSION["Empresa_Codigo"]);
		}else if ($res_nota==1){
			//volta saldo como se estivesse inutilizando
			//manifesto_cancela($nr_nota, 'D');
		}
		mdfe_exibe_processamento('6',$desc_nfe);
		return $ok;
	}

	function mdfe_cancela($nr_nota,$op){
		$con_nfe = 'select * from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		if ($reg_nfe->MDFe_Chave == ''){
			manifesto_valida_persistencia($nr_nota,$_SESSION["Empresa_Codigo"]);
			mdfe_gera_chave($reg_nfe);
		}
		if ($op=='C'){
			$nf_e = mdfe_gera_arquivo_cancela($nr_nota);
		}else{
			$nf_e = mdfe_gera_arquivo_inutiliza($nr_nota);
		}
		return $nf_e;
	}
	
	function manifesto_encerramento($nr_nota){
		$con_nfe = 'select Modelo from manifesto_carga '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Manifesto="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		if ($reg_nfe->Modelo=='58'){
			echo '<div id="retorno" style="text-family: verdana; text-size: 18px; text-align: center; margin-top: 100px; ">
					Enviando pedido de Encerramento do MDF-e!
				  </div>';
			$ok = mdfe_gera_arquivo_encerra($nr_nota);
		}else{
			$ok = true;
		}
		return $ok;
	}
?>