<?
	require_once(dirname(__FILE__).'/nfe_funcoes.php');

	function nota_fiscal_gera_arquivo_nf($nr_nota){
		//reavalia persistncias da nota e dos itens
		//consulta corpo da nota
		$con_nota = 'select * from nota_fiscal '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota = "'.$nr_nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);
		if ($reg_nota->Situacao!='F'){
			nota_fiscal_valida_persistencia($nr_nota);
			nota_fiscal_item_valida_persistencia($nr_nota);
			//consulta corpo da nota
			$con_nota = 'select * from nota_fiscal '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Nota = "'.$nr_nota.'"';
			$res_nota = consulta_sql($con_nota);
			$reg_nota = consulta_ler_objeto($res_nota);
			consulta_limpa($res_nota);
		}
		nf_gera_chave($reg_nota);
		$con_nota = 'select * from nota_fiscal '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota = "'.$nr_nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);
		//cria objeto xml
		$xml = new XML();
		//adiciona dados da nota
		$r = &$xml->createRoot("NF");
		$nf_inf = &$r->addChild("infNF");
		$nf_inf->addAttribute('versao', '1.00', false);
		$nf_inf->addAttribute('layout_impressao', $reg_nota->Layout_Impressao, false);
		//chave da NFe
		$ide = &$nf_inf->addChild("ide");
		//natureza de operao
		$ide->addAttribute('natOp', $reg_nota->Nat_Op_Descricao , false);
		$ide->addAttribute('CFOP', $reg_nota->Nat_Op_CFOP , false);
		//modelo
		$ide->addAttribute('mod', $reg_nota->Modelo , false);
		//serie
		$ide->addAttribute('serie', $reg_nota->Serie , false);
		//nr doc
		$ide->addAttribute('nNF', $reg_nota->NrDoc , false);
		//data de emissao
		$ide->addAttribute('dEmi', datad(dataf($reg_nota->DH_Emissao)) , false);
		//data de saida
		$ide->addAttribute('dSaiEnt', datad(dataf($reg_nota->DH_EntSai)) , false);
		$ide->addAttribute('hSaiEnt', substr($reg_nota->DH_EntSai,11,8) , false);
		//tipo entrada saida
		$ide->addAttribute('tpNF', $reg_nota->TipoES, false);
		//cidade fato gerador
		$ide->addAttribute('cMunFG', $reg_nota->Cidade_FG, false);
		//adiciona dados do emitente
		$emit = &$nf_inf->addChild("emit");
		if (strlen(limpa_numero($reg_nota->Empresa_CNPJ))==14){
			//cnpj do emitente
			$emit->addAttribute('CNPJ', limpa_numero($reg_nota->Empresa_CNPJ), false);
		}else{
			//cpf emitente                       //cpf do emitente
			$emit->addAttribute('CPF', limpa_numero($reg_nota->Empresa_CNPJ), false);
		}
		//nome/razao
		$emit->addAttribute('xNome', substr($reg_nota->Empresa_Razao,0,60), false);
		if (($reg_nota->Empresa_Fantasia != '')&&
			(strlen($reg_nota->Empresa_CNPJ)>14)){
			//fantasia
			$emit->addAttribute('xFant', substr($reg_nota->Empresa_Fantasia,0,60), false);
		}
		//endereco do emitente
		$emit_end = &$emit->addChild("enderEmit");
		//logradouro
		$emit_end->addAttribute('xLgr', substr($reg_nota->Empresa_Logradouro,0,60), false);
		//numero
		if (trim($reg_nota->Empresa_Numero) != ''){
			$emit_end->addAttribute('nro', substr($reg_nota->Empresa_Numero,0,60), false);
		}else{
			$emit_end->addAttribute('nro', 'S/N', false);
		}
		//complemento
		if (trim($reg_nota->Empresa_Complemento) != ''){
			$emit_end->addAttribute('xCpl', substr($reg_nota->Empresa_Complemento,0,60), false);
		}
		//bairro
		$emit_end->addAttribute('xBairro', substr($reg_nota->Empresa_Bairro,0,60), false);
		//nr cidade
		$emit_end->addAttribute('cMun', $reg_nota->Empresa_Codigo_Cidade, false);
		//nome cidade
		$emit_end->addAttribute('xMun', substr($reg_nota->Empresa_Nome_Cidade,0,60), false);
		//uf
		$emit_end->addAttribute('UF', $reg_nota->Empresa_UF, false);
		//CEP
		if (($reg_nota->Empresa_CEP != '00000-000')&&
			(limpa_numero($reg_nota->Empresa_CEP) != '')){
			$emit_end->addAttribute('CEP', limpa_numero($reg_nota->Empresa_CEP), false);
		}
		//cod pas
		$emit_end->addAttribute('cPais', $reg_nota->Empresa_Codigo_Pais, false);
		//nome pas
		$emit_end->addAttribute('xPais', $reg_nota->Empresa_Nome_Pais, false);
		//telefone
		if (limpa_numero($reg_nota->Empresa_Telefone_Nr) != ''){
			$emit_end->addAttribute('Fone', $reg_nota->Empresa_Telefone_Nr, false);
		}
		//demais dados do emitente
		//IE
		$emit->addAttribute('IE', $reg_nota->Empresa_Insc_Estadual, false);
		//IE ST
		if (limpa_numero($reg_nota->Empresa_IE_ST) != ''){
			$emit->addAttribute('IEST', $reg_nota->Empresa_IE_ST, false);
		}
		//IM
		if ((limpa_numero($reg_nota->Empresa_IM) != '')&&
			(limpa_numero($reg_nota->Empresa_CNAE) != '')){
			$emit->addAttribute('IM', $reg_nota->Empresa_IM, false);
			//}
			//CNAE
			//if (limpa_numero($reg_nota->Empresa_CNAE) != ''){
			$emit->addAttribute('CNAE', $reg_nota->Empresa_CNAE, false);
		}
		$con_empresa = 'select EMail from pessoa '.
						' where Dominio="'.$reg_nota->Empresa.'"'.
						' and Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		$emit->addAttribute('email', $reg_nota->EMail, false);
		//regime Simples Nacional
		//adiciona dados do destinatrio
		$dest = &$nf_inf->addChild("dest");
		if ($reg_nota->Dest_UF == 'EX'){
			$dest->addAttribute('CNPJ', '', false);
		}else{
			if (strlen(limpa_numero($reg_nota->Dest_CPF_CNPJ))==14){
				//cnpj do emitente
				$dest->addAttribute('CNPJ', limpa_numero($reg_nota->Dest_CPF_CNPJ), false);
			}else{
				//cpf emitente                       //cpf do emitente
				$dest->addAttribute('CPF', limpa_numero($reg_nota->Dest_CPF_CNPJ), false);
			}
		}
		//nome/razao
		$dest->addAttribute('xNome', substr($reg_nota->Dest_Razao,0,60), false);
		//endereco do destinatario
		$dest_end = &$dest->addChild("enderDest");
		//logradouro
		$dest_end->addAttribute('xLgr', substr($reg_nota->Dest_Logradouro,0,60), false);
		//numero
		if (trim($reg_nota->Dest_Numero) != ''){
			$dest_end->addAttribute('nro', substr($reg_nota->Dest_Numero,0,60), false);
		}else{
			$dest_end->addAttribute('nro', 'S/N', false);
		}
		//complemento
		if (trim($reg_nota->Dest_Complemento) != ''){
			$dest_end->addAttribute('xCpl', substr($reg_nota->Dest_Complemento,0,60), false);
		}
		//bairro
		$dest_end->addAttribute('xBairro', substr($reg_nota->Dest_Bairro,0,60), false);
		//nr cidade
		$dest_end->addAttribute('cMun', $reg_nota->Dest_Codigo_Cidade, false);
		//nome cidade
		$dest_end->addAttribute('xMun', substr($reg_nota->Dest_Nome_Cidade,0,60), false);
		//uf
		$dest_end->addAttribute('UF', $reg_nota->Dest_UF, false);
		//CEP
		if (($reg_nota->Dest_CEP != '00000-000')&&
			(limpa_numero($reg_nota->Dest_CEP) != '')){
			$dest_end->addAttribute('CEP', limpa_numero($reg_nota->Dest_CEP), false);
		}
		//cod pas
		$dest_end->addAttribute('cPais', $reg_nota->Dest_Codigo_Pais, false);
		//nome pas
		$dest_end->addAttribute('xPais', $reg_nota->Dest_Nome_Pais, false);
		//telefone
		if (limpa_numero($reg_nota->Dest_Telefone_Nr) != ''){
			$dest_end->addAttribute('Fone', $reg_nota->Dest_Telefone_Nr, false);
		}
		//demais dados do destinatario
		//IE
		$dest->addAttribute('IE', $reg_nota->Dest_Insc_Estadual, false);
		//SUFRAMA
		if (limpa_numero($reg_nota->Dest_Suframa) != ''){
			$dest->addAttribute('ISUF', $reg_nota->Dest_Suframa, false);
		}
		//EMail
		if ($reg_nota->Dest_EMail != ''){
			$dest->addAttribute('email', $reg_nota->Dest_EMail, false);
		}
		//consulta itens da NF
		$con_itens = 'select * from nota_fiscal_item'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota = "'.$nr_nota.'"'.
					' order by Seq_Item';
		$res_itens = consulta_sql($con_itens);
		$nrw_itens = consulta_num_registros($res_itens);
		//para cada item da nota
		for($itens=0;$itens<$nrw_itens;$itens++){
			$reg_itens = consulta_ler_objeto($res_itens);
			//adiciona dados dos itens ao arquivo
			$det = &$nf_inf->addChild("det");
			//seq do item na NF
			$det->addAttribute('nItem', ($itens+1), true);
			//dados do produto
			$prod = &$det->addChild("prod");
			//cdigo do produto/servio
			if ($reg_itens->Codigo_Produto==''){ //no  um produto (caso de complementao)
				$prod->addAttribute('cProd', 'CFOP'.limpa_numero($reg_itens->CFOP), false);
			}else{
				$prod->addAttribute('cProd', $reg_itens->Codigo_Produto, false);
			}
			if ((strlen($reg_itens->Barra_Produto) == 8) ||
				(strlen($reg_itens->Barra_Produto) >= 12)){
				$prod->addAttribute('cEAN', $reg_itens->Barra_Produto, false);
			}else{
				$prod->addAttribute('cEAN', '', false);
			}
			$prod->addAttribute('xProd', substr($reg_itens->Prod_Descricao,0,120), false);
			$prod->addAttribute('NCM', limpa_numero($reg_itens->Prod_NCM), false);
			if ($reg_itens->Prod_NCM_Ex != ''){
				//ex
				$prod->addAttribute('EXTIPI', fill_full($reg_itens->Prod_NCM_Ex,2), false);
			}
			//cfop
			$prod->addAttribute('CFOP', $reg_itens->CFOP, false);
			//unidade de medida
			$prod->addAttribute('uCom', $reg_itens->Unidade_Estoque, false);
			//quantidade
			$prod->addAttribute('qCom', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 digitos
			//valor unitrio
			if ($reg_itens->Quantidade_Estoque > 0 ){
				$prod->addAttribute('vUnCom', nfe_numero($reg_itens->Valor_Unitario,4), false); //4 digitos
			}else{
				$prod->addAttribute('vUnCom', nfe_numero(0,4), false); //4 digitos
			}
			//valor total
			if ($reg_itens->Quantidade_Estoque > 0 ){
				$prod->addAttribute('vProd', nfe_numero(($reg_itens->Valor_Total+$reg_itens->Valor_Desconto),2), false);
			}else{
				$prod->addAttribute('vProd', nfe_numero(0,2), false);
			}
			///ean da unidade tributvel
			if ((strlen($reg_itens->Barra_Produto) == 8) ||
				(strlen($reg_itens->Barra_Produto) >= 12)){
				$prod->addAttribute('cEANTrib', $reg_itens->Barra_Produto, false);
			}else{
				$prod->addAttribute('cEANTrib', '', false);
			}
			//frete
			if ($reg_itens->Valor_Frete>0){
				$prod->addAttribute('vFrete', nfe_numero($reg_itens->Valor_Frete,2), false);
			}
			//seguro
			if ($reg_itens->Valor_Seguro>0){
				$prod->addAttribute('vSeg', nfe_numero($reg_itens->Valor_Seguro,2), false);
			}
			//desconto
			if ($reg_itens->Valor_Desconto>0){
				$prod->addAttribute('vDesc', nfe_numero($reg_itens->Valor_Desconto,2), false);
			}
			//outros
			if ($reg_itens->Valor_Outros>0){
				$prod->addAttribute('vOutro', nfe_numero($reg_itens->Valor_Outros,2), false);
			}
			//adiciona dados dos impostos (ICMS,IPI,PIS,COFINS,ISS)
			$imposto = &$det->addChild("imposto");
			if ($reg_itens->Prod_Depart != 0){// produto
				$icms = &$imposto->addChild("ICMS");
				$cst = $reg_itens->ICMS_CST;
				$icms_cst = &$icms->addChild("ICMSTrib");
				//origem
				$icms_cst->addAttribute('orig', $reg_itens->Origem, false);
				//cst
				$icms_cst->addAttribute('CST', $cst, false);
				if ($cst == '00'){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
				}
				if ($cst == '10'){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
					//modalidade st
					$icms_cst->addAttribute('modBCST', $reg_itens->ICMSST_Modal, false);
					if ($reg_itens->ICMSST_MVA > 0){
						//mva
						$icms_cst->addAttribute('pMVAST', nfe_numero($reg_itens->ICMSST_MVA), false);
					}
					if ($reg_itens->ICMSST_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBCST', nfe_numero($reg_itens->ICMSST_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBCST', nfe_numero($reg_itens->ICMSST_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMSST', nfe_numero($reg_itens->ICMSST_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMSST', nfe_numero($reg_itens->ICMSST_Valor), false);
				}
				if ($cst == '20'){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					if ($reg_itens->ICMS_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBC', nfe_numero($reg_itens->ICMS_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
				}
				if ($cst == '30'){
					//modalidade st
					$icms_cst->addAttribute('modBCST', $reg_itens->ICMSST_Modal, false);
					if ($reg_itens->ICMSST_MVA > 0){
						//mva
						$icms_cst->addAttribute('pMVAST', nfe_numero($reg_itens->ICMSST_MVA), false);
					}
					if ($reg_itens->ICMSST_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBCST', nfe_numero($reg_itens->ICMSST_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBCST', nfe_numero($reg_itens->ICMSST_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMSST', nfe_numero($reg_itens->ICMSST_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMSST', nfe_numero($reg_itens->ICMSST_Valor), false);
				}
				if ($cst == '51'){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					if ($reg_itens->ICMS_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBC', nfe_numero($reg_itens->ICMS_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
				}
				if ($cst == '60'){
					//base
					$icms_cst->addAttribute('vBCSTRet', nfe_numero($reg_itens->ICMSST_Retido_BC), false);
					//valor
					$icms_cst->addAttribute('vICMSSTRet', nfe_numero($reg_itens->ICMSST_Retido_Valor), false);
				}
				if ($cst == '70'){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					//reducao
					$icms_cst->addAttribute('pRedBC', nfe_numero($reg_itens->ICMS_Reducao), false);
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
					//modalidade st
					$icms_cst->addAttribute('modBCST', $reg_itens->ICMSST_Modal, false);
					if ($reg_itens->ICMSST_MVA > 0){
						//mva
						$icms_cst->addAttribute('pMVAST', nfe_numero($reg_itens->ICMSST_MVA), false);
					}
					if ($reg_itens->ICMSST_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBCST', nfe_numero($reg_itens->ICMSST_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBCST', nfe_numero($reg_itens->ICMSST_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMSST', nfe_numero($reg_itens->ICMSST_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMSST', nfe_numero($reg_itens->ICMSST_Valor), false);
				}
				if (($cst == '90')||($cst=='900')){
					//modalidade
					$icms_cst->addAttribute('modBC', $reg_itens->ICMS_Modal, false);
					//base
					$icms_cst->addAttribute('vBC', nfe_numero($reg_itens->ICMS_BC), false);
					if ($reg_itens->ICMS_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBC', nfe_numero($reg_itens->ICMS_Reducao), false);
					}
					//aliquota
					$icms_cst->addAttribute('pICMS', nfe_numero($reg_itens->ICMS_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMS', nfe_numero($reg_itens->ICMS_Valor), false);
					//modalidade st
					$icms_cst->addAttribute('modBCST', $reg_itens->ICMSST_Modal, false);
					if ($reg_itens->ICMSST_MVA > 0){
						//mva
						$icms_cst->addAttribute('pMVAST', nfe_numero($reg_itens->ICMSST_MVA), false);
					}
					if ($reg_itens->ICMSST_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBCST', nfe_numero($reg_itens->ICMSST_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBCST', nfe_numero($reg_itens->ICMSST_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMSST', nfe_numero($reg_itens->ICMSST_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMSST', nfe_numero($reg_itens->ICMSST_Valor), false);
				}
				if ($reg_itens->ICMS_Partilha_UF != ''){
					if (($cst=='10')||
						($cst=='90')){
						//perc bc
						$icms_cst->addAttribute('pBCOp', nfe_numero($reg_itens->ICMS_Partilha_BC_Perc), false);
						$uf = $reg_itens->ICMS_Partilha_UF;
						if ($uf=='O'){
							$uf = $reg_nota->Empresa_UF;
						}else if ($uf=='D'){
							$uf = $reg_nota->Dest_UF;
						}
						//valor
						$icms_cst->addAttribute('UFST', $uf, false);
					}
					if ($cst=='41'){
						//base retida
						$icms_cst->addAttribute('vBCSTRet', nfe_numero($reg_itens->ICMSST_Retido_BC), false);
						//valore retido
						$icms_cst->addAttribute('vICMSSTRet', nfe_numero($reg_itens->ICMSST_Retido_Valor), false);
						//base destino
						$icms_cst->addAttribute('vBCSTDest', nfe_numero($reg_itens->ICMSST_Destino_BC), false);
						//valore destino
						$icms_cst->addAttribute('vICMSSTDest', nfe_numero($reg_itens->ICMSST_Destino_Valor), false);
					}
				}
				if (($cst=='201')||($cst=='202')||($cst=='203')){
					//modalidade st
					$icms_cst->addAttribute('modBCST', $reg_itens->ICMSST_Modal, false);
					if ($reg_itens->ICMSST_MVA > 0){
						//mva
						$icms_cst->addAttribute('pMVAST', nfe_numero($reg_itens->ICMSST_MVA), false);
					}
					if ($reg_itens->ICMSST_Reducao > 0){
						//reducao
						$icms_cst->addAttribute('pRedBCST', nfe_numero($reg_itens->ICMSST_Reducao), false);
					}
					//base
					$icms_cst->addAttribute('vBCST', nfe_numero($reg_itens->ICMSST_BC), false);
					//aliquota
					$icms_cst->addAttribute('pICMSST', nfe_numero($reg_itens->ICMSST_Percentual), false);
					//valor
					$icms_cst->addAttribute('vICMSST', nfe_numero($reg_itens->ICMSST_Valor), false);
				}
				if (($cst=='500')||($cst=='900')){
					//base
					$icms_cst->addAttribute('vBCSTRet', nfe_numero($reg_itens->ICMSST_Retido_BC), false);
					//valor
					$icms_cst->addAttribute('vICMSSTRet', nfe_numero($reg_itens->ICMSST_Retido_Valor), false);
				}
				if (($cst=='101')||($cst=='201')||($cst=='900')){
					//aliquota
					$icms_cst->addAttribute('pCredSN', nfe_numero($reg_itens->ICMSSN_Perc), false);
					//valor
					$icms_cst->addAttribute('vCredICMSSN', nfe_numero($reg_itens->ICMSSN_Valor), false);
				}
				//ipi
				if ($reg_itens->IPI_CST != ''){
					$ipi = &$imposto->addChild("IPI");
					//classe
					if ($reg_itens->IPI_Classe!= ''){
						$ipi->addAttribute('clEnq', $reg_itens->IPI_Classe, false);
					}
					//fabricante
					if (strlen(limpa_numero($reg_itens->IPI_Fabricante_CNPJ))== 14){
						$ipi->addAttribute('CNPJProd', limpa_numero($reg_itens->IPI_Fabricante_CNPJ), false);
					}
					//selo
					if ($reg_itens->IPI_Selo_Nr != ''){
						$ipi->addAttribute('cSelo', $reg_itens->IPI_Selo_Nr, false);
					}
					//qtd
					if ($reg_itens->IPI_Selo_Qtd>0){
						$ipi->addAttribute('qSelo', nfe_numero($reg_itens->IPI_Selo_Qtd,0), false);
					}
					//enquadramento legal
					$enq = $reg_itens->IPI_Codigo_Equad_Legal;
					if ($enq==''){
						$enq='999';
					}
					$ipi->addAttribute('cEnq', fill_full($enq,3), false);
					$cst_ipi = $reg_itens->IPI_CST;
					if ($reg_nota->TipoES=='1'){
						$cst_ipi+=50;
					}
					if (($reg_itens->IPI_CST == '00')||
						($reg_itens->IPI_CST == '49')){
						$ipi_cst = &$ipi->addChild("IPITrib");
						//cst
						$ipi_cst->addAttribute('CST', $cst_ipi, false);
						if ($reg_itens->IPI_ValorUnidade >0){
							//quantidade trib
							$ipi_cst->addAttribute('qUnid', nfe_numero($reg_itens->Quantidade_Estoque,4), false);//4 digitos
							//valor por unidade
							$ipi_cst->addAttribute('vUnid', nfe_numero($reg_itens->IPI_ValorUnidade,4), false);
						}else{
							//base de cculo
							$ipi_cst->addAttribute('vBC', nfe_numero($reg_itens->IPI_BC), false);
							//aliquota
							$ipi_cst->addAttribute('pIPI', nfe_numero($reg_itens->IPI_Aliquota), false);
						}
						//valor
						$ipi_cst->addAttribute('vIPI', nfe_numero($reg_itens->IPI_Valor), false);
					}else{
						$ipi_cst = &$ipi->addChild("IPITrib");
						//cst
						$ipi_cst->addAttribute('CST', $cst_ipi, false);
					}
				}
				//ii
			}
			//pis
			$pis = &$imposto->addChild("PIS");
			//por aliquota
			if (($reg_itens->PIS_CST=='01')||
				($reg_itens->PIS_CST=='02')){
				$pis_cst = &$pis->addChild("PISTrib");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				//base
				$pis_cst->addAttribute('vBC', nfe_numero($reg_itens->PIS_BC), false);
				//aliq
				$pis_cst->addAttribute('pPIS', nfe_numero($reg_itens->PIS_Aliquota), false);
				//valor
				$pis_cst->addAttribute('vPIS', nfe_numero($reg_itens->PIS_Valor), false);
			}else if ($reg_itens->PIS_CST=='03'){
				$pis_cst = &$pis->addChild("PISTrib");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				//qtd trib
				$pis_cst->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
				//valor por unidade
				$pis_cst->addAttribute('vAliqProd', nfe_numero($reg_itens->PIS_ValorUnidade,4), false); //4 casas
				//valor
				$pis_cst->addAttribute('vPIS', nfe_numero($reg_itens->PIS_Valor), false);
			}else if ($reg_itens->PIS_CST>=49){ //outros
				$pis_cst = &$pis->addChild("PISTrib");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
				if ($reg_itens->PIS_ValorUnidade >0){
					//qtd trib
					$pis_cst->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$pis_cst->addAttribute('vAliqProd', nfe_numero($reg_itens->PIS_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$pis_cst->addAttribute('vBC', nfe_numero($reg_itens->PIS_BC), false);
					//aliq
					$pis_cst->addAttribute('pPIS', nfe_numero($reg_itens->PIS_Aliquota), false);
				}//valor
				$pis_cst->addAttribute('vPIS', nfe_numero($reg_itens->PIS_Valor), false);
			}else{ //no tributado
				$pis_cst = &$pis->addChild("PISTrib");
				//cst
				$pis_cst->addAttribute('CST', $reg_itens->PIS_CST, false);
			}
			//pis st
			if (($reg_itens->PIS_ST_ValorUnidade >0)||
				($reg_itens->PIS_ST_Aliquota>0)){
				$pis_st = &$imposto->addChild("PISST");
				if ($reg_itens->PIS_ST_ValorUnidade >0){
					//qtd trib
					$pis_st->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$pis_st->addAttribute('vAliqProd', nfe_numero($reg_itens->PIS_ST_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$pis_st->addAttribute('vBC', nfe_numero($reg_itens->PIS_ST_BC), false);
					//aliq
					$pis_st->addAttribute('pPIS', nfe_numero($reg_itens->PIS_ST_Aliquota), false);
				}//valor
				$pis_st->addAttribute('vPIS', nfe_numero($reg_itens->PIS_ST_Valor), false);
			}
			//cofins
			$cofins = &$imposto->addChild("COFINS");
			//por aliquota
			if (($reg_itens->COFINS_CST=='01')||
				($reg_itens->COFINS_CST=='02')){
				$cofins_cst = &$cofins->addChild("COFINSTrib");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				//base
				$cofins_cst->addAttribute('vBC', nfe_numero($reg_itens->COFINS_BC), false);
				//aliq
				$cofins_cst->addAttribute('pCOFINS', nfe_numero($reg_itens->COFINS_Aliquota), false);
				//valor
				$cofins_cst->addAttribute('vCOFINS', nfe_numero($reg_itens->COFINS_Valor), false);
			}else if ($reg_itens->COFINS_CST=='03'){
				$cofins_cst = &$cofins->addChild("COFINSTrib");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				//qtd trib
				$cofins_cst->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
				//valor por unidade
				$cofins_cst->addAttribute('vAliqProd', nfe_numero($reg_itens->COFINS_ValorUnidade,4), false); //4 casas
				//valor
				$cofins_cst->addAttribute('vCOFINS', nfe_numero($reg_itens->COFINS_Valor), false);
			}else if ($reg_itens->COFINS_CST>=49){ //outros
				$cofins_cst = &$cofins->addChild("COFINSTrib");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
				if ($reg_itens->COFINS_ValorUnidade >0){
					//qtd trib
					$cofins_cst->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$cofins_cst->addAttribute('vAliqProd', nfe_numero($reg_itens->COFINS_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$cofins_cst->addAttribute('vBC', nfe_numero($reg_itens->COFINS_BC), false);
					//aliq
					$cofins_cst->addAttribute('pCOFINS', nfe_numero($reg_itens->COFINS_Aliquota), false);
				}//valor
				$cofins_cst->addAttribute('vCOFINS', nfe_numero($reg_itens->COFINS_Valor), false);
			}else{ //no tributado
				$cofins_cst = &$cofins->addChild("COFINSTrib");
				//cst
				$cofins_cst->addAttribute('CST', $reg_itens->COFINS_CST, false);
			}
			//cofins st
			if (($reg_itens->COFINS_ST_ValorUnidade >0)||
				($reg_itens->COFINS_ST_Aliquota>0)){
				$cofins_st = &$imposto->addChild("COFINSST");
				if ($reg_itens->COFINS_ST_ValorUnidade >0){
					//qtd trib
					$cofins_st->addAttribute('qBCProd', nfe_numero($reg_itens->Quantidade_Estoque,4), false); //4 casas
					//valor por unidade
					$cofins_st->addAttribute('vAliqProd', nfe_numero($reg_itens->COFINS_ST_ValorUnidade,4), false); //4 casas
				}else{
					//base
					$cofins_st->addAttribute('vBC', nfe_numero($reg_itens->COFINS_ST_BC), false);
					//aliq
					$cofins_st->addAttribute('pCOFINS', nfe_numero($reg_itens->COFINS_ST_Aliquota), false);
				}//valor
				$cofins_st->addAttribute('vCOFINS', nfe_numero($reg_itens->COFINS_ST_Valor), false);
			}
			//iss
			if ($reg_itens->Prod_Depart == 0){//somente servico tem iss
				$iss = &$imposto->addChild("ISSQN");
				//base
				if ($reg_itens->ISS_CST!='I'){
					$iss->addAttribute('vBC', nfe_numero($reg_itens->ISS_BC), false);
				}else{
					$iss->addAttribute('vBC', nfe_numero($reg_itens->ISS_BC), false);
				}//aliquota
				$iss->addAttribute('vAliq', nfe_numero($reg_itens->ISS_Aliquota), false);
				//valor
				if ($reg_itens->ISS_CST!='I'){
					$iss->addAttribute('vISSQN', nfe_numero($reg_itens->ISS_Valor), false);
				}else{
					$iss->addAttribute('vISSQN', nfe_numero(0), false);
				}
				//municiopo fato gerador
				$iss->addAttribute('cMunFG', $reg_itens->ISS_Cidade_FG, false);
				$codigo_servico = $reg_itens->Servico_Codigo;
				$con_desc = 'select Descricao, Codigo_SP from tipo_servico '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Codigo_Servico="'.$reg_itens->Servico_Codigo.'"';
				$res_desc = consulta_sql($con_desc);
				$reg_desc = consulta_ler_linha($res_desc);
				consulta_limpa($res_desc);
				if ($reg_nota->Layout_Impressao=='4'){
					$codigo_servico = $reg_desc[1];
					$con_desc = 'select Descricao from tipo_servico_codigo '.
								'where Codigo_Servico ="'.$reg_desc[1].'"';
					$res_desc = consulta_sql($con_desc);
					$reg_desc = consulta_ler_linha($res_desc);
					consulta_limpa($res_desc);
				}
				if ($reg_nota->Layout_Impressao=='5'){
					$codigo_servico = ' ';//$reg_desc[1];
					$con_desc = 'select Descricao from tipo_servico_codigo '.
								'where Codigo_Servico ="'.$reg_desc[1].'"';
					$res_desc = consulta_sql($con_desc);
					$reg_desc = consulta_ler_linha($res_desc);
					consulta_limpa($res_desc);
				}
				$desc = nfe_formata_txt($reg_desc[0]);
				//servico
				$iss->addAttribute('cListServ', $codigo_servico, false);
				//cst iss
				$iss->addAttribute('cSitTrib', $reg_itens->ISS_CST, false);
				//descrio servio
				$iss->addAttribute('xListServ', $desc, false);
				//echo '</textarea>';
				//consulta nome e uf da cidade do fato gerador
				$con_desc = 'select Nome,UF from cidade '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Codigo_Cidade="'.$reg_itens->ISS_Cidade_FG.'"';
				$res_desc = consulta_sql($con_desc);
				$reg_desc = consulta_ler_linha($res_desc);
				consulta_limpa($res_desc);
				//nome da cidade
				$iss->addAttribute('xMun', $reg_desc[0], false);
				//uf da cidade
				$iss->addAttribute('UF', $reg_desc[1], false);
			}
			$obs = nfe_formata_txt($reg_itens->Observacao);
			//consulta obs do item
			$con_obs = 'select * from nota_fiscal_obs'.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' and Nr_Nota = "'.$nr_nota.'"'.
						' and Seq_Item="'.$reg_itens->Seq_Item.'"'.
						' and TipoObs="P" '.
						' group by Texto_Completo '.
						' order by Seq_Obs ';
			$res_obs = consulta_sql($con_obs);
			$nrw_obs = consulta_num_registros($res_obs);
			//para cada obs
			for($o=0;$o<$nrw_obs;$o++){
				$reg_obs = consulta_ler_objeto($res_obs);
				//adiciona a desc detalhada deste item
				if ($obs!=''){
					$obs.=';';
				}
				$obs.= nfe_formata_txt($reg_obs->Texto_Completo);
			}
			consulta_limpa($res_obs);
			//se tiver desc detalhada
			if (($_SESSION['Dominio']==351)||($_SESSION['Dominio']==352)){
				if ($reg_nota->Layout_Impressao==2){
					if (($itens+1)==$nrw_itens){
						$obs.= nfe_formata_txt('<PARCELAS>');
					}
				}
			}
			if ($obs!=''){
				//adiciona as informaes adiconadis do item
				$det->addAttribute('infAdProd', trim($obs), false);
			}
		}
		consulta_limpa($res_itens);
		//adiciona os totais da NF
		$totais = &$nf_inf->addChild("total");
		//totias do ICMS
		$icms_tot = &$totais->addChild("ICMSTot");
		//base
		$icms_tot->addAttribute('vBC', nfe_numero($reg_nota->Total_ICMS_BC), false);
		//valor
		$icms_tot->addAttribute('vICMS', nfe_numero($reg_nota->Total_ICMS_Valor), false);
		//base st
		$icms_tot->addAttribute('vBCST', nfe_numero($reg_nota->Total_ICMS_ST_BC), false);
		//valor st
		$icms_tot->addAttribute('vST', nfe_numero($reg_nota->Total_ICMS_ST_Valor), false);
		//total pro/serv
		$icms_tot->addAttribute('vProd', nfe_numero( ($reg_nota->Total_Produtos + $reg_nota->Total_Servicos + $reg_nota->Total_Desconto)), false);
		//frete
		$icms_tot->addAttribute('vFrete', nfe_numero($reg_nota->Total_Frete), false);
		//seguro
		$icms_tot->addAttribute('vSeg', nfe_numero($reg_nota->Total_Seguro), false);
		//desconto
		$icms_tot->addAttribute('vDesc', nfe_numero($reg_nota->Total_Desconto), false);
		//ii
		$icms_tot->addAttribute('vII', nfe_numero($reg_nota->Total_II), false);
		//ipi
		$icms_tot->addAttribute('vIPI', nfe_numero($reg_nota->Total_IPI), false);
		//pis
		$icms_tot->addAttribute('vPIS', nfe_numero($reg_nota->Total_PIS), false);
		//cofins
		$icms_tot->addAttribute('vCOFINS', nfe_numero($reg_nota->Total_COFINS), false);
		//outro
		$icms_tot->addAttribute('vOutro', nfe_numero($reg_nota->Total_Outros), false);
		//total NF
		$icms_tot->addAttribute('vNF', nfe_numero($reg_nota->Total_NF), false);
		//totais do ISS (somente se tiver servios)
		if ($reg_nota->Total_Servicos > 0){
			$iss_tot = &$totais->addChild("ISSQNtot");
			//total dos servicos
			$iss_tot->addAttribute('vServ', nfe_numero($reg_nota->Total_Servicos), false);
			//base
			$iss_tot->addAttribute('vBC', nfe_numero($reg_nota->Total_ISS_BC), false);
			//valor
			$iss_tot->addAttribute('vISS', nfe_numero($reg_nota->Total_ISS_Valor), false);
			//pis
			$iss_tot->addAttribute('vPIS', nfe_numero($reg_nota->Total_ISS_PIS_Valor), false);
			//cofins
			$iss_tot->addAttribute('vCOFINS', nfe_numero($reg_nota->Total_ISS_COFINS_Valor), false);
		}
		//totais retidos
		if (($reg_nota->Total_Retido_PIS > 0)||
			($reg_nota->Total_Retido_COFINS > 0)||
			($reg_nota->Total_Retido_CSLL_Valor > 0)||
			($reg_nota->Total_Retido_IRRF_Valor > 0)||
			($reg_nota->Total_CSLL_Valor > 0)||
			($reg_nota->Total_IRRF_Valor > 0)||
			($reg_nota->Total_Retido_PrevSocial_Valor > 0)){
			$ret_tot = &$totais->addChild("retTrib");
		}
		if ($reg_nota->Total_Retido_PIS > 0){
			//pis
			$ret_tot->addAttribute('vRetPIS', nfe_numero($reg_nota->Total_Retido_PIS), false);
		}
		if ($reg_nota->Total_Retido_COFINS > 0){
			//cofins
			$ret_tot->addAttribute('vRetCOFINS', nfe_numero($reg_nota->Total_Retido_COFINS), false);
		}
		if (($reg_nota->Total_Retido_CSLL_Valor > 0)||($reg_nota->Total_CSLL_Valor > 0)){
			//csll
			$ret_tot->addAttribute('vRetCSLL', nfe_numero($reg_nota->Total_Retido_CSLL_Valor+$reg_nota->Total_CSLL_Valor), false);
		}
		if (($reg_nota->Total_Retido_IRRF_Valor > 0)||( $reg_nota->Total_IRRF_Valor > 0 )){
			//irrf base
			$ret_tot->addAttribute('vBCIRRF', nfe_numero($reg_nota->Total_Retido_IRRF_BC+$reg_nota->Total_IRRF_BC), false);
			//irrf valor
			$ret_tot->addAttribute('vIRRF', nfe_numero($reg_nota->Total_Retido_IRRF_Valor+$reg_nota->Total_IRRF_Valor), false);
		}
		if ($reg_nota->Total_Retido_PrevSocial_Valor > 0){
			//base prev
			$ret_tot->addAttribute('vBCRetPrev', nfe_numero($reg_nota->Total_Retido_PrevSocial_BC), false);
			//valor prev
			$ret_tot->addAttribute('vRetPrev', nfe_numero($reg_nota->Total_Retido_PrevSocial_Valor), false);
		}
		//dados do frete
		$transp = &$nf_inf->addChild("transp");
		//modalidade de frete
		$tp_frete = $reg_nota->FretePor;
		if ($tp_frete == '0'){  //terceiros
			$tp_frete ='2';
		}else if ($tp_frete == '1'){  //emitente
			$tp_frete = '0';
		}else if ($tp_frete == '2'){  //dest
			$tp_frete = '1';
		}  //9  sem frete
		$transp->addAttribute('modFrete', $tp_frete, false);
		//se tiver transportadora
		if ($reg_nota->Transportadora > 0){
			//adiciona dados da transportadora
			$transporta = &$transp->addChild("transporta");
			//cfp/ccnpj
			if (strlen(limpa_numero($reg_nota->Transp_CPF_CNPJ)) == 11){
				if (limpa_numero($reg_nota->Transp_CPF_CNPJ) != '00000000000'){
					$transporta->addAttribute('CPF', limpa_numero($reg_nota->Transp_CPF_CNPJ), false);
				}
			}
			if (strlen(limpa_numero($reg_nota->Transp_CPF_CNPJ)) == 14){
				if (limpa_numero($reg_nota->Transp_CPF_CNPJ) != '00000000000000'){
					$transporta->addAttribute('CNPJ', limpa_numero($reg_nota->Transp_CPF_CNPJ), false);
				}
			}
			if (trim(substr($reg_nota->Transp_Nome,0,60))!= ''){
				$transporta->addAttribute('xNome', trim(substr($reg_nota->Transp_Nome,0,60)), false);
			}
			if ( (strlen(limpa_numero($reg_nota->Transp_CPF_CNPJ)) == 14)&&
				($reg_nota->Transp_UF != '')&&
				(limpa_numero($reg_nota->Transp_CPF_CNPJ) != '00000000000000')){
				if ($reg_nota->Transp_IE != ''){
					$transporta->addAttribute('IE', $reg_nota->Transp_IE, false);
				}
			}
			if (trim($reg_nota->Transp_Endereco)!=''){
				$ender = trim($reg_nota->Transp_Logradouro);
				if (trim($reg_nota->Transp_Numero) != ''){
					$ender.= ', '.trim($reg_nota->Transp_Numero);
				}else{
					$ender.= ', S/N';
				}
				if (trim($reg_nota->Transp_Complemento) != ''){
					$ender.= ' '.trim($reg_nota->Transp_Complemento);
				}
				$transporta->addAttribute('xEnder', trim(substr($ender,0,60)), false);
			}
			if (trim($reg_nota->Transp_Cidade_Nome)!=''){
				$transporta->addAttribute('xMun', trim(substr($reg_nota->Transp_Cidade_Nome,0,60)), false);
			}
			if (trim($reg_nota->Transp_UF)!=''){
				$transporta->addAttribute('UF', $reg_nota->Transp_UF, false);
			}
		}
		//se tiver reteno do frete
		if ($reg_nota->Frete_Valor_Serv >0){
			//adiciona dados dessa reteno
			$ret_transp = &$transp->addChild("retTransp");
			//valor servico
			$ret_transp->addAttribute('vServ', nfe_numero($reg_nota->Frete_Valor_Serv), false);
			//base
			$ret_transp->addAttribute('vBCRet', nfe_numero($reg_nota->Frete_Retido_ICMS_BC), false);
			//aliq
			$ret_transp->addAttribute('pICMSRet', nfe_numero($reg_nota->Frete_Retido_ICMS_Aliquota), false);
			//valor
			$ret_transp->addAttribute('vICMSRet', nfe_numero($reg_nota->Frete_Retido_ICMS_Valor), false);
			//cfop
			$ret_transp->addAttribute('CFOP', $reg_nota->Frete_CFOP, false);
			//cidade
			$ret_transp->addAttribute('cMunFG', $reg_nota->Frete_Codigo_Cidade, false);
		}
		//se tiver veculo
		if ($reg_nota->Veiculo_Tipo == 'C'){
			//caminho
			if (strlen(limpa_numero2($reg_nota->Veiculo_Placa))==7){
				//adiciona dados desse veculo
				$veic_transp = &$transp->addChild("veicTransp");
				//placa
				$veic_transp->addAttribute('placa', limpa_numero2($reg_nota->Veiculo_Placa), false);
				//uf
				$veic_transp->addAttribute('UF', $reg_nota->Veiculo_Placa_UF, false);
				//antt
				if (limpa_numero2($reg_nota->Veiculo_ANTT) != ''){
					$veic_transp->addAttribute('RNTC', limpa_numero2($reg_nota->Veiculo_ANTT), false);
				}
			}
			//se tiver reboque
			if (strlen(limpa_numero2($reg_nota->Veiculo_Reboque_Placa))==7){
				//adciona dados do reboque
				$reboque = &$transp->addChild("reboque");
				//placa
				$reboque->addAttribute('placa', limpa_numero2($reg_nota->Veiculo_Reboque_Placa), false);
				//uf
				$reboque->addAttribute('UF', $reg_nota->Veiculo_Reboque_UF, false);
				//antt
				if (limpa_numero2($reg_nota->Veiculo_Reboque_ANTT ) != ''){
					$reboque->addAttribute('RNTC', limpa_numero2($reg_nota->Veiculo_Reboque_ANTT), false);
				}
			}
		}
		//se for vago/balsa
		if (($reg_nota->Veiculo_Tipo == 'V')&&
			(limpa_numero2($reg_nota->Veiculo_Placa)!= '')){
			//placa do vagao
			$transp->addAttribute('vagao', limpa_numero2($reg_nota->Veiculo_Placa), false);
		}
		if (($reg_nota->Veiculo_Tipo == 'B')&&
			(limpa_numero2($reg_nota->Veiculo_Placa)!= '')){
			//placa do vagao
			$transp->addAttribute('balsa', limpa_numero2($reg_nota->Veiculo_Placa), false);
		}
		//se tive informaes do volume
		if (($reg_nota->Volumes_Qtd > 0)||
			(trim($reg_nota->Volumes_Nr) != '')||
			($reg_nota->Peso_Liquido > 0)||
			($reg_nota->Peso_Bruto > 0)){
			//adicona dados do volume
			$vol = &$transp->addChild("vol");
			$tem_vol = false;
			//qtd de volumes
			if ($reg_nota->Volumes_Qtd > 0){
				$vol->addAttribute('qVol', nfe_numero($reg_nota->Volumes_Qtd,0), false);
				$tem_vol = true;
			}else if (trim($reg_nota->Volumes_Nr) != ''){
				$vol->addAttribute('qVol', '1', false);
				$tem_vol = true;
			}
			if ($tem_vol){
				if (trim($reg_nota->Volumes_Especie) != ''){
					$vol->addAttribute('esp', trim($reg_nota->Volumes_Especie), false);
				}
				if (trim($reg_nota->Volumes_Marca) != ''){
					$vol->addAttribute('marca', trim($reg_nota->Volumes_Marca), false);
				}
			}
			if (trim($reg_nota->Volumes_Nr) != ''){
				$vol->addAttribute('nVol', trim($reg_nota->Volumes_Nr), false);
			}
			if ($reg_nota->Peso_Liquido>0){
				$vol->addAttribute('pesoL', nfe_numero($reg_nota->Peso_Liquido,3), false);
			}
			if ($reg_nota->Peso_Bruto>0){
				$vol->addAttribute('pesoB', nfe_numero($reg_nota->Peso_Bruto,3), false);
			}
		}
		//dados dos lacres (no possui)
		//consulta faturas da nota fiscal
		$con_parc = 'select * from nota_fiscal_parcela'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota = "'.$nr_nota.'"'.
					' order by Parcela  ';
		$res_parc = consulta_sql($con_parc);
		$nrw_parc = consulta_num_registros($res_parc);
		//se tiver faturas
		if ($nrw_parc >0){
			//adciona dados da cobraa
			$cobr = &$nf_inf->addChild("cobr");
			//para cada fatura
			for($f=0;$f<$nrw_parc;$f++){
				$reg_parc = consulta_ler_objeto($res_parc);
				//adiciona os vencimentos
				$dup = &$cobr->addChild("dup");
				//numero
				$dup->addAttribute('nDup', $reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_parc->Parcela, false);
				//vencimento
				$dup->addAttribute('dVenc', $reg_parc->DT_Vencimento, false);
				//valor
				$dup->addAttribute('vDup', $reg_parc->Valor_Parcela, false);
			}
		}
		consulta_limpa($res_parc);
		//consulta observaes da nota e dos itens
		//agrupada por descrio completa
		//ordenado por seq item e seq_obs
		$obs = '';
		$mes_ref = '';
		$con_obs = 'select * from nota_fiscal_obs'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' and Nr_Nota = "'.$nr_nota.'"'.
					' and TipoObs="A" '.
					' group by Texto_Completo '.
					' order by Seq_Item, Seq_Obs';
		$res_obs = consulta_sql($con_obs);
		$nrw_obs = consulta_num_registros($res_obs);
		//para cada obs
		for($o=0;$o<$nrw_obs;$o++){
			$reg_obs = consulta_ler_objeto($res_obs);
			//adicona  obs do corpo da nota
			if (strpos(' '.$reg_obs->Texto_Completo,'PERODO DE REFERNCIA:')>0){
				$mes_ref = trim(substr($reg_obs->Texto_Completo,22));
			}else{
				if ($obs!=''){
					$obs.=';';
				}
				$obs.= nfe_formata_txt($reg_obs->Texto_Completo);
			}
		}
		consulta_limpa($res_obs);
		//se tem obs do corpo da nota
		if ($obs!=''){
			//adicona  obs da nfe
			$inf_adic = &$nf_inf->addChild("infAdic");
			//texto na obs
			$inf_adic->addAttribute('infCpl', trim($obs), false);
			$inf_adic->addAttribute('mesRef', trim($mes_ref), false);
		}
		//finaliza arquivo na pasta tmp
		rmkdir(nf_pasta_raiz().'impressao');
		rmkdir(nf_pasta_raiz().'tmp');
		$xml->toFile(nf_pasta_raiz().'impressao/', $reg_nota->Nr_Nota."-nf.xfr");
		$retorno = '';
		$salvou = file_exists(nf_pasta_raiz().'impressao/'.$reg_nota->Nr_Nota."-nf.xfr");
		//se consegui salvar
		if ($salvou){
			$retorno = $reg_nota->Nr_Nota;
		}else{
			$retorno = 0;
		}
		return $retorno;

	}
	
?>