<?php
	require_once(dirname(__FILE__).'/nfe_processo.php');

	function nfe_processa_lote($lista_nfs,$modalidade){
		$notas_proc = array();
		$k = 0;
		$erro_validacao = 0;
		$modelo_nfe = '55';
		//consulta lista nfs
		foreach($lista_nfs as $key => $nr_nota){
			if(empty($nr_nota)){
				continue;
			}
			//verifica o status da nf gravando no banco o novo status (de I - Iniciado Processo da NF-e)
			$upd_nota = 'UPDATE nota_fiscal SET '.
						' Situacao = "I" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' AND Situacao = "P"';
			$res_upd = consulta_sql($upd_nota,true,1);
			//se pode fazer nf-e
			if($res_upd == 1){
				//adciona  lista de nfs  executar
				//gera chave de acesso  NF-e (caso ainda no possua)
				if(nfe_valida_dados_nfe($nr_nota)){
					$con_nfe = 'SELECT * FROM nota_fiscal '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota = "'.$nr_nota.'"';
					$res_nfe = consulta_sql($con_nfe);
					$reg_nfe = consulta_ler_objeto($res_nfe);
					consulta_limpa($res_nfe);
					//se a chave da NFe no est definida
					$modelo_nfe = $reg_nfe->Modelo;
					if($modelo_nfe == '65'){
						if($modalidade > 1){
							$modalidade = '9';
						}
					}
					if(BuscaParam('NF_DH_SAIDA') != 'V'){ //se no for pra ficar vazio
						if(dataf($reg_nfe->DH_SaidaNota) == '00/00/0000'){ //se estiver vazio
							//coloca a data e hora da saida da nota
							$up_nota_d = 'UPDATE nota_fiscal SET '.
										' DH_EntSai = now(), '.
										' DH_SaidaNota = DH_EntSai '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
										' AND Nr_Nota = "'.$nr_nota.'"';
							$res_nota_d = consulta_sql($up_nota_d,true,1);
						}
					}
					if((($modelo_nfe == '65') || ($modelo_nfe == '59')) && ($modalidade == '9') && ($reg_nfe->NFe_TipoEmissao == '1')){
						nfe_gera_chave($reg_nfe,$modalidade);
						$notas_proc[$k] = $nr_nota;
						$k++;
					}else if($reg_nfe->NFe_Chave == ''){
						nfe_gera_chave($reg_nfe,$modalidade);
						$notas_proc[$k] = $nr_nota;
						$k++;
					}else{
						if(($modalidade==1)||($reg_nfe->NFe_TipoEmissao==$modalidade)){
							$notas_proc[$k] = $nr_nota;
							$k++;
						}else{
							$upd_nota = 'UPDATE nota_fiscal SET '.
										' Situacao = "P" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota = "'.$nr_nota.'"'.
										' AND Situacao = "I"';
							$res_upd = consulta_sql($upd_nota,true,1);  //retorna para P pois no vai fazer a NFe
							nfe_exibe_erro('FRE-601','Nota Fiscal selecionada j foi gerada em ambiente normal (A validao desta NF-e foi abortada: "'.$reg_nfe->NFe_Chave.'")!',0);
						}
					}
				}else{
					$erro_validacao++;
				}
			}
		}

		//verifica se lista tem notas a processar
		if($k > 0){
			if(($modalidade=='5')||($modalidade=='9')||(config_pad('nfe_tpenvio')!='uma')){
				return nfe_processa_lote_fase1($notas_proc, $modalidade, $modelo_nfe);
			}else{
				$k = 0;
				foreach($notas_proc as $key => $nr_nota){
					if($nr_nota > 0){
						$gerou =  nfe_processa_fase1($nr_nota, $modalidade, $modelo_nfe);
						if($gerou){
							$k++;
						}
					}
				}
				return ($k>0);
			}
		}else{ //seno
			// exibe erro na tela dezindo que nenhuma nota aberta se encontra na lista selecionada
			if($erro_validacao == 0){
				nfe_exibe_erro('FRE-001','Notas selecionadas no podem ser enviadas! Verifique novamente a lista, aparentemente outro usurio j fez o envio destas NF-es!',0);
			}else{
				nfe_exibe_erro('FRE-001',$erro_validacao.' das Notas selecionadas possue(m) dados invlidos. Corrija os dados e tente o envio novamente!',0);
			}
			return false;
		}
	}

	function nfe_processa_lote_fase1($lista_nfs,$modalidade,$modelo_nfe='55'){ //gerao do lote
		set_time_limit(60);
		nfe_exibe_processamento('1');
		$ano_mes = nfe_ano_mes();
		$nf_e_geradas = array();
		$teve_erro = false;
		//para cada nota da lista
		foreach($lista_nfs as $key => $nr_nota){
			//se ainda no teve erro
			if($teve_erro == false){
				//consulta a nota no banco de dados e gera os arquivos XML na pasta tmp
				$nf_e = nfe_gera_arquivo_nfe($nr_nota);  //$nf_e['nr_nota']; $nf_e['chave_nfe'];
				$nf_e_geradas[$key] = $nf_e;
				//se a chave da nfe for vazia
				if($nf_e==''){  //teve erro no processo de gerao do arquivo
					$teve_erro = true;
				}else{
					//se arquivo j est nos arquivos do lote  enviar
					if(($modalidade=='5')||($modalidade=='9')){
						if(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe-ret.xml')){
							unlink(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe-ret.xml');
						}
						if(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err')){
							unlink(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err');
						}
						if(file_exists(nfe_pasta_raiz().'validar/Validado/'.$nf_e_geradas[$key].'-nfe.xml')){
							unlink(nfe_pasta_raiz().'validar/Validado/'.$nf_e_geradas[$key].'-nfe.xml');
						}
						$copiou = nfe_copia_arquivo('tmp','validar',$nf_e.'-nfe.xml');
					}else{
						if(file_exists(nfe_pasta_raiz().'envio_lote/Assinado/'.$nf_e.'-nfe.xml')){
							$copiou = true;
						}else{
							$copiou = nfe_copia_arquivo('tmp','envio_lote',$nf_e.'-nfe.xml','');
						}
					}
					if(!($copiou)){ //sem erro na cpia para a pasta envio
						$teve_erro = true;
					}
				}
			}
		}
		if(!($teve_erro)){
			//espera 15 segundos
			if(($modalidade=='5')||($modalidade=='9')){
				foreach($nf_e_geradas as $key => $nr_nota){
					$assinou = false;
					//valida se tem algum arquivo de erro na pasta de retorno
					while (!($assinou)){
						set_time_limit(60);
						if((file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe-ret.xml')) ||
							(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err')) ){
							$assinou = true;
						}
					}
				}
			}else{
				foreach($nf_e_geradas as $key => $nr_nota){
					$assinou = false;
					//valida se tem algum arquivo de erro na pasta de retorno
					while (!($assinou)){
						set_time_limit(60);
						if((file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err')) ||
							(file_exists(nfe_pasta_raiz().'envio_lote/Assinado/'.$nf_e_geradas[$key].'-nfe.xml'))){
							$assinou = true;
						}
					}
				}
			}
			//s leep(15);
			//para cada nota da lista de nf-es geradas
			if(($modalidade=='5')||($modalidade=='9')){
				foreach($nf_e_geradas as $key => $nr_nota){
					set_time_limit(60);
					//valida se tem algum arquivo de erro na pasta de retorno
					$ano_mes =  '20'.substr($nf_e_geradas[$key],2,4);
					//echo $nf_e_geradas[$key].'<BR>';
					if(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err')){
						//se tiver erros exibe eles na tela
						$conteudo_arquivo = nfe_abre_arquivo_err($nf_e_geradas[$key].'-nfe.err');
						nfe_exibe_erro('FRE-201','NF-e "'.$nf_e_geradas[$key].'" INCONSISTENTE!<BR>\n'.$conteudo_arquivo,'');
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nf_e_geradas[$key].'-nfe.err','',true);
						$teve_erro = true;
					}else if(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe-ret.xml')){
						//se tiver erros exibe eles na tela
						//$conteudo_arquivo = nfe_abre_arquivo_err($nf_e_geradas[$key].'-nfe-ret.xml');
						$status = '';
						$motivo = '';
						unset($xml);
						$xml = new XML();
						$xml->fromFile(nfe_pasta_raiz().'retorno/', $nf_e_geradas[$key].'-nfe-ret.xml', true);
						//le nr do lote no arquivo
						if($xml->root->name == 'Validacao'){
							foreach($xml->root->atts as $keyx => $value){
								if($xml->root->atts[$keyx]->name == 'cStat'){
									$status = fill_full($xml->root->atts[$keyx]->value,15);
								}
								if($xml->root->atts[$keyx]->name == 'xMotivo'){
									$motivo = fill_full($xml->root->atts[$keyx]->value,15);
								}
							}
						}
						//abre arquivo xml para ver qual a inconsistencia
						if($status != '1'){
							nfe_exibe_erro('FRE-602','NF-e "'.$nf_e_geradas[$key].'" INCONSISTENTE!<BR>\n'.
							$status.'-'.$motivo,'');
							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nf_e_geradas[$key].'-nfe-ret.xml','',true);
							$teve_erro = true;
						}else{
							nfe_copia_arquivo('retorno','SEFAZ/Validacao/'.$ano_mes,$nf_e_geradas[$key].'-nfe-ret.xml','',true);
						}
					}
				}
			}else{
				foreach($nf_e_geradas as $key => $nr_nota){
					//valida se tem algum arquivo de erro na pasta de retorno
					if(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[$key].'-nfe.err')){
						//se tiver erros exibe eles na tela
						$ano_mes =  '20'.substr($nf_e_geradas[$key],2,4);
						$conteudo_arquivo = nfe_abre_arquivo_err($nf_e_geradas[$key].'-nfe.err');
						nfe_exibe_erro('FRE-201','NF-e "'.$nf_e_geradas[$key].'" INCONSISTENTE!<BR>'.$conteudo_arquivo,'');
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nf_e_geradas[$key].'-nfe.err','',true);
						$teve_erro = true;
					}
				}
			}
		}
		if($teve_erro){
			foreach($lista_nfs as $key => $nr_nota){
				nfe_exibe_erro('FRE-202','Abortando Envio da NF-e ('.$key.')',$nr_nota);
			}
			return false;
		}else{
			if(($modalidade=='5')||($modalidade=='9')){
				foreach($nf_e_geradas as $key => $nr_nota){
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' Situacao = "P", '.
								' NFe_Situacao="FSD" '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Nr_Nota = "'.$lista_nfs[$key].'"'.
								' AND Situacao = "I"';
					$res_upd = consulta_sql($upd_nota,true,1);
					if(file_exists(nfe_pasta_raiz().'validar/Validado/'.$nf_e_geradas[$key].'-nfe.xml')){
						nfe_copia_arquivo('validar/Validado','SEFAZ/NF-es/'.$ano_mes.'/FSDA',$nf_e_geradas[$key].'-nfe.xml','');
					}
				}
				if($modalidade=='9'){
					nfe_exibe_processamento('OFF-LINE');
				}else{
					nfe_exibe_processamento('FS-DA');
				}
				return true;
			}else{
				$lote = nfe_gera_arquivo_lote($nf_e_geradas);
				$copiou = nfe_copia_arquivo('tmp','envio_lote',$lote.'-montar-lote.xml','');
				//se falhou durante a cpia
				if(!($copiou)){
					foreach($lista_nfs as $key => $nr_nota){
						nfe_exibe_erro('FRE-203','Abortando Envio da NF-e ('.$key.')',$nr_nota);
					}
					return false;
				}else{
					return nfe_processa_lote_fase2($lista_nfs,$nf_e_geradas,$lote,false,$modelo_nfe);
				}
			}
		}
	}

	function nfe_processa_lote_fase2($lista_nfs,$nf_e_geradas,$lote,$parar=false,$modelo_nfe='55'){
		if(!($parar)){
			nfe_exibe_processamento('2');
		}
		$lista_lotes = array();
		$lista_nfs_com_lote = array();
		//epera at ter algum retorno
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if((file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[0].'-nfe.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$nf_e_geradas[0].'-num-lot.xml'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$lote.'-montar-lote.err'))){
				$ok = true;
			}
		}
		usleep(200000);
		//se teve erro no lote ele no fez o envio
		if(file_exists(nfe_pasta_raiz().'retorno/'.$lote.'-montar-lote.err')){
			$conteudo_arquivo = nfe_abre_arquivo_err($lote.'-montar-lote.err');
			$ano_mes = nfe_ano_mes();
			//copia arquivo de erro para a patas erros
			nfe_copia_arquivo('retorno','erros/'.$ano_mes,$lote.'-montar-lote.err','',true);
			nfe_exibe_erro('FRE-204','Falha no Processamento do Arquivo "'.$lote.'-montar-lote.err"!'.
			$conteudo_arquivo,'');
			foreach($lista_nfs as $key => $nr_nota){
				nfe_exibe_erro('FRE-205','Abortando Envio da NF-e ('.$key.')',$nr_nota);
			}
			return false;
		}else{
			//para cada NF ou tem arquivo de retrono ou de error
			$teve_notas = 0;
			foreach($lista_nfs as $key => $nr_nota){
				$con_nfe = 'SELECT * FROM nota_fiscal '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota = "'.$nr_nota.'"';
				$res_nfe = consulta_sql($con_nfe);
				$reg_nfe = consulta_ler_objeto($res_nfe);
				consulta_limpa($res_nfe);
				$ano_mes = nfe_ano_mes($reg_nfe->DH_Emissao);
				if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Chave.'-nfe.err')){
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Chave.'-nfe.err');
					//copia arquivo de erro para a patas erros
					nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Chave.'-nfe.err',$nr_nota,true);
					nfe_exibe_erro('FRE-206','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Chave.'-nfe.xml"!'.
												$conteudo_arquivo,$nr_nota);
				}else if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Chave.'-num-lot.xml')){
					//abre o arquivo de lote para pegar o nmero do lote
					$nr_lote = 0;
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno/', $reg_nfe->NFe_Chave.'-num-lot.xml', true);
					//le nr do lote no arquivo
					if($xml->root->name == 'DadosLoteNfe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'NumeroLoteGerado'){
								$nr_lote = fill_full($xml->root->atts[$key]->value,15);
							}
						}
					}
					if($nr_lote == 0){
						usleep(200000);
						unset($xml);
						$xml = new XML();
						$xml->fromFile(nfe_pasta_raiz().'retorno/', $reg_nfe->NFe_Chave.'-num-lot.xml', true);
						//le nr do lote no arquivo
						if($xml->root->name == 'DadosLoteNfe'){
							foreach($xml->root->atts as $key => $value){
								if($xml->root->atts[$key]->name == 'NumeroLoteGerado'){
									$nr_lote = fill_full($xml->root->atts[$key]->value,15);
								}
							}
						}
					}
					if($nr_lote >0){
						//copia arquivo de lote para a pasta de lotes enviados
						nfe_copia_arquivo('retorno','SEFAZ/Lotes/'.$ano_mes,$reg_nfe->NFe_Chave.'-num-lot.xml','');
						//salva nr do lote na NF-e
						$upd_nota = 'UPDATE nota_fiscal SET'.
									' NFe_Lote = "'.$nr_lote.'" '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota = "'.$nr_nota.'"'.
									' AND Situacao = "I"';
						consulta_sql($upd_nota, true, 1);
						$lista_lotes[$nr_lote] = 1;
						$lista_nfs_com_lote[$nr_nota] = $nr_lote;
						$teve_notas++;
					}else{  //seno
						//copia arquivo de lote para a pasta de erros
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Chave.'-num-lot.xml','',true);
						nfe_exibe_erro('FRE-207','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Chave.'-num-lot.xml"!'.
												'No foi possvel ler o nmero do lote da NF-e!',$nr_nota);
					}
				}else{
					nfe_exibe_erro('FRE-208','Arquvo de retorno da NF-e "'.$reg_nfe->NFe_Chave.'" no encontrado! Esta NF-e no foi enviada neste lote!',$nr_nota);
				}
			}

			if($teve_notas >0){
				return nfe_processa_lote_fase3($lista_nfs_com_lote,$lista_lotes,$modelo_nfe);
			}else{
				nfe_exibe_erro('FRE-208','Nenhuma NF-e selecionada foi enviada corretamente! Todo o processo foi abortado!','');
				return false;
			}
		}
	}

	function nfe_processa_lote_fase3($lista_nfs,$lista_lotes,$modelo_nfe='55'){
		nfe_exibe_processamento('3');
		$ok = false;
		$lista_recibos = array();
		$teve_notas = 0;
		$lista_nfs_com_recibo = array();
		//espera o retrono de todos os recibos ou erros
		foreach($lista_lotes as $nr_lote => $key){
			//echo 'Entrou lista_lotes<BR>';
			$ok = false;
			$ano_mes = nfe_ano_mes();
			while (!($ok)){
				set_time_limit(60);
				if((file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-rec.err'))||
					(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-env-lot.err'))||
					(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-pro-rec.err'))||
					(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-rec.xml'))||
					(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-pro-rec.xml'))){
					//echo 'Entrou arquivo<BR>';
					$ok = true;
					if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-pro-rec.err')){
						$conteudo_arquivo = nfe_abre_arquivo_err($nr_lote.'-pro-rec.err');
						nfe_exibe_erro('FRE-210','Falha no Processamento do Arquivo "'.$nr_lote.'-pro-rec.err"!<BR>'.
						$conteudo_arquivo,'');
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_lote.'-pro-rec.err','',true);
						foreach($lista_nfs as $nr_nota => $lote_nf){
							if($lote_nf == $nr_lote){
								nfe_exibe_erro('FRE-211','Abortando envio da NF-e ('.$nr_nota.')!',$nr_nota);
							}
						}
					}else if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-rec.err')){
						$conteudo_arquivo = nfe_abre_arquivo_err($nr_lote.'-rec.err');
						nfe_exibe_erro('FRE-210','Falha no Processamento do Arquivo "'.$nr_lote.'-rec.err"!<BR>'.
						$conteudo_arquivo,'');
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_lote.'-rec.err','',true);
						foreach($lista_nfs as $nr_nota => $lote_nf){
							if($lote_nf == $nr_lote){
								nfe_exibe_erro('FRE-211','Abortando envio da NF-e ('.$nr_nota.')!',$nr_nota);
							}
						}
					}else if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-env-lot.err')){
						$conteudo_arquivo = nfe_abre_arquivo_err($nr_lote.'-env-lot.err');
						nfe_exibe_erro('FRE-210','Falha no Processamento do Arquivo "'.$nr_lote.'-env-lot.err"!<BR>'.
												$conteudo_arquivo,'');
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_lote.'-env-lot.err','',true);
						/*
						sleep(10);
						foreach($lista_nfs as $nr_nota => $lote_nf){
						set_time_limit(60);
						if($lote_nf == $nr_lote){
						//fazer consulta de situacao da NFe sem o recibo
						//validar se tem arquivo -sit.xml da NFe
						//abre o arquivo e testa se est autorizada

						nfe_exibe_erro('FRE-211','Abortando envio da NF-e ('.$nr_nota.')!',$nr_nota);
						}
						}
						*/
					}else if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_lote.'-pro-rec.xml')){
						$nr_nota_sincrono = '';
						foreach($lista_nfs as $nr_nota => $lote_nf){
							//echo 'Entrou lista_nfs'.$lote_nf.'-'.$lote_nf.'<BR>';
							if($lote_nf == $nr_lote){
								/*$upd_nota = 'Update nota_fiscal set'.
								' NFe_Recibo="'.$nr_lote.'" '.
								' where Nr_Nota = "'.$nr_nota.'" '.
								' and Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' and Situacao="I"';
								consulta_sql($upd_nota,true,1);
								*/
								$lista_nfs_com_recibo[$nr_nota] = $nr_lote;
								$lista_recibos[$nr_lote] = 1;
								$teve_notas++;
								$nr_nota_sincrono = $nr_nota;
							}
						}
						$res_lote = nfe_processa_lote_fase5($lista_nfs_com_recibo,$nr_lote,1,$modelo_nfe,$nr_nota_sincrono);
						if(!($res_lote)){
							nfe_exibe_erro('FRE-217','Nenhuma NF-e selecionada foi enviada corretamente! Todo o processo foi abortado!','');
						}
						return $res_lote;
					}else{						
						usleep(200000);
						//echo 'Entrou xml'.$nr_lote.'-rec.xml'.'<BR>';
						$xml = new XML();
						$xml->fromFile(nfe_pasta_raiz().'retorno/', $nr_lote.'-rec.xml', true);
						//le nr do lote no arquivo
						$status='';
						$motivo='';
						//echo 'Entrou root:'.$xml->root->name.'<BR>';
						if($xml->root->name == 'retEnviNFe'){
							//echo 'Entrou retEnviNFe<BR>';
							foreach($xml->root->atts as $key => $value){
								if($xml->root->atts[$key]->name == 'cStat'){
									$status = $xml->root->atts[$key]->value;
									//echo 'Entrou cStat'.$status.'<BR>';
								}
								if($xml->root->atts[$key]->name == 'xMotivo'){
									$motivo = $xml->root->atts[$key]->value;
								}
							}
							foreach($xml->root->childs as $key => $value){
								if($xml->root->childs[$key]->name == 'infRec'){
									$inf_rec = &$xml->root->childs[$key];
									//echo 'Entrou infRec<BR>';
								}
							}
						}
						//se o stauts for de lote processado
						if($status == '103'){
							//tenta ler o nr do recibo
							$nr_recibo = 0;
							//echo 'Entrou 103<BR>';
							foreach($inf_rec->atts as $key => $value){
								if($inf_rec->atts[$key]->name == 'nRec'){
									$nr_recibo = $inf_rec->atts[$key]->value;
									//echo 'Entrou nRec'.$nr_recibo.'<BR>';
								}
							}
							//fecha arquivo
							//se leu o numero do recibo
							if($nr_recibo > 0){   //salva nr do recibo na NF-e
								//echo 'Entrou nr_recibo'.$nr_recibo.'<BR>';
								nfe_copia_arquivo('retorno','SEFAZ/Recibos/'.$ano_mes,$nr_lote.'-rec.xml','',false);
								foreach($lista_nfs as $nr_nota => $lote_nf){
									//echo 'Entrou lista_nfs'.$lote_nf.'-'.$lote_nf.'<BR>';
									if($lote_nf == $nr_lote){
										$upd_nota = 'UPDATE nota_fiscal SET '.
													' NFe_Recibo = "'.$nr_recibo.'" '.
													' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
													' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
													' AND Nr_Nota = "'.$nr_nota.'"'.
													' AND Situacao = "I"';
										consulta_sql($upd_nota,true,1);
										$lista_nfs_com_recibo[$nr_nota] = $nr_recibo;
										$lista_recibos[$nr_recibo]=1;
										$teve_notas++;
									}
								}
							}else{  //seno
								nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_lote.'-rec.xml','',true);
								nfe_exibe_erro('FRE-212','Falha no Processamento do Arquivo "'.$nr_lote.'-rec.xml"!'.
															'No foi possvel ler o nmero do recibo da NF-e!',0);
								foreach($lista_nfs as $nr_nota => $lote_nf){
									if($lote_nf == $nr_lote){
										nfe_exibe_erro('FRE-213','Abortando envio da NF-e ('.$nr_nota.')!',$nr_nota);
									}
								}
							}
						}
					}
				}
			}
		}
		if($teve_notas >0){
			set_time_limit(60);
			return nfe_processa_lote_fase4($lista_nfs_com_recibo,$lista_recibos,1,$modelo_nfe);
		}else{
			nfe_exibe_erro('FRE-214','Nenhuma NF-e selecionada foi enviada corretamente! Todo o processo foi abortado!','');
			return false;
		}
	}

	function nfe_processa_lote_fase4($lista_nfs,$lista_recibos,$tentativa,$modelo_nfe='55',$nr_nota_sincrona=''){
		$qtd_ok = 0;		
		usleep(200000);
		set_time_limit(60);
		nfe_exibe_processamento('4',$tentativa);
		foreach($lista_recibos as $nr_recibo => $key){
			if ((!(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml'))) &&
				(!(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.err'))) &&
				(!(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-ped-rec.err'))) ){
				//cria arquivo de consulta de lote(se no gerou automaticamente)
				$gerou = false;
				foreach($lista_nfs as $nr_nota => $recibo_nf){
					if(($recibo_nf == $nr_recibo)&&($nr_recibo[0]!='0')){
						if(!($gerou)){
							nfe_gera_arquivo_consulta($nr_nota);
							$gerou = true;
						}
					}
				}
				if($gerou){
					$copiou = nfe_copia_arquivo('tmp','envio',$nr_recibo.'-ped-rec.xml','');
					if(!($copiou)){
						nfe_exibe_erro('FRE-215','Falha na gerao da consulta de lote!','');
						return false;
					}
				}else{
					nfe_exibe_erro('FRE-216','Falha na gerao da consulta de lote!','');
					return false;
				}
			}
			$res_lote = nfe_processa_lote_fase5($lista_nfs,$nr_recibo,$tentativa,$modelo_nfe,$nr_nota_sincrona);
			if($res_lote){
				$qtd_ok++;
			}
		}
		if($qtd_ok>0){
			return true;
		}else{
			if($tentativa==1){
				nfe_exibe_erro('FRE-217','Nenhuma NF-e selecionada foi enviada corretamente! Todo o processo foi abortado!','');
			}
			return false;
		}
	}

	function nfe_processa_lote_fase5($lista_nfs,$nr_recibo,$tentativa,$modelo_nfe,$nr_nota_sincrona=''){
		$lista_recibos = array();
		$autorizadas = 0;
		//fica tentando at encontra o arquivo de retorno
		$ok = false;
		//consulta nr dados da NF-e
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if((file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-ped-rec.err'))){
				$ano_mes = nfe_ano_mes();
				$ok = true;
				if($nr_recibo[0]!='0'){	 usleep(200000); }
				if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-ped-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($nr_recibo.'-ped-rec.err');
					nfe_exibe_erro('FRE-218','Falha no Processamento do Arquivo "'.$nr_recibo.'-ped-rec.err"!'.
					$conteudo_arquivo,'');
					return false;
				}else if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($nr_recibo.'-pro-rec.err');
					nfe_exibe_erro('FRE-218','Falha no Processamento do Arquivo "'.$nr_recibo.'-pro-rec.err"!'.
					$conteudo_arquivo,'');
					return false;
				}else{
					//abre arquivo de retorno da consulta					
					usleep(200000);
					$status='';
					$motivo='';
					$versao='1.10';
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno/', $nr_recibo.'-pro-rec.xml', true);
					//le nr do lote no arquivo
					if($xml->root->name == 'retConsReciNFe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
					}else if($xml->root->name == 'retEnviNFe'){  //sincrono
							foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
					}
					//pega status do lote
					if($status == '105'){  //lote ainda no processado aguarda e tenta denovo
						//fecha arquivo da consulta
						//copia para a pasta erros
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',true);
						//aguarda mais 10 segundos
						sleep(1);
						$lista_recibos[$nr_recibo]=1;
						if($tentativa>10){
							nfe_exibe_erro('FRE-225','Excedeu o limite de tempo para envio do lote da NF-e! '.
													'"'.$status.'" - '.$motivo.'<BR><BR>'.
													'Aguarde algum tempo e tente o reenvio novamente!','');
							return false;
						}else{
							return nfe_processa_lote_fase4($lista_nfs,$lista_recibos,$tentativa+1,$modelo_nfe,$nr_nota_sincrona);
						}
					}else if($status == '104'){
						//lote foi procesasado deve ler cada ptrocolo de fazer validao individual em cada nota da lista
						set_time_limit(60);
						if($nr_recibo[0]!='0'){ usleep(200000);}
						nfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes,$nr_recibo.'-pro-rec.xml','',false);
						foreach($xml->root->childs as $key_proc => $value){
							set_time_limit(60);
							if($xml->root->childs[$key_proc]->name == 'protNFe'){
								$prot_nfe = &$xml->root->childs[$key_proc];
								$versao = '1.10';
								foreach($prot_nfe->atts as $key => $value){
									if($xml->root->atts[$key]->name == 'versao'){
										$versao = $xml->root->atts[$key]->value;
									}
								}
								$status = '';
								$motivo = '';
								$protocolo_nr = '';
								$protocolo_dh = '';
								$protocolo_pr = '';
								$protocolo_dv = '';
								$txt_inf_prot = '';
								$chave_nfe = '';
								foreach($prot_nfe->childs as $key => $value){
									$status = '';
									$motivo = '';
									$protocolo_nr = '';
									$protocolo_dh = '';
									$protocolo_pr = '';
									$protocolo_dv = '';
									$txt_inf_prot = '';
									$chave_nfe = '';
									if($prot_nfe->childs[$key]->name == 'infProt'){
										set_time_limit(60);
										$txt_inf_prot = $prot_nfe->childs[$key]->toString();
										foreach($prot_nfe->childs[$key]->atts as $key2 => $value){
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'cStat'){
												$status = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'xMotivo'){
												$motivo = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'verAplic'){
												$protocolo_pr = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'dhRecbto'){
												$protocolo_dh = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'nProt'){
												$protocolo_nr = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'digVal'){
												$protocolo_dv = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
											if($prot_nfe->childs[$key]->atts[$key2]->name == 'chNFe'){
												$chave_nfe = $prot_nfe->childs[$key]->atts[$key2]->value;
											}
										}
									}
									//grava dados do protocolo da NF-e
									set_time_limit(60);
									$con_nota = 'SELECT Nr_Nota, DH_Emissao, NFe_Versao FROM nota_fiscal '.
												' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
												' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
												' AND EmissaoPT = "P"'.
												' AND Situacao = "I"'.
												' AND NFe_Chave = "'.$chave_nfe.'"';
									$res_nota = consulta_sql($con_nota);
									$reg_nota = consulta_ler_linha($res_nota);
									consulta_limpa($res_nota);
									$nr_nota = $reg_nota[0];
									$ano_mes_nf = nfe_ano_mes($reg_nota[1]);
									$versao = $reg_nota[2];
									set_time_limit(60);
									ignore_user_abort(true);
									$upd_nota = 'UPDATE nota_fiscal SET'.
												' NFe_Situacao = "'.$status.'", '.
												' NFe_Protocolo_Motivo = "'.$motivo.'", '.
												' NFe_Versao_SF = "'.$protocolo_pr.'", '.
												' NFe_Protocolo_DH = "'.str_replace('T',' ',$protocolo_dh).'", '.
												' NFe_Protocolo = "'.$protocolo_nr.'", '.
												' NFe_Protocolo_Sig = "'.$protocolo_dv.'" '.
												' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
												' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
												' AND Nr_Nota = "'.$nr_nota.'"'.
												' AND Situacao = "I"';
									$res_upt = consulta_sql($upd_nota,true,1);
									set_time_limit(60);
									if($res_upt == 1){
										if(($status == '100')||($status == '150')){
											//testa se o qrquivo da NF-e est na pasta de autorizadas do uninfe
											if(!(file_exists(nfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf.'/'.$chave_nfe.'-nfe.xml'))){
												//se no tiver espera por qdeve estar em poucos instantes
												set_time_limit(60);
												if($nr_recibo[0]!='0'){sleep(1); }
											}
											//caso ainda no esteja  por que o uninfe no vai colocar.
											//ento, neste caso tenta recuper-lo da paras em processamento
											if(!(file_exists(nfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf.'/'.$chave_nfe.'-nfe.xml'))){
												if((file_exists(nfe_pasta_raiz().'backup/EmProcessamento/'.$chave_nfe.'-nfe.xml'))){
													nfe_copia_arquivo('backup/EmProcessamento','backup/Autorizados/'.$ano_mes_nf,$chave_nfe.'-nfe.xml','',false);
												}
											}
											//ou da pasta err
											if(!(file_exists(nfe_pasta_raiz().'backup_err/'.$ano_mes_nf.'/'.$chave_nfe.'-nfe.xml'))){
												if((file_exists(nfe_pasta_raiz().'backup_err/'.$chave_nfe.'-nfe.xml'))){
													nfe_copia_arquivo('backup_err','backup/Autorizados/'.$ano_mes_nf,$chave_nfe.'-nfe.xml','',false);
												}
											}
											if(file_exists(nfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf.'/'.$chave_nfe.'-nfe.xml')){
												//abre o arquivo da NF-e da pasta backup/autorizadas
												usleep(200000);
												$texto_nfe = xml_fromFile(nfe_pasta_raiz().'backup/Autorizados/'.$ano_mes_nf,$chave_nfe.'-nfe.xml');
												//arquivo assinado est na pasta de nfes autorizadas
												//a autorizao j foi lida anteriormente ($prot_nfe)
												set_time_limit(60);
												$string = '<?xml version="1.0" encoding="utf-8"?>'.
															'<nfeProc xmlns="http://www.portalfiscal.inf.br/nfe" versao="'.$versao.'">'.
															$texto_nfe.
															'<protNFe versao="'.$versao.'" xmlns="http://www.portalfiscal.inf.br/nfe">'.
															$txt_inf_prot.
															'</protNFe>'.
															'</nfeProc>';
												$Handle = fopen(nfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($versao,5).'-procNFe.xml', 'w');
												$Data = utf8_encode($string);
												fwrite($Handle, $Data);
												fclose($Handle);
												set_time_limit(0);
												//copia para a pasta definitiva
												nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes_nf.'/Autorizados',$protocolo_nr.'_v'.fill_full($versao,5).'-procNFe.xml','',false);
												$Handle = fopen(nfe_pasta_raiz().'tmp/'.fill_full($chave_nfe,44).'-procNFe.xml', 'w');
												$Data = utf8_encode($string);
												fwrite($Handle, $Data);
												fclose($Handle);
												set_time_limit(0);
												//copia para a pasta definitiva
												nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes_nf.'/Autorizados2',fill_full($chave_nfe,44).'-procNFe.xml','',false);
												set_time_limit(0);
												nfe_processa_fase6($nr_nota,true);
												$autorizadas++;
											}else{
												nfe_exibe_erro('FRE-220','A SEFAZ autorizou o uso da NF-e "'.$chave_nfe.'", '.
																		'porm o arquivo da NF-e no foi localizado no servidor!'.
																		'<BR><BR>'.
																		'Faa o reenvio da NF-e e, caso o problema persista, '.
																		'entre em contato com a Freeline!','');
											}
										}else if(($status == '301')||
												 ($status == '302')){
											//fecha arquivo da consulta
											//foi denegada a NF-e
											//gera arquivo de distribuio da NF-e na pasta de denegadas
											if(!(file_exists(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes_nf.'/'.$chave_nfe.'-den.xml'))){
												//se no tiver espera por qdeve estar em poucos instantes
												set_time_limit(60);
												sleep(1);
											}
											if(file_exists(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes_nf.'/'.$chave_nfe.'-den.xml')){
												usleep(200000);
												$texto_nfe = xml_fromFile(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes_nf, $chave_nfe.'-den.xml');
												//arquivo assinado est na pasta de nfes autorizadas
												//a autorizao j foi lida anteriormente ($prot_nfe)
												set_time_limit(60);
												$string = '<?xml version="1.0" encoding="utf-8"?>'.
															'<nfeProc xmlns="http://www.portalfiscal.inf.br/nfe" versao="'.$versao.'">'.
															$texto_nfe.
															'<protNFe versao="'.$versao.'" xmlns="http://www.portalfiscal.inf.br/nfe">'.
															$txt_inf_prot.
															'</protNFe>'.
															'</nfeProc>';
												$Handle = fopen(nfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($versao,5).'-procNFe.xml', 'w');
												$Data = utf8_encode($string);
												fwrite($Handle, $Data);
												fclose($Handle);
												set_time_limit(60);
												//copia para a pasta definitiva
												nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes_nf.'/Denegadas',$protocolo_nr.'_v'.fill_full($versao,5).'-procNFe.xml','',false);
												$Handle = fopen(nfe_pasta_raiz().'tmp/'.fill_full($chave_nfe,44).'-procNFe.xml', 'w');
												$Data = utf8_encode($string);
												fwrite($Handle, $Data);
												fclose($Handle);
												set_time_limit(60);
												//copia para a pasta definitiva
												nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes_nf.'/Denegadas2',fill_full($chave_nfe,44).'-procNFe.xml','',false);
												set_time_limit(60);
												//exibe mensagem na tela sobre a denegao de uso
												nfe_exibe_erro('FRE-220','A SEFAZ no autorizou o uso da NF-e "'.$chave_nfe.'"!'.
																		'"'.$status.'" - '.$motivo.'<BR><BR>'.
																		'Conforme determina a legislao, essa nota no poder ser utilizada!'.
																		'Entre em contato com a SEFAZ do seu Estado para obter mais informaes!','');
												nfe_processa_fase6($nr_nota,false);
											}else{
												if ($protocolo_nr!=''){
													nfe_exibe_erro('FRE-220-A','A SEFAZ denegou o uso da NF-e "'.$chave_nfe.'", '.
																			'porm o arquivo da NF-e no foi localizado no servidor!'.
																			'<BR><BR>'.
																			'Faa o reenvio da NF-e e, caso o problema persista, '.
																			'entre em contato com a Freeline!','');
												}else{
													nfe_exibe_erro('FRE-220-B','Rejeio do Arquivo da NF-e "'.$chave_nfe.'" pela SEFAZ!'.
																	'"'.$status.'" - '.$motivo.'<BR><BR>'.
																	'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
												}
											}
										}else if($status == '204'){
											//exibe mensagem na tela sobre a denegao de uso
											nfe_exibe_erro('FRE-221','Falha no processamento do Lote da NF-e "'.$chave_nfe.'"!'.
																	'"'.$status.'" - '.$motivo.'<BR><BR>'.
																	'A NF-e j foi autorizada em um envio anterior. '.
																	'Faa o reenvio da NF-e para consultar a autorizao e fechar a nota corretamente!','');
											$upd_nota = 'UPDATE nota_fiscal SET'.
														' NFe_Protocolo = "", '.
														' NFe_Recibo = "" '.
														' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
														' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
														' AND Nr_Nota = "'.$nr_nota.'"'.
														' AND Situacao = "I"'.
														' AND NFe_Protocolo = "'.$protocolo_nr.'"';
											$res_upt = consulta_sql($upd_nota,true,1);
										}else if(($status == '999')&&($reg_nota->Modelo=='55')){
											if( (strpos(' '.$motivo,'Rejeio Automtica')>0)||
												(strpos(' '.$motivo,'Rejeicao Automatica')>0)||
												(strpos(' '.$motivo,'Rejeio automtica')>0)||
												(strpos(' '.$motivo,'Rejeicao automatica')>0)||
												(strpos(' '.$motivo,'rejeio automtica')>0)||
												(strpos(' '.$motivo,'rejeicao automatica')>0)||
												(strpos(' '.$motivo,'rejeicao automatica')>0)||
												(strpos(' '.$motivo,'catalogado Rejei')>0)||
												(strpos(' '.$motivo,'rejeitada automaticamente')>0)){
												nfe_exibe_erro('FRE-225','Rejeio do Arquivo da NF-e "'.$chave_nfe.'" por falha de recebimento da SEFAZ!<BR>'.
																			$status.'-'.$motivo.'<BR>'.
																			'Faa novo envio (modo normal) para obter a autorizao!',$nr_nota);
											}else{
												nfe_exibe_erro('FRE-222','Falha no Processamento do Lote da NF-e "'.$chave_nfe.'"!<BR>'.
																			$status.'-'.$motivo.'<BR>'.
																			'Aguarde e tente novamente mais tarde at que a SEFAZ processe o lote!','');
											}
										}else{
											nfe_exibe_erro('FRE-223','Rejeio do Arquivo da NF-e "'.$chave_nfe.'" pela SEFAZ!'.
																	'"'.$status.'" - '.$motivo.'<BR><BR>'.
																	'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
										}
									}else{  //no fez upt pois no tinha dados pra isso
										//$autorizadas++;
									}
								}//for das informaes dos protocolos (cada NFe tem um)
							}//se tag  protocolo
						}//for dos protocolos
					}else { //status erado do lote
						nfe_exibe_erro('FRE-224','Rejeio do Arquivo da Lote NF-e pelo SEFAZ!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Faa o reenvio da NF-e para buscar a resposta da SEFAZ novamente!',$nr_nota_sincrona);
						return false;
					}///teve arquivo com status errado
				}  //foi arquivo XML
			}//  algum arquivo esperado
		} //looping achou arquivo

		if($autorizadas>0){
			return true;  // teve nota autorizxadas
		}else{
			//nfe_exibe_erro('FRE-224','Nenhuma NF-e selecionada foi enviada corretamente! Todo o processo foi abortado!','');
			return false;
		}
	}
	
?>