<?php
	require_once(dirname(__FILE__).'/ie.php');

	function nfe_ano_mes($data='',$tipo='AAAAMM'){  //foramto 0000-00-00
		if($data==''){
			$data = data_atual('date');
		}
		if($tipo=='AAAAMM'){
			return $data[0].$data[1].
					$data[2].$data[3].
					$data[5].$data[6];
		}else{
			return $data[2].$data[3].
					$data[5].$data[6];
		}
	}

	function nfe_modulo11($nr_original){
		$soma = 0;
		$k= 2;
		for($i=strlen($nr_original);$i>0;$i--){
			$soma+= ($nr_original[$i-1] * $k);
			$k++;
			if($k>9){
				$k = 2;
			}
		}
		$digito = 11 - ($soma%11);
		if($digito >= 10){
			$digito = 0;
		}
		return $digito;
	}

	function nfe_retira_texto_excesso($texto,$inicio,$tamanho_max){
		//descobre quantos carates < > " ' & existem no texto
		// o limite vai ser menor se existirem esses caracteres
		//por que no xml eles ocupam mais do que uma posio
		//primeiro tira os primeiros $tamanjho de caracteres caracteres)
		$texto = trim(substr(trim($texto),$inicio,$tamanho_max));
		$texto_final = '';
		//$conta_menor = substr_count($texto_final,'>');
		$tamanho  = strlen($texto);
		$tamanho_total = 0;
		for($t=0;$t<$tamanho;$t++){
			$tamanho_car = 1;
			if(($texto[$t]=='<')||($texto[$t]=='>')){
				$tamanho_car = 4;
			}else if(($texto[$t]=='"')||($texto[$t]=="'")){
				$tamanho_car = 6;
			}else if($texto[$t]=='&'){
				$tamanho_car = 5;
			}else if($texto[$t]==''){
				$tamanho_car = 12;
			}
			$tamanho_total+=$tamanho_car;
			if($tamanho_total<=$tamanho_max){
				$texto_final.= $texto[$t];
			}
		}
		return trim($texto_final);
	}

	function nfe_copia_arquivo($origem, $destino, $arquivo, $nr_nota = '', $renomeia = false, $apaga = true){
		//usleep(200000);
		//determina nome do arquivo de origem
		$arq_ori = nfe_pasta_raiz().$origem.'/'.$arquivo;
		//determina nome do arquivo de destino
		$arq_des = nfe_pasta_raiz().$destino.'/'.$arquivo;
		//se renomeia
		if($renomeia){
			//arquivo de destino  com a data/hora no incio do mesmo
			$data_hora = data_atual('date').nr2hora(hora_atual());
			$data_hora = str_replace('-','',$data_hora);
			$data_hora = str_replace(':','',$data_hora);
			$arq_des = nfe_pasta_raiz().$destino.'/'.$data_hora.'_'.$arquivo;
		}
		//verifica se arquivo de origem existe
		if(file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if(!(file_exists(nfe_pasta_raiz().$destino))){
				//seno cria ela (ano_mes)
				rmkdir(nfe_pasta_raiz().$destino."/",0777);
			}
			//verifica se destino existe
			if(file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				@unlink(realpath($arq_des));
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);
			//se fez a copia corretamente
			if($copiou){
				//se a instruo for de apagar o arquivo de origem
				if($apaga){
					//apaga o arquivo de origem
					//if(is_writable($arq_ori)){
					@unlink(realpath($arq_ori));
					//}
				}
				return true;
			}else{
				nfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
										'Verifique a estrutura de pastas do servidor!',$nr_nota);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			nfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',$nr_nota);
			return false;
		}
	}

	function nfe_abre_arquivo_err($arquivo){
		//abre arquivo de erro na pasta de retorno
		$temp_file = nfe_pasta_raiz().'temp_xml/'.$arquivo;
		$arq_base  = nfe_pasta_raiz().'retorno/'.$arquivo;
		usleep(200000);
		if(file_exists($temp_file)){
			unlink($temp_file);
		}
		//echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
		copy($arq_base, $temp_file);
		$linhas_erro = '';
		$array_of_list_values = file($temp_file);
		foreach($array_of_list_values as $key => $value){
			set_time_limit(30);
			$linhas_erro.= $value;
		}
		unset($array_of_list_values);
		unlink($temp_file);
		//le todo o contedo da pasta
		return nl2br($linhas_erro);
	}

	function nfe_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$_SESSION["Empresa_Codigo"].'/';
	}

	function nfe_pasta_raiz2($dominio,$empresa){
		return '../arquivos_clientes/'.$dominio.'/nf_e/'.$empresa.'/';
	}

	function nfe_pasta_raiz3(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/';
	}

	function nf_pasta_raiz(){
		return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf/'.$_SESSION["Empresa_Codigo"].'/';
	}

	function nfe_busca_arquivo($nr_nota,$tipo="xml"){
		$con_nfe = 'SELECT NrDoc, Serie, NFe_Chave, NFe_Protocolo, NFe_Versao, DH_Emissao FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		if($tipo == "pdf"){
			$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Danfe/';
			if(!is_dir($url_arq)){
				rmkdir($url_arq);
			}
			if(($_SESSION['Dominio'] == '122') || ($_SESSION['Dominio'] == '191')){
				$nm_arq="nfe_".$reg_nfe->NrDoc."_".$reg_nfe->Serie.".pdf";
			}else{
				$nm_arq = fill_full($reg_nfe->NFe_Chave,44).'-procNFe.pdf';
			}
			$url_arq.= $nm_arq;
		}else{
			$nm_arq = $reg_nfe->NFe_Protocolo.'_v'.fill_full($reg_nfe->NFe_Versao,5).'-procNFe.xml';
			$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Autorizados/'.$nm_arq;
			//phpinfo();
			$nm_arq2 = fill_full($reg_nfe->NFe_Chave,44).'-procNFe.xml';
			$url_arq2 = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Autorizados2/'.$nm_arq2;
			if(file_exists($url_arq2)){
				$url_arq = $url_arq2;
			}
		}
		return $url_arq;
	}

	function nfe_busca_arquivo_backup($nr_nota){
		$con_nfe =  'SELECT NFe_Chave, DH_Emissao FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//arquivos_clientes/2/nf_e/1/backup/Autorizados/201805/41180576676436000167550010000991051000853750-procNFe.xml
		$nm_arq = fill_full($reg_nfe->NFe_Chave, 44).'-procNFe.xml';
		$url_arq = nfe_pasta_raiz().'backup/Autorizados/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/'.$nm_arq;
		return $url_arq;
	}

	function nfe_busca_arquivo_cancela($nr_nota){
		$con_nfe =  'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
					' AND Nr_Nota = "'.$nr_nota.'" ';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$versao = $reg_nfe->NFe_Versao;
		if($versao == '1.10'){
			$versao = '1.07';
		}
		if(($reg_nfe->NFe_Situacao=='101')||($reg_nfe->NFe_Situacao=='151')){
			$nm_arq = $reg_nfe->NFe_Protocolo_C.'_v'.fill_full($versao,5).'-procCancNFe.xml';
			$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Canceladas/'.$nm_arq;
		}else if(($reg_nfe->NFe_Situacao=='135')||($reg_nfe->NFe_Situacao=='136')||($reg_nfe->NFe_Situacao=='155')){
			$nm_arq = $reg_nfe->NFe_Protocolo_C.'_v'.fill_full('1.00',5).'-procEventoNFe.xml';
			$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_nfe->DH_Emissao,'AAAAMM').'/Canceladas/'.$nm_arq;
		}else{
			$url_arq = '';
		}
		return $url_arq;
	}

	function busca_dados_cce($empresa = ''){
		$retorno = array();
		if($empresa == ""){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$sql_dados_cli ='SELECT pes.Nome_Razao, pes.Email, pes_end.Logradouro, pes_end.Numero, pes_end.Complemento, '.
						' pes_end.Bairro, pes_end.CEP, pes_end.Nome_Cidade,pes_end.UF, pes_tel.Numero_Telefone FROM pessoa pes '.
						' LEFT JOIN pessoa_endereco pes_end ON pes.Dominio = pes_end.Dominio AND pes.Pessoa = pes_end.Pessoa '.
						' LEFT JOIN pessoa_telefone pes_tel ON pes.Dominio = pes_tel.Dominio AND pes.Pessoa = pes_tel.Pessoa '.
						' WHERE pes.Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND pes.Pessoa = "'.$empresa.'"  '.
						' AND pes_end.Seq_Endereco = 1 '.
						' AND pes_tel.Seq_Telefone = 1 '.
						' LIMIT 1';
		$res_dados_cli = consulta_sql($sql_dados_cli);
		$reg_dados_cli = consulta_ler_objeto($res_dados_cli);
		$retorno['razao'] = $reg_dados_cli->Nome_Razao;
		$retorno['logradouro'] = $reg_dados_cli->Logradouro;
		$retorno['numero'] = $reg_dados_cli->Numero;
		$retorno['complemento'] = $reg_dados_cli->Complemento;
		$retorno['bairro'] = $reg_dados_cli->Bairro;
		$retorno['CEP'] = $reg_dados_cli->CEP;
		$retorno['municipio'] = $reg_dados_cli->Nome_Cidade;
		$retorno['UF'] = $reg_dados_cli->UF;
		$retorno['telefone'] = $reg_dados_cli->Numero_Telefone;
		$retorno['email'] = $reg_dados_cli->Email;
		$retorno = array_map("utf8_encode_si", $retorno);
		return $retorno;
	}

	function nfe_busca_arquivo_cce($nr_nota, $evento = '',$tipo = "xml"){
		$con_evento='SELECT CCe_Protocolo, DH_Evento, Versao_Evento FROM nota_fiscal_evento '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		if($evento != ''){
			$con_evento.= ' AND Seq_Evento = "'.$evento.'"';
		}else{
			$con_evento.= ' ORDER BY Seq_Evento DESC '.
							' LIMIT 1';
		}
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		$url_arq = '';
		if($reg_evento->CCe_Protocolo!=''){
			if($tipo == "xml"){
				$nm_arq = $reg_evento->CCe_Protocolo.'_v'.fill_full($reg_evento->Versao_Evento,5).'-procEventoNFe.xml';
				$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_evento->DH_Evento,'AAAAMM').'/CCe/'.$nm_arq;
			}else{ //pdf
				$nfe_pdf_caminho = nfe_pasta_raiz().'SEFAZ/NF-es/'.nfe_ano_mes($reg_evento->DH_Evento,'AAAAMM').'/Danfe/';
				if(!is_dir($nfe_pdf_caminho)){
					rmkdir($nfe_pdf_caminho);
				}
				$nm_arq = $reg_evento->CCe_Protocolo.'_v'.fill_full($reg_evento->Versao_Evento,5).'-procEventoNFe.pdf';
				$url_arq = $nfe_pdf_caminho.$nm_arq;
			}
		}
		return $url_arq;
	}

	function nfe_busca_arquivo_cce_backup($nr_nota, $evento = ''){
		$con_evento='SELECT NFe_Chave, DH_Emissao FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		if($evento == ''){
			$con_seq_evento='SELECT Seq_Evento FROM nota_fiscal_evento '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota = "'.$nr_nota.'"'.
							' ORDER BY Seq_Evento DESC '.
							' LIMIT 1';
			$res_seq_evento = consulta_sql($con_seq_evento);
			$reg_seq_evento = consulta_ler_objeto($res_seq_evento);
			consulta_limpa($res_seq_evento);
			$evento = '1';
			if(isset($reg_seq_evento)){
				$evento = $reg_seq_evento->Seq_Evento;
			}
		}
		$url_arq = '';
		//arquivos_clientes/2/nf_e/1/backup/Autorizados/201805/41180576676436000167550010000991051000853750_01-procEventoNFe.xml
		$nm_arq = $reg_evento->NFe_Chave.'_'.fill_full($evento, 2).'-procEventoNFe.xml';
		$url_arq = nfe_pasta_raiz().'backup/Autorizados/'.nfe_ano_mes($reg_evento->DH_Emissao,'AAAAMM').'/'.$nm_arq;
		return $url_arq;
	}

	function nfe_exibe_download($ano_mes, $nm_arq){
		$url_arq = nfe_pasta_raiz().'SEFAZ/NF-es/'.$ano_mes.'/Recebidas/'.$nm_arq;
		$url_arq = 'Arquivo da NF-e: <a href="'.$url_arq.'" target="_blank">'.$nm_arq.'</a>';
		if (!file_exists(nfe_pasta_raiz().'SEFAZ/NF-es/'.$ano_mes.'/Recebidas/'.$nm_arq)){
			$url_arq = '';
		}
		return $url_arq;
	}

	function nfe_exibe_erro($codigo,$mensagem,$nr_nota){
		//exibe o erro na tela
		echo '<p><font size="2" face="Verdana"><b>'.$codigo.'</b><BR>'.$mensagem.'</font></p><BR><BR>';
		//retorna o status dessa nota para "P"
		if($nr_nota!=0){
			nfe_retorna_nfe($nr_nota);
		}
	}

	function nfe_exibe_processamento($fase,$cmpl=''){
		//exibe o erro na tela
		if($fase == '1'){
			echo '<p><font size="2" face="Verdana">Gerando Arquivo da NF-e... (1/6)</font></p>';
		}
		if($fase == '2'){
			echo '<p><font size="2" face="Verdana">Validando e Assinando Arquivo XML... (2/6)</font></p>';
		}
		if($fase == '3'){
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML... (3/6)</font></p>';
		}
		if($fase == '4'){
			$tentativa = '';
			if($cmpl>1){
				$tentativa = '(Tentativa '.$cmpl.')';
			}
			echo '<p><font size="2" face="Verdana">Verificando Autorizao de Uso...'.$tentativa.' (4/6)</font></p>';
		}
		if($fase == '5'){
			echo '<p><font size="2" face="Verdana">Fechando Documento... (5/6)</font></p>';
		}
		if($fase == '6'){
			echo '<p><font size="2" face="Verdana">NF-e '.$cmpl.'! (6/6)</font></p>';
		}
		if($fase == 'R'){
			echo '<p><font size="2" face="Verdana">Reprocessando a NF-e!</font></p>';
		}
		if($fase == 'C1'){
			if($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' da NF!</font></p>';
		}
		if($fase == 'C2_A'){
			if($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Enviando Arquivo XML de '.$operacao.'...</font></p>';
		}
		if($fase == 'C2_B'){
			if($cmpl=='I'){
				$operacao = 'Inutilizao';
				$artigo = 'a';
			}else{
				$operacao = 'Cancelamento';
				$artigo = 'o';
			}
			echo '<p><font size="2" face="Verdana">'.$operacao.' da NF Homologad'.$artigo.'!</font></p>';
		}
		if($fase == 'C3'){
			echo '<p><font size="2" face="Verdana">Retornando Estoque do Produto...</font></p>';
		}
		if($fase == 'C4'){
			echo '<p><font size="2" face="Verdana">Retornando saldo das NFs Referenciadas...</font></p>';
		}
		if($fase == 'C5'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos '.busca_nome_pedido_orc().'s Referenciados...</font></p>';
		}
		if($fase == 'C6'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins Referenciados...</font></p>';
		}
		if($fase == 'C6_B'){
			echo '<p><font size="2" face="Verdana">Retornando saldo dos Boletins de Resduos Referenciados...</font></p>';
		}
		if($fase == 'C7_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo Movimento de Estoque...</font></p>';
		}
		if($fase == 'C7'){
			if($cmpl=='I'){
				$operacao = 'Inutilizada';
			}else{
				$operacao = 'Cancelada';
			}
			echo '<p><font size="2" face="Verdana">Nota Fiscal '.$operacao.' com Sucesso!</font></p>';
		}
		if($fase == 'FS-DA'){
			echo '<p><font size="2" face="Verdana">NF-es validadas com sucesso! Formulrio de Segurana Autorizado!</font></p>';
		}
		if($fase == 'OFF-LINE'){
			echo '<p><font size="2" face="Verdana">NFC-es validadas com sucesso! Emisso em Contingncia OFF-LINE!</font></p>';
		}
		if($fase == 'C8_A'){
			echo '<p><font size="2" face="Verdana">Desfazendo a Conta...</font></p>';
		}
		if($fase == 'C1_G'){
			if($cmpl=='I'){
				$operacao = 'Inutilizao';
			}else{
				$operacao = 'Cancelamento';
			}
			echo '<p><font size="2" face="Verdana">Iniciando processo de '.$operacao.' da Conta!</font></p>';
		}
		if($fase == 'C7_G'){
			if($cmpl=='I'){
				$operacao = 'Inutilizada';
			}else{
				$operacao = 'Cancelada';
			}
			echo '<p><font size="2" face="Verdana">A Conta foi '.$operacao.' com Sucesso!</font></p>';
		}

		flush(); @ob_flush();
		flush(); @ob_flush();
	}

	function nfe_formata_txt($texto){
		$texto2='';
		$texto1 = strtr(trim($texto), array(";" => ':', "  " => ' ', "'" => '', '"' => '', '' => '-', "	" => ' '));
		$texto1 = strtr(trim($texto1), array("\r\n" => ';', "\r" => ';', "\n" => ';'));
		while($texto1!=$texto2){
			$texto2 = $texto1;
			$texto1 = strtr(trim($texto1), array("  " => ' ', ";;" => ';'));
		}
		return $texto1;
	}

	function nfe_gera_chave($reg_nfe,$modalidade=0){
		//consulta srie da NF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie ='SELECT NFe_Ambiente,NFe_TipoEmissao,NFe_FormatoDANFe '.
					' FROM nota_fiscal_serie '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Modelo="'.$reg_nfe->Modelo.'"'.
					' AND Serie="'.$reg_nfe->Serie.'"'.
					' AND SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		//gera chave de acesso  NF-e (caso ainda no possua)
		//so 44 dgitos
		// 02 cdigo UF do emitente
		// 04 ano mes de emisso
		// 14 cnpj emitente
		// 02 Modelo (55)
		// 03 serie
		// 09 nr documento
		// 01 forma emisso
		// 08 aleatrio
		// 01 digitos Mod 11
		if(($modalidade=='5')||
			($modalidade=='6')||
			($modalidade=='7')||
			($modalidade=='9')){
			if($reg_nfe->Modelo=='65' || $reg_nfe->Modelo=='59'){
				$modalidade = '9'; //nfc-e s tem off-line - nao tem svc
			}
			if(($reg_nfe->Modelo=='55')&&($modalidade=='9')){
				$modalidade = '1'; //nf-e no tem off-line (nesse caso a contigencia  s pra NFC-e)
			}
			$reg_serie[1] = $modalidade;
		}
		//pega uf da empresa e consulta cadastro pra saber o numero de referencia
		$con_uf='SELECT Codigo_UF FROM uf '.
				' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
				' AND UF="'.$reg_nfe->Empresa_UF.'"';
		$res_uf = consulta_sql($con_uf);
		$reg_uf = consulta_ler_linha($res_uf);
		consulta_limpa($res_uf);
		$ano_mes = nfe_ano_mes($reg_nfe->DH_Emissao,'AAMM');
		$cnpj    = limpa_numero($reg_nfe->Empresa_CNPJ);
		$serie   = limpa_numero($reg_nfe->Serie);
		if($reg_nfe->NFe_Chave==''){
			$nr_random = '';
			$chave_ok = false;
			while (!$chave_ok){
				$nr_random = fill_full(rand(10, 999), 4).
				fill_full(rand(100,5999),4);
				$chave_ok = ($nr_random!='00000000') && ($nr_random!='11111111') &&
							($nr_random!='22222222') && ($nr_random!='33333333') &&
							($nr_random!='44444444') && ($nr_random!='55555555') &&
							($nr_random!='66666666') && ($nr_random!='77777777') &&
							($nr_random!='88888888') && ($nr_random!='99999999') &&
							($nr_random!='12345678') && ($nr_random!='23456789') &&
							($nr_random!='34567890') && ($nr_random!='45678901') &&
							($nr_random!='56789012') && ($nr_random!='67890123') &&
							($nr_random!='78901234') && ($nr_random!='89012345') &&
							($nr_random!='90123456') && ($nr_random!='01234567');
			}
		}else{
			$nr_random = substr($reg_nfe->NFe_Chave,35,8);
		}
		$chave_nfe = fill_full($reg_uf[0],2).$ano_mes.
					fill_full($cnpj,14).fill_full($reg_nfe->Modelo,2).
					fill_full($serie,3).fill_full($reg_nfe->NrDoc,9).
					fill_full($reg_serie[1],1).$nr_random;
		$dig_nfe = nfe_modulo11($chave_nfe);
		$chave_nfe.= $dig_nfe;
		$upd_nota = 'Update nota_fiscal set'.
					' NFe_Chave="'.$chave_nfe.'",'.
					' NFe_Ambiente="'.$reg_serie[0].'", '.
					' NFe_TipoEmissao="'.$reg_serie[1].'", '.
					' NFe_FormatoDANFe="'.$reg_serie[2].'", '.
					' NFe_Versao="'.config_pad('nfe_versao').'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$reg_nfe->Nr_Nota.'" '.
					' AND NFe_Chave="'.$reg_nfe->NFe_Chave.'"';
					consulta_sql($upd_nota,true,1);

		//consulta ultimo registro dessa modalidade de contingencia <> 1
		//dh contingencia e motivo
		if($reg_serie[1]!='1'){
			$con_cont = 'SELECT * FROM nota_fiscal_contingencia'.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Modalidade="'.$reg_serie[1].'"'.
						' ORDER BY DH_Inicio desc';
			$res_cont = consulta_sql($con_cont);
			$reg_cont = consulta_ler_objeto($res_cont);
			consulta_limpa($res_cont);
			$upd_nota = 'Update nota_fiscal set'.
						' NFe_Contigencia_DH="'.$reg_cont->DH_Inicio.'", '.
						' NFe_Contigencia_Motivo="'.$reg_cont->Motivo.'" '.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota="'.$reg_nfe->Nr_Nota.'" '.
						' AND Situacao="I"'.
						' AND NFe_Contigencia_DH="0000-00-00 00:00:00"';
			consulta_sql($upd_nota,true,1);
		}
	}

	function nf_gera_chave($reg_nfe){
		//consulta srie da NF-e para preencher o ambiente tipod DANFe, etc.
		$con_serie ='SELECT Layout_Impressao '.
					' FROM nota_fiscal_serie '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Modelo="'.$reg_nfe->Modelo.'"'.
					' AND Serie="'.$reg_nfe->Serie.'"'.
					' AND SubSerie="'.$reg_nfe->SubSerie.'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		$upd_nota = 'Update nota_fiscal set'.
					' Layout_Impressao="'.$reg_serie[0].'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$reg_nfe->Nr_Nota.'" ';
		/**Modificao realizada em  14-05-2021 para forar a impressao em Lote das NF modelo zz - hardt 205 */
		//			' AND ( (Situacao="A")'.
		//			'    OR (Situacao="P") )';
		consulta_sql($upd_nota,true,1);
	}

	function nfe_numero($valor,$qtd_zeros=2){
		$valor = (($valor + 1) - 1);
		$valor = number_format($valor,$qtd_zeros,".","");
		return $valor;
	}

	function nfe_valida_dados_nfe($nr_nota){
		///valida minimamente os dados da NF-e para minimizar Rejeies na SEFAZ
		$erros = '';
		//conuslta Nota Fiscal
		$con_nfe =  'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);

		if (($reg_nfe->NrDoc==0) && ($reg_nfe->Modelo != 59)){
			//calcula Nr doc pela serie
			$con_doc_serie = 'select * from nota_fiscal_serie '.
							' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Modelo = "'.$reg_nfe->Modelo.'"'.
							' and Serie = "'.$reg_nfe->Serie.'"'.
							' and SubSerie = "'.$reg_nfe->SubSerie.'"';
			$res_doc_serie = consulta_sql($con_doc_serie);
			$reg_doc_serie = consulta_ler_objeto($res_doc_serie);
			consulta_limpa($res_doc_serie);
	
			$ok = false;
			$tentativa = 0;
			$ultimo_doc = $reg_doc_serie->UltimoDoc;
			$teste = '';
			$nr_nota_fiscal = $nr_nota;
	
			while (!($ok)){
				$up_nota_fiscal_serie = 'update nota_fiscal_serie set '.
										' UltimoDoc = "'.($ultimo_doc+1).'" '.
										' where Dominio = "'.$_SESSION['Dominio'].'" '.
										' and Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
										' and UltimoDoc = "'.$ultimo_doc.'"'.
										' and Modelo = "'.$reg_nfe->Modelo.'"'.
										' and Serie = "'.$reg_nfe->Serie.'"'.
										' and SubSerie = "'.$reg_nfe->SubSerie.'"';
	
				$ok = (consulta_sql($up_nota_fiscal_serie,true,1) > 0 );
	
				$ultimo_doc++;
				$tentativa++;
				if(($tentativa==10) &&($ok==false)){
					$ok = true;
					$nr_nota_fiscal = 0;
				}
			}
			//coloca nr e data atualizada nesta nota
			if($nr_nota_fiscal>0){
				$upd_nota_fiscal =  'Update nota_fiscal set '.
									' NrDoc = "'.$ultimo_doc.'", '.
									' NFe_Chave = "", '.
									' DH_Emissao = now(), '.
									' DH_EntSai = now(), '.
									' DH_SaidaNota = DH_EntSai '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota = "'.$nr_nota.'"';
				consulta_sql($upd_nota_fiscal);
			}
		}




		//validao emitente
		//CNPJ
		//if(strlen($reg_nfe->Empresa_CNPJ)<18){
		//    $erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da empresa  invlido!';
		//}
		//vlidar o CNPJ (funo)
		if(!CalculaCNPJ($reg_nfe->Empresa_CNPJ)){
			$erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da Empresa  invlido!';
		}
		//nome
		if(strlen($reg_nfe->Empresa_Razao)<3){
			$erros.='<BR>A Razo Social "'.$reg_nfe->Empresa_Razao.'" da empresa  invlida!';
		}
		//fantasia      //nao aobrigatorio
		if(($reg_nfe->Empresa_Fantasia!='')&&(strlen($reg_nfe->Empresa_Fantasia)<3)){
			$erros.='<BR>O nome fantasia da Empresa  invlido!';
		}
		//logradouro
		if(strlen($reg_nfe->Empresa_Logradouro)<2){
			$erros.='<BR>O logradouro da Empresa  invlido!';
		}
		//bairro
		if(strlen($reg_nfe->Empresa_Bairro)<2){
			$erros.='<BR>O bairro da Empresa  invlido!';
		}
		//CEP
		if(($reg_nfe->Empresa_CEP!='')&&(strlen($reg_nfe->Empresa_CEP)<9)){
			$erros.='<BR>O CEP "'.$reg_nfe->Empresa_CEP.'" da Empresa  invlido!';
		}
		//cidade nome
		if(strlen($reg_nfe->Empresa_Nome_Cidade)<2){
			$erros.='<BR>O nome de cidade da Empresa  invlido!';
		}
		//Cidade nr
		if(($reg_nfe->Empresa_Codigo_Cidade<=0)&&(strlen($reg_nfe->Empresa_Codigo_Cidade)>7)){ //1000000
			$erros.='<BR>O cdigo de cidade da Empresa  invlido!';
		}
		//pais nome
		if(strlen($reg_nfe->Empresa_Nome_Pais)<2){
			$erros.='<BR>O nome de pas da Empresa  invlido!';
		}
		//pais nr
		if($reg_nfe->Empresa_Codigo_Pais<=0){
			$erros.='<BR>O cdigo de pas da Empresa  invlido!';
		}
		//telefone
		if(strlen($reg_nfe->Empresa_Telefone_Nr)<14){
			$erros.='<BR>O telefone "'.$reg_nfe->Empresa_Telefone_Nr.'" da Empresa  invlido!';
		}
		//UF
		if(strlen($reg_nfe->Empresa_UF)<2){
			$erros.='<BR>A UF da Empresa  invlida!';
		}
		//IE
		if(limpa_mascara($reg_nfe->Empresa_Insc_Estadual) != ''){
			if(strtoupper($reg_nfe->Empresa_Insc_Estadual) != 'ISENTO'){
				if(!(ChkInscEstadual($reg_nfe->Empresa_Insc_Estadual, $reg_nfe->Empresa_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" da Empresa  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}
		//IM/CNAE  //se informar IM informe o CNAE da empresa
		//if($reg_nfe->Empresa_IM!=''){
		//    if(strlen($reg_nfe->Empresa_CNAE)<=0){
		//        $erros.='<BR>O CNAE da Empresa  invlido!';
		//    }
		//}
		//validao destinatrio
		//CNPJ
		if($reg_nfe->Dest_UF!='EX'){  //no valida caso seja estrangeiro
			if(strlen($reg_nfe->Dest_CPF_CNPJ)==14){
				if(!CalculaCPF($reg_nfe->Dest_CPF_CNPJ)){
					if(($reg_nfe->Modelo=='65')&&($reg_nfe->Dest_CPF_CNPJ=='000.000.000-00')){
						//cliente padrao consumidor final
					}else{
						$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
					}
				}
			}else if(strlen($reg_nfe->Dest_CPF_CNPJ)==18){
				if(!CalculaCNPJ($reg_nfe->Dest_CPF_CNPJ)){
					$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
				}
			}else if(($reg_nfe->Modelo!='65')||($reg_nfe->Destinatario>0)){
				$erros.='<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
			}
		}
		//nome
		if (($reg_nfe->Modelo=='65')&&($reg_nfe->Dest_Razao=='')){
		}else{
			if(strlen($reg_nfe->Dest_Razao)<3){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Destinatario>0)){
					$erros.='<BR>O razo social do Cliente/Fornecedor  invlido!';
				}
			}
			//fantasia      //nao aobrigatorio
			if(($reg_nfe->Dest_Fantasia!='')&&(strlen($reg_nfe->Dest_Fantasia)<3)){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Destinatario>0)){
					$erros.='<BR>O nome fantasia do Cliente/Fornecedor  invlido!';
				}
			}
		}
		if(($reg_nfe->Modelo=='65')&&
			(($reg_nfe->Dest_Endereco==0)||
			($reg_nfe->Dest_Logradouro==''))){
		}else{
			//logradouro
			if(strlen($reg_nfe->Dest_Logradouro)<2){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O logradouro do Cliente/Fornecedor  invlido!';
				}
			}
			//bairro
			if(strlen($reg_nfe->Dest_Bairro)<2){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O bairro do Cliente/Fornecedor  invlido!';
				}
			}
			//CEP
			//if(strlen($reg_nfe->Dest_UF)!='EX'){
			//    if(strlen($reg_nfe->Dest_CEP)<9){
			//        $erros.='<BR>O CEP "'.$reg_nfe->Dest_CEP.'" do Cliente/Fornecedor  invlido!';
			//    }
			//}
			//cidade nome
			if(strlen($reg_nfe->Dest_Nome_Cidade)<2){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O nome de cidade do Cliente/Fornecedor  invlido!';
				}
			}
			//Cidade nr
			if($reg_nfe->Dest_Codigo_Cidade<=0){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O cdigo de cidade do Cliente/Fornecedor  invlido!';
				}
			}
			//pais nome
			if(strlen($reg_nfe->Dest_Nome_Pais)<2){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O nome de pas do Cliente/Fornecedor  invlido!';
				}
			}
			//pais nr
			if($reg_nfe->Dest_Codigo_Pais<=0){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>O cdigo de pas do Cliente/Fornecedor  invlido!';
				}
			}
			/*
			//telefone
			if(strlen($reg_nfe->Dest_Telefone_Nr)<14){
			$erros.='<BR>O telefone "'.$reg_nfe->Dest_Telefone_Nr.'" do Cliente/Fornecedor  invlido!';
			}*/
			//UF
			if(strlen($reg_nfe->Dest_UF)<2){
				if(($reg_nfe->Modelo!='65')||($reg_nfe->Dest_Endereco>0)){
					$erros.='<BR>A UF do Cliente/Fornecedor  invlida!';
				}
			}
		}
		//IE
		if(limpa_mascara($reg_nfe->Dest_Insc_Estadual) != ''){
			if(strtoupper($reg_nfe->Dest_Insc_Estadual) != 'ISENTO'){
				$ie_validar = $reg_nfe->Dest_Insc_Estadual;
				if(substr($ie_validar,0,2)=='NC'){
					$ie_validar = substr($ie_validar,2,20);
				}
				if(!(ChkInscEstadual($ie_validar, $reg_nfe->Dest_UF))){
					$erros.='<BR>A Inscrio Estadual "'.$ie_validar.'" do Cliente/Fornecedor  invlida para "'.$reg_nfe->Dest_UF.'"!';
				}
			}
		}
		//transportadora
		//CNPJ
		//somente se tivera transportadora definida na NF
		if($reg_nfe->Transportadora>0){
			if(($reg_nfe->Transp_CPF_CNPJ!='00.000.000/0000-00') ||
				($reg_nfe->Transp_CPF_CNPJ!='000.000.000-00')){
				if(strlen($reg_nfe->Transp_CPF_CNPJ)==14){
					if(!CalculaCPF($reg_nfe->Transp_CPF_CNPJ)){
						$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
					}
				}else if(strlen($reg_nfe->Transp_CPF_CNPJ)==18){
					if(!CalculaCNPJ($reg_nfe->Transp_CPF_CNPJ)){
						$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
					}
				}else{
					$erros.='<BR>O CNPJ "'.$reg_nfe->Transp_CPF_CNPJ.'" da Transportadora  invlido!';
				}
			}
			//nome
			if(strlen($reg_nfe->Transp_Nome)<3){
				$erros.='<BR>O nome da Transportadora  invlido!';
			}
			//UF
			if(strlen($reg_nfe->Transp_UF)<2){
				$erros.='<BR>A UF da Transportadora  invlida!';
			}
			//IE
			if(limpa_mascara($reg_nfe->Transp_IE) != ''){
				if(strtoupper($reg_nfe->Transp_IE) != 'ISENTO'){
					if(!(ChkInscEstadual($reg_nfe->Transp_IE, $reg_nfe->Transp_UF))){
						$erros.='<BR>A Inscrio Estadual "'.$reg_nfe->Transp_IE.'" da Transportadora  invlida para "'.$reg_nfe->Transp_UF.'"!';
					}
				}
			}
		}

		$total_item = array();
		$con_depart='select Codigo_Depart, Fatura_Sem_Estoque, Controle_Lote  '.
					' from produto_departamento '.
					' where Dominio="'.$_SESSION['Dominio'].'"';
		$res_depart = consulta_sql($con_depart);
		$nrw_depart = consulta_num_registros($res_depart);
		for($d=0;$d<$nrw_depart;$d++){
			$reg_depart = consulta_ler_linha($res_depart);
			$depart[$reg_depart[0]] = $reg_depart[1];
			$tplote[$reg_depart[0]] = $reg_depart[2];	
		}
		consulta_limpa($res_depart);

		//consulta Nota Fiscal Item
		$con_item = 'SELECT * FROM nota_fiscal_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrw_item;$i++){
			$reg_item = consulta_ler_objeto($res_item);
			//valida dados do produto
			//Codigo
			//descrio
			if(strlen($reg_item->Prod_Descricao)<2){
				$erros.= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": Descrio do Produto  invlido!';
			}
			//Unidade de medida
			if(strlen($reg_item->Unidade_NF)<1){ //pode sim ter 1 dig
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A unidade de medida  invlida!';
			}
			//NCM (se com IPI ou CFOP comea com 3 ou 7 tem que ter 8 digitos, seno s dois  suficiente)
			if(($reg_item->IPI_Valor>0)||((substr($reg_item->CFOP,0)==3)||(substr($reg_item->CFOP,0)==7))){
				if(strlen($reg_item->Prod_NCM)<10){
					$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuir todos os dez dgitos para operaes com exterior ou com incidncia de IPI!';
				}
			}else if(strlen($reg_item->Prod_NCM)<2){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuiir ao menos os dois primeiros dgitos (gnero) para esta operao!';
			}
			//Origem da Mercadoria (se CFOP = 3) a origem deve ser 1
			if(substr($reg_item->CFOP,0)==3){
				if($reg_item->Origem!='1'){
					$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A origem de mercadoria  invlida! para operaes de importao a origem deve ser obrigatoriamente "2 - Estrangeira"';
				}
			}
			//CSTs de ICMS, IPI, PIS e COFINS (validar se Os CST existem na lista de CSTs)
			if(busca_dados_combo('icms_cst_'.$reg_nfe->Empresa_CRT,$reg_item->ICMS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do ICMS "'.$reg_item->ICMS_CST.'"  invlido!';
			}
			if(busca_dados_combo('ipi_cst',$reg_item->IPI_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do IPI "'.$reg_item->IPI_CST.'"  invlido!';
			}
			if(busca_dados_combo('pis_cst_nf_'.$reg_nfe->TipoES,$reg_item->PIS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do PIS "'.$reg_item->PIS_CST.'"  invlido!';
			}
			if(busca_dados_combo('cofins_cst_nf_'.$reg_nfe->TipoES,$reg_item->COFINS_CST)==''){
				$erros.='<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do COFINS "'.$reg_item->COFINS_CST.'"  invlido!';
			}
			if (($_SESSION['Dominio']==2)||($_SESSION['Dominio']==359)){
				
				if (($reg_item->Prod_Depart==14)&&
					($_SESSION['Dominio']==2)&&
					($reg_nfe->Destinatario<100)){
					//transferencia de cereais deixa ficar negativo
				
				}else if (($reg_item->Quantidade_Estoque>0)&&
					($reg_item->CFOP_Mov_Estoque=='D')&&
					($reg_item->Prod_Depart>0)){
					//verifica se o departamento controla estoque (servios nunca controla)
					//echo 'Depart'.$reg_item->Prod_Depart;
					if (isset($depart[$reg_item->Prod_Depart])){
						if ($depart[$reg_item->Prod_Depart]=='N'){
				   
							$con_hist_fin = 'select DH_Liberacao, Estoque from pessoa_liberacao_fat '.
											' where Dominio = "'.$_SESSION['Dominio'].'" '.
											' and Pessoa = "'.$reg_nfe->Destinatario.'" '.
											' and Id_Produto="'.$reg_item->Id_Produto.'"'.
											' order by DH_Liberacao Desc limit 1';
							$res_hist_fin = consulta_sql($con_hist_fin);
							$reg_hist_fin = consulta_ler_linha($res_hist_fin);
							consulta_limpa($res_hist_fin);
							//$resultado.= $con_hist_fin;
							if ((dataf($reg_hist_fin[0])==data_atual('data'))&&($reg_hist_fin[1]=='S')) {

							}else{
								//consulta estoque
								$con_estoque =	'select sum(Saldo_Atual) from produto_saldo_filial '.
												' where Dominio="'.$_SESSION['Dominio'].'"'.
												' and Codigo_Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
												' and Id_Produto="'.$reg_item->Id_Produto.'"'.
												' and Local_Armaz = "0"';
								$res_estoque = consulta_sql($con_estoque);
								$reg_estoque = consulta_ler_linha($res_estoque);
								consulta_limpa($res_estoque);

								$tp_lote = $tplote[$reg_item->Prod_Depart];

								$con_prod = 'select Estoque_Lote from produto '.
											' where Dominio ="'.$_SESSION['Dominio'].'"'.
											' and Id_Produto="'.$reg_item->Id_Produto.'"';
								$res_prod = consulta_sql($con_prod);
								$ped_prod = consulta_ler_linha($res_prod);
								consulta_limpa($res_prod);

								$con_prod_barras =	'SELECT Codigo_Barras, Complemento, Saldo_Atual FROM produto_cod_barras '.
													' where Dominio ="'.$_SESSION['Dominio'].'" '.
													' and Id_Produto="'.$reg_item->Id_Produto.'" '.
													' and Codigo_Barras="'.$reg_item->Barra_Produto.'" '.
													' and Situacao<>"E" ';
								$res_prod_barras = consulta_sql($con_prod_barras);
								$num_cod_baras  = consulta_num_registros($res_prod_barras);
								$reg_prod_barras = consulta_ler_linha($res_prod_barras);
								consulta_limpa($res_prod_barras);

								if ($ped_prod[0]!='N'){
									$tp_lote = $ped_prod[0];
								}

								$chave_prod = $reg_item->Id_Produto;
								$ds_lote = '';
								if (($tp_lote=='L')||($tp_lote=='P')||($tp_lote=='F')){
									//contar a quantidade deste lote disponvel
									$chave_prod.= '_'.$reg_item->Peneira.'_'.$reg_item->NrLote;
									$con_lotes ='select sum(Saldo_Atual) from produto_saldo_filial_lote '.
												' where Dominio="'.$_SESSION['Dominio'].'"'.
												' and Codigo_Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
												' and Id_Produto="'.$reg_item->Id_Produto.'"'.
												' and Peneira="'.$reg_item->Peneira.'"'.
												' and NrLote="'.$reg_item->NrLote.'"';
									$res_lotes = consulta_sql($con_lotes);
									$reg_lotes = consulta_ler_linha($res_lotes);
									consulta_limpa($res_lotes);

									$disponivel = $reg_lotes[0];
									$ds_lote = ' Lote: '.$reg_item->NrLote;
								}else{
									$disponivel = $reg_estoque[0];
								}
								//se o disponvel for inferior ao saldo da filail
								//deve usar este disponivel
								if ($disponivel<$reg_estoque[0]){
									$reg_estoque[0] = $disponivel;
								}
						  
								if (!(isset($total_item[$chave_prod]))){
									$total_item[$chave_prod] = 0;
								}
								$total_item[$chave_prod]+= $reg_item->Quantidade_Estoque;

								$s_estoque = formata_qtd($reg_estoque[0],3, false);
                                $n_estoque = str2nr(formata_valor($s_estoque));
								$s_total = formata_qtd($total_item[$chave_prod],3, false);
                                $n_total = str2nr(formata_valor($s_total));


								if ($n_estoque<$n_total){	
									$erros.='<BR>Saldo Insuficiente! Produto Seq: "'.$reg_item->Seq_Item.'" : '.
											'Produto: '.$reg_item->Codigo_Produto.'-'.$reg_item->Prod_Descricao.
											$ds_lote.
											' Saldo Atual: '.formata_qtd($reg_estoque[0],3, false);
								}else if ($disponivel<$reg_item->Quantidade_Estoque){
									$erros.='<BR>Saldo Insuficiente! Produto Seq: "'.$reg_item->Seq_Item.'" : '.
											'Produto: '.$reg_item->Codigo_Produto.'-'.$reg_item->Prod_Descricao.
											$ds_lote.
											' Saldo Atual: '.formata_qtd($reg_estoque[0],3, false);
								}
							}//nao tem liberao
						}//fim depart controla estoque
					}//tem departament
				}//qtd >0
			}//dominiio 2
		}//for item
		consulta_limpa($res_item);

		if($erros!=''){
			$upd_nota = 'Update nota_fiscal '.
						'set Situacao="P" '.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota="'.$nr_nota.'" '.
						' AND Situacao="I"';
			$res_upd = consulta_sql($upd_nota,true,1);  //retorna para P pois no vai fazer a NFe
			nfe_exibe_erro('FRE-602','A Nota Fiscal <b>"'.$reg_nfe->NrDoc.'/'.$reg_nfe->Serie.'"</b> contm dados invlidos!'.
										'<BR>Corrija os dados e tente o envio navamente!'.$erros.'<BR><BR>',0);
		}
		return ($erros=='');
	}

	//copia arquivo de trnsferencia
	function nfe_copia_arquivo2($origem,$destino,$arquivo_o,$arquivo_d,$ano_mes){
		//determina nome do arquivo de origem
		$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$origem.'/SEFAZ/NF-es/'.$ano_mes.'/Autorizados';
		$arq_ori = $pasta_ori.'/'.$arquivo_o;
		//echo 'Arqui Ori'.$arq_ori.'<BR>';
		$ano_mes2 =  nfe_ano_mes();
		//determina nome do arquivo de destino
		$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$destino.'/SEFAZ/NF-es/'.$ano_mes2.'/Recebidas';
		$arq_des = $pasta_des.'/'.$arquivo_d;
		//se renomeia
		//echo 'Arqui Dest'.$arq_des.'<BR>';
		//verifica se arquivo de origem existe
		if(file_exists($arq_ori)){
			//verifica se pasta de destino existe
			if(!(file_exists($pasta_des))){
				//seno cria ela (ano_mes)
				rmkdir($pasta_des."/",0777);
			}
			//verifica se destino existe
			if(file_exists($arq_des)){
				//apaga arquivo de destino caso exista alguma coisa
				unlink($arq_des);
			}
			//efetiva acopia do arquivo
			//echo $arq_ori.'-'.$arq_des.'<BR>';
			$copiou = copy($arq_ori, $arq_des);

			//se fez a copia corretamente
			if($copiou){
				return true;
			}else{
				nfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
										'Verifique a estrutura de pastas do servidor!',0);
				return false;
			}
		}else{ //seno
			//exibe erro de arquivo inexistente
			nfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo_o.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
									'Verifique a estrutura de pastas do servidor!',0);
			return false;
		}
	}

	//muda a pasta ano mes da pasta recebidas (edio da data de entrada)
	function nfe_copia_arquivo3($empresa,$data1,$data2,$arquivo){
		//determina nome do arquivo de origem
		$ano_mes1 = nfe_ano_mes($data1);
		$ano_mes2 = nfe_ano_mes($data2);
		if($ano_mes2!=$ano_mes1){
			$pasta_ori = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$empresa.'/SEFAZ/NF-es/'.$ano_mes1.'/Recebidas';
			$arq_ori = $pasta_ori.'/'.$arquivo;
			//echo 'Arqui Ori'.$arq_ori.'<BR>';
			//determina nome do arquivo de destino
			$pasta_des = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nf_e/'.$empresa.'/SEFAZ/NF-es/'.$ano_mes2.'/Recebidas';
			$arq_des = $pasta_des.'/'.$arquivo;
			//se renomeia
			//echo 'Arqui Dest'.$arq_des.'<BR>';
			//verifica se arquivo de origem existe
			if(file_exists($arq_ori)){
				//verifica se pasta de destino existe
				if(!(file_exists($pasta_des))){
					//seno cria ela (ano_mes)
					rmkdir($pasta_des."/",0777);
				}
				//verifica se destino existe
				if(file_exists($arq_des)){
					//apaga arquivo de destino caso exista alguma coisa
					unlink($arq_des);
				}
				//efetiva acopia do arquivo
				//echo $arq_ori.'-'.$arq_des.'<BR>';
				$copiou = copy($arq_ori, $arq_des);
				//se fez a copia corretamente
				if($copiou){
					unlink($arq_ori);
					return true;
				}else{
					nfe_exibe_erro('FRE-004','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
											'Verifique a estrutura de pastas do servidor!',0);
					return false;
				}
			}else{ //seno
				//exibe erro de arquivo inexistente
				nfe_exibe_erro('FRE-003','Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$ano_mes1.'" para a pasta "'.$ano_mes2.'"!<BR>'.
										'Verifique a estrutura de pastas do servidor!',0);
				return false;
			}
		}else{
			return true;
		}
	}

	///// FUNO PARA VERIFICAR A DATA DE VALIDADE DO CERTIFICADO E EMITIR UM AVISO
	function nfe_validade_do_certificado(){
		//Gera um arquivo uninfe-cons-inf.xml na pasta de envio ()
		//O retorno  gerado aps o envio com o nome uninfe-ret-cons-inf.xml
		//Tendo esse arquivo de retorno vc ter os dados do uninfe
		//inclusive data ini e data fin
		//tendo data val faz uma comparao com a data atual e se
		//tiver faltando 30 dias emite um aviso no primeiro login do dia.
		$xml2 = new XML();
		$root = &$xml2->createRoot("ConsInf");
		$root->addAttribute('xServ', 'CONS-INF', false);
		$ano_mes_hora  = 'uninfe-cons-inf.xml';
		$xml2->toFile(nfe_pasta_raiz().'tmp/', $ano_mes_hora);
		$salvou = nfe_copia_arquivo('tmp','envio',$ano_mes_hora,'',false);
		//$salvou = true;
		$ano_mes = nfe_ano_mes();
		$data_atual = data_atual('data');
		$dias_falta = 0;
		$tentativa = 0;
		$validade = '';

		$ret['ok'] = '';
		$ret['dias'] = '';
		$ret['dtval'] = '';


		//se consegui salvar
		if($salvou){
			$ok = false;
			while(!($ok)){
				set_time_limit(60);
				if((file_exists(nfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
					$ok = true;
					usleep(200000);
				}else{
					usleep(200000);
					$tentativa++;
				}
				//echo 'ok';
				if($ok){
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno','uninfe-ret-cons-inf.xml', true);
					if($xml->root->name == 'retConsInf'){
						//echo 'retConsInf';
						foreach($xml->root->childs as $key => $value){
							if($xml->root->childs[$key]->name== 'DadosCertificado'){
								$dados_cert = &$xml->root->childs[$key];
								//echo 'DadosCertificado';
								foreach($dados_cert->atts as $key3 => $value2){
									if($dados_cert->atts[$key3]->name== 'dValFin'){
										//echo 'dValFin';
										$validade = $dados_cert->atts[$key3]->value;
									}
								}
							}
						}
					}
					if((file_exists(nfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml'))){
						unlink(nfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
					}
				}
				if($tentativa>=10){
					$ok = true;
				}
			}
			if($validade==''){
				$ret['ok'] = 'NE';
				return $ret;
			}else {
				$dt_validadeDT = substr($validade,0,10);
				$dias_falta = (-data2nr($data_atual)+data2nr($dt_validadeDT));

				$ret['ok'] = 'DP';
				$ret['dias'] = $dias_falta;
				$ret['dtval'] = $validade;
				if ($dias_falta<0){
					$ret['ok'] = 'FP';
				}

			}
			//$hr_validade
			//$dias_falta = 5;
		}
		// $consulta = 'Update param set Conteudo = "'.data_atual('date').'"'
		// 			.' WHERE Dominio="'.$_SESSION["Dominio"].'"'
		// 			.' AND Chave = "VALIDA_CERTIFICADO"';
		// $ok = consulta_sql($consulta,true,1);
		//unlink(nfe_pasta_raiz().'retorno/uninfe-ret-cons-inf.xml');
		return $ret;
	}

	function cce_gera_chave($nr_nota,$evento){
		$con_nota = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" ';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_objeto($res_nota);
		consulta_limpa($res_nota);
		$con_evento='SELECT * FROM nota_fiscal_evento '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" '.
					' AND Seq_Evento="'.$evento.'"';
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_objeto($res_evento);
		consulta_limpa($res_evento);
		$con_lote = 'SELECT max(CCe_Lote) FROM nota_fiscal_evento '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"';
		$res_lote = consulta_sql($con_lote);
		$reg_lote = consulta_ler_linha($res_lote);
		consulta_limpa($res_lote);
		//tpEvento + chave da NF-e + nSeqEvento
		$chave_cce = '110110'.
					$reg_nota->NFe_Chave.
					fill_full($reg_evento->Seq_Evento,2);
					$cod_orgao = substr($reg_nota->NFe_Chave,0,2);
		$lote = $reg_lote[0] + 1;
		$upd_nota = 'Update nota_fiscal_evento set'.
					' Versao_Evento="'.config_pad('cce_versao').'" ,'.
					' Id_Evento="'.$chave_cce.'", '.
					' CCe_Lote="'.$lote.'", '.
					' Cod_Orgao="'.$cod_orgao.'" '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota="'.$nr_nota.'" '.
					' AND Seq_Evento="'.$evento.'"'.
					' AND Id_Evento=""';
		consulta_sql($upd_nota,true,1);
		/*
		$con_evento = 'SELECT max( CONVERT( CCe_Lote, SIGNED )) '.
		' FROM nota_fiscal_evento '.
		' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
		' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' AND CCe_Lote <>""';
		$res_evento = consulta_sql($con_evento);
		$reg_evento = consulta_ler_linha($res_evento);
		consulta_limpa($res_evento);

		$upd_nota = 'Update nota_fiscal_evento set'.
		' CCe_Lote="'.($reg_evento[0]+1).'" ,'.
		' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
		' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
		' AND Nr_Nota="'.$nr_nota.'" '.
		' AND Seq_Evento="'.$evento.'"';
		consulta_sql($upd_nota,true,1);
		*/
	}

	function consulta_status_e_servico($tp_amb=2){
		$con_uf_empresa='SELECT Codigo_Cidade FROM pessoa_endereco '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Pessoa = "'.$_SESSION['Empresa_Codigo'].'" '.
						' AND Situacao <> "E" '.
						' ORDER BY Seq_Endereco ASC limit 1';
		$res_uf_empresa = consulta_sql($con_uf_empresa);
		$reg_uf_empresa = consulta_ler_linha($res_uf_empresa);
		consulta_limpa($res_uf_empresa);
		$ano_mes = nfe_ano_mes();
		$versao_c = '1.07';
		$versao = config_pad('nfe_versao');
		if($versao == '2.00'){
			$versao_c = '2.00';
		}
		if($versao == '3.10'){
			$versao_c = '3.10';
		}
		$xml = new XML();
		$root = &$xml->createRoot("consStatServ");
		$root->addAttribute('versao', $versao_c, true);
		$root->addAttribute('xmlns', 'http://www.portalfiscal.inf.br/nfe', true);
		$root->addAttribute('tpAmb', $tp_amb, false);
		//$root->addAttribute('tpAmb', '1', false);
		$root->addAttribute('cUF',  substr($reg_uf_empresa[0],0,2), false);
		//$root->addAttribute('tpEmis',  '3', false);
		$root->addAttribute('xServ',  'STATUS', false);
		$ano_mes = data_atual('date');
		$hora = nr2hora(hora_atual());
		$ano_mes_hora  = str_replace('-','',$ano_mes).'T'.str_replace(':','',$hora);
		//$ano_mes_hora = 'Outro';
		$xml->toFile(nfe_pasta_raiz().'tmp/', $ano_mes_hora.'-ped-sta.xml');
		$salvou = nfe_copia_arquivo('tmp','envio',$ano_mes_hora.'-ped-sta.xml','',false);
		$dh_sefaz = '';
		$data_sefaz = '';
		$hora_sefaz = '';
		$tentativa = 0;
		$diferenca_data = '';
		$diferenca_hora = '';
		$dh_sefaz = '';
		$tempo_medio_sefaz= '';
		$descricao_sefaz= '';
		$codigo_sefaz= '';
		//se consegui salvar
		if($salvou){
			$ok = false;
			while(!($ok)){
				//set_time_limit(60);
				if((file_exists(nfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml'))||
					(file_exists(nfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err'))){
					$ok = true;
					sleep(1);
					if(file_exists(nfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml')){
						$xml = new XML();
						$xml->fromFile(nfe_pasta_raiz().'retorno/',$ano_mes_hora.'-sta.xml', true);
						if($xml->root->name == 'retConsStatServ'){
							foreach($xml->root->atts as $key2 => $value){
								if($xml->root->atts[$key2]->name== 'dhRecbto'){
									$dh_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'tMed'){
									$tempo_medio_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'xMotivo'){
									$descricao_sefaz = &$xml->root->atts[$key2]->value;
								}
								if($xml->root->atts[$key2]->name== 'cStat'){
									$codigo_sefaz = &$xml->root->atts[$key2]->value;
								}
							}
							if(($codigo_sefaz=='107')&&($dh_sefaz!='')){
								//AAAA-MM-DDTHH:MM:SS
								$data_pc = data2nr(data_atual('data'));
								$hora_pc = hora_atual();
								$data_sefaz = substr($dh_sefaz,0,10);
								$hora_sefaz = substr($dh_sefaz,11);
								$data_sefaz = data2nr(dataf($data_sefaz));
								$hora_sefaz = hora2nr($hora_sefaz);
								$diferenca_data = 24*60*60*($data_sefaz-$data_pc);
								$diferenca_hora = ($hora_sefaz-$hora_pc);
								$diferenca = $diferenca_data+($diferenca_hora);
								$update='update uf set DH_SEFAZ = '.$diferenca.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										' AND Codigo_UF = "'.substr($reg_uf_empresa[0],0,2).'"';
								consulta_sql($update);
								unlink(nfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-sta.xml');
								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz.'.<BR><BR>Data/Hora: '.dataf((substr($dh_sefaz,0,10))).' '.substr($dh_sefaz,11).'<BR>Tempo mdio: '.$tempo_medio_sefaz.'s';
								//return true;
							}else {
								$mensagem = $codigo_sefaz.' - '.$descricao_sefaz;
							}
						}else{
							$mensagem = 'Falha na estrutura do arquivo XML de retorno!';
							//return false;
						}
					}else if(file_exists(nfe_pasta_raiz().'retorno/'.$ano_mes_hora.'-ped-sta.err')){
						//exibe mensagem do arquivo de erro
						$conteudo_arquivo = nfe_abre_arquivo_err($ano_mes_hora.'-ped-sta.err');
						$mensagem = 'Falha no Processamento do Arquivo '.$conteudo_arquivo.'!';
					}else{
						$mensagem = 'Falha no Processamento do Arquivo!';
						//return false;
					}
				}
			}//while
		}else{
			$mensagem = 'Consulta abortada por favor tente mais tarde!';
		}
		return $mensagem;
	}

	function nfe_busca_ambiente_evento(){
		$retorno = '2';
		$con_serie ='SELECT NFe_Ambiente FROM nota_fiscal_serie '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' AND Modelo = "55" '.
					' AND Situacao = "A" limit 1';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		if($reg_serie[0]=='1'){
			$retorno = '1';
		}
		return $retorno;
	}

	function nota_fiscal_busca_ipi_origem($empresa,$nr_nota,$produto){
		$con_origem='SELECT Nota_Empresa, Nota_Nr_Nota FROM nota_fiscal_refenciada '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$empresa.'" '.
					' AND Nr_Nota = "'.$nr_nota.'" '.
					' AND ((Tipo_Doc="N") OR (Tipo_Doc="E"))';
		$res_origem = consulta_sql($con_origem);
		$nrw_origem = consulta_num_registros($res_origem);
		$total_ipi = 0;
		for($o=0;$o<$nrw_origem;$o++){
			$reg_origem = consulta_ler_linha($res_origem);
			//consulta item da nota
			$con_item_o='SELECT SUM(Quantidade_Estoque) FROM nota_fiscal_item '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$reg_origem[0].'" '.
						' AND Nr_Nota = "'.$reg_origem[1].'" '.
						' AND Id_Produto = "'.$produto.'"';
			$res_item_o = consulta_sql($con_item_o);
			$reg_item_o = consulta_ler_linha($res_item_o);
			consulta_limpa($res_item_o);
			$total_ipi+= $reg_item_o[0];
		}
		consulta_limpa($res_origem);
		return $total_ipi;
	}

	function nfe_copia_arquivo_renomeia($pasta, $origem, $destino){
		$a_origem  = nfe_pasta_raiz().$pasta.'/'.$origem;
		$a_destino = nfe_pasta_raiz().$pasta.'/'.$destino;
		if(file_exists($a_destino)){
			unlink($a_destino);
		}
		//rename($a_origem,$a_destino);
		//echo 'Arquivo:'.$a_origem.'-'.$a_destino;
		copy($a_origem,$a_destino);
	}

	function XML_BuscaTag($xml,$tag,$campo=true){
		if ($campo){
			$xml_o = $xml;
			$posI = strpos(' '.$xml,'<'.$tag);
			$xml  = substr($xml, ($posI-1)+(strlen('<'.$tag)) );
			$posI2 = strpos($xml,'/>');
			if ($posI2>0){
				$valor = '';
			}else{
				$posI3 = strpos(' '.$xml,'>');
				$xml  = substr($xml,$posI3);
				$posF  = strpos($xml,'</'.$tag.'>');
				$valor = substr($xml,0,$posF);
			}
			/*if ($tag=='emit'){
			echo '<textarea rows="10" cols="100">'.
			'$valor:'.$valor.
			'$xml_o:'.$xml.
			'$tag:'.$tag.
			'$posI:'.$posI.
			'$posI2:'.$posI2.
			'$posI4:'.$posI3.
			'$posF:'.$posF.
			'</textarea>';

			} */
		}else{
			$posI = strpos($xml,' '.$tag.'="');
			$xml  = substr($xml,$posI);
			$posI = strpos(' '.$xml,'="');
			$xml  = substr($xml,$posI+1);
			$posF  = strpos($xml,'"');
			$valor = substr($xml,0,$posF);
		}
		return $valor;
	}

	function gzdecodeFree($data,&$filename='',&$error='',$maxlength=null){
		$len = strlen($data);
		if ($len < 18 || strcmp(substr($data,0,2),"\x1f\x8b")) {
			$error = "Not in GZIP format.";
			return null;  // Not GZIP format (See RFC 1952)
		}
		$method = ord(substr($data,2,1));  // Compression method
		$flags  = ord(substr($data,3,1));  // Flags
		if ($flags & 31 != $flags) {
			$error = "Reserved bits not allowed.";
			return null;
		}
		// NOTE: $mtime may be negative (PHP integer limitations)
		$mtime = unpack("V", substr($data,4,4));
		$mtime = $mtime[1];
		$xfl   = substr($data,8,1);
		$os    = substr($data,8,1);
		$headerlen = 10;
		$extralen  = 0;
		$extra     = "";
		if ($flags & 4) {
			// 2-byte length prefixed EXTRA data in header
			if ($len - $headerlen - 2 < 8) {
				return false;  // invalid
			}
			$extralen = unpack("v",substr($data,8,2));
			$extralen = $extralen[1];
			if ($len - $headerlen - 2 - $extralen < 8) {
				return false;  // invalid
			}
			$extra = substr($data,10,$extralen);
			$headerlen += 2 + $extralen;
		}
		$filenamelen = 0;
		$filename = "";
		if ($flags & 8) {
			// C-style string
			if ($len - $headerlen - 1 < 8) {
				return false; // invalid
			}
			$filenamelen = strpos(substr($data,$headerlen),chr(0));
			if ($filenamelen === false || $len - $headerlen - $filenamelen - 1 < 8) {
				return false; // invalid
			}
			$filename = substr($data,$headerlen,$filenamelen);
			$headerlen += $filenamelen + 1;
		}
		$commentlen = 0;
		$comment = "";
		if ($flags & 16) {
			// C-style string COMMENT data in header
			if ($len - $headerlen - 1 < 8) {
				return false;    // invalid
			}
			$commentlen = strpos(substr($data,$headerlen),chr(0));
			if ($commentlen === false || $len - $headerlen - $commentlen - 1 < 8) {
				return false;    // Invalid header format
			}
			$comment = substr($data,$headerlen,$commentlen);
			$headerlen += $commentlen + 1;
		}
		$headercrc = "";
		if ($flags & 2) {
			// 2-bytes (lowest order) of CRC32 on header present
			if ($len - $headerlen - 2 < 8) {
				return false;    // invalid
			}
			$calccrc = crc32(substr($data,0,$headerlen)) & 0xffff;
			$headercrc = unpack("v", substr($data,$headerlen,2));
			$headercrc = $headercrc[1];
			if ($headercrc != $calccrc) {
				$error = "Header checksum failed.";
				return false;    // Bad header CRC
			}
			$headerlen += 2;
		}
		// GZIP FOOTER
		$datacrc = unpack("V",substr($data,-8,4));
		$datacrc = sprintf('%u',$datacrc[1] & 0xFFFFFFFF);
		$isize = unpack("V",substr($data,-4));
		$isize = $isize[1];
		// decompression:
		$bodylen = $len-$headerlen-8;
		if ($bodylen < 1) {
			// IMPLEMENTATION BUG!
			return null;
		}
		$body = substr($data,$headerlen,$bodylen);
		$data = "";
		if ($bodylen > 0) {
			switch ($method) {
				case 8:
					// Currently the only supported compression method:
					$data = gzinflate($body,$maxlength);
					break;
				default:
					$error = "Unknown compression method.";
					return false;
			}
		}  // zero-byte body content is allowed
		// Verifiy CRC32
		$crc   = sprintf("%u",crc32($data));
		$crcOK = $crc == $datacrc;
		$lenOK = $isize == strlen($data);
		if (!$lenOK || !$crcOK) {
			$error = ( $lenOK ? '' : 'Length check FAILED. ') . ( $crcOK ? '' : 'Checksum FAILED.');
			return false;
		}
		return $data;
	}

	function nfxml_carac2especial($caracteres){
		$resultado = str_replace('&','&amp;' ,$caracteres);
		$resultado = str_replace('<','&lt;'  ,$resultado);
		$resultado = str_replace('>','&gt;'  ,$resultado);
		$resultado = str_replace('"','&quot;',$resultado);
		$resultado = str_replace('','&amp;Oslash;',$resultado);
		$resultado = str_replace('	',' ',$resultado);
		//retira carteres epeciais
		$LATIN_UC_CHARS = "`";
		$LATIN_LC_CHARS = "AAAAAAECEEEEIIIIDNOOOOOUUUUYaaaaaaeceeeeiiiionoooooouuuuy 2  '''";
		$resultado = strtr($resultado, $LATIN_UC_CHARS, $LATIN_LC_CHARS);
		$resultado = str_replace("'",'&apos;',$resultado);
		$resultado = $resultado;
		return trim($resultado);
	}

?>