<?
	//Fase 1 - Gerao Arquivo XML da NF-e
	//Fase 2 - Retorno Numero do Lote ou Erro
	//Fase 3 - Retrono Nmero do Recibo ou Erro
	//Fase 4 - Consulta Situao NF-e (caso j no tenha a situao na pasta)
	//Fase 5 - Retorno Consulta Situao (protocolo)
	//Fase 6 - Fechamento da NF-e e Finalizao do Processo como um todo.

	require_once(dirname(__FILE__).'/nfe_arquivos.php');

	function nfe_processa($nr_nota){
		$notas_proc = '';
		//verifica o status da nf gravando no banco o novo status (de  I Iniciado Processo)
		$upd_nota = 'UPDATE nota_fiscal SET '.
					' Situacao = "I" '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"'.
					' AND Situacao = "P"';
		$res_upd = consulta_sql($upd_nota, true, 1);
		//se pode fazer nf-e
		if($res_upd==1){
			$con_nfe = 'SELECT * FROM nota_fiscal '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota = "'.$nr_nota.'"';
			$res_nfe = consulta_sql($con_nfe);
			$reg_nfe = consulta_ler_objeto($res_nfe);
			consulta_limpa($res_nfe);

			if(BuscaParam('NF_DH_SAIDA')!='V'){ //se n~]ao for pra ficar vazio
				if(dataf($reg_nfe->DH_SaidaNota) == '00/00/0000'){ //se estiver vazio
					//coloca a data e hora da saida da nota
					$up_nota_d = 'UPDATE nota_fiscal SET '.
								' DH_EntSai = now(), '.
								' DH_SaidaNota = DH_EntSai '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
								' AND Nr_Nota = "'.$nr_nota.'"';
					$res_nota_d = consulta_sql($up_nota_d,true,1);
				}
			}

			//se a chave da NFe no est definida
			if($reg_nfe->NFe_Chave == ''){
				nfe_gera_chave($reg_nfe);
			}
			//inicia o processoa da NFe
			return nfe_processa_fase1($nr_nota);
			//return false;
		}else{ //seno
			// exibe erro na tela dezindo que nenhuma nota aberta se encontra na lista selecionada
			nfe_exibe_erro('FRE-001','Nota selecionada no pode ser enviada! Verifique novamente a lista, aparentemente outro usurio j fez o envio desta NF-e!',0);
			return false;
		}
	}

	function nfe_retorna_nfe($nr_nota){
		if($nr_nota != ''){
			//retorna o status dessa nota para "P"
			$upd_nota = 'UPDATE nota_fiscal SET'.
						' NFe_Versao_SF = "", '.
						' NFe_Situacao = "", '.
						' NFe_Lote = "", '.
						' NFe_Recibo = "", '.
						' NFe_Protocolo = "", '.
						' NFe_Protocolo_DH = "0000-00-00 00:00:00", '.
						' NFe_Protocolo_Sig = "",'.
						' NFe_Protocolo_C = "", '.
						' NFe_Protocolo_C_DH = "0000-00-00 00:00:00", '.
						' NFe_Protocolo_C_Sig = "", '.
						//' NFe_Contigencia_DH = "0000-00-00 00:00:00", '.
						//' NFe_Contigencia_Motivo = "", '.
						' NFe_Protocolo_Motivo = "", '.
						' Situacao = "P" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' AND Situacao = "I"';
			consulta_sql($upd_nota, true, 1);
		}
	}

	function nfe_processa_fase1($nr_nota,$modelo_nfe='55'){ //gerao do lote
		nfe_exibe_processamento('1');
		//consulta a nota no banco de dados e gera os arquivos XML na pasta tmp
		$nf_e = nfe_gera_arquivo_nfe($nr_nota);  //$nf_e['nr_nota']; $nf_e['chave_nfe'];
		//se a chave da nfe for vazia
		if($nf_e!=''){  //no teve erro no processo de gerao do arquivo
			$copiou = nfe_copia_arquivo('tmp','envio',$nf_e.'-nfe.xml',$nr_nota);
			if($copiou){ //sem erro na cpia para a pasta envio
				return nfe_processa_fase2($nr_nota,false,$modelo_nfe);
			}else{
				return false;
			}
		}else{
			return false;
		}
	}

	function nfe_processa_fase2($nr_nota,$parar=false,$modelo_nfe='55'){
		if(!($parar)){
			nfe_exibe_processamento('2');
		}
		//consulta dados da NF-e
		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		//fica testando at ter o retrono do lote ou arquivo de erro
		$ok = false;
		while (!($ok)){
			set_time_limit(60);
			if((file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Chave.'-nfe.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Chave.'-num-lot.xml'))){
				$ok = true;
				//espera 0,5 segundos				
				//avalia se tem arquivo de retrono de erro do lote
				$ano_mes = nfe_ano_mes($reg_nfe->DH_Emissao);
				if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Chave.'-nfe.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Chave.'-nfe.err');
					//copia arquivo de erro para a patas erros
					nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Chave.'-nfe.err',$nr_nota,true);
					nfe_exibe_erro('FRE-006','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Chave.'-nfe.xml"!'.
					$conteudo_arquivo,$nr_nota);
					return false;
				}else{
					//seno  por que gerou o arquivo de lote
					//abre o arquivo de lote para pegar o nmero do lote
					usleep(200000);
					$nr_lote = 0;
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno/', $reg_nfe->NFe_Chave.'-num-lot.xml', true);
					//le nr do lote no arquivo
					if($xml->root->name == 'DadosLoteNfe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'NumeroLoteGerado'){
								$nr_lote = fill_full($xml->root->atts[$key]->value,15);
							}
						}
					}
					//se leu arquivo de lote
					if($nr_lote >0){
						//copia arquivo de lote para a pasta de lotes enviados
						nfe_copia_arquivo('retorno','SEFAZ/Lotes/'.$ano_mes,$reg_nfe->NFe_Chave.'-num-lot.xml','');
						//salva nr do lote na NF-e
						$upd_nota = 'UPDATE nota_fiscal SET'.
									' NFe_Lote = "'.$nr_lote.'" '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota = "'.$nr_nota.'"'.
									' AND Situacao = "I"';
						consulta_sql($upd_nota,true,1);
						//incializa novo processo
						return nfe_processa_fase3($nr_nota);
					}else{  //seno
						if($parar){// se vai tentar denovo
							//copia arquivo de lote para a pasta de erros
							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Chave.'-num-lot.xml','',true);
							nfe_exibe_erro('FRE-007','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Chave.'-num-lot.xml"!'.
							'No foi possvel ler o nmero do lote da NF-e!',$nr_nota);
							return false;
						}else{
							//tenta denovo (s mais essa vez
							usleep(200000);
							return nfe_processa_fase2($nr_nota,true,$modelo_nfe);
						}
					}
				}
			}else{
				usleep(200000);
			}
		}
	}

	function nfe_processa_fase3($nr_nota,$modelo_nfe='55'){
		nfe_exibe_processamento('3');
		$ok = false;
		//consulta nr dados da NF-e
		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = nfe_ano_mes($reg_nfe->DH_Emissao);
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if((file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-rec.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-env-lot.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-pro-rec.err'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-rec.xml'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-pro-rec.xml'))){
				$ok = true;
				//espera 0,5 segundos
				//avalia se tem arquivo de retrono de erro do lote
				if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Lote.'-rec.err');
					nfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Lote.'-rec.err"!'.
											$conteudo_arquivo,$nr_nota);
					nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Lote.'-rec.err','',true);
					return false;
				}else if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Lote.'-pro-rec.err');
					nfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Lote.'-pro-rec.err"!'.
					$conteudo_arquivo,$nr_nota);
					nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Lote.'-pro-rec.err','',true);
					return false;
				}else if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-env-lot.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Lote.'-env-lot.err');
					nfe_exibe_erro('FRE-008','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Lote.'-env-lot.err"!'.
					$conteudo_arquivo,$nr_nota);
					nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Lote.'-env-lot.err','',true);
					return false;
				}else if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Lote.'-pro-rec.xml')){ //processo sincrono
					//restorna o erro do arquivo
					$upd_nota = 'UPDATE nota_fiscal SET '.
								' NFe_Recibo = "'.$reg_nfe->NFe_Lote.'" '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota = "'.$nr_nota.'"'.
								' AND Situacao = "I"';
					consulta_sql($upd_nota,true,1);
					//vi direto para para a proxima fase
					return nfe_processa_fase5($nr_nota,1,$modelo_nfe);
				}else{
					//seno  por que gerou o arquivo de recibo
					//abre o arquivo de recibo para pegar o status e motivo do recibo
					usleep(200000);
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno/', $reg_nfe->NFe_Lote.'-rec.xml', true);
					//le nr do lote no arquivo
					$status='';
					$motivo='';
					if($xml->root->name == 'retEnviNFe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if($xml->root->childs[$key]->name == 'infRec'){
								$inf_rec = &$xml->root->childs[$key];
							}
						}
					}
					//se o stauts for de lote processado
					if($status == '103'){
						//tenta ler o nr do recibo
						$nr_recibo = 0;
						foreach($inf_rec->atts as $key => $value){
							if($inf_rec->atts[$key]->name == 'nRec'){
								$nr_recibo = $inf_rec->atts[$key]->value;
							}
						}
						//fecha arquivo
						//se leu o numero do recibo
						if($nr_recibo > 0){   //salva nr do recibo na NF-e
							nfe_copia_arquivo('retorno','SEFAZ/Recibos/'.$ano_mes,$reg_nfe->NFe_Lote.'-rec.xml','',false);
							$upd_nota = 'UPDATE nota_fiscal SET '.
										' NFe_Recibo = "'.$nr_recibo.'" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota = "'.$nr_nota.'"'.
										' AND Situacao = "I"';
							consulta_sql($upd_nota, true, 1);
							//faz uma espera inicial de 15 segundos (nova norma)
							//if($modelo_nfe
							usleep(200000);
							if(!file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								sleep(1);
							}
							if(!file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								sleep(1);
							}
							if(!file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								sleep(3);
							}//apera at 5 segundos

							//no precisa fazer a consulta pois ela foi feita automaticamente
							if(file_exists(nfe_pasta_raiz().'retorno/'.$nr_recibo.'-pro-rec.xml')){
								return nfe_processa_fase5($nr_nota,1,$modelo_nfe);
							}else{
								return nfe_processa_fase4($nr_nota,1,$modelo_nfe);
							}
						}else{  //seno
							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Lote.'-rec.xml','',true);
							nfe_exibe_erro('FRE-009','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Lote.'-rec.xml"!'.
													'No foi possvel ler o nmero do recibo da NF-e!',$nr_nota);
							return false;
						}
					}else{
						//fecha arquivo
						//copia arquivo de lote para a pasta de erros
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Lote.'-rec.xml','',true);
						nfe_exibe_erro('FRE-010','Rejeio do Arquivo da NF-e pela SEFAZ!'.
						'"'.$status.'" - '.$motivo.'<BR><BR>'.
						'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
						return false;
					}
				}
			}else{
				usleep(200000);
			}
		}
	}

	function nfe_processa_fase4($nr_nota,$tentativa,$modelo_nfe = '55'){
		nfe_exibe_processamento('4',$tentativa);
		//consulta dados da NF-e
		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		nfe_gera_arquivo_consulta($nr_nota);
		//copia da pasta tmp para a pasta envio
		$copiou = nfe_copia_arquivo('tmp','envio',$reg_nfe->NFe_Recibo.'-ped-rec.xml','');
		if($copiou){
			return nfe_processa_fase5($nr_nota,$tentativa,$modelo_nfe);
		}else{
			return false;
		}
	}

	function nfe_processa_fase5($nr_nota,$tentativa=1,$modelo_nfe='55'){
		//consulta dados NF-e
		$con_nfe =  'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		$ano_mes = nfe_ano_mes($reg_nfe->DH_Emissao);
		//fica tentando at encontra o arquivo de retorno
		$ok = false;
		//consulta nr dados da NF-e
		//fica testando at ter o retrono do recibo ou arquivo de erro
		while (!($ok)){
			set_time_limit(60);
			if((file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Recibo.'-pro-rec.xml'))||
				(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Recibo.'-pro-rec.err'))){
				$ok = true;
				if(file_exists(nfe_pasta_raiz().'retorno/'.$reg_nfe->NFe_Recibo.'-pro-rec.err')){
					//restorna o erro do arquivo
					$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Recibo.'-pro-rec.err');
					nfe_exibe_erro('FRE-011','Falha no Processamento do Arquivo "'.$reg_nfe->NFe_Recibo.'-pro-rec.err"!'.
					$conteudo_arquivo,'');
					return false;
				}else{
					//abre arquivo de retorno da consulta
					usleep(200000);
					$status='';
					$motivo='';
					$xml = new XML();
					$xml->fromFile(nfe_pasta_raiz().'retorno/', $reg_nfe->NFe_Recibo.'-pro-rec.xml', true);
					//le nr do lote no arquivo
					if($xml->root->name == 'retConsReciNFe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if($xml->root->childs[$key]->name == 'protNFe'){
								$prot_nfe = &$xml->root->childs[$key];
							}
						}
					}
					if($xml->root->name == 'retEnviNFe'){
						foreach($xml->root->atts as $key => $value){
							if($xml->root->atts[$key]->name == 'cStat'){
								$status = $xml->root->atts[$key]->value;
							}
							if($xml->root->atts[$key]->name == 'xMotivo'){
								$motivo = $xml->root->atts[$key]->value;
							}
						}
						foreach($xml->root->childs as $key => $value){
							if($xml->root->childs[$key]->name == 'protNFe'){
								$prot_nfe = &$xml->root->childs[$key];
							}
						}
					}
					//pega status do lote
					if($status == '105'){  //lote ainda no processado aguarda e tenta denovo
						//fecha arquivo da consulta
						//copia para a pasta erros
						nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',true);
						//aguarda mais 10 segundos
						sleep(5);
						return nfe_processa_fase4($nr_nota,$tentativa+1,$modelo_nfe);
					}else if($status == '104'){
						//le dados do protocolo de recebimento da NFe
						ignore_user_abort(1);
						$status = '';
						$motivo = '';
						$protocolo_nr = '';
						$protocolo_dh = '';
						$protocolo_pr = '';
						$protocolo_dv = '';
						$txt_inf_prot = '';
						foreach($prot_nfe->childs as $key => $value){
							if($prot_nfe->childs[$key]->name == 'infProt'){
								$txt_inf_prot = $prot_nfe->childs[$key]->toString();
								foreach($prot_nfe->childs[$key]->atts as $key2 => $value){
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'cStat'){
										$status = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'xMotivo'){
										$motivo = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'verAplic'){
										$protocolo_pr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'dhRecbto'){
										$protocolo_dh = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'nProt'){
										$protocolo_nr = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
									if($prot_nfe->childs[$key]->atts[$key2]->name == 'digVal'){
										$protocolo_dv = $prot_nfe->childs[$key]->atts[$key2]->value;
									}
								}
							}
						}
						//grava dados do protocolo da NF-e
						set_time_limit(60);
						$upd_nota = 'UPDATE nota_fiscal SET'.
									' NFe_Situacao = "'.$status.'", '.
									' NFe_Protocolo_Motivo = "'.$motivo.'", '.
									' NFe_Versao_SF = "'.$protocolo_pr.'", '.
									' NFe_Protocolo_DH = "'.str_replace('T', ' ',$protocolo_dh).'", '.
									' NFe_Protocolo = "'.$protocolo_nr.'", '.
									' NFe_Protocolo_Sig = "'.$protocolo_dv.'" '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota = "'.$nr_nota.'"'.
									' AND Situacao = "I"';
						consulta_sql($upd_nota,true,1);
						set_time_limit(60);
						//le statsu da NF-e
						if(($status == '100')||($status == '150')){
							//fecha arquivo da consulta							
							set_time_limit(60);
							//copia para a pasta de recibos
							nfe_copia_arquivo('retorno','SEFAZ/Autorizacao/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',false);
							//foi autorizada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de aurorizada
							//abre o arquivo da NF-e da pasta backup/autorizadas							
							usleep(200000);
							$texto_nfe = xml_fromFile(nfe_pasta_raiz().'backup/Autorizados/'.$ano_mes,$reg_nfe->NFe_Chave.'-nfe.xml');
							//arquivo assinado est na pasta de nfes autorizadas
							//a autorizao j foi lida anteriormente ($prot_nfe)
							$string = '<?xml version="1.0" encoding="utf-8"?>'.
										'<nfeProc xmlns="http://www.portalfiscal.inf.br/nfe" versao="'.$reg_nfe->NFe_Versao.'">'.
										$texto_nfe.
										'<protNFe versao="'.$reg_nfe->NFe_Versao.'" xmlns="http://www.portalfiscal.inf.br/nfe">'.
										$txt_inf_prot.
										'</protNFe>'.
										'</nfeProc>';
							$Handle = fopen(nfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->NFe_Versao,5).'-procNFe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes.'/Autorizados',$protocolo_nr.'_v'.fill_full($reg_nfe->NFe_Versao,5).'-procNFe.xml','',false);
							//salva NFe pela chave de acesso tambm
							$Handle = fopen(nfe_pasta_raiz().'tmp/'.fill_full($reg_nfe->NFe_Chave,44).'-procNFe.xml', 'w');
							$Data = utf8_encode($string);
							fwrite($Handle, $Data);
							fclose($Handle);
							//copia para a pasta definitiva
							nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes.'/Autorizados2',fill_full($reg_nfe->NFe_Chave,44).'-procNFe.xml','',false);
							set_time_limit(60);
							return nfe_processa_fase6($nr_nota,true,$modelo_nfe);
						}else if(($status == '301')||
								 ($status == '302')){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de recibos
							nfe_copia_arquivo('retorno','SEFAZ/Denegacao/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',false);
							//foi denegada a NF-e
							//gera arquivo de distribuio da NF-e na pasta de denegadas

							if(!(file_exists(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes.'/'.$reg_nfe->NFe_Chave.'-den.xml'))){
								//se no tiver espera por qdeve estar em poucos instantes
								set_time_limit(60);
								sleep(1);
							}
							if(file_exists(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes.'/'.$reg_nfe->NFe_Chave.'-den.xml')){
								usleep(200000);
								$texto_nfe = xml_fromFile(nfe_pasta_raiz().'backup/Denegados/'.$ano_mes,$reg_nfe->NFe_Chave.'-den.xml');
								//arquivo assinado est na pasta de nfes autorizadas
								//a autorizao j foi lida anteriormente ($prot_nfe)
								$string = '<?xml version="1.0" encoding="utf-8"?>'.
											'<nfeProc xmlns="http://www.portalfiscal.inf.br/nfe" versao="'.$reg_nfe->NFe_Versao.'">'.
											$texto_nfe.
											'<protNFe versao="'.$reg_nfe->NFe_Versao.'" xmlns="http://www.portalfiscal.inf.br/nfe">'.
											$txt_inf_prot.
											'</protNFe>'.
											'</nfeProc>';
								$Handle = fopen(nfe_pasta_raiz().'tmp/'.$protocolo_nr.'_v'.fill_full($reg_nfe->NFe_Versao,5).'-procNFe.xml', 'w');
								$Data = utf8_encode($string);
								fwrite($Handle, $Data);
								fclose($Handle);
								//copia para a pasta definitiva
								nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes.'/Denegadas',$protocolo_nr.'_v'.fill_full($reg_nfe->NFe_Versao,5).'-procNFe.xml','',false);
								$Handle = fopen(nfe_pasta_raiz().'tmp/'.fill_full($reg_nfe->NFe_Chave,44).'-procNFe.xml', 'w');
								$Data = utf8_encode($string);
								fwrite($Handle, $Data);
								fclose($Handle);
								//copia para a pasta definitiva
								nfe_copia_arquivo('tmp','SEFAZ/NF-es/'.$ano_mes.'/Denegadas2',fill_full($reg_nfe->NFe_Chave,44).'-procNFe.xml','',false);
								//exibe mensagem na tela sobre a denegao de uso
								nfe_exibe_erro('FRE-013','A SEFAZ no autorizou o uso da NF-e!'.
														'"'.$status.'" - '.$motivo.'<BR><BR>'.
														'Conforme determina a legislao, essa nota no poder ser utilizada!'.
														'Entre em contato com a SEFAZ do seu Estado para obter mais informaes!','');
								set_time_limit(60);
								return nfe_processa_fase6($nr_nota,false);
							}else{
								if ($protocolo_nr!=''){
									nfe_exibe_erro('FRE-013-A','A SEFAZ denegou o uso da NF-e "'.$reg_nfe->NFe_Chave.'", '.
															'porm o arquivo da NF-e no foi localizado no servidor!'.
															'<BR><BR>'.
															'Faa o reenvio da NF-e e, caso o problema persista, '.
															'entre em contato com a Freeline!','');
								}else{
									nfe_exibe_erro('FRE-113-B','Rejeio do Arquivo da NF-e "'.$reg_nfe->NFe_Chave.'" pela SEFAZ!'.
													'"'.$status.'" - '.$motivo.'<BR><BR>'.
													'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
								}
								return false;
							}
							
						}else if($status == '204'){
							//fecha arquivo da consulta
							set_time_limit(60);
							//copia para a pasta de erros
							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',true);
							//exibe mensagem na tela sobre a denegao de uso
							nfe_exibe_erro('FRE-014','Falha no processamento do Lote da NF-e!'.
													'"'.$status.'" - '.$motivo.'<BR><BR>'.
													'Faa o reenvio da nota fiscal para concluir o processamento!','');
							$upd_nota = 'UPDATE nota_fiscal SET '.
										' NFe_Recibo = "", '.
										' NFe_Protocolo = "" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
										' AND Nr_Nota = "'.$nr_nota.'"'.
										' AND Situacao = "I"';
							consulta_sql($upd_nota, true, 1);
							set_time_limit(60);
							return false;
						}else if($status == '704'){
							
							//DH NFC-e
							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',true);
							nfe_exibe_erro('FRE-015','Rejeio do Arquivo da NF-e pela SEFAZ!'.
													'"'.$status.'" - '.$motivo.'<BR><BR>'.
													'Data/Hora da nota atualizados! Faa o envio novamente!',$nr_nota);
							//funo retorna false (no fez a nota corretamente)

							$upd_nota = 'UPDATE nota_fiscal SET '.
										' NFe_Chave = "", '.
										' DH_Emissao = now(), '.
										' DH_EntSai = now(), '.
										' DH_SaidaNota = now() '.										
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
										' AND Nr_Nota = "'.$nr_nota.'"';
							consulta_sql($upd_nota, true, 1);						

							return false;							
						}else{
							//outro tipo de rejeio							

							nfe_copia_arquivo('retorno','erros/'.$ano_mes,$reg_nfe->NFe_Recibo.'-pro-rec.xml','',true);
							nfe_exibe_erro('FRE-015','Rejeio do Arquivo da NF-e pela SEFAZ!'.
														'"'.$status.'" - '.$motivo.'<BR><BR>'.
														'Corrija os dados desta nota e faa o envio novamente!',$nr_nota);
							//funo retorna false (no fez a nota corretamente)
							return false;
						}
					}else{
						$conteudo_arquivo = nfe_abre_arquivo_err($reg_nfe->NFe_Recibo.'-pro-rec.xml');
						nfe_exibe_erro('FRE-012','Rejeio do Arquivo da NF-e pela SEFAZ!'.
												'"'.$status.'" - '.$motivo.'<BR><BR>'.
												'Corrija os dados desta nota e faa o envio novamente!'.
												$conteudo_arquivo,$nr_nota);
						return false;
					}
				}
			}else{
				usleep(200000);
			}
		}
	}

	function nfe_processa_fase6($nr_nota,$ok){
		//fecha a nota
		set_time_limit(60);
		nfe_exibe_processamento('5');
		if($ok){
			$status_nf = 'F';
			$desc_nfe = 'Autorizada';
		}else{
			//apenas muda o status (NF-e Denegada)
			$status_nf = 'C';
			$desc_nfe = 'Denegada';
		}
		$perguntar_quitar = BuscaParam('NF-QUITAR-AVISTA');
		//echo $perguntar_quitar.'-';
		if($perguntar_quitar != 'N'){
			$con_parcelas = 'SELECT * FROM nota_fiscal_parcela '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota = "'.$nr_nota.'"'.
							' AND DT_Vencimento <= "'.data_atual('date').'"'.
							' AND Parcela > 0';
			$res_parcelas = consulta_sql($con_parcelas);
			$nrw_parcelas = consulta_num_registros($res_parcelas);
			consulta_limpa($res_parcelas);
			if($nrw_parcelas == 0){
				$perguntar_quitar = 'N';
			}
		}
		//echo $perguntar_quitar.'-';
		$upd_nota = 'UPDATE nota_fiscal SET'.
					' Situacao = "'.$status_nf.'", '.
					' UsuarioVenda = "'.base64_decode_si($_REQUEST['USER_ID']).'"'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"'.
					' AND Situacao = "I"';
		$res_nota = consulta_sql($upd_nota, true, 1);
		set_time_limit(60);
		if(($res_nota == 1) && ($ok)){
			gera_mov_saida($_SESSION["Empresa_Codigo"], $nr_nota, 'F');
			nota_fiscal_mov_estoque($nr_nota, 'F');
			nota_fiscal_gera_contas($nr_nota);
			nota_fiscal_estoque_reserva($nr_nota, 'F');
			gera_estoque_romaneio($_SESSION["Empresa_Codigo"], $nr_nota, 'F');
			nota_fiscal_associa_dav($nr_nota);
			devolucao_pedido($nr_nota, '-');
			nota_fiscal_gera_pedido_devolucao($nr_nota);
			$con_nota = 'SELECT * FROM nota_fiscal '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Nota = "'.$nr_nota.'"';
			$res_nota = consulta_sql($con_nota);
			$reg_nota = consulta_ler_objeto($res_nota);
			consulta_limpa($res_nota);
			veiculo_nota_saida($_SESSION["Empresa_Codigo"], $nr_nota, $reg_nota->Transportadora,
			$reg_nota->Veiculo, $reg_nota->Vendedor, $reg_nota->Veiculo_KMSaida,
			$reg_nota->DH_EntSai,$reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo, 'inc');
			if(($reg_nota->Modelo == '65') || ($perguntar_quitar == 'S')){
				//consulta as parcelas a vista
				$data_baixa = data_atual('date');
				//consulta valor de parcelas caso tenha alguma
				$con_parcelas = 'SELECT * FROM nota_fiscal_parcela '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
								' AND Nr_Nota = "'.$nr_nota.'"'.
								' AND DT_Vencimento <= "'.data_atual('date').'" '. //parcela zero(parte a vista do cupom no vai gerar nada)
								' AND Parcela > 0 '. //parcela zero(parte a vista do cupom no vai gerar nada)
								' ORDER BY Parcela';
				$res_parcelas = consulta_sql($con_parcelas);
				$nrw_parcelas = consulta_num_registros($res_parcelas);
				for($p=0;$p<$nrw_parcelas;$p++){
					$reg_parcelas = consulta_ler_objeto($res_parcelas);
					//cria cada parcela conforme cada vencto
					//echo $reg_parcelas->Nr_Contas.'-';
					$con_contasS =  'select Situacao from contas_pr '.
									' where Dominio="'.$_SESSION['Dominio'].'"'.
									' and Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
									' and Nr_Contas="'.$reg_parcelas->Nr_Contas.'"'.
									' and Seq="1"';
					$res_contasS = consulta_sql($con_contasS);
					$reg_contasS = consulta_ler_objeto($res_contasS);
					consulta_limpa($res_contasS);
					if ($reg_contasS->Situacao=='A'){
						financeiro_baixa_conta($_SESSION['Empresa_Codigo'], $reg_parcelas->Nr_Contas, 1, //chave da tabela
												$_SESSION['Empresa_Codigo'], $data_baixa, $data_baixa, //empresa e data do caixa
												0, 0, $reg_parcelas->Valor_Parcela, //descontos e acrescimos (o valor totla  o valor com o valor do acerscimo e do esconto automtico)
												0, 'S', //jusros usado na baixa
												0, 0, //pontualizade e prodtesto
												0, '', 0, 0, '', //dados do meio de pagamaneto
												'', '','',//$obs_caixa,
												'', 0, true);
						$upd_forma= 'UPDATE contas_pr set'.  //fechamento automatico  em dinheiro
									' Finalizadora = "1"'.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
									' and Nr_Contas = "'.$reg_parcelas->Nr_Contas.'"'.
									' and Seq = "1"'.
									' and Situacao = "A"';
						consulta_sql($upd_forma);
					}
				}
				consulta_limpa($res_parcelas);
			}
			//<CRM>

			nota_fiscal_atualiza_data_ultima_venda( $reg_nota->DH_EntSai , $reg_nota->Destinatario,  $reg_nota->Vendedor , $reg_nota->Modelo, $reg_nota->Nat_Op_Gera_Contas,  $reg_nota->Empresa , $nr_nota );
			/*
			Funao Original , transferido para nota_fiscal.php em 25/01/2024
			if(($reg_nota->Modelo == '55') && ($reg_nota->Nat_Op_Gera_Contas == 'R')){
				$prefixo = 't_';
				for($t=0;$t<2;$t++){
					$upt_cli = 'UPDATE '.$prefixo.'pessoa_cliente SET '.
								' DH_Ultima_Venda = "'.$reg_nota->DH_EntSai.'" ' .
								' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
								' AND Pessoa = "'.$reg_nota->Destinatario.'" ';
					$res_cli = consulta_sql($upt_cli, true, 1);
					
					// if($res_cli > 0){
					// $upt_pes = 'UPDATE '.$prefixo.'pessoa SET '.
					// ' DataHora_Alteracao = now() '.
					// ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					// ' AND Pessoa = "'.$reg_nota->Destinatario.'" ';
					// consulta_sql($upt_pes);
					// } 
					
					$prefixo = '';
				}
				$ticket_medio = BuscaParam('TICKET_MEDIO_NF');
				if($ticket_medio == 'S'){
					ticket_medio_cliente($reg_nota->Destinatario, true);
				}
				$crm_calcula_faturamento = BuscaParam('CRM_CALC_FATURA_VEND');
				if($crm_calcula_faturamento == 'S'){
					$ano = substr($reg_nota->DH_EntSai, 0, 4);
					$mes = substr($reg_nota->DH_EntSai, 5, 2);
					calcula_faturamento_mensal_vendedor($reg_nota->Vendedor, $ano, $mes);
				}
			}
			*/
			//</CRM>
			//nota_fiscal_emitida_confirmacao_compra.php

			/*
			if((($reg_nota->Modelo == '01') || ($reg_nota->Modelo == '55')) && ($reg_nota->Nat_Op_Gera_Contas == 'R')){
				$con_cli = 'SELECT Primeira_NF_Empresa, Primeira_NF_Nr FROM pessoa_cliente '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_nota->Destinatario.'"';
				$res_cli= consulta_sql($con_cli);
				$reg_cli = consulta_ler_objeto($res_cli);
				consulta_limpa($res_cli);
				if(($reg_cli->Primeira_NF_Empresa == 0) && ($reg_cli->Primeira_NF_Nr == 0)){
					$prefixo = 't_';
					for($t=0;$t<2;$t++){
						$upt_cli = 'UPDATE '.$prefixo.'pessoa_cliente SET '.
									' Primeira_NF_Empresa = "'.$reg_nota->Empresa.'", ' .
									' Primeira_NF_Nr = "'.$nr_nota.'" ' .
									' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
									' AND Pessoa = "'.$reg_nota->Destinatario.'" ';
						$res_cli = consulta_sql($upt_cli);
						$prefixo = '';
					}
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' Primeira_NF_Dest = "S" '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota = "'.$nr_nota.'"';
					$res_nota = consulta_sql($upd_nota);
				}
			}
			*/
		}else if($res_nota == 1){
			//volta saldo como se estivesse inutilizando
			nota_fiscal_cancela($nr_nota, 'D');
		}
		nfe_exibe_processamento('6',$desc_nfe);
		return $ok;
	}

	function nfe_cancela($nr_nota,$op){
		$con_nfe = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"';
		$res_nfe = consulta_sql($con_nfe);
		$reg_nfe = consulta_ler_objeto($res_nfe);
		consulta_limpa($res_nfe);
		if($reg_nfe->NFe_Chave == ''){
			nota_fiscal_valida_persistencia($nr_nota);
			nfe_gera_chave($reg_nfe);
		}
		if($op == 'C'){
			$nf_e = nfe_gera_arquivo_cancela($nr_nota);
		}else{
			$nf_e = nfe_gera_arquivo_inutiliza($nr_nota);
		}
		return $nf_e;
	}
	
?>