<?
	require_once(dirname(__FILE__).'/nfe_funcoes.php');
	require_once(dirname(__FILE__).'/nfse_funcoes.php');

	function nota_fiscal_gera_arquivo_nf_servico($filt_serie,$operacao="I"){
		$cabecalho='';		

		$nr_lote = 0;
		$nr_nota = 0;
		$lista_desc = '';
		$total_iss = 0;
		$total_irrf = 0;
		$total_pis = 0;
		$total_cofins = 0;
		$total_csll = 0;
		$total_inss = 0;
		if ($operacao=='I'){
			$con_nota = 'SELECT * FROM nota_fiscal '.
						' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
						' AND ((Situacao="F") OR (Situacao="C"))'.
						' AND Modelo="'.base64_decode($filt_serie).'"'.
						// ' AND Total_Servicos>0'.
						' AND EmissaoPT="P"'.
						' AND NFSe_Lote=""'.
						' ORDER BY Nr_Nota';
		}else{
			$con_serie= 'SELECT Layout_Impressao FROM nota_fiscal_serie '.
						' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Modelo="'.base64_decode_si($filt_serie).'"';
			$res_serie = consulta_sql($con_serie);
			$reg_serie = consulta_ler_linha($res_serie);
			consulta_limpa($res_serie);

			if((($reg_serie[0]=='5')||($reg_serie[0]=='6'))){
				$con_nota = 'SELECT * FROM nota_fiscal '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Situacao="CC" '.
							' AND Modelo="'.base64_decode($filt_serie).'"'.
							' AND Total_Servicos>0'.
							' AND EmissaoPT="P" '.
							' AND NFSe_Lote_C=""'.
							' ORDER BY Nr_Nota';
			}else{
				$con_nota = 'SELECT * FROM nota_fiscal '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Situacao="C" '.
							' AND Modelo="'.base64_decode($filt_serie).'"'.
							' AND Total_Servicos>0'.
							' AND EmissaoPT="P" '.
							' AND NFSe_Lote_C=""'.
							' ORDER BY Nr_Nota';
			}
			// $con_nota = 'SELECT * FROM nota_fiscal '.
			// ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
			// ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
			// ' AND Modelo="'.base64_decode_si($filt_serie).'"'.
			// ' AND Situacao="F" '.
			// ' AND Total_Servicos>0'.
			// ' AND EmissaoPT="P" '.
			// ' AND NFSe_Lote_C=""'.
			// ' ORDER BY Nr_Nota';
			}
			$res_nota = consulta_sql($con_nota);
			$nro_nota = consulta_num_registros($res_nota);
			if($nro_nota>0){
				$con_serie= 'SELECT'.
							' max(NFSe_Lote),'.
							' Layout_Impressao'.
							' FROM nota_fiscal_serie '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_serie = consulta_sql($con_serie);
				$reg_serie = consulta_ler_linha($res_serie);
				consulta_limpa($res_serie);

				$nr_lote = ($reg_serie[0]+1);

				$upd_nota_serie='UPDATE nota_fiscal_serie SET'.
								' NFSe_Lote="'.$nr_lote.'" '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
								' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_nota_serie = consulta_sql($upd_nota_serie,true,1);

				if($reg_serie[1]=='4'){ //NFS-e So Paulo
					
					$retorno = array();
					$cabecalho = '';
					$conteudo1 = '';
					$conteudo2 = '';
					$conteudo3 = '';
					$registro_detalhe = '';
					$rodape = '';
					$arquivo_montado = '';
					$num_detalhe = 0;
					$data_ini = '';
					$data_fim = '';
					$vl_total_serv = 0;
					$vl_total_desc = 0;

					for($n=0;$n<$nro_nota;$n++){
						$reg_nota = consulta_ler_objeto($res_nota);
						$nr_nota = $reg_nota->Nr_Nota;
						if($n==0){
							$data_ini = $reg_nota->DH_Emissao;
						}
						$data_fim = $reg_nota->DH_Emissao;
						if($operacao=="I"){
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote=""';
						}else{
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote_C="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_C_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote_C=""';
						}

						$res_upd = consulta_sql($upd_nota,true,1);
						//$res_upd = 1;
						if($res_upd==1){
							$vl_total_serv+= $reg_nota->Total_Servicos;
							$vl_total_desc+= $reg_nota->Total_Desconto;

							if($reg_nota->Modelo!='98'){
								$tipo_rps = 'RPS-M'; //1 - Recibo; 2 - Nota fiscal conjugada mista
							}else{
								$tipo_rps = 'RPS';
							}
							/* Situacao RPS
							T - Operao normal (tributao conforme documento emitido)
							I - Operao isenta ou no tributvel, executadas no Municpio de So Paulo
							F  Operao isenta ou no tributvel pelo Municpio de So Paulo, executada em outro Municpio
							C - Cancelado
							E  Extraviado
							J  ISS Suspenso por Deciso Judicial (neste caso, informar no campo Discriminao dos Servios, o nmero do processo judicial na 1 instncia).
							*/

							//consulta itens da NF
							$con_itens= 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item';
							$res_itens = consulta_sql($con_itens);
							$nrw_itens = consulta_num_registros($res_itens);
							//para cada item da nota
							$lista_desc = '';
							$cidade = $reg_nota->Cidade_FG;
							$iss_aliq = 0;
							$total_iss = 0;
							$total_irrf = 0;
							$total_inss = 0;
							$total_pis = 0;
							$total_cofins = 0;
							$total_csll = 0;

							for($itens=0;$itens<$nrw_itens;$itens++){
								$reg_itens = consulta_ler_objeto($res_itens);
								if($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
								if ($reg_itens->ISS_Cidade_FG!=''){
									$cidade = $reg_itens->ISS_Cidade_FG;
								}
								$iss_aliq  = $reg_itens->ISS_Aliquota;
								if ($reg_itens->ISS_CST!='I'){
									$total_iss+= $reg_itens->ISS_BC;
								}
								$total_irrf += $reg_itens->IRRF_Valor;
								$total_inss += $reg_itens->PrevSocial_Valor;
								$total_pis += $reg_itens-> PIS_Valor;
								$total_cofins += $reg_itens->COFINS_Valor;
								$total_csll += $reg_itens->CSLL_Valor;


								$con_obs =  'SELECT * FROM nota_fiscal_obs'.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
											' GROUP BY Texto_Completo'.
											' ORDER BY Seq_Obs';
								$res_obs = consulta_sql($con_obs);
								$nrw_obs = consulta_num_registros($res_obs);
								for($obss=0;$obss<$nrw_obs;$obss++){
								$reg_obs = consulta_ler_objeto($res_obs);
								if($lista_desc!=''){
								$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
								}
								consulta_limpa($res_obs);
							}

							$con_obs =  'SELECT * FROM nota_fiscal_obs'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Seq_Item=0'.
										' AND Seq_Obs>3 '.
										' GROUP BY Texto_Completo'.
										' ORDER BY Seq_Obs';
							$res_obs = consulta_sql($con_obs);
							$nrw_obs = consulta_num_registros($res_obs);
							for($obss=0;$obss<$nrw_obs;$obss++){
								$reg_obs = consulta_ler_objeto($res_obs);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
							}
							consulta_limpa($res_obs);

							$cons_parc= 'SELECT * FROM nota_fiscal_parcela'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' ORDER BY Parcela';
							$res_parc = consulta_sql($cons_parc);
							$nrw_parc = consulta_num_registros($res_parc);
							if($nrw_parc>0){
								$lista_desc.= ';VENCIMENTOS:';
								for($p=0;$p<$nrw_parc;$p++){
									$reg_parc = consulta_ler_objeto($res_parc);
									if ($lista_desc!=''){
										$lista_desc.=';';
									}
									$lista_desc.=nfe_formata_txt(dataf($reg_parc->DT_Vencimento));
								}
							}
							consulta_limpa($res_parc);

							//trim(substr($lista_desc,0,8000))
							$lista_desc = str_replace(';','|',$lista_desc);

							//consulta empresa cnpj nome
							$con_empresa =  'SELECT'.
											' CPF_CNPJ,'.
											' Nome_Razao'.
											' FROM pessoa '.
											' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
											' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
							$res_empresa = consulta_sql($con_empresa);
							$reg_empresa = consulta_ler_linha($res_empresa);
							consulta_limpa($res_empresa);

							$con_end_emp =  'SELECT'.
											' Insc_Municipal,'.
											' CEP,'.
											' Logradouro,'.
											' Numero,'.
											' Bairro,'.
											' Complemento,'.
											' UF,'.
											' Codigo_Cidade,'.
											' Nome_Cidade'.
											' FROM pessoa_endereco '.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Pessoa="'.$reg_nota->Empresa.'"'.
											' AND Seq_Endereco="'.$reg_nota->Empresa_Endereco.'"';
							$res_end_emp = consulta_sql($con_end_emp);
							$reg_end_emp = consulta_ler_linha($res_end_emp);
							consulta_limpa($res_end_emp);

							//consulta Tomador
							$con_tom =  'SELECT'.
										' CPF_CNPJ,'.
										' Nome_Razao,'.
										' EMail,'.
										' Tipo_Cad_Pessoa'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_tom = consulta_sql($con_tom);
							$reg_tom = consulta_ler_linha($res_tom);
							consulta_limpa($res_tom);

							if(strlen(limpa_numero($reg_tom[0]))==11){
								if(limpa_numero($reg_tom[0])=='00000000000'){
									$tipo_tomador = '3';
								}else{
									$tipo_tomador = '1';
								}
							}else if(strlen(limpa_numero($reg_tom[0]))==14){
								$tipo_tomador = '2';
							}

							if($tipo_tomador=='3'){
								$cpf_cnpj_tom = '00000000000';
							}else{
								$cpf_cnpj_tom = limpa_numero($reg_tom[0]);
							}

							$con_end_tom =  'SELECT'.
											' Insc_Municipal,'.
											' CEP,'.
											' Logradouro,'.
											' Numero,'.
											' Bairro,'.
											' Complemento, '.
											' UF,'.
											' Codigo_Cidade,'.
											' Nome_Cidade,'.
											' Insc_Estadual'.
											' FROM pessoa_endereco '.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Pessoa="'.$reg_nota->Destinatario.'"'.
											' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
							$res_end_tom = consulta_sql($con_end_tom);
							$reg_end_tom = consulta_ler_linha($res_end_tom);
							consulta_limpa($res_end_tom);

							$con_cidade='SELECT Nome FROM cidade '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'" '.
										' AND Codigo_Cidade="'.$reg_end_tom[7].'" ';
							$res_cidade = consulta_sql($con_cidade);
							$reg_cidade = consulta_ler_linha($res_cidade);
							consulta_limpa($res_cidade);

							if($reg_end_tom[7]=='3550308'){ //sao paulo
								$insc_munic_tom = preenche_texto(limpa_numero($reg_end_tom[0]),8);
							}else{
								$insc_munic_tom = '00000000';
							}

							if($reg_itens->ISS_CST=='R'){
								$iss_retido = '1';
							}else {
								$iss_retido = '2';
							}

							if($reg_nota->Situacao=='F'){
								if(($reg_itens->ISS_CST=='N')||($reg_itens->ISS_CST=='S')||($reg_itens->ISS_CST=='R')){
									$sit_rps = 'T';
								}else if($reg_itens->ISS_CST=='I'){
									if($reg_itens->ISS_Cidade_FG!=''){
										if($reg_itens->ISS_Cidade_FG != $reg_end_emp[7]){
											$sit_rps = 'F';
										}else{
											$sit_rps = 'I';
										}
									}else{
										$sit_rps = 'I';
									}
								}else{
									$sit_rps = 'I';
								}
							}else if($reg_nota->Situacao=='C'){
								$sit_rps = 'C';
							}else if($reg_nota->Situacao=='E'){
								$sit_rps = 'E';
							}


							$con_serv = 'SELECT'.
										' Codigo_SP,'.
										' AliquotaISS'.
										' FROM tipo_servico '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Codigo_Servico="'.$reg_itens->Servico_Codigo.'"';
							$res_serv = consulta_sql($con_serv);
							$reg_serv = consulta_ler_linha($res_serv);
							consulta_limpa($res_serv);

							$cod_serv = $reg_serv[0];
							$aliq_iss = $reg_serv[1];


							$conteudo1= '2'.
										preenche_texto($tipo_rps,5).
										preenche_texto($reg_nota->Serie,5).
										fill_full($reg_nota->NrDoc,12).
										limpa_numero(datad(dataf($reg_nota->DH_Emissao))).
										$sit_rps.
										fill_full(round($reg_nota->Total_Servicos*100),15).
										fill_full(round($reg_nota->Total_Desconto*100),15).
										fill_full($cod_serv,5).
										fill_full(round($aliq_iss*100),4).
										$iss_retido.
										$tipo_tomador.
										fill_full($cpf_cnpj_tom,14).
										fill_full($insc_munic_tom,8).
										preenche_texto(fill_full(limpa_numero($reg_end_tom[9]),12),12).
										preenche_texto($reg_tom[1],75). //nomerazao
										preenche_texto('',3). //tipo end 3
										preenche_texto($reg_end_tom[2],50). //endereco 50
										preenche_texto($reg_end_tom[3],10). //numero end 10
										preenche_texto($reg_end_tom[5],30). //complemento 30
										preenche_texto($reg_end_tom[4],30). //bairro 30
										preenche_texto($reg_cidade[0],50). //cidade 50
										preenche_texto($reg_end_tom[6],2). //uf 2
										fill_full(substr(limpa_numero($reg_end_tom[1]),0,8),8). //cep 8
										preenche_texto($reg_tom[2],75). //email 75
										preenche_texto($lista_desc,1001). //email N (N<=1000)
										FIML;
							$num_detalhe++;

							//montar cabecalho por ultimo para pegar as datas inicio e fim do periodo do rps
							$cabecalho= '1'.
										'001'.
										limpa_numero($reg_end_emp[0]).
										limpa_numero(datad(dataf($data_ini))).//data inicial do periodo dos RPS
										limpa_numero(datad(dataf($data_fim))).//data final do periodo dos RPS
										FIML;

							$registro_detalhe.= $conteudo1.
												$conteudo2;

						}//fim update
					}//fim for

					$rodape = '9'.
								fill_full($num_detalhe,7).
								fill_full(round($vl_total_serv*100),15).
								fill_full(round($vl_total_desc*100),15).
								FIML;

					$arquivo_montado =  $cabecalho.
										$registro_detalhe.
										$rodape;

					$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/lote/";

					//finaliza arquivo na pasta tmp
					rmkdir($caminho);
					$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.txt";

					$retorno = '';
					$salvou = file_exists($caminho.$nome_arq);

					//echo 'File: '.$caminho.$nome_arq. 'SALVOU:'.$salvou;
					if(file_exists($caminho.$nome_arq)){
						unlink($caminho.$nome_arq);
					}

					$Handle = fopen($caminho.$nome_arq, 'w');
					fwrite($Handle, $arquivo_montado);
					fclose($Handle);

					if(file_exists($caminho.$nome_arq)){
						$salvou = true;
					}

					//echo 'Salvou: '.$salvou;
					//se consegui salvar
					if($salvou){
						$retorno = 1;
					}else{
						$retorno = -1;
					}

				}else if($reg_serie[1]=='5'){ //NFSe Curitiba
					//cria objeto xml
					$xml = new XML();

					$nf_inf = &$xml->createRoot("EnviarLoteRpsEnvio");
					$nf_inf->addAttribute('xmlns', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);
					$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
					$nf_inf->addAttribute('xsi:schemaLocation', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);


					//consulta empresa cnpj nome
					$con_empresa = 'SELECT'.
									' CPF_CNPJ,'.
									' Nome_Razao'.
									' FROM pessoa '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
					$res_empresa = consulta_sql($con_empresa);
					$reg_empresa = consulta_ler_linha($res_empresa);
					consulta_limpa($res_empresa);
					$cnpj = limpa_numero($reg_empresa[0]);

					$con_end_emp = 'SELECT'.
									' Insc_Municipal,'.
									' CEP,'.
									' Logradouro,'.
									' Numero,'.
									' Bairro,'.
									' Complemento,'.
									' UF,'.
									' Codigo_Cidade,'.
									' Nome_Cidade,'.
									' CNAE_Municipal'.
									' FROM pessoa_endereco '.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Situacao<>"E"'.
									' ORDER BY Seq_Endereco limit 1';
					$res_end_emp = consulta_sql($con_end_emp);
					$reg_end_emp = consulta_ler_linha($res_end_emp);
					consulta_limpa($res_end_emp);
					$insc_munic = limpa_numero($reg_end_emp[0]);

					$lote_rps = &$nf_inf->addChild("LoteRps");
					$lote_rps->addAttribute('id', $nr_lote, true);
					$lote_rps->addAttribute('NumeroLote', $nr_lote, false);
					$lote_rps->addAttribute('Cnpj', $cnpj, false);
					$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
					$lote_rps->addAttribute('QuantidadeRps', $nro_nota, false);

					$lista_rps = &$lote_rps->addChild("ListaRps");

					for($k=0;$k<$nro_nota;$k++){
						$reg_nota = consulta_ler_objeto($res_nota);
						$nr_nota = $reg_nota->Nr_Nota;
						if($operacao=="I"){
							$status = '1';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote=""';
						}else{
							$status = '2';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote_C="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_C_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote_C=""';
						}

						$res_upd = consulta_sql($upd_nota,true,1);
						//$res_upd = 1;
						if($res_upd==1){
							$rps = &$lista_rps->addChild("Rps");
							$rps->addAttribute('xmlns', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);

							$inf_rps = &$rps->addChild("InfRps");
							$inf_rps->addAttribute('id', $k+1, true);

							$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
							$ident_rps->addAttribute('Numero', $reg_nota->NrDoc, false);
							if($reg_nota->Serie!=''){
								$ident_rps->addAttribute('Serie', $reg_nota->Serie, false);
							}
							$ident_rps->addAttribute('Tipo', '1', false); //1 - RPS

							$data = str_replace(' ','T',$reg_nota->DH_Emissao);
							$inf_rps->addAttribute('DataEmissao', $data, false);

							$con_item = 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item LIMIT 1';
							$res_item = consulta_sql($con_item);
							$reg_item = consulta_ler_objeto($res_item);
							//if($reg_nota->Situacao=='F'){
							if($reg_item->ISS_CST=='I'){
								$sit_rps = '3';
							}else if(($reg_item->ISS_CST=='N')||($reg_item->ISS_CST=='S')||($reg_item->ISS_CST=='R')){
								if($reg_item->ISS_Cidade_FG!=''){
									if($reg_item->ISS_Cidade_FG != $reg_end_emp[7]){
										$sit_rps = '2';
									}else{
										$sit_rps = '1';
									}
								}else{
									$sit_rps = '1';
								}
							}
							//}
							consulta_limpa($res_item);

							$inf_rps->addAttribute('NaturezaOperacao', $sit_rps, false);

							$con_pessoa='SELECT'.
										' CPF_CNPJ,'.
										' Opt_Simples'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_pessoa = consulta_sql($con_pessoa);
							$reg_pessoa = consulta_ler_objeto($res_pessoa);
							consulta_limpa($res_pessoa);
							if($reg_pessoa->Opt_Simples=='S'){
								$opt_simples = '1';
							}else{
								$opt_simples = '2';
							}

							//$inf_rps->addAttribute('RegimeEspecialTributacao', '0', false);
							$inf_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
							$inf_rps->addAttribute('IncentivadorCultural', '2', false);
							$inf_rps->addAttribute('Status', $status, false);

							$total_outros = 0;

							$con_itens= 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item';
							$res_itens = consulta_sql($con_itens);
							$nrw_itens = consulta_num_registros($res_itens);
							//para cada item da nota
							$lista_desc = '';
							$cidade = $reg_nota->Cidade_FG;
							$iss_aliq = 0;
							$iss_bc = 0;
							$total_iss = 0;
							$total_irrf = 0;
							$total_inss = 0;
							$total_pis = 0;
							$total_cofins = 0;
							$total_csll = 0;
							$total_retido = 0;

							for($itens=0;$itens<$nrw_itens;$itens++){
								$reg_itens = consulta_ler_objeto($res_itens);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
								if ($reg_itens->ISS_Cidade_FG!=''){
									$cidade = $reg_itens->ISS_Cidade_FG;
								}
								$iss_aliq = $reg_itens->ISS_Aliquota;
								if ($reg_itens->ISS_CST!='I'){
									$total_iss+= $reg_itens->ISS_BC;
								}
								$total_irrf+= $reg_itens->IRRF_Valor;
								$total_inss+= $reg_itens->PrevSocial_Valor;
								$total_pis+= $reg_itens-> PIS_Valor;
								$total_cofins+= $reg_itens->COFINS_Valor;
								$total_csll+= $reg_itens->CSLL_Valor;

								if($reg_itens->ISS_CST=='R'){
									$total_retido+= $reg_itens->ISS_Valor;
								}
							}

							$lista_desc = str_replace(";","\r\n",$lista_desc);
							$inf_serv = &$inf_rps->addChild('Servico');
							$inf_valores = &$inf_serv->addChild('Valores');
							$inf_valores->addAttribute('ValorServicos', nfe_numero($reg_nota->Total_Servicos,2), false);
							//if($reg_nota->Total_Desconto>0){
							$inf_valores->addAttribute('ValorDeducoes', nfe_numero(0,2), false);
							//}
							//if($total_pis>0){
							$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
							//}
							//if($total_cofins>0){
							$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
							//}
							//if($total_inss>0){
							$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
							//}
							//if($total_irrf>0){
							$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
							//}
							//if($total_csll>0){
							$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
							//}

							if($reg_itens->ISS_CST=='R'){
								$inf_valores->addAttribute('IssRetido', '1', false);
							}else {
								$inf_valores->addAttribute('IssRetido', '2', false);
							}

							$vl_iss = nfe_numero(arredonda_numero_menos($total_iss * $iss_aliq)/100,2);
							//if($vl_iss>0){
							$inf_valores->addAttribute('ValorIss', $vl_iss, false);
							//}
							//if($total_retido>0){
							$inf_valores->addAttribute('ValorIssRetido', nfe_numero($total_retido,2), false);
							//}
							//if($total_outros>0){
							$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
							//}
							$inf_valores->addAttribute('BaseCalculo', nfe_numero($total_iss,2), false);
							$inf_valores->addAttribute('Aliquota', nfe_numero(($iss_aliq/100),2), false);

							$vl_liquido = ($reg_nota->Total_NF-
											$total_pis-
											$total_cofins-
											$total_inss-
											$total_irrf-
											$total_csll-
											$total_outros-
											$total_retido);

							$inf_valores->addAttribute('ValorLiquidoNfse', nfe_numero($vl_liquido,2), false);
							$inf_valores->addAttribute('DescontoIncondicionado', nfe_numero(0,2), false);
							$inf_valores->addAttribute('DescontoCondicionado', nfe_numero(0,2), false);

							$inf_serv->addAttribute('ItemListaServico', $reg_itens->Servico_Codigo, false);

							if($reg_itens->Servico_Codigo!=''){
								$con_desc = 'SELECT Codigo_CNAE FROM tipo_servico '.
											' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
											' AND Codigo_Servico="'.$reg_itens->Servico_Codigo.'"';
								$res_desc = consulta_sql($con_desc);
								$reg_desc = consulta_ler_linha($res_desc);
								consulta_limpa($res_desc);

								$inf_serv->addAttribute('CodigoCnae', limpa_numero($reg_desc[0]), false);
							}
							$inf_serv->addAttribute('Discriminacao', trim(substr($lista_desc,0,2000)), false);
							$inf_serv->addAttribute('CodigoMunicipio', $cidade, false);


							$con_end_emp =  'SELECT Insc_Municipal FROM pessoa_endereco '.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Pessoa="'.$reg_nota->Empresa.'"'.
											' AND Seq_Endereco="'.$reg_nota->Empresa_Endereco.'"';
							$res_end_emp = consulta_sql($con_end_emp);
							$reg_end_emp = consulta_ler_linha($res_end_emp);
							consulta_limpa($res_end_emp);

							$inf_prest = &$inf_rps->addChild('Prestador');
							$inf_prest->addAttribute('Cnpj', limpa_numero($reg_empresa[0]), false);

							$prest_im = limpa_numero($reg_end_emp[0]);
							if($prest_im!=''){
								$inf_prest->addAttribute('InscricaoMunicipal', $prest_im, false);
							}
							$con_tom =  'SELECT'.
										' CPF_CNPJ,'.
										' Nome_Razao,'.
										' EMail'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_tom = consulta_sql($con_tom);
							$reg_tom = consulta_ler_linha($res_tom);
							consulta_limpa($res_tom);

							$inf_tom = &$inf_rps->addChild('Tomador');
							if($reg_tom[0]!=''){
								$inf_idtom = &$inf_tom->addChild('IdentificacaoTomador');
								$inf_cpftom = &$inf_idtom->addChild('CpfCnpj');
								if(strlen(limpa_numero($reg_tom[0]))==11){
									$inf_cpftom->addAttribute('Cpf', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}else if(strlen(limpa_numero($reg_tom[0]))==14){
									$inf_cpftom->addAttribute('Cnpj', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}

								$con_im_tom = 'SELECT'.
												' Insc_Municipal,'.
												' Codigo_Cidade'.
												' FROM pessoa_endereco '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
								$res_im_tom = consulta_sql($con_im_tom);
								$reg_im_tom = consulta_ler_linha($res_im_tom);
								consulta_limpa($res_im_tom);
								if($reg_im_tom[1]=='4106902'){
									$tom_im = limpa_numero($reg_im_tom[0]);
									if($tom_im!=''){
										$inf_idtom->addAttribute('InscricaoMunicipal', $tom_im, false);
									}
								}
							}
							$inf_tom->addAttribute('RazaoSocial', substr(trim(UpperDados($nome_tomador)),0,115), false);
							if($informa_end){
								$con_end_tom =  'SELECT'.
												' Insc_Municipal,'.
												' CEP,'.
												' Logradouro,'.
												' Numero,'.
												' Bairro,'.
												' Complemento, '.
												' UF,'.
												' Codigo_Cidade,'.
												' Nome_Cidade,'.
												' Insc_Estadual'.
												' FROM pessoa_endereco '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
								$res_end_tom = consulta_sql($con_end_tom);
								$reg_end_tom = consulta_ler_linha($res_end_tom);
								consulta_limpa($res_end_tom);
								$inf_end_tom = &$inf_tom->addChild('Endereco');
								$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,125);
								if($end_endereco!=''){
									$inf_end_tom->addAttribute('Endereco', $end_endereco, false);
								}
								$end_num = substr(limpa_numero($reg_end_tom[3]),0,10);
								if($end_num!=''){
									$inf_end_tom->addAttribute('Numero', $end_num, false);
								}
								$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,60);
								if($end_comp!=''){
									$inf_end_tom->addAttribute('Complemento', $end_comp, false);
								}
								$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,60);
								if($end_bairro!=''){
									$inf_end_tom->addAttribute('Bairro', $end_bairro, false);
								}
								$end_munic = substr(limpa_numero($reg_end_tom[7]),0,7);
								if($end_munic!=''){
									$inf_end_tom->addAttribute('CodigoMunicipio', $end_munic, false);
								}
								$end_uf = substr(trim(UpperDados($reg_end_tom[6])),0,2);
								if($end_uf!=''){
									$inf_end_tom->addAttribute('Uf', $end_uf, false);
								}
								$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
								if($end_cep!=''){
									$inf_end_tom->addAttribute('Cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);
								}
							}

							$tem_contato = false;
							$tel_tomador = '';
							if($reg_nota->Dest_Telefone>0){
								$con_tom_tel = 'SELECT Numero_Telefone FROM pessoa_telefone '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
												' AND Situacao<>"E" ';
								$res_tom_tel = consulta_sql($con_tom_tel);
								$reg_tom_tel = consulta_ler_linha($res_tom_tel);
								consulta_limpa($res_tom_tel);

								$tel_tomador = $reg_tom_tel[0];
								$tem_contato = true;
							}

							if($tem_contato){
								$inf_cont_tom = &$inf_tom->addChild('Contato');
								if($tel_tomador!=''){
									$inf_cont_tom->addAttribute('Telefone', substr(limpa_numero($tel_tomador),0,11), false);
								}
								if($reg_tom[2]!=''){
									$inf_cont_tom->addAttribute('Email', substr(trim($reg_tom[2]),0,80), false);
								}
							}
						}//fim if update
					}//fim for
					$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/lote/";

					//finaliza arquivo na pasta tmp
					rmkdir($caminho);
					$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.xml";
					//echo $caminho.'<BR>'.$nr_lote.'<BR>-'.$nome_arq.'-';

					$xml->toFile($caminho, $nome_arq);
					$retorno = '';
					$salvou = file_exists($caminho.$nome_arq);
					$texto_final = '';
					$array_of_list_values = file($caminho.$nome_arq);

					foreach ($array_of_list_values as $list_value){
						$list_value = str_replace('&apos;','&apos', $list_value);
						$list_value = str_replace('&lt;','&lt', $list_value);
						$list_value = str_replace('&gt;','&gt', $list_value);
						$list_value = str_replace('&quot;','&quot', $list_value);
						$list_value = str_replace('&amp;','&amp', $list_value);


						$list_value = str_replace(';',FIML, $list_value);
						$list_value = str_replace('&apos','&apos;', $list_value);
						$list_value = str_replace('&lt','&lt;', $list_value);
						$list_value = str_replace('&gt','&gt;', $list_value);
						$list_value = str_replace('&quot','&quot;', $list_value);
						$list_value = str_replace('&amp','&amp;', $list_value);

						$texto_final.=$list_value;
					}

					if (file_exists($caminho.$nome_arq)){
						unlink($caminho.$nome_arq);
					}

					$Handle = fopen($caminho.$nome_arq, 'w');
					fwrite($Handle, $texto_final);
					fclose($Handle);

					//se consegui salvar
					if ($salvou){
						$retorno = 1;
					}else{
						$retorno = -1;
					}


				}else if($reg_serie[1]=='6'){ //NFSe Araucaria
					for($n=0;$n<$nro_nota;$n++){
						$reg_nota = consulta_ler_objeto($res_nota);
						//var_dump2($reg_nota);
						nota_fiscal_gera_arquivo_nf_servico_envio_araucaria($filt_serie,$reg_nota,"I");
						$retorno = 1;
					}
				}else if($reg_serie[1]=='15'){ //NFSe Itanhaem
					//cria objeto xml
					$xml = new XML();

					$nf_inf = &$xml->createRoot("EnviarLoteRpsEnvio");
					//$nf_inf->addAttribute('xmlns', 'http://www.abrasf.org.br/ABRASF/arquivos/nfse.xsd', true);
					$nf_inf->addAttribute('xmlns', 'http://www.abrasf.org.br/nfse.xsd', true);
					//$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
					//$nf_inf->addAttribute('xsi:schemaLocation', 'http://www.abrasf.org.br/ABRASF/arquivos/nfse.xsd', true);

					//consulta empresa cnpj nome
					$con_empresa =  'SELECT'.
									' CPF_CNPJ,'.
									' Nome_Razao'.
									' FROM pessoa '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
					$res_empresa = consulta_sql($con_empresa);
					$reg_empresa = consulta_ler_linha($res_empresa);
					consulta_limpa($res_empresa);
					$cnpj = limpa_numero($reg_empresa[0]);

					$con_end_emp =  'SELECT'.
									' Insc_Municipal,'.
									' CEP,'.
									' Logradouro,'.
									' Numero,'.
									' Bairro,'.
									' Complemento,'.
									' UF,'.
									' Codigo_Cidade,'.
									' Nome_Cidade,'.
									' CNAE_Municipal'.
									' FROM pessoa_endereco '.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Situacao<>"E"'.
									' ORDER BY Seq_Endereco limit 1';
					$res_end_emp = consulta_sql($con_end_emp);
					$reg_end_emp = consulta_ler_linha($res_end_emp);
					consulta_limpa($res_end_emp);
					$insc_munic = $reg_end_emp[0];
					$cnae_munic = $reg_end_emp[9];

					$lote_rps = &$nf_inf->addChild("LoteRps");
					$lote_rps->addAttribute('Id', $nr_lote, true);
					$lote_rps->addAttribute('NumeroLote', $nr_lote, false);
					$lote_rps->addAttribute('Cnpj', $cnpj, false);
					$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
					$lote_rps->addAttribute('QuantidadeRps', $nro_nota, false);

					$lista_rps = &$lote_rps->addChild("ListaRps");
					$lista_nfs = '';
					for($k=0;$k<$nro_nota;$k++){
						$reg_nota = consulta_ler_objeto($res_nota);

						$nr_nota = $reg_nota->Nr_Nota;
						if($lista_nfs!=''){
							$lista_nfs.= ';';
						}
						$lista_nfs.= $nr_nota;

						if($operacao=="I"){
							$status = '1';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote=""';
						}else{
							$status = '2';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote_C="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_C_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote_C=""';
						}

						$res_upd = consulta_sql($upd_nota,true,1);
						//$res_upd = 1;
						if($res_upd==1){
							$rps = &$lista_rps->addChild("Rps");

							$inf_rps = &$rps->addChild("InfRps");

							$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
							$ident_rps->addAttribute('Numero', $reg_nota->NrDoc, false);
							$ident_rps->addAttribute('Serie', $reg_nota->Serie, false);
							$ident_rps->addAttribute('Tipo', '1', false); //1 - RPS

							$data = str_replace(' ','T',$reg_nota->DH_Emissao);
							$inf_rps->addAttribute('DataEmissao', $data, false);

							$inf_rps->addAttribute('Status', $status, false);


							//RPS SUBSTITUIDO
							$con_ref =  'SELECT * FROM nota_fiscal_refenciada '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Tipo_Doc="N"'.
										' ORDER BY Seq_Doc '.
										' LIMIT 1 ';
							$res_ref = consulta_sql($con_ref);
							$nrw_ref = consulta_num_registros($res_ref);
							if($nrw_ref>0){
								$reg_ref = consulta_ler_objeto($res_ref);

								$sub_rps = &$inf_rps->addChild('RpsSubstituido');
								$sub_rps->addAttribute('Numero', $reg_ref->NF_Nr_Doc, false);
								$sub_rps->addAttribute('Serie', $reg_ref->NF_Serie, false);
								$sub_rps->addAttribute('Tipo', '1', false); //1 - RPS
							}
							consulta_limpa($res_ref);

							$competencia = datad(dataf($reg_nota->DH_Emissao));
							$lista_rps->addAttribute('Competencia', $competencia, false);

							$total_outros = 0;

							$con_itens= 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item';
							$res_itens = consulta_sql($con_itens);
							$nrw_itens = consulta_num_registros($res_itens);
							//para cada item da nota
							$lista_desc = '';
							$cidade = $reg_nota->Cidade_FG;
							$pais = '1058';
							$iss_aliq = 0;
							$iss_bc = 0;
							$total_iss = 0;
							$total_irrf = 0;
							$total_inss = 0;
							$total_pis = 0;
							$total_cofins = 0;
							$total_csll = 0;
							$total_retido = 0;

							for($itens=0;$itens<$nrw_itens;$itens++){
								$reg_itens = consulta_ler_objeto($res_itens);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
								if ($reg_itens->ISS_Cidade_FG!=''){
									$cidade = $reg_itens->ISS_Cidade_FG;
								}
								$iss_aliq = $reg_itens->ISS_Aliquota;
								if ($reg_itens->ISS_CST!='I'){
									$total_iss+= $reg_itens->ISS_BC;
								}
								$total_irrf+= $reg_itens->IRRF_Valor;
								$total_inss+= $reg_itens->PrevSocial_Valor;
								$total_pis+= $reg_itens-> PIS_Retido_Valor;
								$total_cofins+= $reg_itens->COFINS_Retido_Valor;
								$total_csll+= $reg_itens->CSLL_Valor;

								if($reg_itens->ISS_CST=='R'){
									$total_retido+= $reg_itens->ISS_Valor;
								}
								$con_obs =  'SELECT * FROM nota_fiscal_obs'.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
											' GROUP BY Texto_Completo'.
											' ORDER BY Seq_Obs';
								$res_obs = consulta_sql($con_obs);
								$nrw_obs = consulta_num_registros($res_obs);
								for($obss=0;$obss<$nrw_obs;$obss++){
									$reg_obs = consulta_ler_objeto($res_obs);
									if ($lista_desc!=''){
										$lista_desc.=';';
									}
									$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
								}
								consulta_limpa($res_obs);
							}

							$con_obs = 'SELECT * FROM nota_fiscal_obs'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Seq_Item=0'.
										' AND Seq_Obs>3 '.
										' GROUP BY Texto_Completo'.
										' ORDER BY Seq_Obs';
							$res_obs = consulta_sql($con_obs);
							$nrw_obs = consulta_num_registros($res_obs);
							for($obss=0;$obss<$nrw_obs;$obss++){
								$reg_obs = consulta_ler_objeto($res_obs);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
							}
							consulta_limpa($res_obs);

							$venc = 'SELECT DT_Vencimento FROM nota_fiscal_parcela'.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" ';
							$res_venc = consulta_sql($venc);
							$reg_venc = consulta_ler_linha($res_venc);
							consulta_limpa($res_venc);

							$lista_desc = str_replace(";","\r\n",$lista_desc);
							$lista_desc .= "\r\nVencimento: ".nfe_formata_txt(dataf($reg_venc[0]));

							$inf_serv = &$lista_rps->addChild('Servico');
							$inf_valores = &$inf_serv->addChild('Valores');

							$inf_valores->addAttribute('ValorServicos', nfe_numero($reg_nota->Total_Servicos,2), false);
							if($reg_nota->Total_Desconto>0){
								$inf_valores->addAttribute('ValorDeducoes', nfe_numero($reg_nota->Total_Desconto,2), false);
							}
							if($total_pis>0){
								$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
							}
							if($total_cofins>0){
								$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
							}
							if($total_inss>0){
								$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
							}
							if($total_irrf>0){
								$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
							}
							if($total_csll>0){
								$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
							}
							if($total_outros>0){
								$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
							}
							$vl_iss = nfe_numero(arredonda_numero_menos($total_iss * $iss_aliq)/100,2);
							if($vl_iss>0){
								$inf_valores->addAttribute('ValorIss', $vl_iss, false);
							}
							$iss_aliq = nfe_numero(($iss_aliq/100),2);
							if($iss_aliq>0){
								$inf_valores->addAttribute('Aliquota', $iss_aliq, false);
							}

							if($reg_itens->ISS_CST=='R'){
								$inf_serv->addAttribute('IssRetido', '1', false);
								$inf_serv->addAttribute('ResponsavelRetencao', '1', false);
							}else {
								$inf_serv->addAttribute('IssRetido', '2', false);
							}


							$inf_serv->addAttribute('ItemListaServico', $reg_itens->Servico_Codigo, false);

							//$cnae_munic = limpa_numero($reg_end_emp[9]);
							$inf_serv->addAttribute('CodigoCnae', $cnae_munic, false);

							//$inf_serv->addAttribute('CodigoTributacaoMunicipio', $cnae_munic, false);
							$inf_serv->addAttribute('Discriminacao', trim(substr($lista_desc,0,2000)), false);
							$inf_serv->addAttribute('CodigoMunicipio', $cidade, false);
							$inf_serv->addAttribute('CodigoPais', $pais, false);

							$con_item = 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item LIMIT 1';
							$res_item = consulta_sql($con_item);
							$reg_item = consulta_ler_objeto($res_item);
							if($reg_item->ISS_CST=='I'){
								$sit_rps = '3';
							}else if(($reg_item->ISS_CST=='N')||($reg_item->ISS_CST=='S')||($reg_item->ISS_CST=='R')){
								if($reg_item->ISS_Cidade_FG!=''){
									if($reg_item->ISS_Cidade_FG != $reg_end_emp[7]){
										$sit_rps = '2';
									}else{
										$sit_rps = '1';
									}
								}else{
									$sit_rps = '1';
								}
							}
							consulta_limpa($res_item);
							$inf_serv->addAttribute('ExigibilidadeISS', $sit_rps, false);

							$inf_prest = &$lista_rps->addChild('Prestador');
							$inf_prest->addAttribute('Cnpj', limpa_numero($reg_empresa[0]), false);

							$prest_im = limpa_numero($reg_end_emp[0]);
							if($prest_im!=''){
								$inf_prest->addAttribute('InscricaoMunicipal', $insc_munic, false);
							}

							$con_tom =  'SELECT'.
										' CPF_CNPJ,'.
										' Nome_Razao,'.
										' EMail'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_tom = consulta_sql($con_tom);
							$reg_tom = consulta_ler_linha($res_tom);
							consulta_limpa($res_tom);

							$inf_tom = &$lista_rps->addChild('TomadorServico');
							if($reg_tom[0]!=''){
								$inf_idtom = &$inf_tom->addChild('IdentificacaoTomador');
								$inf_cpftom = &$inf_idtom->addChild('CpfCnpj');
								if(strlen(limpa_numero($reg_tom[0]))==11){
									$inf_cpftom->addAttribute('Cpf', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}else if(strlen(limpa_numero($reg_tom[0]))==14){
									$inf_cpftom->addAttribute('Cnpj', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}
							}
							$inf_tom->addAttribute('RazaoSocial', substr(trim(UpperDados($nome_tomador)),0,115), false);

							if($informa_end){
								$con_end_tom =  'SELECT'.
												' Insc_Municipal,'.
												' CEP,'.
												' Logradouro,'.
												' Numero,'.
												' Bairro,'.
												' Complemento, '.
												' UF,'.
												' Codigo_Cidade,'.
												' Nome_Cidade,'.
												' Insc_Estadual,'.
												' Codigo_Pais'.
												' FROM pessoa_endereco '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
								$res_end_tom = consulta_sql($con_end_tom);
								$reg_end_tom = consulta_ler_linha($res_end_tom);
								consulta_limpa($res_end_tom);

								$inf_end_tom = &$inf_tom->addChild('Endereco');

								$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,125);
								if($end_endereco!=''){
									$inf_end_tom->addAttribute('Endereco', $end_endereco, false);
								}

								$end_num = substr(limpa_numero($reg_end_tom[3]),0,10);
								if($end_num!=''){
									$inf_end_tom->addAttribute('Numero', $end_num, false);
								}

								$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,60);
								if($end_comp!=''){
									$inf_end_tom->addAttribute('Complemento', $end_comp, false);
								}

								$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,60);
								if($end_bairro!=''){
									$inf_end_tom->addAttribute('Bairro', $end_bairro, false);
								}

								$end_munic = substr(limpa_numero($reg_end_tom[7]),0,7);
								if($end_munic!=''){
									$inf_end_tom->addAttribute('CodigoMunicipio', $end_munic, false);
								}

								$end_uf = substr(trim(UpperDados($reg_end_tom[6])),0,2);
								if($end_uf!=''){
									$inf_end_tom->addAttribute('Uf', $end_uf, false);
								}

								$end_cep = substr(limpa_numero($reg_end_tom[10]),0,4);
								if($end_cep!=''){
									$inf_end_tom->addAttribute('CodigoPais', substr(limpa_numero($reg_end_tom[10]),0,8), false);
								}

								$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
								if($end_cep!=''){
									$inf_end_tom->addAttribute('Cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);
								}
							}

							$tem_contato = false;
							$tel_tomador = '';
							if($reg_nota->Dest_Telefone>0){
								$con_tom_tel =  'SELECT'.
												' Numero_Telefone,'.
												' Situacao'.
												' FROM pessoa_telefone '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
												' AND Situacao<>"E" ';
								$res_tom_tel = consulta_sql($con_tom_tel);
								$reg_tom_tel = consulta_ler_linha($res_tom_tel);
								consulta_limpa($res_tom_tel);

								$tel_tomador = $reg_tom_tel[0];
								$tem_contato = true;
							}

							if($tem_contato){
								$inf_cont_tom = &$inf_tom->addChild('Contato');
								if($tel_tomador!=''){
									$inf_cont_tom->addAttribute('Telefone', substr(limpa_numero($tel_tomador),0,11), false);
								}
								if($reg_tom[2]!=''){
									$inf_cont_tom->addAttribute('Email', substr(trim($reg_tom[2]),0,80), false);
								}
							}

							$con_pessoa='SELECT CPF_CNPJ, Opt_Simples FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_pessoa = consulta_sql($con_pessoa);
							$reg_pessoa = consulta_ler_objeto($res_pessoa);
							consulta_limpa($res_pessoa);
							if($reg_pessoa->Opt_Simples=='S'){
								$opt_simples = '1';
							}else{
								$opt_simples = '2';
							}

							$lista_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
							$lista_rps->addAttribute('IncentivoFiscal', '2', false);
						}//fim if update
					}//fim for
					$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/tmp/";

					//finaliza arquivo na pasta tmp
					rmkdir($caminho);
					$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.xml";
					//echo $caminho.'<BR>'.$nr_lote.'<BR>-'.$nome_arq.'-';
					$nome_tmp = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28);

					$xml->toFile($caminho, $nome_arq);
					$retorno = '';
					$salvou = file_exists($caminho.$nome_arq);
					$texto_final = '';
					$array_of_list_values = file($caminho.$nome_arq);

					foreach ($array_of_list_values as $list_value){
						$list_value = str_replace('&apos;','&apos', $list_value);
						$list_value = str_replace('&lt;','&lt', $list_value);
						$list_value = str_replace('&gt;','&gt', $list_value);
						$list_value = str_replace('&quot;','&quot', $list_value);
						$list_value = str_replace('&amp;','&amp', $list_value);
						$list_value = str_replace(';',FIML, $list_value);
						$list_value = str_replace('&apos','&apos;', $list_value);
						$list_value = str_replace('&lt','&lt;', $list_value);
						$list_value = str_replace('&gt','&gt;', $list_value);
						$list_value = str_replace('&quot','&quot;', $list_value);
						$list_value = str_replace('&amp','&amp;', $list_value);

						$texto_final.=$list_value;
					}

					if (file_exists($caminho.$nome_arq)){
						unlink($caminho.$nome_arq);
					}
					$Handle = fopen($caminho.$nome_arq, 'w');
					fwrite($Handle, $texto_final);
					fclose($Handle);

					//se consegui salvar

					$lista_nfs = explode(';',$lista_nfs);
					if ($salvou){
						if(nfse_valida_lote($nome_tmp,$lista_nfs,$operacao)){
							$retorno = 1;
						}else{
							$retorno = -1;
						}
						//$retorno = 1;
					}else{
						$retorno = -1;
					}

				}else if($reg_serie[1]=='16'){ //NFSe Jaragu do Sul (Betha) //NAO ESTA GERANDO POR AQUI!!
					//cria objeto xml
					$xml = new XML();

					$nf_inf = &$xml->createRoot("EnviarLoteRpsSincronoEnvio");
					$nf_inf->addAttribute('xmlns', 'xmlns="http://www.betha.com.br/e-nota-contribuinte-ws"', true);
					//$nf_inf->addAttribute('xmlns', 'http://www.abrasf.org.br/ABRASF/arquivos/nfse.xsd', true);
					//$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
					//$nf_inf->addAttribute('xsi:schemaLocation', 'http://www.abrasf.org.br/ABRASF/arquivos/nfse.xsd', true);


					//consulta empresa cnpj nome
					$con_empresa  = 'SELECT'.
									' CPF_CNPJ,'.
									' Nome_Razao'.
									' FROM pessoa '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
					$res_empresa = consulta_sql($con_empresa);
					$reg_empresa = consulta_ler_linha($res_empresa);
					consulta_limpa($res_empresa);
					$cnpj = limpa_numero($reg_empresa[0]);

					$con_end_emp  = 'SELECT'.
									' Insc_Municipal,'.
									' CEP,'.
									' Logradouro,'.
									' Numero,'.
									' Bairro,'.
									' Complemento,'.
									' UF,'.
									' Codigo_Cidade,'.
									' Nome_Cidade,'.
									' CNAE_Municipal'.
									' FROM pessoa_endereco '.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Situacao<>"E"'.
									' ORDER BY Seq_Endereco limit 1';
					$res_end_emp = consulta_sql($con_end_emp);
					$reg_end_emp = consulta_ler_linha($res_end_emp);
					consulta_limpa($res_end_emp);
					$insc_munic = $reg_end_emp[0];
					$cnae_munic = $reg_end_emp[9];

					$lote_rps = &$nf_inf->addChild("LoteRps");
					$lote_rps->addAttribute('Id', $nr_lote, true);
					$lote_rps->addAttribute('versao', "2.02", true);

					$lote_rps->addAttribute('NumeroLote', $nr_lote, false);
					$lote_rps->addAttribute('Cnpj', $cnpj, false);
					$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
					$lote_rps->addAttribute('QuantidadeRps', $nro_nota, false);

					$lista_rps = &$lote_rps->addChild("ListaRps");
					$lista_nfs = '';
					for($k=0;$k<$nro_nota;$k++){
						$reg_nota = consulta_ler_objeto($res_nota);

						$nr_nota = $reg_nota->Nr_Nota;
						if($lista_nfs!=''){
							$lista_nfs.= ';';
						}
						$lista_nfs.= $nr_nota;

						if($operacao=="I"){
							$status = '1';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote=""';
						}else{
							$status = '2';
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote_C="'.$nr_lote.'", '.
										' NFSe_Versao="1.0", '.
										' NFSe_Lote_C_DH_Envio=now() '.
										' WHERE Dominio="'.$reg_nota->Dominio.'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NFSe_Lote_C=""';
						}

						$res_upd = consulta_sql($upd_nota,true,1);
						//$res_upd = 1;
						if($res_upd==1){
							$rps = &$lista_rps->addChild("Rps");
							//$rps->addAttribute('xmlns', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);

							$inf_rps = &$rps->addChild("InfRps");
							//$inf_rps->addAttribute('Id', $k+1, true);

							$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
							$ident_rps->addAttribute('Numero', $reg_nota->NrDoc, false);
							$ident_rps->addAttribute('Serie', $reg_nota->Serie, false);
							$ident_rps->addAttribute('Tipo', '1', false); //1 - RPS

							$competencia = datad(dataf($reg_nota->DH_Emissao)); //str_replace(' ','T',$reg_nota->DH_Emissao);
							$inf_rps->addAttribute('DataEmissao', $competencia, false);
							$inf_rps->addAttribute('Status', $status, false);

							$con_item = 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item LIMIT 1';
							$res_item = consulta_sql($con_item);
							$reg_item = consulta_ler_objeto($res_item);
							if($reg_item->ISS_CST=='I'){
								$sit_rps = '3';
							}else if(($reg_item->ISS_CST=='N')||($reg_item->ISS_CST=='S')||($reg_item->ISS_CST=='R')){
								if($reg_item->ISS_Cidade_FG!=''){
									if($reg_item->ISS_Cidade_FG != $reg_end_emp[7]){
										$sit_rps = '2';
									}else{
										$sit_rps = '1';
									}
								}else{
									$sit_rps = '1';
								}
							}
							consulta_limpa($res_item);
							//$inf_rps->addAttribute('NaturezaOperacao', $sit_rps, false);
							//RPS SUBSTITUIDO
							$con_ref =  'SELECT * FROM nota_fiscal_refenciada '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Tipo_Doc="N"'.
										' ORDER BY Seq_Doc '.
										' LIMIT 1 ';
							$res_ref = consulta_sql($con_ref);
							$nrw_ref = consulta_num_registros($res_ref);
							if($nrw_ref>0){
								$reg_ref = consulta_ler_objeto($res_ref);

								$sub_rps = &$inf_rps->addChild('RpsSubstituido');
								$sub_rps->addAttribute('Numero', $reg_ref->NF_Nr_Doc, false);
								$sub_rps->addAttribute('Serie', $reg_ref->NF_Serie, false);
								$sub_rps->addAttribute('Tipo', '1', false); //1 - RPS
							}
							consulta_limpa($res_ref);

							$competencia = datad(dataf($reg_nota->DH_Emissao));
							$lista_rps->addAttribute('Competencia', $competencia, false);
							$total_outros = 0;

							$con_itens= 'SELECT * FROM nota_fiscal_item'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Prod_Depart=0'.
										' ORDER BY Seq_Item';
							$res_itens = consulta_sql($con_itens);
							$nrw_itens = consulta_num_registros($res_itens);
							//para cada item da nota
							$lista_desc = '';
							$cidade = $reg_nota->Cidade_FG;
							$iss_aliq = 0;
							$iss_bc = 0;
							$total_iss = 0;
							$total_irrf = 0;
							$total_inss = 0;
							$total_pis = 0;
							$total_cofins = 0;
							$total_csll = 0;
							$total_retido = 0;

							for($itens=0;$itens<$nrw_itens;$itens++){
								$reg_itens = consulta_ler_objeto($res_itens);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
								if ($reg_itens->ISS_Cidade_FG!=''){
									$cidade = $reg_itens->ISS_Cidade_FG;
								}
								$iss_aliq = $reg_itens->ISS_Aliquota;
								if ($reg_itens->ISS_CST!='I'){
									$total_iss+= $reg_itens->ISS_BC;
								}
								$total_irrf+= $reg_itens->IRRF_Valor;
								$total_inss+= $reg_itens->PrevSocial_Valor;
								$total_pis+= $reg_itens-> PIS_Retido_Valor;
								$total_cofins+= $reg_itens->COFINS_Retido_Valor;
								$total_csll+= $reg_itens->CSLL_Valor;

								if($reg_itens->ISS_CST=='R'){
									$total_retido+= $reg_itens->ISS_Valor;
								}

								$con_obs =  'SELECT * FROM nota_fiscal_obs'.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
											' GROUP BY Texto_Completo'.
											' ORDER BY Seq_Obs';
								$res_obs = consulta_sql($con_obs);
								$nrw_obs = consulta_num_registros($res_obs);
								for($obss=0;$obss<$nrw_obs;$obss++){
									$reg_obs = consulta_ler_objeto($res_obs);
									if ($lista_desc!=''){
										$lista_desc.=';';
									}
									$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
								}
								consulta_limpa($res_obs);
							}

							$con_obs = 'SELECT * FROM nota_fiscal_obs'.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
										' AND Seq_Item=0'.
										' AND Seq_Obs>3 '.
										' GROUP BY Texto_Completo'.
										' ORDER BY Seq_Obs';
							$res_obs = consulta_sql($con_obs);
							$nrw_obs = consulta_num_registros($res_obs);
							for($obss=0;$obss<$nrw_obs;$obss++){
								$reg_obs = consulta_ler_objeto($res_obs);
								if ($lista_desc!=''){
									$lista_desc.=';';
								}
								$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
							}
							consulta_limpa($res_obs);

							$venc = 'SELECT DT_Vencimento FROM nota_fiscal_parcela'.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" ';
							$res_venc = consulta_sql($venc);
							$reg_venc = consulta_ler_linha($res_venc);
							consulta_limpa($res_venc);

							$lista_desc = str_replace(";","\r\n",$lista_desc);
							$lista_desc .= "\r\nVencimento: ".nfe_formata_txt(dataf($reg_venc[0]));

							$inf_serv = &$inf_rps->addChild('Servico');
							$inf_valores = &$inf_serv->addChild('Valores');
							$inf_valores->addAttribute('ValorServicos', nfe_numero($reg_nota->Total_Servicos,2), false);
							//if($reg_nota->Total_Desconto>0){
							//   $inf_valores->addAttribute('ValorDeducoes', nfe_numero(0,2), false);
							//}
							if($total_pis>0){
								$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
							}
							if($total_cofins>0){
								$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
							}
							if($total_inss>0){
								$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
							}
							if($total_irrf>0){
								$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
							}
							if($total_csll>0){
								$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
							}
							if($reg_itens->ISS_CST=='R'){
								$inf_valores->addAttribute('IssRetido', '1', false);
							}else {
								$inf_valores->addAttribute('IssRetido', '2', false);
							}
							$vl_iss = nfe_numero(arredonda_numero_menos($total_iss * $iss_aliq)/100,2);
							if($vl_iss>0){
								$inf_valores->addAttribute('ValorIss', $vl_iss, false);
							}
							if($total_retido>0){
								$inf_valores->addAttribute('ValorIssRetido', nfe_numero($total_retido,2), false);
							}
							if($total_outros>0){
								$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
							}
							if($total_iss>0){
								$inf_valores->addAttribute('BaseCalculo', nfe_numero($total_iss,2), false);
							}
							$iss_aliq = nfe_numero(($iss_aliq/100),2);
							if($iss_aliq>0){
								$inf_valores->addAttribute('Aliquota', $iss_aliq, false);
							}
							$vl_liquido = ($reg_nota->Total_NF-$total_pis-$total_cofins-$total_inss-
							$total_irrf-$total_csll-$total_outros-$total_retido);
							if($vl_liquido>0){
								$inf_valores->addAttribute('ValorLiquidoNfse', nfe_numero($vl_liquido,2), false);
							}

							//$inf_valores->addAttribute('DescontoIncondicionado', nfe_numero(0,2), false);
							//$inf_valores->addAttribute('DescontoCondicionado', nfe_numero(0,2), false);
							$inf_serv->addAttribute('ItemListaServico', $reg_itens->Servico_Codigo, false);

							//$cnae_munic = limpa_numero($reg_end_emp[9]);
							$inf_serv->addAttribute('CodigoCnae', $cnae_munic, false);
							$inf_serv->addAttribute('Discriminacao', trim(substr($lista_desc,0,2000)), false);
							$inf_serv->addAttribute('CodigoMunicipio', $cidade, false);

							$inf_prest = &$inf_rps->addChild('Prestador');
							$inf_prest->addAttribute('Cnpj', limpa_numero($reg_empresa[0]), false);

							//$prest_im = limpa_numero($reg_end_emp[0]);
							//if($prest_im!=''){
							$inf_prest->addAttribute('InscricaoMunicipal', $insc_munic, false);
							//}

							$con_tom =  'SELECT'.
										' CPF_CNPJ,'.
										' Nome_Razao,'.
										' EMail'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_tom = consulta_sql($con_tom);
							$reg_tom = consulta_ler_linha($res_tom);
							consulta_limpa($res_tom);

							$inf_tom = &$inf_rps->addChild('Tomador');
							if($reg_tom[0]!=''){
								$inf_idtom = &$inf_tom->addChild('IdentificacaoTomador');
								$inf_cpftom = &$inf_idtom->addChild('CpfCnpj');

								if(strlen(limpa_numero($reg_tom[0]))==11){
									$inf_cpftom->addAttribute('Cpf', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}else if(strlen(limpa_numero($reg_tom[0]))==14){
									$inf_cpftom->addAttribute('Cnpj', limpa_numero($reg_tom[0]), false);
									if(limpa_numero($reg_tom[0])=='00000000000000'){
										$nome_tomador = 'TOMADOR NO IDENTIFICADO';
										$informa_end = false;
									}else{
										$nome_tomador = $reg_tom[1];
										$informa_end = true;
									}
								}
							}
							$inf_tom->addAttribute('RazaoSocial', substr(trim(UpperDados($nome_tomador)),0,115), false);
							if($informa_end){
								$con_end_tom = 'SELECT Insc_Municipal, CEP, Logradouro, Numero, Bairro, Complemento, '.
												' UF, Codigo_Cidade, Nome_Cidade, Insc_Estadual FROM pessoa_endereco '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
								$res_end_tom = consulta_sql($con_end_tom);
								$reg_end_tom = consulta_ler_linha($res_end_tom);
								consulta_limpa($res_end_tom);

								$inf_end_tom = &$inf_tom->addChild('Endereco');

								$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,125);
								if($end_endereco!=''){
									$inf_end_tom->addAttribute('Endereco', $end_endereco, false);
								}
								$end_num = substr(limpa_numero($reg_end_tom[3]),0,10);
								if($end_num!=''){
									$inf_end_tom->addAttribute('Numero', $end_num, false);
								}
								$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,60);
								if($end_comp!=''){
									$inf_end_tom->addAttribute('Complemento', $end_comp, false);
								}
								$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,60);
								if($end_bairro!=''){
									$inf_end_tom->addAttribute('Bairro', $end_bairro, false);
								}
								$end_munic = substr(limpa_numero($reg_end_tom[7]),0,7);
								if($end_munic!=''){
									$inf_end_tom->addAttribute('CodigoMunicipio', $end_munic, false);
								}
								$end_uf = substr(trim(UpperDados($reg_end_tom[6])),0,2);
								if($end_uf!=''){
									$inf_end_tom->addAttribute('Uf', $end_uf, false);
								}
								$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
								if($end_cep!=''){
									$inf_end_tom->addAttribute('Cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);
								}
							}

							$tem_contato = false;
							$tel_tomador = '';
							if($reg_nota->Dest_Telefone>0){
								$con_tom_tel =  'SELECT'.
												' Numero_Telefone,'.
												' Situacao'.
												' FROM pessoa_telefone '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
												' AND Situacao<>"E" ';
								$res_tom_tel = consulta_sql($con_tom_tel);
								$reg_tom_tel = consulta_ler_linha($res_tom_tel);
								consulta_limpa($res_tom_tel);

								$tel_tomador = $reg_tom_tel[0];
								$tem_contato = true;
							}
							if($tem_contato){
								$inf_cont_tom = &$inf_tom->addChild('Contato');
								if($tel_tomador!=''){
									$inf_cont_tom->addAttribute('Telefone', substr(limpa_numero($tel_tomador),0,11), false);
								}
								if($reg_tom[2]!=''){
									$inf_cont_tom->addAttribute('Email', substr(trim($reg_tom[2]),0,80), false);
								}
							}
							$con_pessoa='SELECT'.
										' CPF_CNPJ,'.
										' Opt_Simples'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"';
							$res_pessoa = consulta_sql($con_pessoa);
							$reg_pessoa = consulta_ler_objeto($res_pessoa);
							consulta_limpa($res_pessoa);
							if($reg_pessoa->Opt_Simples=='S'){
								$opt_simples = '1';
							}else{
								$opt_simples = '2';
							}
							//$inf_rps->addAttribute('RegimeEspecialTributacao', '0', false);
							$inf_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
							$inf_rps->addAttribute('IncentivadorCultural', '2', false);
						}//fim if update
					}//fim for
					$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/tmp/";

					//finaliza arquivo na pasta tmp
					rmkdir($caminho);
					$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.xml";
					//echo $caminho.'<BR>'.$nr_lote.'<BR>-'.$nome_arq.'-';
					$nome_tmp = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28);

					$xml->toFile($caminho, $nome_arq);
					$retorno = '';
					$salvou = file_exists($caminho.$nome_arq);
					$texto_final = '';
					$array_of_list_values = file($caminho.$nome_arq);

					foreach ($array_of_list_values as $list_value){
						$list_value = str_replace('&apos;','&apos', $list_value);
						$list_value = str_replace('&lt;','&lt', $list_value);
						$list_value = str_replace('&gt;','&gt', $list_value);
						$list_value = str_replace('&quot;','&quot', $list_value);
						$list_value = str_replace('&amp;','&amp', $list_value);
						$list_value = str_replace(';',FIML, $list_value);
						$list_value = str_replace('&apos','&apos;', $list_value);
						$list_value = str_replace('&lt','&lt;', $list_value);
						$list_value = str_replace('&gt','&gt;', $list_value);
						$list_value = str_replace('&quot','&quot;', $list_value);
						$list_value = str_replace('&amp','&amp;', $list_value);

						$texto_final.=$list_value;
					}

					if (file_exists($caminho.$nome_arq)){
						unlink($caminho.$nome_arq);
					}
					$Handle = fopen($caminho.$nome_arq, 'w');
					fwrite($Handle, $texto_final);
					fclose($Handle);

					//se consegui salvar

					$lista_nfs = explode(';',$lista_nfs);
					if ($salvou){
						if(nfse_valida_lote($nome_tmp,$lista_nfs,$operacao)){
							$retorno = 1;
						}else{
							$retorno = -1;
						}
						//$retorno = 1;
					}else{
						$retorno = -1;
					}

				}else{ //JOINVILLE
					//cria objeto xml
					$xml = new XML();

					//Layout antes 11/2024
					/*
						$nf_inf = &$xml->createRoot("lote");
						$nf_inf->addAttribute('xmlns', 'https://www.nfem.joinville.sc.gov.br', true);
						$nf_inf->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
						$nf_inf->addAttribute('xsi:schemaLocation', 'http://www.nfem.joinville.sc.gov.br rps_1.0.xsd', true);

						$nf_inf->addAttribute('versao', '1.0', false);
						$nf_inf->addAttribute('numero', $nr_lote, false);
						$nf_inf->addAttribute('tipo', '1', false); //RPS
						//$nf_inf->addAttribute('layout_impressao', $reg_nota->Layout_Impressao, false);

						//consulta empresa cnpj nome
						$con_empresa =  'SELECT'.
										' CPF_CNPJ,'.
										' Nome_Razao'.
										' FROM pessoa '.
										' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
										' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
						$res_empresa = consulta_sql($con_empresa);
						$reg_empresa = consulta_ler_linha($res_empresa);
						consulta_limpa($res_empresa);

						$cnpj = limpa_numero($reg_empresa[0]);

						//PRESTADOR
						$pres = &$nf_inf->addChild("prestador");
						$pres->addAttribute('documento', $cnpj, false);
						$pres->addAttribute('razao_social', $reg_empresa[1] , false);

						for($k=0;$k<$nro_nota;$k++){
							$reg_nota = consulta_ler_objeto($res_nota);

							$nr_nota = $reg_nota->Nr_Nota;

							if ($operacao=="I"){
								$upd_nota = 'UPDATE nota_fiscal SET'.
											' NFSe_Lote="'.$nr_lote.'", '.
											' NFSe_Versao="1.0", '.
											' NFSe_Lote_DH_Envio=now() '.
											' WHERE Dominio="'.$reg_nota->Dominio.'"'.
											' AND Empresa="'.$reg_nota->Empresa.'"'.
											' AND Nr_Nota="'.$nr_nota.'"'.
											' AND NFSe_Lote=""';
							}else{
								$upd_nota = 'UPDATE nota_fiscal SET'.
											' NFSe_Lote_C="'.$nr_lote.'", '.
											' NFSe_Versao="1.0", '.
											' NFSe_Lote_C_DH_Envio=now() '.
											' WHERE Dominio="'.$reg_nota->Dominio.'"'.
											' AND Empresa="'.$reg_nota->Empresa.'"'.
											' AND Nr_Nota="'.$nr_nota.'"'.
											' AND NFSe_Lote_C=""';
							}

							$res_upd = consulta_sql($upd_nota,true,1);
							//$res_upd = 1;
							if($res_upd==1){
								//RPS(s)
								//Valores fixo
								$rps = &$nf_inf->addChild("rps");
								$rps->addAttribute('numero', $reg_nota->NrDoc, false);
								if($reg_nota->Serie!=''){
									$rps->addAttribute('serie', $reg_nota->Serie , false);
								}
								$rps->addAttribute('operacao', $operacao, false);
								if ($reg_nota->Modelo!='98'){
									$rps->addAttribute('tipo', '2', false); //1 - Recibo; 2 - Nota fiscal conjugada mista
								}else{
									$rps->addAttribute('tipo', '1', false);
								}
								$data = substr($reg_nota->DH_Emissao,0,10);
								$rps->addAttribute('data', $data, false);

								//consulta Tomador
								$con_tom =  'SELECT'.
											' CPF_CNPJ,'.
											' Nome_Razao,'.
											' EMail,'.
											' Tipo_Cad_Pessoa'.
											' FROM pessoa '.
											' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
											' AND Pessoa="'.$reg_nota->Destinatario.'"';
								$res_tom = consulta_sql($con_tom);
								$reg_tom = consulta_ler_linha($res_tom);
								consulta_limpa($res_tom);

								$con_pessoa = 'SELECT'.
												' Insc_Municipal,'.
												' CEP,'.
												' Logradouro,'.
												' Numero,'.
												' Bairro,'.
												' Complemento,'.
												' UF,'.
												' Codigo_Cidade,'.
												' Nome_Cidade'.
												' FROM pessoa_endereco '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Pessoa="'.$reg_nota->Destinatario.'"'.
												' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
								$res_pessoa = consulta_sql($con_pessoa);
								$reg_pessoa = consulta_ler_linha($res_pessoa);
								consulta_limpa($res_pessoa);

								$cnpj_tom = limpa_numero($reg_tom[0]);

								//Dados do tomador
								$tom = &$rps->addChild("tomador");
								$tom->addAttribute('documento', $cnpj_tom, false);
								$tom->addAttribute('nome', trim(substr($reg_tom[1],0,60)), false);

								if($reg_pessoa[0]!=''){
									$tom->addAttribute('inscricao_municipal', trim(substr($reg_pessoa[0],0,20)), false);
								}
								if($reg_tom[2]!=''){
									$tom->addAttribute('email', trim(substr($reg_tom[2],0,50)), false);
								}

								//Consulta tipo_cad_pessoa

								$con_cad_pessoa='SELECT Codigo_Servico FROM tipo_cad_pessoa '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Codigo_Tipo_Cadastro="'.$reg_tom[3].'"';
								$res_cad_pessoa = consulta_sql($con_cad_pessoa);
								$reg_cad_pessoa = consulta_ler_linha($res_cad_pessoa);
								consulta_limpa($res_cad_pessoa);

								if($reg_cad_pessoa[0]==''){
									$reg_cad_pessoa[0] = '0';
								}

								$tom->addAttribute('situacao_especial', $reg_cad_pessoa[0], false);
								$cep = limpa_numero($reg_pessoa[1]);
								$cep = fill_full(substr($cep,0,8),8);
								$tom->addAttribute('cep', $cep, false);
								$tom->addAttribute('endereco', trim(substr($reg_pessoa[2],0,150)), false);
								if($reg_pessoa[3]!=''){
									$tom->addAttribute('numero', trim(substr($reg_pessoa[3],0,10)), false);
								}else {
									$tom->addAttribute('numero', 'S/N', false);
								}
								if($reg_pessoa[5]!=''){
									$tom->addAttribute('complemento', trim(substr($reg_pessoa[5],0,100)), false);
								}
								$tom->addAttribute('bairro', trim(substr($reg_pessoa[4],0,50)), false);
								//Estado - se nao for joinville
								if($reg_pessoa[7]!='4209102'){
									$tom->addAttribute('cidade', trim(substr($reg_pessoa[8],0,60)), false);
									$tom->addAttribute('estado', trim($reg_pessoa[6]), false);
								}
								//consulta itens da NF
								$con_itens= 'SELECT * FROM nota_fiscal_item'.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Prod_Depart=0'.
											' ORDER BY Seq_Item';
								$res_itens = consulta_sql($con_itens);
								$nrw_itens = consulta_num_registros($res_itens);
								//para cada item da nota
								$lista_desc = '';
								$cidade = $reg_nota->Cidade_FG;
								$iss_aliq = 0;
								$total_iss = 0;
								$total_irrf = 0;
								$total_inss = 0;
								$total_pis = 0;
								$total_cofins = 0;
								$total_csll = 0;

								for($itens=0;$itens<$nrw_itens;$itens++){
									$reg_itens = consulta_ler_objeto($res_itens);
									if ($lista_desc!=''){
										$lista_desc.=';';
									}
									$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
									if ($reg_itens->ISS_Cidade_FG!=''){
										$cidade = $reg_itens->ISS_Cidade_FG;
									}
									$iss_aliq  = $reg_itens->ISS_Aliquota;
									if ($reg_itens->ISS_CST!='I'){
										$total_iss+= $reg_itens->ISS_BC;
									}
									$total_irrf += $reg_itens->IRRF_Valor;
									$total_inss += $reg_itens->PrevSocial_Valor;
									$total_pis += $reg_itens->PIS_Valor;
									$total_cofins += $reg_itens->COFINS_Valor;
									$total_csll += $reg_itens->CSLL_Valor;

									$con_obs =  'SELECT * FROM nota_fiscal_obs'.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
												' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
												' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
												' GROUP BY Texto_Completo'.
												' ORDER BY Seq_Obs';
									$res_obs = consulta_sql($con_obs);
									$nrw_obs = consulta_num_registros($res_obs);
									for($obss=0;$obss<$nrw_obs;$obss++){
										$reg_obs = consulta_ler_objeto($res_obs);
										if ($lista_desc!=''){
											$lista_desc.=';';
										}
										$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
									}
									consulta_limpa($res_obs);

								}
								$con_obs = 'SELECT * FROM nota_fiscal_obs'.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Seq_Item=0'.
											' AND Seq_Obs>3 '.
											' GROUP BY Texto_Completo'.
											' ORDER BY Seq_Obs';
								$res_obs = consulta_sql($con_obs);
								$nrw_obs = consulta_num_registros($res_obs);
								for($obss=0;$obss<$nrw_obs;$obss++){
									$reg_obs = consulta_ler_objeto($res_obs);
									if ($lista_desc!=''){
										$lista_desc.=';';
									}
									$lista_desc.=trim($reg_obs->Texto_Completo);
								}
								consulta_limpa($res_obs);
								$rps->addAttribute('descricao_servicos', trim(substr($lista_desc,0,8000)), false);
								$tipo_pessoa = '0';
								if ($reg_tom[3]=='6'){
									$tipo_pessoa = '1';
								}
								$rps->addAttribute('destino_servico', $tipo_pessoa, false);
								//Os valores
								$rps->addAttribute('valor_total', nfe_numero($reg_nota->Total_Servicos,2), false);
								//Os valore de deducao
								if($reg_nota->Total_Desconto >0){
									$rps->addAttribute('valor_deducao', nfe_numero($reg_nota->Total_Desconto,2), false);
								}
								//Servio
								$rps->addAttribute('servico', $reg_itens->Servico_Codigo, false);
								if ($cidade!='4209102'){
									$con_cidade='SELECT Nome, UF FROM cidade '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Codigo_Cidade="'.$cidade.'"';
									$res_cidade = consulta_sql($con_cidade);
									$reg_cidade = consulta_ler_linha($res_cidade);
									consulta_limpa($res_cidade);
									$cidade = $reg_cidade[0].'/'.$reg_cidade[1];
									$rps->addAttribute('local_servico', trim($cidade), false);
								}

								// Retido
								if($reg_itens->ISS_CST == 'R'){
									$valor_iss = 0;
								}else{
									$valor_iss = (arredonda_numero_menos($total_iss * $iss_aliq) / 100);
								}

								//Aliquota e outros impostos
								$rps->addAttribute('aliquota_iss', nfe_numero($iss_aliq, 2), false);
								$rps->addAttribute('valor_iss', nfe_numero($valor_iss, 2), false);

								//if retido
								if($reg_itens->ISS_CST == 'R'){
									$rps->addAttribute('iss_retido', '1', false);
								}else {
									$rps->addAttribute('iss_retido', '0', false);
								}
								if ($total_irrf>0){
									$rps->addAttribute('valor_irrf', nfe_numero($total_irrf,2), false);
								}
								if ($total_inss>0){
									$rps->addAttribute('valor_inss', nfe_numero($total_inss,2), false);
								}
								if ($total_pis>0){
									$rps->addAttribute('valor_pis', nfe_numero($total_pis,2), false);
								}
								if ($total_cofins>0){
									$rps->addAttribute('valor_cofins', nfe_numero($total_cofins,2), false);
								}
								if ($total_csll>0){
									$rps->addAttribute('valor_csll', nfe_numero($total_csll,2), false);
								}
							}
						}
						$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/lote/";

						//finaliza arquivo na pasta tmp
						rmkdir($caminho);
						$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.xml";
						//echo $caminho.'<BR>'.$nr_lote.'<BR>-'.$nome_arq.'-';

						$xml->toFile($caminho, $nome_arq);
						$retorno = '';
						$salvou = file_exists($caminho.$nome_arq);
						$texto_final = '';
						$array_of_list_values = file($caminho.$nome_arq);

						foreach ($array_of_list_values as $list_value){
							$list_value = str_replace('&apos;','&apos', $list_value);
							$list_value = str_replace('&lt;','&lt', $list_value);
							$list_value = str_replace('&gt;','&gt', $list_value);
							$list_value = str_replace('&quot;','&quot', $list_value);
							$list_value = str_replace('&amp;','&amp', $list_value);
							$list_value = str_replace(';',FIML, $list_value);
							$list_value = str_replace('&apos','&apos;', $list_value);
							$list_value = str_replace('&lt','&lt;', $list_value);
							$list_value = str_replace('&gt','&gt;', $list_value);
							$list_value = str_replace('&quot','&quot;', $list_value);
							$list_value = str_replace('&amp','&amp;', $list_value);
							$texto_final.=$list_value;
						}

						if (file_exists($caminho.$nome_arq)){
							unlink($caminho.$nome_arq);
						}
						$Handle = fopen($caminho.$nome_arq, 'w');
						fwrite($Handle, $texto_final);
						fclose($Handle);

						//se consegui salvar
						if ($salvou){
							$retorno = 1;
						}else{
							$retorno = -1;
						}
					*/
					$retorno = 0;
					for($n=0;$n<$nro_nota;$n++){
						$reg_nota = consulta_ler_objeto($res_nota);
						$retorno = nota_fiscal_envio_joinville_gerar_nfse($reg_nota,false);						
					}

					
				}
			}else{
				$retorno = 0;
			}
			consulta_limpa($res_nota);
			return $retorno;
		}

		function nota_fiscal_importa_arquivo_nf_retorno($arquivo,$filt_serie){
			$retorno = '';
			$retorno_nf = '';
			if (file_exists($arquivo)){
				$diretorio = dirname($arquivo);
				$nm_arquivo = str_replace($diretorio.'\\','',$arquivo);
				$nm_arquivo = str_replace($diretorio.'/','',$nm_arquivo);

				$xml = new XML();
				$xml->fromFile($diretorio,$nm_arquivo,true);

				$status='';
				$nr_lote = '';
				$obs = '';
				$tipo = '';
				$descricao = '';
				$desc_status = '';
				$dt_envio = '';
				$dt_receb = '';
				$empresa_cnpj = '';
				$empresa_logado_cnpj = '';
				$nr_nota = 0;
				$serie = '';
				$hora_envio = '';
				$hora_receb = '';

				if ($xml->root->name == 'lote'){
					foreach($xml->root->childs as $key => $value){
					if ($xml->root->childs[$key]->name == 'prestador'){
						$prestador = &$xml->root->childs[$key];
						foreach($prestador->atts as $key2 => $value2){
							if ($prestador->atts[$key2]->name == 'documento'){
								$empresa_cnpj = $prestador->atts[$key2]->value;
							}
						}
					}
				}

				$con_empresa = 'SELECT CPF_CNPJ FROM pessoa '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);
				$empresa_cnpj = mcpf($empresa_cnpj);

				if($reg_empresa[0]!=$empresa_cnpj){
					$retorno = 4; //No foi possivel acessar o arquivo XML
				}else {
					foreach($xml->root->atts as $key => $value){
						if ($xml->root->atts[$key]->name == 'numero'){
							$nr_lote = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'tipo'){
							$tipo = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'data_envio'){
							$dh_envio = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'data_processamento'){
							$dh_receb = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'descricao_status'){
							$des_status = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'observacao'){
							$obs = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'status'){
							$status = $xml->root->atts[$key]->value;
						}
						if ($xml->root->atts[$key]->name == 'descricao_status'){
							$desc_status = $xml->root->atts[$key]->value;
						}
					}

					//Verificar se o cpf_cnpj  igual a empresa logado
					//se for != (echo mostra q nao foi possivel acessar o arquivo)
					//se (empresa) == faz uma consulta no banco de dados para identificar este numero
					// de lote para a mesma seria
					//se nao tiver nenhum registro retorna mensagem de erro.
					//filtros(serie, numero_lote, NFSe_Nr = '')
					//se nro_reg > 0 processa e senao nao faz nada.

					if($status!=1){
						//Limpa o nr lote
						$upd_nota = 'UPDATE nota_fiscal SET'.
									' NFSe_Lote="" '.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
									' AND Modelo="'.base64_decode_si($filt_serie).'" '.
									' AND NFSe_Lote="'.$nr_lote.'"'.
									' AND NFSe_Nr=""';
						$res_upd = consulta_sql($upd_nota,true,1);
						$retorno = $obs;
					}else{
						foreach($xml->root->childs as $key => $value){
							if ($xml->root->childs[$key]->name == 'rps'){
								$rps = &$xml->root->childs[$key];
								foreach($rps->atts as $key3 => $value3){
									if ($rps->atts[$key3]->name == 'numero'){
										$nr_rps = $rps->atts[$key3]->value;
									}
									if ($rps->atts[$key3]->name == 'serie'){
										$serie = $rps->atts[$key3]->value;
									}
									if ($rps->atts[$key3]->name == 'nfem_numero'){
										$nr_nota = $rps->atts[$key3]->value;
									}
									if ($rps->atts[$key3]->name == 'nfem_codigo_verificacao'){
										$cod_ver = $rps->atts[$key3]->value;
									}
								}
								//consulta a serie e valida
								$con_nota = 'SELECT * FROM nota_fiscal '.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
											' AND Modelo="'.base64_decode_si($filt_serie).'"'.
											//' AND Nr_Nota="'.$nr_nota.'"'.
											' AND NrDoc="'.$nr_rps.'"'.
											' AND Situacao<>"E"';
								$res_nota = consulta_sql($con_nota);
								$reg_nota = consulta_ler_objeto($res_nota);
								consulta_limpa($res_nota);

								if($reg_nota->Serie!=$serie){
									return 2; //Serie diferente
								}else {
									$upd_nota = 'UPDATE nota_fiscal SET'.
												' NFSe_Lote_DH_Envio="'.$dh_envio.'", '.
												' NFSe_Lote_DH_Processado="'.$dh_receb.'", '.
												' NFSe_Nr="'.$nr_nota.'", '.
												' NFSe_Chave="'.$cod_ver.'" '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Empresa="'.$reg_nota->Empresa.'"'.
												' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
									$res_upd = consulta_sql($upd_nota,true,1);

									$retorno_nf.= $reg_nota->Nr_Nota.';';

									//UPDATE no contas a receber
									//mudar NR doc para o nr da NFSe
									if(($nr_nota>0)&&($nr_nota!='')){
										if ($_SESSION['Dominio']!=99){
											$con_upt = 'UPDATE contas_pr SET'.
														' Nr_Doc="'.$nr_nota.'", '.
														' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
														' AND Empresa="'.$reg_nota->Empresa.'"'.
														' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
														' AND Modelo="'.$reg_nota->Modelo.'"'.
														' AND TipoPR="R"';
											consulta_sql($con_upt);
										}
										
									}

									if($res_upd==0){
										echo 'O retorno do RPS('.$nr_rps.') j foi processado! ';
										echo '<BR>';
									}else {
										echo 'O retorno do RPS('.$nr_rps.') foi importado! ';
										echo '<BR>';
									}
									$retorno = 1;
								}
							}
						}
					}
				}
			}else if ($xml->root->name == 'ConsultarLoteRpsResponse'){

				$valores_r['Numero'] = '';
				$valores['Numero'] = '';

				foreach($xml->root->childs as $key => $value){
					if ($xml->root->childs[$key]->name == 'ConsultarLoteRpsResult'){
						$nivel_1 = &$xml->root->childs[$key];
						foreach($nivel_1->childs as $key2 => $value2){
							if ($nivel_1->childs[$key2]->name == 'ListaNfse'){
								$nivel_2 = &$nivel_1->childs[$key2];
								foreach($nivel_2->childs as $key3 => $value3){
									if ($nivel_2->childs[$key3]->name == 'CompNfse'){
										$nivel_3 = &$nivel_2->childs[$key3];
										foreach($nivel_3->childs as $key4 => $value4){
											if ($nivel_3->childs[$key4]->name == 'tcCompNfse'){
												$nivel_4 = &$nivel_3->childs[$key4];
												foreach($nivel_4->childs as $key5 => $value5){
													if ($nivel_4->childs[$key5]->name == 'Nfse'){
														$nivel_5 = &$nivel_4->childs[$key5];
														foreach($nivel_5->childs as $key6 => $value6){
															if ($nivel_5->childs[$key6]->name == 'InfNfse'){
																$nivel_6 = &$nivel_5->childs[$key6];
																foreach($nivel_6->atts as $key6a => $value6a){
																	$valores[$nivel_6->atts[$key6a]->name] = $nivel_6->atts[$key6a]->value;
																}
																foreach($nivel_6->childs as $key7 => $value7){
																	if ($nivel_6->childs[$key7]->name == 'IdentificacaoRps'){
																		$nivel_7a = &$nivel_6->childs[$key7];
																		foreach($nivel_7a->atts as $key7a => $value7a){
																			$valores_r[$nivel_7a->atts[$key7a]->name] = $nivel_7a->atts[$key7a]->value;
																		}
																	}
																	if ($nivel_6->childs[$key7]->name == 'PrestadorServico'){
																		$nivel_7 = &$nivel_6->childs[$key7];
																		foreach($nivel_7->childs as $key8 => $value8){
																			if ($nivel_7->childs[$key8]->name == 'IdentificacaoPrestador'){
																				$nivel_8 = &$nivel_7->childs[$key8];
																				foreach($nivel_8->atts as $key9 => $value9){
																					if ($nivel_8->atts[$key9]->name == 'Cnpj'){
																						$empresa_cnpj = $nivel_8->atts[$key9]->value;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}

				//print_r($valores);
				//print_r($valores_r);

				$con_empresa = 'SELECT CPF_CNPJ FROM pessoa '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);

				$empresa_cnpj = mcpf($empresa_cnpj);

				if($reg_empresa[0]!=$empresa_cnpj){
					$retorno = 4; //No foi possivel acessar o arquivo XML
				}else{
					if($valores_r['Numero']!=''){
						//consulta a serie e valida
						$con_nota = 'SELECT * FROM nota_fiscal '.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Modelo="'.base64_decode_si($filt_serie).'"'.
									//' AND Nr_Nota="'.$nr_nota.'"'.
									' AND NrDoc="'.$valores_r['Numero'].'"'.
									' AND Situacao<>"E"';
						$res_nota = consulta_sql($con_nota);
						$reg_nota = consulta_ler_objeto($res_nota);
						consulta_limpa($res_nota);

						if($reg_nota->Serie!=$valores_r['Serie']){
							return 2; //Serie diferente
						}else {
							$upd_nota = 'UPDATE nota_fiscal SET'.
										' NFSe_Lote_DH_Envio="'.$valores['DataEmissao'].'", '.
										' NFSe_Lote_DH_Processado="'.$valores['DataEmissao'].'", '.
										' NFSe_Nr="'.$valores['Numero'].'", '.
										' NFSe_Chave="'.$valores['CodigoVerificacao'].'" '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
							$res_upd = consulta_sql($upd_nota,true,1);

							$retorno_nf.= $reg_nota->Nr_Nota.';';

							//UPDATE no contas a receber
							//mudar NR doc para o nr da NFSe
							if(($valores['Numero']>0)&&($valores['Numero']!='')){
								if ($_SESSION['Dominio']!=99){
									$con_upt =  'UPDATE contas_pr SET'.
												' Nr_Doc="'.$valores['Numero'].'", '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Empresa="'.$reg_nota->Empresa.'"'.
												' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
												' AND Modelo="'.$reg_nota->Modelo.'"'.
												' AND TipoPR="R"';
									consulta_sql($con_upt);
								}
							}

							if($res_upd==0){
								echo 'O retorno do RPS('.$valores_r['Numero'].') j foi processado! ';
								echo '<BR>';
							}else {
								echo 'O retorno do RPS('.$valores_r['Numero'].') foi importado! ';
								echo '<BR>';
							}
							$retorno = 1;
						}
					}else{
						$retorno = 2;
					}
				}
			}else if ($xml->root->name == 'ConsultarNfseResposta'){
				$valores_r['Numero'] = '';
				$valores['Numero'] = '';
				$num=0;
				foreach($xml->root->childs as $key => $value){
					if ($xml->root->childs[$key]->name == 'ListaNfse'){
						$nivel_1 = &$xml->root->childs[$key];
						foreach($nivel_1->childs as $key2 => $value2){
							if ($nivel_1->childs[$key2]->name == 'CompNfse'){
								$nivel_2 = &$nivel_1->childs[$key2];
								foreach($nivel_2->childs as $key3 => $value3){
									if ($nivel_2->childs[$key3]->name == 'Nfse'){
										$nivel_3 = &$nivel_2->childs[$key3];
										foreach($nivel_3->childs as $key4 => $value4){
											if ($nivel_3->childs[$key4]->name == 'InfNfse'){
												$nivel_4 = &$nivel_3->childs[$key4];
												foreach($nivel_4->atts as $key4a => $value6a){
													$valores[$num][$nivel_4->atts[$key4a]->name] = $nivel_4->atts[$key4a]->value;
												}
												foreach($nivel_4->childs as $key5 => $value5){
													if ($nivel_4->childs[$key5]->name == 'IdentificacaoRps'){
														$nivel_5a = &$nivel_4->childs[$key5];
														foreach($nivel_5a->atts as $key5a => $value5a){
															$valores_r[$num][$nivel_5a->atts[$key5a]->name] = $nivel_5a->atts[$key5a]->value;
														}
													}
													if ($nivel_4->childs[$key5]->name == 'PrestadorServico'){
														$nivel_5 = &$nivel_4->childs[$key5];
														foreach($nivel_5->childs as $key6 => $value6){
															if ($nivel_5->childs[$key6]->name == 'IdentificacaoPrestador'){
																$nivel_6 = &$nivel_5->childs[$key6];
																foreach($nivel_6->atts as $key7 => $value7){
																	if ($nivel_6->atts[$key7]->name == 'Cnpj'){
																		$empresa_cnpj = $nivel_6->atts[$key7]->value;
																	}
																}
															}
														}
													}
												}
												$num++;
											}
										}
									}
								}
							}
						}
					}
				}

				$con_empresa =  'SELECT CPF_CNPJ FROM pessoa '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);

				$empresa_cnpj = mcpf($empresa_cnpj);

				if($reg_empresa[0]!=$empresa_cnpj){
					$retorno = 4; //No foi possivel acessar o arquivo XML
				}else{
					foreach($valores_r as $chave => $valor){
						$lista_nf = $valores_r[$chave];
						$lista_doc = $valores[$chave];

						if($lista_nf['Numero']!=''){
							//consulta a serie e valida
							$con_nota = 'SELECT * FROM nota_fiscal '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
										' AND Modelo="'.base64_decode_si($filt_serie).'"'.
										' AND Serie="'.trim($lista_nf['Serie']).'"'.
										//' AND Nr_Nota="'.$nr_nota.'"'.
										' AND NrDoc="'.$lista_nf['Numero'].'"'.
										' AND Situacao<>"E"';
							$res_nota = consulta_sql($con_nota);
							$reg_nota = consulta_ler_objeto($res_nota);
							consulta_limpa($res_nota);

							if($reg_nota->Serie!=trim($lista_nf['Serie'])){
								//return 2; //Serie diferente
								echo 'O retorno do RPS('.$lista_nf['Numero'].')  inconsistente! Srie Invlida! ';
								echo '<BR>';
							}else {
								$upd_nota = 'UPDATE nota_fiscal SET'.
											' NFSe_Lote_DH_Envio="'.$lista_doc['DataEmissao'].'", '.
											' NFSe_Lote_DH_Processado="'.$lista_doc['DataEmissao'].'", '.
											' NFSe_Nr="'.$lista_doc['Numero'].'", '.
											' NFSe_Chave="'.$lista_doc['CodigoVerificacao'].'" '.
											' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
											' AND Empresa="'.$reg_nota->Empresa.'"'.
											' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
											' AND Modelo="'.$reg_nota->Modelo.'"'.
											' AND Serie="'.$reg_nota->Serie.'"';
								$res_upd = consulta_sql($upd_nota,true,1);
								$retorno_nf.= $reg_nota->Nr_Nota.';';
								//UPDATE no contas a receber
								//mudar NR doc para o nr da NFSe
								if(($lista_doc['Numero']>0)&&($lista_doc['Numero']!='')){
									if ($_SESSION['Dominio']!=99){
										$con_upt = 'UPDATE contas_pr SET'.
													' Nr_Doc="'.$lista_doc['Numero'].'", '.
													' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
													' AND Empresa="'.$reg_nota->Empresa.'"'.
													' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
													' AND Modelo="'.$reg_nota->Modelo.'"'.
													' AND Serie="'.$reg_nota->Serie.'"'.
													' AND TipoPR="R"';
										consulta_sql($con_upt);
									}
								}

								if($res_upd==0){
									echo 'O retorno do RPS('.$lista_nf['Numero'].') j foi processado! ';
									echo '<BR>';
								}else {
									echo 'O retorno do RPS('.$lista_nf['Numero'].') foi importado! ';
									echo '<BR>';
								}
								$retorno = 1;
							}
						}else{
							//$retorno = 2;
							echo 'O retorno do RPS('.$lista_nf['Numero'].')  inconsistente! Nmero Invlido! ';
							echo '<BR>';
						}
					}
				}
			}else{ //Fim Lote
				$retorno = 3; // Falha na leitura do lote XML de Nota de servico Eletronico
			}
		}
		$retorno_novo['cod'] = $retorno;
		$retorno_novo['nfs'] = $retorno_nf;

		return $retorno_novo;
	}


	function nota_fiscal_gera_arquivo_nf_servico_envio($filt_serie,$lista_notas,$usuario,$operacao="I"){
		$con_serie= 'SELECT Layout_Impressao FROM nota_fiscal_serie '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
					' AND Modelo="'.base64_decode_si($filt_serie).'"';
		$res_serie = consulta_sql($con_serie);
		$reg_serie = consulta_ler_linha($res_serie);
		consulta_limpa($res_serie);
		
		$Layout = $reg_serie[0];

		$str_lista_nfs='';
		$lista_nfs = explode(';',$lista_notas);
		foreach($lista_nfs as $key => $nr_nota){
			if ($nr_nota!=''){
				if ($str_lista_nfs!=''){
					$str_lista_nfs.=',';
				}
				$str_lista_nfs.= $nr_nota;
			}
		}
		if ($str_lista_nfs==''){
			$str_lista_nfs = 'Nr_Nota<0';
		}else{
			$str_lista_nfs = 'Nr_Nota in ('.$str_lista_nfs.')';
		}

		$con_nota = 'SELECT * FROM nota_fiscal '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Modelo="'.base64_decode_si($filt_serie).'"'.
					' AND '.$str_lista_nfs;
		$notas_autorizadas = '';

		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		if ($nrw_nota==0){
			echo '<font size="3" face="Verdana">Nenhuma Nota Fiscal localizada!</font><br>';
			return '';
		}

		for($nf=0;$nf<$nrw_nota;$nf++){
			$reg_nota = consulta_ler_objeto($res_nota);
			if ($operacao=='I'){
				echo '<font size="3" face="Verdana"><b>Enviando o RPS '.$reg_nota->NrDoc.'...<b></font><br><br>';
			}else{
				echo '<font size="3" face="Verdana"><b>Enviando Cancelamento do RPS '.$reg_nota->NrDoc.' - Nr NF '.$reg_nota->NFSe_Nr.'...<b></font><br><br>';
			}
			flush(); @ob_flush();
        	flush(); @ob_flush();

			if ($operacao=='I'){
				$up_nota_p= 'UPDATE nota_fiscal SET'.
							' Situacao="I", '.
							' UsuarioVenda="'.base64_decode_si($_SESSION['USER_ID']).'"'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'" '.
							' AND Empresa="'.$reg_nota->Empresa.'" '.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" '.
							' AND ((Situacao="P") AND (Situacao="A"))';
				consulta_sql($up_nota_p,true,1);
			}
			if ($Layout==13){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_araquari($filt_serie,$reg_nota,$operacao);
			}else if ($Layout==15){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_itanhaem($filt_serie,$reg_nota,$operacao);
			}else if ($Layout==16){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_jaragua_do_sul($reg_nota,$operacao);
			}else if ($Layout==17){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_joinville($reg_nota,$operacao);
			}else if ($Layout==21){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_brasilia($reg_nota,$operacao);
			}else if ($Layout==22){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_araucaria_ws($reg_nota,$operacao);
			}else if ($Layout==6){
				$ret = nota_fiscal_gera_arquivo_nf_servico_envio_araucaria($filt_serie,$reg_nota,$operacao);
			}else{
				echo '<font size="3" face="Verdana"><b>Envio do RPS no realizado! Layout '.$Layout.' Invlido!<b></font><br>';
				$ret = 2;
			}
			if ($ret==1){
				if ($operacao=='I'){
					echo '<font size="3" face="Verdana">NFS-e do RPS '.$reg_nota->NrDoc.' emitida com sucesso!</font><br>';
				}else{
					echo '<font size="3" face="Verdana">NFS-e '.$reg_nota->NFSe_Nr.' (RPS '.$reg_nota->NrDoc.') cancelada com sucesso!</font><br>';
				}
				$notas_autorizadas.= $reg_nota->Nr_Nota.';';

				//fecha nota fiscal
				if ($operacao=='I'){
					//volta status pra P
					$up_nota_p= 'UPDATE nota_fiscal SET'.
					 			' Situacao="P", '.
					 			' UsuarioVenda="'.base64_decode_si($_SESSION['USER_ID']).'"'.
					 			' WHERE Dominio="'.$_SESSION['Dominio'].'" '.
					 			' AND Empresa="'.$reg_nota->Empresa.'" '.
					 			' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" '.
					 			' AND Situacao="I"';
					consulta_sql($up_nota_p,true,1);
					nota_fiscal_fecha_nota_normal($reg_nota->Nr_Nota,'S',$usuario);
				}else{
					//cancela nota (no faz nada a rotina de cancelamento vai fazer tudo
				}
			}else if ($ret==0){
				if ($operacao=='I'){
					echo '<font size="3" face="Verdana"><b>NFS-e do RPS '.$reg_nota->NrDoc.' no foi emitida!</b></font><br>';
				}else{
					echo '<font size="3" face="Verdana"><b>Cancelamento da NFS-e '.$reg_nota->NFSe_Nr.' no realizado!</b></font><br>';
				}

				if (($reg_serie[0]==16)||
					($reg_serie[0]==17)||
					($reg_serie[0]==21)||
					($reg_serie[0]==22)){
					if ($operacao=='I'){
						//volta status pra P
						nfse_retorna_nfse2($reg_nota->Nr_Nota,$operacao);
						$up_nota_p= 'UPDATE nota_fiscal SET'.
									' Situacao="P" '.
									//' UsuarioVenda="'.base64_decode_si($_SESSION['USER_ID']).'"'.
									' WHERE Dominio="'.$_SESSION['Dominio'].'" '.
									' AND Empresa="'.$_SESSION['Empresa_Codigo'].'" '.
									' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" '.
									' AND Situacao="I"';
						consulta_sql($up_nota_p,true,1);
					}
				}
			}//retrio 2 no exibe nada pois j fez
		}
		consulta_limpa($res_nota);
		//if ($notas_autorizadas!='')
		return $notas_autorizadas;
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_araquari($filt_serie,$reg_nota,$operacao="I"){
		$retorno = 0;
		$salvou = false;

		//valida se situao da nota est correta
		$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
		$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-rps.xml";
		if ($operacao=='C'){
			$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-can.xml";
		}

		$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$reg_nota->NFSe_Lote;
		$nr_lote = $reg_nota->NFSe_Lote;

		if (($reg_nota->Situacao!='I')&&($reg_nota->Situacao!='P')&&($operacao=="I")){
			echo '<font size="2" face="Verdana">FRE-821 - Envio do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else if (($reg_nota->Situacao!='F')&&($operacao=="C")){
			echo '<font size="2" face="Verdana">FRE-822 - Cancelamento do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else{
			$sit_atual = $reg_nota->Situacao;
			//se for I verifica se retorno j est na pasta,
			if (($operacao=="I") && ($sit_atual=='I')){
				//caso no esteja, muda o status pra P
				if (file_exists($caminho_r.'/s_'.$nome_arq)){
					//caso esteja no faz nada, s pega o retorno
					$salvou = true;
				}else{
					$sit_atual='P';
				}
			}
			if (($operacao=="C") && ($sit_atual=='F')){
				$sit_atual='P';
			}
			//se situacao for P
			if ($sit_atual=='P'){
				//muda o lote
				echo '<font size="2" face="Verdana">Gerando arquivo de Envio!</font><br>';

				$con_serie= 'SELECT'.
							' max(NFSe_Lote),'.
							' Layout_Impressao'.
							' FROM nota_fiscal_serie '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_serie = consulta_sql($con_serie);
				$reg_serie = consulta_ler_linha($res_serie);
				consulta_limpa($res_serie);

				$nr_lote = ($reg_serie[0]+1);

				$upd_nota_serie='UPDATE nota_fiscal_serie SET'.
								' NFSe_Lote="'.$nr_lote.'" '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
								' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_nota_serie = consulta_sql($upd_nota_serie,true,1);


				if ($operacao=="I"){
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote="'.$nr_lote.'", '.
								' Layout_Impressao="'.$reg_serie[1].'" '.
								' NFSe_Versao="1.0", '.
								' NFSe_Lote_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);

					//muda o status da nota pra I
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' Situacao="I" '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Situacao="P"';
					consulta_sql($upd_nota);
				}else{
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote_C="'.$nr_lote.'", '.
								' NFSe_Lote_C_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);
				}
				//precisa criar o arquivo XML
				$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
				$caminho_e="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/rps";
				$caminho_t="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/tmp";
				$caminho_err="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/erro";

				//$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-nfse.xml";
				$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$nr_lote;
				//cria objeto xml
				$xml = new XML("1.0","ISO-8859-1");
				$nfse = &$xml->createRoot("nfse");
				$nfse->addAttribute('id', 'nota', true);   //somente se tiver assinatura digital ??

				/*
				$rps = &$nfse->addChild("rps");
				$rps->addAttribute('nro_recibo_provisorio', $reg_nota->NrDoc, false);
				$rps->addAttribute('serie_recibo_provisorio', $reg_nota->Serie, false);
				$rps->addAttribute('data_emissao_recibo_provisorio', dataf($reg_nota->DH_Emissao), false);
				$rps->addAttribute('hora_emissao_recibo_provisorio', substr($reg_nota->DH_Emissao,11,8), false);
				*/

				$nf = &$nfse->addChild("nf");
				if ($operacao=="C"){
					$nf->addAttribute('numero', $reg_nota->NFSe_Nr, false);
					$nf->addAttribute('situacao', 'C', false);
				}

				//consulta empresa cnpj nome
				$con_empresa =  'SELECT'.
								' CPF_CNPJ,'.
								' Nome_Razao'.
								' FROM pessoa '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);
				$cnpj = limpa_numero($reg_empresa[0]);


				$con_end_emp =  'SELECT'.
								' Insc_Municipal,'.
								' CEP,'.
								' Logradouro,'.
								' Numero,'.
								' Bairro,'.
								' Complemento,'.
								' UF,'.
								' Codigo_Cidade,'.
								' Nome_Cidade,'.
								' CNAE_Municipal'.
								' FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Situacao<>"E"'.
								' ORDER BY Seq_Endereco limit 1';
				$res_end_emp = consulta_sql($con_end_emp);
				$reg_end_emp = consulta_ler_linha($res_end_emp);
				consulta_limpa($res_end_emp);

				$cidade_prest = busca_codigo_cidade_siafi($reg_end_emp[7]);

				$prestador = &$nfse->addChild("prestador");
				$prestador->addAttribute('cpfcnpj', $cnpj, false);
				$prestador->addAttribute('cidade', $cidade_prest, false);


				$tomador = &$nfse->addChild("tomador");
				if ($operacao!="C"){
					$tomador->addAttribute('endereco_informado', '1', false);
				}

				$con_tom =  'SELECT'.
							' CPF_CNPJ,'.
							' Nome_Razao,'.
							' EMail,'.
							' RG,'.
							' Nome_Fantasia'.
							' FROM pessoa '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							' AND Pessoa="'.$reg_nota->Destinatario.'"';
				$res_tom = consulta_sql($con_tom);
				$reg_tom = consulta_ler_linha($res_tom);
				consulta_limpa($res_tom);

				$con_end_tom =  'SELECT'.
								' Insc_Municipal,'.
								' CEP,'.
								' Logradouro,'.
								' Numero,'.
								' Bairro,'.
								' Complemento,'.
								' UF,'.
								' Codigo_Cidade,'.
								' Nome_Cidade,'.
								' Insc_Estadual,'.
								' Nome_Pais,'.
								' Ponto_Referencia'.
								' FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
				$res_end_tom = consulta_sql($con_end_tom);
				$reg_end_tom = consulta_ler_linha($res_end_tom);
				consulta_limpa($res_end_tom);

				$cnpj_tom = limpa_numero($reg_tom[0]);

				if ($reg_end_tom[6]=='EX'){
					$tipo_fj = 'E';
				}else if(strlen($cnpj_tom)==11){
					$tipo_fj = 'F';
				}else{
					$tipo_fj = 'J';
				}

				$tomador->addAttribute('tipo', $tipo_fj, false);

				if ($tipo_fj=='E'){
					$tomador->addAttribute('identificador', $reg_tom[3], false);
					$tomador->addAttribute('estado', 'EXTERIOR', false);
					$tomador->addAttribute('pais', $reg_end_tom[10], false);
					$tomador->addAttribute('cpfcnpj', '99999999999', false);
				}else{
					$tomador->addAttribute('cpfcnpj', $cnpj_tom, false);
				}
				$tomador->addAttribute('ie', substr(limpa_numero2($reg_end_tom[9]),0,14), false);

				$tomador->addAttribute('nome_razao_social', substr(trim(UpperDados($reg_tom[4])),0,100), false);
				if ( substr(trim(UpperDados($reg_tom[1])),0,100) != substr(trim(UpperDados($reg_tom[1])),0,100)){
					if ($tipo_fj == 'J'){
						$tomador->addAttribute('sobrenome_nome_fantasia', substr(trim(UpperDados($reg_tom[4])),0,100), false);
					}else{
						$tomador->addAttribute('sobrenome_nome_fantasia', '', false);
					}
				}else{
					$tomador->addAttribute('sobrenome_nome_fantasia', '', false);
				}
				$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,70);
				$tomador->addAttribute('logradouro', $end_endereco, false);

				$tomador->addAttribute('email', substr(trim($reg_tom[2]),0,100), false);

				$end_num = substr(limpa_numero($reg_end_tom[3]),0,8);
				$tomador->addAttribute('numero_residencia', $end_num, false);

				$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,50);
				$tomador->addAttribute('complemento', $end_comp, false);

				$end_ref = substr(trim(UpperDados($reg_end_tom[6])),0,100);
				$tomador->addAttribute('ponto_referencia', $end_ref, false);

				$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,30);
				$tomador->addAttribute('bairro', $end_bairro, false);

				if ($tipo_fj=='E'){
					$end_munic = substr(trim(UpperDados($reg_end_tom[8])),0,100);
				}else{
					$end_munic = busca_codigo_cidade_siafi($reg_end_tom[7]);
					$tomador->addAttribute('cidade', $end_munic, false);
				}

				$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
				$tomador->addAttribute('cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);

				//ddd_fone_comercial
				//fone_comercial

				//ddd_fone_residencial
				//fone_residencial

				//ddd_fax
				//fone_fax

				$con_tom_tel =  'SELECT Numero_Telefone FROM pessoa_telefone '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
								' AND Situacao<>"E" ';
				$res_tom_tel = consulta_sql($con_tom_tel);
				$reg_tom_tel = consulta_ler_linha($res_tom_tel);
				consulta_limpa($res_tom_tel);

				$nr_fone = limpa_numero($reg_tom_tel[0]);
				$ddd_fone = '';
				if ((strlen($nr_fone)==10)||(strlen($nr_fone)==11)){
					$ddd_fone = substr($nr_fone,0,2);
					$nr_fone = substr($nr_fone,2,9);
				}else if (strlen($nr_fone)>=12){
					$ddd_fone = substr($nr_fone,0,3);
					$nr_fone = substr($nr_fone,3,9);
				}else{
					$nr_fone = substr($nr_fone,0,9);
				}

				$tomador->addAttribute('ddd_fone_comercial', $ddd_fone, false);
				$tomador->addAttribute('fone_comercial', $nr_fone, false);

				$tomador->addAttribute('ddd_fone_residencial', '', false);
				$tomador->addAttribute('fone_residencial', '', false);

				$tomador->addAttribute('ddd_fax', '', false);
				$tomador->addAttribute('fone_fax', '', false);


				$t_itens = &$nfse->addChild('itens');

				$con_itens= 'SELECT * FROM nota_fiscal_item'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Prod_Depart=0'.
							' ORDER BY Seq_Item';
				$res_itens = consulta_sql($con_itens);
				$nrw_itens = consulta_num_registros($res_itens);

				$lista_desc_total = '';
				$cidade_fg = $reg_nota->Cidade_FG;
				$total_retido = 0;

				for($itens=0;$itens<$nrw_itens;$itens++){
					$reg_itens = consulta_ler_objeto($res_itens);

					$lista_itens = &$t_itens->addChild('lista');
					$cidade_fg = $reg_nota->Cidade_FG;
					if ($reg_itens->ISS_Cidade_FG!=''){
						$cidade_fg = $reg_itens->ISS_Cidade_FG;
					}
					$fg_munic = busca_codigo_cidade_siafi($cidade_fg);
					if ($fg_munic==$cidade_prest){
						$trib_muni = 'S';
					}else{
						$trib_muni = 'N';
					}
					if($reg_itens->ISS_CST=='I'){
						$trib_muni = 'N';
					}

					$lista_itens->addAttribute('tributa_municipio_prestador', $trib_muni, false);
					$lista_itens->addAttribute('codigo_local_prestacao_servico', $fg_munic, false);
					$lista_itens->addAttribute('unidade_codigo', '', false);
					//$lista_itens->addAttribute('unidade_quantidade', pt2vr(nfe_numero($reg_itens->Quantidade_Estoque,3)), false);
					//$lista_itens->addAttribute('unidade_valor_unitario', pt2vr(nfe_numero($reg_itens->Valor_Unitario,2)), false);

					$lista_itens->addAttribute('unidade_quantidade', '', false);  //segundo o exemplo nao preenche
					$lista_itens->addAttribute('unidade_valor_unitario', '', false); //segundo o exemplo nao preenche
					$lista_itens->addAttribute('codigo_item_lista_servico', limpa_numero($reg_itens->Servico_Codigo), false);
					$lista_desc = nfe_formata_txt($reg_itens->Observacao);

					$con_obs =  'SELECT * FROM nota_fiscal_obs'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
								' GROUP BY Texto_Completo'.
								' ORDER BY Seq_Obs';
					$res_obs = consulta_sql($con_obs);
					$nrw_obs = consulta_num_registros($res_obs);
					for($obss=0;$obss<$nrw_obs;$obss++){
						$reg_obs = consulta_ler_objeto($res_obs);
						if ($reg_obs->Seq_Obs==23){
							//esse vai pro total  (valor aprox tributos so no ultimo item)
							$lista_desc_total = nfe_formata_txt($reg_obs->Texto_Completo);
						}else{
							if ($lista_desc!=''){
								$lista_desc.=';';
							}
							$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
						}
					}
					consulta_limpa($res_obs);

					$lista_desc = str_replace(";","&amp;lt;br&amp;gt;",$lista_desc);
					$lista_itens->addAttribute('descritivo', substr($lista_desc,0,1000), false);
					$lista_itens->addAttribute('aliquota_item_lista_servico', pt2vr(nfe_numero($reg_itens->ISS_Aliquota,2)), false);

					$situacao_tributaria = '0';
					$valor_retido = 0;
					if($reg_itens->ISS_CST=='R'){
						$situacao_tributaria = 1;
						$valor_retido = $reg_itens->ISS_Valor;
					}
					if($reg_itens->ISS_CST=='S'){
						$situacao_tributaria = 2;
					}
					if($reg_itens->ISS_CST=='I'){
						$situacao_tributaria = 6;
					}
					$lista_itens->addAttribute('situacao_tributaria', $situacao_tributaria, false);
					if ($reg_itens->ISS_BC<=0){
						$lista_itens->addAttribute('valor_tributavel', pt2vr(nfe_numero($reg_itens->Valor_Total,2)), false);
					}else{
						$lista_itens->addAttribute('valor_tributavel', pt2vr(nfe_numero($reg_itens->ISS_BC,2)), false);
					}
					$lista_itens->addAttribute('valor_deducao', pt2vr(nfe_numero($reg_itens->Valor_Desconto,2)), false);
					$lista_itens->addAttribute('valor_issrf', pt2vr(nfe_numero($valor_retido,2)), false);

					$total_retido+=$valor_retido;
				}
				consulta_limpa($res_itens);


				$vl_liquido = ($reg_nota->Total_NF-
								$reg_nota->Total_ISS_PIS_Valor-
								$reg_nota->Total_ISS_COFINS_Valor-
								$reg_nota->Total_Retido_PrevSocial_Valor-
								$reg_nota->Total_Retido_IRRF_Valor-
								$reg_nota->Total_IRRF_Valor-
								$reg_nota->Total_Retido_CSLL_Valor-
								$reg_nota->Total_CSLL_Valor-
								//$total_outros-
								$total_retido);

				$nf->addAttribute('valor_total', pt2vr(nfe_numero($vl_liquido,2)), false);

				$nf->addAttribute('valor_desconto', '0,00', false);
				$nf->addAttribute('valor_ir', pt2vr(($reg_nota->Total_Retido_IRRF_Valor+$reg_nota->Total_IRRF_Valor)), false);
				$nf->addAttribute('valor_inss', pt2vr($reg_nota->Total_Retido_PrevSocial_Valor), false);
				$nf->addAttribute('valor_contribuicao_social', pt2vr($reg_nota->Total_Retido_CSLL_Valor+$reg_nota->Total_CSLL_Valor), false);
				$nf->addAttribute('valor_rps', '0,00', false);
				$nf->addAttribute('valor_pis', pt2vr($reg_nota->Total_ISS_PIS_Valor), false);
				$nf->addAttribute('valor_cofins', pt2vr($reg_nota->Total_ISS_COFINS_Valor), false);
				if ($operacao=="C"){
					$nf->addAttribute('observacao', $reg_nota->Cancela_Motivo_Descricao, false);  //motivo do cancelamento ( na oprao C
				}else{
					$nf->addAttribute('observacao', '', false);  //reserva slot pra colocar no final
				}

				$con_obs =  'SELECT * FROM nota_fiscal_obs'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Seq_Item=0'.
							' AND Seq_Obs>3 '.
							' GROUP BY Texto_Completo'.
							' ORDER BY Seq_Obs';
				$res_obs = consulta_sql($con_obs);
				$nrw_obs = consulta_num_registros($res_obs);

				if (($lista_desc_total!='')||($nrw_obs>0)){
					$genericos = &$nfse->addChild('genericos');
				}

				if ($lista_desc_total!=''){
					$t_linha = &$genericos->addChild('linha');
					$t_linha->addAttribute('titulo', '', false);
					$t_linha->addAttribute('descricao', substr($lista_desc_total,0,200), false);
				}

				for($obss=0;$obss<$nrw_obs;$obss++){
					$reg_obs = consulta_ler_objeto($res_obs);

					$lista_desc_total =trim($reg_obs->Texto_Completo);
					$lista_desc_total = str_replace(";","&amp;lt;br&amp;gt;",$lista_desc_total);

					$t_linha = &$genericos->addChild('linha');
					$t_linha->addAttribute('titulo', '', false);
					$t_linha->addAttribute('descricao', substr($lista_desc_total,0,200), false);
				}
				consulta_limpa($res_obs);

				rmkdir($caminho_t.'/');

				//echo $caminho_t.'/', $nome_arq;
				$xml->toFile($caminho_t.'/', $nome_arq);
				$salvou = file_exists($caminho_t.'/'.$nome_arq);

			}
			//pegar da pasta de retorno

			if ($salvou){
				echo '<font size="2" face="Verdana">Transmitindo arquivo!</font><br>';
				//$ls_n = '';
				//$ls_n[0]=$reg_nota->Nr_Nota;;
				//$retorno = nfse_valida_lote($nome_arq,$ls_n[0],$operacao);
				$retorno = nfse_processa_araquari($nome_arq,$reg_nota,$operacao,$sit_atual);
			}else{
				echo '<font size="2" face="Verdana">FRE-823 - Falha ao gerar arquivo "'.$nome_arq.'" na pasta "'.$caminho_t.'"!</font><br>';
				nfse_retorna_nfse2($reg_nota->Nr_Nota,$operacao);
			}
		}
		return $retorno;
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_itanhaem($filt_serie,$reg_nota,$operacao="I"){
		$retorno = 0;
		$salvou = false;
		$status = '1';

		//valida se situao da nota est correta
		$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
		$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-rps.xml";
		if ($operacao=='C'){
			$status = '2';
			$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-can.xml";
		}

		$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$reg_nota->NFSe_Lote;
		$nr_lote = $reg_nota->NFSe_Lote;

		if (($reg_nota->Situacao!='I')&&($reg_nota->Situacao!='P')&&($operacao=="I")){
			echo '<font size="2" face="Verdana">FRE-821 - Envio do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else if (($reg_nota->Situacao!='F')&&($operacao=="C")){
			echo '<font size="2" face="Verdana">FRE-822 - Cancelamento do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else{
			$sit_atual = $reg_nota->Situacao;
			//se for I verifica se retorno j est na pasta,
			if (($operacao=="I") && ($sit_atual=='I')){
				//caso no esteja, muda o status pra P
				if (file_exists($caminho_r.'/s_'.$nome_arq)){
					//caso esteja no faz nada, s pega o retorno
					$salvou = true;
				}else{
					$sit_atual='P';
				}
			}
			if (($operacao=="C") && ($sit_atual=='F')){
				$sit_atual='P';
			}

			//se situacao for P
			if ($sit_atual=='P'){
				//muda o lote
				echo '<font size="2" face="Verdana">Gerando arquivo de Envio!</font><br>';
				$con_serie= 'SELECT'.
							' max(NFSe_Lote),'.
							' Layout_Impressao'.
							' FROM nota_fiscal_serie '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_serie = consulta_sql($con_serie);
				$reg_serie = consulta_ler_linha($res_serie);
				consulta_limpa($res_serie);
				$nr_lote = ($reg_serie[0]+1);
				$upd_nota_serie='UPDATE nota_fiscal_serie SET'.
								' NFSe_Lote="'.$nr_lote.'" '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
								' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_nota_serie = consulta_sql($upd_nota_serie,true,1);
				if ($operacao=="I"){
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote="'.$nr_lote.'", '.
								' Layout_Impressao="'.$reg_serie[1].'" '.
								' NFSe_Versao="1.0", '.
								' NFSe_Lote_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);

					//muda o status da nota pra I
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' Situacao="I" '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Situacao="P"';
					consulta_sql($upd_nota);
				}else{
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote_C="'.$nr_lote.'", '.
								' NFSe_Lote_C_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);
				}


				//precisa criar o arquivo XML
				$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
				$caminho_e="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/rps";
				$caminho_t="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/tmp";
				$caminho_err="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/erro";

				//$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-nfse.xml";

				$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$nr_lote;

				$con_empresa =  'SELECT'.
								' CPF_CNPJ,'.
								' Nome_Razao'.
								' FROM pessoa '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);
				$cnpj = limpa_numero($reg_empresa[0]);

				$con_end_emp =  'SELECT'.
								' Insc_Municipal,'.
								' CEP,'.
								' Logradouro,'.
								' Numero,'.
								' Bairro,'.
								' Complemento,'.
								' UF,'.
								' Codigo_Cidade,'.
								' Nome_Cidade,'.
								' CNAE_Municipal'.
								' FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Situacao<>"E"'.
								' ORDER BY Seq_Endereco limit 1';
				$res_end_emp = consulta_sql($con_end_emp);
				$reg_end_emp = consulta_ler_linha($res_end_emp);
				consulta_limpa($res_end_emp);
				$insc_munic = $reg_end_emp[0];
				$cnae_munic = $reg_end_emp[9];

				//cria objeto xml
				$xml = new XML("1.0","ISO-8859-1");

				$nfse = &$xml->createRoot("EnviarLoteRpsEnvio");
				//$nfse->addAttribute('id', 'nota', true);   //somente se tiver assinatura digital ??

				$lote_rps = &$nfse->addChild("LoteRps");
				//$lote_rps->addAttribute('Id', $nr_lote, true);
				$lote_rps->addAttribute('NumeroLote', $nr_lote, false);
				$lote_rps->addAttribute('Cnpj', $cnpj, false);
				$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
				$lote_rps->addAttribute('QuantidadeRps', 1, false); //sempre vai ser 1

				$lista_rps = &$lote_rps->addChild("ListaRps");
				$lista_nfs = '';

				if($operacao=="I"){
					$status = '1';
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote="'.$nr_lote.'", '.
								' NFSe_Versao="1.0", '.
								' NFSe_Lote_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND NFSe_Lote=""';
				}else{
					$status = '2';
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote_C="'.$nr_lote.'", '.
								' NFSe_Versao="1.0", '.
								' NFSe_Lote_C_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND NFSe_Lote_C=""';
				}

				$res_upd = consulta_sql($upd_nota,true,1);
				//$res_upd = 1;
				if($res_upd==1){
					$rps = &$lista_rps->addChild("Rps");
					$inf_dec = &$rps->addChild("InfDeclaracaoPrestacaoServico");

					$inf_rps = &$inf_dec->addChild("Rps");
					$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
					$ident_rps->addAttribute('Numero', $reg_nota->NrDoc, false);
					$ident_rps->addAttribute('Serie', $reg_nota->Serie, false);
					$ident_rps->addAttribute('Tipo', '1', false); //1 - RPS

					$data = str_replace(' ','T',$reg_nota->DH_Emissao);
					$inf_rps->addAttribute('DataEmissao', $data, false);
					$inf_rps->addAttribute('Status', $status, false);
					//RPS SUBSTITUIDO
					$con_ref = 'SELECT * FROM nota_fiscal_refenciada '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Tipo_Doc="N"'.
								' ORDER BY Seq_Doc '.
								' LIMIT 1 ';
					$res_ref = consulta_sql($con_ref);
					$nrw_ref = consulta_num_registros($res_ref);
					if($nrw_ref>0){
						$reg_ref = consulta_ler_objeto($res_ref);
						$sub_rps = &$inf_rps->addChild('RpsSubstituido');
						$sub_rps->addAttribute('Numero', $reg_ref->NF_Nr_Doc, false);
						$sub_rps->addAttribute('Serie', $reg_ref->NF_Serie, false);
						$sub_rps->addAttribute('Tipo', '1', false); //1 - RPS
					}
					consulta_limpa($res_ref);

					$competencia = datad(dataf($reg_nota->DH_Emissao));
					$inf_dec->addAttribute('Competencia', $competencia, false);

					$total_outros = 0;
					$con_itens= 'SELECT * FROM nota_fiscal_item'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Prod_Depart=0'.
								' ORDER BY Seq_Item';
					$res_itens = consulta_sql($con_itens);
					$nrw_itens = consulta_num_registros($res_itens);
					//para cada item da nota
					$lista_desc = '';
					$cidade = $reg_nota->Cidade_FG;
					$pais = '1058';
					$iss_aliq = 0;
					$iss_bc = 0;
					$total_iss = 0;
					$total_irrf = 0;
					$total_inss = 0;
					$total_pis = 0;
					$total_cofins = 0;
					$total_csll = 0;
					$total_retido = 0;

					for($itens=0;$itens<$nrw_itens;$itens++){
						$reg_itens = consulta_ler_objeto($res_itens);
						if ($lista_desc!=''){
							$lista_desc.=';';
						}
						$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
						if ($reg_itens->ISS_Cidade_FG!=''){
							$cidade = $reg_itens->ISS_Cidade_FG;
						}
						$iss_aliq = $reg_itens->ISS_Aliquota;
						if ($reg_itens->ISS_CST!='I'){
							$total_iss+= $reg_itens->ISS_BC;
						}
						$total_irrf+= $reg_itens->IRRF_Valor;
						$total_inss+= $reg_itens->PrevSocial_Valor;
						$total_pis+= $reg_itens-> PIS_Retido_Valor;
						$total_cofins+= $reg_itens->COFINS_Retido_Valor;
						$total_csll+= $reg_itens->CSLL_Valor;

						if($reg_itens->ISS_CST=='R'){
							$total_retido+= $reg_itens->ISS_Valor;
						}

						$con_obs =  'SELECT * FROM nota_fiscal_obs'.
									' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
									' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
									' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
									' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
									' GROUP BY Texto_Completo'.
									' ORDER BY Seq_Obs';
						$res_obs = consulta_sql($con_obs);
						$nrw_obs = consulta_num_registros($res_obs);
						for($obss=0;$obss<$nrw_obs;$obss++){
							$reg_obs = consulta_ler_objeto($res_obs);
							if ($lista_desc!=''){
								$lista_desc.=';';
							}
							$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
						}
						consulta_limpa($res_obs);
					}

					$con_obs =  'SELECT * FROM nota_fiscal_obs'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Seq_Item=0'.
								' AND Seq_Obs>3 '.
								' GROUP BY Texto_Completo'.
								' ORDER BY Seq_Obs';
					$res_obs = consulta_sql($con_obs);
					$nrw_obs = consulta_num_registros($res_obs);
					for($obss=0;$obss<$nrw_obs;$obss++){
						$reg_obs = consulta_ler_objeto($res_obs);
						if ($lista_desc!=''){
							$lista_desc.=';';
						}
						$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
					}
					consulta_limpa($res_obs);

					$venc = 'SELECT DT_Vencimento FROM nota_fiscal_parcela'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" ';
					$res_venc = consulta_sql($venc);
					$reg_venc = consulta_ler_linha($res_venc);
					consulta_limpa($res_venc);


					$lista_desc = str_replace(";","\r\n",$lista_desc);
					$lista_desc .= "\r\nVencimento: ".nfe_formata_txt(dataf($reg_venc[0]));

					$inf_serv = &$inf_dec->addChild('Servico');
					$inf_valores = &$inf_serv->addChild('Valores');

					$inf_valores->addAttribute('ValorServicos', nfe_numero($reg_nota->Total_Servicos,2), false);
					if($reg_nota->Total_Desconto>0){
						$inf_valores->addAttribute('ValorDeducoes', nfe_numero($reg_nota->Total_Desconto,2), false);
					}
					if($total_pis>0){
						$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
					}
					if($total_cofins>0){
						$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
					}
					if($total_inss>0){
						$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
					}
					if($total_irrf>0){
						$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
					}
					if($total_csll>0){
						$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
					}
					if($total_outros>0){
						$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
					}
					$vl_iss = nfe_numero(arredonda_numero_menos($total_iss * $iss_aliq)/100,2);
					if($vl_iss>0){
						$inf_valores->addAttribute('ValorIss', $vl_iss, false);
					}
					$iss_aliq = nfe_numero(($iss_aliq/100),2);
					if($iss_aliq>0){
						$inf_valores->addAttribute('Aliquota', $iss_aliq, false);
					}
					//$inf_valores->addAttribute('DescontoIncondicionado', nfe_numero(0,2), false);
					//$inf_valores->addAttribute('DescontoCondicionado', nfe_numero(0,2), false);
					if($reg_itens->ISS_CST=='R'){
						$inf_serv->addAttribute('IssRetido', '1', false);
						$inf_serv->addAttribute('ResponsavelRetencao', '1', false);
					}else {
						$inf_serv->addAttribute('IssRetido', '2', false);
					}
					$inf_serv->addAttribute('ItemListaServico', $reg_itens->Servico_Codigo, false);

					//$cnae_munic = limpa_numero($reg_end_emp[9]);
					$inf_serv->addAttribute('CodigoCnae', $cnae_munic, false);
					//$inf_serv->addAttribute('CodigoTributacaoMunicipio', $cnae_munic, false);
					$inf_serv->addAttribute('Discriminacao', trim(substr($lista_desc,0,2000)), false);
					$inf_serv->addAttribute('CodigoMunicipio', $cidade, false);
					$inf_serv->addAttribute('CodigoPais', $pais, false);

					$con_item = 'SELECT * FROM nota_fiscal_item'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Prod_Depart=0'.
								' ORDER BY Seq_Item LIMIT 1';
					$res_item = consulta_sql($con_item);
					$reg_item = consulta_ler_objeto($res_item);
					if($reg_item->ISS_CST=='I'){
						$sit_rps = '3';
					}else if(($reg_item->ISS_CST=='N')||($reg_item->ISS_CST=='S')||($reg_item->ISS_CST=='R')){
						if($reg_item->ISS_Cidade_FG!=''){
							if($reg_item->ISS_Cidade_FG != $reg_end_emp[7]){
								$sit_rps = '2';
							}else{
								$sit_rps = '1';
							}
						}else{
							$sit_rps = '1';
						}
					}
					consulta_limpa($res_item);
					$inf_serv->addAttribute('ExigibilidadeISS', $sit_rps, false);

					$inf_prest = &$inf_dec->addChild('Prestador');
					$inf_prest->addAttribute('Cnpj', limpa_numero($reg_empresa[0]), false);

					$prest_im = limpa_numero($reg_end_emp[0]);
					if($prest_im!=''){
						$inf_prest->addAttribute('InscricaoMunicipal', $insc_munic, false);
					}

					$con_tom =  'SELECT'.
								' CPF_CNPJ,'.
								' Nome_Razao,'.
								' EMail'.
								' FROM pessoa '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"';
					$res_tom = consulta_sql($con_tom);
					$reg_tom = consulta_ler_linha($res_tom);
					consulta_limpa($res_tom);

					$inf_tom = &$inf_dec->addChild('TomadorServico');
					if($reg_tom[0]!=''){
						$inf_idtom = &$inf_tom->addChild('IdentificacaoTomador');
						$inf_cpftom = &$inf_idtom->addChild('CpfCnpj');
						if(strlen(limpa_numero($reg_tom[0]))==11){
							$inf_cpftom->addAttribute('Cpf', limpa_numero($reg_tom[0]), false);
							if(limpa_numero($reg_tom[0])=='00000000000'){
								$nome_tomador = 'TOMADOR NO IDENTIFICADO';
								$informa_end = false;
							}else{
								$nome_tomador = $reg_tom[1];
								$informa_end = true;
							}
						}else if(strlen(limpa_numero($reg_tom[0]))==14){
							$inf_cpftom->addAttribute('Cnpj', limpa_numero($reg_tom[0]), false);
							if(limpa_numero($reg_tom[0])=='00000000000000'){
								$nome_tomador = 'TOMADOR NO IDENTIFICADO';
								$informa_end = false;
							}else{
								$nome_tomador = $reg_tom[1];
								$informa_end = true;
							}
						}
					}
					$inf_tom->addAttribute('RazaoSocial', substr(trim(UpperDados($nome_tomador)),0,115), false);

					if($informa_end){
						$con_end_tom =  'SELECT'.
										' Insc_Municipal,'.
										' CEP,'.
										' Logradouro,'.
										' Numero,'.
										' Bairro,'.
										' Complemento,'.
										' UF,'.
										' Codigo_Cidade,'.
										' Nome_Cidade,'.
										' Insc_Estadual,'.
										' Codigo_Pais'.
										' FROM pessoa_endereco '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"'.
										' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
						$res_end_tom = consulta_sql($con_end_tom);
						$reg_end_tom = consulta_ler_linha($res_end_tom);
						consulta_limpa($res_end_tom);
						$inf_end_tom = &$inf_tom->addChild('Endereco');
						$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,125);
						if($end_endereco!=''){
							$inf_end_tom->addAttribute('Endereco', $end_endereco, false);
						}
						$end_num = substr(limpa_numero($reg_end_tom[3]),0,10);
						if($end_num!=''){
							$inf_end_tom->addAttribute('Numero', $end_num, false);
						}
						$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,60);
						if($end_comp!=''){
							$inf_end_tom->addAttribute('Complemento', $end_comp, false);
						}
						$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,60);
						if($end_bairro!=''){
							$inf_end_tom->addAttribute('Bairro', $end_bairro, false);
						}
						$end_munic = substr(limpa_numero($reg_end_tom[7]),0,7);
						if($end_munic!=''){
							$inf_end_tom->addAttribute('CodigoMunicipio', $end_munic, false);
						}
						$end_uf = substr(trim(UpperDados($reg_end_tom[6])),0,2);
						if($end_uf!=''){
							$inf_end_tom->addAttribute('Uf', $end_uf, false);
						}
						$end_cep = substr(limpa_numero($reg_end_tom[10]),0,4);
						if($end_cep!=''){
							$inf_end_tom->addAttribute('CodigoPais', substr(limpa_numero($reg_end_tom[10]),0,8), false);
						}
						$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
						if($end_cep!=''){
							$inf_end_tom->addAttribute('Cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);
						}
					}

					$tem_contato = false;
					$tel_tomador = '';
					if($reg_nota->Dest_Telefone>0){
						$con_tom_tel =  'SELECT'.
										' Numero_Telefone,'.
										' Situacao'.
										' FROM pessoa_telefone '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Pessoa="'.$reg_nota->Destinatario.'"'.
										' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
										' AND Situacao<>"E" ';
						$res_tom_tel = consulta_sql($con_tom_tel);
						$reg_tom_tel = consulta_ler_linha($res_tom_tel);
						consulta_limpa($res_tom_tel);

						$tel_tomador = $reg_tom_tel[0];
						$tem_contato = true;
					}

					if($tem_contato){
						$inf_cont_tom = &$inf_tom->addChild('Contato');
						if($tel_tomador!=''){
							$inf_cont_tom->addAttribute('Telefone', substr(limpa_numero($tel_tomador),0,11), false);
						}
						if($reg_tom[2]!=''){
							$inf_cont_tom->addAttribute('Email', substr(trim($reg_tom[2]),0,80), false);
						}
					}

					$con_pessoa='SELECT'.
								' CPF_CNPJ,'.
								' Opt_Simples'.
								' FROM pessoa '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"';
					$res_pessoa = consulta_sql($con_pessoa);
					$reg_pessoa = consulta_ler_objeto($res_pessoa);
					consulta_limpa($res_pessoa);
					if($reg_pessoa->Opt_Simples=='S'){
						$opt_simples = '1';
					}else{
						$opt_simples = '2';
					}
					$inf_dec->addAttribute('OptanteSimplesNacional', $opt_simples, false);
					$inf_dec->addAttribute('IncentivoFiscal', '2', false);
				}

				rmkdir($caminho_t.'/');

				//echo $caminho_t.'/', $nome_arq;
				$xml->toFile($caminho_t.'/', $nome_arq);
				$salvou = file_exists($caminho_t.'/'.$nome_arq);

			}
			//pegar da pasta de retorno

			if ($salvou){
				echo '<font size="2" face="Verdana">Transmitindo arquivo!</font><br>';
				$retorno = nfse_processa_araquari($nome_arq,$reg_nota,$operacao,$sit_atual);
			}else{
				echo '<font size="2" face="Verdana">FRE-823 - Falha ao gerar arquivo "'.$nome_arq.'" na pasta "'.$caminho_t.'"!</font><br>';
				nfse_retorna_nfse2($reg_nota->Nr_Nota,$operacao);
			}

		}
		return $retorno;
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_araucaria($filt_serie,$reg_nota,$operacao="I"){
		$retorno = false;
		$salvou = false;

		//valida se situao da nota est correta
		$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
		$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-rps.xml";
		if ($operacao=='C'){
			$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($reg_nota->NrDoc,10)."-can.xml";
		}

		$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$reg_nota->NFSe_Lote;
		$nr_lote = $reg_nota->NFSe_Lote;

		if ($reg_nota->Situacao!='F' && $operacao=="I"){
			echo '<font size="2" face="Verdana">FRE-821 - Envio do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else if (($reg_nota->Situacao!='F')&&($operacao=="C")){
			echo '<font size="2" face="Verdana">FRE-822 - Cancelamento do RPS no realizado! Situao "'.$reg_nota->Situacao.'" Invlida!</font><br>';
		}else{
			$sit_atual = $reg_nota->Situacao;
			//se for I verifica se retorno j est na pasta,
			if (($operacao=="I") && ($sit_atual=='I')){
				//caso no esteja, muda o status pra P
				if (file_exists($caminho_r.'/s_'.$nome_arq)){
					//caso esteja no faz nada, s pega o retorno
					$salvou = true;
				}else{
					$sit_atual='P';
				}
			}
			if (($operacao=="C") || ($sit_atual=='F')){
				$sit_atual='P';
			}

			if ($sit_atual=='P'){
				echo '<font size="2" face="Verdana">Gerando arquivo de Envio!</font><br>';

				$con_serie= 'SELECT'.
							' max(NFSe_Lote),'.
							' Layout_Impressao'.
							' FROM nota_fiscal_serie '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_serie = consulta_sql($con_serie);
				$reg_serie = consulta_ler_linha($res_serie);
				consulta_limpa($res_serie);

				$nr_lote = ($reg_serie[0]+1);

				$upd_nota_serie='UPDATE nota_fiscal_serie SET'.
								' NFSe_Lote="'.$nr_lote.'" '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
								' AND Modelo="'.base64_decode_si($filt_serie).'"';
				$res_nota_serie = consulta_sql($upd_nota_serie,true,1);

				if ($operacao=="I"){
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote="'.$nr_lote.'" '.
								//' Layout_Impressao="'.$reg_serie[1].'" '.
								//' NFSe_Versao="1.0", '.
								//' NFSe_Lote_DH_Envio =  '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);
				}else{
					$upd_nota = 'UPDATE nota_fiscal SET'.
								' NFSe_Lote_C="'.$nr_lote.'", '.
								' NFSe_Lote_C_DH_Envio=now() '.
								' WHERE Dominio="'.$reg_nota->Dominio.'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($upd_nota);
				}


				//precisa criar o arquivo XML
				$caminho_r="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/retorno";
				$caminho_e="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/rps";
				$caminho_t="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/tmp";
				$caminho_err="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/erro";
				$id_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.$nr_lote;
				//cria objeto xml
				$xml = new XML("1.0","ISO-8859-1");

				$nfse = &$xml->createRoot("nfse");

				$nf = &$nfse->addChild("nf");

				if ($operacao=="C"){
					$nf->addAttribute('numero', $reg_nota->NFSe_Nr, false);
					$nf->addAttribute('situacao', 'C', false);
				}

				//consulta empresa cnpj nome
				$con_empresa = 'SELECT'.
								' CPF_CNPJ,'.
								' Nome_Razao'.
								' FROM pessoa '.
								' WHERE Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Dominio="'.$_SESSION["Dominio"].'"';
				$res_empresa = consulta_sql($con_empresa);
				$reg_empresa = consulta_ler_linha($res_empresa);
				consulta_limpa($res_empresa);
				$cnpj = limpa_numero($reg_empresa[0]);

				$con_end_emp = 'SELECT Insc_Municipal, CEP, Logradouro, Numero, Bairro, Complemento, UF, Codigo_Cidade, Nome_Cidade, CNAE_Municipal FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Situacao<>"E"'.
								' ORDER BY Seq_Endereco limit 1';
				$res_end_emp = consulta_sql($con_end_emp);
				$reg_end_emp = consulta_ler_linha($res_end_emp);
				consulta_limpa($res_end_emp);
				$reg_end_emp[8] = str_replace("", "A", $reg_end_emp[8]);
				$reg_end_emp[8] = str_replace("", "A", $reg_end_emp[8]);
				$reg_end_emp[8] = str_replace("", "E", $reg_end_emp[8]);
				$reg_end_emp[8] = str_replace("", "I", $reg_end_emp[8]);
				$reg_end_emp[8] = str_replace("", "O", $reg_end_emp[8]);
				$cidade_prest = $reg_end_emp[7];
				$con_cidade = 'SELECT Codigo_SERPRO FROM cidade_serpro WHERE '.
								' UF="'.$reg_end_emp[6].'"'.
								' AND Nome_Cidade="'.$reg_end_emp[8].'"';
				$res_cidade = consulta_sql($con_cidade);
				$reg_cidade = consulta_ler_linha($res_cidade);
				consulta_limpa($res_cidade);


				$prestador = &$nfse->addChild("prestador");
				$prestador->addAttribute('cpfcnpj', $cnpj, false);
				$prestador->addAttribute('cidade', $reg_cidade[0], false);


				$tomador = &$nfse->addChild("tomador");
				if ($operacao!="C"){
					$tomador->addAttribute('endereco_informado', '1', false);
				}

				$con_tom = 'SELECT'.
							' CPF_CNPJ,'.
							' Nome_Razao,'.
							' EMail,'.
							' RG,'.
							' Nome_Fantasia'.
							' FROM pessoa '.
							' WHERE Pessoa="'.$reg_nota->Destinatario.'"'.
							' AND Dominio="'.$_SESSION["Dominio"].'"';
				$res_tom = consulta_sql($con_tom);
				$reg_tom = consulta_ler_linha($res_tom);
				consulta_limpa($res_tom);

				$con_end_tom = 'SELECT'.
								' Insc_Municipal,'.
								' CEP,'.
								' Logradouro,'.
								' Numero,'.
								' Bairro,'.
								' Complemento, '.
								' UF,'.
								' Codigo_Cidade,'.
								' Nome_Cidade,'.
								' Insc_Estadual,'.
								' Nome_Pais,'.
								' Ponto_Referencia'.
								' FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
				$res_end_tom = consulta_sql($con_end_tom);
				$reg_end_tom = consulta_ler_linha($res_end_tom);
				consulta_limpa($res_end_tom);

				$cnpj_tom = limpa_numero($reg_tom[0]);

				if ($reg_end_tom[6]=='EX'){
					$tipo_fj = 'E';
				}else if(strlen($cnpj_tom)==11){
					$tipo_fj = 'F';
				}else{
					$tipo_fj = 'J';
				}

				$tomador->addAttribute('tipo', $tipo_fj, false);

				if ($tipo_fj=='E'){
					$tomador->addAttribute('identificador', $reg_tom[3], false);
					$tomador->addAttribute('estado', 'EXTERIOR', false);
					$tomador->addAttribute('pais', $reg_end_tom[10], false);
					$tomador->addAttribute('cpfcnpj', '99999999999', false);
				}else{
					$tomador->addAttribute('cpfcnpj', $cnpj_tom, false);
				}

				$tomador->addAttribute('ie', substr(limpa_numero2($reg_end_tom[9]),0,14), false);
				$tomador->addAttribute('nome_razao_social', substr(trim(UpperDados($reg_tom[4])),0,100), false);
				if ( substr(trim(UpperDados($reg_tom[1])),0,100) != substr(trim(UpperDados($reg_tom[1])),0,100)){
					if ($tipo_fj == 'J'){
						$tomador->addAttribute('sobrenome_nome_fantasia', substr(trim(UpperDados($reg_tom[4])),0,100), false);
					}else{
						$tomador->addAttribute('sobrenome_nome_fantasia', '', false);
					}
				}else{
					$tomador->addAttribute('sobrenome_nome_fantasia', '', false);
				}
				$end_endereco = substr(trim(UpperDados($reg_end_tom[2])),0,70);
				$tomador->addAttribute('logradouro', $end_endereco, false);
				$email_tomador = trim($reg_tom[2]);
				if(strlen($reg_tom[2])>99){
					$email_tomador="";
					$emails = explode(";",trim($reg_tom[2]));
					$emailsize = 0;
					for($k=0;$k<count($emails);$k++){
						if($emailsize+strlen($emails[$k].";")<100){
							$emailsize+=strlen($emails[$k].";");
							$email_tomador.=$emails[$k].";";
						}
					}
					$email_tomador = substr($email_tomador, 0, -1);
				}
				$tomador->addAttribute('email', $email_tomador, false);

				$end_num = substr(limpa_numero($reg_end_tom[3]),0,8);
				$tomador->addAttribute('numero_residencia', $end_num, false);

				$end_comp = substr(trim(UpperDados($reg_end_tom[5])),0,50);
				$tomador->addAttribute('complemento', $end_comp, false);

				$end_ref = substr(trim(UpperDados($reg_end_tom[11])),0,100);
				$tomador->addAttribute('ponto_referencia', $end_ref, false);

				$end_bairro = substr(trim(UpperDados($reg_end_tom[4])),0,30);
				$tomador->addAttribute('bairro', $end_bairro, false);

				if ($tipo_fj=='E'){
					$end_munic = substr(trim(UpperDados($reg_end_tom[8])),0,100);
				}else{
					$reg_end_tom[8] = str_replace("", "A", $reg_end_tom[8]);
					$reg_end_tom[8] = str_replace("", "A", $reg_end_tom[8]);
					$reg_end_tom[8] = str_replace("", "E", $reg_end_tom[8]);
					$reg_end_tom[8] = str_replace("", "I", $reg_end_tom[8]);
					$reg_end_tom[8] = str_replace("", "O", $reg_end_tom[8]);
					$con_cidade='SELECT Codigo_SERPRO FROM cidade_serpro '.
								' WHERE UF="'.$reg_end_tom[6].'"'.
								' AND Nome_Cidade="'.$reg_end_tom[8].'"';
					$res_cidade = consulta_sql($con_cidade);
					$reg_cidade_tom = consulta_ler_linha($res_cidade);
					consulta_limpa($res_cidade);
					$tomador->addAttribute('cidade', $reg_cidade_tom[0], false);
				}

				$end_cep = substr(limpa_numero($reg_end_tom[1]),0,8);
				$tomador->addAttribute('cep', substr(limpa_numero($reg_end_tom[1]),0,8), false);

				//ddd_fone_comercial
				//fone_comercial

				//ddd_fone_residencial
				//fone_residencial

				$con_tom_tel =  'SELECT Numero_Telefone FROM pessoa_telefone '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Seq_Telefone="'.$reg_nota->Dest_Telefone.'"'.
								' AND Situacao<>"E" ';
				$res_tom_tel = consulta_sql($con_tom_tel);
				$reg_tom_tel = consulta_ler_linha($res_tom_tel);
				consulta_limpa($res_tom_tel);

				$nr_fone = limpa_numero($reg_tom_tel[0]);
				$ddd_fone = '';
				if ((strlen($nr_fone)==10)||(strlen($nr_fone)==11)){
					$ddd_fone = substr($nr_fone,0,2);
					$nr_fone = substr($nr_fone,2,9);
				}else if (strlen($nr_fone)>=12){
					$ddd_fone = substr($nr_fone,0,3);
					$nr_fone = substr($nr_fone,3,9);
				}else{
					$nr_fone = substr($nr_fone,0,9);
				}

				$tomador->addAttribute('ddd_fone_comercial', $ddd_fone, false);
				$tomador->addAttribute('fone_comercial', $nr_fone, false);

				$tomador->addAttribute('ddd_fone_residencial', '', false);
				$tomador->addAttribute('fone_residencial', '', false);

				$tomador->addAttribute('ddd_fax', '', false);
				$tomador->addAttribute('fone_fax', '', false);


				$t_itens = &$nfse->addChild('itens');

				$con_itens= 'SELECT * FROM nota_fiscal_item'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Prod_Depart=0'.
							' ORDER BY Seq_Item';

				$res_itens = consulta_sql($con_itens);
				$nrw_itens = consulta_num_registros($res_itens);

				$lista_desc_total = '';
				$cidade_fg = $reg_nota->Cidade_FG;
				$total_retido = 0;

				for($itens=0;$itens<$nrw_itens;$itens++){
					$reg_itens = consulta_ler_objeto($res_itens);
					$lista_itens = &$t_itens->addChild('lista');
					$cidade_fg = $reg_nota->Cidade_FG;
					if ($reg_itens->ISS_Cidade_FG!=''){
						$cidade_fg = $reg_itens->ISS_Cidade_FG;
					}

					if ($cidade_fg==$cidade_prest){
						$trib_muni = 'S';
						$codigo_local_prestacao_servico = $reg_cidade[0];
					}else{
						$trib_muni = 'N';
						$con_local_prestado='SELECT UF, Nome FROM cidade'.
											' WHERE Codigo_Cidade="'.$cidade_fg.'"';
						$res_local_prestado = consulta_sql($con_local_prestado);
						$reg_local_prestado = consulta_ler_linha($res_local_prestado);
						consulta_limpa($res_local_prestado);

						$con_local_prestado='SELECT Codigo_SERPRO FROM cidade_serpro'.
											' WHERE UF="'.$reg_local_prestado[0].'"'.
											' AND Nome_Cidade="'.$reg_local_prestado[1].'"';
						$res_local_prestado = consulta_sql($con_local_prestado);
						$reg_local_prestado = consulta_ler_linha($res_local_prestado);
						consulta_limpa($res_local_prestado);

						$codigo_local_prestacao_servico = $reg_local_prestado[0];
					}
					if($reg_itens->ISS_CST=='I'){
						$trib_muni = 'N';
					}

					$lista_itens->addAttribute('tributa_municipio_prestador', $trib_muni, false);
					$lista_itens->addAttribute('codigo_local_prestacao_servico', $codigo_local_prestacao_servico, false);
					$lista_itens->addAttribute('codigo_item_lista_servico', limpa_numero($reg_itens->Servico_Codigo), false);

					$lista_desc = nfe_formata_txt($reg_itens->Observacao);


					$con_obs = 'SELECT * FROM nota_fiscal_obs'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
								' GROUP BY Texto_Completo'.
								' ORDER BY Seq_Obs';
					$res_obs = consulta_sql($con_obs);
					$nrw_obs = consulta_num_registros($res_obs);
					for($obss=0;$obss<$nrw_obs;$obss++){
						$reg_obs = consulta_ler_objeto($res_obs);
						if ($reg_obs->Seq_Obs==23){
							$lista_desc_total = nfe_formata_txt($reg_obs->Texto_Completo);
						}else{
							if ($lista_desc!=''){
								$lista_desc.=';';
							}
							$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
						}
					}
					consulta_limpa($res_obs);

					$lista_desc = str_replace(";","&amp;lt;br&amp;gt;",$lista_desc);
					$lista_itens->addAttribute('descritivo', substr($lista_desc,0,1000), false);
					$lista_itens->addAttribute('aliquota_item_lista_servico', pt2vr(nfe_numero($reg_itens->ISS_Aliquota,2)), false);

					$situacao_tributaria = '0';
					$valor_retido = 0;
					if($reg_itens->ISS_CST=='R'){
						$situacao_tributaria = 1;
						$valor_retido = $reg_itens->ISS_Valor;
					}
					if($reg_itens->ISS_CST=='S'){
						$situacao_tributaria = 2;
					}
					if($reg_itens->ISS_CST=='I'){
						$situacao_tributaria = 6;
					}

					$lista_itens->addAttribute('situacao_tributaria', $situacao_tributaria, false);

					if ($reg_itens->ISS_BC<=0){
						$lista_itens->addAttribute('valor_tributavel', pt2vr(nfe_numero($reg_itens->Valor_Total,2)), false);
					}else{
						$lista_itens->addAttribute('valor_tributavel', pt2vr(nfe_numero($reg_itens->ISS_BC,2)), false);
					}
					$lista_itens->addAttribute('valor_deducao', pt2vr(nfe_numero($reg_itens->Valor_Desconto,2)), false);
					$lista_itens->addAttribute('valor_issrf', pt2vr(nfe_numero($valor_retido,2)), false);
					$lista_itens->addAttribute('unidade_codigo', '', false);
					$lista_itens->addAttribute('unidade_quantidade', '', false);
					$lista_itens->addAttribute('unidade_valor_unitario', '', false);

					$total_retido+=$valor_retido;
				}
				consulta_limpa($res_itens);

				$nf->addAttribute('valor_total', pt2vr(nfe_numero($reg_nota->Total_NF,2)), false);
				$nf->addAttribute('valor_desconto', '0,00', false);
				$nf->addAttribute('valor_ir', pt2vr(($reg_nota->Total_Retido_IRRF_Valor+$reg_nota->Total_IRRF_Valor)), false);
				$nf->addAttribute('valor_inss', pt2vr($reg_nota->Total_Retido_PrevSocial_Valor), false);
				$nf->addAttribute('valor_contribuicao_social', pt2vr($reg_nota->Total_Retido_CSLL_Valor), false);
				$nf->addAttribute('valor_rps', '0,00', false);
				$nf->addAttribute('valor_pis', pt2vr($reg_itens->PIS_Retido_Valor), false);
				$nf->addAttribute('valor_cofins', pt2vr($reg_itens->COFINS_Retido_Valor), false);

				if ($operacao=="C"){
					$nf->addAttribute('observacao', $reg_nota->Cancela_Motivo_Descricao, false);  //motivo do cancelamento
				}else{
					$nf->addAttribute('observacao', '', false);
				}

				$con_obs =  'SELECT * FROM nota_fiscal_obs'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Seq_Item=0'.
							' AND Seq_Obs>3 '.
							' GROUP BY Texto_Completo'.
							' ORDER BY Seq_Obs';
				$res_obs = consulta_sql($con_obs);
				$nrw_obs = consulta_num_registros($res_obs);

				if (($lista_desc_total!='')||($nrw_obs>0)){
					$genericos = &$nfse->addChild('genericos');
				}

				if ($lista_desc_total!=''){
					$t_linha = &$genericos->addChild('linha');
					$t_linha->addAttribute('titulo', '', false);
					$t_linha->addAttribute('descricao', substr($lista_desc_total,0,200), false);
				}

				for($obss=0;$obss<$nrw_obs;$obss++){
					$reg_obs = consulta_ler_objeto($res_obs);

					$lista_desc_total =trim($reg_obs->Texto_Completo);
					$lista_desc_total = str_replace(";","&amp;lt;br&amp;gt;",$lista_desc_total);

					$t_linha = &$genericos->addChild('linha');
					$t_linha->addAttribute('titulo', '', false);
					$t_linha->addAttribute('descricao', substr($lista_desc_total,0,200), false);
				}
				consulta_limpa($res_obs);

				rmkdir($caminho_t.'/');
				$caminho="../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$_SESSION['Empresa_Codigo']."/lote";

				//finaliza arquivo na pasta tmp
				rmkdir($caminho);
				$nome_arq = $reg_nota->Modelo.'_'.$reg_nota->Serie.'_'.fill_full($nr_lote,28)."-lote.xml";

				$xml->toFile($caminho, $nome_arq);
				$salvou = file_exists($caminho.'/'.$nome_arq);
			}
			//pegar da pasta de retorno

			if ($salvou){
				echo '<font size="2" face="Verdana">Arquivo Salvo!</font><br>';
			}else{
				echo '<font size="2" face="Verdana">FRE-823 - Falha ao gerar arquivo "'.$nome_arq.'" na pasta "'.$caminho.'"!</font><br>';
				nfse_retorna_nfse2($reg_nota->Nr_Nota,$operacao);
			}
		}
		return $retorno;
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_jaragua_do_sul($reg_nota,$operacao="I"){
		if ($operacao=='I'){
			return nota_fiscal_envio_jaragua_do_sul_gerar_nfse($reg_nota);
		}else{
			return nota_fiscal_envio_jaragua_do_sul_cancelar($reg_nota);
		}
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_joinville($reg_nota,$operacao="I"){
		if ($operacao=='I'){
			return nota_fiscal_envio_joinville_gerar_nfse($reg_nota);
		}else{
			return nota_fiscal_envio_joinville_cancelar($reg_nota);
		}
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_brasilia($reg_nota,$operacao="I"){
		if ($operacao=='I'){
			return nota_fiscal_envio_brasilia_gerar_nfse($reg_nota);
		}else{
			return nota_fiscal_envio_brasilia_cancelar($reg_nota);
		}
	}

	function nota_fiscal_gera_arquivo_nf_servico_envio_araucaria_ws($reg_nota,$operacao="I"){
		if ($operacao=='I'){
			return nota_fiscal_envio_araucaria_ws_gerar_nfse($reg_nota);
		}else{
			return nota_fiscal_envio_araucaria_ws_cancelar($reg_nota);
		}
	}

	function nota_fiscal_cancelamento_gera_arquivo_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$nr_nf,$cidade,$insc_munic,$Layout){
		$nome_arquivo_canc     = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ped-cannfse.xml';
		$nome_arquivo_canc_ret = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ret-cannfse.xml';
		$nome_arquivo_cancT    = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ped-cannfse.txt';

		$pasta_envio   = 'envio';
        $pasta_retorno = 'retorno';
		$versao="1.00";
        $xmlns="http://www.abrasf.org.br/nfse.xsd";

        if ($Layout=='5'){//curitiba
            $xmlns="http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd";
        }
        if ($Layout==16){//jaragua do sul betha
            $versao="2.02";
			$pasta_envio   = 'rps';
			$pasta_retorno = 'retorno';
            $xmlns="http://www.betha.com.br/e-nota-contribuinte-ws";
        }
        if ($Layout=='17'){//joinville
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://nfews.joinville.sc.gov.br";
        }
		if ($Layout=='17N'){//joinville
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="1.00";
            $xmlns="http://www.publica.inf.br";
        }
        if (($Layout=='21')||($Layout=='22')){//brasilia - ararucaria ws
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://www.abrasf.org.br/nfse.xsd";
        }

		if(file_exists(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_canc)){
			unlink(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_canc);
		}

		if(file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_cancT)){
			unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_cancT);
		}
		//se j tem retrono nao precisa tentar enviar novamente
		if(!file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret)){
			echo '<font size="2" face="Verdana">Gerando arquivo de cancelamento...</font><br>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			//CodigoCancelamento
			// 1 - Erro na emissao;
			// 2 - Servico nao prestado;
			// 3 - Erro de assinatura;
			// 4 - Duplicidade da nota;
			// 5 - Erro de processamento
			if ($Layout == '22'){//cidade 4101804 araucria_ws
				$conteudo = '<CancelarNfseEnvio xmlns="'.$xmlns.'">'.
								'<Pedido>'.
									'<InfPedidoCancelamento>'.
										'<IdentificacaoNfse>'.
											'<Numero>'.$nr_nf.'</Numero>'.
											'<CpfCnpj>'.
												'<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
											'</CpfCnpj>'.
											'<CodigoMunicipio>'.$cidade.'</CodigoMunicipio>'.
										'</IdentificacaoNfse>'.
										'<CodigoCancelamento>2</CodigoCancelamento>'.
									'</InfPedidoCancelamento>'.
								'</Pedido>'.
							'</CancelarNfseEnvio>';
			}else if ($Layout == '17N'){//cidade 4209102 joinville
				$motivo = trim(substr($reg_nota->Cancela_Motivo_Descricao,0,255));
				$codigoC = substr($motivo,0,4);
				if ($codigoC[0]!='C'){ $codigoC = 'C999'; }

				$conteudo = '<CancelarNfseEnvio xmlns="'.$xmlns.'">'.
								'<Pedido>'.
									'<InfPedidoCancelamento id="assinar">'.
										'<IdentificacaoNfse>'.
											'<Numero>'.$nr_nf.'</Numero>'.											
											'<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
											'<InscricaoMunicipal>'.$insc_munic.'</InscricaoMunicipal>'.
											'<CodigoMunicipio>'.$cidade.'</CodigoMunicipio>'.
										'</IdentificacaoNfse>'.
										'<CodigoCancelamento>'.$codigoC.'</CodigoCancelamento>'.
										//'<MotivoCancelamento>'.nfsexml_carac2especial($motivo).'</MotivoCancelamento>'.
									'</InfPedidoCancelamento>'.
								'</Pedido>'.
							'</CancelarNfseEnvio>';
			}else if (($Layout == '17')||($Layout == '21')){//cidade 4209102 joinville - 5300108 brasilia
				$conteudo = '<CancelarNfseEnvio xmlns="'.$xmlns.'">'.
								'<Pedido>'.
									'<InfPedidoCancelamento Id="NF'.$nr_nf.'">'.
										'<IdentificacaoNfse>'.
											'<Numero>'.$nr_nf.'</Numero>'.
											'<CpfCnpj>'.
												'<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
											'</CpfCnpj>'.
											'<CodigoMunicipio>'.$cidade.'</CodigoMunicipio>'.
										'</IdentificacaoNfse>'.
										'<CodigoCancelamento>2</CodigoCancelamento>'.
									'</InfPedidoCancelamento>'.
								'</Pedido>'.
							'</CancelarNfseEnvio>';
			}else{//layouyt //13 araquari , 15 itanhaeim e 16 jaraqua do sul
				$conteudo =	'<CancelarNfseEnvio xmlns="'.$xmlns.'">'.
								'<Pedido>'.
									'<InfPedidoCancelamento Id="CAN1">'.
										'<IdentificacaoNfse>'.
											'<Numero>'.$nr_nf.'</Numero>'.
											'<CpfCnpj>'.
												'<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
											'</CpfCnpj>'.
											'<InscricaoMunicipal>'.$insc_munic.'</InscricaoMunicipal>'.
											'<CodigoMunicipio>'.$cidade.'</CodigoMunicipio>'.
										'</IdentificacaoNfse>'.
										'<CodigoCancelamento>2</CodigoCancelamento>'.
									'</InfPedidoCancelamento>'.
								'</Pedido>'.
							'</CancelarNfseEnvio>';
			}
			$xmlString = $conteudo;
			$copiou = file_put_contents(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_canc,$xmlString);
			if (!$copiou){
				echo '<font size="2" face="Verdana">Falha ao gerar arquivo "'.$nome_arquivo_canc.'" na pasta "Enviar"!</font><br>';
				echo '<font size="3" face="Verdana"><b>Operao de cancelamento foi Abortado!</b></font><br>';
				nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
				return 0;
			}
		}
		return 1;
	}

	function nota_fiscal_cancelamento_retorno_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$cidade,$Layout){
		$nome_arquivo_canc     = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ped-cannfse.xml';
		$nome_arquivo_canc_ret = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ret-cannfse.xml';
		$nome_arquivo_canc_ret2= $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-cannfse.xml';
		$nome_arquivo_cancT    = $cnpj_limpo.'_'.$nr_doc.'_'.$nr_lote.'-ped-cannfse.err';

		$pasta_envio   = 'envio';
        $pasta_retorno = 'retorno';
		$versao="1.00";
        $xmlns="http://www.abrasf.org.br/nfse.xsd";

        if ($Layout==5){//curitiba
            $xmlns="http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd";
        }
        if ($Layout==16){//jaragua do sul betha
            $versao="2.02";
			$pasta_envio   = 'rps';
			$pasta_retorno = 'retorno';
            $xmlns="http://www.betha.com.br/e-nota-contribuinte-ws";
        }
        if ($Layout==17){//joinville
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://nfews.joinville.sc.gov.br";
        }
        if (($Layout==21)||($Layout==22)){//brasilia - ararucaria ws
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://www.abrasf.org.br/nfse.xsd";
        }

		$ano_mes    = nfse_ano_mes($reg_nota->DH_Emissao);

		$ok = false;
		$c = 0;
		while(!$ok){
			if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret)){
				$ok = true;
			}
			if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret2)){
				$ok = true;
			}
			if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_cancT)){
				$ok = true;
			}
			if ($c==120){
				$ok = true;
			}else{
				sleep(1);
			}				
		}
		usleep(200);
		set_time_limit(300);

		if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_cancT)){
			$xml_retorno = file_get_contents(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_cancT);
			echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e! Verifique a mensagem de erro.</font><br>';
			echo '<font size="2" face="Verdana">'.$xml_retorno.'</font><br>';
			nfse_copia_arquivo('tmp', 'erros/' . $ano_mes, $nome_arquivo_canc_ret, '', true, true);
			nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
			echo '<font size="3" face="Verdana"><b>Operao de cancelamento foi Abortado!</b></font><br>';
			return 0;
		}

		if ((!file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret))&&
			(!file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret2))){
			echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e! Tempo de resposta excedido!</font><br>';
			echo '<font size="2" face="Verdana">Verifique o integrador (NFSeEnvio) e/ou tente novamente!</font><br>';
			if (file_exists(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_canc)){
				unlink(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_canc);
			}
			nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
			return 0;
		}
		if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret)){
			$xml_corpo = nfse_carrega_xml(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret);
		}else{
			$xml_corpo = nfse_carrega_xml(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret2);
		}
		
		$xmlString = $xml_corpo->asXml();

		if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret)){
			unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret);
		}
		if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret2)){
			unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_canc_ret2);
		}

		if (file_exists(nfse_pasta_raiz().'tmp/'.$nome_arquivo_canc_ret)){
			unlink(nfse_pasta_raiz().'tmp/'.$nome_arquivo_canc_ret);
		}
		file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_canc_ret, $xmlString);
		

		//nfse_copia_arquivo('tmp', 'SEFAZ/RetCancelmento/'.$ano_mes, $nome_arquivo_canc_ret, '', false, true);

			// <CancelarNfseResposta xmlns="http://www.publica.inf.br" xmlns:pub="http://www.publica.inf.br/integracao_nfse" xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
			// <Cancelamento>
			// <Confirmacao>
			// <Pedido>
			// <InfPedidoCancelamento id="82572184">
			// <IdentificacaoNfse>
			// <Numero>202400000013640</Numero>
			// <Cnpj>18941283000131</Cnpj>
			// <InscricaoMunicipal>E</InscricaoMunicipal>
			// <CodigoMunicipio>4209102</CodigoMunicipio>
			// </IdentificacaoNfse>
			// <CodigoCancelamento>C003</CodigoCancelamento>
			// </InfPedidoCancelamento>
			// <ds:Signature>
			// <ds:SignedInfo>
			// <ds:CanonicalizationMethod Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/>
			// <ds:SignatureMethod Algorithm="http://www.w3.org/2000/09/xmldsig#rsa-sha1"/>
			// <ds:Reference URI="#assinar">
			// <ds:Transforms>
			// <ds:Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/>
			// <ds:Transform Algorithm="http://www.w3.org/TR/2001/REC-xml-c14n-20010315"/>
			// </ds:Transforms>
			// <ds:DigestMethod Algorithm="http://www.w3.org/2000/09/xmldsig#sha1"/>
			// <ds:DigestValue>wonVlZcSpPmdMNHQVsdVgosHI0Q=</ds:DigestValue>
			// </ds:Reference>
			// </ds:SignedInfo>
			// <ds:SignatureValue>QlM0M94jdCfdDO45Gj0Fsy0ixT2Gw32Vv7RNYJXncJMnoxOOL8GAtfdJHSkh1qhaXMGTX5VP4i88DsBzo+isUrzzZhyXcHGAbOJaP6b6zMY/CW1fICRvb1VbXRGKVVjLPrFjqdPNvPVXufSg96AP17O08U7PG3aQyFPQ4r9/c9rKlKtaSkF0tHD7wJMIPNuxuAhFtzrxV9UD6vZgGlXMOxGQ1EtLBrBq02CXa0W1/AW/AS+uCByT+xpkD2TaCQ8opTEDY+ExuU73dr8phuaDcAg89QSixN37Vt45lKUXFQiyEgRyoPvPhVDpKG0jKJo2SpxoqVe4HabWt8ve4aTMjQ==</ds:SignatureValue>
			// <ds:KeyInfo>
			// <ds:X509Data>
			// <ds:X509Certificate>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</ds:X509Certificate>
			// </ds:X509Data>
			// </ds:KeyInfo>
			// </ds:Signature>
			// </Pedido>
			// <DataHoraCancelamento>2024-11-11T15:26:13</DataHoraCancelamento>
		if($xml_corpo
					->Cancelamento
						->Confirmacao
							->Pedido
							->InfPedidoCancelamento
								->IdentificacaoNfse
								->Numero > 0){
			$nr_nota = $xml_corpo
						->RetCancelamento
							->NfseCancelamento
							->Confirmacao
								->Pedido
								->InfPedidoCancelamento
									->IdentificacaoNfse
									->Numero;
			$nome_arquivo_cancelado = 'RPS'.$nr_doc.'_NF'.$nr_nota.'-cannfse.xml';
			echo '<font size="2" face="Verdana">NFS-e cancelada na prefeitura.</font><br>';
			echo '<font size="2" face="Verdana">Cancelando no sistema...</font><br>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			nfse_copia_arquivo('tmp', 'SEFAZ/Cancelamento/'.$ano_mes, $nome_arquivo_canc_ret, '', false, true);
			
			// $conteudo = $xml_corpo->CancelarNfseResposta
			// 				->Cancelamento;
			file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_cancelado, $xmlString);
			nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/Canceladas', $nome_arquivo_cancelado, '', false, true);

			$data = $xml_corpo
							->Cancelamento
								->Confirmacao
								->DataHoraCancelamento;
			$sql =  'UPDATE nota_fiscal SET'.
					' NFSe_Lote_C_DH_Processado="'.$data.'" '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$reg_nota->Empresa.'"'.
					' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
			consulta_sql($sql);
			return 1;
		}



		if($xml_corpo
				  ->CancelarNfseResposta
					->RetCancelamento
					  ->NfseCancelamento
						->Confirmacao
						  ->Pedido
							->InfPedidoCancelamento
							  ->IdentificacaoNfse
								->Numero > 0){
			$nr_nota = $xml_corpo
						->CancelarNfseResposta
						->RetCancelamento
							->NfseCancelamento
							->Confirmacao
								->Pedido
								->InfPedidoCancelamento
									->IdentificacaoNfse
									->Numero;
			$nome_arquivo_cancelado = 'RPS'.$nr_doc.'_NF'.$nr_nota.'-cannfse.xml';
			echo '<font size="2" face="Verdana">NFS-e cancelada na prefeitura.</font><br>';
			echo '<font size="2" face="Verdana">Cancelando no sistema...</font><br>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			nfse_copia_arquivo('tmp', 'SEFAZ/Cancelamento/'.$ano_mes, $nome_arquivo_canc_ret, '', false, true);
			
			// $conteudo = $xml_corpo->CancelarNfseResposta
			// 				->RetCancelamento
			// 					->NfseCancelamento->asString();
			file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_cancelado, $xmlString);
			nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/Canceladas', $nome_arquivo_cancelado, '', false, true);

			$data = $xml_corpo
						->CancelarNfseResposta
							->RetCancelamento
							->NfseCancelamento
								->Confirmacao
								->DataHora;
			$sql =  'UPDATE nota_fiscal SET'.
					' NFSe_Lote_C_DH_Processado="'.$data.'" '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$reg_nota->Empresa.'"'.
					' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
			consulta_sql($sql);
			return 1;
		}

		$codigo   = $xml_corpo->CancelarNfseEnvioResponse->CancelarNfseResposta->ListaMensagemRetorno[0]->Codigo;
		$mensagem = $xml_corpo->CancelarNfseEnvioResponse->CancelarNfseResposta->ListaMensagemRetorno[0]->Mensagem;
		$correcao = $xml_corpo->CancelarNfseEnvioResponse->CancelarNfseResposta->ListaMensagemRetorno[0]->Correcao;
		if($codigo=="E27"){
			echo '<font size="2" face="Verdana">NFS-e j foi cancelada na prefeitura.</font><br>';
			echo '<font size="2" face="Verdana">Cancelando no sistema...</font><br>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			nfse_copia_arquivo('tmp', 'SEFAZ/Cancelamento/'.$ano_mes, $nome_arquivo_canc_ret, '', false, true);
			$sql =  'UPDATE nota_fiscal SET'.
					' NFSe_Lote_C_DH_Processado="'.data_atual('date').' '.hora_atual('hora').'" '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$reg_nota->Empresa.'"'.
					' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
			consulta_sql($sql);
			return 1;
		}
		echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e. Verifique a mensagem de erro.</font><br>';
		echo '<font size="2" face="Verdana">'.$codigo.' - '.utf8_decode($mensagem).'</font><br>'; 
		echo '<font size="2" face="Verdana">'.utf8_decode($correcao).'</font><br>';
		nfse_copia_arquivo('tmp', 'erros/' . $ano_mes, $nome_arquivo_canc_ret, '', true, true);
		nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
		return 0;
	}

	function nota_fiscal_envio_jaragua_do_sul_cancelar($reg_nota){
		$Layout = 16;
		$versao = '2.02';
		$cidade = '4208906';
		return nota_fiscal_envio_cancelar($reg_nota,$Layout,$versao,$cidade);
	}

	function nota_fiscal_envio_joinville_cancelar($reg_nota){
		$Layout = '17N';
		$versao = '1.00';
		$cidade = '4209102';
		return nota_fiscal_envio_cancelar($reg_nota,$Layout,$versao,$cidade);
	}

	function nota_fiscal_envio_brasilia_cancelar($reg_nota){
		$Layout = 21;
		$versao = '2.04';
		$cidade = '5300108';
		return nota_fiscal_envio_cancelar($reg_nota,$Layout,$versao,$cidade);
	}

	function nota_fiscal_envio_araucaria_ws_cancelar($reg_nota){
		$Layout = 22;
		$versao = '2.04';
		$cidade = '4101804';
		return nota_fiscal_envio_cancelar($reg_nota,$Layout,$versao,$cidade);
	}

	function nota_fiscal_envio_cancelar($reg_nota,$Layout,$versao,$cidade){
		$retorno = 0;
		$salvou  = false;
		$status  = 1;
		set_time_limit(300);

		$con_empresa  = 'SELECT'.
						' CPF_CNPJ,'.
						' Nome_Razao, '.
						' Opt_Simples '.
						' FROM pessoa '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
						' AND Pessoa="'.$reg_nota->Empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);
		
		$cnpj_limpo = limpa_numero($reg_empresa[0]);

		$con_end_emp =  'SELECT'.
						' Insc_Municipal '.
						' FROM pessoa_endereco '.
						' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
						' AND Pessoa="'.$reg_nota->Empresa.'"'.
						' AND Situacao<>"E"'.
						' ORDER BY Seq_Endereco limit 1';
		$res_end_emp = consulta_sql($con_end_emp);
		$reg_end_emp = consulta_ler_linha($res_end_emp);
		consulta_limpa($res_end_emp);
		$insc_munic = '';
		if($reg_end_emp[0]!=''){
			$insc_munic = $reg_end_emp[0];
		}
		
		
		$nr_doc  = $reg_nota->NrDoc;
		$nr_lote = limpa_numero(data_atual('date').''.hora_atual('hora'));

		if($reg_nota->NFSe_Nr==''){
			echo '<font size="2" face="Verdana">RPS '.$reg_nota->NrDoc.' no foi enviado  prefeitura!</font><br>';
			if($reg_nota->Situacao=='C'){
				echo '<font size="2" face="Verdana">RPS j cancelado...</font><br>';
			}else if($reg_nota->Situacao!='F'){
				echo '<font size="2" face="Verdana">Cancelando RPS sem envio prvio...</font><br>';
			}
			return 1;
		}

		if($reg_nota->Situacao!='F'){
			echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e! NFS-e '.$reg_nota->NFSe_Nr.' (RPS '.$reg_nota->NrDoc.') no est fechado.</font><br>';
			nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
			return 0;
		}

		if ($Layout=='17N'){//cancelamento de subsitututo
			$tem_sub = false;
			$con_ref =  'SELECT * FROM nota_fiscal_refenciada '.
						' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$reg_nota->Empresa.'"'.
						' AND Nota_Empresa="'.$reg_nota->Empresa.'"'.
						' AND Nota_Nr_Nota="0" '.
						' AND NF_Emitente="'.$reg_nota->Empresa.'"'.
						' AND NF_Nr_Doc="'.$reg_nota->NrDoc.'"'.
						' AND NF_Serie="'.$reg_nota->Serie.'"'.
						' AND Tipo_Doc="N"'.
						' GROUP BY Nr_Nota'.
						' ORDER BY Nr_Nota desc';
			$res_ref = consulta_sql($con_ref);
			$nrw_ref = consulta_num_registros($res_ref);
			for($r=0;$r<$nrw_ref;$r++){
				$reg_ref = consulta_ler_objeto($res_ref);
				$con_refN = 'SELECT * FROM nota_fiscal '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$reg_nota->Empresa.'"'.
							' AND Nr_Nota="'.$reg_ref->Nr_Nota.'"';
				$res_refN = consulta_sql($con_refN);
				$reg_refN = consulta_ler_objeto($res_refN);
				consulta_limpa($res_refN);
				if ($reg_refN->Modelo=='98'){
					if (($reg_refN->Situacao=='A')||
						($reg_refN->Situacao=='P')||
						($reg_refN->Situacao=='I')){
						echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e! NFS-e '.$reg_nota->NFSe_Nr.' (RPS '.$reg_nota->NrDoc.') tem RPS Substituto (RPS Substituto '.$reg_refN->NrDoc.') em aberto.</font><br>';
						nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
						return 0;
					}else
					if ($reg_refN->Situacao=='C'){
						echo '<font size="2" face="Verdana">Falha ao cancelar NFS-e! NFS-e '.$reg_nota->NFSe_Nr.' (RPS '.$reg_nota->NrDoc.') tem RPS Substituto (RPS Substituto '.$reg_refN->NrDoc.') em cancelada.</font><br>';
						nfse_retorna_nfse2($reg_nota->Nr_Nota,'C');
						return 0;
					}else
					if ($reg_refN->Situacao=='F'){

						return 1;//se esta fechada nem enviada nada s fecha mesmo
					}else{
						//E excluido nao conta pra cancelamento
						//print_r($reg_refN);
					}
				}
			}
			consulta_limpa($res_ref);
		}

		
						

		if (nota_fiscal_cancelamento_gera_arquivo_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$reg_nota->NFSe_Nr,$cidade,$insc_munic,$Layout)){
			return nota_fiscal_cancelamento_retorno_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$cidade, $Layout);
		}else{
			return 0;
		}
	}

	function nota_fiscal_envio_nfse_gerar_arquivo_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$cidade,$Layout,$operacao='I'){
		$con_empresa  = 'SELECT'.
						' CPF_CNPJ,'.
						' Nome_Razao, '.
						' Opt_Simples '.
						' FROM pessoa '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
						' AND Pessoa="'.$reg_nota->Empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);

		$status = 1;
		if ($operacao=='C'){
			$status = 2;
		}

		$serie = $reg_nota->Serie;
		if ($Layout==22){ //araucaria a serie  sempre 1
			$serie = '1';
		}

		$nome_arquivo_ped      = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-env-loterps.xml';
		$nome_arquivo_ret      = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-ret-loterps.xml';
		$nome_arquivo_retT     = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-env-loterps.err';
		$nome_arquivo_retT2    = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-ret-loterps.err';

		//$nome_arquivo_con     = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-envcon-loterps.xml';
		$nome_arquivo_conT    = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-envcon-loterps.err';
		if ($Layout=='17N'){//joinville
			$nome_arquivo_conT    = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-loterps.err';
		}
		$nome_arquivo_conR    = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-loterps.xml';

		if(file_exists(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_conT)){
			unlink(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_conT);
		}
		if(file_exists(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_retT)){
			unlink(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_retT);
		}
		if(file_exists(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_retT2)){
			unlink(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_retT2);
		}
		$gerar = true;
		if(file_exists(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_ret)){
			$gerar = false;
		}
		if(file_exists(nfse_pasta_raiz().'Retorno/'.$nome_arquivo_conR)){
			$gerar = false;
		}

		if ($reg_nota->NFSe_Lote_C>0){//protocolo (se tem protocolo  s pedir pra consultar denovo)
			$gerar = false;
		}

		if ($gerar){
			$con_end_emp =  'SELECT'.
							' Insc_Municipal,'.	//0
							' CEP,'.			//1
							' Logradouro,'.		//2
							' Numero,'.			//3
							' Bairro,'.			//4
							' Complemento,'.	//5
							' UF,'.				//6
							' Codigo_Cidade,'.	//7
							' Nome_Cidade,'.	//8
							' CNAE_Municipal'.	//9
							' FROM pessoa_endereco '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Pessoa="'.$reg_nota->Empresa.'"'.
							' AND Situacao<>"E"'.
							' ORDER BY Seq_Endereco limit 1';
			$res_end_emp = consulta_sql($con_end_emp);
			$reg_end_emp = consulta_ler_objeto($res_end_emp);
			consulta_limpa($res_end_emp);

			$insc_munic = '0';
			if($reg_end_emp->Insc_Municipal!='')
				$insc_munic = limpa_numero($reg_end_emp->Insc_Municipal);
			$cnae_munic = $reg_end_emp->CNAE_Municipal;
			//cria objeto xml
			if ($Layout=='15'){
				$xml = new XML("1.0","ISO-8859-1");
			}else{
				$xml = new XML(" ");
			}
			$joinville_novo = false;
			if ($joinville_novo){
				$Layout = '17N';
			}
			$nfse = &$xml->createRoot("EnviarLoteRpsEnvio");
			if ($Layout=='5'){ //curitiba
				$nfse->addAttribute('xmlns', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);
				$nfse->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
				$nfse->addAttribute('xsi:schemaLocation', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);
			}else if ($Layout=='16'){ //betha jaragua do sul
				$nfse->addAttribute('xmlns', 'http://www.betha.com.br/e-nota-contribuinte-ws', true);
			}else if ($Layout=='17'){ //joinville
				$nfse->addAttribute('xmlns', 'http://nfews.joinville.sc.gov.br', true);
			}else if ($Layout=='17N'){ //joinville
				$nfse->addAttribute('xmlns', 'http://www.publica.inf.br', true);
				//$nfse->addAttribute('xmlns:xsi', 'http://www.w3.org/2001/XMLSchema-instance', true);
				//$nfse->addAttribute('xsi:schemaLocation', 'http://www.publica.inf.br schema_nfse_v03.xsd', true);
			}else{
				$nfse->addAttribute('xmlns', 'http://www.abrasf.org.br/nfse.xsd', true);
			}

			

			$lote_rps = &$nfse->addChild("LoteRps");
			if ($Layout=='5'){ //curitiba
				$lote_rps->addAttribute('id', $nr_lote, true);
			}else if ($Layout=='16'){ //betha jaragua do sul
				//$lote_rps->addAttribute('Id', 'lote', true);
				$lote_rps->addAttribute('Id', 'lote_1', true);
				$lote_rps->addAttribute('versao', '2.02', true);
			}else if ($Layout=='17'){ //joinville
				//$lote_rps->addAttribute('Id', 'lote_1', true);
				$lote_rps->addAttribute('Id', 'lote_1', true);
				$lote_rps->addAttribute('versao', '2.04', true);
			}else if ($Layout=='17N'){ //joinville
				$lote_rps->addAttribute('versao', '1.00', true);
			}else if ($Layout=='21'){ //brasilia
				$lote_rps->addAttribute('Id', 'lote_1', true);
				$lote_rps->addAttribute('versao', '2.04', true);
			}

			$lote_rps->addAttribute('NumeroLote', $nr_lote, false);
			if ($Layout=='17N'){
				$lote_rps->addAttribute('Cnpj', $cnpj_limpo, false);
				$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
			}else{
				$prestador = &$lote_rps->addChild("Prestador");
				$CpfCnpj = &$prestador->addChild("CpfCnpj");
				$CpfCnpj->addAttribute('Cnpj', $cnpj_limpo, false);
				if (($Layout!='17')&&($Layout!='21')&&($Layout!='22')){ //joinville - brasilia - araucaria ws
					$lote_rps->addAttribute('InscricaoMunicipal', $insc_munic, false);
				}
			}

			
			$lote_rps->addAttribute('QuantidadeRps', 1, false); 


			$lista_rps = &$lote_rps->addChild("ListaRps");
			//$lista_nfs = '';			

			if(1){
				$rps = &$lista_rps->addChild("Rps");
				if ($Layout=='5'){ //curitiba
					//ListaRps -> Rps -> InfRps -> IdentificacaoRps
					$rps->addAttribute('xmlns', 'http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd', true);
					$inf_rps = &$rps->addChild("InfRps");
					$inf_rps->addAttribute('id', 1, true);
					$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
				}elseif ($Layout=='17N'){ //joinville
					//ListaRps -> Rps -> InfRps -> IdentificacaoRps
					$inf_rps = &$rps->addChild("InfRps");
					$inf_rps->addAttribute('id', 'assinar', true);
					$ident_rps = &$inf_rps->addChild('IdentificacaoRps');
				}else{
					//ListaRps -> Rps -> InfDeclaracaoPrestacaoServico -> Rps -> IdentificacaoRps
					$inf_rps = &$rps->addChild("InfDeclaracaoPrestacaoServico");
					if ($Layout==16){ //betha jaragua do sul
						$inf_rps->addAttribute('Id', 'rps'.$nr_doc, true);
					}else if ($Layout=='17'){ //joinville
						$inf_rps->addAttribute('Id', 'infPS_1', true);
					}
					$rps = &$inf_rps->addChild("Rps");
					if ($Layout=='17'){ //joinville
						$rps->addAttribute('Id', 'infRPS_1', true);
					}
					$ident_rps = &$rps->addChild('IdentificacaoRps');
				}
				
				$ident_rps->addAttribute('Numero', $nr_doc, false);
				$ident_rps->addAttribute('Serie', $serie, false);
				$ident_rps->addAttribute('Tipo', '1', false);

				$data = datad(dataf($reg_nota->DH_Emissao));
				if (($Layout=='5')||($Layout=='15')||($Layout=='17N')){ //curitiba - betha - Joinville
					$data = str_replace(' ','T',$reg_nota->DH_Emissao);
				}


				$opt_simples = '1';
				if($reg_empresa->Opt_Simples == 'N'){
					$opt_simples = '2';
				}

				$con_itens= 'SELECT * FROM nota_fiscal_item'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$reg_nota->Empresa.'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Prod_Depart=0'.
							' ORDER BY Seq_Item';
				$res_itens = consulta_sql($con_itens);
				$nrw_itens = consulta_num_registros($res_itens);
				//para cada item da nota
				$lista_desc = '';
				$cidade = $reg_nota->Cidade_FG;
				$pais = '1058';
				$iss_cst = 'I';
				$iss_aliq = 0;
				$iss_bc = 0;
				$iss_valor = 0;
				$iss_retido = 0;
				$codigo_servico = '';

				$total_irrf = 0;
				$total_inss = 0;
				$total_pis = 0;
				$total_cofins = 0;
				$total_csll = 0;

				$total_outros = 0;
				$desconto     = $reg_nota->Total_Desconto;
				$valor_serv   = $reg_nota->Total_Servicos+$desconto;

				$val_impo_total=0;

				for($itens=0;$itens<$nrw_itens;$itens++){
					$reg_itens = consulta_ler_objeto($res_itens);
					if ($lista_desc!=''){
						$lista_desc.=';';
					}
					if ($reg_itens->Servico_Codigo!=''){
						$codigo_servico = $reg_itens->Servico_Codigo;
					}

					if ($reg_itens->ISS_CST!=''){
						$iss_cst = $reg_itens->ISS_CST;
					}

					$lista_desc.=nfe_formata_txt($reg_itens->Observacao);
					if ($reg_itens->ISS_Cidade_FG!=''){
						$cidade = $reg_itens->ISS_Cidade_FG;
					}
					$iss_aliq = $reg_itens->ISS_Aliquota;
					$iss_bc+= $reg_itens->ISS_BC;
					

					$total_irrf+= $reg_itens->IRRF_Valor;
					$total_inss+= $reg_itens->PrevSocial_Valor;
					$total_pis+= $reg_itens-> PIS_Retido_Valor;
					$total_cofins+= $reg_itens->COFINS_Retido_Valor;
					$total_csll+= $reg_itens->CSLL_Valor;

					$total_item = $reg_itens->Valor_Total - $reg_itens->ICMS_Desonerado_Valor;
					if ((substr($reg_itens->CFOP,0,1)=='3')&&
						($reg_itens->Valor_Agregado > 0 )){
						$total_item = $reg_itens->Valor_Agregado;
					}else{
						$total_item+= $reg_itens->ICMSST_Valor;
						//if($reg_itens->ICMS_BC_Adic_Frete=='S')   { $total_item+= $reg_itens->Valor_Frete; }
						$total_item+= $reg_itens->Valor_Frete;
						$total_item+= $reg_itens->Valor_Outros;
						//if($reg_itens->ICMS_BC_Adic_IPI=='S')     { $total_item+= $reg_itens->IPI_Valor; }
						$total_item+= $reg_itens->IPI_Valor;
					}
					$val_impoF = ($total_item) * ($reg_itens->Perc_TributosF/100);
					$val_impoE = ($total_item) * ($reg_itens->Perc_TributosE/100);
					$val_impoM = ($total_item) * ($reg_itens->Perc_TributosM/100);
					$val_impoF = arredonda_numero_menos($val_impoF*100)/100;
					$val_impoE = arredonda_numero_menos($val_impoE*100)/100;
					$val_impoM = arredonda_numero_menos($val_impoM*100)/100;
					$val_impo  = $val_impoF+$val_impoE+$val_impoM;
					if ($val_impo>0){
						$val_impo_total+= $val_impo;
					}
					$con_obs =  'SELECT * FROM nota_fiscal_obs'.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$reg_nota->Empresa.'"'.
								' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
								' AND Seq_Item="'.$reg_itens->Seq_Item.'"'.
								' GROUP BY Texto_Completo'.
								' ORDER BY Seq_Obs';
					$res_obs = consulta_sql($con_obs);
					$nrw_obs = consulta_num_registros($res_obs);
					for($obss=0;$obss<$nrw_obs;$obss++){
						$reg_obs = consulta_ler_objeto($res_obs);
						if ($lista_desc!=''){
							$lista_desc.=';';
						}
						$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
					}
					consulta_limpa($res_obs);
				}

				if($iss_cst=='I'){
					$sit_rps = '3';
				}else if(($iss_cst=='N')||($iss_cst=='S')||($iss_cst=='R')){
					if($cidade!=''){
						if($cidade != $reg_end_emp->Codigo_Cidade){
							$sit_rps = '2';
						}else{
							$sit_rps = '1';
						}
					}else{
						$sit_rps = '1';
					}
				}

				$nat_op_iss = '101';//ISS devido para Joinville
				if ($opt_simples=='1'){
					$nat_op_iss = '107';//ISS devido para Joinville (Simples Nacional)
				}
				if($iss_cst=='I'){
					$nat_op_iss = '103';//ISENTO
					$mei = ((substr($reg_empresa->Nome_Razao,-3)=='MEI') ||(substr($reg_empresa->Nome_Razao,-6)=='M.E.I.'));
					if ($mei){
						$nat_op_iss = '109';//MEI
					}	
				}else if(($iss_cst=='N')||($iss_cst=='S')){
					if($cidade!=''){
						if($cidade != $reg_end_emp->Codigo_Cidade){
							$nat_op_iss = '102';//ISS devido para outro Municpio
							if ($opt_simples=='1'){
								$nat_op_iss = '108';//ISS devido para outro Municpio (Simples Nacional)
							}
						}else{
							$nat_op_iss = '101';//ISS devido para Joinville
							if ($opt_simples=='1'){
								$nat_op_iss = '107';//ISS devido para Joinville (Simples Nacional)
							}
						}
					}else{
						$nat_op_iss = '101';//ISS devido para Joinville
						if ($opt_simples=='1'){
							$nat_op_iss = '107';//ISS devido para Joinville (Simples Nacional)
						}
					}
				}else if ($iss_cst=='R'){
					$nat_op_iss = '105';//ISS retido pelo tomador
					if ($opt_simples=='1'){
						$nat_op_iss = '110';//ISS retido pelo tomador (Simples Nacional)
					}
				}
				//$nat_op_iss = substr($nat_op_iss,1,2);

				// 104 IMUNE*
				// 103 ISENTO
				// 112 ISS devido em Joinville, prestado fora
				// 101 ISS devido para Joinville
				// 107 ISS devido para Joinville (Simples Nacional)
				// 102 ISS devido para outro Municpio
				// 108 ISS devido para outro Municpio (Simples Nacional)
				// 106 ISS FIXO*
				// 111 ISS prestado em Joinville sem valor de ISS devido*
				// 105 ISS retido pelo tomador
				// 110 ISS retido pelo tomador (Simples Nacional)
				// 109 MEI*
				// 150 Nota Avulsa*

				if ($Layout=='5'){ //curitiba - Joinville
					$inf_rps->addAttribute('DataEmissao', $data, false);
					$inf_rps->addAttribute('NaturezaOperacao', $sit_rps, false);
					//$inf_rps->addAttribute('RegimeEspecialTributacao', '0', false);
					$inf_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
					$inf_rps->addAttribute('IncentivadorCultural', '2', false);
					$inf_rps->addAttribute('Status', $status, false);
				} else if ($Layout=='17N'){ //Joinville
					$inf_rps->addAttribute('DataEmissao', $data, false);
					$inf_rps->addAttribute('NaturezaOperacao', $nat_op_iss, false);
					$inf_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
					$inf_rps->addAttribute('IncentivadorCultural', '2', false);
					$inf_rps->addAttribute('Status', $status, false);
				} else{
					$rps->addAttribute('DataEmissao', $data, false);
					$rps->addAttribute('Status', '1', false);
				}


				//RPS SUBSTITUIDO
				$con_ref =  'SELECT * FROM nota_fiscal_refenciada '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Empresa="'.$reg_nota->Empresa.'"'.
							' AND Tipo_Doc="N"'.
							' ORDER BY Seq_Doc '.
							' LIMIT 1 ';
				$res_ref = consulta_sql($con_ref);
				$nrw_ref = consulta_num_registros($res_ref);
				if($nrw_ref>0){
					$reg_ref = consulta_ler_objeto($res_ref);
					$sub_rps = &$inf_rps->addChild('RpsSubstituido');
					$serie_s = $reg_ref->NF_Serie;
					if ($Layout=='22'){//araucaria  sempre serie 1
						$serie_s = '1';
					}
					$sub_rps->addAttribute('Numero', $reg_ref->NF_Nr_Doc, false);
					$sub_rps->addAttribute('Serie', $serie_s, false);
					$sub_rps->addAttribute('Tipo', '1', false); //1 - RPS
				}
				consulta_limpa($res_ref);	

				$competencia = datad(dataf($reg_nota->DH_Emissao));
				
				

				$con_obs = 'SELECT * FROM nota_fiscal_obs'.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$reg_nota->Empresa.'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
							' AND Seq_Item=0'.
							' AND Seq_Obs>3 '.
							' GROUP BY Texto_Completo'.
							' ORDER BY Seq_Obs';
				$res_obs = consulta_sql($con_obs);
				$nrw_obs = consulta_num_registros($res_obs);
				for($obss=0;$obss<$nrw_obs;$obss++){
				$reg_obs = consulta_ler_objeto($res_obs);
					if ($lista_desc!=''){
						$lista_desc.=';';
					}
					$lista_desc.=nfe_formata_txt($reg_obs->Texto_Completo);
				}
				consulta_limpa($res_obs);

				$lista_vencto = '';
				$venc = 'SELECT DT_Vencimento FROM nota_fiscal_parcela'.
						' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$reg_nota->Empresa.'"'.
						' AND Nr_Nota="'.$reg_nota->Nr_Nota.'" '.
						' ORDER BY DT_Vencimento';
				$res_venc = consulta_sql($venc);
				$nrw_venc = consulta_num_registros($res_venc);
				for ($v=0;$v<$nrw_venc;$v++){
					$reg_venc = consulta_ler_objeto($res_venc);
					if($reg_venc->DT_Vencimento!='0000-00-00' && $reg_venc->DT_Vencimento!=''){
						if ($lista_vencto!='') $lista_vencto.= ', ';
						$lista_vencto.= nfe_formata_txt(dataf($reg_venc->DT_Vencimento));
					}
				}
				consulta_limpa($res_venc);

				$lista_desc = str_replace(";","\r\n",$lista_desc);
				if ($_SESSION['Dominio']==99)$lista_vencto='';
				if($lista_vencto!=''){
					$lista_desc.= "\r\nVencimento: ".$lista_vencto;
				}

				if (($Layout=='15')||($Layout=='16')||($Layout=='17N')){//itanhaem - betha (jaragua)
					$valor_serv = arredonda_numero_menos(($valor_serv - $desconto) * 100)/100;
					$desconto = 0;
				}

				$con_tp_serv = 'SELECT Codigo_CNAE, AliquotaISS FROM tipo_servico '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
								' AND Codigo_Servico="'.$codigo_servico.'"';
				$res_tp_serv = consulta_sql($con_tp_serv);
				$reg_tp_serv = consulta_ler_objeto($res_tp_serv);
				consulta_limpa($res_tp_serv);

				if ($iss_aliq<=0){
					$iss_aliq = $reg_tp_serv->AliquotaISS;
				}

				$iss_valor = nfe_numero(arredonda_numero_menos($iss_bc * $iss_aliq)/100,2);
				if ($iss_cst=='I'){
					//$iss_bc     = 0;
					$iss_valor  = 0;
				}
				if($iss_cst=='R'){
					$iss_retido = $iss_valor;
					$iss_valor = 0;
				}
				if($iss_valor>0){
					if($iss_cst=='R'){
						if ($reg_nota->Empresa_CRT=='S'){
							$iss_valor = 0;
						}
					}
				}

				$vl_liquido = ($valor_serv-
								$desconto-
								$total_pis-
								$total_cofins-
								$total_inss-
								$total_irrf-
								$total_csll-
								$total_outros-
								$iss_retido);

				$codigo_servico_s = $codigo_servico;
				if (($Layout=='17')||($Layout=='21')||($Layout=='22')){//joinville - brasilia - araucaria ws
					$codigo_servico_s = fill_full($codigo_servico_s,5);
				}
				if (($Layout=='16')||($Layout=='17N')){//betha jaraqua
					$codigo_servico_s = str_replace(".", "", $codigo_servico_s);
				}

				if (($Layout=='5')||($Layout=='17N')){
					//nao tem mais mapos
				}else{
					$inf_rps->addAttribute('Competencia', $competencia, false);
				}

				$inf_serv    = &$inf_rps->addChild('Servico');
				$inf_valores = &$inf_serv->addChild('Valores');
				$inf_valores->addAttribute('ValorServicos', nfe_numero($valor_serv,2), false);

				if ($Layout=='17N'){
					$inf_valores->addAttribute('ValorDeducoes', nfe_numero($desconto,2), false);
					$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
					$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
					$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
					$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
					$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
				}else{
					if ($Layout=='5'){//curitiba
						$inf_valores->addAttribute('ValorDeducoes', nfe_numero(0,2), false);
					}else if($desconto>0){
						$inf_valores->addAttribute('ValorDeducoes', nfe_numero($desconto,2), false);
					}
	
					if($total_pis>0){
						$inf_valores->addAttribute('ValorPis', nfe_numero($total_pis,2), false);
					}
					if($total_cofins>0){
						$inf_valores->addAttribute('ValorCofins', nfe_numero($total_cofins,2), false);
					}
					if($total_inss>0){
						$inf_valores->addAttribute('ValorInss', nfe_numero($total_inss,2), false);
					}
					if($total_irrf>0){
						$inf_valores->addAttribute('ValorIr', nfe_numero($total_irrf,2), false);
					}
					if($total_csll>0){
						$inf_valores->addAttribute('ValorCsll', nfe_numero($total_csll,2), false);
					}
				}
				
				if (($Layout!='5')&&($Layout!='17N')){//curitiba
					if($total_outros>0){
						$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
					}
				}

				if (($Layout=='21')||($Layout=='22')){//joinville - brasilia - araucaria ws
					if($val_impo_total>0){
						$inf_valores->addAttribute('ValTotTributos', nfe_numero($val_impo_total,2), false);
					}
				}

				if (($Layout=='5')||($Layout=='17N')){//curitiba - joinville
					if($iss_cst=='R'){
						$inf_valores->addAttribute('IssRetido', '1', false);
					}else{
						$inf_valores->addAttribute('IssRetido', '2', false);
					}
				}

				$inf_valores->addAttribute('ValorIss', nfe_numero($iss_valor,2), false);
				if (($Layout=='5')||($Layout=='13')||($Layout=='15')||($Layout=='16')){//curitiba - araquari - itahaem - jaraqua
					$aliq = nfe_numero(($iss_aliq/100),2); //2% fica 0.02
				}else{
					$aliq = nfe_numero(($iss_aliq),2);		//2% fica 2.00
				}
				if ($Layout=='5'){//curitiba
					$inf_valores->addAttribute('ValorIssRetido', nfe_numero($iss_retido,2), false);
					if($total_outros>0){
						$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
					}
					$inf_valores->addAttribute('BaseCalculo', nfe_numero($iss_bc,2), false);
					$inf_valores->addAttribute('Aliquota', $aliq, false);

					$inf_valores->addAttribute('ValorLiquidoNfse', nfe_numero($vl_liquido,2), false);
					$inf_valores->addAttribute('DescontoIncondicionado', nfe_numero(0,2), false);
					$inf_valores->addAttribute('DescontoCondicionado', nfe_numero(0,2), false);
				}else
				if ($Layout=='17N'){//joinville
					if($iss_cst=='R'){
						$inf_valores->addAttribute('ValorIssRetido', nfe_numero($iss_retido,2), false);
					}
					//if($total_outros>0){
					$inf_valores->addAttribute('OutrasRetencoes', nfe_numero($total_outros,2), false);
					if($iss_cst=='R'){
						$inf_valores->addAttribute('BaseCalculo', nfe_numero($iss_bc,2), false);
					}
					$inf_valores->addAttribute('Aliquota', $aliq, false);
					if($iss_cst=='R'){
						$inf_valores->addAttribute('ValorLiquidoNfse', nfe_numero($vl_liquido,2), false);
					}
					$inf_valores->addAttribute('DescontoIncondicionado', nfe_numero(0,2), false);
					$inf_valores->addAttribute('DescontoCondicionado', nfe_numero(0,2), false);
				}else{
					if($aliq>0){
						$inf_valores->addAttribute('Aliquota', $aliq, false);
					}	
					//DescontoIncondicionado
					//DescontoCondicionado
					if($iss_cst=='R'){
						$inf_serv->addAttribute('IssRetido', '1', false);
						$inf_serv->addAttribute('ResponsavelRetencao', '1', false);
					}else {
						$inf_serv->addAttribute('IssRetido', '2', false);
					}
				}

				//$reg_itens->Servico_Codigo = '10.01'; TESTE
				if($codigo_servico==''){
					echo '<font size="2" face="Verdana">Cdigo do servio no informado. Defina o cdigo no cadastro de servios!</font><br>';
					return 0;
				}

				$inf_serv->addAttribute('ItemListaServico', $codigo_servico_s, false);

				if ($Layout=='5'){//curitiba
					if($reg_tp_serv->Codigo_CNAE!=''){
						$inf_serv->addAttribute('CodigoCnae', limpa_numero($reg_tp_serv->Codigo_CNAE), false);
					}
				}else if (($Layout=='15')||($Layout=='16')){//itahaem - betha jaragu
					$cnae_munic = limpa_numero($reg_end_emp->CNAE_Municipal);
					$inf_serv->addAttribute('CodigoCnae', $cnae_munic, false);
				}
				
				//$inf_serv->addAttribute('CodigoTributacaoMunicipio', $cnae_munic, false);
				//CodigoTributacaoMunicipio
				//CodigoNbs

				$pais= '1058';
				$max_desc = 2000;
				if ($Layout=='17N'){ $max_desc = 10000; }

				$inf_serv->addAttribute('Discriminacao', nfsexml_carac2especial(trim(substr($lista_desc,0,$max_desc))), false);
				$inf_serv->addAttribute('CodigoMunicipio', $cidade, false);
				if ($Layout=='15'){ //itahaem
					$inf_serv->addAttribute('CodigoPais', $pais, false);
				}
				
				if (($Layout!='5')&&($Layout!='17N')){ //nao  curitiba/joinville
					//IdentifNaoExigibilidade
					// 1 - Exigivel; 
					// 2 - Nao incidencia; 
					// 3 - Isencao; 
					// 4 - Exportacao; 
					// 5 - Imunidade; 
					// 6 - Exigibilidade Suspensa por Decisao Judicial; 
					// 7 - Exigibilidade Suspensa por Processo Administrativo)

					$inf_serv->addAttribute('ExigibilidadeISS', $sit_rps, false);
					if ($Layout!='15'){
						if (($sit_rps=='1') || ($sit_rps=='6') || ($sit_rps=='7')){
							$inf_serv->addAttribute('MunicipioIncidencia', $cidade, false);
						}
					}
				}

				//NumeroProcesso
				$inf_prest = &$inf_rps->addChild('Prestador');
				if ($Layout=='17N'){
					$inf_prest->addAttribute('Cnpj', $cnpj_limpo, false);
					if($insc_munic!=''){
						$inf_prest->addAttribute('InscricaoMunicipal', $insc_munic, false);
					}
				}else{
					$prest_cpf_cnpj = &$inf_prest->addChild('CpfCnpj');
					$prest_cpf_cnpj->addAttribute('Cnpj', $cnpj_limpo, false);
					if (($Layout!='17')&&($Layout!='21')&&($Layout!='22')){//joinville - brasilia - araucaria_ws
						if($insc_munic!=''){
							$inf_prest->addAttribute('InscricaoMunicipal', $insc_munic, false);
						}
					}
				}
				

				$con_tom =  'SELECT '.
							' CPF_CNPJ,'.
							' Nome_Razao,'.
							' EMail'.
							' FROM pessoa '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							' AND Pessoa="'.$reg_nota->Destinatario.'"';
				$res_tom = consulta_sql($con_tom);
				$reg_tom = consulta_ler_objeto($res_tom);
				consulta_limpa($res_tom);

				$con_end_tom =  'SELECT'.
								' Insc_Municipal,'.		//0
								' CEP,'.				//1
								' Logradouro,'.			//2
								' Numero,'.				//3
								' Bairro,'.				//4
								' Complemento, '.		//5
								' UF,'.					//6
								' Codigo_Cidade,'.		//7
								' Nome_Cidade,'.		//8
								' Insc_Estadual,'.		//9
								' Codigo_Pais'.			//10
								' FROM pessoa_endereco '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Seq_Endereco="'.$reg_nota->Dest_Endereco.'"';
				$res_end_tom = consulta_sql($con_end_tom);
				$reg_end_tom = consulta_ler_objeto($res_end_tom);
				consulta_limpa($res_end_tom);

				$tomador_im   = limpa_numero($reg_end_tom->Insc_Municipal);
				$tomador_cnpj = limpa_numero($reg_tom->CPF_CNPJ);

				if (($Layout!='5')&&($Layout!='17N')){
					$inf_tom = &$inf_rps->addChild('TomadorServico');
				}else{
					$inf_tom = &$inf_rps->addChild('Tomador');
				}
				$nome_tomador = 'TOMADOR NAO IDENTIFICADO';
				$informa_end = false;

				if($reg_tom->CPF_CNPJ!=''){
					$inf_idtom = &$inf_tom->addChild('IdentificacaoTomador');
					$inf_cpftom = &$inf_idtom->addChild('CpfCnpj');

					if(strlen($tomador_cnpj)==11){
						$inf_cpftom->addAttribute('Cpf', $tomador_cnpj, false);
						if($tomador_cnpj!='00000000000'){
							$nome_tomador = $reg_tom->Nome_Razao;
							$informa_end = true;
						}
					}else if(strlen($tomador_cnpj)==14){
						$inf_cpftom->addAttribute('Cnpj', $tomador_cnpj, false);
						if($tomador_cnpj!='00000000000000'){
							$nome_tomador = $reg_tom->Nome_Razao;
							$informa_end = true;
						}
					}
					if ($informa_end){
						if ($Layout=='5'){//curitiba
							if($reg_end_tom->Codigo_Cidade=='4106902'){
								if($tomador_im!=''){
									$inf_idtom->addAttribute('InscricaoMunicipal', $tomador_im, false);
								}
							}
						}
						if ($Layout=='17'){//joinville
							if($reg_end_tom->Codigo_Cidade=='4209102'){
								if($tomador_im!=''){
									$inf_idtom->addAttribute('InscricaoMunicipal', $tomador_im, false);
								}
							}
						}
					}					
				}
				//NifTomador
				$inf_tom->addAttribute('RazaoSocial', nfsexml_carac2especial(substr(trim($nome_tomador),0,115)), false);
				if($informa_end){
					$end_uf       = nfsexml_carac2especial(substr(trim($reg_end_tom->UF),0,2));
					$end_munic    = nfsexml_carac2especial(substr(limpa_numero($reg_end_tom->Codigo_Cidade),0,7));

					$end_endereco = nfsexml_carac2especial(substr(trim($reg_end_tom->Logradouro),0,200));
					$end_num      = nfsexml_carac2especial(substr(limpa_numero($reg_end_tom->Numero),0,10));
					$end_comp     = nfsexml_carac2especial(substr(trim($reg_end_tom->Complemento),0,60));
					$end_bairro   = nfsexml_carac2especial(substr(trim($reg_end_tom->Bairro),0,60));
					$end_munic_d  = nfsexml_carac2especial(substr(trim($reg_end_tom->Nome_Cidade),0,60));
					$end_cep      = nfsexml_carac2especial(substr(limpa_numero($reg_end_tom->CEP),0,8));
					$end_pais     = nfsexml_carac2especial(substr(limpa_numero($reg_end_tom->Codigo_Pais),0,8));

					if ($end_uf=='EX'){ 
						$end_munic=='9999999'; 
					}else{
						$end_pais = '1058';
					}

					if (($end_uf=='EX') && (($Layout=='17')||($Layout=='21')||($Layout=='22'))){//brasilia - araucaria_ws
						$inf_end_tom = &$inf_tom->addChild('EnderecoExterior');

						$inf_end_tom->addAttribute('CodigoPais', $end_pais, false);
						
						$end_endereco = trim($end_endereco.' '.$end_num);
						$end_endereco = trim($end_endereco.' '.$end_comp);
						$end_endereco = trim($end_endereco.' '.$end_bairro);
						$end_endereco = trim($end_endereco.' '.$end_munic_d);
						$end_endereco = substr($end_endereco,0,255);

						$inf_end_tom->addAttribute('EnderecoCompletoExterior', $end_endereco, false);
					}else{
						$inf_end_tom = &$inf_tom->addChild('Endereco');
						$inf_end_tom->addAttribute('Endereco', $end_endereco, false);

						if ($end_num!=''){
							$inf_end_tom->addAttribute('Numero', $end_num, false);
						}else{
							if (($Layout=='17')||($Layout=='21')||($Layout=='22')){//joinville - brasilia - araucaria_ws
								$inf_end_tom->addAttribute('Numero', '', false);
							}
							if ($Layout=='17N'){
								$inf_end_tom->addAttribute('Numero', '0', false);
							}
						}
						if ($end_comp!=''){
							$inf_end_tom->addAttribute('Complemento', $end_comp, false);
						}
						$inf_end_tom->addAttribute('Bairro', $end_bairro, false);
						$inf_end_tom->addAttribute('CodigoMunicipio', $end_munic, false);
						$inf_end_tom->addAttribute('Uf', $end_uf, false);
						
						if (($Layout=='15')){//itahaem
							$inf_end_tom->addAttribute('CodigoPais', $end_pais, false);
							if (($end_cep!='')&&($end_munic!='9999999')){
								$inf_end_tom->addAttribute('Cep', $end_cep, false);
							}
						}else if (($Layout=='17N')){//Joinville
							if (($end_cep!='')&&($end_munic!='9999999')){
								$inf_end_tom->addAttribute('Cep', $end_cep, false);
							}							
							if ($end_munic=='9999999'){
								$inf_end_tom->addAttribute('CodigoPais', $end_pais, false);
								$inf_end_tom->addAttribute('Municipio', $end_munic_d, false);
							}
						}else{//betha jaragua - joinville
							if ($end_munic=='9999999'){
								$inf_end_tom->addAttribute('CodigoPais', $end_pais, false);
							}
							if (($end_cep!='')&&($end_munic!='9999999')){
								$inf_end_tom->addAttribute('Cep', $end_cep, false);
							}
													
						}						
					}
				}
				$email = substr(trim($reg_tom->EMail),0,80);
				$tem_contato = ($email!='');//tem e-mail
				$tel_tomador = '';
				
				$con_tom_tel = 'SELECT'.
								' Numero_Telefone '.
								' FROM pessoa_telefone '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Pessoa="'.$reg_nota->Destinatario.'"'.
								' AND Situacao="A"'.
								' ORDER BY Seq_Telefone';
				$res_tom_tel = consulta_sql($con_tom_tel);
				$reg_tom_tel = consulta_ler_objeto($res_tom_tel);
				consulta_limpa($res_tom_tel);
				if ($reg_tom_tel->Numero_Telefone!=''){
					$tel_tomador = $reg_tom_tel->Numero_Telefone;
					$tem_contato = true;
				}

				if($tem_contato){
					$inf_cont_tom = &$inf_tom->addChild('Contato');
					if($tel_tomador!=''){
						$inf_cont_tom->addAttribute('Telefone', substr(limpa_numero($tel_tomador),0,20), false);
					}
					if($email!=''){
						$inf_cont_tom->addAttribute('Email', $email, false);
					}
				}
				//<Intermediario
				//	<IdentificacaoIntermediario
				//		<CpfCnpj
				//			<Cnpj
				//			<Cpf
				//		<InscricaoMunicipal
				//	<RazaoSocial
				//	<CodigoMunicipio

				//ConstrucaoCivil
				//	CodigoObra
				//	Art

				
				if (($Layout!='5')&&($Layout!='17N')){//curitiba//joinville
					if (($opt_simples=='1')&&($Layout!=15)){//itanhaem
						/*
						1 - Microempresa municipal
						2 - Estimativa
						3 - Sociedade de profissionais
						4 - Cooperativa
						5 - Microempresrio Individual (MEI)
						6 - Microempresrio e Empresa de Pequeno Porte (ME EPP)
						*/
						$mei = ((substr($reg_empresa->Nome_Razao,-3)=='MEI') ||(substr($reg_empresa->Nome_Razao,-6)=='M.E.I.'));
						$me  = ((substr($reg_empresa->Nome_Razao,-4)=='ME')  ||(substr($reg_empresa->Nome_Razao,-4)=='M.E.'));
						$epp = ((substr($reg_empresa->Nome_Razao,-3)=='EPP') ||(substr($reg_empresa->Nome_Razao,-6)=='E.P.P.'));
						//$coop= ((substr($reg_empresa->Nome_Razao,0,4)=='CCOP'));
						//$prof= ((substr($reg_empresa->Nome_Razao,0,4)=='SIND')||(substr($reg_empresa->Nome_Razao,0,4)=='SOCI'));
						$regime = 1;
						if ($mei) { $regime = 5; } else
						if (($me)||($epp)) { $regime = 6; } //else
						//if ($coop) { $regime = 4; } else
						//if ($prof) { $regime = 3; }
						$inf_rps->addAttribute('RegimeEspecialTributacao', $regime, false);
					}

					$inf_rps->addAttribute('OptanteSimplesNacional', $opt_simples, false);
					$inf_rps->addAttribute('IncentivoFiscal', '2', false);
				}
			}

			// diretrios de criao do arquivo xml
			rmkdir(nfse_pasta_raiz().'tmp/');
			$xml->toFile(nfse_pasta_raiz().'tmp/', $nome_arquivo_ped);
			$salvou = file_exists(nfse_pasta_raiz().'tmp/'.$nome_arquivo_ped);
		}else{
			$salvou = true;
		}
		return $salvou;
	}

	//joinville
	function nota_fiscal_envio_jaragua_do_sul_gerar_nfse($reg_nota){
		$Layout = '16';
		$versao = '2.02';
		$cidade = '4208906';
		return nota_fiscal_envio_gerar_nfse_abrasf($reg_nota,$Layout,$versao,$cidade);
	}

	//joinville
	function nota_fiscal_envio_joinville_gerar_nfse($reg_nota,$transmitir=true){
		$Layout = '17N';
		$versao = '1.00';
		$cidade = '4209102';
		return nota_fiscal_envio_gerar_nfse_abrasf($reg_nota,$Layout,$versao,$cidade,$transmitir);
	}

	//brasilia
	function nota_fiscal_envio_brasilia_gerar_nfse($reg_nota){
		$Layout = '21';
		$versao = '2.04';
		$cidade = '5300108';
		return nota_fiscal_envio_gerar_nfse_abrasf($reg_nota,$Layout,$versao,$cidade);
	}

	//araucaria ws
	function nota_fiscal_envio_araucaria_ws_gerar_nfse($reg_nota){
		$Layout = '22';
		$versao = '2.04';
		$cidade = '4101804';
		return nota_fiscal_envio_gerar_nfse_abrasf($reg_nota,$Layout,$versao,$cidade);
	}

	function nota_fiscal_envio_gerar_nfse_abrasf($reg_nota,$Layout,$versao,$cidade,$transmitir=true){
		$retorno = 0;
		$salvou  = false;
		$status  = 1;
		set_time_limit(300);
		
		$cnpj_limpo = limpa_numero($reg_nota->Empresa_CNPJ);

		if($reg_nota->NFSe_Nr!=''){
			echo '<font size="2" face="Verdana">NFS-e j foi processada!</font><br>';
			flush(); @ob_flush();
			flush(); @ob_flush();
			return 1;
		}

		if ($reg_nota->Situacao=='C'){
			echo '<font size="2" face="Verdana">Falha ao enviar RPS '.$reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo.'!</font><br>';
			echo '<font size="2" face="Verdana">Envio no realizado! Situao "Cancelada"  Invlida!</font><br>';
			return 0;
		}else{
			$pode_enviar = (($reg_nota->Situacao=='I')||
						    ($reg_nota->Situacao=='P')||
						    ($reg_nota->Situacao=='A')||
						    ($reg_nota->Situacao=='F'));
			
			if (!$pode_enviar){
				echo '<font size="2" face="Verdana">Falha ao enviar RPS '.$reg_nota->NrDoc.'/'.$reg_nota->Serie.'-'.$reg_nota->Modelo.'!</font><br>';
				echo '<font size="2" face="Verdana">Envio no realizado! RPS no est pronta para envio!</font><br>';
				nfse_retorna_nfse2($reg_nota->Nr_Nota,'I');
				return 0;
			}else{
				if ($transmitir){
					echo '<font size="2" face="Verdana">Gerando Arquivo de Envio...</font><br><br>';
				}
				

				$nr_doc = $reg_nota->NrDoc;

				if (($reg_nota->NFSe_Lote>0)){
					$nr_lote = $reg_nota->NFSe_Lote;
				}else{
					$nr_lote = nfse_cria_lote($reg_nota->Empresa,$reg_nota->Modelo,$reg_nota->Serie);
					$sql =  'UPDATE nota_fiscal SET'.
							' NFSe_Lote="'.$nr_lote.'", '.
							' NFSe_Versao="'.$versao.'", '.
							' NFSe_Lote_C="",'.
							' NFSe_Lote_DH_Envio="'.data_atual('date').' '.hora_atual('hora').'" '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$reg_nota->Empresa.'"'.
							' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
					consulta_sql($sql);
					$reg_nota->NFSe_Lote = $nr_lote;
					$reg_nota->NFSe_Lote_C = '';
				}	
				$nome_arquivo_ped = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-env-loterps.xml';
					
				$existeC = false;
				$pasta_retorno = 'Retorno';

				$nome_arquivo_consulta_retorno = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-loterps.xml';
				if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno)) {
					$existeC = true;
				}
				if (($existeC)||($reg_nota->NFSe_Lote_C!='')){
					$salvou = true;
				}else{					
					$salvou = nota_fiscal_envio_nfse_gerar_arquivo_abrasf($reg_nota,$cnpj_limpo,$nr_doc,$nr_lote,$cidade,$Layout);
				}
				// return false;
				if ($salvou){
					if ($transmitir){
						echo '<font size="2" face="Verdana">Transmitindo arquivo...</font><br><br>';
						$retorno = nfse_processa_abrasf($reg_nota, $Layout);
						if ($retorno){//se nota fechada reabre pra refazer o nr da fatura
							$con_nrdoc= 'SELECT NFSe_Nr FROM nota_fiscal '.
										' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$reg_nota->Empresa.'"'.
										' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
							$res_nrdoc = consulta_sql($con_nrdoc);
							$reg_nrdoc = consulta_ler_objeto($res_nrdoc);
							consulta_limpa($res_nrdoc);

							if ($reg_nrdoc->NFSe_Nr>0){
								if ($_SESSION['Dominio']!=99){
									$con_upt =  'UPDATE contas_pr SET'.
												' Nr_Doc="'.$reg_nrdoc->NFSe_Nr.'" '.
												' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
												' AND Empresa="'.$reg_nota->Empresa.'"'.
												' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
												' AND Modelo="'.$reg_nota->Modelo.'"'.
												' AND TipoPR="R"';
									consulta_sql($con_upt);
								}
							}
						}
					}else{

						$caminho     = "../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$reg_nota->Empresa."/lote/";
						$caminho_tmp = "../../../arquivos_clientes/".$_SESSION['Dominio']."/nfs_e/".$reg_nota->Empresa."/tmp/";

						//finaliza arquivo na pasta tmp
						rmkdir($caminho,0777);
						$nome_arq = limpa_numero(data_atual('date')).
									limpa_numero($reg_nota->Empresa_CNPJ).
									fill_full($nr_lote,10)."rps.xml";

						if (file_exists($caminho.$nome_arq)) {
							usleep(200);
							unlink($caminho.$nome_arq);
						}					
						$retorno = 0;

						if (file_exists($caminho_tmp.$nome_arquivo_ped)) {
							//efetiva acopia do arquivo
							//echo $arq_ori.'-'.$arq_des.'<BR>';
							$copiou = copy($caminho_tmp.$nome_arquivo_ped, $caminho.$nome_arq);
							if ($copiou) $retorno = 1; 
						}
					}
				}else{
					echo '<font size="2" face="Verdana">Falha ao gerar arquivo "'.$nome_arquivo_ped.'" na pasta "tmp"!</font><br>';
					nfse_retorna_nfse2($reg_nota->Nr_Nota,'I');
					$retorno = 0;
				}
			}
		}
		return $retorno;
	}
