<?php
    require_once(dirname(__FILE__).'/ie.php');


    function nfse_retira_texto_excesso($texto, $inicio, $tamanho_max){
        //descobre quantos carates < > " ' & existem no texto
        // o limite vai ser menor se existirem esses caracteres
        //por que no xml eles ocupam mais do que uma posio

        //primeiro tira os primeiros $tamanjho de caracteres caracteres)
        $texto = trim(substr(trim($texto), $inicio, $tamanho_max));
        $texto_final = '';
        //$conta_menor = substr_count($texto_final,'>');
        $tamanho  = strlen($texto);
        $tamanho_total = 0;
        for ($t = 0; $t < $tamanho; $t++) {
            $tamanho_car = 1;
            if (($texto[$t] == '<') || ($texto[$t] == '>')) {
                $tamanho_car = 4;
            } else if (($texto[$t] == '"') || ($texto[$t] == "'")) {
                $tamanho_car = 6;
            } else if ($texto[$t] == '&') {
                $tamanho_car = 5;
            }
            $tamanho_total += $tamanho_car;
            if ($tamanho_total <= $tamanho_max) {
                $texto_final .= $texto[$t];
            }
        }

        return trim($texto_final);
    }

    function nfse_copia_arquivo($origem, $destino, $arquivo, $nr_nota = '', $renomeia = false, $apaga = true){
        //determina nome do arquivo de origem
        $arq_ori = nfse_pasta_raiz().$origem.'/'.$arquivo;

        //determina nome do arquivo de destino
        $arq_des = nfse_pasta_raiz().$destino.'/'.$arquivo;
        //se renomeia
        if ($renomeia) {
            //arquivo de destino  com a data/hora no incio do mesmo
            $data_hora = data_atual('date').nr2hora(hora_atual());
            $data_hora = str_replace('-', '', $data_hora);
            $data_hora = str_replace(':', '', $data_hora);
            $arq_des = nfse_pasta_raiz().$destino.'/'.$data_hora.'_'.$arquivo;
        }

        //verifica se arquivo de origem existe
        if (file_exists($arq_ori)) {
            //verifica se pasta de destino existe
            if (!(file_exists(nfse_pasta_raiz().$destino))) {
                //seno cria ela (ano_mes)
                rmkdir(nfse_pasta_raiz().$destino."/", 0777);
            }

            //verifica se destino existe
            if (file_exists($arq_des)) {
                //apaga arquivo de destino caso exista alguma coisa
                unlink($arq_des);
            }
            //efetiva acopia do arquivo
            //echo $arq_ori.'-'.$arq_des.'<BR>';
            $copiou = copy($arq_ori, $arq_des);

            //se fez a copia corretamente
            if ($copiou) {
                //se a instruo for de apagar o arquivo de origem
                if ($apaga) {
                    //apaga o arquivo de origem
                    unlink($arq_ori);
                }
                return true;
            } else {
                nfse_exibe_erro(
                    'FRE-004',
                    'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
                        'Verifique a estrutura de pastas do servidor!',
                    $nr_nota
                );
                return false;
            }
        } else { //seno
            //exibe erro de arquivo inexistente
            nfse_exibe_erro(
                'FRE-003',
                'Falha ao Copiar Arquivo "'.$arquivo.'" da pasta "'.$origem.'" para a pasta "'.$destino.'"!<BR>'.
                    'Verifique a estrutura de pastas do servidor!',
                $nr_nota
            );
            return false;
        }
    }

    function nfse_abre_arquivo_err($arquivo){
        //abre arquivo de erro na pasta de retorno

        $temp_file = nfse_pasta_raiz().'temp_xml/'.$arquivo;
        $arq_base  = nfse_pasta_raiz().'retorno/'.$arquivo;

        sleep(1);

        if (file_exists($temp_file)) {
            unlink($temp_file);
        }
        //echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
        copy($arq_base, $temp_file);


        $linhas_erro = '';
        $array_of_list_values = file($temp_file);
        foreach ($array_of_list_values as $key => $value) {
            set_time_limit(30);
            $linhas_erro .= $value;
        }
        unset($array_of_list_values);
        unlink($temp_file);
        //le todo o contedo da pasta
        return nl2br($linhas_erro);
    }

    function nfse_pasta_raiz(){
        return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/nfs_e/'.$_SESSION["Empresa_Codigo"].'/';
    }

    function nfse_pasta_raiz2($dominio, $empresa){
        return '../arquivos_clientes/'.$dominio.'/nfs_e/'.$empresa.'/';
    }

    function nfse_pasta_raiz3(){
        return '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/';
    }

    function nfse_exibe_erro($codigo, $mensagem, $lista_notas = 0, $operacao = 'I'){
        //exibe o erro na tela
        echo '<p><font size="2" face="Verdana"><b>'.$codigo.'</b><BR>'.$mensagem.'</font></p><BR><BR>';
        //retorna o status dessa nota para "P"
        if ($lista_notas != 0) {
            nfse_retorna_nfse($lista_notas, $operacao);
        }
    }

    function nfse_retorna_nfse($lista_notas, $operacao){
        $empresa = '';
        $modelo = '';
        $serie = '';
        $subSerie = '';
        $ultLote = '';

        $nf = 0;
        foreach ($lista_notas as $key => $nr_nota) {
            if ($nr_nota != '') {
                if ($nf == 0) {
                    $con_nfe =  'SELECT * FROM nota_fiscal '.
                                ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                                ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"';
                                ' AND Nr_Nota="'.$nr_nota.'"';
                    $res_nfe = consulta_sql($con_nfe);
                    $reg_nfe = consulta_ler_objeto($res_nfe);
                    consulta_limpa($res_nfe);

                    $empresa = $reg_nfe->Empresa;
                    $modelo = $reg_nfe->Modelo;
                    $serie = $reg_nfe->Serie;
                    $subSerie = $reg_nfe->SubSerie;
                    $ultLote = $reg_nfe->NFSe_Lote;
                }

                if ($operacao == 'I') {
                    $upd_nota = 'UPDATE nota_fiscal SET'.
                                ' NFSe_Lote="", '.
                                ' NFSe_Versao="", '.
                                ' NFSe_Lote_DH_Envio="0000-00-00 00:00:00"'.
                                ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                                ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                                ' AND Nr_Nota="'.$nr_nota.'" '.
                                ' AND Situacao="F"';
                    consulta_sql($upd_nota, true, 1);
                } else {
                    $upd_nota = 'UPDATE nota_fiscal SET'.
                                ' NFSe_Lote_C="", '.
                                ' NFSe_Versao="", '.
                                ' NFSe_Lote_C_DH_Envio="0000-00-00 00:00:00"'.
                                ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                                ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                                ' AND Nr_Nota="'.$nr_nota.'" '.
                                ' AND Situacao="F"';
                    consulta_sql($upd_nota, true, 1);
                }
                $nf++;
            }
        }

        $upd_doc =  'UPDATE nota_fiscal_serie SET '.
                    ' NFSe_Lote = NFSe_Lote - 1 '.
                    ' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
                    ' AND Empresa="'.$empresa.'"'.
                    ' AND Modelo="'.$modelo.'"'.
                    ' AND Serie="'.$serie.'"'.
                    ' AND SubSerie="'.$subSerie.'"'.
                    ' AND NFSe_Lote="'.$ultLote.'"';
        consulta_sql($upd_doc, true, 1);
    }

    function nfse_retorna_nfse2($nr_nota, $operacao){
        if ($operacao == 'I') {
            $upd_nota = 'UPDATE nota_fiscal SET'.
                        ' NFSe_Lote="", '.
                        ' NFSe_Lote_C="", '.
                        ' NFSe_Versao="", '.
                        ' NFSe_Lote_DH_Envio="0000-00-00 00:00:00"'.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                        ' AND Nr_Nota="'.$nr_nota.'" '.
                        ' AND ((Situacao="I") or (Situacao="P") or (Situacao="F")';
            consulta_sql($upd_nota, true, 1);
            $upd_nota = 'UPDATE nota_fiscal SET'.
                        ' Situacao="P" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                        ' AND Nr_Nota="'.$nr_nota.'" '.
                        ' AND Situacao="I"';
            consulta_sql($upd_nota, true, 1);
        } else {
            $upd_nota = 'UPDATE nota_fiscal SET'.
                        //' NFSe_Lote_C="", '.
                        ' NFSe_Lote_C_DH_Envio="0000-00-00 00:00:00"'.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                        ' AND Nr_Nota="'.$nr_nota.'" '.
                        ' AND Situacao="F"';
            consulta_sql($upd_nota, true, 1);
        }
    }

    function nfse_copia_arquivo_renomeia($pasta, $origem, $destino){
        $pasta_raiz = nfse_pasta_raiz().$pasta;

        $pasta_raiz = realpath($pasta_raiz);
        $a_origem  = $pasta_raiz.DIRECTORY_SEPARATOR.$origem;
        $a_destino = $pasta_raiz.DIRECTORY_SEPARATOR.$destino;

        if (file_exists($a_destino)) { unlink($a_destino); }
        rename($a_origem, $a_destino);
        if (file_exists($a_origem)) { unlink($a_origem); }
    }

    function nfse_ano_mes($data = '', $tipo = 'AAAAMM'){  //formato 0000-00-00
        if ($data == '') {
            $data = data_atual('date');
        }
        if ($tipo == 'AAAAMM') {
            return $data[0].$data[1] .
                $data[2].$data[3] .
                $data[5].$data[6];
        } else {
            return $data[2].$data[3] .
                $data[5].$data[6];
        }
    }

    function nfse_cria_lote($empresa,$modelo,$serie=''){
        $filt_serie = $modelo;
        if ($serie!=''){
            $filt_serie.='" AND Serie="'.$serie;
        }
        $con_serie= 'select max(NFSe_Lote), Layout_Impressao from nota_fiscal_serie '.
                    ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                    ' and Empresa = "'.$empresa.'"'.
                    ' and Modelo = "'.$filt_serie.'"';
        $res_serie = consulta_sql($con_serie);
        $reg_serie = consulta_ler_linha($res_serie);
        consulta_limpa($res_serie);

        $nr_lote = ($reg_serie[0]+1);

        $upd_nota_serie='UPDATE nota_fiscal_serie SET'.
                        ' NFSe_Lote="'.$nr_lote.'" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$empresa.'"'.
                        ' AND Modelo="'.$filt_serie.'"';
        consulta_sql($upd_nota_serie,true,1);
    
        return $nr_lote;
        
    }

    function nfse_carrega_xml($arquivo){
        $response = file_get_contents($arquivo);
            
        $response = str_replace('SOAP-ENV:',  "",  $response);
        $response = str_replace('soap-env:',  "",  $response); 
        $response = str_replace(':SOAP-ENV=',  "=", $response);
        $response = str_replace(':soap-env=',  "=", $response);
        $response = str_replace('<soap:',     "<", $response);
        $response = str_replace('</soap:',    "</", $response);
        $response = str_replace('<SOAP:',     "<", $response);
        $response = str_replace('</SOAP:',    "</", $response);
        $xml      = simplexml_load_string($response);

        if (isset($xml[0]->Body)){//se tem Envelope - Body
            //$xml[0]->Body->asXml($arquivo);
            $xml_corpo = $xml[0]->Body;
        }else{
           // $xml->asXml($arquivo);
            $xml_corpo = $xml;
        }

        return $xml_corpo;
    }

    function nfse_valida_dados_nfse($nr_nota, $operacao){
        ///valida minimamente os dados da NF-e para minimizar Rejeies na SEFAZ
        $erros = '';

        //conuslta Nota Fiscal

        $con_nfe  = 'SELECT * FROM nota_fiscal '.
                    ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                    ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                    ' AND Nr_Nota="'.$nr_nota.'" ';
        $res_nfe = consulta_sql($con_nfe);
        $reg_nfe = consulta_ler_objeto($res_nfe);
        consulta_limpa($res_nfe);


        //validao emitente

        //CNPJ
        //if(strlen($reg_nfe->Empresa_CNPJ)<18){
        //    $erros.='<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da empresa  invlido!';
        //}
        //vlidar o CNPJ (funo)
        if (!CalculaCNPJ($reg_nfe->Empresa_CNPJ)) {
            $erros .= '<BR>O CNPJ "'.$reg_nfe->Empresa_CNPJ.'" da Empresa  invlido!';
        }

        //nome
        if (strlen($reg_nfe->Empresa_Razao) < 3) {
            $erros .= '<BR>A Razo Social "'.$reg_nfe->Empresa_Razao.'" da empresa  invlida!';
        }
        //fantasia      //nao aobrigatorio
        if (($reg_nfe->Empresa_Fantasia != '') && (strlen($reg_nfe->Empresa_Fantasia) < 3)) {
            $erros .= '<BR>O nome fantasia da Empresa  invlido!';
        }
        //logradouro
        if (strlen($reg_nfe->Empresa_Logradouro) < 3) {
            $erros .= '<BR>O logradouro da Empresa  invlido!';
        }
        //bairro
        if (strlen($reg_nfe->Empresa_Bairro) < 3) {
            $erros .= '<BR>O bairro da Empresa  invlido!';
        }
        //CEP
        if (($reg_nfe->Empresa_CEP != '') && (strlen($reg_nfe->Empresa_CEP) < 9)) {
            $erros .= '<BR>O CEP "'.$reg_nfe->Empresa_CEP.'" da Empresa  invlido!';
        }
        //cidade nome
        if (strlen($reg_nfe->Empresa_Nome_Cidade) < 3) {
            $erros .= '<BR>O nome de cidade da Empresa  invlido!';
        }
        //Cidade nr
        if (($reg_nfe->Empresa_Codigo_Cidade <= 0) && (strlen($reg_nfe->Empresa_Codigo_Cidade) > 7)) { //1000000
            $erros .= '<BR>O cdigo de cidade da Empresa  invlido!';
        }
        //pais nome
        if (strlen($reg_nfe->Empresa_Nome_Pais) < 3) {
            $erros .= '<BR>O nome de pas da Empresa  invlido!';
        }
        //pais nr
        if ($reg_nfe->Empresa_Codigo_Pais <= 0) {
            $erros .= '<BR>O cdigo de pas da Empresa  invlido!';
        }
        //telefone
        if (strlen($reg_nfe->Empresa_Telefone_Nr) < 14) {
            $erros .= '<BR>O telefone "'.$reg_nfe->Empresa_Telefone_Nr.'" da Empresa  invlido!';
        }
        //UF
        if (strlen($reg_nfe->Empresa_UF) < 2) {
            $erros .= '<BR>A UF da Empresa  invlida!';
        }
        //IE
        if (limpa_mascara($reg_nfe->Empresa_Insc_Estadual) != '') {
            if (strtoupper($reg_nfe->Empresa_Insc_Estadual) != 'ISENTO') {
                if (!(ChkInscEstadual($reg_nfe->Empresa_Insc_Estadual, $reg_nfe->Empresa_UF))) {
                    $erros .= '<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" da Empresa  invlida para "'.$reg_nfe->Dest_UF.'"!';
                }
            }
        }

        //validao destinatrio
        //CNPJ
        if ($reg_nfe->Dest_UF != 'EX') {  //no valida caso seja estrangeiro
            if (strlen($reg_nfe->Dest_CPF_CNPJ) == 14) {
                if (!CalculaCPF($reg_nfe->Dest_CPF_CNPJ)) {
                    $erros .= '<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
                }
            } else if (strlen($reg_nfe->Dest_CPF_CNPJ) == 18) {
                if (!CalculaCNPJ($reg_nfe->Dest_CPF_CNPJ)) {
                    $erros .= '<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
                }
            } else {
                $erros .= '<BR>O CNPJ "'.$reg_nfe->Dest_CPF_CNPJ.'" do Cliente/Fornecedor  invlido!';
            }
        }
        //nome
        if (strlen($reg_nfe->Dest_Razao) < 3) {
            $erros .= '<BR>O razo social do Cliente/Fornecedor  invlido!';
        }
        //fantasia      //nao aobrigatorio
        if (($reg_nfe->Dest_Fantasia != '') && (strlen($reg_nfe->Dest_Fantasia) < 3)) {
            $erros .= '<BR>O nome fantasia do Cliente/Fornecedor  invlido!';
        }

        //logradouro
        if (strlen($reg_nfe->Dest_Logradouro) < 3) {
            $erros .= '<BR>O logradouro do Cliente/Fornecedor  invlido!';
        }
        //bairro
        if (strlen($reg_nfe->Dest_Bairro) < 3) {
            $erros .= '<BR>O bairro do Cliente/Fornecedor  invlido!';
        }

        //cidade nome
        if (strlen($reg_nfe->Dest_Nome_Cidade) < 3) {
            $erros .= '<BR>O nome de cidade do Cliente/Fornecedor  invlido!';
        }
        //Cidade nr
        if ($reg_nfe->Dest_Codigo_Cidade <= 0) {
            $erros .= '<BR>O cdigo de cidade do Cliente/Fornecedor  invlido!';
        }
        //pais nome
        if (strlen($reg_nfe->Dest_Nome_Pais) < 3) {
            $erros .= '<BR>O nome de pas do Cliente/Fornecedor  invlido!';
        }
        //pais nr
        if ($reg_nfe->Dest_Codigo_Pais <= 0) {
            $erros .= '<BR>O cdigo de pas do Cliente/Fornecedor  invlido!';
        }
        //UF
        if (strlen($reg_nfe->Dest_UF) < 2) {
            $erros .= '<BR>A UF do Cliente/Fornecedor  invlida!';
        }
        //IE
        if (limpa_mascara($reg_nfe->Dest_Insc_Estadual) != '') {
            if (strtoupper($reg_nfe->Dest_Insc_Estadual) != 'ISENTO') {
                if (!(ChkInscEstadual($reg_nfe->Dest_Insc_Estadual, $reg_nfe->Dest_UF))) {
                    $erros .= '<BR>A Inscrio Estadual "'.$reg_nfe->Dest_Insc_Estadual.'" do Cliente/Fornecedor  invlida para "'.$reg_nfe->Dest_UF.'"!';
                }
            }
        }

        //consulta Nota Fiscal Item
        $con_item = 'SELECT * FROM nota_fiscal_item '.
                    ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                    ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                    ' AND Nr_Nota="'.$nr_nota.'"';
        $res_item = consulta_sql($con_item);
        $nrw_item = consulta_num_registros($res_item);
        for ($i = 0; $i < $nrw_item; $i++) {
            $reg_item = consulta_ler_objeto($res_item);
            //valida dados do produto
            //Codigo
            //descrio
            if (strlen($reg_item->Prod_Descricao) < 3) {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": Descrio do Produto  invlido!';
            }
            //Unidade de medida
            if (strlen($reg_item->Unidade_NF) < 1) { //pode sim ter 1 dig
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": A unidade de medida  invlida!';
            }
            //NCM (se com IPI ou CFOP comea com 3 ou 7 tem que ter 8 digitos, seno s dois  suficiente)
            if (($reg_item->IPI_Valor > 0) || ((substr($reg_item->CFOP, 0) == 3) || (substr($reg_item->CFOP, 0) == 7))) {
                if (strlen($reg_item->Prod_NCM) < 10) {
                    $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuir todos os dez dgitos para operaes com exterior ou com incidncia de IPI!';
                }
            } else if (strlen($reg_item->Prod_NCM) < 2) {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O NCM do produto "'.$reg_item->Prod_NCM.'"  invlido! O NCM deve possuiir ao menos os dois primeiros dgitos (gnero) para esta operao!';
            }

            //CSTs de ICMS, IPI, PIS e COFINS (validar se Os CST existem na lista de CSTs)
            if (busca_dados_combo('icms_cst_'.$reg_nfe->Empresa_CRT, $reg_item->ICMS_CST) == '') {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do ICMS "'.$reg_item->ICMS_CST.'"  invlido!';
            }
            if (busca_dados_combo('ipi_cst', $reg_item->IPI_CST) == '') {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do IPI "'.$reg_item->IPI_CST.'"  invlido!';
            }

            if (busca_dados_combo('pis_cst_nf_'.$reg_nfe->TipoES, $reg_item->PIS_CST) == '') {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do PIS "'.$reg_item->PIS_CST.'"  invlido!';
            }
            if (busca_dados_combo('cofins_cst_nf_'.$reg_nfe->TipoES, $reg_item->COFINS_CST) == '') {
                $erros .= '<BR>Produto Seq: "'.$reg_item->Seq_Item.'": O CST do COFINS "'.$reg_item->COFINS_CST.'"  invlido!';
            }
        }
        consulta_limpa($res_item);

        if ($erros != '') {
            $upd_nota = 'UPDATE nota_fiscal SET'.
                        ' Situacao="P" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
                        ' AND Nr_Nota="'.$nr_nota.'" '.
                        ' AND Situacao="I"';
            $res_upd = consulta_sql($upd_nota, true, 1);  //retorna para P pois no vai fazer a NFe

            nfse_exibe_erro(
                            'FRE-602',
                            'A Nota Fiscal <b>"'.$reg_nfe->NrDoc.'/'.$reg_nfe->Serie.'"</b> contm dados invlidos!'.
                                '<BR>Corrija os dados e tente o envio navamente!'.$erros.'<BR><BR>',
                            $nr_nota,
                            $operacao
                        );
        }
        return ($erros == '');
    }

    // INICIO PROCESSO
    function nfse_valida_lote($nome_lote, $lista_nfs, $operacao){
        $notas_proc = '';
        $k = 0;
        $erro_validacao = 0;
        $nfse_erro = '';
        //consulta lista nfs
        foreach ($lista_nfs as $key => $nr_nota) {
            if (nfse_valida_dados_nfse($nr_nota, $operacao)) {
                $k++;
            } else {
                $erro_validacao++;
            }
        }
        //verifica se lista tem notas a processar
        if ($erro_validacao == 0) {
            return nfse_processa_lote($nome_lote, $lista_nfs, $operacao);
        } else { //seno
            nfse_exibe_erro(
                'FRE-001',
                $erro_validacao .
                    ' Nota(s) possue(m) dados invlidos. Corrija os dados e tente o envio novamente!',
                $lista_nfs,
                $operacao
            );
            return false;
        }
    }

    function nfse_processa_lote($nome_lote, $lista_nfs, $operacao){ //gerao do lote
        set_time_limit(60);
        //nfse_exibe_processamento('1');

        //$ano_mes = nfse_ano_mes();
        $nf_e_geradas = '';
        $teve_erro = false;
        //para cada nota da lista

        if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-ret-lote.xml')) {
            unlink(nfse_pasta_raiz().'retorno/'.$nome_lote.'-ret-lote.xml');
        }
        if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-rps.xml')) {
            unlink(nfse_pasta_raiz().'retorno/'.$nome_lote.'-rps.xml');
        }
        if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps-ret.xml')) {
            unlink(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps-ret.xml');
        }
        if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps.err')) {
            unlink(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps.err');
        }
        if (file_exists(nfse_pasta_raiz().'validar/Validado/'.$nome_lote.'-env-loterps.xml')) {
            unlink(nfse_pasta_raiz().'validar/Validado/'.$nome_lote.'-env-loterps.xml');
        }
        if (file_exists(nfse_pasta_raiz().'validar/'.$nome_lote.'-env-loterps.xml')) {
            unlink(nfse_pasta_raiz().'validar/'.$nome_lote.'-env-loterps.xml');
        }
        //renomeia arquivo
        nfse_copia_arquivo_renomeia('tmp', $nome_lote.'-lote.xml', $nome_lote.'-env-loterps.xml');

        $copiou = nfse_copia_arquivo('tmp', 'validar', $nome_lote.'-env-loterps.xml');

        if (!($copiou)) { //sem erro na cpia para a pasta envio
            $teve_erro = true;
        }

        if (!($teve_erro)) {
            //espera 15 segundos

            $assinou = false;
            //valida se tem algum arquivo de erro na pasta de retorno
            while (!($assinou)) {
                set_time_limit(60);
                if ((file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps-ret.xml')) ||
                    (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps.err'))
                ) {
                    $assinou = true;
                    // espera a finalizao da escrita do arquivo
                    sleep(2);

                    if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps-ret.xml')) {
                        nfse_copia_arquivo_renomeia('retorno', $nome_lote.'-env-loterps-ret.xml', $nome_lote.'-lote-ret.xml');
                    }
                    if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-env-loterps.err')) {
                        nfse_copia_arquivo_renomeia('retorno', $nome_lote.'-env-loterps.err', $nome_lote.'-lote.err');
                    }
                }
            }

            sleep(5);

            set_time_limit(60);
            //valida se tem algum arquivo de erro na pasta de retorno
            if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-lote.err')) {
                //se tiver erros exibe eles na tela
                $conteudo_arquivo = nfse_abre_arquivo_err($nome_lote.'-lote.err');
                nfse_exibe_erro('FRE-201', 'Lote "'.$nome_lote.'" INCONSISTENTE!<BR>\n'.$conteudo_arquivo, 0);
                nfse_copia_arquivo('retorno', 'erros/', $nome_lote.'-lote.err', '', true);
                $teve_erro = true;
            } else if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-lote-ret.xml')) {
                //se tiver erros exibe eles na tela
                $status = '';
                $motivo = '';
                unset($xml);
                $xml = new XML();
                $xml->fromFile(nfse_pasta_raiz().'retorno/', $nome_lote.'-lote-ret.xml', true);
                //le nr do lote no arquivo
                if ($xml->root->name == 'Validacao') {
                    foreach ($xml->root->atts as $keyx => $value) {
                        if ($xml->root->atts[$keyx]->name == 'cStat') {
                            $status = $xml->root->atts[$keyx]->value;
                        }
                        if ($xml->root->atts[$keyx]->name == 'xMotivo') {
                            $motivo = $xml->root->atts[$keyx]->value;
                        }
                    }
                }
                //abre arquivo xml para ver qual a inconsistencia

                if ($status != '1') {
                    nfse_exibe_erro('FRE-602', 'Lote "'.$nome_lote.'" INCONSISTENTE!<BR>'.
                        $status.'-'.$motivo, 0);
                    nfse_copia_arquivo('retorno', 'erros/', $nome_lote.'-lote-ret.xml');
                    $teve_erro = true;
                } else {
                    if (file_exists(nfse_pasta_raiz().'retorno/'.$nome_lote.'-lote-ret.xml')) {
                        unlink(nfse_pasta_raiz().'retorno/'.$nome_lote.'-lote-ret.xml');
                    }
                    nfse_copia_arquivo_renomeia('validar/Validado', $nome_lote.'-env-loterps.xml', $nome_lote.'-lote.xml');
                    nfse_copia_arquivo('validar/Validado', 'lote/', $nome_lote.'-lote.xml');
                }
            }
        }

        if ($teve_erro) {
            nfse_exibe_erro('FRE-202', 'Abortando Envio do Lote ('.$nome_lote.')', $lista_nfs, $operacao);
            return false;
        } else {
            return true;
        }
    }

    // ENVIO DE NOTA FISCAL JARAGUA DO SUL MODELO 13, ENVIO VIA UNINFE, MODELO XML ABRASF V2.04.
    //1 ? No Recebido
    //2 ? No Processado
    //3 ? Processado com Erro
    //4 ? Processado com Sucesso

    function nfse_processa_araquari($nome_arquivo, $reg_nota, $operacao, $sit_atual){
        return 1;
    }

    ///modelo15 ithanhaem nao envia

    // ENVIO DE NOTA FISCAL JARAGUA DO SUL MODELO 16, ENVIO VIA NFSeEnvio, MODELO XML BETHA V2.02.
    // ENVIO DE NOTA FISCAL JOINVILLE MODELO 17, ENVIO VIA NFSeEnvio, MODELO XML DE JOINVILLE V2.04.
    // ENVIO DE NOTA FISCAL BRASILIA MODELO 21, ENVIO VIA NFSeEnvio, MODELO XML DE BRASILIA V2.04.
    // ENVIO DE NOTA FISCAL BRASILIA MODELO 22, ENVIO VIA NFSeEnvio, MODELO XML DE ARAUCARIA V2.04.
    //0 ? No Recebido
    //1 ? Processado
    //2 ? Processado com Erro

    function nfse_processa_abrasf($reg_nota, $Layout,  $contador = 0 ){
        flush(); @ob_flush();
        flush(); @ob_flush();
        set_time_limit(300);
        $pasta_envio   = 'envio';
        $pasta_retorno = 'retorno';
        $versao="1.00";
        $xmlns="http://www.abrasf.org.br/nfse.xsd";//brasilia ararucaria
        if ($Layout==5){//curitiba
            $xmlns="http://isscuritiba.curitiba.pr.gov.br/iss/nfse.xsd";
        }
        if ($Layout==16){//jaragua do sul betha
            $pasta_envio   = 'rps';
            $pasta_retorno = 'retorno';
            $versao="2.02";
            $xmlns="http://www.betha.com.br/e-nota-contribuinte-ws";
        }
        if (($Layout=='17')||($Layout=='17N')){//joinville
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://nfews.joinville.sc.gov.br";
        }
        if (($Layout==21)||($Layout==22)){//brasilia ararucaria
            $pasta_envio   = 'Enviar';
            $pasta_retorno = 'Retorno';
            $versao="2.04";
            $xmlns="http://www.abrasf.org.br/nfse.xsd";
        }
        if ($reg_nota->NFSe_Nr > 0) {
            echo '<font size="2" face="Verdana">RPS j enviado! A nota de nmero '.$reg_nota->NFSe_Nr.' j foi processada.</font><br><br>';
            return 1;
        }

        $_NFSE_TIMEOUT = 5;
        $contador++;
        $ano_mes = nfse_ano_mes();
		$cnpj_limpo  = limpa_numero($reg_nota->Empresa_CNPJ);
		$nr_doc      = $reg_nota->NrDoc;
        $nr_lote     = $reg_nota->NFSe_Lote;

        $nome_arquivo_ped     = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-env-loterps.xml';
        $nome_arquivo_retorno = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-ret-loterps.xml';

        $nome_arquivo_consulta         = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-envcon-loterps.xml';
        $nome_arquivo_consulta_retorno = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-loterps.xml';

        $nome_arquivo_retornoT          = str_replace("xml", "err", $nome_arquivo_ped);
        $nome_arquivo_retornoT2         = str_replace("xml", "err", $nome_arquivo_retorno);
        $nome_arquivo_consulta_retornoT = str_replace("xml", "err", $nome_arquivo_consulta);

        if ($Layout=='17N'){//joinville
            $nome_arquivo_consulta         = $cnpj_limpo.'_'.$nr_doc.'_'.fill_full($nr_lote,6).'-ped-loterps.xml';
            $nome_arquivo_consulta_retornoT = str_replace("xml", "err", $nome_arquivo_consulta_retorno);
        }


        $existe = false;
        $existeC = false;
        if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno)) {
            $existe = true;
        }    
        //echo '<BR>Temp:'.nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT;

        if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT)) {
            usleep(200);
            unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT);
            //echo '<BR>Apaga:'.nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT;
            //return false;
        }
        //echo '<BR>Temp:'.nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2;
        if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2)) {
            usleep(200);
            unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2);
            //echo '<BR>Apaga:'.nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2;
            //return false;
        }
        
        if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno)) {
            $existeC = true;
        }        
        if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT)) {
            usleep(200);
            unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT);
        }
        

        $valida_envio = true;
        if (($existeC)||($reg_nota->NFSe_Lote_C!='')){//tem protocolo
            $protocolo = $reg_nota->NFSe_Lote_C;
            $valida_envio = true;
        }else{
            if (!$existe) {
                if ($Layout=='17N'){
                    nfse_copia_arquivo('tmp', 'Backup/Envios/'.$ano_mes, $nome_arquivo_ped, '', false, false);
                }
                $copiou = nfse_copia_arquivo('tmp', $pasta_envio, $nome_arquivo_ped, '', false, true);
                if (!$copiou) {
                    echo '<font size="2" face="Verdana">Falha ao copiar Arquivo</font><br>';
                    return 0;
                }
            }
            $ok = false;
            $c=0;
            while (!$ok) {
                $c++;
                if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno)) {
                    $ok = true;
                }
                if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT)) {
                    $ok = true;
                }
                if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2)) {
                    $ok = true;
                }
                if ($c==120){
                    $ok = true;
                }else{
                    sleep(1);
                }
            }
            usleep(200);
            set_time_limit(300);

            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT)) {
                $response = file_get_contents(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT);
                nfse_copia_arquivo($pasta_retorno.'', 'erros/'.$ano_mes, $nome_arquivo_retornoT, '', true, true);
                echo '<font size="2" face="Verdana">Falha enviar arquivo!<BR>'.utf8_decode($response).'</font><br>';
                return 0;
            }

            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2)) {
                $response = file_get_contents(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retornoT2);
                nfse_copia_arquivo($pasta_retorno.'', 'erros/'.$ano_mes, $nome_arquivo_retornoT2, '', true, true);
                echo '<font size="2" face="Verdana">Falha enviar arquivo!<BR>'.utf8_decode($response).'</font><br>';
                return 0;
            }

            if (!file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno)) {
                echo '<font size="2" face="Verdana">Falha ao enviar Arquivo! Tempo de resposta excedido!</font><br>';
                echo '<font size="2" face="Verdana">Verifique o integrador (NFSeEnvio) e tente novamente.</font><br>';
                if (file_exists(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_ped)) {
                    unlink(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_ped);
                }
                return 0;
            }
            
            $xml = nfse_carrega_xml(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno);
             
            if (isset($xml->EnviarLoteRpsEnvioResponse->EnviarLoteRpsResposta)){
                $xml_corpo = $xml->EnviarLoteRpsEnvioResponse->EnviarLoteRpsResposta;//resposta NFSeEnvio
                $xmlString = $xml_corpo->asXml();
            }else if (isset($xml->EnviarLoteRpsResposta)){
                $xml_corpo = $xml->EnviarLoteRpsResposta;//resposta NFSeEnvio
                $xmlString = $xml_corpo->asXml();
            }else{
                $xml_corpo = $xml;//resposta do Uninfe
                $xmlString = $xml->asXml();
            }


            /*
                <?xml version="1.0" encoding="UTF-8" standalone="yes"?>
                <EnviarLoteRpsResposta xmlns="http://www.publica.inf.br" xmlns:pub="http://www.publica.inf.br/integracao_nfse" xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
                    <NumeroLote>3098</NumeroLote>
                    <DataRecebimento>2024-11-07T13:40:28</DataRecebimento>
                    <Protocolo>NTszMDE4OTs0NDM0OzMwOTg7NTszMDE4OTs0NDM0OzMwOTg7NT</Protocolo>
                </EnviarLoteRpsResposta>
             */

            if (file_exists(nfse_pasta_raiz().'tmp/'.$nome_arquivo_retorno)) {
                unlink(nfse_pasta_raiz().'tmp/'.$nome_arquivo_retorno);
            }
            file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_retorno,$xmlString);
            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno)) {
                unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_retorno);
            }

            if ($xml_corpo->Protocolo == '') {
                $valida_envio = false;
                $codigo   = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Codigo;
                $mensagem = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Mensagem;
                $correcao = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Correcao;
                echo '<font size="2" face="Verdana">'.$codigo.' - '.utf8_decode($mensagem).'</font><br>';
                echo '<font size="2" face="Verdana">'.utf8_decode($correcao).'</font><br>';
                nfse_copia_arquivo('tmp', 'erros/'.$ano_mes, $nome_arquivo_retorno, '', true, true);
                return 0;
            } else {
                if (file_exists(nfse_pasta_raiz().'Backup/Envios/'.$ano_mes.'/'.$nome_arquivo_ped)) {
                    nfse_copia_arquivo('Backup/Envios/'.$ano_mes, 'SEFAZ/Lotes/'.$ano_mes, $nome_arquivo_ped, '', false, true);
                }         
                nfse_copia_arquivo('tmp', 'Backup/Retornos/'.$ano_mes, $nome_arquivo_retorno, '', true, false);      
                nfse_copia_arquivo('tmp', 'SEFAZ/Recibos/'.$ano_mes, $nome_arquivo_retorno, '', false, true);

                //file_put_contents(nfse_pasta_raiz().'notas_fiscais/lote_processado_'. $xml_corpo->EnviarLoteRpsEnvioResponse->NumeroLote .'.xml', $xml_retorno);
                echo '<font size="2" face="Verdana">RPS Recebido, Aguardando o Processamento.</font><br>';
                flush(); @ob_flush();
                flush(); @ob_flush();

                $protocolo = $xml_corpo->Protocolo;
                $sql =  'UPDATE nota_fiscal SET'.
                        ' NFSe_Lote_C="'.$protocolo.'" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$reg_nota->Empresa.'"'.
                        ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
                consulta_sql($sql);

                $reg_nota->NFSe_Lote_C = $protocolo; // passa o protocolo para funo recursiva sem precisar consultar novamente no banco.
                $valida_envio = true;
                //sleep(1);
            }
        } 

        if ($valida_envio) {

            $existe = false;
            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno)) {
                $existe = true;
            }
            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT)) {
                usleep(200);
                unlink(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT);
            }
            if (file_exists(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_consulta)) {
                usleep(200);
                unlink(nfse_pasta_raiz().$pasta_envio.'/'.$nome_arquivo_consulta);
            }

            echo '<font size="2" face="Verdana">Consultado Situao do Processamento do RPS (Tentativa '.$contador.').</font><br><br>';
            flush(); @ob_flush();
            flush(); @ob_flush();

            if (!$existe) {

                // <ConsultarLoteRpsEnvio xmlns="http://www.publica.inf.br">
                // <Prestador id="assinar">
                // <Cnpj>95836771000120</Cnpj>
                // <InscricaoMunicipal>56</InscricaoMunicipal>
                // </Prestador>
                // <Protocolo>MTsyODswMzExMjQwMjAwMDE3NjsxOzE7Mjg7MDMxMTI0MDIwMD</Protocolo>
                // </ConsultarLoteRpsEnvio>
                if ($Layout=='17N'){
                    $con_end_emp =  'SELECT'.
                                    ' Insc_Municipal,'.	//0
                                    ' CEP,'.			//1
                                    ' Logradouro,'.		//2
                                    ' Numero,'.			//3
                                    ' Bairro,'.			//4
                                    ' Complemento,'.	//5
                                    ' UF,'.				//6
                                    ' Codigo_Cidade,'.	//7
                                    ' Nome_Cidade,'.	//8
                                    ' CNAE_Municipal'.	//9
                                    ' FROM pessoa_endereco '.
                                    ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                                    ' AND Pessoa="'.$reg_nota->Empresa.'"'.
                                    ' AND Situacao<>"E"'.
                                    ' ORDER BY Seq_Endereco limit 1';
                    $res_end_emp = consulta_sql($con_end_emp);
                    $reg_end_emp = consulta_ler_objeto($res_end_emp);
                    consulta_limpa($res_end_emp);
                    
                    $insc_munic = '0';
                    if($reg_end_emp->Insc_Municipal!='')
                        $insc_munic = limpa_numero($reg_end_emp->Insc_Municipal);

                    $conteudo = '<ConsultarLoteRpsEnvio xmlns="http://www.publica.inf.br">'.
                                    '<Prestador id="assinar">'.
                                        '<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
                                        '<InscricaoMunicipal>'.$insc_munic.'</InscricaoMunicipal>'.
                                    '</Prestador>'.
                                    '<Protocolo>'.$protocolo.'</Protocolo>'.
                                '</ConsultarLoteRpsEnvio>';
                }else{
                    $conteudo = '<ConsultarLoteRpsEnvio xmlns="'.$xmlns.'">'.
                                    '<Prestador>'.
                                        '<CpfCnpj>'.
                                            '<Cnpj>'.$cnpj_limpo.'</Cnpj>'.
                                        '</CpfCnpj>'.
                                    '</Prestador>'.
                                    '<Protocolo>'.$protocolo.'</Protocolo>'.
                                '</ConsultarLoteRpsEnvio>';
                }
                
				$xmlString = $conteudo;
				file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_consulta,$xmlString);

                if ($Layout=='17N'){
                    nfse_copia_arquivo('tmp', 'Backup/Envios/'.$ano_mes, $nome_arquivo_consulta, '', false, false);
                }
                $copiou = nfse_copia_arquivo('tmp', $pasta_envio, $nome_arquivo_consulta, '', false, true);

                if (!$copiou) {
                    echo '<font size="2" face="Verdana">Falha ao gerar arquivo "'.$nome_arquivo_consulta.'" na pasta "Enviar"!</font><br>';
				    return 2;
                }
            }
            $ok = false;
            $c = 0;
            while (!$ok) {
                $c++;
                if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno)) {
                    $ok = true;
                }
                if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT)) {
                    $ok = true;
                }
                if ($c==120){
                    $ok = true;
                }else{
                    sleep(1);
                }
            }
            usleep(200);

            if (file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT)) {
                $response = file_get_contents(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retornoT);
                nfse_copia_arquivo($pasta_retorno.'', 'erros/'.$ano_mes, $nome_arquivo_consulta_retornoT, '', true, true);
                echo '<font size="2" face="Verdana">Falha enviar arquivo!<BR>'.utf8_decode($response).'</font><br>';
                echo '<font size="2" face="Verdana">Tente novamente mais tarde (~ 15 min.).</font><br>';
                return 2;
            }

            if (!file_exists(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno)) {
                echo '<font size="2" face="Verdana">Falha ao enviar Arquivo! Tempo de resposta excedido!</font><br>';
                echo '<font size="2" face="Verdana">Verifique o integrador (NFSeEnvio) e/ou tente novamente.</font><br>';
                return 2;
            }

            $xml = nfse_carrega_xml(nfse_pasta_raiz().$pasta_retorno.'/'.$nome_arquivo_consulta_retorno);
            if (isset($xml->ConsultarLoteRpsEnvioResponse->ConsultarLoteRpsResposta)){
                $xml_corpo = $xml->ConsultarLoteRpsEnvioResponse->ConsultarLoteRpsResposta;//resposta NFSeEnvio
                $xmlString = $xml_corpo->asXml();
            }else if (isset($xml->ConsultarLoteRpsResposta)){
                $xml_corpo = $xml->ConsultarLoteRpsResposta;//resposta NFSeEnvio
                $xmlString = $xml_corpo->asXml();
            }else{
                $xml_corpo = $xml;//resposta do Uninfe
                $xmlString = $xml->asXml();
            }            

            $situacao = $xml_corpo->Situacao;

            if ($Layout=='17N'){
                // if (isset($xml_corpo->ListaMensagemRetornoLote)){
                //     if (!($situacao>0)) $situacao = 3;
                // }else{
                //     $situacao = 4;
                // }

                $nota_nr = $xml_corpo->ListaNfse[0]->CompNfse->Nfse->InfNfse->Numero;
                if ($nota_nr>0){
                    $situacao = 4;
                }else{
                    $situacao = 3;
                }
            }
            if (($situacao > 0) && ($situacao < 5)) {
                $sql  = 'UPDATE nota_fiscal SET'.
                        ' NFSe_Situacao="'.$situacao.'" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$reg_nota->Empresa.'"'.
                        ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
                consulta_sql($sql);
            }
            // if ($situacao == 3) {//ao tentar consultar o RPS descobre que j foi cancelado
            //     nfse_copia_arquivo($pasta_retorno, 'SEFAZ/RetConsultas/'.$ano_mes, $nome_arquivo_consulta_retorno, '', false, true);
            //     $nr_nota = $reg_nota->Nr_Nota;

            //     $nota_nr = $xml_corpo->ListaNfse[0]->CompNfse->Nfse->InfNfse->Numero;
            //     $chave   = $xml_corpo->ListaNfse[0]->CompNfse->Nfse->InfNfse->CodigoVerificacao;

            //     $nome_arquivo_cancelado = 'RPS_'.$nr_doc.'_'.$nota_nr.'-cannfse.xml';
            //     if (file_exists(nfse_pasta_raiz().'tmp/'.$nome_arquivo_cancelado)) {
            //         unlink(nfse_pasta_raiz().'tmp/'.$nome_arquivo_cancelado);
            //     }
            //     file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_cancelado,$xmlString);
            //     nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/Canceladas', $nome_arquivo_cancelado, '', false, true);


            //     //file_put_contents(nfse_pasta_raiz().'notas_fiscais/consulta_rps_'.$nota_nr.'.xml', $xml_retorno);
            //     $sql  = 'UPDATE nota_fiscal SET'.
            //             ' NFSe_Nr="'.$nota_nr.'", '.
            //             ' NFSe_Chave="'.$chave.'", '.
            //             ' NFSe_Lote_C="", '.
            //             ' NFSe_Lote_DH_Processado="'.data_atual('date').' '.hora_atual('hora').'" '.
            //             ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
            //             ' AND Empresa="'.$reg_nota->Empresa.'"'.
            //             ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
            //     consulta_sql($sql);

            //     $sql  = 'UPDATE nota_fiscal SET'.
            //             ' Situcao="P" '.
            //             ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
            //             ' AND Empresa="'.$reg_nota->Empresa.'"'.
            //             ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"'.
            //             ' AND Situcao="I"';
            //     consulta_sql($sql);

                
            //     //layout 16
            //     if (isset($xml->ListaNfse[0]->CompNfse->Nfse->InfNfse->OutrasInformacoes)){
            //         $url_pdf = trim($xml->ListaNfse[0]->CompNfse->Nfse->InfNfse->OutrasInformacoes);
            //         if (substr($url_pdf,0,4)=='http'){
            //             $arquivo_pdf = file_get_contents($url_pdf);
            //             if ($arquivo_pdf!=''){
            //                 $nome_pdf = 'RPS'.$reg_nota->NrDoc.'_NF'.$nota_nr.'-nfse.pdf';
            //                 file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_pdf, $arquivo_pdf);
            //                 nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/PDF', $nome_pdf, '', false, true);
            //             }
            //         }
            //     }

            //     nota_fiscal_cancela($nr_nota, 'I', "N", false);
            //     echo '<font size="2" face="Verdana">NFS-e Cancelada.</font><br><br>';
            //     return true;
            // }
            if ($situacao == 4) {
                nfse_copia_arquivo($pasta_retorno, 'SEFAZ/RetConsultas/'.$ano_mes, $nome_arquivo_consulta_retorno, '', false, true);
                /**
                {
                    "ConsultarLoteRpsEnvioResponse":{
                        "ConsultarLoteRpsResposta":{
                            "Situacao":"4",
                            "ListaNfse":{
                                "CompNfse":{
                                    "Nfse":{
                                        "InfNfse":{
                                            "Numero":"11733",
                                            "NumeroRps":"6315",
                                            "CodigoVerificacao":"07A829B7-10E5-A9CA-6565-FB825DED490C",
                                            "DataEmissao":"2023-11-01T10:46:00",
                                            "NfseSubstituida":"0",
                                            "ValorCredito":"0"
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                    <ConsultarLoteRpsResposta xmlns="http://www.publica.inf.br" xmlns:pub="http://www.publica.inf.br/integracao_nfse" xmlns:ds="http://www.w3.org/2000/09/xmldsig#">
                        <ListaNfse>
                            <CompNfse>
                                <Nfse>
                                    <InfNfse id="82511937">
                                        <Numero>202400000026428</Numero>
                                        ....
                                    </InfNfse>
                                </Nfse>
                                <NfseCancelamento/>
                            </CompNfse>
                        </ListaNfse>
                    </ConsultarLoteRpsResposta>


                 */
                echo '<font size="2" face="Verdana">NFS-e Autorizada.</font><br>';
                echo '<font size="2" face="Verdana">Clique em continuar para realizar a impresso.</font><br><br>';
                $nota_nr = $xml_corpo->ListaNfse[0]->CompNfse->Nfse->InfNfse->Numero;
                $chave   = $xml_corpo->ListaNfse[0]->CompNfse->Nfse->InfNfse->CodigoVerificacao;
                
                $nome_arquivo_xml = 'RPS'.$nr_doc.'_NF'.$nota_nr.'-nfse.xml';
                if (file_exists(nfse_pasta_raiz().'tmp/'.$nome_arquivo_xml)) {
                    unlink(nfse_pasta_raiz().'tmp/'.$nome_arquivo_xml);
                }
                file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_arquivo_xml,$xmlString);
                nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/RPS', $nome_arquivo_xml, '', false, true);
                
                //layout 16
                if (isset($xml->ListaNfse[0]->CompNfse->Nfse->InfNfse->OutrasInformacoes)){
                    $url_pdf = trim($xml->ListaNfse[0]->CompNfse->Nfse->InfNfse->OutrasInformacoes);
                    if (substr($url_pdf,0,4)=='http'){
                        $arquivo_pdf = file_get_contents($url_pdf);
                        if ($arquivo_pdf!=''){
                            $nome_pdf = 'RPS'.$reg_nota->NrDoc.'_NF'.$nota_nr.'-nfse.pdf';
                            file_put_contents(nfse_pasta_raiz().'tmp/'.$nome_pdf, $arquivo_pdf);
                            nfse_copia_arquivo('tmp', 'SEFAZ/NFS-es/'.$ano_mes.'/PDF', $nome_pdf, '', false, true);
                        }
                    }
                }

                $sql  = 'UPDATE nota_fiscal SET'.
                        ' NFSe_Nr="'.$nota_nr.'", '.
                        ' NFSe_Chave="'.$chave.'", '.
                        //' NFSe_Lote_C="", '.
                        ' NFSe_Lote_DH_Processado="'.data_atual('date').' '.hora_atual('hora').'" '.
                        ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa="'.$reg_nota->Empresa.'"'.
                        ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
                consulta_sql($sql);
                return true;
            } else if ( ($situacao == 2) ||
                        ($situacao == 1) ) {
                if ($contador < $_NFSE_TIMEOUT) {
                    echo '<font size="2" face="Verdana">RPS enviado mas ainda no processado pela prefeitura.</font><br>';
                    echo '<font size="2" face="Verdana">Aguarde. Realizando nova tentativa...</font><br><br>';
                    flush(); @ob_flush();
                    flush(); @ob_flush();
                    sleep(15);
                    nfse_copia_arquivo($pasta_retorno, 'SEFAZ/TentConsultas/'.$ano_mes, $nome_arquivo_consulta_retorno, '', false, true);
                    return nfse_processa_abrasf($reg_nota, $Layout, $contador);
                } else {
                    echo '<font size="2" face="Verdana">RPS enviado mas ainda no processado pela prefeitura.</font><br>';
                    echo '<font size="2" face="Verdana">Tente novamente mais tarde (~ 15 min.).</font><br>';
                    return false;
                }
            } else if ($situacao == 3) {
                nfse_copia_arquivo($pasta_retorno, 'SEFAZ/RetConsultas/'.$ano_mes, $nome_arquivo_consulta_retorno, '', false, true);
                //echo '<font size="2" face="Verdana"><pre>'.print_r($xml_corpo,1).'</pre></font><br>';
                echo '<font size="2" face="Verdana">Um erro ocorreu com o RPS, verifique a mensagem de erro.</font><br>';
                $codigo = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[0]->Codigo;
                $mensagem = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[0]->Mensagem;
                $correcao = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[0]->Correcao;

                if ($xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[1]->Codigo != '') {
                    $codigo = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[1]->Codigo;
                    $mensagem = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[1]->Mensagem;
                    $correcao = $xml_corpo->ListaMensagemRetornoLote->MensagemRetornoLote[1]->Correcao;
                }

                if ($codigo == '') {
                    $codigo = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Codigo;
                    $mensagem = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Mensagem;
                    $correcao = $xml_corpo->ListaMensagemRetorno->MensagemRetorno[0]->Correcao;
                }

                echo '<font size="2" face="Verdana">'.$codigo.' - '.utf8_decode($mensagem).'</font><br>';
                echo '<font size="2" face="Verdana">'.utf8_decode($correcao).'</font><br>';
                if ($reg_nota->Situacao!='C'){
                    $sql  = 'UPDATE nota_fiscal SET'.
                            ' NFSe_Lote="0" '.
                            ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                            ' AND Empresa="'.$reg_nota->Empresa.'"'.
                            ' AND Nr_Nota="'.$reg_nota->Nr_Nota.'"';
                    consulta_sql($sql);
                }
                

            } else {
                echo '<font size="2" face="Verdana">Um erro ocorreu com o RPS.</font><br>';
                if ($contador < $_NFSE_TIMEOUT) {
                    echo '<font size="2" face="Verdana">RPS enviado mas ainda no processado pela prefeitura.</font><br>';
                    echo '<font size="2" face="Verdana">Aguarde. Realizando nova tentativa...</font><br><br>';
                    flush(); @ob_flush();
                    flush(); @ob_flush();
                    sleep(15);
                    nfse_copia_arquivo($pasta_retorno, 'SEFAZ/TentConsultas/'.$ano_mes, $nome_arquivo_consulta_retorno, '', false, true);
                    return nfse_processa_abrasf($reg_nota, $Layout, $contador);
                }else{
                    echo '<font size="2" face="Verdana">Tente novamente mais tarde (~ 15 min.).</font><br>';
                    return false;
                }
            }
        }

        echo '<font size="2" face="Verdana">Ocorreu um erro.<br></font><br>';
        return false;
    }

    function nfsexml_carac2especial($caracteres){
		$resultado = str_replace('&','E' ,$caracteres);
		$resultado = str_replace('<','-'  ,$resultado);
		$resultado = str_replace('>','-'  ,$resultado);
		$resultado = str_replace('"',' ',$resultado);
		$resultado = str_replace('','0',$resultado);
		$resultado = str_replace('	',' ',$resultado);
		//retira carteres epeciais
		$LATIN_UC_CHARS = "`";
		$LATIN_LC_CHARS = "AAAAAAECEEEEIIIIDNOOOOOUUUUYaaaaaaeceeeeiiiionoooooouuuuy 2  '''";
		$resultado = strtr($resultado, $LATIN_UC_CHARS, $LATIN_LC_CHARS);
		$resultado = str_replace("'",' ',$resultado);
		$resultado = $resultado;
		return trim($resultado);
	}
