<?

    function paf_nfce_tipo_sistema(){
        $con_dominio = 'SELECT * FROM dominio '.
                        'WHERE DOminio="'.$_SESSION['Dominio'].'"';
        $res_dominio = consulta_sql($con_dominio);
        $reg_dominio = consulta_ler_objeto($res_dominio);
        consulta_limpa($res_dominio);

        $ret['Nuvem_CNPJ']=$reg_dominio->Nuvem_CNPJ;
        $ret['Nuvem_Razao']=$reg_dominio->Nuvem_Razao;
        $ret['Nuvem_Endereco']=$reg_dominio->Nuvem_Endereco;
        $ret['Nuvem_Fone']=$reg_dominio->Nuvem_Fone;
        $ret['Nuvem_Contato']=$reg_dominio->Nuvem_Contato;
        $ret['Nuvem_EMail']=$reg_dominio->Nuvem_EMail;

        if ($_SERVER['REMOTE_ADDR']=='127.0.0.1'){
            $ret['arqTP'] = '1';
        }else{
            $ender3 = substr($_SERVER['REMOTE_ADDR'],0,3);
            if (($ender3=='10.')||($ender3=='192')){
                $ret['arqTP'] = '2';
            }else{
                $ret['arqTP'] = '3';
            }
        }
        if ($ret['Nuvem_Razao']!=''){ $ret['arqTP'] = '4'; }
        if ($ret['arqTP']=='1') $ret['arqBD'] = 'Banco de dados local';
        if ($ret['arqTP']=='2') $ret['arqBD'] = 'Banco de dados interno';
        if ($ret['arqTP']=='3') $ret['arqBD'] = 'Banco de dados corporativo';
        if ($ret['arqTP']=='4') $ret['arqBD'] = 'Banco de dados na nuvem';

        if ($ret['arqTP']=='1') $ret['arqSist'] = 'PAF-NFC-e Local';
        if ($ret['arqTP']=='2') $ret['arqSist'] = 'PAF-NFC-e interno';
        if ($ret['arqTP']=='3') $ret['arqSist'] = 'PAF-NFC-e corporativo';
        if ($ret['arqTP']=='4') $ret['arqSist'] = 'PAF-NFC-e na nuvem';

        return $ret;
    }


    function paf_gera_xml($nroArquivo,$dados_txt){

		$data = data_atual('date');
		$hora = hora_atual('hora');

		$dataS = limpa_numero(dataf($data));
		$dataA = limpa_numero($data);
		$horaS = limpa_numero($hora);

		if ($dados_txt==''){ $dados_txt = 'No h dados disponveis para gerao do arquivo eletrnico solicitado.'; }
		$banco_tipo = paf_nfce_tipo_sistema();

		$dados_XML = '<menuFiscal xmlns="http://www.sef.sc.gov.br/nfce">';
		$dados_XML.= '<arquivo';
		$dados_XML.= ' nroArquivo="'.$nroArquivo.'"';
		$dados_XML.= ' data="'.$dataS.'"';
		$dados_XML.= ' hora="'.$horaS.'"';
		$dados_XML.= ' arqBD="'.$banco_tipo['arqBD'].'"';
		$dados_XML.= ' arqSist="'.$banco_tipo['arqSist'].'"';
		$dados_XML.= '>';
		$dados_XML.= base64_encode($dados_txt);
		$dados_XML.= '</arquivo>';
		$dados_XML.= '</menuFiscal>';

		$xml['Nome'] = 'MF_'.$nroArquivo.'_'.$dataA.'_'.$horaS.'.xml';
		$xml['NomeS'] = 'MF_'.$nroArquivo.'_'.$dataA.'_'.$horaS.'-sign.xml';
        $xml['NomeTXT'] = 'MF_'.$nroArquivo.'_'.$dataA.'_'.$horaS.'.txt';
		$xml['Local'] = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/pdv/MF/'.$_SESSION['Empresa_Codigo'].'/';
		$xml['URL'] = $xml['Local'].$xml['Nome'];
		$xml['URLT'] = $xml['Local'].$xml['NomeTXT'];
		$xml['URLS'] = $xml['Local'].$xml['NomeS'];
        $xml['XML'] = $dados_XML;	
        $xml['TXT'] = $dados_txt;			
		
		paf_assina_xml($xml);

        
		return $xml;
	}

    function paf_assina_xml($xml){

        rmkdir2($xml['Local']);

        //salva apenas o txt
        if(file_exists($xml['URLT'])){ unlink($xml['URLT']); }
		$Handle = fopen($xml['URLT'], 'w');
		fwrite($Handle, $xml['TXT']);
		fclose($Handle);

		//salva xml puro
		if(file_exists($xml['URL'])){ unlink($xml['URL']); }
		$Handle = fopen($xml['URL'], 'w');
		fwrite($Handle, $xml['XML']);
		fclose($Handle);

		//assina
		$dados_XML = trim(paf_assina($xml['XML']));

		//vala xml assinado
		if(file_exists($xml['URLS'])){ unlink($xml['URLS']); }
		$Handle = fopen($xml['URLS'], 'w');
		fwrite($Handle, $dados_XML);
		fclose($Handle);
    }

    function paf_gera_registros_paf($dt_ini,$dt_fim,$festoque,$filtro){
        $dados_txt = '';
		$empresa = $_SESSION['Empresa_Codigo'];
		
		
		$con_empresa = 'select * from pessoa '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$con_empresa = 'select * from pessoa_endereco '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"'.
					   ' and Situacao<>"E"'.
					   ' order by Seq_Endereco';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresae = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);

		
		$IE = substr(limpa_numero($reg_empresae->Insc_Estadual),0,14);
		if ($IE == ''){
			$IE = 'ISENTO';
		}
		$IM = substr(limpa_numero($reg_empresae->Insc_Municipal),0,14);
		
		//registro UI
		//01 Tipo de registro U1 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Inscrio Estadual Inscrio Estadual do estabelecimento 14 17 30 X
		//04 Inscrio Municipal Inscrio Municipal do estabelecimento 14 31 44 X
		//05 Razo Social Razo Social do estabelecimento 50 45 94 X
		
		$linha = 'U1'.
				 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
				 preenche_texto($IE,14).
				 preenche_texto($IM,14).
				 preenche_texto(substr($reg_empresa->Nome_Razao,0,50),50);		
		$dados_txt.= $linha.FIML;
		//A2
		//01 Tipo de registro A2 02 1 2 X
		//02 Data Data do movimento 08 3 10 D
		//03 Meio de pagamento	Meio de pagamento registrado nos documentos emitidos (Dinheiro, Cheque, Cartode Crdito, Carto de Dbito, PIX, transferncias de recursos, carteira digital etc.) 25 11 35 X
		//04 Cdigo do tipo de documento Cdigo do tipo, com as seguintes opes: 1-NFC-e 2-NF-e 3-Operao no tributvel, identificando o CPF ou CNPJ do cliente. 01 36 36 X
		//05 Valor Valor total, com duas casas decimais, do dia informado no campo 02 correspondente ao meio de pagamento informado no campo 03 e ao tipo de Documento informado no campo 04 12 37 48 N
		//06 CPF/CNPJ do cliente CPF ou CNPJ do cliente que realizou a operao cujo cdigo do tipo de documento  3 (vide campo n 04) 14 49 62 N
		//07 N do documento N do Documento emitido quando da realizao da operao no tributvel, cdigo tipo 3, se for o caso 10 63 72 N
		//orderm
		//Data
		//Meio de pagamento
		//Cdigo do tipo de documento
		$pagtos = array();
		//J1
		//01 Tipo de registro J1 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Data de emisso da NFC-e Data de emisso da NFC-e 08 17 24 D
		//04 Subtotal do documento Valor total do documento, com duas casas decimais 14 25 38 N
		//05 Desconto sobre subtotal Valor do desconto ou percentual aplicado sobre o valor do subtotal dodocumento, com duas casas decimais 13 39 51 N
		//06 Indicador do tipo de desconto sobre subtotal Informar V para valor monetrio ou P para percentual 1 52 52 X
		//07 Acrscimo sobre subtotal Valor do acrscimo ou percentual aplicado sobre o valor do subtotal do documento, com duas casas decimais 13 53 65 N
		//08 Indicador do tipo de acrscimo sobre subtotal Informar V para valor monetrio ou P para percentual 1 66 66 X
		//09 Valor total lquido Valor total da NFC-e aps desconto/acrscimo, com duas casas decimais 14 67 80 N
		//10 Tipo de emisso (tpEmis) Informar o tipo de emisso da NFC-e, nos termos do Manual de orientaes da NFC-e  utilizar os cdigos tpEmis 1 81 81 N
		//11 Chave de acesso da NFC-e Informar a chave de acesso da NFC-e, nos termos do Manual de orientaes da NFC-e 44 82 125 N
		//12 Nmero da NFC-e Nmero da NFC-e 10 126 135 N
		//13 Srie da NFC-e Srie da NFC-e 3 136 138 X
		//14 CPF/CNPJ do adquirente CPF/CNPJ do adquirente 14 139 152 NF-e
		
		//J2
		//01 Tipo de registro J2 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Data de emisso da NFC-e emitida em CONTINGNCIA Data de emisso da NFC-e emitida em CONTINGNCIA 08 17 24 D
		//04 Nmero do item Nmero do item registrado no documento 03 25 27 N
		//05 Cdigo do produto ou servio Cdigo do produto ou servio registrado no documento 14 28 41 X
		//06 Descrio Descrio do produto ou servio registrado no documento 100 42 141 X
		//07 Quantidade Quantidade comercializada, sem a separao das casas decimais 07 142 148 N
		//08 Unidade Unidade de medida 3 149 151 N
		//09 Valor unitrio Valor unitrio do produto ou servio, sem a separao das casas decimais 08 152 159 N
		//10 Desconto sobre item Valor do desconto incidente sobre o valor do item, com duas casas decimais 08 160 167 N
		//11 Acrscimo sobre item Valor do acrscimo incidente sobre o valor do item, com duas casas decimais 08 168 175 N
		//12 Valor total lquido Valor total lquido do item, com duas casas decimais 14 176 189 N
		//13 Totalizador parcial Cdigo do totalizador relativo ao produto ou servio conforme tabela abaixo 7 190 196 X
		//14 Casas decimais daquantidade Parmetro de nmero de casas decimais da quantidade 01 197 197 N
		//15 Casas decimais de valor unitrio Parmetro de nmero de casas decimais de valorunitrio 01 198 198 N
		//16 Nmero da NFC-e Nmero da NFC-e 10 199 208 N
		//17 Srie da NFC-e Srie da NFC-e 3 209 211 X
		//18 Chave de acesso da NFC-e Chave de acesso da NFC-e 44 212 255 
		
		//ordem
		//CNPJ do Emitente
		//Data de Emisso
		//Tipo de Documento
		//Srie
		//Nmero do Documento
		//Nmero do item
		
		$notas = array();
		$notasi = array();
		
		$con_nota = 'select * from nota_fiscal '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' and Empresa = "'.$empresa.'"'.
					 ' and DH_Emissao>="'.$dt_ini.'"'.
					 ' and DH_Emissao<="'.$dt_fim.' 23:59:59"'.
					 ' and EmissaoPT="P" and TipoES="1" '.
					 ' and ((Situacao="F") or (Situacao="C"))'.
					 ' and ((Modelo="55") or (Modelo="65" ) )';//or (Modelo="01")) ';
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrw_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);
			$data = substr($reg_nota->DH_Emissao,0,10);
			$tipo = 0;
			if (($reg_nota->Situacao=="F")&&($reg_nota->TipoES=="1")){
				$tipo= 1;
				if ($reg_nota->Modelo=="55"){
					$tipo= 2;
					if ($reg_nota->Nat_Op_Gera_Contas!='R'){
						$tipo = 0;
					}
				}
				if ($reg_nota->Modelo=="01"){
					$tipo = 4;
				}	
			}else if (($reg_nota->Situacao=="C")&&($reg_nota->Modelo=="55")){
				$tipo= 1;
			}
			
			if ($tipo>0){
				$con_pagt = 'select * from nota_fiscal_finaliza '.
							  ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					          ' and Empresa = "'.$empresa.'"'.
					          ' and Nr_Nota = "'.$reg_nota->Nr_Nota.'"';
				$res_pagt = consulta_sql($con_pagt);
				$nrw_pagt = consulta_num_registros($res_pagt);
				if ($nrw_pagt>0){
					//echo $nrw_pagt;
					for($p=0;$p<$nrw_pagt;$p++){
						$reg_pagt = consulta_ler_objeto($res_pagt);
						//echo 'Finaliza'.$reg_pagt->Finaliza;
						$meio = substr(busca_dados_combo('meio_pagamento_todos',$reg_pagt->Finaliza),0,25);
						$valor = $reg_pagt->Valor;
						$chave = $data.'_'.$meio.'_'.$tipo;
						if (!isset($pagtos[$chave])){
							$pagtos[$chave]['Data'] = $data;
							$pagtos[$chave]['Meio'] = $meio;
							$pagtos[$chave]['Tipo'] = $tipo;
							$pagtos[$chave]['Valor'] = 0;
							$pagtos[$chave]['CPF'] = '';
							$pagtos[$chave]['NrDoc'] = '';
						}
						$pagtos[$chave]['Valor']+= $valor;
					}
				}else{
					//echo 'Fatura_Tipo'.$reg_nota->Fatura_Tipo;
					$meio = substr(busca_dados_combo('tipo_fatura',$reg_nota->Fatura_Tipo),0,25);
					$valor = $reg_nota->Total_NF;
					$chave = $data.'_'.$meio.'_'.$tipo;
					if (!isset($pagtos[$chave])){
						$pagtos[$chave]['Data'] = $data;
						$pagtos[$chave]['Meio'] = $meio;
						$pagtos[$chave]['Tipo'] = $tipo;
						$pagtos[$chave]['Valor'] = 0;
						$pagtos[$chave]['CPF'] = '';
						$pagtos[$chave]['NrDoc'] = '';
					}
					$pagtos[$chave]['Valor']+= $valor;
					
				}
				consulta_limpa($res_pagt);
			}
			if (($tipo==1)||($tipo==4)){
				$serie   = $reg_nota->Serie;
				$nr      = $reg_nota->NrDoc;
				$tipoe    = $reg_nota->NFe_TipoEmissao;
				if ($tipoe==''){
					$tipoe = '1';
				}
				$chavenf = $data.'_'.$tipo.'_'.fill_full($serie,3).'_'.fill_full($nr,10).'_'.$reg_nota->Nr_Nota;
				$notas[$chavenf]['Data']=$data;
				$notas[$chavenf]['SubTotal']=$reg_nota->Total_NF;
				$notas[$chavenf]['DescontoV']=0;
				$notas[$chavenf]['DescontoT']='V';
				$notas[$chavenf]['AcrescimoV']=0;
				$notas[$chavenf]['AcrescimoT']='V';
				$notas[$chavenf]['TotalLiq']=$reg_nota->Total_NF;
				$notas[$chavenf]['tipoemiss']=$tipoe;
				$notas[$chavenf]['NFeChave']=$reg_nota->NFe_Chave;
				$notas[$chavenf]['Nr']=$nr;
				$notas[$chavenf]['Serie']=$serie;
				$notas[$chavenf]['CPF']=$reg_nota->Dest_CPF_CNPJ;
				if ($tipo==4){
					$tipoe = 4;
				}
				if ($tipoe>1){//nota em contingencia
					$con_item = 'select * from nota_fiscal_item '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$reg_nota->Empresa.'"'.
								' and Nr_Nota = "'.$reg_nota->Nr_Nota.'" ';
					$res_item = consulta_sql($con_item);
					$nrw_item = consulta_num_registros($res_item);
					for($i=0;$i<$nrw_item;$i++){
						$reg_item = consulta_ler_objeto($res_item);
						$chavenfi = $chavenf.'_'.$reg_item->Seq_Item;
						$cProduto = $reg_item->Barra_Produto;
						if ($cProduto==''){
							$cProduto = $reg_item->Codigo_Produto;
						}
						if ($reg_item->Prod_Depart!=0){
							if ($reg_item->ICMS_Valor>0){
								$tributo = 'T'.fill_full(round($reg_item->ICMS_Percentual*100),4);
							}else if (($reg_item->ICMS_CST=='60')||($reg_item->ICMS_CST=='500')){
								$tributo = 'F';
							}else if (($reg_item->ICMS_CST=='40')||($reg_item->ICMS_CST=='300')){
								$tributo = 'I';
							}else{
								$tributo = 'N';
							}
						}else{
							$tributo = 'S'.fill_full(round($reg_item->ISS_Aliquota*100),4);
							if ($reg_item->ISS_CST=='I'){
								$tributo = 'IS';
							}else if ($reg_item->ISS_CST=='S'){
								$tributo = 'FS';
							}else if ($reg_item->ISS_Aliquota==0){
								$tributo = 'NS';
							}
							//$cProduto = $reg_item->Servico_Codigo.'.'.$cProduto;
						}
						$notasi[$chavenfi]['Data']=$data;
						$notasi[$chavenfi]['Item']=$reg_item->Seq_Item;
						$notasi[$chavenfi]['cProduto']=$cProduto;
						$notasi[$chavenfi]['dProduto']=$reg_item->Prod_Descricao;
						$notasi[$chavenfi]['Qtd']= $reg_item->Quantidade_Estoque;
						$notasi[$chavenfi]['Unid']= $reg_item->Unidade_Estoque;
						$notasi[$chavenfi]['vUnit']= $reg_item->Valor_Unitario;
						$notasi[$chavenfi]['DescontoV']=$reg_item->Valor_Desconto;
						$notasi[$chavenfi]['AcrescimoV']=$reg_item->Valor_Frete+$reg_item->Valor_Seguro+$reg_item->Valor_Outros;
						$notasi[$chavenfi]['TotalLiq']=$reg_item->Valor_Total+$notasi[$chavenfi]['AcrescimoV'];
						$notasi[$chavenfi]['Totalizador']=$tributo;
						$notasi[$chavenfi]['NFeChave']=$reg_nota->NFe_Chave;
						$notasi[$chavenfi]['Nr']=$nr;
						$notasi[$chavenfi]['Serie']=$serie;
					}
					consulta_limpa($res_item);
				}
			}
		}
		consulta_limpa($res_nota);
		
		
		$con_baixas = 'select * from contas_pr '.
					 ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' and Empresa = "'.$empresa.'"'.
					 ' and Caixa_DT>="'.$dt_ini.'"'.
					 ' and Caixa_DT<="'.$dt_fim.' 23:59:59"'.
					 ' and TipoPR="R"'.
					 ' and Situacao="F"'.
					 ' and Parcela>0 '.
					 ' and Valor_Pago>0 '.
					 ' and Nr_Lote_Baixa>0'.
					 ' order by Caixa_DT';//geralmente 0  porque baixou por devoluo
		$res_baixas = consulta_sql($con_baixas);
		$nrw_baixas = consulta_num_registros($res_baixas);
		for($c=0;$c<$nrw_baixas;$c++){
			$reg_baixas = consulta_ler_objeto($res_baixas);

			$data = $reg_baixas->Caixa_DT;
			$tipo = 3;
			if ($reg_baixas->Meio_Pagto>0){
				$meio = substr(busca_dados_combo('meio_pagamento_todos',$reg_baixas->Meio_Pagto),0,25);
			}else{
				$meio = 'Dinheiro';
			}
			
			$con_pessoa='select * from pessoa '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$reg_baixas->Pessoa.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			consulta_limpa($res_pessoa);
			
			$chave = $data.'_'.$meio.'_'.$tipo.'_'.$c;
			$pagtos[$chave]['Data'] = $data;
			$pagtos[$chave]['Meio'] = $meio;
			$pagtos[$chave]['Tipo'] = $tipo;
			$pagtos[$chave]['Valor'] = $reg_baixas->Valor_Liquido;
			$pagtos[$chave]['CPF']   = $reg_pessoa->CPF_CNPJ;
			$pagtos[$chave]['NrDoc'] = $reg_baixas->Nr_Doc;	
		}
		consulta_limpa($res_baixas);
		
		//P2 produtos
		//01 Tipo de registro P2 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF- NFC-e 14 3 16 N
		//03 Cdigo Cdigo da mercadoria ou servio cadastrado na tabela a que se refere o Requisito XIII deste Anexo 14 17 30 X
		//04 CEST Cdigo Especificador daSubstituio Tributria 07 31 37 X
		//05 NCM/SH Nomenclatura Comum do Mercosul Sistema Harmonizado 08 38 45 X
		//06 Descrio Descrio da Mercadoria ou servio cadastrado na tabela a que se refere o Requisito XIII deste Anexo 50 46 95 X
		//07 Unidade Unidade de medida cadastrada na tabela a que se refere o Requisito XIII deste Anexo 06 96 101 X
		//08 IAT Indicador de Arredondamento ou Truncamento,conforme Item 6.3.1.3 01 102 102 X
		//09 IPPT Indicador de Produo Prpria ou de Terceiro, conforme item 6.3.1.4 01 103 103 X
		//10 Situao Tributria Cdigo da Situao Tributaria, conforme tabela constante no item 6.3.1.5 01 104 104 X
		//11 Alquota Alquota, conforme Item 6.3.1.6 04 105 108 N
		//12 Valor unitrio Valor unitrio comduas casas decimais 12 109 120 N
		//ordem 
		//Cdigo da mercadoria 
		
		$impostos = impostos_produto($empresa);		
		$produtos = array();
		$produtosc = array();
		$barras = array();
		
		$con_barra = 'select * from produto_cod_barras '.
				   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Situacao<>"E"'.
				   ' and Codigo_Barras<>"SEM GETIN"';
		$res_barra = consulta_sql($con_barra);
		$nrw_barra = consulta_num_registros($res_barra);
		for($b=0;$b<$nrw_barra;$b++){
			$reg_barra = consulta_ler_objeto($res_barra);
			$cbar = trim(substr($reg_barra->Codigo_Barras,0,14));
			$barras[$reg_barra->Id_Produto][$cbar]=$cbar;
		}
		consulta_limpa($res_barra);
		
		$con_prod = 'select * from produto '.
				   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Situacao<>"E" and Id_Produto>0';
		$res_prod = consulta_sql($con_prod);
		$nrw_prod = consulta_num_registros($res_prod);
		for($b=0;$b<$nrw_prod;$b++){
			$reg_prod = consulta_ler_objeto($res_prod);
			$produto['Codigo'] = trim(substr($reg_prod->Codigo_Produto,0,14));
			$produto['CEST'] = $reg_prod->Codigo_CEST;
			$produto['NCM'] = $reg_prod->NCM;
			$produto['Descricao'] = $reg_prod->Descricao_Completa;
			$produto['Unid'] = $reg_prod->Unidade_Venda;
			$produto['IAT'] = $reg_prod->IAT;
			$produto['IPPT'] = $reg_prod->IPPT;			
			if (isset($impostos['ecf'][$reg_prod->Codigo_Classe_Tributo])){
				$trb = $impostos['ecf'][$reg_prod->Codigo_Classe_Tributo];				
				$ecfR = substr($trb,0,1);
				if (($ecfR=='S')||($ecfR=='T')){
					$ecfA = substr($trb,1,4)/100;
				}else{
					$ecfA = 0;
				}
			}else{
				$ecfR = 'N';
				$ecfA = 0;
			}
			$produto['Tributo'] = $ecfR;
			$produto['TributoA'] = $ecfA;
			$produto['Preco_Venda1'] = $reg_prod->Preco_Venda1;
			$produtosc[$reg_prod->Id_Produto] = $produto; 
			if (isset($barras[$reg_prod->Id_Produto])){
				$barras_produto = $barras[$reg_prod->Id_Produto]; 
				foreach($barras_produto as $chave => $valor){
					$bar = $barras_produto[$chave];
					$produto['Codigo'] = $bar;
					$chave = $produto['Codigo'];
					$produtos[$chave]= $produto;
				}
			}else{
				$chave = $produto['Codigo'];
				$produtos[$chave]= $produto;
			}			
		}
		consulta_limpa($res_prod);
		
		//E2 EStoque do dia
		//01 Tipo de registro E2 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF- NFC-e 14 3 16 N
		//03 Cdigo da mercadoria ou produto Cdigo da mercadoria ou produtocadastrado na tabela a que se refere o Requisito XIII deste Anexo 14 17 30 X
		//04 CEST Cdigo Especificador da Substituio Tributria 07 31 37 X
		//05 NCM/SH Nomenclatura Comum do Mercosul Sistema Harmonizado 08 38 45 X
		//06 Descrio da mercadoria ou produto Descrio da Mercadoria ou produto cadastrado na tabela a que se refere o Requisito XIII deste Anexo 50 46 95 X
		//07 Unidade Unidade de medida cadastrada na tabela a que se refere o RequisitoXIII deste Anexo 06 96 101 X
		//08 Mensurao do estoque Informao de estoque positivo (+) ou negativo (-) 01 102 102 X
		//09 Quantidade em estoque Quantidade da mercadoria ou produto constante no estoque, com trs casas decimais 09 103 111 N
		//10 Data da emisso data em que o arquivo foi solicitado 08 112 119 D
		//11 Data do estoque data da posio do estoque 08 120 127 D
		$estoque = array();
		
		$con_prod = 'select * from paf_estoque_dia '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Id_Produto>0';
		if ($festoque=='P'){
			$con_prod.= ' and ((Produto_Cod = "'.$filtro.'") or (Produto_Descricao like "%'.$filtro.'%"))';
		}
		//echo $con_prod;
		$res_prod = consulta_sql($con_prod);
		$nrw_prod = consulta_num_registros($res_prod);
		for($b=0;$b<$nrw_prod;$b++){
			$reg_prod = consulta_ler_objeto($res_prod);
			$produtoe['Codigo'] = trim(substr($reg_prod->Produto_Cod,0,14));
			$produtoe['CEST'] = $reg_prod->Produto_CEST;
			$produtoe['NCM'] = $reg_prod->Produto_NCM;
			$produtoe['Descricao'] = $reg_prod->Produto_Descricao;
			$produtoe['Unid'] = $reg_prod->Produto_Unidade;
			$produtoe['Saldo'] = $reg_prod->Saldo;
			$produtoe['Data'] = $reg_prod->DataEstoque;
			$produtoe['Sinal'] = '+';
			if ($produtoe['Saldo']<=(-0.001)){
				$produtoe['Sinal'] = '-';
				$produtoe['Saldo'] = $produtoe['Saldo'] * (-1);
			}			
			$chave = $produtoe['Codigo'];
			$estoque[$chave]= $produtoe;
		}
		consulta_limpa($res_prod);
		
		//D2 pedidos
		//01 Tipo de registro D2 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF- NFC-e 14 3 16 N
		//03 Nmero do DAV Nmero do DAV emitido 13 17 29 X
		//04 Data do DAV Data de emisso do DAV 08 30 37 D
		//05 Ttulo do DAV Ttuloatribudo ao DAV de acordocom sua funo (ex: Oramento, Pedido, etc.) 30 38 67 X
		//06 Valor Total do DAV Valor total do DAV emitido, com duas casas decimais 08 68 75 N
		//07 Nome do adquirente Nome do Cliente 40 76 115 X
		//08 CPF/CNPJ do adquirente CPF ou CNPJ do adquirente 14 116 129 N
		
		//D3 pedidos itens
		//01 Tipo de registro D3 02 1 2 X
		//02 Nmero do DAV Nmero do DAV onde est contido este item 13 03 15 X
		//03 Data de incluso Data de incluso do item no DAV 08 16 23 D
		//04 Nmero do item Nmero sequencial do item registrado no documento 03 24 26 N
		//05 Cdigo do Produtoou Servio Cdigo do produto ou servio registrado no documento. 14 27 40 X
		//06 Descrio Descrio do produto ou servio constanteno DANFE 100 41 140 X
		//07 QuantidadeQuantidade, sema separao das casas decimais 07 141 147 N
		//08 Unidade Unidadede medida 03 148 150 X
		//09 Valor unitrio Valor unitrio do produto ou servio, sem a separao das casas decimais 08 151 158 N
		//10 Desconto sobreitem Valordo desconto incidente sobre o valor doitem, com duas casasdecimais. 08 159 166 N
		//11 Acrscimo sobre item Valordo acrscimo incidente sobre o valor doitem, com duas casas decimais 08 167 174 N
		//12 Valor totallquido Valortotal lquido do item, com duas casas decimais. 14 175 188 N
		//13 Situao Tributria Cdigo da Situao Tributaria conforme Tabela constante no item 6.3.1.5 01 189 189 X
		//14 Alquota Alquota, conforme Item 6.7.1.4 04 190 193 N
		//15 Indicador de cancelamento Informar "S" ou "N", conforme tenha ocorrido ou no, a marcao do cancelamento do item no documento auxiliar de venda 01 194 194 X
		//16 Casas decimais da quantidade Parmetro de nmerode casas decimais da quantidade 01 195 195 N
		//17 Casas decimais de valor unitrio Parmetro de nmerode casas decimais de valor unitrio 01 196 196 N
		
		//D4
		//01 Tipo D4 02 1 2 X
		//02 Nmero do DAV Nmero do DAV onde est contido este item 13 03 15 X
		//03 Data de alterao Data de alterao (incluso,excluso ou alterao) do item no DAV 08 16 23 D
		//04 Hora de alteraoHora de alterao (incluso, excluso ou alterao) do item no DAV 06 24 29 H
		//05 Cdigo do Produto ou Servio Cdigo do produto ou servio registrado no documento. 14 30 43 X
		//06 Descrio Descrio do produto ou servio constante no Cupom Fiscal 100 44 143 X
		//07 Quantidade Quantidade, sem a separao das casas decimais 07 144 150 N
		//08 Unidade Unidade de medida 03 151 153 X
		//09 Valor unitrioValor unitrio do produto ou servio, sem a separao das casas decimais. 08 154 161 N
		//10 Desconto sobre item Valor do desconto incidente sobre o valor do item, com duas casas decimais. 08 162 169 N
		//11 Acrscimo sobre item Valor do acrscimo incidente sobre o valor do item, com duas casas decimais. 08 170 177 N
		//12 Valor total lquido Valor total lquido do item, com duas casas decimais. 14 178 191 N
		//13 Situao Tributria Cdigo da Situao Tributaria conforme tabela constante no item 6.3.1.5 01 192 192 X
		//14 Alquota Alquota, conforme item 6.7.1.4 04 193 196 N
		//15 Indicador de cancelamento Informar "S" ou "N", conforme tenha ocorrido ou no, a marcao do cancelamento do item no documento auxiliar de venda. 01 197 197 X
		//16 Casas decimais da quantidade Parmetro de nmero de casas decimais da quantidade 01 198 198 N
		//17 Casas decimais de valor unitrio Parmetro de nmero de casas decimais de valor unitrio 01 199 199 N
		//18 Tipo de alterao A para alterao, E para excluso e I para incluso 01 200 200 X
		
		//ordem
		//Nr se item
		//D4 - nr pedido data/hora alteracao
		$pedidos = array();
		$pedidosi = array();
		
		$titulo_dav = busca_nome_pedido_orc();
		$con_ped = 'select * from pedido '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and DH_Emissao>="'.$dt_ini.'"'.
					' and DH_Emissao<="'.$dt_fim.' 23:59:59"';//or (Modelo="01")) ';
		$res_ped = consulta_sql($con_ped);
		$nrw_ped = consulta_num_registros($res_ped);
		for($p=0;$p<$nrw_ped;$p++){
			$reg_ped = consulta_ler_objeto($res_ped);
			$chave = $reg_ped->Numero_Pedido;
			
			$con_pessoa='select * from pessoa '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$reg_ped->Pessoa.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			consulta_limpa($res_pessoa);
			
			$pedidos[$chave]['Nr'] = $reg_ped->Numero_Pedido;
			$pedidos[$chave]['Data'] = substr($reg_ped->DH_Emissao,0,10);
			$pedidos[$chave]['Valor'] = $reg_ped->Valor_Total_Liquido;
			$pedidos[$chave]['Nome'] = $reg_pessoa->Nome_Razao;
			$pedidos[$chave]['CPF'] = $reg_pessoa->CPF_CNPJ;
			
			$con_item = 'select * from pedido_item '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$reg_ped->Empresa.'"'.
						' and Numero_Pedido = "'.$reg_ped->Numero_Pedido.'" '.
						' order by Seq_Item';
			$res_item = consulta_sql($con_item);
			$nrw_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrw_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				if (isset($produtosc[$reg_item->ID_Produto])){//se produto no existe na tabela(no faz anda)
					$produto = $produtosc[$reg_item->ID_Produto];
					$chavei = $chave.'.'.$reg_item->Seq_Item;
					$pedidosi[$chavei]['Nr'] = $reg_ped->Numero_Pedido;
					$pedidosi[$chavei]['Data'] = substr($reg_ped->DH_Emissao,0,10);
					if ($reg_item->DH_Inclusao!='0000-00-00 00:00:00'){
						$pedidosi[$chavei]['Data'] = substr($reg_item->DH_Inclusao,0,10);
					}
					$pedidosi[$chavei]['Seq'] = $reg_item->Seq_Item;
					$pedidosi[$chavei]['cProduto'] = $reg_item->Barra_Produto;
					if ($pedidosi[$chavei]['cProduto']==''){
						$pedidosi[$chavei]['cProduto'] = $produto['Codigo'];
					}
					$pedidosi[$chavei]['dProduto'] = $produto['Descricao'];
					$pedidosi[$chavei]['uProduto'] = $produto['Unid'];
					$pedidosi[$chavei]['Tributo'] = $produto['Tributo'];
					$pedidosi[$chavei]['TributoA'] = $produto['TributoA'];
					
					$pedidosi[$chavei]['Qtd'] = $reg_item->Qtd;
					$pedidosi[$chavei]['Valor_Unitario'] = $reg_item->Valor_Unitario;
					$pedidosi[$chavei]['Valor_Desconto'] = $reg_item->Valor_Desconto;
					$pedidosi[$chavei]['Valor_Acrescimo'] = $reg_item->Valor_Acrescimo;
					$pedidosi[$chavei]['Valor_Total'] = $reg_item->Valor_Total;
					$pedidosi[$chavei]['Cancelado'] = 'N';
					if (($reg_item->Status=='C')||($reg_item->Status=='E')){
						$pedidosi[$chavei]['Cancelado'] = 'S';
					}
				}
			}
			consulta_limpa($res_item);
		}
		consulta_limpa($res_ped);
		
		//S2 Mesas
		//01 Tipo de registro S2 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Data de abertura Data de abertura da Mesa ou Conta de Cliente, no formato aaaammdd 08 17 24 D
		//04 Hora de abertura Hora de abertura da Mesa ouConta de Cliente, no formato hhmmss 06 25 30 H
		//05 Numero da Mesa/ Conta Cliente Numero da Mesa / Conta Cliente 13 31 43 X
		//06 Valor Total Valor total dos produtos registrados/fornecidos na Mesa ou Conta de Cliente, com duas casas decimais 13 44 56 N
		//07 N do Conferencia de Mesa N do Conferencia de Mesa 09 57 65 
		//ordem Data de abertura
		//Hora de abertura
		
		//S3 Itens Mesas
		//01 Tipo de registro S3 02 1 2 X
		//02 CNPJ CNPJ do estabelecimentousurio do PAF-NFC-e 14 3 16 N
		//03 Data de abertura Data de abertura da Mesa ou Conta de Cliente, no formato aaaammdd 08 17 24 D
		//04 Hora de abertura Hora de abertura da Mesa ou Conta de Cliente, no formato hhmmss 06 25 30 H
		//05 Nmero da Mesa/Conta de Cliente Nmero da Mesa/Conta de Cliente 13 31 43 X
		//06 Cdigo do Produto ou Servio Cdigo do produto ou servio registrado no documento. 14 44 57 X
		//07 Descrio Descrio do produto ou servio constante no Cupom Fiscal 100 58 157 X
		//08 Quantidade Quantidade comercializada, sem a separao das casas decimais 07 158 164 N
		//09 Unidade Unidade de medida 03 165 167 X
		//10 Valor unitrio Valor unitrio do produto ou servio, com duas casas decimais. 08 168 175 N
		//11 Casas decimais da quantidade Parmetro de nmero de casas decimais da quantidade 01 176 176 N
		//12 Casas decimais de valor unitrio Parmetro de nmero de casas de valor unitrio 01 177 177 N
		//ordem Nmero da Mesa
		
		$mesas = array();
		$mesasi = array();
		
		$con_ped = 'select * from comanda '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Situacao="A"';//or (Modelo="01")) ';
		$res_ped = consulta_sql($con_ped);
		$nrw_ped = consulta_num_registros($res_ped);
		for($p=0;$p<$nrw_ped;$p++){
			$reg_ped = consulta_ler_objeto($res_ped);
			$chave = $reg_ped->DT_Movto.'-'.$reg_ped->HR_Movto.'-'.$reg_ped->Nr_Comanda;
			
			$mesas[$chave]['Data']  = substr($reg_ped->DT_Movto,0,10);
			$mesas[$chave]['Hora']  = substr($reg_ped->HR_Movto,0,8);
			$mesas[$chave]['Nr']    = $reg_ped->Nr_Mesa;
			$mesas[$chave]['Valor'] = $reg_ped->Valor_Total;
			$mesas[$chave]['RG'] = $reg_pessoa->RG_COO;
			if ($mesas[$chave]['RG']<=0){
				$mesas[$chave]['RG'] = '';
			}
			
			$con_item = 'select * from comanda_item '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$reg_ped->Empresa.'"'.
						' and Nr_Comanda = "'.$reg_ped->Nr_Comanda.'" '.
						' order by Seq';
			$res_item = consulta_sql($con_item);
			$nrw_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrw_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				if (isset($produtosc[$reg_item->Id_Produto])){//se produto no existe na tabela(no faz anda)
					$produto = $produtosc[$reg_item->Id_Produto];
					$chavei = $reg_ped->Nr_Mesa.'-'.$reg_ped->Nr_Comanda.'.'.$reg_item->Seq_Item;
					
					$mesasi[$chavei]['Data']  = substr($reg_ped->DT_Movto,0,10);
					$mesasi[$chavei]['Hora']  = substr($reg_ped->HR_Movto,0,8);
					$mesasi[$chavei]['Nr']    = $reg_ped->Nr_Mesa;
					$mesasi[$chavei]['Seq'] = $reg_item->Seq;
					$mesasi[$chavei]['cProduto'] = $reg_item->Produto_Barra;
					if ($mesasi[$chavei]['cProduto']==''){
						$mesasi[$chavei]['cProduto'] = $produto['Codigo'];
					}
					$mesasi[$chavei]['dProduto'] = $produto['Descricao'];
					$mesasi[$chavei]['uProduto'] = $produto['Unid'];
					
					$mesasi[$chavei]['Qtd'] = $reg_item->Quantidade;
					$mesasi[$chavei]['Valor_Unitario'] = $reg_item->Valor_Unitario;
				}
			}
			consulta_limpa($res_item);
		}
		consulta_limpa($res_ped);
		
		ksort($pagtos);
		ksort($produtos);
		ksort($estoque);
		ksort($pedidos);
		ksort($pedidosi);
		ksort($mesas);
		ksort($mesasi);
		ksort($notas);
		ksort($notasi);
		
		foreach($pagtos as $chave => $valor){
			$pagto = $pagtos[$chave];
			$cpf   = fill_full(substr(limpa_numero($pagto['CPF']),0,14),14);
			$nrdoc = fill_full(substr(limpa_numero($pagto['NrDoc']),0,10),10);
			if ($pagto['Tipo']!=3){
				$cpf = preenche_texto('',14);
				$nrdoc = preenche_texto('',10);
			}
			$linha = 'A2'.
					 fill_full(limpa_numero($pagto['Data']),8).
					 preenche_texto($pagto['Meio'],14).
					 preenche_texto($pagto['Tipo'],1).
					 fill_full(round($pagto['Valor']*100),12).
					 $cpf.
					 $nrdoc;
			$dados_txt.= $linha.FIML;
		}
		
		foreach($produtos as $chave => $valor){
			$produto = $produtos[$chave];
			$linha = 'P2'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 preenche_texto($produto['Codigo'],14).
					 preenche_texto(limpa_numero($produto['CEST']),7).
					 preenche_texto(limpa_numero($produto['NCM']),8).
					 preenche_texto(substr($produto['Descricao'],0,50),50).
					 preenche_texto(substr($produto['Unid'],0,6),6).
					 preenche_texto($produto['IAT'],1).
					 preenche_texto($produto['IPPT'],1).
					 preenche_texto($produto['Tributo'],1).
					 fill_full(round($produto['TributoA']*100),4).
					 fill_full(round($produto['Preco_Venda1']*100),12);
			$dados_txt.= $linha.FIML;
		}
		$data_gera = limpa_numero(data_atual('date'));
		foreach($estoque as $chave => $valor){
			$produtoe = $estoque[$chave];			
			$linha = 'E2'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 preenche_texto($produtoe['Codigo'],14).
					 preenche_texto(limpa_numero($produtoe['CEST']),7).
					 preenche_texto(limpa_numero($produtoe['NCM']),8).
					 preenche_texto(substr($produtoe['Descricao'],0,50),50).
					 preenche_texto(substr($produtoe['Unid'],0,6),6).
					 preenche_texto($produtoe['Sinal'],1).
					 fill_full(round($produtoe['Saldo']*1000),9).
					 fill_full(limpa_numero($produtoe['Data']),8).
					 $data_gera;
			$dados_txt.= $linha.FIML;
		}
		
		foreach($pedidos as $chave => $valor){
			$pedido = $pedidos[$chave];	
			$linha = 'D2'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 fill_full($pedido['Nr'],13).
					 fill_full(limpa_numero($pedido['Data']),8).
					 preenche_texto($titulo_dav,30).
					 fill_full(round($pedido['Valor']*100),8).
					 preenche_texto(substr($pedido['Nome'],0,40),40).
					 fill_full(limpa_numero($pedido['CPF']),14);
			$dados_txt.= $linha.FIML;
		}
		
		foreach($pedidosi as $chave => $valor){
			$pedido = $pedidosi[$chave];
			$linha = 'D3'.
					 fill_full($pedido['Nr'],13).
					 fill_full(limpa_numero($pedido['Data']),8).
					 fill_full($pedido['Seq'],3).
					 preenche_texto($pedido['cProduto'],14).
					 preenche_texto(substr($pedido['dProduto'],0,100),100).
					 fill_full(round($pedido['Qtd']*1000),7).
					 preenche_texto(substr($pedido['uProduto'],0,3),3).
					 fill_full(round($pedido['Valor_Unitario']*100),8).
					 fill_full(round($pedido['Valor_Desconto']*100),8).
					 fill_full(round($pedido['Valor_Acrescimo']*100),8).
					 fill_full(round($pedido['Valor_Total']*100),14).
					 preenche_texto(substr($pedido['Tributo'],0,1),1).
					 fill_full(round($pedido['TributoA']*100),4).
					 preenche_texto(substr($pedido['Cancelado'],0,1),1).
					 '3'.
					 '2';
			$dados_txt.= $linha.FIML;
		}
		
		foreach($mesas as $chave => $valor){
			$mesa = $mesas[$chave];	
			$linha = 'S2'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 fill_full(limpa_numero($mesa['Data']),8).
					 fill_full(limpa_numero($mesa['Hora']),6).
					 preenche_texto($mesa['Nr'],13).
					 fill_full(round($mesa['Valor']*100),13).
					 preenche_texto($mesa['RG'],9);
			$dados_txt.= $linha.FIML;
		}
		
		foreach($mesasi as $chave => $valor){
			$mesa = $mesasi[$chave];
			$linha = 'S3'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 fill_full(limpa_numero($mesa['Data']),8).
					 fill_full(limpa_numero($mesa['Hora']),6).
					 preenche_texto($mesa['Nr'],13).
					 
					 preenche_texto($mesa['cProduto'],14).
					 preenche_texto(substr($mesa['dProduto'],0,100),100).
					 fill_full(round($mesa['Qtd']*1000),7).
					 preenche_texto(substr($mesa['uProduto'],0,3),3).
					 fill_full(round($mesa['Valor_Unitario']*100),8).
					 '3'.
					 '2';;		
			$dados_txt.= $linha.FIML;
		}
		
		foreach($notas as $chave => $valor){
			$nota = $notas[$chave];
			
			$linha = 'J1'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 fill_full(limpa_numero($nota['Data']),8).
					 fill_full(round($nota['SubTotal']*100),14).
					 fill_full(round($nota['DescontoV']*100),13).
					 preenche_texto($nota['DescontoT'],1).
					 fill_full(round($nota['AcrescimoV']*100),13).
					 preenche_texto($nota['AcrescimoT'],1).
					 fill_full(round($nota['TotalLiq']*100),14).
					 preenche_texto($nota['tipoemiss'],1).
					 preenche_texto($nota['NFeChave'],44).
					 fill_full(round($nota['Nr']),10).
					 preenche_texto($nota['Serie'],3).
					 fill_full(limpa_numero($nota['CPF']),14);
			$dados_txt.= $linha.FIML;
		}
		
		foreach($notasi as $chave => $valor){
			$nota = $notasi[$chave];
			
			$linha = 'J2'.
					 fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
					 fill_full(limpa_numero($nota['Data']),8).
					 fill_full(limpa_numero($nota['Item']),3).
					 preenche_texto(substr($nota['cProduto'],0,14),14).
					 preenche_texto(substr($nota['dProduto'],0,100),100).
					 fill_full(round($nota['Qtd']*1000),7).
					 preenche_texto(substr($nota['Unid'],0,3),3).
					 fill_full(round($nota['vUnit']*100),8).
					 fill_full(round($nota['DescontoV']*100),8).
					 fill_full(round($nota['AcrescimoV']*100),8).
					 fill_full(round($nota['TotalLiq']*100),14).
					 preenche_texto($nota['Totalizador'],7).
					 '3'.
					 '2'.
					 fill_full(round($nota['Nr']),10).
					 preenche_texto($nota['Serie'],3).
					 preenche_texto($nota['NFeChave'],44);
			$dados_txt.= $linha.FIML;
		}
        return $dados_txt;
    }

    function paf_gera_vendas_id($dt_ini,$dt_fim,$filtro){
        $empresa = $_SESSION['Empresa_Codigo'];
        $dados_txt = '';
		
		$con_empresa = 'select * from pessoa '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$con_empresa = 'select * from pessoa_endereco '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"'.
					   ' and Situacao<>"E"'.
					   ' order by Seq_Endereco';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresae = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$IE = substr(limpa_numero($reg_empresae->Insc_Estadual),0,14);
		if ($IE == ''){
			$IE = 'ISENTO';
		}
		$IM = substr(limpa_numero($reg_empresae->Insc_Municipal),0,14);
		
		//registro UI
		//01 Tipo de registro Z1 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Inscrio Estadual Inscrio Estadual do estabelecimento 14 17 30 X
		//04 Inscrio Municipal Inscrio Municipal do estabelecimento 14 31 44 X
		//05 Razo Social Razo Social do estabelecimento 50 45 94 X
		
		$linha = 'Z1'.
		         fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
				 preenche_texto($IE,14).
				 preenche_texto($IM,14).
				 preenche_texto(substr($reg_empresa->Nome_Razao,0,50),50);
		$dados_txt.= $linha.FIML;
		
		$linha = 'Z2'.
		         fill_full(limpa_numero(config_pad('paf_emp_cnpj')),14).
				 preenche_texto(config_pad('paf_emp_ie'),14).
				 preenche_texto(config_pad('paf_emp_im'),14).
				 preenche_texto(substr((config_pad('paf_emp_razao')),0,50),50);
		$dados_txt.= $linha.FIML;
		
		$linha = 'Z3'.
				 preenche_texto(substr((config_pad('sistema_nome_pdv')),0,50),50).
		         preenche_texto(substr((config_pad('sistema_versao_pdv')),0,10),10);
		$dados_txt.= $linha.FIML;
		
		$totalz4=0;
		
		//Z4
		//01 Tipo de registro Z4 02 1 2 X
		//02 Nmero do CPF/CNPJ,Nmero do CPF/CNPJ Identificado na NFC-e 14 3 16 N
		//03 Totalizao Mensal  Total de vendas no ms, com duas casas decimais, ao CPF/CNPJ indicado no campo 02 14 17 30 N
		//04 Data Inicial das Vendas ao CPF/CNPJ Primeiro dia do ms a que se refere o relatrio de Vendas ao CPF/CNPJ identificado no campo 02 08 31 38 D
		//05 Data Final das Vendas ao CPF/CNPJ ltimo dia do ms a que se refere o relatrio de vendas ao CPF/CNPJ Identificado no campo 02 08 39 46 D
		//06 Data da gerao do relatrio Data que o relatrio foi gerado pelo PAF-NFC-e 08 47 54 D
		//07 Hora da Gerao do Relatrio Hora que o relatrio foi gerado pelo PAF-NFC-e 06 55 60 H
		$notas = array();
		
		$con_nota = 'select * from nota_fiscal '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' and Empresa = "'.$empresa.'"'.
					 ' and DH_Emissao>="'.$dt_ini.'"'.
					 ' and DH_Emissao<="'.$dt_fim.' 23:59:59"'.
					 ' and EmissaoPT="P" and TipoES="1" '.
					 ' and ((Situacao="F") or (Situacao="C"))'.
					 ' and ((Modelo="01") or (Modelo="65" ) )';//or (Modelo="01")) ';
		if ($filtro!=''){
			$con_nota.= ' and Dest_CPF_CNPJ like "'.$filtro.'%"';
		}
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrw_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);
			if (($reg_nota->Dest_CPF_CNPJ!='')&&($reg_nota->Dest_CPF_CNPJ!='000.000.000-00')&&($reg_nota->Dest_CPF_CNPJ!='00.000.000/0000-00')){
				$chavenf = $reg_nota->Dest_CPF_CNPJ;
				$data = substr($reg_nota->DH_Emissao,0,10);
				$data_n = data2nr(dataf($data));
				if (!isset($notas[$chavenf])){
					$notas[$chavenf]['CPF']=$reg_nota->Dest_CPF_CNPJ;
					$notas[$chavenf]['DataI']=$data;
					$notas[$chavenf]['DataF']=$data;
					$notas[$chavenf]['Valor']=0;
				}
				$notas[$chavenf]['Valor']+=$reg_nota->Total_NF;
				if ($data_n<data2nr(dataf($notas[$chavenf]['DataI']))){
					$notas[$chavenf]['DataI']=$data;
				}
				if ($data_n>data2nr(dataf($notas[$chavenf]['DataF']))){
					$notas[$chavenf]['DataF']=$data;
				}
			}
		}
		consulta_limpa($res_nota);	
		
		$data = limpa_numero(data_atual('date'));
		$hora = limpa_numero(nr2hora(hora_atual()));
		ksort($notas);
		foreach($notas as $chave => $valor){
			$nota = $notas[$chave];
			$linha = 'Z4'.
					 fill_full(limpa_numero($nota['CPF']),14).
					 fill_full(round($nota['Valor']*100),14).
					 fill_full(limpa_numero($nota['DataI']),8).
					 fill_full(limpa_numero($nota['DataF']),8).
					 $data.
					 $hora;
			$dados_txt.= $linha.FIML;
			$totalz4++;
		}
		
		$linha = 'Z9'.
				 fill_full(limpa_numero(config_pad('paf_emp_cnpj')),14).
				 preenche_texto(config_pad('paf_emp_ie'),14).
				 fill_full($totalz4,6);
		$dados_txt.= $linha.FIML;

        return $dados_txt;
		
		// $nm_arquivo = md5('paf_'.$_REQUEST['USER_ID']).'.txt';
		// $local = '../../../arquivos_clientes/'.$_SESSION['Dominio'].'/pdv/';
		// rmkdir2($local);
		
		// $arquivo_existe = $local.$nm_arquivo;
		// if(file_exists($arquivo_existe)){
		// 	unlink($arquivo_existe);
		// }

		// $Handle = fopen($arquivo_existe, 'w');
		// fwrite($Handle, $dados_txt);
		// fclose($Handle);
		// assinar_arquivo_ead($arquivo_existe);
		// echo $ok;
    }

    function paf_gera_req_extena($dt_ini,$dt_fim){
        $empresa = $_SESSION['Empresa_Codigo'];
		$dados_txt = '';
		
		$con_empresa = 'select * from pessoa '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$con_empresa = 'select * from pessoa_endereco '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"'.
					   ' and Situacao<>"E"'.
					   ' order by Seq_Endereco';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresae = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$IE = substr(limpa_numero($reg_empresae->Insc_Estadual),0,14);
		if ($IE == ''){
			$IE = 'ISENTO';
		}
		$IM = substr(limpa_numero($reg_empresae->Insc_Municipal),0,14);
		
		//registro UI
		//01 Tipo de registro Z1 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Inscrio Estadual Inscrio Estadual do estabelecimento 14 17 30 X
		//04 Inscrio Municipal Inscrio Municipal do estabelecimento 14 31 44 X
		//05 Razo Social Razo Social do estabelecimento 50 45 94 X

		
		$linha = 'W1'.
		         fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
				 preenche_texto($IE,14).
				 preenche_texto($IM,14).
				 preenche_texto(substr($reg_empresa->Nome_Razao,0,50),50);
		$dados_txt.= $linha.FIML;
		
		$linha = 'W2'.
		         fill_full(limpa_numero(config_pad('paf_emp_cnpj')),14).
				 preenche_texto(config_pad('paf_emp_ie'),14).
				 preenche_texto(config_pad('paf_emp_im'),14).
				 preenche_texto(substr((config_pad('paf_emp_razao')),0,50),50);
		$dados_txt.= $linha.FIML;
		
		$linha = 'W3'.
				 preenche_texto(substr((config_pad('sistema_nome_pdv')),0,50),50).
				 preenche_texto(substr((config_pad('sistema_versao_pdv')),0,10),10);
		$dados_txt.= $linha.FIML;
		
		$totalz4=0;
		
		//Z4
		//01 Tipo de registro Z4 02 1 2 X
		//02 Nmero do CPF/CNPJ,Nmero do CPF/CNPJ Identificado na NFC-e 14 3 16 N
		//03 Totalizao Mensal  Total de vendas no ms, com duas casas decimais, ao CPF/CNPJ indicado no campo 02 14 17 30 N
		//04 Data Inicial das Vendas ao CPF/CNPJ Primeiro dia do ms a que se refere o relatrio de Vendas ao CPF/CNPJ identificado no campo 02 08 31 38 D
		//05 Data Final das Vendas ao CPF/CNPJ ltimo dia do ms a que se refere o relatrio de vendas ao CPF/CNPJ Identificado no campo 02 08 39 46 D
		//06 Data da gerao do relatrio Data que o relatrio foi gerado pelo PAF-NFC-e 08 47 54 D
		//07 Hora da Gerao do Relatrio Hora que o relatrio foi gerado pelo PAF-NFC-e 06 55 60 H
		$notas = array();

		$con_nota = 'select * from pedido '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' and Empresa = "'.$empresa.'"'.
					 ' and DH_Emissao>="'.$dt_ini.'"'.
					 ' and DH_Emissao<="'.$dt_fim.' 23:59:59"'.
					 ' and CRE>0';//or (Modelo="01")) ';
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrw_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);
			$chave = $reg_nota->CRE;
			$notas[$chave]['Origem'] = 'Internet';
			$notas[$chave]['Status'] = 'R';
			if ($reg_nota->Status=='E'){
				$notas[$chave]['Status'] = 'D';
			}
			if ($reg_nota->Status=='F'){
				$notas[$chave]['Status'] = 'A';
			}
			$notas[$chave]['CRE'] = $reg_nota->CRE;
			$notas[$chave]['DAV'] = $reg_nota->Numero_Pedido;
			$notas[$chave]['PV'] = 0;
			$notas[$chave]['Valor'] = $reg_nota->Valor_Total_Liquido;
		}
		consulta_limpa($res_nota);
		
		ksort($notas);
		foreach($notas as $chave => $valor){
			$nota = $notas[$chave];
			$linha = 'W4'.
					 preenche_texto($nota['Origem'],20).
					 preenche_texto($nota['Status'],1).
					 fill_full(limpa_numero($nota['CRE']),9).
					 fill_full(limpa_numero($nota['DAV']),13).
					 fill_full(limpa_numero($nota['PV']),10).
					 fill_full(round($nota['Valor']*100),14);		
			$dados_txt.= $linha.FIML;
			$totalz4++;
		}
		
		$linha = 'W5'.
				 fill_full(limpa_numero(config_pad('paf_emp_cnpj')),14).
				 preenche_texto(config_pad('paf_emp_ie'),14).
				 fill_full($totalz4,6);
		$dados_txt.= $linha.FIML;
		
		return $dados_txt;
    }

    function paf_gera_davs(){
		$empresa = $_SESSION['Empresa_Codigo'];
		$dados_txt = '';
		
		$con_empresa = 'select * from pessoa '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresa = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$con_empresa = 'select * from pessoa_endereco '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Pessoa="'.$empresa.'"'.
					   ' and Situacao<>"E"'.
					   ' order by Seq_Endereco';
		$res_empresa = consulta_sql($con_empresa);
		$reg_empresae = consulta_ler_objeto($res_empresa);
		consulta_limpa($res_empresa);
		
		$IE = substr(limpa_numero($reg_empresae->Insc_Estadual),0,14);
		if ($IE == ''){
			$IE = 'ISENTO';
		}
		$IM = substr(limpa_numero($reg_empresae->Insc_Municipal),0,14);
		
		//registro UI
		//01 Tipo de registro V1 02 1 2 X
		//02 CNPJ CNPJ do estabelecimento usurio do PAF-NFC-e 14 3 16 N
		//03 Inscrio Estadual Inscrio Estadual do estabelecimento 14 17 30 X
		//04 Inscrio Municipal Inscrio Municipal do estabelecimento 14 31 44 X
		//05 Razo Social Razo Social do estabelecimento 50 45 94 X

		
		$linha = 'V1'.
		         fill_full(limpa_numero($reg_empresa->CPF_CNPJ),14).
				 preenche_texto($IE,14).
				 preenche_texto($IM,14).
				 preenche_texto(substr($reg_empresa->Nome_Razao,0,50),50);
		$dados_txt.= $linha.FIML;
				
		
		//V2 / V3
		// 01 Tipo de registro V2 02 1 2 X
		// 02 Data Data da abertura do DAV 08 3 10 D
		// 03 DAV N Nmero do DAV no encerrado 13 11 23 N
		
		$data_limite = datad(nr2data(data_atual('num')-(366*5)));
		$data_limiteS = ' AND DH_Emissao>="'.$data_limite.'"';

		$con_nota = 'SELECT * FROM pedido '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Empresa = "'.$empresa.'"'.
					 ' AND Status<>"F"'.
					 ' ORDER BY DH_Emissao';
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrw_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);
			$linha = 'V2'.					 
					 fill_full(limpa_numero(datad(dataf($reg_nota->DH_Emissao))),8).
					 fill_full(limpa_numero($reg_nota->Numero_Pedido),13);
			$dados_txt.= $linha.FIML;
		}
		consulta_limpa($res_nota);

		$con_nota = 'SELECT * FROM pedido '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' AND Empresa = "'.$empresa.'"'.
					 ' AND Status="F"'.
					 $data_limiteS.
					 ' AND Nota_Modelo<>"55"'.
					 ' AND Nota_Modelo<>"65"'.
					 ' ORDER BY DH_Emissao';
		$res_nota = consulta_sql($con_nota);
		$nrw_nota = consulta_num_registros($res_nota);
		for($n=0;$n<$nrw_nota;$n++){
			$reg_nota = consulta_ler_objeto($res_nota);
			$linha = 'V3'.					 
					 fill_full(limpa_numero(datad(dataf($reg_nota->DH_Emissao))),8).
					 fill_full(limpa_numero($reg_nota->Numero_Pedido),13);
			$dados_txt.= $linha.FIML;
		}
		consulta_limpa($res_nota);
		
		
		
		return $dados_txt;
    }

	/*
	function assinaXML($docxml, $tag){

        try {
            $tagid = $tag;
            $crt_dir = dirname(dirname($this->rps_dir)) . '/cert';
            $priKEY = "$crt_dir/pkey.pem";
            $keypass = file_get_contents("$crt_dir/pass.txt");
            $pubKEY = "$crt_dir/cert.pem";

            // Habilita a manipulao de erros da libxml
            libxml_use_internal_errors(true);
            //limpar erros anteriores que possam estar em memria
            libxml_clear_errors();
            // carrega o documento no DOM
            $xmldoc = new DOMDocument('1.0', 'UTF-8');
            $xmldoc->preserveWhiteSpace = true; //elimina espaos em branco
            $xmldoc->formatOutput = false;
            // muito importante deixar ativadas as opes para limpar os espacos em branco
            // e as tags vazias
            if (!$xmldoc->loadXML($docxml, LIBXML_NOBLANKS | LIBXML_NOXMLDECL | LIBXML_BIGLINES)) {
                $msg = "Erro ao carregar XML, provavel erro no proprio xml!!";
                $errors = libxml_get_errors();
                if (!empty($errors)) {
                    $i = 1;
                    foreach ($errors as $error) {
                        $msg .= "\n  [$i]-" . trim($error->message);
                    }
                    libxml_clear_errors();
                }
                throw new Exception($msg);
            }

            //extrair a tag com os dados a serem assinados
            $xpath = new DOMXPath($xmldoc);
            $xpath->registerNamespace('ns', "http://www.sef.sc.gov.br/nfce");
            $node = $xpath->query("//ns:{$tagid}")->item(0);
            if (!isset($node)) {
                $msg = "A tag <$tagid> no existe no XML!!";
                throw new Exception($msg);
            }

            // Cria novo Security object
            $objDSig = new XMLSecurityDSig('');
            // Usa a c14n exclusive canonicalization
            $objDSig->setCanonicalMethod(XMLSecurityDSig::C14N);
            // Assina usando SHA-1
            $objDSig->addReference(
                $node,
                XMLSecurityDSig::SHA1,
                [
                    "http://www.w3.org/2000/09/xmldsig#enveloped-signature",
                    "http://www.w3.org/TR/2001/REC-xml-c14n-20010315"
                ],
                [
                    'id_name' => 'Id',
                    'overwrite' => false
                ]
            );

            // Cria nova (private) Security key
            $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA1, array('type'=>'private'));
            $objKey->passphrase = "$keypass";
            $objKey->loadKey("$priKEY", TRUE);

            // Assina o XML
            $objDSig->sign($objKey);
            // Adiciona a public key para a signature
            $objDSig->add509Cert(file_get_contents("$pubKEY"));
            // Acrescenta a signature para o XML
            $objDSig->appendSignature($node->parentNode);
            $objDSig = null;

            //grava na string o objeto DOM
            $xml = $xmldoc->saveXML();
        } catch (Exception $e) {
            throw $e;
        }
        //retorna o documento assinado
        return $xml;
    } //fim signXM
	*/

	function paf_busca_certificado(){
		$ret['cert_pfx'] = base64_decode(BuscaParamEmpresa('CERT_PFX'));
		$ret['senha'] = base64_decode(BuscaParamEmpresa('CERT_SENHA'));

		if ($ret['cert_pfx']==''){
			//$ret['cert_pfx'] = file_get_contents('../../includes/chave_freeline.free');
			//$ret['senha'] = base64_decode('QGZyZWVsaW5lMTk5MQ==');
		}
		return $ret;
	}

	function paf_ler_certificado(){
		$certificado = paf_busca_certificado();
		$ret['ok'] = false;
		$ret['msg'] = '';

		//$pfxCertPrivado = $certificado['cert_pfx'];
		$pfxContent = $certificado['cert_pfx'];//file_get_contents($pfxCertPrivado);
		$cert_password  = $certificado['senha'];

		if ($pfxContent=='') {
			$ret['msg'] = "Certificado no cadastrado!!";
			return $ret;
		}		

		if (!openssl_pkcs12_read($pfxContent, $x509certdata, $cert_password)) {
			$ret['msg'] = "O certificado no pode ser lido!!";
			return $ret;
		} else {

			// $CertPriv   = array();
			// $CertPriv   = openssl_x509_parse(openssl_x509_read($x509certdata['cert']));

			//print_r($x509certdata);

			$PrivateKey = $x509certdata['pkey'];

			$pub_key = openssl_pkey_get_public($x509certdata['cert']);
			$keyData = openssl_pkey_get_details($pub_key);

			$PublicKey  = $keyData['key'];

			$objSSLPriKey = openssl_get_privatekey($PrivateKey);
			if ($objSSLPriKey === false) {
				$ret['msg'] = "Houve erro no carregamento da chave privada.";
				return $ret;
			}
			
			$objSSLPubKey = $PublicKey;//openssl_get_publickey($PublicKey);


			$ret['ok'] = true;
			$ret['msg'] = "Certificado lido com sucesso";
			$ret['objSSLPriKey'] = $objSSLPriKey;
			$ret['objSSLPubKey'] = $objSSLPubKey;
		}
		
		
		return $ret;
	}

	function paf_upload_certificado($empresa,$senha){
		if ((!empty($_FILES['certificado_arquivo']['name'])) && ($senha!="")){
			if (file_exists($_FILES['certificado_arquivo']['tmp_name'])){

				$cert_conteudo = base64_encode(file_get_contents($_FILES['certificado_arquivo']['tmp_name']));
				$cert_senha = base64_encode($senha);

				$consulta = 'UPDATE pessoa_empresa SET '.
							' CERT_PFX = "'.$cert_conteudo.'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = '.$empresa;
				consulta_sql($consulta);

				$consulta = 'UPDATE pessoa_empresa SET '.
							' CERT_SENHA = "'.$cert_senha.'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = '.$empresa;
				consulta_sql($consulta);


				$consulta = 'UPDATE t_pessoa_empresa SET '.
							' CERT_PFX = "'.$cert_conteudo.'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = '.$empresa;
				consulta_sql($consulta);

				$consulta = 'UPDATE t_pessoa_empresa SET '.
							' CERT_SENHA = "'.$cert_senha.'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' and Pessoa = '.$empresa;
				consulta_sql($consulta);
			}
		}
	}

	function paf_assina($docxml){

		$cert = paf_ler_certificado();	

		if ($cert['ok']){
			//$docxml = $xml_original;

			$tagid = 'arquivo';
	
			$xml = $docxml;
			// if (is_file($docxml)) {
			// 	$xml = file_get_contents($docxml);
			// }
			//remove sujeiras do xml
			$order = array("\r\n", "\n", "\r", "\t");
			$xml = str_replace($order, '', $xml);
			$xmldoc = new DOM();
			$xmldoc->loadXMLString($xml);
			//coloca o node raiz em uma varivel
			$root = $xmldoc->documentElement;
			//extrair a tag com os dados a serem assinados
			$node = $xmldoc->getElementsByTagName($tagid)->item(0);
			if (!isset($node)) {
				echo "A tag <$tagid> no existe no XML!!<BR>".$docxml;
				return $docxml;
			}
			//$this->docId = $node->getAttribute('Id');
			$xmlResp = $xml;
			$xmlRespA = zSignXML($xmldoc, $root, $node, $cert['objSSLPriKey'],$cert['objSSLPubKey']);
			if ($xmlRespA!=''){ $xmlResp = $xmlRespA;}
			//libera a chave privada
			//openssl_free_key($objSSLPriKey);
			return $xmlResp;
		}else{
			echo $cert['msg'];
			return $docxml;
		}	
		
	}


	function zSignXML($xmldoc, $root, $node, $objSSLPriKey,$objSSLPubKey){
        $nsDSIG = 'http://www.w3.org/2000/09/xmldsig#';
        $nsCannonMethod = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
        $nsSignatureMethod = 'http://www.w3.org/2000/09/xmldsig#rsa-sha1';
        $nsTransformMethod1 ='http://www.w3.org/2000/09/xmldsig#enveloped-signature';
        $nsTransformMethod2 = 'http://www.w3.org/TR/2001/REC-xml-c14n-20010315';
        $nsDigestMethod = 'http://www.w3.org/2000/09/xmldsig#sha1';
        //pega o atributo id do node a ser assinado
        $idSigned = trim($node->getAttribute("nroArquivo"));
        //extrai os dados da tag para uma string na forma canonica
        $dados = $node->C14N(true, false, null, null);
        //calcular o hash dos dados
        $hashValue = hash('sha1', $dados, true);
        //converter o hash para base64
        $digValue = base64_encode($hashValue);
        //cria o node <Signature>
        $signatureNode = $xmldoc->createElementNS($nsDSIG, 'Signature');
        //adiciona a tag <Signature> ao node raiz
        $root->appendChild($signatureNode);
        //cria o node <SignedInfo>
        $signedInfoNode = $xmldoc->createElement('SignedInfo');
        //adiciona o node <SignedInfo> ao <Signature>
        $signatureNode->appendChild($signedInfoNode);
        //cria no node com o mtodo de canonizao dos dados
        $canonicalNode = $xmldoc->createElement('CanonicalizationMethod');
        //adiona o <CanonicalizationMethod> ao node <SignedInfo>
        $signedInfoNode->appendChild($canonicalNode);
        //seta o atributo ao node <CanonicalizationMethod>
        $canonicalNode->setAttribute('Algorithm', $nsCannonMethod);
        //cria o node <SignatureMethod>
        $signatureMethodNode = $xmldoc->createElement('SignatureMethod');
        //adiciona o node <SignatureMethod> ao node <SignedInfo>
        $signedInfoNode->appendChild($signatureMethodNode);
        //seta o atributo Algorithm ao node <SignatureMethod>
        $signatureMethodNode->setAttribute('Algorithm', $nsSignatureMethod);
        //cria o node <Reference>
        $referenceNode = $xmldoc->createElement('Reference');
        //adiciona o node <Reference> ao node <SignedInfo>
        $signedInfoNode->appendChild($referenceNode);
        //seta o atributo URI a node <Reference>
        $referenceNode->setAttribute('URI', '#'.$idSigned);
        //cria o node <Transforms>
        $transformsNode = $xmldoc->createElement('Transforms');
        //adiciona o node <Transforms> ao node <Reference>
        $referenceNode->appendChild($transformsNode);
        //cria o primeiro node <Transform> OBS: no singular
        $transfNode1 = $xmldoc->createElement('Transform');
        //adiciona o primeiro node <Transform> ao node <Transforms>
        $transformsNode->appendChild($transfNode1);
        //set o atributo Algorithm ao primeiro node <Transform>
        $transfNode1->setAttribute('Algorithm', $nsTransformMethod1);
        //cria outro node <Transform> OBS: no singular
        $transfNode2 = $xmldoc->createElement('Transform');
        //adiciona o segundo node <Transform> ao node <Transforms>
        $transformsNode->appendChild($transfNode2);
        //set o atributo Algorithm ao segundo node <Transform>
        $transfNode2->setAttribute('Algorithm', $nsTransformMethod2);
        //cria o node <DigestMethod>
        $digestMethodNode = $xmldoc->createElement('DigestMethod');
        //adiciona o node <DigestMethod> ao node <Reference>
        $referenceNode->appendChild($digestMethodNode);
        //seta o atributo Algorithm ao node <DigestMethod>
        $digestMethodNode->setAttribute('Algorithm', $nsDigestMethod);
        //cria o node <DigestValue>
        $digestValueNode = $xmldoc->createElement('DigestValue', $digValue);
        //adiciona o node <DigestValue> ao node <Reference>
        $referenceNode->appendChild($digestValueNode);
        //extrai node <SignedInfo> para uma string na sua forma canonica
        $cnSignedInfoNode = $signedInfoNode->C14N(true, false, null, null);
        //cria uma variavel vazia que receber a assinatura
        $signature = '';
        //calcula a assinatura do node canonizado <SignedInfo>
        //usando a chave privada em formato PEM
        if (! openssl_sign($cnSignedInfoNode, $signature, $objSSLPriKey)) {
            $msg = "Houve erro durante a assinatura digital.\n";
			echo $msg;
			return '';
        }
        //converte a assinatura em base64
        $signatureValue = base64_encode($signature);
        //cria o node <SignatureValue>
        $signatureValueNode = $xmldoc->createElement('SignatureValue', $signatureValue);
        //adiciona o node <SignatureValue> ao node <Signature>
        $signatureNode->appendChild($signatureValueNode);
        //cria o node <KeyInfo>
        $keyInfoNode = $xmldoc->createElement('KeyInfo');
        //adiciona o node <KeyInfo> ao node <Signature>
        $signatureNode->appendChild($keyInfoNode);
        //cria o node <X509Data>
        $x509DataNode = $xmldoc->createElement('X509Data');
        //adiciona o node <X509Data> ao node <KeyInfo>
        $keyInfoNode->appendChild($x509DataNode);
        //remove linhas desnecessrias do certificado
        
		$pubKeyClean = zCleanPubKey($objSSLPubKey);
        
		//cria o node <X509Certificate>
        $x509CertificateNode = $xmldoc->createElement('X509Certificate', $pubKeyClean);
        //adiciona o node <X509Certificate> ao node <X509Data>
        $x509DataNode->appendChild($x509CertificateNode);
        //salva o xml completo em uma string
        $xmlResp = $xmldoc->saveXML();
        //retorna o documento assinado
        return $xmlResp;
    }

	function zCleanPubKey($pubKey){
        //inicializa variavel
		$data = $pubKey;
        $data = str_replace('-----BEGIN PUBLIC KEY-----','',$data);
        $data = str_replace('-----END PUBLIC KEY-----','',$data);
		$data = str_replace('-----BEGIN CERTIFICATE-----','',$data);
        $data = str_replace('-----END CERTIFICATE-----','',$data);
        $data = str_replace("\n",'',$data);
        $data = str_replace("\r",'',$data);
        
		$data = trim($data);
        return $data;
    }


	class Dom extends DOMDocument{
		/**
		 * __construct
		 *
		 * @param string $version
		 * @param string $charset
		 */
		var $erros = array();
		public function __construct($version = '1.0', $charset = 'utf-8'){
			parent::__construct($version, $charset);
			$this->formatOutput = false;
			$this->preserveWhiteSpace = false;
		}

		public function loadXMLString($xmlString = ''){
			if (! $this->loadXML($xmlString, LIBXML_NOBLANKS | LIBXML_NOEMPTYTAG)) {
				$msg = "O arquivo indicado no  um XML!";
				echo $msg;
			}
		}
		
		public function loadXMLFile($pathXmlFile = ''){
			$data = file_get_contents($$pathXmlFile);
			$this->loadXMLString($data);
		}
				
		/**
		 * getNodeValue
		 * Extrai o valor do node DOM
		 *
		 * @param  string $nodeName        identificador da TAG do xml
		 * @param  int    $itemNum         numero do item a ser retornado
		 * @param  string $extraTextBefore prefixo do retorno
		 * @param  string $extraTextAfter  sufixo do retorno
		 * @return string
		 */
		public function getNodeValue($nodeName, $itemNum = 0, $extraTextBefore = '', $extraTextAfter = ''){
			$node = $this->getElementsByTagName($nodeName)->item($itemNum);
			if (isset($node)) {
				$texto = html_entity_decode(trim($node->nodeValue), ENT_QUOTES, 'UTF-8');
				return $extraTextBefore . $texto . $extraTextAfter;
			}
			return '';
		}
		
		/**
		 * getValue
		 *
		 * @param  DOMElement $node
		 * @param  string     $name
		 * @return string
		 */
		public function getValue($node, $name){
			if (empty($node)) {
				return '';
			}
			$texto = ! empty($node->getElementsByTagName($name)->item(0)->nodeValue) ?
				$node->getElementsByTagName($name)->item(0)->nodeValue : '';
			return html_entity_decode($texto, ENT_QUOTES, 'UTF-8');
		}
		
		/**
		 * getNode
		 * Retorna o node solicitado
		 *
		 * @param  string  $nodeName
		 * @param  integer $itemNum
		 * @return DOMElement se existir ou string vazia se no
		 */
		public function getNode($nodeName, $itemNum = 0){
			$node = $this->getElementsByTagName($nodeName)->item($itemNum);
			if (isset($node)) {
				return $node;
			}
			return '';
		}
		
		/**
		 * getChave
		 *
		 * @param  string $nodeName
		 * @return string
		 */
		public function getChave($nodeName = 'infNFe'){
			$node = $this->getElementsByTagName($nodeName)->item(0);
			if (! empty($node)) {
				$chaveId = $node->getAttribute("Id");
				$chave =  preg_replace('/[^0-9]/', '', $chaveId);
				return $chave;
			}
			return '';
		}
		
		/**
		 * addChild
		 * Adiciona um elemento ao node xml passado como referencia
		 * Sero inclusos erros na array $erros[] sempre que a tag for obrigatria e
		 * nenhum parmetro for passado na varivel $content e $force for false
		 *
		 * @param  \DOMElement $parent
		 * @param  string      $name
		 * @param  string      $content
		 * @param  boolean     $obrigatorio
		 * @param  string      $descricao
		 * @param  boolean     $force       fora a criao do elemento mesmo sem dados e no considera como erro
		 * @return void
		 */
		public function addChild(&$parent, $name, $content = '', $obrigatorio = false, $descricao = "", $force = false){
			$content = trim($content);
			if ($obrigatorio && $content === '' && !$force) {
				$this->erros[] = array(
					"tag" => $name,
					"desc" => $descricao,
					"erro" => "Preenchimento Obrigatrio!"
				);
			}
			if ($obrigatorio || $content !== '' || $force) {
				$content = htmlspecialchars($content, ENT_QUOTES);
				$temp = $this->createElement($name, $content);
				$parent->appendChild($temp);
			}
		}
		
		/**
		 * appChild
		 * Acrescenta DOMElement a pai DOMElement
		 * Caso o pai esteja vazio retorna uma exception com a mensagem
		 * O parametro "child" pode ser vazio
		 *
		 * @param  \DOMNode $parent
		 * @param  \DOMNode $child
		 * @param  string   $msg
		 * @return void
		 * @throws Exception\InvalidArgumentException
		 */
		public function appChild(&$parent, $child, $msg = ''){
			if (empty($parent)) {
				echo $msg;
			}
			if (!empty($child)) {
				$parent->appendChild($child);
			}
		}
		
		/**
		 * addArrayChild
		 * Adiciona a um DOMNode parent, outros elementos passados em um array de DOMElements
		 *
		 * @param  DOMElement $parent
		 * @param  array      $arr
		 * @return int
		 */
		public function addArrayChild(&$parent, $arr){
			$num = 0;
			if (! empty($arr) && ! empty($parent)) {
				foreach ($arr as $node) {
					$this->appChild($parent, $node, '');
					$num++;
				}
			}
			return $num;
		}
	}


?>