<?php

	function inputs_post($post){
		$html = '';
		if(!empty($post)){
			foreach($post as $chave => $valor){
				$html.= '<input type="hidden" name="'.$chave.'" value="'.$valor.'">';
			}
		}
		return $html;
	}

	//<CRM>
	function auto_version($file){
		return file_exists($file) ? $file.'?'.filemtime($file) : $file;
	}

	function busca_faturamento_mensal_vendedor($vendedor, $ano, $mes){
		$mes = str_pad($mes, 2, '0', STR_PAD_LEFT);
		$ano_mes = $ano.$mes;
		$valor_faturamento = 0;
		$data_atual = data_atual('date');
		$ano_atual = substr($data_atual, 0, 4);
		$mes_atual = substr($data_atual, 5, 2);
		//$mes_atual = '03';
		$ano_mes_atual = $ano_atual.$mes_atual;
		if ($ano_mes <= $ano_mes_atual){ // no deixa buscar faturamento de um ms posterior ao atual
			$con_faturamento = 'SELECT Valor_Total_NF, Valor_Total_NF_Prod	FROM crm_vendedor_faturamento '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
								' AND AnoMes = "'.$ano_mes.'" '.
								' AND Vendedor = "'.$vendedor.'" '.
								' AND Situacao = "A" ';
			$res_faturamento = consulta_sql($con_faturamento);
			$nrw_faturamento = consulta_num_registros($res_faturamento);
			if ($nrw_faturamento > 0){
				$reg_faturamento = consulta_ler_objeto($res_faturamento);
				$calcula_mes = false;
				if ($ano_mes == $ano_mes_atual){
					$calcula_mes = true;
				}
				if ($calcula_mes === true){
					$ret_calc = calcula_faturamento_mensal_vendedor($vendedor, $ano, $mes);
					$valor_faturamento = $ret_calc['Valor_Total_NF'];
				}else{
					$valor_faturamento = $reg_faturamento->Valor_Total_NF;
				}
			}else{
				$ret_calc = calcula_faturamento_mensal_vendedor($vendedor, $ano, $mes);
				$valor_faturamento = $ret_calc['Valor_Total_NF'];
			}
			consulta_limpa($res_faturamento);
		}
		return $valor_faturamento;
	}

	function calcula_faturamento_mensal_vendedor($vendedor, $ano, $mes){
		$dominios = array();
		$dominios['271'] = '271'; 
		$con_faturamento = 'SELECT IFNULL(SUM( '.
							' (nfi.Valor_Total + nfi.Valor_Outros + nfi.ICMSST_Valor + nfi.IPI_Valor + nfi.Valor_Frete + nfi.Valor_Seguro) * ( '.
							'    CASE '.
							'       WHEN ((nf.TipoES = "1") AND (nfi.CFOP_Gera_Contas = "R")) THEN 1 '.
							'       WHEN ((nf.TipoES = "0") AND (nfi.CFOP_Gera_Contas = "A")) THEN -1 '.
							'       ELSE 0 '.
							'    END '.
							' )), 0) AS Valor_Total_NF '.
							' FROM nota_fiscal nf '.
							' INNER JOIN nota_fiscal_item nfi '.
							' ON nf.Dominio = nfi.Dominio '.
							' AND nf.Empresa = nfi.Empresa '.
							' AND nf.Nr_Nota = nfi.Nr_Nota '.
							' WHERE nf.Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND nf.Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
							' AND ( '.
							'    ((nf.TipoES = "1") AND (nfi.CFOP_Gera_Contas = "R")) OR '.
							'    ((nf.TipoES = "0") AND (nfi.CFOP_Gera_Contas = "A")) '.
							' ) '.
							' AND ((nf.Nat_Op_CFOP <> "5.929") AND (nf.Nat_Op_CFOP <> "6.929")) '.
							' AND nf.Situacao = "F" '.
							' AND YEAR(nf.DH_EntSai) = "'.$ano.'"  '.
							' AND MONTH(nf.DH_EntSai) = "'.$mes.'"';
		if ($vendedor > 0){
			$con_faturamento.= ' AND nf.Vendedor = "'.$vendedor.'" ';
		}
		if ($_SESSION['Dominio'] == $dominios['271']){
			$con_faturamento.= 'AND nf.Vendedor <> "1253"';
		}
		$res_faturamento = consulta_sql($con_faturamento);
		$reg_faturamento = consulta_ler_objeto($res_faturamento);
		consulta_limpa($res_faturamento);
		$valor_total_nf = $reg_faturamento->Valor_Total_NF;
		//$valor_total_nf_prod = $reg_faturamento->Valor_Total_NF_Prod;
		$valor_total_nf_prod = 0;
		//$ano = substr($dh_entsai, 0, 4);
		//$mes = substr($dh_entsai, 5, 2);
		$ano_mes = $ano.$mes;
		$usuario = '';
		if (isset($_REQUEST['USER_ID'])){
			$usuario = base64_decode_si($_REQUEST['USER_ID']);
		}else if(isset($_SESSION['CRM'])){
			$usuario = $_SESSION['USER_ID'];
		}
		$insert = 'INSERT INTO crm_vendedor_faturamento ( '.
					' Dominio, '.
					' Empresa, '.
					' AnoMes, '.
					' Vendedor, '.
					' Valor_Total_NF, '.
					' Valor_Total_NF_Prod, '.
					' DH_Criacao, '.
					' Usuario_Criacao, '.
					' Situacao '.
					' ) VALUES ('.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$_SESSION['Empresa_Codigo'].'", '.
					' "'.$ano_mes.'", '.
					' "'.$vendedor.'", '.
					' "'.$valor_total_nf.'", '.
					' "'.$valor_total_nf_prod.'", '.
					' now(), '.
					' "'.$usuario.'", '.
					' "A" '.
					' ) ON DUPLICATE KEY UPDATE '.
					' Valor_Total_NF = "'.$valor_total_nf.'", '.
					' Valor_Total_NF_Prod = "'.$valor_total_nf_prod.'"';
		consulta_sql($insert);
		if ($vendedor > 0){
			$data_atual = data_atual('date');
			$ano_atual = substr($data_atual, 0, 4);
			$mes_atual = substr($data_atual, 5, 2);
			$ano_mes_atual = $ano_atual.$mes_atual;
			$calcula_mes = true;
			$con_faturamento = 'SELECT COUNT(*) FROM crm_vendedor_faturamento '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
								' AND AnoMes = "'.$ano_mes.'" '.
								' AND Vendedor = "0" '.
								' AND Situacao = "A" ';
			$res_faturamento = consulta_sql($con_faturamento);
			$reg_faturamento = consulta_ler_linha($res_faturamento);
			consulta_limpa($res_faturamento);
			if ($reg_faturamento[0] > 0){
				if ($ano_mes != $ano_mes_atual){
					$calcula_mes = false;
				}
			}
			if ($calcula_mes === true){
				calcula_faturamento_mensal_vendedor('0', $ano, $mes); //calcula faturamento mensal para o vendedor 0 - Geral
			}
		}
		return array(
						'Valor_Total_NF' => $valor_total_nf,
						'Valor_Total_NF_Prod' => $valor_total_nf_prod
					);
	}

	function ticket_medio_cliente($pessoa, $calcula = false){
		$con_cli = 'SELECT DH_Ultima_Venda, Ticket_Medio, Numero_Notas FROM pessoa_cliente '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$pessoa.'"';
		$res_cli = consulta_sql($con_cli);
		$reg_cli = consulta_ler_linha($res_cli);
		consulta_limpa($res_cli);
		$dh_ultima_venda = $reg_cli[0];
		$ticket_medio = $reg_cli[1];
		$numero_notas = $reg_cli[2];
		if (($calcula === true) || (($ticket_medio == 0 || $numero_notas == 0) && ($dh_ultima_venda != '0000-00-00 00:00:00'))){
			$con_ticket_medio = 'SELECT IFNULL((SUM(Total_NF) / COUNT(*)), 0) as Ticket_Medio, COUNT(*) as Numero_Notas FROM nota_fiscal '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
								' AND TipoES = "1" '.
								' AND Nat_Op_Gera_Contas = "R" '.
								' AND Destinatario = "'.$pessoa.'" '.
								' AND Total_NF > 0 '.
								' AND Situacao = "F" ';
			$res_ticket_medio = consulta_sql($con_ticket_medio);
			$reg_ticket_medio = consulta_ler_objeto($res_ticket_medio);
			consulta_limpa($res_ticket_medio);
			$ticket_medio = $reg_ticket_medio->Ticket_Medio;
			$numero_notas = $reg_ticket_medio->Numero_Notas;
			$prefixo = 't_';
			for($t=0;$t<2;$t++){
				$upt_cli = 'UPDATE '.$prefixo.'pessoa_cliente SET '.
							' Ticket_Medio = "'.$ticket_medio.'", ' .
							' Numero_Notas = "'.$numero_notas.'" ' .
							' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
							' AND Pessoa = "'.$pessoa.'" ';
				$res_cli = consulta_sql($upt_cli, true, 1);            
				$prefixo = '';
			}
		}
		return array(
						'DH_Ultima_Venda' => $dh_ultima_venda,
						'Valor_Medio' => $ticket_medio,
						'Numero_Notas' => $numero_notas
					);
	}

	function colunaToLetraPHPExcel($coluna){
		$letras = array(
						0 => 'A',
						1 => 'B',
						2 => 'C',
						3 => 'D',
						4 => 'E',
						5 => 'F',
						6 => 'G',
						7 => 'H',
						8 => 'I',
						9 => 'J',
						10 => 'K',
						11 => 'L',
						12 => 'M',
						13 => 'N',
						14 => 'O',
						15 => 'P',
						16 => 'Q',
						17 => 'R',
						18 => 'S',
						19 => 'T',
						20 => 'U',
						21 => 'V',
						22 => 'W',
						23 => 'X',
						24 => 'Y',
						25 => 'Z'
						);
		$primeira_letra = 0;
		while($coluna > 26){
			$primeira_letra++;
			$coluna-= 26;
		}
		$letra = $letras[$coluna];
		if ($primeira_letra > 0){
			$letra = $letras[$primeira_letra].$letra;
		}
		return $letra;
	}

	function random_color_part($darker){
		return str_pad( dechex( mt_rand( ($darker) ? 0 : 40, 255 ) ), 2, '0', STR_PAD_LEFT);
	}

	function random_color($darker = false){
		return random_color_part($darker) . random_color_part($darker) . random_color_part($darker);
	}

	function lista_anos($ano_max = 1900){
		$anos = range(date('Y'), $ano_max);
		return array_combine($anos, $anos);
	}   

	function utf8_encode_si($string){
		if (!is_utf8($string)){
			$string = utf8_encode($string);
		}
		return $string;
	}

	function is_utf8($string){
		return (mb_detect_encoding($string, 'UTF-8', true) == 'UTF-8');
	}

	function utf8_decode_si($string){
		if (is_utf8($string)){
			$string = utf8_decode($string);
		}
		return $string;
	}

	function lista_decimais(){
		$lista = array();
		$lista['-1'] = 3;
		$sql_unidade = 'select Unidade,Decimais from unidade_medida'.
		' where Dominio="'.$_SESSION["Dominio"].'"';
		$res_unidade = consulta_sql($sql_unidade);
		$nrw_unidade = consulta_num_registros($res_unidade);
		for ($u=0;$u<$nrw_unidade;$u++){
			$reg_unidade = consulta_ler_linha($res_unidade);
			$lista[$reg_unidade[0]] = $reg_unidade[1];
		}
		consulta_limpa($res_unidade);
		return $lista;
	}

	function valida_cpf_cnpj($cpf_cnpj){
		if (strlen($cpf_cnpj)== 18){
			return CalculaCNPJ($cpf_cnpj);
		}else{
			return CalculaCPF($cpf_cnpj);
		}
	}

	//Calcula CPF
	function CalculaCPF($CampoNumero){
		$Numero = array();
		$resultado_calculo = true;
		$RecebeCPF=$CampoNumero;
		//Retirar todos os caracteres que nao sejam 0-9
		$s="";
		for ($x=1; $x<=strlen($RecebeCPF); $x=$x+1){
			$ch=substr($RecebeCPF,$x-1,1);
			if (ord($ch)>=48 && ord($ch)<=57){
				$s=$s.$ch;
			}
		}
		$RecebeCPF=$s;
		if (strlen($RecebeCPF)!=11){
			$resultado_calculo= false;
		}else if($RecebeCPF=="00000000000"){
			//$then;
			$resultado_calculo= false;
		}else{
			$Numero[1]=intval(substr($RecebeCPF,1-1,1));
			$Numero[2]=intval(substr($RecebeCPF,2-1,1));
			$Numero[3]=intval(substr($RecebeCPF,3-1,1));
			$Numero[4]=intval(substr($RecebeCPF,4-1,1));
			$Numero[5]=intval(substr($RecebeCPF,5-1,1));
			$Numero[6]=intval(substr($RecebeCPF,6-1,1));
			$Numero[7]=intval(substr($RecebeCPF,7-1,1));
			$Numero[8]=intval(substr($RecebeCPF,8-1,1));
			$Numero[9]=intval(substr($RecebeCPF,9-1,1));
			$Numero[10]=intval(substr($RecebeCPF,10-1,1));
			$Numero[11]=intval(substr($RecebeCPF,11-1,1));
			$soma=10*$Numero[1]+9*$Numero[2]+8*$Numero[3]+7*$Numero[4]+6*$Numero[5]+5*
			$Numero[6]+4*$Numero[7]+3*$Numero[8]+2*$Numero[9];
			$soma=$soma-(11*(intval($soma/11)));
			if($soma==0 || $soma==1){
				$resultado1=0;
			} else {
				$resultado1=11-$soma;
			}
			if($resultado1==$Numero[10]){
				$soma=$Numero[1]*11+$Numero[2]*10+$Numero[3]*9+$Numero[4]*8+$Numero[5]*7+$Numero[6]*6+$Numero[7]*5+
				$Numero[8]*4+$Numero[9]*3+$Numero[10]*2;
				$soma=$soma-(11*(intval($soma/11)));
				if ($soma==0 || $soma==1){
					$resultado2=0;
				}else{
					$resultado2=11-$soma;
				}
				if ($resultado2==$Numero[11]){
					$resultado_calculo= true;
				}else{
					$resultado_calculo= false;
				}
			}else{
				$resultado_calculo= false;
			}
		}
		return $resultado_calculo;
	}
	// Fim do Calcula CPF

	//Funo que calcula CNPJ
	function CalculaCNPJ($CampoNumero){
		$Numero = array();
		$RecebeCNPJ=${"CampoNumero"};
		$resultado_calculo= true;
		$s="";
		for($x=1; $x<=strlen($RecebeCNPJ); $x=$x+1){
			$ch=substr($RecebeCNPJ,$x-1,1);
			if (ord($ch)>=48 && ord($ch)<=57){
				$s=$s.$ch;
			}
		}
		$RecebeCNPJ=$s;
		if (strlen($RecebeCNPJ)!=14){
			$resultado_calculo= false;
		}else if ($RecebeCNPJ=="00000000000000"){
			$resultado_calculo= false;
		}else{
			$Numero[1]=intval(substr($RecebeCNPJ,1-1,1));
			$Numero[2]=intval(substr($RecebeCNPJ,2-1,1));
			$Numero[3]=intval(substr($RecebeCNPJ,3-1,1));
			$Numero[4]=intval(substr($RecebeCNPJ,4-1,1));
			$Numero[5]=intval(substr($RecebeCNPJ,5-1,1));
			$Numero[6]=intval(substr($RecebeCNPJ,6-1,1));
			$Numero[7]=intval(substr($RecebeCNPJ,7-1,1));
			$Numero[8]=intval(substr($RecebeCNPJ,8-1,1));
			$Numero[9]=intval(substr($RecebeCNPJ,9-1,1));
			$Numero[10]=intval(substr($RecebeCNPJ,10-1,1));
			$Numero[11]=intval(substr($RecebeCNPJ,11-1,1));
			$Numero[12]=intval(substr($RecebeCNPJ,12-1,1));
			$Numero[13]=intval(substr($RecebeCNPJ,13-1,1));
			$Numero[14]=intval(substr($RecebeCNPJ,14-1,1));
			$soma=$Numero[1]*5+$Numero[2]*4+$Numero[3]*3+$Numero[4]*2+$Numero[5]*9+$Numero[6]*8+$Numero[7]*7+
			$Numero[8]*6+$Numero[9]*5+$Numero[10]*4+$Numero[11]*3+$Numero[12]*2;
			$soma=$soma-(11*(intval($soma/11)));
			if ($soma==0 || $soma==1){
				$resultado1=0;
			}else{
				$resultado1=11-$soma;
			}
			if ($resultado1==$Numero[13]){
				$soma=$Numero[1]*6+$Numero[2]*5+$Numero[3]*4+$Numero[4]*3+$Numero[5]*2+$Numero[6]*9+
				$Numero[7]*8+$Numero[8]*7+$Numero[9]*6+$Numero[10]*5+$Numero[11]*4+$Numero[12]*3+$Numero[13]*2;
				$soma=$soma-(11*(intval($soma/11)));
				if ($soma==0 || $soma==1){
					$resultado2=0;
				}else{
					$resultado2=11-$soma;
				}
				if($resultado2==$Numero[14]){
					$resultado_calculo= true;
				}else{
					$resultado_calculo= false;
				}
			}else{
				$resultado_calculo= false;
			}
		}
		return $resultado_calculo;
	}
	//Fim do Calcula CNPJ
	/**Funo para apresentar o nome de Pedido ou Oramento */
	function busca_nome_pedido_orc($tipo = ''){
		if (($_SESSION["Dominio"]=='2')||($_SESSION["Dominio"]=='69') ||($_SESSION["Dominio"]=='34x')){
			//Adicionado DOM 34 em 29-03-2023 por @isabel
			//Comentado Dominio 34 em 23/08/2023 por @isabel a pedido do Cleitne 
			//Quando o Cleinte precisar da mudana no relatrio do Nome ( pedido/oramento) mudar no relatorio direto como era antes .
			$retorno = 'Pedido';
		}else{
			if ($tipo!='R'){
				$retorno = 'Oramento';
			}else{
				$retorno = 'Or.';
			}
		}
		if (isset($_SESSION['CRM'])){
			$retorno = utf8_encode_si($retorno);
		}
		return $retorno;
	}

    function busca_nome_servico_modelo($tipo = ''){
       
      
            $retorno = 'Ordem de Servio ';
      
        return $retorno;
    }

	function busca_nome_os($tipo = ''){
		$retorno = 'Ordem de Servio';
		return $retorno;	
	}

	function busca_nome_requisicao($abreviado = '', $label_nr = '', $plural = ''){
		if ($plural=='S'){
			return 'Consignaes';
		}else if(BuscaParam('REQ_TIPO')=='R'){
			if ($label_nr=='S'){
				return 'Requisio';
			}else if($abreviado=='S'){
				return 'Req. Material';
			}else{
				return 'Requisio de Material';
			}
		}else if(BuscaParam('REQ_TIPO')=='C'){
			return 'Consignao';
		}else if(BuscaParam('REQ_TIPO')=='O'){
			return 'Controle de Obra';
		}else if(BuscaParam('REQ_TIPO')=='T'){
			if ($abreviado=='S'){
				return 'Controle de Transf.';
			}else{
				return 'Controle de Transformao';
			}
		}
	}

	function busca_artigo_requisicao(){
		if ((BuscaParam('REQ_TIPO') == 'R') || (BuscaParam('REQ_TIPO') == 'C')){
			return 'a';
		}else if((BuscaParam('REQ_TIPO') == 'O') || (BuscaParam('REQ_TIPO') == 'T')){
			return 'o';
		}
	}

	function busca_limite_credito_utilizado($codigo){
		$con_contas = 'SELECT IFNULL(SUM(Valor), 0) FROM contas_pr '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$codigo.'"'.
						' AND TipoPR = "R" '.
						' AND Situacao = "A"';
		$res_contas = consulta_sql($con_contas);
		$reg_contas = consulta_ler_linha($res_contas);
		consulta_limpa($res_contas);
		$con_cheque = 'SELECT IFNULL(SUM(Valor), 0) FROM cheque_pre '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$codigo.'"'.
						' AND ( (Situacao = "C") OR (Situacao = "D") '.
						'    OR (Situacao = "2") OR (Situacao = "J") '.
						'    OR (Situacao = "I")) ';
		$res_cheque = consulta_sql($con_cheque);
		$reg_cheque = consulta_ler_linha($res_cheque);
		consulta_limpa($res_cheque);
		return ($reg_cheque[0] + $reg_contas[0]);
	}

	function busca_limite_credito_vencido($codigo){
		$con_contas = 'SELECT IFNULL(SUM(Valor), 0) FROM contas_pr '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Situacao = "A" '.
					' AND TipoPR = "R" '.
					' AND Pessoa = "'.$codigo.'"'.
					' AND DT_Vencto <= "'.data_atual('date').'"';
		$res_contas = consulta_sql($con_contas);
		$reg_contas = consulta_ler_linha($res_contas);
		consulta_limpa($res_contas);
		return $reg_contas[0];
	}

	function liberacao_credito($codigo){
		$usuario = '';
		if (isset($_REQUEST['USER_ID'])){
			$usuario = base64_decode_si($_REQUEST['USER_ID']);
		}else if (isset($_SESSION['CRM'])){
			$usuario = $_SESSION['USER_ID'];
		}
		// pegar o limite de credito anterior
		$con_pessoa = 'SELECT Limite_Credito_Total, Vendedor  FROM t_pessoa_cliente '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$codigo.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		//$nrw_pessoa = consulta_num_registros($res_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$upt_liberado = 'UPDATE t_pessoa_cliente SET '.
						' Limite_Credito_Status = "S", '.
						' Limite_Credito_Usuario = "'.$usuario.'",'.
						' Limite_Credito_Data = now() '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
						' AND Pessoa = "'.$codigo.'"';
		consulta_sql($upt_liberado);
		$upt_liberado = 'UPDATE pessoa_cliente SET '.
						//' Vendedor="'.$reg_pessoa[1].'", '.
						' Limite_Credito_Total="'.$reg_pessoa[0].'", '.
						' Limite_Credito_Status = "S", '.
						' Limite_Credito_Usuario = "'.$usuario.'",'.
						' Limite_Credito_Data = now() '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$codigo.'"';
		consulta_sql($upt_liberado);                
	}

	function desfazer_liberacao_credito($codigo){
		$con_pessoa = 'SELECT Limite_Credito_Total, Vendedor FROM pessoa_cliente '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Pessoa = "'.$codigo.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$nrw_pessoa = consulta_num_registros($res_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$update_tpessoa = 'UPDATE t_pessoa_cliente SET '.
		//' Vendedor= "'.$reg_pessoa[1].'",'.
		' Limite_Credito_Total= "'.$reg_pessoa[0].'",'.
		' Limite_Credito_Status="S" '.
		' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
		' AND Pessoa = "'.$codigo.'"';
		consulta_sql($update_tpessoa);
	}

	function liberacao_pessoa($codigo, $alt_nf = true){
		$pessoa   = tabelas('pessoa');
		$upt_liberado = 'Update t_pessoa set Liberado="S" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
		consulta_sql($upt_liberado);
		// pegar o limite de credito anterior
		$con_pessoa = 'select Limite_Credito_Total, Vendedor from pessoa_cliente '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$nrw_pessoa = consulta_num_registros($res_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$con_pessoan = 'select Limite_Credito_Total,Vendedor from t_pessoa_cliente '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
		$res_pessoan = consulta_sql($con_pessoan);
		$nrw_pessoan = consulta_num_registros($res_pessoan);
		$reg_pessoan = consulta_ler_linha($res_pessoan);
		consulta_limpa($res_pessoan);
		foreach ($pessoa as $nome){
			//apaga registros da tabela ativa
			$con_del = 'delete from '.$nome.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
			consulta_sql($con_del);
			//apaga registros da tabela ativa
			$con_ins = 'Insert into '.$nome.
						' select * from t_'.$nome.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
			consulta_sql($con_ins);
		}
		$vend = '';
		if ($_SESSION["Dominio"]==2){
			$vend = ' Vendedor="'.$reg_pessoa[1].'", ';
		}
		// Voltar o limite anterior
		$upt_liberado = 'Update pessoa_cliente set '.
						//$vend.
						' Limite_Credito_Total="'.$reg_pessoa[0].'", '.
						' Limite_Credito_Status="S" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
		consulta_sql($upt_liberado);
		$usuario = '';
		if (isset($_REQUEST['USER_ID'])){
			$usuario = base64_decode_si($_REQUEST['USER_ID']);
		}else if(isset($_SESSION['CRM'])){
			$usuario = $_SESSION['USER_ID'];
		}
		$con_limite_usuario = 'select Limite_Credito from usuario '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Usuario ="'.$usuario.'"';
		$res_limite_usuario = consulta_sql($con_limite_usuario);
		$reg_limite_usuario = consulta_ler_linha($res_limite_usuario);
		consulta_limpa($res_limite_usuario);
		if ($_SESSION["Dominio"]==2){
			if (($reg_pessoan[0]<=0.001)||($reg_pessoa[1]!=$reg_pessoan[1])){
				$reg_pessoan[0] = 0.01;
			}
		}
		if ($reg_limite_usuario[0]>=$reg_pessoan[0]){                    
			liberacao_credito($codigo);
		}
		/**Modificao realizada em 18/01/2023 para que o usuario que modificou o T_Pessoa, seja o mesmo do Pessoa  */
		$upt_liberado = 'UPDATE pessoa SET '.
						' DataHora_Alteracao = now() '.
					//	', Usuario_Alteracao  = "'.base64_decode_si($_REQUEST['USER_ID']).'" '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$codigo.'"';
		consulta_sql($upt_liberado);
		
		$upt_pessoa = 'UPDATE t_pessoa SET'.
					  ' DataHora_Alteracao = now() '.
					//  ' , Usuario_Alteracao  = "'.base64_decode_si($_REQUEST['USER_ID']).'"'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"';
		consulta_sql($upt_pessoa,true,1);
		/*
		consultar as notas fiscais com status A ou P da empresa atual.
		se status = P nao pode ter NFe_Situacao preenchida, emissao propria
		*/
		if ($alt_nf){
			$cons_nota_fiscal = 'Select Nr_Nota from nota_fiscal '.
								' where Dominio = "'.$_SESSION['Dominio'].'" '.
								' and Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
								' and EmissaoPT = "P" '.
								' and Destinatario = "'.$codigo.'" '.
								' and ( (Situacao = "A") or (Situacao = "P") ) ';
			$res_nota_fiscal = consulta_sql($cons_nota_fiscal);
			$nro_nota_fiscal = consulta_num_registros($res_nota_fiscal);
			/*para cada NF dessa consulta correr item por item e recalcular os impostos
			desses itens */
			for($k=0;$k<$nro_nota_fiscal;$k++){
				$reg_nota_fiscal = consulta_ler_objeto($res_nota_fiscal);
				$con_item = 'select Seq_Item from nota_fiscal_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' and Nr_Nota = "'.$reg_nota_fiscal->Nr_Nota.'" ';
				$res_item = consulta_sql($con_item);
				$nro_item = consulta_num_registros($res_item);
				for ($i=0;$i<$nro_item;$i++){
					$reg_item = consulta_ler_linha($res_item);
					nota_fiscal_recalcula($reg_nota_fiscal->Nr_Nota,$reg_item[0]);
				}
				consulta_limpa($res_item);
			}
			consulta_limpa($res_nota_fiscal);
		}else{
			$nro_nota_fiscal=0;
		}
		//retorne o numero de registros afetados de nf
		return $nro_nota_fiscal;
		//Confira novamente os valores para poder fechar as Notas fiscais.
	}

	function desfazer_liberacao_pessoa($codigo){
		$pessoa   = tabelas('pessoa');
		//consulta se  cadastro novo
		$con_pessoa = 'select Pessoa from pessoa '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa="'.$codigo.'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$nrw_pessoa = consulta_num_registros($res_pessoa);
		consulta_limpa($res_pessoa);
		//novos registro no se exclui, apenas remove da lista
		if ($nrw_pessoa==0){
			$upt_liberado = 'Update t_pessoa set Liberado="S",Situacao="E" '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Pessoa="'.$codigo.'"';
			consulta_sql($upt_liberado);
		}else{
			foreach ($pessoa as $nome){
				//apaga registros da tabela ativa
				$con_del = 'delete from t_'.$nome.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Pessoa="'.$codigo.'"';
				consulta_sql($con_del);
				//apaga registros da tabela ativa
				$con_ins = 'Insert into t_'.$nome.
							' select * from '.$nome.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Pessoa="'.$codigo.'"';
				consulta_sql($con_ins);
			}
		}
	}

	function vendedor_logado(){
		$pessoa = 0;
		$usuario = '';
		if (isset($_REQUEST['USER_ID'])){
			$usuario = base64_decode_si($_REQUEST['USER_ID']);
		}else if(isset($_SESSION['CRM'])){
			$usuario = $_SESSION['USER_ID'];
		}
		$con_vendedor = 'SELECT Pessoa FROM pessoa_vendedor '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Usuario = "'.$usuario.'"'.
						' AND Situacao <> "E"';
		$res_vendedor = consulta_sql($con_vendedor);
		$reg_vendedor = consulta_ler_linha($res_vendedor);
		consulta_limpa($res_vendedor);
		return (isset($reg_vendedor) ? $reg_vendedor[0] : '0');
	}

	function vendedor_cliente($pessoa){
		$con_vendedor = 'SELECT Vendedor FROM pessoa_cliente '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$pessoa.'"'.
						' AND Situacao <> "E"' ;
		$res_vendedor = consulta_sql($con_vendedor);
		$reg_vendedor = consulta_ler_linha($res_vendedor);
		consulta_limpa($res_vendedor);
		return (isset($reg_vendedor) ? $reg_vendedor[0] : '0');
	}

	function pedido_recalculo($nr_pedido,$nr_empresa=0){
        /*para adicionar o valor do Frete - pedidos WooComerce */
        //Cliente Versatil Dominio 23
		
		if ($nr_empresa==0){
			$nr_empresa = $_SESSION['Empresa_Codigo'];
		}
        $cons_pedido = 'SELECT Valor_Frete, Valor_Desconto, Valor_Acrescimo , Valor_Outros '.
                        ' FROM pedido '.
                        ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
                        ' AND Empresa = "'.$nr_empresa.'"'.
                        ' AND Numero_Pedido = "'.$nr_pedido.'" ';
                      //  ' AND   Status <> "E"';
        $res_pedido = consulta_sql($cons_pedido);
        $reg_pedido = consulta_ler_linha($res_pedido);
        consulta_limpa($res_pedido);
		
		$frete  = $reg_pedido[0];
        $outros = $reg_pedido[3];
            
		
		if ( ($_SESSION['Dominio'] == '351') || ($_SESSION['Dominio'] == '23') ){
            $desc   = $reg_pedido[1]; 
            $acres  = $reg_pedido[2];
        }else{
            $desc   = 0;
            $acres  = 0;
        }
       
        
		$valor_total_prod = 0;
		$valor_total_serv = 0;       
		$custo_total = 0;
		$cons_pedido_item = 'Select Id_Produto, Valor_Total, Valor_Desconto, Valor_Imposto,Preco_Custo,Qtd '.
                            ' from pedido_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$nr_empresa.'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"'.
							' and Status <> "E"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$nrowarr_pedido_item = consulta_num_registros($res_pedido_item);
		$total_desconto = 0;
		$total_imposto = 0;
		for($k=0;$k<$nrowarr_pedido_item;$k++){
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			$cons_produto = 'Select Codigo_Depart from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_pedido_item[0].'"';
			$res_produto = consulta_sql($cons_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);
			if($reg_produto[0] != 0){
				$valor_total_prod+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}else {
				$valor_total_serv+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}
			$total_desconto+= $reg_pedido_item[2];
			$total_imposto+= $reg_pedido_item[3];
			$custo_total = $reg_pedido_item[4] * $reg_pedido_item[5];
		}
		$sub_total = ($valor_total_prod+$valor_total_serv);
          /*para adicionar o valor do Frete - pedidos WooComerce */
        //Cliente Versatil Dominio 23
        
        $total_liq = $sub_total-$total_desconto+$total_imposto-$desc+$acres+$frete+$outros;   
        
		
		consulta_limpa($res_pedido_item);
		//calculo_LB
		$lbcoms = pedido_calcula_lb($nr_empresa,$nr_pedido);
		$pedido_item = 'Update pedido set '.
						' Valor_Total_Prod = "'.$valor_total_prod.'", '.
						' Valor_Total_Serv = "'.$valor_total_serv.'", '.
						' Valor_Sub_Total = "'.$sub_total.'", '.
						' Valor_Desconto = "'.$total_desconto.'", '.
						' Valor_Imposto = "'.$total_imposto.'", '.
						' Perc_LB = "'.$lbcoms.'", '.
						' Valor_Acrescimo = 0, '.
						' Valor_Frete = "'.$frete.'", '.
						' Valor_Outros = "'.$outros.'", '.
						//                       ' Forma_Pagto = 1, '.
						' Valor_Total_Liquido = "'.$total_liq.'" '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$nr_empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($pedido_item);
		pedido_recalculo_parcelas($nr_empresa,$nr_pedido);
		//consulta parcelas, se tiver, faz recalculo com base no que ja estava (data vencto e parcelas)
		/*
		$parcelas = 'delete from pedido_parcela '.
		' where Dominio = "'.$_SESSION['Dominio'].'"'.
		' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
		' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($parcelas);
		*/
	}


	/** 
	 * Funo para Cancelar pedidos, funo que estava em telas separadas,  agrupada para haver apenas uma funo sendo chamado em telas diferentes  ( neste momento: ao cancelar e ao clonar)
	 * @param string $empresa 
	 * @param string $num_pedido
	 * @param string $motivo
	 * @return boolean  true ou false
	 * @author Maurcio Moller <mauricio@freeline.inf.br>
	 * @author Isabel Boaventura <isabel@freeline.inf.br>
	 * @version 15.12.00 
	 * Data criao: 31/08/2023
	 */
	function pedido_cancela( $empresa, $nr_pedido, $motivo ){		
		
		$cons_item ='select OS_Empresa, OS_Nr from pedido_item '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$empresa.'"'.
					' and Numero_Pedido="'.$nr_pedido.'" '.
					' and OS_Nr>0 group by OS_Empresa,OS_Nr';
		$res_item = consulta_sql($cons_item);
		$nrw_item = consulta_num_registros($res_item);
		for($pi=0;$pi<$nrw_item;$pi++){
			$reg_item = consulta_ler_objeto($res_item);
			
			$con_volta = 'Update ordem_servico_item set'.
						' Status = "A" '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and Empresa = "'.$reg_item->OS_Empresa.'" '.
						' and Nr_OrdemServico = "'.$reg_item->OS_Nr.'"'.
						' and Status="F"';
			$res_volta = consulta_sql($con_volta,true,1);
			if ($res_volta>0){
				$con_volta = 'Update ordem_servico set'.
							' Status = "A" '.
							' where Dominio = "'.$_SESSION['Dominio'].'" '.
							' and Empresa = "'.$reg_item->OS_Empresa.'" '.
							' and Nr_OrdemServico = "'.$reg_item->OS_Nr.'"';
				$res_volta = consulta_sql($con_volta,true,1);
			} 
		}
		consulta_limpa($res_item);
		
		//remove todos os itens em aberto e fecha todos que foram atendidos parcialmente
		$con_del = 'Update produto_saldo_filial_lote_reser '.
				 ' set Situacao="E" '.
				 ' where Dominio="'.$_SESSION["Dominio"].'" '.
				 ' and Pedido_Empresa="'.$empresa.'"'.
				 ' and Pedido_Nr="'.$nr_pedido.'" '.
				 ' and Situacao="A"';
		consulta_sql($con_del);

		$con_del = 'Update produto_saldo_filial_lote_reser '.
				 ' set Qtd_Reserva=Qtd_Atendida, '.
				 ' Situacao="F" '.
				 ' where Dominio="'.$_SESSION["Dominio"].'" '.
				 ' and Pedido_Empresa="'.$empresa.'"'.
				 ' and Pedido_Nr="'.$nr_pedido.'" '.
				 ' and Situacao="P"';
		consulta_sql($con_del);
		pedido_compra_deleta_saldo_vendido(($nr_pedido*(-1)), $empresa );

		$novo_status = 'C';

		$con_item = 'select * from pedido_item '.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$empresa.'"'.
					' and Numero_Pedido="'.$nr_pedido.'" '.
					' and Status<>"C" and Status<>"E"';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($pi=0;$pi<$nrw_item;$pi++){
			$reg_item = consulta_ler_objeto($res_item);

			if ($reg_item->Qtd_Atendida>0){
				$saldo = arredonda_numero_menos(($reg_item->Qtd - $reg_item->Qtd_Atendida)*1000)/1000;
				$muda_qtd = '';
				if ($saldo>=0.001){
					$con_seq = 'select max(Seq_Item) from pedido_item '.
								' where Dominio ="'.$_SESSION['Dominio'].'"'.
								' and Empresa="'.$empresa.'"'.
								' and Numero_Pedido="'.$nr_pedido.'" ';
					$res_seq = consulta_sql($con_seq);
					$reg_seq = consulta_ler_linha($res_seq);
					consulta_limpa($res_seq);
					$seq_n = $reg_seq[0] + 1;
					$con_ins = 'Insert into pedido_item '.
								'(Dominio, '.
								' Empresa, '.
								' Numero_Pedido, '.
								' Seq_Item, '.
								' ID_Produto, '.
								' Barra_Produto ) '.
								' values ( '.
								' "'.$_SESSION["Dominio"].'", '.
								' "'.$empresa.'",'.
								' "'.$nr_pedido.'",'.
								' "'.$seq_n.'",'.
								' "'.$reg_item->ID_Produto.'", '.
								' "'.$reg_item->Barra_Produto.'")';
					consulta_sql($con_ins);
					$perc_base = $saldo/$reg_item->Qtd;
					$del_cad = 'Update pedido_item set '.
								' Qtd = "'.$saldo.'", '.
								' Valor_Unitario = "'.$reg_item->Valor_Unitario.'", '.
								' Valor_Desconto = "'.($reg_item->Valor_Desconto*($perc_base)).'", '.
								' Valor_Acrescimo = "'.($reg_item->Valor_Acrescimo*($perc_base)).'", '.
								' Valor_Total = ((Qtd * Valor_Unitario) - Valor_Desconto), '.
								' Perc_Imposto = "'.$reg_item->Perc_Imposto.'", '.
								' Valor_Imposto = ((Perc_Imposto * Valor_Total)/100), '.
								' Qtd_Peca = "'.($reg_item->Qtd_Peca*($perc_base)).'", '.
								//' Altura = "'.($reg_item->Altura*($perc_base)).'", '.
								//' Largura = "'.($reg_item->Largura*($perc_base)).'", '.
								' Id_Peca = "'.$reg_item->Largura.'", '.
								' DT_PrazoEntrega = "'.$reg_item->DT_PrazoEntrega.'", '.
								' Status = "C", '.
								' Obs = "'.$reg_item->Obs.'", '.
								' Cultura = "'.$reg_item->Cultura.'", '.
								' Aplicacao = "'.$reg_item->Aplicacao.'", '.
								' Seq_Pedido_Cliente = "'.$reg_item->Seq_Pedido_Cliente.'", '.
								' Faturar = "'.$reg_item->Faturar.'", '.
								' NrLote = "'.$reg_item->NrLote.'", '.
								' Peneira = "'.$reg_item->Peneira.'", '.
								' DT_Fabricacao = "'.$reg_item->DT_Fabricacao.'", '.
								' DT_Validade = "'.$reg_item->DT_Validade.'", '.
								' Germinacao = "'.$reg_item->Germinacao.'", '.
								' Pureza = "'.$reg_item->Pureza.'", '.
								' Nr_Serie = "'.$reg_item->Nr_Serie.'", '.
								' NrCompra = "'.$reg_item->NrCompra.'", '.
								' EmpresaCompra = "'.$reg_item->EmpresaCompra.'", '.
								' Nr_Atestado = "'.$reg_item->Nr_Atestado.'" '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido ="'.$nr_pedido.'"'.
								' and Seq_Item ="'.$seq_n.'"';
					$res_pessoa = consulta_sql($del_cad,true,1);

					$cons_pedido_itemn = 'Select * from pedido_item '.
										 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
										 ' and Empresa = "'.$empresa.'"'.
										 ' and Numero_Pedido = "'.$nr_pedido.'"'.
										 ' and Seq_Item = "'.$seq_n.'"';
					$res_pedido_itemn = consulta_sql($cons_pedido_itemn);
					$reg_pedido_itemn = consulta_ler_objeto($res_pedido_itemn);
					consulta_limpa($res_pedido_itemn);

					$del_cad = 'Update pedido_item set '.
								' Qtd = Qtd - '.$reg_pedido_itemn->Qtd.', '.
								' Qtd_Peca = Qtd_Peca - '.($reg_pedido_itemn->Qtd_Peca).', '.
								//' Qtd_Liberada = Qtd, '.
								' Valor_Desconto = Valor_Desconto - '.$reg_pedido_itemn->Valor_Desconto.', '.
								' Valor_Acrescimo = Valor_Acrescimo - '.$reg_pedido_itemn->Valor_Acrescimo.', '.
								' Valor_Total = Valor_Total - '.$reg_pedido_itemn->Valor_Total.' , '.
								' Valor_Imposto = Valor_Imposto - '.$reg_pedido_itemn->Valor_Imposto.' '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido ="'.$nr_pedido.'"'.
								' and Seq_Item ="'.$reg_item->Seq_Item.'"';
					$res_pessoa = consulta_sql($del_cad,true,1);

					/**Quando Quantidade_Atendida>0 e TEM pedido de Compra  Edita a quantidade */
					if(  $reg_item->SeqCompra>0 ){
						$modPedCompra = 'Update pedido_compra_item '.
										' SET Qtd ="'.$saldo.'"'.
										' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
										' AND Empresa="'.$reg_item->EmpresaCompra.'"'.
										' AND Numero_Pedido="'.$reg_item->NrCompra.'" '.
										' AND Seq_Item="'.$reg_item->SeqCompra.'" '.
										' AND Status<>"F"'.
										' AND Status<>"E"'.
										' AND Status<>"C"';
						consulta_sql($modPedCompra);
						pedido_compra_recalculo( $reg_item->NrCompra);

					}

				}
				//separa em novo item o saldo (com item cancelado)
				//fecha item original
				$novo_status = 'F';	

				$consulta = 'Update pedido_item '.
							' set Status="F"'.
							$muda_qtd.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$empresa.'"'.
							' and Numero_Pedido="'.$nr_pedido.'" '.
							' and Seq_Item="'.$reg_item->Seq_Item.'" '.
							' and Status<>"F"'.
							' and Status<>"C"';
				consulta_sql($consulta);	
			}else{
				//cancela item
				$consulta = 'Update pedido_item '.
							' set Status="C"'.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$empresa.'"'.
							' and Numero_Pedido="'.$nr_pedido.'" '.
							' and Seq_Item="'.$reg_item->Seq_Item.'" '.
							' and Status<>"F"'.
							' and Status<>"E"'.
							' and Status<>"C"';
				consulta_sql($consulta);
			}		  
		}
		consulta_limpa($res_item);

			
		if ($novo_status == 'F'){
			pedido_calcula_status($nr_pedido,  $empresa );
		}

		$consulta = 'Update pedido '.
				  ' set Status="'.$novo_status.'", '.
				  ' Integrado="N", '.
				  ' IntegradoUP="N", '.
				  ' Integrado_Demander="T", '.
				  ' DH_Cancela = now(), '.
				  ' Usuario_Cancela = "'.base64_decode_si($_REQUEST['USER_ID']).'", '.
				  ' Obs_Cancel = "'.UpperDados($motivo).'" '.
				  ' where Dominio ="'.$_SESSION['Dominio'].'"'.
				  ' and Empresa="'.$empresa.'"'.
				  ' and Numero_Pedido="'.$nr_pedido.'" ';
		consulta_sql($consulta);

		return true ;

	}

	function pedido_recalculo_parcelas($empresa,$nr_pedido){
		$con_pedido = 'select * from pedido '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		consulta_limpa($res_pedido);
		$valor_total = $reg_pedido->Valor_Total_Liquido;
		$con_parc = 'select Parcela, DT_Vencimento, Valor_Parcela from pedido_parcela '.
					' where Dominio ="'.$_SESSION['Dominio'].'" '.
					' and Empresa="'.$empresa.'"'.
					' and Numero_Pedido="'.$nr_pedido.'"';
		$res_parc = consulta_sql($con_parc);
		$nro_parc = consulta_num_registros($res_parc);
		if ($nro_parc>0){
			$valor_parcela = $valor_total/$nro_parc;
			$valor_parcela = $valor_parcela  * 100;
			$ve = explode(".", $valor_parcela.'.');
			$valor_parcela = $ve[0]/100;
			for($p=0;$p<$nro_parc;$p++){
				$reg_parc = consulta_ler_linha($res_parc);
				$valor_total-= $valor_parcela;
				$upt_parc = 'Update pedido_parcela '.
							' set Valor_Parcela="'.$valor_parcela.'"'.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$empresa.'"'.
							' and Numero_Pedido="'.$nr_pedido.'" '.
							' and Parcela = '.$reg_parc[0];
				consulta_sql($upt_parc);
			}
		}
		consulta_limpa($res_parc);
		$upt_pacela = 'Update pedido_parcela set '.
					' Valor_Parcela = Valor_Parcela + '.$valor_total.
					' where Dominio ="'.$_SESSION['Dominio'].'"'.
					' and Empresa="'.$empresa.'"'.
					' and Numero_Pedido="'.$nr_pedido.'" '.
					' and Parcela = "1" ';
		consulta_sql($upt_pacela);
	}

	function pedido_calcula_lb($empresa,$nr_pedido){
		//119 para teste
		$zathura = Zathura();
		$con_pedido = 'select * from pedido '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		consulta_limpa($res_pedido);
		$valor_total_prod = 0;
		$valor_total_serv = 0;
		$custo_total = 0;
		$cons_pedido_item = 'Select Id_Produto, Valor_Total, Valor_Desconto, Valor_Imposto,Preco_Custo,Qtd,SeqCompra from pedido_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"'.
							' and Status <> "E"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$nrowarr_pedido_item = consulta_num_registros($res_pedido_item);
		$total_desconto = 0;
		$total_imposto = 0;
		for($k=0;$k<$nrowarr_pedido_item;$k++){
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			$valor_total_prod+= $reg_pedido_item[1]+$reg_pedido_item[2];
			$total_desconto+= $reg_pedido_item[2];
			$total_imposto+= $reg_pedido_item[3];
			//echo '
			//Id_Produto: '.$reg_pedido_item[0].'-C'.$reg_pedido_item[4].'-Q'.$reg_pedido_item[5].'<BR>
			//';
			$custo_item = $reg_pedido_item[4] * $reg_pedido_item[5];
			if ($reg_pedido_item[6]==0){
				$custo_item = $custo_item+($custo_item*BuscaParam('CUSTO_AD_PAD')/100);
			}
			$custo_total+= $custo_item;
		}
		$sub_total = ($valor_total_prod+$valor_total_serv);
		$total_liq = $sub_total-$total_desconto;
		consulta_limpa($res_pedido_item);
		//echo '$custo_total-'.$custo_total;
		//valor c3
		$total_c3 = ($total_liq * $reg_pedido->C3_Perc/100);
		if( $zathura ){
			$totdesc = ($reg_pedido->Outros_Custos ) + ($total_c3 );
		}else{
			$totdesc = ($reg_pedido->Outros_Custos * 1.40) + ($total_c3 * 1.40);
		}
		//$totdesc = ($reg_pedido->Outros_Custos * 1.40) + ($total_c3 * 1.40);
		//echo '$totdesc-'.$totdesc;
		//echo '$total_liq-'.$total_liq;
		//totdesc = (moutros * 1.40) + ((c3comp/100) * 1.40 * totalped) + desconto
		//lbcoms = 100 * (((venda - totdesc) / custo) - 1)
		//echo '$custo_totalA'.$custo_total.'-';
		//adicona o percentual de custo do estoque
		//$custo_total = $custo_total+($custo_total*BuscaParam('CUSTO_AD_PAD')/100);
		//echo '$custo_totalD'.$custo_total.'-';
		if ($custo_total>0){
						
			if( $zathura ){
				$lbcoms_v2 = (((($total_liq)) - ($custo_total + $totdesc))/($total_liq ) ) * 100 ;
				$lbcoms = ( ( ((($total_liq)) - ($custo_total + $totdesc))/($total_liq ) ) * 100 )* 0.93;
			}else{
				$lbcoms = (((($total_liq- $totdesc)*100)/($custo_total))-100);
			}
			
		}else{
			$lbcoms = 100;
		}
		//	echo '$lbcoms-'.$lbcoms;
		return round($lbcoms,2);
	}

	function pedido_calcula_lb_item($qtd_e, $valor_total_item,
									$casado, $valor_compra_dig,
									$valor_custo, $preco_compra){
		
		$custo_calc = $valor_custo;
		if ($casado){
			$custo_calc = $valor_compra_dig;
		}else{
			if( Zathura() ){
				if($preco_compra > $valor_custo ){
					$custo_calc = $preco_compra+($preco_compra*BuscaParam('CUSTO_AD_PAD')/100); 
				}else{
					$custo_calc = $valor_custo+($valor_custo*BuscaParam('CUSTO_AD_PAD')/100); 
				}
			}else{
				$custo_calc =  $valor_custo+($valor_custo*BuscaParam('CUSTO_AD_PAD')/100); //+3%
			}
		}

		if($custo_calc>0){
			if( Zathura() ){
				$lb_v2 = ((($valor_total_item ) - ($custo_calc*$qtd_e))/($valor_total_item ) ) * 100 ;
				$lb = ( ((($valor_total_item ) - ($custo_calc*$qtd_e))/($valor_total_item ) ) * 100 ) * 0.93 ;
			}else{
				$lb = ((($valor_total_item*100)/($custo_calc*$qtd_e))-100);
			}
			
			if(($lb < 0.0001) && ($lb > (-0.0001))){
				$lb = 0;
			}
		}else{
			$lb = 100;
		}
		$ret['custo'] = $custo_calc;
		$ret['lb'] = round($lb,2);
		return $ret;
	}

	function pedido_recalculo2($nr_pedido){
		$valor_total_prod = 0;
		$valor_total_serv = 0;
		$cons_pedido_item = 'Select Id_Produto, Valor_Total, Valor_Desconto, Valor_Imposto from pedido_padrao_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"'.
							' and Status <> "E"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$nrowarr_pedido_item = consulta_num_registros($res_pedido_item);
		$total_desconto = 0;
		$total_imposto = 0;
		for($k=0;$k<$nrowarr_pedido_item;$k++){
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			$cons_produto = 'Select Codigo_Depart from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_pedido_item[0].'"';
			$res_produto = consulta_sql($cons_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);
			if ($reg_produto[0] != 0){
				$valor_total_prod+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}else {
				$valor_total_serv+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}
			$total_desconto+= $reg_pedido_item[2];
			$total_imposto+= $reg_pedido_item[3];
		}
		$sub_total = ($valor_total_prod+$valor_total_serv);
		$total_liq = $sub_total-$total_desconto+$total_imposto;
		consulta_limpa($res_pedido_item);
		$pedido_item = 'Update pedido_padrao set '.
						' Valor_Total_Prod = "'.$valor_total_prod.'", '.
						' Valor_Total_Serv = "'.$valor_total_serv.'", '.
						' Valor_Sub_Total = "'.$sub_total.'", '.
						' Valor_Desconto = "'.$total_desconto.'", '.
						' Valor_Imposto = "'.$total_imposto.'", '.
						' Valor_Acrescimo = 0, '.
						' Valor_Frete = 0, '.
						' Valor_Outros = 0, '.
						' Forma_Pagto = 1, '.
						' Valor_Total_Liquido = "'.$total_liq.'" '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($pedido_item);
	}

	function pedido_item_calcula_status($nr_pedido, $seq, $empresa=0){
		if ($empresa==0){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$cons_pedido_item = 'Select Qtd, '.
							' Qtd_Atendida, '.
							' Qtd_Liberada, '.
							' Valor_Unitario, '.
							' Valor_Total '.
							' from pedido_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Seq_Item = "'.$seq.'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$reg_pedido_item = consulta_ler_linha($res_pedido_item);
		consulta_limpa($res_pedido_item);
		if (($reg_pedido_item[1]+$reg_pedido_item[2])==0){
			$status = 'A';
		}else if($reg_pedido_item[0]<=$reg_pedido_item[1]){
			$status = 'F';
		}else if($reg_pedido_item[2]<=$reg_pedido_item[1]){
			$status = 'P';
		}else {
			$status = 'L';
		}
		$atualiza_pedido_item = 'Update pedido_item set '.
								' Status = "'.$status.'" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido = "'.$nr_pedido.'"'.
								' and Seq_Item = "'.$seq.'"';
		consulta_sql($atualiza_pedido_item);
	}

	function pedido_calcula_status($nr_pedido, $empresa=0, $finalizado=false){
		$liberado = false;
		$aberto = false;
		$fechado = false;
		$parcial = false;
		$cancelado = false;
		$estoque = 'S';
		//if($lib_tipo=='F'){
		//  $estoque = 'N';
		//}
		$lib_tipo = BuscaParam('LIBERA_AUTOMAT_PEDID');
		if ($empresa==0){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$cons_pedido = 'Select Status, Estoque from pedido_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"'.
						' and Status <> "E"';
		$res_pedido = consulta_sql($cons_pedido);
		$nrwowarr_pedido = consulta_num_registros($res_pedido);
		for($kk=0;$kk<$nrwowarr_pedido;$kk++){
			$reg_pedido_item = consulta_ler_linha($res_pedido);
			if ($reg_pedido_item[0] == 'L'){
				$liberado = true;
				if ($lib_tipo=='F'){
					if ($reg_pedido_item[1]=='N'){
						$estoque = 'N';
					}
				}
			}
			if ($reg_pedido_item[0] == 'F'){
				$fechado = true;
				$tem_estoque_lib = true;
			}
			if ($reg_pedido_item[0] == 'A'){
				$aberto = true;
				if ($reg_pedido_item[1]=='N'){
					$estoque = 'N';
				}
			}
			if ($reg_pedido_item[0] == 'P'){
				$parcial = true;
				if ($lib_tipo=='F'){
					if ($reg_pedido_item[1]=='N'){
						$estoque = 'N';
					}
				}
			}
			if ($reg_pedido_item[0] == 'C'){
				//$cancelado = true;
				$parcial = true;
			}
		}
		consulta_limpa($res_pedido);
		if ($cancelado){
			$status = 'C';
		}else if($liberado){
			$status = 'L';
		}else if($parcial){
			$status = 'P';
		}else if(($aberto) && ($fechado)){
			$status = 'P';
		}else if($fechado){
			$status = 'F';
		}else {
			$status = 'A';
		}
		$atualiza_pedido_status = 'Update pedido set '.
									' Status = "'.$status.'", '.
									' Estoque = "'.$estoque.'" '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa = "'.$empresa.'"'.
									' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($atualiza_pedido_status);
		$con_pedido = 'select * from pedido '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		consulta_limpa($res_pedido);
		//$integradoUp = ' IntegradoUp = "N", Integrado_Demander = "N", ';
		$int_up = 'S';
		if ($finalizado){
			$int_up = 'N';
		}
		$integradoUp = ' IntegradoUp = "'.$int_up.'", Integrado_Demander = "N", ';
		if ($reg_pedido->Pessoa<100){
			$integradoUp = '';
		}
		if ($reg_pedido->Pessoa==$empresa){
			$integradoUp = '';
		}
		//if ($reg_pedido->Local_Fatura==0){
		//    $integradoUp = '';
		//}
		$atualiza_pedido_status = 'Update pedido set '.
								$integradoUp.
								' Integrado = "N" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($atualiza_pedido_status);
		pedido_gera_outros_custo($empresa,$nr_pedido);
		return $estoque;
	}


	/**A partir daqui teste oara a troca de fornecer  */

	/**
	 * Funo para inserir um Item em um Pedido de Compra j existente
	 * Descobre se o item j existe no Pedido de Compra 
	 * Se no exite: Adiciona como novo item
	 * Se j existe: atualiza o item
	 *
	 * @param int $empresa
	 * @param int $pedidoCompra
	 * @param int $id
	 * @param int $barra
	 * @param double $qtd
	 * @param double $custo
	 * @param int $pedidoVenda
	 * @param int $seqItemVenda
	 * @return void
	 */
	function inserir_itens_pedido_compra( $empresa, $pedidoCompra , $id, $barra, $qtd, $custo, $pedidoVenda, $seqItemVenda, $fornecedor   ){
		$atualiza_item = false ;

		//descobre se este item existe no Pedido de Compra 
		$sql_item = 'SELECT Seq_Item FROM pedido_compra_item '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'"'.
					' AND Numero_Pedido="'.$pedidoCompra.'"'.
					' AND ID_Produto="'.$id.'" '.
					' AND Barra_Produto="'.$barra.'"'.
					' AND Nr_Pedido_Venda ="'.$pedidoVenda.'"';
		$res_item = consulta_sql( $sql_item );
		$reg_item = consulta_ler_linha($res_item );
		consulta_limpa($res_item );

		if (($reg_item[0]== 0)||($reg_item[0]== NULL )||($reg_item[0]== '') ){
			//insere item no pedido de compra
			//consulta ultimo item do pedido
			$con_seq = 'SELECT MAX(Seq_Item) FROM pedido_compra_item '.
						' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
						' AND Empresa="'.$empresa.'"'.
						' AND Numero_Pedido="'.$pedidoCompra.'" ';
			$res_seq = consulta_sql($con_seq);
			$reg_seq = consulta_ler_linha($res_seq);
			consulta_limpa($res_seq);
			$seqItemCompra = $reg_seq[0] + 1;
			$atualiza_item = true; 

			$con_ins = 'INSERT INTO pedido_compra_item '.
					'(Dominio, '.
					' Empresa, '.
					' Numero_Pedido, '.
					' Seq_Item, '.
					' ID_Produto, '.
					' Barra_Produto ) VALUES ( '.
					'"'.$_SESSION["Dominio"].'",'.
					'"'.$empresa.'",'.
					'"'.$pedidoCompra.'",'.
					'"'.$seqItemCompra.'",'.
					'"'.$id.'",'.
					'"'.$barra.'" )';
			consulta_sql($con_ins);
		}else{
			$atualiza_item = true; 
			$seqItemCompra = $reg_item[0] ;
		}

		if( $atualiza_item ){

			atualiza_item_pedido_compra( $empresa, $pedidoCompra, $seqItemCompra, $id, $barra, $qtd, $custo, $pedidoVenda);
			//assossia o pedido de compra ao pedido de venda 
			atualiza_item_pedido_venda ($empresa, $pedidoVenda, $seqItemVenda, $id, $barra, $pedidoCompra, $seqItemCompra, $empresa, $fornecedor );
		}

	}

	
	/**
	 * Funo para troca de Fornecedor quando forem os Mesmos itens apenas forencedores Diferentes 
	 *
	 * @param int  $empresa
	 * @param int $pedidoCompra
	 * @param int $fornecedorNovo
	 * @param int $fornecedorAnterior
	 * @return void
	 */
	function troca_fornecedor ($empresa, $pedidoCompra, $fornecedorNovo, $fornecedorAnterior  ){
		//Esta funo  para quando todos os itens de um PEDIDO de VENDA  vo direto para um nido PEDIDO de COMPRA 
		
		$muda = 'UPDATE pedido_compra '.  
				' SET Pessoa="'.$fornecedorNovo.'" '. 
				' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
				' AND Empresa  = "'.$empresa.'" '.
				' AND Numero_Pedido = "'.$pedidoCompra.'" '.
				' AND Pessoa="'.$fornecedorAnterior .'"';
		consulta_sql( $muda );

	}

	/**
	 * Busca quais Pedidos deste Fornecedor existente e esto com o Status Diferente de Fechado 
	 *
	 * @param int $empresa
	 * @param int $fornecedor
	 * @return array $resp (informaes de resposta) id
	 */
	function busca_pedido_compra_fornecedor ( $empresa ,  $fornecedor ){
		//descobrir quais os pedidos que estao diferente de Fechado para este fornecdor 

		$resp = array();
		$consulta_fornecedor = 'SELECT Numero_Pedido, Empresa, Pessoa , Status  FROM pedido_compra  '.
							' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
							' AND Empresa="'.$empresa.'"'.
							' AND Pessoa="'.$fornecedor.'"'.
							' AND  Status<>"F"'. 
							' ORDER BY Numero_Pedido ASC LIMIT 1';
		$res_forn = consulta_sql( $consulta_fornecedor );
		$reg_forn = consulta_ler_objeto($res_forn);
		$num_reg  = consulta_num_registros( $res_forn );
		if( $num_reg>0){
			$resp['resp'] = 'OK';
			$resp['PC'] = $reg_forn->Numero_Pedido;
			$resp['E'] = $reg_forn->Empresa ;
			$resp['F'] = $reg_forn->Pessoa;
			$resp['S'] = $reg_forn->Status ;
		}else{
			$resp['resp'] = 'ERROR';
		}
		consulta_limpa(  $res_forn );

		return $resp;

	}

	/**
	 * A partir de um Pedido de Compra, descobre se tem este item cadastrado nele 
	 *
	 * @param int $empresa
	 * @param int $pedidoCompra
	 * @param int $id
	 * @param int $barra
	 * @param int $pedidoVenda
	 * @return array $resp (informaes de resposta)
	 */
	function verifica_item_pedido_compra( $empresa, $pedidoCompra, $id, $barra, $pedidoVenda  ){
		$resp = array();

		//descobrir se neste pedido de compra EXISTE este item 
		$cons_item='SELECT Numero_Pedido, Empresa, Seq_Item FROM pedido_compra_item  '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'"'.
					' AND Numero_Pedido="'.$pedidoCompra.'"'.
					' AND ID_Produto="'.$id.'" '.
					' AND Barra_Produto="'.$barra.'" '.
					//' AND Nr_Pedido_Venda="'.$pedidoVenda.'"'.
					'  AND Status<>"F"'. //AND Status<>"C"
					' ';
		$res_item = consulta_sql( $cons_item );
		$reg_item = consulta_ler_objeto($res_item);
		$num_item = consulta_num_registros($res_item );
		if($num_item>0){
			$resp['resp'] = 'OK';
			$resp['PC'] = $reg_item->Numero_Pedido;
			$resp['EC'] = $reg_item->Empresa;
			$resp['SC'] = $reg_item->Seq_Item;
		}else{
			$resp['resp'] = 'ERROR';
		}
		consulta_limpa($res_item);

		return $resp;

	}

	/**
	 * Funo que ir atualizar o item no Pedido de VENDA com as informaes do Pedido de COMPRA 
	 *
	 * @param int $empresa
	 * @param int $pedidoVenda
	 * @param int $id
	 * @param int $barra
	 * @param int $pedidoCompra
	 * @param int $seqCompra
	 * @param int $empresaCompra
	 * @param int $fornecedor
	 * @return void
	 */
	function atualiza_item_pedido_venda ($empresa, $pedidoVenda, $seqItemVenda,  $id, $barra, $pedidoCompra, $seqCompra, $empresaCompra, $fornecedor ){
		( $empresaCompra == '' ) ? $empresaCompra = 1 : $empresaCompra =$empresaCompra ; 
		( $seqCompra == '' ) ? $seqCompra = -1 : $seqCompra = $seqCompra;
		$del_cad='UPDATE pedido_item SET '.
				' FornecCompra="'.$fornecedor.'", '.
				' EmpresaCompra="'.$empresaCompra.'", '.
				' NrCompra="'.$pedidoCompra.'", '.
				' SeqCompra="'.$seqCompra.'" '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Numero_Pedido ="'.$pedidoVenda.'"';
		if( $seqItemVenda != '' ){
			$del_cad .= ' AND SeqItem ="'.$seqItemVenda .'" ';
		}
		$del_cad.=' AND ID_Produto="'.$id .'"'. 
				' AND Barra_Produto="'.$barra.'" ';
		consulta_sql($del_cad,true,1);
	}

	/**
	 * Funo para atualizar o Pedido de Compra 
	 *
	 * @param int $empresa
	 * @param int $pedidoCompra
	 * @param int $seq
	 * @param double $qtd
	 * @param double $custo
	 * @param int $pedidoVenda
	 */
	function atualiza_item_pedido_compra( $empresa, $pedidoCompra, $seq, $id, $qtd, $custo, $pedidoVenda){

		$con_produto = 'SELECT Unidade_Fator, Unidade_Compra, Unidade_Venda FROM produto '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$id.'"';
		$res_produto = consulta_sql($con_produto);
		$reg_produto = consulta_ler_objeto($res_produto);
		consulta_limpa($res_produto);
		$unidade = $reg_produto->Unidade_Venda;
				
		$fator = $reg_produto->Unidade_Fator;
		if ($fator==0){
				$fator = 1;
		}
		if ($reg_produto->Unidade_Compra<>''){
				$unidade = $reg_produto->Unidade_Compra;
		}

		$del_cad = 'UPDATE pedido_compra_item SET '.
				' Qtd_Compra = "'.$qtd.'", '.
				' Qtd = "'.$qtd.'", '.
				' Qtd_Liberada = "'.$qtd.'", '.
				' Unidade_Compra = "'.$unidade.'", '.
				' Unidade_Fator = "1", '.
				' Unidade_Operacao = "M", '.
				' Valor_Unitario="'.$custo.'", '.
				' Valor_Unitario_Compra = "'.$custo.'", '.
				' Valor_Total = (Qtd * Valor_Unitario), '.
				' Status = "A" '.
				//' Nr_Pedido_Venda="'.$pedidoVenda.'" '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Numero_Pedido ="'.$pedidoCompra.'"'.
				' AND Seq_Item ="'.$seq.'"';
		$res_pessoa = consulta_sql($del_cad,true,1);
		if($res_pessoa > 0 ){
			pedido_compra_recalculo($pedidoCompra);
		}
		if( $res_pessoa >0){
			pedido_compra_recalculo( $pedidoCompra );
		}
	}


	function ativa_pedido_compra($empresa, $pedidoCompra ){
		$ativa ='UPDATE pedido_compra '.
				' SET Status = "A" '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Numero_Pedido ="'.$pedidoCompra.'"'.
				' AND (Status = "E" OR Status = "C")'.
				'';
		$ok = (consulta_sql( $ativa ,true,1) > 0 );
		if( $ok ){
			return $pedidoCompra;
		}
	}

	

	/** Aqui faz o cancelamento do Item no Pedido de compra,  para gerar um novo Pedido Compra para outro fornecedor  */
	/***
	 * Funo para cancelar o Item do Pedido de Compra 
	 * @param  int  $name
	 * @return bolean true | false
	*/
	function cancela_item_pedido_compra($empresa, $pedidoCompra, $seqCompra ){

		$agora = date('d/m/Y h:i:s'); 
		$usuario = base64_decode_si($_REQUEST['USER_ID']);
		//deleta o item do Pedido Original
		$del_item ='UPDATE pedido_compra_item '.
				' SET Status = "C", '.
				' Obs="Cancelamento de Item - Mudana de Fornecedor no Pedido de Venda em '.$agora.' por '.$usuario.'" '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Numero_Pedido ="'.$pedidoCompra.'"'.
				' AND Seq_Item ="'.$seqCompra.'"'.
			//	' AND ID_Produto="'.$id.'"'.
			//	' AND Barra_Produto="'.$barra.'"'.
				'';

		$ok = (consulta_sql($del_item,true,1) > 0 );
		pedido_compra_recalculo( $pedidoCompra );
	}

	function cancela_pedido_compra( $empresa, $pedidoCompra ){
		$agora = date('d/m/Y h:i:s'); 
		$usuario = base64_decode_si($_REQUEST['USER_ID']);
		//deleta o item do Pedido Original
		$del_item ='UPDATE pedido_compra '.
				' SET Status = "C", '.
				' DH_Cancela=  "'.$agora.'" , '.
				' Usuario_Cancela= "'.$usuario.'", '.
				' Observacao=  CONCAT( Observacao, " " ,"Cancelamento de Item - Mudana de Fornecedor no Pedido de Venda." ) '.
				' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
				' AND Empresa = "'.$empresa.'"'.
				' AND Numero_Pedido ="'.$pedidoCompra.'"';

		consulta_sql($del_item) ;
		

	}


	/**
	 * Se o Item CASADO do Pedido de Venda foi Cancelado, Cancelar tambm o Item do Pedido de Compra
	 *
	 * @param int $empresa
	 * @param int $pedidoVenda
	 * @param int $seqVenda
	 * @return void
	 */
	function cancela_item_pedido_venda_compra( $empresa, $pedidoVenda, $seqVenda ){
		/**Verifica no pedido de Venda se o item foi cancelado, verifica o item correspondente no Pedido de Compra  */

		$agora = date('d/m/Y h:i:s'); 
		$usuario = base64_decode_si($_REQUEST['USER_ID']);

		$con_item = 'SELECT * FROM pedido_item '.
					' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'"'.
					' AND Numero_Pedido="'.$pedidoVenda.'" '.
					' AND Seq_Item ="'.$seqVenda.'"';
		$res_item = consulta_sql($con_item);
		$reg_item = consulta_ler_objeto($res_item);
		consulta_limpa($res_item);
		if( ($reg_item->NrCompra>0) && ($reg_item->SeqCompra>0) && (($reg_item->Status=="C")||($reg_item->Status=="E")) ){
			$con_volta ='UPDATE pedido_compra_item SET '.
						' Status = "E", '.
						' Obs="Cancelamento do Item no Pedido de Venda Num. '.$reg_item->Numero_Pedido.' em '.$agora.' por  '.$usuario.' "'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Empresa = "'.$reg_item->EmpresaCompra.'" '.
						' AND Numero_Pedido  = "'.$reg_item->NrCompra.'"'.
						' AND Seq_Item ="'.$reg_item->SeqCompra.'"';
			$res_volta = consulta_sql($con_volta,true,1);
			pedido_compra_recalculo( $reg_item->NrCompra );
		}

		return $res_volta;
	}

	/**
	 * Reinicia as informaes de Pedido de Compra, EmpresaCompra e SeqCompra no Pedido de Venda
	 *
	 * @param int $empresa
	 * @param int $pedidoVenda
	 * @param int $seq
	 * @return void
	 */
	function reinicia_item_pedido_venda( $empresa,  $pedidoVenda, $seq ){
		$updt_item ='UPDATE pedido_item SET'.
					' EmpresaCompra = 0 , '.
					' NrCompra=0, '. 
					' SeqCompra= -1 '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Numero_Pedido ="'.$pedidoVenda.'"'.
					' AND Seq_Item ="'.$seq.'"';
		$ok = (consulta_sql($updt_item,true,1) > 0 );

	}


	/**
	 * Verifica quantos itens no Pedido de Venda est para o mesmo fornecedor,  alm do Item selecionado
	 *
	 * @param int $empresa
	 * @param int $pedidoCompra
	 * @param int $id
	 * @param int $barra
	 * @param int $pedidoVenda
	 * @return int Quantidade [0 ou mais]
	 * @author Mauricio <mauricio@freeline.inf.br>
	 */
	function pedido_conta_itens_compra($empresa,$pedidoCompra, $id, $barra, $pedidoVenda ){
		//verificar quantos itens tem no pedido de comrpa 
        $con_itens = 'SELECT count(*) as NrPedidos from pedido_compra_item '.
                     ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                     ' AND Empresa="'.$empresa.'"'.
                     ' AND Numero_Pedido="'.$pedidoCompra.'"'.
                     ' AND ID_Produto<>"'.$id.'"'.
					// ' AND Barra_Produto<>"'.$barra.'"'.
                    // ' AND Nr_Pedido_Venda<>"'.$pedidoVenda.'"'.
                     ' AND Status<>"E" AND Status<>"C" AND Status<>"F" ';
        $res_itens = consulta_sql($con_itens);
        $reg_itens = consulta_ler_objeto($res_itens);
        consulta_limpa($res_itens);
        return $reg_itens->NrPedidos;
    }


	/**Ate aqui troca para novo fornecedor  */

	function pedido_libera_gera_compra($empresa,$pedido){
		if ($empresa==0){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$lista_pedidos_gerados = '';
		$nr_vendedor = 0;
		$con_ped = 'Select Vendedor from pedido '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Numero_Pedido = "'.$pedido.'"';
		$res_ped = consulta_sql($con_ped);
		$reg_ped = consulta_ler_linha($res_ped);
		consulta_limpa($res_ped);
		$nr_vendedor = $reg_ped[0];
		$status_ped = 'B';
		$qtd_liberar = ', Qtd_Liberada = 0 ';
		if (BuscaParam('LIB_AUTO_PED_COMPRA')=='S'){
			$status_ped = 'A';
			$qtd_liberar = ', Qtd_Liberada = Qtd ';
		}
		$con_pedi = 'Select * from pedido_item '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Numero_Pedido = "'.$pedido.'"';
		/** Adicionada o Dominio 83 em 03/02/2021 por @isabel*/
		if( Zathura()   || ($_SESSION['Dominio'] == '83')){
			$con_pedi .= ' AND ( Status <> "E" AND Status <> "C" ) ';
		}else{
			$con_pedi .= ' and Status = "L" ';
		}
		$con_pedi.= ' and SeqCompra<>0 '.
					' and FornecCompra>0 '.
					' order by NrCompra desc, Seq_Item';
		$res_pedi = consulta_sql($con_pedi);
		$nrw_pedi = consulta_num_registros($res_pedi);
		$lped_compra = array();
		for($k=0;$k<$nrw_pedi;$k++){
			$reg_pedi = consulta_ler_objeto($res_pedi);
			$coloca_ped = true;
			if ($reg_pedi->NrCompra>0){
				//echo $k.'j passou';
				if (isset($lped_compra[$reg_pedi->FornecCompra])){
					$coloca_ped = false;
				}
				$lped_compra[$reg_pedi->FornecCompra] = $reg_pedi->NrCompra;
				$ped_compra = $reg_pedi->NrCompra;
			}else{
				if (!(isset($lped_compra[$reg_pedi->FornecCompra]))){
					//cria o pedido de compra
					$con_pedidc = 'select max(Numero_Pedido) from pedido_compra '.
									' where Dominio="'.$_SESSION["Dominio"].'"'.
									' and Empresa="'.$empresa.'"';
					$res_pedidc = consulta_sql($con_pedidc);
					$reg_pedidc = consulta_ler_linha($res_pedidc);
					consulta_limpa($res_pedidc);
					$ped_compra = $reg_pedidc[0];
					$ok = false;
					while (!($ok)){
						$ped_compra++;
						$cons_insere = 'Insert into pedido_compra '.
										'(Dominio, Empresa, Numero_Pedido,  '.
										' DH_Emissao, Pessoa, Vendedor, '.
										' Forma_Pagto, Status, Usuario_Criacao, Tipo_Pedido) '.
										' values ('.
										' "'.$_SESSION["Dominio"].'", '.
										' "'.$empresa.'", '.
										' "'.$ped_compra.'", '.
										' now(), '.
										' "'.$reg_pedi->FornecCompra.'", '.
										' "'.$nr_vendedor.'", '.
										' 1, "E", "'.base64_decode_si($_REQUEST['USER_ID']).'",'.
										'"1"'.
										') ';
						$ok = (consulta_sql($cons_insere,true,1) > 0 );
					}
					$atualiza_pedido = 'Update pedido_compra set '.
										' Observacao="VENDA CASADA ORAMENTO '.$pedido.'", '.
										' Status = "'.$status_ped.'"'.
										' where Dominio = "'.$_SESSION['Dominio'].'"'.
										' and Empresa = "'.$empresa.'"'.
										' and Numero_Pedido = "'.$ped_compra.'"';
					consulta_sql($atualiza_pedido);
					$lped_compra[$reg_pedi->FornecCompra] = $ped_compra;
				}else{//se esse fornecedor j gerou outro pedido de compra
					//s precisa incluir esse item no peeido j existente
					$ped_compra = $lped_compra[$reg_pedi->FornecCompra];
					$coloca_ped = false;
				}
				//insere item no pedido de compra
				//consulta ultimo item do pedido
				$con_seq = 'select max(Seq_Item) from pedido_compra_item '.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$empresa.'"'.
							' and Numero_Pedido="'.$ped_compra.'" ';
				$res_seq = consulta_sql($con_seq);
				$reg_seq = consulta_ler_linha($res_seq);
				consulta_limpa($res_seq);
				$seq = $reg_seq[0] + 1;
				$con_ins = 'Insert into pedido_compra_item '.
							'(Dominio, '.
							' Empresa, '.
							' Numero_Pedido, '.
							' Seq_Item, '.
							' ID_Produto, '.
							' Barra_Produto ) '.
							' values ( '.
							'"'.$_SESSION["Dominio"].'",'.
							'"'.$empresa.'",'.
							'"'.$ped_compra.'",'.
							'"'.$seq.'",'.
							'"'.$reg_pedi->ID_Produto.'", '.
							'"'.$reg_pedi->Barra_Produto.'")';
				consulta_sql($con_ins);
				$con_produto = 'select * from produto '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto = "'.$reg_pedi->ID_Produto.'"';
				$res_produto = consulta_sql($con_produto);
				$reg_produto = consulta_ler_objeto($res_produto);
				consulta_limpa($res_produto);
				$unidade = $reg_produto->Unidade_Venda;
				
				// $fator = $reg_produto->Unidade_Fator;
				// if ($fator==0){
				// $fator = 1;
				// }
				// if ($reg_produto->Unidade_Compra<>''){
				// $unidade = $reg_produto->Unidade_Compra;
				// }
				
				$del_cad = 'Update pedido_compra_item set '.
							' Qtd_Compra = "'.$reg_pedi->Qtd.'", '.
							' Qtd = "'.$reg_pedi->Qtd.'", '.
							' Qtd_Liberada = "'.$reg_pedi->Qtd.'", '.
							' Unidade_Compra = "'.$unidade.'", '.
							' Unidade_Fator = "1", '.
							' Unidade_Operacao = "M", '.
							' Valor_Unitario="'.$reg_pedi->Preco_Custo.'", '.
							' Valor_Unitario_Compra = "'.$reg_pedi->Preco_Custo.'", '.
							' Valor_Total = (Qtd * Valor_Unitario), '.
							' Status = "A", '.
							' Obs = "'.$reg_pedi->Obs.'" '.
							//' Nr_Pedido_Venda = "'.$pedido.'" '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Numero_Pedido ="'.$ped_compra.'"'.
							' and Seq_Item ="'.$seq.'"';
				$res_pessoa = consulta_sql($del_cad,true,1);

				
				if($res_pessoa > 0 ){
					pedido_compra_recalculo($ped_compra);
				}
				//assossia o pedido de compra ao pedido de venda
				$del_cad = 'Update pedido_item set '.
							' EmpresaCompra="'.$empresa.'", '.
							' NrCompra="'.$ped_compra.'", '.
							' SeqCompra="'.$seq.'" '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Numero_Pedido ="'.$pedido.'"'.
							' and Seq_Item ="'.$reg_pedi->Seq_Item.'"';
				consulta_sql($del_cad);
			}//fim ainda no tinha pedido de compra associado;
			if ($coloca_ped){
				if ($lista_pedidos_gerados!= ''){
					$lista_pedidos_gerados.=',';
				}
				$lista_pedidos_gerados.=$ped_compra;
			}
		}//fim looping itens
		consulta_limpa($res_pedi);
		return $lista_pedidos_gerados;
	}

	/**Funo do Mauricio para verificar se tem alem do item mais algum deste mesmo fornecedor  */

	function pedido_conta_compra_fornecedor($empresa,$nr_pedido,$seq_item,$fornec){

		//echo ' <br> linha 3319 '.
        $con_itens = 'SELECT count(*) as NrPedidos from pedido_item '.
                     ' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
                     ' AND Empresa="'.$empresa.'"'.
                     ' AND Numero_Pedido="'.$nr_pedido.'"'.
                     ' AND Seq_Item<>"'.$seq_item.'"'.
                     ' AND FornecCompra="'.$fornec.'"'.
                    // ' AND FornecCompra>0'.
                    // ' AND SeqCompra>0'.
                     ' AND Status<>"E"';
        $res_itens = consulta_sql($con_itens);
        $reg_itens = consulta_ler_objeto($res_itens);
        consulta_limpa($res_itens);
        return $reg_itens->NrPedidos;
    }

	function pedido_gera_outros_custo($empresa,$pedido){
		$con_pedido = 'select Vendedor, Outros_Custos, Numero_Pedido from pedido '.
					' where Dominio = "'.$_SESSION["Dominio"].'" and '.
					' Empresa = "'.$empresa.'" and'.
					' Numero_Pedido = "'.$pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_linha($res_pedido);
		consulta_limpa($res_pedido);
		$con_pedidoi = 'select Qtd_Atendida from pedido_item '.
						' where Dominio = "'.$_SESSION["Dominio"].'" and '.
						' Empresa = "'.$empresa.'" and'.
						' Numero_Pedido = "'.$pedido.'" and '.
						' Qtd_Atendida>0 and Status<>"E"';
		$res_pedidoi = consulta_sql($con_pedidoi);
		$reg_pedidoi = consulta_ler_linha($res_pedidoi);
		consulta_limpa($res_pedidoi);
		if ($reg_pedidoi[0]>0){
			$con_nota = 'select Nr_Contas,Situacao from contas_pr '.
						' where Dominio = "'.$_SESSION["Dominio"].'" '.
						' and Empresa = "'.$empresa.'"'.
						' and TipoPR = "P" and TipoEmissao = "P" '.
						' and Pessoa = "'.$reg_pedido[0].'"'.
						' and Modelo = "99" and Serie = "ORC"'.
						' and Nr_Doc = "'.$reg_pedido[2].'-OC'.'"'.
						' and Situacao <> "E"'.
						' and Situacao <> "C"'.
						' order by Seq';
			$res_nota = consulta_sql($con_nota);
			$reg_nota = consulta_ler_linha($res_nota);
			consulta_limpa($res_nota);
			if ($reg_nota[0]>0){
			}else if($reg_pedido[1]>0){
				financeiro_gera_contas('P','P',$empresa, $reg_pedido[0],
										0,'99','ORC','',//subserie
										$reg_pedido[2].'-OC', 1,
										data_atual('date'),data_atual('date'),1,$empresa,
										$reg_pedido[1], 0, 0, 'S',
										0, 0, '',
										0,0,0,0);
			}
		}else{
			$con_nota = 'Update contas_pr set '.
						' Situacao="E" '.
						' where Dominio = "'.$_SESSION["Dominio"].'" '.
						' and Empresa = "'.$empresa.'"'.
						' and TipoPR = "P" and TipoEmissao = "P" '.
						' and Pessoa = "'.$reg_pedido[0].'"'.
						' and Modelo = "99" and Serie = "ORC"'.
						' and Nr_Doc = "'.$reg_pedido[2].'-OC'.'"'.
						' and Situacao = "A"';
			consulta_sql($con_nota);
		}
	}

	//ORDEM DE SERVICO
	function ordem_servico_item_calcula_status($nr_pedido, $seq, $empresa=''){
		if ($empresa == ''){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$cons_pedido_item = 'Select Qtd, '.
							' Qtd_Atendida, '.
							//' Qtd_Liberada, '.
							' Valor_Unitario, '.
							' Valor_Total '.
							' from ordem_servico_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Nr_OrdemServico = "'.$nr_pedido.'"'.
							' and Seq_Item = "'.$seq.'"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$reg_pedido_item = consulta_ler_linha($res_pedido_item);
		consulta_limpa($res_pedido_item);
		if ($reg_pedido_item[1]==0){
			$status = 'A';
		}else if($reg_pedido_item[0]==$reg_pedido_item[1]){
			$status = 'F';
		}else if($reg_pedido_item[1]<$reg_pedido_item[2]){
			$status = 'P';
		}else{
			$status = 'E';
		}
		$atualiza_pedido_item = 'Update ordem_servico_item set '.
								' Status = "'.$status.'" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Nr_OrdemServico = "'.$nr_pedido.'"'.
								' and Seq_Item = "'.$seq.'"';
		consulta_sql($atualiza_pedido_item);
	}

	function ordem_servico_calcula_status($nr_pedido, $status, $empresa=''){
		if ($empresa == ''){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$ok_itens = true;
		if ($status == 'F'){
			$cons_pedido_item = 'SELECT COUNT(*) FROM ordem_servico_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$empresa.'"'.
								' AND Nr_OrdemServico = "'.$nr_pedido.'"'.
								' AND Qtd_Atendida < Qtd'.
								' AND Status = "A"';
			$res_pedido_item = consulta_sql($cons_pedido_item);
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			consulta_limpa($res_pedido_item);
			$ok_itens = ($reg_pedido_item[0] == 0);
		}
		if ($ok_itens){
			$atualiza_pedido_status = 'UPDATE ordem_servico SET '.
										' Status = "'.$status.'" '.
										//' Estoque = "'.$estoque.'" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										' AND Empresa = "'.$empresa.'"'.
										' AND Nr_OrdemServico = "'.$nr_pedido.'"';
			if ($status == 'A'){
				$atualiza_pedido_status.= ' AND Status = "F" ';
			}
			consulta_sql($atualiza_pedido_status);
		}
		//return $estoque;
	}

	//PEDIDO DE COMPRA
	function pedido_compra_recalculo($nr_pedido){
		$valor_total_prod = 0;
		$valor_total_serv = 0;
		$cons_pedido_item = ' Select Id_Produto, Valor_Total, Valor_Desconto, IPI_Valor, ICMSST_Valor,Seq_Item  from pedido_compra_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"'.
							' and Status <> "E"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$nrowarr_pedido_item = consulta_num_registros($res_pedido_item);
		$total_desconto = 0;
		$total_ipi = 0;
		$total_st  = 0;
		for($k=0;$k<$nrowarr_pedido_item;$k++){
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			$cons_produto = ' Select Codigo_Depart from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_pedido_item[0].'"';
			$res_produto = consulta_sql($cons_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);
			if ($reg_produto[0] != 0){
				$valor_total_prod+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}else {
				$valor_total_serv+= $reg_pedido_item[1]+$reg_pedido_item[2];
			}
			$total_desconto+= $reg_pedido_item[2];
			$total_ipi+= $reg_pedido_item[3];
			$total_st+= $reg_pedido_item[4];
			pedido_compra_item_calcula_status($nr_pedido, $reg_pedido_item[5], $_SESSION['Empresa_Codigo']);
		}
		$sub_total = ($valor_total_prod+$valor_total_serv);
		$total_liq = (($sub_total+$total_ipi+$total_st)-$total_desconto);
		consulta_limpa($res_pedido_item);
		$pedido_item = ' Update pedido_compra set '.
						' Valor_Total_Prod = "'.$valor_total_prod.'", '.
						' Valor_Total_Serv = "'.$valor_total_serv.'", '.
						' Valor_Sub_Total = "'.$sub_total.'", '.
						' Valor_Desconto = "'.$total_desconto.'", '.
						' Valor_Acrescimo = 0, '.
						' Valor_Frete = 0, '.
						' Valor_Outros = 0, '.
						' Valor_IPI = "'.$total_ipi.'", '.
						' Valor_ICMSST = "'.$total_st.'", '.
						' Valor_Total_Liquido = "'.$total_liq.'" '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		$res = consulta_sql($pedido_item,true,1);
		if ($res==1){
			$pedido_item =	' Update pedido_compra set '.
							' Forma_Pagto = 1 '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($pedido_item);
			$parcelas = 'delete from pedido_compra_parcela '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($parcelas);
		}
		pedido_compra_calcula_status($nr_pedido, $_SESSION['Empresa_Codigo']);
	}

	function pedido_compra_item_calcula_status($nr_pedido, $seq, $empresa = ''){
		if ($empresa == ''){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$cons_pedido_item = 'Select Qtd, '.
							' Qtd_Atendida, '.
							' Qtd_Liberada, '.
							' Valor_Unitario, '.
							' Valor_Total '.
							' from pedido_compra_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Numero_Pedido = "'.$nr_pedido.'"'.
							' and Seq_Item = "'.$seq.'"';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$reg_pedido_item = consulta_ler_linha($res_pedido_item);
		consulta_limpa($res_pedido_item);
		if (($reg_pedido_item[1]+$reg_pedido_item[2])==0){
			$status = 'B';
		}else if($reg_pedido_item[0]<=$reg_pedido_item[1]){
			$status = 'F';
		}else if($reg_pedido_item[2]<=$reg_pedido_item[1]){
			$status = 'P';
		}else{
			$status = 'A';
		}
		if ($_SESSION['Dominio']=='289' || $_SESSION['Dominio']=='290'){
			if ($reg_pedido_item[2]<=$reg_pedido_item[1]){
				$status = 'F';
			}else{
				$status = 'A';
			}
		}
		$atualiza_pedido_item = 'Update pedido_compra_item set '.
								' Status = "'.$status.'" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido = "'.$nr_pedido.'"'.
								' and Seq_Item = "'.$seq.'"';
		/**Alterao realizada em 06/10/2023 para no pegar itens Cancelados, Excluidos e Fechados por @isabel  */
		$atualiza_pedido_item .= 'AND Status<>"E" AND Status<>"C" AND Status<>"F" ';

		consulta_sql($atualiza_pedido_item);
	}
	
	function pedido_compra_calcula_status($nr_pedido, $empresa = ''){
		$aberto = false;
		$fechado = false;
		$parcial = false;
		$cancelado = false;
		$bloqueado = false;
		$estoque = 'N';
		if ($empresa == ''){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$cons_pedido =	'Select Status from pedido_compra_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"'.
						' and Status <> "E"';
		$res_pedido = consulta_sql($cons_pedido);
		$nrwowarr_pedido = consulta_num_registros($res_pedido);
		for($kk=0;$kk<$nrwowarr_pedido;$kk++){
			$reg_pedido_item = consulta_ler_linha($res_pedido);
			if ($reg_pedido_item[0] == 'F'){
				$fechado = true;
			}
			if ($reg_pedido_item[0] == 'A'){
				$aberto = true;
			}
			if ($reg_pedido_item[0] == 'B'){
				$bloqueado = true;
			}
			if ($reg_pedido_item[0] == 'P'){
				$parcial = true;
			}
			if ($reg_pedido_item[0] == 'C'){
				$cancelado = true;
			}
		}
		consulta_limpa($res_pedido);
		if ($cancelado){
			$status = 'C';
		}else if($parcial){
			$status = 'P';
		}else if(($aberto) && ($fechado)){
			$status = 'P';
		}else if(($aberto) && ($bloqueado)){
			$status = 'A';
		}else if($bloqueado){
			$status = 'B';
		}else if($fechado){
			$status = 'F';
			$estoque = 'S';
		}else {
			$status = 'A';
		}

		
		$atualiza_pedido_status='Update pedido_compra set '.
								' Status = "'.$status.'", '.
								' Estoque = "'.$estoque.'" '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa.'"'.
								' and Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($atualiza_pedido_status);
	}

	//FIM PEDIDO DE COMPRA
	function calcula_pedido_compra($nr_pedido){
		$con_seq =	'SELECT IFNULL(SUM(Valor_Total), 0) FROM pedido_compra_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Numero_Pedido = "'.$nr_pedido.'"';
		$res_seq = consulta_sql($con_seq);
		$reg_seq = consulta_ler_linha($res_seq);
		consulta_limpa($res_seq);
		return $reg_seq[0];
	}

	function liberar_pedido($nr_pedido, $nr_empresa = 0, $finalizado = false){
		if ($nr_empresa==0){
			$nr_empresa = $_SESSION['Empresa_Codigo'];
		}
		$lib_tipo = BuscaParam('LIBERA_AUTOMAT_PEDID');
		$mensagem = '';
		$parcial = false;
		$compra = false;
		//$nr_pedido = base64_decode_si($nr_pedido);
		$cons_pedido =	'Select Status, Tipo_Pedido, Empresa, Pessoa from pedido '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$nr_empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($cons_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		if ((($reg_pedido->Status=='F'))||(($reg_pedido->Status)=='C')){
			// ao entrar aqui nao processa nenhuma execuo
		}else{
			//determina quanto pode ser liberado caso o produto controle lote
			//remove todos os itens em aberto e fecha todos que foram atendidos parcialmente
			$con_del =	'Update produto_saldo_filial_lote_reser '.
						' set Situacao="E" '.
						' where Dominio="'.$_SESSION["Dominio"].'" '.
						' and Pedido_Empresa="'.$nr_empresa.'"'.
						' and Pedido_Nr="'.$nr_pedido.'" '.
						//' and Pedido_Seq="'.$reg_item->Seq_Item.'"'.
						' and Situacao="A"';
			consulta_sql($con_del);
			$con_del =	'Update produto_saldo_filial_lote_reser '.
						' set Qtd_Reserva=Qtd_Atendida, '.
						' Situacao="F" '.
						' where Dominio="'.$_SESSION["Dominio"].'" '.
						' and Pedido_Empresa="'.$nr_empresa.'"'.
						' and Pedido_Nr="'.$nr_pedido.'" '.
						//' and Pedido_Seq="'.$reg_item->Seq_Item.'"'.
						' and Situacao="P"';
			consulta_sql($con_del);
			//verifica se movimenta estoque, para validar ou nao o lote
			$con_tipo = 'select CFOP from tipo_pedido '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Tipo = "'.$reg_pedido->Tipo_Pedido.'"';
			$res_tipo = consulta_sql($con_tipo);
			$reg_tipo = consulta_ler_linha($res_tipo);
			consulta_limpa($res_tipo);
			$con_cfop = 'select Mov_Estoque from cfop '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and CFOP = "5.'.$reg_tipo[0].'"';
			$res_cfop = consulta_sql($con_cfop);
			$reg_cfop = consulta_ler_linha($res_cfop);
			consulta_limpa($res_cfop);
			$nao_movimenta = false;
			if ($reg_cfop[0]=='N'){
				$nao_movimenta = true;
			}
			//consulta cada item e libera cada item individualmente
			$con_item = 'select * from pedido_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$nr_empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"'.
						' and Status <> "E"';
			if ($lib_tipo!='L'){
				$con_item.=' and Qtd > Qtd_Liberada';
			}
			if (($lib_tipo!='F')&&($lib_tipo!='L')){
				$con_item.=' and Estoque="S"';
			}
			$res_item = consulta_sql($con_item);
			$nrw_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrw_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				pedido_compra_deleta_saldo_vendido(($nr_pedido*(-1)), $nr_empresa, $reg_item->Seq_Item);
				//consulta e descobre se o item controla estoque por lote
				//conulta o produto
				$con_prod = 'select Codigo_Depart, Estoque_Lote '.
							' from produto '.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Id_Produto="'.$reg_item->ID_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$ped_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);
				$liberar = $reg_item->Qtd;
				if ($ped_prod[0]>0){
					//consulta o departamento do produto
					$con_depart='Select Controle_Lote, Fatura_Sem_Estoque, Venda_Exige_Compra '.
								' from produto_departamento '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Codigo_Depart = "'.$ped_prod[0].'"';
					$res_depart = consulta_sql($con_depart);
					$reg_depart = consulta_ler_linha($res_depart);
					consulta_limpa($res_depart);
					$tp_controle = $reg_depart[0];
					if ((($reg_depart[2]=='S')||($reg_depart[2]=='A')) &&
						($reg_item->NrCompra=='0')){
						$liberar = 0;
						$compra = true;
					}
					if ($_SESSION["Dominio"]==333){
						if ($reg_depart[1]=='N'){
							$con_saldo ='select sum(Saldo_Atual) Saldo from produto_saldo_filial '.
										' where Dominio="'.$_SESSION["Dominio"].'"'.
										' and Codigo_Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
										' and Id_Produto="'.$reg_item->ID_Produto.'"'.
										' and Local_Armaz=0 ';
							$res_saldo = consulta_sql($con_saldo);
							$reg_saldo = consulta_ler_linha($res_saldo);
							consulta_limpa($res_saldo);
							if ($reg_saldo[0]<($reg_item->Qtd - $reg_item->Qtd_Atendida)){
								$liberar = 0;
							}
						}
					}
					if ($reg_item->NrCompra>0){
						//consultar saldo pedido_compra_item Qtd-QtdVendida
						$cons_pedido_item = 'SELECT (Qtd - Qtd_Vendida) '.
											' FROM pedido_compra_item '.
											' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
											' AND Empresa = "'.$reg_item->EmpresaCompra.'"'.
											' AND Numero_Pedido = "'.$reg_item->NrCompra.'"'.
											' AND ID_Produto = "'.$reg_item->ID_Produto.'"';
						$res_pedido_item = consulta_sql($cons_pedido_item);
						$reg_pedido_item = consulta_ler_linha($res_pedido_item);
						consulta_limpa($res_pedido_item);
						if ($reg_pedido_item[0]<($reg_item->Qtd - $reg_item->Qtd_Atendida)){
							$liberar = 0;
						}
					}
					if ($ped_prod[1]!='N'){
						$tp_controle = $ped_prod[1];
					}
					if ($nao_movimenta){
						$tp_controle = 'N';
					}
					if ($liberar>0){
						if ($tp_controle=='E'){
							//consulta lotes disponveis para a filial atual
							$liberar = $reg_item->Qtd_Atendida;
							$saldo = $reg_item->Qtd - $reg_item->Qtd_Atendida;
							$con_saldo ='select NrLote, sum(Saldo_Atual) Saldo from produto_saldo_filial_lote '.
										' where Dominio="'.$_SESSION["Dominio"].'"'.
										' and Codigo_Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
										' and Id_Produto="'.$reg_item->ID_Produto.'"'.
										' group by NrLote having Saldo>0'.
										' order by DH_Lote, NrLote';
							$res_saldo = consulta_sql($con_saldo);
							$nrw_saldo = consulta_num_registros($res_saldo);
							for($s=0;$s<$nrw_saldo;$s++){
								$reg_saldo = consulta_ler_linha($res_saldo);
								$con_reservas = 'select sum(Qtd_Reserva-Qtd_Atendida) from produto_saldo_filial_lote_reser '.
												' where Dominio="'.$_SESSION["Dominio"].'"'.
												' and Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
												' and Id_Produto="'.$reg_item->ID_Produto.'"'.
												' and Nr_Lote="'.$reg_saldo[0].'"'.
												' and ((Situacao="A") or (Situacao="P"))';
								$res_reservas = consulta_sql($con_reservas);
								$reg_reservas = consulta_ler_linha($res_reservas);
								consulta_limpa($res_reservas);
								$disponivel = $reg_saldo[1] - $reg_reservas[0];
								if ($disponivel>0){
									$qtd_liberar = $saldo;
									if ($qtd_liberar > $disponivel){
										$qtd_liberar = $disponivel;
									}
									//reserva a qtd disponivel
									$con_ins =	'Insert into produto_saldo_filial_lote_reser '.
												'(id, Dominio, Empresa, Id_Produto, Nr_Lote, '.
												' Qtd_Reserva, Pedido_Empresa, '.
												' Pedido_Nr, Pedido_Seq)'.
												' values ("", '.
												'"'.$_SESSION["Dominio"].'",'.
												'"'.$_SESSION['Empresa_Codigo'].'",'.
												'"'.$reg_item->ID_Produto.'",'.
												'"'.$reg_saldo[0].'",'.
												'"'.$qtd_liberar.'",'.
												'"'.$nr_empresa.'",'.
												'"'.$nr_pedido.'",'.
												'"'.$reg_item->Seq_Item.'")';
									consulta_sql($con_ins,true,2);
									//descresse saldo para que o prximo pegue s o resto;
									$saldo-= $qtd_liberar;
									//e agrega na qtd que vai ser liberada
									$liberar+= $qtd_liberar;
									if ($saldo<=0){ //ao atender tudo sai do looping
										$s = $nrw_saldo;
									}
								}
							}
							consulta_limpa($res_saldo);
						}else if(($tp_controle!='N')&&($tp_controle!='')){
							$con_saldo= 'select sum(Saldo_Atual) Saldo from produto_saldo_filial_lote '.
										' where Dominio="'.$_SESSION["Dominio"].'"'.
										' and Codigo_Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
										' and Id_Produto="'.$reg_item->ID_Produto.'"'.
										' and Peneira="'.$reg_item->Peneira.'"'.
										' and NrLote="'.$reg_item->NrLote.'"';
							$res_saldo = consulta_sql($con_saldo);
							$reg_saldo = consulta_ler_linha($res_saldo);
							consulta_limpa($res_saldo);
							$con_saldo2='select sum(Qtd-Qtd_Atendida) Saldo from pedido_item '.
										' where Dominio="'.$_SESSION["Dominio"].'"'.
										' and Empresa="'.$reg_item->Empresa.'"'.
										' and Numero_Pedido="'.$reg_item->Numero_Pedido.'"'.
										' and Seq_Item<>"'.$reg_item->Seq_Item.'"'.
										' and Id_Produto="'.$reg_item->ID_Produto.'"'.
										' and Peneira="'.$reg_item->Peneira.'"'.
										' and NrLote="'.$reg_item->NrLote.'"'.
										' and Status="L"';
							$res_saldo2 = consulta_sql($con_saldo2);
							$reg_saldo2 = consulta_ler_linha($res_saldo2);
							consulta_limpa($res_saldo2);
							$disponivel = $reg_saldo[0] - $reg_saldo2[0];
							$saldo = $reg_item->Qtd - $reg_item->Qtd_Atendida;
							//echo  $saldo.'#'.$reg_saldo[0];
							if ($saldo > $disponivel){
								$liberar = $reg_item->Qtd_Atendida + $disponivel;
							}
						}
						if ($liberar != $reg_item->Qtd){
							$parcial = true;
						}
					}
				}
				if ($liberar<$reg_item->Qtd_Atendida){
					$liberar = $reg_item->Qtd_Atendida;
				}
				$atualiza_pedido_item = 'Update pedido_item set '.
										' Qtd_Liberada = "'.$liberar.'" '.
										' where Dominio = "'.$_SESSION['Dominio'].'"'.
										' and Empresa = "'.$nr_empresa.'"'.
										' and Numero_Pedido = "'.$nr_pedido.'"'.
										' and Seq_Item="'.$reg_item->Seq_Item.'"';
				consulta_sql($atualiza_pedido_item);
				pedido_item_calcula_status($nr_pedido, $reg_item->Seq_Item, $nr_empresa); 
			}
			pedido_calcula_status($nr_pedido,$nr_empresa,$finalizado);
			if ($parcial){
				$mensagem.='<BR>Ateno: Alguns itens foram liberados parcialmente por falta de lotes no estoque disponvel!';
			}
			if ($compra){
				$mensagem.='<BR>Ateno: Alguns itens no foram liberados falta do Nr do Pedido de Compra!';
			}
		}
		return $mensagem;
	}

	function liberar_pedido_compra($nr_pedido,$nr_empresa=0){
		if ($nr_empresa==0){
			$nr_empresa = $_SESSION['Empresa_Codigo'];
		}
		$mensagem = '';
		//        $nr_pedido = base64_decode_si($nr_pedido);
		$cons_pedido =	'Select Status from pedido_compra '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$nr_empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($cons_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		if ((($reg_pedido->Status=='F'))||(($reg_pedido->Status)=='C')){
			// ao entrar aqui nao processa nenhuma execuo
		}else{
			//somente para a sul ser feita a verificao de liberar fertilizante
			if ($_SESSION['Dominio']=='2'){
				if (session::tempermissao('FERT_LIBERA') == '   '){
					$perm_fert=false;
				}else{
					$perm_fert=true;
				}
			}else{
				$perm_fert=true;
			}
			//consulta cada item e libera cada item individualmente
			$con_item = 'select * from pedido_compra_item '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$nr_empresa.'"'.
						' and Numero_Pedido = "'.$nr_pedido.'"'.
						' and Status <> "E"'.
						' and ((Qtd > Qtd_Liberada) or (Status="B"))';
			$res_item = consulta_sql($con_item);
			$nrw_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrw_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				$con_prod = 'select Codigo_Depart '.
							' from produto '.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Id_Produto="'.$reg_item->ID_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$ped_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);
				//perm_fert==false  apenas para a SUL
				if ($perm_fert==false){
					if ($ped_prod[0]=='4'){
						$libera_item=false;
					}else{
						$libera_item=true;
					}
				}else{
					$libera_item=true;
				}
				if ($libera_item){
					$liberar = $reg_item->Qtd;
					$atualiza_pedido_item = 'Update pedido_compra_item set '.
											' Qtd_Liberada = "'.$liberar.'" '.
											' where Dominio = "'.$_SESSION['Dominio'].'"'.
											' and Empresa = "'.$nr_empresa.'"'.
											' and Numero_Pedido = "'.$nr_pedido.'"'.
											' and Seq_Item="'.$reg_item->Seq_Item.'"';
					consulta_sql($atualiza_pedido_item);
					pedido_compra_item_calcula_status($nr_pedido, $reg_item->Seq_Item, $nr_empresa);
				}
			}                     
			pedido_compra_calcula_status($nr_pedido,$nr_empresa);                     
		}
		return $mensagem;
	}

	function pedido_compra_deleta_saldo_vendido($nr_pedido, $empresa_pedido, $seq_item=''){
		$cons_vend ='SELECT * from pedido_compra_vendido '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa_Venda = "'.$empresa_pedido.'"'.
					' AND Nr_Venda = "'.$nr_pedido.'"';
		if ($seq_item!=''){
			$cons_vend.= ' AND Seq_Item_Venda = "'.$seq_item.'"';
		}
		//echo $cons_vend;
		$res_vend = consulta_sql($cons_vend);
		$nrow_vend = consulta_num_registros($res_vend);
		if ($nrow_vend>0){
			for($v=0;$v<$nrow_vend;$v++){
				$reg_vend = consulta_ler_objeto($res_vend);
				$del_ped =	'DELETE from pedido_compra_vendido '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$reg_vend->Empresa.'"'.
							' AND Numero_Pedido = "'.$reg_vend->Numero_Pedido.'"'.
							' AND Seq_Item = "'.$reg_vend->Seq_Item.'"'.
							' AND Empresa_Venda = "'.$reg_vend->Empresa_Venda.'"'.
							' AND Nr_Venda = "'.$reg_vend->Nr_Venda.'"'.
							' AND Seq_Item_Venda = "'.$reg_vend->Seq_Item_Venda.'"';
				consulta_sql($del_ped);
				// teste para no ser feito quando for uma devoluo 
				// realizado em  03/06/2022 por @isabel  para Cancelamento de Notas de Devolucao do Dominio 2
				if( $reg_vend->Qtd_Vendida > 0 ){
					$upd_ped_compra='UPDATE pedido_compra_item '.
								' SET Qtd_Vendida = Qtd_Vendida - '.$reg_vend->Qtd_Vendida.' '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$reg_vend->Empresa.'"'.
								' and Numero_Pedido = "'.$reg_vend->Numero_Pedido.'"'.
								' and Seq_Item = "'.$reg_vend->Seq_Item.'"';
					consulta_sql($upd_ped_compra);
				}
			}
		}
		consulta_limpa($res_vend);
	}

	function busca_seq_pedido_compra_item($nr_pedido, $empresa, $seq_item){
		$nr_seq_item = 0;
		if ($nr_pedido>0){
			//consulta produto, qtd_liberada e qtd_atendida
			$cons_ped_venda='select Id_Produto, Quantidade_Estoque, 0, EmpresaCompra, NrCompra '.
							' from nota_fiscal_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Nr_Nota = "'.$nr_pedido.'"'.
							' and Seq_Item = "'.$seq_item.'"';
		}else{
			//consulta produto, qtd_liberada e qtd_atendida
			$cons_ped_venda='select ID_Produto, Qtd_Liberada, Qtd_Atendida, EmpresaCompra, NrCompra '.
							' from pedido_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$empresa.'"'.
							' and Numero_Pedido = "'.($nr_pedido*(-1)).'"'.
							' and Seq_Item = "'.$seq_item.'"';
		}
		$res_ped_venda = consulta_sql($cons_ped_venda);
		$reg_ped_venda = consulta_ler_linha($res_ped_venda);
		consulta_limpa($res_ped_venda);
		//busca seq do item de compra
		$cons_pedido_item = 'select Seq_Item '.
							' from pedido_compra_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$reg_ped_venda[3].'"'.
							' and Numero_Pedido = "'.$reg_ped_venda[4].'"'.
							' and Id_Produto = "'.$reg_ped_venda[0].'"'.
							// ' and Qtd_Liberada <= "'.($reg_ped_venda[1]-$reg_ped_venda[2]).'"'.
							' and ((Status="A") or (Status="P")or (Status="F"))'.
							' and (Qtd>Qtd_Vendida)';
		$res_pedido_item = consulta_sql($cons_pedido_item);
		$nrw_pedido_item = consulta_num_registros($res_pedido_item);
		if ($nrw_pedido_item>0){
			$reg_pedido_item = consulta_ler_linha($res_pedido_item);
			$nr_seq_item = $reg_pedido_item[0];
		}
		consulta_limpa($res_pedido_item);
		return $nr_seq_item;
	}

	function pedido_compra_insere_saldo_vendido($nr_compra, $empresa_compra,
												$nr_venda, $empresa_venda, $seq_venda,
												$qtd_vendida){
		if ($qtd_vendida>0.0001){
			$nr_seq = busca_seq_pedido_compra_item($nr_venda, $empresa_venda, $seq_venda);
			if ($nr_seq>0){
				//$reg_pedido_item = consulta_ler_linha($res_pedido_item);
				$ins_vend = 'INSERT INTO pedido_compra_vendido ('.
							'Dominio, Empresa, Numero_Pedido, Seq_Item, '.
							'Empresa_Venda, Nr_Venda, Seq_Item_Venda, Qtd_Vendida) '.
							'VALUES ("'.$_SESSION['Dominio'].'", "'.$empresa_compra.'", "'.$nr_compra.'", "'.$nr_seq.'", '.
							'"'.$empresa_venda.'", "'.$nr_venda.'", "'.$seq_venda.'", "'.$qtd_vendida.'")';
				consulta_sql($ins_vend);
				$upd_ped_compra='UPDATE pedido_compra_item '.
								' SET Qtd_Vendida = Qtd_Vendida + '.$qtd_vendida.' '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$empresa_compra.'"'.
								' and Numero_Pedido = "'.$nr_compra.'"'.
								' and Seq_Item = "'.$nr_seq.'"';
				consulta_sql($upd_ped_compra);
			}
		}
	}

	function pedido_compra_retorna_saldo_pedido($nr_venda, $empresa_venda, $seq_venda,
		$empresa_pedido, $nr_pedido, $seq_pedido){
		$cons_seq_vendido = 'SELECT * from pedido_compra_vendido '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							//' and Empresa = "'.$empresa_compra.'"'.
							//' and Numero_Pedido = "'.$nr_compra.'"'.
							' and Empresa_Venda = "'.$empresa_venda.'"'.
							' and Nr_Venda = "'.$nr_venda.'"'.
							' and Seq_Item_Venda = "'.$seq_venda.'"';
		$res_seq_vendido = consulta_sql($cons_seq_vendido);
		$nrw_seq_vendido = consulta_num_registros($res_seq_vendido);
		if ($nrw_seq_vendido>0){
			for($s=0;$s<$nrw_seq_vendido;$s++){
				$reg_seq_vendido = consulta_ler_objeto($res_seq_vendido);
				$upd_ped_vendido =	'UPDATE pedido_compra_vendido '.
									' SET Qtd_Vendida = Qtd_Vendida - '.$reg_seq_vendido->Qtd_Vendida.' '.
									' where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Empresa = "'.$reg_seq_vendido->Empresa.'"'.
									' and Numero_Pedido = "'.$reg_seq_vendido->Numero_Pedido.'"'.
									' and Seq_Item = "'.$reg_seq_vendido->Seq_Item.'"'.
									' and Empresa_Venda = "'.$empresa_venda.'"'.
									' and Nr_Venda = "'.$nr_venda.'"'.
									' and Seq_Item_Venda = "'.$seq_venda.'"';
				$res_upd_ped_vendido = consulta_sql($upd_ped_vendido,true,1);
				if ($res_upd_ped_vendido>0){
					$upd_ped_vendido =	'delete from pedido_compra_vendido '.
										' where Dominio = "'.$_SESSION['Dominio'].'"'.
										' and Empresa = "'.$reg_seq_vendido->Empresa.'"'.
										' and Numero_Pedido = "'.$reg_seq_vendido->Numero_Pedido.'"'.
										' and Seq_Item = "'.$reg_seq_vendido->Seq_Item.'"'.
										' and Empresa_Venda = "'.$empresa_venda.'"'.
										' and Nr_Venda = "'.$nr_venda.'"'.
										' and Seq_Item_Venda = "'.$seq_venda.'"'.
										' and Qtd_Vendida<=0';
					consulta_sql($upd_ped_vendido,true,1);
					$ins_vend = 'INSERT INTO pedido_compra_vendido ('.
								'Dominio, Empresa, Numero_Pedido, Seq_Item, '.
								'Empresa_Venda, Nr_Venda, Seq_Item_Venda, Qtd_Vendida) '.
								'VALUES ("'.$_SESSION['Dominio'].'", '.
								'"'.$reg_seq_vendido->Empresa.'", '.
								'"'.$reg_seq_vendido->Numero_Pedido.'", '.
								'"'.$reg_seq_vendido->Seq_Item.'", '.
								'"'.$empresa_pedido.'", '.
								'"'.($nr_pedido*(-1)).'", '.
								'"'.$seq_pedido.'", '.
								'"0")';
					consulta_sql($ins_vend);
					$upd_ped_vendido1 = 'UPDATE pedido_compra_vendido '.
										' SET Qtd_Vendida = Qtd_Vendida + '.$reg_seq_vendido->Qtd_Vendida.' '.
										' where Dominio = "'.$_SESSION['Dominio'].'"'.
										' and Empresa = "'.$reg_seq_vendido->Empresa.'"'.
										' and Numero_Pedido = "'.$reg_seq_vendido->Numero_Pedido.'"'.
										' and Seq_Item = "'.$reg_seq_vendido->Seq_Item.'"'.
										' and Empresa_Venda = "'.$empresa_pedido.'"'.
										' and Nr_Venda = "'.($nr_pedido*(-1)).'"'.
										' and Seq_Item_Venda = "'.$seq_pedido.'"';
					$res_upd_ped_vendido1 = consulta_sql($upd_ped_vendido1);
				}
			}
		}
	}

	require_once(dirname(__FILE__).'/nota_fiscal.php');
	require_once(dirname(__FILE__).'/nota_frete.php');
	require_once(dirname(__FILE__).'/financeiro.php');
	require_once(dirname(__FILE__).'/contas_galt.php');
	require_once(dirname(__FILE__).'/cupom_fiscal.php');
	require_once(dirname(__FILE__).'/cash_back.php');

	function consulta_boletim($numero){
		$con_boletim =	'select * from boletim_pesagem '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' and Nr_Boletim = "'.$numero.'"';
		$res_boletim = consulta_sql($con_boletim);
		//$nro_boletim = consulta_num_registros($res_boletim);
		$reg_boletim = consulta_ler_objeto($res_boletim);
		return $reg_boletim;
	}


	/**
	 * Funo criada por @Mauricio em 10/08/2022 no $imples_Web_Pro e repassada para o $imples_Web, para buscar o sado do mes por produto
	 * @param int id_produto (obrigatrio)
	 * @param int empresa (opcional)
	 * @param string data (opcional)
	 * @return array
	 */
	function BuscaSaldoMes($id_produto,$empresa='',$data=''){
		$ret = array();
		if ($empresa==''){
			$empresa = $_SESSION['Empresa'];
		}
        if ($data == ''){
            $data = date('Y-m-d');
        } 
        $ano_mes = substr($data,0,4).substr($data,5,2);
		$con_saldo = 'SELECT Saldo_Atual as Saldo, Preco_Custo as Custo, Custo_Geral as Geral FROM  produto_saldo_filial_mes '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' AND Id_Produto="'.$id_produto.'" '.
						' AND AnoMes<="'.$ano_mes.'" '.
						' and Local_Armaz=0 '.
						' order by AnoMes desc limit 1';

		$res_saldo = consulta_sql($con_saldo );
		$reg_saldo = consulta_ler_linha($res_saldo);
		consulta_limpa( $res_saldo);

		$ret['Saldo'] = $reg_saldo[0];
		$ret['Custo'] = $reg_saldo[1];
		$ret['Geral'] = $reg_saldo[2];
		if ($ret['Saldo']===null){
			$ret['Saldo'] = 0;
			$ret['Custo'] = 0;
			$ret['Geral'] = 0;
		}
		
        $con_saldo2 = 'SELECT Saldo_Atual as Saldo, Preco_Custo as Custo, Custo_Geral as Geral FROM  produto_saldo_filial_mes '.
						' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' AND Id_Produto="'.$id_produto.'" '.
						' AND AnoMes<="'.$ano_mes.'" '.
						' and Local_Armaz=(-1) '.
						' order by AnoMes desc limit 1';
		$res_saldo2 = consulta_sql($con_saldo2 );
		$reg_saldo2 = consulta_ler_linha($res_saldo2);
		consulta_limpa( $res_saldo2);

		$ret2['Saldo'] = $reg_saldo2[0];
		$ret2['Custo'] = $reg_saldo2[1];
		$ret2['Geral'] = $reg_saldo2[2];

        if ($ret2['Saldo']===null){
			$ret2['Saldo'] = 0;
			$ret2['Custo'] = 0;
			$ret2['Geral'] = 0;
		}
        $ret['Saldo']+= $ret2['Saldo'];
		$ret['Geral']+= $ret2['Geral'];
        if ($ret['Saldo']!=0){
		    $ret['GeralU'] = $ret['Geral']/$ret['Saldo'];
        }else{
            $ret['GeralU'] = $ret['Geral'];
        }
		return $ret;
	}

	/**
	 * Adicionado novo campo (custo_geral_nf) por @mauricio em 10/08/2022, no sistema $imples_Web_Pro repassado para o $imples Web, para situas de Venda no cupom,  Ordem de Produo e Acerto de estoque
	 *   */
	function gera_mov_estoque($id_produto,$barra,$data,
								$qtd,$local,$proprietario,
								$valor_produto,
								$lote,$serie,$atestado, $dt_fab,
								$dt_val, $pureza, $germinacao,
								$obs, $nf_modelo='',$nf_doc='0',
								$nf_item='0',$nf_serie='',$nf_nr='0',
								$acerto=0,$emp=0,$nivel=1,$peneira='',
								$valor_sem_imposto=0,$cfop_financ='S', $cfop_est='N', $custo_geral_nf=0){
		
		if ($emp==0){	$emp = $_SESSION["Empresa_Codigo"];	}
		$custo_geral =  $valor_produto;
		if ($custo_geral<=0){ $custo_geral = $custo_geral_nf; }
        if ($custo_geral<=0){ 
			$retorno_custo_geral =  BuscaSaldoMes($id_produto,$emp,$data) ; 
            $custo_geral = $retorno_custo_geral['GeralU']*$qtd; 
            if($custo_geral<0){ $custo_geral =  $custo_geral * (-1); }//deve ser positivo pra efeito de calculo
        }
		if($qtd<0){ $custo_geral =  $custo_geral * (-1); }//se diminui o estoque o custo geral  tambm diminui
		
		
		$composto = false;
		$fator = '';
		// se nivel < 10
		if ($nivel<10){
			//Consultar as composicoes do produto
			$con_prod_comp ='select Id_Produto_Origem, Quantidade  from produto_composicao '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Id_Produto_Final="'.$id_produto.'"'.
							' and Situacao = "A"';
			$res_prod_comp = consulta_sql($con_prod_comp);
			$nro_prod_comp = consulta_num_registros($res_prod_comp);
			//se tem componentes
			if ($nro_prod_comp>0){
				//consulta o produto
				$con_produto =	'select Baixa_Estoque from produto '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Id_Produto="'.$id_produto.'"';
				$res_produto= consulta_sql($con_produto);
				$reg_produto = consulta_ler_linha($res_produto);
				consulta_limpa($res_produto);
				//se tipo de composicao = por ordem de produo
				if ($reg_produto[0]=='V'){
					$composto = true;
				}
			}
		}
		//se $composto
		if ($composto){
			//para cada linha
			for($p=0;$p<$nro_prod_comp;$p++){
				//determina o fator de conversao e atualiza o estoque do componente
				$reg_prod_comp = consulta_ler_linha($res_prod_comp);
				$fator = $reg_prod_comp[1];
				$qtd_comp = $qtd*$fator;
				$valor_produto = 0;
				$con_cad =	'select Codigo_Barras from produto_cod_barras '.
							' where Dominio="'.$_SESSION["Dominio"].'" '.
							' and Id_Produto = "'.$reg_prod_comp[0].'"'.
							' and Situacao = "A" '.
							' limit 1';
				$res_cad = consulta_sql($con_cad);
				$reg_cad = consulta_ler_linha($res_cad);
				consulta_limpa($res_cad);
				$barra = $reg_cad[0];
				gera_mov_estoque($reg_prod_comp[0],$barra,$data,
								$qtd_comp,0,$proprietario,
								$valor_produto,
								'','','', '',
								'', '', '',
								$obs,$nf_modelo,$nf_doc,
								$nf_item,$nf_serie,$nf_nr,
								$acerto,$emp,$nivel+1,'');
			}
			consulta_limpa($res_prod_comp);
		}else{
			$data_custo = data_atual('date').' '.nr2hora(hora_atual());
			if (($qtd > 0) && ($valor_produto > 0)){
				//////////////////////////////////////////////
				////////////Custo do Produto - Dominio////////
				//////////////////////////////////////////////
				//consulta custo atual para usar na tabela
				$con_produto =	'SELECT Preco_Custo, DH_Custo, Custo_Referencial FROM produto'.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Id_Produto = "'.$id_produto.'"';
				$res_produto = consulta_sql($con_produto);
				$reg_produto = consulta_ler_linha($res_produto);
				consulta_limpa($res_produto);
				//entrada recalcula custo do produto
				$con_estoq ='SELECT IFNULL(SUM(Saldo_Atual), 0) FROM produto_saldo_filial'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Id_Produto = "'.$id_produto.'"';
				$res_estoq = consulta_sql($con_estoq);
				$reg_estoq = consulta_ler_linha($res_estoq);
				consulta_limpa($res_estoq);
				if ($reg_estoq[0] < 0){
					$reg_estoq[0] = 0;
					//pra custo no ficar negativo ou diviso por zero
				}
				if ($reg_produto[0] <= 0){
					if ($qtd > 0){
						$reg_produto[0] = $valor_produto / $qtd;
					}
				}
				$custo = ($reg_estoq[0] * $reg_produto[0]) + $valor_produto;
				$custo_unitario = $custo / ($reg_estoq[0] + $qtd);
				$custo_reposicao = ($valor_produto / $qtd);
				if ($valor_produto>0){
					if ( Zathura()  ){
						$custo_unitario = $custo_reposicao;
						$custo = ($reg_estoq[0] * $custo_unitario) + $valor_produto;						
					}
				}

				
				
				//custo referencial
				$custo_referencial = $custo_reposicao;
				if (($nf_nr > 0) && ($cfop_financ != 'N')){
					//consulta utima entrada
					$con_custoh='SELECT Preco_Custo_Ult_Entrada FROM produto_hist_custo'.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								// ' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Id_Produto = "'.$id_produto.'"'.
								' ORDER BY DH_Custo DESC '.
								' LIMIT 1';
					$res_custoh = consulta_sql($con_custoh);
					$reg_custoh = consulta_ler_linha($res_custoh);
					consulta_limpa($res_custoh);
					if (isset($reg_custoh)){
						if ($reg_custoh[0] > 0){
							$custo_referencial = $reg_custoh[0];
							if (($custo_reposicao > 0) && ($reg_estoq[0] > 0)){
								$custo_referencial = (($custo_reposicao + $reg_custoh[0]) / 2);
							}
						}
					}
				}else{  //se for alterao de saldo s pega do cadastro
					$custo_referencial = $reg_produto[2];
				}
				/**Teste de Custo Geral para Dominio 02 usando o Dominio 214 como teste por @isabel  */
				if( $cfop_est == "A"){
					$custo_geral =  $valor_produto; //sera o valor do produto mesmo sem a divisao pela quantidade 

				}else if( $cfop_est == "D"){
					$custo_geral =  $valor_produto * (-1); 
					//se diminui o estoque o custo geral  tambm diminui 
				}

				/**Teste de Custo Geral para Dominio 02 usando o Dominio 214 como teste por @isabel  */	
				//atualiza custo total do produto
				$udt_saldo_pro ='UPDATE produto SET '.
								' Custo_Referencial = "'.$custo_referencial.'",'.
								' Preco_Custo = "'.$custo_unitario.'",'.
								' DH_Custo = "'.$data_custo.'",  '.
								' Custo_Geral = Custo_Geral + "'.$custo_geral.'" '.	// para dominio 2 criado em  27/04/2022 por @isabel
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Id_Produto = "'.$id_produto.'"';
				consulta_sql($udt_saldo_pro,true,1);
				//consulta_ler_linha($res_estoq);
				$udt_saldo_pro ='UPDATE produto_cod_barras SET '.
								' Preco_Custo = "'.$custo_unitario.'", '.
								' DH_Custo = "'.$data_custo.'" '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Id_Produto = "'.$id_produto.'" '.
								' AND Codigo_Barras = "'.$barra.'"';
				consulta_sql($udt_saldo_pro,true,1);
				//////////////////////////////////////////////
				////////////Custo do Produto - Empresa////////
				//////////////////////////////////////////////
				//consulta custo atual para usar na tabela
				$con_custo ='SELECT Preco_Custo, DH_Custo, Preco_Custo_Ult_Entrada FROM produto_hist_custo'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Id_Produto = "'.$id_produto.'"'.
							' ORDER BY DH_Custo DESC '.
							' LIMIT 1';
				$res_custo = consulta_sql($con_custo);
				$reg_custo = consulta_ler_linha($res_custo);
				consulta_limpa($res_custo);
				//calcula custo na filial
				$con_estoq ='SELECT IFNULL(SUM(Saldo_Atual), 0), IFNULL(MAX(Custo_Reposicao), 0), '.
							' IFNULL(MAX(Custo_SemImposto), 0), IFNULL(MAX(Custo_Referencial), 0), IFNULL(MAX(Preco_Custo), 0) '.
							' FROM produto_saldo_filial'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Id_Produto = "'.$id_produto.'"';
				$res_estoq = consulta_sql($con_estoq);
				$reg_estoq = consulta_ler_linha($res_estoq);
				consulta_limpa($res_estoq);
				if ($reg_custo[0] <= 0){
					$reg_custo[0] = $reg_estoq[4];
				}
				$custo_unitario = $reg_custo[0];
				if ($reg_estoq[0] < 0){
					$reg_estoq[0] = 0;
				}
				if ($reg_custo[0] <= 0){
					if ($qtd > 0){
						$reg_custo[0] = $valor_produto / $qtd;
					}
				}
				//echo  'QtEst'.$reg_estoq[0].'CE'.$reg_custo[0].'CO'.$valor_produto;
				$custo = ($reg_estoq[0] * $reg_custo[0]) + $valor_produto;
				$custo_unitario = $custo/($reg_estoq[0]+$qtd);
				$custo_semImp = ($valor_sem_imposto/$qtd);
				$custo_reposicao = ($valor_produto/$qtd);
				if ($valor_produto>0){
					if (Zathura() ){
						$custo_unitario = $custo_reposicao;
						$custo = ($reg_estoq[0] * $custo_unitario) + $valor_produto;
					}
				}

				if ($custo_reposicao<=0){
					$custo_reposicao = $reg_estoq[1];
				}
				if ($custo_semImp<=0){
					$custo_semImp = $reg_estoq[2];
				}
				//custo referencial
				$custo_referencial =  $custo_reposicao;
				if (($nf_nr > 0) && ($cfop_financ != 'N')){
					if ($reg_estoq[1] > 0){
						$custo_referencial = $reg_estoq[1];
						if (($custo_reposicao > 0) && ($reg_estoq[0] > 0)){
							$custo_referencial = (($custo_reposicao + $reg_estoq[1]) / 2);
						}
					}
				}else{  //se for alterao de saldo s pega do cadastro
					$custo_referencial = $reg_estoq[3];
				}
				//echo 'CU'.$custo_unitario.'CT'.$custo.'QtEnt'.$qtd;
				// custo geral para dominio 2 
				//insere no histrico do custo
				$con_insere='INSERT INTO produto_hist_custo '.
							'(Dominio, Empresa, Id_Produto, '.
							' DH_Custo, Preco_Custo, '.
							' Preco_Custo_Ult_Entrada, '.
							' Custo_Reposicao, Tipo, '.
							' Custo_SemImposto, Custo_Referencial '.
							' ,Custo_Geral, DH_Atualizacao3 '.
							' ) '.
							' VALUES ( '.
							' "'.$_SESSION['Dominio'].'", '.
							' "'.$emp.'", '.
							' "'.$id_produto.'", '.
							' now(), "'.$custo_unitario.'", '.
							' "'.$custo_reposicao.'", '.
							' 0, "E",'.
							' "'.$custo_semImp.'", '.
							' "'.$custo_referencial.'" '.
							' , Custo_Geral + ("'.$custo_geral.'") , now() '.
							')';
				consulta_sql($con_insere);
			}else{
				//////////////////////////////////////////////
				// ( quantidads <= 0 )
				// 	Geralmente so saidas 
				/////////////////////////////////////////////
				//consulta custo atual para usar na tabela
				$con_custo ='select Preco_Custo,DH_Custo, '.
							' Preco_Custo_Ult_Entrada, '.
							' Custo_SemImposto, Custo_Referencial, Custo_Geral from produto_hist_custo'.
							' where Dominio="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' and Id_Produto="'.$id_produto.'"'.
							' order by DH_Custo desc limit 1';
				$res_custo = consulta_sql($con_custo);
				$reg_custo = consulta_ler_linha($res_custo);
				consulta_limpa($res_custo);
				
				if ($reg_custo[0] <= 0){
					$con_estoq ='select max(Custo_Reposicao), '.
								' max(Custo_SemImposto),max(Custo_Referencial),max(Preco_Custo) from produto_saldo_filial'.
								' where Dominio ="'.$_SESSION['Dominio'].'"'.
								' and Codigo_Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' and Id_Produto="'.$id_produto.'"';
					$res_estoq = consulta_sql($con_estoq);
					$reg_estoq = consulta_ler_linha($res_estoq);
					consulta_limpa($res_estoq);
					if ($reg_custo[0]<=0){
						$reg_custo[0] = $reg_estoq[3];
					}
					if ($reg_custo[3]<=0){
						$reg_custo[3] = $reg_estoq[1];
					}
					if ($reg_custo[2]<=0){
						$reg_custo[2] = $reg_estoq[0];
					}
					if ($reg_custo[4]<=0){
						$reg_custo[4] = $reg_estoq[2];
					}
				}
				$custo_unitario = $reg_custo[0];
				$data_custo = $reg_custo[1];
				$custo_semImp = $reg_custo[3];
				$custo_reposicao = $reg_custo[2];
				$custo_referencial = $reg_custo[4];
			}
			//atualiza custo total do produto
			$udt_saldo_pro ='Update produto set '.
							' Estoque_Atual  = Estoque_Atual  + ("'.$qtd.'") '.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Id_Produto="'.$id_produto.'"';
			consulta_sql($udt_saldo_pro,true,1);
			//consulta_ler_linha($res_estoq);
			$udt_saldo_pro ='Update produto_cod_barras set '.
							' Saldo_Atual  = Saldo_Atual + ("'.$qtd.'") '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$id_produto.'" '.
							' and Codigo_Barras = "'.$barra.'"';
			consulta_sql($udt_saldo_pro,true,1);
			if ($qtd > 0){
				$op = 'E';
			}else{
				$op = 'S';
			}
			//insere registro no movimento de estoque
			$usuario = base64_decode_si($_REQUEST['USER_ID']);
			$con_insere='INSERT INTO movimento_estoque '.
						'(id, Dominio, Empresa, Data_Mov, '.
						' Data_Estoque, Usuario, Id_Produto, '.
						' Codigo_Barras, Quantidade, Proprietario, '.
						' Local_Armaz, Operacao, Modelo_Doc, '.
						' Nr_Nota, Seq_Item, Serie, NrDoc, '.
						' Observacao, NrLote, Nr_Serie, Nr_Atestado, '.
						' DT_Fabricacao, DT_Validade, Germinacao, '.
						' Pureza, Preco_Custo, DH_Custo, Peneira) VALUES ( '.
						' "", "'.$_SESSION['Dominio'].'", '.
						' "'.$emp.'", '.
						' now(), "'.datad(dataf($data)).'", '.
						' "'.$usuario.'", "'.$id_produto.'", '.
						' "'.$barra.'", "'.$qtd.'", '.
						' "'.$proprietario.'", "'.$local.'", '.
						' "'.$op.'", "'.$nf_modelo.'", '.
						' "'.$nf_doc.'", "'.$nf_item.'", '.
						' "'.$nf_serie.'", "'.$nf_nr.'", '.
						' "'.$obs.'", "'.$lote.'", "'.$serie.'", '.
						' "'.$atestado.'", "'.$dt_fab.'", "'.$dt_val.'", '.
						' "'.$pureza.'", "'.$germinacao.'", '.
						' "'.$custo_unitario.'", "'.$data_custo.'",'.
						' "'.$peneira.'")';
			consulta_sql($con_insere);
			// Se foi um cupom
			//if($nf_modelo == '2D'){
			//   calcularSaldoProdutoVendaDia($id_produto, datad(dataf($data)), ($qtd * -1));
			//}

			//Para descobrir o movimento que ocorreu  e encaminhar o valor para o estoque_filial
			$con_notaMov =	'SELECT CFOP_Mov_Estoque , Valor_Agregado, ICMSST_Valor ,  IPI_Valor FROM nota_fiscal_item'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa= "'.$emp.'" '.
							' AND Nr_Nota = "'.$nf_doc.'" '.  //Campo Nr_Nota vem com o nome NF_DOC
							' AND Id_Produto = "'.$id_produto.'"'. 
							' AND Barra_Produto= "'.$barra.'" '.							
							' ';
			//	echo '<BR> '.$con_notaMov ;
			$res_notaMov = consulta_sql($con_notaMov );
			$reg_notaMov = consulta_ler_linha($res_notaMov );
			consulta_limpa($res_notaMov );

			if($reg_notaMov[0] == "D"){
				$valor_movimentado = (( $reg_notaMov[1] + $reg_notaMov[2] + $reg_notaMov[3]) *(-1));
				// echo '<BR>$valor_movimentado '. $valor_movimentado; 
				// echo '<BR>$reg_notaMov[1] '. $reg_notaMov[1]; 
				// echo '<BR>$reg_notaMov[2] '. $reg_notaMov[2]; 
				// echo '<BR>$reg_notaMov[3] '. $reg_notaMov[3]; 
				// //echo '<BR>$reg_notaMov[1] '. $reg_notaMov[1]; 

				//exit();
			}
			if($reg_notaMov[0] == "A"){
				$valor_movimentado = ( $reg_notaMov[1] + $reg_notaMov[2] + $reg_notaMov[3] );
				// //
				// echo '<BR>$valor_movimentado '. $valor_movimentado; 
				// echo '<BR> <BR>'; 

				// echo '<BR>$valor_movimentado '. $valor_movimentado; 
				// echo '<BR>$reg_notaMov[1] '. $reg_notaMov[1]; 
				// echo '<BR>$reg_notaMov[2] '. $reg_notaMov[2]; 
				// echo '<BR>$reg_notaMov[3] '. $reg_notaMov[3]; 
				// //echo '<BR>$reg_notaMov[1] '. $reg_notaMov[1]; 

				// //exit();
				//exit();
			}	
			
			$est2 = ($nf_modelo!='2D');
			estoque_filial($emp,
							$id_produto,
							$local,
							$qtd,
							$data_custo,
							datad(dataf($data)),
							$custo_unitario,$barra,
							$custo_reposicao,
							$custo_semImp,
							$custo_referencial,
							$est2,
							($valor_produto>0), $valor_movimentado );
							 
			if ((trim($lote)!='')||(trim($peneira)!='')){
				saldo_filial_lote($emp, $id_produto, $local,
									$qtd, $dt_fab, $dt_val, 0, $lote,
									$germinacao, $pureza, $atestado, '',
									$acerto,$peneira);
			}
		}
		local_atualiza_custo($emp,$id_produto);
	}

	function calcularSaldoProdutoVendaDia($idProduto, $data, $qtd){
		if ($qtd != 0){
			$updateVendaDia='UPDATE produto_saldo_venda_dia SET '.
							' Quantidade = (Quantidade + ("'.$qtd.'")) '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND Id_Produto = "'.$idProduto.'" '.
							' AND DT_Emissao = "'.$data.'" ';
			$resVendaDia = consulta_sql($updateVendaDia, true, 1);
			// Se no afetou nenhum registro, insere
			if ($resVendaDia == 0){
				$insertVendaDia='INSERT INTO produto_saldo_venda_dia ( '.
								' Dominio, '.
								' Id_Produto, '.
								' DT_Emissao, '.
								' Quantidade '.
								' ) VALUES ( '.
								' "'.$_SESSION['Dominio'].'", '.
								' "'.$idProduto.'", '.
								' "'.$data.'", '.
								' "'.$qtd.'" '.
								' )';
				consulta_sql($insertVendaDia);
			}
		}
	}

	function gera_mov_estoque_lote($id_produto,$data,
									$qtd,$local,$empresa,
									$lote,$peneira,$dt_fab,$dt_val,
									$germinacao,$pureza,$atestado){
		$upt_lote = 'Insert Into produto_saldo_filial_lote '.
					' ( '.
					' Dominio, '.
					' Id_Produto, '.
					' Codigo_Empresa, '.
					' Local_Armaz, '.
					' NrLote, '.
					' Peneira, '.
					' DH_Lote, '.
					' DT_Fabricacao, '.
					' DT_Validade, '.
					' Germinacao, '.
					' Pureza, '.
					' Nr_Atestato '.
					')'.
					' values '.
					'( '.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$id_produto.'", '.
					' "'.$empresa.'", '.
					' "'.$local.'", '.
					' "'.$lote.'", '.
					' "'.$peneira.'", '.
					' now(), '.
					' "'.$dt_fab.'", '.
					' "'.$dt_val.'", '.
					' "'.$germinacao.'", '.
					' "'.$pureza.'", '.
					' "'.$atestado.'" '.
					' )';
		consulta_sql($upt_lote);
		$upt_lote = 'Update produto_saldo_filial_lote set '.
					' Saldo_Atual = "'.$qtd.'",'.
					' Germinacao = "'.$germinacao.'",'.
					' Pureza = "'.$pureza.'",'.
					' DT_Fabricacao = "'.$dt_fab.'", '.
					' DT_Validade = "'.$dt_val.'", '.
					' Nr_Atestato = "'.$atestado.'"'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Id_Produto = "'.$id_produto.'"'.
					' and Local_Armaz = "'.$local.'"'.
					' and NrLote = "'.$lote.'"'.
					' and Peneira = "'.$peneira.'"';
		consulta_sql($upt_lote);
		//atualiza peneria
		if ($peneira!=''){
			//deleta todas as peneiras pra esse produto
			$del_peneira =	'delete from produto_saldo_filial_peneira '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Empresa = "'.$empresa.'"'.
							' and Id_Produto = "'.$id_produto.'"'.
							' and Local_Armaz = "'.$local.'"';//.
							//' and Peneira = "'.$peneira.'"';
			consulta_sql($del_peneira);
			//coloca todas as peneiraz de forma agrupada
			$upt_lote = 'Insert Into produto_saldo_filial_peneira '.
						'(Dominio, '.
						' Id_Produto, '.
						' Codigo_Empresa, '.
						' Local_Armaz, '.
						' Peneira, '.
						' Saldo_Atual, '.
						' DH_Peneira )'.
						' select '.
						' Dominio, '.
						' Id_Produto, '.
						' Codigo_Empresa, '.
						' Local_Armaz, '.
						' Peneira, '.
						' sum(Saldo_Atual), '.
						' max(DH_Lote) from produto_saldo_filial_lote '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'"'.
						' and Local_Armaz = "'.$local.'"'.
						' and Peneira <> ""'.
						' group by Peneira';
			consulta_sql($upt_lote);
		}
	}

	function gera_mov_estoque_barra($id_produto,$data,
									$qtd,$local,$empresa,
									$barra){
		//consulta custo atual para usar na tabela
		$con_custo ='SELECT Preco_Custo FROM produto_hist_custo '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Id_Produto = "'.$id_produto.'"'.
					' ORDER BY DH_Custo DESC '.
					' LIMIT 1';
		$res_custo = consulta_sql($con_custo);
		$reg_custo = consulta_ler_linha($res_custo);
		consulta_limpa($res_custo);
		$custo_unitario = isset($reg_custo) ? $reg_custo[0] : 0;
		$upt_barra ='Insert Into produto_saldo_filial_barra '.
					' ( '.
					' Dominio, '.
					' Id_Produto, '.
					' Codigo_Empresa, '.
					' Local_Armaz, '.
					' Codigo_Barras, '.
					' DH_Custo, '.
					' Preco_Custo, '.
					' Data_Mov '.
					')'.
					' values '.
					'( '.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$id_produto.'", '.
					' "'.$empresa.'", '.
					' "'.$local.'", '.
					' "'.$barra.'", '.
					' now(), '.
					' "'.$custo_unitario.'", '.
					' now() '.
					' )';
		consulta_sql($upt_barra);
		$upt_barra ='Update produto_saldo_filial_barra set '.
					' Saldo_Atual = "'.$qtd.'"'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Id_Produto = "'.$id_produto.'"'.
					' and Local_Armaz = "'.$local.'"'.
					' and Codigo_Barras = "'.$barra.'"';
		$res_barra = consulta_sql($upt_barra,true,1);
		if ($res_barra>0){
			$con_estoq = 'SELECT IFNULL(SUM(Saldo_Atual), 0) FROM produto_saldo_filial_barra '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Codigo_Barras = "'.$barra.'"';
			$res_estoq = consulta_sql($con_estoq);
			$reg_estoq = consulta_ler_linha($res_estoq);
			consulta_limpa($res_estoq);
			$upt_codbarra = 'Update produto_cod_barras set '.
							' Saldo_Atual = "'.$reg_estoq[0].'"'.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$id_produto.'"'.
							' and Codigo_Barras = "'.$barra.'"';
			consulta_sql($upt_codbarra);
		}
	}

	function estoque_filial($empresa, $id_produto, $local,
							$qtd, $dt_custo, $dt_movto, $preco,
							$barra='',
							$valor_reposicao=0,
							$valor_sem_imposto=0,
							$custo_referencial=0,
							$est2=true,$compra=true, $custo_geral=0){
		$con_saldo ='INSERT INTO produto_saldo_filial '.
					'(Dominio,  Id_Produto,  Codigo_Empresa, '.
					' Local_Armaz )'.
					' VALUES ( '.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$id_produto.'", '.
					' "'.$empresa.'", '.
					' "'.$local.'" ) ';
		consulta_sql($con_saldo);
		if ($est2){
			$dh2 = ' DH_Atualizacao2 = now(), ';
		}else{
			$dh2 = '';
		}
		
		/** Teste para o Dominio 2 usando o Dominio 214 em 25/04/2022 por @isabel */
		$custoHora= ' Custo_Geral= Custo_Geral + ("'.$custo_geral.'"), DH_Atualizacao3 = now(),  ';
		
		
		$udt_saldo ='Update produto_saldo_filial set '.
					' Saldo_Atual = Saldo_Atual + ("'.$qtd.'"), '.
					' DH_Custo = "'.$dt_custo.'", '.
					' Preco_Custo = "'.$preco.'", '.
					' Data_Mov = "'.$dt_movto.'", '.
					' Custo_Reposicao="'.$valor_reposicao.'", '.
					' Custo_SemImposto="'.$valor_sem_imposto.'", '.
					' Custo_Referencial="'.$custo_referencial.'", '.
					$dh2. 
					$custoHora.
					' DH_Atualizacao = now() '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Id_Produto = "'.$id_produto.'" '.
					' and Local_Armaz = "'.$local.'"';
		//echo  '<BR> '. $udt_saldo ; 
		//exit();
		$res_updt = consulta_sql($udt_saldo,true,1);
		/* Na modificado de 05/08/2021 feita por @mauricio , esta assim:
		if (($_SESSION['Dominio']==386)&&($valor_reposicao>0)&&($qtd>0)&&($compra)){
			ou
		if (($_SESSION['Dominio']==333)&&($custo_reposicao>0)&&($qtd>0)&&($compra)){
		*/
		$nf_atualiza_compra = BuscaParam('NF_ATUALIZA_COMPRA');
		if (($_SESSION['Dominio']==333)&&($valor_reposicao>0)&&($qtd>0)&&($compra)){
			$udt_p ='Update produto set '.
					' Preco_Compra = "'.$valor_reposicao.'" '.
					/* Na modificado de 05/08/2021 feita por @mauricio , esta assim:
						' Preco_Compra = "'.$custo_reposicao.'" '.	
					*/
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" ';
			$res_p = consulta_sql($udt_p,true,1);
			$udt_p ='Update produto set '.
					' Preco_Venda1 = round((Preco_Compra/(1-Preco_Venda1_Perc/100))*10)/10 '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" '.
					' and Preco_Compra>0'.
					' and Preco_Venda1_Perc>0'.
					' and Preco_Venda1_Perc<100';
			$res_p = consulta_sql($udt_p,true,1);
			$udt_p ='Update produto set '.
					' Preco_Venda2 = round((Preco_Compra/(1-Preco_Venda2_Perc/100))*10)/10 '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" '.
					' and Preco_Compra>0'.
					' and Preco_Venda2_Perc>0'.
					' and Preco_Venda2_Perc<100';
			$res_p = consulta_sql($udt_p,true,1);
			$udt_p ='Update produto set '.
					' Preco_Venda3 = ROUND((Preco_Compra/(1-Preco_Venda3_Perc/100))*10)/10 '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" '.
					' and Preco_Compra>0'.
					' and Preco_Venda3_Perc>0'.
					' and Preco_Venda3_Perc<100';
			$res_p = consulta_sql($udt_p,true,1);
			$udt_p ='UPDATE produto SET '.
					' Preco_Venda4 = ROUND((Preco_Compra /(1 - Preco_Venda4_Perc / 100)) * 10) / 10 '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Produto = "'.$id_produto.'" '.
					' AND Preco_Compra > 0'.
					' AND Preco_Venda4_Perc > 0'.
					' AND Preco_Venda4_Perc < 100';
			$res_p = consulta_sql($udt_p,true,1);
			$udt_p ='UPDATE produto SET '.
					' Preco_Venda5 = ROUND((Preco_Compra/(1-Preco_Venda5_Perc/100))*10)/10 '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Produto = "'.$id_produto.'" '.
					' AND Preco_Compra > 0'.
					' AND Preco_Venda5_Perc > 0'.
					' AND Preco_Venda5_Perc < 100';
			$res_p = consulta_sql($udt_p,true,1);
		}else if (($nf_atualiza_compra == 'S')&&($valor_reposicao>0)&&($qtd>0)&&($compra)){
			/**Modificacao realizada em  10/05/2022 para 392 por @isabel e @mauricio  */
			/** O valor de compra no iremos mudar j esta fazendo corretamente */
			$udt_p ='Update produto set '.
					' Preco_Compra = "'.$valor_reposicao.'" '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" ';
			$res_p = consulta_sql($udt_p,true,1);

			/** A partir do produto descobrir se o reajuste esta ativado e quais os percentuais  */
			$con_inf_prod ='SELECT Preco_Compra, '. 
							' Reajuste_Automatico_Precos, '.
							' Preco_Venda1_Perc, '.
							' Preco_Venda2_Perc, '.
							' Preco_Venda3_Perc, '.
							' Preco_Venda4_Perc, '.
							' Preco_Venda5_Perc '.							
							' FROM produto '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.							
							' AND Id_Produto = "'.$id_produto.'"  ';
			$res_inf_prod = consulta_sql($con_inf_prod);
			$reg_inf_prod = consulta_ler_linha($res_inf_prod);
			consulta_limpa($res_inf_prod);
			if( $reg_inf_prod[1]== 'S'){
				$udt_p ='Update produto set '.
						' Preco_Venda1 = round((Preco_Compra+(Preco_Compra*Preco_Venda1_Perc/100))*100)/100 '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Preco_Compra>0'.
						' and Preco_Venda1_Perc>0'.
						' and Preco_Venda1_Perc<1000';
				$res_p = consulta_sql($udt_p,true,1);				
				
				
				$udt_p ='Update produto set '.
						' Preco_Venda2 = round((Preco_Compra+(Preco_Compra*Preco_Venda2_Perc/100))*100)/100 '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Preco_Compra>0'.
						' and Preco_Venda2_Perc>0'.
						' and Preco_Venda2_Perc<1000';
				$res_p = consulta_sql($udt_p,true,1);
				$udt_p ='Update produto set '.
						' Preco_Venda3 = round((Preco_Compra+(Preco_Compra*Preco_Venda3_Perc/100))*100)/100 '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Preco_Compra>0'.
						' and Preco_Venda3_Perc>0'.
						' and Preco_Venda3_Perc<1000';
				$res_p = consulta_sql($udt_p,true,1);
				$udt_p ='UPDATE produto SET '.
						' Preco_Venda4 = round((Preco_Compra+(Preco_Compra*Preco_Venda4_Perc/100))*100)/100 '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$id_produto.'" '.
						' AND Preco_Compra > 0'.
						' AND Preco_Venda4_Perc > 0'.
						' AND Preco_Venda4_Perc < 1000';
				$res_p = consulta_sql($udt_p,true,1);
				$udt_p ='UPDATE produto SET '.
						' Preco_Venda5 = round((Preco_Compra+(Preco_Compra*Preco_Venda5_Perc/100))*100)/100 '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$id_produto.'" '.
						' AND Preco_Compra > 0'.
						' AND Preco_Venda5_Perc > 0'.
						' AND Preco_Venda5_Perc < 1000';
				$res_p = consulta_sql($udt_p,true,1);
			}
		}
		
		if (($_SESSION['Dominio']==386)&&($valor_reposicao>0)&&($qtd>0)&&($compra)){
			$udt_p ='Update produto set '.
					' Preco_Compra = "'.$valor_reposicao.'" '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Id_Produto = "'.$id_produto.'" ';
			$res_p = consulta_sql($udt_p,true,1);
		}
		//Fazer um update no saldo_filial_mes
		// nos campos: saldo_atual, DH_Custo, Data_Mov, Preco_Custo, Entrada ou Saida
		//se for saida multiplica - 1 e salva positivo
		$ano = substr($dt_movto,0,4);
		$mes = substr($dt_movto,5,2);
		$ano_mes = $ano.$mes;
		if ($qtd<0){
			$campoes = ', Saidas = Saidas + '.($qtd*(-1));
						
		}else{
			$campoes = ', Entradas  = Entradas  + '.$qtd;
		}
		/** Teste para o Dominio 2 usando o Dominio 214 em 25/04/2022 por @isabel */
		$custoHora2= ' , Custo_Geral= Custo_Geral + ("'.$custo_geral.'"), DH_Atualizacao3 = now()  ';
		$udt_saldo_mes ='Update produto_saldo_filial_mes set '.
						' Saldo_Atual = Saldo_Atual + ("'.$qtd.'"), '.
						' DH_Custo = "'.$dt_custo.'", '.
						' Preco_Custo = "'.$preco.'", '.
						' Data_Mov = "'.$dt_movto.'" '.
						$custoHora2.
						$campoes. 
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Local_Armaz = "'.$local.'"'.
						' and AnoMes = "'.$ano_mes.'"';

		//echo '<br> '.$udt_saldo_mes ;
		$res_updt_mes = consulta_sql($udt_saldo_mes,true,1);
		//se n afetou o registro
		if (!$res_updt_mes){
			//consulta * order by ano_mes desc limit 1
			$con_saldo_mes ='select Saldo_Atual, '.
							' DH_Custo, '.
							' Data_Mov, '.
							' Preco_Custo, '.
							' Custo_Geral '.
							' from produto_saldo_filial_mes '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Empresa = "'.$empresa.'"'.
							' and Id_Produto = "'.$id_produto.'" '.
							' and Local_Armaz = "'.$local.'"'.
							' and AnoMes < "'.$ano_mes.'" order by AnoMes DESC Limit 1 ';
			$res_saldo_mes = consulta_sql($con_saldo_mes);
			$reg_saldo_mes = consulta_ler_linha($res_saldo_mes);
			consulta_limpa($res_saldo_mes);
			$ins_saldo_mes ='INSERT into produto_saldo_filial_mes '.
							' ( Dominio, '.
							' Id_Produto, '.
							' Codigo_Empresa, '.
							' Local_Armaz, '.
							' AnoMes, '.
							' Saldo_Atual, '.
							' DH_Custo, '.
							' Data_Mov, '.
							' Preco_Custo, '.
							' Saldo_Anterior, '.
							' Custo_Geral '.
							' ) '.
							' values '.
							' ( "'.$_SESSION['Dominio'].'", '.
							' "'.$id_produto.'", '.
							' "'.$empresa.'", '.
							' "'.$local.'", '.
							' "'.$ano_mes.'", '.
							' "'.$reg_saldo_mes[0].'", './/Saldo Atual
							' "'.$reg_saldo_mes[1].'", './/DH Custo
							' "'.$reg_saldo_mes[2].'", './/DT_MOV
							' "'.$reg_saldo_mes[3].'", './/Preco Custo
							' "'.$reg_saldo_mes[0].'", './/Saldo Ant
							' "'.$reg_saldo_mes[4].'" '. //Custo Geral  para Dominio  2 add em  27/04/2022 por @isabel
							' )';
			//echo '<br> '. $ins_saldo_mes ;
			$con_saldo_mes = consulta_sql($ins_saldo_mes);
			$res_updt_mes = consulta_sql($udt_saldo_mes,true,1);
		}
		$custoGeral2= ' , Custo_Geral= Custo_Geral + ("'.$custo_geral.'"), DH_Atualizacao3 = now()  ';
		
		$udt_saldo_mes ='Update produto_saldo_filial_mes set '.
						' Saldo_Atual = Saldo_Atual + ("'.$qtd.'"), '.
						' Saldo_Anterior = Saldo_Anterior + ("'.$qtd.'") '.
						$custoGeral2.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Local_Armaz = "'.$local.'"'.
						' and AnoMes > "'.$ano_mes.'"';
		$res_updt_mes = consulta_sql($udt_saldo_mes,true,1);
		if ($barra!=''){
			$con_saldo ='INSERT INTO produto_saldo_filial_barra '.
						'(Dominio,  Id_Produto,  Codigo_Empresa, '.
						' Local_Armaz, Codigo_Barras ) VALUES ( '.
						' "'.$_SESSION['Dominio'].'", '.
						' "'.$id_produto.'", '.
						' "'.$empresa.'", '.
						' "'.$local.'",'.
						' "'.$barra.'")';
			consulta_sql($con_saldo);
			/** Usando Domominio 214 para teste do Dominio  2 em  27/04/2022 por  @isabel */
			$custoGeral = ' ,Custo_Geral = Custo_Geral + "'.$custo_geral.'" ';
			

			$udt_saldo ='Update produto_saldo_filial_barra set '.
						' Saldo_Atual = Saldo_Atual + ("'.$qtd.'"), '.
						' DH_Custo = "'.$dt_custo.'", '.
						' Preco_Custo = "'.$preco.'", '.
						' Data_Mov = "'.$dt_movto.'" '.$custoGeral.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Local_Armaz = "'.$local.'"'.
						' and Codigo_Barras = "'.$barra.'"';
			$res_updt = consulta_sql($udt_saldo,true,1);
			//echo ' <br> quando tem o codigo de barra : '.$udt_saldo;
		}

		//exit();
	}

	function saldo_filial_lote($empresa, $id_produto, $local,
								$qtd, $dt_fabr, $dt_val, $preco, $nr_lote,
								$germinacao, $pureza, $nr_atestado, $obs,
								$acerto,$peneira){
		if ($acerto>0){
			$udt_saldo ='Update produto_saldo_filial_lote set '.
						' Saldo_Atual = 0 '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'" ';
			$res_updt = consulta_sql($udt_saldo,true,1);
			$qtd  = $acerto;
		}
		$con_saldo ='INSERT INTO produto_saldo_filial_lote '.
					'(Dominio,  '.
					' Id_Produto,  '.
					' Codigo_Empresa, '.
					' Local_Armaz, '.
					' NrLote, '.
					' Peneira )'.
					' VALUES ( '.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$id_produto.'", '.
					' "'.$empresa.'", '.
					' "'.$local.'", '.
					' "'.$nr_lote.'", '.
					' "'.$peneira.'" ) ';
		consulta_sql($con_saldo);
		$udt_saldo ='Update produto_saldo_filial_lote set '.
					' Saldo_Atual = Saldo_Atual + ("'.$qtd.'"), '.
					' DT_Fabricacao = "'.$dt_fabr.'", '.
					' DT_Validade = "'.$dt_val.'", '.
					' Preco_Maximo = "'.$preco.'", '.
					' Germinacao = "'.$germinacao.'",'.
					' Pureza = "'.$pureza.'",'.
					' Nr_Atestato = "'.$nr_atestado.'",'.
					' Observacao = "'.$obs.'"'.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Id_Produto = "'.$id_produto.'" '.
					' and Local_Armaz = "'.$local.'"'.
					' and NrLote = "'.$nr_lote.'"'.
					' and Peneira = "'.$peneira.'"';
		$res_updt = consulta_sql($udt_saldo,true,1);
		if ($qtd>0){
			$udt_saldo ='Update produto_saldo_filial_lote set '.
						' DH_Lote = now() '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'" '.
						' and Local_Armaz = "'.$local.'"'.
						' and NrLote = "'.$nr_lote.'"'.
						' and Peneira = "'.$peneira.'"';
			$res_updt = consulta_sql($udt_saldo,true,1);
		}
		if ($peneira!=''){
			//deleta todas as peneiras pra esse produto
			$del_peneira =	'delete from produto_saldo_filial_peneira '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Empresa = "'.$empresa.'"'.
							' and Id_Produto = "'.$id_produto.'"'.
							' and Local_Armaz = "'.$local.'"';//.
							//' and Peneira = "'.$peneira.'"';
			consulta_sql($del_peneira);
			//coloca todas as peneiraz de forma agrupada
			$upt_lote = 'Insert Into produto_saldo_filial_peneira '.
						'(Dominio, '.
						' Id_Produto, '.
						' Codigo_Empresa, '.
						' Local_Armaz, '.
						' Peneira, '.
						' Saldo_Atual, '.
						' DH_Peneira )'.
						' select '.
						' Dominio, '.
						' Id_Produto, '.
						' Codigo_Empresa, '.
						' Local_Armaz, '.
						' Peneira, '.
						' sum(Saldo_Atual), '.
						' max(DH_Lote) from produto_saldo_filial_lote '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Id_Produto = "'.$id_produto.'"'.
						' and Local_Armaz = "'.$local.'"'.
						' and Peneira <> ""'.
						' group by Peneira';
			consulta_sql($upt_lote);
		}
	}
	
	function recalcula_estoque_fisico($produto_anterior,$produto_atual,$data_inicio,$empresa=0){
		//reecalcula estoque fisico dos dois produtos desde o inicio do perodo at hoje
		$depar_anterior = 0;
		$grupo_anterior = 0;
		$linha_anterior = 0;
		$depar_atual = 0;
		$grupo_atual = 0;
		$linha_atual = 0;
		//verifica se os produtos sa diferentes
		if ($produto_anterior!=$produto_atual){
			if($produto_anterior > 0){
				//consulta cadastro de produto para saber o departamento e grupo
				$con_produto =	'select Codigo_Depart, Codigo_Grupo, Codigo_Linha from produto'.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto="'.$produto_anterior.'"';
				$res_produto = consulta_sql($con_produto);
				$reg_produto = consulta_ler_linha($res_produto);
				consulta_limpa($res_produto);
				$depar_anterior = $reg_produto[0];
				$grupo_anterior = $reg_produto[1];
				$linha_anterior = $reg_produto[2];
			}
		}
		if ($produto_atual > 0){
			//consulta cadastro de produto para saber o departamento e grupo
			$con_produto = 'select Codigo_Depart,Codigo_Grupo, Codigo_Linha from produto'.
			' where Dominio = "'.$_SESSION['Dominio'].'"'.
			' and Id_Produto="'.$produto_atual.'"';
			$res_produto = consulta_sql($con_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);
			$depar_atual = $reg_produto[0];
			$grupo_atual = $reg_produto[1];
			$linha_atual = $reg_produto[2];
		}
		if (($depar_anterior >0) &&
			($grupo_anterior >0)){
			//if(($depar_anterior != $depar_atual) ||
			//    ($grupo_anterior != $grupo_atual)){
			//     recalcula_estoque_fisico_grupo($depar_anterior,$grupo_anterior,$data_inicio);
			//}
			if (($depar_anterior != $depar_atual) ||
				($grupo_anterior != $grupo_atual)||
				($linha_anterior != $linha_atual)){
				recalcula_estoque_fisico_linha($depar_anterior,$grupo_anterior,$linha_anterior,$data_inicio,$empresa);
			}
		}
		if (($depar_atual >0) &&
			($grupo_atual >0)){
			//recalcula_estoque_fisico_grupo($depar_atual,$grupo_atual,$data_inicio);
			recalcula_estoque_fisico_linha($depar_atual,$grupo_atual,$linha_atual,$data_inicio,$empresa);
		}
	}

	function recalcula_estoque_fisico_linha($depart, $grupo, $linha, $data_inicio, $empresa = 0){
		$data_inicio = datad(dataf($data_inicio));
		if ($empresa == 0){
			$empresa = $_SESSION["Empresa_Codigo"];
		}
		$filtro = '';
		//faz consulta pra saber a lista de produtos que tem esse depart/grupo
		$con_produto =	'SELECT Id_Produto FROM produto'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Codigo_Depart = "'.$depart.'" '.
						' AND Codigo_Grupo = "'.$grupo.'"'.
						' AND Codigo_Linha = "'.$linha.'" ';
		$res_produto = consulta_sql($con_produto);
		$nrw_produto = consulta_num_registros($res_produto);
		for($p=0;$p<$nrw_produto;$p++){
			$reg_produto = consulta_ler_linha($res_produto);
			//salva lista em array pra futura comparao do cdigo (id) que est no boletim
			if ($filtro!=''){
				$filtro.=' or ';
			}
			$filtro.=' (Id_Produto="'.$reg_produto[0].'") ';
		}
		consulta_limpa($res_produto);
		if ($filtro!=''){
			$filtro = ' and ('.$filtro.')';
		}else{
			$filtro.=' and (Id_Produto=0) ';
		}
		//verica que tipo de peso soma na tabela
		$TPE = 'PesoPago';
		$TPS = 'PesoLiquido';
		$con_grupo ='SELECT EstoqueFisico FROM produto_grupo '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Codigo_Depart = "'.$depart.'" '.
					' AND Codigo_Grupo = "'.$grupo.'"';
		$res_grupo = consulta_sql($con_grupo);
		$reg_grupo = consulta_ler_linha($res_grupo);
		consulta_limpa($res_grupo);
		while (strlen($reg_grupo[0]) < 3){
			$reg_grupo[0].=' ';
		}
		if($reg_grupo[0][1]=='L'){
			$TPE = 'PesoLiquido';
		}
		if ($reg_grupo[0][2]=='P'){
			$TPS = 'PesoPago';
		}
		//consulta todos os boletins do dia
		//consulta totais de entradas
		$con_ent =	'SELECT '.
					' IFNULL(SUM('.$TPE.'), 0), '.
					' IFNULL(SUM(PesoLiquido), 0), '.
					' IFNULL(SUM(PesoLiquido-PesoPago), 0), '.
					' IFNULL(SUM(Umidade_Desc), 0), '.
					' IFNULL(SUM(Impureza_Desc), 0), '.
					' IFNULL(SUM(Avariado_Desc), 0), '.
					' IFNULL(SUM(Quebrado_Desc), 0), '.
					' IFNULL(SUM(Triguilho_Desc), 0), '.
					' IFNULL(SUM(Germinacao_Desc), 0), '.
					' IFNULL(SUM(pH_Desc), 0), '.
					' IFNULL(SUM(Transgenico_Desc), 0) '.
					' FROM boletim_pesagem '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'" '.
					' AND Tipo="0" AND ( (Situacao="P") OR (Situacao="F")) '.
					' AND DH_Abertura>="'.$data_inicio.' 00:00:00" '.
					' AND DH_Abertura<="'.$data_inicio.' 23:59:59" '.$filtro;
		$res_ent = consulta_sql($con_ent);
		$reg_ent = consulta_ler_linha($res_ent);
		consulta_limpa($res_ent);
		//consulta totais de saidas
		$con_sai =	'SELECT IFNULL(SUM('.$TPS.'), 0) '.
					' FROM boletim_pesagem '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa="'.$empresa.'" '.
					' AND Tipo="1" AND ( (Situacao="P") OR (Situacao="F")) '.
					' AND DH_Abertura>="'.$data_inicio.' 00:00:00" '.
					' AND DH_Abertura<="'.$data_inicio.' 23:59:59" '.$filtro;
		$res_sai = consulta_sql($con_sai);
		$reg_sai = consulta_ler_linha($res_sai);
		consulta_limpa($res_sai);
		//consulta saldo anterior
		$con_saldo ='SELECT Saldo_Final, Acertos FROM produto_linha_estoque_fisico '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Codigo_Empresa = "'.$empresa.'" '.
					' AND Codigo_Depart = "'.$depart.'"'.
					' AND Codigo_Grupo = "'.$grupo.'"'.
					' AND Codigo_Linha = "'.$linha.'"'.
					' AND Data_Mov < "'.$data_inicio.'"'.
					' ORDER BY Data_Mov DESC '.
					' LIMIT 1';
		$res_saldo = consulta_sql($con_saldo);
		$reg_saldo = consulta_ler_linha($res_saldo);
		consulta_limpa($res_saldo);
		$saldoFinal = 0;
		$Acertos = 0;
		if (isset($reg_saldo)){
			$saldoFinal = $reg_saldo[0];
			$acertos = $reg_saldo[1];
		}
		//insere registro com saldo do dia anterior
		$con_ins =	'INSERT INTO produto_linha_estoque_fisico '.
					' (Dominio, Codigo_Empresa, Codigo_Depart, '.
					' Codigo_Grupo, Codigo_Linha, Data_Mov, Saldo_Anterior, '.
					' Saldo_Final) '.
					' VALUES ( '.
					' "'.$_SESSION['Dominio'].'", '.
					' "'.$empresa.'", '.
					' "'.$depart.'", '.
					' "'.$grupo.'", '.
					' "'.$linha.'", '.
					' "'.$data_inicio.'", '.
					' "'.$saldoFinal.'", '.
					' "'.$acertos.'" '.
					' )';
		consulta_sql($con_ins);
		//consulta saldo anterior
		$con_saldo ='select Saldo_Anterior, Acertos from produto_linha_estoque_fisico '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Codigo_Depart="'.$depart.'" '.
					' and Codigo_Grupo="'.$grupo.'"'.
					' and Codigo_Linha="'.$linha.'"'.
					' and Data_Mov = "'.$data_inicio.'"';
		$res_saldo = consulta_sql($con_saldo);
		$reg_saldo = consulta_ler_linha($res_saldo);
		consulta_limpa($res_saldo);
		$saldoAnterior = 0;
		$acertos = 0;
		if (isset($reg_saldo)){
			$saldoAnterior = $reg_saldo[0];
			$acertos = $reg_saldo[1];
		}
		$saldo_atual = round(($saldoAnterior + $reg_ent[0] + $acertos) - $reg_sai[0]);
		//faz update do total de entrada saidas descontos e no saldo final
		$con_upt =	'Update produto_linha_estoque_fisico set '.
					' Entradas="'.$reg_ent[0].'", '.
					' Saidas="'.$reg_sai[0].'", '.
					' Saldo_Final="'.$saldo_atual.'", '.
					' Entradas_Liquido="'.$reg_ent[1].'",'.
					' Entradas_Total_Desconto="'.$reg_ent[2].'",'.
					' Entradas_Umidade="'.$reg_ent[3].'",'.
					' Entradas_Impureza="'.$reg_ent[4].'",'.
					' Entradas_Avariado="'.$reg_ent[5].'",'.
					' Entradas_Quebrado="'.$reg_ent[6].'",'.
					' Entradas_Triguilho="'.$reg_ent[7].'",'.
					' Entradas_Germinacao="'.$reg_ent[8].'",'.
					' Entradas_Ph="'.$reg_ent[9].'",'.
					' Entradas_GMO="'.$reg_ent[10].'" '.
					' where Dominio="'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Codigo_Depart="'.$depart.'"'.
					' and Codigo_Grupo="'.$grupo.'"'.
					' and Codigo_Linha="'.$linha.'"'.
					' and Data_Mov="'.$data_inicio.'"';
		consulta_sql($con_upt);
		//verifica se tem registros posteriores a essa data
		$con_saldo ='select Data_Mov,Entradas,Saidas,Acertos from produto_linha_estoque_fisico '.
					' where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Codigo_Empresa = "'.$empresa.'"'.
					' and Codigo_Depart="'.$depart.'"'.
					' and Codigo_Grupo="'.$grupo.'"'.
					' and Codigo_Linha="'.$linha.'"'.
					' and Data_Mov>"'.$data_inicio.'"'.
					' order by Data_Mov';
		$res_saldo = consulta_sql($con_saldo);
		$nrw_saldo = consulta_num_registros($res_saldo);
		for($s=0;$s<$nrw_saldo;$s++){
			$reg_saldo = consulta_ler_linha($res_saldo);
			$saldo_anterior = $saldo_atual;
			$saldo_atual+= round( ($reg_saldo[1]+$reg_saldo[3]) - $reg_saldo[2] );
			///atualiza o saldo atual/final desses registros posteriores
			$con_upt =	'Update produto_linha_estoque_fisico set '.
						' Saldo_Anterior="'.$saldo_anterior.'", '.
						' Saldo_Final="'.$saldo_atual.'" '.
						' where Dominio="'.$_SESSION['Dominio'].'"'.
						' and Codigo_Empresa = "'.$empresa.'"'.
						' and Codigo_Depart="'.$depart.'"'.
						' and Codigo_Grupo="'.$grupo.'"'.
						' and Codigo_Linha="'.$linha.'"'.
						' and Data_Mov="'.$reg_saldo[0].'"';
			consulta_sql($con_upt);
		}
		consulta_limpa($res_saldo);
	}
	/*
	function recalcula_estoque_fisico_grupo($depart,$grupo,$data_inicio){
	$data_inicio = datad(dataf($data_inicio));

	$filtro='';
	//faz consulta pra saber a lista de produtos que tem esse depart/grupo
	$con_produto = 'select Id_Produto from produto'.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" '.
	' and Codigo_Grupo="'.$grupo.'"';
	$res_produto = consulta_sql($con_produto);
	$nrw_produto = consulta_num_registros($res_produto);
	for($p=0;$p<$nrw_produto;$p++){
	$reg_produto = consulta_ler_linha($res_produto);
	//salva lista em array pra futura comparao do cdigo (id) que est no boletim
	if($filtro!=''){
	$filtro.=' or ';
	}
	$filtro.=' (Id_Produto="'.$reg_produto[0].'") ';
	}
	consulta_limpa($res_produto);
	if($filtro!=''){
	$filtro = ' and ('.$filtro.')';
	}else{
	$filtro.=' and (Id_Produto=0) ';
	}


	//verica que tipo de peso soma na tabela
	$TPE = 'PesoPago';
	$TPS = 'PesoLiquido';

	$con_grupo = 'select EstoqueFisico from produto_grupo '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" '.
	' and Codigo_Grupo="'.$grupo.'"';
	$res_grupo = consulta_sql($con_grupo);
	$reg_grupo = consulta_ler_linha($res_grupo);
	consulta_limpa($res_grupo);

	while (strlen($reg_grupo[0]) < 3){
	$reg_grupo[0].=' ';
	}
	if($reg_grupo[0][1]=='L'){
	$TPE = 'PesoLiquido';
	}
	if($reg_grupo[0][2]=='P'){
	$TPS = 'PesoPago';
	}

	//consulta todos os boletins do dia

	//consulta totais de entradas
	$con_ent = 'select sum('.$TPE.'), '.
	' sum(PesoLiquido), '.
	' sum(PesoLiquido-PesoPago), '.
	' sum(Umidade_Desc), '.
	' sum(Impureza_Desc), '.
	' sum(Avariado_Desc), '.
	' sum(Quebrado_Desc), '.
	' sum(Triguilho_Desc), '.
	' sum(Germinacao_Desc), '.
	' sum(pH_Desc), '.
	' sum(Transgenico_Desc) '.
	' from boletim_pesagem '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
	' and Tipo="0" and Situacao<>"C"'.
	' and DH_Abertura>="'.$data_inicio.' 00:00:00" '.
	' and DH_Abertura<="'.$data_inicio.' 23:59:59" '.$filtro;
	$res_ent = consulta_sql($con_ent);
	$reg_ent = consulta_ler_linha($res_ent);
	consulta_limpa($res_ent);


	//consulta totais de saidas
	$con_sai = 'select sum('.$TPS.') '.
	' from boletim_pesagem '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
	' and Tipo="1" and Situacao<>"C"'.
	' and DH_Abertura>="'.$data_inicio.' 00:00:00" '.
	' and DH_Abertura<="'.$data_inicio.' 23:59:59" '.$filtro;
	$res_sai = consulta_sql($con_sai);
	$reg_sai = consulta_ler_linha($res_sai);
	consulta_limpa($res_sai);

	//consulta saldo anterior
	$con_saldo = 'select Saldo_Final,Acertos from produto_grupo_estoque_fisico '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" and Codigo_Grupo="'.$grupo.'"'.
	' and Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
	' and Data_Mov <"'.$data_inicio.'"'.
	' order by Data_Mov Desc limit 1';
	$res_saldo = consulta_sql($con_saldo);
	$reg_saldo = consulta_ler_linha($res_saldo);
	consulta_limpa($res_saldo);

	//insere registro com saldo do dia anterior
	$con_ins = 'INSERT INTO produto_grupo_estoque_fisico '.
	' (Dominio, Codigo_Empresa, Codigo_Depart, '.
	' Codigo_Grupo, Data_Mov, Saldo_Anterior, '.
	' Saldo_Final) '.
	' VALUES ("'.$_SESSION['Dominio'].'", '.
	' "'.$_SESSION["Empresa_Codigo"].'", '.
	' "'.$depart.'", "'.$grupo.'", '.
	' "'.$data_inicio.'", '.
	' "'.$reg_saldo[0].'", "'.$reg_saldo[0].'")';
	consulta_sql($con_ins);


	//consulta saldo anterior
	$con_saldo = 'select Saldo_Anterior, Acertos from produto_grupo_estoque_fisico '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" and Codigo_Grupo="'.$grupo.'"'.
	' and Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
	' and Data_Mov = "'.$data_inicio.'"';
	$res_saldo = consulta_sql($con_saldo);
	$reg_saldo = consulta_ler_linha($res_saldo);
	consulta_limpa($res_saldo);


	$saldo_atual = round(($reg_saldo[0]+$reg_ent[0]+$reg_saldo[1])-$reg_sai[0]);

	//faz update do total de entrada saidas descontos e no saldo final
	$con_upt = 'Update produto_grupo_estoque_fisico set '.
	' Entradas="'.$reg_ent[0].'", '.
	' Saidas="'.$reg_sai[0].'", '.
	' Saldo_Final="'.$saldo_atual.'", '.
	' Entradas_Liquido="'.$reg_ent[1].'",'.
	' Entradas_Total_Desconto="'.$reg_ent[2].'",'.
	' Entradas_Umidade="'.$reg_ent[3].'",'.
	' Entradas_Impureza="'.$reg_ent[4].'",'.
	' Entradas_Avariado="'.$reg_ent[5].'",'.
	' Entradas_Quebrado="'.$reg_ent[6].'",'.
	' Entradas_Triguilho="'.$reg_ent[7].'",'.
	' Entradas_Germinacao="'.$reg_ent[8].'",'.
	' Entradas_Ph="'.$reg_ent[9].'",'.
	' Entradas_GMO="'.$reg_ent[10].'" '.
	' where Dominio="'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" and Codigo_Grupo="'.$grupo.'"'.
	' and Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
	' and Data_Mov="'.$data_inicio.'"';
	consulta_sql($con_upt);

	//verifica se tem registros posteriores a essa data
	$con_saldo = 'select Data_Mov,Entradas,Saidas,Acertos from produto_grupo_estoque_fisico '.
	' where Dominio = "'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" and Codigo_Grupo="'.$grupo.'"'.
	' and Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
	' and Data_Mov>"'.$data_inicio.'"'.
	' order by Data_Mov';
	$res_saldo = consulta_sql($con_saldo);
	$nrw_saldo = consulta_num_registros($res_saldo);
	for($s=0;$s<$nrw_saldo;$s++){
	$reg_saldo = consulta_ler_linha($res_saldo);
	$saldo_anterior = $saldo_atual;
	$saldo_atual+= round( ($reg_saldo[1]+$reg_saldo[3]) - $reg_saldo[2] );
	///atualiza o saldo atual/final desses registros posteriores
	$con_upt = 'Update produto_grupo_estoque_fisico set '.
	' Saldo_Anterior="'.$saldo_anterior.'", '.
	' Saldo_Final="'.$saldo_atual.'" '.
	' where Dominio="'.$_SESSION['Dominio'].'"'.
	' and Codigo_Depart="'.$depart.'" and Codigo_Grupo="'.$grupo.'"'.
	' and Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
	' and Data_Mov="'.$reg_saldo[0].'"';
	consulta_sql($con_upt);
	}
	consulta_limpa($res_saldo);

	}
	*/

	function gera_ordem_producao($id_produto, $barra='', $qtdade, $data_producao,
								$tp_ordem, $subprod_id=0, $subprod_qtd=0,
								$fornec=0, $obs=''){
		$preco_custo = 0;
		$custo_fin = 0;
		$ordem_gerada = 0;
		//Verifica a maior nrordem j cadastrada para a empresa
		$cons_ordem='SELECT IFNULL(MAX(Nr_Ordem), 0) FROM ordem_producao '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"';
		$res_ordem = consulta_sql($cons_ordem);
		$reg_ordem = consulta_ler_linha($res_ordem);
		consulta_limpa($res_ordem);
		$nr_ordem = ($reg_ordem[0] + 1);
		$empresa = $_SESSION['Empresa_Codigo'];
		$usuario = UpperDados(base64_decode_si($_REQUEST['USER_ID']));
		$programada = ((BuscaParam('PRODUCAO_TIPO')=='P')||(BuscaParam('PRODUCAO_TIPO')=='A'));
		if ($tp_ordem=='D'){
			$programada = false;
		}
		if ($programada){ //produo programanda/agendada
			$situacao = 'G'; //agendado
		}else{
			$situacao = 'P'; //pronto
		}
		$ins_ordem ='INSERT INTO ordem_producao ('.
					' Dominio, Empresa, Nr_Ordem, Id_Produto, '.
					' Quantidade, DH_Ordem, Tipo, Usuario, '.
					' Situacao, Fornecedor, Observacao, Barra_Produto, '.
					' SubProduto_Id, SubProduto_Qtd, DT_Producao ) '.
					' VALUES ('.
					' "'.$_SESSION["Dominio"].'",'.
					' "'.$empresa.'",'.
					' "'.$nr_ordem.'",'.
					' "'.$id_produto.'",'.
					' "'.$qtdade.'",'.
					' now(),'.
					' "'.$tp_ordem.'",'.
					' "'.$usuario.'", '.
					' "'.$situacao.'", '.
					' "'.$fornec.'", '.
					' "'.$obs.'", '.
					' "'.$barra.'", '.
					' "'.$subprod_id.'", '.
					' "'.$subprod_qtd.'", '.
					' "'.$data_producao.'" '.
					')';
		$res_ordem = consulta_sql($ins_ordem,true,1);
		$local = 0;
		if ($res_ordem>0){
			$cons_comp ='select Id_Produto_Origem, Quantidade from produto_composicao '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and Id_Produto_Final = "'.$id_produto.'" '.
						' and Situacao = "A" ';
			$res_comp = consulta_sql($cons_comp);
			$nro_comp = consulta_num_registros($res_comp);
			$custo_fin = 0;
			if ($nro_comp>0){
				for($p=0;$p<$nro_comp;$p++){
					$reg_comp = consulta_ler_objeto($res_comp);
					$cons_prod ='SELECT Preco_Custo FROM produto_saldo_filial '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Id_Produto = "'.$reg_comp->Id_Produto_Origem.'" '.
								' AND Codigo_Empresa = "'.$empresa.'"'.
								' ORDER BY Local_Armaz ASC '.
								' LIMIT 1';
					$res_prod = consulta_sql($cons_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);
					$precoCusto = isset($reg_prod) ? $reg_prod[0] : 0;
					//$preco_custo+= ($reg_prod[0]*$reg_comp->Quantidade*$qtdade);
					//$custo_fin+= ($reg_prod[0]*$reg_comp->Quantidade);
					//$preco_custo = retorna_custo_produto($reg_comp->Id_Produto_Origem,$reg_comp->Quantidade);
					if ($tp_ordem == 'D'){
						$multiplicador = (1);
						$tipo = 'fechar_desmontagem';
						$preco_custo = 0;
					}else{
						$multiplicador = (-1);
						$preco_custo = ($precoCusto * $reg_comp->Quantidade);
						$custo_fin+= $preco_custo;
					}
					if ($programada){
					}else{
						gera_mov_estoque($reg_comp->Id_Produto_Origem,'', data_atual('date'),
										(($reg_comp->Quantidade*$qtdade)*$multiplicador), $local,
										$_SESSION['Empresa_Codigo'], 0,
										'', '', '', '', '', '', '', 'Movimento Estoque de Ordem de Produo');
					}
					$ins_item = 'INSERT INTO ordem_producao_item '.
								'(Dominio, Empresa, Nr_Ordem, Id_Produto, '.
								' Quantidade, Preco_Custo) '.
								' VALUES ('.
								' "'.$_SESSION["Dominio"].'",'.
								' "'.$empresa.'",'.
								' "'.($reg_ordem[0]+1).'", '.
								' "'.$reg_comp->Id_Produto_Origem.'",'.
								' "'.$reg_comp->Quantidade.'", '.
								' "'.$preco_custo.'")';
					$res_item = consulta_sql($ins_item,true,1);
				}
				$upt_ordem ='Update ordem_producao set '.
							' Preco_Custo = "'.$custo_fin.'"'.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' and Nr_Ordem = "'.($reg_ordem[0]+1).'"'.
							' and Id_Produto = "'.$id_produto.'"';
				$res_ordem = consulta_sql($upt_ordem);
				//gera_mov_estoque($produto,'', data_atual('date'),
				//                 $qtdade, 0, $_SESSION['Empresa_Codigo'], $preco_custo,
				//                 0, 0, 0, 0, 0, 0, 0, 'Movimento Estoque de Ordem de Produo');
			}
			consulta_limpa($res_comp);
		}
		$ordem_gerada = $nr_ordem;
		return $ordem_gerada;
	}

	function impostos_ecf($empresa){
		$tributos_ecf = array();
		$tributos_ecf[0] = 'I1';
		$con_ecf = 'SELECT Codigo_Tributo_Ecf, TributoECF FROM tributo_ecf';
		$res_ecf = consulta_sql($con_ecf);
		$nrw_ecf = consulta_num_registros($res_ecf);
		for($e=0;$e<$nrw_ecf;$e++){
			set_time_limit(60);
			$reg_ecf = consulta_ler_linha($res_ecf);
			$tributos_ecf[$reg_ecf[0]] = $reg_ecf[1];
			//echo $tributos_ecf[$reg_ecf[0]].'<BR>';
		}
		consulta_limpa($res_ecf);
		$impostos = array();
		$impostos[0] = 'I1';
		//$var_nota = variaveis_nota(0,0,$empresa);
		$con_tri = 'select Codigo_Classe_Tributo, Tipo from produto_classe_tributo'.
		' where Dominio = "'.$_SESSION['Dominio'].'"';
		$res_tri = consulta_sql($con_tri);
		$nrw_tri = consulta_num_registros($res_tri);
		for($c=0;$c<$nrw_tri;$c++){
			$reg_tri = consulta_ler_linha($res_tri);
			set_time_limit(60);
			$con_for = 'select * from produto_classe_tributo_formula '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Classe_Tributo="'.$reg_tri[0].'"'.
						' and Situacao<>"E"'.
						' order by Ordem, Seq_Formula';
			$res_for = consulta_sql($con_for);
			$nro_for = consulta_num_registros($res_for);
			$ok = false;
			for($f=0;$f<$nro_for;$f++){
				set_time_limit(60);
				$reg_for = consulta_ler_objeto($res_for);
				$ok = false;
				eval($reg_for->Formula);
				if ($ok){
					$f = $nro_for;  //sai do looping
				}
			}
			consulta_limpa($res_for);
			if ($reg_tri[1]!='S'){
				$con_val = 'select Codigo_Tributo_Ecf  from produto_tributo_icms '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_ICMS.'"';
				$impostos[$reg_tri[0]] = 'I1';
			}else{
				$con_val = 'select Codigo_Tributo_Ecf  from produto_tributo_iss '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_ICMS.'"';
				$impostos[$reg_tri[0]] = 'IS1';
			}
			$res_val = consulta_sql($con_val);
			$reg_val = consulta_ler_linha($res_val);
			consulta_limpa($res_val);
			if (isset($tributos_ecf[$reg_val[0]])){
				$impostos[$reg_tri[0]] = $tributos_ecf[$reg_val[0]];
			}
			if ($impostos[$reg_tri[0]] == ''){
				if ($reg_tri[1]=='T'){
					$impostos[$reg_tri[0]] = 'I1';
				}else{
					$impostos[$reg_tri[0]] = 'IS1';
				}
			}
		}
		consulta_limpa($res_tri);
		return $impostos;
	}

	function impostos_produto($empresa, $cliente = 0, $end_cliente = 0, $produto = 0, $trib = 0, $cfop_base='5.102'){
		$tributos_ecf = array();
		$tributos_icms = array();
		$tributos_icms[0] = 'I1';
		$con_ecf = 'SELECT Codigo_Tributo_Ecf, TributoECF FROM tributo_ecf';
		$res_ecf = consulta_sql($con_ecf);
		$nrw_ecf = consulta_num_registros($res_ecf);
		for($e=0;$e<$nrw_ecf;$e++){
			set_time_limit(60);
			$reg_ecf = consulta_ler_linha($res_ecf);
			$tributos_ecf[$reg_ecf[0]] = $reg_ecf[1];
			//echo $tributos_ecf[$reg_ecf[0]].'<BR>';
		}
		consulta_limpa($res_ecf);

		$impostos_ecf = array();
		$impostos_ecf[0] = 'I1';

		$impostos_icm = array();
		$impostos_icm[0] = '0';

		$impostos_icms_cst = array();
		$impostos_icms_cst[0] = '40';

		$impostos_red_icms = array();
		$impostos_red_icms[0] = '0';

		$impostos_icms_st = array();
		$impostos_icms_st[0] = '0';

		$impostos_red_icms_st = array();
		$impostos_red_icms_st[0] = '0';

		$impostos_mva_icms_st = array();
		$impostos_mva_icms_st[0] = '0';

		$impostos_ipi = array();
		$impostos_ipi[0] = '0';

		$impostos_pis = array();
		$impostos_pis[0] = '0';

		$impostos_confis = array();
		$impostos_confis[0] = '0';

		$impostos_pis_cst = array();
		$impostos_pis_cst[0] = '07';

		$impostos_confis_cst = array();
		$impostos_confis_cst[0] = '07';

		$var_nota = variaveis_nota(0,0,$empresa,$cliente,$end_cliente,$produto,$cfop_base);
		//echo $cfop_base;
		//print_r($var_nota);
		if ($cliente>0){
			$con_cad = 'select * from pessoa_endereco '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$cliente.'"'.
						' and Seq_Endereco = "'.$end_cliente.'"';
			if ($end_cliente==0){
				$con_cad = 'select * from pessoa_endereco '.
							' where Dominio="'.$_SESSION["Dominio"].'"'.
							' and Pessoa = "'.$cliente.'"'.
							' and Situacao <> "E" order by Seq_Endereco LIMIT 1 ';
			}
			$res_cad = consulta_sql($con_cad);
			$reg_cad = consulta_ler_objeto($res_cad);
			consulta_limpa($res_cad);

			$con_cad = 'select * from pessoa_endereco '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$empresa.'"'.
						' and Situacao <> "E" order by Seq_Endereco LIMIT 1 ';

			$res_cad = consulta_sql($con_cad);
			$reg_emp = consulta_ler_objeto($res_cad);
			consulta_limpa($res_cad);

			$empresa_sul = (($reg_emp->UF=='PR')||
							($reg_emp->UF=='SC')||
							($reg_emp->UF=='RS')||
							($reg_emp->UF=='SP')||
							($reg_emp->UF=='RJ')||
							($reg_emp->UF=='MG'));

			$dest_nordeste=(($reg_cad->UF=='AC')||
							($reg_cad->UF=='AL')||
							($reg_cad->UF=='AM')||
							($reg_cad->UF=='AP')||
							($reg_cad->UF=='BA')||
							($reg_cad->UF=='CE')||
							($reg_cad->UF=='ES')||
							($reg_cad->UF=='MA')||
							($reg_cad->UF=='PA')||
							($reg_cad->UF=='PE')||
							($reg_cad->UF=='PI')||
							($reg_cad->UF=='RN')||
							($reg_cad->UF=='RO')||
							($reg_cad->UF=='RR')||
							($reg_cad->UF=='SE')||
							($reg_cad->UF=='TO'));
			// echo 'ESTADOS:'.$reg_cad->UF.'-'.$reg_emp->UF;
		}

		$con_tri = 'select Codigo_Classe_Tributo, Tipo from produto_classe_tributo'.
					' where Dominio = "'.$_SESSION['Dominio'].'"';
		if ($trib>0){
			$con_tri.= ' and Codigo_Classe_Tributo="'.$trib.'"';
		}
		$res_tri = consulta_sql($con_tri);
		$nrw_tri = consulta_num_registros($res_tri);
		for($c=0;$c<$nrw_tri;$c++){
			$reg_tri = consulta_ler_linha($res_tri);
			set_time_limit(60);

			$con_for = 'select * from produto_classe_tributo_formula '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Classe_Tributo="'.$reg_tri[0].'"'.
						' and Situacao<>"E"'.
						' order by Ordem, Seq_Formula';
			$res_for = consulta_sql($con_for);
			$nro_for = consulta_num_registros($res_for);
			$ok = false;
			for($f=0;$f<$nro_for;$f++){
				set_time_limit(60);
				$reg_for = consulta_ler_objeto($res_for);
				$ok = false;
				eval($reg_for->Formula);
				if ($ok){
					$f = $nro_for;  //sai do looping
				} 
			}
			consulta_limpa($res_for);
			if ($reg_tri[1]=='T'){
				$con_val = 'select * from produto_tributo_icms '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_ICMS.'"';
				$impostos_ecf[$reg_tri[0]] = 'I1';
			}else{
				$con_val = 'select * from produto_tributo_iss '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_ICMS.'"';
				$impostos_ecf[$reg_tri[0]] = 'IS1';
			}
			$res_val = consulta_sql($con_val);
			$reg_val = consulta_ler_objeto($res_val);
			consulta_limpa($res_val);
			if (isset($tributos_ecf[$reg_val->Codigo_Tributo_Ecf])){
				$impostos_ecf[$reg_tri[0]] = $tributos_ecf[$reg_val->Codigo_Tributo_Ecf];
			}
			if ($impostos_ecf[$reg_tri[0]] == ''){
				if ($reg_tri[1]=='T'){
					$impostos_ecf[$reg_tri[0]] = 'I1';
				}else{
					$impostos_ecf[$reg_tri[0]] = 'IS1';
				}
			}
			if ($reg_tri[1]!='S'){
				$impostos_icms_cst[$reg_tri[0]] = $reg_val->ICMS_CST;
				$impostos_icms[$reg_tri[0]] = $reg_val->ICMS_Percentual;
				$impostos_red_icms[$reg_tri[0]] = $reg_val->ICMS_Reducao;
				$impostos_icms_st[$reg_tri[0]] = $reg_val->ICMSST_Percentual;
				$impostos_mva_icms_st[$reg_tri[0]] = $reg_val->ICMSST_MVA;
				$impostos_red_icms_st[$reg_tri[0]] = $reg_val->ICMSST_Reducao;
				$con_val = 'select * from produto_tributo_ipi '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_IPI.'"';
				$res_val = consulta_sql($con_val);
				$reg_val = consulta_ler_objeto($res_val);
				consulta_limpa($res_val);
				//precisa consulta tabela de IPI
				$impostos_ipi[$reg_tri[0]] = $reg_val->IPI_Aliquota;
			}else{
				$impostos_icms_cst[$reg_tri[0]] = '40';
				$impostos_icms[$reg_tri[0]] = 0;
				$impostos_red_icms[$reg_tri[0]] = 0;
				$impostos_icms_st[$reg_tri[0]] = 0;
				$impostos_red_icms_st[$reg_tri[0]] = 0;
				$impostos_mva_icms_st[$reg_tri[0]] = 0;
				$impostos_ipi[$reg_tri[0]] = 0;
			}
			$con_val = 'select * from produto_tributo_pis '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_PIS.'"';
			$res_val = consulta_sql($con_val);
			$reg_val = consulta_ler_objeto($res_val);
			consulta_limpa($res_val);
			//precisa consulta tabela de IPI
			$impostos_pis[$reg_tri[0]] = $reg_val->PIS_Aliquota;
			$impostos_pis_cst[$reg_tri[0]] = $reg_val->PIS_CST;
			$con_val = 'select * from produto_tributo_cofins '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Codigo_Tributo="'.$reg_for->Codigo_Tributo_COFINS.'"';
			$res_val = consulta_sql($con_val);
			$reg_val = consulta_ler_objeto($res_val);
			consulta_limpa($res_val);
			//precisa consulta tabela de IPI
			$impostos_cofins[$reg_tri[0]] = $reg_val->COFINS_Aliquota;
			$impostos_cofins_cst[$reg_tri[0]] = $reg_val->COFINS_CST;
			if ($cliente>0){
				if (($reg_cad->UF!=$reg_emp->UF)&&($impostos_icms[$reg_tri[0]]>7)){
					if (($empresa_sul)&&($dest_nordeste)){
						$impostos_icms[$reg_tri[0]] = 7;//7% para vendas de estados do sul ou sudeste (exceto ES) para estados do norte, noredeste ou ES
					}else{
						$impostos_icms[$reg_tri[0]] = 12;
					}
					if (limpa_numero($reg_cad->Insc_Estadual)!=''){
						if (($var_nota['item_origem']=='1') ||
							($var_nota['item_origem']=='2') ||
							($var_nota['item_origem']=='3')||
							($var_nota['item_origem']=='8')){
							$impostos_icms[$reg_tri[0]] = 4;
						}
					}
				}
				if (limpa_numero($reg_cad->Insc_Estadual)==''){
					$impostos_icms_st[$reg_tri[0]]=0;
					$impostos_red_icms_st[$reg_tri[0]]=0;
					$impostos_mva_icms_st[$reg_tri[0]]=0;
					$impostos_ipi[$reg_tri[0]]=0;
				}
			}
			if (data_atual('num')>=data2nr('13/03/2023')){
				if ($reg_emp->UF=='PR'){
					if ($impostos_icms[$reg_tri[0]]    == 18){$impostos_icms[$reg_tri[0]]    = 19;}
					if ($impostos_icms_st[$reg_tri[0]] == 18){$impostos_icms_st[$reg_tri[0]] = 19;}
				}
			}
		}
		consulta_limpa($res_tri);
		$impostos = array();
		$impostos['ecf'] = $impostos_ecf;
		$impostos['icms'] = $impostos_icms;
		$impostos['icms_cst'] = $impostos_icms_cst;
		$impostos['red_icms'] = $impostos_red_icms;
		$impostos['icms_st'] = $impostos_icms_st;
		$impostos['red_icms_st'] = $impostos_red_icms_st;
		$impostos['mva_icms_st'] = $impostos_mva_icms_st;
		$impostos['ipi'] = $impostos_ipi;
		$impostos['pis'] = $impostos_pis;
		$impostos['pis_cst'] = $impostos_pis_cst;
		$impostos['cofins'] = $impostos_cofins;
		$impostos['cofins_cst'] = $impostos_cofins_cst;
		return $impostos;
	}

	function lista_empresas(){
		$lista_empresas = array();
		$lista_empresas[0] = '';
		$con_empresa = 'SELECT Pessoa, Nome_Listas FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND SUBSTRING(Cadastros,7,1) = "S"';
		$res_empresa = consulta_sql($con_empresa);
		$nrw_empresa = consulta_num_registros($res_empresa);
		for($i=0;$i<$nrw_empresa;$i++){
			$reg_empresa = consulta_ler_linha($res_empresa);
			$lista_empresas[$reg_empresa[0]] = $reg_empresa[1];
		}
		consulta_limpa($res_empresa);
		return $lista_empresas;
	}

	function nome_empresa($lista_empresas, $empresa, $tamanho = 0){
		if (isset($lista_empresas[$empresa])){
			$retorno = $lista_empresas[$empresa];
			if ($tamanho > 0){
				$retorno = substr($retorno,0,$tamanho);
			}
			return $retorno;
		}else{
			return $empresa;
		}
	}

	function busca_imagem_empresa($nm_imagem, $origem = '', $cod_empresa = ''){
		if ($cod_empresa == ""){
			$cod_empresa2 = $_SESSION['Empresa_Codigo'];
		}else{
			$cod_empresa2 = $cod_empresa;
		}

		$nm_imagem1 = explode('.', $nm_imagem);
		$nm_img = $nm_imagem1[0].'_'.$cod_empresa2;
		$nm_ext = $nm_imagem1[1];

		if (file_exists($origem.'../arquivos_clientes/'.$_SESSION['Dominio'].'/empresa/'.$nm_img.'.'.$nm_ext)){
			return $origem.'../arquivos_clientes/'.$_SESSION['Dominio'].'/empresa/'.$nm_img.'.'.$nm_ext;
		}else if(file_exists($origem.'../arquivos_clientes/'.$_SESSION['Dominio'].'/empresa/'.$nm_imagem)){
			return $origem.'../arquivos_clientes/'.$_SESSION['Dominio'].'/empresa/'.$nm_imagem;
		}else{
			if ($cod_empresa == ""){
				return $origem.'imgs/'.$nm_imagem;
			}else{
				if ($nm_imagem1[0] == "logo_nfe"){
					return $origem.'imgs/logo_nfe.jpg';
				}else{
					return $origem.'imgs/sem_imagem.jpg';
				}
			}
		}
	}

	function consulta_produto_preco_venda($nr_nota_fiscal,$data){
		$con_nota = 'SELECT nfi.Id_Produto, nfi.Valor_Unitario '.
					' FROM nota_fiscal_item nfi '.
					' WHERE nfi.Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND nfi.Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
					' AND nfi.Nr_Nota = "'.$nr_nota_fiscal.'" ';
		$res_nota = consulta_sql($con_nota);
		while($reg_nota = consulta_ler_linha($res_nota)){
			atualiza_produto_preco_venda($_SESSION['Empresa_Codigo'], $data,$reg_nota[0], $reg_nota[1]);
		}
		consulta_limpa($res_nota);
	}

	function atualiza_produto_preco_venda($empresa, $data, $produto, $preco_novo){
		$cons_seq = 'SELECT Seq, Preco_Novo FROM produto_hist_preco_venda '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Id_Produto = "'.$produto.'"'.
					' ORDER BY Seq DESC '.
					' LIMIT 1';
		$res_seq = consulta_sql($cons_seq);
		$reg_seq = consulta_ler_linha($res_seq);
		consulta_limpa($res_seq);
		$seq = 0;
		$precoAnterior = 0;
		if (isset($reg_seq)){
			$seq = $reg_seq[0];
			$precoAnterior = $reg_seq[1];
		}
		if ($precoAnterior <= 0){
			$precoAnterior = 0;
		}
		if ($precoAnterior != $preco_novo){
			$con_custo = 'SELECT Preco_Custo FROM produto_hist_custo'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$produto.'"'.
						' ORDER BY DH_Custo DESC '.
						' LIMIT 1';
			$res_custo = consulta_sql($con_custo);
			$reg_custo = consulta_ler_linha($res_custo);
			consulta_limpa($res_custo);
			$precoCusto = isset($reg_custo) ? $reg_custo[0] : 0;
			$ins_preco = 'INSERT INTO produto_hist_preco_venda (Dominio, Empresa, Id_Produto, Seq, '
						.' DH_Preco, Preco_Anterior, Preco_Novo, Usuario, Custo) '
						.' VALUES ("'.$_SESSION['Dominio'].'", "'.$empresa.'", "'.$produto.'", "'.($seq + 1).'", '
						.' now(), "'.$precoAnterior.'", "'.$preco_novo.'", '
						.' "'.base64_decode_si($_REQUEST['USER_ID']).'", "'.$precoCusto.'")';
			consulta_sql($ins_preco);
		}
	}

	function busca_arvore_asc($id_produto, $nos=''){
		$arvore = '';
		//ver o id_prod dentro dos ns
		if (strpos(' ;'.$nos,';'.$id_produto.';')>0){
			return '';
		}else {
			$no_atual = $nos;
			// Consulta a composio desse produto
			$con_prod_comp = 'SELECT * FROM produto_composicao '.
			' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
			' AND Id_Produto_Origem = "'.$id_produto.'"'.
			' AND Situacao = "A"';
			$res_prod_comp = consulta_sql($con_prod_comp);
			$nro_prod_comp = consulta_num_registros($res_prod_comp);
			//se no tiver
			if ($nro_prod_comp <= 0){
				consulta_limpa($res_prod_comp);
				return $id_produto.';';
			}else{
				$arvore = $id_produto.';';
				$no_atual.=$arvore;
				//para cada composio
				for($i=0;$i<$nro_prod_comp;$i++){
					//l o registro
					$reg_prod_comp = consulta_ler_objeto($res_prod_comp);
					$arvore.= busca_arvore_asc($reg_prod_comp->Id_Produto_Final,$no_atual);
				}
				consulta_limpa($res_prod_comp);
				//final do loopin;
				return $arvore;
			}
		}
	}

	function busca_arvore_desc($id_produto, $servico = false, $qtd = 1, $nivel = 1, $apenas_compostos=false){
		$arvore = array();
		$retorno = array();
		//ver o id_prod dentro dos ns
		$arvore['id_produto'] = $id_produto;
		$arvore['qtd'] = $qtd;
		$arvore['tipo'] = 'P';
		//Consulta o produto para saber o baixa estoque
		$con_produto = 'select Baixa_Estoque from produto '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Id_Produto="'.$id_produto.'"';
		$res_produto = consulta_sql($con_produto);
		$reg_produto = consulta_ler_linha($res_produto);
		consulta_limpa($res_produto);
		//se baixa estoque for ordem de producao
		if (($reg_produto[0] == 'V') && ($nivel < 10)){
			//conuslta a compisio desse produto
			if ($servico){
				$con_prod_comp = 'select * from produto_composicao '.
								' where Dominio="'.$_SESSION["Dominio"].'"'.
								' and Id_Produto_Final = "'.$id_produto.'"'.
								' and Situacao = "A"';
			}else{
				$con_prod_comp = 'select * from produto_composicao pc '.
								' inner join produto p '.
								' on pc.Dominio = p.Dominio '.
								' and pc.Id_Produto_Origem = p.Id_Produto '.
								' where pc.Dominio="'.$_SESSION["Dominio"].'"'.
								' and pc.Id_Produto_Final = "'.$id_produto.'"'.
								' and p.Codigo_Depart <> 0 '.
								' and pc.Situacao = "A"';
			}
			$res_prod_comp = consulta_sql($con_prod_comp);
			$nro_prod_comp = consulta_num_registros($res_prod_comp);
			//senao numero produto
		}else {
			//nro_prod_comp = -1
			$nro_prod_comp = -1;
		}
		//se no tiver
		if ($nro_prod_comp<=0){
			//se for igual a zero
			if ($nro_prod_comp==0){
				consulta_limpa($res_prod_comp);
			}
			return $arvore;
		}else{
			$arvore['tipo'] = 'A';
			//para cada composio
			for($i=0;$i<$nro_prod_comp;$i++){
				//le o reigsitro
				$reg_prod_comp = consulta_ler_objeto($res_prod_comp);
				$retorno = busca_arvore_desc($reg_prod_comp->Id_Produto_Origem,$servico,$reg_prod_comp->Quantidade,$nivel+1, $apenas_compostos);
				if (!empty($retorno)){
					$arvore['arvore'][$i] = $retorno;
				}
			}
			consulta_limpa($res_prod_comp);
			//final do loopin;
			return $arvore;
		}
	}

	function desmonta_arvore_desc($arvore){
		if ($arvore['tipo'] == 'P'){
			$final[$arvore['id_produto']]= $arvore['qtd'];
		}else{
			$final = array();
			$arvore2 = $arvore['arvore'];
			//var_dump2($arvore2);
				foreach($arvore2 as $key=>$value){
					$arvore3 = $arvore2[$key];
					$lista_a = desmonta_arvore_desc($arvore3);
					foreach($lista_a as $key2=>$value2){
						if (!(isset($final[$key2]))){
							$final[$key2] = 0;
						}
						$final[$key2]+= $lista_a[$key2]*$arvore['qtd'];
					}
				}
			}
		return $final;
	}

	// Funo para retornar somente os produtos que tenham composies (do produto informado) em 1 nivel de array (no em arvore)
	function busca_arvore_compostos($array = array(), $id_produto, $qtd = 1, $nivel = 1){
		// Consulta o produto para saber o baixa estoque
		$con_produto = 'select Baixa_Estoque from produto '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Id_Produto="'.$id_produto.'"';
		$res_produto = consulta_sql($con_produto);
		$reg_produto = consulta_ler_linha($res_produto);
		consulta_limpa($res_produto);
		//se baixa estoque for ordem de producao
		if(($reg_produto[0] == 'P') && ($nivel < 10)){
			//consulta a composio desse produto
			$con_prod_comp = 'select * from produto_composicao pc '.
							' inner join produto p '.
							' on pc.Dominio = p.Dominio '.
							' and pc.Id_Produto_Origem = p.Id_Produto '.
							' where pc.Dominio="'.$_SESSION["Dominio"].'"'.
							' and pc.Id_Produto_Final = "'.$id_produto.'"'.
							' and p.Codigo_Depart <> 0 '.
							' and pc.Situacao = "A"';
			$res_prod_comp = consulta_sql($con_prod_comp);
			$nro_prod_comp = consulta_num_registros($res_prod_comp);
			//senao numero produto
		}else{
			$nro_prod_comp = -1;
		}
		//se no tiver
		if ($nro_prod_comp > 0){
			//para cada composio
			for($i=0;$i<$nro_prod_comp;$i++){
				//l o registro
				$reg_prod_comp = consulta_ler_objeto($res_prod_comp);
				$id_produto = $reg_prod_comp->Id_Produto_Origem;

				if (!isset($array[$id_produto])){
					$array[$id_produto]['id_produto'] = $id_produto;
					$array[$id_produto]['qtd'] = $reg_prod_comp->Quantidade * $qtd;
				}else{
					$array[$id_produto]['qtd']+= $reg_prod_comp->Quantidade * $qtd;
				}
				$array = busca_arvore_compostos($array, $reg_prod_comp->Id_Produto_Origem, ($reg_prod_comp->Quantidade * $qtd), $nivel + 1);
			}
			consulta_limpa($res_prod_comp);
			//final do looping;
		}else{
			unset($array[$id_produto]);
		}
		return $array;
	}

	//local mov estoque precsdia ter uma funo antes pra determinar se o produto  composto ou  total
	function local_mov_estoque($emp,$id_produto,$cod_barras,
								$qtd,$local_origem,$local_destino,$nivel=1){
		if ($emp == 0){
			$emp = $_SESSION["Empresa_Codigo"];
		}
		$composto = false;
		$fator = '';
		// se nivel < 10
		if ($nivel<10){
			//Consultar as composicoes do produto
			$con_prod_comp = 'SELECT Id_Produto_Origem, Quantidade FROM produto_composicao '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Id_Produto_Final = "'.$id_produto.'"'.
							' AND Situacao = "A"';
			$res_prod_comp = consulta_sql($con_prod_comp);
			$nro_prod_comp = consulta_num_registros($res_prod_comp);
			//se tem componentes
			if ($nro_prod_comp > 0){
				//consulta o produto
				$con_produto = 'SELECT Baixa_Estoque FROM produto '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Id_Produto = "'.$id_produto.'"';
				$res_produto = consulta_sql($con_produto);
				$reg_produto = consulta_ler_linha($res_produto);
				consulta_limpa($res_produto);
				//se tipo de composicao = por ordem de produo
				if ($reg_produto[0] == 'V'){
					$composto = true;
				}
			}
		}
		//se $composto
		if ($composto){
			//para cada linha
			for($p=0;$p<$nro_prod_comp;$p++){
				//determina o fator de conversao e atualiza o estoque do componente
				$reg_prod_comp = consulta_ler_linha($res_prod_comp);
				$fator = $reg_prod_comp[1];
				$qtd_comp = $qtd * $fator;
				$valor_produto = 0;
				$con_cad = 'SELECT Codigo_Barras FROM produto_cod_barras '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Id_Produto = "'.$reg_prod_comp[0].'" '.
							' AND Situacao = "A" '.
							' LIMIT 1';
				$res_cad = consulta_sql($con_cad);
				$reg_cad = consulta_ler_linha($res_cad);
				consulta_limpa($res_cad);
				$barra = '';
				if (isset($reg_cad)){
					$barra = $reg_cad[0];
				}
				local_mov_estoque($emp,$reg_prod_comp[0],$barra,
								$qtd,$local_origem,$local_destino,$nivel+1);
			}
			consulta_limpa($res_prod_comp);
		}else{
			$con_produto = 'SELECT Codigo_Depart FROM produto '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Id_Produto = "'.$id_produto.'"';
			$res_produto = consulta_sql($con_produto);
			$reg_produto = consulta_ler_linha($res_produto);
			consulta_limpa($res_produto);
			if ($reg_produto[0] != 0){  //no mexe pra servios
				local_estoque($emp,$id_produto,$cod_barras,
							$qtd,$local_origem,$local_destino);
			}
		}
	}

	function local_estoque($empresa_dest,$id_produto,$cod_barras,
							$qtd,$local_origem,$local_destino){
		$ok_origem = false;
		$ok_detino = false;
		$upda_origem = 'UPDATE produto_saldo_filial SET '.
						' Saldo_Atual = Saldo_Atual - "'.$qtd.'", '.
						' Data_Mov = now(), '.
						' DH_Atualizacao = now() '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz = "'.$local_origem.'"';
		$ok_origem = consulta_sql($upda_origem,true,1);
		if ($ok_origem <= 0){
			$insere_origem = 'insert into produto_saldo_filial ( '.
							' Dominio, '.
							' Id_Produto, '.
							' Codigo_Empresa, '.
							' Local_Armaz, '.
							' Saldo_Atual, Data_Mov, '.
							' DH_Atualizacao) values ( '.
							'"'.$_SESSION['Dominio'].'", '.
							'"'.$id_produto.'", '.
							'"'.$empresa_dest.'", '.
							'"'.$local_origem.'", '.
							'"0", '.
							'now(),now())';
			consulta_sql($insere_origem);
			$ok_origem = consulta_sql($upda_origem,true,1);
		}
		$upda_destino = 'UPDATE produto_saldo_filial SET '.
						' Saldo_Atual = Saldo_Atual + "'.$qtd.'", '.
						' Data_Mov = now(), '.
						' DH_Atualizacao = now() '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz = "'.$local_destino.'"';
		$ok_detino = consulta_sql($upda_destino, true, 1);
		if ($ok_detino <= 0){
			$insere_destino = 'insert into produto_saldo_filial ( '.
							' Dominio, '.
							' Id_Produto, '.
							' Codigo_Empresa, '.
							' Local_Armaz, '.
							' Saldo_Atual, Data_Mov, '.
							' DH_Atualizacao) values ( '.
							'"'.$_SESSION['Dominio'].'", '.
							'"'.$id_produto.'", '.
							'"'.$empresa_dest.'", '.
							'"'.$local_destino.'", '.
							'"0", '.
							'now(),now())';
			consulta_sql($insere_destino);
			$ok_detino = consulta_sql($upda_destino,true,1);
		}
		if (($cod_barras != '') && ($cod_barras != $id_produto)){
			local_estoque_barra($empresa_dest,$id_produto,$cod_barras,$qtd,$local_origem,$local_destino);
		}
		local_atualiza_custo($empresa_dest,$id_produto);
	}
		
	function local_estoque_barra($empresa_dest,$id_produto,$cod_barras,
								$qtd,$local_origem,$local_destino){
		$ok_origem = false;
		$ok_detino = false;
		$upda_origem = 'UPDATE produto_saldo_filial_barra SET '.
						' Saldo_Atual = Saldo_Atual - "'.$qtd.'", '.
						' Data_Mov = now() '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz = "'.$local_origem.'"'.
						' AND Codigo_Barras = "'.$cod_barras.'"';
		$ok_origem = consulta_sql($upda_origem,true,1);
		if ($ok_origem <= 0){
			$insere_origem = 'insert into produto_saldo_filial_barra ( '.
							' Dominio, '.
							' Id_Produto, '.
							' Codigo_Barras, '.
							' Codigo_Empresa, '.
							' Local_Armaz, '.
							' Saldo_Atual, '.
							' Data_Mov) values ( '.
							'"'.$_SESSION['Dominio'].'", '.
							'"'.$id_produto.'", '.
							'"'.$cod_barras.'", '.
							'"'.$empresa_dest.'", '.
							'"'.$local_origem.'", '.
							'"0", '.
							'now())';
			consulta_sql($insere_origem);
			$ok_origem = consulta_sql($upda_origem,true,1);
		}
		$upda_destino = 'UPDATE produto_saldo_filial_barra SET '.
						' Saldo_Atual = Saldo_Atual + "'.$qtd.'", '.
						' Data_Mov = now() '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz = "'.$local_destino.'"'.
						' AND Codigo_Barras = "'.$cod_barras.'"';
		$ok_detino = consulta_sql($upda_destino,true,1);
		if ($ok_detino <= 0){
			$insere_destino = 'insert into produto_saldo_filial_barra ( '.
								' Dominio, '.
								' Id_Produto, '.
								' Codigo_Barras, '.
								' Codigo_Empresa, '.
								' Local_Armaz, '.
								' Saldo_Atual, '.
								' Data_Mov) values ( '.
								'"'.$_SESSION['Dominio'].'", '.
								'"'.$id_produto.'", '.
								'"'.$cod_barras.'", '.
								'"'.$empresa_dest.'", '.
								'"'.$local_destino.'", '.
								'"0", '.
								'now())';
			consulta_sql($insere_destino);
			$ok_detino = consulta_sql($upda_destino,true,1);
		}
	}

	function local_atualiza_custo($empresa, $id_produto){
		$con_custo = 'SELECT Preco_Custo, DH_Custo FROM produto_saldo_filial '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Codigo_Empresa = "'.$empresa.'"'.
					' AND Id_Produto = "'.$id_produto.'"'.
					' AND Local_Armaz = "0"';
		$res_custo = consulta_sql($con_custo);
		$reg_custo = consulta_ler_linha($res_custo);
		consulta_limpa($res_custo);
		$precoCusto = 0;
		$dhCusto = '0000-00-00 00:00:00';
		if (isset($reg_custo)){
			$precoCusto = $reg_custo[0];
			$dhCusto = $reg_custo[1];
		}
		$upda_origem = 'UPDATE produto_saldo_filial SET '.
						' Preco_Custo = "'.$precoCusto.'", '.
						' DH_Custo = "'.$dhCusto.'" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz <> "0"';
		$ok_origem = consulta_sql($upda_origem,true,1);
		$upda_origem = 'UPDATE produto_saldo_filial_barra SET '.
						' Preco_Custo = "'.$precoCusto.'", '.
						' DH_Custo = "'.$dhCusto.'" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"'.
						' AND Local_Armaz <> "0"';
		$ok_origem = consulta_sql($upda_origem,true,1);
	}

	function label_vendedor_ou_rep_comercial($abreviado = ''){
		$retorno = '';
		$tipo = BuscaParam('VENDEDOR-TIPO');
		if ($tipo == 1){ //Normal
			$retorno = 'Vendedor';
		}else if($tipo == 2){ //Representante comercial
			if ($abreviado == 'S'){
				$retorno = 'Rep. Coml.';
			}else{
				$retorno = 'Representante Comercial';
			}
		}else{
			$retorno = 'Vendedor';
		}
		return $retorno;
	}

	function empresa_representante($pessoa, $exibe_codigo = '',$tipo=''){
		$retorno = '';
		if ($tipo==''){
			$tipo = BuscaParam('VENDEDOR-TIPO');
		}
		$con_pessoa = 'SELECT Nome_Listas FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Pessoa = "'.$pessoa.'" ';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		if ($tipo == 2){ //Representante comercial
			$con_vendedo2 = 'SELECT Tipo, Situacao, Empresa_Representante, Nr_CORE FROM pessoa_vendedor '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND Pessoa = "'.$pessoa.'"';
			$res_vendedo2 = consulta_sql($con_vendedo2);
			$reg_vendedo2 = consulta_ler_linha($res_vendedo2);
			consulta_limpa($res_vendedo2);
			if (($reg_vendedo2[2]!='')&&($reg_vendedo2[3]!='')){
				$retorno = $reg_pessoa[0].' - ('.$reg_vendedo2[2].') - CORE Nr '.$reg_vendedo2[3];
			}else if($reg_vendedo2[2]!=''){
				$retorno = $reg_pessoa[0].' - ('.$reg_vendedo2[2].')';
			}else if($reg_vendedo2[3]!=''){
				$retorno = $reg_pessoa[0].' - CORE Nr '.$reg_vendedo2[3];
			}else {
				$retorno = $reg_pessoa[0];
			}
		}else{
			$retorno = $reg_pessoa[0];
		}
		if ($exibe_codigo == 'S'){
			$retorno = $pessoa.' - '.$retorno;
		}
		return $retorno;
	}


	/**
	 * Mtodo para a partir de Cdigo/Cdigo de barras encontrar o produto ja cadastrado no sistema e devolver a array com Id_Produto, Codigo_Produto e (se tiver) Codigo_Barras
	 * @param string $codigo
	 * @return array $cod_retorno
	 * @author Maurcio Moller
	 */
	function busca_codigo_produto_barras($codigo){
		$cod_retorno = array();

		$cod_barras = $codigo;
		$codigo2 = $cod_barras;

		$tzero = false;
		if (strlen($codigo2)>1){
			$tzero = ($codigo2[0]=='0');
		}
		while ($tzero){
			$codigo2 = substr($codigo2,1,100);
			$tzero = false;
			if (strlen($codigo2)>1){
				$tzero = ($codigo2[0]=='0');
			}
		}
		$con_produto = 'SELECT Id_Produto FROM produto_cod_barras '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND ((Codigo_Barras = "'.$codigo.'")'.
						' OR (Codigo_Barras = "'.$codigo2.'"))'.
						' AND Situacao = "A"';
		$res_produto = consulta_sql($con_produto);
		$nrw_produto = consulta_num_registros($res_produto);
		if ($nrw_produto>0){
			$reg_produto = consulta_ler_linha($res_produto);
			$id_prod = $reg_produto[0];
			consulta_limpa($res_produto);
		}else{
			consulta_limpa($res_produto);
			$id_prod = 0;
			$cod_prod = 0;
			$cod_barras = '';
			$con_produto = 'SELECT Id_Produto, Codigo_Produto FROM produto '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND ((Codigo_Produto = "'.$codigo.'")'.
							' OR (Codigo_Produto = "'.$codigo2.'"))'.
							' AND ((Situacao = "A") OR (Situacao = "P")) ';
			$res_produto = consulta_sql($con_produto);
			$nrw_produto = consulta_num_registros($res_produto);
			if ($nrw_produto>0){
				$reg_produto = consulta_ler_linha($res_produto);
				$id_prod  = $reg_produto[0];
				$cod_prod = $reg_produto[1];
			}else{
				$id_prod = '';
				$cod_prod = '';
			}
			consulta_limpa($res_produto);
		}

		//adicionar pesuisa do produtyo
		$con_cad =  'SELECT Codigo_Produto FROM produto '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Id_Produto = "'.$id_prod.'" ';
		$res_cad = consulta_sql($con_cad);
		$reg_cad = consulta_ler_linha($res_cad);
		consulta_limpa($res_cad);


		$cod_retorno['id_prod'] = $id_prod;
		$cod_retorno['cod_barras'] = $cod_barras;
		$cod_retorno['cod_prod'] = $reg_cad[0];

		/**Se codigo_barra vazio, consulta o id_produto e adiciona o primeiro codigo de barra ativo */
		if( $cod_retorno['cod_barras'] ==''){

			$con_cad =  'SELECT Codigo_Barras FROM produto_cod_barras '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
						' AND Id_Produto = "'.$cod_retorno['id_prod'].'" '.
						' AND Situacao = "A" '.
						' ORDER BY Codigo_Barras  LIMIT 1';
			$res_cad = consulta_sql($con_cad);
			$reg_cad = consulta_ler_linha($res_cad);
			consulta_limpa($res_cad);
			$cod_retorno['cod_barras'] = $reg_cad[0];

		}
		return $cod_retorno;
	}

	function barra_de_progresso_no_relatorio($origem='',$top='40%',$left='36%'){
		$retorno = "
		<!--USA-SE ESTA DIV PARA MOSTRAR O PROGRESSO AO IMPRIMIR E FECHA QUANDO A IMPRESSO  GERADA-->
		<div id='progresso' style='position: absolute; display: block; background-color: transparent; border: solid 0px silver; width: 100%; height: 50%;top:".$top."' align='center' valign='middle'>
			<div style='padding-top:15px;padding-bottom:15px;background-color: white; border: solid 1px silver; width: 200px; height: 50px; line-height: 100px; font-size: 14px; font-weight: bold;' >
				<img style='vertical-align:middle' src='".$origem."imgs/progress.gif'>
				<span>&nbsp;Por favor aguarde...</span>
			</div>
		</div>";
		return $retorno;
	}

	function barra_de_progresso($origem,$dominio,$usuario,$campos_obrigatorio,$tipo_campo){
		$retorno = array();
		$delete = 'delete from relatorio_tmp '.
				' where Dominio = "'.$dominio.'" '.
				' and Usuario = "'.$usuario.'" ';
		$retorno['delete'] = $delete;
		$bottom = '80';
		$left = '260';
		if (!isset($campos_obrigatorio)){
			$campos_obrigatorio = array();
		}
		if (!isset($campos_obrigatorio[0])){
			$campos_obrigatorio[0] = '';
		}
		if (!isset($campos_obrigatorio[1])){
			$campos_obrigatorio[1] = '';
		}
		if ($campos_obrigatorio[0]=='ESPECIAL'){
			$bottom = '30';
			$left = '160';
		}
		if ($campos_obrigatorio[0]=='ESPECIAL2'){
			$bottom = '30';
			$left = '220';
		}
		if ($campos_obrigatorio[0]=='ESPECIAL3'){
			$bottom = '100';
			$left = '220';
		}
		$top = ' top: 145px; ';
		$div_de_progresso = "<div id='progresso' style='position: absolute; display: none; background-color: transparent; border: solid 0px silver; width: 100%; height: 50%;".$top.";z-index:3000;' align='center' valign='middle'>
								<div style='padding-top:15px;padding-bottom:15px;background-color: white; border: solid 1px silver; width: 200px; height: 50px; line-height: 100px; font-size: 14px; font-weight: bold;' >
									<img style='vertical-align:middle' src='".$origem."imgs/carregando_arquivo.gif'>
									<span>&nbsp;Por favor aguarde...</span>
								</div>
							</div>";
		$retorno['div'] = $div_de_progresso;
		$script = "
<script>
	function abre_e_fecha_progresso(){
		ok = true;
		if ('".$campos_obrigatorio[0]."'=='ESPECIAL'){
			ok = true;
			var c = document.getElementById('relatorio');
			if ((document.relatorio.Tipo_Data_INI.value!='')&&(document.relatorio.Tipo_Data_INI.value.length<10)){
				ok = false;
			}
			if ((document.relatorio.Tipo_Data_FIM.value!='')&&(document.relatorio.Tipo_Data_FIM.value.length<10)){
				ok = false;
			}
			if ((document.relatorio.Nome_Parcial.value!='')&&(document.relatorio.Nome_Parcial.value.length<3)){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[1]."'=='Empresa'){
			ok = true;
			if (document.getElementById('Empresa').value==''){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[0]."'=='ESPECIAL2'){
			ok = true;
			var c=document.relatorio;
			if (c.Correcao_Data.value==''){
				return false;
			}
			if ((c.Tipo_Data_INI.value!='')&&(c.Tipo_Data_INI.value.length<10)){
				ok = false;
			}
			if ((c.Tipo_Data_FIM.value!='')&&(c.Tipo_Data_FIM.value.length<10)){
				return false;
			}
			if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
				ok = false;
			}
			if (c.Correcao_Juros.value!=''){
				if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
					ok = false;
				}
				if (Numero(c.Correcao_Juros.value)<=0){
					ok = false;
				}
			}
			if (c.Correcao_Desconto.value!=''){
				if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
					ok = false;
				}
				if (Numero(c.Correcao_Desconto.value)<=0){
					ok = false;
				}
			}
			if ((c.Nome_Parcial.value!='')&&(c.Nome_Parcial.value.length<3)){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[0]."'=='ESPECIAL3'){
			var c=document.relatorio;
			if ((!c.ckAdiantaCred.checked)&&(!c.ckAdiantaDeb.checked)&&
				(!c.ckChequesPre.checked)&&(!c.ckContasPag.checked)&&
				(!c.ckContasRec.checked)&&(!c.ckDividasBancarias.checked)&&
				(!c.ckContratos.checked)&&(!c.ckFixacao.checked)
				){
				ok = false;
			}
			if (c.Empresa.Value==''){
				ok = false;
			}
			if (document.getElementById('Cliente').value==''){
				ok = false;
			}
			if ((c.DT_INI.value!='')&&(c.DT_INI.value.length<10)){
				ok = false;
			}
			if ((c.DT_FIM.value!='')&&(c.DT_FIM.value.length<10)){
				ok = false;
			}
			if (c.OpDuplicata.value=='A'){
				if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
					ok = false;
				}
				if (c.Correcao_Juros.value!=''){
					if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
						ok = false;
					}
					if (Numero(c.Correcao_Juros.value)<=0){
						ok = false;
					}
				}
				if (c.Correcao_Desconto.value!=''){
					if ((c.Correcao_Data.value!='')&&(c.Correcao_Data.value.length<10)){
						ok = false;
					}
					if (Numero(c.Correcao_Desconto.value)<=0){
						ok = false;
					}
				}
			}
			if ((c.DT_INI_CONT.value!='')&&(c.DT_INI_CONT.value.length<10)){
				ok = false;
			}
			if ((c.DT_FIM_CONT.value!='')&&(c.DT_FIM_CONT.value.length<10)){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[0]."'=='ESPECIAL4'){
			var c=document.relatorio;
			if ((c.Data_INI.value!='')&&(c.Data_INI.value.length<10)){
				ok = false;
			}
			if ((c.Data_FIM.value!='')&&(c.Data_FIM.value.length<10)){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[0]."'=='ESPECIAL5'){
			var c = document.getElementById('relatorio');
			var tipo_relatorio = '';
			if (document.relatorio.Data_INI.value==''){
				ok = false;
			}
			if (document.relatorio.Data_FIM.value==''){
				ok = false;
			}
			if ((document.relatorio.Data_INI.value!='')&&(document.relatorio.Data_INI.value.length<10)){
				ok = false;
			}
			if ((document.relatorio.Data_FIM.value!='')&&(document.relatorio.Data_FIM.value.length<10)){
				ok = false;
			} 
			if (document.relatorio.Id_Produto.value==''){
				ok = false;
			}
		}
		if ('".$campos_obrigatorio[1]."'=='Empresa'){
			ok = true;
			if (document.getElementById('Empresa').value==''){
				ok = false;
			}
		}
		";

		if (($campos_obrigatorio[0]!='ESPECIAL')&&
			($campos_obrigatorio[0]!='ESPECIAL2')&&
			($campos_obrigatorio[0]!='ESPECIAL3')&&
			($campos_obrigatorio[0]!='ESPECIAL4')&&
			($campos_obrigatorio[0]!='ESPECIAL5')&&
			($campos_obrigatorio[0]!='LISTA')){
			if ((sizeof($campos_obrigatorio) >= 1)&&($campos_obrigatorio[0] != '')){
				for($i=0;$i<sizeof($campos_obrigatorio);$i++){
					$script.="
		if (document.getElementById('".$campos_obrigatorio[$i]."').value==''){
			ok = false;";
			//$i=(sizeof($campos_obrigatorio)+1);
					$script.="
		}
		if ('".$tipo_campo[$i]."'=='DATA'){
			if (document.getElementById('".$campos_obrigatorio[$i]."').value.length<10){
				ok = false; ";
				//$k=(sizeof($campos_obrigatorio)+1);
					$script.="
			}
		}";
				}
				for($i1=0;$i1<sizeof($campos_obrigatorio);$i1++){
					$script.="
		if ('".$campos_obrigatorio[$i1]."'=='TipoRel'){
			if (document.getElementById('TipoRel').value=='A'){
				if (document.getElementById('Produto').value==''){
					ok = false;";
					//$i1=(sizeof($campos_obrigatorio)+1);
					$script.="
				}
			}
		}";
				}
			}
		}
		$script.="
		if (ok){
			document.getElementById('progresso').style.display = 'block';
			ao_carregar();
		}
	}

	function fecha_div(){
		var con = new XHConn();
		var resposta = '';
		var atualiza = function(ajax){
			resposta = ajax.responseText.replace(/\\+/g,\" \");
			//alert(resposta);
			if (pega_cvs(resposta,1)=='S'){
				document.getElementById('progresso').style.display = 'none';
			}else{
				setTimeout('ao_carregar()',400);
			}
		}
		con.connect('../relatorio_valida_progresso.php','POST','USER_ID=".$_REQUEST['USER_ID']."&dominio=".$_SESSION['Dominio']."&op=carregar',atualiza);
	}

	function ao_carregar(){
		fecha_div();
	}
</script>";

		$retorno['script'] = $script;
		return $retorno;
	}

	function gera_nf_ordem_de_servico($nr_os){
	}

	function fecha_ordem_de_servico($nr_os){
	}

	function nf_ordem_de_servico($nr_os, $op){
		//consulta a ordem e verifica o seu status
		$con_cadast = 'SELECT Status FROM ordem_servico '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_OrdemServico = "'.$nr_os.'"';
		$res_cadast = consulta_sql($con_cadast);
		$reg_cadast = consulta_ler_objeto($res_cadast);
		consulta_limpa($res_cadast);
		if ($op == 'nf'){ //GERAR A NOTA
			if ($reg_cadast->Status == 'F'){
				//SE A ORDEM ESTIVER FECHADA
				gera_nf_ordem_de_servico($nr_os);
			}else { //
				echo "<script>
	if(confirm('Deseja fechar a ordem de servio?')){";
		//FECHA A NOTA E DEPOIS CHAMA A ROTINA PARA GERAR A NOTA
				fecha_ordem_de_servico($nr_os);
				//ROTINA PARA GERAR A NOTA
				gera_nf_ordem_de_servico($nr_os);
				echo "
	}
</script>";
			}
		}else if($op == 'fechar'){
			//FAZ O FECHAMENTO AQUI
			fecha_ordem_de_servico($nr_os);
		}
		return '';
	}

	/*
	function gera_egf_arquivo(){
	$con_tmp = 'select * from contas_pr_quitar_tmp '.
	' where Dominio = "'.$_SESSION['Dominio'].'" '.
	' and Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
	' and Usuario = "'.base64_decode_si($_SESSION['USER_ID']).'" ';
	$res_tmp = consulta_num_registros($res_tmp);
	$nro_tmp = consulta_num_registros($res_tmp);

	if($nro_tmp>0){
	$reg_tmp = consulta_ler_objeto($res_pessoa);

	//MONTA CABEALHO DO ARQUIVO
	$con_egf = 'select * from banco_contas_egf '.
	' where Dominio = "'.$_SESSION['Dominio'].'" '.
	' Usuario = "'.base64_decode_si($_SESSION['USER_ID']).'" ';
	$res_egf = consulta_sql($con_egf);
	$reg_egf = consulta_ler_objeto($res_egf);
	consulta_limpa($res_pessoa);

	$data_tmp = $reg_egf->DT_Compra;
	$ano = substr($data_tmp,0,4);
	$mes = substr($data_tmp,5,2);
	$dia = substr($data_tmp,9,2);

	$data = $dia.$mes.$ano;


	$cnpj_empresa = '';

	$con_pessoa = 'select CPF_CNPJ from pessoa '.
	' where Dominio = "'.$_SESSION['Dominio'].'" '.
	' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'" ';
	$res_pessoa = consulta_sql($con_pessoa);
	$reg_pessoa = consulta_ler_linha($res_pessoa);
	consulta_limpa($res_pessoa);

	$cnpj_tmp = $reg_pessoa[0];
	$cnpj_empresa = str_replace('.','',$cnpj_tmp);
	$cnpj_empresa = str_replace('.','',$cnpj_empresa);
	$cnpj_empresa = str_replace('/','',$cnpj_empresa);
	$cnpj_empresa = str_replace('-','',$cnpj_empresa);

	$cabecalho = ''. //CODIGO HEADER TAMANHO 2
	'Arq_EGF'. //NOME DO ARQUIVO TAMANHO 8
	$data. //DATA REMESSA TAMANHO 8
	''. //NR REMESSA TAMANHO 9
	$cnpj_empresa. //CNPJ EMPRESA TAMANHO 14
	''. //PREFIXO AGENCIA TAMANHO 9
	''. //CONTA DO CONTRATO TAMANHO 9
	''. //NR CONTRATO TAMANHO 9
	''. //UNIDADE ORGANIZACIONAL TAMANHO 9
	''; //ESPAO EM BRANCO TAMANHO 53

	$conteudo01 = ''; //REFERENTE A EXCLUSO DE LOTE

	$conteudo02 = ''. //CODIGO DETALHE 2 TAMANHO 2
	''. //FINALIDADE TAMANHO 5
	''. //CODIGO PRODUTO TAMANHO 5
	''. //SAFRA TAMANHO 9 EXEMPLO AAAA/AAAA
	''. //PREFIXO AGENCIA OP TAMANHO 5
	''; //ESPAO EM BRANCO TAMANHO 104

	$conteudo03 = ''. //CODIGO DETALHE 3 TAMANHO 2
	''. //CPF/CNPJ DO PRODUTOR RURAL TAMANHO 14
	''. //INDICADOR DO CDIGO DE TIPO PARA CNPJ TAMANHO 1;
	''. //SERIE NOTA TAMANHO 3
	''. //NR NOTA FISCAL TAMANHO 17
	''. //DATA COMPRA TAMANHO 8 EX: DDMMAAAA
	''. //QTD ADQUIRIDA TAMANHO 18
	''. //VALOR PAGO TAMANHO 17
	''. //VALOR FINANCIADO TAMANHO 17
	''. //UNIDADE MEDIDA TAMANHO 20
	''. //MUNICIPIO ORIGEM TAMANHO 7
	''; //ESPAO EM BRANCO TAMANHO 6

	$conteudo04 = ''. //CODIGO DETALHE 4 TAMANHO 2
	''. //QTD REGISTRO TAMANHO 7
	''. //SOMA QTD ADQUIRIDA TAMANHO 18
	''. //SOMA VALOR PAGO TAMANHO 17
	''. //SOMA VALOR FINANCIADO TAMANHO 17
	''; //ESPAO EM BRANCO TAMANHO 69

	$rodape = ''. //CODIGO TRAILER - IDENTIFICA ULTIMA LINHA TAMNHO 1;
	''. //QTD REGISTROS TAMANHO 7
	''; //ESPAO EM BRANCO 121

	$con_gera = 'select * from nota_fiscal '.
	' where Dominio="'.$_SESSION['Dominio'].'"'.
	' and Empresa = "'.$reg_tmp->Empresa.'"'.
	' and NrDoc = "'.$reg_tmp->Nr_Doc.'"'.
	' and Serie = "'.$reg_tmp->Serie.'"'.
	' and SubSerie = "'.$reg_tmp->SubSerie.'"'.
	' and Modelo = "'.$reg_tmp->Modelo.'"';
	$res_gera = consulta_sql($con_gera);
	$nrw_gera = consulta_num_registros($res_gera);
	for($g=0;$g<$nrw_gera;$g++){
	set_time_limit(30);
	$reg_gera = consulta_ler_objeto($res_gera);



	}
	consulta_limpa($res_gera);
	}

	consulta_limpa($res_tmp);
	}*/

	function recalcula_total_os($empresa, $nr_ordem){
		$total_produto = 0;
		$total_servico = 0;
		$total_horas = 0;
		$valor_total_liq = 0;
		$valor_total_desc = 0;
		$total_desconto = 0;
        /* Aprovado -  inlog - 352 
        if( ($_SESSION['Dominio'] == '271')|| ($_SESSION['Dominio'] == '352') ){
                $con_seq = 'SELECT IFNULL(SUM(Valor_Total), 0), IFNULL(SUM(Valor_Desconto), 0) FROM ordem_servico_item '.
                    ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' AND Empresa = "'.$empresa.'"'.
                    ' AND Nr_OrdemServico = "'.$nr_ordem.'"'.
                    ' AND Status <> "E"'.
                    ' AND Status <> "C"'.
                    ' AND Aprovado = "S"'.
                    ' AND Codigo_Depart <> 0';
        }else{

            */
            $con_seq = 'SELECT IFNULL(SUM(Valor_Total), 0), IFNULL(SUM(Valor_Desconto), 0) FROM ordem_servico_item '.
                    ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' AND Empresa = "'.$empresa.'"'.
                    ' AND Nr_OrdemServico = "'.$nr_ordem.'"'.
                    ' AND Status <> "E"'.
                    ' AND Status <> "C"'.
                    ' AND Codigo_Depart <> 0';
        //  }
		
		$res_seq = consulta_sql($con_seq);
		$reg_seq = consulta_ler_linha($res_seq);
		consulta_limpa($res_seq);
		$total_produto = $reg_seq[0];
          /* Aprovado -  inlog - 352 
        if( ($_SESSION['Dominio'] == '271')|| ($_SESSION['Dominio'] == '352') ){
             $con_seq1 = 'SELECT IFNULL(SUM(Valor_Total), 0), IFNULL(SUM(Valor_Desconto), 0) FROM ordem_servico_item '.
                    ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' AND Empresa = "'.$empresa.'"'.
                    ' AND Nr_OrdemServico = "'.$nr_ordem.'"'.
                    ' AND Status <> "E"'.
                    ' AND Status <> "C"'.
                    ' AND Aprovado = "S"'.
                    ' AND Codigo_Depart = 0';  
        }else{

            */
            $con_seq1 = 'SELECT IFNULL(SUM(Valor_Total), 0), IFNULL(SUM(Valor_Desconto), 0) FROM ordem_servico_item '.
                    ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' AND Empresa = "'.$empresa.'"'.
                    ' AND Nr_OrdemServico = "'.$nr_ordem.'"'.
                    ' AND Status <> "E"'.
                    ' AND Status <> "C"'.
                    ' AND Codigo_Depart = 0';    
        //    }
		
		$res_seq1 = consulta_sql($con_seq1);
		$reg_seq1 = consulta_ler_linha($res_seq1);
		consulta_limpa($res_seq1);
		$total_servico = $reg_seq1[0];
		$con_ordem = 'SELECT IFNULL(SUM(Horas_Trabalho), 0) FROM ordem_servico_funcionario '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa = "'.$empresa.'" '.
					' AND Nr_OrdemServico = "'.$nr_ordem.'"'.
					' AND Status <> "E"'.
					' AND Status <> "C"';
		$res_ordem = consulta_sql($con_ordem);
		$reg_ordem = consulta_ler_linha($res_ordem);
		consulta_limpa($res_ordem);
		$total_horas = ($reg_ordem[0]);
		$valor_total_liq = (($total_servico + $total_produto) - $total_desconto);
		$valor_total_desc = ($reg_seq[1] + $reg_seq1[1]);
		$update = 'UPDATE ordem_servico SET '.
					' Valor_Total_Serv = "'.$total_servico.'", '.
					' Valor_Total_Prod = "'.$total_produto.'", '.
					' Valor_Sub_Total = "'.$total_servico.'", '.
					' Horas_Trabalho = "'.$total_horas.'", '.
					' Valor_Total_Liquido = "'.$valor_total_liq.'", '.
					' Valor_Desconto = "'.$valor_total_desc.'" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Nr_OrdemServico = "'.$nr_ordem.'"';
		consulta_sql($update);
	}

	function gera_mov_saida($empresa, $nr_nota, $situacao = 'F'){
		if ($situacao != 'F'){
			//faz update na tabela pra cancelar
			$del_base = 'UPDATE movimento_vendas SET '.
						' Situacao = "C" '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Nr_Nota = "'.$nr_nota.'"';
			consulta_sql($del_base);
			$sinal = '-';
		}else{
			//faz insert na tabela para colocar os dados novos
			//consulta a nota
			$con_nota = 'SELECT * FROM nota_fiscal'.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Nr_Nota = "'.$nr_nota.'"';
			$res_nota = consulta_sql($con_nota);
			$reg_nota = consulta_ler_objeto($res_nota);
			consulta_limpa($res_nota);
			//consulta a observacao
			$con_obs = 'SELECT IFNULL(GROUP_CONCAT( DISTINCT Texto_Completo ), "") FROM nota_fiscal_obs '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' AND TipoObs = "A"'.
						' GROUP BY Empresa';
			$res_obs = consulta_sql($con_obs);
			$reg_obs = consulta_ler_linha($res_obs);
			consulta_limpa($res_obs);
			$obs = str_replace('"', "'", $reg_obs[0]);
			//consulta os vencimentos
			$data_emissao = data2nr(dataf($reg_nota->DH_Emissao));
			$ano_mes = $reg_nota->DH_EntSai;
			$ano_mes = $ano_mes[0].$ano_mes[1].$ano_mes[2].$ano_mes[3].$ano_mes[5].$ano_mes[6];
			$prazos = '';
			$con_parc = 'SELECT DT_Vencimento FROM nota_fiscal_parcela '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' ORDER BY Parcela ASC';
			$res_parc = consulta_sql($con_parc);
			while($reg_parc = consulta_ler_objeto($res_parc)){
				$dias = data2nr(dataf($reg_parc->DT_Vencimento)) - $data_emissao;
				if ($prazos != ''){
					$prazos.= ',';
				}
				$prazos.= $dias;
			}
			consulta_limpa($res_parc);
			//consulta o vendedor
			$con_ven =  'SELECT Nome_Razao, CPF_CNPJ FROM pessoa '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Pessoa = "'.$reg_nota->Vendedor.'"';
			$res_ven = consulta_sql($con_ven);
			$reg_ven = consulta_ler_objeto($res_ven);
			consulta_limpa($res_ven);
			//consulta nota referenciada (apenas 1)
			$con_ref =  'SELECT NF_Serie, NF_Nr_Doc FROM nota_fiscal_refenciada '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
						' AND Empresa = "'.$empresa.'" '.
						' AND Nr_Nota = "'.$nr_nota.'" '.
						' AND ((NF_Modelo = "01") OR (NF_Modelo = "55"))'.
						' LIMIT 1';
			$res_ref = consulta_sql($con_ref);
			$reg_ref = consulta_ler_objeto($res_ref);
			consulta_limpa($res_ref);
			$nr_ref = '';
			if (isset($reg_ref)){
				$nr_ref = $reg_ref->NF_Nr_Doc;
				if ($nr_ref != ''){
					$nr_ref.= '.'.$reg_ref->NF_Serie;
				}
			}
			//prepara sql base
			$ins_base = 'INSERT INTO movimento_vendas ('.
						' id, Dominio, Empresa, '.
						' Data_Mov, Ano_Mes, '.
						' Pessoa, Pessoa_Endereco, Situacao, '.
						' TipoES, EmissaoPT, '.
						' Modelo, Serie, NrDoc, Nr_Nota, '.
						' Vendedor, Vendedor_Nome, Vendedor_CPF, '.
						' Forma_Pagto, Fatura_Tipo, Forma_Pagto_Desc, Forma_Pagto_Venctos, '.
						' Observacao, NF_Ref, '.
						' DH_Emissao, DH_EntSai, '.
						' Empresa_CNPJ, Pessoa_CNPJ, '.
						' Id_Produto, Quantidade, Valor_Total, Valor_Produto, '.
						' Valor_ICMS, Valor_ICMS_ST, Valor_IPI, Valor_PIS, Valor_COFINS, '.
						' CFOP, CFOP_Descricao, CFOP_GeraContas, CFOP_MovEstoque, '.
						' Cultura, Cultura_Desc, Peneria, Nr_Lote, '.
						' Peso_Bruto, Peso_Liquido, '.
						' Produto_Codigo, Produto_Descricao, '.
						' Produto_Unidade, Produto_Depart, Produto_Fornecedor ) VALUES ('.
						' null , "'.$_SESSION["Dominio"].'", "'.$empresa.'", '.
						' now(), "'.$ano_mes.'", '.
						' "'.$reg_nota->Destinatario.'", "'.$reg_nota->Dest_Endereco.'", "F", '.
						' "'.$reg_nota->TipoES.'", "'.$reg_nota->EmissaoPT.'", '.
						' "'.$reg_nota->Modelo.'", "'.$reg_nota->Serie.'", "'.$reg_nota->NrDoc.'", "'.$reg_nota->Nr_Nota.'", '.
						' "'.$reg_nota->Vendedor.'", "'.$reg_ven->Nome_Razao.'", "'.$reg_ven->CPF_CNPJ.'", '.
						' "'.$reg_nota->Forma_Pagto.'", "'.$reg_nota->Fatura_Tipo.'", "'.$reg_nota->Forma_Pagto_Desc .'", "'.$prazos.'", '.
						' "'.$obs.'", "'.$nr_ref.'", '.
						' "'.$reg_nota->DH_Emissao.'", "'.$reg_nota->DH_EntSai.'", '.
						' "'.$reg_nota->Empresa_CNPJ.'", "'.$reg_nota->Dest_CPF_CNPJ.'", ';
			//consulta os itens da nota
			$con_item = 'SELECT * FROM nota_fiscal_item '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Nr_Nota = "'.$nr_nota.'"'.
						' ORDER BY Seq_Item';
			$res_item = consulta_sql($con_item);
			//para cada item da nota
			while($reg_item = consulta_ler_objeto($res_item)){
				//consulta os dados do produto
				$con_prod = 'SELECT Codigo_Depart, Codigo_Fornecedor FROM produto '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
							' AND Id_Produto = "'.$reg_item->Id_Produto.'"';
				$res_prod = consulta_sql($con_prod);
				$reg_prod = consulta_ler_objeto($res_prod);
				consulta_limpa($res_prod);
				/* ' Id_Produto, Quantidade, Valor_Total, Valor_Produto, '.
				' Valor_ICMS, Valor_ICMS_ST, '.
				' Valor_IPI, Valor_PIS, Valor_COFINS, '.
				' CFOP, CFOP_Descricao, CFOP_GeraContas, CFOP_MovEstoque, '.
				' Cultura, Cultura_Desc, Peneria, Nr_Lote, '.
				' Peso_Bruto, Peso_Liquido, '.
				' Produto_Codigo, Produto_Descricao, '.
				' Produto_Unidade, Produto_Depart, Produto_Fornecedor ) VALUES ('; */
				//faz insert na tabela de movimento


                /// 24/07/2020
				$ins_item =  $ins_base.
							' "'.$reg_item->Id_Produto.'", "'.$reg_item->Quantidade_Estoque.'", '.
							' "'.($reg_item->Valor_Total+$reg_item->Valor_Frete+$reg_item->Valor_Seguro+$reg_item->Valor_Outros).'", '.
							' "'.($reg_item->Quantidade_NF*$reg_item->Valor_Unitario).'", '.
							' "'.$reg_item->ICMS_Valor.'", "'.$reg_item->ICMSST_Valor.'", '.
							' "'.$reg_item->IPI_Valor.'", "'.$reg_item->PIS_Valor.'", "'.$reg_item->COFINS_Valor.'",'.
							' "'.$reg_item->CFOP.'", "'.$reg_nota->Nat_Op_Descricao.'", '.
							' "'.$reg_nota->Nat_Op_Gera_Contas.'", "'.$reg_nota->Nat_Op_Mov_Estoque.'", '.
							' "", "", "'.$reg_item->Peneria.'", "'.$reg_item->NrLote.'",'.
							' "'.$reg_item->Peso_Bruto.'", "'.$reg_item->Peso_Liquido.'",'.
							' "'.$reg_item->Codigo_Produto.'", "'.$reg_item->Prod_Descricao.'",'.
							' "'.$reg_item->Unidade_Estoque.'", "'.$reg_prod->Codigo_Depart.'", "'.$reg_prod->Codigo_Fornecedor.'")';
				$id_mov = consulta_sql($ins_item,true,2);
				
				//fiz separado porque  campo novo e nao quero que afete outros porque isso s? vale pra sul messmo
				$del_base = 'UPDATE movimento_vendas SET '.
							' NFe_Chave="'.$reg_nota->NFe_Chave.'", '.
							' Produto_NCM="'.$reg_item->Prod_NCM.'", '.	
							' Pessoa_Logradouro= "'.$reg_nota->Dest_Logradouro.'", '.
							' Pessoa_EnderNum= "'.$reg_nota->Dest_Numero.'", '.
							' Pessoa_Complemento= "'.$reg_nota->Dest_Complemento.'", '.
							' Pessoa_Bairro= "'.$reg_nota->Dest_Bairro.'", '.
							' Pessoa_CEP= "'.$reg_nota->Dest_CEP.'", '.
							' Seq_Item_Nota="'.$reg_item->Seq_Item.'", '.
							' Nr_Receituario="'.$reg_item->Nr_Receituario.'", '.
							' Pessoa_CodCidade= "'.$reg_nota->Dest_Codigo_Cidade.'" '.
							' where id="'.$id_mov.'"';
				consulta_sql($del_base);
				//adicionado seq-item e receituario da nota fiscal item no Movimento_vendas para a sql do Receituario em 17-10-2022 por @isabel

				/* if((($reg_nota->Nat_Op_Mov_Estoque == 'D') && ($reg_nota->Nat_Op_Gera_Contas != 'A')) ||
				(($reg_nota->Nat_Op_Mov_Estoque == 'A') && ($reg_nota->Nat_Op_Gera_Contas == 'A'))){
				$idc = 1;
				if((($reg_nota->Nat_Op_Mov_Estoque == 'A') && ($reg_nota->Nat_Op_Gera_Contas == 'A'))){
				$idc = -1;

				}
				calcularSaldoProdutoVendaDia($reg_item->Id_Produto, datad(dataf($reg_nota->DH_EntSai)), $reg_item->Quantidade_Estoque * $idc);
				} */
			}
			consulta_limpa($res_item);
			$sinal = '+';
		}
	}

	function recalcula_total_comunicado_venda($nr_comunicado){
		$con_comunicado = 'SELECT * FROM comunicado_venda '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"';
		$res_comunicado = consulta_sql($con_comunicado);
		$reg_comunicado = consulta_ler_objeto($res_comunicado);
		consulta_limpa($res_comunicado);
		if (($reg_comunicado->Situacao == 'E') || ($reg_comunicado->Situacao == 'A')){
			$con_prod = 'SELECT IFNULL(SUM(Valor_Mensal), 0), IFNULL(SUM(Valor_Licensa), 0),'.
						' IFNULL(SUM(Valor_Mensal > 0), 0), IFNULL(SUM(Valor_Licensa > 0), 0) '.
						' FROM comunicado_venda_itens '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"'.
						' AND Situacao = "A"';
			$res_prod = consulta_sql($con_prod);
			$reg_copia = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);
			$ins_cad = 'UPDATE comunicado_venda SET '.
						' Valor_Manutencao = "'.$reg_copia[0].'",'.
						' Valor_Licenca = "'.$reg_copia[1].'",'.
						' Valor_Total = ((Valor_Licenca+Valor_Customizacao) - Desconto_Licenca), '.
						' Nr_Copias = "'.$reg_copia[2].'", '.
						' Nr_Manutencao = "'.$reg_copia[2].'" '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"';
			consulta_sql($ins_cad);
			$ins_cad = 'DELETE FROM comunicado_venda_parcela '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"';
			consulta_sql($ins_cad);
		}
	}

	function insere_hist_comunicado_venda($nr_comunicado,$seq_item,$tipo,$valor_novo=0){
		if ($tipo == 'A'){
			$seq = 1;
			//deleta seq 1
			$del_hist = 'DELETE FROM comunicado_venda_itens '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"'.
						' AND Seq_Item = "'.$seq_item.'"'.
						' AND Seq_Hist = 1';
			consulta_sql($del_hist);
		}else{
			$con_seq = 'SELECT (IFNULL(MAX(Seq_Item), 0) + 1) FROM comunicado_venda_itens_hist '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
						' AND Nr_Comunicado = "'.$nr_comunicado.'"'.
						' AND Seq_Item = "'.$seq_item.'"';
			$res_seq = consulta_sql($con_seq);
			$reg_seq = consulta_ler_linha($res_seq);
			consulta_limpa($res_seq);
			$seq = $reg_seq[0];
		}
		$con_men = 'SELECT Valor_Atual_Mensal FROM comunicado_venda_itens '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Comunicado = "'.$nr_comunicado.'"'.
					' AND Seq_Item = "'.$seq_item.'"';
		$res_men = consulta_sql($con_men);
		$reg_men = consulta_ler_linha($res_men);
		consulta_limpa($res_men);
		$valor_antes = $reg_men[0];
		if ($valor_novo <= 0){
			$valor_novo = $valor_antes;
		}
		$ins_hist = 'INSERT INTO comunicado_venda_itens_hist '.
					' (Dominio, Empresa, Nr_Comunicado, Seq_Item, Seq_Hist, '.
					' TipoMov, Valor_Antes, Valor_Depois, Situacao, '.
					' DH_Alteracao, Usuario_Alteracao) VALUES ('.
					'"'.$_SESSION["Dominio"].'",'.
					'"'.$_SESSION["Empresa_Codigo"].'",'.
					'"'.$nr_comunicado.'",'.
					'"'.$seq_item.'",'.
					'"'.$seq.'",'.
					'"'.$tipo.'",'.
					'"'.$valor_antes.'",'.
					'"'.$valor_novo.'",'.
					'"A",'.
					'now(),'.
					'"'.base64_decode_si($_REQUEST['USER_ID']).'" '.
					')';
		consulta_sql($ins_hist);
	}

	function pedido_carga_recalcula($empresa,$carga){
		$con_ped = 'SELECT IFNULL(SUM(Valor_Pedido), 0) FROM pedido_carga_pedido '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Nr_Carga = "'.$carga.'"';
		$res_ped = consulta_sql($con_ped);
		$reg_ped = consulta_ler_linha($res_ped);
		consulta_limpa($res_ped);
		$con_ite = 'SELECT IFNULL(SUM(Valor_Total), 0) FROM pedido_carga_item '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Nr_Carga = "'.$carga.'"'.
					' AND Nr_Pedido = 0';
		$res_ite = consulta_sql($con_ite);
		$reg_ite = consulta_ler_linha($res_ite);
		consulta_limpa($res_ite);
		$update = 'UPDATE pedido_carga SET '.
					' Valor_Total = "'.($reg_ite[0] + $reg_ped[0]).'" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$empresa.'"'.
					' AND Nr_Carga = "'.$carga.'"';
		consulta_sql($update);
	}

	function produto_margem_minima($id_produto, $empresa = ''){
		if ($empresa == ''){
			$empresa = $_SESSION["Empresa_Codigo"];
		}
		$margem = 0;
		// No faz consultas
		if ($_SESSION["Dominio"] == 2){
			return $margem;
		}
		$con_pro = 'SELECT Codigo_Fornecedor, Margem_Preco_Minimo, Codigo_Depart FROM produto '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Id_Produto = "'.$id_produto.'"';
		$res_pro = consulta_sql($con_pro);
		$reg_pro = consulta_ler_objeto($res_pro);
		consulta_limpa($res_pro);
		$tp_margem = BuscaParam('MARGEM_TIPO');
		if ($tp_margem == 'P'){
			$margem = $reg_pro->Margem_Preco_Minimo;
			if ($margem <= 0){
				$con_for = 'SELECT Margem_Preco_Minimo FROM pessoa_fornecedor '.
				' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				' AND Pessoa = "'.$reg_pro->Codigo_Fornecedor.'"';
				$res_for = consulta_sql($con_for);
				$reg_for = consulta_ler_objeto($res_for);
				consulta_limpa($res_for);
				$margem = $reg_for->Margem_Preco_Minimo;
			}
		}
		if (($tp_margem == 'P') || ($tp_margem == 'D')){
			if ($margem <= 0){
				$con_dep = 'SELECT Margem_Preco_Minimo FROM produto_departamento '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Codigo_Depart = "'.$reg_pro->Codigo_Depart.'"';
				$res_dep = consulta_sql($con_dep);
				$reg_dep = consulta_ler_objeto($res_dep);
				consulta_limpa($res_dep);
				$margem = $reg_dep->Margem_Preco_Minimo;
			}
		}
		if ($tp_margem == 'P'){
			if ($margem <= 0){
				$con_emp = 'SELECT Margem_Preco_Minimo FROM pessoa_empresa '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$empresa.'"';
				$res_emp = consulta_sql($con_emp);
				$reg_emp = consulta_ler_objeto($res_emp);
				consulta_limpa($res_emp);
				$margem = $reg_emp->Margem_Preco_Minimo;
			}
			if ($margem <= 0){
				$margem = BuscaParam('MARGEM_PRECO_MINIMO');
			}
		}
		return $margem;
	}

	function produto_margem_minima2($id_produto, $empresa = ''){
		if ($empresa == ''){
			$empresa = $_SESSION["Empresa_Codigo"];
		}
		$margem = 0;
		$con_pro = 'SELECT Codigo_Fornecedor, Margem_Preco_Minimo, Codigo_Depart FROM produto '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Id_Produto = "'.$id_produto.'"';
		$res_pro = consulta_sql($con_pro);
		$reg_pro = consulta_ler_objeto($res_pro);
		consulta_limpa($res_pro);
		$tp_margem = BuscaParam('MARGEM_TIPO');
		if ($tp_margem == 'P'){
			$margem = $reg_pro->Margem_Preco_Minimo;
			if ($margem <= 0){
				$con_for = 'SELECT Margem_Preco_Minimo FROM pessoa_fornecedor '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_pro->Codigo_Fornecedor.'"';
				$res_for = consulta_sql($con_for);
				$reg_for = consulta_ler_objeto($res_for);
				consulta_limpa($res_for);
				$margem = $reg_for->Margem_Preco_Minimo;
			}
		}
		if (($tp_margem == 'P') || ($tp_margem == 'D')){
			if ($margem <= 0){
				$con_dep = 'SELECT Margem_Preco_Minimo FROM produto_departamento '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Codigo_Depart = "'.$reg_pro->Codigo_Depart.'"';
				$res_dep = consulta_sql($con_dep);
				$reg_dep = consulta_ler_objeto($res_dep);
				consulta_limpa($res_dep);
				$margem = $reg_dep->Margem_Preco_Minimo;
			}
		}
		if ($tp_margem == 'P'){
			if ($margem <= 0){
				$con_emp = 'SELECT Margem_Preco_Minimo FROM pessoa_empresa '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$empresa.'"';
				$res_emp = consulta_sql($con_emp);
				$reg_emp = consulta_ler_objeto($res_emp);
				consulta_limpa($res_emp);
				$margem = $reg_emp->Margem_Preco_Minimo;
			}
			if ($margem <= 0){
				$margem = BuscaParam('MARGEM_PRECO_MINIMO');
			}
		}
		return $margem;
	}

	function produto_preco_minima($id_produto, $empresa = '', $nr_compra = ''){
		if ($empresa == ''){
			$empresa = $_SESSION["Empresa_Codigo"];
		}
		$tp_margem = BuscaParam('MARGEM_TIPO');
		$minimo = 0;
		if (($tp_margem == 'P') || ($tp_margem == 'D')){
			$margem = produto_margem_minima($id_produto, $empresa);
			$con_custo = 'SELECT Preco_Custo, Custo_Referencial FROM produto_saldo_filial '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' AND Id_Produto = "'.$id_produto.'" '.
						' ORDER BY Local_Armaz ASC '.
						' LIMIT 1';
			$res_custo = consulta_sql($con_custo);
			$reg_custo = consulta_ler_linha($res_custo);
			consulta_limpa($res_custo);
			$preco_custo = 0;
			if (isset($reg_custo)){
				$preco_custo = $reg_custo[1];
			}
			if ($nr_compra != ''){
				$exp_pedido = explode('_',$nr_compra);
				$nr_pedcompra = $exp_pedido[1];
				$empresa_compra = $exp_pedido[0];
				$cons_comp_item = 'SELECT Valor_Unitario FROM pedido_compra_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$empresa_compra.'"'.
								' AND Numero_Pedido = "'.$nr_pedcompra.'"'.
								' AND Id_Produto = "'.$id_produto.'"'.
								' AND ((Status = "A") OR (Status = "P"))';
				$res_comp_item = consulta_sql($cons_comp_item);
				$nrw_comp_item = consulta_num_registros($res_comp_item);
				if ($nrw_comp_item > 0){
					$reg_comp_item = consulta_ler_linha($res_comp_item);
					$preco_custo = $reg_comp_item[0];
				}
				consulta_limpa($res_comp_item);
			}
			if ($preco_custo > 0){
				$minimo = $preco_custo + ($preco_custo * ($margem) / 100);
			}
		}
		return $minimo;
	}

	function retorna_custo_produto($id_produto, $qtdade, $nivel = 0, $cont = 0){
		$custo = 0;
		$cons_saldo = 'SELECT Preco_Custo FROM produto_saldo_filial '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
						' AND Codigo_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'"';
		$res_saldo = consulta_sql($cons_saldo);
		$nrows = consulta_num_registros($res_saldo);
		if ($nrows == 0){
			$cons_saldo = 'SELECT Preco_Custo FROM produto_hist_custo '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Id_Produto = "'.$id_produto.'" '.
						' ORDER BY DH_Custo DESC '.
						' LIMIT 1';
			$res_saldo = consulta_sql($cons_saldo);
		}
		$reg_saldo = consulta_ler_linha($res_saldo);
		consulta_limpa($res_saldo);
		$precoCusto = 0;
		if (isset($reg_saldo)){
			$precoCusto = $reg_saldo[0];
		}
		$custo+= ($qtdade * $precoCusto);
		$con_composi = 'SELECT Id_Produto_Origem, Quantidade FROM produto_composicao  '.
						' WHERE Dominio = '.$_SESSION["Dominio"].
						' AND Id_Produto_Final = "'.$id_produto.'"'.
						' AND Situacao = "A" '.
						' ORDER by Id_Produto_Origem';
		$res_composi = consulta_sql($con_composi);
		$nrw_composi = consulta_num_registros($res_composi);
		if ($nrw_composi > 0){
			$custo = 0;
		}
		for($cp=0;$cp<$nrw_composi;$cp++){
			$reg_composi = consulta_ler_objeto($res_composi);
			$custo+= retorna_custo_produto($reg_composi->Id_Produto_Origem, $reg_composi->Quantidade, $nivel + 1);
			$cont+= 1;
		}
		consulta_limpa($res_composi);
		if ($cont > 0){
			$custo = $custo * $qtdade;
		}
		return $custo;
	}

	function atualiza_funcionario($funcionario){
		$con_func = 'SELECT Valor_Salario, Estagiario, Comissionado, Primeiro_Emprego, Menor_Aprendiz, '.
					' Empresa, Setor, Cargo, Temporario, Centro_Custo, Empresa_Lotado '.
					' FROM t_pessoa_funcionario_salario '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Pessoa = "'.$funcionario.'"'.
					' AND Situacao = "A"'.
					' ORDER BY Data DESC, Seq_Salario DESC '.
					' LIMIT 1 ';
		$res_func = consulta_sql($con_func);
		$nro_func = consulta_num_registros($res_func);
		if ($nro_func > 0){
			$reg_func = consulta_ler_objeto($res_func);
			$con_pessoa_hist = 'SELECT Empresa_Terceirizada FROM t_pessoa_funcionario_historico '.
								' WHERE Dominio="'.$_SESSION["Dominio"].'" '.
								' AND Pessoa = "'.$funcionario.'" '.
								' AND Situacao <> "E" '.
								' ORDER BY Data_Inicio DESC '.
								' LIMIT 1';
			$res_pessoa_hist = consulta_sql($con_pessoa_hist);
			$reg_pessoa_hist = consulta_ler_linha($res_pessoa_hist);
			consulta_limpa($res_pessoa_hist);
			$emp_terceirizada = 0;
			if (isset($reg_pessoa_hist)){
				$emp_terceirizada = $reg_pessoa_hist[0];
			}
			$update = 'UPDATE t_pessoa_funcionario SET '.
					' Valor_Salario = "'.$reg_func->Valor_Salario.'", '.
					' Estagiario = "'.$reg_func->Estagiario.'", '.
					' Comissionario = "'.$reg_func->Comissionado.'", '.
					' Primeiro_Emprego = "'.$reg_func->Primeiro_Emprego.'", '.
					' Menor_Aprendiz = "'.$reg_func->Menor_Aprendiz .'", '.
					' Empresa_Atual = "'.$reg_func->Empresa.'", '.
					' Setor_Atual = "'.$reg_func->Setor.'", '.
					' Cargo_Atual = "'.$reg_func->Cargo.'", '.
					' Temporario = "'.$reg_func->Temporario.'", '.
					' Empresa_Terceirizada = "'.$emp_terceirizada.'", '.
					' Centro_Custo_Atual = "'.$reg_func->Centro_Custo.'", '.
					' Empresa_Lotado = "'.$reg_func->Empresa_Lotado.'" '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Pessoa = "'.$funcionario.'" ';
			consulta_sql($update);
		}
		consulta_limpa($res_func);
	}

	//Funo para campos do fechamento da ordem de produo.
	function retorna_campos_op($dominio){
		$retorno = false;
		switch ($dominio){
			case 56:
			case -2:
				$retorno = true;
				break;
			default:
				$retorno = false;
				break;
		}
		return $retorno;
	}

	function retorna_campos_estoque_remessas($dominio){
		$retorno = false;
		switch ($dominio){
			case 41:
			case 4:
			case -2:
				$retorno = true;
				break;
			default:
				$retorno = false;
				break;
		}
		return $retorno;
	}

	function oculta_em_cobranca($dominio){
		$retorno = false;
		switch ($dominio){
			case 40: //MBR
			case -2:
				$retorno = true;
				break;
			default:
				$retorno = false;
				break;
		}
		return $retorno;
	}

	function atualiza_forma_pagto(){
		if ($_SESSION['Dominio'] == '4'){
			$upd_ped = 'UPDATE pedido SET '.
						' Fatura_Tipo = "B" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Status = "L" '.
						' AND ((Forma_Pagto = "34") OR (Forma_Pagto = "42"))';
			consulta_sql($upd_ped);
			$upd_ped = 'UPDATE pedido SET '.
						' Fatura_Tipo = "M" '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Status = "L" '.
						' AND Forma_Pagto = "1"';
			consulta_sql($upd_ped);
			//#depois de corrigir no PedidosAgeis, remover daqui
			$cons_ped = 'SELECT Numero_Pedido, Pessoa, Empresa FROM pedido'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Status = "L"';
			$res_ped = consulta_sql($cons_ped);
			$nrw_ped = consulta_num_registros($res_ped);
			for($p=0;$p<$nrw_ped;$p++){
				$reg_ped = consulta_ler_linha($res_ped);
				$cons_pess = 'SELECT Frete_Padrao FROM pessoa_cliente'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Pessoa = "'.$reg_ped[1].'"';
				$res_pess = consulta_sql($cons_pess);
				$reg_pess = consulta_ler_linha($res_pess);
				consulta_limpa($res_pess);
				$upd_ped = 'UPDATE pedido SET '.
							' Frete = "'.$reg_pess[0].'"'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$reg_ped[2].'"'.
							' AND Numero_Pedido = "'.$reg_ped[0].'"';
				consulta_sql($upd_ped);
			}
			consulta_limpa($res_ped);
		}
	}

	function mostra_hint_multi(){
		$hint = 'Para selecionar um intervalo de registros, clique no primeiro registro da sequncia, segure a tecla <b>SHIFT</b>, e depois clique no ltimo registro da sequncia.<br><br>Para selecionar mltiplos registros que no estejam em sequncia, segure a tecla <b>CTRL</b> enquanto seleciona os registros desejados.<br><br>Selecione apenas o primeiro registro (<b>EM BRANCO</b> ) para remover o filtro.';
		return $hint;
	}

	/** Adicionado em 13-09-2022 para Produtos - Medicamentos por @isabel*/
	function mostra_hint_medicamento(){
		$recomendacao_externa = 'No caso de produtos que so registrados no Ministrio da Agricultura, Pecuria e Abastecimento (MAPA), recomenda-se que seja inserido o termo ISENTO, seguido do registro/cadastro do MAPA.(https://andav.com.br/publications/atencao-as-mudancas-na-nota-fiscal-para-insumos-veterinarios/)<br>';
		$hint = '<b>Medicamentos</b><br>
			Informaes obrigatrias para emisso de notas com produtos que contenham NCMs iniciados com <b>3001, 3002, 3003, 3004, 3005 ou 3006</b>.<br>
			Tal obrigao visa atender a <b>Instruo Normativa ANVISA N 100/2021</b> que trata do Sistema Nacional de Controle de Medicamentos, cumprindo a <b>Lei N 11.903/2009</b> que dispe sobre a rastreabilidade de medicamentos.<br>
			Utilizar o nmero do registro ANVISA (11 ou 13 caracteres) ou preencher com o literal <b>ISENTO</b>, no caso de medicamento isento de registro na ANVISA ou quando o produto no possuir registro especfico.<BR>
			 Para medicamento isento de registro na ANVISA, informar o nmero da deciso que o isenta, como por exemplo o nmero da Resoluo da Diretoria Colegiada da ANVISA (RDC). <br>			
			Para medicamentos  necessrio ativar o <b>Controle por Lote</b>, localizado na aba "Bsico". ';
		return $hint;
	}
	/** Adicionado em 02-01-2024 para informar como selecionar os produtos por @isabel*/
	function mostra_hint_produtos(){
		$hint = 'Adicione o <b>Cdigo do produto</b> ou <b>Cdigo de Barra</b> do produto que deseja exportar.<br><br>Caso deseje exportar mais de um produto, adicione o Cdigo do produto ou o Cdigo de Barra, seguido de ponto e virgula (<b>;</b>), replique at finalizar todos os produtos desejados.';
		return $hint;
	}

	function previsao_orcamentaria_recalcula($nr_orcamento){
		$con_item = 'SELECT IFNULL(SUM(Valor), 0), IFNULL(SUM(Valor_Realizado), 0), IFNULL(SUM(Valor_Previsto), 0) FROM previsao_orcamentaria_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Nr_Orcamento = "'.$nr_orcamento.'"'.
					' AND Situacao <> "E"';
		$res_item = consulta_sql($con_item);
		$reg_item = consulta_ler_linha($res_item);
		consulta_limpa($res_item);
		$consulta = 'UPDATE previsao_orcamentaria SET '
					.' Valor = "'.$reg_item[0].'", '
					.' Valor_Realizado = "'.$reg_item[1].'", '
					.' Valor_Previsto = "'.$reg_item[2].'" '
					.' WHERE Dominio = "'.$_SESSION["Dominio"].'"'
					.' AND Nr_Orcamento = "'.$nr_orcamento.'"';
		consulta_sql($consulta);
	}

	function busca_codigo_cidade_siafi($cod_cidade){
		$codSIAFI = '';
		$con_item = 'SELECT CodSIAFI FROM cidade '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Codigo_Cidade = "'.$cod_cidade.'"';
		$res_item = consulta_sql($con_item);
		$reg_item = consulta_ler_linha($res_item);
		consulta_limpa($res_item);
		if (isset($reg_item)){
			$codSIAFI = $reg_item[0];
		}
		return $codSIAFI;
	}

	function atualiza_preco_pedido($nr_pedido, $empresa = '', $seq = ''){
		if ($empresa == ''){
			$empresa = $_SESSION["Empresa_Codigo"];
		}
		$con_pedido = 'SELECT Pessoa FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		consulta_limpa($res_pedido);
		$cons_ped_item = 'SELECT ID_Produto, Empresa, Numero_Pedido, Seq_Item FROM pedido_item '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
		if ($seq != ''){
			$cons_ped_item.= ' AND Seq_Item = "'.$seq.'"';
		}
		$cons_ped_item.= ' AND Status <> "E"'.
						' AND Status <> "C"'.
						' AND Status <> "F"';
		$res_ped_item = consulta_sql($cons_ped_item);
		$nro_ped_item = consulta_num_registros($res_ped_item);
		$atualizou = false;
		for($i=0;$i<$nro_ped_item;$i++){
			$reg_ped_item = consulta_ler_objeto($res_ped_item);
			$con_preco = 'SELECT Preco FROM produto_pessoa_preco '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Id_Produto = "'.$reg_ped_item->ID_Produto.'"'.
						' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
						' AND ((Data_Inicio <= "'.data_atual('date').'") OR (Data_Inicio = "0000-00-00")) '.
						' AND ((Data_Fim >= "'.data_atual('date').'") OR (Data_Fim = "0000-00-00")) '.
						' ORDER BY Seq DESC';
			$res_preco = consulta_sql($con_preco);
			$reg_preco = consulta_ler_linha($res_preco);
			consulta_limpa($res_preco);
			if ($reg_preco[0] > 0){
				$upd_item = 'UPDATE pedido_item SET'.
							' Valor_Unitario = "'.$reg_preco[0].'", '.
							' Valor_Total = (Qtd*Valor_Unitario) - Valor_Desconto, '.
							' Valor_Imposto = (Valor_Total * Perc_Imposto / 100) '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$reg_ped_item->Empresa.'"'.
							' AND Numero_Pedido = "'.$reg_ped_item->Numero_Pedido.'"'.
							' AND Seq_Item = "'.$reg_ped_item->Seq_Item.'"';
				$res_item = consulta_sql($upd_item,true,1);
				if ($res_item > 0){
					$atualizou = true;
				}
			}
		}
		consulta_limpa($res_ped_item);
		if ($atualizou){
			pedido_recalculo($nr_pedido);
			$integradoUp = ' IntegradoUp = "N", Integrado_Demander = "N", ';
			if ($reg_pedido->Pessoa < 100){
				$integradoUp = '';
			}
			if ($reg_pedido->Pessoa == $empresa){
				$integradoUp = '';
			}
			$atualiza_pedido_status = 'UPDATE pedido SET '.
										$integradoUp.
										' Integrado = "N" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										' AND Empresa = "'.$empresa.'"'.
										' AND Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($atualiza_pedido_status);
		}
	}

	function pedido_calcula_impostos($empresa, $nr_pedido, $pessoa, $local_fatura, $produto, $kit = true){
		$perc_imposto = '';
		$con_prod = 'SELECT * FROM produto '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Produto = "'.$produto.'"';
		$res_prod = consulta_sql($con_prod);
		$reg_prod = consulta_ler_objeto($res_prod);
		consulta_limpa($res_prod);
		$usa_kit = (($reg_prod->Baixa_Estoque == 'K') && ($kit));
		if ($usa_kit){
			//consulta pra saber se tem componentes
			$dados_kit = busca_produtos_kit($reg_prod->Id_Produto);
			$usa_kit = ($dados_kit['cont']>0);
		}
		if ($usa_kit){
			$total_kit = 0;
			//$dados_kit2 = $dados_kit;
			foreach($dados_kit['lista'] as $id_k=>$valores_k){
				//soma o valor no total do kit
				$dados_kit['lista'][$id_k]['Qtd'] = arredonda_numero_menos($dados_kit['lista'][$id_k]['Qtd']* 1000)/1000;
				$total_kit+=  arredonda_numero_menos($dados_kit['lista'][$id_k]['Qtd']*$dados_kit['lista'][$id_k]['Preco']*100)/100;
			}
			$totalg_kit  = 100;
			$total_perc = 0;
			//monta o percentual base do preo
			if ($total_kit>0){
				$perc_preco = $totalg_kit / $total_kit;
			}else{
				$perc_preco = 1;
			}
			foreach($dados_kit['lista'] as $id_k=>$valores_k){
				$imposto_item = ($dados_kit['lista'][$id_k]['Qtd']*$dados_kit['lista'][$id_k]['Preco'])*$perc_preco;
				$perc_item = pedido_calcula_impostos($empresa,$nr_pedido, $pessoa,$local_fatura,$id_k,false);
				// echo 'produto'.$produto.'-perc_imposto'.$perc_imposto.'-imposto_item'.$imposto_item.'-perc_item'.$perc_item.'<BR>';
				$perc_imposto+= ($imposto_item * $perc_item)/100;
			}
		}else{
			//descobr o tipo de pedido
			$con_pedido='select Tipo_Pedido from pedido '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Empresa="'.$empresa.'"'.
						' and Numero_Pedido="'.$nr_pedido.'" ';
			$res_pedido = consulta_sql($con_pedido);
			$reg_pedido = consulta_ler_objeto($res_pedido);
			consulta_limpa($res_pedido);
			//descobre a cfop base
			$con_tipop ='select CFOP from tipo_pedido '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Codigo_Tipo = "'.$reg_pedido->Tipo_Pedido.'"';
			$res_tipop = consulta_sql($con_tipop);
			$reg_tipop = consulta_ler_objeto($res_tipop);
			consulta_limpa($res_tipop);
			$cfop_base = '5.'.fill_full($reg_tipop->CFOP,3);
			if ($reg_pedido->Tipo_Pedido<0){
				$cfop_base = '1.'.fill_full($reg_tipop->CFOP,3);
			}
			$impostos = impostos_produto($empresa,$pessoa,$local_fatura,$produto, 0, $cfop_base);
			//calcula os impostos desse produto (CIMS ICMS ST e IPI)
			//print_r($impostos);
			$ipi = 0;
			$icms = 0;
			$red = 0;
			$base_st = 0;
			if (isset($impostos['icms'][$reg_prod->Codigo_Classe_Tributo])){
				$ipi = $impostos['ipi'][$reg_prod->Codigo_Classe_Tributo];
				$icms = $impostos['icms'][$reg_prod->Codigo_Classe_Tributo];
				$icms_st = $impostos['icms_st'][$reg_prod->Codigo_Classe_Tributo];
				$red_icms_st = $impostos['red_icms_st'][$reg_prod->Codigo_Classe_Tributo];
				$mva_icms_st = $impostos['mva_icms_st'][$reg_prod->Codigo_Classe_Tributo];
				if ($red_icms_st > 0){
					$mva_icms_st = $mva_icms_st * ((100 - $red_icms_st) / 100);
				}
				$vl_ipi = $ipi;
				$bc_in = 100 + $vl_ipi;
				$vl_in = $bc_in * ($icms / 100);
				$bc_st = $bc_in + ($bc_in * ($mva_icms_st / 100));

				$st_por_dentro = (BuscaParam('ICMSST_DENTRO')=='S');
				if (($mva_icms_st==0)&&($red_icms_st==0)&&($st_por_dentro)&&($icms_st>$icms)&&($icms_st<100)){
					$dif_aliq = (100 - ($icms_st))/100;
					$base1 = $bc_st - $vl_in;
					$bc_st = ( ($base1 / $dif_aliq)*100)/100;
				}
				//if(($icms_st > 0) && ($vl_in > 0) && ($bc_st > 0)){
				//   $perc2 = (1 - ($icms_st / 100));
				//   $bc_st = ($bc_st - $vl_in);
				//   $bc_st = ($bc_st / $perc2);
				//}
				$vl_st = (($bc_st * ($icms_st / 100)) - ($vl_in));
				if ($vl_st < 0.01){
					$vl_st = 0;
				}
				$perc_imposto = ($vl_ipi + $vl_st);
			}
		}
		return $perc_imposto;
	}

	function pedido_calcula_bloqueio_financeiro($empresa, $nr_pedido){
		//valida o custo dos itens (confome pedido de compra)
		$Bloqueado_Financeiro_Motivo = '';
		if ($_SESSION["Dominio"] == '2'){
			$bloquear = 'N';
			$tem_fertilizantes = false;
			$con_pedido = 'SELECT * FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
			$res_pedido = consulta_sql($con_pedido);
			$reg_pedido = consulta_ler_objeto($res_pedido);
			consulta_limpa($res_pedido);
			if ($reg_pedido->Pessoa > 100){ //transferncia no conta pra esse teste
				$cons_item = 'SELECT * FROM pedido_item'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$empresa.'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"'.
							' AND Status <> "C" '.
							' AND Status <> "E"'.
							' ORDER BY Seq_Item ';
				$res_item = consulta_sql($cons_item);
				$nrows_item = consulta_num_registros($res_item);
				for($i=0;$i<$nrows_item;$i++){
					$reg_item = consulta_ler_objeto($res_item);
					//consulta para saber se o custo  inferiro  compra
					$con_prod = 'SELECT Codigo_Depart, Preco_Venda1, Codigo_Produto, Descricao_Completa FROM produto '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Id_Produto = "'.$reg_item->ID_Produto.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_objeto($res_prod);
					consulta_limpa($res_prod);
					$desc_item = '
'.                               'Item: '.$reg_item->Seq_Item.' Produto: '.$reg_prod->Codigo_Produto.'-'.$reg_prod->Descricao_Completa.' ';

					$con_hist = 'SELECT Preco_Custo_Ult_Entrada FROM produto_hist_custo '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Id_Produto = "'.$reg_item->ID_Produto.'" '.
								' ORDER BY DH_Custo DESC '.
								' LIMIT 1 ';
					$res_hist = consulta_sql($con_hist);
					$reg_hist = consulta_ler_objeto($res_hist);
					consulta_limpa($res_hist);
					$custo = 0;
					if (isset($reg_hist)){
						$custo = $reg_hist->Preco_Custo_Ult_Entrada;
					}
					if ($reg_prod->Codigo_Depart == 14){
						$custo = 0;
					}
					$con_hist_fin = 'select DH_Liberacao, Valor_Unitario from pessoa_liberacao_fat '.
									  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
									  ' and ((Pessoa = "'.$reg_pedido->Pessoa.'") '.
									  ' or (Pessoa = 0)) '.
									  ' and Id_Produto="'.$reg_item->ID_Produto.'"'.
									  ' order by DH_Liberacao Desc limit 1';
					$res_hist_fin = consulta_sql($con_hist_fin);
					$reg_hist_fin = consulta_ler_linha($res_hist_fin);
					consulta_limpa($res_hist_fin);
					$dt_lib = data2nr(dataf($reg_hist_fin[0]));
					if ($dt_lib>=data_atual('num')){
						$preco_liberado = $reg_hist_fin[1];
						if ($preco_liberado<$custo){
							$custo = $preco_liberado;
						}
					}
					if ($reg_item->Qtd > 0){
						$venda = $reg_item->Valor_Total / $reg_item->Qtd;
					}else{
						$venda = $reg_item->Valor_Total;
					}
					//busca a margem minima do departamento do produto atual
					$perc_desc = (produto_margem_minima2($reg_item->ID_Produto)) / 100;
					if ($perc_desc == 0){
						$perc_desc = 1;
					}
					if ($reg_prod->Codigo_Depart == 4){
						$tem_fertilizantes = true;
					}
					$preco_minimo = ($reg_prod->Preco_Venda1 - ($reg_prod->Preco_Venda1 * $perc_desc)) ;
					if ($preco_minimo>$venda){
						$bloquear = 'S';
						$Bloqueado_Financeiro_Motivo.= $desc_item.'- Preo Abaixo do Mnimo!';
					}
					if ($reg_item->NrCompra > 0){
						$con_compra = 'SELECT IFNULL(MIN(Valor_Total / Qtd), 0) FROM pedido_compra_item '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND Empresa = "'.$reg_item->EmpresaCompra.'"'.
									' AND Numero_Pedido = "'.$reg_item->NrCompra.'"'.
  								    ' and ID_Produto="'.$reg_item->ID_Produto.'"'.
									' AND Qtd > 0 '.
									' AND Valor_Total > 0 '.
									' AND Status <> "C" '.
									' AND Status <> "E"';
						$res_compra = consulta_sql($con_compra);
						$reg_compra = consulta_ler_linha($res_compra);
						consulta_limpa($res_compra);
						if ($reg_compra[0] > 0){
							$custo = $reg_compra[0];
						}
					}
					if ($custo > $venda){
						$bloquear='S';
						$Bloqueado_Financeiro_Motivo.= $desc_item.'- Preo Abaixo do Custo!';
					}
				}
				consulta_limpa($res_item);
				if ($tem_fertilizantes){
					$con_vencto = 'SELECT IFNULL(MAX(DT_Vencimento), "0000-00-00") FROM pedido_parcela '.
									' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND Empresa = "'.$empresa.'"'.
									' AND Numero_Pedido = "'.$nr_pedido.'"';
					$res_vencto = consulta_sql($con_vencto);
					$reg_vencto = consulta_ler_linha($res_vencto);
					consulta_limpa($res_vencto);
					$dias = data2nr(dataf($reg_vencto[0])) - data_atual('num');//data2nr(dataf($reg_pedido->DH_Emissao));
					if ($dias > 40){
						$bloquear = 'S';
						$Bloqueado_Financeiro_Motivo.= '
'.                                  					'Prazo para Pagamento de Fertilizantes Acima do Permitido!' ;
					}
				}
			}
			$upt_pedido = 'UPDATE pedido SET '.
							' Bloqueado_Financeiro = "'.$bloquear.'",'.
							' Bloqueado_Financeiro_Motivo = "'.$Bloqueado_Financeiro_Motivo.'"'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$empresa.'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($upt_pedido);
		}
	}

	function pedido_reabrir($nr_pedido){
		$consulta = 'UPDATE pedido_item SET '.
					' Qtd_Liberada = Qtd_Atendida, '.
					' Status = "A"'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Empresa="'.$_SESSION["Empresa_Codigo"].'" '.
					' AND Numero_Pedido = "'.$nr_pedido.'" '.
					' AND ((Status = "A") OR (Status = "L"))'.
					' AND Qtd_Atendida = 0';
		$sql = consulta_sql($consulta,true,1);
		//remove todos os itens em aberto e fecha todos que foram atendidos parcialmente
		$con_del = 'UPDATE produto_saldo_filial_lote_reser SET '.
					' Situacao = "E" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Pedido_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' AND Pedido_Nr = "'.$nr_pedido.'" '.
					' AND Situacao = "A"';
		consulta_sql($con_del);
		$con_del = 'UPDATE produto_saldo_filial_lote_reser SET '.
					' Qtd_Reserva = Qtd_Atendida, '.
					' Situacao = "F" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
					' AND Pedido_Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' AND Pedido_Nr = "'.$nr_pedido.'" '.
					' AND Situacao = "P"';
		consulta_sql($con_del);
		pedido_calcula_status($nr_pedido);
		// if ($sql > 0){
		// 	//consulta A com Nr de Pedido de Compra
		// 	$con_req_item = 'select Seq_Item, SeqCompra, NrCompra, EmpresaCompra '.
		// 					' from pedido_item '.
		// 					' where Dominio = "'.$_SESSION['Dominio'].'" '.
		// 					' and Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
		// 					' and Numero_Pedido = "'.$nr_pedido.'" '.
		// 					' and (Status="A") '.
		// 					' and SeqCompra>0 '.
		// 					' and NrCompra>0 '.
		// 					' order by Seq_Item';
		// 	$res_req_item = consulta_sql($con_req_item);
		// 	$nro_req_item = consulta_num_registros($res_req_item);
		// 	for($i=0;$i<$nro_req_item;$i++){
		// 		$reg_req_item = consulta_ler_objeto($res_req_item);
		// 		//apaga pedido de compra

		// 		//verificacao para Zathura 
		// 		//MODIFICAO realizada em  13/10/2023  por @isabel
		// 		//Deixar sem excluir o Pedido de Compra 
		// 		$con_del = 'Update pedido_compra '.
		// 					' set Status="E" '.
		// 					' where Dominio="'.$_SESSION["Dominio"].'" '.
		// 					' and Empresa="'.$reg_req_item->EmpresaCompra.'"'.
		// 					' and Numero_Pedido="'.$reg_req_item->NrCompra.'" ';
		// 		consulta_sql($con_del);
		// 		//apaga pedido e seqCompra
		// 		$con_del = 'Update pedido_item '.
		// 					' set SeqCompra=-1, '.
		// 					' NrCompra=0, '.
		// 					' EmpresaCompra=0 '.
		// 					' where Dominio="'.$_SESSION["Dominio"].'" '.
		// 					' and Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
		// 					' and Numero_Pedido="'.$nr_pedido.'" '.
		// 					' and Seq_Item="'.$reg_req_item->Seq_Item.'"';
		// 		consulta_sql($con_del);
		// 	}
		// 	consulta_limpa($res_req_item);
		// }
		pedido_compra_deleta_saldo_vendido(($nr_pedido*(-1)), $_SESSION['Empresa_Codigo']);
	}

	function busca_produtos_kit($produto, $qtd = 1, $nivel = 1){
		$resposta = array();
		$resposta['cont'] = 0;
		$resposta['lista'] = array();
		if ($nivel > 10){
		}else{
			$con_prod = 'select * from produto '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Id_Produto="'.$produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_objeto($res_prod);
			consulta_limpa($res_prod);
			if ($reg_prod->Baixa_Estoque == 'K'){
				$con_comp = 'select composicao.Id_Produto_Origem, '.
							' composicao.Quantidade, '.
							' prod.Unidade_Venda, '.
							' prod.Preco_Venda1 '.
							' from produto_composicao composicao '.
							' inner join produto prod '.
							' on prod.Dominio=composicao.Dominio'.
							' and prod.Id_Produto=composicao.Id_Produto_Origem'.
							' where composicao.Dominio="'.$_SESSION["Dominio"].'"'.
							' and composicao.Id_Produto_Final="'.$produto.'"'.
							' and composicao.Situacao="A"'.
							' and prod.Codigo_Depart<>0'.
							' and prod.Preco_Venda1>0';
				$res_comp = consulta_sql($con_comp);
				$nrw_comp = consulta_num_registros($res_comp);
				for($c=0;$c<$nrw_comp;$c++){
					$reg_comp = consulta_ler_objeto($res_comp);
					$lista_comp = busca_produtos_kit($reg_comp->Id_Produto_Origem,1,$nivel+1);;
					if ($lista_comp['cont']==0){
						if (!isset($resposta['lista'][$reg_comp->Id_Produto_Origem])){
							$resposta['lista'][$reg_comp->Id_Produto_Origem] = array();
							$resposta['lista'][$reg_comp->Id_Produto_Origem]['Preco']= $reg_comp->Preco_Venda1;
							$resposta['lista'][$reg_comp->Id_Produto_Origem]['Qtd']  = 0;
							$resposta['lista'][$reg_comp->Id_Produto_Origem]['Unid'] = $reg_comp->Unidade_Venda;
							$resposta['cont']++;
						}
						$resposta['lista'][$reg_comp->Id_Produto_Origem]['Qtd']+=($qtd*$reg_comp->Quantidade);
					}else{
						$lista = $lista_comp['lista'];
						foreach($lista as $id => $valores){
							if (!isset($resposta['lista'][$id])){
								$resposta['lista'][$id]=array();
								$resposta['lista'][$id]['Preco']= $lista[$id]['Preco'];
								$resposta['lista'][$id]['Qtd']  = 0;
								$resposta['lista'][$id]['Unid'] = $lista[$id]['Unid'];
								$resposta['cont']++;
							}
							$resposta['lista'][$id]['Qtd']+=($lista[$id]['Qtd']*$reg_comp->Quantidade*$qtd);
						}
					}
				}
				consulta_limpa($res_comp);
			}
		}
		return $resposta;
	}

	function verifica_modulos(){
		$str = "0";
		if (BuscaParam('MODULO_NFE') == "S"){
			$str.= ",1";
		}
		if(BuscaParam('MODULO_CTE') == "S"){
			$str.= ",2";
		}
		if(BuscaParam('MODULO_SPED') == "S"){
			$str.= ",3";
		}
		if(BuscaParam('MODULO_ENTRADAS') == "S"){
			$str.= ",4";
		}
		if(BuscaParam('MODULO_FINANCEIRO') == "S"){
			$str.= ",5";
		}
		if(BuscaParam('MODULO-CEREAIS') != "SEM"){
			$str.= ",6";
		}
		if(BuscaParam('MODULO_MDFE') == "S"){
			$str.= ",7";
		}
		if(BuscaParam('MODULO_GESTAO') == "S"){
			$str.= ",8";
		}
		if(BuscaParam('MODULO_PEDIDO_VENDA') == "S"){
			$str.= ",9";
		}
		if(BuscaParam('MODULO_REQUISICAO') == "S"){
			$str.= ",10";
		}
		if(BuscaParam('MODULO_OS') == "S"){
			$str.= ",11";
		}
		if(BuscaParam('MODULO_RH') == "S"){
			$str.= ",12";
		}
		return $str;
	}

	function modulo_ativo($modulo){
		$ativo = false;
		$valor = 'N';
		if ($modulo == '1'){
			$modulo = 'NFE';
		}
		if ($modulo == '2'){
			$modulo = 'CTE';
		}
		if ($modulo == '3'){
			$modulo = 'SPED';
		}
		if ($modulo == '4'){
			$modulo = 'ENTRADAS';
		}
		if ($modulo == '5'){
			$modulo = 'FINANCEIRO';
		}
		if ($modulo == '6'){
			$modulo = 'CEREAIS';
		}
		if ($modulo == '7'){
			$modulo = 'MDFE';
		}
		if ($modulo == '8'){
			$modulo = 'GESTAO';
		}
		if ($modulo == '9'){
			$modulo = 'PEDIDO_VENDA';
		}
		if ($modulo == '10'){
			$modulo = 'REQUISICAO';
		}
		if ($modulo == '11'){
			$modulo = 'OS';
		}
		if ($modulo == '12'){
			$modulo = 'RH';
		}
		$nm_modulo = 'MODULO_';
		if ($modulo == 'CEREAIS'){
			$nm_modulo = 'MODULO-';
			$valor = 'SEM';
		}
		if (BuscaParam($nm_modulo.$modulo)!=$valor){
			$ativo = true;
		}
		return $ativo;
	}

	function var_dump2($input, $collapse=false){
		$recursive = function($data, $level=0) use (&$recursive, $collapse){
			global $argv;
			$isTerminal = isset($argv);
			if (!$isTerminal && $level == 0 && !defined("DUMP_DEBUG_SCRIPT")){
				define("DUMP_DEBUG_SCRIPT", true);
				echo '<script language="Javascript">function toggleDisplay(id){';
				echo 'var state = document.getElementById("container"+id).style.display;';
				echo 'document.getElementById("container"+id).style.display = state == "inline" ? "none" : "inline";';
				echo 'document.getElementById("plus"+id).style.display = state == "inline" ? "inline" : "none";';
				echo '}</script>'."\n";
			}
			$type = !is_string($data) && is_callable($data) ? "Callable" : ucfirst(gettype($data));
			$type_data = null;
			$type_color = null;
			$type_length = null;
			switch ($type){
				case "String":
					$type_color = "green";
					$type_length = strlen($data);
					$type_data = "\"" . htmlentities($data) . "\""; break;

				case "Double":
				case "Float":
					$type = "Float";
					$type_color = "#0099c5";
					$type_length = strlen($data);
					$type_data = htmlentities($data); break;

				case "Integer":
					$type_color = "red";
					$type_length = strlen($data);
					$type_data = htmlentities($data); break;

				case "Boolean":
					$type_color = "#92008d";
					$type_length = strlen($data);
					$type_data = $data ? "TRUE" : "FALSE"; break;

				case "NULL":
					$type_length = 0; break;

				case "Array":
					$type_length = count($data);
			}

			if (in_array($type, array("Object", "Array"))){
				$notEmpty = false;
				foreach($data as $key => $value){
					if (!$notEmpty){
						$notEmpty = true;
						if ($isTerminal){
							echo $type . ($type_length !== null ? "(" . $type_length . ")" : "")."\n";
						}else{
							$id = substr(md5(rand().":".$key.":".$level), 0, 8);
							echo "<a href=\"javascript:toggleDisplay('". $id ."');\" style=\"text-decoration:none\">";
							echo "<span style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>";
							echo "</a>";
							echo "<span id=\"plus". $id ."\" style=\"display: " . ($collapse ? "inline" : "none") . ";\">&nbsp;&#10549;</span>";
							echo "<div id=\"container". $id ."\" style=\"display: " . ($collapse ? "" : "inline") . ";\">";
							echo "<br />";
						}
						for($i=0; $i <= $level; $i++){
							echo $isTerminal ? "|    " : "<span style='color:black'>|</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
						}
						echo $isTerminal ? "\n" : "<br />";
					}
					for($i=0; $i <= $level; $i++){
						echo $isTerminal ? "|    " : "<span style='color:black'>|</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
					}
					echo $isTerminal ? "[" . $key . "] => " : "<span style='color:black'>[" . $key . "]&nbsp;=>&nbsp;</span>";
					call_user_func($recursive, $value, $level+1);
				}
				if ($notEmpty){
					for($i=0; $i <= $level; $i++){
						echo $isTerminal ? "|    " : "<span style='color:black'>|</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
					}
					if (!$isTerminal){
						echo "</div>";
					}
				}else{
					echo $isTerminal ?
						$type . ($type_length !== null ? "(" . $type_length . ")" : "") . "  " :
						"<span style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>&nbsp;&nbsp;";
				}
			}else{
				echo $isTerminal ?
					$type . ($type_length !== null ? "(" . $type_length . ")" : "") . "  " :
					"<span style='color:#666666'>" . $type . ($type_length !== null ? "(" . $type_length . ")" : "") . "</span>&nbsp;&nbsp;";
				if ($type_data != null){
					echo $isTerminal ? $type_data : "<span style='color:" . $type_color . "'>" . $type_data . "</span>";
				}
			}
			echo $isTerminal ? "\n" : "<br />";
		};
		call_user_func($recursive, $input);
	}

	function liberar_pedido_lote($nr_pedido,$nr_empresa=0){
		if ($nr_empresa == 0){
			$nr_empresa = $_SESSION['Empresa_Codigo'];
		}
		$lib_tipo = BuscaParam('LIBERA_AUTOMAT_PEDID');
		$mensagem = '';
		$upd_ped = 'UPDATE pedido set'.
					' Estoque = "S" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$nr_empresa.'"'.
					' AND Numero_Pedido = "'.$nr_pedido.'"';
		consulta_sql($upd_ped);
		$upd_ped = 'UPDATE pedido_item set'.
					' Estoque = "S" '.
					' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					' AND Empresa = "'.$nr_empresa.'"'.
					' AND Numero_Pedido = "'.$nr_pedido.'"'.
					' AND Status <> "E" '.
					' AND Status <> "F"';
		consulta_sql($upd_ped);
		$cons_pedido = 'SELECT Status, Tipo_Pedido, Empresa, Pessoa, Forma_Pagto FROM pedido '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$nr_empresa.'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
		$res_pedido = consulta_sql($cons_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);

		if (($reg_pedido->Status == 'F') || (($reg_pedido->Status) == 'C')){
		// ao entrar aqui nao processa nenhuma execuo
		}else{
			if ($_SESSION['Dominio'] == '205'){ //hardt
				$con_cli = 'SELECT Periodicidade_Padrao FROM pessoa_cliente '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Pessoa = "'.$reg_pedido->Pessoa.'"';
				$res_cli = consulta_sql($con_cli);
				$reg_cli = consulta_ler_linha($res_cli);
				consulta_limpa($res_cli);
				if ($reg_cli[0] > 0){
					$con_regiao = 'SELECT * FROM pedido_periodicidade '.
								' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
								' AND Periodicidade="'.$reg_cli[0].'"'.
								' AND Situacao<>"E"';
					$res_regiao = consulta_sql($con_regiao);
					$reg_regiao = consulta_ler_objeto($res_regiao);
					consulta_limpa($res_regiao);
					$upd_ped = '';
					if ($reg_regiao->Transportadora > 0){
						$upd_ped = 'Transportadora = "'.$reg_regiao->Transportadora.'",';
					}
					if ($reg_regiao->Motorista > 0){
						$upd_ped.= 'Motorista = "'.$reg_regiao->Motorista.'",';
					}
					if ($reg_regiao->Veiculo > 0){
						$upd_ped.= 'Veiculo = "'.$reg_regiao->Veiculo.'",';
					}
					if ($upd_ped != ''){
						$upd_ped = rtrim($upd_ped, ',');
						$atualiza_pedido = 'UPDATE pedido SET '.
											$upd_ped.
											' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
											' AND Empresa = "'.$nr_empresa.'"'.
											' AND Numero_Pedido = "'.$nr_pedido.'"'.
											' AND ((Transportadora = 0) OR '.
											'      (Motorista = 0) OR '.
											'      (Veiculo = 0))';
						consulta_sql($atualiza_pedido);
					}
				}
			}
			$con_pagto = 'SELECT Meio_Pagto FROM forma_pagto '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Codigo_Pagto = "'.$reg_pedido->Forma_Pagto.'"';
			$res_pagto = consulta_sql($con_pagto);
			$reg_pagto = consulta_ler_objeto($res_pagto);
			consulta_limpa($res_pagto);
			$atu_pedido_pagto = 'UPDATE pedido SET '.
								' Fatura_Tipo = "'.$reg_pagto->Meio_Pagto.'"'.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$nr_empresa.'"'.
								' AND Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($atu_pedido_pagto);
			//consulta cada item e libera cada item individualmente
			$con_item = 'SELECT * FROM pedido_item '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$nr_empresa.'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"'.
						' AND Status <> "E"';
			if ($lib_tipo != 'L'){
				$con_item.=' and Qtd > Qtd_Liberada';
			}
			if (($lib_tipo != 'F') || ($lib_tipo != 'L')){
				$con_item.=' and Estoque="S"';
			}
			$res_item = consulta_sql($con_item);
			$nrw_item = consulta_num_registros($res_item);
			for($i=0;$i<$nrw_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);
				$liberar = $reg_item->Qtd;
				if ($liberar<$reg_item->Qtd_Atendida){
					$liberar = $reg_item->Qtd_Atendida;
				}
				$atualiza_pedido_item ='UPDATE pedido_item SET '.
										' Qtd_Liberada = "'.$liberar.'" '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
										' AND Empresa = "'.$nr_empresa.'"'.
										' AND Numero_Pedido = "'.$nr_pedido.'"'.
										' AND Seq_Item="'.$reg_item->Seq_Item.'"';
				consulta_sql($atualiza_pedido_item);
				pedido_item_calcula_status($nr_pedido, $reg_item->Seq_Item, $nr_empresa);
			}
			pedido_calcula_status($nr_pedido,$nr_empresa);
		}
		return $mensagem;
	}

	function pedido_liberacao_lote_valida($nr_pedido, $valida = false, $obs = ''){
		$ok = true;
		$motivo = "";
		$con_pedido = 'SELECT Pessoa, Observacao, Forma_Pagto, DH_Entrega, '.
						' Valor_Total_Liquido, Fatura_Tipo, DH_Emissao FROM pedido'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"'.
						' AND Status = "A"';
		$res_pedido = consulta_sql($con_pedido);
		$nrw_pedido = consulta_num_registros($res_pedido);
		if ($nrw_pedido > 0){
			$reg_pedido = consulta_ler_objeto($res_pedido);
			$nf_zz = (($_SESSION['Dominio'] == '205') && ($reg_pedido->Forma_Pagto == '35'));
			if ($valida){
				$con_cli =	'SELECT Limite_Credito_Total, Formas_Pagto, Periodicidade_Padrao FROM pessoa_cliente '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_pedido->Pessoa.'"';
				$res_cli = consulta_sql($con_cli);
				$reg_cli = consulta_ler_objeto($res_cli);
				consulta_limpa($res_cli);
				if (($reg_pedido->Forma_Pagto != '1') && ($reg_pedido->Forma_Pagto != '2') && ($nf_zz === false)){
					//consulta o limite de crdito do cliente
					$con_parc2 ='SELECT IFNULL(SUM(Valor_Parcela), 0) FROM pedido_parcela '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Numero_Pedido = "'.$nr_pedido.'"';
					$res_parc2 = consulta_sql($con_parc2);
					$reg_parc2 = consulta_ler_linha($res_parc2);
					consulta_limpa($res_parc2);
					$total_ped = $reg_parc2[0];
					$con_parc3 ='SELECT IFNULL(SUM((Qtd_Atendida*Valor_Unitario) + ((Valor_Desconto/Qtd) * Qtd_Atendida)), 0) FROM pedido_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Numero_Pedido = "'.$nr_pedido.'" '.
								' AND (Status <> "E") '.
								' AND (Status <> "C")'.
								' AND Qtd > 0'.
								' AND Qtd_Atendida > 0';
					$res_parc3 = consulta_sql($con_parc3);
					$reg_parc3 = consulta_ler_linha($res_parc3);
					consulta_limpa($res_parc3);
					if ($reg_parc3[0] > 0){
						$total_ped-= $reg_parc3[0];
					}
					if ($total_ped <= 0){
						$total_ped = 0;
					}
					$total_cred_utilizado = busca_limite_credito_utilizado($reg_pedido->Pessoa);
					$perc_var = BuscaParam('VARIACAO_LIMITE') / 100;
					$limite_cred = $reg_cli->Limite_Credito_Total;
					$limite_total = $limite_cred + ($limite_cred*$perc_var);
					//pedido_implantacao_parcelas_procura.php
					if (($total_cred_utilizado + $total_ped) > $limite_total){
						$ok = false;
						//$motivo.="Cliente '".$reg_pedido->Pessoa."' excedeu o limite de crdito;".PHP_EOL;
						$motivo.= PHP_EOL . PHP_EOL .
									'Faturamento Bloqueado pelo Limite de Crdito Ultrapassado!'. PHP_EOL .
									'Limite de Crdito Liberado: '.to_money($limite_cred, false). PHP_EOL .
									'Limite de Crdito Tolerado: '.to_money($limite_total, false). PHP_EOL .
									'Limite de Crdito Utilizado: '.to_money($total_ped, false);
					}
					//procura por faturas vencidas
					$fatura_vencida = 'N';
					//$validade = BuscaParam('FAT_CARENCIA');
					$data_base = datad(nr2data((data_atual('nr'))));
					$con_contas='SELECT Empresa FROM contas_pr '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Situacao = "A"'.
								' AND TipoPR = "R"'.
								' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
								' AND DT_Vencto < "'.$data_base.'"'.
								' LIMIT 1';
					$res_contas = consulta_sql($con_contas);
					$nrw_contas = consulta_num_registros($res_contas);
					consulta_limpa($res_contas);
					if ($nrw_contas > 0){
						$fatura_vencida = 'S';
					}
					if ($fatura_vencida == "S"){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL .
									'Faturamento Bloqueado pela existncia de Fatura Vencida!'.PHP_EOL .
									'Existe ao menos uma fatura vencida acima da tolerncia!';
					}
				}
				//obs diferente de vazio
				if ($reg_pedido->Observacao != ""){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL . "Observao preenchida! ('".$reg_pedido->Observacao."')";
				}
				//formas de pagamento do cliente
				$formas_pagto_lista = explode(',', $reg_cli->Formas_Pagto);
				if (!in_array($reg_pedido->Forma_Pagto, $formas_pagto_lista)){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL . "Forma de pagamento do pedido no est na relao de formas de pagamentos do cliente '".$reg_pedido->Pessoa."'.";
				}
				//contas a receber num periodo de 60 dias
				$data_contas_limite = datad(nr2data((data_atual() - 60)));
				$con_contas='SELECT Nr_Contas FROM contas_pr '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
							' AND TipoPR = "R" '.
							' AND DH_Criacao >= "'.$data_contas_limite.' 00:00:00" '.
							' AND Situacao <> "E"';
				$res_contas = consulta_sql($con_contas);
				$nrw_contas = consulta_num_registros($res_contas);
				if ($nrw_contas == 0){
					$reg_contas = consulta_ler_linha($res_contas);
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL . "No h Contas a receber num perodo de 60 dias!";
				}
				consulta_limpa($res_contas);
				//compara os dias da periodicidade com o dia de entrega do pedido
				$con_perio ='SELECT Dias FROM pedido_periodicidade '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Periodicidade = "'.$reg_cli->Periodicidade_Padrao.'"';
				$res_perio = consulta_sql($con_perio);
				$reg_perio = consulta_ler_objeto($res_perio);
				consulta_limpa($res_perio);
				$entrega = datad(dataf($reg_pedido->DH_Entrega));
				//echo 'ET"'.$entrega.'"<BR>';
				if ($entrega=='0000-00-00'){
					$entrega = datad(dataf($reg_pedido->DH_Emissao));
					//echo 'EM"'.$entrega.'"<BR>';
				}
				$con_outros='SELECT Numero_Pedido FROM pedido '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido <> "'.$nr_pedido.'"'.
							' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
							' AND ((Status = "A") or (Status = "P") or (Status = "L") or (Status = "F"))'.
							' AND ( ((DH_Emissao>="'.$entrega.'") and (DH_Entrega="0000-00-00 00:00:00")) OR (DH_Entrega>="'.$entrega.'"))'.
							' AND ( ((DH_Emissao<="'.$entrega.' 23:59:59") and (DH_Entrega="0000-00-00 00:00:00")) OR (DH_Entrega<="'.$entrega.' 23:59:59"))';
				$res_outros = consulta_sql($con_outros);
				$reg_outros = consulta_ler_linha($res_outros);
				consulta_limpa($res_outros);
				if ($reg_outros[0]>0){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL . "Existe outro Pedido para este Cliente: ".$reg_outros[0]."!";
				}
				if (substr($reg_perio->Dias, dia_semana(data2nr(dataf($entrega))), 1) == "N"){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL . "Data de entrega do pedido no confere com a periodicidade cadastrada!";
				}
				//consulta os saldos
				$con_ped_saldo= 'SELECT ID_Produto, SUM(Qtd - Qtd_Atendida) Qtd, MIN(Valor_Unitario) Valor_Unitario  FROM pedido_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Numero_Pedido = "'.$nr_pedido.'" '.
								' AND ((Status = "A") OR (Status = "P")) '.
								' GROUP BY ID_Produto';
				$res_ped_saldo = consulta_sql($con_ped_saldo);
				$nrw_ped_saldo = consulta_num_registros($res_ped_saldo);
				for($k=0;$k<$nrw_ped_saldo;$k++){
					$reg_ped_saldo = consulta_ler_objeto($res_ped_saldo);
					//consulta preo do produto
					$con_produto =	'SELECT Preco_Venda5, Codigo_Produto FROM produto '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Id_Produto="'.$reg_ped_saldo->ID_Produto.'"';
					$res_produto = consulta_sql($con_produto);
					$reg_produto = consulta_ler_objeto($res_produto);
					consulta_limpa($res_produto);
					if ($reg_ped_saldo->Valor_Unitario < $reg_produto->Preco_Venda5){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL . "Valor unitrio do produto (".$reg_produto->Codigo_Produto.") inferior ao quinto preo do mesmo!";
					}
					//consulta saldo do produto
					$con_saldo ='SELECT Saldo_Atual FROM produto_saldo_filial '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Id_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
								' AND Local_Armaz = "0"';
					$res_saldo = consulta_sql($con_saldo);
					$reg_saldo = consulta_ler_objeto($res_saldo);
					consulta_limpa($res_saldo);
					$saldo_produto = $reg_saldo->Saldo_Atual;
					$qtd_requerida = $reg_ped_saldo->Qtd;
					//consulta os pedidos liberados para calcular o saldo
					$con_liberados ='SELECT IFNULL(SUM(pedi.Qtd - pedi.Qtd_Atendida), 0) Qtd FROM pedido_item pedi '.
									' INNER JOIN pedido ped '.
									' ON pedi.Dominio = ped.Dominio '.
									' AND pedi.Empresa = ped.Empresa '.
									' AND pedi.Numero_Pedido = ped.Numero_Pedido '.
									' WHERE pedi.Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND pedi.Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
									' AND pedi.Numero_Pedido <> "'.$nr_pedido.'"'.
									' AND pedi.ID_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
									' AND pedi.Status = "L"'.
									' AND ped.Status = "L"';
					$res_liberados = consulta_sql($con_liberados);
					$reg_liberados = consulta_ler_objeto($res_liberados);
					consulta_limpa($res_liberados);
					$qtd_liberada = $reg_liberados->Qtd;
					$disponivel = $saldo_produto - $qtd_liberada;
					if (($disponivel < 0.0001) && (($disponivel > (-0.0001)))){
						$disponivel = 0;
					}
					if (($disponivel) < $qtd_requerida){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL .
									'Saldo Insuficiente do Produto '.$reg_produto->Codigo_Produto .
									' (Disponvel: '.formata_qtd($disponivel, 3, false).')';
					}
				}
				consulta_limpa($res_ped_saldo);
				//se o valor for inferior a 50 reais
				if ($reg_pedido->Valor_Total_Liquido < 50){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL ."Valor inferior a R$ 50,00!";
				}
				//se for boleto menor que 100 reais
				if (($reg_pedido->Valor_Total_Liquido < 100) && ($reg_pedido->Fatura_Tipo == "B")){
					$ok = false;
					$motivo.= PHP_EOL . PHP_EOL ."H boletos com valor inferior a R$ 100,00!";
				}
				$upd_ped =	'UPDATE pedido SET'.
							' Bloqueado_Financeiro_Motivo = "'.trim($motivo).'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'" '.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($upd_ped);
			}
			if ($ok){
				$upd_ped =	'UPDATE pedido SET'.
							' Obs_Libera = "'.trim($obs).'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($upd_ped);
				liberar_pedido_lote($nr_pedido);
			}
		}
		consulta_limpa($res_pedido);
		return $ok;
	}

	function pedido_liberacao_lote_valida2($nr_pedido, $valida = false,$obs = ''){
		$ok = true;
		$motivo = "";
		$con_pedido =	'SELECT Pessoa, Observacao, Forma_Pagto, DH_Entrega, '.
						' Valor_Total_Liquido, Fatura_Tipo FROM pedido'.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"'.
						' AND Status = "A"';
		$res_pedido = consulta_sql($con_pedido);
		$nrw_pedido = consulta_num_registros($res_pedido);
		if($nrw_pedido > 0){
			$reg_pedido = consulta_ler_objeto($res_pedido);
			if($valida){
				//consulta os saldos
				$con_ped_saldo ='SELECT ID_Produto, SUM(Qtd - Qtd_Atendida) Qtd, MIN(Valor_Unitario) Valor_Unitario  FROM pedido_item '.
								' WHERE Dominio ="'.$_SESSION['Dominio'].'"'.
								' AND Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Numero_Pedido="'.$nr_pedido.'" '.
								' AND ((Status = "A") OR (Status = "P")) '.
								' GROUP BY ID_Produto';
				$res_ped_saldo = consulta_sql($con_ped_saldo);
				$nrw_ped_saldo = consulta_num_registros($res_ped_saldo);
				for($k=0;$k<$nrw_ped_saldo;$k++){
					$reg_ped_saldo = consulta_ler_objeto($res_ped_saldo);
					//consulta preo do produto
					$con_produto =	'SELECT Preco_Venda5, Codigo_Produto FROM produto '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Id_Produto="'.$reg_ped_saldo->ID_Produto.'"';
					$res_produto = consulta_sql($con_produto);
					$reg_produto = consulta_ler_objeto($res_produto);
					consulta_limpa($res_produto);
					//consulta saldo do produto
					$con_saldo ='SELECT Saldo_Atual FROM produto_saldo_filial '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Id_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
								' AND Local_Armaz = "0"';
					$res_saldo = consulta_sql($con_saldo);
					$reg_saldo = consulta_ler_objeto($res_saldo);
					consulta_limpa($res_saldo);
					$saldo_produto = $reg_saldo->Saldo_Atual;
					$qtd_requerida = $reg_ped_saldo->Qtd;
					//consulta os pedidos liberados para calcular o saldo
					$con_liberados ='SELECT IFNULL(SUM(pedi.Qtd - pedi.Qtd_Atendida), 0) Qtd FROM pedido_item pedi '.
									' INNER JOIN pedido ped '.
									' ON pedi.Dominio = ped.Dominio '.
									' AND pedi.Empresa = ped.Empresa '.
									' AND pedi.Numero_Pedido = ped.Numero_Pedido '.
									' WHERE pedi.Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND pedi.Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
									' AND pedi.Numero_Pedido <> "'.$nr_pedido.'"'.
									' AND pedi.ID_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
									' AND pedi.Status = "L"'.
									' AND ped.Status = "L"';
					$res_liberados = consulta_sql($con_liberados);
					$reg_liberados = consulta_ler_objeto($res_liberados);
					consulta_limpa($res_liberados);
					$qtd_liberada = $reg_liberados->Qtd;
					$disponivel = $saldo_produto - $qtd_liberada;
					if(($disponivel < 0.0001) && (($disponivel > (-0.0001)))){
						$disponivel = 0;
					}
					if(($disponivel) < $qtd_requerida){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL .
									'Saldo Insuficiente do Produto '.$reg_produto->Codigo_Produto .
									' (Disponvel: '.formata_qtd($disponivel, 3, false).')';
					}
				}
				consulta_limpa($res_ped_saldo);
				$upd_ped = 'UPDATE pedido set'.
							' Bloqueado_Financeiro_Motivo = "'.trim($motivo).'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($upd_ped);
			}
			$upd_ped = 'UPDATE pedido set'.
						' Bloqueado_Financeiro_Motivo = "'.trim($motivo).'" '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
						' AND Numero_Pedido = "'.$nr_pedido.'"';
			consulta_sql($upd_ped);
			if($ok){
				liberar_pedido_lote($nr_pedido);
			}
		}
		consulta_limpa($res_pedido);
		return $ok;
	}

	function pedido_liberacao_lote_valid3a($nr_pedido, $valida=false,$obs=''){
		$ok = true;
		$motivo = "";
		$con_pedido = 'SELECT Pessoa, Observacao, Forma_Pagto, DH_Entrega, '.
					' Valor_Total_Liquido, Fatura_Tipo, DH_Emissao FROM pedido'.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
					' AND Numero_Pedido = "'.$nr_pedido.'"'.
					' AND Status = "A"';
		$res_pedido = consulta_sql($con_pedido);
		$nrw_pedido = consulta_num_registros($res_pedido);
		if($nrw_pedido > 0){
			$reg_pedido = consulta_ler_objeto($res_pedido);
			if($valida){
				$con_cli = 'SELECT Limite_Credito_Total, Formas_Pagto, Periodicidade_Padrao '.
							' FROM pessoa_cliente '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							' AND Pessoa="'.$reg_pedido->Pessoa.'"';
				$res_cli = consulta_sql($con_cli);
				$reg_cli = consulta_ler_objeto($res_cli);
				consulta_limpa($res_cli);
				if($reg_pedido->Forma_Pagto != 1){
					//consulta o limite de crdito do cliente
					$con_parc2 ='SELECT IFNULL(SUM(Valor_Parcela), 0) FROM pedido_parcela '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Numero_Pedido = "'.$nr_pedido.'"';
					$res_parc2 = consulta_sql($con_parc2);
					$reg_parc2 = consulta_ler_linha($res_parc2);
					consulta_limpa($res_parc2);
					$total_ped = $reg_parc2[0];
					$con_parc3 ='SELECT IFNULL(SUM((Qtd_Atendida * Valor_Unitario) + ((Valor_Desconto / Qtd) * Qtd_Atendida)), 0) '.
								' FROM pedido_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'" '.
								' AND Numero_Pedido = "'.$nr_pedido.'"'.
								' AND (Status <> "E") '.
								' AND (Status <> "C") '.
								' AND Qtd > 0'.
								' AND Qtd_Atendida > 0';
					$res_parc3 = consulta_sql($con_parc3);
					$reg_parc3 = consulta_ler_linha($res_parc3);
					consulta_limpa($res_parc3);
					if($reg_parc3[0] > 0){
						$total_ped-= $reg_parc3[0];
					}
					if($total_ped <= 0){
						$total_ped = 0;
					}
					$total_cred_utilizado = busca_limite_credito_utilizado($reg_pedido->Pessoa);
					$perc_var = BuscaParam('VARIACAO_LIMITE') / 100;
					$limite_cred = $reg_cli->Limite_Credito_Total;
					$limite_total = $limite_cred + ($limite_cred*$perc_var);
					//pedido_implantacao_parcelas_procura.php
					if(($total_cred_utilizado + $total_ped) > $limite_total){
						$ok = false;
						//$motivo.="Cliente '".$reg_pedido->Pessoa."' excedeu o limite de crdito;".PHP_EOL;
						$motivo.= PHP_EOL . PHP_EOL . 'Faturamento Bloqueado pelo Limite de Crdito Ultrapassado!'. PHP_EOL .
									'Limite de Crdito Liberado: '.to_money($limite_cred, false). PHP_EOL .
									'Limite de Crdito Tolerado: '.to_money($limite_total, false). PHP_EOL .
									'Limite de Crdito Utilizado: '.to_money($total_ped, false);
					}
					//procura por faturas vencidas
					$fatura_vencida = 'N';
					//$validade = BuscaParam('FAT_CARENCIA');
					$data_base = datad(nr2data((data_atual('nr')-10)));
					$con_contas='SELECT Empresa FROM contas_pr '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
								' AND Situacao = "A"'.
								' AND TipoPR = "R"'.
								' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
								' AND DT_Vencto < "'.$data_base.'"'.
								' LIMIT 1';
					$res_contas = consulta_sql($con_contas);
					$nrw_contas = consulta_num_registros($res_contas);
					consulta_limpa($res_contas);
					if($nrw_contas > 0){
						$fatura_vencida = 'S';
					}
					if($fatura_vencida == "S"){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL .
									'Faturamento Bloqueado pela existncia de Fatura Vencida!'.PHP_EOL .
									'Existe ao menos uma fatura vencida acima da tolerncia!';
					}
				}
				//obs diferente de vazio
				//consulta os saldos
				$con_ped_saldo ='SELECT ID_Produto, SUM(Qtd - Qtd_Atendida) Qtd, MIN(Valor_Unitario) Valor_Unitario  FROM pedido_item '.
								' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
								' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Numero_Pedido = "'.$nr_pedido.'" '.
								' AND ((Status = "A") OR (Status = "P")) '.
								' GROUP BY ID_Produto';
				$res_ped_saldo = consulta_sql($con_ped_saldo);
				$nrw_ped_saldo = consulta_num_registros($res_ped_saldo);
				for($k=0;$k<$nrw_ped_saldo;$k++){
					$reg_ped_saldo = consulta_ler_objeto($res_ped_saldo);
					//consulta preo do produto
					$con_produto =	'SELECT Preco_Venda5, Codigo_Produto FROM produto '.
									' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
									' AND Id_Produto="'.$reg_ped_saldo->ID_Produto.'"';
					$res_produto = consulta_sql($con_produto);
					$reg_produto = consulta_ler_objeto($res_produto);
					consulta_limpa($res_produto);
					//consulta saldo do produto
					$con_saldo ='SELECT Saldo_Atual FROM produto_saldo_filial '.
								' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
								' AND Codigo_Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
								' AND Id_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
								' AND Local_Armaz = "0"';
					$res_saldo = consulta_sql($con_saldo);
					$reg_saldo = consulta_ler_objeto($res_saldo);
					consulta_limpa($res_saldo);
					$saldo_produto = $reg_saldo->Saldo_Atual;
					$qtd_requerida = $reg_ped_saldo->Qtd;
					//consulta os pedidos liberados para calcular o saldo
					$con_liberados ='SELECT IFNULL(SUM(pedi.Qtd-pedi.Qtd_Atendida), 0) Qtd FROM pedido_item pedi '.
									' INNER JOIN pedido ped '.
									' ON pedi.Dominio = ped.Dominio '.
									' AND pedi.Empresa = ped.Empresa '.
									' AND pedi.Numero_Pedido = ped.Numero_Pedido '.
									' WHERE pedi.Dominio = "'.$_SESSION['Dominio'].'"'.
									' AND pedi.Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
									' AND pedi.Numero_Pedido <> "'.$nr_pedido.'"'.
									' AND pedi.ID_Produto = "'.$reg_ped_saldo->ID_Produto.'"'.
									' AND pedi.Status = "L"'.
									' AND ped.Status = "L"';
					$res_liberados = consulta_sql($con_liberados);
					$reg_liberados = consulta_ler_objeto($res_liberados);
					consulta_limpa($res_liberados);
					$qtd_liberada = $reg_liberados->Qtd;
					$disponivel = $saldo_produto - $qtd_liberada;
					if(($disponivel < 0.0001) && (($disponivel > (-0.0001)))){
						$disponivel = 0;
					}
					if(($disponivel) < $qtd_requerida){
						$ok = false;
						$motivo.= PHP_EOL . PHP_EOL .
								'Saldo Insuficiente do Produto '.$reg_produto->Codigo_Produto .
								' (Disponvel: '.formata_qtd($disponivel, 3, false).')';
					}
				}
				consulta_limpa($res_ped_saldo);
				$upd_ped = 'UPDATE pedido SET'.
							' Bloqueado_Financeiro_Motivo = "'.trim($motivo).'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($upd_ped);
			}
			if($ok){
				$upd_ped = 'UPDATE pedido SET'.
							' Obs_Libera = "'.trim($obs).'" '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
							' AND Numero_Pedido = "'.$nr_pedido.'"';
				consulta_sql($upd_ped);
				liberar_pedido_lote($nr_pedido);
			}
		}
		consulta_limpa($res_pedido);
		return $ok;
	}

	function calcula_preco_promocao($id_produto = 0){
		$perc_preco_auto = trim(BuscaParam('PERC_PRECO_AUTO'));
		if($perc_preco_auto == ""){ // Retorna se for vazio
			return;
		}
		$promo_lista = array();
		$con_promo ='SELECT Id_Produto, Valor from produto_promocao '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" ';
		if($id_produto > 0){
			$con_promo.= ' AND Id_Produto = "'.$id_produto.'"';
		}
		$con_promo.=' AND Situacao="A" '.
					' AND DT_Inicio <= "'.data_atual('date').'"'.
					' AND ((DT_Final = "0000-00-00") OR (DT_Final >= "'.data_atual('date').'"))';
		$res_promo = consulta_sql($con_promo);
		$nrw_promo = consulta_num_registros($res_promo);
		for($p=0;$p<$nrw_promo;$p++){
			$reg_promo = consulta_ler_objeto($res_promo);
			$promo_lista[$reg_promo->Id_Produto] = $reg_promo->Valor;
		}
		consulta_limpa($res_promo);
		$porcentagens = explode(';', $perc_preco_auto);
		$con_prod_preco='SELECT Id_Produto, Preco_Venda1, Preco_Venda5 FROM produto '.
						' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
						' AND Situacao = "A" '.
						' AND Id_Produto > 0 ';
		if($id_produto > 0){
			$con_prod_preco.=' AND Id_Produto = "'.$id_produto.'"';
		}
		$con_prod_preco.=' ORDER BY Id_Produto';
		$res_prod_preco = consulta_sql($con_prod_preco);
		$nrw_prod_preco = consulta_num_registros($res_prod_preco);
		for($k=0; $k<$nrw_prod_preco; $k++){
			$reg_prod_preco = consulta_ler_objeto($res_prod_preco);
			$preco_venda5 = $reg_prod_preco->Preco_Venda1 - ($reg_prod_preco->Preco_Venda1 * ($porcentagens[3] / 100));
			if(isset($promo_lista[$reg_prod_preco->Id_Produto])){
				$preco_venda5 = $promo_lista[$reg_prod_preco->Id_Produto];
			}
			$preco_venda5 = formata_qtd($preco_venda5, 2, true);
			$preco_venda5_atual = formata_qtd($reg_prod_preco->Preco_Venda5, 2, true);
			if($preco_venda5 != $preco_venda5_atual){
				$upt_pessoa='UPDATE produto SET '.
							' Preco_Venda5 = "'.str2nr(formata_valor($preco_venda5)).'", '.
							' DH_Alteracao = now(),'.
							' Usuario_Alteracao = "'.base64_decode_si($_REQUEST['USER_ID']).'"'.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Id_Produto = "'.$reg_prod_preco->Id_Produto.'"';
				$res_pessoa = consulta_sql($upt_pessoa, true, 1);
			}
		}
		consulta_limpa($res_prod_preco);
	}

	function lista_produtos_nf_entrada($nr_nota){
		$lista_produtos = array();
		$con_item = 'SELECT Seq_Item, Id_Produto, Codigo_Produto, Barra_Produto, '.
					' Valor_Agregado, ICMSST_Valor, Quantidade_Estoque, Prod_Descricao '.
					' FROM nota_fiscal_item '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
					' AND Nr_Nota = "'.$nr_nota.'"'.
					' AND Prod_Depart <> 0'.
					' AND Quantidade_Estoque > 0'.
					' AND Kit = 0'.
					' ORDER BY Seq_Item';
		$res_item = consulta_sql($con_item);
		$nrw_item = consulta_num_registros($res_item);
		for($i=0;$i<$nrw_item;$i++){
			$reg_item = consulta_ler_objeto($res_item);
			$valor_produto = ($reg_item->Valor_Agregado + $reg_item->ICMSST_Valor);
			$qtd = $reg_item->Quantidade_Estoque;
			$variacao = 0;
			if($qtd > 0){
				$custo_atual = round(($valor_produto / $qtd), 2);
				$con_custo ='SELECT Preco_Custo, Preco_Custo_Ult_Entrada FROM produto_hist_custo'.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
							' AND Id_Produto = "'.$reg_item->Id_Produto.'"'.
							' ORDER by DH_Custo DESC '.
							' LIMIT 1';
				$res_custo = consulta_sql($con_custo);
				$reg_custo = consulta_ler_linha($res_custo);
				consulta_limpa($res_custo);
				$precoCustoUltEntrada = 0;
				if(isset($reg_custo)){
					$precoCustoUltEntrada = $reg_custo[1];
				}
				$custo_anterior = round($precoCustoUltEntrada, 2);
				$variacao = 0;
				if($custo_anterior > 0){
					$variacao = (((($custo_atual*100) / $custo_anterior)) - 100);
				}
			}
			if(($variacao != 0) || (($custo_anterior == 0) && ($variacao == 0))){
				$cons_prod ='SELECT Preco_Venda1 FROM produto '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
							' AND Id_Produto = "'.$reg_item->Id_Produto.'"';
				$res_prod = consulta_sql($cons_prod);
				$reg_prod = consulta_ler_objeto($res_prod);
				consulta_limpa($res_prod);
				//Cdigo | Descricao | Custo Reposio Anterior | Custo Atual | % Variao | Preo Venda
				$codigo_produto = $reg_item->Codigo_Produto;
				if($reg_item->Barra_Produto != ''){
					$codigo_produto = $reg_item->Barra_Produto;
				}
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Codigo'] = $codigo_produto;
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Descricao'] = $reg_item->Prod_Descricao;
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Custo_Rep_Anterior'] = $custo_anterior;
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Custo_Atual'] = $custo_atual;
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Variacao'] = $variacao;
				$lista_produtos[$nr_nota][$reg_item->Seq_Item]['Preco_Venda'] = $reg_prod->Preco_Venda1;
			}
		}
		consulta_limpa($res_item);
		if(count($lista_produtos) == 0){
			return '';
		}else{
			return $lista_produtos;
		}
	}

	function BuscaDashboard(){
		$ok = false;
		if($_SESSION["Dominio"] == 2){
			if(session::tempermissao('MOV_CAIXA') != '   '){
				$ok = true;
			}
		}
		return $ok;
	}

	function BuscaResumo(){
		$ok = false;
		if($_SESSION["Dominio"] != 2){
			if(session::tempermissao('REL_CONTASREC_ACOMP_INADIMPLENCIA') != '   '){
				$ok = true;
			}
		}
		return $ok;
	}

	function montarComboEmpresa($empresaSelecionada = '',$vazio='<option value=""></option>',$permissao='FINANCEIRO_FILIAL'){
		$pemissao = (session::tempermissao($permissao) == '   ') ? 'N' : 'S';
		$con_empre ='SELECT Pessoa, Nome_Listas FROM pessoa '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Situacao <> "E" '.
					' AND SUBSTRING(Cadastros, 7, 1) = "S"';
		if($pemissao == 'N'){
			$con_empre.= ' AND Pessoa = "'.$_SESSION['Empresa_Codigo'].'" ';
			$empresaSelecionada = $_SESSION['Empresa_Codigo'];
		}
		$con_empre.= ' ORDER BY Nome_Listas ';
		$lista_empresas = cria_cb_busca($con_empre, $empresaSelecionada);
		if($pemissao != 'N'){
			$lista_empresas = $vazio.$lista_empresas;
		}
		return $lista_empresas;
	}

	function calcularPercentualDescontoProporcional($idProduto, $quantidade, $valorTotal){
		$conProduto='SELECT Preco_Venda1 FROM produto '.
					' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
					' AND Id_Produto = "'.$idProduto.'"';
		$resProduto = consulta_sql($conProduto);
		$regProduto = consulta_ler_objeto($resProduto);
		consulta_limpa($resProduto);
		$precoVenda1 = $regProduto->Preco_Venda1;
		$perc = 0;
		if(($precoVenda1 > 0) && ($quantidade > 0) && ($valorTotal > 0)){
			$valorUnitario = ($valorTotal / $quantidade);
			$perc = (1 - ($valorUnitario / $precoVenda1)) * 100;
			if($perc < 0){
				$perc = 0;
			}
		}
		return $perc;
	}

	function calcularValorTotalDescontoProporcional($idProduto, $quantidade){
		if(empty($quantidade)){
			return 0;
		}
		$con_produto =	'SELECT Preco_Venda1 FROM produto '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Id_Produto = "'.$idProduto.'"';
		$res_produto = consulta_sql($con_produto);
		$reg_produto = consulta_ler_linha($res_produto);
		consulta_limpa($res_produto);
		$percDesconto = 0;
		$conProdDesconto =	'SELECT MIN(Perc_Desconto) FROM produto_desconto '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Id_Produto = "'.$idProduto.'"'.
							' AND Qtd_Minima >= "'.$quantidade.'" '.
							' AND Situacao = "A"';
		$resProdDesconto = consulta_sql($conProdDesconto);
		$regProdDesconto = consulta_ler_linha($resProdDesconto);
		consulta_limpa($resProdDesconto);
		if(!empty($regProdDesconto)){
			$percDesconto = $regProdDesconto[0];
		}
		return (($reg_produto[0] * $quantidade) * (1 - ($percDesconto / 100)));
	}

	function isFreeline(){
		return (
				base64_decode_si($_REQUEST['USER_ID']) == 'Freeline' ||
				base64_decode_si($_REQUEST['USER_ID']) == 'FREELINE2'
				);
	}


	/**
	 * Funcao sendo refeita para add todas as modificaes do Dominio 292 para o Dominio 431 em 30/09/2022 por @isabel */
	function Zathura(){
		return ( ($_SESSION['Dominio'] == 292 ) ||( $_SESSION['Dominio'] == 431 ) || ($_SESSION['Dominio'] == 'xx')) ;	
		// usando o DOM 34 para teste 	em 20072023
	}




	function letra_coluna2($coluna){
		$letras = array();
		// echo 'Coluna Agora: '.$coluna;
		$letras[1]='A';		$letras[2]='B';		$letras[3]='C';
		$letras[4]='D';		$letras[5]='E';		$letras[6]='F';
		$letras[7]='G';		$letras[8]='H';		$letras[9]='I';
		$letras[10]='J';	$letras[11]='K';	$letras[12]='L';
		$letras[13]='M'; 	$letras[14]='N';	$letras[15]='O';
		$letras[16]='P';	$letras[17]='Q';	$letras[18]='R';
		$letras[19]='S';	$letras[20]='T';	$letras[21]='U';
		$letras[22]='V';	$letras[23]='W';	$letras[24]='X';
		$letras[25]='Y';	$letras[26]='Z';
		$primeira_letra = 0;
		while($coluna > 26){
			$primeira_letra++;
			$coluna-= 26;
		}
		$letra = $letras[$coluna];
		if($primeira_letra > 0){
			$letra = $letras[$primeira_letra].$letra;
		}
		return $letra;
	}

	function buscarProdutoLocalizacao($idProduto, $empresa = 0, $localArmaz = 0){
		if($empresa == 0){
			$empresa = $_SESSION['Empresa_Codigo'];
		}
		$conLocalizacao='SELECT Localizacao FROM produto_saldo_filial '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' AND Id_Produto = "'.$idProduto.'"'.
						' AND Local_Armaz = "'.$localArmaz.'"';
		$resLocalizacao = consulta_sql($conLocalizacao);
		$regLocalizacao = consulta_ler_linha($resLocalizacao);
		consulta_limpa($resLocalizacao);      

		$localizacao = '';
		if(isset($regLocalizacao)){
			$localizacao = trim($regLocalizacao[0]);
		}
		return $localizacao;
	}

	function produto_saldo_diario_ultima($dominio){
		$con_ultimo='SELECT max(Data_Base) FROM produto_saldo_diario '.
					' WHERE Dominio = "'.$dominio.'"';
		$res_ultimo = consulta_sql($con_ultimo);
		$reg_ultimo = consulta_ler_linha($res_ultimo);
		consulta_limpa($res_ultimo);
		
		if (($reg_ultimo[0]=='')||($reg_ultimo[0]==null)||($reg_ultimo[0]=='0000-00-00')){
			$data_base = data_atual('num')-1;
		}else{
			$data_base = data2nr(dataf($reg_ultimo[0]));
		}
		//mas de 10 vezes nao executa porque dai ficou parado muito tempo mesmo
		$dif = $data_base - data_atual('num');
		if ($dif>10){
			$data_base = data_atual('num')-10;
		}
		return $data_base;
	}

	function produto_saldo_diario_valida($dominio){
		if ($_SESSION["Dominio"]==2){
			$ultimo = produto_saldo_diario_ultima($dominio); 
			$atual = data_atual('num');
			for($data=$ultimo;$data<$atual;$data++){
				produto_saldo_diario_insere($dominio,$data);
			}
		}
	}

	function produto_saldo_diario_insere($dominio,$data){
		//ainda salva o estoque do dia
		$insere = 'INSERT INTO produto_saldo_diario '.
				  '(Dominio, Data_Base, Id_Produto, '.
				  ' Empresa, Saldo_Atual, Preco_Custo) '.
				  ' select Dominio, '.
				  ' "'.datad(nr2data($data)).'", '.
				  ' Id_Produto, '.
				  ' Codigo_Empresa, '.
				  ' sum(Saldo_Atual), '.
				  ' max(Preco_Custo) '.
				  ' from produto_saldo_filial '.
				  ' where Dominio="'.$dominio.'"'.
				  ' group by Id_Produto, Codigo_Empresa';
		consulta_sql($insere);
	}

	function Navegador() {
		$MSIE = strpos($_SERVER['HTTP_USER_AGENT'],"MSIE");
		$MSIE2 = strpos($_SERVER['HTTP_USER_AGENT'],"Trident");
		$Firefox = strpos($_SERVER['HTTP_USER_AGENT'],"Firefox");
		$Mozilla = strpos($_SERVER['HTTP_USER_AGENT'],"Mozilla");
		$Chrome = strpos($_SERVER['HTTP_USER_AGENT'],"Chrome");
		$Chromium = strpos($_SERVER['HTTP_USER_AGENT'],"Chromium");
		$Safari = strpos($_SERVER['HTTP_USER_AGENT'],"Safari");
		$Opera = strpos($_SERVER['HTTP_USER_AGENT'],"Opera");

		if ($MSIE == true) { $navegador = "IE"; }
		else if ($MSIE2 == true) { $navegador = "IE"; }
		else if ($Firefox == true) { $navegador = "Firefox"; }
		else if ($Mozilla == true) { $navegador = "Firefox"; }
		else if ($Chrome == true) { $navegador = "Chrome"; }
		else if ($Chromium == true) { $navegador = "Chromium"; }
		else if ($Safari == true) { $navegador = "Safari"; }
		else if ($Opera == true) { $navegador = "Opera"; }
		else { $navegador = $_SERVER['HTTP_USER_AGENT']; }

		return $navegador;
	}

	function produto_ajuste($empresa,$UF){
		$ajuste = 0;
		$lst_ajuste = BuscaParamEmpresa('ProdutoAjuste',$empresa);
		if ($lst_ajuste!=''){
			$lst_uf= explode(';',$lst_ajuste);
			$perc_uf = 0;
			$perc_todos=0;
			foreach ($lst_uf as $key=>$value){
				//echo $lst_uf[$key].'<BR>';
				if ($lst_uf[$key]!=''){
					$dados_uf = explode('=',$lst_uf[$key].'=');
					if ($dados_uf[1]==''){ $dados_uf[1] = 0;}
					if ($dados_uf[0]=='TODOS'){
						$perc_todos= str2nr(formata_valor($dados_uf[1]));
					}
					if ($dados_uf[0]==$UF){
						$perc_uf = str2nr(formata_valor($dados_uf[1]));
					}
				}
			}
			if ($perc_todos>0) {$ajuste = $perc_todos;}
			if ($perc_uf>0) {$ajuste = $perc_uf;}
		}
		return $ajuste;
	}

	function pessoa_deletar_lgpd($codigo,$tempo){
		$ret = pessoa_deletar_lgpd_validar($codigo,$tempo);
		if($ret['ok']){
			$consulta = 'Update t_pessoa_cliente '.
						' set '.
						' SPC_Consulta="", '.
						' Trabalho_Nome="", '.
						' Trabalho_Ant_Nome="", '.
						' Trabalho_Ant_Telefone="", '.
						' Conjuge_Nome="", '.
						' Conjuge_CPF="", '.
						' Conjuge_RG="", '.
						' Conjuge_Emprego="", '.
						' Equipamentos="", '.
						' Veiculos="", '.
						' Maquinas="", '.
						' Compra="", '.
						' Vende="", '.
						' Avaliacao="", '.
						' Emails_Laudo="", '.
						' GPS_Latitude="", '.
						' GPS_Longitude="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_avaliacao '.
						' set '.
						' Observacao="DADOS EXCLUDOS - LGPD" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_cliente_referencia '.
						' set '.
						' Nome="DADOS EXCLUDOS - LGPD", '.
						' Telefone="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_conta '.
						' set '.
						' Agencia="0000", '.
						' Numero_Conta="0000", '.
						' Convenio="", '.
						' Obs="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_conta '.
						' set '.
						' Agencia="0000", '.
						' Numero_Conta="0000", '.
						' Convenio="", '.
						' Obs="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_contato '.
						' set '.
						' Nome="DADOS EXCLUDOS - LGPD", '.
						' Numero_Telefone="", '.
						' EMail="", '.
						' Observacao="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_dependente '.
						' set '.
						' Nome="DADOS EXCLUDO - LGPD", '.
						' RG="", '.
						' CPF="", '.
						' Nr_Cartao_Plano_Saude="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_endereco '.
						' set '.
						' Logradouro="DADOS EXCLUDOS - LGPD", '.
						' Numero="", '.
						' Complemento="", '.
						' Ponto_Referencia="", '.
						' Caixa_Postal="", '.
						' Insc_Estadual="", '.
						' Insc_Municipal="", '.
						' Insc_SUFRAMA="", '.
						' Insc_Terra="", '.
						' Arrendatario="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_fornecedor '.
						' set '.
						' Processo_Numero="", '.
						' Avalista_CPF="", '.
						' Avalista_RG="", '.
						' Avalista_Nome="", '.
						' RL_Endereco="", '.
						' RL_CPF="", '.
						' RL_RG="", '.
						' RL_Nome="", '.
						' RL_Email="", '.
						' Avalista_Email="", '.
						' Avalista_Endereco="", '.
						' Testemunha_CPF="", '.
						' Testemunha_RG="", '.
						' Testemunha_Nome="", '.
						' Testemunha_Email="", '.
						' Testemunha_Endereco="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_funcionario '.
						' set '.
						' CPT="", '.
						' PIS="", '.
						' FGTS_Agencia="", '.
						' FGTS_Conta="", '.
						' Nr_Cartao_Onibus="", '.
						' Nr_Cartao_Plano_Saude="", '.
						' Titulo_Numero="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_qualificacao '.
						' set '.
						' Nr_Registro="XXX" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_substituto '.
						' set '.
						' Insc_Estadual="", '.
						' Situacao="E" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_obs '.
						' set '.
						' Situacao="E" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_telefone '.
						' set '.
						' Numero_Telefone="(XX) XXXX-XXXX",'.
						' Observacao="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_transportador '.
						' set '.
						' Registro_ANTT="",'.
						' PIS="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_transportador_motorista '.
						' set '.
						' Nome="DADOS EXCLUDOS - LGPD",'.
						' CPF="000.000.000-00",'.
						' RG="",'.
						' CNH="",'.
						' INSS="",'.
						' CNH_Observacao="",'.
						' Telefone_1="",'.
						' Telefone_2="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_transportador_veiculo '.
						' set '.
						' Placa="XXX-XXXX",'.
						' Veiculo_Nr_Chassis="",'.
						' Veiculo_RENAVAN="",'.
						' Registro_ANTT="",'.
						' Reboque_Placa="",'.
						' Reboque_Registro_ANTT="",'.
						' Reboque2_Placa="",'.
						' Reboque2_Registro_ANTT="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa_vendedor '.
						' set '.
						' Usuario="",'.
						' Empresa_Representante="",'.
						' Nr_CORE="" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$consulta = 'Update t_pessoa '.
						' set Situacao="E", '.
						' Nome_Razao="DADOS EXCLUDOS - LGPD", '.
						' Nome_Fantasia="DADOS EXCLUDOS - LGPD", '.
						' Nome_Listas="DADOS EXCLUDOS - LGPD", '.
						' CPF_CNPJ="000.000.000-00", '.
						' EMail="", '.
						' Web_Site="", '.
						' Cadastros="NNNNNNNNNN", '.
						' RG="", '.
						' RG_Pai="", '.
						' RG_Mae="", '.
						' DataHora_Alteracao=now(), '.
						' Liberado="N" '.
						' where Dominio="'.$_SESSION["Dominio"].'"'.
						' and Pessoa = "'.$codigo.'"';
			$sql = consulta_sql($consulta);

			$upt_pessoa = 'UPDATE t_pessoa SET'.
						  ' Usuario_Alteracao  = "'.base64_decode_si($_SESSION["USER_ID"]).'"'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"';
			consulta_sql($upt_pessoa,true,1);
			if ($tempo==0){
				liberacao_pessoa($codigo);
			}
		}
		return $ret;
	}
	
	function pessoa_deletar_lgpd_validar($codigo,$tempo){
		$ret['ok'] = true;
		$ret['erro'] = '';
		//consulta ad em aberto
		$con_aberto = 'select count(*) from contas_ad'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"'.
					  ' and Situacao="A"';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]>0){ $ret['ok'] = false; $ret['erro'].= 'Adiantamento em Aberto: '.$reg_aberto[0].'.;';}

		//consulta contas P em aberto
		$con_aberto = 'select count(*) from contas_pr'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"'.
					  ' and TipoPR="P"'.
					  ' and Situacao="A"';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]>0){ $ret['ok'] = false; $ret['erro'].= 'Contas a Pagar em Aberto: '.$reg_aberto[0].'.;';}

		//consulta contas R em aberto
		$con_aberto = 'select count(*) from contas_pr'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"'.
					  ' and TipoPR="R"'.
					  ' and Situacao="A"';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]>0){ $ret['ok'] = false; $ret['erro'].= 'Contas a Receber em Aberto: '.$reg_aberto[0].'.;';}

		//consulta cheque em aberto
		$con_aberto = 'select count(*) from cheque_pre'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"'.
					  ' and ((Situacao="C") or (Situacao="D") or (Situacao="2"))';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]>0){ $ret['ok'] = false; $ret['erro'].= 'Cheques a Receber em Aberto: '.$reg_aberto[0].'.;';}

		//requiso de material em aberto
		$con_aberto = 'select count(*) from requisicao'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Local_Destino = "'.$codigo.'"'.
					  ' and ( ( Status = "F" ) or (Status = "P") or (Status = "A"))';
					  ' and Tipo_Requisicao<> "D"';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]>0){ $ret['ok'] = false; $ret['erro'].= 'Resquiso em Aberto: '.$reg_aberto[0].'.;';}

		//funcionario
		$con_aberto = 'select Tipo from t_pessoa_funcionario_historico'.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$codigo.'"'.
					  ' and Situacao<>"E"'.
					  ' and ((Tipo="A") or (Tipo="D")) '.
					  ' order by Data_Inicio desc, Seq_Historico desc';
		$res_aberto = consulta_sql($con_aberto);
		$reg_aberto = consulta_ler_linha($res_aberto);
		consulta_limpa($res_aberto);
		if ($reg_aberto[0]=='A'){ $ret['ok'] = false; $ret['erro'].= 'Funcionrio ainda em Estado Ativo.;';}

		//tempo
		if (($ret['ok'])&&($tempo>0)){
			
			$data_base = datad(nr2data(data_atual('num')-$tempo));
			//tempo de cadastro
			$con_aberto = 'select DataHora_Alteracao from pessoa'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			//$data = data2nr(dataf($reg_aberto[0]));
			//if ($data >= $data_base){ $ret['ok'] = false; $ret['erro']='ltima alterao cadastral no perodo!';}

			//tempo de contas
			$con_aberto = 'select max(DT_Pagto) from contas_pr'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"'.
						  ' and Situacao<>"E"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			$data = data2nr(dataf($reg_aberto[0]));
			if ($data > $data_base){ $ret['ok'] = false; $ret['erro']='Existe Contas no periodo!';}

			//tempo de cheque
			$con_aberto = 'select max(DT_Ultimo) from cheque_pre'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			$data = data2nr(dataf($reg_aberto[0]));
			if ($data > $data_base){ $ret['ok'] = false;$ret['erro']='Existe Cheque no periodo!';}

			//tempo de ad
			$con_aberto = 'select max(DT_Pagto) from contas_ad'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"'.
						  ' and Situacao<>"E"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			$data = data2nr(dataf($reg_aberto[0]));
			if ($data > $data_base){ $ret['ok'] = false;$ret['erro']='Existe Adiantamento no periodo!';}
			//tempo de pedido
			$con_aberto = 'select max(DH_Emissao) from pedido'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Pessoa = "'.$codigo.'"'.
						  ' and Status<>"E"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			$data = data2nr(dataf($reg_aberto[0]));
			if ($data > $data_base){ $ret['ok'] = false;$ret['erro']='Existe Pedido no periodo!';}
			//tempo de nf
			$con_aberto = 'select max(DH_Emissao) from nota_fiscal'.
						  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						  ' AND Destinatario = "'.$codigo.'"'.
						  ' and Situacao<>"E"';
			$res_aberto = consulta_sql($con_aberto);
			$reg_aberto = consulta_ler_linha($res_aberto);
			consulta_limpa($res_aberto);
			$data = data2nr(dataf($reg_aberto[0]));
			if ($data > $data_base){ $ret['ok'] = false; $ret['erro']='Existe NF no periodo!';}
		}
		if ($ret['ok']){
			$ret['erro'] = 'Dados do Cadastro da Pessoa '.$codigo.' Excludos!;;';
		}else{
			$ret['erro'] = 'Dados do Cadastro da Pessoa '.$codigo.' NO Foram Excludos!;Motivo:;'.$ret['erro'].';;';
			if($tempo>0){
				$ret['erro'] = '';
			}
		}
		return $ret;
	}
	function estoque_recalcula_dia($valida_dia=true,$empresa=''){
		if ($empresa==''){ $empresa = $_SESSION['Empresa_Codigo']; }
		
		if ($valida_dia){
			$con_est = 'select DataEstoque from paf_estoque_dia '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' limit 1';
			$res_est = consulta_sql($con_est);
			$reg_est = consulta_ler_linha($res_est);
			consulta_limpa($res_est);
			$ok = data_atual('date')!=$reg_est[0];
			$data_est = $reg_est[0];
		}else{
			$ok = true;
		}
		if ($ok){
			ignore_user_abort(1);

			$data = data_atual('date');
			$data_est = $data;

			$apagar = 'delete from paf_estoque_dia '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"';
			consulta_sql($apagar);

			$estoque = array();

			$con_esto = 'select Id_Produto, Saldo_Atual from produto_saldo_filial '.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' and Local_Armaz="0"';
			$res_esto = consulta_sql($con_esto);
			$nrw_esto = consulta_num_registros($res_esto);
			for($e=0;$e<$nrw_esto;$e++){
				$reg_esto = consulta_ler_objeto($res_esto);
				$estoque[$reg_esto->Id_Produto]=$reg_esto->Saldo_Atual;
			}
			consulta_limpa($res_esto);
			$con_esto = 'select Id_Produto, Saldo_Atual, Codigo_Barras from produto_saldo_filial_barra'.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Codigo_Empresa = "'.$empresa.'"'.
						' and Local_Armaz="0"';
			$res_esto = consulta_sql($con_esto);
			$nrw_esto = consulta_num_registros($res_esto);
			for($e=0;$e<$nrw_esto;$e++){
				$reg_esto = consulta_ler_objeto($res_esto);
				$estoque[$reg_esto->Id_Produto.'_'.$reg_esto->Codigo_Barras]=$reg_esto->Saldo_Atual;
			}
			consulta_limpa($res_esto);

			$con_barra= 'select '.
						' pro.Id_Produto,'.
						' pro.Codigo_Produto,'.
						' pro.Descricao_Completa,'.
						' pro.Codigo_Depart,'.
						' pro.Codigo_Classe_Tributo,'.
						' pro.NCM,'.
						' pro.Unidade_Venda,'.
						' pro.Codigo_CEST, '.
						' barra.Codigo_Barras, '.
						' barra.Complemento '.
						' from produto pro'.
						' left outer join produto_cod_barras barra'.
						' on pro.Dominio=barra.Dominio '.
						' and pro.Id_Produto=barra.Id_Produto '.
						' and barra.Situacao<>"E"'.
						' WHERE pro.Dominio = "'.$_SESSION["Dominio"].'"'.
						' and pro.Id_Produto>0'.
						' and pro.Codigo_Depart!=0'.
						' and pro.Situacao<>"E"'.
						' order by pro.Id_Produto';
			$res_barra = consulta_sql($con_barra);
			$nrw_barra = consulta_num_registros($res_barra);
			for($i=0;$i<$nrw_barra;$i++){
				$reg_barra = consulta_ler_objeto($res_barra);
				$barra = $reg_barra->Codigo_Barras;
				$est_id = $reg_barra->Id_Produto.'_'.$reg_barra->Codigo_Barras;
				if ($barra==''){
					$barra = $reg_barra->Codigo_Produto;
					$est_id = $reg_barra->Id_Produto;
				}
				if (isset($estoque[$est_id])){
					$saldo = $estoque[$est_id];
				}else{
					$saldo = 0;
				}
				$dados = '"'.$_SESSION["Dominio"].'", '.
						'"'.$empresa.'", '.
						'"'.$reg_barra->Id_Produto.'", '.
						'"'.$barra.'", '.
						'"'.str_replace('"',"'",$reg_barra->Codigo_Produto).'", '.
						'"'.str_replace('"',"'",trim($reg_barra->Descricao_Completa.' '.$reg_barra->Complemento)).'", '.
						'"'.$reg_barra->NCM.'", '.
						'"'.$reg_barra->Codigo_CEST.'", '.
						'"'.$reg_barra->Unidade_Venda.'", '.
						'"'.$saldo.'", '.
						'"'.$data.'", ';
				$ins = 'INSERT INTO paf_estoque_dia '.
						' (Dominio, Empresa, '.
						' Id_Produto, Produto_Barra, Produto_Cod, '.
						' Produto_Descricao, Produto_NCM, Produto_CEST,'.
						' Produto_Unidade, Saldo, DataEstoque, Cript) '.
						' VALUES ('.$dados.'"'.md5($dados).'")';
				consulta_sql($ins);
			}
			consulta_limpa($res_barra);
		}
		$res['ok'] = $ok;
		$res['data'] = $data_est;

		return $res;
	}

	function calcula_base_pisconfis($base_pis,$data,$valor_icms,$pessoa,$tipo_emissao){
		//echo '<BR>base_pis'.$base_pis.'-data'.$data.'-valor_icms'.$valor_icms.'-';
		//echo '-';
		//echo 
		$data_inicio = BuscaParam('ICMS_BASE_PISCOFINS');
		if (($data_inicio=='')||($data_inicio=='0000-00-00')){
			//echo 'NE';
			return $base_pis;
		}else{
			$n_data = data2nr(dataf($data));
			$n_data_inicio = data2nr(dataf($data_inicio));
			if ($n_data>=$n_data_inicio){
				$base_pis = round($base_pis - $valor_icms,2);
				if ($base_pis<0.01){
					$base_pis = 0;
				}
			}
		}
		//echo 'base_final'.$base_pis;
		return $base_pis;
	}

	/** 
	 * Funo usada para clculo de  data_base que o sistema usa para alertas 
	 * @return string $data_base (formato aaaa-mm-dd)
	 */
	function calcula_data_base_carencia(){

		$periodo = BuscaParam('FAT_CARENCIA');
		
		if ( ($_SESSION["Dominio"]==49) ){	
			$periodo = 0;			
		}
		if (($_SESSION["Dominio"]==83 )){
			$periodo = 90;
		}
		/**Solicitao realizada por cliente Victor em 25/08/2023 via e-mail realizado por @isabel  */
		if(  Zathura()  ){
			$periodo = 2;
		}
		if ( ($_SESSION["Dominio"]==420) ){
			$periodo = 10;
		}
		$data_base = datad(nr2data((data_atual('nr')-$periodo)));		
		return $data_base;
	}


	/** Funo para validar o saldo do usuario */
	function valida_saldo_usuario(){
		/**Verificar o Limite de Crdito do usuario */
		$cons_LC = 'SELECT Limite_Credito FROM usuario '.
					' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
					' AND Usuario="'.base64_decode_si($_REQUEST['USER_ID']).'"';
		$res_LC = consulta_sql( $cons_LC );
		$reg_LC = consulta_ler_linha( $res_LC );
		consulta_limpa( $res_LC );

		return $reg_LC[0];

	}
	
	function cria_txt($num_pedido, $empresa, $ocultar, $monitor){

		$inicio_linha_txt = '10000S';
		$dados_pedido = '';
		$dados_item = '';
		$dados_rodape = '';
		$fim_Linha = '
';
		$label = label_vendedor_ou_rep_comercial('S');

		$lbl_ped = busca_nome_pedido_orc();
		if($lbl_ped=='Pedido'){
			$lbl_ped2 = '                 P E D I D O             ';
		}else{
			$lbl_ped2 = '              O R C A M E N T O          ';
		}

		if ($_SESSION["Dominio"]==337){
			$lbl_ped2 = '         O R C A M E N T O - OXITINTAS   ';
		}

		$con_pedido = 'select * from pedido '.
					 ' where Dominio = "'.$_SESSION["Dominio"].'"'.
					 ' and Empresa = "'.$empresa.'"'.
					 ' and Numero_Pedido = "'.$num_pedido.'"';
		$res_pedido = consulta_sql($con_pedido);
		$reg_pedido = consulta_ler_objeto($res_pedido);
		consulta_limpa($res_pedido);

		$con_pess = 'select Nome_Razao, CPF_CNPJ from pessoa '.
				   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' and Pessoa = "'.$reg_pedido->Pessoa.'"';
		$res_pess = consulta_sql($con_pess);
		$reg_pess = consulta_ler_linha($res_pess);
		consulta_limpa($res_pess);

		$con_ende = 'select * from pessoa_endereco '.
				   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' and Pessoa = "'.$reg_pedido->Pessoa.'"'.
				   ' and Seq_Endereco = "'.$reg_pedido->Local_Fatura.'"';
		$res_ende = consulta_sql($con_ende);
		$reg_ende = consulta_ler_objeto($res_ende);
		consulta_limpa($res_ende);

		$con_vend = 'select Nome_Listas, CPF_CNPJ from pessoa '.
				   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' and Pessoa = "'.$reg_pedido->Vendedor.'"';
		$res_vend = consulta_sql($con_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);

		//strtoupper
		$dados_pedido = $inicio_linha_txt.'   '.$fim_Linha.
						$inicio_linha_txt.'   '.$fim_Linha.
						$inicio_linha_txt.''.xml_carac2especial($lbl_ped2).''.$fim_Linha;
		if ($_SESSION["Dominio"]==337){
			$dados_pedido.= $inicio_linha_txt.'            Fone: (47) 99120-4473'.$fim_Linha;
		}
		$dados_pedido.= $inicio_linha_txt.'         ---------------------------     '.$fim_Linha.
						$inicio_linha_txt.preenche_texto(UpperDados($lbl_ped).' N.: '.$reg_pedido->Numero_Pedido,29).dataf($reg_pedido->DH_Emissao).' '.substr($reg_pedido->DH_Emissao,11,8).$fim_Linha.
						$inicio_linha_txt.preenche_texto(substr($label.': '.$reg_vend[0], 0, 48),48).$fim_Linha.
						$inicio_linha_txt.'------------------------------------------------'.$fim_Linha.
						$inicio_linha_txt.substr('Cliente: '.$reg_pess[0], 0, 48).$fim_Linha;
		if (($_SESSION["Dominio"]==337)||($_SESSION["Dominio"]==386)){
			$endereco = $reg_ende->Logradouro.', ';
			if ($reg_ende->Numero==''){
				$endereco.= 'S/N';
			}else{
				$endereco.= $reg_ende->Numero;
			}
			if ($reg_ende->Complemento!=''){
				$endereco.= ' - '.$reg_ende->Complemento;
			}
			$endereco1 = $inicio_linha_txt.substr($endereco, 0, 48).$fim_Linha;
			$endereco2 = trim(substr($endereco, 48, 48));
			if ($endereco2!=''){
				$endereco2 = $inicio_linha_txt.$endereco2.$fim_Linha;
			}
			$dados_pedido.= $endereco1.$endereco2.
						$inicio_linha_txt.substr($reg_ende->Bairro.' - '.$reg_ende->Nome_Cidade.'/'.$reg_ende->UF, 0, 48).$fim_Linha;

		}
		if ($_SESSION["Dominio"]==337){//337
			$dados_pedido.= $inicio_linha_txt.'------------------------------------------------'.$fim_Linha.
							$inicio_linha_txt.'DESCRICAO PRODUTO      |QTD |V. UNIT  |V. TOTAL '.$fim_Linha.
							$inicio_linha_txt.'------------------------------------------------'.$fim_Linha;
		}else{								 //12345678901234567890
			$dados_pedido.= $inicio_linha_txt.'------------------------------------------------'.$fim_Linha.
							$inicio_linha_txt.preenche_texto('DESCRICAO DO PRODUTO',29).'|'.preenche_texto_esquerda('QUANT.',7).'|'.preenche_texto_esquerda('VALOR',10).$fim_Linha.
							$inicio_linha_txt.'------------------------------------------------'.$fim_Linha;
		}
		$con_item = 'select * from pedido_item '.
					' where Dominio = "'.$_SESSION["Dominio"].'"'.
					' and Empresa = "'.$empresa.'"'.
					' and Numero_Pedido = "'.$num_pedido.'"'.
					' and Status <> "C"'.
					' and Status <> "E"';
		if($ocultar=='S'){
			if($reg_pedido->Status=='L'){
				$con_item.=' and Status = "L"';
			}
		}
		$con_item.= ' order by Seq_Item asc ';
		$res_item = consulta_sql($con_item);
		$nrows_item = consulta_num_registros($res_item);
		$total_desc = 0;
		$total_acre = 0;
		$total_ped  = 0;
		$total_imposto=0;
		$total_pedido = $reg_pedido->Valor_Sub_Total;
		if($nrows_item>0){
			for($i=0;$i<$nrows_item;$i++){
				$reg_item = consulta_ler_objeto($res_item);

				$cons_prod = 'select Codigo_Produto, Descricao_Completa '.
							' from produto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto = "'.$reg_item->ID_Produto.'"';
				$res_prod = consulta_sql($cons_prod);
				$reg_prod = consulta_ler_linha($res_prod);
				consulta_limpa($res_prod);

				$mostrar = false;
				if((($ocultar!='S')||($reg_item->Qtd_Atendida<$reg_item->Qtd)) || ($reg_pedido->Status!='L')){
					$mostrar = true;
				}

				if($reg_pedido->Status!='L'){
					$qtd_e = $reg_item->Qtd;
					$qtd_l = $reg_item->Qtd_Liberada;
					$qtd_a = $reg_item->Qtd_Atendida;
				}else if ($ocultar=='S'){
					$qtd_e = ($reg_item->Qtd_Liberada-$reg_item->Qtd_Atendida);
					$qtd_l = ($reg_item->Qtd_Liberada-$reg_item->Qtd_Atendida);
					$qtd_a = 0;
					if ($qtd_e<0){
					   $qtd_e = 0;
					}
					if ($qtd_l<0){
					   $qtd_l = 0;
					}
				}else{
					$qtd_e = $reg_item->Qtd;
					$qtd_l = $reg_item->Qtd_Liberada;
					$qtd_a = $reg_item->Qtd_Atendida;
				}

				$val_ped =  arredonda_numero_menos(($qtd_e*$reg_item->Valor_Unitario)*100)/100;
				$perc_tot = ($qtd_e/$reg_item->Qtd);
				$desc_ped = arredonda_numero_menos(($reg_item->Valor_Desconto * $perc_tot)*100)/100;
				$imp_prod = arredonda_numero_menos(($reg_item->Valor_Imposto * $perc_tot)*100)/100;
				if ($total_pedido>0){
					$perc_ped = $val_ped/$total_pedido;
				}else{
					$perc_ped = 1;
				}				
				
				$acre_ped = arredonda_numero_menos((($reg_item->Valor_Acrescimo) * $perc_tot)*100)/100;
				$acre2_ped = arredonda_numero_menos((($reg_pedido->Valor_Outros) * $perc_tot * $perc_ped)*100)/100;

				$total_desc+= $desc_ped;
				$total_acre+= $acre_ped + $acre2_ped;
				$total_imposto+= $imp_prod;
				$total_ped+= ($val_ped + $imp_prod + $acre_ped + $acre2_ped) - $desc_ped;

				if($mostrar){
					$total_item = formata_valor(str_replace('"','',to_money($reg_item->Valor_Unitario)));
					$val_pedS = formata_valor(str_replace('"','',to_money($val_ped)));
					if ($_SESSION["Dominio"]==337){ //
						$dados_item.= $inicio_linha_txt.preenche_texto(substr($reg_prod[1], 0, 23), 23).
													'|'.preenche_texto_esquerda(formata_qtd($qtd_e,2,false),4).
													'|'.preenche_texto_esquerda($total_item,9).
													'|'.preenche_texto_esquerda($val_pedS,9).$fim_Linha;
					}else if ($_SESSION["Dominio"]==386){ //{
						$dados_item.= $inicio_linha_txt.preenche_texto(substr(' '.$reg_prod[1], 0, 47), 47).$fim_Linha;
						$dados_item.= $inicio_linha_txt.preenche_texto(substr(' '.$reg_prod[1], 47, 29), 29).
													'|'.preenche_texto_esquerda(formata_qtd($qtd_e,2,false),7).
													'|'.preenche_texto_esquerda($val_pedS,10).$fim_Linha;
					}else{ //{
						$dados_item.= $inicio_linha_txt.preenche_texto(substr(' '.$reg_prod[1], 0, 29), 29).
													'|'.preenche_texto_esquerda(formata_qtd($qtd_e,2,false),7).
													'|'.preenche_texto_esquerda($val_pedS,10).$fim_Linha;
					}
				}
			}
		}
		consulta_limpa($res_item);

		$total_frete = $reg_pedido->Valor_Frete;
		$total_troco = $reg_pedido->Pagto_Troco;

		$total_ped = formata_valor(str_replace('"','',to_money($total_ped)));
		$dados_rodape.= $inicio_linha_txt.'------------------------------------------------'.$fim_Linha;
		if ($total_desc>0){
			$total_desc = formata_valor(str_replace('"','',to_money($total_desc)));
			$dados_rodape.= $inicio_linha_txt.preenche_texto('TOTAL DESCONTO:',38).''.preenche_texto_esquerda($total_desc,10).$fim_Linha;
		}
		if ($total_acre>0){
			$total_acre = formata_valor(str_replace('"','',to_money($total_acre)));
			$dados_rodape.= $inicio_linha_txt.preenche_texto('TOTAL ACRESCIMO:',38).''.preenche_texto_esquerda($total_acre,10).$fim_Linha;
		}
		if ($total_imposto>0){
			$total_imposto = formata_valor(str_replace('"','',to_money($total_imposto)));
			$dados_rodape.= $inicio_linha_txt.preenche_texto('TOTAL IMPOSTO:',38).''.preenche_texto_esquerda($total_imposto,10).$fim_Linha;
		}
		if ($total_frete>0){
			$total_frete = formata_valor(str_replace('"','',to_money($total_frete)));
			$dados_rodape.= $inicio_linha_txt.preenche_texto('TOTAL ENTREGA:',38).''.preenche_texto_esquerda($total_frete,10).$fim_Linha;
		}
		
		$dados_rodape.= $inicio_linha_txt.preenche_texto('TOTAL DO '.UpperDados($lbl_ped).':',38).''.preenche_texto_esquerda($total_ped,10).$fim_Linha;
		if( $_SESSION['Dominio'] != 241){
			$cb_forma_pagto='select Codigo_Pagto, Descricao from forma_pagto '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Status<>"E" order by Descricao';
			$plano_pagto = busca_dados_combo($cb_forma_pagto,$reg_pedido->Forma_Pagto);
			if (strtolower($plano_pagto)=='dia determinado'){
				$con_pagto= 'select * from pedido_parcela '.
							' where Dominio ="'.$_SESSION['Dominio'].'"'.
							' and Empresa="'.$_SESSION["Empresa_Codigo"].'"'.
							' and Numero_Pedido="'.$num_pedido.'" ';
				$res_pagto = consulta_sql($con_pagto);
				$reg_pagto = consulta_ler_objeto($res_pagto);
				consulta_limpa($res_pagto);
				$plano_pagto.= ' ('.dataf($reg_pagto->DT_Vencimento).')';
			}
			$meio_pagto = busca_dados_combo('tipo_fatura',$reg_pedido->Fatura_Tipo).' '.$reg_pedido->Pagto_DescricaoComplementar;
			if ($reg_pagto->Fatura_Pago=='S'){
				$meio_pagto.= ' (Pago)';
			}
			
			$dados_rodape.=$inicio_linha_txt.preenche_texto($plano_pagto.' '.$meio_pagto,48).$fim_Linha;
		}

		if ($total_troco>0){
			$total_troco = formata_valor(str_replace('"','',to_money($total_troco)));
			$dados_rodape.= $inicio_linha_txt.preenche_texto('TROCO:',38).''.preenche_texto_esquerda($total_troco,10).$fim_Linha;
		}

		if(( $_SESSION['Dominio'] != 241)&&( $_SESSION['Dominio'] != 382)){
			$seq_entrega = $reg_pedido->Local_Entrega;
			if ($seq_entrega==0){
				$seq_entrega = $reg_pedido->Local_Fatura;
			}
			$entrega_texto = 'Entrega: ';
			if ($reg_pedido->Local_Retirada>0){
				$entrega_texto = 'Retirada no Balco';
				$entrega_ender1 = '';
				$entrega_ender2 = '';
			}else if ($seq_entrega>0){
				$con_ender ='SELECT * FROM pessoa_endereco '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							' AND Pessoa = "'.$reg_pedido->Pessoa.'"'.
							' AND Seq_Endereco = "'.$seq_entrega.'"';
				$res_ender = consulta_sql($con_ender);
				$reg_ender = consulta_ler_objeto($res_ender);
				consulta_limpa($res_ender);

				$entrega_ender1 = $reg_ender->Logradouro;
				if ($reg_ender->Numero!=''){
					$entrega_ender1.= ', '.$reg_ender->Numero;
				}else{
					$entrega_ender1.= ', S/N';
				}
				$entrega_ender1.= ' '.$reg_ender->Complemento;
				$entrega_ender2 = $reg_ender->CEP.' '.$reg_ender->Bairro.' - '.
									$reg_ender->Nome_Cidade.'/'.$reg_ender->UF;
			}else{
				$con_cidad ='SELECT Nome,UF FROM cidade '.
							' WHERE Dominio="'.$_SESSION["Dominio"].'"'.
							' AND Codigo_Cidade = "'.$reg_pedido->Entrega_Codigo_Cidade.'"';
				$res_cidad = consulta_sql($con_cidad);
				$reg_cidad = consulta_ler_objeto($res_cidad);
				consulta_limpa($res_cidad);
				$entrega_ender1 = $reg_pedido->Entrega_Logradouro;
				if ($reg_pedido->Entrega_Numero!=''){
					$entrega_ender1.= ', '.$reg_pedido->Entrega_Numero;
				}else{
					$entrega_ender1.= ', S/N';
				}
				$entrega_ender1.= ' '.$reg_pedido->Entrega_Complemento;
				$entrega_ender2 = $reg_pedido->Entrega_CEP.' '.$reg_pedido->Entrega_Bairro.' - '.
									$reg_cidad->Nome.'/'.$reg_cidad->UF;


				
			}

			$ent = $entrega_texto.$entrega_ender1.' '.$entrega_ender2;
			$ent1 = substr($ent,0,48);
			$ent2 = substr($ent,48,48);
	
		
			$dados_rodape.= $inicio_linha_txt.'------------------------------------------------'.$fim_Linha.
						$inicio_linha_txt.$ent1.$fim_Linha;

			if ($ent2!=''){
				$dados_rodape.= $inicio_linha_txt.$ent2.$fim_Linha;
			}
		}
		$dados_rodape.= $inicio_linha_txt.'------------------------------------------------'.$fim_Linha.
						$inicio_linha_txt.substr('OBS: '.nfe_formata_txt($reg_pedido->Observacao), 0, 48).$fim_Linha.
						$inicio_linha_txt.'   '.$fim_Linha.
						$inicio_linha_txt.'   '.$fim_Linha.
						$inicio_linha_txt.'------------------------------------------------'.$fim_Linha;
		
		if(( $_SESSION['Dominio'] != 241)&&( $_SESSION['Dominio'] != 382)){
			if ($reg_pedido->Local_Retirada>0){
			}else{
				/** Modificacao realizada para Dominio 337 em  27-12-2023 por @isabel */
				if( $_SESSION['Dominio'] != 337){

					$dados_rodape.= $inicio_linha_txt.'DECLARO QUE RECEBI DO ENTREGADOR OS PRODUTOS E PAGUEI O VALOR ACIMA.'.$fim_Linha.
								$inicio_linha_txt.' '.$fim_Linha.
								$inicio_linha_txt.'_________________________________'.$fim_Linha.
								$inicio_linha_txt.substr($reg_pess[0], 0, 48).$fim_Linha.
								$inicio_linha_txt.' '.$fim_Linha.
								$inicio_linha_txt.'RECEBIDO AS: ____:____'.$fim_Linha;
				}
			}
		}

		/** Modificacao realizada para Dominio 337 em  27-12-2023 por @isabel */
		if( $_SESSION['Dominio'] != 337){
			$dados_rodape.= $inicio_linha_txt.'.'.$fim_Linha.
						$inicio_linha_txt.'.'.$fim_Linha.
						$inicio_linha_txt.'.'.$fim_Linha.
						$inicio_linha_txt.'.'.$fim_Linha;
		}

		$mensagem = 'Falha ao Gerar Arquivo!';
		if($dados_item!=''){
			$mensagem = 'Impresso gerada!';
			if ($monitor==1){
				monitor_web_executar(	'TXT',		//DOC/NFE/CCE/PDV
										'TXT', 		//ARQ ou TXT
										'',		//paramentros para executar ou nome do arquivo p/ operacao PDV)
										$dados_pedido.$dados_item.$dados_rodape);
			}else{
				$path = "../../../arquivos_clientes/".$_SESSION['Dominio']."/pedidos/";
				rmkdir2($path);
				$arquivo_final = 'Pedido_'.$num_pedido.'.FRE';
				if (file_exists($path.'/'.$arquivo_final)){
					unlink($path.'/'.$arquivo_final);
				}
				$dados_txt = $dados_pedido.$dados_item.$dados_rodape;
				$Handle = fopen($path.'/'.$arquivo_final, 'w');
				fwrite($Handle, $dados_txt);
				fclose($Handle);
				if (file_exists($path.'/'.$arquivo_final)){
					//echo '<BR>Arquivo Gerado com Sucesso!';
					$mensagem = 'Arquivo Gerado com Sucesso!';
				}
			}
		}
		return $mensagem;
	}
	
	/**Funo usada para a busca de Pessoas que tem Procuracao (Tipo de Documento == 13) cadastrado 
	 * return string com as pessoas que tem procuracao separado com ',' 
	*/
	function busca_pessoas_com_procuracao(){
		$pessoas_procuracao = '-1';
		//procurar todas as pessoas que tem procuracao
		$con_proc = 'SELECT Pessoa FROM pessoa_documento '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
		 			' AND Procurado = "13"'. 
		 			' AND Situacao="A"';
 		$res_proc = consulta_sql($con_proc);
 		$row_proc = consulta_num_registros( $res_proc );
		if( $row_proc > 0 ){
			for( $pp = 0 ; $pp <  $row_proc ; $pp ++){
				$reg_proc = consulta_ler_linha($res_proc);
				$pessoas_procuracao .= ', '. $reg_proc[0];
			}            
			consulta_limpa($res_proc);
		}
		return $pessoas_procuracao;
	}

	/**
	 * Funo Adicionar No Pedido  o primeiro Numero de Telefone Ativo do Cliente ir fazer a atualizao do Pedido
	 * @param string $empresa
	 * @param string $pessoa
	 * @param string $pedido 
	 * */
	function add_pedido_telefone_cliente(  $empresa,  $pessoa,  $pedido  ){
		$telefone = 0 ;
		//procurar todos telefones desta pessoa
		$con_tel = 'SELECT Seq_Telefone FROM pessoa_telefone '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Pessoa="'.$pessoa.'"'.
		 			' AND Situacao="A"'.
					' order by Seq_Telefone LIMIT 1 ';
 		$res_tel = consulta_sql($con_tel);
		$reg_tel = consulta_ler_linha($res_tel );
		consulta_limpa($res_tel );
		$telefone = $reg_tel[0] ;
		$upt_pedido =   'UPDATE pedido SET'.
						' Tel = "'.$telefone.'"'.
						' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
						' AND Empresa = "'.$empresa.'"'.
						' AND Numero_Pedido = "'.$pedido.'"';
		consulta_sql($upt_pedido ,true,1);
	}

	/**
	 * Mtodo para verificar Se pode ou No Cancelar o Pedido Original
	 * @param string $empresa
	 * @param string $pedido
	 * @return void
	 */
	function verifica_pedido_itens_clonados( $empresa, $pedido ){
		$cancelar_pedido = false; 
		$ttl_atendido = 0; 
		//Procurar o status do Pedido 
		$con_pdd = 'SELECT Status  FROM pedido '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa ="'.$empresa.'"'.
		 			' AND Numero_Pedido ="'.$pedido.'"';
 		$res_pdd = consulta_sql($con_pdd);
		$reg_pdd = consulta_ler_linha($res_pdd );
		consulta_limpa($res_pdd );
		//j foi cancelado,  ento no fazer mais nada
		//foi Fechado, No ser alerado
		//Foi excluido, no ira fazer mais nada 
		if( ($reg_pdd[0] != 'C') && ($reg_pdd[0] != 'F') && ($reg_pdd[0] != 'E')){
			//busca cada item 
			$con_item = 'SELECT Qtd_Atendida,  Status  FROM pedido_item  '.
					' WHERE Dominio="'.$_SESSION['Dominio'].'"'.
					' AND Empresa ="'.$empresa.'"'.
		 			' AND Numero_Pedido ="'.$pedido.'"';
			$res_item = consulta_sql($con_item );
			$nrm_item = consulta_num_registros( $res_item );
			for( $i=0; $i<= $nrm_item ; $i++){
				$reg_item = consulta_ler_linha($res_item );
				if( ($reg_item[1] != 'C') && ($reg_item[1] != 'F') && ($reg_item[1] != 'E')){
					$ttl_atendido += $reg_item[0];
				}
			}			
			consulta_limpa($res_item );
			//se qualquer quantidade atendida for maior que zero,  
			//j trava e responde como falso 
			if( $ttl_atendido <= 0){
				$cancelar_pedido = true ; 
			}
		}
		return   $cancelar_pedido ;
	}
?>