<?
	class SF_Reg_0000 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $LECD='LECD';
		var $DT_FIN;
		var $NOME;
		var $CNPJ;
		var $UF;
		var $IE;
		var $COD_MUN;
		var $IM;
		var $IND_SIT_ESP;

		function CriaRegistro($DT_INI, $DT_FIN,
							$NOME, $CNPJ, $UF, $IE, $COD_MUN,
							$IM, $IND_SIT_ESP=''){

			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			//echo '-'.$NOME.'-';

			$this->CNPJ = substr(limpa_numero($CNPJ),0,14);
			$this->UF = substr($UF,0,2);
			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if ($IE=='ISENTO'){
				$this->IE = 'ISENTO';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->IM = limpa_numero2($IM);

			$this->IND_SIT_ESP = $IND_SIT_ESP;
		}

		function LerRegistro(){
			return '|0000|'.
					$this->LECD.'|'.
					$this->DT_INI.'|'.
					$this->DT_FIN.'|'.
					$this->NOME.'|'.
					$this->CNPJ.'|'.
					$this->UF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->IM.'|'.
					$this->IND_SIT_ESP.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0007 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_ENT_REF;
		var $COD_INSCR;
		
		function CriaRegistro($COD_ENT_REF, $COD_INSCR){
			$this->COD_ENT_REF = trim(substr(limpa_texto($COD_ENT_REF),0,60));
			$this->COD_INSCR = trim(substr(limpa_texto($COD_INSCR),0,60));
		}

		function LerRegistro(){
			return '|0007|'.
					$this->COD_ENT_REF.'|'.
					$this->COD_INSCR.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0020 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_DEC;
		var $CNPJ;
		var $UF;
		var $IE;
		var $COD_MUN;
		var $IM;
		var $NIRE;

		function CriaRegistro($IND_DEC, $CNPJ, $UF, $IE, $COD_MUN,
							$IM, $NIRE=''){
			$this->IND_DEC = $IND_DEC;
			$this->CNPJ = substr(limpa_numero($CNPJ),0,14);
			$this->UF = substr($UF,0,2);
			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if ($IE=='ISENTO'){
				$this->IE = 'ISENTO';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->IM = limpa_numero2($IM);
			$this->NIRE = $NIRE;
		}

		function CriaRegistroBase($COD_PESSOA){
			//consulta cadastro de pessoa
			$con_pessoa = 'select * from pessoa '.
			' where Dominio = "'.$_SESSION['Dominio'].'"'.
			' and Pessoa="'.$COD_PESSOA.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			$nrw_pessoa = consulta_num_registros($res_pessoa);
			consulta_limpa($res_pessoa);
			if ($nrw_pessoa==0){
				sped_exibe_erro( '0020', 'Falha na gerao do arquivo SPED! Pessoa ('.$COD_PESSOA.') no cadastrada ! ');
			}
			//consulta endereco da nota ou princpal
			//se for zero ( o primeiro endereco disponivel)
			$con_ender = 'select * from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"'.
						' and Situacao<>"E"'.
						' order by Seq_Endereco limit 1';
			$res_ender = consulta_sql($con_ender);
			$reg_ender = consulta_ler_objeto($res_ender);
			consulta_limpa($res_ender);

			if (!(valida_cpf_cnpj($reg_pessoa->CPF_CNPJ))){
				sped_exibe_erro( '0020', 'Falha na gerao do arquivo SPED! CPF/CNPJ ('.$reg_pessoa->CPF_CNPJ.') da Pessoa ('.$COD_PESSOA.') invlido!');
			}
			if ((limpa_numero2($reg_ender->Insc_Estadual)!='')&&($reg_ender->Insc_Estadual!='ISENTO')){
				if (!(ChkInscEstadual(limpa_numero2($reg_ender->Insc_Estadual), $reg_ender->UF))){
					sped_exibe_erro( '0020', 'Falha na gerao do arquivo SPED! Inscrio Estadual ('.$reg_ender->Insc_Estadual.') da Pessoa ('.$COD_PESSOA.') Invlida para '.$reg_ender->UF.'!');
				}
			}
			if ($reg_ender->Codigo_Cidade==0){
				sped_exibe_erro( '0020', 'Falha na gerao do arquivo SPED! Cidade da Pessoa ('.$COD_PESSOA.') no cadastrada!');
			}
			$IND_DEC = '0';    //12.456.890/2345-78
			if (substr($reg_pessoa->CPF_CNPJ,11,4)=='0001'){
				$IND_DEC = '1';
			}
			$this->CriaRegistro($IND_DEC, $reg_pessoa->CPF_CNPJ,
			$reg_ender->UF,
			$reg_ender->Insc_Estadual,
			$reg_ender->Codigo_Cidade,
			$reg_ender->Insc_Municipal);
			return $this->UF;
		}

		function LerRegistro(){
			return '|0020|'.
					$this->IND_DEC.'|'.
					$this->CNPJ.'|'.
					$this->UF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->IM.'|'.
					$this->NIRE.'|'.
					fim_linha();
		}

	}

	class SF_Reg_0150 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_PART;
		var $NOME;
		var $COD_PAIS;
		var $CNPJ;
		var $CPF;
		var $NIT;
		var $UF;
		var $IE;
		var $IE_ST;
		var $COD_MUN;
		var $IM;
		var $SUFRAMA;

		function CriaRegistro($COD_PART, $NOME, $COD_PAIS, $CNPJ,
							$NIT, $UF, $IE, $IE_ST, $COD_MUN,
							$IM, $SUFRAMA){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			$this->COD_PAIS = trim(substr(limpa_numero($COD_PAIS),0,5));
			if ($this->COD_PAIS==''){
				$this->COD_PAIS='1058';//brasil
			}
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			if (strlen($this->CNPJ)==11){
				$this->CPF = $this->CNPJ;
				$this->CNPJ = '';
			}else{
				$this->CPF = '';
			}
			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if ($IE=='ISENTO'){
				$this->IE = 'ISENTO';
			}
			$this->IE_ST = trim(substr(limpa_numero2($IE_ST),0,14));
			if ($IE_ST=='ISENTO'){
				$this->IE_ST = 'ISENTO';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->SUFRAMA = limpa_numero2($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}
			$this->UF = $UF;
			$this->NIT = $NIT;
			$this->IM = $IM;

			if ($this->COD_PAIS!='1058'){
				$this->COD_MUN = '9999999';
				$this->CPF = '';
				$this->CNPJ = '';
				$this->IE = '';
				$this->UF = 'EX';
			}
		}

		function CriaRegistroBase($COD_PART){
			//echo '-part_'.$COD_PART.'-';
			$codigo = explode('_',$COD_PART);
			if (isset($codigo[1])){
				$COD_PESSOA = $codigo[1];
			}else{
				$COD_PESSOA = 1;
			}
			if (isset($codigo[2])){
				$COD_ENDER = $codigo[2];
			}else{
				$COD_ENDER = 0;
			}
			//consulta cadastro de pessoa
			$con_pessoa = 'select * from pessoa '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			$nrw_pessoa = consulta_num_registros($res_pessoa);
			consulta_limpa($res_pessoa);
			if ($nrw_pessoa==0){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Pessoa ('.$COD_PART.') no cadastrada ! ');
			}else{
				if (trim($reg_pessoa->Nome_Razao)==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Nome/Razo da Pessoa ('.$COD_PART.') no cadastrada! ');
				}
			}
			//consulta endereco da nota ou princpal
			//se for zero ( o primeiro endereco disponivel)
			$con_ender = 'select * from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"';
			if ($COD_ENDER>0){
				$con_ender.= ' and Seq_Endereco="'.$COD_ENDER.'"';
			}else{
				$con_ender.= ' and Situacao<>"E" order by Seq_Endereco limit 1';
			}
			$res_ender = consulta_sql($con_ender);
			$reg_ender = consulta_ler_objeto($res_ender);
			consulta_limpa($res_ender);
			$ENDER = $reg_ender->Logradouro;
			if ($reg_ender->UF=='EX'){
				$ENDER.= ' '.$reg_ender->Nome_Cidade;
			}else{
				if (!(valida_cpf_cnpj($reg_pessoa->CPF_CNPJ))){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! CPF/CNPJ ('.$reg_pessoa->CPF_CNPJ.') da Pessoa ('.$COD_PART.') invlido!');
				}
				if ((limpa_numero2($reg_ender->Insc_Estadual)!='')&&($reg_ender->Insc_Estadual!='ISENTO')){
					if (!(ChkInscEstadual(limpa_numero2($reg_ender->Insc_Estadual), $reg_ender->UF))){
						sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Inscrio Estadual ('.$reg_ender->Insc_Estadual.') da Pessoa ('.$COD_PART.') Invlida para '.$reg_ender->UF.'!');
					}
				}
				if ($reg_ender->Codigo_Cidade==0){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Cidade da Pessoa ('.$COD_PART.') no cadastrada!');
				}
				if ($ENDER==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Logradouro da Pessoa ('.$COD_PART.') no cadastrado!');
				}
			}
			$this->CriaRegistro($COD_PART, $reg_pessoa->Nome_Razao,
								$reg_ender->Codigo_Pais, $reg_pessoa->CPF_CNPJ,
								'', $reg_ender->UF,
								$reg_ender->Insc_Estadual, '',
								$reg_ender->Codigo_Cidade,
								$reg_ender->Insc_Municipal, $reg_ender->Insc_SUFRAMA);
			return $this->UF;
		}

		function LerRegistro(){
			return '|0150|'.
					$this->COD_PART.'|'.
					$this->NOME.'|'.
					$this->COD_PAIS.'|'.
					$this->CNPJ.'|'.
					$this->CPF.'|'.
					$this->NIT.'|'.
					$this->UF.'|'.
					$this->IE.'|'.
					$this->IE_ST.'|'.
					$this->COD_MUN.'|'.
					$this->IM.'|'.
					$this->SUFRAMA.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0180 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_REL;
		var $DT_INI_REL;
		var $DT_FIN_REL;

		function CriaRegistro($COD_REL, $DT_INI_REL, $DT_FIN_REL){
			$this->COD_REL = $COD_REL;
			$this->DT_INI_REL = str_replace('/','',$DT_INI_REL);
			$this->DT_FIN_REL = str_replace('/','',$DT_FIN_REL);
		}

		function LerRegistro(){
			return '|0180|'.
					$this->COD_REL.'|'.
					$this->DT_INI_REL.'|'.
					$this->DT_FIN_REL.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_ESC;
		var $COD_VER_LC;

		function CriaRegistro($IND_ESC, $COD_VER_LC){
			$this->IND_ESC = trim(substr(limpa_texto($IND_ESC),0,6));
			$this->COD_VER_LC = trim(limpa_texto($COD_VER_LC));
		}

		function LerRegistro(){
			return '|I010|'.
					$this->IND_ESC.'|'.
					$this->COD_VER_LC.'|'.
					fim_linha();
			}
	}

	class SF_Reg_I012 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_ORD;
		var $NAT_LIVR;
		var $TIPO;
		var $COD_HASH_AUX;

		function CriaRegistro($NUM_ORD, $NAT_LIVR, $TIPO,
			$COD_HASH_AUX){
			$this->NUM_ORD = limpa_numero($NUM_ORD);
			$this->NAT_LIVR = trim(substr(limpa_texto($NAT_LIVR),0,80));
			$this->TIPO = trim(substr(limpa_numero($TIPO),0,1));
			$this->COD_HASH_AUX = $COD_HASH_AUX;
		}

		function LerRegistro(){
			return '|I012|'.
					$this->NUM_ORD.'|'.
					$this->NAT_LIVR.'|'.
					$this->TIPO.'|'.
					$this->COD_HASH_AUX.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I015 extends SPED_Registro_Base{
			//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CTA_RES;

		function CriaRegistro($COD_CTA_RES){
			$this->COD_CTA_RES = trim(substr(limpa_texto($COD_CTA_RES),0,60));
		}

		function LerRegistro(){
			return '|I015|'.
					$this->COD_CTA_RES.'|'.
					fim_linha();
		}

	}
			
	class SF_Reg_I020 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $REG_COD;
		var $NUM_AD;
		var $CAMPO;
		var $DESCRICAO;
		var $TIPO;

		function CriaRegistro($REG_COD, $NUM_AD, $CAMPO,
								$DESCRICAO, $TIPO){
			$this->REG_COD = trim(substr(limpa_texto($REG_COD),0,4));
			$this->NUM_AD = limpa_numero($NUM_AD);
			$this->CAMPO = trim(substr(limpa_texto($CAMPO),0,60));
			$this->DESCRICAO = trim(substr(limpa_numero($DESCRICAO),0,60));
			$this->TIPO = trim(substr(limpa_numero($TIPO),0,60));
		}

		function LerRegistro(){
			return '|I020|'.
					$this->REG_COD.'|'.
					$this->NUM_AD.'|'.
					$this->CAMPO.'|'.
					$this->DESCRICAO.'|'.
					$this->TIPO.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I030 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DNRC_ABERT="TERMO DE ABERTURA";
		var $NUM_ORD;
		var $NAT_LIVR;
		var $QTD_LIN;
		var $NOME;
		var $NIRE;
		var $CNPJ;
		var $DT_ARQ;
		var $DT_ARQ_CONV;
		var $DESC_MUN;

		function CriaRegistro($NUM_ORD, $NAT_LIVR, $QTD_LIN,
							$NOME, $NIRE, $CNPJ, $DT_ARQ, $DT_ARQ_CONV,
							$DESC_MUN){
			$this->NUM_ORD = limpa_numero($NUM_ORD);
			$this->NAT_LIVR = trim(substr(limpa_texto($NAT_LIVR),0,80));
			$this->QTD_LIN = limpa_numero($QTD_LIN);
			$this->NOME = trim(substr(limpa_texto($NOME),0,60));
			$this->NIRE = limpa_numero($NIRE);
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			$this->DT_ARQ = str_replace('/','',$DT_ARQ);
			$this->DT_ARQ_CONV = str_replace('/','',$DT_ARQ_CONV);
			$this->DESC_MUN = trim(substr(limpa_texto($DESC_MUN),0,80));
		}

		function LerRegistro(){
			return '|I030|'.
					$this->DNRC_ABERT.'|'.
					$this->NUM_ORD.'|'.
					$this->NAT_LIVR.'|'.
					$this->QTD_LIN.'|'.
					$this->NOME.'|'.
					$this->NIRE.'|'.
					$this->CNPJ.'|'.
					$this->DT_ARQ.'|'.
					$this->DT_ARQ_CONV.'|'.
					$this->DESC_MUN.'|'.
					fim_linha();
		}

	}

	class SF_Reg_I050 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_ALT;

		var $COD_NAT;
		var $IND_CTA;
		var $NIVEL;
		var $COD_CTA;
		var $COD_CTA_SUP;
		var $CTA;

		function CriaRegistro($DT_ALT, $COD_NAT, $IND_CTA, $NIVEL,
			$COD_CTA, $COD_CTA_SUP, $CTA){
			$this->DT_ALT = str_replace('/','',$DT_ALT);
			$this->COD_NAT = trim(substr(limpa_texto($COD_NAT),0,2));
			$this->IND_CTA = trim(substr(limpa_texto($IND_CTA),0,1));
			$this->NIVEL = limpa_numero($NIVEL);
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CTA_SUP = trim(substr(limpa_texto($COD_CTA_SUP),0,60));
			$this->CTA = trim(substr(limpa_texto($CTA),0,60));
		}

		function LerRegistro(){
			return '|I050|'.
					$this->DT_ALT.'|'.
					$this->COD_NAT.'|'.
					$this->IND_CTA.'|'.
					$this->NIVEL.'|'.
					$this->COD_CTA.'|'.
					$this->COD_CTA_SUP.'|'.
					$this->CTA.'|'.
					fim_linha();
		}

	}

	class SF_Reg_I051 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_ENT_REF;
		var $COD_CCUS;
		var $COD_CTA_REF;

		function CriaRegistro($COD_ENT_REF, $COD_CCUS, $COD_CTA_REF){
			$this->COD_ENT_REF = trim(substr(limpa_texto($COD_ENT_REF),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->COD_CTA_REF = trim(substr(limpa_texto($COD_CTA_REF),0,60));
		}

		function LerRegistro(){
			return '|I051|'.
					$this->COD_ENT_REF.'|'.
					$this->COD_CCUS.'|'.
					$this->COD_CTA_REF.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I052 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CCUS;
		var $COD_AGL;

		function CriaRegistro($COD_CCUS, $COD_AGL){
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->COD_AGL = trim(substr(limpa_texto($COD_AGL),0,60));
		}

		function LerRegistro(){
			return '|I052|'.
					$this->COD_CCUS.'|'.
					$this->COD_AGL.'|'.
					fim_linha();
		}

	}
	
	class SF_Reg_I075 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_HIST;
		var $DESCR_HIST;

		function CriaRegistro($COD_HIST, $DESCR_HIST){
			$this->COD_HIST = trim(substr(limpa_texto($COD_HIST),0,60));
			$this->DESCR_HIST = trim(substr(limpa_texto($DESCR_HIST),0,60));
		}

		function LerRegistro(){
			return '|I075|'.
					$this->COD_HIST.'|'.
					$this->DESCR_HIST.'|'.
					fim_linha();
		}

	}
	class SF_Reg_I100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_ALT;
		var $COD_CCUS;
		var $CCUS;

		function CriaRegistro($DT_ALT, $COD_CCUS, $CCUS){
			$this->DT_ALT = str_replace('/','',$DT_ALT);
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->CCUS = trim(substr(limpa_texto($CCUS),0,60));
		}

		function LerRegistro(){
			return '|I100|'.
					$this->DT_ALT.'|'.
					$this->COD_CCUS.'|'.
					$this->CCUS.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I150 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($DT_INI, $DT_FIN){
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
		}

		function LerRegistro(){
			return '|I150|'.
			$this->DT_INI.'|'.
			$this->DT_FIN.'|'.
			fim_linha();
		}
	}

	class SF_Reg_I151 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $ASSIM_DIG;
		function CriaRegistro($ASSIM_DIG){
			$this->ASSIM_DIG = $ASSIM_DIG;
		}
		function LerRegistro(){
			return '|I151|'.
					$this->ASSIM_DIG.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I155 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CTA;
		var $COD_CCUS;
		var $VL_SLD_INI=0;
		var $IND_DC_INI='C';
		var $VL_DEB=0;
		var $VL_CRED=0;
		var $VL_SLD_FIN=0;
		var $IND_DC_FIN='C';

		function CriaRegistro($COD_CTA, $COD_CCUS, $VL_SLD_INI){
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->VL_SLD_INI = $VL_SLD_INI;
			$this->IND_DC_INI = 'C';
			if ($this->VL_SLD_INI<=0.01){
				$this->IND_DC_INI = 'D';
			}
			$this->VL_SLD_FIN = ( $this->IND_DC_INI +
			$this->VL_CRED ) - $this->VL_DEB;

			$this->IND_DC_FIN = 'C';
			if ($this->VL_SLD_FIN<=0.01){
				$this->IND_DC_FIN = 'D';
			}
		}

		function SomaRegistro($VL_CRED, $VL_DEB ,$VL_SLD_INI=0){

			$this->VL_DEB+= $VL_DEB;
			$this->VL_CRED+= $VL_CRED;
			$this->VL_SLD_INI+= $VL_SLD_INI;

			$this->IND_DC_INI = 'C';
			if ($this->VL_SLD_INI<=0.01){
				$this->IND_DC_INI = 'D';
			}
			$this->VL_SLD_FIN = ( $this->IND_DC_INI +
			$this->VL_CRED ) - $this->VL_DEB;

			$this->IND_DC_FIN = 'C';
			if ($this->VL_SLD_FIN<=0.01){
				$this->IND_DC_FIN = 'D';
			}
		}

		function LerRegistro(){
			return '|I155|'.
					$this->COD_CTA.'|'.
					$this->COD_CCUS.'|'.
					formata_qtd_sped($this->VL_SLD_INI,2,false).'|'.
					$this->IND_DC_INI.'|'.
					formata_qtd_sped($this->VL_DEB,2,false).'|'.
					formata_qtd_sped($this->VL_CRED,2,false).'|'.
					formata_qtd_sped($this->VL_SLD_FIN,2,false).'|'.
					$this->IND_DC_FIN.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_LCTO;
		var $DT_LCTO;
		var $VL_LCTO;
		var $IND_LCTO;

		function CriaRegistro($NUM_LCTO, $DT_LCTO, $VL_LCTO, $IND_LCTO='N'){
			$this->NUM_LCTO = $NUM_LCTO;
			$this->DT_LCTO = str_replace('/','',$DT_LCTO);
			$this->VL_LCTO = $VL_LCTO;
			$this->IND_LCTO = $IND_LCTO;
		}

		function LerRegistro(){
			return '|I200|'.
					$this->NUM_LCTO.'|'.
					$this->DT_LCTO.'|'.
					formata_qtd_sped($this->VL_LCTO,2,false).'|'.
					$this->IND_LCTO.'|'.
					fim_linha();
		}

	}

	class SF_Reg_I250 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CTA;
		var $COD_CCUS;
		var $VL_DC;
		var $IND_DC;
		var $NUM_ARQ;
		var $COD_HIST_PAD;
		var $HIST;
		var $COD_PART;

		function CriaRegistro($COD_CTA, $COD_CCUS, $VL_DC,
			$IND_DC,  $NUM_ARQ,  $COD_HIST_PAD,
			$HIST, $COD_PART=''){
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->VL_DC = $VL_DC;
			$this->IND_DC = $IND_DC;
			$this->NUM_ARQ = $NUM_ARQ;
			$this->COD_HIST_PAD = trim(substr(limpa_texto($COD_HIST_PAD),0,60));
			$this->HIST = trim(substr(limpa_texto($HIST),0,65535));
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
		}

		function LerRegistro(){
			return '|I250|'.
					$this->COD_CTA.'|'.
					$this->COD_CCUS.'|'.
					formata_qtd_sped($this->VL_DC,2,false).'|'.
					$this->IND_DC.'|'.
					$this->NUM_ARQ.'|'.
					$this->COD_HIST_PAD.'|'.
					$this->HIST.'|'.
					$this->COD_PART.'|'.
					fim_linha();
			}
		}

	class SF_Reg_I300 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_BCTE;

		function CriaRegistro($DT_BCTE){
			$this->DT_BCTE = str_replace('/','',$DT_BCTE);
		}

		function LerRegistro(){
			return '|I300|'.
					$this->DT_BCTE.'|'.
					fim_linha();
		}

	}
			
	class SF_Reg_I310 extends SPED_Registro_Base{
			//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CTA;
		var $COD_CCUS;
		var $VAL_DEBD=0;
		var $VAL_CRED=0;

		function CriaRegistro($COD_CTA, $COD_CCUS){
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
		}

		function SomaRegistro($VAL_DEBD, $VAL_CRED){
			$this->VAL_DEBD+= $VAL_DEBD;
			$this->VAL_CRED+= $VAL_CRED;
		}

		function LerRegistro(){
			return '|I310|'.
					$this->COD_CTA.'|'.
					$this->COD_CCUS.'|'.
					formata_qtd_sped($this->VAL_DEBD,2,false).'|'.
					formata_qtd_sped($this->VAL_CRED,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_I350 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_RES;

		function CriaRegistro($DT_RES){
			$this->DT_RES = str_replace('/','',$DT_RES);
		}

		function LerRegistro(){
			return '|I350|'.
					$this->DT_RES.'|'.
					fim_linha();
		}		
	}

	class SF_Reg_I355 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CTA;
		var $COD_CCUS;
		var $VL_CTA=0;
		var $IND_DC='C';

		function CriaRegistro($COD_CTA, $COD_CCUS, $VL_CTA){
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));

			$this->VL_CTA+= $VL_CTA;
			$this->IND_DC='C';
			if ($this->VL_CTA<=0.01){
				$this->IND_DC='D';
			}
		}

		function SomaRegistro($VL_CTA){
			$this->VL_CTA+= $VL_CTA;
		}

		function LerRegistro(){
			return '|I355|'.
					$this->COD_CTA.'|'.
					$this->COD_CCUS.'|'.
					formata_qtd_sped($this->VL_CTA,2,false).'|'.
					$this->IND_DC.'|'.
					fim_linha();
		}

	}

	class SF_Reg_I500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $TAM_FONTE;

		function CriaRegistro($TAM_FONTE){
			$this->TAM_FONTE = $TAM_FONTE;
		}

		function LerRegistro(){
			return '|I500|'.
					$this->TAM_FONTE.'|'.
					fim_linha();
		}
	}

	class SF_Reg_I510 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NM_CAMPO;
		var $DESC_CAMPO;
		var $TIPO_CAMPO;
		var $TAM_CAMPO;
		var $DEC_CAMPO;
		var $COL_CAMPO;

		function CriaRegistro($NM_CAMPO, $DESC_CAMPO, $TIPO_CAMPO,
							$TAM_CAMPO, $DEC_CAMPO, $COL_CAMPO){
			$this->NM_CAMPO = trim(substr(limpa_texto($NM_CAMPO),0,16));
			$this->DESC_CAMPO = trim(substr(limpa_texto($DESC_CAMPO),0,50));
			$this->TIPO_CAMPO = $TIPO_CAMPO;
			$this->TAM_CAMPO = $TAM_CAMPO;
			$this->DEC_CAMPO = $DEC_CAMPO;
			$this->COL_CAMPO = $COL_CAMPO;
		}

		function LerRegistro(){
			return '|I510|'.
					$this->NM_CAMPO.'|'.
					$this->DESC_CAMPO.'|'.
					$this->TIPO_CAMPO.'|'.
					$this->TAM_CAMPO.'|'.
					$this->DEC_CAMPO.'|'.
					$this->COL_CAMPO.'|'.
					fim_linha();
		}
	}
			
	class SF_Reg_I550 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $RZ_CONT;

		function CriaRegistro($RZ_CONT){
			$this->RZ_CONT = $RZ_CONT;
		}

		function LerRegistro(){
			return '|I550|'.
					$this->RZ_CONT.'|'.
					fim_linha();
		}

	}

	class SF_Reg_I555 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $RZ_CONT_TOT;

		function CriaRegistro($RZ_CONT_TOT){
			$this->RZ_CONT_TOT = $RZ_CONT_TOT;
		}

		function LerRegistro(){
			return '|I555|'.
				$this->RZ_CONT_TOT.'|'.
				fim_linha();
		}
	}

	class SF_Reg_J005 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_INI;
		var $DT_FIN;
		var $ID_DEM;
		var $CAB_DEM;

		function CriaRegistro($DT_INI,$DT_FIN,$ID_DEM,$CAB_DEM){
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
			$this->ID_DEM = $ID_DEM;
			$this->CAB_DEM = trim(substr(limpa_texto($CAB_DEM),0,65535));
			}

		function LerRegistro(){
			return '|J005|'.
					$this->DT_INI.'|'.
					$this->DT_FIN.'|'.
					$this->ID_DEM.'|'.
					$this->CAB_DEM.'|'.
					fim_linha();
		}
	}


	class SF_Reg_J100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_AGL;
		var $NIVEL_AGL;
		var $IND_GRP_BAL;
		var $DESCR_COD_AGL;
		var $VL_CTA=0;
		var $IND_DC_BAL='C';

		function CriaRegistro($COD_AGL, $NIVEL_AGL, $IND_GRP_BAL,
							$DESCR_COD_AGL, $VL_CTA=0){
			$this->COD_AGL = trim(substr(limpa_texto($COD_AGL),0,60));
			$this->NIVEL_AGL = trim(substr(limpa_texto($NIVEL_AGL),0,60));

			$this->IND_GRP_BAL= $IND_GRP_BAL;
			$this->DESCR_COD_AGL = trim(substr(limpa_texto($DESCR_COD_AGL),0,60));
			$this->VL_CTA+= $VL_CTA;

			$this->IND_DC_BAL='C';
			if ($this->VL_CTA<=0.01){
				$this->IND_DC_BAL='D';
			}
		}

		function SomaRegistro($VL_CTA){
			$this->VL_CTA+= $VL_CTA;
			$this->IND_DC_BAL='C';
			if ($this->VL_CTA<=0.01){
				$this->IND_DC_BAL='D';
			}
		}

		function LerRegistro(){
			return '|J100|'.
					$this->COD_AGL.'|'.
					$this->NIVEL_AGL.'|'.
					$this->IND_GRP_BAL.'|'.
					$this->DESCR_COD_AGL.'|'.
					formata_qtd_sped($this->VL_CTA,2,false).'|'.
					$this->IND_DC_BAL.'|'.
					fim_linha();
		}

	}

	class SF_Reg_J150 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_AGL;
		var $NIVEL_AGL;
		var $DESCR_COD_AGL;
		var $VL_CTA;
		var $IND_VL;

		function CriaRegistro($COD_AGL, $NIVEL_AGL, $DESCR_COD_AGL,
							$IND_VL, $VL_CTA=0){
			$this->COD_AGL = trim(substr(limpa_texto($COD_AGL),0,60));
			$this->NIVEL_AGL = trim(substr(limpa_texto($NIVEL_AGL),0,60));

			$this->DESCR_COD_AGL = trim(substr(limpa_texto($DESCR_COD_AGL),0,60));
			$this->IND_VL = trim(substr(limpa_texto($IND_VL),0,1));
			$this->VL_CTA = $VL_CTA;
		}

		function LerRegistro(){
			return '|J150|'.
			$this->COD_AGL.'|'.
			$this->NIVEL_AGL.'|'.
			$this->DESCR_COD_AGL.'|'.
			formata_qtd_sped($this->VL_CTA,2,false).'|'.
			$this->IND_VL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_J800 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $ARQ_RTF;
		var $IND_FIM_RTF='J800FIM';

		function CriaRegistro($ARQ_RTF){
			$this->ARQ_RTF = $ARQ_RTF;
		}

		function LerRegistro(){
			return '|J800|'.
					$this->ARQ_RTF.'|'.
					$this->IND_FIM_RTF.'|'.
					fim_linha();
		}
	}

	class SF_Reg_J900 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DNRC_ENCER='TERMO DE ENCERRAMENTO';
		var $NUM_ORD;
		var $NAT_LIVRO;
		var $NOME;
		var $QTD_LIN;
		var $DT_INI_ESCR;
		var $DT_FIN_ESCR;

		function CriaRegistro($NUM_ORD,$NAT_LIVRO,$NOME,$QTD_LIN,
							$DT_INI_ESCR,$DT_FIN_ESCR){
			$this->NUM_ORD = $NUM_ORD;
			$this->NAT_LIVRO = trim(substr(limpa_texto($NAT_LIVRO),0,60));
			$this->NOME = trim(substr(limpa_texto($NOME),0,60));
			$this->QTD_LIN = $QTD_LIN;
			$this->DT_INI_ESCR = str_replace('/','',$DT_INI_ESCR);
			$this->DT_FIN_ESCR = str_replace('/','',$DT_FIN_ESCR);
		}

		function LerRegistro(){
			return '|J900|'.
					$this->DNRC_ENCER.'|'.
					$this->NUM_ORD.'|'.
					$this->NAT_LIVRO.'|'.
					$this->NOME.'|'.
					$this->QTD_LIN.'|'.
					$this->DT_INI_ESCR.'|'.
					$this->DT_FIN_ESCR.'|'.
					fim_linha();
		}
	}

	class SF_Reg_J930 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IDENT_NOM;
		var $IDENT_CPF;
		var $IDENT_QUALIF;
		var $COD_ASSIM;
		var $IND_CRC;

		function CriaRegistro($IDENT_NOM,$IDENT_CPF,$IDENT_QUALIF,
							$COD_ASSIM,$IND_CRC){
			$this->IDENT_NOM = trim(substr(limpa_texto($IDENT_NOM),0,60));
			$this->IDENT_CPF = trim(substr(limpa_numero($IDENT_CPF),0,11));
			$this->IDENT_QUALIF = $IDENT_QUALIF;
			$this->COD_ASSIM = $COD_ASSIM;
			$this->IND_CRC = $IND_CRC;
		}

		function LerRegistro(){
			return '|J930|'.
					$this->IDENT_NOM.'|'.
					$this->IDENT_CPF.'|'.
					$this->IDENT_QUALIF.'|'.
					$this->COD_ASSIM.'|'.
					$this->IND_CRC.'|'.
					fim_linha();
		}
	}

	class SF_Reg_9900 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $REG_BLC;
		var $QTD_REG_BLC=0;

		function CriaRegistro($REG_BLC, $QTD_REG_BLC){
			//echo 'conta'.$REG_BLC.'vanterior'.$this->QTD_REG_BLC.'-';
			$this->REG_BLC  = trim(substr(limpa_texto($REG_BLC),0,4));
			$this->QTD_REG_BLC+= $QTD_REG_BLC;
			//echo 'conta'.$REG_BLC.'vantual'.$this->QTD_REG_BLC.'-';
		}
		function LerRegistro(){
			return '|9900|'.
					$this->REG_BLC.'|'.
					$this->QTD_REG_BLC.'|'.
					fim_linha();
		}
	}

?>