<?
	class SF_Reg_0000 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_VER;
		var $COD_FIN;
		var $DT_INI;
		var $DT_FIN;
		var $NOME;
		var $CNPJ;
		var $CPF;

		var $UF;
		var $IE;
		var $COD_MUN;
		var $IM;
		var $SUFRAMA;
		var $IND_PERFIL;
		var $IND_ATIV;

		function CriaRegistro($COD_VER, $COD_FIN, $DT_INI, $DT_FIN,
							$NOME, $CNPJ, $UF, $IE, $COD_MUN,
							$IM, $SUFRAMA, $IND_PERFIL='A', $IND_ATIV='1'){
			$this->COD_VER = fill_full(substr($COD_VER,0,3),3);
			$this->COD_FIN = fill_full(substr($COD_FIN,0,1),1);
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			//echo '-'.$NOME.'-';

			$this->CNPJ = substr(limpa_numero($CNPJ),0,14);
			if (strlen($this->CNPJ)==11){
				$this->CPF = $this->CNPJ;
				$this->CNPJ = '';
			}else{
				$this->CPF = '';
			}
			$this->UF = substr($UF,0,2);
			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if (($IE=='ISENTO')||($IE=='Isento')){
				$this->IE = '';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->IM = limpa_numero2($IM);
			$this->SUFRAMA = limpa_numero($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}

			$this->IND_PERFIL = $IND_PERFIL;
			$this->IND_ATIV = $IND_ATIV;
		}

		function LerRegistro(){
			return '|0000|'.
					$this->COD_VER.'|'.
					$this->COD_FIN.'|'.
					$this->DT_INI.'|'.
					$this->DT_FIN.'|'.
					$this->NOME.'|'.
					$this->CNPJ.'|'.
					$this->CPF.'|'.
					$this->UF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->IM.'|'.
					$this->SUFRAMA.'|'.
					$this->IND_PERFIL.'|'.
					$this->IND_ATIV.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0002 extends SPED_Registro_Base{
		//REGISTRO 0002: CLASSIFICAÇÃO DO ESTABELECIMENTO INDUSTRIAL OU EQUIPARADO A INDUSTRIAL
		var $CLAS_ESTAB_IND;
		
		function CriaRegistro($CLAS_ESTAB_IND){
			$this->CLAS_ESTAB_IND = fill_full($CLAS_ESTAB_IND,2);
		}
		
		function LerRegistro(){
			return '|0002|'.
					$this->CLAS_ESTAB_IND.'|'.
					fim_linha();
		}

	}
			
	class SF_Reg_0005 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $FANTASIA;
		var $CEP;
		var $END;
		var $NUM;
		var $COMPL;
		var $BAIRRO;
		var $FONE;
		var $FAX;
		var $EMAIL;

		function CriaRegistro($FANTASIA, $CEP, $END, $NUM,
							$COMPL, $BAIRRO, $FONE, $FAX, $EMAIL){

			$this->FANTASIA = trim(substr(limpa_texto($FANTASIA),0,60));
			$this->CEP = fill_full(substr(limpa_numero($CEP),0,8),8);
			$this->END = trim(substr(limpa_texto($END),0,60));
			$this->NUM = trim(substr(limpa_texto($NUM),0,10));
			if ($this->NUM==''){
				$this->NUM = 'S/N';
			}
			$this->COMPL = trim(substr(limpa_texto($COMPL),0,60));
			$this->BAIRRO = trim(substr(limpa_texto($BAIRRO),0,60));
			if ($this->BAIRRO==''){
				$this->BAIRRO = 'CENTRO';
			}
			$this->FONE = trim(substr(limpa_numero($FONE),0,10));
			$this->FAX = trim(substr(limpa_numero($FAX),0,10));
			$this->EMAIL = substr(limpa_texto($EMAIL),0,60);
		}

		function LerRegistro(){
			return '|0005|'.
					$this->FANTASIA.'|'.
					$this->CEP.'|'.
					$this->END.'|'.
					$this->NUM.'|'.
					$this->COMPL.'|'.
					$this->BAIRRO.'|'.
					$this->FONE.'|'.
					$this->FAX.'|'.
					$this->EMAIL.'|'.
					fim_linha();
		}

	}


	class SF_Reg_0015 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $UF_ST;
		var $IE_ST;

		function CriaRegistro($UF_ST, $IE_ST){
			$this->UF_ST = substr($UF_ST,0,2);
			$this->IE_ST = trim(substr(limpa_numero2($IE_ST),0,14));
			if (($IE_ST=='ISENTO')||($IE_ST=='Isento')){
				$this->IE_ST = '';
			}
		}

		function LerRegistro(){
			return '|0015|'.
					$this->UF_ST.'|'.
					$this->IE_ST.'|'.
					fim_linha();
		}

	}

	class SF_Reg_0100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NOME;
		var $CPF;
		var $CRC;
		var $CNPJ;
		var $CEP;
		var $END;
		var $NUM;
		var $COMPL;
		var $BAIRRO;
		var $FONE;
		var $FAX;
		var $EMAIL;
		var $COD_MUN;

		function CriaRegistro($NOME, $CPF, $CRC, $CNPJ,
							$CEP, $END, $NUM,
							$COMPL, $BAIRRO, $FONE, $FAX,
							$EMAIL, $COD_MUN){

			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			$this->CPF = trim(substr(limpa_numero($CPF),0,11));
			$this->CRC = trim(substr(limpa_numero($CRC),0,15));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			$this->CEP = fill_full(substr(limpa_numero($CEP),0,8),8);
			$this->END = trim(substr(limpa_texto($END),0,60));
			$this->NUM = trim(substr(limpa_texto($NUM),0,10));
			if ($this->NUM==''){
				$this->NUM = 'S/N';
			}
			$this->COMPL = trim(substr(limpa_texto($COMPL),0,60));
			$this->BAIRRO = trim(substr(limpa_texto($BAIRRO),0,60));
			if ($this->BAIRRO==''){
				$this->BAIRRO = 'CENTRO';
			}
			$this->FONE = trim(substr(limpa_numero($FONE),0,10));
			$this->FAX = trim(substr(limpa_numero($FAX),0,10));
			$this->EMAIL = limpa_texto($EMAIL);
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
		}

		function LerRegistro(){
			return '|0100|'.
					$this->NOME.'|'.
					$this->CPF.'|'.
					$this->CRC.'|'.
					$this->CNPJ.'|'.
					$this->CEP.'|'.
					$this->END.'|'.
					$this->NUM.'|'.
					$this->COMPL.'|'.
					$this->BAIRRO.'|'.
					$this->FONE.'|'.
					$this->FAX.'|'.
					$this->EMAIL.'|'.
					$this->COD_MUN.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0150 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $NOME;
		var $COD_PAIS;
		var $CNPJ;
		var $CPF;
		var $IE;
		var $COD_MUN;
		var $SUFRAMA;
		var $END;
		var $NUM;
		var $COMPL;
		var $BAIRRO;
		var $UF;

		function CriaRegistro($COD_PART, $NOME, $COD_PAIS, $CNPJ,
							$IE, $COD_MUN, $SUFRAMA,
							$END, $NUM, $COMPL, $BAIRRO){

			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			$this->COD_PAIS = trim(substr(limpa_numero($COD_PAIS),0,5));
			if ($this->COD_PAIS==''){
				$this->COD_PAIS='1058';//brasil
			}
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			if (strlen($this->CNPJ)==11){
				$this->CPF = $this->CNPJ;
				$this->CNPJ = '';
			}else{
				$this->CPF = '';
			}
			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if (($IE=='ISENTO')||($IE=='Isento')){
				$this->IE = '';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->SUFRAMA = limpa_numero2($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}

			$this->END = trim(substr(limpa_texto($END),0,60));
			$this->NUM = trim(substr(limpa_texto($NUM),0,10));
			if ($this->NUM==''){
				$this->NUM = 'S/N';
			}
			$this->COMPL = trim(substr(limpa_texto($COMPL),0,60));
			$this->BAIRRO = trim(substr(limpa_texto($BAIRRO),0,60));
			if ($this->BAIRRO==''){
				$this->BAIRRO = 'CENTRO';
			}

			if ($this->COD_PAIS!='1058'){
				$this->COD_MUN = '9999999';
				$this->CPF = '';
				$this->CNPJ = '';
				$this->IE = '';
			}

		}

		function CriaRegistroBase($COD_PART,$silencioso,
		                          $CPF_CNPJ,$NOME,$IE,$SUFRAMA,
								  $END_LOG,$END_NR, $END_COMP){
			//echo '-part_'.$COD_PART.'-';
			$codigo = explode('_',$COD_PART);
			if (isset($codigo[1])){
				$COD_PESSOA = $codigo[1];
			}else{
				$COD_PESSOA = 1;
			}
			if (isset($codigo[2])){
				$COD_ENDER = $codigo[2];
			}else{
				$COD_ENDER = 0;
			}

			//consulta cadastro de pessoa
			$con_pessoa = 'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$COD_PESSOA.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			$nrw_pessoa = consulta_num_registros($res_pessoa);
			consulta_limpa($res_pessoa);

			if ($nrw_pessoa==0){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Pessoa ('.$COD_PART.') no cadastrada ! ',$silencioso);
			}else{
				if (trim($reg_pessoa->Nome_Razao)==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Nome/Razo da Pessoa ('.$COD_PART.') no cadastrada! ',$silencioso);
				}
			}

			//consulta endereco da nota ou princpal
			//se for zero (é o primeiro endereco disponivel)
			$con_ender = 'select * from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"';
			if ($COD_ENDER>0){
				$con_ender.= ' and Seq_Endereco="'.$COD_ENDER.'"';
			}else{
				$con_ender.= ' and Situacao<>"E" order by Seq_Endereco limit 1';
			}
			$res_ender = consulta_sql($con_ender);
			$reg_ender = consulta_ler_objeto($res_ender);
			consulta_limpa($res_ender);

			if (($reg_pessoa->CPF_CNPJ!='000.000.000-00')&&
				($reg_pessoa->CPF_CNPJ!='00.000.000/0000-00')){
				$CPF_CNPJ = $reg_pessoa->CPF_CNPJ;
				$NOME     = $reg_pessoa->Nome_Razao;
				$IE       = $reg_ender->Insc_Estadual;
				$SUFRAMA  = $reg_ender->Insc_SUFRAMA;
				$END_LOG  = $reg_ender->Logradouro;
				$END_NR   = $reg_ender->Numero;
				$END_COMP = $reg_ender->Complemento;
			}

			if ($reg_ender->UF=='EX'){
				$END_LOG.= ' '.$reg_ender->Nome_Cidade;
			}else{
				
				if (!(valida_cpf_cnpj($CPF_CNPJ))){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! CPF/CNPJ ('.$CPF_CNPJ.') da Pessoa ('.$COD_PART.') inválido!',$silencioso);
				}
				if ((limpa_numero2($IE)!='')&&($IE!='ISENTO')&&($IE!='Isento')){
					if (!(ChkInscEstadual(limpa_numero2($IE), $reg_ender->UF))){
						sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Inscrio Estadual ('.$IE.') da Pessoa ('.$COD_PART.') Inválida para '.$reg_ender->UF.'!',$silencioso);
					}
				}
				if ($reg_ender->Codigo_Cidade==0){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Cidade da Pessoa ('.$COD_PART.') no cadastrada!',$silencioso);
				}
				if ($END_LOG==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Logradouro da Pessoa ('.$COD_PART.') no cadastrado!',$silencioso);
				}
			}
			$this->UF = $reg_ender->UF;

			$this->CriaRegistro($COD_PART, $NOME,
								$reg_ender->Codigo_Pais, $CPF_CNPJ, $IE,
								$reg_ender->Codigo_Cidade, $SUFRAMA,
								$END_LOG, $END_NR,
								$END_COMP, $reg_ender->Bairro);
			return $this->UF;
		}

		function LerRegistro(){
			return '|0150|'.
					$this->COD_PART.'|'.
					$this->NOME.'|'.
					$this->COD_PAIS.'|'.
					$this->CNPJ.'|'.
					$this->CPF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->SUFRAMA.'|'.
					$this->END.'|'.
					$this->NUM.'|'.
					$this->COMPL.'|'.
					$this->BAIRRO.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0175 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_ALT;
		var $NR_CAMPO;
		var $CONT_ANT;

		function CriaRegistro($DT_ALT, $NR_CAMPO, $CONT_ANT){
			$this->DT_ALT = str_replace('/','',$DT_ALT);
			$this->NR_CAMPO = $NR_CAMPO;
			$this->CONT_ANT = trim(substr(limpa_texto($CONT_ANT),0,100));
		}

		function LerRegistro(){
			return '|0175|'.
					$this->DT_ALT.'|'.
					$this->NR_CAMPO.'|'.
					$this->CONT_ANT.'|'.
					fim_linha();
		}

	}

	class SF_Reg_0190 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $UNID;
		var $DESCR;

		function CriaRegistro($UNID, $DESCR){
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->DESCR = trim(limpa_texto($DESCR));
			if ($this->DESCR==''){
				$this->DESCR = 'QTD EM '.$this->UNID;
				//sped_exibe_erro( '0190', 'Falha na gerao do arquivo SPED! Unidade de Medida ('.$this->UNID.') no possue descrio, usando descrio genérica!');
			}
		}

		function LerRegistro(){
			return '|0190|'.
					$this->UNID.'|'.
					$this->DESCR.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $DESCR_ITEM;
		var $COD_BARRA;
		var $COD_ANT_ITEM;
		var $UNID_INV;
		var $TIPO_ITEM;
		var $COD_NCM;
		var $EX_IPI;
		var $COD_GEN;
		var $COD_LST;
		var $ALIQ_ICMS;
		var $CEST;
		var $MES_REF;
		var $maior_fator=0;

		function CriaRegistro($COD_ITEM, $DESCR_ITEM, $COD_BARRA,
							$COD_ANT_ITEM, $UNID_INV, $TIPO_ITEM,
							$COD_NCM, $EX_IPI, $COD_LST, $ALIQ_ICMS,
							$CEST, $MES_REF,
							$silencioso,$blocoK,
							&$reg0, $impostos, $id_item,$reg221=false){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->DESCR_ITEM = trim(limpa_texto($DESCR_ITEM));
			$this->COD_BARRA = trim(substr(limpa_texto($COD_BARRA),0,14));
			$this->COD_ANT_ITEM = trim(substr(limpa_texto($COD_ANT_ITEM),0,60));
			$this->UNID_INV = trim(substr(limpa_texto($UNID_INV),0,6));
			$this->TIPO_ITEM = fill_full(trim(substr(limpa_numero($TIPO_ITEM),0,2)),2);
			$this->COD_NCM = trim(substr(limpa_numero($COD_NCM),0,8));
			if (strlen($this->COD_NCM)==8){
				$this->EX_IPI = trim(substr(limpa_numero($EX_IPI),0,3));
			}else{
				$this->EX_IPI = '';
				$this->COD_NCM = '';
			}
			$this->COD_GEN = fill_full(trim(substr(limpa_numero($COD_NCM),0,2)),2);
			$this->COD_LST = trim(substr(limpa_numero($COD_LST),0,4));
			if($this->COD_LST!=''){
				$this->COD_LST = fill_full($this->COD_LST,4);
				$this->COD_LST = substr($this->COD_LST,0,2).'.'.substr($this->COD_LST,2,2);
			}
			$this->ALIQ_ICMS = $ALIQ_ICMS; //formata_qtd(
			$this->CEST = trim(substr(limpa_numero($CEST),0,7));
			$this->MES_REF = $MES_REF;

			if ($COD_ITEM==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! Cdigo do Item no Informado!',$silencioso);
			}
			if ($DESCR_ITEM==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! Descrio do Item ('.$COD_ITEM.') no Informada!',$silencioso);
			}
			if ($UNID_INV==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! Unidade de Medida do Item ('.$COD_ITEM.') no Informada!',$silencioso);
			}
			$ok_comp =	(
							($blocoK=='S')&&
							(
							 ($this->TIPO_ITEM=='3')||
							 ($this->TIPO_ITEM=='4')
							)&&
							(
							 data2nr($MES_REF)<data2nr('01/01/2023')
							)
						)||(
							($this->TIPO_ITEM=='0')&&
							(
							 data2nr($MES_REF)>=data2nr('01/01/2023')
							)
						);
			$tem_comp_listado = false;
			if ($ok_comp){
				$con_com = 'select * from produto_composicao '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Id_Produto_Final="'.$id_item.'" '.
							' and Situacao = "A" ';
				$res_com = consulta_sql($con_com);
				$nrw_com = consulta_num_registros($res_com);
				for($c=0;$c<$nrw_com;$c++){
					$reg_com = consulta_ler_objeto($res_com);
					$con_pro = 'select * from produto '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto="'.$reg_com->Id_Produto_Origem.'"';
					$res_pro = consulta_sql($con_pro);
					$reg_pro = consulta_ler_objeto($res_pro);
					consulta_limpa($res_pro);
					if (data2nr($MES_REF)>=data2nr('01/01/2023')){
						$regC = &$this->Adiciona_Registro('0221',$reg_pro->Codigo_Produto);
						$regC->CriaRegistro($reg_pro->Codigo_Produto, $reg_com->Quantidade);
						$tem_comp_listado=true;
					}else{//bloco K
						$regC = &$this->Adiciona_Registro('0210',$reg_pro->Codigo_Produto);
						$regC->CriaRegistro($reg_pro->Codigo_Produto, $reg_com->Quantidade, 0);
					}
					//consulta 1 cod barras
					$COD_BARRA = '';
					$con_bar = 'select * from produto_cod_barras '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Id_Produto="'.$reg_com->Id_Produto_Origem.'" '.
								' and Situacao = "A" '.
								' and LENGTH(Codigo_Barras)>=13 limit 1';
					$res_bar = consulta_sql($con_bar);
					$reg_bar = consulta_ler_objeto($res_bar);
					consulta_limpa($res_bar);
					//pega a liuota principal do produto
					$ALIQ_ICMS = 0;
					if (isset($impostos['icms'][$reg_pro->Codigo_Classe_Tributo])){
						$ALIQ_ICMS = $impostos['icms'][$reg_pro->Codigo_Classe_Tributo];
					}
					$NCM = $reg_pro->NCM;
					if ($reg_pro->Codigo_Depart==0){
						$NCM = '00';
					}
					$reg2 = &$reg0->Adiciona_Registro('0200',$reg_pro->Codigo_Produto);
					$reg2->CriaRegistro($reg_pro->Codigo_Produto,
										$reg_pro->Descricao_Completa,
										$reg_bar->Codigo_Barras,
										'', $reg_pro->Unidade_Venda,
										$reg_pro->Tipo,
										$NCM, $reg_pro->NCM_EX,
										$reg_pro->Servico_Codigo,
										$ALIQ_ICMS, $reg_pro->Codigo_CEST,
										$MES_REF,
										$silencioso,
										$blocoK,
										$reg0,
										$impostos,
										$reg_com->Id_Produto_Origem,
										true);
					if ($reg_pro->Codigo_Produto==''){
						sped_exibe_erro( '0200/0210', 'Falha na gerao do arquivo SPED! Produto ('.$reg_pro->Id_Produto.') no cadastrado!',$silencioso);
					}
					$con_uni = 'select * from unidade_medida '.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Unidade="'.$reg_pro->Unidade_Venda.'"';
					$res_uni = consulta_sql($con_uni);
					$reg_uni = consulta_ler_objeto($res_uni);
					consulta_limpa($res_uni);
					$reg3 = &$reg0->Adiciona_Registro('0190',$reg_pro->Unidade_Venda);
					$reg3->CriaRegistro($reg_pro->Unidade_Venda, $reg_uni->Descricao);
				}
				consulta_limpa($res_com);

			}
			if (data2nr($MES_REF)>=data2nr('01/01/2023')){
				if (($reg221)&&(!$tem_comp_listado)){
					$regC = &$this->Adiciona_Registro('0221',$this->COD_ITEM);
					$regC->CriaRegistro($this->COD_ITEM, 1);
				}
			}
		}

		function LerRegistro(){
			$cCEST = '';
			if (data2nr($this->MES_REF)>=data2nr('01/01/2017')){
				$cCEST = $this->CEST.'|';
			}
			return '|0200|'.
					$this->COD_ITEM.'|'.
					$this->DESCR_ITEM.'|'.
					$this->COD_BARRA.'|'.
					$this->COD_ANT_ITEM.'|'.
					$this->UNID_INV.'|'.
					$this->TIPO_ITEM.'|'.
					$this->COD_NCM.'|'.
					$this->EX_IPI.'|'.
					$this->COD_GEN.'|'.
					$this->COD_LST.'|'.
					formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
					$cCEST.
					fim_linha();
		}
	}

	class SF_Reg_0205 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DESCR_ANT_ITEM;
		var $DT_INI;
		var $DT_FIM;
		var $COD_ANT_ITEM;

		function CriaRegistro($DESCR_ANT_ITEM, $DT_INI, $DT_FIM, $COD_ANT_ITEM){
			$this->DESCR_ANT_ITEM = trim(limpa_texto($DESCR_ANT_ITEM));
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIM = str_replace('/','',$DT_FIM);
			$this->COD_ANT_ITEM = trim(substr(limpa_texto($COD_ANT_ITEM),0,60));
		}

		function LerRegistro(){
			return '|0205|'.
			$this->DESCR_ANT_ITEM.'|'.
			$this->DT_INI.'|'.
			$this->DT_FIM.'|'.
			$this->COD_ANT_ITEM.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0206 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_COMB;

		function CriaRegistro($COD_COMB){
			$this->COD_COMB = trim(limpa_texto($COD_COMB));
		}

		function LerRegistro(){
			return '|0206|'.
			$this->COD_COMB.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0210 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM_COMP;
		var $QTD_COMP;
		var $PERDA;

		function CriaRegistro($COD_ITEM_COMP, $QTD_COMP, $PERDA){
			$this->COD_ITEM_COMP = trim(substr(limpa_texto($COD_ITEM_COMP),0,60));
			$this->QTD_COMP = $QTD_COMP;
			$this->PERDA = $PERDA;
		}

		function LerRegistro(){
			return '|0210|'.
			$this->COD_ITEM_COMP.'|'.
			formata_qtd_sped($this->QTD_COMP,6,false).'|'.
			formata_qtd_sped($this->PERDA,2,false).'|'.
			fim_linha();
		}
	}


	class SF_Reg_0220 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $UNID_CONV;
		var $FAT_CONV;
		var $COD_BARRA;

		function CriaRegistro($UNID_CONV, $FAT_CONV,$COD_BARRA){
			$this->UNID_CONV = trim(substr(limpa_texto($UNID_CONV),0,6));
			$this->FAT_CONV = $FAT_CONV;
			$this->COD_BARRA = trim(substr(limpa_texto($COD_BARRA),0,14));
			if ($COD_BARRA=='NE'){
				$this->COD_BARRA = 'NE';
			}
		}

		function LerRegistro(){
			$bar = $this->COD_BARRA;
			if ($bar == 'NE'){
				$bar = '';
			}else{
				$bar.='|'; 
			}
			return '|0220|'.
					$this->UNID_CONV.'|'.
					formata_qtd_sped($this->FAT_CONV,6,false).'|'.
					$bar.
					fim_linha();
		}
	}

	class SF_Reg_0221 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM_COMP;
		var $QTD_COMP;

		function CriaRegistro($COD_ITEM_COMP, $QTD_COMP){
			$this->COD_ITEM_COMP = trim(substr(limpa_texto($COD_ITEM_COMP),0,60));
			$this->QTD_COMP = $QTD_COMP;
		}

		function LerRegistro(){
			return '|0221|'.
			$this->COD_ITEM_COMP.'|'.
			formata_qtd_sped($this->QTD_COMP,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_0300 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_IND_BEM;
		var $IDENT_MERC;
		var $DESCR_ITEM;
		var $COD_PRNC;
		var $COD_CTA;
		var $NR_PARC;

		function CriaRegistro($COD_IND_BEM, $IDENT_MERC, $DESCR_ITEM,
			$COD_PRNC, $COD_CTA, $NR_PARC){
			$this->COD_IND_BEM = trim(substr(limpa_texto($COD_IND_BEM),0,60));
			$this->IDENT_MERC = fill_full(trim(substr(limpa_numero($IDENT_MERC),0,2)),2);
			$this->DESCR_ITEM = trim(limpa_texto($DESCR_ITEM));
			$this->COD_PRNC = trim(substr(limpa_texto($COD_PRNC),0,60));
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->NR_PARC = trim(substr(limpa_numero($NR_PARC),0,3));
			if ($this->NR_PARC==''){
				$this->NR_PARC = '1';
			}
		}

		function LerRegistro(){
			return '|0300|'.
					$this->COD_IND_BEM.'|'.
					$this->IDENT_MERC.'|'.
					$this->DESCR_ITEM.'|'.
					$this->COD_PRNC.'|'.
					$this->COD_CTA.'|'.
					$this->NR_PARC.'|'.
					fim_linha();
		}

	}

	class SF_Reg_0305 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_CCUS;
		var $FUNC;
		var $VIDA_UTIL;

		function CriaRegistro($COD_CCUS, $FUNC, $VIDA_UTIL){
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->FUNC = trim(limpa_texto($FUNC));
			$this->VIDA_UTIL = trim(substr(limpa_numero($VIDA_UTIL),0,3));
			if ($this->VIDA_UTIL==''){
				$this->VIDA_UTIL = '1';
			}
		}

		function LerRegistro(){
			return '|0305|'.
			$this->COD_CCUS.'|'.
			$this->FUNC.'|'.
			$this->VIDA_UTIL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_NAT;
		var $DESCR_NAT;

		function CriaRegistro($COD_NAT, $DESCR_NAT){
			$this->COD_NAT = trim(substr(limpa_texto($COD_NAT),0,10));
			$this->DESCR_NAT = trim(limpa_texto($DESCR_NAT));
		}

		function LerRegistro(){
			return '|0400|'.
			$this->COD_NAT.'|'.
			$this->DESCR_NAT.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0450 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_INF;
		var $TXT;

		function CriaRegistro($COD_INF, $TXT){
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->TXT = trim(limpa_texto($TXT));
		}

		function LerRegistro(){
			return '|0450|'.
			$this->COD_INF.'|'.
			$this->TXT.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0460 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_OBS;
		var $TXT;

		function CriaRegistro($COD_OBS, $TXT){
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
			$this->TXT = trim(limpa_texto($TXT));
		}

		function LerRegistro(){
			return '|0460|'.
			$this->COD_OBS.'|'.
			$this->TXT.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_ALT;
		var $COD_NAT_CC;
		var $IND_CTA;
		var $NIVEL;
		var $COD_CTA;
		var $NOME_CTA;

		function CriaRegistro($DT_ALT, $COD_NAT_CC,
			$IND_CTA, $NIVEL,
			$COD_CTA, $NOME_CTA){
			$this->DT_ALT = str_replace('/','',dataf($DT_ALT));
			$this->COD_NAT_CC = fill_full(trim(substr(limpa_numero($COD_NAT_CC),0,2)),2);
			$this->IND_CTA = trim(substr(limpa_texto($IND_CTA),0,1));
			if ($this->IND_CTA==''){
				$this->IND_CTA = 'S';
			}
			$this->NIVEL = trim(substr(limpa_numero($NIVEL),0,5));
			if ($this->NIVEL==''){
				$this->NIVEL = '1';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->NOME_CTA = trim(substr(limpa_texto($NOME_CTA),0,60));
		}

		function LerRegistro(){
			return '|0500|'.
			$this->DT_ALT.'|'.
			$this->COD_NAT_CC.'|'.
			$this->IND_CTA.'|'.
			$this->NIVEL.'|'.
			$this->COD_CTA.'|'.
			$this->NOME_CTA.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0600 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_ALT;
		var $COD_CCUS;
		var $CCUS;

		function CriaRegistro($DT_ALT, $COD_CCUS, $CCUS){
			$this->DT_ALT = str_replace('/','',$DT_ALT);
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->CCUS = trim(substr(limpa_texto($CCUS),0,60));
		}

		function LerRegistro(){
			return '|0600|'.
			$this->DT_ALT.'|'.
			$this->COD_CCUS.'|'.
			$this->CCUS.'|'.
			fim_linha();
		}
	}
	//registros bloco C

	class SF_Reg_C100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $NUM_DOC;
		var $CHV_NFE;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $IND_PGTO;
		var $VL_DESC;
		var $VL_ABAT_NT;
		var $VL_MERC;
		var $IND_FRT;
		var $VL_FRT;
		var $VL_SEG;
		var $VL_OUT_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_IPI;
		var $VL_PIS;
		var $VL_COFINS;
		var $VL_PIS_ST;
		var $VL_COFINS_ST;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
							$COD_MOD, $COD_SIT, $SER,
							$NUM_DOC, $CHV_NFE, $DT_DOC,
							$DT_E_S, $VL_DOC, $IND_PGTO,
							$VL_DESC, $VL_ABAT_NT, $VL_MERC,
							$IND_FRT, $VL_FRT, $VL_SEG,
							$VL_OUT_DA, $VL_BC_ICMS, $VL_ICMS,
							$VL_BC_ICMS_ST, $VL_ICMS_ST,
							$VL_IPI, $VL_PIS, $VL_COFINS,
							$VL_PIS_ST, $VL_COFINS_ST,$considera_data=false){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,3));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));
			$this->CHV_NFE = $CHV_NFE;

			if ($this->COD_MOD=='65'){
				$this->COD_PART = '';
			}

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if ($this->COD_SIT=='05'){
					$this->CHV_NFE = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('/','',$DT_DOC);
					$this->DT_E_S = str_replace('/','',$DT_E_S);
				}else{
					$this->DT_DOC = '';
					$this->DT_E_S = '';
				}
				$this->COD_PART = '';
				$this->VL_DOC = '';
				$this->IND_PGTO = '';
				$this->VL_DESC = '';
				$this->VL_ABAT_NT = '';
				$this->VL_MERC = '';
				$this->IND_FRT = '';
				$this->VL_FRT = '';
				$this->VL_SEG = '';
				$this->VL_OUT_DA = '';
				$this->VL_BC_ICMS = '';
				$this->VL_ICMS = '';
				$this->VL_BC_ICMS_ST = '';
				$this->VL_ICMS_ST = '';
				$this->VL_IPI = '';
				$this->VL_PIS = '';
				$this->VL_COFINS = '';
				$this->VL_PIS_ST = '';
				$this->VL_COFINS_ST = '';
			}else{
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->DT_E_S = str_replace('/','',$DT_E_S);
				$this->VL_DOC = $VL_DOC;
				$this->IND_PGTO = fill_full(trim(substr(limpa_numero($IND_PGTO),0,1)),1);
				$this->VL_DESC = $VL_DESC;
				$this->VL_ABAT_NT = $VL_ABAT_NT;
				$this->VL_MERC = $VL_MERC;
				$this->IND_FRT = fill_full(trim(substr(limpa_numero($IND_FRT),0,1)),1);
				//a partir de 2012 muda os números
				if (data2nr($DT_E_S)>=data2nr('01/01/2012')){
					if ($this->IND_FRT=='0'){
						$this->IND_FRT = '2';
					}else if ($this->IND_FRT=='1'){
						$this->IND_FRT = '0';
					}else if ($this->IND_FRT=='2'){
						$this->IND_FRT = '1';
					}
				}
				if (data2nr($DT_E_S)>=data2nr('01/07/2012')){
					if ($this->IND_PGTO=='9'){
						$this->IND_PGTO = '2';
					}
				}

				if ($COD_SIT=='06'){
					if($this->VL_MERC <= 0){
						$this->VL_MERC = $VL_BC_ICMS;
					}
				}

				$this->VL_FRT = $VL_FRT;
				$this->VL_SEG = $VL_SEG;
				$this->VL_OUT_DA = $VL_OUT_DA;
				$this->VL_BC_ICMS = $VL_BC_ICMS;
				$this->VL_ICMS = $VL_ICMS;
				$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
				$this->VL_ICMS_ST = $VL_ICMS_ST;
				$this->VL_IPI = $VL_IPI;
				$this->VL_PIS = $VL_PIS;
				$this->VL_COFINS = $VL_COFINS;
				$this->VL_PIS_ST = $VL_PIS_ST;
				$this->VL_COFINS_ST = $VL_COFINS_ST;


				if ($this->COD_MOD=='65'){
					$this->VL_OUT_DA+= $this->VL_ICMS_ST + $this->VL_IPI;
					$this->VL_BC_ICMS_ST = '';
					$this->VL_ICMS_ST = '';
					$this->VL_IPI = '';
					$this->VL_PIS = '';
					$this->VL_COFINS = '';
					$this->VL_PIS_ST = '';
					$this->VL_COFINS_ST = '';
					$this->IND_FRT = '9';
				}
			}
		}

		function LerRegistro(){
			return '|C100|'.
					$this->IND_OPER.'|'.
					$this->IND_EMIT.'|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->COD_SIT.'|'.
					$this->SER.'|'.
					$this->NUM_DOC.'|'.
					$this->CHV_NFE.'|'.
					$this->DT_DOC.'|'.
					$this->DT_E_S.'|'.
					formata_qtd_sped($this->VL_DOC,2,false).'|'.
					$this->IND_PGTO.'|'.
					formata_qtd_sped($this->VL_DESC,2,false).'|'.
					formata_qtd_sped($this->VL_ABAT_NT,2,false).'|'.
					formata_qtd_sped($this->VL_MERC,2,false).'|'.
					$this->IND_FRT.'|'.
					formata_qtd_sped($this->VL_FRT,2,false).'|'.
					formata_qtd_sped($this->VL_SEG,2,false).'|'.
					formata_qtd_sped($this->VL_OUT_DA,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_IPI,2,false).'|'.
					formata_qtd_sped($this->VL_PIS,2,false).'|'.
					formata_qtd_sped($this->VL_COFINS,2,false).'|'.
					formata_qtd_sped($this->VL_PIS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_COFINS_ST,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_C101 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_FCP_UF_DEST=0;
		var $VL_ICMS_UF_DEST=0;
		var $VL_ICMS_UF_REM=0;

		function CriaRegistro($VL_FCP_UF_DEST,  $VL_ICMS_UF_DEST, $VL_ICMS_UF_REM){
			$this->VL_FCP_UF_DEST+= $VL_FCP_UF_DEST;
			$this->VL_ICMS_UF_DEST+= $VL_ICMS_UF_DEST;
			$this->VL_ICMS_UF_REM+= $VL_ICMS_UF_REM;
		}

		function LerRegistro(){
			return '|C101|'.
			formata_qtd_sped($this->VL_FCP_UF_DEST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_UF_DEST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_UF_REM,2,false).'|'.
			fim_linha();
		}

	}
	class SF_Reg_C105 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $OPER;
		var $UF;

		function CriaRegistro($OPER, $UF){
			$this->OPER = fill_full(trim(substr(limpa_numero($OPER),0,1)),1);
			$this->UF = trim(substr(limpa_texto($UF),0,2));
		}

		function LerRegistro(){
			return '|C105|'.
			$this->OPER.'|'.
			$this->UF.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_INF;
		var $TXT_COMPL;

		function CriaRegistro($COD_INF, $TXT_COMPL){
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
		}
			
		function LerRegistro(){
			return '|C110|'.
			$this->COD_INF.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C111 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_PROC;
		var $IND_PROC;

		function CriaRegistro($NUM_PROC, $IND_PROC){
			$this->NUM_PROC = trim(substr(limpa_texto($NUM_PROC),0,15));
			$this->IND_PROC = fill_full(trim(substr(limpa_numero($IND_PROC),0,1)),1);
		}
			
		function LerRegistro(){
			return '|C111|'.
			$this->NUM_PROC.'|'.
			$this->IND_PROC.'|'.
			fim_linha();
		}			
	}

	class SF_Reg_C112 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_DA;
		var $UF;
		var $NUM_DA;
		var $COD_AUT;
		var $VL_DA;
		var $DT_VCTO;
		var $DT_PGTO;

		function CriaRegistro($COD_DA, $UF, $NUM_DA,
			$COD_AUT, $VL_DA,
			$DT_VCTO, $DT_PGTO){
			$this->COD_DA = fill_full(trim(substr(limpa_numero($COD_DA),0,1)),1);
			$this->UF = trim(substr(limpa_texto($UF),0,2));
			$this->NUM_DA = trim(limpa_texto($NUM_DA));
			$this->COD_AUT = trim(limpa_texto($COD_AUT));
			$this->VL_DA = $VL_DA;
			$this->DT_VCTO = str_replace('/','',$DT_VCTO);
			$this->DT_PGTO = str_replace('/','',$DT_PGTO);
		}
		
		function LerRegistro(){
			return '|C112|'.
			$this->COD_DA.'|'.
			$this->UF.'|'.
			$this->NUM_DA.'|'.
			$this->COD_AUT.'|'.
			formata_qtd_sped($this->VL_DA,2,false).'|'.
			$this->DT_VCTO.'|'.
			$this->DT_PGTO.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C113 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $DT_DOC;
		var $MES_REF;
		var $CHV_DOCe;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
								$COD_MOD, $SER,
								$SUB, $NUM_DOC, $DT_DOC,
								$CHV_DOCe ,$MES_REF){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));

			$this->COD_MOD = trim(substr(limpa_texto($COD_MOD),0,2));
			$this->SER = trim(substr(limpa_texto($SER),0,4));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}


			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->CHV_DOCe = trim(substr(limpa_texto($CHV_DOCe),0,44));

			if (($this->COD_MOD!='55')&&
				($this->COD_MOD!='57')&&
				($this->COD_MOD!='65')&&
				($this->COD_MOD!='67')){
				$this->CHV_DOCe = '';
			}
			$this->MES_REF = $MES_REF;
		}
		
		function LerRegistro(){
			$cCHV_DOCe = '';
			if (data2nr($this->MES_REF)>=data2nr('01/01/2017')){
				$cCHV_DOCe = $this->CHV_DOCe.'|';
			}

			return '|C113|'.
					$this->IND_OPER.'|'.
					$this->IND_EMIT.'|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->SER.'|'.
					$this->SUB.'|'.
					$this->NUM_DOC.'|'.
					$this->DT_DOC.'|'.
					$cCHV_DOCe.
					fim_linha();
		}
	}


	class SF_Reg_C114 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD;
		var $ECF_FAB;
		var $ECF_CX;
		var $NUM_DOC;
		var $DT_DOC;

		function CriaRegistro($COD_MOD, $ECF_FAB, $ECF_CX,
			$NUM_DOC, $DT_DOC){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->ECF_FAB = trim(substr(limpa_texto($ECF_FAB),0,20));
			$this->ECF_CX = trim(substr(limpa_numero($ECF_CX),0,3));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-6));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
		}
		
		function LerRegistro(){
			return '|C114|'.
			$this->COD_MOD.'|'.
			$this->ECF_FAB.'|'.
			$this->ECF_CX.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			fim_linha();
		}
	}
			
	class SF_Reg_C115 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_CARGA;
		var $CNPJ_COL;
		var $IE_COL;
		var $CPF_COL;
		var $COD_MUN_COL;
		var $CNPJ_ENTG;
		var $IE_ENTG;
		var $CPF_ENTG;
		var $COD_MUN_ENTG;

		function CriaRegistro($IND_CARGA, $CNPJ, $IE, $COD_MUN, $TP='B'){
			$this->IND_CARGA = fill_full(trim(substr(limpa_numero($IND_CARGA),0,1)),1);

			$this->CNPJ_COL = trim(substr(limpa_numero($CNPJ),0,14));
			if (strlen($this->CNPJ_COL)==11){
				$this->CPF_COL = $this->CNPJ_COL;
				$this->CNPJ_COL = '';
			}else{
				$this->CPF_COL = '';
			}

			$this->IE_COL = trim(substr(limpa_numero2($IE),0,14));
			if (($IE=='ISENTO')||($IE=='Isento')){
				$this->IE_COL = '';
			}
			$this->COD_MUN_COL = fill_full(trim(substr(limpa_numero($COD_MUN),0,7)),7);
			if ($TP=='E'){
				$this->CNPJ_ENTG = $this->CNPJ_COL;
				$this->CPF_ENTG = $this->CPF_COL;
				$this->IE_ENTG = $this->IE_COL;
				$this->COD_MUN_ENTG = $this->COD_MUN_COL;
				$this->CNPJ_COL = '';
				$this->CPF_COL = '';
				$this->IE_COL = '';
				$this->COD_MUN_COL = '';
			}
		}
		
		function LerRegistro(){
			return '|C115|'.
			$this->IND_CARGA.'|'.
			$this->CNPJ_COL.'|'.
			$this->IE_COL.'|'.
			$this->CPF_COL.'|'.
			$this->COD_MUN_COL.'|'.
			$this->CNPJ_ENTG.'|'.
			$this->IE_ENTG.'|'.
			$this->CPF_ENTG.'|'.
			$this->COD_MUN_ENTG.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C120 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_DOC_IMP;
		var $NUM_DOC_IMP;
		var $PIS_IMP;
		var $COFINS_IMP;
		var $NUM_ACDRAW;

		function CriaRegistro($COD_DOC_IMP, $NUM_DOC_IMP, $PIS_IMP,
			$COFINS_IMP, $NUM_ACDRAW){
			$this->COD_DOC_IMP = fill_full(trim(substr(limpa_texto($COD_DOC_IMP),0,1)),1);
			$this->NUM_DOC_IMP =  trim(substr(limpa_numero($NUM_DOC_IMP),-10));
			$this->PIS_IMP = $PIS_IMP;
			$this->COFINS_IMP = $COFINS_IMP;
			$this->NUM_ACDRAW = trim(substr(limpa_texto($NUM_ACDRAW),0,20));
		}
		
		function LerRegistro(){
			return '|C120|'.
			$this->COD_DOC_IMP.'|'.
			$this->NUM_DOC_IMP.'|'.
			formata_qtd_sped($this->PIS_IMP,2,false).'|'.
			formata_qtd_sped($this->COFINS_IMP,2,false).'|'.
			$this->NUM_ACDRAW.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C130 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_SERV_NT;
		var $VL_BC_ISSQN;
		var $VL_ISSQN;
		var $VL_BC_IRRF;
		var $VL_IRRF;
		var $VL_BC_PREV;
		var $VL_PREV;

		function CriaRegistro($VL_SERV_NT, $VL_BC_ISSQN, $VL_ISSQN,
			$VL_BC_IRRF, $VL_IRRF, $VL_BC_PREV, $VL_PREV){
			$this->VL_SERV_NT = $VL_SERV_NT;
			$this->VL_BC_ISSQN = $VL_BC_ISSQN;
			$this->VL_ISSQN = $VL_ISSQN;
			$this->VL_BC_IRRF = $VL_BC_IRRF;
			$this->VL_IRRF = $VL_IRRF;
			$this->VL_BC_PREV = $VL_BC_PREV;
			$this->VL_PREV = $VL_PREV;
		}
		
		function LerRegistro(){
			return '|C130|'.
			formata_qtd_sped($this->VL_SERV_NT,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ISSQN,2,false).'|'.
			formata_qtd_sped($this->VL_ISSQN,2,false).'|'.
			formata_qtd_sped($this->VL_BC_IRRF,2,false).'|'.
			formata_qtd_sped($this->VL_IRRF,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PREV,2,false).'|'.
			formata_qtd_sped($this->VL_PREV,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C140 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_EMIT;
		var $IND_TIT;
		var $DESC_TIT;
		var $NUM_TIT;
		var $QTD_PARC;
		var $VL_TIT;

		function CriaRegistro($IND_EMIT, $IND_TIT, $DESC_TIT,
			$NUM_TIT, $QTD_PARC, $VL_TIT){
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_texto($IND_EMIT),0,1)),1);
			$this->IND_TIT = fill_full(trim(substr(limpa_texto($IND_TIT),0,2)),2);
			$this->DESC_TIT = trim(limpa_texto($DESC_TIT));
			$this->NUM_TIT = trim(limpa_texto($NUM_TIT));
			$this->QTD_PARC =  $QTD_PARC;
			//if ($this->QTD_PARC<1){
			//   $this->QTD_PARC = '1';
			//}
			$this->VL_TIT = $VL_TIT;
		}
		
		function LerRegistro(){
			return '|C140|'.
			$this->IND_EMIT.'|'.
			$this->IND_TIT.'|'.
			$this->DESC_TIT.'|'.
			$this->NUM_TIT.'|'.
			$this->QTD_PARC.'|'.
			formata_qtd_sped($this->VL_TIT,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C141 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_PARC;
		var $DT_VCTO;
		var $VL_PARC;

		function CriaRegistro($NUM_PARC, $DT_VCTO, $VL_PARC){
			$this->NUM_PARC =  trim(substr(limpa_numero($NUM_PARC),-2));
			$this->DT_VCTO = str_replace('/','',$DT_VCTO);
			$this->VL_PARC = $VL_PARC;
		}
			
		function LerRegistro(){
			return '|C141|'.
			$this->NUM_PARC.'|'.
			$this->DT_VCTO.'|'.
			formata_qtd_sped($this->VL_PARC,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C160 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $VEIC_ID;
		var $QTD_VOL;
		var $PESO_BRT;
		var $PESO_LIQ;
		var $UF_ID;

		function CriaRegistro($COD_PART, $VEIC_ID, $QTD_VOL,
			$PESO_BRT, $PESO_LIQ, $UF_ID){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->VEIC_ID =  trim(limpa_numero2($VEIC_ID));
			$this->UF_ID = trim(substr(limpa_texto($UF_ID),0,20));
			if (strlen($this->VEIC_ID)!=7){
				$this->VEIC_ID = '';
				$this->UF_ID = '';
			}
			if ($this->UF_ID==''){
				$this->VEIC_ID = '';
			}
			$this->QTD_VOL = trim(limpa_numero($QTD_VOL));
			if ($this->QTD_VOL<=0){
				$this->QTD_VOL = '1';
			}
			$this->PESO_BRT = $PESO_BRT;
			$this->PESO_LIQ = $PESO_LIQ;
		}
		
		function LerRegistro(){
			return '|C160|'.
			$this->COD_PART.'|'.
			$this->VEIC_ID.'|'.
			$this->QTD_VOL.'|'.
			formata_qtd_sped($this->PESO_BRT,2,false).'|'.
			formata_qtd_sped($this->PESO_LIQ,2,false).'|'.
			$this->UF_ID.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C165 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $VEIC_ID;
		var $COD_AUT;
		var $NR_PASSE;
		var $HORA;
		var $TEMPER;
		var $QTD_VOL;
		var $PESO_BRT;
		var $PESO_LIQ;
		var $NOM_MOT;
		var $CPF;
		var $UF_ID;

		function CriaRegistro($COD_PART, $VEIC_ID, $COD_AUT,
			$NR_PASSE, $HORA, $TEMPER,
			$QTD_VOL, $PESO_BRT, $PESO_LIQ,
			$NOM_MOT, $CPF, $UF_ID){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->VEIC_ID =  trim(limpa_numero2($VEIC_ID));
			$this->UF_ID = trim(substr(limpa_texto($UF_ID),0,20));
			if (strlen($this->VEIC_ID)!=7){
				$this->VEIC_ID = '';
				$this->UF_ID = '';
			}
			if ($this->UF_ID==''){
				$this->VEIC_ID = '';
			}
			$this->QTD_VOL = trim(limpa_numero($QTD_VOL));
			if ($this->QTD_VOL<=0){
				$this->QTD_VOL = '';
			}
			$this->PESO_BRT = $PESO_BRT;
			$this->PESO_LIQ = $PESO_LIQ;

			$this->COD_AUT = trim(limpa_texto($COD_AUT));
			$this->NR_PASSE = trim(limpa_texto($NR_PASSE));
			$this->HORA = fill_full(trim(substr(limpa_numero($HORA),0,6)),6);
			$this->TEMPER = $TEMPER;
			$this->NOM_MOT = trim(substr(limpa_texto($NOM_MOT),0,60));
			$this->CPF = fill_full(trim(substr(limpa_numero($CPF),0,11)),11);
		}
			
		function LerRegistro(){
			return '|C165|'.
			$this->COD_PART.'|'.
			$this->VEIC_ID.'|'.
			$this->COD_AUT.'|'.
			$this->NR_PASSE.'|'.
			$this->HORA.'|'.
			formata_qtd_sped($this->TEMPER,1,false).'|'.
			$this->QTD_VOL.'|'.
			formata_qtd_sped($this->PESO_BRT,2,false).'|'.
			formata_qtd_sped($this->PESO_LIQ,2,false).'|'.
			$this->NOM_MOT.'|'.
			$this->CPF.'|'.
			$this->UF_ID.'|'.
			fim_linha();
		}
	}
	class SF_Reg_C170 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_ITEM;
		var $COD_ITEM;
		var $ID_ITEM;
		var $DESCR_COMPL;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;
		var $VL_DESCT;
		var $IND_MOV;
		var $CST_ICMS;
		var $CFOP;
		var $COD_NAT;
		var $VL_BC_ICMS;
		var $ALIQ_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $ALIQ_ST;
		var $VL_ICMS_ST;
		var $IND_APUR;
		var $CST_IPI;
		var $COD_ENQ;
		var $VL_BC_IPI;
		var $ALIQ_IPI;
		var $VL_IPI;
		var $CST_PIS;
		var $VL_BC_PIS;
		var $ALIQ_PIS;
		var $QUANT_BC_PIS;
		var $ALIQ_PISQ;
		var $VL_PIS;
		var $CST_COFINS;
		var $VL_BC_COFINS;
		var $ALIQ_COFINS;
		var $QUANT_BC_COFINS;
		var $ALIQ_COFINSQ;
		var $VL_COFINS;
		var $COD_CTA;

		var $UNID_FAT;
		var $UNID_OP;
		var $VL_OPER_SOMA;
		var $VL_OPER_SOMA2;

		var $ICMS_Dest_Valor;
		var $ICMS_Dest_Valor_FCP;
		var $ICMS_Dest_Valor_Remete;

		var $ICMS_FCP_Valor;
		var $ICMSST_FCP_Valor;

		var $VL_ABAT_NT;

		function CriaRegistro($NUM_ITEM, $ID_ITEM,
			$COD_ITEM, $DESCR_COMPL,
			$QTD,
			$UNID, $UNID_FAT, $UNID_OP,
			$VL_ITEM, $VL_DESC,
			$IND_MOV, $CST_ICMS, $CFOP, $COD_NAT,
			$VL_BC_ICMS, $ALIQ_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $ALIQ_ST, $VL_ICMS_ST,
			$IND_APUR, $CST_IPI, $COD_ENQ, $VL_BC_IPI,
			$ALIQ_IPI, $VL_IPI, $CST_PIS, $VL_BC_PIS,
			$ALIQ_PIS, $QUANT_BC_PIS, $ALIQ_PISQ,
			$VL_PIS, $CST_COFINS, $VL_BC_COFINS,
			$ALIQ_COFINS, $QUANT_BC_COFINS, $ALIQ_COFINSQ,
			$VL_COFINS, $COD_CTA, $VL_OPER_SOMA, $VL_OPER_SOMA2,
			$ICMS_Dest_Valor,$ICMS_Dest_Valor_FCP,$ICMS_Dest_Valor_Remete,
			$VL_ABAT_NT,$ICMS_FCP_Valor,$ICMSST_FCP_Valor){
			$this->NUM_ITEM =  $NUM_ITEM;
			$this->ID_ITEM =  $ID_ITEM;
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->DESCR_COMPL = trim(limpa_texto($DESCR_COMPL));
			$this->QTD =  $QTD;
			$this->IND_MOV = fill_full(trim(substr(limpa_numero($IND_MOV),0,1)),1);
			if ($this->QTD<=0){
				$this->QTD = 1;
				$this->IND_MOV = 1;
			}
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));

			$this->UNID_FAT = $UNID_FAT;
			$this->UNID_OP = $UNID_OP;
			if ($this->UNID_FAT<=0){
				$this->UNID_FAT = 1;
			}else if ($this->UNID_OP=='D'){
				$this->UNID_FAT = 1/$this->UNID_FAT;
				if ($this->UNID_FAT<=0){
					$this->UNID_FAT = 1;
				}
			}

			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
			$this->COD_NAT = trim(substr(limpa_texto($COD_NAT),0,10));
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
			$this->ALIQ_ST = $ALIQ_ST;
			$this->VL_ICMS_ST = $VL_ICMS_ST;
			$this->IND_APUR = fill_full(trim(substr(limpa_numero($IND_APUR),0,1)),1);

			if ($CST_IPI==''){
				$CST_IPI = 2;
			}
			if (($CFOP[0]=='5') ||
				($CFOP[0]=='6') ||
				($CFOP[0]=='7') ){
				$CST_IPI = $CST_IPI + 50;
			}
			$this->CST_IPI = fill_full(trim(substr($CST_IPI,0,2)),2);

			$this->COD_ENQ = trim(substr(limpa_numero($COD_ENQ),0,3));
			if ($this->COD_ENQ!=''){
				$this->COD_ENQ = fill_full($this->COD_ENQ,3);
			}
			if ($this->COD_ENQ='999'){
				$this->COD_ENQ= '';
			}
			$this->VL_BC_IPI = $VL_BC_IPI;
			$this->ALIQ_IPI = $ALIQ_IPI;
			$this->VL_IPI = $VL_IPI;

			$this->CST_PIS = fill_full(trim(substr(limpa_numero($CST_PIS),0,2)),2);
			$this->VL_BC_PIS = $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->QUANT_BC_PIS = $QUANT_BC_PIS;
			$this->ALIQ_PISQ = $ALIQ_PISQ;
			$this->VL_PIS = $VL_PIS;

			$this->CST_COFINS = fill_full(trim(substr(limpa_numero($CST_COFINS),0,2)),2);
			$this->VL_BC_COFINS = $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->QUANT_BC_COFINS = $QUANT_BC_COFINS;
			$this->ALIQ_COFINSQ = $ALIQ_COFINSQ;
			$this->VL_COFINS = $VL_COFINS;

			$this->COD_CTA = trim(limpa_texto($COD_CTA));

			$this->VL_OPER_SOMA = $VL_OPER_SOMA;
			$this->VL_OPER_SOMA2 = $VL_OPER_SOMA2;

			$this->ICMS_Dest_Valor = $ICMS_Dest_Valor;
			$this->ICMS_Dest_Valor_FCP = $ICMS_Dest_Valor_FCP;
			$this->ICMS_Dest_Valor_Remete = $ICMS_Dest_Valor_Remete;

			$this->VL_ABAT_NT = $VL_ABAT_NT;
			$this->VL_DESCT = $this->VL_DESC;
			if ($this->VL_ABAT_NT!=''){
				$this->VL_DESCT+= $this->VL_ABAT_NT;
			}
			$this->ICMS_FCP_Valor   = $ICMS_FCP_Valor;
			$this->ICMSST_FCP_Valor = $ICMSST_FCP_Valor;
		}
		
		function AlteraUnidade($UNID){
			$this->UNID = $UNID;
		}
			
		function LerRegistro(){

			$VL_ABAT_NT = $this->VL_ABAT_NT;
			if ($VL_ABAT_NT!=''){
				$VL_ABAT_NT= formata_qtd_sped($VL_ABAT_NT,2,false).'|';
			}

			return '|C170|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			$this->DESCR_COMPL.'|'.
			formata_qtd_sped($this->QTD,5,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->IND_MOV.'|'.

			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			$this->COD_NAT.'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.

			$this->IND_APUR.'|'.

			$this->CST_IPI.'|'.
			$this->COD_ENQ.'|'.
			formata_qtd_sped($this->VL_BC_IPI,2,false).'|'.
			formata_qtd_sped($this->ALIQ_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_IPI,2,false).'|'.

			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,3,false).'|'.
			formata_qtd_sped($this->ALIQ_PISQ,4,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.

			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,3,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINSQ,4,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.

			$this->COD_CTA.'|'.
			$VL_ABAT_NT.
			fim_linha();
		}
	}

	class SF_Reg_C171 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_TANQUE;
		var $QTDE;

		function CriaRegistro($NUM_TANQUE, $QTDE){
			$this->NUM_TANQUE =  trim(substr(limpa_numero($NUM_TANQUE),-3));
			$this->QTDE = $QTDE;
		}
			
		function LerRegistro(){
			return '|C171|'.
			$this->NUM_TANQUE.'|'.
			formata_qtd_sped($this->QTDE,3,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C172 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_BC_ISSQN;
		var $ALIQ_ISSQN;
		var $VL_ISSQN;

		function CriaRegistro($VL_BC_ISSQN, $ALIQ_ISSQN, $VL_ISSQN){
			$this->VL_BC_ISSQN = $VL_BC_ISSQN;
			$this->ALIQ_ISSQN = $ALIQ_ISSQN;
			$this->VL_ISSQN = $VL_ISSQN;
		}
		function LerRegistro(){
			return '|C172|'.
			formata_qtd_sped($this->VL_BC_ISSQN,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ISSQN,2,false).'|'.
			formata_qtd_sped($this->VL_ISSQN,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C173 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $LOTE_MED;
		var $QTD_ITEM;
		var $DT_FAB;
		var $DT_VAL;
		var $IND_MED;
		var $TP_PROD;
		var $VL_TAB_MAX;

		function CriaRegistro($LOTE_MED, $QTD_ITEM, $DT_FAB,
			$DT_VAL, $IND_MED, $TP_PROD,
			$VL_TAB_MAX){
			$this->LOTE_MED =  trim(limpa_numero($LOTE_MED));
			$this->QTD_ITEM =  $QTD_ITEM;
			$this->DT_FAB =  str_replace('/','',$DT_FAB);
			$this->DT_VAL =  str_replace('/','',$DT_VAL);
			$this->IND_MED = fill_full(trim(substr(limpa_numero($IND_MED),0,1)),1);
			$this->TP_PROD = fill_full(trim(substr(limpa_numero($TP_PROD),0,1)),1);
			$this->VL_TAB_MAX = $VL_TAB_MAX;
		}
		
		function LerRegistro(){
			return '|C173|'.
			$this->LOTE_MED.'|'.
			$this->QTD_ITEM.'|'.
			$this->DT_FAB.'|'.
			$this->DT_VAL.'|'.
			$this->IND_MED.'|'.
			$this->TP_PROD.'|'.
			formata_qtd_sped($this->VL_TAB_MAX,2,false).'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C174 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_ARM;
		var $NUM_ARM;
		var $DESCR_COMPL;

		function CriaRegistro($IND_ARM, $NUM_ARM, $DESCR_COMPL){
			$this->IND_ARM = fill_full(trim(substr(limpa_numero($IND_ARM),0,1)),1);
			$this->NUM_ARM = trim(limpa_texto($NUM_ARM));
			$this->DESCR_COMPL = trim(limpa_texto($DESCR_COMPL));
		}
		
		function LerRegistro(){
			return '|C174|'.
			$this->IND_ARM.'|'.
			$this->NUM_ARM.'|'.
			$this->DESCR_COMPL.'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C175 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_VEIC_OPER;
		var $CNPJ;
		var $UF;
		var $CHASSI_VEIC;

		function CriaRegistro($IND_VEIC_OPER, $CNPJ, $UF, $CHASSI_VEIC){
			$this->IND_VEIC_OPER = fill_full(trim(substr(limpa_numero($IND_VEIC_OPER),0,1)),1);
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			$this->UF = trim(substr(limpa_texto($UF),0,2));
			$this->CHASSI_VEIC = trim(substr(limpa_texto($CHASSI_VEIC),0,17));
		}
		
		function LerRegistro(){
			return '|C174|'.
			$this->IND_VEIC_OPER.'|'.
			$this->CNPJ.'|'.
			$this->UF.'|'.
			$this->CHASSI_VEIC.'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_C176 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD_ULT_E;
		var $NUM_DOC_ULT_E;
		var $SER_ULT_E;
		var $DT_ULT_E;
		var $COD_PART_ULT_E;
		var $QUANT_ULT_E;
		var $VL_UNIT_ULT_E;
		var $VL_UNIT_BC_ST;

		function CriaRegistro($COD_MOD_ULT_E, $NUM_DOC_ULT_E,
			$SER_ULT_E, $DT_ULT_E,
			$COD_PART_ULT_E, $QUANT_ULT_E,
			$VL_UNIT_ULT_E, $VL_UNIT_BC_ST){
			$this->COD_MOD_ULT_E = fill_full(trim(substr(limpa_numero($COD_MOD_ULT_E),0,2)),2);
			$this->NUM_DOC_ULT_E =  trim(substr(limpa_numero($NUM_DOC_ULT_E),-3));
			$this->SER_ULT_E = trim(substr(limpa_texto($SER_ULT_E),0,3));
			$this->DT_ULT_E =  str_replace('/','',$DT_ULT_E);
			$this->COD_PART_ULT_E = trim(substr(limpa_texto($COD_PART_ULT_E),0,60));
			$this->QUANT_ULT_E = $QUANT_ULT_E;
			$this->VL_UNIT_ULT_E = $VL_UNIT_ULT_E;
			$this->VL_UNIT_BC_ST = $VL_UNIT_BC_ST;
		}
		
		function LerRegistro(){
			return '|C176|'.
			$this->COD_MOD_ULT_E.'|'.
			$this->NUM_DOC_ULT_E.'|'.
			$this->SER_ULT_E.'|'.
			$this->DT_ULT_E.'|'.
			$this->COD_PART_ULT_E.'|'.
			formata_qtd_sped($this->QUANT_ULT_E,3,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ULT_E,3,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ST,3,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C177 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_SELO_IPI;
		var $QT_SELO_IPI;

		function CriaRegistro($COD_SELO_IPI, $QT_SELO_IPI){
			$this->COD_SELO_IPI = fill_full(trim(substr(limpa_numero($COD_SELO_IPI),0,6)),6);
			$this->QT_SELO_IPI =  trim(substr(limpa_numero($QT_SELO_IPI),-12));
		}
		
		function LerRegistro(){
			return '|C177|'.
			$this->COD_SELO_IPI.'|'.
			$this->QT_SELO_IPI.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C178 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CL_ENQ;
		var $VL_UNID;
		var $QUANT_PAD;

		function CriaRegistro($CL_ENQ, $VL_UNID,$QUANT_PAD){
			$this->CL_ENQ =  trim(substr(limpa_numero($CL_ENQ),-5));
			$this->VL_UNID =  $VL_UNID;
			$this->QUANT_PAD =  $QUANT_PAD;
		}
		function LerRegistro(){
			return '|C178|'.
			$this->CL_ENQ.'|'.
			formata_qtd_sped($this->VL_UNID,2,false).'|'.
			formata_qtd_sped($this->QUANT_PAD,3,false).'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_C179 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $BC_ST_ORIG_DEST;
		var $ICMS_ST_REP;
		var $ICMS_ST_COMPL;
		var $BC_RET;
		var $ICMS_RET;

		function CriaRegistro($BC_ST_ORIG_DEST, $ICMS_ST_REP,
			$ICMS_ST_COMPL, $BC_RET, $ICMS_RET){
			$this->BC_ST_ORIG_DEST =  $BC_ST_ORIG_DEST;
			$this->ICMS_ST_REP =  $ICMS_ST_REP;
			$this->ICMS_ST_COMPL =  $ICMS_ST_COMPL;
			$this->BC_RET =  $BC_RET;
			$this->ICMS_RET =  $ICMS_RET;
		}
		function LerRegistro(){
			return '|C179|'.
			formata_qtd_sped($this->BC_ST_ORIG_DEST,2,false).'|'.
			formata_qtd_sped($this->ICMS_ST_REP,2,false).'|'.
			formata_qtd_sped($this->ICMS_ST_COMPL,2,false).'|'.
			formata_qtd_sped($this->BC_RET,2,false).'|'.
			formata_qtd_sped($this->ICMS_RET,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C180 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_RESP_RET;
		var $QUANT_CONV;
		var $UNID;
		var $VL_UNIT_CONV;
		var $VL_UNIT_ICMS_OP_CONV;
		var $VL_UNIT_BC_ICMS_ST_CONV;
		var $VL_UNIT_ICMS_ST_CONV;
		var $VL_UNIT_FCP_ST_CONV;
		var $COD_DA;
		var $NUM_DA;


		function CriaRegistro($COD_RESP_RET,$QUANT_CONV,$UNID,
			$VL_UNIT_CONV,$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_CONV,$VL_UNIT_ICMS_ST_CONV,
			$VL_UNIT_FCP_ST_CONV,
			$COD_DA,$NUM_DA){

			$this->COD_RESP_RET = fill_full(trim(substr(limpa_numero($COD_RESP_RET),0,1)),1);
			$this->QUANT_CONV = $QUANT_CONV;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_UNIT_CONV = $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_OP_CONV = $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_CONV = $VL_UNIT_BC_ICMS_ST_CONV;
			$this->VL_UNIT_FCP_ST_CONV = $VL_UNIT_FCP_ST_CONV;
			$this->COD_DA = fill_full(trim(substr(limpa_numero($COD_DA),0,1)),1);
			$this->NUM_DA = fill_full(trim(substr(limpa_numero($NUM_DA),0,60)),60);

		}
		function LerRegistro(){
			return '|C180|'.
			$this->COD_RESP_RET.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV,6,false).'|'.
			$this->COD_DA.'|'.
			$this->NUM_DA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C185 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_ITEM;
		var $COD_ITEM;
		var $CST_ICMS;
		var $CFOP;
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV;
		var $UNID;
		var $VL_UNIT_CONV;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV;
		var $VL_UNIT_ICMS_OP_CONV;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_CONV_REST;
		var $VL_UNIT_FCP_ST_CONV_REST;
		var $VL_UNIT_ICMS_ST_CONV_COMPL;
		var $VL_UNIT_FCP_ST_CONV_COMPL;


		function CriaRegistro($NUM_ITEM,$COD_ITEM,$CST_ICMS,
			$CFOP,$COD_MOT_REST_COMPL,$QUANT_CONV,
			$UNID,
			$VL_UNIT_CONV,
			$VL_UNIT_ICMS_NA_OPERACAO_CONV,
			$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_CONV_REST,
			$VL_UNIT_FCP_ST_CONV_REST,
			$VL_UNIT_ICMS_ST_CONV_COMPL,
			$VL_UNIT_FCP_ST_CONV_COMPL){

			$this->NUM_ITEM = $NUM_ITEM;
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));

			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->QUANT_CONV = $QUANT_CONV;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_UNIT_CONV = $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV = $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV = $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST = $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST = $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL = $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL = $VL_UNIT_FCP_ST_CONV_COMPL;

		}
		
		function LerRegistro(){
			return '|C185|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C190 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR=0;
		var $VL_BC_ICMS=0;
		var $VL_ICMS=0;
		var $VL_BC_ICMS_ST=0;
		var $VL_ICMS_ST=0;
		var $VL_RED_BC=0;
		var $VL_IPI=0;
		var $COD_OBS;
		var $ICMS_Dest_Valor=0;
		var $ICMS_Dest_Valor_FCP=0;
		var $ICMS_Dest_Valor_Remete=0;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS, $COD_OBS=''){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}

		function SomaRegistro($VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $VL_ICMS_ST, $VL_RED_BC,
			$VL_IPI,
			$ICMS_Dest_Valor,$ICMS_Dest_Valor_FCP,$ICMS_Dest_Valor_Remete){

			$this->VL_OPR = $this->VL_OPR + $VL_OPR;

			$this->VL_BC_ICMS = $this->VL_BC_ICMS + $VL_BC_ICMS;
			$this->VL_ICMS = $this->VL_ICMS + $VL_ICMS;
			$this->VL_BC_ICMS_ST = $this->VL_BC_ICMS_ST + $VL_BC_ICMS_ST;
			$this->VL_ICMS_ST = $this->VL_ICMS_ST  + $VL_ICMS_ST;
			$this->VL_RED_BC = $this->VL_RED_BC + $VL_RED_BC;
			$this->VL_IPI = $this->VL_IPI + $VL_IPI;

			$this->ICMS_Dest_Valor = $ICMS_Dest_Valor;
			$this->ICMS_Dest_Valor_FCP = $ICMS_Dest_Valor_FCP;
			$this->ICMS_Dest_Valor_Remete = $ICMS_Dest_Valor_Remete;

		}
		
		function LerRegistro(){
			return '|C190|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			formata_qtd_sped($this->VL_IPI,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C191 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_FCP_OP=0;
		var $VL_FCP_ST=0;
		var $VL_FCP_RET=0;

		function SomaRegistro($VL_FCP_OP, $VL_FCP_ST, $VL_FCP_RET){
			$this->VL_FCP_OP = $this->VL_FCP_OP + $VL_FCP_OP;
			$this->VL_FCP_ST = $this->VL_FCP_ST + $VL_FCP_ST;
			$this->VL_FCP_RET = $this->VL_FCP_RET + $VL_FCP_RET;
		}
		
		function LerRegistro(){
			return '|C191|'.
			formata_qtd_sped($this->VL_FCP_OP,2,false).'|'.
			formata_qtd_sped($this->VL_FCP_ST,2,false).'|'.
			formata_qtd_sped($this->VL_FCP_RET,2,false).'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C195 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_OBS;
		var $TXT_COMPL;

		function CriaRegistro($COD_OBS, $TXT_COMPL){
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
		}
			
		function LerRegistro(){
			return '|C195|'.
			$this->COD_OBS.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C197 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_AJ;
		var $DESCR_COMPL_AJ;
		var $COD_ITEM;
		var $VL_BC_ICMS;
		var $ALIQ_ICMS;
		var $VL_ICMS;
		var $VL_OUTROS;

		function CriaRegistro($COD_AJ, $DESCR_COMPL_AJ, $COD_ITEM,
			$VL_BC_ICMS,$ALIQ_ICMS,
			$VL_ICMS,$VL_OUTROS){
			$this->COD_AJ = fill_full(trim(substr(limpa_texto($COD_AJ),0,10)),10);
			$this->DESCR_COMPL_AJ = trim(limpa_texto($DESCR_COMPL_AJ));
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_OUTROS = $VL_OUTROS;

		}
		
		function LerRegistro(){
			return '|C197|'.
			$this->COD_AJ.'|'.
			$this->DESCR_COMPL_AJ.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OUTROS,2,false).'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C300 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC_INI;
		var $NUM_DOC_FIN;
		var $DT_DOC;
		var $VL_DOC;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_CTA;

		function CriaRegistro($COD_MOD, $SER, $SUB,
			$NUM_DOC_INI,$NUM_DOC_FIN, $DT_DOC,
			$VL_DOC,$VL_PIS,$VL_COFINS,$COD_CTA ){
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC_INI =  trim(substr(limpa_numero($NUM_DOC_INI),-6));
			$this->NUM_DOC_FIN =  trim(substr(limpa_numero($NUM_DOC_FIN),-6));
			$this->DT_DOC =  str_replace('/','',$DT_DOC);
			$this->VL_DOC = $VL_DOC;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_CTA = trim(limpa_texto($COD_CTA));

		}
		
		function LerRegistro(){
			return '|C300|'.
			$this->COD_MOD.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC_INI.'|'.
			$this->NUM_DOC_FIN.'|'.
			$this->DT_DOC.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C310 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_DOC_CANC;
		function CriaRegistro($NUM_DOC_CANC){
			$this->NUM_DOC_CANC =  trim(substr(limpa_numero($NUM_DOC_CANC),-6));
		}
			
		function LerRegistro(){
			return '|C310|'.
			$this->NUM_DOC_CANC.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C320 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR,$VL_BC_ICMS, $VL_ICMS,
			$VL_RED_BC,$COD_OBS ){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = trim(substr(limpa_numero($CFOP),0,4));
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_OPR = $VL_OPR;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_RED_BC = $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
			
		function LerRegistro(){
			return '|C320|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C321 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_ITEM;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_PIS;
		var $VL_COFINS;

		function CriaRegistro($COD_ITEM, $QTD, $UNID,
			$VL_ITEM,$VL_DESC, $VL_BC_ICMS,
			$VL_ICMS,$VL_PIS,$VL_COFINS ){
			$this->COD_ITEM = trim(substr(limpa_numero($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->UNID = trim(substr(limpa_numero($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
		}
		
		function LerRegistro(){
			return '|C321|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C330 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV=0;
		var $UNID;
		var $VL_UNIT_CONV=0;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV=0;
		var $VL_UNIT_ICMS_OP_CONV=0;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_CONV_REST=0;
		var $VL_UNIT_FCP_ST_CONV_REST=0;
		var $VL_UNIT_ICMS_ST_CONV_COMPL=0;
		var $VL_UNIT_FCP_ST_CONV_COMPL=0;


		function CriaRegistro($COD_MOT_REST_COMPL,$UNID){
			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
		}

		function SomaRegistro($QUANT_CONV,
							$VL_UNIT_CONV,
							$VL_UNIT_ICMS_NA_OPERACAO_CONV,
							$VL_UNIT_ICMS_OP_CONV,
							$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_ICMS_ST_CONV_REST,
							$VL_UNIT_FCP_ST_CONV_REST,
							$VL_UNIT_ICMS_ST_CONV_COMPL,
							$VL_UNIT_FCP_ST_CONV_COMPL){

			$this->QUANT_CONV+= $QUANT_CONV;
			$this->VL_UNIT_CONV+= $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV+= $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV+= $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST+= $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST+= $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL+= $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL+= $VL_UNIT_FCP_ST_CONV_COMPL;

		}
		
		function LerRegistro(){
			return '|C330|'.
					$this->COD_MOT_REST_COMPL.'|'.
					formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
					$this->UNID.'|'.
					formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
					formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
					fim_linha();
		}
	}
	
	class SF_Reg_C350 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $SER;
		var $SUB_SER;
		var $NUM_DOC;
		var $DT_DOC;
		var $CNPJ_CPF;
		var $VL_MERC;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_CTA;

		function CriaRegistro($SER, $SUB_SER, $NUM_DOC,
							$DT_DOC,$CNPJ_CPF, $VL_MERC,
							$VL_DOC,$VL_DESC,
							$VL_PIS,$VL_COFINS,
							$COD_CTA ){
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB_SER = trim(substr(limpa_texto($SUB_SER),0,4));
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-6));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->CNPJ_CPF = trim(substr(limpa_numero($CNPJ_CPF),0,14));
			if ((strlen($this->CNPJ_CPF)!=14)&&
				(strlen($this->CNPJ_CPF)!=11)){
				$this->CNPJ_CPF = '';
			}
			$this->VL_MERC = $VL_MERC;
			$this->VL_DOC = $VL_DOC;
			$this->VL_DESC = $VL_DESC;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_CTA = trim(limpa_texto($COD_CTA));

		}
		
		function LerRegistro(){
			return '|C350|'.
			$this->SER.'|'.
			$this->SUB_SER.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			$this->CNPJ_CPF.'|'.
			formata_qtd_sped($this->VL_MERC,2,false).'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_C370 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $NUM_ITEM;
		var $COD_ITEM;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;

		function CriaRegistro($NUM_ITEM, $COD_ITEM, $QTD,
			$UNID,$VL_ITEM, $VL_DESC){
			$this->NUM_ITEM = trim(substr(limpa_numero($NUM_ITEM),0,3));
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
		}
		
		function LerRegistro(){
			return '|C370|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,2,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C380 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV;
		var $UNID;
		var $VL_UNIT_CONV;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV;
		var $VL_UNIT_ICMS_OP_CONV;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_CONV_REST;
		var $VL_UNIT_FCP_ST_CONV_REST;
		var $VL_UNIT_ICMS_ST_CONV_COMPL;
		var $VL_UNIT_FCP_ST_CONV_COMPL;
		var $CST_ICMS;
		var $CFOP;

		function CriaRegistro($COD_MOT_REST_COMPL,$QUANT_CONV,
							$UNID,
							$VL_UNIT_CONV,
							$VL_UNIT_ICMS_NA_OPERACAO_CONV,
							$VL_UNIT_ICMS_OP_CONV,
							$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
							$VL_UNIT_ICMS_ST_CONV_REST,
							$VL_UNIT_FCP_ST_CONV_REST,
							$VL_UNIT_ICMS_ST_CONV_COMPL,
							$VL_UNIT_FCP_ST_CONV_COMPL,
							$CST_ICMS,$CFOP ){

			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->QUANT_CONV = $QUANT_CONV;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_UNIT_CONV = $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV = $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV = $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST = $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST = $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL = $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL = $VL_UNIT_FCP_ST_CONV_COMPL;

			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
		}
		
		function LerRegistro(){
			return '|C380|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C390 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_RED_BC, $COD_OBS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->VL_OPR =  $VL_OPR;
			$this->VL_BC_ICMS =  $VL_BC_ICMS;
			$this->VL_ICMS =  $VL_ICMS;
			$this->VL_RED_BC =  $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|C390|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD;
		var $ECF_MOD;
		var $ECF_FAB;
		var $ECF_CX;

		function CriaRegistro($COD_MOD, $ECF_MOD,
			$ECF_FAB, $ECF_CX){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->ECF_MOD = trim(substr(limpa_texto($ECF_MOD),0,20));
			$this->ECF_FAB = trim(substr(limpa_texto($ECF_FAB),0,20));
			$this->ECF_CX = trim(substr(limpa_numero($ECF_CX),0,3));
			if ($this->ECF_CX<1){
				$this->ECF_CX = 1;
			}
		}
		
		function LerRegistro(){
			return '|C400|'.
			$this->COD_MOD.'|'.
			$this->ECF_MOD.'|'.
			$this->ECF_FAB.'|'.
			$this->ECF_CX.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C405 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_DOC;
		var $CRO;
		var $CRZ;
		var $NUM_COO_FIN;
		var $GT_FIN;
		var $VL_BRT;

		function CriaRegistro($DT_DOC, $CRO,
			$CRZ, $NUM_COO_FIN,
			$GT_FIN, $VL_BRT){
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->CRO = trim(substr(limpa_numero($CRO),-3));
			$this->CRZ = trim(substr(limpa_numero($CRZ),-6));
			$this->NUM_COO_FIN = trim(substr(limpa_numero($NUM_COO_FIN),-6));
			$this->GT_FIN = $GT_FIN;
			$this->VL_BRT = $VL_BRT;
		}
		
		function LerRegistro(){
			return '|C405|'.
			$this->DT_DOC.'|'.
			$this->CRO.'|'.
			$this->CRZ.'|'.
			$this->NUM_COO_FIN.'|'.
			formata_qtd_sped($this->GT_FIN,2,false).'|'.
			formata_qtd_sped($this->VL_BRT,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C410 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_PIS=0;
		var $VL_COFINS=0;

		function CriaRegistro($VL_PIS, $VL_COFINS){
			$this->VL_PIS+= $VL_PIS;
			$this->VL_COFINS+= $VL_COFINS;
		}
			
		function LerRegistro(){
			return '|C410|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C420 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_TOT_PAR;
		var $VLR_ACUM_TOT;
		var $NR_TOT;
		var $DESCR_NR_TOT;

		function CriaRegistro($COD_TOT_PAR, $VLR_ACUM_TOT){
			$this->COD_TOT_PAR = trim(substr(limpa_texto($COD_TOT_PAR),0,7));
			$this->VLR_ACUM_TOT = $VLR_ACUM_TOT;
			$this->NR_TOT = '';
			$this->DESCR_NR_TOT = '';
			if ((substr($this->COD_TOT_PAR,2,1))=='T'){
				$this->NR_TOT = substr($this->COD_TOT_PAR,0,2);
				$this->DESCR_NR_TOT = 'ICMS '.$this->COD_TOT_PAR;
			}else if ((substr($this->COD_TOT_PAR,2,1))=='S'){
				$this->NR_TOT = substr($this->COD_TOT_PAR,0,2);
				$this->DESCR_NR_TOT = 'ISS '.$this->COD_TOT_PAR;
			}
		}
		
		function LerRegistro(){
			return '|C420|'.
			$this->COD_TOT_PAR.'|'.
			formata_qtd_sped($this->VLR_ACUM_TOT,2,false).'|'.
			$this->NR_TOT.'|'.
			$this->DESCR_NR_TOT.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C425 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $ID_ITEM;
		var $QTD=0;
		var $UNID;
		var $VL_ITEM=0;
		var $VL_PIS=0;
		var $VL_COFINS=0;
		
		function CriaRegistro($COD_ITEM, $ID_ITEM, $UNID){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
		}

		function SomaRegistro($QTD, $VL_ITEM, $VL_PIS , $VL_COFINS){
			$this->QTD = $this->QTD + $QTD;
			$this->VL_ITEM = $this->VL_ITEM + $VL_ITEM;
			$this->VL_PIS = $this->VL_PIS + $VL_PIS;
			$this->VL_COFINS = $this->VL_COFINS + $VL_COFINS;
		}

		function LerRegistro(){
			return '|C425|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C430 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV=0;
		var $UNID;
		var $VL_UNIT_CONV=0;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV=0;
		var $VL_UNIT_ICMS_OP_CONV=0;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_CONV_REST=0;
		var $VL_UNIT_FCP_ST_CONV_REST=0;
		var $VL_UNIT_ICMS_ST_CONV_COMPL=0;
		var $VL_UNIT_FCP_ST_CONV_COMPL=0;
		var $CST_ICMS;
		var $CFOP;

		function CriaRegistro($COD_MOT_REST_COMPL,
			$UNID,
			$CST_ICMS,
			$CFOP){

			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
		}

		function SomaRegistro($QUANT_CONV,
			$VL_UNIT_CONV,
			$VL_UNIT_ICMS_NA_OPERACAO_CONV,
			$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_CONV_REST,
			$VL_UNIT_FCP_ST_CONV_REST,
			$VL_UNIT_ICMS_ST_CONV_COMPL,
			$VL_UNIT_FCP_ST_CONV_COMPL){

			$this->QUANT_CONV+= $QUANT_CONV;
			$this->VL_UNIT_CONV+= $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV+= $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV+= $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST+= $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST+= $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL+= $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL+= $VL_UNIT_FCP_ST_CONV_COMPL;
		}

		function LerRegistro(){
			return '|C430|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C460 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD;
		var $COD_SIT;
		var $NUM_DOC;
		var $DT_DOC;
		var $VL_DOC;
		var $VL_PIS;
		var $VL_COFINS;
		var $CPF_CNPJ;
		var $NOM_ADQ;

		function CriaRegistro($COD_MOD, $COD_SIT, $NUM_DOC,
			$DT_DOC, $VL_DOC, $VL_PIS,
			$VL_COFINS, $CPF_CNPJ, $NOM_ADQ){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-6));
			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				$this->DT_DOC = '';
				$this->VL_DOC = '';
				$this->VL_PIS = '';
				$this->VL_COFINS = '';
				$this->CPF_CNPJ = '';
				$this->NOM_ADQ = '';
			}else{
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->VL_DOC = $VL_DOC;
				$this->VL_PIS = $VL_PIS;
				$this->VL_COFINS = $VL_COFINS;
				$this->CPF_CNPJ = trim(substr(limpa_numero($CPF_CNPJ),0,14));
				if ((strlen($this->CPF_CNPJ)!=14)&&
					(strlen($this->CPF_CNPJ)!=11)){
					$this->CPF_CNPJ = '';
				}
				$this->NOM_ADQ = trim(substr(limpa_texto($NOM_ADQ),0,60));
				if ($this->NOM_ADQ==''){
					$this->NOM_ADQ = 'CONSUMIDOR FINAL';
				}
			}
		}
		
		function LerRegistro(){
			return '|C460|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->CPF_CNPJ.'|'.
			$this->NOM_ADQ.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C470 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $ID_ITEM;
		var $QTD;
		var $QTD_CANC;
		var $UNID;
		var $VL_ITEM;
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_TOT_PAR;
		var $DESC_PROPORCIONAL=0;
		var $VALOR_REAL=0;

		function CriaRegistro($COD_ITEM, $ID_ITEM, $QTD, $QTD_CANC,
			$UNID, $VL_ITEM, $COD_TOT_PAR, $ORIGEM,
			$VL_PIS, $VL_COFINS){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->QTD = $QTD;
			$this->QTD_CANC = $QTD_CANC;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_TOT_PAR = $COD_TOT_PAR;

			$con_pro = 'select Origem,Codigo_Fornecedor from produto '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto="'.$this->ID_ITEM.'"';
			$res_pro = consulta_sql($con_pro);
			$reg_pro = consulta_ler_linha($res_pro);
			consulta_limpa($res_pro);

			if($ORIGEM==''){
				//consulta produto
				$ORIGEM = $reg_pro[0];
			}

			$ORIGEM = fill_full(trim(substr(limpa_texto($ORIGEM),0,1)),1);

			$this->CFOP = '5102';
			$this->ALIQ_ICMS = 0;
			if ((substr($this->COD_TOT_PAR,2,1))=='S'){
				$this->CST_ICMS = '41';
				$this->CFOP = '5933';
			}else if ((substr($this->COD_TOT_PAR,1,1))=='S'){
				$this->CST_ICMS = '41';
				$this->CFOP = '5933';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='I'){
				$this->CST_ICMS = '40';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='N'){
				$this->CST_ICMS = '41';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='F'){
				$this->CST_ICMS = '60';
				$this->CFOP = '5405';
			}else{
				$this->CST_ICMS = '00';
				$this->ALIQ_ICMS = substr($this->COD_TOT_PAR,3,4)/100;
			}
			if (($_SESSION['Dominio']!=22)&&($_SESSION['Dominio']!=23)&&($_SESSION['Dominio']!=183)&&
					($_SESSION['Dominio']!=223)&&($_SESSION['Dominio']!=287)){
				if ($reg_pro[1]==1){
					if ($this->CFOP=='5405'){
						$this->CFOP='5401';
					}
					if ($this->CFOP=='5102'){
						$this->CFOP='5101';
					}
				}
			}
			$this->CST_ICMS = $ORIGEM.$this->CST_ICMS;
			$this->VALOR_REAL = arredonda_numero_menos(($this->VL_ITEM - $this->DESC_PROPORCIONAL)*100)/100;
			if ($this->VALOR_REAL<0.01){
				$this->VALOR_REAL = 0.01;
			}
		}
		
		function DescontoRegistro($DESCONTO){
			$this->DESC_PROPORCIONAL+= $DESCONTO;
			$this->VALOR_REAL = arredonda_numero_menos( ($this->VL_ITEM - $this->DESC_PROPORCIONAL)*100)/100;
			if ($this->VALOR_REAL<=0.01){
				$this->VALOR_REAL = 0.01;
			}
		}

		function LerRegistro(){
			return '|C470|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			formata_qtd_sped($this->QTD_CANC,3,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VALOR_REAL,2,false).'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C480 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV=0;
		var $UNID;
		var $VL_UNIT_CONV=0;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV=0;
		var $VL_UNIT_ICMS_OP_CONV=0;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_CONV_REST=0;
		var $VL_UNIT_FCP_ST_CONV_REST=0;
		var $VL_UNIT_ICMS_ST_CONV_COMPL=0;
		var $VL_UNIT_FCP_ST_CONV_COMPL=0;
		var $CST_ICMS;
		var $CFOP;

		function CriaRegistro($COD_MOT_REST_COMPL,
			$UNID,
			$CST_ICMS,
			$CFOP){
			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));

			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
		}

		function SomaRegistro($QUANT_CONV,
			$VL_UNIT_CONV,
			$VL_UNIT_ICMS_NA_OPERACAO_CONV,
			$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_CONV_REST,
			$VL_UNIT_FCP_ST_CONV_REST,
			$VL_UNIT_ICMS_ST_CONV_COMPL,
			$VL_UNIT_FCP_ST_CONV_COMPL){

			$this->QUANT_CONV+= $QUANT_CONV;
			$this->VL_UNIT_CONV+= $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV+= $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV+= $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST+= $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST+= $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL+= $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL+= $VL_UNIT_FCP_ST_CONV_COMPL;

		}

		function LerRegistro(){
			return '|C480|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C490 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR=0;
		var $VL_BC_ICMS=0;
		var $VL_ICMS=0;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$COD_OBS=''){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}

		function SomaRegistro($VL_OPR, $VL_BC_ICMS, $VL_ICMS){
			$this->VL_OPR = $this->VL_OPR + $VL_OPR;
			$this->VL_BC_ICMS = $this->VL_BC_ICMS + $VL_BC_ICMS;
			//           $this->VL_ICMS = $this->VL_ICMS + $VL_ICMS;
			$this->VL_ICMS = arredonda_numero_menos($this->VL_BC_ICMS * $VL_ICMS) /100;
		}

		function LerRegistro(){
			return '|C490|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $COD_CONS;
		var $NUM_DOC;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_FORN;
		var $VL_SERV_NT;
		var $VL_TERC;
		var $VL_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $COD_INF;
		var $VL_PIS;
		var $VL_COFINS;
		var $TP_LIGACAO;
		var $COD_GRUPO_TENSAO;
		var $CHV_DOCe;
		var $tem_final=0;
		var $COD_MUN_DEST;
		var $COD_CTA;


		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$COD_CONS, $NUM_DOC, $DT_DOC,
			$DT_E_S, $VL_DOC, $VL_DESC,
			$VL_FORN, $VL_SERV_NT,
			$VL_TERC, $VL_DA, $VL_BC_ICMS,
			$VL_ICMS, $VL_BC_ICMS_ST, $VL_ICMS_ST,
			$COD_INF, $VL_PIS, $VL_COFINS, $TP_LIGACAO,
			$COD_GRUPO_TENSAO,
			$CHV_DOCe, $COD_MUN_DEST,
			$COD_CTA, $tem_final ){

			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else{
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->COD_CONS = fill_full(trim(substr(limpa_texto($COD_CONS),0,2)),2);
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->DT_E_S = str_replace('/','',$DT_E_S);
			$this->VL_DOC = $VL_DOC;
			$this->VL_DESC = $VL_DESC;
			$this->VL_FORN = $VL_FORN;
			$this->VL_SERV_NT = $VL_SERV_NT;
			$this->VL_TERC = $VL_TERC;
			$this->VL_DA = $VL_DA;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
			$this->VL_ICMS_ST = $VL_ICMS_ST;
			if ($this->VL_ICMS<=0){
				$this->VL_BC_ICMS = 0;
			}
			if ($this->VL_ICMS_ST<=0){
				$this->VL_BC_ICMS_ST = 0;
			}
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->TP_LIGACAO = $TP_LIGACAO;
			$this->COD_GRUPO_TENSAO = $COD_GRUPO_TENSAO;
			$this->CHV_DOCe = $CHV_DOCe;

			$this->COD_MUN_DEST = $COD_MUN_DEST;
			$this->COD_CTA  = $COD_CTA;

			$this->tem_final = $tem_final;

		}
		function LerRegistro(){
			$final_2020 = '';
			$final_2022 = '';
			if ($this->tem_final>0){
				if ($this->COD_MOD=='66'){
					$final_2020 = $this->CHV_DOCe.'|'.
									'1|'.  //FIN_DOCe
									'|'.   //CHV_DOCe_REF
									'1|'.  //IND_DEST - 1 Contribuinte, 2Isento, 9 N Contribuinte
									$this->COD_MUN_DEST.'|'.
									$this->COD_CTA.'|';

				}else{
					$final_2020 = '|'.   //CHV_DOCe
									'|'.   //FIN_DOCe
									'|'.   //CHV_DOCe_REF
									'1|'.  //IND_DEST - 1 Contribuinte, 2Isento, 9 N Contribuinte
									$this->COD_MUN_DEST.'|'.
									$this->COD_CTA.'|';
				}
			}
			if ($this->tem_final>1){
				$final_2022 = '|'.   //CHV_DOCe
								'|'.   //FIN_DOCe
								'|'.   //CHV_DOCe_REF
								'|'.   //CHV_DOCe_REF
								'|'.   //CHV_DOCe_REF
								'|'.   //CHV_DOCe_REF
								'|';   //CHV_DOCe_REF;
			}
			return '|C500|'.
					$this->IND_OPER.'|'.
					$this->IND_EMIT.'|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->COD_SIT.'|'.
					$this->SER.'|'.
					$this->SUB.'|'.
					$this->COD_CONS.'|'.
					$this->NUM_DOC.'|'.
					$this->DT_DOC.'|'.
					$this->DT_E_S.'|'.
					formata_qtd_sped($this->VL_DOC,2,false).'|'.
					formata_qtd_sped($this->VL_DESC,2,false).'|'.
					formata_qtd_sped($this->VL_FORN,2,false).'|'.
					formata_qtd_sped($this->VL_SERV_NT,2,false).'|'.
					formata_qtd_sped($this->VL_TERC,2,false).'|'.
					formata_qtd_sped($this->VL_DA,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
					$this->COD_INF.'|'.
					formata_qtd_sped($this->VL_PIS,2,false).'|'.
					formata_qtd_sped($this->VL_COFINS,2,false).'|'.
					$this->TP_LIGACAO.'|'.
					$this->COD_GRUPO_TENSAO.'|'.
					$final_2020.
					$final_2022.
					fim_linha();
		}
		
	}

	class SF_Reg_C590 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $VL_ICMS_ST, $VL_RED_BC,
			$COD_OBS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->VL_OPR =  $VL_OPR;
			$this->VL_BC_ICMS =  $VL_BC_ICMS;
			$this->VL_ICMS =  $VL_ICMS;
			$this->VL_BC_ICMS_ST =  $VL_BC_ICMS_ST;
			$this->VL_ICMS_ST =  $VL_ICMS_ST;
			$this->VL_RED_BC =  $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|C590|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C591 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_FCP_OP=0;
		var $VL_FCP_ST=0;

		function SomaRegistro($VL_FCP_OP, $VL_FCP_ST){
			$this->VL_FCP_OP = $this->VL_FCP_OP + $VL_FCP_OP;
			$this->VL_FCP_ST = $this->VL_FCP_ST + $VL_FCP_ST;
		}
		
		function LerRegistro(){
			return '|C591|'.
			formata_qtd_sped($this->VL_FCP_OP,2,false).'|'.
			formata_qtd_sped($this->VL_FCP_ST,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C595 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_OBS;
		var $TXT_COMPL;

		function CriaRegistro($COD_OBS, $TXT_COMPL){
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
		}
		
		function LerRegistro(){
			return '|C595|'.
			$this->COD_OBS.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C597 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_AJ;
		var $DESCR_COMPL_AJ;
		var $COD_ITEM;
		var $VL_BC_ICMS;
		var $ALIQ_ICMS;
		var $VL_ICMS;
		var $VL_OUTROS;

		function CriaRegistro($COD_AJ, $DESCR_COMPL_AJ, $COD_ITEM,
			$VL_BC_ICMS,$ALIQ_ICMS,
			$VL_ICMS,$VL_OUTROS){
			$this->COD_AJ = fill_full(trim(substr(limpa_texto($COD_AJ),0,10)),10);
			$this->DESCR_COMPL_AJ = trim(limpa_texto($DESCR_COMPL_AJ));
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_OUTROS = $VL_OUTROS;
		}
			
		function LerRegistro(){
			return '|C597|'.
			$this->COD_AJ.'|'.
			$this->DESCR_COMPL_AJ.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OUTROS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C800 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE

		var $COD_MOD;
		var $COD_SIT;
		var $NUM_CFE;
		var $DT_DOC;
		var $VL_CFE;
		var $VL_PIS;
		var $VL_COFINS;
		var $CNPJ_CPF;
		var $NR_SAT;
		var $CHV_CFE;
		var $VL_DESC;
		var $VL_MERC;
		var $VL_OUT_DA;
		var $VL_ICMS;
		var $VL_PIS_ST;
		var $VL_COFINS_ST;

		function CriaRegistro($COD_MOD,$COD_SIT,
			$NUM_CFE, $DT_DOC,$VL_CFE,
			$VL_PIS,$VL_COFINS,
			$CNPJ_CPF,$NR_SAT,$CHV_CFE,
			$VL_DESC,$VL_MERC,$VL_OUT_DA,
			$VL_ICMS,$VL_PIS_ST,$VL_COFINS_ST,
			$considera_data=false){
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->NUM_CFE =  trim(substr(limpa_numero($NUM_CFE),-6));
			$this->CHV_CFE = $CHV_CFE;
			$this->NR_SAT  = fill_full(trim(substr(limpa_numero($NR_SAT),0,9)),9);

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if ($this->COD_SIT=='05'){
					$this->CHV_CFE = '';
					$this->NR_SAT = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('/','',$DT_DOC);
				}else{
					$this->DT_DOC = '';
				}
				$this->VL_CFE = '';
				$this->VL_PIS = '';
				$this->VL_COFINS = '';
				$this->CNPJ_CPF = '';

				$this->VL_DESC = '';
				$this->VL_MERC = '';
				$this->VL_OUT_DA = '';
				$this->VL_ICMS = '';
				$this->VL_PIS_ST = '';
				$this->VL_COFINS_ST = '';
			}else{

				$this->DT_DOC = str_replace('/','',$DT_DOC);

				$this->VL_CFE = $VL_CFE;
				$this->VL_PIS = $VL_PIS;
				$this->VL_COFINS = $VL_COFINS;
				$this->CNPJ_CPF = limpa_numero($CNPJ_CPF);
				if (($this->CNPJ_CPF=='00000000000')||
					($this->CNPJ_CPF=='00000000000000')){
					$this->CNPJ_CPF = '';
				}
				$this->VL_DESC = $VL_DESC;
				$this->VL_MERC = $VL_MERC;
				$this->VL_OUT_DA = $VL_OUT_DA;
				$this->VL_ICMS = $VL_ICMS;
				$this->VL_PIS_ST = $VL_PIS_ST;
				$this->VL_COFINS_ST = $VL_COFINS_ST;

			}
		}
		
		function LerRegistro(){
			return '|C800|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->NUM_CFE.'|'.
			$this->DT_DOC.'|'.
			formata_qtd_sped($this->VL_CFE,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->CNPJ_CPF.'|'.
			$this->NR_SAT.'|'.
			$this->CHV_CFE.'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_MERC,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DA,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS_ST,2,false).'|'.
			fim_linha();
		}

	}

	class SF_Reg_C810 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_ITEM;
		var $COD_ITEM;
		var $ID_ITEM;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $CST_ICMS;
		var $CFOP;

		function CriaRegistro($NUM_ITEM, $COD_ITEM, $ID_ITEM, $QTD,
			$UNID, $VL_ITEM, $CST_ICMS, $CFOP, $ORIGEM){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->QTD = $QTD;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;

			$this->CST_ICMS = $CST_ICMS;
			$this->CFOP = limpa_numero($CFOP);
			$ORIGEM = fill_full($ORIGEM,1);
			if (strlen($CST_ICMS)==3){
				$ORIGEM = '';
			}
			$this->CST_ICMS = $ORIGEM.$this->CST_ICMS;
		}
		
		function LerRegistro(){
			return '|C810|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C815 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV;
		var $UNID;
		var $VL_UNIT_CONV;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV;
		var $VL_UNIT_ICMS_OP_CONV;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
		var $VL_UNIT_ICMS_ST_CONV_REST;
		var $VL_UNIT_FCP_ST_CONV_REST;
		var $VL_UNIT_ICMS_ST_CONV_COMPL;
		var $VL_UNIT_FCP_ST_CONV_COMPL;

		function CriaRegistro($COD_MOT_REST_COMPL,$QUANT_CONV,
			$UNID,
			$VL_UNIT_CONV,
			$VL_UNIT_ICMS_NA_OPERACAO_CONV,
			$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_CONV_REST,
			$VL_UNIT_FCP_ST_CONV_REST,
			$VL_UNIT_ICMS_ST_CONV_COMPL,
			$VL_UNIT_FCP_ST_CONV_COMPL ){

			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->QUANT_CONV = $QUANT_CONV;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_UNIT_CONV = $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV = $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV = $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV = $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST = $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST = $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL = $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL = $VL_UNIT_FCP_ST_CONV_COMPL;

		}
		
		function LerRegistro(){
			return '|C815|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C850 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR=0;
		var $VL_BC_ICMS=0;
		var $VL_ICMS=0;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$COD_OBS=''){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}

		function SomaRegistro($VL_OPR, $VL_BC_ICMS, $VL_ICMS){
			$this->VL_OPR = $this->VL_OPR + $VL_OPR;
			$this->VL_BC_ICMS = $this->VL_BC_ICMS + $VL_BC_ICMS;
			//           $this->VL_ICMS = $this->VL_ICMS + $VL_ICMS;
			$this->VL_ICMS = $this->VL_ICMS + $VL_ICMS;
		}

		function LerRegistro(){
			return '|C850|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C860 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD;
		var $NR_SAT;
		var $DT_DOC;
		var $DOC_INI=0;
		var $DOC_FIM=0;

		function CriaRegistro($COD_MOD, $NR_SAT, $DT_DOC, $NR_DOC){
			$this->COD_MOD = trim(substr(limpa_texto($COD_MOD),0,2));
			$this->NR_SAT = fill_full(trim(substr(limpa_texto($NR_SAT),0,9)),9);
			$this->DT_DOC = str_replace('/','',$DT_DOC);

			if ($this->DOC_INI==0){
				$this->DOC_INI=$NR_DOC;
			}
			if ($this->DOC_INI>$NR_DOC){
				$this->DOC_INI=$NR_DOC;
			}
			if ($this->DOC_FIM<$NR_DOC){
				$this->DOC_FIM=$NR_DOC;
			}
		}

		function LerRegistro(){
			return '|C860|'.
			$this->COD_MOD.'|'.
			$this->NR_SAT.'|'.
			$this->DT_DOC.'|'.
			$this->DOC_INI.'|'.
			$this->DOC_FIM.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C870 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $QTD;
		var $UNID;
		var $CFOP;
		var $CST_ICMS;

		function CriaRegistro($COD_ITEM, $UNID, $CFOP, $CST_ICMS ){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
		}

		function SomaRegistro($QTD){
			$this->QTD = $this->QTD + $QTD;
		}

		function LerRegistro(){
			return '|C870|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,6,false).'|'.
			$this->UNID.'|'.
			$this->CFOP.'|'.
			$this->CST_ICMS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C880 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOT_REST_COMPL;
		var $QUANT_CONV=0;
		var $UNID;
		var $VL_UNIT_CONV=0;
		var $VL_UNIT_ICMS_NA_OPERACAO_CONV=0;
		var $VL_UNIT_ICMS_OP_CONV=0;
		var $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV=0;
		var $VL_UNIT_ICMS_ST_CONV_REST=0;
		var $VL_UNIT_FCP_ST_CONV_REST=0;
		var $VL_UNIT_ICMS_ST_CONV_COMPL=0;
		var $VL_UNIT_FCP_ST_CONV_COMPL=0;

		function CriaRegistro($COD_MOT_REST_COMPL,$UNID){
			$this->COD_MOT_REST_COMPL = fill_full(trim(substr(limpa_numero($COD_MOT_REST_COMPL),0,1)),1);
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
		}

		function SomaRegistro($QUANT_CONV,
			$VL_UNIT_CONV,
			$VL_UNIT_ICMS_NA_OPERACAO_CONV,
			$VL_UNIT_ICMS_OP_CONV,
			$VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,
			$VL_UNIT_ICMS_ST_CONV_REST,
			$VL_UNIT_FCP_ST_CONV_REST,
			$VL_UNIT_ICMS_ST_CONV_COMPL,
			$VL_UNIT_FCP_ST_CONV_COMPL){

			$this->QUANT_CONV+= $QUANT_CONV;
			$this->VL_UNIT_CONV+= $VL_UNIT_CONV;
			$this->VL_UNIT_ICMS_NA_OPERACAO_CONV+= $VL_UNIT_ICMS_NA_OPERACAO_CONV;
			$this->VL_UNIT_ICMS_OP_CONV+= $VL_UNIT_ICMS_OP_CONV;
			$this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV+= $VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV;
			$this->VL_UNIT_ICMS_ST_CONV_REST+= $VL_UNIT_ICMS_ST_CONV_REST;
			$this->VL_UNIT_FCP_ST_CONV_REST+= $VL_UNIT_FCP_ST_CONV_REST;
			$this->VL_UNIT_ICMS_ST_CONV_COMPL+= $VL_UNIT_ICMS_ST_CONV_COMPL;
			$this->VL_UNIT_FCP_ST_CONV_COMPL+= $VL_UNIT_FCP_ST_CONV_COMPL;

		}

		function LerRegistro(){
			return '|C880|'.
			$this->COD_MOT_REST_COMPL.'|'.
			formata_qtd_sped($this->QUANT_CONV,6,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_UNIT_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_NA_OPERACAO_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_OP_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_BC_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_ESTOQUE_CONV,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_REST,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_ICMS_ST_CONV_COMPL,6,false).'|'.
			formata_qtd_sped($this->VL_UNIT_FCP_ST_CONV_COMPL,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C890 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR=0;
		var $VL_BC_ICMS=0;
		var $VL_ICMS=0;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$COD_OBS=''){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}

		function SomaRegistro($VL_OPR, $VL_BC_ICMS, $VL_ICMS){
			$this->VL_OPR = $this->VL_OPR + $VL_OPR;
			$this->VL_BC_ICMS = $this->VL_BC_ICMS + $VL_BC_ICMS;
			//           $this->VL_ICMS = $this->VL_ICMS + $VL_ICMS;
			$this->VL_ICMS = arredonda_numero_menos($this->VL_BC_ICMS * $VL_ICMS) /100;
		}

		function LerRegistro(){
			return '|C890|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_D100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $CHV_CTE;
		var $DT_DOC;
		var $DT_A_P;
		var $TP_CTE;
		var $CHV_CTE_REF;
		var $VL_DOC;
		var $VL_DESC;
		var $IND_FRT;
		var $VL_SERV;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_NT;
		var $COD_INF;
		var $COD_CTA;
		var $COD_MUN_ORIG;
		var $COD_MUN_DEST;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$NUM_DOC, $CHV_CTE, $DT_DOC,
			$DT_A_P, $TP_CTE, $CHV_CTE_REF,
			$VL_DOC, $VL_DESC, $IND_FRT, $VL_SERV,
			$VL_BC_ICMS, $VL_ICMS,
			$VL_NT, $COD_INF, $COD_CTA,
			$COD_MUN_ORIG, $COD_MUN_DEST,
			$considera_data=false){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,3));
			$this->SUB = trim(substr(limpa_texto($SUB),0,2));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if ((($this->COD_MOD=='55')||
					($this->COD_MOD=='65')||
					($this->COD_MOD=='57')||
					($this->COD_MOD=='67'))&&
					(data2nr($DT_A_P)>=data2nr('01/01/2011'))&&
					($this->IND_EMIT=='0')){
					$this->CHV_CTE = $CHV_CTE;
				}else{
					$this->CHV_CTE = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('/','',$DT_DOC);
					$this->DT_A_P = str_replace('/','',$DT_A_P);
				}else{
					$this->DT_DOC = '';
					$this->DT_A_P = '';
				}
				$this->TP_CTE = '';
				$this->CHV_CTE_REF = '';
				$this->VL_DOC = '';
				$this->VL_DESC = '';
				$this->IND_FRT = '';

				$this->VL_SERV = '';
				$this->VL_BC_ICMS = '';
				$this->VL_ICMS = '';
				$this->VL_NT = '';

				$this->COD_INF = '';
				$this->COD_CTA = '';

			}else{
				//if (($this->COD_MOD=='57')&&
				//    ($this->IND_EMIT=='0')){
				$this->CHV_CTE = $CHV_CTE;
				//}else{
				//    $this->CHV_CTE = '';
				//}
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->DT_A_P = str_replace('/','',$DT_A_P);

				$this->TP_CTE = fill_full(trim(substr(limpa_numero($TP_CTE),0,1)),1);
				$this->CHV_CTE_REF = trim(substr(limpa_numero($TP_CTE),0,44));
				if (strlen($this->CHV_CTE_REF)!=44){
					$this->CHV_CTE_REF = '';
				}

				$this->VL_DOC = $VL_DOC;
				$this->VL_DESC = $VL_DESC;
				$this->IND_FRT = fill_full(trim(substr(limpa_numero($IND_FRT),0,1)),1);

				if (data2nr($DT_A_P)>=data2nr('01/07/2012')){
					if ($this->IND_FRT=='0'){
						$this->IND_FRT = '2';
					}else if ($this->IND_FRT=='1'){
						$this->IND_FRT = '0';
					}else if ($this->IND_FRT=='2'){
						$this->IND_FRT = '1';
					}
				}

				$this->VL_SERV = $VL_SERV;
				$this->VL_BC_ICMS = $VL_BC_ICMS;
				$this->VL_ICMS = $VL_ICMS;
				$this->VL_NT = $VL_NT;

				$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
				$this->COD_CTA = trim(limpa_texto($COD_CTA));
			}
			$this->COD_MUN_ORIG = $COD_MUN_ORIG;
			$this->COD_MUN_DEST = $COD_MUN_DEST;
		}

		function LerRegistro(){
			$COD_MUN = '';
			if ($this->COD_MUN_ORIG!=''){
				$COD_MUN = $this->COD_MUN_ORIG.'|'.
				$this->COD_MUN_DEST.'|';
			}
			return '|D100|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->CHV_CTE.'|'.
			$this->DT_DOC.'|'.
			$this->DT_A_P.'|'.
			$this->TP_CTE.'|'.
			$this->CHV_CTE_REF.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->IND_FRT.'|'.
			formata_qtd_sped($this->VL_SERV,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_NT,2,false).'|'.
			$this->COD_INF.'|'.
			$this->COD_CTA.'|'.
			$COD_MUN.
			fim_linha();
		}
	}
	class SF_Reg_D101 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_FCP_UF_DEST;
		var $VL_ICMS_UF_DEST;
		var $VL_ICMS_UF_REM;

		function CriaRegistro($VL_FCP_UF_DEST,  $VL_ICMS_UF_DEST, $VL_ICMS_UF_REM){
			$this->VL_FCP_UF_DEST = $VL_FCP_UF_DEST;
			$this->VL_ICMS_UF_DEST = $VL_ICMS_UF_DEST;
			$this->VL_ICMS_UF_REM = $VL_ICMS_UF_REM;
		}

		function LerRegistro(){
			return '|D101|'.
			formata_qtd_sped($this->VL_FCP_UF_DEST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_UF_DEST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_UF_REM,2,false).'|'.
			fim_linha();
		}

	}

	class SF_Reg_D190 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_RED_BC, $COD_OBS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->VL_OPR =  $VL_OPR;
			$this->VL_BC_ICMS =  $VL_BC_ICMS;
			$this->VL_ICMS =  $VL_ICMS;
			$this->VL_RED_BC =  $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|D190|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_D500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_SERV;
		var $VL_SERV_NT;
		var $VL_TERC;
		var $VL_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $COD_INF;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_CTA;
		var $TP_ASSINANTE;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$NUM_DOC, $DT_DOC, $DT_E_S,
			$VL_DOC, $VL_DESC, $VL_SERV,
			$VL_SERV_NT, $VL_TERC, $VL_DA,
			$VL_BC_ICMS, $VL_ICMS,
			$COD_INF, $VL_PIS, $VL_COFINS, $COD_CTA,
			$TP_ASSINANTE){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else{
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->DT_E_S = str_replace('/','',$DT_E_S);
			$this->VL_DOC = $VL_DOC;
			$this->VL_DESC = $VL_DESC;
			$this->VL_SERV = $VL_SERV;
			$this->VL_SERV_NT = $VL_SERV_NT;
			$this->VL_TERC = $VL_TERC;
			$this->VL_DA = $VL_DA;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			if ($this->VL_ICMS<=0){
				$this->VL_BC_ICMS = 0;
			}
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_CTA = trim(limpa_texto($COD_CTA));
			$this->TP_ASSINANTE = substr(fill_full(trim(limpa_numero($TP_ASSINANTE)),2),1,1);
		}
		
		function LerRegistro(){
			return '|D500|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			$this->DT_E_S.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_SERV,2,false).'|'.
			formata_qtd_sped($this->VL_SERV_NT,2,false).'|'.
			formata_qtd_sped($this->VL_TERC,2,false).'|'.
			formata_qtd_sped($this->VL_DA,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_INF.'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->TP_ASSINANTE.'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_D590 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $VL_ICMS_ST, $VL_RED_BC,
			$COD_OBS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->VL_OPR =  $VL_OPR;
			$this->VL_BC_ICMS =  $VL_BC_ICMS;
			$this->VL_ICMS =  $VL_ICMS;
			$this->VL_BC_ICMS_ST =  $VL_BC_ICMS_ST;
			$this->VL_ICMS_ST =  $VL_ICMS_ST;
			$this->VL_RED_BC =  $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|D590|'.
					$this->CST_ICMS.'|'.
					$this->CFOP.'|'.
					formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_OPR,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS,2,false).'|'.
					formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
					formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
					$this->COD_OBS.'|'.
					fim_linha();
		}
		
	}

	class SF_Reg_E100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($DT_INI, $DT_FIN){
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
		}
		
		function LerRegistro(){
			return '|E100|'.
					$this->DT_INI.'|'.
					$this->DT_FIN.'|'.
					fim_linha();
		}
	}

	class SF_Reg_E110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_TOT_DEBITOS=0;
		var $VL_AJ_DEBITOS=0;
		var $VL_TOT_AJ_DEBITOS=0;
		var $VL_ESTORNOS_CRED=0;
		var $VL_TOT_CREDITOS=0;
		var $VL_AJ_CREDITOS=0;
		var $VL_TOT_AJ_CREDITOS=0;
		var $VL_ESTORNOS_DEB=0;
		var $VL_SLD_CREDOR_ANT=0;
		var $VL_SLD_APURADO=0;
		var $VL_TOT_DED=0;
		var $VL_ICMS_RECOLHER=0;
		var $VL_SLD_CREDOR_TRANSPORTAR=0;
		var $DEB_ESP=0;

		function SomaRegistro($VL_TOT_DEBITOS, $VL_AJ_DEBITOS,
								$VL_TOT_AJ_DEBITOS, $VL_ESTORNOS_CRED,
								$VL_TOT_CREDITOS, $VL_AJ_CREDITOS,
								$VL_TOT_AJ_CREDITOS, $VL_ESTORNOS_DEB,
								$VL_SLD_CREDOR_ANT, $VL_TOT_DED, $DEB_ESP){
			$this->VL_TOT_DEBITOS =  $this->VL_TOT_DEBITOS + $VL_TOT_DEBITOS;
			$this->VL_AJ_DEBITOS =  $this->VL_AJ_DEBITOS + $VL_AJ_DEBITOS;
			$this->VL_TOT_AJ_DEBITOS = $this->VL_TOT_AJ_DEBITOS + $VL_TOT_AJ_DEBITOS;
			$this->VL_ESTORNOS_CRED = $this->VL_ESTORNOS_CRED + $VL_ESTORNOS_CRED;
			$this->VL_TOT_CREDITOS = $this->VL_TOT_CREDITOS + $VL_TOT_CREDITOS;
			$this->VL_AJ_CREDITOS = $this->VL_AJ_CREDITOS + $VL_AJ_CREDITOS;
			$this->VL_TOT_AJ_CREDITOS = $this->VL_TOT_AJ_CREDITOS + $VL_TOT_AJ_CREDITOS;
			$this->VL_ESTORNOS_DEB = $this->VL_ESTORNOS_DEB + $VL_ESTORNOS_DEB;
			$this->VL_SLD_CREDOR_ANT = $this->VL_SLD_CREDOR_ANT + $VL_SLD_CREDOR_ANT;
			$this->VL_TOT_DED = $this->VL_TOT_DED + $VL_TOT_DED;
			$this->DEB_ESP = $this->DEB_ESP + $DEB_ESP;

			$this->VL_SLD_APURADO = ($this->VL_TOT_DEBITOS + $this->VL_TOT_AJ_DEBITOS) -
			($this->VL_TOT_CREDITOS +
			$this->VL_ESTORNOS_DEB +
			$this->VL_AJ_CREDITOS+
			$this->VL_TOT_AJ_CREDITOS+
			$this->VL_SLD_CREDOR_ANT);
			$this->VL_SLD_CREDOR_TRANSPORTAR = 0;
			if ($this->VL_SLD_APURADO < 0){
				$this->VL_SLD_CREDOR_TRANSPORTAR = $this->VL_SLD_APURADO * (-1);
				$this->VL_SLD_APURADO = 0;
			}
			$this->VL_ICMS_RECOLHER = $this->VL_SLD_APURADO;
		}

		function LerRegistro(){
			return '|E110|'.
					formata_qtd_sped($this->VL_TOT_DEBITOS,2,false).'|'.
					formata_qtd_sped($this->VL_AJ_DEBITOS,2,false).'|'.
					formata_qtd_sped($this->VL_TOT_AJ_DEBITOS,2,false).'|'.
					formata_qtd_sped($this->VL_ESTORNOS_CRED,2,false).'|'.
					formata_qtd_sped($this->VL_TOT_CREDITOS,2,false).'|'.
					formata_qtd_sped($this->VL_AJ_CREDITOS,2,false).'|'.
					formata_qtd_sped($this->VL_TOT_AJ_CREDITOS,2,false).'|'.
					formata_qtd_sped($this->VL_ESTORNOS_DEB,2,false).'|'.
					formata_qtd_sped($this->VL_SLD_CREDOR_ANT,2,false).'|'.
					formata_qtd_sped($this->VL_SLD_APURADO,2,false).'|'.
					formata_qtd_sped($this->VL_TOT_DED,2,false).'|'.
					formata_qtd_sped($this->VL_ICMS_RECOLHER,2,false).'|'.
					formata_qtd_sped($this->VL_SLD_CREDOR_TRANSPORTAR,2,false).'|'.
					formata_qtd_sped($this->DEB_ESP,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_E111 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_AJ_APUR;
		var $DESCR_COMPL_AJ;
		var $VL_AJ_APUR;

		function CriaRegistro(	$COD_AJ_APUR,
								$DESCR_COMPL_AJ,
								$VL_AJ_APUR){
			$this->COD_AJ_APUR = fill_full(trim(substr(limpa_texto($COD_AJ_APUR),0,8)),8);
			$this->DESCR_COMPL_AJ = trim(limpa_texto($DESCR_COMPL_AJ));
			$this->VL_AJ_APUR =  $VL_AJ_APUR;
		}
		
		function LerRegistro(){
			return '|E111|'.
					$this->COD_AJ_APUR.'|'.
					$this->DESCR_COMPL_AJ.'|'.
					formata_qtd_sped($this->VL_AJ_APUR,2,false).'|'.
					fim_linha();
		}
	}
	
	class SF_Reg_E112 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_DA;
		var $NUM_PROC;
		var $IND_PROC;
		var $PROC;
		var $TXT_COMPL;

		function CriaRegistro($NUM_DA, 
							  $NUM_PROC,
							  $IND_PROC,
							  $PROC,
							  $TXT_COMPL){
			$this->NUM_DA = trim(limpa_texto($NUM_DA));
			$this->NUM_PROC = fill_full(trim(substr(limpa_texto($NUM_PROC),0,4)),4);
			$this->IND_PROC = $IND_PROC;
			$this->PROC = trim(limpa_texto($PROC));
			$this->TXT_COMPL =  trim(limpa_texto($TXT_COMPL));
		}
		function LerRegistro(){
			return '|E112|'.
					$this->NUM_DA.'|'.
					$this->NUM_PROC.'|'.
					$this->IND_PROC.'|'.
					$this->PROC.'|'.
					$this->TXT_COMPL.'|'.
					fim_linha();
		}
	}

	class SF_Reg_E113 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $DT_DOC;
		var $COD_ITEM;
		var $VL_AJ_ITEM;

		function CriaRegistro($COD_PART, $COD_MOD, $SER,
								$SUB, $NUM_DOC, $DT_DOC,
								$COD_ITEM, $VL_AJ_ITEM){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->VL_AJ_ITEM = $VL_AJ_ITEM;
		}
		
		function LerRegistro(){
			return '|E113|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->SER.'|'.
					$this->SUB.'|'.
					$this->NUM_DOC.'|'.
					$this->DT_DOC.'|'.
					$this->COD_ITEM.'|'.
					formata_qtd_sped($this->VL_AJ_ITEM,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_E115 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_INF_ADIC;
		var $VL_INF_ADIC;
		var $DESCR_COMPL_AJ;

		function CriaRegistro($COD_INF_ADIC, 
								$VL_INF_ADIC,
								$DESCR_COMPL_AJ){
			$this->COD_INF_ADIC = fill_full(trim(substr(limpa_texto($COD_INF_ADIC),0,8)),8);
			$this->VL_INF_ADIC =  $VL_INF_ADIC;
			$this->DESCR_COMPL_AJ = trim(limpa_texto($DESCR_COMPL_AJ));
		}
		
		function LerRegistro(){
			return '|E115|'.
					$this->COD_INF_ADIC.'|'.
					formata_qtd_sped($this->VL_INF_ADIC,2,false).'|'.
					$this->DESCR_COMPL_AJ.'|'.
					fim_linha();
		}
			
	}

	class SF_Reg_E116 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_OR;
		var $VL_OR;
		var $DT_VCTO;
		var $COD_REC;
		var $NUM_PROC;
		var $IND_PROC;
		var $PROC;
		var $TXT_COMPL;
		var $MES_REF;

		function CriaRegistro($COD_OR, $VL_OR, $DT_VCTO,
			$COD_REC, $NUM_PROC, $IND_PROC,
			$PROC, $TXT_COMPL, $MES_REF){
			$this->COD_OR = fill_full(trim(substr(limpa_texto($COD_OR),0,3)),3);
			$this->VL_OR = $VL_OR;
			$this->DT_VCTO = str_replace('/','',$DT_VCTO);
			$this->COD_REC = trim(limpa_texto($COD_REC));
			$this->NUM_PROC = trim(substr(limpa_texto($NUM_PROC),0,15));
			$this->IND_PROC = $IND_PROC;

			$this->PROC = trim(limpa_texto($PROC));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));

			if (data2nr($MES_REF)>=data2nr('01/01/2011')){
				$this->MES_REF = str_replace('/','',substr($MES_REF,3,7));
			}else{
				$this->MES_REF = '';
			}
		}
		
		function LerRegistro(){

			if ($this->MES_REF==''){
				return '|E116|'.
						$this->COD_OR.'|'.
						formata_qtd_sped($this->VL_OR,2,false).'|'.
						$this->DT_VCTO.'|'.
						$this->COD_REC.'|'.
						$this->NUM_PROC.'|'.
						$this->IND_PROC.'|'.
						$this->PROC.'|'.
						$this->TXT_COMPL.'|'.
						fim_linha();
			}else{
				return '|E116|'.
						$this->COD_OR.'|'.
						formata_qtd_sped($this->VL_OR,2,false).'|'.
						$this->DT_VCTO.'|'.
						$this->COD_REC.'|'.
						$this->NUM_PROC.'|'.
						$this->IND_PROC.'|'.
						$this->PROC.'|'.
						$this->TXT_COMPL.'|'.
						$this->MES_REF.'|'.
						fim_linha();
			}
		}
	}
	
	class SF_Reg_E200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $UF;
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($UF, $DT_INI, $DT_FIN){
			$this->UF = trim(substr(limpa_texto($UF),0,2));
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
		}
		
		function LerRegistro(){
			return '|E200|'.
			$this->UF.'|'.
			$this->DT_INI.'|'.
			$this->DT_FIN.'|'.
			fim_linha();
		}
	}

	class SF_Reg_E210 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_MOV_ST=0;
		var $VL_SLD_CRED_ANT_ST=0;
		var $VL_DEVOL_ST=0;
		var $VL_RESSARC_ST=0;
		var $VL_OUT_CRED_ST=0;
		var $VL_AJ_CREDITOS_ST=0;
		var $VL_RETENCAO_ST=0;
		var $VL_OUT_DEB_ST=0;
		var $VL_ESTORNOS_DEB=0;
		var $VL_AJ_DEBITOS_ST=0;
		var $VL_SLD_DEV_ANT_ST=0;
		var $VL_DEDUCOES_ST=0;
		var $VL_ICMS_RECOL_ST=0;
		var $VL_SLD_CRED_ST_TRAN=0;
		var $DEB_ESP_ST=0;

		function SomaRegistro($VL_SLD_CRED_ANT_ST,
			$VL_DEVOL_ST, $VL_RESSARC_ST,
			$VL_OUT_CRED_ST, $VL_AJ_CREDITOS_ST,
			$VL_RETENCAO_ST, $VL_OUT_DEB_ST,
			$VL_ESTORNOS_DEB, $VL_AJ_DEBITOS_ST,
			$VL_DEDUCOES_ST, $DEB_ESP_ST){
			$this->IND_MOV_ST = 1;
			$this->VL_SLD_CRED_ANT_ST = $this->VL_SLD_CRED_ANT_ST + $VL_SLD_CRED_ANT_ST;
			$this->VL_DEVOL_ST = $this->VL_DEVOL_ST + $VL_DEVOL_ST;
			$this->VL_RESSARC_ST = $this->VL_RESSARC_ST +  $VL_RESSARC_ST;
			$this->VL_OUT_CRED_ST = $this->VL_OUT_CRED_ST + $VL_OUT_CRED_ST;
			$this->VL_AJ_CREDITOS_ST = $this->VL_AJ_CREDITOS_ST + $VL_AJ_CREDITOS_ST;
			$this->VL_RETENCAO_ST = $this->VL_RETENCAO_ST + $VL_RETENCAO_ST;
			$this->VL_OUT_DEB_ST = $this->VL_OUT_DEB_ST + $VL_OUT_DEB_ST;
			$this->VL_AJ_DEBITOS_ST = $this->VL_AJ_DEBITOS_ST + $VL_AJ_DEBITOS_ST;

			$this->DEB_ESP_ST = $this->DEB_ESP_ST + $DEB_ESP_ST;
			$this->VL_DEDUCOES_ST = $this->VL_DEDUCOES_ST + $VL_DEDUCOES_ST;

			$this->VL_SLD_DEV_ANT_ST =  ($this->VL_RETENCAO_ST +
			$this->VL_OUT_DEB_ST+
			$this->VL_AJ_DEBITOS_ST)
			-
			($this->VL_SLD_CRED_ANT_ST+
			$this->VL_DEVOL_ST+
			$this->VL_RESSARC_ST+
			$this->VL_OUT_CRED_ST+
			$this->VL_AJ_CREDITOS_ST);
			$this->VL_SLD_CRED_ST_TRAN = 0;
			if ($this->VL_SLD_DEV_ANT_ST < 0){
				$this->VL_SLD_CRED_ST_TRAN = $this->VL_SLD_DEV_ANT_ST * (-1);
				$this->VL_SLD_DEV_ANT_ST = 0;
			}
			$this->VL_ICMS_RECOL_ST = $this->VL_SLD_DEV_ANT_ST;
		}
		
		function LerRegistro(){
			return '|E210|'.
			$this->IND_MOV_ST.'|'.
			formata_qtd_sped($this->VL_SLD_CRED_ANT_ST,2,false).'|'.
			formata_qtd_sped($this->VL_DEVOL_ST,2,false).'|'.
			formata_qtd_sped($this->VL_RESSARC_ST,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_CRED_ST,2,false).'|'.
			formata_qtd_sped($this->VL_AJ_CREDITOS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_RETENCAO_ST,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DEB_ST,2,false).'|'.
			formata_qtd_sped($this->VL_AJ_DEBITOS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_SLD_DEV_ANT_ST,2,false).'|'.
			formata_qtd_sped($this->VL_DEDUCOES_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_RECOL_ST,2,false).'|'.
			formata_qtd_sped($this->VL_SLD_CRED_ST_TRAN,2,false).'|'.
			formata_qtd_sped($this->DEB_ESP_ST,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_E220 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_AJ_APUR;
		var $DESCR_COMPL_AJ;
		var $VL_AJ_APUR;

		function CriaRegistro($COD_AJ_APUR, $DESCR_COMPL_AJ,
			$VL_AJ_APUR){
			$this->COD_AJ_APUR = fill_full(trim(substr(limpa_texto($COD_AJ_APUR),0,8)),8);
			$this->DESCR_COMPL_AJ = trim(limpa_texto($DESCR_COMPL_AJ));
			$this->VL_AJ_APUR =  $VL_AJ_APUR;
		}
		
		function LerRegistro(){
			return '|E220|'.
			$this->COD_AJ_APUR.'|'.
			$this->DESCR_COMPL_AJ.'|'.
			formata_qtd_sped($this->VL_AJ_APUR,2,false).'|'.
			fim_linha();
		}
	}
			
	class SF_Reg_E230 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_DA;
		var $NUM_PROC;
		var $IND_PROC;
		var $PROC;
		var $TXT_COMPL;

		function CriaRegistro($NUM_DA, $NUM_PROC,
			$IND_PROC, $PROC,
			$TXT_COMPL){
			$this->NUM_DA = trim(limpa_texto($NUM_DA));
			$this->NUM_PROC = fill_full(trim(substr(limpa_texto($NUM_PROC),0,4)),4);
			$this->IND_PROC = $IND_PROC;
			$this->PROC = trim(limpa_texto($PROC));
			$this->TXT_COMPL =  trim(limpa_texto($TXT_COMPL));
		}
		
		function LerRegistro(){
			return '|E230|'.
			$this->NUM_DA.'|'.
			$this->NUM_PROC.'|'.
			$this->IND_PROC.'|'.
			$this->PROC.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_E240 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $DT_DOC;
		var $COD_ITEM;
		var $VL_AJ_ITEM;

		function CriaRegistro(	$COD_PART, $COD_MOD, $SER,
								$SUB, $NUM_DOC, $DT_DOC,
								$COD_ITEM, $VL_AJ_ITEM){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->VL_AJ_ITEM = $VL_AJ_ITEM;
		}
			
		function LerRegistro(){
			return '|E240|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->SER.'|'.
					$this->SUB.'|'.
					$this->NUM_DOC.'|'.
					$this->DT_DOC.'|'.
					$this->COD_ITEM.'|'.
					formata_qtd_sped($this->VL_AJ_ITEM,2,false).'|'.
					fim_linha();
		}
	}
	
	class SF_Reg_E250 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_OR;
		var $VL_OR;
		var $DT_VCTO;
		var $COD_REC;
		var $NUM_PROC;
		var $IND_PROC;
		var $PROC;
		var $TXT_COMPL;
		var $MES_REF;

		function CriaRegistro($COD_OR, $VL_OR, $DT_VCTO,
			$COD_REC, $NUM_PROC, $IND_PROC,
			$PROC, $TXT_COMPL, $MES_REF){
			$this->COD_OR = fill_full(trim(substr(limpa_texto($COD_OR),0,3)),3);
			$this->VL_OR = $VL_OR;
			$this->DT_VCTO = str_replace('/','',$DT_VCTO);
			$this->COD_REC = trim(limpa_texto($COD_REC));
			$this->NUM_PROC = trim(substr(limpa_texto($NUM_PROC),0,15));
			$this->IND_PROC = $IND_PROC;

			$this->PROC = trim(limpa_texto($PROC));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));

			if (data2nr($MES_REF)>=data2nr('01/01/2011')){
				$this->MES_REF = str_replace('/','',substr($MES_REF,3,7));
			}else{
				$this->MES_REF = '';
			}
		}
		
		function LerRegistro(){
			if ($this->MES_REF==''){
				return '|E250|'.
						$this->COD_OR.'|'.
						formata_qtd_sped($this->VL_OR,2,false).'|'.
						$this->DT_VCTO.'|'.
						$this->COD_REC.'|'.
						$this->NUM_PROC.'|'.
						$this->IND_PROC.'|'.
						$this->PROC.'|'.
						$this->TXT_COMPL.'|'.
						fim_linha();
			}else{
				return '|E250|'.
						$this->COD_OR.'|'.
						formata_qtd_sped($this->VL_OR,2,false).'|'.
						$this->DT_VCTO.'|'.
						$this->COD_REC.'|'.
						$this->NUM_PROC.'|'.
						$this->IND_PROC.'|'.
						$this->PROC.'|'.
						$this->TXT_COMPL.'|'.
						$this->MES_REF.'|'.
						fim_linha();
			}
		}
	}
	
	class SF_Reg_E300 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $UF;
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($UF, $DT_INI, $DT_FIN){
			$this->UF = trim(substr(limpa_texto($UF),0,2));
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
		}
		
		function LerRegistro(){
			return '|E300|'.
			$this->UF.'|'.
			$this->DT_INI.'|'.
			$this->DT_FIN.'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_E310 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_MOV_DIFAL=0;
		var $VL_SLD_CRED_ANT_DIFAL=0;
		var $VL_TOT_DEBITOS_DIFAL=0;
		var $VL_OUT_DEB_DIFAL=0;
		var $VL_TOT_CREDITOS_DIFAL=0;
		var $VL_OUT_CRED_DIFAL=0;
		var $VL_SLD_DEV_ANT_DIFAL=0;
		var $VL_DEDUCOES_DIFAL=0;
		var $VL_RECOL=0;
		var $VL_SLD_CRED_TRANSP=0;
		var $DEB_ESP_DIFAL=0;

		var $VL_SLD_CRED_ANT_FCP = 0;
		var $VL_TOT_DEB_FCP = 0;
		var $VL_OUT_DEB_FCP = 0;
		var $VL_TOT_CRED_FCP = 0;
		var $VL_OUT_CRED_FCP = 0;
		var $VL_SLD_DEV_ANT_FCP = 0;
		var $VL_DEDUCOES_FCP = 0;
		var $VL_RECOL_FCP = 0;
		var $VL_SLD_CRED_TRANSPORTAR_FCP = 0;
		var $DEB_ESP_FCP = 0;

		function SomaRegistro($VL_SLD_CRED_ANT_DIFAL,
			$VL_TOT_DEBITOS_DIFAL,$VL_OUT_DEB_DIFAL,$VL_TOT_DEB_FCP,
			$VL_TOT_CREDITOS_DIFAL,$VL_TOT_CRED_FCP,$VL_OUT_CRED_DIFAL,
			$VL_SLD_DEV_ANT_DIFAL,$VL_DEDUCOES_DIFAL,$DEB_ESP_DIFAL){
			$this->IND_MOV_DIFAL = 1;

			$this->VL_SLD_CRED_ANT_DIFAL= $this->VL_SLD_CRED_ANT_DIFAL + $VL_SLD_CRED_ANT_DIFAL;
			$this->VL_TOT_DEBITOS_DIFAL = $this->VL_TOT_DEBITOS_DIFAL + $VL_TOT_DEBITOS_DIFAL;
			$this->VL_OUT_DEB_DIFAL = $this->VL_OUT_DEB_DIFAL + $VL_OUT_DEB_DIFAL;
			$this->VL_TOT_DEB_FCP = $this->VL_TOT_DEB_FCP +  $VL_TOT_DEB_FCP;
			$this->VL_TOT_CREDITOS_DIFAL = $this->VL_TOT_CREDITOS_DIFAL + $VL_TOT_CREDITOS_DIFAL;
			$this->VL_TOT_CRED_FCP = $this->VL_TOT_CRED_FCP + $VL_TOT_CRED_FCP;
			$this->VL_OUT_CRED_DIFAL = $this->VL_OUT_CRED_DIFAL + $VL_OUT_CRED_DIFAL;

			$this->VL_DEDUCOES_DIFAL = $this->VL_DEDUCOES_DIFAL + $VL_DEDUCOES_DIFAL;
			$this->DEB_ESP_DIFAL = $this->DEB_ESP_DIFAL + $DEB_ESP_DIFAL;

			$this->VL_SLD_DEV_ANT_DIFAL = ($this->VL_TOT_DEBITOS_DIFAL +
											$this->VL_OUT_DEB_DIFAL)//+
											//$this->VL_TOT_DEB_FCP)
											-
											($this->VL_SLD_CRED_ANT_DIFAL+
											$this->VL_TOT_CREDITOS_DIFAL+
											//$this->VL_TOT_CRED_FCP+
											$this->VL_OUT_CRED_DIFAL+
											$this->VL_DEDUCOES_DIFAL);


			$this->VL_SLD_CRED_TRANSP = 0;
			if ($this->VL_SLD_DEV_ANT_DIFAL < 0){
				$this->VL_SLD_CRED_TRANSP = $this->VL_SLD_DEV_ANT_DIFAL * (-1);
				$this->VL_SLD_DEV_ANT_DIFAL = 0;
			}
			$this->VL_RECOL = $this->VL_SLD_DEV_ANT_DIFAL;

			$this->VL_SLD_DEV_ANT_FCP = ($this->VL_TOT_DEB_FCP +
										$this->VL_OUT_DEB_FCP)
										-
										($this->VL_SLD_CRED_ANT_FCP+
										$this->VL_TOT_CRED_FCP+
										$this->VL_OUT_CRED_FCP+
										$this->VL_DEDUCOES_FCP);


			$this->VL_SLD_CRED_TRANSPORTAR_FCP = 0;
			if ($this->VL_SLD_DEV_ANT_FCP < 0){
				$this->VL_SLD_CRED_TRANSPORTAR_FCP = $this->VL_SLD_DEV_ANT_FCP * (-1);
				$this->VL_SLD_DEV_ANT_FCP = 0;
			}
			$this->VL_RECOL_FCP = $this->VL_SLD_DEV_ANT_FCP;
		}

		function LerRegistro(){
			//if (data2nr($MES_REF)>=data2nr('01/10/2017')){
			return '|E310|'.                                                    //1
			$this->IND_MOV_DIFAL.'|'.                                      //2
			formata_qtd_sped($this->VL_SLD_CRED_ANT_DIFAL,2,false).'|'.    //3
			formata_qtd_sped($this->VL_TOT_DEBITOS_DIFAL,2,false).'|'.     //4
			formata_qtd_sped($this->VL_OUT_DEB_DIFAL,2,false).'|'.         //5
			formata_qtd_sped($this->VL_TOT_CREDITOS_DIFAL,2,false).'|'.    //6
			formata_qtd_sped($this->VL_OUT_CRED_DIFAL,2,false).'|'.        //7
			formata_qtd_sped($this->VL_SLD_DEV_ANT_DIFAL,2,false).'|'.     //8
			formata_qtd_sped($this->VL_DEDUCOES_DIFAL,2,false).'|'.        //9
			formata_qtd_sped($this->VL_RECOL,2,false).'|'.                 //10
			formata_qtd_sped($this->VL_SLD_CRED_TRANSP,2,false).'|'.       //11
			formata_qtd_sped($this->DEB_ESP_DIFAL,2,false).'|'.            //12
			formata_qtd_sped($this->VL_SLD_CRED_ANT_FCP,2,false).'|'.      //13
			formata_qtd_sped($this->VL_TOT_DEB_FCP,2,false).'|'.           //14
			formata_qtd_sped($this->VL_OUT_DEB_FCP,2,false).'|'.           //15
			formata_qtd_sped($this->VL_TOT_CRED_FCP,2,false).'|'.          //16
			formata_qtd_sped($this->VL_OUT_CRED_FCP,2,false).'|'.          //17
			formata_qtd_sped($this->VL_SLD_DEV_ANT_FCP,2,false).'|'.     //18
			formata_qtd_sped($this->VL_DEDUCOES_FCP,2,false).'|'.          //19
			formata_qtd_sped($this->VL_RECOL_FCP,2,false).'|'.             //20
			formata_qtd_sped($this->VL_SLD_CRED_TRANSPORTAR_FCP,2,false).'|'.//21
			formata_qtd_sped($this->DEB_ESP_FCP,2,false).'|'.              //22
			fim_linha();
			/*}else{
			return '|E310|'.
			$this->IND_MOV_DIFAL.'|'.
			formata_qtd_sped($this->VL_SLD_CRED_ANT_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_DEBITOS_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DEB_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_DEB_FCP,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CREDITOS_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CRED_FCP,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_CRED_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_SLD_DEV_ANT_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_DEDUCOES_DIFAL,2,false).'|'.
			formata_qtd_sped($this->VL_RECOL,2,false).'|'.
			formata_qtd_sped($this->VL_SLD_CRED_TRANSP,2,false).'|'.
			formata_qtd_sped($this->DEB_ESP_DIFAL,2,false).'|'.
			fim_linha();
			}*/
		}
	}


	class SF_Reg_E316 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_OR='';
		var $VL_OR=0;
		var $DT_VCTO='';
		var $COD_REC='';
		var $NUM_PROC='';
		var $IND_PROC='';
		var $PROC='';
		var $TXT_COMPL='';
		var $MES_REF='';

		function SomaRegistro($COD_OR,
			$VL_OR,$DT_VCTO,$COD_REC,$MES_REF){
			$this->COD_OR = $COD_OR;
			$this->VL_OR= $this->VL_OR + $VL_OR;
			$this->DT_VCTO = str_replace('/','',$DT_VCTO);
			$this->COD_REC = $COD_REC;
			if (data2nr($MES_REF)>=data2nr('01/01/2011')){
				$this->MES_REF = str_replace('/','',substr($MES_REF,3,7));
			}else{
				$this->MES_REF = '';
			}

		}

		function LerRegistro(){
			return '|E316|'.
			$this->COD_OR.'|'.
			formata_qtd_sped($this->VL_OR,2,false).'|'.
			$this->DT_VCTO.'|'.
			$this->COD_REC.'|'.
			$this->NUM_PROC.'|'.
			$this->IND_PROC.'|'.
			$this->PROC.'|'.
			$this->TXT_COMPL.'|'.
			$this->MES_REF.'|'.
			fim_linha();
		}
	}

	class SF_Reg_E500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_APUR;
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($IND_APUR, $DT_INI, $DT_FIN){
			$this->IND_APUR = fill_full(trim(substr(limpa_texto($IND_APUR),0,1)),1);
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
		}
		function LerRegistro(){
			return '|E500|'.
			$this->IND_APUR.'|'.
			$this->DT_INI.'|'.
			$this->DT_FIN.'|'.
			fim_linha();
		}
	}

	class SF_Reg_E510 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CFOP;
		var $CST_IPI;
		var $VL_CONT_IPI;
		var $VL_BC_IPI;
		var $VL_IPI;

		function CriaRegistro($CFOP, $CST_IPI, $VL_CONT_IPI,
			$VL_BC_IPI, $VL_IPI){
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
			$this->CST_IPI = fill_full(trim(substr(limpa_numero($CST_IPI),0,2)),2);

			$this->VL_CONT_IPI =  $VL_CONT_IPI;
			$this->VL_BC_IPI =  $VL_BC_IPI;
			$this->VL_IPI =  $VL_IPI;
		}
			
		function LerRegistro(){
			return '|E510|'.
			$this->CFOP.'|'.
			$this->CST_IPI.'|'.
			formata_qtd_sped($this->VL_CONT_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_BC_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_IPI,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_E520 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_SD_ANT_IPI;
		var $VL_DEB_IPI;
		var $VL_CRED_IPI;
		var $VL_OD_IPI;
		var $VL_OC_IPI;
		var $VL_SC_IPI;
		var $VL_SD_IPI;

		function CriaRegistro($VL_SD_ANT_IPI, $VL_DEB_IPI,
			$VL_CRED_IPI, $VL_OD_IPI,
			$VL_OC_IPI, $VL_SC_IPI,
			$VL_SD_IPI){
			$this->VL_SD_ANT_IPI =  $VL_SD_ANT_IPI;
			$this->VL_DEB_IPI =  $VL_DEB_IPI;
			$this->VL_CRED_IPI =  $VL_CRED_IPI;
			$this->VL_OD_IPI =  $VL_OD_IPI;
			$this->VL_OC_IPI =  $VL_OC_IPI;
			$this->VL_SC_IPI =  $VL_SC_IPI;
			$this->VL_SD_IPI =  $VL_SD_IPI;
		}
		
		function LerRegistro(){
			return '|E520|'.
			formata_qtd_sped($this->VL_SD_ANT_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_DEB_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_CRED_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_OD_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_OC_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_SC_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_SD_IPI,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_TP_LEIAUTE;

		function CriaRegistro($IND_TP_LEIAUTE){
			$this->IND_TP_LEIAUTE = $IND_TP_LEIAUTE;
		}

		function LerRegistro(){
			return '|K010|'.
			$this->IND_TP_LEIAUTE.'|'.
			fim_linha();
		}
	}

	class SF_Reg_K100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_INI;
		var $DT_FIN;

		function CriaRegistro($DT_INI, $DT_FIN){
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);

		}
			
		function LerRegistro(){
			return '|K100|'.
			$this->DT_INI.'|'.
			$this->DT_FIN.'|'.
			fim_linha();
		}
	}

	class SF_Reg_K200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_EST ;
		var $COD_ITEM;
		var $QTD;
		var $IND_EST;
		var $COD_PART;

		function CriaRegistro($DT_EST, $COD_ITEM, $QTD, $IND_EST, $COD_PART){
			$this->DT_EST  = str_replace('/','',$DT_EST);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->IND_EST = $IND_EST;
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
		}
		
		function LerRegistro(){
			return '|K200|'.
			$this->DT_EST.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			$this->IND_EST.'|'.
			$this->COD_PART.'|'.
			fim_linha();
		}
	}

	class SF_Reg_K210 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_INI_OS;
		var $DT_FIN_OS;
		var $COD_DOC_OS;
		var $COD_ITEM_ORI;
		var $QTD_ORI;

		function CriaRegistro($DT_INI_OS, $DT_FIN_OS, $COD_DOC_OS, $COD_ITEM_ORI, $QTD_ORI){
			$this->DT_INI_OS   = str_replace('/','',$DT_INI_OS);
			$this->DT_FIN_OS   = str_replace('/','',$DT_FIN_OS);
			$this->COD_DOC_OS  = trim(substr(limpa_texto($COD_DOC_OS),0,30));
			$this->COD_ITEM_ORI = trim(substr(limpa_texto($COD_ITEM_ORI),0,60));
			$this->QTD_ORI = $QTD_ORI;
		}
		
		function LerRegistro(){
			return '|K210|'.
			$this->DT_INI_OS.'|'.
			$this->DT_FIN_OS.'|'.
			$this->COD_DOC_OS.'|'.
			$this->COD_ITEM_ORI.'|'.
			formata_qtd_sped($this->QTD_ORI,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K215 extends SPED_Registro_Base{
		var $COD_ITEM_DES;
		var $QTD_DES;

		function CriaRegistro($COD_ITEM_DES, $QTD_DES){
			$this->COD_ITEM_DES = trim(substr(limpa_texto($COD_ITEM_DES),0,60));
			$this->QTD_DES = $QTD_DES ;
		}
		
		function LerRegistro(){
			return '|K215|'.
			$this->COD_ITEM_DES.'|'.
			formata_qtd_sped($this->QTD_DES,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K220 extends SPED_Registro_Base{
		var $DT_MOV;
		var $COD_ITEM_ORI;
		var $COD_ITEM_DES;
		var $QTD_ORI;
		var $QTD_DES;

		function CriaRegistro($DT_MOV, $COD_ITEM_ORI, $COD_ITEM_DES, $QTD_ORI, $QTD_DES){
			$this->DT_MOV = str_replace('/','',$DT_MOV);
			$this->COD_ITEM_ORI = trim(substr(limpa_texto($COD_ITEM_ORI),0,60));
			$this->COD_ITEM_DES = trim(substr(limpa_texto($COD_ITEM_DES),0,60));
			$this->QTD_ORI = $QTD_ORI;
			$this->QTD_DES = $QTD_DES;
		}
		
		function LerRegistro(){
			return '|K220|'.
			$this->DT_MOV.'|'.
			$this->COD_ITEM_ORI.'|'.
			$this->COD_ITEM_DES.'|'.
			formata_qtd_sped($this->QTD_ORI,6,false).'|'.
			formata_qtd_sped($this->QTD_DES,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K230 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_INI_OP;
		var $DT_FIN_OP;
		var $COD_DOC_OP;
		var $COD_ITEM;
		var $QTD_ENC;

		function CriaRegistro($DT_INI_OP, $DT_FIN_OP, $COD_DOC_OP, $COD_ITEM, $QTD_ENC){
			$this->DT_INI_OP   = str_replace('/','',$DT_INI_OP);
			$this->DT_FIN_OP  = str_replace('/','',$DT_FIN_OP);
			$this->COD_DOC_OP  = trim(substr(limpa_texto($COD_DOC_OP),0,30));
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->QTD_ENC = $QTD_ENC;
		}
		function LerRegistro(){
			return '|K230|'.
			$this->DT_INI_OP.'|'.
			$this->DT_FIN_OP.'|'.
			$this->COD_DOC_OP.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD_ENC,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K235 extends SPED_Registro_Base{
		var $DT_SAIDA;
		var $COD_ITEM;
		var $QTD;
		var $COD_INS_SUBST;

		function CriaRegistro($DT_SAIDA, $COD_ITEM, $QTD, $COD_INS_SUBST){
			$this->DT_SAIDA = str_replace('/','',$DT_SAIDA);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->COD_INS_SUBST = trim(substr(limpa_texto($COD_INS_SUBST),0,60));
		}
		
		function LerRegistro(){
			return '|K235|'.
			$this->DT_SAIDA.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,6,false).'|'.
			$this->COD_INS_SUBST.'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_K250 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_PROD;
		var $COD_ITEM;
		var $QTD_ENC=0;

		function CriaRegistro($DT_PROD, $COD_ITEM){
			$this->DT_PROD   = str_replace('/','',$DT_PROD);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
		}

		function SomaRegistro($QTD_ENC){
			$this->QTD_ENC+= $QTD_ENC;
		}
		
		function LerRegistro(){
			return '|K250|'.
			$this->DT_PROD.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD_ENC,6,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_K255 extends SPED_Registro_Base{
		var $DT_CONS;
		var $COD_ITEM;
		var $QTD=0;
		var $COD_INS_SUBST;

		function CriaRegistro($DT_CONS, $COD_ITEM, $COD_INS_SUBST){
			$this->DT_CONS = str_replace('/','',$DT_CONS);
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->COD_INS_SUBST = trim(substr(limpa_texto($COD_INS_SUBST),0,60));
		}

		function SomaRegistro($QTD){
			$this->QTD+= $QTD;
		}

		function LerRegistro(){
			return '|K255|'.
			$this->DT_CONS.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,6,false).'|'.
			$this->COD_INS_SUBST.'|'.
			fim_linha();
		}
	}

	class SF_Reg_H005 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $DT_INV;
		var $VL_INV=0;
		var $MOT_INV='01';

		function CriaRegistro($DT_INV, $VL_INV=0, $MOT_INV='01'){
			$this->DT_INV =  str_replace('/','',$DT_INV);
			$this->VL_INV =  $VL_INV;
			if ($MOT_INV!=''){
				$this->MOT_INV =  fill_full($MOT_INV,2);
			}else{
				$this->MOT_INV = '';
			}
		}
		
		function LerRegistro(){
			$tipo = $this->MOT_INV.'|';
			if ($this->MOT_INV==''){
				$tipo = '';
			}
			return '|H005|'.
					$this->DT_INV.'|'.
					formata_qtd_sped($this->VL_INV,2,false).'|'.
					$tipo.
					fim_linha();
		}
	}

	class SF_Reg_H010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $ID_ITEM;
		var $UNID;
		var $QTD;
		var $VL_UNIT;
		var $VL_ITEM;
		var $IND_PROP;
		var $COD_PART;
		var $TXT_COMPL;
		var $COD_CTA;
		var $ITEM_IR;

		function CriaRegistro($COD_ITEM, $ID_ITEM, $UNID,
			$QTD, $VL_UNIT, $VL_ITEM,
			$IND_PROP, $COD_PART, $TXT_COMPL,
			$COD_CTA){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->QTD = $QTD;
			$this->VL_UNIT = $VL_UNIT;
			$this->VL_ITEM = $VL_ITEM;
			$this->IND_PROP = fill_full(trim(substr(limpa_texto($IND_PROP),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
			$this->COD_CTA = trim(limpa_texto($COD_CTA));

		}
		
		function LerRegistro(){
			$tITEM_IR = '';
			if ($this->ITEM_IR!=''){
				$tITEM_IR = formata_qtd_sped($this->ITEM_IR,2,false).'|';
			}

			return '|H010|'.
			$this->COD_ITEM.'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			formata_qtd_sped($this->VL_UNIT,6,false).'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->IND_PROP.'|'.
			$this->COD_PART.'|'.
			$this->TXT_COMPL.'|'.
			$this->COD_CTA.'|'.
			$tITEM_IR.
			fim_linha();
		}
	}

	class SF_Reg_H020 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $CST_ICMS;
		var $BC_ICMS;
		var $VL_ICMS;

		function CriaRegistro($CST_ICMS, $BC_ICMS, $VL_ICMS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_texto($CST_ICMS),0,3)),3);
			$this->BC_ICMS = $BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
		}
			
		function LerRegistro(){
			return '|H020|'.
			$this->CST_ICMS.'|'.
			formata_qtd_sped($this->BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_H030 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $VL_ICMS_OP;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_FCP;

		function CriaRegistro($VL_ICMS_OP, $VL_BC_ICMS_ST, $VL_ICMS_ST, $VL_FCP){
			$this->VL_ICMS_OP = $VL_ICMS_OP;
			$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
			$this->VL_ICMS_ST = $VL_ICMS_ST;
			$this->VL_FCP = $VL_FCP;
		}
		
		function LerRegistro(){
			return '|H030|'.
			formata_qtd_sped($this->VL_ICMS_OP,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_FCP,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_1010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_EXP = 'N';
		var $IND_CCRF = 'N';
		var $IND_COMB = 'N';
		var $IND_USINA = 'N';
		var $IND_VA = 'N';
		var $IND_EE = 'N';
		var $IND_CART = 'N';
		var $IND_FORM = 'N';
		var $IND_AER = 'N';
		var $IND_GIAF1 = ''; //somente para 2019 - pernambuco S
		var $IND_GIAF2 = ''; //somente para 2019 - pernambuco S
		var $IND_GIAF3 = ''; //somente para 2019 - pernambuco S
      var $IND_REST_RESSARC_COMPL_ICMS = ''; //somente para 2019

		function CriaRegistro($IND_EXP='', $IND_CCRF='', $IND_COMB='', $IND_USINA='',
			$IND_VA='', $IND_EE='', $IND_CART='', $IND_FORM='',
			$IND_AER='',
			$IND_GIAF1='',$IND_GIAF2='', $IND_GIAF3='',
			$IND_REST_RESSARC_COMPL_ICMS = ''){
			if ($IND_EXP!='') $this->IND_EXP = $IND_EXP;
			if ($IND_CCRF!='') $this->IND_CCRF = $IND_CCRF;
			if ($IND_COMB!='') $this->IND_COMB = $IND_COMB;
			if ($IND_USINA!='') $this->IND_USINA = $IND_USINA;
			if ($IND_VA!='') $this->IND_VA = $IND_VA;
			if ($IND_EE!='') $this->IND_EE = $IND_EE;
			if ($IND_CART!='') $this->IND_CART = $IND_CART;
			if ($IND_FORM!='') $this->IND_FORM = $IND_FORM;
			if ($IND_AER!='') $this->IND_AER = $IND_AER;
			if ($IND_GIAF1!='') $this->IND_GIAF1 = $IND_GIAF1;
			if ($IND_GIAF2!='') $this->IND_GIAF2 = $IND_GIAF2;
			if ($IND_GIAF3!='') $this->IND_GIAF3 = $IND_GIAF3;
			if ($IND_REST_RESSARC_COMPL_ICMS!='') $this->IND_REST_RESSARC_COMPL_ICMS = $IND_REST_RESSARC_COMPL_ICMS;
		}
		
		function LerRegistro(){
			$IND_GIAF = '';
			
			if ($this->IND_GIAF1!=''){
				$IND_GIAF.= $this->IND_GIAF1.'|'.
							$this->IND_GIAF2.'|'.
							$this->IND_GIAF3.'|';
			}
			if ($this->IND_REST_RESSARC_COMPL_ICMS!=''){
				$IND_GIAF.= $this->IND_REST_RESSARC_COMPL_ICMS.'|';
			}
			return '|1010|'.
					$this->IND_EXP.'|'.
					$this->IND_CCRF.'|'.
					$this->IND_COMB.'|'.
					$this->IND_USINA.'|'.
					$this->IND_VA.'|'.
					$this->IND_EE.'|'.
					$this->IND_CART.'|'.
					$this->IND_FORM.'|'.
					$this->IND_AER.'|'.
					$IND_GIAF.
					fim_linha();
		}
	}


	class SF_Reg_1100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $IND_DOC;
		var $NRO_DE;
		var $DT_DE;
		var $NAT_EXP;
		var $NRO_RE;
		var $DT_RE;
		var $CHC_EMB;
		var $DT_CHC;
		var $DT_AVB;
		var $TP_CHC;
		var $PAIS;

		function CriaRegistro($IND_DOC, $NRO_DE, $DT_DE,
			$NAT_EXP, $NRO_RE, $DT_RE,
			$CHC_EMB, $DT_CHC, $DT_AVB,
			$TP_CHC, $PAIS){
			$this->IND_DOC = fill_full(trim(substr(limpa_texto($IND_DOC),0,1)),1);
			$this->NRO_DE  = trim(substr(limpa_numero($NRO_DE),-11));
			$this->DT_DE = str_replace('/','',$DT_DE);
			$this->NAT_EXP = fill_full(trim(substr(limpa_texto($NAT_EXP),0,1)),1);
			if ($NRO_RE==''){
				$this->NRO_RE  = '';
				$this->DT_RE = '';
			}else{
				$this->NRO_RE  = trim(substr(limpa_numero($NRO_RE),-12));
				$this->DT_RE = str_replace('/','',$DT_RE);
			}
			if ($CHC_EMB==''){
				$this->CHC_EMB  = '';
				$this->DT_CHC = '';
			}else{
				$this->CHC_EMB  = trim(substr(limpa_texto($CHC_EMB),-13));
				$this->DT_CHC = str_replace('/','',$DT_CHC);
			}
			$this->DT_AVB = str_replace('/','',$DT_AVB);
			$this->TP_CHC = fill_full(trim(substr(limpa_texto($TP_CHC),0,2)),2);
			$PAIS = fill_full(limpa_numero($PAIS),4);
			$this->PAIS = substr($PAIS,0,3);
		}
		
		function LerRegistro(){
			return '|1100|'.
			$this->IND_DOC.'|'.
			$this->NRO_DE.'|'.
			$this->DT_DE.'|'.
			$this->NAT_EXP.'|'.
			$this->NRO_RE.'|'.
			$this->DT_RE.'|'.
			$this->CHC_EMB.'|'.
			$this->DT_CHC.'|'.
			$this->DT_AVB.'|'.
			$this->TP_CHC.'|'.
			$this->PAIS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_1105 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_MOD;
		var $SERIE;
		var $NUM_DOC;
		var $CHV_NFE;
		var $DT_DOC;
		var $COD_ITEM;

		function CriaRegistro($COD_MOD, $SERIE, $NUM_DOC,
			$CHV_NFE, $DT_DOC, $COD_ITEM){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->SERIE  = trim(substr(limpa_texto($SERIE),0,3));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SERIE = fill_full($this->SERIE,3);
			}

			$this->NUM_DOC  = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->CHV_NFE  = trim(substr(limpa_numero($CHV_NFE),0,44));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->COD_ITEM  = trim(substr(limpa_texto($COD_ITEM),0,60));
		}
		
		function LerRegistro(){
			return '|1105|'.
			$this->COD_MOD.'|'.
			$this->SERIE.'|'.
			$this->NUM_DOC.'|'.
			$this->CHV_NFE.'|'.
			$this->DT_DOC.'|'.
			$this->COD_ITEM.'|'.
			fim_linha();
		}
	}

	class SF_Reg_1110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $COD_MOD;
		var $SERIE;
		var $NUM_DOC;
		var $DT_DOC;
		var $CHV_NFE;
		var $NR_MEMO;
		var $QTD;
		var $UNID;

		function CriaRegistro($COD_PART, $COD_MOD, $SERIE, $NUM_DOC,
							$DT_DOC, $CHV_NFE, $NR_MEMO, $QTD, $UNID){
			$this->COD_PART  = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->SERIE  = trim(substr(limpa_texto($SERIE),0,3));
			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SERIE = fill_full($this->SERIE,3);
			}
			$this->NUM_DOC  = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->CHV_NFE  = trim(substr(limpa_numero($CHV_NFE),0,44));
			$this->NR_MEMO  = trim(limpa_numero($NR_MEMO));
			$this->QTD  = $QTD;
			$this->UNID  = trim(substr(limpa_texto($UNID),0,6));
		}
			
		function LerRegistro(){
			return '|1110|'.
					$this->COD_PART.'|'.
					$this->COD_MOD.'|'.
					$this->SERIE.'|'.
					$this->NUM_DOC.'|'.
					$this->DT_DOC.'|'.
					$this->CHV_NFE.'|'.
					$this->NR_MEMO.'|'.
					formata_qtd_sped($this->QTD,2,false).'|'.
					$this->UNID.'|'.
					fim_linha();
		}
	}

	class SF_Reg_1400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_ITEM;
		var $MUN;
		var $VALOR=0;

		function CriaRegistro($COD_ITEM, $MUN, $VALOR){
			$this->COD_ITEM  = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->MUN = fill_full(trim(substr(limpa_texto($MUN),0,7)),7);
			$this->VALOR+= $VALOR;
		}
			
		function LerRegistro(){
			return '|1400|'.
					$this->COD_ITEM.'|'.
					$this->MUN.'|'.
					formata_qtd_sped($this->VALOR,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_1600 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $TOT_CREDITO=0;
		var $TOT_DEBITO=0;

		function CriaRegistro($COD_PART, $TOT_CREDITO, $TOT_DEBITO){
			$this->COD_PART  = trim(substr(limpa_texto($COD_PART),0,60));
			$this->TOT_CREDITO+= $TOT_CREDITO;
			$this->TOT_DEBITO+= $TOT_DEBITO;
		}
			
		function LerRegistro(){
			return '|1600|'.
					$this->COD_PART.'|'.
					formata_qtd_sped($this->TOT_CREDITO,2,false).'|'.
					formata_qtd_sped($this->TOT_DEBITO,2,false).'|'.
					fim_linha();
		}
	}
	
	class SF_Reg_1601 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_PART;
		var $COD_PART_INTERMED;
		var $TOT_VS=0;
		var $TOT_ISS=0;
		var $TOT_OUTROS=0;

		function CriaRegistro($COD_PART, $COD_PART_INTERMED, $TOT_VS, $TOT_ISS, $TOT_OUTROS){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_PART_INTERMED = trim(substr(limpa_texto($COD_PART_INTERMED),0,60));
			$this->TOT_VS+= $TOT_VS;
			$this->TOT_ISS+= $TOT_ISS;
			$this->TOT_OUTROS+= $TOT_OUTROS;
		}
			
		function LerRegistro(){
			return '|1601|'.
					$this->COD_PART.'|'.
					$this->COD_PART_INTERMED.'|'.
					formata_qtd_sped($this->TOT_VS,2,false).'|'.
					formata_qtd_sped($this->TOT_ISS,2,false).'|'.
					formata_qtd_sped($this->TOT_OUTROS,2,false).'|'.
					fim_linha();
		}
	}

	class SF_Reg_1700 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $COD_DISP;
		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC_INI;
		var $NUM_DOC_FIN;
		var $NUM_AUT;

		function CriaRegistro($COD_DISP, $COD_MOD, $SER, $SUB,
			$NUM_DOC_INI, $NUM_DOC_FIN, $NUM_AUT){
			$this->COD_DISP = fill_full(trim(substr(limpa_texto($COD_DISP),0,2)),2);
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->SER  = trim(substr(limpa_texto($SER),0,4));
			$this->SUB  = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC_INI  = trim(substr(limpa_numero($NUM_DOC_INI),-12));
			$this->NUM_DOC_FIN  = trim(substr(limpa_numero($NUM_DOC_FIN),-12));
			$this->NUM_AUT  = trim(substr(limpa_texto($NUM_AUT),0,60));

		}
		function LerRegistro(){
			return '|1700|'.
					$this->COD_DISP.'|'.
					$this->COD_MOD.'|'.
					$this->SER.'|'.
					$this->SUB.'|'.
					$this->NUM_DOC_INI.'|'.
					$this->NUM_DOC_FIN.'|'.
					$this->NUM_AUT.'|'.
					fim_linha();
		}
	}
	class SF_Reg_1710 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $NUM_DOC_INI;
		var $NUM_DOC_FIN;

		function CriaRegistro($NUM_DOC_INI, $NUM_DOC_FIN){
			$this->NUM_DOC_INI  = trim(substr(limpa_numero($NUM_DOC_INI),-12));
			$this->NUM_DOC_FIN  = trim(substr(limpa_numero($NUM_DOC_FIN),-12));
		}
		function LerRegistro(){
			return '|1710|'.
					$this->NUM_DOC_INI.'|'.
					$this->NUM_DOC_FIN.'|'.
					fim_linha();
		}
	}

	class SF_Reg_9900 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAÇÃO DA ENTIDADE
		var $REG_BLC;
		var $QTD_REG_BLC=0;

		function CriaRegistro($REG_BLC, $QTD_REG_BLC){
			//echo 'conta'.$REG_BLC.'vanterior'.$this->QTD_REG_BLC.'-';
			$this->REG_BLC  = trim(substr(limpa_texto($REG_BLC),0,4));
			$this->QTD_REG_BLC+= $QTD_REG_BLC;
			//echo 'conta'.$REG_BLC.'vantual'.$this->QTD_REG_BLC.'-';
		}
		function LerRegistro(){
			return '|9900|'.
					$this->REG_BLC.'|'.
					$this->QTD_REG_BLC.'|'.
					fim_linha();
		}
	}

?>