<?
	class SF_Reg_0000 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_VER;
		var $TIPO_ESCRIT;
		var $IND_SIT_ESP;
		var $NUM_REC_ANTERIOR;
		var $DT_INI;
		var $DT_FIN;
		var $NOME;
		var $CNPJ;
		var $CPF;
		var $UF;
		var $IE;
		var $COD_MUN;
		var $IM;
		var $SUFRAMA;
		var $IND_NAT_PJ;
		var $IND_ATIV;

		function CriaRegistro($COD_VER, $TIPO_ESCRIT, $IND_SIT_ESP,
								$NUM_REC_ANTERIOR, $DT_INI, $DT_FIN,
								$NOME, $CNPJ, $UF, $COD_MUN,
								$SUFRAMA, $IND_NAT_PJ='00', $IND_ATIV='2'){
			$this->COD_VER = fill_full(substr($COD_VER,0,3),3);
			$this->TIPO_ESCRIT = fill_full(substr($TIPO_ESCRIT,0,1),1);
			$this->IND_SIT_ESP = $IND_SIT_ESP;
			$this->NUM_REC_ANTERIOR = trim(substr(limpa_texto($NUM_REC_ANTERIOR),0,41));
			$this->DT_INI = str_replace('/','',$DT_INI);
			$this->DT_FIN = str_replace('/','',$DT_FIN);
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			//echo '-'.$NOME.'-';
			$this->CNPJ = substr(limpa_numero($CNPJ),0,14);
			if (strlen($this->CNPJ)==11){
				$this->CPF = $this->CNPJ;
				$this->CNPJ = '';
			}else{
				$this->CPF = '';
			}
			$this->UF = substr($UF,0,2);

			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);

			$this->SUFRAMA = limpa_numero($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}

			$this->IND_NAT_PJ = $IND_NAT_PJ;
			$this->IND_ATIV = $IND_ATIV;
		}

		function LerRegistro(){
			return '|0000|'.
					$this->COD_VER.'|'.
					$this->TIPO_ESCRIT.'|'.
					$this->IND_SIT_ESP.'|'.
					$this->NUM_REC_ANTERIOR.'|'.
					$this->DT_INI.'|'.
					$this->DT_FIN.'|'.
					$this->NOME.'|'.
					$this->CNPJ.'|'.
					$this->UF.'|'.
					$this->COD_MUN.'|'.
					$this->SUFRAMA.'|'.
					$this->IND_NAT_PJ.'|'.
					$this->IND_ATIV.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NOME;
		var $CPF;
		var $CRC;
		var $CNPJ;
		var $CEP;
		var $END;
		var $NUM;
		var $COMPL;
		var $BAIRRO;
		var $FONE;
		var $FAX;
		var $EMAIL;
		var $COD_MUN;

		function CriaRegistro($NOME, $CPF, $CRC, $CNPJ,
								$CEP, $END, $NUM,
								$COMPL, $BAIRRO, $FONE, $FAX,
								$EMAIL, $COD_MUN){

			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			$this->CPF = trim(substr(limpa_numero($CPF),0,11));
			$this->CRC = trim(substr(limpa_numero($CRC),0,15));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			$this->CEP = fill_full(substr(limpa_numero($CEP),0,8),8);
			$this->END = trim(substr(limpa_texto($END),0,60));
			$this->NUM = trim(substr(limpa_texto($NUM),0,10));
			if ($this->NUM==''){
				$this->NUM = 'S/N';
			}
			$this->COMPL = trim(substr(limpa_texto($COMPL),0,60));
			$this->BAIRRO = trim(substr(limpa_texto($BAIRRO),0,60));
			if ($this->BAIRRO==''){
				$this->BAIRRO = 'CENTRO';
			}
			$this->FONE = trim(substr(limpa_numero($FONE),0,10));
			$this->FAX = trim(substr(limpa_numero($FAX),0,10));
			$this->EMAIL = limpa_texto($EMAIL);
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
		}

		function LerRegistro(){
			return '|0100|'.
			$this->NOME.'|'.
			$this->CPF.'|'.
			$this->CRC.'|'.
			$this->CNPJ.'|'.
			$this->CEP.'|'.
			$this->END.'|'.
			$this->NUM.'|'.
			$this->COMPL.'|'.
			$this->BAIRRO.'|'.
			$this->FONE.'|'.
			$this->FAX.'|'.
			$this->EMAIL.'|'.
			$this->COD_MUN.'|'.
			fim_linha();
		}
	}


	class SF_Reg_0110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_INC_TRIB;
		var $IND_APRO_CRED;
		var $COD_TIPO_CONT;
		var $IND_REG_CUM;

		function CriaRegistro($COD_INC_TRIB, $IND_APRO_CRED, $COD_TIPO_CONT, $IND_REG_CUM=''){
			$this->COD_INC_TRIB  = $COD_INC_TRIB;
			$this->IND_APRO_CRED = $IND_APRO_CRED;
			$this->COD_TIPO_CONT = $COD_TIPO_CONT;
			$this->IND_REG_CUM   = $IND_REG_CUM;
		}

		function LerRegistro(){
			return '|0110|'.
			$this->COD_INC_TRIB.'|'.
			$this->IND_APRO_CRED.'|'.
			$this->COD_TIPO_CONT.'|'.
			$this->IND_REG_CUM.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0111 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $REC_BRU_NCUM_TRIB_MI = 0;
		var $REC_BRU_NCUM_NT_MI = 0;
		var $REC_BRU_NCUM_EXP = 0;
		var $REC_BRU_CUM = 0;
		var $REC_BRU_TOTAL = 0;

		function SomaRegistro($REC_BRU_NCUM_TRIB_MI,
			$REC_BRU_NCUM_NT_MI,
			$REC_BRU_NCUM_EXP,
			$REC_BRU_CUM){

			$this->REC_BRU_NCUM_TRIB_MI+= $REC_BRU_NCUM_TRIB_MI;
			$this->REC_BRU_NCUM_NT_MI+=   $REC_BRU_NCUM_NT_MI;
			$this->REC_BRU_NCUM_EXP+=     $REC_BRU_NCUM_EXP;
			$this->REC_BRU_CUM+=          $REC_BRU_CUM;

			$this->REC_BRU_TOTAL = $this->REC_BRU_NCUM_TRIB_MI +
			$this->REC_BRU_NCUM_NT_MI   +
			$this->REC_BRU_NCUM_EXP     +
			$this->REC_BRU_CUM;
		}

		function LerRegistro(){
			return '|0111|'.
			formata_qtd_sped($this->REC_BRU_NCUM_TRIB_MI,2,false).'|'.
			formata_qtd_sped($this->REC_BRU_NCUM_NT_MI,2,false).'|'.
			formata_qtd_sped($this->REC_BRU_NCUM_EXP,2,false).'|'.
			formata_qtd_sped($this->REC_BRU_CUM,2,false).'|'.
			formata_qtd_sped($this->REC_BRU_TOTAL,2,false).'|'.
			fim_linha();
		}

	}

	class SF_Reg_0140 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_EST;
		var $NOME;
		var $CNPJ;
		var $UF;
		var $IE;
		var $COD_MUN;
		var $IM;
		var $SUFRAMA;


		function CriaRegistro($COD_EST, $NOME, $CNPJ,
								$UF, $IE, $COD_MUN, $IM, $SUFRAMA){

			$this->COD_EST = trim(substr(limpa_texto($COD_EST),0,60));
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));

			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			$this->UF = trim(substr($UF,0,2));

			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if ($IE=='ISENTO'){
				$this->IE = '';
			}

			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->IM = trim(substr(limpa_numero2($IM),0,60));

			$this->SUFRAMA = limpa_numero2($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}
		}

		function CriaRegistroBase($COD_EST){
			//echo '-part_'.$COD_PART.'-';
			//echo 'Empresa: "'.$COD_EST.'"<BR>';
			$codigo = explode('_',$COD_EST);
			if (isset($codigo[1])){
				$COD_PESSOA = $codigo[1];
			}else{
				$COD_PESSOA = 1;
			}

			//consulta cadastro de pessoa
			$con_pessoa = 'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$COD_PESSOA.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			$nrw_pessoa = consulta_num_registros($res_pessoa);
			consulta_limpa($res_pessoa);

			if ($nrw_pessoa==0){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Pessoa ('.$COD_EST.') n? cadastrada ! ');
			}else{
				if (trim($reg_pessoa->Nome_Razao)==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Nome/Raz? da Pessoa ('.$COD_EST.') n? cadastrada! ');
				}
			}

			//consulta endereco da nota ou princpal
			//se for zero (?o primeiro endereco disponivel)
			$con_ender = 'select * from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"';
			$con_ender.= ' and Situacao<>"E" order by Seq_Endereco limit 1';

			$res_ender = consulta_sql($con_ender);
			$reg_ender = consulta_ler_objeto($res_ender);
			consulta_limpa($res_ender);

			if (!(valida_cpf_cnpj($reg_pessoa->CPF_CNPJ))){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! CPF/CNPJ ('.$reg_pessoa->CPF_CNPJ.') da Pessoa ('.$COD_EST.') inv?ido!');
			}
			if ((limpa_numero2($reg_ender->Insc_Estadual)!='')&&($reg_ender->Insc_Estadual!='ISENTO')){
				if (!(ChkInscEstadual(limpa_numero2($reg_ender->Insc_Estadual), $reg_ender->UF))){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Inscrio Estadual ('.$reg_ender->Insc_Estadual.') da Pessoa ('.$COD_EST.') Inv?ida para '.$reg_ender->UF.'!');
				}
			}
			if ($reg_ender->Codigo_Cidade==0){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Cidade da Pessoa ('.$COD_EST.') n? cadastrada!',false);
			}

			$this->CriaRegistro($COD_EST, $reg_pessoa->Nome_Razao,
								$reg_pessoa->CPF_CNPJ,$reg_ender->UF,
								$reg_ender->Insc_Estadual,
								$reg_ender->Codigo_Cidade,$reg_ender->Insc_Municipal,
								$reg_ender->Insc_SUFRAMA);
			return $this->CNPJ;
		}
		
		function LerRegistro(){
			return '|0140|'.
					$this->COD_EST.'|'.
					$this->NOME.'|'.
					$this->CNPJ.'|'.
					$this->UF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->IM.'|'.
					$this->SUFRAMA.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0150 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_PART;
		var $NOME;
		var $COD_PAIS;
		var $CNPJ;
		var $CPF;
		var $IE;
		var $COD_MUN;
		var $SUFRAMA;
		var $END;
		var $NUM;
		var $COMPL;
		var $BAIRRO;
		var $UF;

		function CriaRegistro($COD_PART, $NOME, $COD_PAIS, $CNPJ,
								$IE, $COD_MUN, $SUFRAMA,
								$END, $NUM, $COMPL, $BAIRRO){

			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->NOME = trim(substr(limpa_texto($NOME),0,100));
			$this->COD_PAIS = trim(substr(limpa_numero($COD_PAIS),0,5));
			if ($this->COD_PAIS==''){
				$this->COD_PAIS='1058';//brasil
			}
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
			if (strlen($this->CNPJ)==11){
				$this->CPF = $this->CNPJ;
				$this->CNPJ = '';
			}else{
				$this->CPF = '';
			}

			$this->IE = trim(substr(limpa_numero2($IE),0,14));
			if ($IE=='ISENTO'){
				$this->IE = '';
			}
			$this->COD_MUN =  fill_full(substr($COD_MUN,0,7),7);
			$this->SUFRAMA = limpa_numero2($SUFRAMA);
			if ($this->SUFRAMA!=''){
				$this->SUFRAMA = fill_full($this->SUFRAMA,9);
			}

			$this->END = trim(substr(limpa_texto($END),0,60));
			$this->NUM = trim(substr(limpa_texto($NUM),0,10));
			if ($this->NUM==''){
				$this->NUM = 'S/N';
			}
			$this->COMPL = trim(substr(limpa_texto($COMPL),0,60));
			$this->BAIRRO = trim(substr(limpa_texto($BAIRRO),0,60));
			if ($this->BAIRRO==''){
				$this->BAIRRO = 'CENTRO';
			}

			if ($this->COD_PAIS!='1058'){
				$this->COD_MUN = '9999999';
				$this->CPF = '';
				$this->CNPJ = '';
				$this->IE = '';
			}
		}

		function CriaRegistroBase($COD_PART,
		                          $CPF_CNPJ,$NOME,$IE,$SUFRAMA,
								  $END_LOG,$END_NR, $END_COMP){
			//echo '-part_'.$COD_PART.'-';

			$codigo = explode('_',$COD_PART);
			if (isset($codigo[1])){
				$COD_PESSOA = $codigo[1];
			}else{
				$COD_PESSOA = 1;
			}
			if (isset($codigo[2])){
				$COD_ENDER = $codigo[2];
			}else{
				$COD_ENDER = 0;
			}

			//consulta cadastro de pessoa
			$con_pessoa = 'select * from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$COD_PESSOA.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_objeto($res_pessoa);
			$nrw_pessoa = consulta_num_registros($res_pessoa);
			consulta_limpa($res_pessoa);

			if ($nrw_pessoa==0){
				sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Pessoa ('.$COD_PART.') n? cadastrada ! ');
			}else{
				if (trim($reg_pessoa->Nome_Razao)==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Nome/Raz? da Pessoa ('.$COD_PART.') n? cadastrada! ');
				}
			}

			//consulta endereco da nota ou princpal
			//se for zero (?o primeiro endereco disponivel)
			$con_ender = 'select * from pessoa_endereco '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa="'.$COD_PESSOA.'"';
			if ($COD_ENDER>0){
				$con_ender.= ' and Seq_Endereco="'.$COD_ENDER.'"';
			}else{
				$con_ender.= ' and Situacao<>"E" order by Seq_Endereco limit 1';
			}
			$res_ender = consulta_sql($con_ender);
			$reg_ender = consulta_ler_objeto($res_ender);
			consulta_limpa($res_ender);
			
			if (($reg_pessoa->CPF_CNPJ!='000.000.000-00')&&
				($reg_pessoa->CPF_CNPJ!='00.000.000/0000-00')){
				$CPF_CNPJ = $reg_pessoa->CPF_CNPJ;
				$NOME     = $reg_pessoa->Nome_Razao;
				$IE       = $reg_ender->Insc_Estadual;
				$SUFRAMA  = $reg_ender->Insc_SUFRAMA;
				$END_LOG  = $reg_ender->Logradouro;
				$END_NR   = $reg_ender->Numero;
				$END_COMP = $reg_ender->Complemento;
			}
			
			if ($reg_ender->UF=='EX'){
				$END_LOG.= ' '.$reg_ender->Nome_Cidade;
			}else{
				if (!(valida_cpf_cnpj($CPF_CNPJ))){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! CPF/CNPJ ('.$CPF_CNPJ.') da Pessoa ('.$COD_PART.') inv?ido!');
				}
				if ((limpa_numero2($IE)!='')&&($IE!='ISENTO')){
					if (!(ChkInscEstadual(limpa_numero2($IE), $reg_ender->UF))){
						sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Inscrio Estadual ('.$IE.') da Pessoa ('.$COD_PART.') Inv?ida para '.$reg_ender->UF.'!');
					}
				}
				if ($reg_ender->Codigo_Cidade==0){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Cidade da Pessoa ('.$COD_PART.') n? cadastrada!');
				}
				if ($END_LOG==''){
					sped_exibe_erro( '0150', 'Falha na gerao do arquivo SPED! Logradouro da Pessoa ('.$COD_PART.') n? cadastrado!');
				}
			}
			$this->UF = $reg_ender->UF;
			$this->CriaRegistro($COD_PART, 
								$NOME,
								$reg_ender->Codigo_Pais, 
								$CPF_CNPJ,
								$IE,
								$reg_ender->Codigo_Cidade, 
								$SUFRAMA,
								$END_LOG, 
								$END_NR,
								$END_COMP, 
								$reg_ender->Bairro);
			return $this->UF;
		}

		function LerRegistro(){
			return '|0150|'.
					$this->COD_PART.'|'.
					$this->NOME.'|'.
					$this->COD_PAIS.'|'.
					$this->CNPJ.'|'.
					$this->CPF.'|'.
					$this->IE.'|'.
					$this->COD_MUN.'|'.
					$this->SUFRAMA.'|'.
					$this->END.'|'.
					$this->NUM.'|'.
					$this->COMPL.'|'.
					$this->BAIRRO.'|'.
					fim_linha();
		}
	}

	class SF_Reg_0190 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $UNID;
		var $DESCR;

		function CriaRegistro($UNID, $DESCR){
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->DESCR = trim(limpa_texto($DESCR));
			if ($this->DESCR==''){
				$this->DESCR = 'QTD EM '.$this->UNID;
				//sped_exibe_erro( '0190', 'Falha na gerao do arquivo SPED! Unidade de Medida ('.$this->UNID.') n? possue descrio, usando descrio gen?ica!');
			}
		}

		function LerRegistro(){
			return '|0190|'.
			$this->UNID.'|'.
			$this->DESCR.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_ITEM;
		var $DESCR_ITEM;
		var $COD_BARRA;
		var $COD_ANT_ITEM;
		var $UNID_INV;
		var $TIPO_ITEM;
		var $COD_NCM;
		var $EX_IPI;
		var $COD_GEN;
		var $COD_LST;
		var $ALIQ_ICMS;

		var $maior_fator=0;

		function CriaRegistro($COD_ITEM, $DESCR_ITEM, $COD_BARRA,
			$COD_ANT_ITEM, $UNID_INV, $TIPO_ITEM,
			$COD_NCM, $EX_IPI, $COD_LST, $ALIQ_ICMS, $DATA_INI){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->DESCR_ITEM = trim(limpa_texto($DESCR_ITEM));
			$this->COD_BARRA = trim(substr(limpa_texto($COD_BARRA),0,14));
			$this->COD_ANT_ITEM = trim(substr(limpa_texto($COD_ANT_ITEM),0,60));
			$this->UNID_INV = trim(substr(limpa_texto($UNID_INV),0,6));
			$this->TIPO_ITEM = fill_full(trim(substr(limpa_numero($TIPO_ITEM),0,2)),2);
			$this->COD_NCM = trim(substr(limpa_numero($COD_NCM),0,8));
			if (strlen($this->COD_NCM)==8){
				$this->EX_IPI = trim(substr(limpa_numero($EX_IPI),0,3));
			}else{
				$this->EX_IPI = '';
				$this->COD_NCM = '';
			}
			$this->COD_GEN = fill_full(trim(substr(limpa_numero($COD_NCM),0,2)),2);
			$this->COD_LST = trim(substr(limpa_numero($COD_LST),0,4));
			if($this->COD_LST!=''){
				$this->COD_LST = fill_full($this->COD_LST,4);
				if (data2nr($DATA_INI)>=data2nr('01/05/2015')){
					$this->COD_LST = substr($this->COD_LST,0,2).'.'.substr($this->COD_LST,2,2);
					if (substr($this->COD_LST,0,1)=='0'){
						$this->COD_LST = substr($this->COD_LST,1,4);
					}
				}
			}
			$this->ALIQ_ICMS = $ALIQ_ICMS; //formata_qtd(

			if ($COD_ITEM==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! C?igo do Item n? Informado!');
			}
			if ($DESCR_ITEM==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! Descrio do Item ('.$COD_ITEM.') n? Informada!');
			}
			if ($UNID_INV==''){
				sped_exibe_erro( '0200', 'Falha na gerao do arquivo SPED! Unidade de Medida do Item ('.$COD_ITEM.') n? Informada!');
			}

		}

		function LerRegistro(){
			return '|0200|'.
			$this->COD_ITEM.'|'.
			$this->DESCR_ITEM.'|'.
			$this->COD_BARRA.'|'.
			$this->COD_ANT_ITEM.'|'.
			$this->UNID_INV.'|'.
			$this->TIPO_ITEM.'|'.
			$this->COD_NCM.'|'.
			$this->EX_IPI.'|'.
			$this->COD_GEN.'|'.
			$this->COD_LST.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_0205 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DESCR_ANT_ITEM;
		var $DT_INI;
		var $DT_FIM;
		var $COD_ANT_ITEM;

		function CriaRegistro($DESCR_ANT_ITEM, $DT_INI, $DT_FIM, $COD_ANT_ITEM){
			$this->DESCR_ANT_ITEM = trim(limpa_texto($DESCR_ANT_ITEM));
			$this->DT_INI = str_replace('-','',datad($DT_INI));
			$this->DT_FIM = str_replace('-','',datad($DT_FIM));
			$this->COD_ANT_ITEM = trim(substr(limpa_texto($COD_ANT_ITEM),0,60));
		}

		function LerRegistro(){
			return '|0205|'.
			$this->DESCR_ANT_ITEM.'|'.
			$this->DT_INI.'|'.
			$this->DT_FIM.'|'.
			$this->COD_ANT_ITEM.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0206 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_COMB;

		function CriaRegistro($COD_COMB){
			$this->COD_COMB = trim(limpa_texto($COD_COMB));
		}

		function LerRegistro(){
			return '|0206|'.
			$this->COD_COMB.'|'.
			fim_linha();
		}

	}

	class SF_Reg_0400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_NAT;
		var $DESCR_NAT;

		function CriaRegistro($COD_NAT, $DESCR_NAT){
			$this->COD_NAT = trim(substr(limpa_texto($COD_NAT),0,10));
			$this->DESCR_NAT = trim(limpa_texto($DESCR_NAT));
		}

		function LerRegistro(){
			return '|0400|'.
			$this->COD_NAT.'|'.
			$this->DESCR_NAT.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0450 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_INF;
		var $TXT;

		function CriaRegistro($COD_INF, $TXT){
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->TXT = trim(limpa_texto($TXT));
		}

		function LerRegistro(){
			return '|0450|'.
			$this->COD_INF.'|'.
			$this->TXT.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0460 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_OBS;
		var $TXT;

		function CriaRegistro($COD_OBS, $TXT){
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
			$this->TXT = trim(limpa_texto($TXT));
		}

		function LerRegistro(){
			return '|0460|'.
			$this->COD_OBS.'|'.
			$this->TXT.'|'.
			fim_linha();
		}
	}

	class SF_Reg_0500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_ALT;
		var $COD_NAT_CC;
		var $IND_CTA;
		var $NIVEL;
		var $COD_CTA;
		var $NOME_CTA;

		function CriaRegistro($DT_ALT, $COD_NAT_CC,
			$IND_CTA, $NIVEL,
			$COD_CTA, $NOME_CTA){
			$this->DT_ALT = str_replace('/','',dataf($DT_ALT));
			$this->COD_NAT_CC = fill_full(trim(substr(limpa_numero($COD_NAT_CC),0,2)),2);
			$this->IND_CTA = trim(substr(limpa_texto($IND_CTA),0,1));
			if ($this->IND_CTA==''){
				$this->IND_CTA = 'S';
			}
			$this->NIVEL = trim(substr(limpa_numero($NIVEL),0,5));
			if ($this->NIVEL==''){
				$this->NIVEL = '1';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->NOME_CTA = trim(substr(limpa_texto($NOME_CTA),0,60));
		}

		function LerRegistro(){
			return '|0500|'.
			$this->DT_ALT.'|'.
			$this->COD_NAT_CC.'|'.
			$this->IND_CTA.'|'.
			$this->NIVEL.'|'.
			$this->COD_CTA.'|'.
			$this->NOME_CTA.'|'.
			'||'.
			fim_linha();
		}

	}

	class SF_Reg_0600 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_ALT;
		var $COD_CCUS;
		var $CCUS;

		function CriaRegistro($DT_ALT, $COD_CCUS, $CCUS){
			$this->DT_ALT = str_replace('-','',datad($DT_ALT));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
			$this->CCUS = trim(substr(limpa_texto($CCUS),0,60));
		}

		function LerRegistro(){
			return '|0600|'.
			$this->DT_ALT.'|'.
			$this->COD_CCUS.'|'.
			$this->CCUS.'|'.
			fim_linha();
		}

	}

	//regsitros bloco A
	class SF_Reg_A010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_EST;
		var $CNPJ;

		function CriaRegistro($COD_EST, $CNPJ){
			$this->COD_EST = trim(substr(limpa_texto($COD_EST),0,60));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
		}

		function LerRegistro(){
			return '|A010|'.
			$this->CNPJ.'|'.
			fim_linha();
		}

	}

	class SF_Reg_A100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $CHV_NFSE;
		var $DT_DOC;
		var $DT_EXE_SERV;
		var $VL_DOC;
		var $IND_PGTO;
		var $VL_DESC;
		var $VL_BC_PIS;
		var $VL_PIS;
		var $VL_BC_COFINS;
		var $VL_COFINS;
		var $VL_PIS_RET;
		var $VL_COFINS_RET;
		var $VL_ISS;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
								$COD_SIT, $SER, $SUB,
								$NUM_DOC, $CHV_NFSE, $DT_DOC,
								$DT_EXE_SERV, $VL_DOC, $IND_PGTO,
								$VL_DESC, $VL_BC_PIS,
								$VL_PIS, $VL_BC_COFINS, $VL_COFINS,
								$VL_PIS_RET, $VL_COFINS_RET, $VL_ISS,
								$considera_data=false){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if (($CHV_NFSE!='')&&
					($this->IND_EMIT=='0')){
					$this->CHV_NFSE = '';//$CHV_NFSE;
				}else{
					$this->CHV_NFSE = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('/','',$DT_DOC);
					$this->DT_EXE_SERV = str_replace('/','',$DT_EXE_SERV);
				}else{
					$this->DT_DOC = '';
					$this->DT_EXE_SERV = '';
				}
				$this->COD_PART = '';
				$this->VL_DOC = '';
				$this->IND_PGTO = '';
				$this->VL_DESC = '';
				$this->VL_BC_PIS = '';
				$this->VL_PIS = '';
				$this->VL_BC_COFINS = '';
				$this->VL_COFINS = '';
				$this->VL_PIS_RET = '';
				$this->VL_COFINS_RET = '';
				$this->VL_ISS = '';
			}else{
				if (($CHV_NFSE!='')&&
					($this->IND_EMIT=='0')){
					$this->CHV_NFSE = $CHV_NFSE;
				}else{
					$this->CHV_NFSE = '';
				}
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->DT_EXE_SERV = str_replace('/','',$DT_EXE_SERV);

				$this->VL_DOC = $VL_DOC;
				$this->IND_PGTO = fill_full(trim(substr(limpa_numero($IND_PGTO),0,1)),1);
				$this->VL_DESC = $VL_DESC;
				$this->VL_BC_PIS = $VL_BC_PIS;
				$this->VL_PIS = $VL_PIS;
				$this->VL_BC_COFINS = $VL_BC_COFINS;
				$this->VL_COFINS = $VL_COFINS;
				$this->VL_PIS_RET = $VL_PIS_RET;
				$this->VL_COFINS_RET = $VL_COFINS_RET;
				$this->VL_ISS = $VL_ISS;
			}
		}

		function LerRegistro(){
			return '|A100|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->CHV_NFSE.'|'.
			$this->DT_DOC.'|'.
			$this->DT_EXE_SERV.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			$this->IND_PGTO.'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS_RET,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS_RET,2,false).'|'.
			formata_qtd_sped($this->VL_ISS,2,false).'|'.
			fim_linha();
		}

	}


	class SF_Reg_A110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_INF;
		var $TXT_COMPL;

		function CriaRegistro($COD_INF, $TXT_COMPL){
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
		}
		
		function LerRegistro(){
			return '|A110|'.
			$this->COD_INF.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_A111 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_PROC;
		var $IND_PROC;

		function CriaRegistro($NUM_PROC, $IND_PROC){
			$this->NUM_PROC = trim(substr(limpa_texto($NUM_PROC),0,15));
			$this->IND_PROC = fill_full(trim(substr(limpa_numero($IND_PROC),0,1)),1);
			if (($this->IND_PROC==0)||($this->IND_PROC==2)){
				$this->IND_PROC = 9;
			}
		}
		function LerRegistro(){
			return '|A111|'.
			$this->NUM_PROC.'|'.
			$this->IND_PROC.'|'.
			fim_linha();
		}
	}

	class SF_Reg_A170 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_ITEM;
		var $COD_ITEM;
		var $ID_ITEM;
		var $DESCR_COMPL;
		var $VL_ITEM;
		var $VL_DESC;
		var $NAT_BC_CRED;
		var $IND_ORIG_CRED;
		var $CST_PIS;
		var $VL_BC_PIS;
		var $ALIQ_PIS;
		var $VL_PIS;
		var $CST_COFINS;
		var $VL_BC_COFINS;
		var $ALIQ_COFINS;
		var $VL_COFINS;
		var $COD_CTA;
		var $COD_CCUS;

		var $VL_OPER_SOMA;

		function CriaRegistro($NUM_ITEM, $ID_ITEM,
			$COD_ITEM, $DESCR_COMPL,
			$VL_ITEM, $VL_DESC,
			$NAT_BC_CRED, $IND_ORIG_CRED,
			$CST_PIS, $VL_BC_PIS,
			$ALIQ_PIS, $VL_PIS, $CST_COFINS,
			$VL_BC_COFINS, $ALIQ_COFINS, $VL_COFINS,
			$COD_CTA, $COD_CCUS, $VL_OPER_SOMA=0){
			$this->NUM_ITEM =  $NUM_ITEM;
			$this->ID_ITEM =  $ID_ITEM;
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->DESCR_COMPL = trim(limpa_texto($DESCR_COMPL));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
			$this->NAT_BC_CRED = trim(substr(limpa_numero($NAT_BC_CRED),0,2));
			$this->IND_ORIG_CRED = fill_full(trim(substr(limpa_numero($IND_ORIG_CRED),0,1)),1);

			$this->CST_PIS = trim(substr(limpa_texto($CST_PIS),0,2));
			$this->VL_BC_PIS = $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->VL_PIS = $VL_PIS;

			$this->CST_COFINS = trim(substr(limpa_texto($CST_COFINS),0,2));
			$this->VL_BC_COFINS = $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->VL_COFINS = $VL_COFINS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}
			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}
			$this->COD_CTA = trim(limpa_texto($COD_CTA));
			$this->COD_CCUS = trim(limpa_texto($COD_CCUS));

			$this->VL_OPER_SOMA = $VL_OPER_SOMA;

		}
		function LerRegistro(){


			return '|A170|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			$this->DESCR_COMPL.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			$this->IND_ORIG_CRED.'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->COD_CCUS.'|'.
			fim_linha();
		}
	}
	
	//registros bloco C
	class SF_Reg_C010 extends SPED_Registro_Base{
			//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_EST;
		var $CNPJ;

		function CriaRegistro($COD_EST, $CNPJ){
			$this->COD_EST = trim(substr(limpa_texto($COD_EST),0,60));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
		}

		function LerRegistro(){
			return '|C010|'.
			$this->CNPJ.'|2|'.

			fim_linha();
		}

	}

	class SF_Reg_C100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $NUM_DOC;
		var $CHV_NFE;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $IND_PGTO;
		var $VL_DESC;
		var $VL_ABAT_NT;
		var $VL_MERC;
		var $IND_FRT;
		var $VL_FRT;
		var $VL_SEG;
		var $VL_OUT_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $VL_IPI;
		var $VL_PIS;
		var $VL_COFINS;
		var $VL_PIS_ST;
		var $VL_COFINS_ST;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER,
			$NUM_DOC, $CHV_NFE, $DT_DOC,
			$DT_E_S, $VL_DOC, $IND_PGTO,
			$VL_DESC, $VL_ABAT_NT, $VL_MERC,
			$IND_FRT, $VL_FRT, $VL_SEG,
			$VL_OUT_DA, $VL_BC_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $VL_ICMS_ST,
			$VL_IPI, $VL_PIS, $VL_COFINS,
			$VL_PIS_ST, $VL_COFINS_ST,$considera_data=false){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,3));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}
			if ($this->COD_MOD=='65'){
				$this->COD_PART = '';
			}

			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));
			$this->CHV_NFE = $CHV_NFE;

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if ($this->COD_SIT=='05'){
					$this->CHV_NFE = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('/','',$DT_DOC);
					$this->DT_E_S = str_replace('/','',$DT_E_S);
				}else{
					$this->DT_DOC = '';
					$this->DT_E_S = '';
				}
				$this->COD_PART = '';
				$this->DT_E_S = '';
				$this->VL_DOC = '';
				$this->IND_PGTO = '';
				$this->VL_DESC = '';
				$this->VL_ABAT_NT = '';
				$this->VL_MERC = '';
				$this->IND_FRT = '';
				$this->VL_FRT = '';
				$this->VL_SEG = '';
				$this->VL_OUT_DA = '';
				$this->VL_BC_ICMS = '';
				$this->VL_ICMS = '';
				$this->VL_BC_ICMS_ST = '';
				$this->VL_ICMS_ST = '';
				$this->VL_IPI = '';
				$this->VL_PIS = '';
				$this->VL_COFINS = '';
				$this->VL_PIS_ST = '';
				$this->VL_COFINS_ST = '';
			}else{

				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->DT_E_S = str_replace('/','',$DT_E_S);

				$this->VL_DOC = $VL_DOC;
				$this->IND_PGTO = fill_full(trim(substr(limpa_numero($IND_PGTO),0,1)),1);
				$this->VL_DESC = $VL_DESC;
				$this->VL_ABAT_NT = $VL_ABAT_NT;
				$this->VL_MERC = $VL_MERC;
				$this->IND_FRT = fill_full(trim(substr(limpa_numero($IND_FRT),0,1)),1);

				//a partir de 2012 muda os n?eros
				if (data2nr($DT_E_S)>=data2nr('01/01/2012')){
					if ($this->IND_FRT=='0'){
						$this->IND_FRT = '2';
					}else if ($this->IND_FRT=='1'){
						$this->IND_FRT = '0';
					}else if ($this->IND_FRT=='2'){
						$this->IND_FRT = '1';
					}
				}

				if (data2nr($DT_E_S)>=data2nr('01/07/2012')){
					if ($this->IND_PGTO=='9'){
						$this->IND_PGTO = '2';
					}
				}

				if ($COD_SIT=='06'){
					if($this->VL_MERC <= 0){
						$this->VL_MERC = $VL_BC_ICMS;
					}
				}

				$this->VL_FRT = $VL_FRT;
				$this->VL_SEG = $VL_SEG;
				$this->VL_OUT_DA = $VL_OUT_DA;
				$this->VL_BC_ICMS = $VL_BC_ICMS;
				$this->VL_ICMS = $VL_ICMS;
				$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
				$this->VL_ICMS_ST = $VL_ICMS_ST;
				$this->VL_IPI = $VL_IPI;
				$this->VL_PIS = $VL_PIS;
				$this->VL_COFINS = $VL_COFINS;
				$this->VL_PIS_ST = $VL_PIS_ST;
				$this->VL_COFINS_ST = $VL_COFINS_ST;
				if ($this->COD_MOD=='65'){
					$this->VL_OUT_DA+= $this->VL_ICMS_ST + $this->VL_IPI;
					$this->VL_BC_ICMS_ST = '';
					$this->VL_ICMS_ST = '';
					$this->VL_IPI = '';
					$this->VL_PIS = '';
					$this->VL_COFINS = '';
					$this->VL_PIS_ST = '';
					$this->VL_COFINS_ST = '';
					$this->IND_FRT = '9';
				}
			}
		}

		function LerRegistro(){

			return '|C100|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->NUM_DOC.'|'.
			$this->CHV_NFE.'|'.
			$this->DT_DOC.'|'.
			$this->DT_E_S.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			$this->IND_PGTO.'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_ABAT_NT,2,false).'|'.
			formata_qtd_sped($this->VL_MERC,2,false).'|'.
			$this->IND_FRT.'|'.
			formata_qtd_sped($this->VL_FRT,2,false).'|'.
			formata_qtd_sped($this->VL_SEG,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DA,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS_ST,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS_ST,2,false).'|'.
			fim_linha();
		}

	}

	class SF_Reg_C105 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $OPER;
		var $UF;

		function CriaRegistro($OPER, $UF){
			$this->OPER = fill_full(trim(substr(limpa_numero($OPER),0,1)),1);
			$this->UF = trim(substr(limpa_texto($UF),0,2));
		}

		function LerRegistro(){
			return '|C105|'.
			$this->OPER.'|'.
			$this->UF.'|'.
			fim_linha();
		}

	}

	class SF_Reg_C110 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_INF;
		var $TXT_COMPL;

		function CriaRegistro($COD_INF, $TXT_COMPL){
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->TXT_COMPL = trim(limpa_texto($TXT_COMPL));
		}
		
		function LerRegistro(){
			return '|C110|'.
			$this->COD_INF.'|'.
			$this->TXT_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C111 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_PROC;
		var $IND_PROC;

		function CriaRegistro($NUM_PROC, $IND_PROC){
			$this->NUM_PROC = trim(substr(limpa_texto($NUM_PROC),0,15));
			$this->IND_PROC = fill_full(trim(substr(limpa_numero($IND_PROC),0,1)),1);
			if (($this->IND_PROC==0)||($this->IND_PROC==2)){
				$this->IND_PROC = 9;
			}
		}
		function LerRegistro(){
			return '|C111|'.
			$this->NUM_PROC.'|'.
			$this->IND_PROC.'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C120 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_DOC_IMP;
		var $NUM_DOC_IMP;
		var $PIS_IMP;
		var $COFINS_IMP;
		var $NUM_ACDRAW;

		function CriaRegistro($COD_DOC_IMP, $NUM_DOC_IMP, $PIS_IMP,
			$COFINS_IMP, $NUM_ACDRAW){
			$this->COD_DOC_IMP = fill_full(trim(substr(limpa_texto($COD_DOC_IMP),0,1)),1);
			$this->NUM_DOC_IMP =  trim(substr(limpa_numero($NUM_DOC_IMP),-10));
			$this->PIS_IMP = $PIS_IMP;
			$this->COFINS_IMP = $COFINS_IMP;
			$this->NUM_ACDRAW = trim(substr(limpa_texto($NUM_ACDRAW),0,20));
		}
		
		function LerRegistro(){
			return '|C120|'.
			$this->COD_DOC_IMP.'|'.
			$this->NUM_DOC_IMP.'|'.
			formata_qtd_sped($this->PIS_IMP,2,false).'|'.
			formata_qtd_sped($this->COFINS_IMP,2,false).'|'.
			$this->NUM_ACDRAW.'|'.
			fim_linha();
		}
		
	}

	class SF_Reg_C170 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_ITEM;
		var $COD_ITEM;
		var $ID_ITEM;
		var $DESCR_COMPL;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;
		var $IND_MOV;
		var $CST_ICMS;
		var $CFOP;
		var $COD_NAT;
		var $VL_BC_ICMS;
		var $ALIQ_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $ALIQ_ST;
		var $VL_ICMS_ST;
		var $IND_APUR;
		var $CST_IPI;
		var $COD_ENQ;
		var $VL_BC_IPI;
		var $ALIQ_IPI;
		var $VL_IPI;
		var $CST_PIS;
		var $VL_BC_PIS;
		var $ALIQ_PIS;
		var $QUANT_BC_PIS;
		var $ALIQ_PISQ;
		var $VL_PIS;
		var $CST_COFINS;
		var $VL_BC_COFINS;
		var $ALIQ_COFINS;
		var $QUANT_BC_COFINS;
		var $ALIQ_COFINSQ;
		var $VL_COFINS;
		var $COD_CTA;

		var $UNID_FAT;
		var $UNID_OP;
		var $VL_OPER_SOMA;

		function CriaRegistro($NUM_ITEM, $ID_ITEM,
			$COD_ITEM, $DESCR_COMPL,
			$QTD,
			$UNID, $UNID_FAT, $UNID_OP,
			$VL_ITEM, $VL_DESC,
			$IND_MOV, $CST_ICMS, $CFOP, $COD_NAT,
			$VL_BC_ICMS, $ALIQ_ICMS, $VL_ICMS,
			$VL_BC_ICMS_ST, $ALIQ_ST, $VL_ICMS_ST,
			$IND_APUR, $CST_IPI, $COD_ENQ, $VL_BC_IPI,
			$ALIQ_IPI, $VL_IPI, $CST_PIS, $VL_BC_PIS,
			$ALIQ_PIS, $QUANT_BC_PIS, $ALIQ_PISQ,
			$VL_PIS, $CST_COFINS, $VL_BC_COFINS,
			$ALIQ_COFINS, $QUANT_BC_COFINS, $ALIQ_COFINSQ,
			$VL_COFINS, $COD_CTA, $VL_OPER_SOMA){
			$this->NUM_ITEM =  $NUM_ITEM;
			$this->ID_ITEM =  $ID_ITEM;
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->DESCR_COMPL = trim(limpa_texto($DESCR_COMPL));
			$this->QTD =  $QTD;
			if ($this->QTD<=0){
				$this->QTD = 1;
				$this->IND_MOV = 1;
			}
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->UNID_FAT = $UNID_FAT;
			$this->UNID_OP = $UNID_OP;
			if ($this->UNID_FAT<=0){
				$this->UNID_FAT = 1;
			}else if ($this->UNID_OP=='D'){
				$this->UNID_FAT = 1/$this->UNID_FAT;
				if ($this->UNID_FAT<=0){
					$this->UNID_FAT = 1;
				}
			}
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
			$this->IND_MOV = fill_full(trim(substr(limpa_numero($IND_MOV),0,1)),1);
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
			$this->COD_NAT = trim(substr(limpa_texto($COD_NAT),0,10));
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_BC_ICMS_ST = $VL_BC_ICMS_ST;
			$this->ALIQ_ST = $ALIQ_ST;
			$this->VL_ICMS_ST = $VL_ICMS_ST;
			$this->IND_APUR = fill_full(trim(substr(limpa_numero($IND_APUR),0,1)),1);
			$this->CST_IPI = fill_full(trim(substr(limpa_numero($CST_IPI),0,2)),2);
			$this->COD_ENQ = trim(substr(limpa_numero($COD_ENQ),0,3));
			if ($this->COD_ENQ!=''){
				$this->COD_ENQ = fill_full($this->COD_ENQ,3);
			}
			if ($this->COD_ENQ='999'){
				$this->COD_ENQ= '';
			}
			$this->VL_BC_IPI = $VL_BC_IPI;
			$this->ALIQ_IPI = $ALIQ_IPI;
			$this->VL_IPI = $VL_IPI;

			$this->CST_PIS = fill_full(trim(substr(limpa_numero($CST_PIS),0,2)),2);
			$this->VL_BC_PIS = $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->QUANT_BC_PIS = $QUANT_BC_PIS;
			$this->ALIQ_PISQ = $ALIQ_PISQ;
			$this->VL_PIS = $VL_PIS;

			$this->CST_COFINS = fill_full(trim(substr(limpa_numero($CST_COFINS),0,2)),2);
			$this->VL_BC_COFINS = $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->QUANT_BC_COFINS = $QUANT_BC_COFINS;
			$this->ALIQ_COFINSQ = $ALIQ_COFINSQ;
			$this->VL_COFINS = $VL_COFINS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->QUANT_BC_PIS==0){
				$this->QUANT_BC_PIS = '';
			}
			if ($this->ALIQ_PISQ==0){
				$this->ALIQ_PISQ = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}
			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->QUANT_BC_COFINS==0){
				$this->QUANT_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINSQ==0){
				$this->ALIQ_COFINSQ = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}
			$this->COD_CTA = trim(limpa_texto($COD_CTA));
			$this->VL_OPER_SOMA = $VL_OPER_SOMA;
		}
		
		function LerRegistro(){
			return '|C170|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			$this->DESCR_COMPL.'|'.
			formata_qtd_sped($this->QTD,5,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->IND_MOV.'|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			$this->COD_NAT.'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS_ST,2,false).'|'.
			formata_qtd_sped($this->ALIQ_ST,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS_ST,2,false).'|'.
			$this->IND_APUR.'|'.
			$this->CST_IPI.'|'.
			$this->COD_ENQ.'|'.
			formata_qtd_sped($this->VL_BC_IPI,2,false).'|'.
			formata_qtd_sped($this->ALIQ_IPI,2,false).'|'.
			formata_qtd_sped($this->VL_IPI,2,false).'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,3,false).'|'.
			formata_qtd_sped($this->ALIQ_PISQ,4,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,3,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINSQ,4,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}


	class SF_Reg_C175 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CFOP;
		var $VL_OPR=0;
		var $VL_DESC=0;
		var $CST_PIS;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $QUANT_BC_PIS = 0;
		var $ALIQ_PIS_QUANT = 0;
		var $VL_PIS=0;

		var $CST_COFINS;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $QUANT_BC_COFINS = 0;
		var $ALIQ_COFINS_QUANT = 0;
		var $VL_COFINS=0;

		var $COD_CTA;
		var $INFO_COMPL;

		function CriaRegistro($CFOP,$VL_OPR,$VL_DESC,
			$CST_PIS,$VL_BC_PIS,$ALIQ_PIS,$QUANT_BC_PIS,$ALIQ_PIS_QUANT,$VL_PIS,
			$CST_COFINS,$VL_BC_COFINS,$ALIQ_COFINS,$QUANT_BC_COFINS,$ALIQ_COFINS_QUANT,$VL_COFINS,
			$COD_CTA,$INFO_COMPL){

			if ($this->VL_BC_PIS==''){
				$this->VL_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS==''){
				$this->ALIQ_PIS = 0;
			}
			if ($this->QUANT_BC_PIS==''){
				$this->QUANT_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS_QUANT==''){
				$this->ALIQ_PIS_QUANT = 0;
			}
			if ($this->VL_PIS==''){
				$this->VL_PIS = 0;
			}

			if ($this->VL_BC_COFINS==''){
				$this->VL_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS==''){
				$this->ALIQ_COFINS = 0;
			}
			if ($this->QUANT_BC_COFINS==''){
				$this->QUANT_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS_QUANT==''){
				$this->ALIQ_COFINS_QUANT = 0;
			}
			if ($this->VL_COFINS==''){
				$this->VL_COFINS = 0;
			}

			$this->CFOP = $CFOP;
			$this->VL_OPR+= $VL_OPR;
			$this->VL_DESC+= $VL_DESC;

			$this->CST_PIS = $CST_PIS;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->QUANT_BC_PIS+= $QUANT_BC_PIS;
			$this->ALIQ_PIS_QUANT+= $ALIQ_PIS_QUANT;
			$this->VL_PIS+= $VL_PIS;

			$this->CST_COFINS = $CST_COFINS;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->QUANT_BC_COFINS+= $QUANT_BC_COFINS;
			$this->ALIQ_COFINS_QUANT+= $ALIQ_COFINS_QUANT;
			$this->VL_COFINS+= $VL_COFINS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->QUANT_BC_PIS==0){
				$this->QUANT_BC_PIS = '';
			}
			if ($this->ALIQ_PIS_QUANT==0){
				$this->ALIQ_PIS_QUANT = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}
			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->QUANT_BC_COFINS==0){
				$this->QUANT_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS_QUANT==0){
				$this->ALIQ_COFINS_QUANT = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->INFO_COMPL = trim(substr(limpa_texto($INFO_COMPL),0,60));
		}
		
		function LerRegistro(){
			return '|C175|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS_QUANT,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS_QUANT,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->INFO_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C300 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_MOD;
		var $SER;
		var $SUB;
		var $NUM_DOC_INI;
		var $NUM_DOC_FIN;
		var $DT_DOC;
		var $VL_DOC;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_CTA;

		function CriaRegistro($COD_MOD, $SER, $SUB,
			$NUM_DOC_INI,$NUM_DOC_FIN, $DT_DOC,
			$VL_DOC,$VL_PIS,$VL_COFINS,$COD_CTA ){
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC_INI =  trim(substr(limpa_numero($NUM_DOC_INI),-6));
			$this->NUM_DOC_FIN =  trim(substr(limpa_numero($NUM_DOC_FIN),-6));
			$this->DT_DOC =  str_replace('-','',datad($DT_DOC));
			$this->VL_DOC = $VL_DOC;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_CTA = trim(limpa_texto($COD_CTA));

		}
		
		function LerRegistro(){
			return '|C300|'.
			$this->COD_MOD.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC_INI.'|'.
			$this->NUM_DOC_FIN.'|'.
			$this->DT_DOC.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C310 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_DOC_CANC;
		function CriaRegistro($NUM_DOC_CANC){
			$this->NUM_DOC_CANC =  trim(substr(limpa_numero($NUM_DOC_CANC),-6));
		}			
		function LerRegistro(){
			return '|C310|'.
			$this->NUM_DOC_CANC.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C320 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR,$VL_BC_ICMS, $VL_ICMS,
			$VL_RED_BC,$COD_OBS ){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = trim(substr(limpa_numero($CFOP),0,4));
			$this->ALIQ_ICMS = $ALIQ_ICMS;
			$this->VL_OPR = $VL_OPR;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_RED_BC = $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|C320|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C321 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $COD_ITEM;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_PIS;
		var $VL_COFINS;

		function CriaRegistro($COD_ITEM, $QTD, $UNID,
			$VL_ITEM,$VL_DESC, $VL_BC_ICMS,
			$VL_ICMS,$VL_PIS,$VL_COFINS ){
			$this->COD_ITEM = trim(substr(limpa_numero($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->UNID = trim(substr(limpa_numero($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
		}
			
		function LerRegistro(){
			return '|C321|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,3,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
	}
			
	class SF_Reg_C350 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $SER;
		var $SUB_SER;
		var $NUM_DOC;
		var $DT_DOC;
		var $CNPJ_CPF;
		var $VL_MERC;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_CTA;

		function CriaRegistro($SER, $SUB_SER, $NUM_DOC,
			$DT_DOC,$CNPJ_CPF, $VL_MERC,
			$VL_DOC,$VL_DESC,
			$VL_PIS,$VL_COFINS,
			$COD_CTA ){
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB_SER = trim(substr(limpa_texto($SUB_SER),0,4));
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-6));
			$this->DT_DOC = str_replace('-','',datad($DT_DOC));
			$this->CNPJ_CPF = trim(substr(limpa_numero($CNPJ_CPF),0,14));
			if ((strlen($this->CNPJ_CPF)!=14)&&
				(strlen($this->CNPJ_CPF)!=11)){
				$this->CNPJ_CPF = '';
			}
			$this->VL_MERC = $VL_MERC;
			$this->VL_DOC = $VL_DOC;
			$this->VL_DESC = $VL_DESC;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_CTA = trim(limpa_texto($COD_CTA));
		}
		
		function LerRegistro(){
			return '|C350|'.
			$this->SER.'|'.
			$this->SUB_SER.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			$this->CNPJ_CPF.'|'.
			formata_qtd_sped($this->VL_MERC,2,false).'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C370 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $NUM_ITEM;
		var $COD_ITEM;
		var $QTD;
		var $UNID;
		var $VL_ITEM;
		var $VL_DESC;

		function CriaRegistro($NUM_ITEM, $COD_ITEM, $QTD,
			$UNID,$VL_ITEM, $VL_DESC){
			$this->NUM_ITEM = trim(substr(limpa_numero($NUM_ITEM),0,3));
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->QTD = $QTD;
			$this->UNID = trim(substr(limpa_texto($UNID),0,6));
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_DESC = $VL_DESC;
		}
		
		function LerRegistro(){
			return '|C370|'.
			$this->NUM_ITEM.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->QTD,2,false).'|'.
			$this->UNID.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C390 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_ICMS;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_OPR;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_RED_BC;
		var $COD_OBS;

		function CriaRegistro($CST_ICMS, $CFOP, $ALIQ_ICMS,
			$VL_OPR, $VL_BC_ICMS, $VL_ICMS,
			$VL_RED_BC, $COD_OBS){
			$this->CST_ICMS = fill_full(trim(substr(limpa_numero($CST_ICMS),0,3)),3);
			$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);

			$this->ALIQ_ICMS =  $ALIQ_ICMS;
			$this->VL_OPR =  $VL_OPR;
			$this->VL_BC_ICMS =  $VL_BC_ICMS;
			$this->VL_ICMS =  $VL_ICMS;
			$this->VL_RED_BC =  $VL_RED_BC;
			$this->COD_OBS = trim(substr(limpa_texto($COD_OBS),0,6));
		}
		
		function LerRegistro(){
			return '|C390|'.
			$this->CST_ICMS.'|'.
			$this->CFOP.'|'.
			formata_qtd_sped($this->ALIQ_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_OPR,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_RED_BC,2,false).'|'.
			$this->COD_OBS.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_MOD;
		var $ECF_MOD;
		var $ECF_FAB;
		var $ECF_CX;

		function CriaRegistro($COD_MOD, $ECF_MOD,
			$ECF_FAB, $ECF_CX){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->ECF_MOD = trim(substr(limpa_texto($ECF_MOD),0,20));
			$this->ECF_FAB = trim(substr(limpa_texto($ECF_FAB),0,20));
			$this->ECF_CX = trim(substr(limpa_numero($ECF_CX),0,3));
			if ($this->ECF_CX<1){
				$this->ECF_CX = 1;
			}
		}
		
		function LerRegistro(){
			return '|C400|'.
			$this->COD_MOD.'|'.
			$this->ECF_MOD.'|'.
			$this->ECF_FAB.'|'.
			$this->ECF_CX.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C405 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $DT_DOC;
		var $CRO;
		var $CRZ;
		var $NUM_COO_FIN;
		var $GT_FIN;
		var $VL_BRT;

		function CriaRegistro($DT_DOC, $CRO,
			$CRZ, $NUM_COO_FIN,
			$GT_FIN, $VL_BRT){
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->CRO = trim(substr(limpa_numero($CRO),-3));
			$this->CRZ = trim(substr(limpa_numero($CRZ),-6));
			$this->NUM_COO_FIN = trim(substr(limpa_numero($NUM_COO_FIN),-6));
			$this->GT_FIN = $GT_FIN;
			$this->VL_BRT = $VL_BRT;
		}
		
		function LerRegistro(){
			return '|C405|'.
			$this->DT_DOC.'|'.
			$this->CRO.'|'.
			$this->CRZ.'|'.
			$this->NUM_COO_FIN.'|'.
			formata_qtd_sped($this->GT_FIN,2,false).'|'.
			formata_qtd_sped($this->VL_BRT,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_C481 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_PIS;
		var $VL_ITEM=0;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $QUANT_BC_PIS=0;
		var $ALIQ_PIS_QUANT=0;
		var $VL_PIS=0;
		var $COD_ITEM;
		var $ID_ITEM;
		var $COD_CTA;

		function CriaRegistro($CST_PIS, $VL_ITEM, $VL_BC_PIS,
			$ALIQ_PIS, $QUANT_BC_PIS, $ALIQ_PIS_QUANT,
			$VL_PIS, $COD_ITEM, $ID_ITEM, $COD_CTA){
			if ($this->VL_BC_PIS==''){
				$this->VL_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS==''){
				$this->ALIQ_PIS = 0;
			}
			if ($this->QUANT_BC_PIS==''){
				$this->QUANT_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS_QUANT==''){
				$this->ALIQ_PIS_QUANT = 0;
			}
			if ($this->VL_PIS==''){
				$this->VL_PIS = 0;
			}
			$this->CST_PIS = $CST_PIS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->QUANT_BC_PIS+= $QUANT_BC_PIS;
			$this->ALIQ_PIS_QUANT = $ALIQ_PIS_QUANT;
			$this->VL_PIS+= $VL_PIS;
			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->QUANT_BC_PIS==0){
				$this->QUANT_BC_PIS = '';
			}
			if ($this->ALIQ_PIS_QUANT==0){
				$this->ALIQ_PIS_QUANT = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|C481|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS_QUANT,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->COD_ITEM.'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_C485 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_COFINS;
		var $VL_ITEM=0;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $QUANT_BC_COFINS=0;
		var $ALIQ_COFINS_QUANT=0;
		var $VL_COFINS=0;
		var $COD_ITEM;
		var $ID_ITEM;
		var $COD_CTA;

		function CriaRegistro($CST_COFINS, $VL_ITEM, $VL_BC_COFINS,
			$ALIQ_COFINS, $QUANT_BC_COFINS, $ALIQ_COFINS_QUANT,
			$VL_COFINS, $COD_ITEM, $ID_ITEM, $COD_CTA){

			if ($this->VL_BC_COFINS==''){
				$this->VL_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS==''){
				$this->ALIQ_COFINS = 0;
			}
			if ($this->QUANT_BC_COFINS==''){
				$this->QUANT_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS_QUANT==''){
				$this->ALIQ_COFINS_QUANT = 0;
			}
			if ($this->VL_COFINS==''){
				$this->VL_COFINS = 0;
			}

			$this->CST_COFINS = $CST_COFINS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->QUANT_BC_COFINS+= $QUANT_BC_COFINS;
			$this->ALIQ_COFINS_QUANT = $ALIQ_COFINS_QUANT;
			$this->VL_COFINS+= $VL_COFINS;

			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->QUANT_BC_COFINS==0){
				$this->QUANT_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS_QUANT==0){
				$this->ALIQ_COFINS_QUANT = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}

			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|C485|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS_QUANT,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_ITEM.'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	//apesar desses registros n? existirem no layout eles precisam ser gerados para proporcionalizar os descontos dos itens
	//pore? os valores n? usados podem ser descartados

	class SF_Reg_C460 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_MOD;
		var $COD_SIT;
		var $NUM_DOC;
		var $DT_DOC;
		var $VL_DOC;


		function CriaRegistro($COD_MOD, $COD_SIT, $NUM_DOC,
			$DT_DOC, $VL_DOC){
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-6));
			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				$this->DT_DOC = '';
				$this->VL_DOC = '';
			}else{
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->VL_DOC = $VL_DOC;
			}
		}
	}

	class SF_Reg_C470 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_ITEM;
		var $ID_ITEM;
		var $QTD=1;
		var $VL_ITEM;
		var $CFOP;
		var $ALIQ_ICMS;
		var $VL_PIS;
		var $VL_COFINS;
		var $COD_TOT_PAR;
		var $DESC_PROPORCIONAL=0;
		var $VALOR_REAL=0;

		function CriaRegistro($COD_ITEM, $ID_ITEM,
			$VL_ITEM, $COD_TOT_PAR,
			$VL_PIS, $VL_COFINS){
			$this->COD_ITEM = trim(substr(limpa_texto($COD_ITEM),0,60));
			$this->ID_ITEM = $ID_ITEM;
			$this->VL_ITEM = $VL_ITEM;
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			$this->COD_TOT_PAR = $COD_TOT_PAR;

			$ORIGEM = '0';
			$con_pro = 'select Origem,Codigo_Fornecedor from produto '.
						' where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Id_Produto="'.$this->ID_ITEM.'"';
			$res_pro = consulta_sql($con_pro);
			$reg_pro = consulta_ler_linha($res_pro);
			consulta_limpa($res_pro);

			if($ORIGEM==''){
				//consulta produto
				$ORIGEM = $reg_pro[0];
			}

			$this->CFOP = '5102';
			$this->ALIQ_ICMS = 0;
			if ((substr($this->COD_TOT_PAR,2,1))=='S'){
				$this->CST_ICMS = '41';
				$this->CFOP = '5933';
			}else if ((substr($this->COD_TOT_PAR,1,1))=='S'){
				$this->CST_ICMS = '41';
				$this->CFOP = '5933';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='I'){
				$this->CST_ICMS = '40';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='N'){
				$this->CST_ICMS = '41';
			}else if ((substr($this->COD_TOT_PAR,0,1))=='F'){
				$this->CST_ICMS = '60';
				$this->CFOP = '5405';
			}else{
				$this->CST_ICMS = '00';
				$this->ALIQ_ICMS = substr($this->COD_TOT_PAR,3,4)/100;
			}
			if ($reg_pro[1]==1){
				if ($this->CFOP=='5405'){
					$this->CFOP='5401';
				}
				if ($this->CFOP=='5102'){
					$this->CFOP='5101';
				}
			}
			$this->CST_ICMS = $ORIGEM.$this->CST_ICMS;
			$this->VALOR_REAL = arredonda_numero_menos(($this->VL_ITEM - $this->DESC_PROPORCIONAL)*100)/100;
			if ($this->VALOR_REAL<0.01){
				$this->VALOR_REAL = 0.01;
			}
		}
		
		function DescontoRegistro($DESCONTO){
			$this->DESC_PROPORCIONAL+= $DESCONTO;
			$this->VALOR_REAL = arredonda_numero_menos( ($this->VL_ITEM - $this->DESC_PROPORCIONAL)*100)/100;
			if ($this->VALOR_REAL<=0.01){
				$this->VALOR_REAL = 0.01;
			}
		}
		
	}


	class SF_Reg_C500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $COD_CONS;
		var $NUM_DOC;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_FORN;
		var $VL_SERV_NT;
		var $VL_TERC;
		var $VL_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_BC_ICMS_ST;
		var $VL_ICMS_ST;
		var $COD_INF;
		var $VL_PIS;
		var $VL_COFINS;
		var $TP_LIGACAO;
		var $COD_GRUPO_TENSAO;
		var $CHV_DOCe;
		var $tem_final=false;

		function CriaRegistro($COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$NUM_DOC, $DT_DOC,
			$DT_E_S, $VL_DOC, $VL_ICMS,
			$COD_INF, $VL_PIS, $VL_COFINS,
			$CHV_DOCe, $tem_final){
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));
			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->DT_E_S = str_replace('/','',$DT_E_S);
			$this->VL_DOC = $VL_DOC;
			$this->VL_ICMS = $VL_ICMS;
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
			if ($this->COD_MOD=='66'){
				$this->CHV_DOCe = $CHV_DOCe;
			}else{
				$this->CHV_DOCe = '';
			}
			$this->tem_final = $tem_final;
		}
		
		function LerRegistro(){
			$final_2020 = '';
			if ($this->tem_final){
				$final_2020 = $this->CHV_DOCe.'|';
			}
			return '|C500|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			$this->DT_E_S.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_INF.'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$final_2020.
			fim_linha();
		}
	}


	class SF_Reg_C501 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_PIS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $VL_PIS=0;
		var $COD_CTA;

		function CriaRegistro($CST_PIS, $VL_ITEM, $NAT_BC_CRED, $VL_BC_PIS,
			$ALIQ_PIS, $VL_PIS, $COD_CTA){

			if ($this->VL_BC_PIS==''){
				$this->VL_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS==''){
				$this->ALIQ_PIS = 0;
			}
			if ($this->VL_PIS==''){
				$this->VL_PIS = 0;
			}


			$this->CST_PIS = $CST_PIS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->VL_PIS+= $VL_PIS;


			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
			
		function LerRegistro(){
			return '|C501|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}


	class SF_Reg_C505 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_COFINS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $VL_COFINS=0;
		var $COD_CTA;

		function CriaRegistro($CST_COFINS, $VL_ITEM, $NAT_BC_CRED, $VL_BC_COFINS,
			$ALIQ_COFINS, $VL_COFINS, $COD_CTA){
			if ($this->VL_BC_COFINS==''){
				$this->VL_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS==''){
				$this->ALIQ_COFINS = 0;
			}
			if ($this->VL_COFINS==''){
				$this->VL_COFINS = 0;
			}

			$this->CST_COFINS = $CST_COFINS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->VL_COFINS+= $VL_COFINS;

			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|C505|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}
	//bloco d Transportte

	//regsitros bloco D
	class SF_Reg_D010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_EST;
		var $CNPJ;

		function CriaRegistro($COD_EST, $CNPJ){
			$this->COD_EST = trim(substr(limpa_texto($COD_EST),0,60));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
		}

		function LerRegistro(){
			return '|D010|'.
			$this->CNPJ.'|'.
			fim_linha();
		}

	}

	class SF_Reg_D100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $CHV_CTE;
		var $DT_DOC;
		var $DT_A_P;
		var $TP_CTE;
		var $CHV_CTE_REF;
		var $VL_DOC;
		var $VL_DESC;
		var $IND_FRT;
		var $VL_SERV;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $VL_NT;
		var $COD_INF;
		var $COD_CTA;

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$NUM_DOC, $CHV_CTE, $DT_DOC,
			$DT_A_P, $TP_CTE, $CHV_CTE_REF,
			$VL_DOC, $VL_DESC, $IND_FRT, $VL_SERV,
			$VL_BC_ICMS, $VL_ICMS,
			$VL_NT, $COD_INF, $COD_CTA, $considera_data=false){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_numero($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,3));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			$this->SUB = trim(substr(limpa_texto($SUB),0,2));
			$this->NUM_DOC =  trim(substr(limpa_numero($NUM_DOC),-9));

			if (($this->COD_SIT=='02')||
				($this->COD_SIT=='03')||
				($this->COD_SIT=='04')||
				($this->COD_SIT=='05')){
				if ((($this->COD_MOD=='55')||
					($this->COD_MOD=='65')||
					($this->COD_MOD=='57')||
					($this->COD_MOD=='67'))&&
					(data2nr($DT_A_P)>=data2nr('01/01/2011'))){
					$this->CHV_CTE = $CHV_CTE;
				}else{
					$this->CHV_CTE = '';
				}
				if ($considera_data){
					$this->DT_DOC = str_replace('-','',datad($DT_DOC));
					$this->DT_A_P = str_replace('-','',datad($DT_A_P));
				}else{
					$this->DT_DOC = '';
					$this->DT_A_P = '';
				}
				$this->TP_CTE = '';
				$this->CHV_CTE_REF = '';
				$this->VL_DOC = '';
				$this->VL_DESC = '';
				$this->IND_FRT = '';

				$this->VL_SERV = '';
				$this->VL_BC_ICMS = '';
				$this->VL_ICMS = '';
				$this->VL_NT = '';

				$this->COD_INF = '';
				$this->COD_CTA = '';

			}else{
				if (($this->COD_MOD=='55')||
					($this->COD_MOD=='65')||
					($this->COD_MOD=='57')||
					($this->COD_MOD=='67')){
					$this->CHV_CTE = $CHV_CTE;
				}else{
					$this->CHV_CTE = '';
				}
				$this->DT_DOC = str_replace('/','',$DT_DOC);
				$this->DT_A_P = str_replace('/','',$DT_A_P);

				$this->TP_CTE = fill_full(trim(substr(limpa_numero($TP_CTE),0,1)),1);
				$this->CHV_CTE_REF = trim(substr(limpa_numero($TP_CTE),0,44));
				if (strlen($this->CHV_CTE_REF)!=44){
					$this->CHV_CTE_REF = '';
				}

				$this->VL_DOC = $VL_DOC;
				$this->VL_DESC = $VL_DESC;
				$this->IND_FRT = fill_full(trim(substr(limpa_numero($IND_FRT),0,1)),1);
				//a partir de 2012 muda os n?eros
				if (data2nr($DT_A_P)>=data2nr('01/07/2012')){
					if ($this->IND_FRT=='0'){
						$this->IND_FRT = '2';
					}else if ($this->IND_FRT=='1'){
						$this->IND_FRT = '0';
					}else if ($this->IND_FRT=='2'){
						$this->IND_FRT = '1';
					}
				}

				$this->VL_SERV = $VL_SERV;
				$this->VL_BC_ICMS = $VL_BC_ICMS;
				$this->VL_ICMS = $VL_ICMS;
				$this->VL_NT = $VL_NT;

				$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
				$this->COD_CTA = trim(limpa_texto($COD_CTA));
			}
		}

		function LerRegistro(){
			return '|D100|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->CHV_CTE.'|'.
			$this->DT_DOC.'|'.
			$this->DT_A_P.'|'.
			$this->TP_CTE.'|'.
			$this->CHV_CTE_REF.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			$this->IND_FRT.'|'.
			formata_qtd_sped($this->VL_SERV,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_NT,2,false).'|'.
			$this->COD_INF.'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_D101 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_NAT_FRT;
		var $CST_PIS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $VL_PIS=0;
		var $COD_CTA='';

		function CriaRegistro($IND_NAT_FRT,
			$VL_ITEM, $CST_PIS, $NAT_BC_CRED, $VL_BC_PIS,
			$ALIQ_PIS, $VL_PIS, $COD_CTA){

			if ($this->VL_BC_PIS==''){
				$this->VL_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS==''){
				$this->ALIQ_PIS = 0;
			}
			if ($this->VL_PIS==''){
				$this->VL_PIS = 0;
			}

			$this->IND_NAT_FRT = $IND_NAT_FRT;
			$this->CST_PIS = $CST_PIS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->VL_PIS+= $VL_PIS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|D101|'.
			$this->IND_NAT_FRT.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->CST_PIS.'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}
			
	class SF_Reg_D105 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_NAT_FRT;
		var $CST_COFINS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $VL_COFINS=0;
		var $COD_CTA='';

		function CriaRegistro($IND_NAT_FRT,
			$VL_ITEM, $CST_COFINS, $NAT_BC_CRED, $VL_BC_COFINS,
			$ALIQ_COFINS, $VL_COFINS, $COD_CTA){

			if ($this->VL_BC_COFINS==''){
				$this->VL_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS==''){
				$this->ALIQ_COFINS = 0;
			}
			if ($this->VL_COFINS==''){
				$this->VL_COFINS = 0;
			}

			$this->IND_NAT_FRT = $IND_NAT_FRT;
			$this->CST_COFINS = $CST_COFINS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->VL_COFINS+= $VL_COFINS;

			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
			
		function LerRegistro(){
			return '|D105|'.
			$this->IND_NAT_FRT.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->CST_COFINS.'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}

	class SF_Reg_D500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_MOD;
		var $COD_SIT;
		var $SER;
		var $SUB;
		var $NUM_DOC;
		var $DT_DOC;
		var $DT_E_S;
		var $VL_DOC;
		var $VL_DESC;
		var $VL_SERV;
		var $VL_SERV_NT;
		var $VL_TERC;
		var $VL_DA;
		var $VL_BC_ICMS;
		var $VL_ICMS;
		var $COD_INF;
		var $VL_PIS;
		var $VL_COFINS;


		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_MOD, $COD_SIT, $SER, $SUB,
			$NUM_DOC, $DT_DOC, $DT_E_S,

			$VL_DOC, $VL_DESC, $VL_SERV,
			$VL_SERV_NT, $VL_TERC, $VL_DA,
			$VL_BC_ICMS, $VL_ICMS,
			$COD_INF, $VL_PIS, $VL_COFINS){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else{
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));
			$this->COD_MOD = fill_full(trim(substr(limpa_texto($COD_MOD),0,2)),2);
			$this->COD_SIT = fill_full(trim(substr(limpa_numero($COD_SIT),0,2)),2);
			$this->SER = trim(substr(limpa_texto($SER),0,4));

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			$this->SUB = trim(substr(limpa_texto($SUB),0,3));
			$this->NUM_DOC = trim(substr(limpa_numero($NUM_DOC),-9));
			$this->DT_DOC = str_replace('/','',$DT_DOC);
			$this->DT_E_S = str_replace('/','',$DT_E_S);
			$this->VL_DOC = $VL_DOC;
			$this->VL_DESC = $VL_DESC;
			$this->VL_SERV = $VL_SERV;
			$this->VL_SERV_NT = $VL_SERV_NT;
			$this->VL_TERC = $VL_TERC;
			$this->VL_DA = $VL_DA;
			$this->VL_BC_ICMS = $VL_BC_ICMS;
			$this->VL_ICMS = $VL_ICMS;
			if ($this->VL_ICMS<=0){
				$this->VL_BC_ICMS = 0;
			}
			$this->COD_INF = trim(substr(limpa_texto($COD_INF),0,6));
			$this->VL_PIS = $VL_PIS;
			$this->VL_COFINS = $VL_COFINS;
		}
		
		function LerRegistro(){
			return '|D500|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->COD_MOD.'|'.
			$this->COD_SIT.'|'.
			$this->SER.'|'.
			$this->SUB.'|'.
			$this->NUM_DOC.'|'.
			$this->DT_DOC.'|'.
			$this->DT_E_S.'|'.
			formata_qtd_sped($this->VL_DOC,2,false).'|'.
			formata_qtd_sped($this->VL_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_SERV,2,false).'|'.
			formata_qtd_sped($this->VL_SERV_NT,2,false).'|'.
			formata_qtd_sped($this->VL_TERC,2,false).'|'.
			formata_qtd_sped($this->VL_DA,2,false).'|'.
			formata_qtd_sped($this->VL_BC_ICMS,2,false).'|'.
			formata_qtd_sped($this->VL_ICMS,2,false).'|'.
			$this->COD_INF.'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_D501 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_PIS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $VL_PIS=0;
		var $COD_CTA;

		function CriaRegistro($CST_PIS, $VL_ITEM, $NAT_BC_CRED, $VL_BC_PIS,
			$ALIQ_PIS, $VL_PIS, $COD_CTA){
			if ($this->VL_BC_PIS==''){
				$this->VL_BC_PIS = 0;
			}
			if ($this->ALIQ_PIS==''){
				$this->ALIQ_PIS = 0;
			}
			if ($this->VL_PIS==''){
				$this->VL_PIS = 0;
			}

			$this->CST_PIS = $CST_PIS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->VL_PIS+= $VL_PIS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|D501|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_D505 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_COFINS;
		var $VL_ITEM=0;
		var $NAT_BC_CRED;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $VL_COFINS=0;
		var $COD_CTA;

		function CriaRegistro($CST_COFINS, $VL_ITEM, $NAT_BC_CRED, $VL_BC_COFINS,
			$ALIQ_COFINS, $VL_COFINS, $COD_CTA){

			if ($this->VL_BC_COFINS==''){
				$this->VL_BC_COFINS = 0;
			}
			if ($this->ALIQ_COFINS==''){
				$this->ALIQ_COFINS = 0;
			}
			if ($this->VL_COFINS==''){
				$this->VL_COFINS = 0;
			}

			$this->CST_COFINS = $CST_COFINS;
			$this->VL_ITEM+= $VL_ITEM;
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->VL_COFINS+= $VL_COFINS;

			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}

			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
		}
		
		function LerRegistro(){
			return '|D505|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_ITEM,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
		
	}

	//bloco F locao de bens m?eis

	//regsitros bloco F
	class SF_Reg_F010 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_EST;
		var $CNPJ;

		function CriaRegistro($COD_EST, $CNPJ){
			$this->COD_EST = trim(substr(limpa_texto($COD_EST),0,60));
			$this->CNPJ = trim(substr(limpa_numero($CNPJ),0,14));
		}

		function LerRegistro(){
			return '|F010|'.
			$this->CNPJ.'|'.
			fim_linha();
		}

	}


	class SF_Reg_F100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $IND_OPER;
		var $IND_EMIT;
		var $COD_PART;
		var $COD_ITEM;
		var $ID_ITEM;
		var $DT_OPER;
		var $VL_OPER;

		var $CST_PIS;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $VL_PIS=0;

		var $CST_COFINS;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $VL_COFINS=0;

		var $NAT_BC_CRED;
		var $IND_ORIG_CRED;
		var $COD_CTA;
		var $COD_CCUS;

		var $DESC_DOC_OPER='LOCAO DE BENS M?EIS';

		function CriaRegistro($IND_OPER, $IND_EMIT, $COD_PART,
			$COD_ITEM, $ID_ITEM, $DT_OPER,
			$VL_OPER, $CST_PIS, $VL_BC_PIS,
			$ALIQ_PIS, $VL_PIS, $CST_COFINS,
			$VL_BC_COFINS, $ALIQ_COFINS,
			$VL_COFINS, $NAT_BC_CRED,
			$IND_ORIG_CRED, $COD_CTA, $COD_CCUS){
			$this->IND_OPER = fill_full(trim(substr(limpa_numero($IND_OPER),0,1)),1);
			if ($IND_EMIT=='P'){
				$IND_EMIT = '0';
			}else if ($IND_EMIT=='T'){
				$IND_EMIT = '1';
			}
			$this->IND_EMIT = fill_full(trim(substr(limpa_numero($IND_EMIT),0,1)),1);
			$this->COD_PART = trim(substr(limpa_texto($COD_PART),0,60));

			$this->DT_OPER = str_replace('/','',$DT_OPER);

			$this->VL_OPER = $VL_OPER;
			$this->CST_PIS = $CST_PIS;
			$this->VL_BC_PIS = $VL_BC_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->VL_PIS = $VL_PIS;
			$this->CST_COFINS = $CST_COFINS;
			$this->VL_BC_COFINS = $VL_BC_COFINS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->VL_COFINS = $VL_COFINS;

			if ($this->VL_BC_PIS==0){
				$this->VL_BC_PIS = '';
			}
			if ($this->ALIQ_PIS==0){
				$this->ALIQ_PIS = '';
			}
			if ($this->VL_PIS==0){
				$this->VL_PIS = '';
			}
			if ($this->VL_BC_COFINS==0){
				$this->VL_BC_COFINS = '';
			}
			if ($this->ALIQ_COFINS==0){
				$this->ALIQ_COFINS = '';
			}
			if ($this->VL_COFINS==0){
				$this->VL_COFINS = '';
			}
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->IND_ORIG_CRED = $IND_ORIG_CRED;
			$this->COD_CTA = trim(substr(limpa_texto($COD_CTA),0,60));
			$this->COD_CCUS = trim(substr(limpa_texto($COD_CCUS),0,60));
		}

		function LerRegistro(){

			return '|F100|'.
			$this->IND_OPER.'|'.
			$this->IND_EMIT.'|'.
			$this->COD_PART.'|'.
			$this->DT_OPER.'|'.
			formata_qtd_sped($this->VL_OPER,2,false).'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->NAT_BC_CRED.'|'.
			$this->IND_ORIG_CRED.'|'.
			$this->COD_CTA.'|'.
			$this->COD_CCUS.'|'.
			$this->DESC_DOC_OPER.'|'.
			fim_linha();
		}

	}

	//regsitros bloco F
	class SF_Reg_F500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $VL_REC_CAIXA=0;
		var $CST_PIS='';
		var $VL_DESC_PIS=0;
		var $VL_BC_PIS=0;
		var $ALIQ_PIS=0;
		var $VL_PIS=0;
		var $CST_COFINS='';
		var $VL_DESC_COFINS=0;
		var $VL_BC_COFINS=0;
		var $ALIQ_COFINS=0;
		var $VL_COFINS=0;
		var $COD_MOD='';
		var $CFOP='';
		var $COD_CTA='';
		var $INFO_COMPL='';

		function CriaRegistroBase($COD_MOD, $CST_PIS, $ALIQ_PIS, $ALIQ_COFINS){
			$this->COD_MOD = $COD_MOD;
			$this->CST_PIS = $CST_PIS;
			$this->CST_COFINS = $CST_PIS;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
		}

		function SomaRegistro($VL_BC,$VL_BASE){
			$this->VL_REC_CAIXA+= $VL_BC;
			if ($this->ALIQ_PIS>0){
				$this->VL_BC_PIS+=    $VL_BASE;
				$this->VL_BC_COFINS+= $VL_BASE;

				$this->VL_PIS    = ($this->VL_BC_PIS    * ($this->ALIQ_PIS/100));
				$this->VL_COFINS = ($this->VL_BC_COFINS * ($this->ALIQ_COFINS/100));
			}
		}

		function LerRegistro(){
			return '|F500|'.
			formata_qtd_sped($this->VL_REC_CAIXA,2,false).'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_DESC_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->VL_PIS,2,false).'|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_DESC_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->VL_COFINS,2,false).'|'.
			$this->COD_MOD.'|'.
			$this->CFOP.'|'.
			$this->COD_CTA.'|'.
			$this->INFO_COMPL.'|'.
			fim_linha();
		}

	}

	//regsitros bloco F
	class SF_Reg_F525 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $VL_REC=0;
		var $IND_REC='';
		var $CNPJ_CPF='';
		var $NUM_DOC='';
		var $COD_ITEM='';
		var $VL_REC_DET=0;
		var $CST_PIS='';
		var $CST_COFINS='';
		var $INFO_COMPL='';
		var $COD_CTA='';

		function CriaRegistroBase($IND_REC, $CNPJ_CPF, $NUM_DOC,
			$CST_PIS, $CST_COFINS){
			$this->IND_REC    = $IND_REC;
			$this->CNPJ_CPF   = $CNPJ_CPF;
			$this->NUM_DOC    = $NUM_DOC;
			$this->CST_PIS    = $CST_PIS;
			$this->CST_COFINS = $CST_COFINS;
		}

		function SomaRegistro($VL_REC){
			$this->VL_REC+=     $VL_REC;
			$this->VL_REC_DET+= $VL_REC;
		}

		function LerRegistro(){
			return '|F525|'.
			formata_qtd_sped($this->VL_REC,2,false).'|'.
			$this->IND_REC.'|'.
			$this->CNPJ_CPF.'|'.
			$this->NUM_DOC.'|'.
			$this->COD_ITEM.'|'.
			formata_qtd_sped($this->VL_REC_DET,2,false).'|'.
			$this->CST_PIS.'|'.
			$this->CST_COFINS.'|'.
			$this->INFO_COMPL.'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}

	}

	class SF_Reg_M100 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CRED;
		var $IND_CRED_ORI;
		var $IND_DESC_CRED;
		var $ALIQ_PIS;
		var $ALIQ_PIS_QUANT;
		var $VL_BC_PIS=0;
		var $QUANT_BC_PIS=0;
		var $VL_CRED=0;
		var $VL_AJUS_ACRES=0;
		var $VL_AJUS_REDUC=0;
		var $VL_CRED_DIF=0;
		var $VL_CRED_DISP=0;
		var $SLD_CRED=0;
		var $VL_CRED_DESC=0;

		function CriaRegistro($COD_CRED, $IND_CRED_ORI, $IND_DESC_CRED,
			$ALIQ_PIS, $ALIQ_PIS_QUANT){

			$this->COD_CRED = $COD_CRED;
			$this->IND_CRED_ORI = $IND_CRED_ORI;
			$this->IND_DESC_CRED = $IND_DESC_CRED;

			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->ALIQ_PIS_QUANT = $ALIQ_PIS_QUANT;
		}

		function SomaRegistro($VL_BC_PIS, $QUANT_BC_PIS, $VL_CRED,
			$VL_AJUS_ACRES, $VL_AJUS_REDUC, $VL_CRED_DIF,
			$VL_CRED_DESC){

			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->QUANT_BC_PIS+= $QUANT_BC_PIS;
			$this->VL_CRED+= $VL_CRED;
			$this->VL_AJUS_ACRES+= $VL_AJUS_ACRES;
			$this->VL_AJUS_REDUC+= $VL_AJUS_REDUC;
			$this->VL_CRED_DIF+= $VL_CRED_DIF;
			$this->VL_CRED_DESC = $VL_CRED_DESC;

			$this->VL_CRED_DISP = ($this->VL_CRED + $this->VL_AJUS_ACRES) - ($this->VL_AJUS_REDUC + $this->VL_CRED_DIF);
			if ($this->VL_CRED_DISP < 0){
				$this->VL_CRED_DISP = 0;
			}
			if ($this->VL_CRED_DESC > $this->VL_CRED_DISP){
				$this->VL_CRED_DESC = $this->VL_CRED_DISP;
			}
			$this->SLD_CRED = $this->VL_CRED_DISP - $this->VL_CRED_DESC;
			if ($this->SLD_CRED < 0){
				$this->SLD_CRED = 0;
			}
			if ($this->SLD_CRED>0){
				$this->IND_DESC_CRED = '1';
			}else{
				$this->IND_DESC_CRED = '0';
			}
		}

		function LerRegistro(){
			return '|M100|'.
			$this->COD_CRED.'|'.
			$this->IND_CRED_ORI.'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,2,false).'|'.
			//formata_qtd_sped($this->ALIQ_PIS_QUANT,2,false).
			'|'.
			formata_qtd_sped($this->VL_CRED,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_ACRES,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_REDUC,2,false).'|'.
			formata_qtd_sped($this->VL_CRED_DIF,2,false).'|'.
			formata_qtd_sped($this->VL_CRED_DISP,2,false).'|'.
			$this->IND_DESC_CRED.'|'.
			formata_qtd_sped($this->VL_CRED_DESC,2,false).'|'.
			formata_qtd_sped($this->SLD_CRED,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M105 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NAT_BC_CRED;
		var $CST_PIS;
		var $DESC_CRED;
		var $VL_BC_PIS_TOT=0;
		var $VL_BC_PIS_CUM=0;
		var $VL_BC_PIS_NC=0;
		var $VL_BC_PIS=0;
		var $QUANT_BC_PIS_TOT=0;
		var $QUANT_BC_PIS=0;

		function CriaRegistro($NAT_BC_CRED, $CST_PIS, $DESC_CRED){
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->CST_PIS = $CST_PIS;
			$this->DESC_CRED = $DESC_CRED;
		}

		function SomaRegistro($VL_BC_PIS_TOT, $VL_BC_PIS_CUM, $VL_BC_PIS_NC,
			$VL_BC_PIS, $QUANT_BC_PIS_TOT, $QUANT_BC_PIS){
			$this->VL_BC_PIS_TOT+= $VL_BC_PIS_TOT;
			$this->VL_BC_PIS_CUM+= $VL_BC_PIS_CUM;
			$this->VL_BC_PIS_NC+= $VL_BC_PIS_NC;
			$this->VL_BC_PIS+= $VL_BC_PIS;
			$this->QUANT_BC_PIS_TOT+= $QUANT_BC_PIS_TOT;
			$this->QUANT_BC_PIS+= $QUANT_BC_PIS;
		}


		function LerRegistro(){
			return '|M105|'.
			$this->NAT_BC_CRED.'|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_BC_PIS_TOT,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS_NC,2,false).'|'.
			formata_qtd_sped($this->VL_BC_PIS,2,false).'|'.
			//formata_qtd_sped($this->QUANT_BC_PIS_TOT,2,false).
			'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,2,false).'|'.
			$this->DESC_CRED.'|'.
			fim_linha();
		}
	}

	class SF_Reg_M200 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $VL_TOT_CONT_NC_PER=0;
		var $VL_TOT_CRED_DESC=0;
		var $VL_TOT_CRED_DESC_ANT=0;
		var $VL_TOT_CONT_NC_DEV=0;
		var $VL_RET_NC=0;
		var $VL_OUT_DED_NC=0;
		var $VL_CONT_NC_REC=0;
		var $VL_TOT_CONT_CUM_PER=0;
		var $VL_RET_CUM=0;
		var $VL_OUT_DED_CUM=0;
		var $VL_CONT_CUM_REC=0;
		var $VL_TOT_CONT_REC=0;

		function SomaRegistro($VL_TOT_CONT_NC_PER, $VL_TOT_CRED_DESC, $VL_TOT_CRED_DESC_ANT,
			$VL_RET_NC, $VL_OUT_DED_NC, $VL_TOT_CONT_CUM_PER,
			$VL_RET_CUM,$VL_OUT_DED_CUM){

			$this->VL_TOT_CONT_NC_PER+= $VL_TOT_CONT_NC_PER;
			$this->VL_TOT_CRED_DESC+= $VL_TOT_CRED_DESC;
			$this->VL_TOT_CRED_DESC_ANT+= $VL_TOT_CRED_DESC_ANT;
			$this->VL_RET_NC+= $VL_RET_NC;
			$this->VL_OUT_DED_NC+= $VL_OUT_DED_NC;
			$this->VL_TOT_CONT_CUM_PER+= $VL_TOT_CONT_CUM_PER;
			$this->VL_RET_CUM+= $VL_RET_CUM;
			$this->VL_OUT_DED_CUM+= $VL_OUT_DED_CUM;

			$this->VL_TOT_CONT_NC_DEV = $this->VL_TOT_CONT_NC_PER - ($this->VL_TOT_CRED_DESC + $this->VL_TOT_CRED_DESC_ANT);
			if ($this->VL_TOT_CONT_NC_DEV<0){
				$this->VL_TOT_CONT_NC_DEV = 0;
			}

			$this->VL_CONT_NC_REC = $this->VL_TOT_CONT_NC_DEV - ($this->VL_RET_NC + $this->VL_OUT_DED_NC);
			if ($this->VL_CONT_NC_REC<0){
				$this->VL_CONT_NC_REC = 0;
			}

			$this->VL_CONT_CUM_REC = $this->VL_TOT_CONT_CUM_PER - ($this->VL_RET_CUM + $this->VL_OUT_DED_CUM);
			if ($this->VL_CONT_CUM_REC<0){
				$this->VL_CONT_CUM_REC = 0;
			}

			$this->VL_TOT_CONT_REC = $this->VL_CONT_NC_REC - $this->VL_CONT_CUM_REC;
			if ($this->VL_TOT_CONT_REC<0){
				$this->VL_TOT_CONT_REC = 0;
			}
		}

		function LerRegistro(){
			return '|M200|'.
			formata_qtd_sped($this->VL_TOT_CONT_NC_PER,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CRED_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CRED_DESC_ANT,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_NC_DEV,2,false).'|'.
			formata_qtd_sped($this->VL_RET_NC,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DED_NC,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_NC_REC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_CUM_PER,2,false).'|'.
			formata_qtd_sped($this->VL_RET_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DED_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_CUM_REC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_REC,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M205 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_CAMPO;
		var $COD_REC;
		var $VL_DEBITO=0;

		function CriaRegistro($NUM_CAMPO, $COD_REC){
			$this->NUM_CAMPO = $NUM_CAMPO;
			$this->COD_REC = $COD_REC;
		}

		function SomaRegistro($VL_DEBITO){
			$this->VL_DEBITO+= $VL_DEBITO;
		}

		function LerRegistro(){
			return '|M205|'.
			$this->NUM_CAMPO.'|'.
			$this->COD_REC.'|'.
			formata_qtd_sped($this->VL_DEBITO,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M210 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CONT;
		var $ALIQ_PIS;
		var $ALIQ_PIS_QUANT;

		var $VL_REC_BRT=0;
		var $VL_BC_CONT=0;
		var $QUANT_BC_PIS=0;
		var $VL_CONT_APUR=0;
		var $VL_AJUS_ACRES=0;
		var $VL_AJUS_REDUC=0;
		var $VL_CONT_DIFER=0;
		var $VL_CONT_DIFER_ANT=0;
		var $VL_CONT_PER=0;

		var $VL_AJUS_ACRES_BC_PIS = '';
		var $VL_AJUS_REDUC_BC_PIS = '';
		var $VL_BC_CONT_AJUS =0;//(Campo 07 = Campo 04 + Campo 05 - Campo 06)

		function CriaRegistro($COD_CONT, $ALIQ_PIS, $ALIQ_PIS_QUANT){
			$this->COD_CONT = $COD_CONT;
			$this->ALIQ_PIS = $ALIQ_PIS;
			$this->ALIQ_PIS_QUANT = $ALIQ_PIS_QUANT;
		}

		function SomaRegistro($VL_REC_BRT, $VL_BC_CONT, $QUANT_BC_PIS,
			$VL_CONT_APUR, $VL_AJUS_ACRES, $VL_AJUS_REDUC,
			$VL_CONT_DIFER, $VL_CONT_DIFER_ANT,
			$VL_AJUS_ACRES_BC_PIS, $VL_AJUS_REDUC_BC_PIS){

			$this->VL_REC_BRT+= $VL_REC_BRT;
			$this->VL_BC_CONT+= $VL_BC_CONT;
			$this->QUANT_BC_PIS+= $QUANT_BC_PIS;
			$this->VL_CONT_APUR+= $VL_CONT_APUR;
			$this->VL_AJUS_ACRES+= $VL_AJUS_ACRES;
			$this->VL_AJUS_REDUC+= $VL_AJUS_REDUC;
			$this->VL_CONT_DIFER+= $VL_CONT_DIFER;
			$this->VL_CONT_DIFER_ANT+= $VL_CONT_DIFER_ANT;

			$this->VL_CONT_PER = ($this->VL_CONT_APUR + $this->VL_AJUS_ACRES + $this->VL_CONT_DIFER_ANT)
								- ($this->VL_AJUS_REDUC + $this->VL_CONT_DIFER);
			if ($this->VL_CONT_PER<0){
				$this->VL_CONT_PER = 0;
			}

			if ($VL_AJUS_ACRES_BC_PIS!==''){
				if ($this->VL_AJUS_ACRES_BC_PIS===''){
					$this->VL_AJUS_ACRES_BC_PIS = 0;
					$this->VL_AJUS_REDUC_BC_PIS = 0;
				}
				$this->VL_AJUS_ACRES_BC_PIS+= $VL_AJUS_ACRES_BC_PIS;
				$this->VL_AJUS_REDUC_BC_PIS+= $VL_AJUS_REDUC_BC_PIS;

				$this->VL_BC_CONT_AJUS = $this->VL_BC_CONT + $this->VL_AJUS_ACRES_BC_PIS
										- ($this->VL_AJUS_REDUC_BC_PIS);
			}
		}

		function LerRegistro(){
			$VL_AJUS_ACRES_BC_PIS = '';
			if ($this->VL_AJUS_ACRES_BC_PIS!==''){
				$VL_AJUS_ACRES_BC_PIS = formata_qtd_sped($this->VL_AJUS_ACRES_BC_PIS,2,false).'|'.
										formata_qtd_sped($this->VL_AJUS_REDUC_BC_PIS,2,false).'|'.
										formata_qtd_sped($this->VL_BC_CONT_AJUS,2,false).'|';
			}
			return '|M210|'.
			$this->COD_CONT.'|'.
			formata_qtd_sped($this->VL_REC_BRT,2,false).'|'.
			formata_qtd_sped($this->VL_BC_CONT,2,false).'|'.
			$VL_AJUS_ACRES_BC_PIS.
			formata_qtd_sped($this->ALIQ_PIS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_PIS,2,false).'|'.
			//formata_qtd_sped($this->ALIQ_PIS_QUANT,2,false).
			'|'.
			formata_qtd_sped($this->VL_CONT_APUR,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_ACRES,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_REDUC,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_DIFER,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_DIFER_ANT,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_PER,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M400 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_PIS;
		var $COD_CTA;
		var $DESC_COMPL;
		var $VL_TOT_REC=0;

		function CriaRegistro($CST_PIS, $COD_CTA, $DESC_COMPL){
			$this->CST_PIS = $CST_PIS;
			$this->COD_CTA = $COD_CTA;
			$this->DESC_COMPL = $DESC_COMPL;
		}

		function SomaRegistro($VL_TOT_REC){
			$this->VL_TOT_REC+= $VL_TOT_REC;
		}

		function LerRegistro(){
			return '|M400|'.
			$this->CST_PIS.'|'.
			formata_qtd_sped($this->VL_TOT_REC,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->DESC_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_M410 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NAT_REC;
		var $COD_CTA;
		var $DESC_COMPL;
		var $VL_REC=0;

		function CriaRegistro($NAT_REC, $COD_CTA, $DESC_COMPL){
			$this->NAT_REC = $NAT_REC;
			$this->COD_CTA = $COD_CTA;
			$this->DESC_COMPL = $DESC_COMPL;
		}

		function SomaRegistro($VL_REC){
			$this->VL_REC+= $VL_REC;
		}

		function LerRegistro(){
			return '|M410|'.
			$this->NAT_REC.'|'.
			formata_qtd_sped($this->VL_REC,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->DESC_COMPL.'|'.
			fim_linha();
		}
	}


	//fim PIS

	//confis
	class SF_Reg_M500 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CRED;
		var $IND_CRED_ORI;
		var $IND_DESC_CRED;

		var $ALIQ_COFINS;
		var $ALIQ_COFINS_QUANT;

		var $VL_BC_COFINS=0;
		var $QUANT_BC_COFINS=0;
		var $VL_CRED=0;
		var $VL_AJUS_ACRES=0;
		var $VL_AJUS_REDUC=0;
		var $VL_CRED_DIF=0;
		var $VL_CRED_DISP=0;
		var $SLD_CRED=0;

		var $VL_CRED_DESC=0;

		function CriaRegistro($COD_CRED, $IND_CRED_ORI, $IND_DESC_CRED,
			$ALIQ_COFINS, $ALIQ_COFINS_QUANT){

			$this->COD_CRED = $COD_CRED;
			$this->IND_CRED_ORI = $IND_CRED_ORI;
			$this->IND_DESC_CRED = $IND_DESC_CRED;

			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->ALIQ_COFINS_QUANT = $ALIQ_COFINS_QUANT;
		}

		function SomaRegistro($VL_BC_COFINS, $QUANT_BC_COFINS, $VL_CRED,
			$VL_AJUS_ACRES, $VL_AJUS_REDUC, $VL_CRED_DIF,
			$VL_CRED_DESC){

			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->QUANT_BC_COFINS+= $QUANT_BC_COFINS;
			$this->VL_CRED+= $VL_CRED;
			$this->VL_AJUS_ACRES+= $VL_AJUS_ACRES;
			$this->VL_AJUS_REDUC+= $VL_AJUS_REDUC;
			$this->VL_CRED_DIF+= $VL_CRED_DIF;
			$this->VL_CRED_DESC = $VL_CRED_DESC;

			$this->VL_CRED_DISP = ($this->VL_CRED + $this->VL_AJUS_ACRES) - ($this->VL_AJUS_REDUC + $this->VL_CRED_DIF);
			if ($this->VL_CRED_DISP < 0){
				$this->VL_CRED_DISP = 0;
			}

			if ($this->VL_CRED_DESC > $this->VL_CRED_DISP){
				$this->VL_CRED_DESC = $this->VL_CRED_DISP;
			}

			$this->SLD_CRED = $this->VL_CRED_DISP - $this->VL_CRED_DESC;
			if ($this->SLD_CRED < 0){
				$this->SLD_CRED = 0;
			}

			if ($this->SLD_CRED>0){
				$this->IND_DESC_CRED = '1';
			}else{
				$this->IND_DESC_CRED = '0';
			}
		}

		function LerRegistro(){
			return '|M500|'.
			$this->COD_CRED.'|'.
			$this->IND_CRED_ORI.'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,2,false).'|'.
			//formata_qtd_sped($this->ALIQ_COFINS_QUANT,2,false).
			'|'.
			formata_qtd_sped($this->VL_CRED,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_ACRES,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_REDUC,2,false).'|'.
			formata_qtd_sped($this->VL_CRED_DIF,2,false).'|'.
			formata_qtd_sped($this->VL_CRED_DISP,2,false).'|'.
			$this->IND_DESC_CRED.'|'.
			formata_qtd_sped($this->VL_CRED_DESC,2,false).'|'.
			formata_qtd_sped($this->SLD_CRED,2,false).'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_M505 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NAT_BC_CRED;
		var $CST_COFINS;
		var $DESC_CRED;

		var $VL_BC_COFINS_TOT=0;
		var $VL_BC_COFINS_CUM=0;
		var $VL_BC_COFINS_NC=0;
		var $VL_BC_COFINS=0;
		var $QUANT_BC_COFINS_TOT=0;
		var $QUANT_BC_COFINS=0;

		function CriaRegistro($NAT_BC_CRED, $CST_COFINS, $DESC_CRED){
			$this->NAT_BC_CRED = $NAT_BC_CRED;
			$this->CST_COFINS = $CST_COFINS;
			$this->DESC_CRED = $DESC_CRED;
		}

		function SomaRegistro($VL_BC_COFINS_TOT, $VL_BC_COFINS_CUM, $VL_BC_COFINS_NC,
			$VL_BC_COFINS, $QUANT_BC_COFINS_TOT, $QUANT_BC_COFINS){

			$this->VL_BC_COFINS_TOT+= $VL_BC_COFINS_TOT;
			$this->VL_BC_COFINS_CUM+= $VL_BC_COFINS_CUM;
			$this->VL_BC_COFINS_NC+= $VL_BC_COFINS_NC;
			$this->VL_BC_COFINS+= $VL_BC_COFINS;
			$this->QUANT_BC_COFINS_TOT+= $QUANT_BC_COFINS_TOT;
			$this->QUANT_BC_COFINS+= $QUANT_BC_COFINS;

		}

		function LerRegistro(){
			return '|M505|'.
			$this->NAT_BC_CRED.'|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_BC_COFINS_TOT,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS_NC,2,false).'|'.
			formata_qtd_sped($this->VL_BC_COFINS,2,false).'|'.
			//formata_qtd_sped($this->QUANT_BC_COFINS_TOT,2,false).
			'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,2,false).'|'.
			$this->DESC_CRED.'|'.
			fim_linha();
		}
	}

	class SF_Reg_M600 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE

		var $VL_TOT_CONT_NC_PER=0;
		var $VL_TOT_CRED_DESC=0;
		var $VL_TOT_CRED_DESC_ANT=0;
		var $VL_TOT_CONT_NC_DEV=0;
		var $VL_RET_NC=0;
		var $VL_OUT_DED_NC=0;
		var $VL_CONT_NC_REC=0;
		var $VL_TOT_CONT_CUM_PER=0;
		var $VL_RET_CUM=0;
		var $VL_OUT_DED_CUM=0;
		var $VL_CONT_CUM_REC=0;
		var $VL_TOT_CONT_REC=0;

		function SomaRegistro($VL_TOT_CONT_NC_PER, $VL_TOT_CRED_DESC, $VL_TOT_CRED_DESC_ANT,
			$VL_RET_NC, $VL_OUT_DED_NC, $VL_TOT_CONT_CUM_PER,
			$VL_RET_CUM,$VL_OUT_DED_CUM){

			$this->VL_TOT_CONT_NC_PER+= $VL_TOT_CONT_NC_PER;
			$this->VL_TOT_CRED_DESC+= $VL_TOT_CRED_DESC;
			$this->VL_TOT_CRED_DESC_ANT+= $VL_TOT_CRED_DESC_ANT;
			$this->VL_RET_NC+= $VL_RET_NC;
			$this->VL_OUT_DED_NC+= $VL_OUT_DED_NC;
			$this->VL_TOT_CONT_CUM_PER+= $VL_TOT_CONT_CUM_PER;
			$this->VL_RET_CUM+= $VL_RET_CUM;
			$this->VL_OUT_DED_CUM+= $VL_OUT_DED_CUM;

			$this->VL_TOT_CONT_NC_DEV = $this->VL_TOT_CONT_NC_PER - ($this->VL_TOT_CRED_DESC + $this->VL_TOT_CRED_DESC_ANT);
			if ($this->VL_TOT_CONT_NC_DEV<0){
				$this->VL_TOT_CONT_NC_DEV = 0;
			}

			$this->VL_CONT_NC_REC = $this->VL_TOT_CONT_NC_DEV - ($this->VL_RET_NC + $this->VL_OUT_DED_NC);
			if ($this->VL_CONT_NC_REC<0){
				$this->VL_CONT_NC_REC = 0;
			}

			$this->VL_CONT_CUM_REC = $this->VL_TOT_CONT_CUM_PER - ($this->VL_RET_CUM + $this->VL_OUT_DED_CUM);
			if ($this->VL_CONT_CUM_REC<0){
				$this->VL_CONT_CUM_REC = 0;
			}

			$this->VL_TOT_CONT_REC = $this->VL_CONT_NC_REC - $this->VL_CONT_CUM_REC;
			if ($this->VL_TOT_CONT_REC<0){
				$this->VL_TOT_CONT_REC = 0;
			}
		}


		function LerRegistro(){
			return '|M600|'.
			formata_qtd_sped($this->VL_TOT_CONT_NC_PER,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CRED_DESC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CRED_DESC_ANT,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_NC_DEV,2,false).'|'.
			formata_qtd_sped($this->VL_RET_NC,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DED_NC,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_NC_REC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_CUM_PER,2,false).'|'.
			formata_qtd_sped($this->VL_RET_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_OUT_DED_CUM,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_CUM_REC,2,false).'|'.
			formata_qtd_sped($this->VL_TOT_CONT_REC,2,false).'|'.
			fim_linha();
		}
	}
	
	class SF_Reg_M605 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NUM_CAMPO;
		var $COD_REC;
		var $VL_DEBITO=0;

		function CriaRegistro($NUM_CAMPO, $COD_REC){
			$this->NUM_CAMPO = $NUM_CAMPO;
			$this->COD_REC = $COD_REC;
		}

		function SomaRegistro($VL_DEBITO){
			$this->VL_DEBITO+= $VL_DEBITO;
		}

		function LerRegistro(){
			return '|M605|'.
			$this->NUM_CAMPO.'|'.
			$this->COD_REC.'|'.
			formata_qtd_sped($this->VL_DEBITO,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M610 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $COD_CONT;
		var $ALIQ_COFINS;
		var $ALIQ_COFINS_QUANT;

		var $VL_REC_BRT=0;
		var $VL_BC_CONT=0;
		var $QUANT_BC_COFINS=0;
		var $VL_CONT_APUR=0;
		var $VL_AJUS_ACRES=0;
		var $VL_AJUS_REDUC=0;
		var $VL_CONT_DIFER=0;
		var $VL_CONT_DIFER_ANT=0;
		var $VL_CONT_PER=0;

		var $VL_AJUS_ACRES_BC_COFINS = '';
		var $VL_AJUS_REDUC_BC_COFINS = '';
		var $VL_BC_CONT_AJUS =0;//(Campo 07 = Campo 04 + Campo 05 - Campo 06)

		function CriaRegistro($COD_CONT, $ALIQ_COFINS, $ALIQ_COFINS_QUANT){
			$this->COD_CONT = $COD_CONT;
			$this->ALIQ_COFINS = $ALIQ_COFINS;
			$this->ALIQ_COFINS_QUANT = $ALIQ_COFINS_QUANT;
		}

		function SomaRegistro($VL_REC_BRT, $VL_BC_CONT, $QUANT_BC_COFINS,
			$VL_CONT_APUR, $VL_AJUS_ACRES, $VL_AJUS_REDUC,
			$VL_CONT_DIFER, $VL_CONT_DIFER_ANT,
			$VL_AJUS_ACRES_BC_COFINS, $VL_AJUS_REDUC_BC_COFINS){
			$this->VL_REC_BRT+= $VL_REC_BRT;
			$this->VL_BC_CONT+= $VL_BC_CONT;
			$this->QUANT_BC_COFINS+= $QUANT_BC_COFINS;
			$this->VL_CONT_APUR+= $VL_CONT_APUR;
			$this->VL_AJUS_ACRES+= $VL_AJUS_ACRES;
			$this->VL_AJUS_REDUC+= $VL_AJUS_REDUC;
			$this->VL_CONT_DIFER+= $VL_CONT_DIFER;
			$this->VL_CONT_DIFER_ANT+= $VL_CONT_DIFER_ANT;

			$this->VL_CONT_PER = ($this->VL_CONT_APUR + $this->VL_AJUS_ACRES + $this->VL_CONT_DIFER_ANT)
								- ($this->VL_AJUS_REDUC + $this->VL_CONT_DIFER);
			if ($this->VL_CONT_PER<0){
				$this->VL_CONT_PER = 0;
			}

			if ($VL_AJUS_ACRES_BC_COFINS!==''){
				if ($this->VL_AJUS_ACRES_BC_COFINS===''){
					$this->VL_AJUS_ACRES_BC_COFINS = 0;
					$this->VL_AJUS_REDUC_BC_COFINS = 0;
				}
				$this->VL_AJUS_ACRES_BC_COFINS+= $VL_AJUS_ACRES_BC_COFINS;
				$this->VL_AJUS_REDUC_BC_COFINS+= $VL_AJUS_REDUC_BC_COFINS;

				$this->VL_BC_CONT_AJUS = $this->VL_BC_CONT + $this->VL_AJUS_ACRES_BC_COFINS
										- ($this->VL_AJUS_REDUC_BC_COFINS);

			}

		}

		function LerRegistro(){
			$VL_AJUS_ACRES_BC_COFINS = '';
			if ($this->VL_AJUS_ACRES_BC_COFINS!==''){
				$VL_AJUS_ACRES_BC_COFINS = formata_qtd_sped($this->VL_AJUS_ACRES_BC_COFINS,2,false).'|'.
											formata_qtd_sped($this->VL_AJUS_REDUC_BC_COFINS,2,false).'|'.
											formata_qtd_sped($this->VL_BC_CONT_AJUS,2,false).'|';
			}
			return '|M610|'.
			$this->COD_CONT.'|'.
			formata_qtd_sped($this->VL_REC_BRT,2,false).'|'.
			formata_qtd_sped($this->VL_BC_CONT,2,false).'|'.
			$VL_AJUS_ACRES_BC_COFINS.
			formata_qtd_sped($this->ALIQ_COFINS,2,false).'|'.
			formata_qtd_sped($this->QUANT_BC_COFINS,2,false).'|'.
			//formata_qtd_sped($this->ALIQ_COFINS_QUANT,2,false).
			'|'.
			formata_qtd_sped($this->VL_CONT_APUR,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_ACRES,2,false).'|'.
			formata_qtd_sped($this->VL_AJUS_REDUC,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_DIFER,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_DIFER_ANT,2,false).'|'.
			formata_qtd_sped($this->VL_CONT_PER,2,false).'|'.
			fim_linha();
		}
	}

	class SF_Reg_M800 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CST_COFINS;
		var $COD_CTA;
		var $DESC_COMPL;
		var $VL_TOT_REC=0;

		function CriaRegistro($CST_COFINS, $COD_CTA, $DESC_COMPL){
			$this->CST_COFINS = $CST_COFINS;
			$this->COD_CTA = $COD_CTA;
			$this->DESC_COMPL = $DESC_COMPL;
		}

		function SomaRegistro($VL_TOT_REC){
			$this->VL_TOT_REC+= $VL_TOT_REC;
		}

		function LerRegistro(){
			return '|M800|'.
			$this->CST_COFINS.'|'.
			formata_qtd_sped($this->VL_TOT_REC,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->DESC_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_M810 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $NAT_REC;
		var $COD_CTA;
		var $DESC_COMPL;
		var $VL_REC=0;

		function CriaRegistro($NAT_REC, $COD_CTA, $DESC_COMPL){
			$this->NAT_REC = $NAT_REC;
			$this->COD_CTA = $COD_CTA;
			$this->DESC_COMPL = $DESC_COMPL;
		}

		function SomaRegistro($VL_REC){
			$this->VL_REC+= $VL_REC;
		}

		function LerRegistro(){
			return '|M810|'.
			$this->NAT_REC.'|'.
			formata_qtd_sped($this->VL_REC,2,false).'|'.
			$this->COD_CTA.'|'.
			$this->DESC_COMPL.'|'.
			fim_linha();
		}
	}

	class SF_Reg_1900 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $CNPJ='';
		var $COD_MOD;
		var $SER;
		var $SUB_SER;
		var $COD_SIT;
		var $VL_TOT_REC=0;
		var $QUANT_DOC=0;
		var $CST_PIS;
		var $CST_COFINS;
		var $CFOP;
		var $INF_COMPL;
		var $COD_CTA;
		var $Notas=array();
		var $multiploCST = false;

		function CriaRegistroBase($Empresa, $COD_MOD, $SER,
			$SUB_SER, $COD_SIT,
			$CST_PIS, $CST_COFINS,
			$CFOP, $INF_COMPL, $COD_CTA){

			//consulta cadastro de pessoa
			if ($this->CNPJ==''){
				$con_pessoa = 'select CPF_CNPJ from pessoa '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa="'.$Empresa.'"';
				$res_pessoa = consulta_sql($con_pessoa);
				$reg_pessoa = consulta_ler_linha($res_pessoa);
				consulta_limpa($res_pessoa);

				$this->CNPJ = fill_full(trim(substr(limpa_numero($reg_pessoa[0]),0,14)),14);
			}
			$this->COD_MOD = $COD_MOD;
			$this->SER = $SER;
			$this->SUB_SER = $SUB_SER;
			$this->COD_SIT = $COD_SIT;

			if (($this->COD_MOD=='55')||
				($this->COD_MOD=='65')||
				($this->COD_MOD=='57')||
				($this->COD_MOD=='67')){
				$this->SER = fill_full($this->SER,3);
			}

			//if ($this->CST_PIS!=''){
			//  if ($this->CST_PIS != $CST_PIS){
			//     $multiploCST = true;
			//     $this->CST_PIS = '';
			//     $this->CST_COFINS = '';
			//  }
			//}else{
			//  if (!($multiploCST)){
			$this->CST_PIS = $CST_PIS;
			$this->CST_COFINS = $CST_COFINS;
			//  }
			//}
			if ($CFOP!=''){
				$this->CFOP = fill_full(trim(substr(limpa_numero($CFOP),0,4)),4);
			}
			$this->INF_COMPL = $INF_COMPL;
			$this->COD_CTA = $COD_CTA;
		}

		function SomaRegistro($VL_TOT_REC){
			$this->VL_TOT_REC+= $VL_TOT_REC;
			//if (!(isset($this->Notas[$DOC]))){
			//   $this->QUANT_DOC++;
			//   $this->Notas[$DOC] = 1;
			//}
		}

		function LerRegistro(){
			return '|1900|'.
			$this->CNPJ.'|'.
			$this->COD_MOD.'|'.
			$this->SER.'|'.
			$this->SUB_SER.'|'.
			$this->COD_SIT.'|'.
			formata_qtd_sped($this->VL_TOT_REC,2,false).'|'.
			$this->QUANT_DOC.'|'.
			$this->CST_PIS.'|'.
			$this->CST_COFINS.'|'.
			$this->CFOP.'|'.
			$this->INF_COMPL.'|'.
			$this->COD_CTA.'|'.
			fim_linha();
		}
	}
	
	//fim cofins
	class SF_Reg_9900 extends SPED_Registro_Base{
		//REGISTRO 0000: ABERTURA DO ARQUIVO DIGITAL E IDENTIFICAO DA ENTIDADE
		var $REG_BLC;
		var $QTD_REG_BLC=0;

		function CriaRegistro($REG_BLC, $QTD_REG_BLC){
			//echo 'conta'.$REG_BLC.'vanterior'.$this->QTD_REG_BLC.'-';
			$this->REG_BLC  = trim(substr(limpa_texto($REG_BLC),0,4));
			$this->QTD_REG_BLC+= $QTD_REG_BLC;
			//echo 'conta'.$REG_BLC.'vantual'.$this->QTD_REG_BLC.'-';
		}
		function LerRegistro(){

			return '|9900|'.
			$this->REG_BLC.'|'.
			$this->QTD_REG_BLC.'|'.
			fim_linha();
		}
	}

?>