	function isset () {
		//  discuss at: http://locutus.io/php/isset/
		// original by: Kevin van Zonneveld (http://kvz.io)
		// improved by: FremyCompany
		// improved by: Onno Marsman (https://twitter.com/onnomarsman)
		// improved by: Rafał Kukawski (http://blog.kukawski.pl)
		//   example 1: isset( undefined, true)
		//   returns 1: false
		//   example 2: isset( 'Kevin van Zonneveld' )
		//   returns 2: true

		var a = arguments
		var l = a.length
		var i = 0
		var undef

		if (l === 0) {
			throw new Error('Empty isset')
		}

		while (i !== l) {
			if (a[i] === undef || a[i] === null) {
				return false
			}
			i++
		}

		return true
	}

	function trim (str, charlist) {
		//  discuss at: http://locutus.io/php/trim/
		// original by: Kevin van Zonneveld (http://kvz.io)
		// improved by: mdsjack (http://www.mdsjack.bo.it)
		// improved by: Alexander Ermolaev (http://snippets.dzone.com/user/AlexanderErmolaev)
		// improved by: Kevin van Zonneveld (http://kvz.io)
		// improved by: Steven Levithan (http://blog.stevenlevithan.com)
		// improved by: Jack
		//    input by: Erkekjetter
		//    input by: DxGx
		// bugfixed by: Onno Marsman (https://twitter.com/onnomarsman)
		//   example 1: trim('    Kevin van Zonneveld    ')
		//   returns 1: 'Kevin van Zonneveld'
		//   example 2: trim('Hello World', 'Hdle')
		//   returns 2: 'o Wor'
		//   example 3: trim(16, 1)
		//   returns 3: '6'

		var whitespace = [
			' ',
			'\n',
			'\r',
			'\t',
			'\f',
			'\x0b',
			'\xa0',
			'\u2000',
			'\u2001',
			'\u2002',
			'\u2003',
			'\u2004',
			'\u2005',
			'\u2006',
			'\u2007',
			'\u2008',
			'\u2009',
			'\u200a',
			'\u200b',
			'\u2028',
			'\u2029',
			'\u3000'
			].join('')
		var l = 0
		var i = 0
		str += ''

		if (charlist) {
			whitespace = (charlist + '').replace(/([[\]().?/*{}+$^:])/g, '$1')
		}

		l = str.length
		for (i = 0; i < l; i++) {
			if (whitespace.indexOf(str.charAt(i)) === -1) {
				str = str.substring(i)
				break
			}
		}

		l = str.length
		for (i = l - 1; i >= 0; i--) {
			if (whitespace.indexOf(str.charAt(i)) === -1) {
				str = str.substring(0, i + 1)
				break
			}
		}
		return whitespace.indexOf(str.charAt(0)) === -1 ? str : ''
	}

	function empty (mixedVar) {
		//  discuss at: http://locutus.io/php/empty/

		var undef
		var key
		var i
		var len
		var emptyValues = [undef, null, false, 0, '', '0']

		for (i = 0, len = emptyValues.length; i < len; i++) {
			if (mixedVar === emptyValues[i]) {
				return true
			}
		}

		if (typeof mixedVar === 'object') {
			for (key in mixedVar) {
				if (mixedVar.hasOwnProperty(key)) {
					return false
				}
			}
			return true
		}

		return false
	}

	function round (value, precision, mode) {
		var m, f, isHalf, sgn // helper variables
		// making sure precision is integer
		precision |= 0
		m = Math.pow(10, precision)
		value *= m
		// sign of the number
		sgn = (value > 0) | -(value < 0)
		isHalf = value % 1 === 0.5 * sgn
		f = Math.floor(value)

		if (isHalf) {
			switch (mode) {
				case 'PHP_ROUND_HALF_DOWN':
				// rounds .5 toward zero
				value = f + (sgn < 0)
				break
				case 'PHP_ROUND_HALF_EVEN':
				// rouds .5 towards the next even integer
				value = f + (f % 2 * sgn)
				break
				case 'PHP_ROUND_HALF_ODD':
				// rounds .5 towards the next odd integer
				value = f + !(f % 2)
				break
				default:
				// rounds .5 away from zero
				value = f + (sgn > 0)
			}
		}

		return (isHalf ? value : Math.round(value)) / m
	}

	function number_format (number, decimals, decPoint, thousandsSep) {
		number = (number + '').replace(/[^0-9+\-Ee.]/g, '')
		var n = !isFinite(+number) ? 0 : +number
		var prec = !isFinite(+decimals) ? 0 : Math.abs(decimals)
		var sep = (typeof thousandsSep === 'undefined') ? ',' : thousandsSep
		var dec = (typeof decPoint === 'undefined') ? '.' : decPoint
		var s = ''
		var toFixedFix = function (n, prec) {
			var k = Math.pow(10, prec)
			return '' + (Math.round(n * k) / k)
				.toFixed(prec)
		}
		// @todo: for IE parseFloat(0.55).toFixed(0) = 0;
		s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.')
		if (s[0].length > 3) {
			s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep)
		}
		if ((s[1] || '').length < prec) {
			s[1] = s[1] || ''
			s[1] += new Array(prec - s[1].length + 1).join('0')
		}
		return s.join(dec)
	}