<?php

/**Conteudo retirado de:
//https://forum.imasters.com.br/topic/490216-leitura-de-arquivos-ofx-com-php/
*
* */

class Ofx {    
	private $ofxFile;    
	public function __construct($ofxFile) {
		$this->ofxFile = $ofxFile;    
	}    
	/*     * Converte o arquivo OFX para XML     */
	public function getOfxAsXML() {        
		$content = file_get_contents($this->ofxFile); 
		$line = strpos($content, "<OFX>");
		$ofx = substr($content, $line - 1);
		$buffer = $ofx;        $count = 0;
		while ($pos = strpos($buffer, '<')) {
		 	$count++;            
		 	$pos2 = strpos($buffer, '>');
		 	$element = substr($buffer, $pos + 1, $pos2 - $pos - 1);
		 	if (substr($element, 0, 1) == '/')
		 		 $sla[] = substr($element, 1);
		 	else
		 		$als[] = $element;
		 	$buffer = substr($buffer, $pos2 + 1);
		 
		}        

		$adif = array_diff($als, $sla);        
		$adif = array_unique($adif);        
		$ofxy = $ofx;        
		foreach ($adif as $dif) {            
			$dpos = 0;            
			while ($dpos = strpos($ofxy, $dif, $dpos + 1)) {                
				$npos = strpos($ofxy, '<', $dpos + 1);                
				$ofxy = substr_replace($ofxy, "</$dif>\n<", $npos, 1);                
				$dpos = $npos + strlen($element) + 3;            
			}        
		}        

		$ofxy = str_replace('&', '&', $ofxy);
		return $ofxy;
	}

	/*     * Retorna o Saldo da conta na data de exportao do extrato     */ 
	public function getBalance() {        
		$xml = new SimpleXMLElement($this->getOfxAsXML());        
		$balance = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->LEDGERBAL->BALAMT;        
		$dateOfBalance = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->LEDGERBAL->DTASOF;        
		$date = strtotime(substr($dateOfBalance, 0, 8));        
		$dateToReturn = date('Y-m-d', $date);        
		return Array('date' => $dateToReturn, 'balance' => $balance);    
	} 
	
	
	/****Retorna uma array de objetos com as informaes do balano do perodo
	 * Informaes encontradas no banco  NU PAGAMENTOS S.A. ( 260 )
	 * 
	 */
	public function getRendimentos() {        
		$xml = new SimpleXMLElement($this->getOfxAsXML()); 
		$info_rend =   $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BALLIST->BAL;        
		return $info_rend ;
	} 


	/*     * Retora um array de objetos com as transaes      *
	       * DTPOSTED => Data da Transao    
	       * TRNAMT   => Valor da Transao      
	       * TRNTYPE  => Tipo da Transao  (Dbito ou Crdito)     
	       * MEMO     => Descrio da Transao     */    
	public function getTransactions() {        
		$xml = new SimpleXMLElement($this->getOfxAsXML());       
		$transactions = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BANKTRANLIST->STMTTRN;        
		return $transactions;    
	}

	/**Retorna as informaes do banco 
	 * BANKID   => Numero do Banco ( Teste == 748 );
	 * ACCTID   => Agencia[4 primeiros digitos ] e Numero [sequencia ] (26020000000290068)
	 * ACCTTYPE => Tipo de informao vinda do Banco ??? (CHECKING) 
	 */
	public function getBanco(){
		$xml = new SimpleXMLElement($this->getOfxAsXML());       
		$info_banco = $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BANKACCTFROM;        
		return $info_banco; 

	}

	/**Retorna uma array com as Data Inicial e Final do arquivo OFX 
	 * DTSTART => Data inicial do evento ( 20200501000000[-3:GMT] )
	 * DTEND   => Data final do evento  ( 20200531000000[-3:GMT])
	*/
	public function getDatas(){

		$xml = new SimpleXMLElement($this->getOfxAsXML());
		$data_inicio='0000-00-00';
		$data_fim='0000-00-00';
		$dataI =  $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BANKTRANLIST->DTSTART; 
		$dateI = strtotime(substr($dataI, 0, 8));
		$data_inicio= date('Y-m-d', $dateI); 
		$dataF =  $xml->BANKMSGSRSV1->STMTTRNRS->STMTRS->BANKTRANLIST->DTEND;
		$dateF = strtotime(substr($dataF, 0, 8)); 
		$data_fim= date('Y-m-d', $dateF);
		
		return Array('inicio' => $data_inicio, 'fim' => $data_fim);   

	}
}

