<?php

	class XML{
		var $version;
		var $encoding;
		var $root;

		function __construct($version_xml = "1.0", $ecoding_xml = "UTF-8"){
			$this->version = $version_xml;
			$this->encoding = $ecoding_xml;
		}

		function setVersion($version_xml){
			$this->version = $version_xml;
		}

		function setEcodig($ecoding_xml){
			$this->encoding = $ecoding_xml;
		}

		function getEcodig(){
			return $this->encoding;
		}

		function getVersion(){
			return $this->version;
		}

		function createRoot($root_name){
			$this->root = new Node($root_name);
			return $this->root;
		}

		function getRoot(){
			return $this->root;
		}

		//Return a string that represent the XML file
		function toString(){
			if($this->version!=' '){
				$string = '<?xml version="'.$this->version.'" encoding="'.$this->encoding.'"?>';
			}else{
				$string = '';
			}
			if ($this->root != null){
				$string .= $this->root->toString();
			}
			return $string;
		}


		function toFile($path, $file_name){
			$path = trim($path);
			$finalPath = $file_name;

			if($path != ''){
				$path = rtrim($path, '/').'/';
				if(!is_dir($path)){
					rmkdir($path);
				}
				$finalPath = $path.$file_name;
			}
			$Handle = fopen($finalPath, 'w');
			$Data = utf8_encode($this->toString());
			fwrite($Handle, $Data);
			fclose($Handle);
		}

		function fromFile($path, $file_name, $utf8=true){
			$texto = xml_fromFile($path, $file_name, $utf8);
			$texto = str_replace("\n","",$texto);
			$texto = str_replace("\r","",$texto);
			//$texto = str_replace("
	//","",$texto);
			$texto2 = str_replace("  <","<",$texto);
			while($texto!=$texto2){
				$texto = $texto2;
				$texto2 = str_replace("  <","<",$texto);
			}


			$texto = $texto2;
			//echo $texto;
			//cria root do xml
			$root = xml_LerNodeNum($texto,0);  //s tem o node numero zero
				//chama funo recursiva para ler os nos
			//unset($this->root);
			$r = &$this->createRoot($root['name']);
			$this->read_node($r,$root);
			return $texto;
		}

		function read_node(&$root,$data){
			$node['atr'] = '';
			$node['qat'] = 0;
			$node['nat'] = array();
			$node['vat'] = array();

			$node['name'] = '';
			$node['val'] = '';
			$node['nos'] = array();
			$node['ini'] = array();
			$node['qtd'] = 0;

			//atributos
			for($i=0;$i<$data['qat'];$i++){
			   $root->addAttribute($data['nat'][$i], $data['vat'][$i], true);
			}
			//outros nos ou valores
			for($i=0;$i<$data['qtd'];$i++){
			    $contador = xml_LerNodeNum($data['val'],$i);
			    if (($contador['qtd'] == 0)&&
				   ($contador['qat'] == 0)) { // por que no  no e sim um valor
					$root->addAttribute($data['nos'][$i], $contador['val'], false);
					// echo '<BR>Lido'.$data['nos'][$i].'Val'.$contador['val'];
			    }else{
					$node = &$root->addChild($data['nos'][$i]);
					$this->read_node($node,$contador);
				}
			}
		}
	}

	class Node {
		var $name = "node";
		var $ntp = 'N';
		var $atts = array();
		var $childs = array();
		var $tags = array();

		function __construct($name = "node"){
			$this->name = $name;
		}

		function setName($node_name){
			$this->name = $node_name;
		}

		function getName(){
			return $this->name;
		}

		function getAttributes(){
			return $this->atts;
		}

		function getChilds(){
			return $this->childs;
		}

		//Create a new attribute in the Node
		function addAttribute($att_name, $att_value, $scape = true){
			$a = new Attribute($att_name, $att_value, $scape);
			$ntag = $this->getTagsCount();
			$this->tags[$ntag] = 'A';
			$this->atts[$ntag] = $a;
			return $a;
		}

		//Create a new Child in the Node
		function addChild($child_name){
			$n = new Node($child_name);
			$ntag = $this->getTagsCount();
			$this->tags[$ntag] = 'N';
			$this->childs[$ntag] = $n;
			return $n;
		}

		function getTagsCount(){
			$i = 0;
			foreach ($this->tags as $qtdtag){
				$i = $i + 1;
			}
			return $i;
		}


		function toString(){
			$string = '<'.$this->name;
			foreach ($this->tags as $key => $tag){
				if ($tag == 'A'){
					if ($this->atts[$key]->getScape()){
						$string.= $this->atts[$key]->toString(); //somente atributos da tag
					}
				}
			}
			$string_vazia = $string.'/>';
			$string.='>';

			$vazia = true;
			foreach ($this->tags as $key => $tag){   //feitos assim para respeitar a ordem que foi uinserido
				if ($tag == 'A'){
					if (!($this->atts[$key]->getScape())){
					    $string.= $this->atts[$key]->toString(); //agora sim as tags mesmo
					    $vazia = false;
				    }
				}else{
				    $string.= $this->childs[$key]->toString();  //e tambm outros nos
				    $vazia = false;
				}
			}
			$string.='</'.$this->name.'>';

			if ($vazia){
				return $string_vazia;
			}else{
				return $string;
			}
		}
	}

	class Attribute{
		var $name;
		var $value;
		var $scape = false;
		var $type = 'S';
		var $ntp = 'A';

		/*
		   Tipos:
			  S - String (floats/integer/dates e times devem ser formatados antes)
			  DT - Date Time
		*/

		function __construct($att_name = "", $att_value = "", $att_scape = true, $type='S'){
			$this->name = $att_name;
			if ($type == 'DT'){
				$att_value = str_replace(' ','T',$att_value).'.000Z';
			}
			$this->value = $att_value;
			$this->scape = $att_scape;
			$this->type = $att_scape;
		}

		function setName($att_name){
			$this->name = $att_name;
		}

		function setValue($att_value){
			$this->value = $att_value;
		}

		function setScape($att_scape){
			$this->scape = $att_scape;
		}

		function getName(){
			return $this->name;
		}

		function getValue(){
			if ($type == 'DT'){
				return substr(str_replace('T',' ',$this->value),0,19);
			}else{
				return $this->value;
			}
		}

		function getScape(){
			return $this->scape;
		}

		function toString(){
			if ($this->scape == false){
				if ($this->value != ''){
					return "<".$this->name.">".xml_carac2especial($this->value)."</".$this->name.">";
				}else{
					return "<".$this->name."/>";
				}
			}else{
				return ' '.$this->name.'="'.xml_carac2especial($this->value).'"';
			}
		}
	}


	function xml_carac2especial($caracteres){
		 $resultado = str_replace('&','&amp;' ,$caracteres);
		 $resultado = str_replace('<','&lt;'  ,$resultado);
		 $resultado = str_replace('>','&gt;'  ,$resultado);
		 $resultado = str_replace('"','&quot;',$resultado);
		 $resultado = str_replace('','&amp;Oslash;',$resultado);

		 //retira carteres epeciais
		 $LATIN_UC_CHARS = "`";
		 $LATIN_LC_CHARS = "AAAAAAECEEEEIIIIDNOOOOOUUUUYaaaaaaeceeeeiiiionoooooouuuuy 2  '''";
		 $resultado = strtr($resultado, $LATIN_UC_CHARS, $LATIN_LC_CHARS);

		 $resultado = str_replace("'",'&apos;',$resultado);

		 $resultado = $resultado;
		 return trim($resultado);

	}

	function xml_especial2carac($caracteres){
		 $resultado = str_replace('&lt;'  ,'<',$caracteres);
		 $resultado = str_replace('&gt;'  ,'>',$resultado);
		 $resultado = str_replace('&quot;','"',$resultado);
		 $resultado = str_replace('&apos;',"'",$resultado);
		 $resultado = str_replace('&Oslash;' ,'',$resultado);
		 $resultado = str_replace('&amp;Oslash;' ,'',$resultado);
		 $resultado = str_replace('&amp;' ,'&',$resultado);
		 return $resultado;
	}


	function xml_fromFile($path, $file_name, $utf8=true){
		if ($path != ''){
			if ($path[strlen($path)-1] == "/"){
				$finalPath = $path.$file_name;
			} else {
				$finalPath = $path."/".$file_name;
			}
		}else{
			$finalPath = $file_name;
		}
		$temp_file = nfe_pasta_raiz().'temp_xml/'.$file_name;
		rmkdir(nfe_pasta_raiz().'temp_xml/',0777);
		if (file_exists($temp_file)){
			unlink($temp_file);
		}
	   // echo 'O-'.$finalPath.'-D-'.$temp_file.'-';
		copy($finalPath, $temp_file);

		$Handle = fopen($temp_file, 'r');
		if ($utf8){
			$Data = utf8_decode(fread($Handle, filesize($temp_file)));
		}else{
			$Data = fread($Handle, filesize($temp_file));
		}
		fclose($Handle);
		//unlink($temp_file);
		//tira quebras de lias se tiver
		//$Data = str_replace("\n","",$Data);
		//$Data = str_replace("\r","",$Data);
		//echo '<textarea rows="2" cols="20">Antes'.$Data.'</textarea>';
		//retira a primeira linha do xml encode
		//echo 'data1'.$Data.'
//';
		if ((substr($Data,0,2)=='?<')&&
			(substr($Data,0,5)!='?<xml')&&
			(substr($Data,0,6)!='?<?xml')){
			$Data = substr($Data,1);
		}else if ((substr($Data,0,2)=='<?')||(substr($Data,0,2)=='?<')){
			$Data = substr($Data,strpos($Data,'>')+1);
		}else{
			//echo 'no lido:"'.substr($Data,0,2).'"';

		}
//        echo 'data2'.$Data.'
//'/;
		//echo '<textarea rows="2" cols="20">Depois'.$Data.'</textarea><BR>';
		return $Data;
	}


	function xml_LerNodeNum($Data,$numero){
		$node['atr'] = '';
		$node['qat'] = 0;
		$node['nat'] = array();
		$node['vat'] = array();

		$node['name'] = '';
		$node['val'] = '';
		$node['nos'] = array();
		$node['ini'] = array();
		$node['len'] = array();
		$node['qtd'] = 0;

		$nos = xml_LeNodeCount(trim($Data));
		if ($nos['qtd'] > 0){
			if (isset($nos['ini'][$numero])){
				//if ($numero==2){
				//   echo $Data.'-'.$nos['ini'][$numero].'-'.$nos['len'][$numero];
				//}
				if ($nos['ini'][$numero] > 0){
					//echo 'ini'.$nos['ini'][$numero];
					//echo 'len'.$nos['len'][$numero];
					$Data = substr(trim($Data),$nos['ini'][$numero],$nos['len'][$numero]);
				}
				//echo 'node:'.$nos['nos'][$numero].'-data:'.$nos['len'][$numero].$Data.'<BR>';
				//if ($numero==2){
				//   echo $Data.'-'.$nos['ini'][$numero].'-'.$nos['len'][$numero];
				//}

				$node = xml_LerNodeName(trim($Data),$nos['nos'][$numero]);
			}
		}
		return $node;
	}


	function xml_LerNodeName($Data,$node_name){
		$node['atr'] = '';
		$node['qat'] = 0;
		$node['nat'] = array();
		$node['vat'] = array();
		$node['name'] = $node_name;
		$node['val'] = '';

		$pos_node = strpos(' '.$Data,'<'.$node_name); //node name
		if ($pos_node > 0){
			$pos_node--;
			$sub_node = substr($Data,$pos_node); //tag
			$pos_ini = strpos($sub_node,'>');
			if ($pos_ini > 1){
				$tag = substr($sub_node,0,strpos($sub_node,'>')+1); //tag
				if ($sub_node[$pos_ini-1] == '/'){
					$sub_node = substr($sub_node,0,$pos_ini+1); //tag
					$vazio = true;
				}else{
					$node_end = '</'.$node_name.'>';
					$end_node = strpos($sub_node,$node_end);
					$sub_node = substr($sub_node,0,$end_node); //tag
					$vazio = false;
				}
				$pos_atr = strpos($tag,' ');

				if ($pos_atr > 0){
					$tamanho = strpos($tag,'>')-$pos_atr;
					if ($vazio){
						$node['atr'] = substr($tag,$pos_atr,$tamanho-1); //tag
					}else{
						$node['atr'] = substr($tag,$pos_atr,$tamanho); //tag
					}
				}
				//echo $Data.(($end_node) - (strpos($sub_node,'>')+1)).'<antes><BR>'."\n";
				if (!($vazio)){ //tag vazia
				   $node['val'] = substr($sub_node,
								  strpos($sub_node,'>')+1,
								  ($end_node) - (strpos($sub_node,'>')+1)); //valor da tag
				}
			}
			//echo $node['val']."<depois><BR>\n";
		}
		$resposta = xml_LeNodeCount($node['val']);
		if ($resposta['qtd']==0){
			$node['val'] = xml_especial2carac($node['val']);
		}
		$resposta['val'] = $node['val'];
		$resposta['atr'] = $node['atr'];

		$atributos = xml_LeAtributos($node['atr']);
		$resposta['qat'] = $atributos['qat'];
		$resposta['nat'] = $atributos['nat'];
		$resposta['vat'] = $atributos['vat'];
		$resposta['name'] = $node_name;
		return $resposta;
	}

	function xml_LeNodeCount($Data){
		//echo '<textarea rows="10" cols="80">';

		//echo '<BR>DATA:'.str_replace('<','I',$Data);
		$node['nos'] = array();
		$node['ini'] = array();
		$node['len'] = array();
		$node['qtd'] = 0;
		$ini=0;
		$valor = trim($Data);

		//if (substr($Data
		if ($valor != ''){
			if ($valor[0]=='<'){ // um outro no
				while ($valor!=''){
					set_time_limit(60);
					$pos_ini = strpos($valor,'>')+1;
					$sem_fim = false;

					//if ($valor[1]== '/'){
					//   $tag_txt = substr($valor,2,$pos_ini-2);
					//   $sem_fim = true;
					//}else{

					$tag_txt = substr($valor,1,$pos_ini-1);
					  //echo '<BR>'.$tag_txt;
					//}
					$tag_name = '';
					$funcao = 'name';
					for($i=0;$i<strlen($tag_txt);$i++){
						if (($tag_txt[$i] == ' ')||
							($tag_txt[$i] == '&')||
							($tag_txt[$i] == '"')||
							($tag_txt[$i] == "'")||
							($tag_txt[$i] == '/')||
							($tag_txt[$i] == '>')){
							$funcao = '';
						} 

						if ($funcao == 'name'){
							$tag_name.=$tag_txt[$i];
							//echo 'tag:'.$tag_txt[$i].'- '.$tag_txt.'<BR>';
						}
					}
					//echo '-'.$tag_name;
					if ($tag_name != ''){
						$node['nos'][$node['qtd']] = $tag_name;
						//echo 'i'.$ini.'-'.($pos_ini).'<BR>';
						$node['ini'][$node['qtd']] = $ini;
						$node['qtd']++;
					}
					$ini+= $pos_ini;
					//echo '<BR>tagIni-Nome="'.$tag_name.'"- ini="'.$ini.'"- pos_ini="'.$pos_ini.'"-Valor='.str_replace('<','I',$valor).'FIMini<BR>';
					$valor = substr($valor,$pos_ini);
					//posicao anterior ao final da tag for a barra invertida
					if ($tag_txt[strlen($tag_txt)-2] == '/'){
						$pos_fim = 0;
						if ($tag_name != ''){
							$node['len'][$node['qtd']-1] = 0;
						}
						//echo 'vazio:'.$tag_name.'<BR>';
					}else{

						$pos_fim = strpos(' '.$valor,'</'.$tag_name.'>');
						//if ($Data == "<name>apresentao</name><teste1/><teste1 id='NFe' id2='NFe'><name2>teste2</name2></teste1><teste1/><teste1/><name2>&lt;e&amp;l&apos;</name2><teste2/>"){
						//echo '<BR>tagfim-Nome="'.$tag_name.'"- ini="'.$ini.'"- pos_fim="'.$pos_fim.'"- Valor='.str_replace('<','I',$valor).'FIMfim<BR>';
						//}

						//echo strlen($tag_txt).'<BR>';
						if ($pos_fim > 0){
							if ($tag_name != ''){
								$node['len'][$node['qtd']-1] = ($pos_fim) +
															strlen($tag_txt)+
															strlen('</'.$tag_name.'>');
							}
							$pos_fim+= strlen('</'.$tag_name.'>') - 1;
							$ini+= $pos_fim;
							$valor = substr($valor, $pos_fim);
						}else{
						 //if ($tag_name != ''){
						 //    $node['len'][$node['qtd']-1] = 0;
						 //    echo '<BR><BR>tag_name-'.$tag_name.'-<BR>'.$Data.'<BR>
						 //
						 //
						 //    ';
						 //}
						}
						$tirou = true;
						while ($tirou){
							if ($valor==''){
								$tirou = false;
							}else if ($valor[0]==' '){
								$tirou = true;
								$valor = substr($valor, 1);
								$ini++;
							}else{
								$tirou = false;
							}
						}
					 // echo '<BR>tagProx-Nome="'.$tag_name.'"- ini="'.$ini.'"- pos_fim="'.$pos_fim.'"- Valor='.str_replace('<','I',$valor).'FIMprox<BR>';
					}

				}
			}
		}
		//print_r($node);
		//echo '</textarea>';
		return $node;
	}


	function xml_LeAtributos($atributos){
		$node['qat'] = 0;
		$node['nat'] = array();
		$node['vat'] = array();

		if (trim($atributos) != ''){
			$funcao = '';
			$nome = '';
			$valor = '';
			for($i=0;$i<strlen($atributos);$i++){
				if ($funcao== ''){
					if ($atributos[$i] != ''){
						$nome.= $atributos[$i];
						$funcao = 'nome';
					}
				}else if ($funcao== 'nome'){
					if ($atributos[$i] == '='){
						$funcao = 'igual';
					}else{
						$nome.= $atributos[$i];
					}
				}else if ($funcao== 'igual'){
					if (($atributos[$i] == '"')||
						($atributos[$i] == "'")){
						$funcao = 'inicio';
					}
				}else if ($funcao== 'inicio'){
					if (($atributos[$i] == '"')||
					   ($atributos[$i] == "'")){

						//deve consucluir e inserir na array de valores
						$node['nat'][$node['qat']] = $nome;
						$node['vat'][$node['qat']] = $valor;
						$node['qat']++;
						//reinica processo
						$funcao = '';
						$nome = '';
						$valor = '';
					}else{
						$valor.= $atributos[$i];
					}
				}
			}
		}
		return $node;
	}

?>