<?
    require_once('../../includes/header.inc');
    require_once('../../includes/base_class.inc');
    define('FPDF_FONTPATH', '../../fpdf/font/');
    require('../../fpdf/fpdf.php');

if(session::usr_conectado($_REQUEST['USER_ID'])){

    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');
    $nr_comunicado = base64_decode_si($_REQUEST['nr_comunicado']);
    $codigo = $_REQUEST['codigo'];

    //echo $con_mala_tmp;
    class PDF extends FPDF {

        var $T128;                                             // tableau des codes 128
        var $ABCset="";                                        // jeu des caractres ligibles au C128
        var $Aset="";                                          // Set A du jeu des caractres ligibles
        var $Bset="";                                          // Set B du jeu des caractres ligibles
        var $Cset="";                                          // Set C du jeu des caractres ligibles
        var $SetFrom;                                          // Convertisseur source des jeux vers le tableau
        var $SetTo;                                            // Convertisseur destination des jeux vers le tableau
        var $JStart = array("A"=>103, "B"=>104, "C"=>105);     // Caractres de slection de jeu au dbut du C128
        var $JSwap = array("A"=>101, "B"=>100, "C"=>99);       // Caractres de changement de jeu


        function Header() {

        }

        function Footer() {
           //
        }

        //____________________________ Extension du constructeur _______________________
        function PDF($orientation='P',$unit='mm',$format='A4') {

            parent::__construct($orientation,$unit,$format);

            $this->T128[] = array(2, 1, 2, 2, 2, 2);           //0 : [ ]               // composition des caractres
            $this->T128[] = array(2, 2, 2, 1, 2, 2);           //1 : [!]
            $this->T128[] = array(2, 2, 2, 2, 2, 1);           //2 : ["]
            $this->T128[] = array(1, 2, 1, 2, 2, 3);           //3 : [#]
            $this->T128[] = array(1, 2, 1, 3, 2, 2);           //4 : [$]
            $this->T128[] = array(1, 3, 1, 2, 2, 2);           //5 : [%]
            $this->T128[] = array(1, 2, 2, 2, 1, 3);           //6 : [&]
            $this->T128[] = array(1, 2, 2, 3, 1, 2);           //7 : [']
            $this->T128[] = array(1, 3, 2, 2, 1, 2);           //8 : [(]
            $this->T128[] = array(2, 2, 1, 2, 1, 3);           //9 : [)]
            $this->T128[] = array(2, 2, 1, 3, 1, 2);           //10 : [*]
            $this->T128[] = array(2, 3, 1, 2, 1, 2);           //11 : [+]
            $this->T128[] = array(1, 1, 2, 2, 3, 2);           //12 : [,]
            $this->T128[] = array(1, 2, 2, 1, 3, 2);           //13 : [-]
            $this->T128[] = array(1, 2, 2, 2, 3, 1);           //14 : [.]
            $this->T128[] = array(1, 1, 3, 2, 2, 2);           //15 : [/]
            $this->T128[] = array(1, 2, 3, 1, 2, 2);           //16 : [0]
            $this->T128[] = array(1, 2, 3, 2, 2, 1);           //17 : [1]
            $this->T128[] = array(2, 2, 3, 2, 1, 1);           //18 : [2]
            $this->T128[] = array(2, 2, 1, 1, 3, 2);           //19 : [3]
            $this->T128[] = array(2, 2, 1, 2, 3, 1);           //20 : [4]
            $this->T128[] = array(2, 1, 3, 2, 1, 2);           //21 : [5]
            $this->T128[] = array(2, 2, 3, 1, 1, 2);           //22 : [6]
            $this->T128[] = array(3, 1, 2, 1, 3, 1);           //23 : [7]
            $this->T128[] = array(3, 1, 1, 2, 2, 2);           //24 : [8]
            $this->T128[] = array(3, 2, 1, 1, 2, 2);           //25 : [9]
            $this->T128[] = array(3, 2, 1, 2, 2, 1);           //26 : [:]
            $this->T128[] = array(3, 1, 2, 2, 1, 2);           //27 : [;]
            $this->T128[] = array(3, 2, 2, 1, 1, 2);           //28 : [<]
            $this->T128[] = array(3, 2, 2, 2, 1, 1);           //29 : [=]
            $this->T128[] = array(2, 1, 2, 1, 2, 3);           //30 : [>]
            $this->T128[] = array(2, 1, 2, 3, 2, 1);           //31 : [?]
            $this->T128[] = array(2, 3, 2, 1, 2, 1);           //32 : [@]
            $this->T128[] = array(1, 1, 1, 3, 2, 3);           //33 : [A]
            $this->T128[] = array(1, 3, 1, 1, 2, 3);           //34 : [B]
            $this->T128[] = array(1, 3, 1, 3, 2, 1);           //35 : [C]
            $this->T128[] = array(1, 1, 2, 3, 1, 3);           //36 : [D]
            $this->T128[] = array(1, 3, 2, 1, 1, 3);           //37 : [E]
            $this->T128[] = array(1, 3, 2, 3, 1, 1);           //38 : [F]
            $this->T128[] = array(2, 1, 1, 3, 1, 3);           //39 : [G]
            $this->T128[] = array(2, 3, 1, 1, 1, 3);           //40 : [H]
            $this->T128[] = array(2, 3, 1, 3, 1, 1);           //41 : [I]
            $this->T128[] = array(1, 1, 2, 1, 3, 3);           //42 : [J]
            $this->T128[] = array(1, 1, 2, 3, 3, 1);           //43 : [K]
            $this->T128[] = array(1, 3, 2, 1, 3, 1);           //44 : [L]
            $this->T128[] = array(1, 1, 3, 1, 2, 3);           //45 : [M]
            $this->T128[] = array(1, 1, 3, 3, 2, 1);           //46 : [N]
            $this->T128[] = array(1, 3, 3, 1, 2, 1);           //47 : [O]
            $this->T128[] = array(3, 1, 3, 1, 2, 1);           //48 : [P]
            $this->T128[] = array(2, 1, 1, 3, 3, 1);           //49 : [Q]
            $this->T128[] = array(2, 3, 1, 1, 3, 1);           //50 : [R]
            $this->T128[] = array(2, 1, 3, 1, 1, 3);           //51 : [S]
            $this->T128[] = array(2, 1, 3, 3, 1, 1);           //52 : [T]
            $this->T128[] = array(2, 1, 3, 1, 3, 1);           //53 : [U]
            $this->T128[] = array(3, 1, 1, 1, 2, 3);           //54 : [V]
            $this->T128[] = array(3, 1, 1, 3, 2, 1);           //55 : [W]
            $this->T128[] = array(3, 3, 1, 1, 2, 1);           //56 : [X]
            $this->T128[] = array(3, 1, 2, 1, 1, 3);           //57 : [Y]
            $this->T128[] = array(3, 1, 2, 3, 1, 1);           //58 : [Z]
            $this->T128[] = array(3, 3, 2, 1, 1, 1);           //59 : [[]
            $this->T128[] = array(3, 1, 4, 1, 1, 1);           //60 : [\]
            $this->T128[] = array(2, 2, 1, 4, 1, 1);           //61 : []]
            $this->T128[] = array(4, 3, 1, 1, 1, 1);           //62 : [^]
            $this->T128[] = array(1, 1, 1, 2, 2, 4);           //63 : [_]
            $this->T128[] = array(1, 1, 1, 4, 2, 2);           //64 : [`]
            $this->T128[] = array(1, 2, 1, 1, 2, 4);           //65 : [a]
            $this->T128[] = array(1, 2, 1, 4, 2, 1);           //66 : [b]
            $this->T128[] = array(1, 4, 1, 1, 2, 2);           //67 : [c]
            $this->T128[] = array(1, 4, 1, 2, 2, 1);           //68 : [d]
            $this->T128[] = array(1, 1, 2, 2, 1, 4);           //69 : [e]
            $this->T128[] = array(1, 1, 2, 4, 1, 2);           //70 : [f]
            $this->T128[] = array(1, 2, 2, 1, 1, 4);           //71 : [g]
            $this->T128[] = array(1, 2, 2, 4, 1, 1);           //72 : [h]
            $this->T128[] = array(1, 4, 2, 1, 1, 2);           //73 : [i]
            $this->T128[] = array(1, 4, 2, 2, 1, 1);           //74 : [j]
            $this->T128[] = array(2, 4, 1, 2, 1, 1);           //75 : [k]
            $this->T128[] = array(2, 2, 1, 1, 1, 4);           //76 : [l]
            $this->T128[] = array(4, 1, 3, 1, 1, 1);           //77 : [m]
            $this->T128[] = array(2, 4, 1, 1, 1, 2);           //78 : [n]
            $this->T128[] = array(1, 3, 4, 1, 1, 1);           //79 : [o]
            $this->T128[] = array(1, 1, 1, 2, 4, 2);           //80 : [p]
            $this->T128[] = array(1, 2, 1, 1, 4, 2);           //81 : [q]
            $this->T128[] = array(1, 2, 1, 2, 4, 1);           //82 : [r]
            $this->T128[] = array(1, 1, 4, 2, 1, 2);           //83 : [s]
            $this->T128[] = array(1, 2, 4, 1, 1, 2);           //84 : [t]
            $this->T128[] = array(1, 2, 4, 2, 1, 1);           //85 : [u]
            $this->T128[] = array(4, 1, 1, 2, 1, 2);           //86 : [v]
            $this->T128[] = array(4, 2, 1, 1, 1, 2);           //87 : [w]
            $this->T128[] = array(4, 2, 1, 2, 1, 1);           //88 : [x]
            $this->T128[] = array(2, 1, 2, 1, 4, 1);           //89 : [y]
            $this->T128[] = array(2, 1, 4, 1, 2, 1);           //90 : [z]
            $this->T128[] = array(4, 1, 2, 1, 2, 1);           //91 : [{]
            $this->T128[] = array(1, 1, 1, 1, 4, 3);           //92 : [|]
            $this->T128[] = array(1, 1, 1, 3, 4, 1);           //93 : [}]
            $this->T128[] = array(1, 3, 1, 1, 4, 1);           //94 : [~]
            $this->T128[] = array(1, 1, 4, 1, 1, 3);           //95 : [DEL]
            $this->T128[] = array(1, 1, 4, 3, 1, 1);           //96 : [FNC3]
            $this->T128[] = array(4, 1, 1, 1, 1, 3);           //97 : [FNC2]
            $this->T128[] = array(4, 1, 1, 3, 1, 1);           //98 : [SHIFT]
            $this->T128[] = array(1, 1, 3, 1, 4, 1);           //99 : [Cswap]
            $this->T128[] = array(1, 1, 4, 1, 3, 1);           //100 : [Bswap]
            $this->T128[] = array(3, 1, 1, 1, 4, 1);           //101 : [Aswap]
            $this->T128[] = array(4, 1, 1, 1, 3, 1);           //102 : [FNC1]
            $this->T128[] = array(2, 1, 1, 4, 1, 2);           //103 : [Astart]
            $this->T128[] = array(2, 1, 1, 2, 1, 4);           //104 : [Bstart]
            $this->T128[] = array(2, 1, 1, 2, 3, 2);           //105 : [Cstart]
            $this->T128[] = array(2, 3, 3, 1, 1, 1);           //106 : [STOP]
            $this->T128[] = array(2, 1);                       //107 : [END BAR]

            for ($i = 32; $i <= 95; $i++) {                                            // jeux de caractres
                $this->ABCset .= chr($i);
            }
            $this->Aset = $this->ABCset;
            $this->Bset = $this->ABCset;
            for ($i = 0; $i <= 31; $i++) {
                $this->ABCset .= chr($i);
                $this->Aset .= chr($i);
            }
            for ($i = 96; $i <= 126; $i++) {
                $this->ABCset .= chr($i);
                $this->Bset .= chr($i);
            }
            $this->Cset="0123456789";

            for ($i=0; $i<96; $i++) {                                                  // convertisseurs des jeux A & B
                @$this->SetFrom["A"] .= chr($i);
                @$this->SetFrom["B"] .= chr($i + 32);
                @$this->SetTo["A"] .= chr(($i < 32) ? $i+64 : $i-32);
                @$this->SetTo["B"] .= chr($i);
            }
        }

        //________________ Fonction encodage et dessin du code 128 _____________________
        function Code128($x,$y,$code,$w,$h) {
            $Aguid="";                                                                      // Cration des guides de choix ABC
            $Bguid="";
            $Cguid="";
            for ($i=0; $i < strlen($code); $i++) {
                $needle=substr($code,$i,1);
                $Aguid .= ((strpos($this->Aset,$needle)===FALSE) ? "N" : "O");
                $Bguid .= ((strpos($this->Bset,$needle)===FALSE) ? "N" : "O");
                $Cguid .= ((strpos($this->Cset,$needle)===FALSE) ? "N" : "O");
            }

            $SminiC = "OOOO";
            $IminiC = 4;

            $crypt = "";
            while ($code > "") {
                                                                                            // BOUCLE PRINCIPALE DE CODAGE
                $i = strpos($Cguid,$SminiC);                                                // forage du jeu C, si possible
                if ($i!==FALSE) {
                    $Aguid [$i] = "N";
                    $Bguid [$i] = "N";
                }

                if (substr($Cguid,0,$IminiC) == $SminiC) {                                  // jeu C
                    $crypt .= chr(($crypt > "") ? $this->JSwap["C"] : $this->JStart["C"]);  // dbut Cstart, sinon Cswap
                    $made = strpos($Cguid,"N");                                             // tendu du set C
                    if ($made === FALSE) $made = strlen($Cguid);
                    if (fmod($made,2)==1) $made--;                                          // seulement un nombre pair
                    for ($i=0; $i < $made; $i += 2) $crypt .= chr(strval(substr($code,$i,2))); // conversion 2 par 2
                    $jeu = "C";
                } else {
                    $madeA = strpos($Aguid,"N");                                            // tendu du set A
                    if ($madeA === FALSE) $madeA = strlen($Aguid);
                    $madeB = strpos($Bguid,"N");                                            // tendu du set B
                    if ($madeB === FALSE) $madeB = strlen($Bguid);
                    $made = (($madeA < $madeB) ? $madeB : $madeA );                         // tendu traite
                    $jeu = (($madeA < $madeB) ? "B" : "A" );                                // Jeu en cours
                    $jeuguid = $jeu . "guid";

                    $crypt .= chr(($crypt > "") ? $this->JSwap["$jeu"] : $this->JStart["$jeu"]); // dbut start, sinon swap

                    $crypt .= strtr(substr($code, 0,$made), $this->SetFrom[$jeu], $this->SetTo[$jeu]); // conversion selon jeu

                }
                $code = substr($code,$made);                                           // raccourcir lgende et guides de la zone traite
                $Aguid = substr($Aguid,$made);
                $Bguid = substr($Bguid,$made);
                $Cguid = substr($Cguid,$made);
            }                                                                          // FIN BOUCLE PRINCIPALE

            $check=ord($crypt[0]);                                                     // calcul de la somme de contrle
            for ($i=0; $i<strlen($crypt); $i++) {
                $check += (ord($crypt[$i]) * $i);
            }
            $check %= 103;

            $crypt .= chr($check) . chr(106) . chr(107);                               // Chaine Crypte complte

            $i = (strlen($crypt) * 11) - 8;                                            // calcul de la largeur du module
            $modul = $w/$i;

            for ($i=0; $i<strlen($crypt); $i++) {                                      // BOUCLE D'IMPRESSION
                $c = $this->T128[ord($crypt[$i])];
                for ($j=0; $j<count($c); $j++) {
                    $this->Rect($x,$y,$c[$j]*$modul,$h,"F");
                    $x += ($c[$j++]+$c[$j])*$modul;
                }
            }
        }  
    }

    $nr_vias = 0;

    $pdf=new PDF('L');
    $pdf->Open();
    
    $numero = '';
    $border = 1;
    $vias = 1;
    $base_y = 0;

    $pdf->AddPage();
    $pdf->SetFont('Arial','',14);
    $pdf->SetAutoPageBreak(false,30);
    
    $consulta = 'Select * from comunicado_venda '.
                ' where Dominio="'.$_SESSION["Dominio"].'"'.
                ' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
                ' and Nr_Comunicado = "'.$nr_comunicado.'"';
    $resultado = consulta_sql($consulta);
    $resg = consulta_ler_objeto($resultado);
    consulta_limpa($resultado);
    
    $data_cominucado = $data_atual;
    $data_venda = $data_atual;
    $data_instalacao = '';
    $cod_vendedor = '';
    $cod_indicador = '';
    $cod_instalador = '';
	
    $valor_customizacao    = 'R$ 0,00';
    $valor_licensas        = 'R$ 0,00';
    $valor_licensast        = 'R$ 0,00';
    $desconto_licensas     = '';
    $valor_liquido         = 'R$ 0,00';
    $valor_manutencoes     = 'R$ 0,00';
    $valor_manutencoest     = 'R$ 0,00';
    $desconto_manutencoes  = '';
    $valor_liquido_manutencao = 'R$ 0,00';


	$data_cominucado = dataf($resg->Data_Comunicado);

	$data_venda = dataf($resg->Data_Venda);
	if ($resg->Data_Instalacao!='0000-00-00'){
		$data_instalacao = dataf($resg->Data_Instalacao);
	}
	if ($resg->Vendedor>0){
		$cod_vendedor = $resg->Vendedor;
	}

	if ($resg->Indicador>0){
		$cod_indicador = $resg->Indicador;
	}
	if ($resg->Instalador>0){
		$cod_instalador = $resg->Instalador;
	}

	if ($resg->Valor_Customizacao>0){
		$valor_customizacao   = str_replace('"','',to_money($resg->Valor_Customizacao));
		$customizacao = 'SIM';
	}else{
		$customizacao = 'NO';
	}
	if ($resg->Valor_Licenca>0){
		$valor_licensas       = str_replace('"','',to_money($resg->Valor_Licenca));
		$valor_licensast       = str_replace('"','',to_money($resg->Valor_Licenca - $resg->Desconto_Licenca));
	}
	if ($resg->Valor_Manutencao>0){
		$valor_manutencoes    = str_replace('"','',to_money($resg->Valor_Manutencao));
		$valor_manutencoest    = str_replace('"','',to_money($resg->Valor_Manutencao - $resg->Desconto_Manutencao));
	}
	if ($resg->Desconto_Licenca>0){
		$desconto_licensas    = str_replace('"','',to_money($resg->Desconto_Licenca));
	}
	if ($resg->Desconto_Manutencao>0){
		$desconto_manutencoes = str_replace('"','',to_money($resg->Desconto_Manutencao));
	}

	$valor_liquido =  str_replace('"','',to_money($resg->Valor_Licenca+$resg->Valor_Customizacao-$resg->Desconto_Licenca));
	$valor_liquido_manutencao = str_replace('"','',to_money($resg->Valor_Manutencao-$resg->Desconto_Manutencao ));

    
    $con_pessoa = 'select * from pessoa '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoa = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    
    $con_pessoa = 'select * from pessoa_endereco '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"'.
                  ' and Situacao="A"'.
                  ' order by Seq_Endereco';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoae = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    
    $con_pessoa = 'select group_concat(Numero_Telefone) Numero_Telefone from pessoa_telefone '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"'.
                  ' and Situacao="A"'.
                  ' and ((Tipo_Telefone = 1) or (Tipo_Telefone = 2))';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoat = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    
    
    $con_pessoa = 'select group_concat(Numero_Telefone) Numero_Telefone from pessoa_telefone '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"'.
                  ' and Situacao="A"'.
                  ' and ((Tipo_Telefone = 3) or (Tipo_Telefone = 4))';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoatc = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    
    $con_pessoa = 'select group_concat(Numero_Telefone) Numero_Telefone from pessoa_telefone '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"'.
                  ' and Situacao="A"'.
                  ' and (Tipo_Telefone = 5)';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoatf = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    
    $con_pessoa = 'select group_concat(Nome) Nome from pessoa_contato '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"'.
                  ' and Situacao="A"'.
                  ' order by Seq_Contato';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_pessoac = consulta_ler_objeto($res_pessoa);
    consulta_limpa($res_pessoa);
    $contato = $reg_pessoac->Nome;
    
    $con_pessoa = 'select Meio_Pagto_Padrao from pessoa_cliente '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$codigo.'"';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_cliente = consulta_ler_linha($res_pessoa);
    consulta_limpa($res_pessoa);

    $con_pessoa = 'select Pessoa, Nome_Listas from pessoa '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$cod_vendedor.'"';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_vendedor = consulta_ler_linha($res_pessoa);
    consulta_limpa($res_pessoa);

    $con_pessoa = 'select Pessoa, Nome_Listas from pessoa '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$cod_indicador.'"';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_indicador = consulta_ler_linha($res_pessoa);
    consulta_limpa($res_pessoa);

    $con_pessoa = 'select Pessoa, Nome_Listas from pessoa '.
                  ' where Dominio="'.$_SESSION["Dominio"].'"'.
                  ' and Pessoa = "'.$cod_instalador.'"';
    $res_pessoa = consulta_sql($con_pessoa);
    $reg_instalador = consulta_ler_linha($res_pessoa);
    consulta_limpa($res_pessoa);
    
    
    for($nr_linha=0;$nr_linha<15;$nr_linha++){
		$lina[$nr_linha] = '';
    }

    $nome_sistema = '';
    $nr_copias = '';
    $proprietario = '';
    $vencimentos = '';
    
    $sql = 'select Data_Vencto,Valor from comunicado_venda_parcela '.
           ' where Dominio="'.$_SESSION["Dominio"].'"'.
           ' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
           ' and Nr_Comunicado = "'.$nr_comunicado.'"'.
           ' order by Parcela';
    $res_itens = consulta_sql($sql);
    $nrw_itens = consulta_num_registros($res_itens);
    for($it=0;$it<$nrw_itens;$it++){
		$reg_itens = consulta_ler_objeto($res_itens);
		if ($vencimentos!=''){
			$vencimentos.= ', ';
		}
		$vencimentos.= dataf($reg_itens->Data_Vencto).' ('.str_replace('"','',to_money($reg_itens->Valor)).')';
    }
    consulta_limpa($res_itens);
    
    
    $sql = 'select * from comunicado_venda_itens '.
           ' where Dominio="'.$_SESSION["Dominio"].'"'.
           ' and Empresa = "'.$_SESSION["Empresa_Codigo"].'"'.
           ' and Nr_Comunicado = "'.$nr_comunicado.'"'.
           ' and Situacao<>"E"'.
           ' order by Id_Produto, Seq_Item';
    $itens = array();
           
    $res_itens = consulta_sql($sql);
    $nrw_itens = consulta_num_registros($res_itens);
    $ult_pago = '';
    $pimeiro = '';
    for($it=0;$it<$nrw_itens;$it++){
		$reg_itens = consulta_ler_objeto($res_itens);

		$id_item = $reg_itens->Id_Produto;
		$gratuito = '';

		if (($reg_itens->Valor_Licensa==0)&&($reg_itens->Valor_Mensal==0)){
			if ($ult_pago!=''){
				if ( ($itens[$ult_pago]['gratuito']=='')||
					($itens[$ult_pago]['gratuito']==$id_item)){
					$gratuito = $id_item;
					$id_item = $ult_pago;
				}
			}
		}
		if ($pimeiro==''){
			$pimeiro = $id_item;
		}
		if (!(isset($itens[$id_item]))){
			$itens[$id_item]['qtd_l'] = 0;
			$itens[$id_item]['qtd_m'] = 0;
			$itens[$id_item]['valor'] = 0;
			$itens[$id_item]['mensal'] = 0;
			$itens[$id_item]['gratuito'] = '';
			$itens[$id_item]['gratuitoq'] = 0;
		}
		if ($reg_itens->Valor_Licensa>0){
			$itens[$id_item]['qtd_l']++;
		}
		if ($reg_itens->Valor_Mensal>0){
			$itens[$id_item]['qtd_m']++;
		}
		$itens[$id_item]['valor']+= $reg_itens->Valor_Licensa;
		$itens[$id_item]['mensal']+= $reg_itens->Valor_Mensal;
		if ($gratuito!=''){
			$itens[$id_item]['gratuito'] = $gratuito;
			$itens[$id_item]['gratuitoq']++;
		}

		if ($reg_itens->Valor_Mensal>0){      
			$con_prod = 'select Codigo_Produto, Descricao_Completa'.
						' from produto '.
						' where Dominio ="'.$_SESSION['Dominio'].'"'.
						' and Id_Produto="'.$id_item.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);
			
			if (substr($reg_prod[1],0,7)=='$IMPLES'){
				$nr_copias++;
			}
		}
		$ult_pago = $id_item;
    }
    consulta_limpa($res_itens);
    $linhas_produto    = array();
    $linhas_manutencao = array();
    $cont_produto    = 0;
    $cont_manutencao = 0;

    foreach($itens as $id_item => $valor){
        $con_prod = 'select Codigo_Produto, Descricao_Curta'.
                    ' from produto '.
                    ' where Dominio ="'.$_SESSION['Dominio'].'"'.
                    ' and Id_Produto="'.$id_item.'"';
        $res_prod = consulta_sql($con_prod);
        $reg_prod = consulta_ler_linha($res_prod);
        consulta_limpa($res_prod);
        $qtd = 0;
        if ($itens[$id_item]['qtd_m']>0){
			$linhas_manutencao[$cont_manutencao]=$itens[$id_item]['qtd_m'].' '.$reg_prod[1].' = '.str_replace('"','',to_money($itens[$id_item]['mensal']));
			$cont_manutencao++;
			$qtd = $itens[$id_item]['qtd_m'];
        }

        if ($itens[$id_item]['qtd_l']>0){
			$linhas_produto[$cont_produto]=$itens[$id_item]['qtd_l'].' '.$reg_prod[1].' = '.str_replace('"','',to_money($itens[$id_item]['valor']));
			$cont_produto++;
			$qtd = $itens[$id_item]['qtd_l'];
        }
        if ($qtd == 0){
			$qtd = '1';
        }
        
        if ($nome_sistema!=''){
			$nome_sistema.= ' + ';
        }
        $nome_sistema.= $qtd.' '.$reg_prod[1];
        if ($itens[$id_item]['gratuitoq']>0){
			$con_prod = 'select Codigo_Produto, Descricao_Curta'.
                        ' from produto '.
                        ' where Dominio ="'.$_SESSION['Dominio'].'"'.
                        ' and Id_Produto="'.$itens[$id_item]['gratuito'].'"';
            $res_prod = consulta_sql($con_prod);
            $reg_prod = consulta_ler_linha($res_prod);
            consulta_limpa($res_prod);
        
			$nome_sistema.= ' (sendo '.$itens[$id_item]['gratuitoq'].' c/ '.$reg_prod[1].')';
        }
        
    }
    $linha_atual=0;
    
    if ($cont_manutencao>0){
        $lina[$linha_atual] = 'LICENCIAMENTO';
        $linha_atual++;
        $linhas_dentro=0;
        foreach($linhas_produto as $id_linha => $valor){
			if ($lina[$linha_atual]!=''){
				$lina[$linha_atual].=',';
			}
			$lina[$linha_atual] = trim($lina[$linha_atual].' '.$valor);
			$linhas_dentro++;
			if ( ($linhas_dentro % 2) == 0) {
				$linha_atual++;
			}
        }
        if ( ($linhas_dentro % 2) != 0) {
			$linha_atual++;
        }
        if ($desconto_licensas!=''){
			$lina[$linha_atual] = 'TOTAL = '.$valor_licensas.' - '.$desconto_licensas.' = '.$valor_licensast;
        }else{
			$lina[$linha_atual] = 'TOTAL = '.$valor_licensas;
        }
        $linha_atual++;
    }
    if ($cont_produto>0){
        $lina[$linha_atual] = 'MANUTENO';
        $linha_atual++;
        $linhas_dentro = 0;
        foreach($linhas_manutencao as $id_linha => $valor){
			if ($lina[$linha_atual]!=''){
				$lina[$linha_atual].=',';
			}
			$lina[$linha_atual] = trim($lina[$linha_atual].' '.$valor);
			$linhas_dentro++;
			if ( ($linhas_dentro % 2) == 0) {
				$linha_atual++;
			}
        }
        if ( ($linhas_dentro % 2) != 0) {
			$linha_atual++;
        }
        if ($desconto_manutencoes!=''){
			$lina[$linha_atual] = 'TOTAL = '.$valor_manutencoes.' - '.$desconto_manutencoes.' = '.$valor_manutencoest;
        }else{
			$lina[$linha_atual] = 'TOTAL = '.$valor_manutencoes;
        }
        $linha_atual++;
    }
    
    $larg = 130;
    
    if ($resg->Observacao!=''){
       $pdf->SetFont('Arial','B',7);
       $lns_nome = $pdf->Lines_MultiCell($larg,$lns,$resg->Observacao,1);
       $lina[$linha_atual] = $resg->Observacao;
       $linha_atual+=$lns_nome;
    }
    
    $lina[$linha_atual] = 'Formas de Pagamento';
    $linha_atual++;

    $lns_nome = $pdf->Lines_MultiCell($larg,$lns,$vencimentos,1);

    $lina[$linha_atual] = $vencimentos;
    $lns_nome++;
    
    $base_x = 15; 

    for ($fh=0;$fh<2;$fh++){
        set_time_limit(30);
        $pdf->y = 10;
        $lns = 5;
        
		$pdf->SetFont('Arial','B',8);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',8);

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell($larg, $lns, 'COMUNICAO DE VENDA', 1, 'C');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$lns = 4;

		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoa->Nome_Razao,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CLIENTE', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->Nome_Razao, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);



		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_vendedor[1],1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'VENDEDOR', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_vendedor[1], 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_indicador[1],1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'INDICADOR', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_indicador[1], 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);
         
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_instalador[1],1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'INSTALADOR', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_instalador[1], 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'DATA DE VENDA', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $data_venda, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'DATA INSTALAO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $data_instalacao, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'DATA COMUNICADO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $data_cominucado, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

        
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$nome_sistema,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'NOME DO SISTEMA', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $nome_sistema, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'TIPO DE MANUT.', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, UpperDados( busca_dados_combo('tipo_manutencao',$resg->Tipo_Manutencao)), 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'NMERO DE CPIAS', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $nr_copias, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'VALOR LICENCIAMENTO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $valor_licensast, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);
         
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'VALOR MANUTENO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $valor_manutencoest, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'VALOR CUSTOM.', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $valor_customizacao, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'VALOR TOTAL', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $valor_liquido, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell($larg, $lns_atual, ' DADOS CADASTRAIS', 1, 'C');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoa->Nome_Razao,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'RAZO SOCIAL', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->Nome_Razao, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoa->Nome_Fantasia,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'FANTASIA', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->Nome_Fantasia, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CDIGO CLIENTE', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->Pessoa, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CPF/CNPJ', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->CPF_CNPJ, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'INSCRIO ESTADUAL', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoae->Insc_Estadual, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$endereco = $reg_pessoae->Logradouro.', ';
		if ($reg_pessoae->Numero!=''){
			$endereco.= $reg_pessoae->Numero;
		}else{
			$endereco.= 'S/N';
		}


		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$endereco,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'ENDEREO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $endereco, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoae->Bairro,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'BAIRRO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoae->Bairro, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoae->Nome_Cidade.'/'.$reg_pessoae->UF,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CIDADE/ESTADO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoae->Nome_Cidade.'/'.$reg_pessoae->UF, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoat->Numero_Telefone,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'TELEFONE', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoat->Numero_Telefone, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoatf->Numero_Telefone,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'FAX', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoatf->Numero_Telefone, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoatc->Numero_Telefone,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CELULAR', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoatc->Numero_Telefone, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoa->EMail,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'E-MAIL', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->EMail, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$reg_pessoa->Web_Site,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'SITE', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $reg_pessoa->Web_Site, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$contato,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'CONTATO', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $contato, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_nome = $pdf->Lines_MultiCell((70/100)*$larg,$lns,$proprietario,1);
		$lns_atual =  $lns * $lns_nome;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell((30/100)*$larg, $lns_atual, 'PROPRIETRIO (COMP.)', 1, 'L');
		$pdf->y=$y;

		$pdf->SetFont('Arial','',7);

		$y=$pdf->y;
		$pdf->MultiCell((70/100)*$larg, $lns, $proprietario, 1, 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);

		//----------
		$pdf->SetFont('Arial','B',7);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',7);

		$lns_atual =  $lns;

		$pdf->x = $base_x;

		$y=$pdf->y;
		$pdf->MultiCell($larg, $lns_atual, 'OBSERVAO', 1, 'C');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns_atual;
		$pdf->SetAutoPageBreak(true,30);


		for($nr_linha=0;$nr_linha<15;$nr_linha++){
			//----------
			$pdf->SetFont('Arial','B',7);
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetAutoPageBreak(false,5);
			$pdf->SetFont('Arial','',7);

			$lns_atual =  $lns;

			$pdf->x = $base_x;

			$y=$pdf->y;
			$pdf->MultiCell($larg, $lns, $lina[$nr_linha], 1, 'C');
			$pdf->y=$y;


			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns_atual;
			$pdf->SetAutoPageBreak(true,5);

		}
		$base_x = 155;
    }
    echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>