<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');

	session::usr_conectado($_REQUEST['USER_ID']);
	$filtro = '';

	class PDF extends FPDF {

		var $T128;                                             // tableau des codes 128
		var $ABCset="";                                        // jeu des caractres ligibles au C128
		var $Aset="";                                          // Set A du jeu des caractres ligibles
		var $Bset="";                                          // Set B du jeu des caractres ligibles
		var $Cset="";                                          // Set C du jeu des caractres ligibles
		var $SetFrom;                                          // Convertisseur source des jeux vers le tableau
		var $SetTo;                                            // Convertisseur destination des jeux vers le tableau
		var $JStart = array("A"=>103, "B"=>104, "C"=>105);     // Caractres de slection de jeu au dbut du C128
		var $JSwap = array("A"=>101, "B"=>100, "C"=>99);       // Caractres de changement de jeu

		function Header() {

		}

		function Footer() {
			//
		}

		
		// based on the Code 39 script from The-eh

		function i25($xpos, $ypos, $code, $basewidth=1, $height=10, $texto_exibe = true ,$texto_fonte = 10){

			$wide = $basewidth;
			$narrow = $basewidth / 3 ;

			// wide/narrow codes for the digits
			$barChar['0'] = 'nnwwn';
			$barChar['1'] = 'wnnnw';
			$barChar['2'] = 'nwnnw';
			$barChar['3'] = 'wwnnn';
			$barChar['4'] = 'nnwnw';
			$barChar['5'] = 'wnwnn';
			$barChar['6'] = 'nwwnn';
			$barChar['7'] = 'nnnww';
			$barChar['8'] = 'wnnwn';
			$barChar['9'] = 'nwnwn';
			$barChar['A'] = 'nn';
			$barChar['Z'] = 'wn';

			// add leading zero if code-length is odd
			if(strlen($code) % 2 != 0){
				$code = '0' . $code;
			}
			if ($texto_exibe){
				$this->SetFont('Arial','',$texto_fonte);
				$this->Text($xpos, $ypos + $height + 4, $code);
			}
			$this->SetFillColor(0);

			// add start and stop codes
			$code = 'AA'.strtolower($code).'ZA';

			for($i=0; $i<strlen($code); $i=$i+2){
				// choose next pair of digits
				$charBar = $code{$i};
				$charSpace = $code{$i+1};
				// check whether it is a valid digit
				if(!isset($barChar[$charBar])){
					$this->Error('Invalid character in barcode: '.$charBar);
				}
				if(!isset($barChar[$charSpace])){
					$this->Error('Invalid character in barcode: '.$charSpace);
				}
				// create a wide/narrow-sequence (first digit=bars, second digit=spaces)
				$seq = '';
				for($s=0; $s<strlen($barChar[$charBar]); $s++){
					$seq .= $barChar[$charBar]{$s} . $barChar[$charSpace]{$s};
				}
				for($bar=0; $bar<strlen($seq); $bar++){
					// set lineWidth depending on value
					if($seq{$bar} == 'n'){
						$lineWidth = $narrow;
					}else{
						$lineWidth = $wide;
					}
					// draw every second value, because the second digit of the pair is represented by the spaces
					if($bar % 2 == 0){
						$this->Rect($xpos, $ypos, $lineWidth, $height, 'F');
					}
					$xpos += $lineWidth;
				}
			}
		}

		function Code39($xpos, $ypos, $code, $baseline=0.5, $height=5, $texto_exibe = true ,$texto_fonte = 10){

			$wide = $baseline;
			$narrow = $baseline / 3 ;
			$gap = $narrow;

			$barChar['0'] = 'nnnwwnwnn';
			$barChar['1'] = 'wnnwnnnnw';
			$barChar['2'] = 'nnwwnnnnw';
			$barChar['3'] = 'wnwwnnnnn';
			$barChar['4'] = 'nnnwwnnnw';
			$barChar['5'] = 'wnnwwnnnn';
			$barChar['6'] = 'nnwwwnnnn';
			$barChar['7'] = 'nnnwnnwnw';
			$barChar['8'] = 'wnnwnnwnn';
			$barChar['9'] = 'nnwwnnwnn';
			$barChar['A'] = 'wnnnnwnnw';
			$barChar['B'] = 'nnwnnwnnw';
			$barChar['C'] = 'wnwnnwnnn';
			$barChar['D'] = 'nnnnwwnnw';
			$barChar['E'] = 'wnnnwwnnn';
			$barChar['F'] = 'nnwnwwnnn';
			$barChar['G'] = 'nnnnnwwnw';
			$barChar['H'] = 'wnnnnwwnn';
			$barChar['I'] = 'nnwnnwwnn';
			$barChar['J'] = 'nnnnwwwnn';
			$barChar['K'] = 'wnnnnnnww';
			$barChar['L'] = 'nnwnnnnww';
			$barChar['M'] = 'wnwnnnnwn';
			$barChar['N'] = 'nnnnwnnww';
			$barChar['O'] = 'wnnnwnnwn';
			$barChar['P'] = 'nnwnwnnwn';
			$barChar['Q'] = 'nnnnnnwww';
			$barChar['R'] = 'wnnnnnwwn';
			$barChar['S'] = 'nnwnnnwwn';
			$barChar['T'] = 'nnnnwnwwn';
			$barChar['U'] = 'wwnnnnnnw';
			$barChar['V'] = 'nwwnnnnnw';
			$barChar['W'] = 'wwwnnnnnn';
			$barChar['X'] = 'nwnnwnnnw';
			$barChar['Y'] = 'wwnnwnnnn';
			$barChar['Z'] = 'nwwnwnnnn';
			$barChar['-'] = 'nwnnnnwnw';
			$barChar['.'] = 'wwnnnnwnn';
			$barChar[' '] = 'nwwnnnwnn';
			$barChar['*'] = 'nwnnwnwnn';
			$barChar['$'] = 'nwnwnwnnn';
			$barChar['/'] = 'nwnwnnnwn';
			$barChar['+'] = 'nwnnnwnwn';
			$barChar['%'] = 'nnnwnwnwn';
			if ($texto_exibe){
				$this->SetFont('Arial','',$texto_fonte);
				$this->Text($xpos, $ypos + $height + 4, $code);
			}
			$this->SetFillColor(0);

			$code = '*'.strtoupper($code).'*';
			for($i=0; $i<strlen($code); $i++){
				$char = $code{$i};
				if(!isset($barChar[$char])){
					$this->Error('Invalid character in barcode: '.$char);
				}
				$seq = $barChar[$char];
				for($bar=0; $bar<9; $bar++){
					if($seq{$bar} == 'n'){
						$lineWidth = $narrow;
					}else{
						$lineWidth = $wide;
					}
					if($bar % 2 == 0){
						$this->Rect($xpos, $ypos, $lineWidth, $height, 'F');
					}
					$xpos += $lineWidth;
				}
				$xpos += $gap;
			}
		}

		function EAN13($x,$y,$barcode,$h=16,$w=.35, $texto_exibe = true ,$texto_fonte = 10)
			{
				$this->Barcode($x,$y,$barcode,$h,$w,13, $texto_exibe,$texto_fonte);
			}

		function UPC_A($x,$y,$barcode,$h=16,$w=.35, $texto_exibe = true ,$texto_fonte = 10)
			{
				$this->Barcode($x,$y,$barcode,$h,$w,12, $texto_exibe,$texto_fonte);
			}

		function GetCheckDigit($barcode)
			{
				//Compute the check digit
				$sum=0;
				for($i=1;$i<=11;$i+=2)
					$sum+=3*$barcode{$i};
				for($i=0;$i<=10;$i+=2)
					$sum+=$barcode{$i};
				$r=$sum%10;
				if($r>0)
					$r=10-$r;
				return $r;
			}

		 function TestCheckDigit($barcode)
			{
				//Test validity of check digit
				$sum=0;
				for($i=1;$i<=11;$i+=2)
					$sum+=3*$barcode{$i};
				for($i=0;$i<=10;$i+=2)
					$sum+=$barcode{$i};
				return ($sum+$barcode{12})%10==0;
			}

		 function Barcode($x,$y,$barcode,$h,$w,$len, $texto_exibe = true ,$texto_fonte = 10)
			{
				//Padding
				$barcode=str_pad($barcode,$len-1,'0',STR_PAD_LEFT);
				if($len==12)
					$barcode='0'.$barcode;
				//Add or control the check digit
				if(strlen($barcode)==12)
					$barcode.=$this->GetCheckDigit($barcode);
				elseif(!$this->TestCheckDigit($barcode))
					$this->Error('Incorrect check digit');
				//Convert digits to bars
				$codes=array(
					'A'=>array(
						'0'=>'0001101','1'=>'0011001','2'=>'0010011','3'=>'0111101','4'=>'0100011',
						'5'=>'0110001','6'=>'0101111','7'=>'0111011','8'=>'0110111','9'=>'0001011'),
					'B'=>array(
						'0'=>'0100111','1'=>'0110011','2'=>'0011011','3'=>'0100001','4'=>'0011101',
						'5'=>'0111001','6'=>'0000101','7'=>'0010001','8'=>'0001001','9'=>'0010111'),
					'C'=>array(
						'0'=>'1110010','1'=>'1100110','2'=>'1101100','3'=>'1000010','4'=>'1011100',
						'5'=>'1001110','6'=>'1010000','7'=>'1000100','8'=>'1001000','9'=>'1110100')
					);
				$parities=array(
					'0'=>array('A','A','A','A','A','A'),
					'1'=>array('A','A','B','A','B','B'),
					'2'=>array('A','A','B','B','A','B'),
					'3'=>array('A','A','B','B','B','A'),
					'4'=>array('A','B','A','A','B','B'),
					'5'=>array('A','B','B','A','A','B'),
					'6'=>array('A','B','B','B','A','A'),
					'7'=>array('A','B','A','B','A','B'),
					'8'=>array('A','B','A','B','B','A'),
					'9'=>array('A','B','B','A','B','A')
					);
				$code='101';
				$p=$parities[$barcode{0}];
				for($i=1;$i<=6;$i++)
					$code.=$codes[$p[$i-1]][$barcode{$i}];
				$code.='01010';
				for($i=7;$i<=12;$i++)
					$code.=$codes['C'][$barcode{$i}];
				$code.='101';
				//Draw bars
				for($i=0;$i<strlen($code);$i++)
				{
					if($code{$i}=='1')
						$this->Rect($x+$i*$w,$y,$w,$h,'F');
				}
				//Print text uder barcode
				if ($texto_exibe=='I'){
					$this->SetFont('Courier','B',$texto_fonte);
					$parte1=substr($barcode,0,1);
					$parte2=substr($barcode,1,6);
					$parte3=substr($barcode,7,6);
					$this->SetFillColor(255);
					if ($texto_fonte==7){
						$this->Rect($x+0.9,$y+$h-5/$this->k,$w*41.1,10,'F');
						$this->Rect($x+11.5,$y+$h-5/$this->k,$w*41.1,10,'F');
						
						$this->SetFillColor(0);
						$this->Text($x-2,$y+$h+1/$this->k,$parte1);
						$this->Text($x+1,$y+$h+1/$this->k,$parte2);
						$this->Text($x+12,$y+$h+1/$this->k,$parte3);
					}else{
						$this->Rect($x+1.3,$y+$h-5/$this->k,$w*42,10,'F');
						$this->Rect($x+17.3,$y+$h-5/$this->k,$w*42,10,'F');
						
						$this->SetFillColor(0);
						$this->Text($x-3,$y+$h+5/$this->k,$parte1);
						$this->Text($x+1.5,$y+$h+5/$this->k,$parte2);
						$this->Text($x+17.5,$y+$h+5/$this->k,$parte3);
					}
				}else if ($texto_exibe){
					$this->SetFont('Arial','B',$texto_fonte);
					$this->Text($x,$y+$h+11/$this->k,substr($barcode,-$len));
				}
			}
		

		//____________________________ Extension du constructeur _______________________
		function PDF($orientation='P',$unit='mm',$format='A4') {

			parent::__construct($orientation,$unit,$format);

			$this->T128[] = array(2, 1, 2, 2, 2, 2);           //0 : [ ]               // composition des caractres
			$this->T128[] = array(2, 2, 2, 1, 2, 2);           //1 : [!]
			$this->T128[] = array(2, 2, 2, 2, 2, 1);           //2 : ["]
			$this->T128[] = array(1, 2, 1, 2, 2, 3);           //3 : [#]
			$this->T128[] = array(1, 2, 1, 3, 2, 2);           //4 : [$]
			$this->T128[] = array(1, 3, 1, 2, 2, 2);           //5 : [%]
			$this->T128[] = array(1, 2, 2, 2, 1, 3);           //6 : [&]
			$this->T128[] = array(1, 2, 2, 3, 1, 2);           //7 : [']
			$this->T128[] = array(1, 3, 2, 2, 1, 2);           //8 : [(]
			$this->T128[] = array(2, 2, 1, 2, 1, 3);           //9 : [)]
			$this->T128[] = array(2, 2, 1, 3, 1, 2);           //10 : [*]
			$this->T128[] = array(2, 3, 1, 2, 1, 2);           //11 : [+]
			$this->T128[] = array(1, 1, 2, 2, 3, 2);           //12 : [,]
			$this->T128[] = array(1, 2, 2, 1, 3, 2);           //13 : [-]
			$this->T128[] = array(1, 2, 2, 2, 3, 1);           //14 : [.]
			$this->T128[] = array(1, 1, 3, 2, 2, 2);           //15 : [/]
			$this->T128[] = array(1, 2, 3, 1, 2, 2);           //16 : [0]
			$this->T128[] = array(1, 2, 3, 2, 2, 1);           //17 : [1]
			$this->T128[] = array(2, 2, 3, 2, 1, 1);           //18 : [2]
			$this->T128[] = array(2, 2, 1, 1, 3, 2);           //19 : [3]
			$this->T128[] = array(2, 2, 1, 2, 3, 1);           //20 : [4]
			$this->T128[] = array(2, 1, 3, 2, 1, 2);           //21 : [5]
			$this->T128[] = array(2, 2, 3, 1, 1, 2);           //22 : [6]
			$this->T128[] = array(3, 1, 2, 1, 3, 1);           //23 : [7]
			$this->T128[] = array(3, 1, 1, 2, 2, 2);           //24 : [8]
			$this->T128[] = array(3, 2, 1, 1, 2, 2);           //25 : [9]
			$this->T128[] = array(3, 2, 1, 2, 2, 1);           //26 : [:]
			$this->T128[] = array(3, 1, 2, 2, 1, 2);           //27 : [;]
			$this->T128[] = array(3, 2, 2, 1, 1, 2);           //28 : [<]
			$this->T128[] = array(3, 2, 2, 2, 1, 1);           //29 : [=]
			$this->T128[] = array(2, 1, 2, 1, 2, 3);           //30 : [>]
			$this->T128[] = array(2, 1, 2, 3, 2, 1);           //31 : [?]
			$this->T128[] = array(2, 3, 2, 1, 2, 1);           //32 : [@]
			$this->T128[] = array(1, 1, 1, 3, 2, 3);           //33 : [A]
			$this->T128[] = array(1, 3, 1, 1, 2, 3);           //34 : [B]
			$this->T128[] = array(1, 3, 1, 3, 2, 1);           //35 : [C]
			$this->T128[] = array(1, 1, 2, 3, 1, 3);           //36 : [D]
			$this->T128[] = array(1, 3, 2, 1, 1, 3);           //37 : [E]
			$this->T128[] = array(1, 3, 2, 3, 1, 1);           //38 : [F]
			$this->T128[] = array(2, 1, 1, 3, 1, 3);           //39 : [G]
			$this->T128[] = array(2, 3, 1, 1, 1, 3);           //40 : [H]
			$this->T128[] = array(2, 3, 1, 3, 1, 1);           //41 : [I]
			$this->T128[] = array(1, 1, 2, 1, 3, 3);           //42 : [J]
			$this->T128[] = array(1, 1, 2, 3, 3, 1);           //43 : [K]
			$this->T128[] = array(1, 3, 2, 1, 3, 1);           //44 : [L]
			$this->T128[] = array(1, 1, 3, 1, 2, 3);           //45 : [M]
			$this->T128[] = array(1, 1, 3, 3, 2, 1);           //46 : [N]
			$this->T128[] = array(1, 3, 3, 1, 2, 1);           //47 : [O]
			$this->T128[] = array(3, 1, 3, 1, 2, 1);           //48 : [P]
			$this->T128[] = array(2, 1, 1, 3, 3, 1);           //49 : [Q]
			$this->T128[] = array(2, 3, 1, 1, 3, 1);           //50 : [R]
			$this->T128[] = array(2, 1, 3, 1, 1, 3);           //51 : [S]
			$this->T128[] = array(2, 1, 3, 3, 1, 1);           //52 : [T]
			$this->T128[] = array(2, 1, 3, 1, 3, 1);           //53 : [U]
			$this->T128[] = array(3, 1, 1, 1, 2, 3);           //54 : [V]
			$this->T128[] = array(3, 1, 1, 3, 2, 1);           //55 : [W]
			$this->T128[] = array(3, 3, 1, 1, 2, 1);           //56 : [X]
			$this->T128[] = array(3, 1, 2, 1, 1, 3);           //57 : [Y]
			$this->T128[] = array(3, 1, 2, 3, 1, 1);           //58 : [Z]
			$this->T128[] = array(3, 3, 2, 1, 1, 1);           //59 : [[]
			$this->T128[] = array(3, 1, 4, 1, 1, 1);           //60 : [\]
			$this->T128[] = array(2, 2, 1, 4, 1, 1);           //61 : []]
			$this->T128[] = array(4, 3, 1, 1, 1, 1);           //62 : [^]
			$this->T128[] = array(1, 1, 1, 2, 2, 4);           //63 : [_]
			$this->T128[] = array(1, 1, 1, 4, 2, 2);           //64 : [`]
			$this->T128[] = array(1, 2, 1, 1, 2, 4);           //65 : [a]
			$this->T128[] = array(1, 2, 1, 4, 2, 1);           //66 : [b]
			$this->T128[] = array(1, 4, 1, 1, 2, 2);           //67 : [c]
			$this->T128[] = array(1, 4, 1, 2, 2, 1);           //68 : [d]
			$this->T128[] = array(1, 1, 2, 2, 1, 4);           //69 : [e]
			$this->T128[] = array(1, 1, 2, 4, 1, 2);           //70 : [f]
			$this->T128[] = array(1, 2, 2, 1, 1, 4);           //71 : [g]
			$this->T128[] = array(1, 2, 2, 4, 1, 1);           //72 : [h]
			$this->T128[] = array(1, 4, 2, 1, 1, 2);           //73 : [i]
			$this->T128[] = array(1, 4, 2, 2, 1, 1);           //74 : [j]
			$this->T128[] = array(2, 4, 1, 2, 1, 1);           //75 : [k]
			$this->T128[] = array(2, 2, 1, 1, 1, 4);           //76 : [l]
			$this->T128[] = array(4, 1, 3, 1, 1, 1);           //77 : [m]
			$this->T128[] = array(2, 4, 1, 1, 1, 2);           //78 : [n]
			$this->T128[] = array(1, 3, 4, 1, 1, 1);           //79 : [o]
			$this->T128[] = array(1, 1, 1, 2, 4, 2);           //80 : [p]
			$this->T128[] = array(1, 2, 1, 1, 4, 2);           //81 : [q]
			$this->T128[] = array(1, 2, 1, 2, 4, 1);           //82 : [r]
			$this->T128[] = array(1, 1, 4, 2, 1, 2);           //83 : [s]
			$this->T128[] = array(1, 2, 4, 1, 1, 2);           //84 : [t]
			$this->T128[] = array(1, 2, 4, 2, 1, 1);           //85 : [u]
			$this->T128[] = array(4, 1, 1, 2, 1, 2);           //86 : [v]
			$this->T128[] = array(4, 2, 1, 1, 1, 2);           //87 : [w]
			$this->T128[] = array(4, 2, 1, 2, 1, 1);           //88 : [x]
			$this->T128[] = array(2, 1, 2, 1, 4, 1);           //89 : [y]
			$this->T128[] = array(2, 1, 4, 1, 2, 1);           //90 : [z]
			$this->T128[] = array(4, 1, 2, 1, 2, 1);           //91 : [{]
			$this->T128[] = array(1, 1, 1, 1, 4, 3);           //92 : [|]
			$this->T128[] = array(1, 1, 1, 3, 4, 1);           //93 : [}]
			$this->T128[] = array(1, 3, 1, 1, 4, 1);           //94 : [~]
			$this->T128[] = array(1, 1, 4, 1, 1, 3);           //95 : [DEL]
			$this->T128[] = array(1, 1, 4, 3, 1, 1);           //96 : [FNC3]
			$this->T128[] = array(4, 1, 1, 1, 1, 3);           //97 : [FNC2]
			$this->T128[] = array(4, 1, 1, 3, 1, 1);           //98 : [SHIFT]
			$this->T128[] = array(1, 1, 3, 1, 4, 1);           //99 : [Cswap]
			$this->T128[] = array(1, 1, 4, 1, 3, 1);           //100 : [Bswap]
			$this->T128[] = array(3, 1, 1, 1, 4, 1);           //101 : [Aswap]
			$this->T128[] = array(4, 1, 1, 1, 3, 1);           //102 : [FNC1]
			$this->T128[] = array(2, 1, 1, 4, 1, 2);           //103 : [Astart]
			$this->T128[] = array(2, 1, 1, 2, 1, 4);           //104 : [Bstart]
			$this->T128[] = array(2, 1, 1, 2, 3, 2);           //105 : [Cstart]
			$this->T128[] = array(2, 3, 3, 1, 1, 1);           //106 : [STOP]
			$this->T128[] = array(2, 1);                       //107 : [END BAR]

			for ($i = 32; $i <= 95; $i++) {                                            // jeux de caractres
				$this->ABCset .= chr($i);
			}
			$this->Aset = $this->ABCset;
			$this->Bset = $this->ABCset;
			for ($i = 0; $i <= 31; $i++) {
				$this->ABCset .= chr($i);
				$this->Aset .= chr($i);
			}
			for ($i = 96; $i <= 126; $i++) {
				$this->ABCset .= chr($i);
				$this->Bset .= chr($i);
			}
			$this->Cset="0123456789";

			for ($i=0; $i<96; $i++) {                                                  // convertisseurs des jeux A & B
				@$this->SetFrom["A"] .= chr($i);
				@$this->SetFrom["B"] .= chr($i + 32);
				@$this->SetTo["A"] .= chr(($i < 32) ? $i+64 : $i-32);
				@$this->SetTo["B"] .= chr($i);
			}
		}

		//________________ Fonction encodage et dessin du code 128 _____________________
		function Code128($x,$y,$code,$w,$h) {
			$Aguid="";                                                                      // Cration des guides de choix ABC
			$Bguid="";
			$Cguid="";
			for ($i=0; $i < strlen($code); $i++) {
				$needle=substr($code,$i,1);
				$Aguid .= ((strpos($this->Aset,$needle)===FALSE) ? "N" : "O");
				$Bguid .= ((strpos($this->Bset,$needle)===FALSE) ? "N" : "O");
				$Cguid .= ((strpos($this->Cset,$needle)===FALSE) ? "N" : "O");
			}

			$SminiC = "OOOO";
			$IminiC = 4;

			$crypt = "";
			while ($code > "") {
																							// BOUCLE PRINCIPALE DE CODAGE
				$i = strpos($Cguid,$SminiC);                                                // forage du jeu C, si possible
				if ($i!==FALSE) {
					$Aguid [$i] = "N";
					$Bguid [$i] = "N";
				}

				if (substr($Cguid,0,$IminiC) == $SminiC) {                                  // jeu C
					$crypt .= chr(($crypt > "") ? $this->JSwap["C"] : $this->JStart["C"]);  // dbut Cstart, sinon Cswap
					$made = strpos($Cguid,"N");                                             // tendu du set C
					if ($made === FALSE) $made = strlen($Cguid);
					if (fmod($made,2)==1) $made--;                                          // seulement un nombre pair
					for ($i=0; $i < $made; $i += 2) $crypt .= chr(strval(substr($code,$i,2))); // conversion 2 par 2
					$jeu = "C";
				} else {
					$madeA = strpos($Aguid,"N");                                            // tendu du set A
					if ($madeA === FALSE) $madeA = strlen($Aguid);
					$madeB = strpos($Bguid,"N");                                            // tendu du set B
					if ($madeB === FALSE) $madeB = strlen($Bguid);
					$made = (($madeA < $madeB) ? $madeB : $madeA );                         // tendu traite
					$jeu = (($madeA < $madeB) ? "B" : "A" );                                // Jeu en cours
					$jeuguid = $jeu . "guid";

					$crypt .= chr(($crypt > "") ? $this->JSwap["$jeu"] : $this->JStart["$jeu"]); // dbut start, sinon swap

					$crypt .= strtr(substr($code, 0,$made), $this->SetFrom[$jeu], $this->SetTo[$jeu]); // conversion selon jeu

				}
				$code = substr($code,$made);                                           // raccourcir lgende et guides de la zone traite
				$Aguid = substr($Aguid,$made);
				$Bguid = substr($Bguid,$made);
				$Cguid = substr($Cguid,$made);
			}                                                                          // FIN BOUCLE PRINCIPALE

			$check=ord($crypt[0]);                                                     // calcul de la somme de contrle
			for ($i=0; $i<strlen($crypt); $i++) {
				$check += (ord($crypt[$i]) * $i);
			}
			$check %= 103;

			$crypt .= chr($check) . chr(106) . chr(107);                               // Chaine Crypte complte

			$i = (strlen($crypt) * 11) - 8;                                            // calcul de la largeur du module
			$modul = $w/$i;

			for ($i=0; $i<strlen($crypt); $i++) {                                      // BOUCLE D'IMPRESSION
				$c = $this->T128[ord($crypt[$i])];
				for ($j=0; $j<count($c); $j++) {
					$this->Rect($x,$y,$c[$j]*$modul,$h,"F");
					$x += ($c[$j++]+$c[$j])*$modul;
				}
			}
		}
		function Rotate($angle,$x=-1,$y=-1) {
			if($x==-1) 
				$x=$this->x; 
			if($y==-1) 
				$y=$this->y; 
			if($this->angle!=0) 
				$this->_out('Q'); 
			$this->angle=$angle; 
			if($angle!=0){ 
				$angle*=M_PI/180; 
				$c=cos($angle); 
				$s=sin($angle); 
				$cx=$x*$this->k; 
				$cy=($this->h-$y)*$this->k; 
				$this->_out(sprintf('q %.5f %.5f %.5f %.5f %.2f %.2f cm 1 0 0 1 %.2f %.2f cm',$c,$s,-$s,$c,$cx,$cy,-$cx,-$cy));
			}
		}
	}
	
	

	$nr_vias = 0;
	
	require('impressao_etiquetas_prod_pdf_lista.php');
	
	$arquivo_base = 'impressao_etiquetas_prod_pdf_';
	if ($_REQUEST['modelo_imp']=='ELGIN'){
		$arquivo_base.='elgin_';
	}
	if ($_REQUEST['modelo_imp']=='ARGOX'){
		$arquivo_base.='argox_';
	}
	if ($_REQUEST['modelo_imp']=='MATRICIAL'){
		$arquivo_base.='grafico_';
	}
	$arquivo_base.=$_REQUEST['modelo_etq'].'.php';
	require($arquivo_base);

	//

	if ($_REQUEST['tp_preco']==''){
		$_REQUEST['tp_preco'] = 'S';
	}
	if ($_REQUEST['tp_desc']==''){
		$_REQUEST['tp_desc'] = 'S';
	}
	if ($_REQUEST['tp_cod']==''){
		$_REQUEST['tp_cod'] = 'S';
	}
	


	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
	$consulta = 'Update param set '.
				' Conteudo = "'.$_REQUEST['modelo_imp'].';'.
								$_REQUEST['modelo_etq'].';'.
								$_REQUEST['tp_preco'].';'.
								$_REQUEST['tp_desc'].';'.
								$_REQUEST['tp_cod'].';'.
								$_REQUEST['nParcelas'].';'.
								$_REQUEST['pDescAVista'].';'.
								str_replace(';',':',$_REQUEST['Texto_Fixo']).'"'.
				' where Dominio="'.$_SESSION["Dominio"].'"'.
				' and Chave = "ETIQUETA_PAD"';
	consulta_sql($consulta);

?>