<?
    require_once('../../includes/header.inc');
    require_once('../../includes/base_class.inc');
    define('FPDF_FONTPATH', '../../fpdf/font/');
    require('../../fpdf/fpdf.php');

if(session::usr_conectado($_REQUEST['USER_ID'])){

    class PDF_HTML extends FPDF{
        var $B=0;
        var $I=0;
        var $U=0;
        var $HREF='';
        var $ALIGN='';
        
        var $NrContrato = 0;
        var $DtAssinatura = 0;
        var $EmpresaCont = 0;
        
        
        function Header($tipo_cab='tudo'){
			if ($this->DefOrientation=='P'){
				$tamanho_total_linha = 190;
			}else{
				$tamanho_total_linha = 275;
			}
			$this->SetFillColor(255,255,255);
			$date=getdate();
			$hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
			$hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);
			$label = label_vendedor_ou_rep_comercial('S');

			$consulta_usuario = 'select Nome from usuario '.
						   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
						   ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"';
			$res = consulta_sql($consulta_usuario);
			$row = consulta_ler_linha($res);
			$nome_usuario = $row[0];
			consulta_limpa($res);

			$con_empresa = 'select Web_Site from pessoa '.
					  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					  ' and Pessoa="'.$_SESSION['Empresa_Codigo'].'"';
			$res_empresa = consulta_sql($con_empresa);
			$reg_empresa = consulta_ler_linha($res_empresa);
			consulta_limpa($res_empresa);

			$this->SetFont('Arial','B',8);
			//Imprime Cabealho

			//IMAGEM
			if($tipo_cab=='tudo'){
				$base_y = 0;
				$this->Cell(1,  15, ' ', 0,0,'C');
				$this->Image(busca_imagem_empresa('logo_menu.jpg', '../../'), (($tamanho_total_linha/2)-5), (15+$base_y), 30,15);  //50,20
				$this->Cell(1,  15, ' ', 0,1,'C');
			}
			$this->Cell(1,  5, ' ', 0,1,'C');

			$this->Cell(1,  15, ' ', 0,0,'C');
			$y=$this->y;
			$this->MultiCell(48, 5, '', 0,'C');
			$this->y=$y;

			$y=$this->y;
			$this->MultiCell(92, 5, $reg_empresa[0], 0,'C');
			$this->y=$y;


			$cons_emp = 'select Nome_Listas from pessoa '.
				   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' and Pessoa = "'.$this->EmpresaCont.'"';
			$res_emp = consulta_sql($cons_emp);
			$reg_emp = consulta_ler_linha($res_emp);
			consulta_limpa($res_emp);

			if($this->DtAssinatura>0){
				$data = dataf($this->DtAssinatura);
				$ano = substr($data,8,2);
			}else{
				$ano = '00';
			}
			$y=$this->y;
			$this->MultiCell(50, 5, 'N Contrato: '.$reg_emp[0].'-'.$this->NrContrato.'/'.$ano, 0,'R');
			$this->y=$y;
			$this->Cell(1,  15, ' ', 0,1,'C');
           

			//CABECALHO GRID (COLUNAS)
			if($this->CabecalhoGrid_Texto!=''){
				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->SetFont('Arial','B',8);

				foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');
			}

			$this->SetFont('Courier','',8);
        }
        
        function Footer(){}

        function WriteHTML($html){
			//HTML parser
			$html=str_replace("\n",' ',$html);
			$a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
			foreach($a as $i=>$e){
				if($i%2==0){
					//Text
					if($this->HREF){
						$this->PutLink($this->HREF,$e);
					}elseif($this->ALIGN=='center'){
						$this->Cell(0,3,$e,0,1,'C');
					}else{
						$this->Write(3,$e);
					}
				}else{
					//Tag
					if($e[0]=='/'){
						$this->CloseTag(strtoupper(substr($e,1)));
					}else{
						//Extract properties
						$a2=explode(' ',$e);
						$tag=strtoupper(array_shift($a2));
						$prop=array();
						foreach($a2 as $v){
							if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
								$prop[strtoupper($a3[1])]=$a3[2];
						}
						$this->OpenTag($tag,$prop);
					}
				}
            }
        }

        function OpenTag($tag,$prop){
			//Opening tag
			if($tag=='B' || $tag=='I' || $tag=='U')
			   $this->SetStyle($tag,true);
			if($tag=='A')
			   $this->HREF=$prop['HREF'];
			if($tag=='BR')
			   $this->Ln(3);
			if($tag=='P')
			   $this->ALIGN=$prop['ALIGN'];
			if($tag=='HR'){
				if( !empty($prop['WIDTH']) ){
					$Width = $prop['WIDTH'];
				}else{
					$Width = $this->w - $this->lMargin-$this->rMargin;
				}
				$this->Ln(1);
				$x = $this->GetX();
				$y = $this->GetY();
				$this->SetLineWidth(0.4);
				$this->Line($x,$y,$x+$Width,$y);
				$this->SetLineWidth(0.2);
				$this->Ln(1);
			}
		}

        function CloseTag($tag){
			//Closing tag
			if($tag=='B' || $tag=='I' || $tag=='U')
				$this->SetStyle($tag,false);
			if($tag=='A')
				$this->HREF='';
			if($tag=='P')
				$this->ALIGN='';
        }

		function SetStyle($tag,$enable){
			//Modify style and select corresponding font
			$this->$tag+=($enable ? 1 : -1);
			$style='';
			foreach(array('B','I','U') as $s)
				if($this->$s>0)
					$style.=$s;
			$this->SetFont('',$style);
		}

		function PutLink($URL,$txt){
			//Put a hyperlink
			$this->SetTextColor(0,0,255);
			$this->SetStyle('U',true);
			$this->Write(5,$txt,$URL);
			$this->SetStyle('U',false);
			$this->SetTextColor(0);
		}
    }

	$label = label_vendedor_ou_rep_comercial('S');

	//CONSULTAS
	//consulta principal
	$consulta = 'select * from contratos '.
			 ' where Dominio="'.$_SESSION["Dominio"].'"'.
			 ' and Nr_Contrato = "'.$_REQUEST['nr_contrato'].'"';
	$resultado = consulta_sql($consulta);
	$registro = consulta_ler_objeto($resultado);

	//consulta empresa
	$con_empresa = 'select Nome_Razao, CPF_CNPJ from pessoa '.
				' where Dominio = "'.$_SESSION['Dominio'].'" '.
				' and Pessoa="'.$registro->Empresa.'"';
	$res_empresa = consulta_sql($con_empresa);
	$reg_empresa = consulta_ler_linha($res_empresa);
	consulta_limpa($res_empresa);

	//consulta endereco empresa
	$cons_endereco = 'select Logradouro, Numero, Nome_Cidade, UF, CEP, Insc_Estadual from pessoa_endereco '.
				  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				  ' and Pessoa="'.$registro->Empresa.'"'.
				  ' and Situacao="A"'.
				  ' order by Seq_Endereco LIMIT 1';
	$res_endereco = consulta_sql($cons_endereco);
	$reg_endereco = consulta_ler_linha($res_endereco);
	consulta_limpa($res_endereco);

	//consulta estado empresa
	$cons_uf_emp = 'select Nome, UF from uf '.
				' where Dominio = "'.$_SESSION['Dominio'].'" '.
				' and UF="'.$reg_endereco[3].'"';
	$res_uf_emp = consulta_sql($cons_uf_emp);
	$reg_uf_emp = consulta_ler_linha($res_uf_emp);
	consulta_limpa($res_uf_emp);

	//consulta pessoa
	$con_pessoa = 'select Nome_Razao, CPF_CNPJ from pessoa '.
			   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
			   ' and Pessoa="'.$registro->Pessoa.'"';
	$res_pessoa = consulta_sql($con_pessoa);
	$reg_pessoa = consulta_ler_linha($res_pessoa);
	consulta_limpa($res_pessoa);

	//consulta endereco pessoa
	$cons_end_pessoa = 'select Logradouro, Numero, Nome_Cidade, UF, CEP, Insc_Estadual from pessoa_endereco '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Pessoa="'.$registro->Pessoa.'"'.
					' and Situacao="A"'.
					' order by Seq_Endereco LIMIT 1';
	$res_end_pessoa = consulta_sql($cons_end_pessoa);
	$reg_end_pessoa = consulta_ler_linha($res_end_pessoa);
	consulta_limpa($res_end_pessoa);

	//consulta estado pessoa
	$cons_uf_pessoa = 'select Nome, UF from uf '.
				   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				   ' and UF="'.$reg_end_pessoa[3].'"';
	$res_uf_pessoa = consulta_sql($cons_uf_pessoa);
	$reg_uf_pessoa = consulta_ler_linha($res_uf_pessoa);
	consulta_limpa($res_uf_pessoa);

	//consulta endereco ENTREGA
	$cons_end_entrega = 'select Logradouro, Numero, Nome_Cidade, UF, CEP, Insc_Estadual from pessoa_endereco '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and Pessoa="'.$registro->Empresa_Entrega.'"'.
					' and Situacao="A"'.
					' order by Seq_Endereco LIMIT 1';
	$res_end_entrega = consulta_sql($cons_end_entrega);
	$reg_end_entrega = consulta_ler_linha($res_end_entrega);
	consulta_limpa($res_end_entrega);

	//consulta estado ENTREGA
	$cons_uf_entrega = 'select Nome, UF from uf '.
					' where Dominio = "'.$_SESSION['Dominio'].'" '.
					' and UF="'.$reg_end_entrega[3].'"';
	$res_uf_entrega = consulta_sql($cons_uf_entrega);
	$reg_uf_entrega = consulta_ler_linha($res_uf_entrega);
	consulta_limpa($res_uf_entrega);

	//consulta endereco PRODUCAO PENHOR
	$cons_end_producao = 'select Logradouro, Numero, Nome_Cidade, UF, CEP, Insc_Estadual from pessoa_endereco '.
					  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					  ' and Pessoa="'.$registro->Pessoa.'"'.
					  ' and Seq_Endereco = "'.$registro->Local_Producao.'"'.
					  ' and Situacao="A"';
	$res_end_producao = consulta_sql($cons_end_producao);
	$reg_end_producao = consulta_ler_linha($res_end_producao);
	consulta_limpa($res_end_producao);

	//consulta estado PRODUCAO PENHOR
	$cons_uf_producao = 'select Nome, UF from uf '.
					 ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					 ' and UF="'.$reg_end_producao[3].'"';
	$res_uf_producao = consulta_sql($cons_uf_producao);
	$reg_uf_producao = consulta_ler_linha($res_uf_producao);
	consulta_limpa($res_uf_producao);

	//consulta estado PROPRIETARIO
	$cons_uf_proprietario = 'select Nome, UF from uf '.
						 ' where Dominio = "'.$_SESSION['Dominio'].'" '.
						 ' and UF="'.$registro->Proprietario_UF.'"';
	$res_uf_proprietario = consulta_sql($cons_uf_proprietario);
	$reg_uf_proprietario = consulta_ler_linha($res_uf_proprietario);
	consulta_limpa($res_uf_proprietario);

	//consulta estado DEPOSITARIO
	$cons_uf_depositario = 'select Nome, UF from uf '.
						' where Dominio = "'.$_SESSION['Dominio'].'" '.
						' and UF="'.$registro->Depositario_UF.'"';
	$res_uf_depositario = consulta_sql($cons_uf_depositario);
	$reg_uf_depositario = consulta_ler_linha($res_uf_depositario);
	consulta_limpa($res_uf_depositario);

	//consulta empresa praca
	$con_emp_praca = 'select Nome_Razao, CPF_CNPJ from pessoa '.
				  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				  ' and Pessoa="'.$registro->Empresa_Praca.'"';
	$res_emp_praca = consulta_sql($con_emp_praca);
	$reg_emp_praca = consulta_ler_linha($res_emp_praca);
	consulta_limpa($res_emp_praca);

	//consulta Unidade Venda do produto
	$con_unid_venda = 'select Unidade_Venda '.
				   ' from produto '.
				   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
				   ' and Id_Produto = "'.$registro->Id_Produto.'"';
	$res_unid_venda = consulta_sql($con_unid_venda);
	$reg_unid_venda = consulta_ler_linha($res_unid_venda);
	consulta_limpa($res_unid_venda);

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	$pdf=new PDF_HTML();
	$pdf->Open();
	$pdf->Cabecalho = '';
	$pdf->Cabecalho_Filtro = '';
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	$pdf->NrContrato = $registro->Nr_Contrato;
	$pdf->DtAssinatura = $registro->DT_Assinatura;
	$pdf->EmpresaCont = $registro->Empresa;

	$pdf->AddPage();

	$k=0;
	$pdf->CabecalhoGrid_Texto = '';
	$lns = 5;

	$k=0;
	$pdf->SetFont('Courier','',8);
	$pdf->SetAutoPageBreak(true,30);
	$pdf->SetFont('Courier','',8);

	//FORMATAR ARTIGO ESTADO
	function ArtigoEstado($UF){
        $termo = 'e'; //valor genrico
        if ($UF == 'AC'){ $termo = 'o'; }
        if ($UF == 'AL'){ $termo = 'as'; }
        if ($UF == 'MA'){ $termo = 'o'; }
        if ($UF == 'AP'){ $termo = 'o'; }
        if ($UF == 'BA'){ $termo = 'a'; }
        if ($UF == 'CE'){ $termo = 'o'; }
        if ($UF == 'DF'){ $termo = 'o'; }
        if ($UF == 'ES'){ $termo = 'o'; }
        if ($UF == 'GO'){ $termo = 'e'; }
        if ($UF == 'MA'){ $termo = 'o'; }
        if ($UF == 'MG'){ $termo = 'e'; }
        if ($UF == 'MS'){ $termo = 'o'; }
        if ($UF == 'MT'){ $termo = 'o'; }
        if ($UF == 'PA'){ $termo = 'o'; }
        if ($UF == 'PB'){ $termo = 'a'; }
        if ($UF == 'PE'){ $termo = 'e'; }
        if ($UF == 'PI'){ $termo = 'o'; }
        if ($UF == 'PR'){ $termo = 'o'; }
        if ($UF == 'RJ'){ $termo = 'o'; }
        if ($UF == 'RN'){ $termo = 'o'; }
        if ($UF == 'RO'){ $termo = 'e'; }
        if ($UF == 'RR'){ $termo = 'e'; }
        if ($UF == 'RS'){ $termo = 'o'; }
        if ($UF == 'SC'){ $termo = 'e'; }
        if ($UF == 'SE'){ $termo = 'o'; }
        if ($UF == 'SP'){ $termo = 'e'; }
        if ($UF == 'TO'){ $termo = 'o'; }
        
        return $termo;
    }

    if($registro->Tipo_Produto == 'S'){
        $tipo_prod = 'Soja';
    }else if($registro->Tipo_Produto == 'M'){
        $tipo_prod = 'Milho';
    }else if($registro->Tipo_Produto == 'T'){
        $tipo_prod = 'Trigo';
    }else if($registro->Tipo_Produto == 'C'){
        $tipo_prod = 'Cevada';
    }
     
    if(($reg_unid_venda[0]=='SA')||($reg_unid_venda[0]=='SO')){
        $qtd_quilos = '50';
        $divisao_quilos = 50;
    }else if($reg_unid_venda[0]=='TO'){
        $qtd_quilos = '60';
        $divisao_quilos = 60;
    }else{
        $qtd_quilos = '1';
        $divisao_quilos = 1;
    }

    $dataEmissao = dataf($registro->DT_Assinatura);
    $dataEntrega = dataf($registro->DT_Entrega);
    $anoEmissao = substr($dataEmissao,6,4);
    $anoEntrega = substr($dataEntrega,6,4);
    if($anoEmissao == $anoEntrega){
        $safra = $anoEmissao;
    }else{
        $safra = $anoEmissao.'/'.$anoEntrega;
    }
     
    if($registro->Tipo_Produto == 'S' || $registro->Tipo_Produto == 'C'){
        $artigo_prod = 'A';
    }else{
        $artigo_prod = 'O';
    }

    if($registro->Tipo_Produto == 'S' || $registro->Tipo_Produto == 'C'){
        $pronome_prod = 'a';
    }else{
        $pronome_prod = 'e';
    }


	//COMPRA E VENDA - PREO FIXO
	if($registro->Tipo_Contrato=='1'){
		$titulo = 'Pelo presente instrumento particular de contrato de compra e venda de cereais, as partes '.
					'abaixo qualificadas, de um lado:';
               
		$par_1 = '01) <b>'.$reg_empresa[0].',</b> pessoa jurdica de direito privado, com sua matriz  '.$reg_endereco[0].' '.$reg_endereco[1].', '.
				'na cidade de '.$reg_endereco[2].', no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].', inscrito no CNPJ do (M.F), sob o n '.$reg_empresa[1].', '.
				'e com Inscrio Estadual sob o n '.$reg_endereco[5].', neste ato representado por seus diretores e/ou '.
				'procuradores, na forma de seu contrato social, doravante denominada simplesmente <b>COMPRADORA,</b> e de outro lado:';

		$par_2 = '02) <b>'.$reg_pessoa[0].',</b> inscrito no CPF/MF, sob o n '.$reg_pessoa[1].', residente no municpio de '.$reg_end_pessoa[2].' '.
				'no Estado d'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].', a seguir denominado simplesmente <b>'.UpperDados($label).',</b> tem entre si, justo e convencionado o '.
				'presente contrato de compra e venda de cereais, que se reger pelas seguintes clusulas e condies.';
              
		$objeto_contrato = '<b>I - OBJETO DO CONTRATO</b>';

     
		$claus_primeira  = '<b><u>CLUSULA PRIMEIRA</u></b> - O <b>'.UpperDados($label).'</b> vende, como de fato vendido tem neste ato  <b>COMPRADORA,</b> '.
						   'a seguinte mercadoria e respectiva quantidade:<BR>'.
						   '<BR>'.
						   'Mercadoria - '.$tipo_prod.' em gros, a granel, "in natura", da safra de '.$safra.'.<BR>'.
						   'Quantidade - '.formata_qtd($registro->Quantidade,3,false).' ('.numero_extenso($registro->Quantidade,false,'M').') Kgs, '.
						   'equivalente a '.formata_qtd(($registro->Quantidade/$divisao_quilos),3,false).' ('.numero_extenso(($registro->Quantidade/$divisao_quilos),false,'F').') '.
						   'sacas de '.$qtd_quilos.' quilos, cada uma.';

		$artigo = 'a';
		$claus_segunda_param = '';
		if($registro->Umidade_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Umidade Mxima......................................................de '.formata_qtd($registro->Umidade_Perc,2,false).'%<BR>';
			$artigo = 'b';
		}
		if($registro->Impureza_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Impurezas em Quantidade Mxima......................................de '.formata_qtd($registro->Impureza_Perc,false).'%<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				$artigo = 'c';
			}
		}
		if(($registro->Ardido_Perc>0) && ($registro->Avariado_Perc>0)){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Avariados....de '.formata_qtd($registro->Avariado_Perc,false).'% ..... c/ no Mximo....de '.formata_qtd($registro->Ardido_Perc,false).'% de Ardidos<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				if($artigo == 'b'){
					$artigo = 'c';
				}else{
					$artigo = 'd';
				}
			}
		}
		if($registro->Quebrado_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Partido e/ou Quebrados...................de '.formata_qtd($registro->Quebrado_Perc,false).'%<BR>';
		}
     
		if($registro->Transgenico!='S'){
			$claus_segunda_param.= '<BR>Obs.: O <b>'.UpperDados($label).'</b> de forma irretratvel e irrevogvel, declara, sob as penas da lei civil e penal, '.
                               'que o produto vendido no  geneticamente modificado (Transgnico) '.
                               'e de que tambm no  sobra de semente tratada com fungicida.<BR>';
		}

		$claus_segunda = '<b><u>CLUSULA SEGUNDA</u></b> - '.$artigo_prod.' '.strtolower($tipo_prod).' ora mencionad'.strtolower($artigo_prod).' ter '.
					  'a seguinte qualidade ou parmetro:<BR>'.
					  '<BR>'.
					  ''.$claus_segunda_param.'<BR>'.
					  '<b>PARGRAFO NICO</b> - Fica facultado  <b>COMPRADORA</b> o direito de receber a mercadoria mediante desconto de '.
					  'peso equivalente, de acordo com sua tabela interna, caso '.strtolower($artigo_prod).' '.strtolower($tipo_prod).' '.
					  'no seja entregue pelo <b>'.UpperDados($label).'</b> rigorosamente dentro dos padres descritos no "caput" desta Clusula.';


		$prazo = '<b>II - PRAZO E LOCAL DE ENTREGA</b>';

		$claus_terceira = '<b><u>CLUSULA TERCEIRA</u></b> - A mercadoria ser entregue parceladamente pelo <b>'.UpperDados($label).' AO COMPRADOR,</b> at '.
					   'o prazo mximo de '.DataExtenso(dataf($registro->DT_Entrega)).', no armazm da <b>COMPRADORA,</b> na cidade de '.
					   ''.$reg_end_entrega[2].', no Estado d'.ArtigoEstado($reg_uf_entrega[1]).' '.$reg_uf_entrega[0].'.<BR>'.
					   '<BR>'.
					   '<b>PARGRAFO NICO</b> - A mercadoria, com peso e qualidade no destino, dever ser acompanhada de documentao '.
					   'fiscal e comercial a favor da <b>COMPRADORA,</b> observada a legislao pertinente.';

		$claus_quarta = '<b><u>CLUSULA QUARTA</u></b> - Correro por conta do <b>'.UpperDados($label).'</b> todas a despesas com frete para transporte '.
						'da mercadoria do local onde se encontra at o local de entrega e/ou destino estipulado.';

		$pagto_garantias = '<b>III - PREO, CONDIES DE PAGAMANTO E GARANTIAS</b>';

		$contrato_moeda = '';
		if($registro->Moeda!='R$'){
			$contrato_moeda.= 'Este valor ser convertido em reais pela taxa mdia do cmbio publicada pelo Banco Central do Brasil (PTAX 800) '.
								' do dia '.dataf($registro->DT_Entrega).'<BR>';
		}
		$claus_quinta = '<b><u>CLUSULA QUINTA</u></b> - A presente negociao  feita pelo preo fixo e irreajustvel de '.
                     ''.$registro->Moeda.' '.formata_qtd($registro->Valor_Unitario,6,false).' ('.trim(extenso($registro->Valor_Unitario)).'), '.
                     'por saca de 60 Kg, acrescido somente do <b>ICMS,</b> se incidente na operao e reduzido o <b>INSS/SENAR,</b> '.
                     'se assim o houver.<BR>'.
                     ''.$contrato_moeda.''.
                     'Considerando que a mercadoria objeto da presente compra e venda  destinada  exportao, se, em decorrncia da '.
                     'legislao fiscal, ou para-fiscal, ou de decises judiciais, houver incidncias, inexistentes na presente data, '.
                     'inclusive de imposto sobre a exportao do produto adquirido, bem como instituio ou aumento de outros impostos, '.
                     'taxas ou contribuies, tais encargos sero de exclusiva responsabilidade do <b>'.UpperDados($label).',</b> que os suportar '.
                     'como reduo do preo estabelecido ou a ser fixado pelas partes.';

		$claus_sexta_parag_prim = '';
		if($registro->DT_Pagto >= $registro->DT_Entrega){
			$claus_sexta_parag_prim.= '<b>PARGRAFO PRIMEIRO</b> - O pagamento ora convencionado fica condicionado  entrega da quantidade '.
									'total da mercadoria adquirida pelo presente instrumento, bem como no prazo supra avenado.';
		}else{
			$claus_sexta_parag_prim.= '<b>PARGRAFO PRIMEIRO</b> - O <b>'.UpperDados($label).'</b> neste ato emite  favor da <b>COMPRADORA</b> uma Nota '.
									  'Promissria no valor de '.$registro->Moeda.' '.formata_qtd($registro->Valor_Promissoria,3,false).' '.
									  '('.trim(extenso($registro->Valor_Promissoria)).'), a ttulo de crdito, esse autnomo para os efeitos legais '.
									  'e processuais, que na data do vencimento poder ser levada a protesto e/ou cobrana judicial, caso o '.
									  '<b>'.UpperDados($label).'</b> no tenha entregue totalmente a mercadoria ora mensionada.';
		}

     
		$claus_sexta_parag_seg2 = '';
		if($registro->Proprietario_CPF!=''){
			$claus_sexta_parag_seg2.= ', inscrito no CPF/MF sob o n '.$registro->Proprietario_CPF.'';
		}
		if($registro->Proprietario_RG!=''){
			$claus_sexta_parag_seg2.= ', carteira de identidade n '.$registro->Proprietario_RG.'';
		}
		$claus_sexta_parag_seg = '';
		if($registro->Penhor=='S'){
			$claus_sexta_parag_seg.= '<b>PARGRAFO SEGUNDO</b> - O <b>'.UpperDados($label).'</b> da em favor da <b>COMPRADORA</b> em carater de '.
									 'exclusividade em <b>PENHOR AGRCOLA</b> em primeiro grau e nico grau correspondente a <b>SAFRA</b> de '.
									 ''.$tipo_prod.' em gros, safra estimada em '.formata_qtd($registro->Safra_Estimada,3,false).' '.
									 '('.trim(numero_extenso($registro->Safra_Estimada,false,'M')).') Kgs, ou '.formata_qtd(($registro->Safra_Estimada/$divisao_quilos),3,false).' '.
									 '('.trim(numero_extenso(($registro->Safra_Estimada/$divisao_quilos),false,'M')).') sacas de '.$qtd_quilos.' Kgs, que ser produzida '.
									 'na safra '.$safra.', em um terreno rural situado no local denominado '.$res_end_producao[0].', no municpio de '.
									 ''.$res_end_producao[2].', no Estado d'.ArtigoEstado($reg_uf_producao[1]).' '.$reg_uf_producao[0].', '.
									 'com rea de '.$registro->Penhor_Area.' objeto de matrcula n '.$registro->Penhor_Matricula.' do '.
									 'cartrio de imveis de '.$reg_end_producao[2].', no Estado d'.ArtigoEstado($reg_uf_producao[1]).' '.
									 ''.$reg_uf_producao[0].', imvel de propriedade do Sr. '.$registro->Proprietario_Nome.', residente e '.
									 'domiciliado em '.$registro->Proprietario_Cidade_Nome.', no Estado d'.ArtigoEstado($registro->Proprietario_UF).' '.
									 ''.$reg_uf_proprietario[0].''.
									 ''.$claus_sexta_parag_seg2.''.
									 ', dando plena, geral e irestrita autorizao para o registro do presente <b>PENHOR</b> nos livros prprios do '.
									 'registro de '.$reg_end_producao[2].', no Estado d'.ArtigoEstado($reg_uf_producao[1]).' '.$reg_uf_producao[0].'.';
		}
     
		$claus_sexta = '<b><u>CLUSULA SEXTA</u></b> - O pagamento ser efetuado no dia '.DataExtenso(dataf($registro->DT_Pagto)).', no '.
					'estabelecimento comercial da <b>COMPRADORA.</b><BR><BR>'.
					''.$claus_sexta_parag_prim.''.
					''.$claus_sexta_parag_seg.'';

		$cond_gerais = '<b>IV - CONDIES GERAIS</b>';
     
		$claus_setima_par_unico = '';
		if($registro->Hipoteca=='S'){
			$claus_setima_par_unico.= '<BR><BR><b>PARGRAFO NICO</b> - O <b>'.UpperDados($label).'</b> declara que '.strtolower($artigo_prod).' '.$tipo_prod.' negociad'.strtolower($artigo_prod).' '.
									  'se encontra fisicamente ou est plantad'.strtolower($artigo_prod).' na propriedade constante na matrcula n '.
									  ''.$registro->Penhor_Matricula.' do registro de imveis, no municpio de '.$reg_end_producao[2].', '.
									  'no Estado d'.ArtigoEstado($reg_uf_producao[1]).' '.$reg_uf_producao[0].'<BR>'.
									  '<BR><b><u>GARANTIA DADA PELO '.UpperDados($label).'</b></u><BR>'.
									  '<BR>Para garantia de presente avena, o <b>'.UpperDados($label).'</b> d em favor da <b>COMPRADORA</b> com anuncia do '.
									  '<b>PROPRIETRIO</b> do imvel, em primeira e nica <b>HIPOTECA</b>, o imvel descrito no Pargrafo nico '.
									  'deste contrato, ficando desde logo o Sr. Oficial de Registro Imobilirio autorizado a efetuar o seu registro.';
		}

		$claus_setima = '<b><u>CLUSULA STIMA</b></u> - As partes de comum acordo estipulam "qua a tradio" definitiva dar-se- '.
					 'a cada entrea da mercadoria passando a <b>COMPRADORA,</b> naquele momento, a ser titular do domnio d'.$artigo_prod.' '.
					 ''.$tipo_prod.' entregue, podendo del'.$pronome_prod.' dispor como melhor lhe aprouver.'.
					 ''.$claus_setima_par_unico.'';
					 
		$claus_oitava = '<b><u>CLUSULA OITAVA</u></b> - Em no ocorrendo a entrega total ou parcial da mercadoria nas condies aqui estipuladas '.
					 'poder a <b>COMPRADORA,</b> independentemente de notificao, promover todas as medidas cabveis, judiciais ou extra-judiciais '.
					 'para obrigar o <b>'.UpperDados($label).'</b> a cumprir totalmente o contrato, sem prejuzo de responder por perdas e danos, hipteses '.
					 'em que responder esta pelas custas do processo a que der causa e honrrios advocatcios.';
					 
		$claus_nona = '<b><u>CLUSULA NONA</u></b> - Fica estabelecida a multa de 20% (vinte por cento) para a parte que desrespeitar '.
				   'qualquer clusula deste contrato.';


		$claus_decima_garantias = '';
		if($registro->Garantias=='S'){
			$claus_decima_garantias.= '<BR><BR>';
			$claus_decima_garantias.= '<b><u>CLUSULA DCIMA PRIMEIRA</u></b> - O <b>Devedor</b> responde pela evico de direito, para fazer a '.
                                  'presente dao em pagamento sempre boa, firme e valiosa, ficando certo que o contrato obriga no s as '.
                                  'partes contratantes, mas tambm seus herdeiros e/ou sucessores.<BR>'.
                                  '<BR>'.
                                  '<b><u>CLUSULA DCIMA SEGUNDA</u></b> - O <b>Devedor</b> trasfere neste ato,  <b>Credora,</b> toda '.
                                  'propriedade, posse, direitos e aes que vinha exercento sobre os bens dados em pagamento, para que esta '.
                                  'ltima possa usar e fluir dos mesmos em sua plenitude.<BR>'.
                                  '<BR>'.
                                  '<b><u>CLUSULA DCIMA TERCEIRA</u></b> - O <b>Devedor</b> declara sob as penas da lei:<BR>'.
                                  '<BR>'.
                                  '<b>PARGRAFO PRIMEIRO</b> - Que a mercadoria objeto deste contrato no est apenhada a qualquer estabelecimento '.
                                  'de crdito ou a terceiros, no tendo sido oferecida em garantia de crditos abertos pr intermdio de '.
                                  'promissria rural, cdula rural pignocitria, cdula rural hipotecria, ou quaisquer outros ttulos.<BR>'.
                                  '<BR>'.
                                  '<b>PARGRAFO SEGUNDO</b> - Que a mercadoria no pertence a nenhum esplio, no sendo objeto de inventrio '.
                                  'ou arrolamento, no dependendo pois de Alvar judicial que autorize sua comercializao.<BR>'.
                                  '<BR>'.
                                  '<b>PARGRAFO TERCEIRO</b> - Que a mercadoria  de sua exclusiva propriedade, no pertencendo a meeiros, '.
                                  'parceiros ou porcenteiros.<BR>'.
                                  '<BR>'.
                                  '<b>PARGRAFO QUARTO</b> - Que no imvel produtor no existam condminos menores, passveis de interdio '.
                                  'ou ausentes.<BR>'.
                                  '<BR>'.
                                  '<b>PARGRAFO QUINTO</b> - Que a mercadoria no  objeto de outro contrato de compra e venda, celebrado '.
                                  'com adquirinte que no seja a prpria <b>Credora.</b>';
		}

		$claus_decima = '<b><u>CLUSULA DCIMA</u></b> - As despesas havidas com registro do presente contrato, correndo por conta do <b>'.UpperDados($label).',</b> '.
                     'e se suportadas pela <b>COMPRADORA,</b> sero descontadas dos pagamentos a serem efetuados ao <b>'.UpperDados($label).',</b> ou por estas '.
                     'reembolsadas contra a apresentao dos respectivos compravantes.'.
                     ''.$claus_decima_garantias.'';
                     
		$deposito_mercantil = '<b>V - DO DEPSITO MERCANTIL</b>';
     
		if($registro->Garantias=='S'){
			$num_clausula = 'QUARTA';
		}else{
			$num_clausula = 'PRIMEIRA';
		}
     
     
		$dep_nac = '';
		if($registro->Depositario_Nacionalidade!=''){
			$dep_nac.= ', '.$registro->Depositario_Nacionalidade;
		}
		$dep_ocup = '';
		if($registro->Depositario_Ocupacao!=''){
			$dep_ocup.= ', '.$registro->Depositario_Ocupacao;
		}
		$dep_cpf = '';
		if($registro->Depositario_CPF!=''){
			$dep_cpf.= ', inscrito no CPF/MF sob o n '.$registro->Depositario_CPF;
		}

		$cgc_pessoa = '';
		if($reg_pessoa[1]!=''){
			$cgc_pessoa = ', inscrito no CPF/MF sob o n '.$reg_pessoa[1];
		}
     

		if($registro->Fiel_Depositario=='S'){
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>COMPRADORA,</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do <b>'.UpperDados($label).',</b> pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. '.$registro->Depositario_Nome.''.
								 ''.$dep_nac.''.$dep_ocup.''.$dep_cpf.''.
								 ', residente e domiciliado no municpio de '.$registro->Depositario_Cidade_Nome.', no Estado '.
								 'd'.ArtigoEstado($reg_uf_depositario[1]).' '.$reg_uf_depositario[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}else{
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>COMPRADORA,</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do <b>'.UpperDados($label).',</b> pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. '.$reg_pessoa[0].''.
								 ''.$cgc_pessoa.''.
								 ', residente e domiciliado no municpio de '.$reg_end_pessoa[2].', no Estado '.
								 'd'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}

		$termos_parag_seg = '<BR><b>PARGRAFO SEGUNDO</b> - O <b>'.UpperDados($label).'</b> reconhece que o objeto deste contrato est comprometido com novas '.
							 'operaes da <b>COMPRADORA</b> perante terceiros, a que a falta da entrega poder gerar prejuzos elevados referentes '.
							 'ao descumprimento e ainda lucros cessantes a serem apurados, para tanto desde logo destaca de sua produo, tornando '.
							 'individualizada as lavouras necessrias ao cumprimento deste <b>CONTRATO,</b> mantendo-se com fiel depositrio dos '.
							 'frutos colhidos at o efetivo reembolso  <b>COMPRADORA,</b> sendo que no caso de descumprimento de tal encargo '.
							 'iniciar as comisses previstas em lei.<BR>';
                         
		$termos_parag_terc = '<BR><b>PARGRAFO TERCEIRO</b> - Ainda reconhece o <b>'.UpperDados($label).'</b> que a lavora destinada ao cumprimento do objeto '.
							  'do presente <b>CONTRATO,</b> encontra-se livre e desembaraada de qualquer nus, no sendo passvel de serem penhorados '.
							  'e sequestrados por outras dvidas do <b>'.UpperDados($label).',</b> contando com a plena cincia da responsabilidade penal, no caso '.
							  'de declarao falsa ou inexata acerca da lavoura ou produo.<BR>';
                         
		$termos_parag_quarto = '<BR><b>PARGRAFO QUARTO</b> - O <b>DEPOSITRIO</b> se obriga a fazer seguro da mercadoria enquanto estiver '.
								'sob sua guarda contra quaisquer riscos, inclusive os de incncio, roubo e casos de furtuitos ou de fora maior.';

		$termos_parag_quinto = '<BR><b>PARGRAFO QUINTO</b> - O trmino do depsito mercantil, convencionado nesta Clusula, dar-se- quando '.
								'de cada parcial da mercadoria objeto do presente contrato, o que dever ocorrer no mesmo perodo previsto '.
								'na <b>CLUSULA TERCEIRA.</b><BR>';
                            
		$termos_parag_sexto = '<BR><b>PARGRAFO SEXTO</b> - Para os efeitos do artigo 284 do Cdigo Comercial e 901 do Cdigo de Processo Civil, '.
							   'as partes acordam que o valor em dinheiro da mercadoria objeto do depsito ora contratado  seu preo de mercado, '.
							   'na praa de '.$reg_emp_praca[0].', preo este nunca inferior ao da aquisio com a devida atualizao monetria.';
     
		$termos_claus_dec_prim = ''.$termos_parag_prim.''.
								  ''.$termos_parag_seg.''.
								  ''.$termos_parag_terc.''.
								  ''.$termos_parag_quarto.''.
								  ''.$termos_parag_quinto.''.
								  ''.$termos_parag_sexto.'';
		$claus_decima_primeira = '<b><u>CLUSULA DCIMA '.$num_clausula.'</b></u> - A <b>COMPRADORA,</b> na qualidade de <b>DEPOSITANTE</b> '.
                                 'e ao <b>'.UpperDados($label).'</b> na qualidade de <b>DEPOSITRIO,</b> estipulam a presente clusula de depositrio '.
                                 'mercantil, nos termos abaixo:<BR>'.
                                 '<BR>'.
                                 ''.$termos_claus_dec_prim.'';
                                 
		if($registro->Garantias=='S'){
			$num_clausula = 'QUINTA';
		}else{
			$num_clausula = 'SEGUNDA';
		}
		$claus_decima_segunda = '<b><u>CLUSULA DCIMA '.$num_clausula.'</b></u> - Fica eleito o foro da cidade de Araucria, no Estado '.
                                'do Paran para dirimir as dvidas porventuras oriundas deste contrato, com renncia de qualquer outro, '.
                                'por mais privilegiado que seja.';
                                
		$proced_fiscal = '<b><u>PROCEDIMENTO FISCAL</u></b> - O <b>'.UpperDados($label).'</b> dever proceder as emisses da Notas Fiscais, conforme '.
						  'orientao posterior.<BR>'.
						  '<BR>'.
						  'E, por estarem assim justas e contratadas, assinam o presente instrumento em 3 (trs) vias de igual teor, na '.
						  'presena das testemunhas abaixo.';

		$pdf->WriteHTML($titulo);
		$pdf->ln(12);
		$pdf->WriteHTML($par_1);
		$pdf->ln(10);
		$pdf->WriteHTML($par_2);
		$pdf->ln(8);
		$pdf->WriteHTML($objeto_contrato);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_primeira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_segunda);
		$pdf->ln(8);
		$pdf->WriteHTML($prazo);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_terceira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_quarta);
		$pdf->ln(8);
		$pdf->WriteHTML($pagto_garantias);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_quinta);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_sexta);
		$pdf->ln(8);
		$pdf->WriteHTML($cond_gerais);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_setima);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_oitava);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_nona);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_decima);
		$pdf->ln(8);
		$pdf->WriteHTML($deposito_mercantil);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_decima_primeira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_decima_segunda);
		$pdf->ln(8);
		$pdf->WriteHTML($proced_fiscal);
     
	}else if($registro->Tipo_Contrato=='2'){
		//TIPO CONTRATO COMPRA E VENDA PRECO A FIXAR
  
		$titulo = 'Pelo presente instrumento particular de contrato de compra e venda de cereais, as partes '.
			   'abaixo qualificadas, de um lado:';

		$par_1 = '01) <b>'.$reg_empresa[0].',</b> pessoa jurdica de direito privado, com sua matriz  '.$reg_endereco[0].' '.$reg_endereco[1].', '.
			  'na cidade de '.$reg_endereco[2].', no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].', inscrito no CNPJ do (M.F), sob o n '.$reg_empresa[1].', '.
			  'e com Inscrio Estadual sob o n '.$reg_endereco[5].', neste ato representado por seus diretores e/ou '.
			  'procuradores, na forma de seu contrato social, doravante denominada simplesmente <b>COMPRADORA,</b> e de outro lado:';

		$par_2 = '02) <b>'.$reg_pessoa[0].',</b> inscrito no CPF/MF, sob o n '.$reg_pessoa[1].', residente no municpio de '.$reg_end_pessoa[2].' '.
			  'no Estado d'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].', a seguir denominado simplesmente <b>'.UpperDados($label).',</b> tem entre si, justo e convencionado o '.
			  'presente contrato de compra e venda de cereais, que se reger pelas seguintes clusulas e condies.';

		$objeto_contrato = '<b>I - OBJETO DO CONTRATO</b>';


		$claus_primeira = '<b><u>CLUSULA PRIMEIRA</u></b> - O <b>'.UpperDados($label).'</b> vende, como de fato vendido tem neste ato  <b>COMPRADORA,</b> '.
                       'a seguinte mercadoria e respectiva quantidade:<BR>'.
                       '<BR>'.
                       'Mercadoria - '.$tipo_prod.' em gros, a granel, "in natura", da safra de '.$safra.'.<BR>'.
                       'Quantidade - '.formata_qtd($registro->Quantidade,3,false).' ('.numero_extenso($registro->Quantidade,false,'M').') Kgs, '.
                       'equivalente a '.formata_qtd(($registro->Quantidade/$divisao_quilos),3,false).' ('.numero_extenso(($registro->Quantidade/$divisao_quilos),false,'F').') '.
                       'sacas de '.$qtd_quilos.' quilos, cada uma.';

		$artigo = 'a';
		$claus_segunda_param = '';
		if($registro->Umidade_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Umidade Mxima......................................................de '.formata_qtd($registro->Umidade_Perc,2,false).'%<BR>';
			$artigo = 'b';
		}
		if($registro->Impureza_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Impurezas em Quantidade Mxima......................................de '.formata_qtd($registro->Impureza_Perc,false).'%<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				$artigo = 'c';
			}
		}
		if(($registro->Ardido_Perc>0) && ($registro->Avariado_Perc>0)){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Avariados...de '.formata_qtd($registro->Avariado_Perc,false).'% .... c/ no Mximo...de '.formata_qtd($registro->Ardido_Perc,false).'% de Ardidos<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				if($artigo == 'b'){
					$artigo = 'c';
				}else{
					$artigo = 'd';
				}
			}
		}
		if($registro->Quebrado_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Partido e/ou Quebrados...................de '.formata_qtd($registro->Quebrado_Perc,false).'%<BR>';
		}

		if($registro->Transgenico!='S'){
			$claus_segunda_param.= '<BR>Obs.: O <b>'.UpperDados($label).'</b> de forma irretratvel e irrevogvel, declara, sob as penas da lei civil e penal, '.
								 'que o produto vendido no  geneticamente modificado (Transgnico) '.
								 'e de que tambm no  sobra de semente tratada com fungicida.<BR>';
		}

		$claus_segunda = '<b><u>CLUSULA SEGUNDA</u></b> - '.$artigo_prod.' '.strtolower($tipo_prod).' ora mencionad'.strtolower($artigo_prod).' ter '.
						  'a seguinte qualidade ou parmetro:<BR>'.
						  '<BR>'.
						  ''.$claus_segunda_param.'<BR>'.
						  '<b>PARGRAFO NICO</b> - Fica facultado  <b>COMPRADORA</b> o direito de receber a mercadoria mediante desconto de '.
						  'peso equivalente, de acordo com sua tabela interna, caso '.strtolower($artigo_prod).' '.strtolower($tipo_prod).' '.
						  'no seja entregue pelo <b>'.UpperDados($label).'</b> rigorosamente dentro dos padres descritos no "caput" desta Clusula.';


		$prazo = '<b>II - PRAZO E LOCAL DE ENTREGA</b>';

		$claus_terceira = '<b><u>CLUSULA TERCEIRA</u></b> - A mercadoria ser entregue parceladamente pelo <b>'.UpperDados($label).' AO COMPRADOR,</b> at '.
						   'o prazo mximo de '.DataExtenso(dataf($registro->DT_Entrega)).', no armazm da <b>COMPRADORA,</b> na cidade de '.
						   ''.$reg_end_entrega[2].', no Estado d'.ArtigoEstado($reg_uf_entrega[1]).' '.$reg_uf_entrega[0].'.<BR>'.
						   '<BR>'.
						   '<b>PARGRAFO NICO</b> - A mercadoria, com peso e qualidade no destino, dever ser acompanhada de documentao '.
						   'fiscal e comercial a favor da <b>COMPRADORA,</b> observada a legislao pertinente.';

		$claus_quarta = '<b><u>CLUSULA QUARTA</u></b> - Correro por conta do <b>'.UpperDados($label).'</b> todas a despesas com frete para transporte '.
						'da mercadoria do local onde se encontra at o local de entrega e/ou destino estipulado.';

		$pagto_garantias = '<b>III - PREO, CONDIES DE PAGAMANTO E GARANTIAS</b>';

		$claus_quinta = '<b><u>CLUSULA QUINTA</u></b> - A presente negociao  feita sob condio de preo a fixar, tendo como base o preo '.
						 'por saca de 60 Kg lquidos na cidade de '.$reg_endereco[2].', no Estado d'.ArtigoEstado($res_uf_emp[1]).' '.
						 ''.$res_uf_emp[0].', acrescido somente do <b>ICMS,</b> se incidente na operao e reduzido o <b>INSS/SENAR,</b> '.
						 'que  de responsabilidade do <b>'.UpperDados($label).'</b>.<BR>'.
						 '<BR>'.
						 '<b>PARGRAFO PRIMEIRO</b> - Se as partes no fixarem o preo de comum acordo at o dia '.DataExtenso(dataf($registro->DT_Pagto)).' '.
						 'o mesmo poder ser fixado pela <b>COMPRADORA,</b> para o que utilizar o mesmo critrio estabelecido no "caput" desta Clusula.<BR>'.
						 '<BR>'.
						 '<b>PARGRAFO SEGUNDO</b> - Como adiantamento por conta do preo total da negociao, a <b>COMPRADORA</b> forneceu ao <b>'.UpperDados($label).'</b> '.
						 ''.$registro->Moeda.' '.formata_qtd($registro->Valor_Unitario,3,false).' ('.trim(extenso($registro->Valor_Unitario)).') '.
						 'devendo este valor fixo e irreajustvel at a data de '.DataExtenso(dataf($registro->DT_Entrega)).', a ser descontado quando do '.
						 'pagamento da mercadoria aps a sua fixao de preo, conforme descrito no <b>PARGRAFO PRIMEIRO</b> desta Clusula.<BR>'.
						 '<BR>'.
						 '<b>PARGRAFO TERCEIRO</b> - O <b>'.UpperDados($label).'</b> neste ato emite  favor da <b>COMPRADORA</b> uma Nota Promissria no valor de '.
						 ''.$registro->Moeda.' '.formata_qtd($registro->Valor_Promissoria,3,false).' ('.trim(extenso($registro->Valor_Promissoria)).'), '.
						 'a ttulo de crdito, esse autnomo para os efeitos legais e processuais, que na data do vencimento poder ser levada '.
						 'a protesto e/ou cobrana judicial, caso o <b>'.UpperDados($label).'</b> no tenha entregue totalmente a mercadoria ora mensionada.';

		$claus_sexta_par_unico = '';
		if($registro->Hipoteca=='S'){
			$claus_sexta_par_unico.= '<BR><BR><b>PARGRAFO NICO</b> - O <b>'.UpperDados($label).'</b> declara que '.strtolower($artigo_prod).' '.$tipo_prod.' negociad'.strtolower($artigo_prod).' '.
									 'se encontra fisicamente ou est plantad'.strtolower($artigo_prod).' na propriedade constante na matrcula n '.
									 ''.$registro->Penhor_Matricula.' do registro de imveis, no municpio de '.$reg_end_producao[2].', '.
									 'no Estado d'.ArtigoEstado($reg_uf_producao[1]).' '.$reg_uf_producao[0].'<BR>'.
									 '<BR><b><u>GARANTIA DADA PELO '.UpperDados($label).'</b></u><BR>'.
									 '<BR>Para garantia de presente avena, o <b>'.UpperDados($label).'</b> d em favor da <b>COMPRADORA</b> com anuncia do '.
									 '<b>PROPRIETRIO</b> do imvel, em primeira e nica <b>HIPOTECA</b>, o imvel descrito no Pargrafo nico '.
									 'deste contrato, ficando desde logo o Sr. Oficial de Registro Imobilirio autorizado a efetuar o seu registro.';
		}

		$claus_sexta = '<b><u>CLUSULA SEXTA</b></u> - As partes de comum acordo estipulam "qua a tradio" definitiva dar-se- '.
						 'a cada entrea da mercadoria passando a <b>COMPRADORA,</b> naquele momento, a ser titular do domnio d'.$artigo_prod.' '.
						 ''.$tipo_prod.' entregue, podendo del'.$pronome_prod.' dispor como melhor lhe aprouver.'.
						 ''.$claus_sexta_par_unico.'';

		$claus_setima = '<b><u>CLUSULA STIMA</u></b> - Em no ocorrendo a entrega total ou parcial da mercadoria nas condies aqui estipuladas '.
						 'poder a <b>COMPRADORA,</b> independentemente de notificao, promover todas as medidas cabveis, judiciais ou extra-judiciais '.
						 'para obrigar o <b>'.UpperDados($label).'</b> a cumprir totalmente o contrato, sem prejuzo de responder por perdas e danos, hipteses '.
						 'em que responder esta pelas custas do processo a que der causa e honrrios advocatcios.';

		$claus_oitava = '<b><u>CLUSULA OITAVA</u></b> - Fica estabelecida a multa de 20% (vinte por cento) para a parte que desrespeitar '.
						'qualquer clusula deste contrato.';

		$claus_decima_garantias = '';
		if($registro->Garantias=='S'){
			$claus_decima_garantias.= '<BR><BR>';
			$claus_decima_garantias.= '<b><u>CLUSULA DCIMA</u></b> - O <b>Devedor</b> responde pela evico de direito, para fazer a '.
									  'presente dao em pagamento sempre boa, firme e valiosa, ficando certo que o contrato obriga no s as '.
									  'partes contratantes, mas tambm seus herdeiros e/ou sucessores.<BR>'.
									  '<BR>'.
									  '<b><u>CLUSULA DCIMA PRIMEIRA</u></b> - O <b>Devedor</b> trasfere neste ato,  <b>Credora,</b> toda '.
									  'propriedade, posse, direitos e aes que vinha exercento sobre os bens dados em pagamento, para que esta '.
									  'ltima possa usar e fluir dos mesmos em sua plenitude.<BR>'.
									  '<BR>'.
									  '<b><u>CLUSULA DCIMA SEGUNDA</u></b> - O <b>Devedor</b> declara sob as penas da lei:<BR>'.
									  '<BR>'.
									  '<b>PARGRAFO PRIMEIRO</b> - Que a mercadoria objeto deste contrato no est apenhada a qualquer estabelecimento '.
									  'de crdito ou a terceiros, no tendo sido oferecida em garantia de crditos abertos pr intermdio de '.
									  'promissria rural, cdula rural pignocitria, cdula rural hipotecria, ou quaisquer outros ttulos.<BR>'.
									  '<BR>'.
									  '<b>PARGRAFO SEGUNDO</b> - Que a mercadoria no pertence a nenhum esplio, no sendo objeto de inventrio '.
									  'ou arrolamento, no dependendo pois de Alvar judicial que autorize sua comercializao.<BR>'.
									  '<BR>'.
									  '<b>PARGRAFO TERCEIRO</b> - Que a mercadoria  de sua exclusiva propriedade, no pertencendo a meeiros, '.
									  'parceiros ou porcenteiros.<BR>'.
									  '<BR>'.
									  '<b>PARGRAFO QUARTO</b> - Que no imvel produtor no existam condminos menores, passveis de interdio '.
									  'ou ausentes.<BR>'.
									  '<BR>'.
									  '<b>PARGRAFO QUINTO</b> - Que a mercadoria no  objeto de outro contrato de compra e venda, celebrado '.
									  'com adquirinte que no seja a prpria <b>Credora.</b>';
		}

		$claus_nona = '<b><u>CLUSULA NONA</u></b> - As despesas havidas com registro do presente contrato, correndo por conta do <b>'.UpperDados($label).',</b> '.
					 'e se suportadas pela <b>COMPRADORA,</b> sero descontadas dos pagamentos a serem efetuados ao <b>'.UpperDados($label).',</b> ou por estas '.
					 'reembolsadas contra a apresentao dos respectivos compravantes.'.
					 ''.$claus_decima_garantias.'';

		$deposito_mercantil = '<b>V - DO DEPSITO MERCANTIL</b>';

		if($registro->Garantias=='S'){
			$num_clausula = ' TERCEIRA';
		}else{
			$num_clausula = ' ';
		}

		$dep_nac = '';
		if($registro->Depositario_Nacionalidade!=''){
			$dep_nac.= ', '.$registro->Depositario_Nacionalidade;
		}
		$dep_ocup = '';
		if($registro->Depositario_Ocupacao!=''){
			$dep_ocup.= ', '.$registro->Depositario_Ocupacao;
		}
		$dep_cpf = '';
		if($registro->Depositario_CPF!=''){
			$dep_cpf.= ', inscrito no CPF/MF sob o n '.$registro->Depositario_CPF;
		}

		$cgc_pessoa = '';
		if($reg_pessoa[1]!=''){
			$cgc_pessoa = ', inscrito no CPF/MF sob o n '.$reg_pessoa[1];
		}


		if($registro->Fiel_Depositario=='S'){
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>COMPRADORA,</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do <b>'.UpperDados($label).',</b> pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. '.$registro->Depositario_Nome.''.
								 ''.$dep_nac.''.$dep_ocup.''.$dep_cpf.''.
								 ', residente e domiciliado no municpio de '.$registro->Depositario_Cidade_Nome.', no Estado '.
								 'd'.ArtigoEstado($reg_uf_depositario[1]).' '.$reg_uf_depositario[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}else{
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>COMPRADORA,</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do <b>'.UpperDados($label).',</b> pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. '.$reg_pessoa[0].''.
								 ''.$cgc_pessoa.''.
								 ', residente e domiciliado no municpio de '.$reg_end_pessoa[2].', no Estado '.
								 'd'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}

		$termos_parag_seg = '<BR><b>PARGRAFO SEGUNDO</b> - O <b>'.UpperDados($label).'</b> reconhece que o objeto deste contrato est comprometido com novas '.
							 'operaes da <b>COMPRADORA</b> perante terceiros, a que a falta da entrega poder gerar prejuzos elevados referentes '.
							 'ao descumprimento e ainda lucros cessantes a serem apurados, para tanto desde logo destaca de sua produo, tornando '.
							 'individualizada as lavouras necessrias ao cumprimento deste <b>CONTRATO,</b> mantendo-se com fiel depositrio dos '.
							 'frutos colhidos at o efetivo reembolso  <b>COMPRADORA,</b> sendo que no caso de descumprimento de tal encargo '.
							 'iniciar as comisses previstas em lei.<BR>';

		$termos_parag_terc = '<BR><b>PARGRAFO TERCEIRO</b> - Ainda reconhece o <b>'.UpperDados($label).'</b> que a lavora destinada ao cumprimento do objeto '.
							  'do presente <b>CONTRATO,</b> encontra-se livre e desembaraada de qualquer nus, no sendo passvel de serem penhorados '.
							  'e sequestrados por outras dvidas do <b>'.UpperDados($label).',</b> contando com a plena cincia da responsabilidade penal, no caso '.
							  'de declarao falsa ou inexata acerca da lavoura ou produo.<BR>';

		$termos_parag_quarto = '<BR><b>PARGRAFO QUARTO</b> - O <b>DEPOSITRIO</b> se obriga a fazer seguro da mercadoria enquanto estiver '.
								'sob sua guarda contra quaisquer riscos, inclusive os de incncio, roubo e casos de furtuitos ou de fora maior.';

		$termos_parag_quinto = '<BR><b>PARGRAFO QUINTO</b> - O trmino do depsito mercantil, convencionado nesta Clusula, dar-se- quando '.
								'de cada parcial da mercadoria objeto do presente contrato, o que dever ocorrer no mesmo perodo previsto '.
								'na <b>CLUSULA TERCEIRA.</b><BR>';

		$termos_parag_sexto = '<BR><b>PARGRAFO SEXTO</b> - Para os efeitos do artigo 284 do Cdigo Comercial e 901 do Cdigo de Processo Civil, '.
							   'as partes acordam que o valor em dinheiro da mercadoria objeto do depsito ora contratado  seu preo de mercado, '.
							   'na praa de '.$reg_emp_praca[0].', preo este nunca inferior ao da aquisio com a devida atualizao monetria.';

		$termos_claus_dec_prim = ''.$termos_parag_prim.''.
								  ''.$termos_parag_seg.''.
								  ''.$termos_parag_terc.''.
								  ''.$termos_parag_quarto.''.
								  ''.$termos_parag_quinto.''.
								  ''.$termos_parag_sexto.'';
		$claus_decima_primeira = '<b><u>CLUSULA DCIMA'.$num_clausula.'</b></u> - A <b>COMPRADORA,</b> na qualidade de <b>DEPOSITANTE</b> '.
                                 'e ao <b>'.UpperDados($label).'</b> na qualidade de <b>DEPOSITRIO,</b> estipulam a presente clusula de depositrio '.
                                 'mercantil, nos termos abaixo:<BR>'.
                                 '<BR>'.
                                 ''.$termos_claus_dec_prim.'';

		if($registro->Garantias=='S'){
			$num_clausula = 'QUARTA';
		}else{
			$num_clausula = 'PRIMEIRA';
		}
		$claus_decima_segunda = '<b><u>CLUSULA DCIMA '.$num_clausula.'</b></u> - Fica eleito o foro da cidade de Araucria, no Estado '.
                                'do Paran para dirimir as dvidas porventuras oriundas deste contrato, com renncia de qualquer outro, '.
                                'por mais privilegiado que seja.';

		$proced_fiscal = '<b><u>PROCEDIMENTO FISCAL</u></b> - O <b>'.UpperDados($label).'</b> dever proceder as emisses da Notas Fiscais, conforme '.
						  'orientao posterior.<BR>'.
						  '<BR>'.
						  'E, por estarem assim justas e contratadas, assinam o presente instrumento em 3 (trs) vias de igual teor, na '.
						  'presena das testemunhas abaixo.';

		$pdf->WriteHTML($titulo);
		$pdf->ln(12);
		$pdf->WriteHTML($par_1);
		$pdf->ln(10);
		$pdf->WriteHTML($par_2);
		$pdf->ln(8);
		$pdf->WriteHTML($objeto_contrato);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_primeira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_segunda);
		$pdf->ln(8);
		$pdf->WriteHTML($prazo);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_terceira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_quarta);
		$pdf->ln(8);
		$pdf->WriteHTML($pagto_garantias);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_quinta);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_sexta);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_setima);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_oitava);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_nona);
		$pdf->ln(8);
		$pdf->WriteHTML($deposito_mercantil);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_decima_primeira);
		$pdf->ln(8);
		$pdf->WriteHTML($claus_decima_segunda);
		$pdf->ln(8);
		$pdf->WriteHTML($proced_fiscal);
  
	}else if($registro->Tipo_Contrato=='3'){
		//TIPO CONTRATO PERMUTA
		$produto = array();
		$ultimo_prod = 0;
		$dataEnt = '';
		$cons_permuta = 'select Nota_Empresa, Nota_Nr_Nota, Nota_NrDoc, Nota_Serie, Nota_Modelo, Nr_Contrato, Seq '.
					 ' from contratos_nota_permuta '.
					 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
					 ' and Empresa = "'.$registro->Empresa.'"'.
					 ' and Nr_Contrato = "'.$registro->Nr_Contrato.'"'.
					 ' and Nota_Nr_Nota <> "0"'.
					 ' order by Nota_DT_Emissao ';
		$res_permuta = consulta_sql($cons_permuta);
		$nrw_permuta = consulta_num_registros($res_permuta);
		for($p=0;$p<$nrw_permuta;$p++){
			$reg_permuta = consulta_ler_linha($res_permuta);

			$cons_data = 'select Nota_DT_Emissao '.
					  ' from contratos_nota_permuta '.
					  ' where Dominio = "'.$_SESSION['Dominio'].'"'.
					  ' and Empresa = "'.$registro->Empresa.'"'.
					  ' and Nr_Contrato = "'.$reg_permuta[5].'"'.
					  ' and Seq = "'.$reg_permuta[6].'"';
			$res_data = consulta_sql($cons_data);
			$reg_data = consulta_ler_linha($res_data);
			consulta_limpa($res_data);

			if($dataEnt!=''){
				if($dataEnt!=dataf($reg_data[0])){
					$dataEnt.= ' e ';
				}else{
					$dataEnt = '';
				}
			}
			$dataEnt.= dataf($reg_data[0]);

			$cons_nota = 'select Id_Produto, Quantidade_Estoque '.
                      ' from nota_fiscal_item '.
                      ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                      ' and Empresa = "'.$reg_permuta[0].'"'.
                      ' and Nr_Nota = "'.$reg_permuta[1].'"';
			$res_nota = consulta_sql($cons_nota);
			$nrw_nota = consulta_num_registros($res_nota);
			for($k=0;$k<$nrw_nota;$k++){
				$reg_nota = consulta_ler_linha($res_nota);
				if(!(isset($produto[$reg_nota[0]]))){
					$produto[$reg_nota[0]] = 0;
					$prod_notas[$reg_nota[0]] = '';
					$ultimo_prod = $reg_nota[0];
				}
				$produto[$reg_nota[0]]+= $reg_nota[1];
				if($prod_notas[$reg_nota[0]]!=''){
					$prod_notas[$reg_nota[0]].= ', ';
				}
				$prod_notas[$reg_nota[0]].= $reg_permuta[2].'/'.$reg_permuta[3].'-'.$reg_permuta[4];
			}
			consulta_limpa($res_nota);
		}
		consulta_limpa($res_permuta);
     
		$msg_permuta = '<b>';
		$permuta_prod = '';
		$semente = false;
		$qtd_produto = '';
		$msg_prod_plural = 'ser entregue';
		$msg_data_plural = 'no dia';
		$cont = 0;

		foreach($produto as $key => $produto_notas){
			$cont++;
		 
			$cons_prod = 'select Descricao_Curta, Unidade_Venda, Codigo_Depart from produto '.
						 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
						 ' and Id_Produto = "'.$key.'"';
			$res_prod = consulta_sql($cons_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);

			$cons_depart = 'select Descricao from produto_departamento '.
						   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
						   ' and Codigo_Depart = "'.$reg_prod[2].'"';
						   //' and Descricao like "%semente%"';
			$res_depart = consulta_sql($cons_depart);
			$reg_depart = consulta_ler_linha($res_depart);
			consulta_limpa($res_depart);
			if(strpos(strtolower($reg_prod[2]), 'semente')){
				$semente = true;
			}
			if(strpos(strtolower($reg_prod[0]), 'soja')){
				$artigo_prod_permuta = 'A';
			}

			if($permuta_prod!=''){
				if($key==$ultimo_prod){
					$permuta_prod.= ' e ';
			    }else{
					$permuta_prod.= ', ';
			    }
			}
			$permuta_prod.= $reg_prod[0];

			if($msg_permuta!='<b>'){
				$msg_permuta.= ' e <BR>';
			}
			$msg_permuta.= ''.formata_qtd($produto_notas,3,false).' '.$reg_prod[1].' de '.$reg_prod[0].' conforme Nota Fiscal '.$prod_notas[$key].'';

			if($qtd_produto!=''){
				$qtd_produto.= ' e ';
			}
			$qtd_produto.= ''.$reg_prod[0].'';
        
		}
		$msg_permuta.= '<BR>por<BR>'.
						''.formata_qtd(($registro->Quantidade/$divisao_quilos),3,false).' Sacas de '.$qtd_quilos.' Kgs de '.$tipo_prod.' em gros a granel.</b>';

		if($cont>1){
			$msg_prod_plural = 'sero entregues';
			$msg_data_plural = 'nos dias';
		}
		$msg_entrega_prod = $qtd_produto.' '.$msg_prod_plural;
		$msg_data_entrega = $msg_data_plural.' '.$dataEnt.''; //dataf($reg_permuta[5]);

		$titulo = 'Pelo presente instrumento particular de contrato de compra e venda de cereais, as partes '.
			   'abaixo qualificadas, de um lado:';

		$par_1 = '01) <b>'.$reg_empresa[0].',</b> pessoa jurdica de direito privado, com sua matriz  '.$reg_endereco[0].' '.$reg_endereco[1].', '.
			  'na cidade de '.$reg_endereco[2].', no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].', inscrito no CNPJ do (M.F), sob o n '.$reg_empresa[1].', '.
			  'e com Inscrio Estadual sob o n '.$reg_endereco[5].', neste ato representado por seus diretores e/ou '.
			  'procuradores, na forma de seu contrato social, e de outro lado:';

		$par_2 = '02) <b>'.$reg_pessoa[0].',</b> inscrito no CPF/MF, sob o n '.$reg_pessoa[1].', residente no municpio de '.$reg_end_pessoa[2].' '.
			  'no Estado d'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].'.';
			  
		$sub_titulo = 'Como outorgantes permutantes reciprocamente outorgados, fica justo e contratado o seguinte.';

		$objeto_contrato = '<b>I - OBJETO DO CONTRATO</b>';

		$claus_primeira = '<b><u>CLUSULA PRIMEIRA</u></b> - O <b>PRIMEIRO</b> declara ser possuidor, de '.$permuta_prod.', '.
                       'o <b>SEGUNDO</b> declara ser possuidor, de '.strtolower($tipo_prod).' '.
                       'em gros  granel e que pretendem entre si permut-los na respectiva quantidade.<BR>'.
                       '<BR>'.$msg_permuta.'';


		$artigo = 'a';
		$claus_segunda_param = '';
		if($registro->Umidade_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Umidade Mxima......................................................de '.formata_qtd($registro->Umidade_Perc,2,false).'%<BR>';
			$artigo = 'b';
		}
		if($registro->Impureza_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Impurezas em Quantidade Mxima......................................de '.formata_qtd($registro->Impureza_Perc,false).'%<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				$artigo = 'c';
			}
		}
		if(($registro->Ardido_Perc>0) && ($registro->Avariado_Perc>0)){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Avariados...de '.formata_qtd($registro->Avariado_Perc,false).'% .... c/ no Mximo...de '.formata_qtd($registro->Ardido_Perc,false).'% de Ardidos<BR>';
			if($artigo == 'a'){
				$artigo = 'b';
			}else{
				if($artigo == 'b'){
					$artigo = 'c';
				}else{
					$artigo = 'd';
				}
			}
		}
		if($registro->Quebrado_Perc>0){
			$claus_segunda_param.= ''.$artigo.') Quantidade Mxima de Gros Partido e/ou Quebrados...................de '.formata_qtd($registro->Quebrado_Perc,false).'%<BR>';
		}

		if($registro->Transgenico!='S'){
			$claus_segunda_param.= '<BR>Obs.: O(A) Sr(a). <b>'.strtoupper($reg_pessoa[0]).',</b> de forma irretratvel e irrevogvel, '.
									'declara, sob as penas da lei civil e penal, que o produto vendido no  geneticamente modificado (Trangnico) '.
									'e de que tambm no  sobra de semente tratada com fungicida.<BR>';
		}
     
		if($semente){
			$claus_segunda_param.= '<BR>A semente em gros ensacada, ora negociada ter a seguinte qualidade ou parmetro:<BR> ';
								   'a) Fiscalizada<BR>'.
								   'b) Pureza............  99,9 %<BR>'.
								   'c) Germinao........  90,0 %';
		}


		$claus_segunda = '<b><u>CLUSULA SEGUNDA</u></b> - '.$artigo_prod.' '.strtolower($tipo_prod).' ora mencionad'.strtolower($artigo_prod).' ter '.
						  'a seguinte qualidade ou parmetro:<BR>'.
						  '<BR>'.
						  ''.$claus_segunda_param.'<BR>'.
						  '<BR>'.
						  '<b>PARGRAFO NICO</b> - Fica facultado  <b>'.$reg_empresa[0].'</b> o direito de receber a mercadoria mediante '.
						  'desconto de peso equivalente, de acordo com sua tabela interna, caso '.strtolower($artigo_prod).' '.strtolower($tipo_prod).' '.
						  'no seja entregue pelo(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b> rigorosamente dentro dos '.
						  'padres descritos no "caput" desta Clusula.';

		$prazo = '<b>II - PRAZO E LOCAL DE ENTREGA</b>';

		$claus_terceira = '<b><u>CLUSULA TERCEIRA</u></b> - '.$artigo_prod.' '.strtolower($tipo_prod).' em gros ser entregue parceladamente pelo(a) '.
						   'Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b>  <b>'.$reg_empresa[0].',</b> at o prazo mximo de '.DataExtenso(dataf($registro->DT_Entrega)).', '.
						   'no armazm da <b>'.$reg_empresa[0].',</b> na cidade de '.$reg_endereco[2].', no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].'.<BR>'.
						   ''.$msg_entrega_prod.' pela <b>'.$reg_empresa[0].'</b> no seu armazm na cidade de '.$reg_endereco[2].', '.
						   'no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].' ao() Sr(a). '.strtoupper($reg_pessoa[0]).', '.
						   ''.$msg_data_entrega.'.<BR>'; //DATAS_ENTREGA
						   '<BR>'.
						   '<b>PARAGRAFO NICO</b> - As mercadorias, devero estar acompanhadas de documentao fiscal e comercial a '.
						   'favor das partes, observada a legislao pertinente.';

		$cond_gerais = '<b>III - CONDIES GERAIS</b>';

		$claus_quarta = '<b><u>CLUSULA QUARTA</u></b> - As partes de comum acordo estipulam qua a tradio definitiva dar-se- a '.
						 'cada entrega da mercadoria, passando a cada outorgado, naquele momento, a ser titular do domnio '.
						 'd'.strtolower($artigo_prod).' '.strtolower($tipo_prod).' em gros a granel e '.$reg_prod[0].' conforme Nota Fiscal '.$prod_notas[$key].', '.
						 'respectivamente entregues, podendo delas dispor como melhor lhes aprouver.';

		$claus_quinta = '<b><u>CLUSULA QUINTA</u></b> - Em no ocorrendo a entrega total ou parcial das mercadorias nas condies aqui '.
						 'estipuladas, poder cada outorgado, independentemente de notificao, promover todas as medidas '.
						 'cabveis, judiciais ou extra-judiciais, para obrigar a outra parte a cumprir totalmente o '.
						 'contrato, sem prejuzo de responder por perdas e danos, hipteses em que responder esta pelas '.
						 'custas do processo a que der causa e honorrios advocatcios.';

		$claus_sexta = '<b><u>CLUSULA SEXTA</u></b> - Fica estabelecida a multa de 20% (vinte por cento) para a parte que desrespeitar '.
						'qualquer clusula deste contrato.';

		$claus_setima = '<b><u>CLUSULA STIMA</u></b> - As despesas havidas com registro do presente contrato, correro '.
						 'por conta do(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b>.';

		$claus_oitava = 'O(A) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b> neste ato emite  favor da <b>'.strtoupper($reg_empresa[0]).'</b> '.
						 'uma Nota Promissria no valor de '.$registro->Moeda.' '.formata_qtd($registro->Valor_Promissoria,3,false).' '.
						 '('.trim(extenso($registro->Valor_Promissoria)).'), a ttulo de crdito, esse autnomo para os efeitos legais '.
						 'e processuais, que na data do vencimento poder ser levada a protesto e/ou cobrana judicial, '.
						 'caso o(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b> no tenha entregue totalmente a mercadoria permutada.';


		$dep_nac = '';
		if($registro->Depositario_Nacionalidade!=''){
			$dep_nac.= ', '.$registro->Depositario_Nacionalidade;
		}
		$dep_ocup = '';
		if($registro->Depositario_Ocupacao!=''){
			$dep_ocup.= ', '.$registro->Depositario_Ocupacao;
		}
		$dep_cpf = '';
		if($registro->Depositario_CPF!=''){
			$dep_cpf.= ', inscrito no CPF/MF sob o n '.$registro->Depositario_CPF;
		}

		$cgc_pessoa = '';
		if($reg_pessoa[1]!=''){
			$cgc_pessoa = ', inscrito no CPF/MF sob o n '.$reg_pessoa[1];
		}


		if($registro->Fiel_Depositario=='S'){
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>'.strtoupper($reg_empresa[0]).',</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> - '.
								 ''.formata_qtd(($registro->Quantidade/$divisao_quilos),3,false).' Sacas de '.$qtd_quilos.' Kgs, de '.$tipo_prod.' em gros a granel -, desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do(a) Sr(a). <b>'.$reg_pessoa[0].',</b> pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. <b>'.$registro->Depositario_Nome.'</b>'.
								 ''.$dep_nac.''.$dep_ocup.''.$dep_cpf.''.
								 ', residente e domiciliado no municpio de '.$registro->Depositario_Cidade_Nome.', no Estado '.
								 'd'.ArtigoEstado($reg_uf_depositario[1]).' '.$reg_uf_depositario[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}else{
			$termos_parag_prim = '<b>PARGRAFO PRIMEIRO</b> - Nos termos do artigo 1.265 a seguintes do Cdigo Civil, a <b>'.strtoupper($reg_empresa[0]).',</b> '.
								 'contrata, como contrato tem, o <b>DEPSITO</b> dos bens descritos na <b>CLUSULA PRIMEIRA,</b> - '.
								 ''.formata_qtd(($registro->Quantidade/$divisao_quilos),3,false).' Sacas de '.$qtd_quilos.' Kgs, de '.$tipo_prod.' em gros a granel -, desde o '.
								 'momento da assinatura deste instrumento e enquanto estiveram na posse do(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b>, pelo que desses '.
								 'bens fica nomeado como <b>FIEL DEPOSITRIO</b> o Sr. <b>'.$reg_pessoa[0].'</b>'.
								 ''.$cgc_pessoa.''.
								 ', residente e domiciliado no municpio de '.$reg_end_pessoa[2].', no Estado '.
								 'd'.ArtigoEstado($reg_uf_pessoa[1]).' '.$reg_uf_pessoa[0].' o qual expressamente declara '.
								 'aceitar o encargo, pelo que assina o presente instrumento, comprometendo-se a cumprir os deveres de tal '.
								 'mister, devendo empregar na conservao dos bens cuidado que empregaria se os mesmos lhe pertencessem, sob '.
								 'pena de serem declarados depositrios infiis sujeitos portanto s penalidades da decorrentes.<BR>';
		}
     
		$termos_parag_seg = '<b>PARGRAFO SEGUNDO</b> - O(A) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b> reconhece que o objeto deste <b>CONTRATO</b> est '.
						 'comprometido com novas operaes da <b>'.strtoupper($reg_empresa[0]).'</b> perante terceiros, a que a falta da entrega poder '.
						 'gerar prejuzos elevados referentes ao descumprimento e ainda lucros cessantes a serem apurados, para tanto desde logo destaca de '.
						 'sua produo, tornando individualizada as lavouras necessrias ao cumprimento deste <b>CONTRATO</b>, mantendo-se com fiel depositrio '.
						 'dos frutos colhidos at o efetivo reembolso  <b>'.strtoupper($reg_empresa[0]).'</b>, sendo que no caso de descumprimento '.
						 'de tal encargo iniciar as comisses previstas em lei.';
						 
		$termos_parag_terc = '<b>PARGRAFO TERCEIRO</b> - Ainda reconhece o(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b> que a lavora destinada '.
						  'ao cumprimento do objeto do presente <b>CONTRATO,</b> encontra-se livre e desembaraada de qualquer nus, no sendo '.
						  'passvel de serem penhorados e sequestrados por outras dvidas do(a) Sr(a) <b>'.strtoupper($reg_pessoa[0]).'</b>, '.
						  'contando com a plena cincia da responsabilidade penal, no caso de declarao falsa ou inexata '.
						  'acerca da lavoura ou produo.';

		$termos_parag_quarto = '<b>PARGRAFO QUARTO</b> - O(A) Sr(a). <b>'.strtoupper($reg_pessoa[0]).'</b>, obriga-se a fazer seguro da '.
							'mercadoria enquanto estiver sob sua guarda contra quaisquer riscos, inclusive os de incndio, '.
							'roubo e casos de furtuitos ou de fora maior.';
							
		$termos_parag_quinto = '<b>PARGRAFO QUINTO</b> - O trmino do depsito mercantil, convencionado nesta Clusula, dar-se- quando de '.
							'cada entrega parcial da mercadoria objeto do presente contrato, o que dever ocorrer no mesmo perodo '.
							'previsto na <b>CLUSULA TERCEIRA.</b>';
							
		$termos_parag_sexto = '<b>PARGRAFO SEXTO</b> - Para os efeitos do artigo 284 do Cdigo Comercial e 901 do Cdigo de Processo Civil, '.
						   'as partes acordam que o valor em dinheiro da mercadoria objeto do depsito ora contratado  o seu preo de '.
						   'mercado, na praa de '.$reg_emp_praca[0].', preo este nunca inferior ao da permuta, com a devida atualizao '.
						   'monetria.';
							
		$claus_nona = '<b><u>CLUSULA NONA</b></u> - A <b>'.strtoupper($reg_empresa[0]).',</b> na qualidade de <b>DEPOSITANTE</b> '.
                   'e o(a) Sr(a). <b>'.strtoupper($reg_pessoa[0]).',</b> na qualidade de <b>DEPOSITRIO,</b> estipulam a presente clusula '.
                   'de depsito mercantil, nos termos abaixo:<BR>'.
                   '<BR>'.
                   ''.$termos_parag_prim.'<BR>'.
                   '<BR>'.
                   ''.$termos_parag_seg.'<BR>'.
                   '<BR>'.
                   ''.$termos_parag_terc.'<BR>'.
                   '<BR>'.
                   ''.$termos_parag_quarto.'<BR>'.
                   '<BR>'.
                   ''.$termos_parag_quinto.'<BR>'.
                   '<BR>'.
                   ''.$termos_parag_sexto.'';

		$claus_decima = '<b><u>CLUSULA DCIMA</u></b> - Fica eleito o foro da cidade de Araucria, no Estado do Paran para dirimir as dvidas '.
					 'porventuras oriundas deste contrato, com renncia de qualquer outro, por mais privilegiado que seja.';
					 
		$proced_fiscal = '<b><u>PROCEDIMENTO FISCAL</u></b> - O <b>'.UpperDados($label).'</b> dever proceder as emisses da Notas Fiscais, conforme '.
					  'orientao posterior.<BR>'.
					  '<BR>'.
					  'E, por estarem assim justas e contratadas, assinam o presente instrumento em 3 (trs) vias de igual teor, na '.
					  'presena das testemunhas abaixo.';

		$pdf->WriteHTML($titulo);
		$pdf->ln(12);
		$pdf->WriteHTML($par_1);
		$pdf->ln(10);
		$pdf->WriteHTML($par_2);
		$pdf->ln(10);
		$pdf->WriteHTML($sub_titulo);
		$pdf->ln(10);
		$pdf->WriteHTML($objeto_contrato);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_primeira);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_segunda);
		$pdf->ln(10);
		$pdf->WriteHTML($prazo);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_terceira);
		$pdf->ln(10);
		$pdf->WriteHTML($cond_gerais);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_quarta);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_quinta);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_sexta);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_setima);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_oitava);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_nona);
		$pdf->ln(10);
		$pdf->WriteHTML($claus_decima);
		$pdf->ln(10);
		$pdf->WriteHTML($proced_fiscal);
     
	}
  
	$pdf->ln(16);

	$pdf->WriteHTML('<P ALIGN="center">'.ucfirst(strtolower($reg_endereco[2])).' - '.ucfirst($reg_uf_emp[0]).', '.DataExtenso(dataf($registro->DT_Assinatura)).'.</P>');
	$pdf->ln(16);

	//ARRUMAR CONTRATO 1022 UMIDADE_PERC, *._PERC PARA 0.00 (EDITADO PARA 1.00 APENAS PARA TESTAR)
	$lar = 190;
	$lns = 5;

	$y=$pdf->y;

/*
//LINHA DEPOSITANTE
     $pdf->Cell(1,      $lns, ' ', 0,0,'C');
     $pdf->SetFont('Courier','',8);
     $pdf->SetAutoPageBreak(false,30);

     $y=$pdf->y;
     $pdf->MultiCell((30/100)*$lar, $lns, '', '', 'C');
     $pdf->y=$y;

     $y=$pdf->y;
     $pdf->MultiCell((20/100)*$lar, $lns, '', '', 'C');
     $pdf->y=$y;

     $y=$pdf->y;
     $pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
     $pdf->y=$y;

     $y=$pdf->y;
     $pdf->MultiCell((20/100)*$lar, $lns, '', '', 'C');
     $pdf->y=$y;

     $pdf->Cell(1,      $lns, ' ', 0,1,'C');
     //Prxima Linha
     $pdf->x=$pdf->lMargin;
     $pdf->y=$y+$lns;
     $pdf->SetAutoPageBreak(true,30);
*/

	//LINHA DEPOSITANTE
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//NOME DEPOSITANTE
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((60/100)*$lar, $lns, $reg_empresa[0], '', 'C');
	$pdf->y=$y;


	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//SIGLA DEPOSITANTE
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, 'Testemunhas', '', 'L');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '- DEPOSITANTE -', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);


	$pdf->ln(10);

	//LINHA TESTEMUNHA1 E VENDEDOR
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//NOME VENDEDOR
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, $registro->Testemunha1_Nome, '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((60/100)*$lar, $lns, $reg_pessoa[0], '', 'C');
	$pdf->y=$y;


	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//SIGLA VENDEDOR
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, 'CPF/MF - '.$registro->Testemunha1_CPF, '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '- '.UpperDados($label).' -', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	$pdf->ln(10);

	//LINHA TESTEMUNHA2 E FIEL-DEPOSITARIO
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '', 'B', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//NOME FIEL-DEPOSITARIO
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, $registro->Testemunha2_Nome, '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((60/100)*$lar, $lns, $reg_pessoa[0], '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);

	//SIGLA FIEL-DEPOSITARIO
	$pdf->Cell(1,      $lns, ' ', 0,0,'C');
	$pdf->SetFont('Courier','B',8);
	$pdf->SetAutoPageBreak(false,30);

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, 'CPF/MF - '.$registro->Testemunha2_CPF, '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((30/100)*$lar, $lns, '- FIEL DEPOSITARIO -', '', 'C');
	$pdf->y=$y;

	$y=$pdf->y;
	$pdf->MultiCell((15/100)*$lar, $lns, '', '', 'C');
	$pdf->y=$y;

	$pdf->Cell(1,      $lns, ' ', 0,1,'C');
	//Prxima Linha
	$pdf->x=$pdf->lMargin;
	$pdf->y=$y+$lns;
	$pdf->SetAutoPageBreak(true,30);


	consulta_limpa($resultado);
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
	
}
?>