<?
    require_once('../../includes/header.inc');
    require_once('../../includes/base_class.inc');
    define('FPDF_FONTPATH', '../../fpdf/font/');
    require('../../fpdf/fpdf.php');

if(session::usr_conectado($_REQUEST['USER_ID'])){

    class PDF_HTML extends FPDF{
        var $B=0;
        var $I=0;
        var $U=0;
        var $HREF='';
        var $ALIGN='';

        function Header($tipo_cab='tudo'){
			if ($this->DefOrientation=='P'){
				$tamanho_total_linha = 190;
			}else{
				$tamanho_total_linha = 275;
			}
			$this->SetFillColor(255,255,255);
			$date=getdate();
			$hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
			$hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);

			$consulta_usuario = 'select Nome from usuario '.
							   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
							   ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"';
			$res = consulta_sql($consulta_usuario);
			$row = consulta_ler_linha($res);
			$nome_usuario = $row[0];
			consulta_limpa($res);

			$con_empresa = 'select Web_Site from pessoa '.
						  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
						  ' and Pessoa="'.$_REQUEST['empresa'].'"';
			$res_empresa = consulta_sql($con_empresa);
			$reg_empresa = consulta_ler_linha($res_empresa);
			consulta_limpa($res_empresa);

			$this->SetFont('Arial','B',8);
			//Imprime Cabealho

			//IMAGEM
			if($tipo_cab=='tudo'){
				$base_y = 0;
				$this->Cell(1,  15, ' ', 0,0,'C');
				$this->Image(busca_imagem_empresa('logo_menu.jpg', '../../'), (($tamanho_total_linha/2)-5), (15+$base_y), 30,15);  //50,20
				$this->Cell(1,  15, ' ', 0,1,'C');
			}
			$this->Cell(1,  5, ' ', 0,1,'C');
			$this->Cell(1,  15, ' ', 0,0,'C');
			$y=$this->y;
			$this->MultiCell(($tamanho_total_linha), 5, $reg_empresa[0], 0,'C');
			$this->y=$y;
			$this->Cell(1,  15, ' ', 0,1,'C');
			//CABECALHO
			$this->Cell(1,  20, ' ', 0,0,'C');
			$this->SetFont('Arial','BU',24);
			$lns_cabecalho = $this->Lines_MultiCell(($tamanho_total_linha/2),5,$this->Cabecalho,1);
			$y=$this->y;
			$this->MultiCell(($tamanho_total_linha), (20/($lns_cabecalho*5)) * 5, $this->Cabecalho, 0,'C');
			$this->y=$y;
			$this->SetFont('Arial','B',10);
			$this->Cell(1,  20, ' ', 0,1,'C');


			//SUB-CABECALHO
			if($this->Sub_Cabecalho_Texto!=''){
				$this->SetFont('Arial',$this->Sub_Cabecalho_Style,10);
				$lns_cabecalho = $this->Lines_MultiCell($tamanho_total_linha,5,$this->Sub_Cabecalho_Texto,$this->Sub_Cabecalho_Border);
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,0,'C');
				$y=$this->y;
				$this->MultiCell($tamanho_total_linha, 5 , $this->Sub_Cabecalho_Texto, $this->Sub_Cabecalho_Border,$this->Sub_Cabecalho_Align);
				$this->y=$y;
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,1,'C');
				$this->x=$this->lMargin;
				$this->y=$y+($lns_cabecalho*5);
				$this->SetAutoPageBreak(true,30);
				$this->SetFont('Arial','',8);
			}

			//CABECALHO GRID (COLUNAS)
			if($this->CabecalhoGrid_Texto!=''){
				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->SetFont('Arial','B',8);
				foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');
			}

          $this->SetFont('Arial','',6);
        }
        
        function Footer(){}

        function WriteHTML($html){
			//HTML parser
			$html=str_replace("\n",' ',$html);
			$a=preg_split('/<(.*)>/U',$html,-1,PREG_SPLIT_DELIM_CAPTURE);
			foreach($a as $i=>$e){
				if($i%2==0){
					//Text
					if($this->HREF)
						$this->PutLink($this->HREF,$e);
					elseif($this->ALIGN=='center')
						$this->Cell(0,5,$e,0,1,'C');
					else
						$this->Write(5,$e);
				}else{
                    //Tag
                    if($e[0]=='/')
                       $this->CloseTag(strtoupper(substr($e,1)));
                    else{
						//Extract properties
						$a2=explode(' ',$e);
						$tag=strtoupper(array_shift($a2));
						$prop=array();
						foreach($a2 as $v){
						   if(preg_match('/([^=]*)=["\']?([^"\']*)/',$v,$a3))
							   $prop[strtoupper($a3[1])]=$a3[2];
						}
						$this->OpenTag($tag,$prop);
                    }
				}
			}
        }

        function OpenTag($tag,$prop){
			//Opening tag
			if($tag=='B' || $tag=='I' || $tag=='U')
				$this->SetStyle($tag,true);
			if($tag=='A')
				$this->HREF=$prop['HREF'];
			if($tag=='BR')
				$this->Ln(5);
			if($tag=='P')
				$this->ALIGN=$prop['ALIGN'];
			if($tag=='HR'){
				if( !empty($prop['WIDTH']) )
					$Width = $prop['WIDTH'];
				else
					$Width = $this->w - $this->lMargin-$this->rMargin;
				$this->Ln(2);
				$x = $this->GetX();
				$y = $this->GetY();
				$this->SetLineWidth(0.4);
				$this->Line($x,$y,$x+$Width,$y);
				$this->SetLineWidth(0.2);
				$this->Ln(2);
			}
		}

		function CloseTag($tag){
			//Closing tag
			if($tag=='B' || $tag=='I' || $tag=='U')
				$this->SetStyle($tag,false);
			if($tag=='A')
				$this->HREF='';
			if($tag=='P')
				$this->ALIGN='';
		}

		function SetStyle($tag,$enable){
			//Modify style and select corresponding font
			$this->$tag+=($enable ? 1 : -1);
			$style='';
			foreach(array('B','I','U') as $s)
				if($this->$s>0)
					$style.=$s;
			$this->SetFont('',$style);
		}

		function PutLink($URL,$txt){
			//Put a hyperlink
			$this->SetTextColor(0,0,255);
			$this->SetStyle('U',true);
			$this->Write(5,$txt,$URL);
			$this->SetStyle('U',false);
			$this->SetTextColor(0);
		}
    }

    function ArtigoEstado($UF){
        $termo = 'e'; //valor genrico
        if($UF == 'AC'){ $termo = 'o'; }
        if ($UF == 'AL'){ $termo = 'as'; }
        if ($UF == 'MA'){ $termo = 'o'; }
        if ($UF == 'AP'){ $termo = 'o'; }
        if ($UF == 'BA'){ $termo = 'a'; }
        if ($UF == 'CE'){ $termo = 'o'; }
        if ($UF == 'DF'){ $termo = 'o'; }
        if ($UF == 'ES'){ $termo = 'o'; }
        if ($UF == 'GO'){ $termo = 'e'; }
        if ($UF == 'MA'){ $termo = 'o'; }
        if ($UF == 'MG'){ $termo = 'e'; }
        if ($UF == 'MS'){ $termo = 'o'; }
        if ($UF == 'MT'){ $termo = 'o'; }
        if ($UF == 'PA'){ $termo = 'o'; }
        if ($UF == 'PB'){ $termo = 'a'; }
        if ($UF == 'PE'){ $termo = 'e'; }
        if ($UF == 'PI'){ $termo = 'o'; }
        if ($UF == 'PR'){ $termo = 'o'; }
        if ($UF == 'RJ'){ $termo = 'o'; }
        if ($UF == 'RN'){ $termo = 'o'; }
        if ($UF == 'RO'){ $termo = 'e'; }
        if ($UF == 'RR'){ $termo = 'e'; }
        if ($UF == 'RS'){ $termo = 'o'; }
        if ($UF == 'SC'){ $termo = 'e'; }
        if ($UF == 'SE'){ $termo = 'o'; }
        if ($UF == 'SP'){ $termo = 'e'; }
        if ($UF == 'TO'){ $termo = 'o'; }

        return $termo;
    }


    $consulta = 'select Empresa, Nr_Recibo, Fornecedor, '.
                 ' DT_Abertura, DT_Fecha, Id_Produto, Tipo_Produto, Quantidade, '.
                 ' Banco, UF_Agencia, Cidade_Agencia, Codigo_Cidade_Agencia from recibo_deposito '.
                 ' where Dominio="'.$_SESSION["Dominio"].'"'.
                 ' and Empresa = "'.$_SESSION['Empresa_Codigo'].'"'.
                 ' and Nr_Recibo = "'.$_REQUEST['nr_recibo'].'"';
    $resultado = consulta_sql($consulta);
    $registro = consulta_ler_objeto($resultado);
     
     
    $con_fornec = 'select Nome_Razao, CPF_CNPJ from pessoa '.
                   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                   ' and Pessoa="'.$registro->Fornecedor.'"';
    $res_fornec = consulta_sql($con_fornec);
    $reg_fornec = consulta_ler_linha($res_fornec);
    consulta_limpa($res_fornec);
     
     
    $con_empresa = 'select Nome_Razao, CPF_CNPJ from pessoa '.
                    ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' and Pessoa="'.$registro->Empresa.'"';
    $res_empresa = consulta_sql($con_empresa);
    $reg_empresa = consulta_ler_linha($res_empresa);
    consulta_limpa($res_empresa);
     
     
    $cons_endereco = 'select Logradouro, Numero, Nome_Cidade, UF, CEP, Insc_Estadual from pessoa_endereco '.
                      ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                      ' and Pessoa="'.$registro->Empresa.'"';
    $res_endereco = consulta_sql($cons_endereco);
    $reg_endereco = consulta_ler_linha($res_endereco);
    consulta_limpa($res_endereco);
     
     
    $cons_uf_emp = 'select Nome, UF from uf '.
                    ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' and UF="'.$reg_endereco[3].'"';
    $res_uf_emp = consulta_sql($cons_uf_emp);
    $reg_uf_emp = consulta_ler_linha($res_uf_emp);
    consulta_limpa($res_uf_emp);
          
    $cons_banco = 'select Nome from banco '.
                   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                   ' and Codigo_Banco = "'.$registro->Banco.'"';
    $res_banco = consulta_sql($cons_banco);
    $reg_banco = consulta_ler_linha($res_banco);
    consulta_limpa($res_banco);


    $cons_uf = 'select Nome, UF from uf '.
                ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                ' and UF = "'.$registro->UF_Agencia.'"';
    $res_uf = consulta_sql($cons_uf);
    $reg_uf = consulta_ler_linha($res_uf);
    consulta_limpa($res_uf);

    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');

       
    $pdf=new PDF_HTML();
    $pdf->Open();
     
    for($j=0;$j<2;$j++){
     
        $pdf->Cabecalho = 'RECIBO DE DEPSITO N '.$_REQUEST['nr_recibo'].'';
        $pdf->Cabecalho_Filtro = '';
        $pdf->Sub_Cabecalho_Texto =  '';
        $pdf->Sub_Cabecalho_Style =  'B';
        $pdf->Sub_Cabecalho_Align =  'L';
        $pdf->Sub_Cabecalho_Border =  0;
        $pdf->AddPage();

        $k=0;
        $pdf->CabecalhoGrid_Texto = '';
        $lns = 5;

        $k=0;
        $pdf->SetFont('Arial','',10);

        $tipo_produto = '';
        if($registro->Tipo_Produto=='M'){
			$tipo_produto = 'Milho';
        }else if($registro->Tipo_Produto=='S'){
            $tipo_produto = 'Soja';
        }else if($registro->Tipo_Produto=='T'){
            $tipo_produto = 'Trigo';
        }else if($registro->Tipo_Produto=='C'){
            $tipo_produto = 'Cevada';
        }

        $mensagem = 'Recebemos do(a) Sr(a). <b>'.$reg_fornec[0].'</b> inscrito no CPF/MF, sob o n '.$reg_fornec[1].', os bens '.
                    'abaixo descritos, a favor do '.$reg_banco[0].', agncia de '.$registro->Cidade_Agencia.' - '.$reg_uf[0].'.'.
                    '<BR>Esses bens ficam depositados  ordem do '.$reg_banco[0].', em armazm desta empresa, localizado na '.
                    ''.$reg_endereco[0].', '.$reg_endereco[1].' na cidade de '.$reg_endereco[2].' no Estado d'.ArtigoEstado($reg_uf_emp[1]).' '.$reg_uf_emp[0].', '.
                    'para guarda e conservao, nos termos da Lei, ficando desde j entendido que o(a) Sr(a). <b>'.$reg_fornec[0].'</b> '.
                    'no poder utilizar, retirando-os no todo ou parte, do referido armazm, ou mandando transfer-los para nome ou '.
                    'disposio de terceiros, sem autorizao escrita do '.$reg_banco[0].', podendo este, a qualquer tempo, '.
                    'independentemente da aquiescncia do devedor, exigir do depositrio a entrega dos bens sob as penas '.
                    'da Lei / art. 1287 do Cdigo Civil.'.
                    '<BR><BR>'.
                    'A especificao dos bens depositados  a seguinte:'.
                    '<BR><BR>';

        $msg_bens = '<b>'.$tipo_produto.' em gros a granel '.formata_qtd($registro->Quantidade,3,false).' Kgs. '.
                    '('.formata_qtd(($registro->Quantidade/60),3,false).' Sacas de 60 Kgs.)</b>';

        //$pdf->MultiCell(0,10,$teste,0,'J',0,15,1);
        $pdf->WriteHTML($mensagem);
   //     $pdf->ln(10);
        $pdf->WriteHTML($msg_bens);
        $pdf->ln(20);

        $lar = 190;
        $lns = 3;

        $y=$pdf->y;

        $pdf->Cell(1,      $lns, ' ', 0,1,'C');
        //Prxima Linha
        $pdf->x=$pdf->lMargin;
        $pdf->y=$y+$lns;
        $pdf->SetAutoPageBreak(true,30);

        $pdf->Cell(1,      $lns, ' ', 0,0,'C');
        $pdf->SetFont('Arial','',10);
        $pdf->SetAutoPageBreak(false,30);

        $y=$pdf->y;
        $pdf->MultiCell((10/100)*$lar, $lns, '', '', 'C');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((60/100)*$lar, $lns, ''.$reg_endereco[2].' - '.$reg_uf_emp[0].', '.DataExtenso(dataf($registro->DT_Abertura)).'.', '', 'C');
        $pdf->y=$y;


		$pdf->ln(20);
		$pdf->MultiCell((10/100)*$lar, $lns, 'Att.', '', 'L');
		$pdf->ln(30);


		$empresa = '<b>'.$reg_empresa[0].'</b><BR>';
		$end_empresa = '<b>'.$reg_endereco[0].', n '.$reg_endereco[1].'</b><BR>';
		$cidade_estado = '<b>'.$reg_endereco[2].' - '.$reg_uf_emp[0].'</b><BR>';
		$cnpj = '<b>CNPJ/MF - '.$reg_empresa[1].'</b><BR>';
		$ins_estadual = '<b>Inscrio Estadual - '.$reg_endereco[5].'</b><BR>';
		$cep_empresa = '<b>CEP - '.$reg_endereco[4].'</b>';
		$pdf->WriteHTML($empresa);
		$pdf->WriteHTML($end_empresa);
		$pdf->WriteHTML($cidade_estado);
		$pdf->WriteHTML($cnpj);
		$pdf->WriteHTML($ins_estadual);
		$pdf->WriteHTML($cep_empresa);

    }
    consulta_limpa($resultado);
    echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}

?>