<?php
    require_once('../../includes/header.inc');
    require_once('../../includes/base_class.inc');
    define('FPDF_FONTPATH', '../../fpdf/font/');
    require('../../fpdf/fpdf.php');

if(session::usr_conectado($_REQUEST['USER_ID']) ){

    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');

    class PDF extends FPDF{
        var $MeiaPagina;
        function Footer(){
			$this->SetFillColor(255,255,255);
			//To be implemented in your own inherited class
			$tamanho_total_linha = 190;

			if($this->MeiaPagina=='N'){
				$novo_y = 266;  //266
			}else{
				$novo_y = 126;
			}

			$this->AliasNbPages();
			//    if($this->Cabecalho_Filtro_Tam!=''){
			//	   $this->SetFont("Arial","",$this->Cabecalho_Filtro_Tam);
			//	 }else{
			$this->SetFont("Arial","",8);
			//	 }
			$this->y=$novo_y+5;
			$this->Cell(1,  5, ' ', 0,0,'C');
			$this->Cell(20,  5, config_pad('sistema_sigla'), 0,0,'L');
			$this->Cell(10,  5, ' ', 0,0,'L');

			$y=$this->y;
			$this->MultiCell(($tamanho_total_linha-50), 5, 'Filtro : '.$this->Cabecalho_Filtro, 0,'L');
			$this->y=$y;

			//$this->Cell(($tamanho_total_linha-50),  10, 'Filtro : '.$this->Cabecalho_Filtro, 0,0,'L');

			$this->Cell(20, 5, 'Pgina: '.$this->PageNo().' / {nb}',0,1,'R');
			$this->Cell(1,  5, ' ', 0,1,'C');
        }
    }    
    
    $consulta = 'select Nr_Conta, NrDoc, Modelo, Serie, Seq, Vendedor, '.
                ' Pessoa, Valor, DT_Vencto, DT_Emissao, DT_Aceite '.
                ' from aceite_duplicata_tmp '.
                ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"'.
                ' order by Vendedor, Pessoa, DT_Vencto, Empresa, NrDoc, Nr_Conta';
    $resultado = consulta_sql($consulta);
    $nrows = consulta_num_registros($resultado);

    $con_vendedor = 'select Nome_Listas, Pessoa from pessoa '.
                    ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                    ' and Pessoa="'.$_REQUEST['vendedor'].'"';
    $res_vendedor = consulta_sql($con_vendedor);
    $reg_vendedor = consulta_ler_linha($res_vendedor);
    consulta_limpa($res_vendedor);

    $pdf=new PDF();
    $pdf->Open();
    $pdf->MeiaPagina = 'N';
        
    if($_REQUEST['versao']=='1'){
		$pdf->MeiaPagina = 'S';
    }
    if($_REQUEST['op']=='E'){
		$pdf->Cabecalho = 'Relao de Aceite de Duplicatas';
    }else if($_REQUEST['op']=='D'){
        if($_REQUEST['levou']=='S'){
			$pdf->Cabecalho = 'Confirmao de Recebimento';
        }else{
			$pdf->Cabecalho = 'Devoluo de Duplicatas';
        }
    }
    
    $label_emp = empresa_representante($_REQUEST['vendedor'],'S');
    
    $pdf->Cabecalho_Filtro =  '';
    $pdf->Sub_Cabecalho_Texto =  $label_emp;
    $pdf->Sub_Cabecalho_Style =  'B';
    $pdf->Sub_Cabecalho_Align =  'L';
    $pdf->Sub_Cabecalho_Border =  0;

    set_time_limit(60);

    if ($nrows>0){
        $k=0;
        $pdf->CabecalhoGrid_Texto = '';

        $pdf->CabecalhoGrid_Texto[$k] = 'Duplicata';
        $pdf->CabecalhoGrid_Tamanho[$k] = '10';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Parcela';
        $pdf->CabecalhoGrid_Tamanho[$k] = '5';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
        $pdf->CabecalhoGrid_Tamanho[$k] = '40';
        $pdf->CabecalhoGrid_Align[$k] = 'L';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Data Emisso';
        $pdf->CabecalhoGrid_Tamanho[$k] = '10';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        $pdf->CabecalhoGrid_Texto[$k] = 'Data Vencto';
        $pdf->CabecalhoGrid_Tamanho[$k] = '10';
        $pdf->CabecalhoGrid_Align[$k] = 'C';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        if($_REQUEST['op']=='D'){
           $pdf->CabecalhoGrid_Texto[$k] = 'Dt Env. Aceite';
           $pdf->CabecalhoGrid_Tamanho[$k] = '10';
           $pdf->CabecalhoGrid_Align[$k] = 'C';
           $pdf->CabecalhoGrid_Border[$k] = 'TB';
           $k++;
        }

        $pdf->CabecalhoGrid_Texto[$k] = 'Valor Doc';
        $pdf->CabecalhoGrid_Tamanho[$k] = '15';
        $pdf->CabecalhoGrid_Align[$k] = 'R';
        $pdf->CabecalhoGrid_Border[$k] = 'TB';
        $k++;

        if($_REQUEST['op']=='E'){
			$ncampos = 6;
        }else{
			$ncampos = 7;
        }
        $pdf->AddPage();
        $pdf->SetFont('Arial','',7);

        $valor_total = 0;

        $quant = 0;
        for($i=0;$i<$nrows;$i++){
            $registro = consulta_ler_objeto($resultado);
            
            $quant++;

            //set_time_limit(60);
            $lns = 0;
            $k = 0;
            $pdf->SetFont('Arial','',7);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(false,170);
            }else{
				$pdf->SetAutoPageBreak(false,30);
            }
            
            $rowarr[$k]  =  $registro->NrDoc.'/'.$registro->Serie.'-'.$registro->Modelo;
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;


            $rowarr[$k]  =  $registro->Seq;
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;

            $con_pessoa = 'select Nome_Listas, Pessoa from pessoa '.
                            ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                            ' and Pessoa="'.$registro->Pessoa.'"';
            $res_pessoa = consulta_sql($con_pessoa);
            $reg_pessoa = consulta_ler_linha($res_pessoa);
            consulta_limpa($res_pessoa);

            $rowarr[$k]  =  $registro->Pessoa.'-'.$reg_pessoa[0];
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;


            if($registro->DT_Emissao!='0000-00-00'){
               $rowarr[$k] = dataf($registro->DT_Emissao);
            }else{
               $rowarr[$k] = '';
            }
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;


            if($registro->DT_Vencto!='0000-00-00'){
				$rowarr[$k] = dataf($registro->DT_Vencto);
            }else{
				$rowarr[$k] = '';
            }
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;


            if($_REQUEST['op']=='D'){
				if($registro->DT_Aceite!='0000-00-00'){
					$rowarr[$k] = dataf($registro->DT_Aceite);
				}else{
					$rowarr[$k] = '';
				}
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
				if ($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;
            }


            if($registro->Valor != ''){
				$rowarr[$k]  =  str_replace('"','',to_money($registro->Valor));
            }
            $vl_linha[$k] = $rowarr[$k];
            $lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190,$lns,$rowarr[$k],0);
            if ($lns_linha[$k]>$lns){
                $lns = $lns_linha[$k];
            }
            $k++;

            $lns = $lns * 4;

            $pdf->SetFont('Arial','',7);

            for ($k=0;$k<$ncampos;$k++){
                $valor = $vl_linha[$k];
                $y=$pdf->y;
                $pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*190, ($lns/($lns_linha[$k]* 4)) * 4, $valor, 0,$pdf->CabecalhoGrid_Align[$k]);
                $pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(true,170);
            }else{
				$pdf->SetAutoPageBreak(true,30);
            }

            $valor_total+= $registro->Valor;

        }

//------------------Quantidade
        $lar = 190;
        $lns = 3;

        $pdf->Cell(1,      $lns, ' ', 0,0,'C');
        $pdf->SetFont('Arial','B',7);
        if($_REQUEST['versao']=='1'){
			$pdf->SetAutoPageBreak(false,150);
        }else{
			$pdf->SetAutoPageBreak(false,30);
        }

        $y=$pdf->y;
        $pdf->MultiCell((40/100)*$lar, $lns, '', '', 'R');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((30/100)*$lar, $lns, 'Quantidade:', '', 'R');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((20/100)*$lar, $lns, $quant, '', 'R');
        $pdf->y=$y;
        
        $y=$pdf->y;
        $pdf->MultiCell((10/100)*$lar, $lns, '', '', 'R');
        $pdf->y=$y;

        $pdf->Cell(1,      $lns, ' ', 0,1,'C');
        //Prxima Linha
        $pdf->x=$pdf->lMargin;
        $pdf->y=$y+$lns;
        if($_REQUEST['versao']=='1'){
			$pdf->SetAutoPageBreak(true,170);
        }else{
			$pdf->SetAutoPageBreak(true,30);
        }

//------------------Valor
        $pdf->Cell(1,      $lns, ' ', 0,0,'C');
        $pdf->SetFont('Arial','B',7);
        if($_REQUEST['versao']=='1'){
			$pdf->SetAutoPageBreak(false,170);
        }else{
			$pdf->SetAutoPageBreak(false,30);
        }

        $y=$pdf->y;
        $pdf->MultiCell((40/100)*$lar, $lns, '', '', 'R');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((30/100)*$lar, $lns, 'Valor Total:', '', 'R');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((20/100)*$lar, $lns, str_replace('"','',to_money($valor_total)), '', 'R');
        $pdf->y=$y;

        $y=$pdf->y;
        $pdf->MultiCell((10/100)*$lar, $lns, '', '', 'R');
        $pdf->y=$y;

        $pdf->Cell(1,      $lns, ' ', 0,1,'C');
        //Prxima Linha
        $pdf->x=$pdf->lMargin;
        $pdf->y=$y+$lns;
        if($_REQUEST['versao']=='1'){
			$pdf->SetAutoPageBreak(true,170);
        }else{
			$pdf->SetAutoPageBreak(true,30);
        }

//------------------Assinatura
        if($_REQUEST['op']=='E'){
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetFont('Arial','B',7);
			if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(false,170);
			}else{
				$pdf->SetAutoPageBreak(false,30);
			}

			$y=$pdf->y;
			$pdf->MultiCell((40/100)*$lar, $lns, '', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((30/100)*$lar, $lns, 'Assinatura:', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((20/100)*$lar, $lns, ' ', 'B', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'R');
			$pdf->y=$y;

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(true,170);
			}else{
				$pdf->SetAutoPageBreak(true,30);
			}

			//------------------Nome
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetFont('Arial','B',7);
			if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(false,170);
			}else{
				$pdf->SetAutoPageBreak(false,30);
			}

			$y=$pdf->y;
			$pdf->MultiCell((40/100)*$lar, $lns, '', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((30/100)*$lar, $lns, '', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((20/100)*$lar, $lns, $_REQUEST['levou'], '', 'C');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((10/100)*$lar, $lns, '', '', 'R');
			$pdf->y=$y;

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			if($_REQUEST['versao']=='1'){
				$pdf->SetAutoPageBreak(true,170);
			}else{
				$pdf->SetAutoPageBreak(true,30);
			}
        }
    }else{
        $pdf->CabecalhoGrid_Texto = '';
        $pdf->AddPage();
        $pdf->SetFont('Arial','',8);

        $pdf->SetAutoPageBreak(true,10);

        $pdf->Cell(1,      5, '', 0,0,'C');
        $pdf->SetAutoPageBreak(false,10);

        $y=$pdf->y;
        $pdf->MultiCell(190, 5, 'No existem registros para este filtro!', 0,'L');
        $pdf->y=$y;

        $pdf->Cell(1,      5, ' ', 0,1,'C');
        //Prxima Linha
        $pdf->x=$pdf->lMargin;
        $pdf->y=$y+5;
        $pdf->SetAutoPageBreak(true,10);
    }

    consulta_limpa($resultado);
    echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>