<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('FLUXO_CAIXA.xls');

	// Creating a workbook
	$workbook = new Workbook("-");

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(12);

	// Format for the headings
	$fmt_cabec_c =& $workbook->add_format();
	$fmt_cabec_c->set_align('center');
	$fmt_cabec_c->set_align('vcenter');
	$fmt_cabec_c->set_pattern();
	$fmt_cabec_c->set_fg_color(40);
	$fmt_cabec_c->set_bold(1);
	$fmt_cabec_c->set_border(1);

	$fmt_cabec_l =& $workbook->add_format();
	$fmt_cabec_l->set_align('left');
	$fmt_cabec_l->set_align('vcenter');
	$fmt_cabec_l->set_pattern();
	$fmt_cabec_l->set_fg_color(40);
	$fmt_cabec_l->set_bold(1);
	$fmt_cabec_l->set_border(1);

	$fmt_cabec_r =& $workbook->add_format();
	$fmt_cabec_r->set_align('right');
	$fmt_cabec_r->set_align('vcenter');
	$fmt_cabec_r->set_pattern();
	$fmt_cabec_r->set_fg_color(40);
	$fmt_cabec_r->set_bold(1);
	$fmt_cabec_r->set_border(1);

	$fmt_txt_l =& $workbook->add_format();
	$fmt_txt_l->set_size(10);
	$fmt_txt_l->set_align('left');
	$fmt_txt_l->set_border(1);

	$fmt_txt_c =& $workbook->add_format();
	$fmt_txt_c->set_size(10);
	$fmt_txt_c->set_align('center');
	$fmt_txt_c->set_border(1);

	$fmt_txt_r =& $workbook->add_format();
	$fmt_txt_r->set_size(10);
	$fmt_txt_r->set_align('right');
	$fmt_txt_r->set_border(1);

	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	$fmt_valor->set_size(10);
	$fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');


	//ITALICOS E NEGRITOS
	$fmt_txt_l_i_b =& $workbook->add_format();
	$fmt_txt_l_i_b->set_size(10);
	$fmt_txt_l_i_b->set_align('left');
	$fmt_txt_l_i_b->set_border(1);
	$fmt_txt_l_i_b->set_bold(1);
	$fmt_txt_l_i_b->set_italic(1);

	$fmt_valor_i_b =& $workbook->add_format();
	$fmt_valor_i_b->set_border(1);
	$fmt_valor_i_b->set_bold(1);
	$fmt_valor_i_b->set_align('right');
	$fmt_valor_i_b->set_size(10);
	$fmt_valor_i_b->set_italic(10);
	$fmt_valor_i_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//NEGRITOS
	$fmt_txt_l_b =& $workbook->add_format();
	$fmt_txt_l_b->set_size(10);
	$fmt_txt_l_b->set_align('left');
	$fmt_txt_l_b->set_border(1);
	$fmt_txt_l_b->set_bold(1);

	$fmt_valor_b =& $workbook->add_format();
	$fmt_valor_b->set_border(1);
	$fmt_valor_b->set_bold(1);
	$fmt_valor_b->set_align('right');
	$fmt_valor_b->set_size(10);//10
	$fmt_valor_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//ITALICOS
	$fmt_txt_l_i =& $workbook->add_format();
	$fmt_txt_l_i->set_size(10);
	$fmt_txt_l_i->set_align('left');
	$fmt_txt_l_i->set_border(1);
	$fmt_txt_l_i->set_italic(1);

	$fmt_valor_i =& $workbook->add_format();
	$fmt_valor_i->set_border(1);
	$fmt_valor_i->set_align('right');
	$fmt_valor_i->set_size(10);
	$fmt_valor_i->set_italic(10);
	$fmt_valor_i->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_data_i =& $workbook->add_format();
	$fmt_data_i->set_size(10);
	$fmt_data_i->set_border(1);
	$fmt_data_i->set_italic(1);
	$fmt_data_i->set_align('center');
	$fmt_data_i->set_num_format('dd/mm/yyyy');


	if(($_REQUEST['previsto']=='P')&&($_REQUEST['modelo']=='DM')){
		$anteriores = true;
	}else{
		$anteriores = false;
	}

	$tipo_custo = 'RECEITA';
	$tem_direto = false;
	$tem_indireto = false;

	$imprimiu_pagina = false;

	if($_REQUEST['modelo']=='OR'){
		$total_acumulado_lista = 0;
		$total_qtd_acumulado = 0;

		$lista_empresas = array();
		$datas = array();

		require('centro_custo_relatorio_funcao_orcado.php');
		require('centro_custo_relatorio_funcao_previsto.php');
		require('centro_custo_relatorio_funcao.php');
	}else{
		if($_REQUEST['previsto']=='P'){
			require('centro_custo_relatorio_funcao_previsto.php');
		}else{
			require('centro_custo_relatorio_funcao.php');
		}
	}
	

	$sub_titulo = '';
	if(($modelo=='DM')||($modelo=='GM')){
		$sub_titulo = 'Anual ';
	}
	if($modelo=='AN'){
		$sub_titulo = 'Analtico ';
	}

	if($modelo=='SI'){
		$sub_titulo = 'Sinttico ';
	}
	if ($modelo=='SE'){
		$sub_titulo = 'Anual Por Empresa ';
	}

	if($_REQUEST['previsto']=='P'){
		$sub_titulo = 'A Realizar '.$sub_titulo;
	}else{
		$sub_titulo = 'Realizado '.$sub_titulo;
	}

	if($modelo=='OR'){
		$sub_titulo = 'Orado x A Realizar x Realizado';
	}

	set_time_limit(60);


	for($tp_rel=0;$tp_rel<=1;$tp_rel++){

		if($tp_rel==1){
			$tipo_custo = 'DESPESA';

			if($modelo=='OR'){
				$total_acumulado_lista = 0;
				$total_qtd_acumulado = 0;

				$lista_empresas = array();
				$datas = array();

				require('centro_custo_relatorio_funcao_orcado.php');
				require('centro_custo_relatorio_funcao_previsto.php');
				require('centro_custo_relatorio_funcao.php');
			}else{

				if($_REQUEST['previsto']=='P'){
					require('centro_custo_relatorio_funcao_previsto.php');
				}else{
					require('centro_custo_relatorio_funcao.php');
				}
			}
		}


		if(!empty($lista_empresas)){         

			if($tp_rel==0){
				$tem_direto = true;
			}else{
				$tem_indireto = true;
			}

			$teste = 0;
			foreach($lista_empresas as $empresa => $valor_emp){
				$lista_mes = $lista_empresas[$empresa]['meses'];
				$nome_empresa  = $lista_empresas[$empresa]['desc'];
				
				if(($visao=='D') && ( $_REQUEST['empresa'] != '' )){
				   $titulo_sheet = $tipo_custo.' '. $empresa;
				}else if( ($visao=='D') && ( $_REQUEST['empresa'] == '')){				  
					$titulo_sheet = $tipo_custo .' '. $empresa.'-'.$nome_empresa ; //.$lista_empresas[$empresa]['desc'];
				}else{
					$titulo_sheet = $tipo_custo.' '.$lista_empresas[$empresa]['desc'];
				}
				$titulo_sheet = substr($titulo_sheet,0,31);
				
				$teste ++ ;
				$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

				$worksheet1->write_string(0,0,'Relatrio Fluxo de Caixa '.$sub_titulo,$formatot);
				$worksheet1->set_row(1,6);
				$worksheet1->write(2,0,config_pad('sistema_licenca'));
				$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora." - Usurio: ".base64_decode($_REQUEST['USER_ID']));

				$linha_ini = 6;           

				$col = 0;

				if($visao=='C'){
					$txt_visao = 'Centro de Custo';
				}else{
					$txt_visao = 'Conta Gerencial';
				}

				if($modelo!='AN'){
					$worksheet1->set_column($col,$col,70);
					$worksheet1->write_string($linha_ini,$col,$txt_visao,$fmt_cabec_l);
					$col++;

					if (($modelo=='DM') ){
						//$pdf->CabecalhoGrid_Tamanho[$k-1] = 28.7;
						if($anteriores){
							$meses[0] = 'Anteriores';
							//$pdf->CabecalhoGrid_Tamanho[$k-1] = 23.6;
							$worksheet1->set_column($col,$col,16);
							$worksheet1->write_string($linha_ini,$col,$meses[0],$fmt_cabec_c);
							$col++;
						}
						for($i=1;$i<13;$i++){
							$meses[$i] = substr(MesExtenso($colunab[fill_full($i,2)]),0,3);

							$worksheet1->set_column($col,$col,16);
							$worksheet1->write_string($linha_ini,$col,$meses[$i].'/'.$coluna[fill_full($i,2)],$fmt_cabec_c);
							$col++;
						}

						$worksheet1->set_column($col,$col,16);
					}else if( ($modelo=='SE') ){
						//apresenta o titulo de cada capitulo						
						if($anteriores){
							$meses[0] = 'Anteriores';
							$worksheet1->set_column($col,$col,16);
							$worksheet1->write_string($linha_ini,$col,$meses[0],$fmt_cabec_c);
							$col++;
						}
						for($i=1;$i<13;$i++){
							$meses[$i] = substr(MesExtenso($coluna[fill_full($i,2)]),0,3);
							//$meses[$i].'/'. 							
							if( $coluna[fill_full($i,2)] != ''){
								$worksheet1->set_column($col,$col,16);
							}else{
								$worksheet1->set_column($col,$col,16,null, true);
							}
							$worksheet1->write_string($linha_ini,$col,$coluna[fill_full($i,2)],$fmt_cabec_c);
							$col++;
						}
						$worksheet1->set_column($col,$col,16);
					}else{
						$worksheet1->set_column($col,$col,20);
					}
				}else{

					$worksheet1->set_column($col,$col,10);
					$worksheet1->write_string($linha_ini,$col,$txt_visao,$fmt_cabec_l);
					$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 5);
					for($lb=0;$lb < 5;$lb++){
						$col++;
						$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
					}
					$col++;
					$worksheet1->set_column($col,$col,20);
				}


				if($modelo=='OR'){
					//$pdf->CabecalhoGrid_Tamanho[$k-1] = 25;


					$worksheet1->set_column($col,$col,20);
					$worksheet1->write_string($linha_ini,$col,'Orado',$fmt_cabec_r);
					$col++;

					$worksheet1->set_column($col,$col,20);
					$worksheet1->write_string($linha_ini,$col,'A Realizar',$fmt_cabec_r);
					$col++;

					$worksheet1->set_column($col,$col,20);
					$worksheet1->write_string($linha_ini,$col,'Realizado',$fmt_cabec_r);
					$col++;

					$worksheet1->set_column($col,$col,20);
					$worksheet1->write_string($linha_ini,$col,'Saldo',$fmt_cabec_r);
					$col++;

					$worksheet1->set_column($col,$col,20);

				}

				$worksheet1->write_string($linha_ini,$col,'Total',$fmt_cabec_r);
				$col++;               

				//$ncampos = 16;
				$valor = 0;
				$seq = 0;

				$vl_acumulado = 0;

				//total parcial do mes  (de acordo com a qtdade de registros solicitada)
				if($anteriores){
					$total_parc_mes['00'] = 0;
				}
				$total_parc_mes['01'] = 0;
				$total_parc_mes['02'] = 0;
				$total_parc_mes['03'] = 0;
				$total_parc_mes['04'] = 0;
				$total_parc_mes['05'] = 0;
				$total_parc_mes['06'] = 0;
				$total_parc_mes['07'] = 0;
				$total_parc_mes['08'] = 0;
				$total_parc_mes['09'] = 0;
				$total_parc_mes['10'] = 0;
				$total_parc_mes['11'] = 0;
				$total_parc_mes['12'] = 0;
				$total_parc_mes['TT'] = 0;

				$total_parc_mes['O'] = 0;
				$total_parc_mes['P'] = 0;
				$total_parc_mes['R'] = 0;

				$linha_ini++;

				//print_r( $lista_mes);

				foreach($lista_mes as $codigo => $valor){

					set_time_limit(60);

					//$seq++;
					//soma para calcular o total de outros produtos depois
					if($anteriores){
						$total_parc_mes['00']+= $lista_mes[$codigo]['total']['00'];
					}
					$total_parc_mes['01']+= $lista_mes[$codigo]['total']['01'];
					$total_parc_mes['02']+= $lista_mes[$codigo]['total']['02'];
					$total_parc_mes['03']+= $lista_mes[$codigo]['total']['03'];
					$total_parc_mes['04']+= $lista_mes[$codigo]['total']['04'];
					$total_parc_mes['05']+= $lista_mes[$codigo]['total']['05'];
					$total_parc_mes['06']+= $lista_mes[$codigo]['total']['06'];
					$total_parc_mes['07']+= $lista_mes[$codigo]['total']['07'];
					$total_parc_mes['08']+= $lista_mes[$codigo]['total']['08'];
					$total_parc_mes['09']+= $lista_mes[$codigo]['total']['09'];
					$total_parc_mes['10']+= $lista_mes[$codigo]['total']['10'];
					$total_parc_mes['11']+= $lista_mes[$codigo]['total']['11'];
					$total_parc_mes['12']+= $lista_mes[$codigo]['total']['12'];
					$total_parc_mes['TT']+= $lista_mes[$codigo]['total']['TT'];

					$total_parc_mes['O']+= $lista_mes[$codigo]['total']['O'];
					$total_parc_mes['P']+= $lista_mes[$codigo]['total']['P'];
					$total_parc_mes['R']+= $lista_mes[$codigo]['total']['R'];

					//$linha_ini++;

					$col=0;
					//Apresenta  a informao de cada coluna 
					if($modelo!='AN'){
						$worksheet1->write_string($linha_ini,$col,$lista_mes[$codigo]['desc'],$fmt_txt_l_i_b);
						$col++;


						//$pdf->SetFont('Arial','B',$fonte);
						if (($modelo=='DM') || ($modelo=='SE')){
							if($anteriores){
								if($lista_mes[$codigo]['total'][$colunab['00']]>0){
									$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['00']],$fmt_valor_i_b);
									$col++;
								}else{
									$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
									$col++;
								}
							}
							for ($j=1; $j<13; $j++){
								if($j<10){
									$ij= '0'.$j;
								}else{
									$ij = $j;
								}

								//
								//if( $lista_mes[$codigo]['total'][$colunab[$ij]] != '' ){
									if($lista_mes[$codigo]['total'][$colunab[$ij]]>0){
										$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab[$ij]],$fmt_valor_i_b);
										$col++;
									}else{
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
										$col++;
									}

								//
								//}

								
							}

							/** 
							 * apenas testes 
							

							if($lista_mes[$codigo]['total'][$colunab['01']]>0){
								$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['01']],$fmt_valor_i_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}
							
							if($lista_mes[$codigo]['total'][$colunab['02']]>0){
								$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['02']],$fmt_valor_i_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['03']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['03']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['04']]>0){
								$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['04']],$fmt_valor_i_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['05']]>0){
								$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['05']],$fmt_valor_i_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['06']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['06']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['07']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['07']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['08']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['08']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['09']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['09']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['10']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['10']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['11']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['11']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							if($lista_mes[$codigo]['total'][$colunab['12']]>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['12']],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}

							 */
						}

						if($modelo=='OR'){

							//Orcado
							if($lista_mes[$codigo]['total']['O']>0){
								$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['O'],$fmt_valor_i_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}
							//Previsto
							if($lista_mes[$codigo]['total']['P']>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['P'],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}
							//Realizado
							if($lista_mes[$codigo]['total']['R']>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['R'],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}
							//Saldo
							$saldo = $lista_mes[$codigo]['total']['O'] - $lista_mes[$codigo]['total']['P'] - $lista_mes[$codigo]['total']['R'];
							if(($saldo<0.001)&&($saldo>(-0.001))){
							    $saldo = 0;
							}
							if($saldo<=0){
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}else{
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['P'],$fmt_valor_i_b);
							    $col++;
							}
							//Total
							$total = $lista_mes[$codigo]['total']['P'] + $lista_mes[$codigo]['total']['R'];
							$worksheet1->write_number($linha_ini,$col,$total,$fmt_valor_i_b);
							$col++;

						}else{
							//Total
							if($lista_mes[$codigo]['total']['TT']>0){
							    $worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['TT'],$fmt_valor_i_b);
							    $col++;
							}else{
							    $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							    $col++;
							}
						}
                    
					}else{ //modelo AN
						$worksheet1->write_string($linha_ini,$col,$lista_mes[$codigo]['desc'],$fmt_txt_l_i_b);
						$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 5);
						for($lb=0;$lb < 5;$lb++){
							$col++;
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
						}
						$col++;

						if($lista_mes[$codigo]['total']['TT']>0){
							$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total']['TT'],$fmt_valor_i_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}
					}
					$linha_ini++;

					$filhos = $lista_mes[$codigo]['filhos'];
					//if($nivel_max==1){
					//   $filhos = array();
					//}
					//$filhos = array();
					foreach($filhos as $cod_filho => $valorf){

						set_time_limit(60);

						if($lista_mes[$codigo]['exibe_f']){

							if($nivel_max!=1){
								//$pdf->SetFont('Arial','',$fonte);
								if($modelo=='AN'){
									//$pdf->SetAutoPageBreak(true,100);
								}
								//$linha_ini++;
								if($filtrado){
									$linha_ini++;
								}
								$col=0;
								if($modelo!='AN'){
									$worksheet1->write_string($linha_ini,$col,$filhos[$cod_filho]['desc'],$fmt_txt_l);
									$col++;
									if (($modelo=='DM') || ($modelo=='SE')){
										if($anteriores){
											if($filhos[$cod_filho]['total'][$colunab['00']]>0){
											   $worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['00']],$fmt_valor);
											   $col++;
											}else{
											   $worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											   $col++;
											}
										}


										for ($j=1; $j<13; $j++){
											if($j<10){
												$ij= '0'.$j;
											}else{
												$ij = $j;
											}
			
											//
											//if( $lista_mes[$codigo]['total'][$colunab[$ij]] != '' ){


												if($filhos[$cod_filho]['total'][$colunab[$ij]]>0){
													$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab[$ij]],$fmt_valor);
													$col++;
												}else{
													$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
													$col++;
												}
		
												// if($lista_mes[$codigo]['total'][$colunab['01']]>0){
												// 	$worksheet1->write_number($linha_ini,$col,$lista_mes[$codigo]['total'][$colunab['01']],$fmt_valor_i_b);
												// 	$col++;
												// }else{
												// 	$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
												// 	$col++;
												// }
			
											//
											//}
			
											
										}

										/**
										 * Apenas para testes 
										

										if($filhos[$cod_filho]['total'][$colunab['01']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['01']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['02']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['02']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['03']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['03']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['04']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['04']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['05']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['05']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['06']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['06']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['07']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['07']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['08']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['08']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['09']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['09']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['10']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['10']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['11']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['11']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($filhos[$cod_filho]['total'][$colunab['12']]>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total'][$colunab['12']],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										 */
									}

									if($modelo=='OR'){

										//Orado
										if($filhos[$cod_filho]['total']['O']>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total']['O'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Previsto
										if($filhos[$cod_filho]['total']['P']>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total']['P'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Realizado
										if($filhos[$cod_filho]['total']['R']>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total']['R'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Saldo
										$saldo = $filhos[$cod_filho]['total']['O'] - $filhos[$cod_filho]['total']['P'] - $filhos[$cod_filho]['total']['R'];
										if(($saldo<0.001)&&($saldo>(-0.001))){
											$saldo = 0;
										}
										if($saldo<=0){
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}else{
											$worksheet1->write_number($linha_ini,$col,$saldo,$fmt_valor_i);
											$col++;
										}


										//Total
										$total = $filhos[$cod_filho]['total']['P'] + $filhos[$cod_filho]['total']['R'];
										$worksheet1->write_number($linha_ini,$col,$total,$fmt_valor_i);
										$col++;


									}else{
										//Total
										if($filhos[$cod_filho]['total']['TT']>0){
											$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total']['TT'],$fmt_valor);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}
									}

								}else{ //modelo AN
									$worksheet1->write_string($linha_ini,$col,$filhos[$cod_filho]['desc'],$fmt_txt_l);
									$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 5);
									for($lb=0;$lb < 5;$lb++){
										$col++;
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
									}
									$col++;

									if($filhos[$cod_filho]['total']['TT']>0){
										$worksheet1->write_number($linha_ini,$col,$filhos[$cod_filho]['total']['TT'],$fmt_valor);
										$col++;
									}else{
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
										$col++;
									}
								}
								//$ncampos = $k;

								//$lns = $lns * $tam_pula_linha;
								//if($filtrado){
								//   $linha_ini++;
								//}else{
								//   $topo = 0;
								//}
							}                        
							$linha_ini++;                        
						}

						if($filtrado){
							$empresas = $filhos[$cod_filho]['empresas'];
							//$filhos = array();
							foreach($empresas as $cod_empresa => $valore){
								set_time_limit(60);
								//$pdf->SetFont('Arial','I',$fonte);

								//$linha_ini++;

								//Codigo pessoa
								$col=0;

								if($modelo!='AN'){
									$worksheet1->write_string($linha_ini,$col,$empresas[$cod_empresa]['desc'],$fmt_txt_l_i);
									$col++;


									if (($modelo=='DM') || ($modelo=='SE')){
										if($anteriores){
											if($empresas[$cod_empresa]['total'][$colunab['00']]>0){
												$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['00']],$fmt_valor_i);
												$col++;
											}else{
												$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
												$col++;
											}
										}

										for ($j=1; $j<13; $j++){
											if($j<10){
												$ij= '0'.$j;
											}else{
												$ij = $j;
											}
											//if( $empresas[$cod_empresa]['total'][$colunab[$ij]] != ''){
												if($empresas[$cod_empresa]['total'][$colunab[$ij]]>0){
													$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab[$ij]],$fmt_valor_i);
													$col++;
												}else{
													$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
													$col++;
												}
											//}
										}

										/**
										 * Apenas em teste 
										

										if($empresas[$cod_empresa]['total'][$colunab['01']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['01']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['02']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['02']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['03']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['03']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['04']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['04']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['05']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['05']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['06']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['06']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['07']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['07']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['08']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['08']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['09']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['09']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['10']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['10']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['11']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['11']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										if($empresas[$cod_empresa]['total'][$colunab['12']]>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab['12']],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										 */

									}

									if($modelo=='OR'){
										//Orado
										if($empresas[$cod_empresa]['total']['O']>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total']['O'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Previsto
										if($empresas[$cod_empresa]['total']['P']>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total']['P'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Realizado
										if($empresas[$cod_empresa]['total']['R']>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total']['R'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}

										//Saldo
										$saldo = $empresas[$cod_empresa]['total']['O'] - $empresas[$cod_empresa]['total']['P'] - $empresas[$cod_empresa]['total']['R'];
										if(($saldo<0.001)&&($saldo>(-0.001))){
											$saldo = 0;
										}
										if($saldo<=0){
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}else{
											$worksheet1->write_number($linha_ini,$col,$saldo,$fmt_valor_i);
											$col++;
										}

										//Total
										$total = $empresas[$cod_empresa]['total']['P'] + $empresas[$cod_empresa]['total']['R'];
										$worksheet1->write_number($linha_ini,$col,$total,$fmt_valor_i);
										$col++;
									}else{
										//Total
										if($empresas[$cod_empresa]['total']['TT']>0){
											$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total']['TT'],$fmt_valor_i);
											$col++;
										}else{
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
											$col++;
										}
									}
								}else{ //modelo AN
									$worksheet1->write_string($linha_ini,$col,$empresas[$cod_empresa]['desc'],$fmt_txt_l_i);
									$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 5);
									for($lb=0;$lb < 5;$lb++){
										$col++;
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
									}
									$col++;

									if($empresas[$cod_empresa]['total']['TT']>0){
										$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total']['TT'],$fmt_valor_i);
										$col++;
									}else{
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
										$col++;
									}
								}
								$linha_ini++;
								//$ncampos = $k;
								//$lns = $lns * $tam_pula_linha;
								if($modelo=='AN'){
									$col=0;

									$worksheet1->write_string($linha_ini,$col,'Data',$fmt_txt_l_i_b);
									$col++;

									$worksheet1->write_string($linha_ini,$col,'Histrico',$fmt_txt_l_i_b);
									$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 4);
									for($lb=0;$lb < 4;$lb++){
										$col++;
										$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
									}
									$col++;

									$worksheet1->write_string($linha_ini,$col,'Valor',$fmt_txt_l_i_b);
									$col++;

									$linha_ini++;

									$detalhes = $empresas[$cod_empresa]['regs'];
									//$filhos = array();
									$nr_seq = 0;
									foreach($detalhes as $cod_det => $valord){

										$col=0;

										$nr_seq++;
										//$pdf->SetFillColor(255,255,255);
										//$fundo = 0;
										//if(($nr_seq%2)==0){
										//   $fundo = 1;
										//   $pdf->SetFillColor(220,220,220);
										//}


										$worksheet1->write_string($linha_ini,$col,dataf($detalhes[$cod_det]['Data']),$fmt_data_i);
										$col++;

										$worksheet1->write_string($linha_ini,$col,$detalhes[$cod_det]['Historico'],$fmt_txt_l_i);
										$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 4);
										for($lb=0;$lb < 4;$lb++){
											$col++;
											$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
										}
										$col++;
                                 
										$worksheet1->write_number($linha_ini,$col,$detalhes[$cod_det]['Valor'],$fmt_valor_i);
										$col++;

                                 
										$linha_ini++;
									}
								}
								$linha_ini++;
							}
						}else if($modelo=='AN'){
                        
							$col=0;
							
							$worksheet1->write_string($linha_ini,$col,'Data',$fmt_txt_l_i_b);
							$col++;
							
							$worksheet1->write_string($linha_ini,$col,'Histrico',$fmt_txt_l_i_b);
							$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 4);
							for($lb=0;$lb < 4;$lb++){
								$col++;
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
							}
							$col++;
							
							$worksheet1->write_string($linha_ini,$col,'Valor',$fmt_txt_l_i_b);
							$col++;
							
							$linha_ini++;

							$detalhes = $filhos[$cod_filho]['regs'];
							//$filhos = array();
							$nr_seq = 0;
							foreach($detalhes as $cod_det => $valord){
								$col=0;                           
								$nr_seq++;
								//$pdf->SetFillColor(255,255,255);
								//$fundo = 0;
								//if(($nr_seq%2)==0){
								//   $fundo = 1;
								//   $pdf->SetFillColor(220,220,220);
								//}                           

								$worksheet1->write_string($linha_ini,$col,dataf($detalhes[$cod_det]['Data']),$fmt_data_i);
								$col++;

								$worksheet1->write_string($linha_ini,$col,$detalhes[$cod_det]['Historico'],$fmt_txt_l_i);
								$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 4);
								for($lb=0;$lb < 4;$lb++){
									$col++;
									$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
								}
								$col++;

								$worksheet1->write_number($linha_ini,$col,$detalhes[$cod_det]['Valor'],$fmt_valor_i);
								$col++;
                          
								$linha_ini++;
							}                        
							$linha_ini++;
						}
					}
				}

				set_time_limit(60);              

				$col=0;
				if($modelo!='AN'){
					$worksheet1->write_string($linha_ini,$col,' TOTAL '.$tipo_custo,$fmt_txt_l_b);
					$col++;

					if (($modelo=='DM') || ($modelo=='SE')){

						if($anteriores){
							if($total_parc_mes[$colunab['00']]>0){
								$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['00']],$fmt_valor_b);
								$col++;
							}else{
								$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
								$col++;
							}
						}

						for ($j=1; $j<13; $j++){
							if($j<10){
								$ij= '0'.$j;
							}else{
								$ij = $j;
							}

							// if($empresas[$cod_empresa]['total'][$colunab[$ij]]>0){
							// 	$worksheet1->write_number($linha_ini,$col,$empresas[$cod_empresa]['total'][$colunab[$ij]],$fmt_valor_i);
							// 	$col++;
							// }else{
							// 	$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							// 	$col++;
							// }

							//if( $total_parc_mes[$colunab[$ij]] != ''){
								if($total_parc_mes[$colunab[$ij]]>0){
									$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab[$ij]],$fmt_valor_b);
									$col++;
								}else{
									$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
									$col++;
								}

							//}

							

						}

						/**
						 * Apenas em teste 
						
						if($total_parc_mes[$colunab['01']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['01']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['02']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['02']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['03']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['03']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['04']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['04']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['05']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['05']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['06']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['06']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['07']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['07']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['08']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['08']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['09']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['09']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['10']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['10']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['11']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['11']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						if($total_parc_mes[$colunab['12']]>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes[$colunab['12']],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}
						*/
					}

					if($modelo=='OR'){

						//Orcado
						if($total_parc_mes['O']>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes['O'],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						//Previsto
						if($total_parc_mes['P']>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes['P'],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}

						//Realizado
						if($total_parc_mes['R']>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes['R'],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}


						//saldo
						$saldo = $total_parc_mes['O'] - $total_parc_mes['P'] - $total_parc_mes['R'];
						if(($saldo<0.001)&&($saldo>(-0.001))){
							$saldo = 0;
						}
						if($saldo<=0){
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}else{
							$worksheet1->write_number($linha_ini,$col,$saldo,$fmt_valor_b);
							$col++;
						}

						//Total
						$total = $total_parc_mes['P'] + $total_parc_mes['R'];
						$worksheet1->write_number($linha_ini,$col,$total,$fmt_valor_b);
						$col++;

					}else{
						//Total
						if($total_parc_mes['TT']>0){
							$worksheet1->write_number($linha_ini,$col,$total_parc_mes['TT'],$fmt_valor_b);
							$col++;
						}else{
							$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
							$col++;
						}
					}
                  
				}else{ //modelo AN
					$worksheet1->write_string($linha_ini,$col,'TOTAL '.$tipo_custo,$fmt_txt_l_b);
					$worksheet1->merge_cells($linha_ini, $col, $linha_ini, $col + 5);
					for($lb=0;$lb < 5;$lb++){
						$col++;
						$worksheet1->write_blank($linha_ini,$col,$fmt_txt_c); //acertar bordas
					}
					$col++;

					if($total_parc_mes['TT']>0){
						$worksheet1->write_number($linha_ini,$col,$total_parc_mes['TT'],$fmt_valor_b);
						$col++;
					}else{
						$worksheet1->write_blank($linha_ini,$col,$fmt_txt_r);
						$col++;
					}
				}
				$linha_ini++; 
			}//for empresa
		} 
	}

    if((!$tem_direto) && (!$tem_indireto)){
		$worksheet1->write_string(0,0,'Relatrio Fluxo de Caixa '.$sub_titulo,$formatot);
		$worksheet1->set_row(1,6);
		$worksheet1->write(2,0,config_pad('sistema_licenca'));
		$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora." - Usurio: ".base64_decode($_REQUEST['USER_ID']));
		$worksheet1->write(6,0,"No existem registros para este filtro!");
    }

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();

?>