<?php
	class Relatorio {
		private $relCaminho;
		private $arraySessionCRM;

		function __construct($relCaminho){
			session_name('SIMPLES_CRM');
			session_start();

			$this->relCaminho = $relCaminho; // Caminho do $IMPLES WEB em que se encontra o relatório
			$this->arraySessionCRM = $_SESSION; // Armazena session do CRM para voltar depois
		}

		public function imprimir(){
			$this->validarSession();
			$this->montarSession();
			$this->montarRequest();

			require_once($this->relCaminho);
		}

		public function voltarSession(){
			// Voltar session do CRM
			$_SESSION = $this->arraySessionCRM;
		}

		private function validarSession(){
			if(!isset($_SESSION['USER_ID'])){
				exit('Session inválida!');
			}
		}

		private function montarSession(){
			// Limpar session do CRM
			$_SESSION = array();

			$_SESSION['Dominio'] = $this->arraySessionCRM['Dominio'];
			$_SESSION['Empresa_Codigo'] = $this->arraySessionCRM['Empresa_Codigo'];
			$_SESSION['USER_ID'] = base64_encode($this->arraySessionCRM['USER_ID']);
			$_SESSION['CRM_REL'] = true;
		}

		private function montarRequest(){
			$_REQUEST['USER_ID'] = $_SESSION['USER_ID'];
			foreach($_GET as $chave => $valor){
				$_REQUEST[$chave] = $valor;
			}
		}

		/* function __destruct(){
		$this->voltarSession();
		} */
	}

	if(!isset($_GET['rel'])){
		exit('Relatório indefinido!');
	}

	function voltarSession($relatorio){
		$relatorio->voltarSession();
	}

	$relCaminho = base64_decode($_GET['rel']);

	$relatorio = new Relatorio($relCaminho);
	register_shutdown_function('voltarSession', $relatorio);
	$relatorio->imprimir();
?>