<?
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	// HTTP headers
	HeaderingExcel('PIS_COFINS_CUPOM.xls');

	// Creating a workbook
	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'CUPOM_PIS_COFINS';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE CUPONS COM PIS/COFINS',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$consulta_ecf = 'select Empresa, NrFab, LetraMF, DT_Emissao, COO, SubTotal, '.
					' Desconto, Acrescimo, Pessoa_Nome '.
					' from ecf_cupom '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Cancelado = "N" '.
					' and DT_Emissao >= "'.datad($_REQUEST['dt_ini']).'"'.
					' and DT_Emissao <= "'.datad($_REQUEST['dt_fim']).'"';

	$filtro =	'Perodo: De "'.$_REQUEST['dt_ini'].'"'.
				' At "'.$_REQUEST['dt_fim'].'"';

	if($_REQUEST['empresa']!=''){
		$consulta_ecf.= ' and Empresa = "'.$_REQUEST['empresa'].'"';
		$con_empre = 'Select Nome_Listas from pessoa '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empre = consulta_sql($con_empre);
		$reg_empre = consulta_ler_linha($res_empre);
		consulta_limpa($res_empre);
		$filtro.=' Empresa: '.$reg_empre[0];
	}else{
		$filtro.=' Empresa: Todas as Empresas';
	}

	if($_REQUEST['pessoa']!=''){
		$consulta_ecf.= ' and Pessoa ="'.$_REQUEST['pessoa'].'"';

		$filtro.= ' Pessoa "'.$_REQUEST['pessoa'].'"';
	}

	$consulta_ecf.= ' order by Empresa, DT_Emissao, COO ';

	$worksheet1->write(8,0,"Filtro: ".$filtro);
	//$worksheet1->insert_bitmap(9,0,"../../imgs/logo_menu.bmp",0,0);

	// Format cabecalho
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatottl =& $workbook->add_format();
	$formatottl->set_align('left');
	$formatottl->set_pattern();
	$formatottl->set_fg_color(40);
	$formatottl->set_bold(1);
	$formatottl->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	$formatotr =& $workbook->add_format();
	$formatotr->set_border(1);
	$formatotr->set_align('right');

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Formato para quantidades
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('[Blue]#,##0_);[Red]-#,##0_)');

	// Formato para precos
	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	//negritos
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_bold(1);
	$formatotlb->set_align('left');

	$formatotbpreco =& $workbook->add_format();
	$formatotbpreco->set_border(1);
	$formatotbpreco->set_align('right');
	$formatotbpreco->set_bold(1);
	$formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotqtdb =& $workbook->add_format();
	$formatotqtdb->set_border(1);
	$formatotqtdb->set_align('right');
	$formatotqtdb->set_size(10);
	$formatotqtdb->set_bold(1);
	$formatotqtdb->set_num_format('#,##0_);-#,##0_)');

	$resultado_ecf = consulta_sql($consulta_ecf);
	$nrows = consulta_num_registros($resultado_ecf);

	if($_REQUEST['pessoa']!=''){
		$con_pessoa='Select Nome_Listas from pessoa '.
					' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					' and Pessoa = "'.$_REQUEST['pessoa'].'"';
		$res_pessoa = consulta_sql($con_pessoa);
		$reg_pessoa = consulta_ler_linha($res_pessoa);
		consulta_limpa($res_pessoa);
		$worksheet1->write_string(10,0,'Pessoa: '.$_REQUEST['pessoa'].'-'.$reg_pessoa[0],$formatost);
	}

	if($_REQUEST['pessoa']!=''){
		$linha_ini = 12;
	}else{
		$linha_ini = 11;
	}

	if ($nrows>0){
		$coluna=0;

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Empresa',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Nr Doc',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'Dt Emisso',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,40);
		$worksheet1->write_string($linha_ini,$coluna,'Pessoa',$formatottl);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,18);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Cupom',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,18);
		$worksheet1->write_string($linha_ini,$coluna,'Base Clc.',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,18);
		$worksheet1->write_string($linha_ini,$coluna,'Valor PIS',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,18);
		$worksheet1->write_string($linha_ini,$coluna,'Valor COFINS',$formatott);
		$coluna++;

		$linha_ini++;
		$qtd_ecf = 0;

		$valor_total_nf = 0;
		$valor_total_retido = 0;
		$valor_total_retido2 = 0;
		$valor_total_bc = 0;
		$emp_atual = '';

		for($i=0;$i<$nrows;$i++){
			$reg = consulta_ler_objeto($resultado_ecf);
			set_time_limit(60);

			if($emp_atual != $reg->Empresa){
				$impostos = impostos_produto($reg->Empresa);

				$tipo[0] = '';
				$con_tipo = 'select Empresa, NrFab, LetraMF, NrCaixa  '.
							' from ecf '.
							' where Dominio="'.$_SESSION["Dominio"].'"';
				$res_tipo = consulta_sql($con_tipo);
				$nrw_tipo = consulta_num_registros($res_tipo);
				for($t=0;$t<$nrw_tipo;$t++){
					$reg_tipo = consulta_ler_linha($res_tipo);
					$tipo[$reg_tipo[0].'_'.$reg_tipo[1].'_'.$reg_tipo[2]] = $reg_tipo[3];
				}
				consulta_limpa($res_tipo);

				$emp_atual = $reg->Empresa;
			}

			$ok_linha = true;
			$ok_line = false;
			if($ok_linha){
				//consulta funcao desconto
				$vl_seq = cupom_fiscal_calcula_desc_acre_proporcional($reg->Empresa,$reg->NrFab,$reg->DT_Emissao,$reg->COO,0,0);

				//inicializar variavel
				$tot_pis = 0;
				$tot_cofins = 0;
				$tot_calculo = 0;

				//consultar o item
				$cons_item ='select ValorTotal, Id_Produto, Seq_Item, TributoCod '.
							' from ecf_cupom_item '.
							' where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Empresa = "'.$reg->Empresa.'"'.
							' and NrFab = "'.$reg->NrFab.'"'.
							' and LetraMF = "'.$reg->LetraMF.'"'.
							' and DT_Emissao = "'.$reg->DT_Emissao.'"'.
							' and COO = "'.$reg->COO.'"'.
							' and Cancelado = "N" ';
				$res_item = consulta_sql($cons_item);
				$nrw_item = consulta_num_registros($res_item);

				for($n=0;$n<$nrw_item;$n++){
					$reg_item = consulta_ler_objeto($res_item);

					$con_pro = 'select * from produto '.
							   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Id_Produto="'.$reg_item->Id_Produto.'"';
					$res_pro = consulta_sql($con_pro);
					$reg_pro = consulta_ler_objeto($res_pro);
					consulta_limpa($res_pro);

					$aliq_pis = 0;
					if(isset($impostos['pis'][$reg_pro->Codigo_Classe_Tributo])){
						$aliq_pis = $impostos['pis'][$reg_pro->Codigo_Classe_Tributo];
					}
					$aliq_cofins = 0;
					if(isset($impostos['cofins'][$reg_pro->Codigo_Classe_Tributo])){
						$aliq_cofins = $impostos['cofins'][$reg_pro->Codigo_Classe_Tributo];
					}

					$vl_pis = 0;
					$vl_cofins = 0;

					if(($aliq_pis>0)||($aliq_cofins>0)){
						$aliq_icms = $reg_item->TributoCod.'0000000';
						if ($aliq_icms!=''){
							if ($aliq_icms[0]=='T'){
								$aliq_icms = (substr($aliq_icms,1,4)/100);
							}else if ($aliq_icms[2]=='T'){
								$aliq_icms = (substr($aliq_icms,3,4)/100);
							}else{
								$aliq_icms = 0;
							}
						}else{
							$aliq_icms = 0;
						}
						$ok_line = true;
						$vl_calculo = round($reg_item->ValorTotal - $vl_seq[$reg_item->Seq_Item]['d'],2);
						$valor_icms = round($vl_calculo * $aliq_icms/100,2);
						$vl_calculo = calcula_base_pisconfis($vl_calculo,$reg->DT_Emissao,$valor_icms,$reg->Empresa,'P');
						if($aliq_pis>0){
							$vl_pis = arredonda_numero_menos($aliq_pis * $vl_calculo)/100;
						}
						if($aliq_cofins>0){
							$vl_cofins = arredonda_numero_menos($aliq_cofins * $vl_calculo)/100;
						}

						$tot_pis+= $vl_pis;
						$tot_cofins+= $vl_cofins;
						$tot_calculo+= $vl_calculo;
					}
				}

				if($ok_line){
					$qtd_ecf++;
					$caixa = 1;

					if(isset($tipo[$reg->Empresa.'_'.$reg->NrFab.'_'.$reg->LetraMF])){
						$caixa = $tipo[$reg->Empresa.'_'.$reg->NrFab.'_'.$reg->LetraMF];
					}

					$coluna = 0;

					$con_empre ='Select Nome_Listas from pessoa '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$reg->Empresa.'"';
					$res_empre = consulta_sql($con_empre);
					$reg_empre = consulta_ler_linha($res_empre);
					consulta_limpa($res_empre);

					$worksheet1->write_string($linha_ini,$coluna,$reg_empre[0],$formatotl);
					$coluna++;

					$worksheet1->write_string($linha_ini,$coluna,$reg->COO.'/'.$caixa.'-2D',$formatotc);
					$coluna++;

					$worksheet1->write_string($linha_ini,$coluna,dataf($reg->DT_Emissao),$formatotc);
					$coluna++;

					$desc_pessoa = $reg->Pessoa_Nome;
					$worksheet1->write_string($linha_ini,$coluna,$desc_pessoa,$formatotl);
					$coluna++;

					$tot_nf = ($reg->SubTotal - $reg->Desconto) + $reg->Acrescimo;
					$worksheet1->write_number($linha_ini,$coluna,$tot_nf,$formatotpreco);
					$coluna++;

					$worksheet1->write_number($linha_ini,$coluna,$tot_calculo,$formatotpreco);
					$coluna++;

					$worksheet1->write_number($linha_ini,$coluna,$tot_pis,$formatotpreco);
					$coluna++;

					$worksheet1->write_number($linha_ini,$coluna,$tot_cofins,$formatotpreco);
					$coluna++;

					$linha_ini++;

					$valor_total_nf+= $tot_nf;
					$valor_total_retido+= $tot_pis;
					$valor_total_retido2+= $tot_cofins;
					$valor_total_bc+= $tot_calculo;
				}
			}
		}

		if($qtd_ecf>0){
			$coluna=0;
			$worksheet1->write_string($linha_ini,$coluna,'TOTAL : '.$qtd_ecf.' cupom(s) fiscal(is)',$formatotlb);
			$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+2);
			for($t=0;$t<=2;$t++){
				$coluna++;
				$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
			}

			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$valor_total_nf,$formatotbpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$valor_total_bc,$formatotbpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$valor_total_retido,$formatotbpreco);
			$coluna++;

			$worksheet1->write_number($linha_ini,$coluna,$valor_total_retido2,$formatotbpreco);
			$coluna++;
		}

	}else{
		$worksheet1->write(10,0,"No existem registros para este filtro!");
	}
	consulta_limpa($resultado_ecf);
	$workbook->close();
?>