<?
    require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
    session::usr_conectado($_REQUEST['USER_ID']);
    require_once('../../includes/write_excel/Worksheet.php');
    require_once('../../includes/write_excel/Workbook.php');
    require_once('../../includes/funcoes/boletim_pesagem.php');

    function HeaderingExcel($filename) {
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=$filename" );
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
        header("Pragma: public");
    }


    $hora = nr2hora(hora_atual());
    $hoje = data_atual('data');

    // HTTP headers
    HeaderingExcel('COMPRA_GMO.xls');

    // Creating a workbook
    $workbook = new Workbook("-");
    // Format for the headings
    $formatot =& $workbook->add_format();
    $formatot->set_size(18);

    $empresa = $_REQUEST['empresa'];
    $fornec = $_REQUEST['fornec'];
    $produto = $_REQUEST['produto'];
    $dt_ini = datad($_REQUEST['dt_ini']);
    $dt_fim = datad($_REQUEST['dt_fim']).' 23:59:59';
    $dt_ini_filtro = $_REQUEST['dt_ini'];
    $dt_fim_filtro = $_REQUEST['dt_fim'];
    $tipo = $_REQUEST['tipo'];


    $titulo_sheet = 'Compra GMO';
    $worksheetr =& $workbook->add_worksheet($titulo_sheet);

    // Format cabecalho
    $formatott =& $workbook->add_format();
    $formatott->set_align('center');
    $formatott->set_pattern();
    $formatott->set_fg_color(40);
    $formatott->set_bold(1);
    $formatott->set_border(1);

    $formatottl =& $workbook->add_format();
    $formatottl->set_align('left');
    $formatottl->set_bold(1);
    $formatottl->set_border(1);


    // Format for the headings
    $formatotl =& $workbook->add_format();
    $formatotl->set_border(1);
    $formatotl->set_align('left');

    $formatotr =& $workbook->add_format();
    $formatotr->set_border(1);
    $formatotr->set_align('right');

    // Format for the headings
    $formatotc =& $workbook->add_format();
    $formatotc->set_border(1);
    $formatotc->set_align('center');

    // Formato para quantidades
    $formatotqtd =& $workbook->add_format();
    $formatotqtd->set_border(1);
    $formatotqtd->set_align('right');
    $formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

    // Formato para quantidades
    $formatotqtd_azul =& $workbook->add_format();
    $formatotqtd_azul->set_border(1);
    $formatotqtd_azul->set_align('right');
    $formatotqtd_azul->set_num_format('#,##0.0##_);-#,##0.0##_)');
    $formatotqtd_azul->set_color('blue');

    // Formato para quantidades
    $formatotqtd_verm =& $workbook->add_format();
    $formatotqtd_verm->set_border(1);
    $formatotqtd_verm->set_align('right');
    $formatotqtd_verm->set_num_format('#,##0.0##_);-#,##0.0##_)');
    $formatotqtd_verm->set_color('red');

    $formatotqtd2 =& $workbook->add_format();
    $formatotqtd2->set_border(1);
    $formatotqtd2->set_align('right');
    $formatotqtd2->set_num_format('#,##0_);-#,##0_)');

    // Formato para precos
    $formatotpreco =& $workbook->add_format();
    $formatotpreco->set_border(1);
    $formatotpreco->set_align('right');
    $formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

    //negritos
    $formatotlb =& $workbook->add_format();
    $formatotlb->set_border(1);
    $formatotlb->set_bold(1);
    $formatotlb->set_align('left');

    $formatotbpreco =& $workbook->add_format();
    $formatotbpreco->set_border(1);
    $formatotbpreco->set_align('right');
    $formatotbpreco->set_bold(1);
    $formatotbpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

    $formatotqtdb =& $workbook->add_format();
    $formatotqtdb->set_border(1);
    $formatotqtdb->set_align('right');
    $formatotqtdb->set_size(10);
    $formatotqtdb->set_bold(1);
    $formatotqtdb->set_num_format('#,##0.0##_);-#,##0.0##_)');

    $formatotqtdb_azul =& $workbook->add_format();
    $formatotqtdb_azul->set_border(1);
    $formatotqtdb_azul->set_align('right');
    $formatotqtdb_azul->set_size(10);
    $formatotqtdb_azul->set_bold(1);
    $formatotqtdb_azul->set_num_format('#,##0.0##_);-#,##0.0##_)');
    $formatotqtdb_azul->set_color('blue');

    $formatotqtdb_verm =& $workbook->add_format();
    $formatotqtdb_verm->set_border(1);
    $formatotqtdb_verm->set_align('right');
    $formatotqtdb_verm->set_size(10);
    $formatotqtdb_verm->set_bold(1);
    $formatotqtdb_verm->set_num_format('#,##0.0##_);-#,##0.0##_)');
    $formatotqtdb_verm->set_color('red');

    $formatotqtdb2 =& $workbook->add_format();
    $formatotqtdb2->set_border(1);
    $formatotqtdb2->set_align('right');
    $formatotqtdb2->set_size(10);
    $formatotqtdb2->set_bold(1);
    $formatotqtdb2->set_num_format('#,##0_);-#,##0_)');


    if($tipo=='C'){
		$consulta = 'select n.Nr_Nota, '.
                   ' n.DH_EntSai, '.
                   ' n.Nr_Contrato, '.
                   ' n.Nr_Boletim_Pesagem, '.
                   ' n.Empresa, '.
                   ' nfi.Seq_Item, '.
                   ' nfi.Id_Produto, '.
                   ' nfi.Quantidade_Estoque, '.
                   ' nfi.Valor_Unitario, '.
                   ' nfi.Valor_Total, '.
                   ' n.Destinatario, '.
                   ' n.NrDoc, n.Serie, n.Modelo '.
                   ' from nota_fiscal n '.
                   ' inner join nota_fiscal_item nfi on '.
                   ' n.Dominio = nfi.Dominio '.
                   ' and n.Empresa = nfi.Empresa '.
                   ' and n.Nr_Nota = nfi.Nr_Nota '.
                   ' Where n.Dominio = "'.$_SESSION['Dominio'].'"'.
                   ' and n.DH_EntSai >= "'.$dt_ini.'" '.
                   ' and n.DH_EntSai <= "'.$dt_fim.'" '.
                   ' and nfi.Id_Produto = "'.$produto.'" '.
                   ' and n.Nat_Op_Gera_Contas = "P" '.
                   ' and n.TipoES = "0"'.
                   ' and n.Situacao = "F"'.
                   ' and n.Nr_Boletim_Pesagem>0';

		$filtro = '';

		if ($empresa != '') {
			$consulta.=' and n.Empresa = "'.$empresa.'"';
			$con_empre = 'select Pessoa, Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					   ' and Pessoa = "'.$empresa.'" '.
					   ' and Situacao <> "E" '.
					   ' order by Nome_Listas';
			$res_empre = consulta_sql($con_empre);
			$reg_empre = consulta_ler_linha($res_empre);
			consulta_limpa($res_empre);
			$filtro.= ' Empresa: "'.$empresa.'-'.$reg_empre[1].'"';
		}

		if($fornec > 0){
			$consulta.= ' and n.Destinatario = "'.$fornec.'"';
			$con_pess = 'select Pessoa, Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					   ' and Pessoa = "'.$fornec.'" '.
					   ' and Situacao <> "E" ';
			$res_pess = consulta_sql($con_pess);
			$reg_pess = consulta_ler_linha($res_pess);
			consulta_limpa($res_pess);
			$filtro.= ' Fornecedor: "'.$fornec.'-'.$reg_pess[1].'"';
		}

		if($produto!=''){
			$con_prod = 'select Codigo_Produto, Descricao_Curta, Descricao_Completa, Retencao_Tecnica from produto '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Id_Produto = "'.$produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);
			$prod = $reg_prod[0].'-'.$reg_prod[1];
			$filtro.= ' Produto: "'.$reg_prod[0].'-'.$reg_prod[1].'"';
		}

		$consulta.= ' order by n.DH_EntSai, n.Nr_Nota, nfi.Seq_Item';


		// Format for the headings
		$formatot =& $workbook->add_format();
		$formatot->set_size(18);

		$formatost =& $workbook->add_format();
		$formatost->set_size(12);

		$worksheetr->write_string(1,0,'Relatrio de Compra de GMO',$formatot);
		$worksheetr->write(2,0,config_pad('sistema_licenca'));
		$worksheetr->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
		$worksheetr->write(4,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

		$worksheetr->write_string(6,0,'Perodo: De '.$dt_ini_filtro.' At '.$dt_fim_filtro);
		$worksheetr->write(7,0,"Filtro: ".$filtro);


		$resultado = consulta_sql($consulta);
		$nrows = consulta_num_registros($resultado);

		$linha_ini = 9;
		$total_geral = 0;
		$total_intacta = 0;
		$total_positiva = 0;
		$total_negativa = 0;

		$valor_total_geral = 0;
		$valor_total_intacta = 0;


		if ($nrows>0){

			$coluna =0;
			$primeira_linha = $linha_ini;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Produto',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Total Recebido',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd PATENTE Declarada',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Testada Positiva',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Testada Negativa',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'PATENTE Total',$formatottl);
			$linha_ini++;

			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Valor Total de Compra',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Valor Total de PATENTE',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'% de PATENTE',$formatottl);
			$linha_ini++;

			$linha_ini++;

			//cria aba detalhamento
			$titulo_sheet2 = 'DETALHES';
			$worksheet2 =& $workbook->add_worksheet($titulo_sheet2);

			$worksheet2->write_string(1,0,'Relatrio de Compra de GMO',$formatot);
			$worksheet2->write(2,0,config_pad('sistema_licenca'));
			$worksheet2->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
			$worksheet2->write(4,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
			$worksheet2->write_string(6,0,'Perodo: De '.$dt_ini_filtro.' At '.$dt_fim_filtro);
			$worksheet2->write(7,0,"Filtro: ".$filtro);

			$linha2 = 9;
			$coluna2 = 0;

			$worksheet2->set_column($coluna2,$coluna2,14);
			$worksheet2->write_string($linha2,$coluna2,'Empresa',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,10);
			$worksheet2->write_string($linha2,$coluna2,'NrBoletim',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,10);
			$worksheet2->write_string($linha2,$coluna2,'Nota Fiscal',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,40);
			$worksheet2->write_string($linha2,$coluna2,'Fornecedor',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,18);
			$worksheet2->write_string($linha2,$coluna2,'CPF/CNPJ',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,12);
			$worksheet2->write_string($linha2,$coluna2,'Data',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,12);
			$worksheet2->write_string($linha2,$coluna2,'Qtdade (TO)',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,16);
			$worksheet2->write_string($linha2,$coluna2,'Classificao',$formatott);
			$coluna2++;

			$linha2++;

			$lista_empresas = lista_empresas();
			//fim aba detalhe



			/*
			TODO: A formula aqui mudei mas deve estar OK agora.
                Tem que testar s.
                Fazer notas com cada caso e ver se est jogando no valor correto.
                */

			for ($l=0; $l < $nrows; $l++) {

				$registro = consulta_ler_objeto($resultado);

				//Pega o nmero da nota fiscal aqui para procurar ela depois caso precise. J aproveita e pega o nmero do boletim tb.
				$nota = $registro->Nr_Nota;
				$boletim = $registro->Nr_Boletim_Pesagem;

				//Verifica agora de onde vai buscar as outras informaes. Se tiver boletim, pega do boletim_pesagem, senao pega do fixacao_nota_baixa
				if($boletim > 0){
					//Essa varivel vai ser somada para saber o volume total recebido, que  o primeiro valor a ser mostrado.
					//Pega a quantidade e o valor do item da nota quando  de boletim.
					$cons_boletim = 'select * from boletim_pesagem'.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Empresa = "'.$registro->Empresa.'"'.
								   ' and Nr_Boletim = "'.$boletim.'"';
					$res_boletim = consulta_sql($cons_boletim);
					$reg_boletim = consulta_ler_objeto($res_boletim);
					consulta_limpa($res_boletim);

					if ($reg_boletim->Placa!='AAA-0000'){
						$total_geral += $registro->Quantidade_Estoque;

						//Verifica se  transgenico ou nao.
						$classif = '';
						if($reg_boletim->Transgenico == 'S'){

							if($reg_boletim->TesteGMO == 'S'){
								//transgenico testado (INCTACTA com Teste positivo)
								$total_positiva += $registro->Quantidade_Estoque;
								$classif = 'Testada Positiva';
							}else{
								//transgenico no testado (INTACTA Declarado)
								$total_intacta += $registro->Quantidade_Estoque;
								$classif = 'Patente Declarada';
							}
							$valor_total_intacta += $registro->Valor_Total;

						}else{
							//Teste negativo (Convencional)
							$total_negativa += $registro->Quantidade_Estoque;
							$classif = 'Testada Negativa';
						}
						$valor_total_geral+= $registro->Valor_Total;


						$coluna2 = 0;
						$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$reg_boletim->Empresa),$formatotl);
						$coluna2++;

						$worksheet2->write_string($linha2,$coluna2,$reg_boletim->Nr_Boletim,$formatotc);
						$coluna2++;

						$worksheet2->write_string($linha2,$coluna2,$registro->NrDoc.'/'.$registro->Serie.'-'.$registro->Modelo,$formatotc);
						$coluna2++;

						$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
									' Where Dominio = "'.$_SESSION['Dominio'].'"'.
									' and Pessoa="'.$reg_boletim->Pessoa.'"';
						$res_forn = consulta_sql($con_forn);
						$reg_forn = consulta_ler_linha($res_forn);
						consulta_limpa($res_forn);

						$worksheet2->write_string($linha2,$coluna2,$reg_boletim->Pessoa.'-'.$reg_forn[0],$formatotl);
						$coluna2++;

						$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
						$coluna2++;

						$worksheet2->write_string($linha2,$coluna2,dataf($reg_boletim->DH_Abertura),$formatotc);
						$coluna2++;

						$worksheet2->write_number($linha2,$coluna2,$registro->Quantidade_Estoque,$formatotqtd);
						$coluna2++;

						$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
						$coluna2++;

						$linha2++;
					}
				}else{
					$seq = $registro->Seq_Item;
					//Busca a quantidade total da fixacao, para depois diminuir dela o testado e nao testado
					$cons_fixacao = 'select Quantidade, Qtd_GMO_Positivo, Qtd_GMO_NaoRealizado, Nota_DT_Emissao, Nota_NrDoc, Nota_Modelo, Nota_Serie from fixacao_nota_baixa'.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Nota_Empresa = "'.$registro->Empresa.'"'.
								   ' and Nota_Nr_Nota = "'.$nota.'"'.
								   ' and Seq_Item = "'.$seq.'"';
					$res_fixacao = consulta_sql($cons_fixacao);
					$rws_fixacao = consulta_num_registros($res_fixacao);

					if($rws_fixacao == 0){
						$cons_dev = 'Select Empresa, Nr_Nota from nota_fiscal '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Empresa = "'.$registro->Empresa.'"'.
								   ' and Nr_Nota < "'.$nota.'"'.
								   ' and Destinatario = "'.$registro->Destinatario.'"'.
								   ' and (DH_Emissao >= "'.datad(dataf($registro->DH_EntSai)).'")'.
								   //' and (DH_Emissao <= "'.$registro->DH_EntSai.'"))'.
								   ' and Situacao = "F"'.
								   ' and TipoES="1" '.
								   ' order by Nr_Nota Desc';
						$res_dev = consulta_sql($cons_dev);
						$nrw_dev = consulta_num_registros($res_dev);

						if($nrw_dev>0){
							$reg_dev = consulta_ler_linha($res_dev);

							if (($reg_dev[1]=='1029033') &&($reg_dev[0]==9)){
								$reg_dev[1]='1029031';
							}
							//se tiver pega a origem

							$con_item_ref = 'select Origem_Empresa, Origem_Nr_Nota, Origem_Quantidade from nota_fiscal_item_ref '.
										 ' where Dominio = "'.$_SESSION['Dominio'].'"'.
										 ' and Empresa = "'.$reg_dev[0].'"'.
										 ' and Nr_Nota = "'.$reg_dev[1].'"';
							$res_item_ref = consulta_sql($con_item_ref);
							$nrw_item_ref = consulta_num_registros($res_item_ref);

							if($registro->Quantidade_Estoque > 0){
								$valor_unit  = $registro->Valor_Total / $registro->Quantidade_Estoque;
							}else{
								$valor_unit  = 0;
							}

							$total = $registro->Quantidade_Estoque;

							for ($z=0; $z < $nrw_item_ref; $z++) {
								$reg_item_ref = consulta_ler_linha($res_item_ref);
								$qtd_somar = 0;

								$cons_nota_bol = 'select Nr_Boletim_Pesagem from nota_fiscal '.
												' where Dominio = "'.$_SESSION['Dominio'].'"'.
												' and Empresa = "'.$reg_item_ref[0].'"'.
												' and Nr_Nota = "'.$reg_item_ref[1].'"';
								$res_nota_bol = consulta_sql($cons_nota_bol);
								$reg_nota_bol = consulta_ler_linha($res_nota_bol);
								consulta_limpa($res_nota_bol);

								$cons_bol = 'select * from boletim_pesagem'.
											' where Dominio = "'.$_SESSION['Dominio'].'"'.
											' and Empresa = "'.$reg_item_ref[0].'"'.
											' and Nr_Boletim = "'.$reg_nota_bol[0].'"';
								$res_bol = consulta_sql($cons_bol);
								$reg_bol = consulta_ler_objeto($res_bol);
								consulta_limpa($res_bol);


								if($total>= $reg_item_ref[2]){
									$qtd_somar = $reg_item_ref[2];
								}else{
									$qtd_somar = $total;
								}
								$total -= $qtd_somar;

								$classif = '';
								if(($reg_bol->Transgenico == 'S') && ($reg_bol->Transgenico_Perc == 7.5)){
									if($reg_bol->TesteGMO == 'S'){
										//transgenico testado (INCTACTA com Teste positivo)
										$total_positiva += $qtd_somar;
										$classif = 'Testada Positiva';
									}else{
										//transgenico no testado (INTACTA Declarado)
										$total_intacta += $qtd_somar;
										$classif = 'Patente Declarada';
									}
									$valor_total_intacta += $valor_unit * $qtd_somar;

								}else{
									//Teste negativo (Convencional)
									$total_negativa += $qtd_somar;
									$classif = 'Testada Negativa';
								}

								$coluna2 = 0;
								$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$reg_bol->Empresa),$formatotl);
								$coluna2++;

								$worksheet2->write_string($linha2,$coluna2,$reg_bol->Nr_Boletim,$formatotc);
								$coluna2++;

								$worksheet2->write_string($linha2,$coluna2,$registro->NrDoc.'/'.$registro->Serie.'-'.$registro->Modelo,$formatotc);
								$coluna2++;

								$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
										   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
										   ' and Pessoa="'.$reg_bol->Pessoa.'"';
								$res_forn = consulta_sql($con_forn);
								$reg_forn = consulta_ler_linha($res_forn);
								consulta_limpa($res_forn);

								$worksheet2->write_string($linha2,$coluna2,$reg_bol->Pessoa.'-'.$reg_forn[0],$formatotl);
								$coluna2++;

								$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
								$coluna2++;

								$worksheet2->write_string($linha2,$coluna2,dataf($reg_bol->DH_Abertura),$formatotc);
								$coluna2++;

								$worksheet2->write_number($linha2,$coluna2,$qtd_somar,$formatotqtd);
								$coluna2++;

								$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
								$coluna2++;

								$linha2++;


								if($total <= 0){
									$z = $nrw_item_ref;
								}

							}
							consulta_limpa($res_item_ref);

							if($total > 0){
								$total_negativa += $total;
							}

							$total_geral += $registro->Quantidade_Estoque;


						}else{
							$total_geral += $registro->Quantidade_Estoque;
							$total_negativa += $registro->Quantidade_Estoque;

							$classif = 'Testada Negativa';

							$coluna2 = 0;
							$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$registro->Empresa),$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,'',$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$registro->NrDoc.'/'.$registro->Serie.'-'.$registro->Modelo,$formatotc);
							$coluna2++;

							$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
									   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
									   ' and Pessoa="'.$registro->Destinatario.'"';
							$res_forn = consulta_sql($con_forn);
							$reg_forn = consulta_ler_linha($res_forn);
							consulta_limpa($res_forn);

							$worksheet2->write_string($linha2,$coluna2,$registro->Destinatario.'-'.$reg_forn[0],$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,dataf($registro->DH_EntSai),$formatotc);
							$coluna2++;

							$worksheet2->write_number($linha2,$coluna2,$registro->Quantidade_Estoque,$formatotqtd);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
							$coluna2++;

							$linha2++;
						}
						consulta_limpa($res_dev);
					}


					for ($i=0; $i < $rws_fixacao; $i++) {

						$reg_fixacao = consulta_ler_linha($res_fixacao);

						//usa a quantidade da fixacao, porque no sei se  problema da nossa base, mas tem itens com quantidade zerada.
						//Nesse caso, ao inves de usar a quantidade e o valor do item da nota, usa apenas o valor unitario do item da nota e multiplica pela quantidade em cada situao
						//Total geral da fixacao do item, para somar na quantidade do volume total recebido. O valor, dessa vez  calculado multiplicando o valor unitario do item pela quantidade.
						$total_geral += $reg_fixacao[0];

						//quantidade testada (INTACTA com Teste Positivo)
						$testada_positiva = $reg_fixacao[1];
						$total_positiva += $testada_positiva;

						//quantidade nao testada (INTACTA Declarada)
						$intacta_declarada = $reg_fixacao[2];
						$total_intacta += $intacta_declarada;

						//teste negativo (Convencional)
						$testada_negativa = ($reg_fixacao[0] - ($reg_fixacao[1] + $reg_fixacao[2]));
						$total_negativa += $testada_negativa;

						//Valores
						$valor_total_geral += ($reg_fixacao[0]) * $registro->Valor_Unitario;
						//valor total intacta
						$valor_total_intacta += ($reg_fixacao[1] + $reg_fixacao[2]) * $registro->Valor_Unitario;


						$classif = '';
						if($testada_positiva>0){
							$classif = 'Testada Positiva';

							$coluna2 = 0;
							$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$registro->Empresa),$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,'',$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_fixacao[4].'/'.$reg_fixacao[6].'-'.$reg_fixacao[5],$formatotc);
							$coluna2++;

							$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
									  ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
									  ' and Pessoa="'.$registro->Destinatario.'"';
							$res_forn = consulta_sql($con_forn);
							$reg_forn = consulta_ler_linha($res_forn);
							consulta_limpa($res_forn);

							$worksheet2->write_string($linha2,$coluna2,$registro->Destinatario.'-'.$reg_forn[0],$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,dataf($reg_fixacao[3]),$formatotc);
							$coluna2++;

							$worksheet2->write_number($linha2,$coluna2,$testada_positiva,$formatotqtd);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
							$coluna2++;

							$linha2++;
						}

						if($intacta_declarada>0){
							$classif = 'Patente Declarada';

							$coluna2 = 0;
							$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$registro->Empresa),$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,'',$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_fixacao[4].'/'.$reg_fixacao[6].'-'.$reg_fixacao[5],$formatotc);
							$coluna2++;

							$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
									  ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
									  ' and Pessoa="'.$registro->Destinatario.'"';
							$res_forn = consulta_sql($con_forn);
							$reg_forn = consulta_ler_linha($res_forn);
							consulta_limpa($res_forn);

							$worksheet2->write_string($linha2,$coluna2,$registro->Destinatario.'-'.$reg_forn[0],$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,dataf($reg_fixacao[3]),$formatotc);
							$coluna2++;

							$worksheet2->write_number($linha2,$coluna2,$intacta_declarada,$formatotqtd);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
							$coluna2++;

							$linha2++;
						}

						if($testada_negativa>0){
							$classif = 'Testada Negativa';

							$coluna2 = 0;
							$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$registro->Empresa),$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,'',$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_fixacao[4].'/'.$reg_fixacao[6].'-'.$reg_fixacao[5],$formatotc);
							$coluna2++;

							$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
									  ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
									  ' and Pessoa="'.$registro->Destinatario.'"';
							$res_forn = consulta_sql($con_forn);
							$reg_forn = consulta_ler_linha($res_forn);
							consulta_limpa($res_forn);

							$worksheet2->write_string($linha2,$coluna2,$registro->Destinatario.'-'.$reg_forn[0],$formatotl);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,dataf($reg_fixacao[3]),$formatotc);
							$coluna2++;

							$worksheet2->write_number($linha2,$coluna2,$testada_negativa,$formatotqtd);
							$coluna2++;

							$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
							$coluna2++;

							$linha2++;
						}
					}
					consulta_limpa($res_fixacao);
				}

			}

			//Agora que j est tudo calculado, joga os valores nos campos. Acho que daqui para baixo no vai ter problema.
			//Se tiver algo errado  nas contas ali em cima mesmo.
			$coluna = 1;
			$linha_ini = $primeira_linha + 1;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;


			$coluna_ajuste = 0;
			$coluna = 2;
			$worksheetr->set_column($coluna,$coluna,25);

			$linha_ini = $primeira_linha;
			$worksheetr->write_string($linha_ini,$coluna-1,$prod,$formatotl);
			$worksheetr->write_blank($linha_ini,$coluna, $formatotl);   //acho que tem colocar aqui pra criar a caixainha em volta
			$worksheetr->merge_cells($linha_ini, $coluna-1, $linha_ini, $coluna);
			$linha_ini++;


			$worksheetr->write_number($linha_ini,$coluna,$total_geral, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_intacta, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_positiva, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_negativa, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,($total_positiva + $total_intacta), $formatotqtd);
			$linha_ini++;



			$worksheetr->write_blank($linha_ini,$coluna_ajuste,$formatotl);
			$worksheetr->merge_cells($linha_ini, $coluna_ajuste, $linha_ini, $coluna_ajuste+2);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_number($linha_ini,$coluna,$valor_total_geral, $formatotpreco);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_number($linha_ini,$coluna,$valor_total_intacta, $formatotpreco);
			$linha_ini++;

			//Valor do percentual intacta, referente aos 7,5%  (sem Percentual "%")
			$worksheetr->write_number($linha_ini,$coluna-1,BuscaParam('GMO_Perc'), $formatotc);


			//$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_formula($linha_ini,$coluna,'=SUM(C'.($linha_ini).'*B'.($linha_ini+1).'/100)', $formatotpreco);
			$linha_ini++;

			$linha_ini++;

		}else{
			$worksheetr->write(10,0,"No existem registros para este filtro!");
		}
		consulta_limpa($resultado);

    }else if($tipo=='R'){//tipo remessa
		$consulta = 'select n.Nr_Nota, '.
                   ' n.DH_EntSai, '.
                   ' n.Nr_Contrato, '.
                   ' n.Nr_Boletim_Pesagem, '.
                   ' n.Empresa, '.
                   ' nfi.Seq_Item, '.
                   ' nfi.Id_Produto, '.
                   ' nfi.Quantidade_Estoque, '.
                   ' nfi.Valor_Unitario, '.
                   ' nfi.Valor_Total, n.Destinatario from nota_fiscal n '.
                   ' inner join nota_fiscal_item nfi on '.
                   ' n.Dominio = nfi.Dominio '.
                   ' and n.Empresa = nfi.Empresa '.
                   ' and n.Nr_Nota = nfi.Nr_Nota '.
                   ' Where n.Dominio = "'.$_SESSION['Dominio'].'"'.
                   ' and n.Destinatario > 100 '.
                   ' and n.DH_EntSai >= "'.$dt_ini.'" '.
                   ' and n.DH_EntSai <= "'.$dt_fim.'" '.
                   ' and n.TipoES = "0"'.
                   ' and n.Situacao = "F"'.
                   ' and n.Nr_Boletim_Pesagem > 0 '.
                   ' and ((n.Nat_Op_CFOP = "1.905") or (n.Nat_Op_CFOP = "2.905"))'.
				   ' and nfi.Compoe_Total="S"';

		$filtro = '';

		if ($empresa != '') {
			$consulta.=' and n.Empresa = "'.$empresa.'"';
			$con_empre = 'select Pessoa, Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					   ' and Pessoa = "'.$empresa.'" '.
					   ' and Situacao <> "E" '.
					   ' order by Nome_Listas';
			$res_empre = consulta_sql($con_empre);
			$reg_empre = consulta_ler_linha($res_empre);
			consulta_limpa($res_empre);
			$filtro.= ' Empresa: "'.$empresa.'-'.$reg_empre[1].'"';
		}

		if($fornec > 0){
			$consulta.= ' and n.Destinatario = "'.$fornec.'"';
			$con_pess = 'select Pessoa, Nome_Listas from pessoa '.
					   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
					   ' and Pessoa = "'.$fornec.'" '.
					   ' and Situacao <> "E" ';
			$res_pess = consulta_sql($con_pess);
			$reg_pess = consulta_ler_linha($res_pess);
			consulta_limpa($res_pess);
			$filtro.= ' Fornecedor: "'.$fornec.'-'.$reg_pess[1].'"';
		}

		if($produto!=''){
			$consulta.=' and nfi.Id_Produto = "'.$produto.'"';
			$con_prod = 'select Codigo_Produto, Descricao_Curta, Descricao_Completa, Retencao_Tecnica from produto '.
					   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' and Id_Produto = "'.$produto.'"';
			$res_prod = consulta_sql($con_prod);
			$reg_prod = consulta_ler_linha($res_prod);
			consulta_limpa($res_prod);
			$prod = $reg_prod[0].'-'.$reg_prod[1];
			$filtro.= ' Produto: "'.$reg_prod[0].'-'.$reg_prod[1].'"';
		}else{
			$produto = '5466;5174';
			$filtro_prod = '';
			$prod = '';
			$con_filtro = '';

			$lista_prod = explode(';',$produto);
			foreach($lista_prod as $key => $valor){
				if($valor!=''){
					if($con_filtro != ''){
						$con_filtro.= 'or';
					}
					$con_filtro.= ' (nfi.Id_Produto = "'.$valor.'") ';
					//$prod[$valor] = '1';
					if($filtro_prod==''){
						$filtro_prod = ' Produtos:';
						$prod = '';
					}else{
						$filtro_prod.= ',';
						$prod.= ',';
					}

					$con_prod = 'select Codigo_Produto, Descricao_Curta from produto '.
							 ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							 ' and Id_Produto = "'.$valor.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);

					$filtro_prod.= ' "'.$reg_prod[0].'-'.$reg_prod[1].'"';
					$prod.= ' '.$reg_prod[0].'-'.$reg_prod[1];
				}
			}

			if($con_filtro != ''){
				$con_filtro = ' and ('.$con_filtro.')';
				//if($filtro != ''){
				$filtro.= ' '.$filtro_prod;
				//}

				$consulta.= ' '.$con_filtro;
			}
		}

		$consulta.= ' order by n.DH_EntSai, n.Nr_Nota, nfi.Seq_Item';

		// Format for the headings
		$formatot =& $workbook->add_format();
		$formatot->set_size(18);

		$formatost =& $workbook->add_format();
		$formatost->set_size(12);

		$worksheetr->write_string(1,0,'Relatrio de Compra de GMO',$formatot);
		$worksheetr->write(2,0,config_pad('sistema_licenca'));
		$worksheetr->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
		$worksheetr->write(4,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

		$worksheetr->write_string(6,0,'Perodo: De '.$dt_ini_filtro.' At '.$dt_fim_filtro);
		$worksheetr->write(7,0,"Filtro: ".$filtro);


		$resultado = consulta_sql($consulta);
		$nrows = consulta_num_registros($resultado);

		$linha_ini = 9;
		$total_geral = 0;
		$total_intacta = 0;
		$total_positiva = 0;
		$total_negativa = 0;

		$valor_total_geral = 0;
		$valor_total_intacta = 0;

		if ($nrows>0){
			$coluna =0;
			$primeira_linha = $linha_ini;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Produto',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Total Recebido',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd PATENTE Declarada',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Testada Positiva',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Qtd Testada Negativa',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'PATENTE Total',$formatottl);
			$linha_ini++;

			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Valor Total de Compra',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'Valor Total de PATENTE',$formatottl);
			$linha_ini++;

			$worksheetr->set_column($coluna,$coluna,25);
			$worksheetr->write_string($linha_ini,$coluna,'% de PATENTE',$formatottl);
			$linha_ini++;

			$linha_ini++;
			
			//cria aba detalhamento
			$titulo_sheet2 = 'DETALHES';
			$worksheet2 =& $workbook->add_worksheet($titulo_sheet2);

			$worksheet2->write_string(1,0,'Relatrio de Compra de GMO',$formatot);
			$worksheet2->write(2,0,config_pad('sistema_licenca'));
			$worksheet2->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
			$worksheet2->write(4,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));
			$worksheet2->write_string(6,0,'Perodo: De '.$dt_ini_filtro.' At '.$dt_fim_filtro);
			$worksheet2->write(7,0,"Filtro: ".$filtro);

			$linha2 = 9;
			$coluna2 = 0;

			$worksheet2->set_column($coluna2,$coluna2,12);
			$worksheet2->write_string($linha2,$coluna2,'Empresa',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,10);
			$worksheet2->write_string($linha2,$coluna2,'NrBoletim',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,40);
			$worksheet2->write_string($linha2,$coluna2,'Fornecedor',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,18);
			$worksheet2->write_string($linha2,$coluna2,'CPF/CNPJ',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,45);
			$worksheet2->write_string($linha2,$coluna2,'Produto',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,12);
			$worksheet2->write_string($linha2,$coluna2,'Data',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,12);
			$worksheet2->write_string($linha2,$coluna2,'Qtdade (TO)',$formatott);
			$coluna2++;

			$worksheet2->set_column($coluna2,$coluna2,16);
			$worksheet2->write_string($linha2,$coluna2,'Classificao',$formatott);
			$coluna2++;

			$linha2++;

			$lista_empresas = lista_empresas();
			//fim aba detalhe


			for($l=0; $l < $nrows; $l++) {
				$registro = consulta_ler_objeto($resultado);


				$cons_boletim = 'select * from boletim_pesagem'.
								' where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Empresa = "'.$registro->Empresa.'"'.
								' and Nr_Boletim = "'.$registro->Nr_Boletim_Pesagem.'"';
				$res_boletim = consulta_sql($cons_boletim);
				$reg_boletim = consulta_ler_objeto($res_boletim);
				consulta_limpa($res_boletim);

				$classif = '';
				if($reg_boletim->Placa!='AAA-0000'){
					$total_geral += $registro->Quantidade_Estoque;
					if(($reg_boletim->Transgenico == 'S') && ($reg_boletim->Transgenico_Perc == 7.5)){
						if($reg_boletim->TesteGMO == 'S'){
							//transgenico testado (INCTACTA com Teste positivo)
							$total_positiva += $registro->Quantidade_Estoque;
							$classif = 'Testada Positiva';
						}else{
							//transgenico no testado (INTACTA Declarado)
							$total_intacta += $registro->Quantidade_Estoque;
							$classif = 'Patente Declarada';
						}
						$valor_total_intacta += $registro->Valor_Total;

					}else{
						//Teste negativo (Convencional)
						$total_negativa += $registro->Quantidade_Estoque;
						$classif = 'Testada Negativa';
					}
					$valor_total_geral+= $registro->Valor_Total;


					$coluna2 = 0;
					$worksheet2->write_string($linha2,$coluna2,nome_empresa($lista_empresas,$reg_boletim->Empresa),$formatotl);
					$coluna2++;

					$worksheet2->write_string($linha2,$coluna2,$reg_boletim->Nr_Boletim,$formatotc);
					$coluna2++;

					$con_forn = 'select Nome_Razao, CPF_CNPJ from pessoa '.
							   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Pessoa="'.$reg_boletim->Pessoa.'"';
					$res_forn = consulta_sql($con_forn);
					$reg_forn = consulta_ler_linha($res_forn);
					consulta_limpa($res_forn);

					$worksheet2->write_string($linha2,$coluna2,$reg_boletim->Pessoa.'-'.$reg_forn[0],$formatotl);
					$coluna2++;

					$worksheet2->write_string($linha2,$coluna2,$reg_forn[1],$formatotc);
					$coluna2++;

					$con_prod = 'select Codigo_Produto, Descricao_Curta from produto '.
							   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Id_Produto = "'.$reg_boletim->Id_Produto.'"';
					$res_prod = consulta_sql($con_prod);
					$reg_prod = consulta_ler_linha($res_prod);
					consulta_limpa($res_prod);
					$worksheet2->write_string($linha2,$coluna2,$reg_prod[1],$formatotc);
					$coluna2++;

					$worksheet2->write_string($linha2,$coluna2,dataf($reg_boletim->DH_Abertura),$formatotc);
					$coluna2++;

					$worksheet2->write_number($linha2,$coluna2,$registro->Quantidade_Estoque,$formatotqtd);
					$coluna2++;

					$worksheet2->write_string($linha2,$coluna2,$classif,$formatotc);
					$coluna2++;

					$linha2++;
				}
			}

			$coluna = 1;
			$linha_ini = $primeira_linha + 1;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna,'TO', $formatotc);
			$linha_ini++;

			$coluna_ajuste = 0;
			$coluna = 2;
			$worksheetr->set_column($coluna,$coluna,35);

			$linha_ini = $primeira_linha;
			$worksheetr->write_string($linha_ini,$coluna-1,$prod,$formatotl);
			$worksheetr->write_blank($linha_ini,$coluna, $formatotl);   //acho que tem colocar aqui pra criar a caixainha em volta
			$worksheetr->merge_cells($linha_ini, $coluna-1, $linha_ini, $coluna);
			$linha_ini++;


			$worksheetr->write_number($linha_ini,$coluna,$total_geral, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_intacta, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_positiva, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,$total_negativa, $formatotqtd);
			$linha_ini++;

			$worksheetr->write_number($linha_ini,$coluna,($total_positiva + $total_intacta), $formatotqtd);
			$linha_ini++;

			$worksheetr->write_blank($linha_ini,$coluna_ajuste,$formatotl);
			$worksheetr->merge_cells($linha_ini, $coluna_ajuste, $linha_ini, $coluna_ajuste+2);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_number($linha_ini,$coluna,$valor_total_geral, $formatotpreco);
			$linha_ini++;

			$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_number($linha_ini,$coluna,$valor_total_intacta, $formatotpreco);
			$linha_ini++;

			//Valor do percentual intacta, referente aos 7,5%  (sem Percentual "%")
			$worksheetr->write_number($linha_ini,$coluna-1,BuscaParam('GMO_Perc'), $formatotc);


			//$worksheetr->write_string($linha_ini,$coluna-1,'', $formatotl);
			$worksheetr->write_formula($linha_ini,$coluna,'=SUM(C'.($linha_ini).'*B'.($linha_ini+1).'/100)', $formatotpreco);
			$linha_ini++;

			$linha_ini++;
		}
    }


    //ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
    $insert = 'insert into relatorio_tmp ( '.
              ' Dominio, '.
              ' Usuario, '.
              ' Descricao ) values ('.
              '"'.$_SESSION['Dominio'].'", '.
              '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
              '"")';
    consulta_sql($insert);

    $workbook->close();
?>