<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	session::usr_conectado($_REQUEST['USER_ID']);

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename){
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	
	$cod_dominio = '122'; //122 ou 191
	$cod_dominio_pz = '83';//83;
	
	//$_REQUEST['tipo_rel'] = 'D';

	HeaderingExcel('COMISSOES.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'RELATRIO COMISSES';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$fmt_branco =& $workbook->add_format();
	$fmt_branco->set_size(10);

	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,'RELATRIO DE COMISSES',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_align('vcenter');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatottl =& $workbook->add_format();
	$formatottl->set_align('left');
	$formatottl->set_pattern();
	$formatottl->set_fg_color(40);
	$formatottl->set_bold(1);
	$formatottl->set_border(1);

	$fmt_titulo =& $workbook->add_format();
	$fmt_titulo->set_align('left');
	$fmt_titulo->set_size(8);

	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_align('vcenter');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_size(8);
	$fmt_cabec->set_border(1);
	$fmt_cabec->set_bold(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');
	$formatotl->set_size(10);
	$formatotl->font='Tahoma';

	$formatotl_filtro =& $workbook->add_format();
	$formatotl_filtro->set_align('left');
	$formatotl_filtro->set_size(10);
	$formatotl_filtro->font='Tahoma';

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	$fmt_txt =& $workbook->add_format();
	$fmt_txt->set_border(1);
	$fmt_txt->set_size(8);
	$fmt_txt->set_align('center');	
	
	$fmt_txt_L =& $workbook->add_format();
	$fmt_txt_L->set_border(1);
	$fmt_txt_L->set_size(8);
	$fmt_txt_L->set_align('left');
	
	$fmt_txt_B =& $workbook->add_format();
	$fmt_txt_B->set_border(1);
	$fmt_txt_B->set_size(8);
	$fmt_txt_B->set_align('center');
	$fmt_txt_B->set_bold(1);
	
	$fmt_txt_I =& $workbook->add_format();
	$fmt_txt_I->set_border(1);
	$fmt_txt_I->set_size(8);
	$fmt_txt_I->set_align('center');
	$fmt_txt_I->set_italic(1);
	
	$fmt_txt_IL =& $workbook->add_format();
	$fmt_txt_IL->set_border(1);
	$fmt_txt_IL->set_size(8);
	$fmt_txt_IL->set_align('left');
	$fmt_txt_IL->set_italic(1);
	
	$fmt_txt_BL =& $workbook->add_format();
	$fmt_txt_BL->set_border(1);
	$fmt_txt_BL->set_size(8);
	$fmt_txt_BL->set_align('left');
	$fmt_txt_BL->set_bold(1);
	
	$fmt_txt_BR =& $workbook->add_format();
	$fmt_txt_BR->set_border(1);
	$fmt_txt_BR->set_size(8);
	$fmt_txt_BR->set_align('right');
	$fmt_txt_BR->set_bold(1);
	
	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	$fmt_valor->set_size(8);
	$fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	
	$fmt_valor_B =& $workbook->add_format();
	$fmt_valor_B->set_border(1);
	$fmt_valor_B->set_align('right');
	$fmt_valor_B->set_size(8);
	$fmt_valor_B->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_valor_B->set_bold(1);
	
	$fmt_valor_I =& $workbook->add_format();
	$fmt_valor_I->set_border(1);
	$fmt_valor_I->set_align('right');
	$fmt_valor_I->set_size(8);
	$fmt_valor_I->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_valor_I->set_italic(1);
	

	$fmt_total =& $workbook->add_format();
	$fmt_total->set_border(1);
	$fmt_total->set_align('right');
	$fmt_total->set_size(8);
	$fmt_total->set_bold(1);
	$fmt_total->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['pessoa'];
	$data_ini = $_REQUEST['data_ini'];
	$data_fim = $_REQUEST['data_fim'];

	$dia_ini = data2nr($data_ini);

	$label = label_vendedor_ou_rep_comercial('S');




	$gera_comissao = BuscaParam('COMISSAO_AUTO');

	//$_REQUEST['tipo_rel'] = 'D';
	$comissao_itens = (($gera_comissao == "P") && ($_REQUEST['tipo_rel'] == 'A'));
	//$comissao_itens = true;

	//DEFINE VALOR DAS COMISSES
	$con_comissao = 'select Empresa, Nr_Comissao, Valor_NF, Vendedor '.
				  ' from comissao '.
				  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				  //' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
				  //' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" '.
				  ' and Valor_Comissao = 0 '.
				  // ' and TipoMov = "F" '.
				  ' and Situacao = "A" ';

	if($gera_comissao=='Q'){
		if ($_SESSION['Dominio']==2){
			$con_comissao.= ' and DT_Emissao >= "2018-01-01" ';
		}
	}else{
        if(($gera_comissao=='T')&&($_SESSION['Dominio']==11)){
        }else{
            $con_comissao.= ' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
                             ' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" ';
        }
    }

    if($_REQUEST['pessoa']!=''){
        $con_comissao.= ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';
    }

    if($_REQUEST['vendedor']!=''){
        $con_comissao.= ' and Vendedor = "'.$_REQUEST['vendedor'].'" ';
    }

    $res_comissao = consulta_sql($con_comissao);
    $nro_comissao = consulta_num_registros($res_comissao);

    if($nro_comissao>0){
        for($c=0;$c<$nro_comissao;$c++){
            $reg_comissao = consulta_ler_linha($res_comissao);
            financeiro_gera_comissao_define_valor($reg_comissao[0],
                                                   $reg_comissao[1],
                                                   $reg_comissao[3],
                                                   $reg_comissao[2]);
        }
    }
    consulta_limpa($res_comissao);

    $consulta = ' select Empresa, Nr_Comissao, Tipo, Nr_Nota, Nr_Doc, Modelo, Serie, SubSerie, DT_Emissao, Pessoa, Valor_NF, '.
                  ' Valor_Comissao, Vendedor, Situacao, Observacao, Contas_Baixa, Contas_Recebe, TipoMov, ECF_NrFab, ECF_LetraMF, '.
                  ' HR_Emissao, Gerente '.
                  ' from comissao '.
                  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                  ' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
                  ' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" '.
                  ' and Valor_Comissao <> 0'.
                  ' and Situacao <> "C" and Situacao <> "E" ';

    $filtro = 'Perodo: De "'.$_REQUEST['data_ini'].'"'.
                ' At "'.$_REQUEST['data_fim'].'"';

    if($_REQUEST['pessoa']!=''){
        $consulta.= ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';

        $con_pessoa_cliente = 'select Nome_Listas from pessoa '.
                               ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                               ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';
        $res_pessoa_cliente = consulta_sql($con_pessoa_cliente);
        $reg_pessoa_cliente = consulta_ler_linha($res_pessoa_cliente);
        consulta_limpa($res_pessoa_cliente);

        $filtro.= ' Cliente: "'.$_REQUEST['pessoa'].'-'.$reg_pessoa_cliente[0].'" ';
    }

    if($_REQUEST['vendedor']!=''){
        $consulta.= ' and Vendedor = "'.$_REQUEST['vendedor'].'" ';

        $con_pessoa_vendedor = 'select Nome_Listas from pessoa '.
                                ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                ' and Pessoa = "'.$_REQUEST['vendedor'].'" ';
        $res_pessoa_vendedor = consulta_sql($con_pessoa_vendedor);
        $reg_pessoa_vendedor = consulta_ler_linha($res_pessoa_vendedor);
        consulta_limpa($res_pessoa_vendedor);

        $filtro.= ' '.$label.': "'.$_REQUEST['vendedor'].'-'.$reg_pessoa_vendedor[0].'" ';
    }

    $consulta.= ' order by Vendedor, DT_Emissao, Nr_Comissao ';
	
	$worksheet1->write(6,0,"Filtro: ".$filtro);


    function exibe_dias_vendedor(&$worksheet1, $lista_vendedor,$cod_dominio_pz,$cod_dominio,&$fmt_txt_B,&$fmt_txt_BR,&$fmt_valor_B){
        foreach($lista_vendedor as $dia => $valor){
            $dados = $lista_vendedor[$dia];			
			$coluna=0;			
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, 'Total do Dia: '.dataf($dia), $fmt_txt_BR);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_BR);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_BR);
			$coluna++;
			
			$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
			
			//$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_BR);
			//$coluna++;
			
			//$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_BR);
			//$coluna++;
            

            if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'], $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_vendaAV']+$dados['total_dia_dev_vendaAV'], $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_vendaPZ'], $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_vendaCF'], $fmt_valor_B);
				$coluna++;
				
				if(($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])!=0){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, round($dados['total_dia_vend_comissao']/($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])*100,2), $fmt_txt_B);
				}else{
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_B);
				}
				$coluna++;				

            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_venda'], $fmt_valor_B);
				$coluna++;				
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_dev_venda'], $fmt_valor_B);
				$coluna++;				
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'], $fmt_valor_B);
				$coluna++;	
				
				$perc_comissao=0;
				if(($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])>0){
					$perc_comissao = round($dados['total_dia_vend_comissao']/($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])*100,2);
				}			
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $perc_comissao, $fmt_txt_B);
				$coluna++;
				
            }else{
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_produto'], $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_desconto'], $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_venda'], $fmt_valor_B);
				$coluna++;	

				$y=$pdf->y;
				if($dados['total_dia_vend_venda']!=0){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, round($dados['total_dia_vend_comissao']/$dados['total_dia_vend_venda']*100,2), $fmt_txt_B);
					$coluna++;			
				}else{
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_B);
					$coluna++;		
					
				}
				$pdf->y=$y;
            }

			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_comissao'], $fmt_valor_B);
			$coluna++;				
			
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){               
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dados['total_dia_vend_liquido'], $fmt_valor_B);
				$coluna++;			   
            }

            $_REQUEST['linha_ini']++;

		}
	}
	
	$_REQUEST['linha_ini'] =9;
	
	
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	if($nrows>0){
		
        $coluna=0;
		$qtd_colunas =0;

        if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){
            
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Data Comisso', $formatott);
			$coluna++;	

			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Nr Doc', $formatott);
			$coluna++;

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$worksheet1->set_column($coluna, $coluna, 30);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Cliente', $formatott);
				$coluna++;	

				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
				$coluna++;	

				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
				$coluna++;	
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
					
				
            }else{				
				$worksheet1->set_column($coluna, $coluna, 30);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Cliente', $formatott);
				$coluna++;	

				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Produto', $formatott);
				$coluna++;	

				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Desconto', $formatott);
				$coluna++;	
            }
			
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor NF', $formatott);
			$coluna++;	
			
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Comisso (%)', $formatott);
			$coluna++;	
			
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Comisso', $formatott);
			$coluna++;

			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Lquido', $formatott);
			$coluna++;
			$_REQUEST['linha_ini']++;
            
		}else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){
            $worksheet1->set_column($coluna, $coluna, 30);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$label, $formatott);
			$coluna++;

			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
			$coluna++;	

			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
			$coluna++;

			$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
							

            if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Venda', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	' Vista', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	' Prazo', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Cupom', $formatott);
				$coluna++;				
				
            }else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){			
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Venda', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Devoluo', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Saldo', $formatott);
				$coluna++;	
				
            }else{
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Produto', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Desconto', $formatott);
				$coluna++;	
				
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Venda', $formatott);
				$coluna++;				
            }
			
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Comisso (%)', $formatott);
			$coluna++;	
			
			$worksheet1->set_column($coluna, $coluna, 15);
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Comisso', $formatott);
			$coluna++;	
            
            //if($cod_dominio_pz!=$_SESSION['Dominio']){
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&(  !Zathura() )){
				$worksheet1->set_column($coluna, $coluna, 15);
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Lquido', $formatott);
				$coluna++;	
            }
			$_REQUEST['linha_ini']++;
		}	
		$qtd_colunas_top = $coluna;
		if(($_REQUEST['tipo_rel']=='D') || ($comissao_itens)){
            $coluna=0;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
			$coluna++;	 

			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Produto', $formatott);
			$coluna++;             
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
			$coluna++; 

			$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-2, $_REQUEST['linha_ini'], $coluna-1);
						
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Quantidade', $formatott);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Unitrio', $formatott);
			$coluna++;  

            if($comissao_itens){
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Total', $formatott);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Perc.', $formatott);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Comisso', $formatott);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Lquido', $formatott);
				$coluna++;					
            }else{				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Valor Total', $formatott);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
				$coluna++;	

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $formatott);
				$coluna++;	

				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
            }
			$qtd_colunas_det = $coluna;	
			
            $_REQUEST['linha_ini']++;
		}

		$id_vendedor = '';
		$desc_vendedor = '';

		$valor_produto = 0;
		$total_produto = 0;
		$valor_liquido = 0;

		$total_vend_produto = 0;
		$total_vend_desconto = 0;
		$total_vend_venda = 0;
		$total_vend_comissao = 0;
		$total_vend_liquido = 0;

		$total_dev_produto = 0;
		$total_dev_desconto = 0;
		$total_dev_venda = 0;
		$total_dev_comissao = 0;
		$total_dev_liquido = 0;

		$total_geral_produto = 0;
		$total_geral_desconto = 0;
		$total_geral_venda = 0;
		$total_geral_comissao = 0;
		$total_geral_liquido = 0;

		$total_geraldev_produto = 0;
		$total_geraldev_desconto = 0;
		$total_geraldev_venda = 0;
		$total_geraldev_comissao = 0;
		$total_geraldev_liquido = 0;

		$total_geral_vendaAV=0;
		$total_geraldev_vendaAV=0;
		$total_geral_vendaPZ=0;
		$total_geral_vendaCF=0;

		$total_vend_vendaAV=0;
		$total_dev_vendaAV=0;
		$total_vend_vendaPZ=0;
		$total_vend_vendaCF=0;

		//total dia
		$total_dia_vend_produto = 0;
		$total_dia_vend_desconto = 0;
		$total_dia_vend_venda = 0;
		$total_dia_vend_comissao = 0;
		$total_dia_vend_liquido = 0;

		$total_dia_dev_produto = 0;
		$total_dia_dev_desconto = 0;
		$total_dia_dev_venda = 0;
		$total_dia_dev_comissao = 0;
		$total_dia_dev_liquido = 0;

		$total_dia_vend_vendaAV=0;
		$total_dia_dev_vendaAV=0;
		$total_dia_vend_vendaPZ=0;
		$total_dia_vend_vendaCF=0;

		$data_do_dia = '';
		$lista_vendedor = array();
		$ok_vendedor = false;

		for($i=0;$i<$nrows;$i++){
            $registro = consulta_ler_objeto($resultado);
            set_time_limit(60);

            if($id_vendedor!=$registro->Vendedor){				
				if($id_vendedor !=''){
					$coluna =0;

					if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){					

						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Venda:', $fmt_txt_BL);
						$coluna++;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;	

						

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;	

							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;	
							
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
						}else{	
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
					
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_produto, $fmt_valor_B);
							$coluna++;	
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_desconto, $fmt_valor_B);
							$coluna++;								
						}
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda, $fmt_valor_B);
						$coluna++;	
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
						$coluna++;	
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao, $fmt_valor_B);
						$coluna++;	

						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido, $fmt_valor_B);
						$coluna++;	

						$_REQUEST['linha_ini']++;
						$coluna=0;
						
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Devolues:', $fmt_txt_BL);
						$coluna++;	
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;	
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;							

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;	

							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;
							
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
				
						}else{		
						    $worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_produto, $fmt_valor_B);
							$coluna++;	
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_desconto, $fmt_valor_B);
							$coluna++;	
						}
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_venda, $fmt_valor_B);
						$coluna++;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
						$coluna++;	
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_comissao, $fmt_valor_B);
						$coluna++;
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_liquido, $fmt_valor_B);
						$coluna++;
						
						

						$_REQUEST['linha_ini']++;
						$coluna=0;	


						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Saldo:', $fmt_txt_BL);
						$coluna++;	
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;	
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){							
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;
							
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
							$coluna++;
							
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
											
						}else{
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_produto+$total_dev_produto, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_desconto+$total_dev_desconto, $fmt_valor_B);
							$coluna++;
						}
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
						$coluna++;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
						$coluna++;
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao+$total_dev_comissao, $fmt_valor_B);
						$coluna++;
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido+$total_dev_liquido, $fmt_valor_B);
						$coluna++;
						
						$_REQUEST['linha_ini']++;

						$total_geral_produto += $total_vend_produto;
						$total_geral_desconto += $total_vend_desconto;
						$total_geral_venda += $total_vend_venda;
						$total_geral_comissao += $total_vend_comissao;
						$total_geral_liquido += $total_vend_liquido;

						$total_geraldev_produto += $total_dev_produto;
						$total_geraldev_desconto += $total_dev_desconto;
						$total_geraldev_venda += $total_dev_venda;
						$total_geraldev_comissao += $total_dev_comissao;
						$total_geraldev_liquido += $total_dev_liquido;

					}else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){
						if(($_REQUEST['tipo_rel']=='SD')&&($ok_vendedor)){
							$_REQUEST['linha_ini']++;
							$_REQUEST['linha_ini']++;
						}
						$ok_vendedor = true;

						$coluna=0;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$desc_vendedor, $fmt_txt_BL);
						$coluna++;	
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;
						
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;
						
						$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
						
						if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaAV+$total_dev_vendaAV, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaPZ, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaCF, $fmt_valor_B);
							$coluna++;							
							
							if(($total_vend_venda+$total_dev_venda)!=0){
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round($total_vend_comissao/($total_vend_venda+$total_dev_venda)*100,2), $fmt_txt_B);
							}else{								
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);						
							}
							$coluna++;						

						}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_venda, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
							$coluna++;	

							if(($total_vend_venda+$total_dev_venda)!=0){
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round(($total_vend_comissao+$total_dev_comissao)/($total_vend_venda+$total_dev_venda)*100,2), $fmt_txt_B);	
							}else{
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);	
							}
							$coluna++;						
							
						}else{
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_produto, $fmt_valor_B);
							$coluna++;
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_desconto, $fmt_valor_B);
							$coluna++;						
							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda, $fmt_valor_B);
							$coluna++;
							
							if($total_vend_venda!=0){
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round($total_vend_comissao/$total_vend_venda*100,2), $fmt_txt_B);
							}else{
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
							}
							$coluna++;
						}					
						
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao+$total_dev_comissao, $fmt_valor_B);
						$coluna++;
						
						//if($cod_dominio_pz!=$_SESSION['Dominio']){
						if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){							
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido+$total_dev_liquido, $fmt_valor_B);
							$coluna++;							
						}
						
						$_REQUEST['linha_ini']++;

						if($_REQUEST['tipo_rel']=='SD'){
							//tambem totalizar o dia
							exibe_dias_vendedor($worksheet1, $lista_vendedor,$cod_dominio_pz,$cod_dominio,$fmt_txt_B,$fmt_txt_BR,$fmt_valor_B);
							$lista_vendedor = array();
						}

						$total_geral_produto += $total_vend_produto;
						$total_geral_desconto += $total_vend_desconto;
						$total_geral_venda += $total_vend_venda;
						$total_geral_comissao += $total_vend_comissao;
						$total_geral_liquido += $total_vend_liquido;

						$total_geraldev_produto += $total_dev_produto;
						$total_geraldev_desconto += $total_dev_desconto;
						$total_geraldev_venda += $total_dev_venda;
						$total_geraldev_comissao += $total_dev_comissao;
						$total_geraldev_liquido += $total_dev_liquido;

						$total_geral_vendaAV+= $total_vend_vendaAV;
						$total_geraldev_vendaAV+= $total_dev_vendaAV;
						$total_geral_vendaPZ+= $total_vend_vendaPZ;
						$total_geral_vendaCF+= $total_vend_vendaCF;

						//estava aqui
					}
					//$data_do_dia = '';

					$total_vend_produto = 0;
					$total_vend_desconto = 0;
					$total_vend_venda = 0;
					$total_vend_comissao = 0;
					$total_vend_liquido = 0;

					$total_dev_produto = 0;
					$total_dev_desconto = 0;
					$total_dev_venda = 0;
					$total_dev_comissao = 0;
					$total_dev_liquido = 0;

					$total_vend_vendaAV=0;
					$total_dev_vendaAV=0;
					$total_vend_vendaPZ=0;
					$total_vend_vendaCF=0;
				}

				$id_vendedor = $registro->Vendedor;

				$con_vendedor = 'select Pessoa, Nome_Listas from pessoa '.
							   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Pessoa = "'.$registro->Vendedor.'"'.
							   ' order by Nome_Listas ';
				$res_vendedor = consulta_sql($con_vendedor);
				$reg_vendedor = consulta_ler_linha($res_vendedor);
				consulta_limpa($res_vendedor);

				$label_emp = empresa_representante($registro->Vendedor,'S');

				$desc_vendedor = $label_emp;

				if(($_REQUEST['tipo_rel']!='S')&&($_REQUEST['tipo_rel']!='SD')){
					$coluna=0;
					
					//$_REQUEST['linha_ini']++;
					if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){
						$qtd_colunas = 9;
						
					}else{
						$qtd_colunas = 9;
						if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
							$qtd_colunas = 10;
						}
					}
					
					
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	' '.$label.': '.$desc_vendedor, $fmt_txt_BL);
					$coluna++;
					
					for($k=0;$k<$qtd_colunas-1;$k++){
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
						$coluna++;					
					}
					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], 0, $_REQUEST['linha_ini'], $qtd_colunas-1);
					$_REQUEST['linha_ini']++;				
					
				}
            }
            

            $data_do_dia = $registro->DT_Emissao;           

            if(($_REQUEST['tipo_rel']!='S')&&($_REQUEST['tipo_rel']!='SD')){
				$coluna = 0;				

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	dataf($registro->DT_Emissao), $fmt_txt);
				$coluna++;
				
				if($registro->Nr_Doc==0){
					$nr_nf = '';
				}else if($registro->Modelo=='2D'){
					$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-2D';
				}else{
					$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo;
				}				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$nr_nf, $fmt_txt);
				$coluna++;

				//somente para o detalhado
				
				if(($registro->Modelo=='2D') && ($registro->Pessoa==0)){
					$pessoa = 'VENDA VIA ECF - CONSUMIDOR FINAL';
				}else if($registro->Pessoa==0){
					$pessoa = 'CONSUMIDOR NO IDENTIFICADO';
				}else{
					$con_pessoa = 'select Nome_Listas from pessoa '.
						' Where Dominio = "'.$_SESSION['Dominio'].'"'.
						' and Pessoa = "'.$registro->Pessoa.'"';
					$res_pessoa = consulta_sql($con_pessoa);
					$reg_pessoa = consulta_ler_linha($res_pessoa);
					consulta_limpa($res_pessoa);
					$pessoa = $registro->Pessoa.'-'.$reg_pessoa[0];
				}					
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$pessoa, $fmt_txt_L);
				$coluna++;				

				if($registro->Modelo!='2D'){
					if($registro->Nr_Nota>0){
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                        ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                        ' and Empresa = "'.$registro->Empresa.'" '.
                                        ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                          ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                          ' and Empresa = "'.$registro->Empresa.'" '.
                                          ' and EmissaoPT = "P" '.
                                          ' and Modelo = "'.$registro->Modelo.'" '.
                                          ' and Serie = "'.$registro->Serie.'" '.
                                          ' and SubSerie = "'.$registro->SubSerie.'" '.
                                          ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
				}else{
					$reg_nota_fiscal[0] = 0;
				}
				$valor_desconto = $reg_nota_fiscal[0];
				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$valor_desconto = 0;
				}

				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF + $registro->Valor_Comissao);

					if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
						$con_nota_fiscal = 'SELECT Total_Produtos FROM nota_fiscal '.
										   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										   ' AND Empresa = "'.$registro->Empresa.'" '.
										   ' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
						$res_nota_fiscal = consulta_sql($con_nota_fiscal);
						$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
						consulta_limpa($res_nota_fiscal);
						$valor_liquido = $reg_nota_fiscal[0];
					}

					$total_dev_produto -= $valor_produto;
					$total_dev_desconto -= $valor_desconto;
					$total_dev_liquido -= $valor_liquido;
				}else{
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF - $registro->Valor_Comissao);

					if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
						$con_nota_fiscal = 'SELECT Total_Produtos FROM nota_fiscal '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$registro->Empresa.'" '.
										' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
						$res_nota_fiscal = consulta_sql($con_nota_fiscal);
						$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
						consulta_limpa($res_nota_fiscal);
						$valor_liquido = $reg_nota_fiscal[0];
					}

					$total_vend_produto  += $valor_produto;
					$total_vend_desconto += $valor_desconto;
					$total_vend_liquido  += $valor_liquido;
				}

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){

					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt);
					$coluna++;	
					
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt);
					$coluna++;	
					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
				}else{						
					$valor = $valor_produto;
					if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
						$valor = '-'.$valor;
					}
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor);
					$coluna++;

					$valor = $valor_desconto;
					if((($registro->TipoMov=='D')||($registro->TipoMov=='C'))&&($valor_desconto!=0)){
						$valor = '-'.$valor;
					}					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor);
					$coluna++;						
				}

				//echo $registro->Valor_NF;
				$valor = $registro->Valor_NF;
				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor = '-'.$valor;
				}				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor);
				$coluna++;	

				$percentual_comissao = 0;
				if($registro->Valor_NF > 0){
					$percentual_comissao = round(($registro->Valor_Comissao/$registro->Valor_NF*100),2);
				}

				if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
					$con_nota_fiscal = 'SELECT Total_ICMS_ST_Valor FROM nota_fiscal '.
									 ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									 ' AND Empresa = "'.$registro->Empresa.'" '.
									 ' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
					if(($registro->Valor_NF - $reg_nota_fiscal[0]) > 0){
						$percentual_comissao = round(($registro->Valor_Comissao/($registro->Valor_NF - $reg_nota_fiscal[0])*100),2);
					}
				}

				if($registro->Valor_NF>0){
					$valor = formata_qtd($percentual_comissao, 2, true); //PERCENTUAL
				}else{
					$valor = 0;
				}
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt);
				$coluna++;

				$valor = $registro->Valor_Comissao;  //VALOR COMISSAO
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor);
				$coluna++;

				$valor = $valor_liquido;  //VALOR LIQUIDO
				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor = '-'.$valor;
				}
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor);
				$coluna++;
				
				$_REQUEST['linha_ini']++;

            }else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){

				if($registro->Modelo!='2D'){
					$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
									 ' where Dominio = "'.$_SESSION['Dominio'].'" '.
									 ' and Empresa = "'.$_SESSION['Empresa_Codigo'].'" '.
									 ' and NrDoc = "'.$registro->Nr_Doc.'" '.
									 ' and Serie = "'.$registro->Serie.'" '.
									 ' and Modelo = "'.$registro->Modelo.'" ';
					if($registro->Nr_Nota>0){
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                        ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                        ' and Empresa = "'.$registro->Empresa.'" '.
                                        ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                          ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                          ' and Empresa = "'.$registro->Empresa.'" '.
                                          ' and EmissaoPT = "P" '.
                                          ' and Modelo = "'.$registro->Modelo.'" '.
                                          ' and Serie = "'.$registro->Serie.'" '.
                                          ' and SubSerie = "'.$registro->SubSerie.'" '.
                                          ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					
					
					
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
				}else{
					$reg_nota_fiscal[0]=0;
				}
				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$valor_desconto = 0;
				}
				$valor_desconto = $reg_nota_fiscal[0];

				if($_REQUEST['tipo_rel']=='SD'){
					if(!isset($lista_vendedor[$registro->DT_Emissao])){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_produto']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_desconto']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_liquido']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto'] =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido']  =0;

						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_venda']     =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_vendaAV']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_venda']    =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaCF']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_comissao'] =0;
					}

					if(!isset($lista_geral[$registro->DT_Emissao])){
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_produto']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_desconto']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_liquido']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto'] =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido']  =0;

						$lista_geral[$registro->DT_Emissao]['total_dia_dev_venda']     =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_vendaAV']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_venda']    =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaCF']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_comissao'] =0;
					}
				}

				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF + $registro->Valor_Comissao);

					$total_vend_liquido  -= $valor_liquido;
					$total_vend_desconto -= $valor_desconto;
					$total_vend_produto  -= $valor_produto;

					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto'] -=$valor_produto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto']-=$valor_desconto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido'] -=$valor_liquido;

						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto'] -=$valor_produto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto']-=$valor_desconto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido'] -=$valor_liquido;
					}
				}else{
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF - $registro->Valor_Comissao);

					$total_vend_liquido  += $valor_liquido;
					$total_vend_desconto += $valor_desconto;
					$total_vend_produto  += $valor_produto;

					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto'] +=$valor_produto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto']+=$valor_desconto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido'] +=$valor_liquido;

						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto'] +=$valor_produto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto']+=$valor_desconto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido'] +=$valor_liquido;
					}
				}
            }

            //calcula o total por dia

            if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
				$total_dev_venda-= $registro->Valor_NF;
				$total_dev_comissao+= $registro->Valor_Comissao; // positivo a devoluo pois no BD  armazenado o valor negativo ( + * - = -)
				//$total_geral_venda-= $registro->Valor_NF;
				$total_dev_vendaAV-= $registro->Valor_NF;
				$total_venda_dia[$registro->DT_Emissao]-= $registro->Valor_NF;

				if($_REQUEST['tipo_rel']=='SD'){
					$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_venda']    -= $registro->Valor_NF;
					$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_vendaAV']  -= $registro->Valor_NF;

					$lista_geral[$registro->DT_Emissao]['total_dia_dev_venda']    -= $registro->Valor_NF;
					$lista_geral[$registro->DT_Emissao]['total_dia_dev_vendaAV']  -= $registro->Valor_NF;
				}

            }else{
				$total_vend_venda+= $registro->Valor_NF;
				$total_vend_comissao+= $registro->Valor_Comissao;
				$total_venda_dia[$registro->DT_Emissao]+= $registro->Valor_NF;

				//$total_geral_venda+= $registro->Valor_NF;

				if($_REQUEST['tipo_rel']=='SD'){
					$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_venda']  += $registro->Valor_NF;
					$lista_geral[$registro->DT_Emissao]['total_dia_vend_venda']  += $registro->Valor_NF;
				}

				//TODO: Thiago Fazer Funo
				//se cupom
				if(($registro->Modelo=='2D')||($registro->Modelo=='65')||($registro->Modelo=='59')){ //CF/NFC-e/SAT-CF-e
					$total_vend_vendaCF+=$registro->Valor_NF;
					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaCF']  += $registro->Valor_NF;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaCF']  += $registro->Valor_NF;
					}
				}else if($registro->Tipo=='E'){
					//else se manual
					$total_vend_vendaAV+=$registro->Valor_NF;
					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
					}
				}else{
					//else
					if($registro->Nr_Nota>0){
						$con_nf = 'select Nr_Nota, Forma_Pagto from nota_fiscal '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
								   ' and Empresa = "'.$registro->Empresa.'" '.
								   ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nf = 'select Nr_Nota, Forma_Pagto from nota_fiscal '.
								  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
								  ' and Empresa = "'.$registro->Empresa.'" '.
								  ' and EmissaoPT = "P" '.
								  ' and Modelo = "'.$registro->Modelo.'" '.
								  ' and Serie = "'.$registro->Serie.'" '.
								  ' and SubSerie = "'.$registro->SubSerie.'" '.
								  ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					$res_nf = consulta_sql($con_nf);
					$reg_nf = consulta_ler_linha($res_nf);
					consulta_limpa($res_nf);
					//busca nota pra saber se avista ou a prazo
					if($reg_nf[0]>0){
						//se plano <=1
						if($reg_nf[1]<=1){
							$total_vend_vendaAV+=$registro->Valor_NF;
							if($_REQUEST['tipo_rel']=='SD'){
								$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
								$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
							}
						}else{
							$total_vend_vendaPZ+=$registro->Valor_NF;
							if($_REQUEST['tipo_rel']=='SD'){
								$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  += $registro->Valor_NF;
								$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  += $registro->Valor_NF;
							}
						}
					}
				}
				//TODO: Thiago Fim Funo
            }

            //$total_vend_comissao+= $registro->Valor_Comissao;
            if($_REQUEST['tipo_rel']=='SD'){
				$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_comissao']  += $registro->Valor_Comissao;
				$lista_geral[$registro->DT_Emissao]['total_dia_vend_comissao']  += $registro->Valor_Comissao;
            }
            //$total_dia_vend_comissao+= $registro->Valor_Comissao;
            //$total_geral_comissao+= $registro->Valor_Comissao;

/*
            $total_dia_vend_produto+= $total_vend_produto;
            $total_dia_vend_desconto+= $total_vend_desconto;
            $total_dia_vend_venda+= $total_vend_venda;
            $total_dia_vend_comissao+= $total_vend_comissao;
            $total_dia_vend_liquido+= $total_vend_liquido;

            $total_dia_dev_produto+= $total_dev_produto;
            $total_dia_dev_desconto+= $total_dev_desconto;
            $total_dia_dev_venda+= $total_dev_venda;
            $total_dia_dev_comissao+= $total_dev_comissao;
            $total_dia_dev_liquido+= $total_dev_liquido;

            $total_dia_vend_vendaAV+= $total_vend_vendaAV;
            $total_dia_dev_vendaAV+= $total_dev_vendaAV;
            $total_dia_vend_vendaPZ+= $total_vend_vendaPZ;
            $total_dia_vend_vendaCF+= $total_vend_vendaCF;
*/

            if(($_REQUEST['tipo_rel']=='D') || ($comissao_itens)){
				if(($registro->Tipo == 'E')&&($registro->Observacao!='')){
					$coluna=0;

					$valor = ' ';
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $frm_txtL);
					$coluna++;

					$valor = 'Obs: '.$registro->Observacao;
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $frm_txtL);
					$coluna++;
					
					
					//$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				

					$_REQUEST['linha_ini']++;

				}else{
					if($registro->Modelo == '2D'){
						$con_item = 'select eci.Id_Produto, eci.Descricao_Produto as Prod_Descricao, eci.Perc_Comissao, eci.Valor_Comissao, '.
									 ' eci.Quantidade as Quantidade_Estoque, eci.Preco as Valor_Unitario, eci.ValorTotal as Valor_Total,'.
									 ' eci.Perc_ComissaoG, eci.Valor_ComissaoG '.
									 ' from ecf_cupom_item eci '.
									 ' Where eci.Dominio = "'.$_SESSION['Dominio'].'"'.
									 ' and eci.Empresa = "'.$registro->Empresa.'"'.
									 ' and eci.NrFab = "'.$registro->ECF_NrFab.'"'.
									 ' and eci.LetraMF = "'.$registro->ECF_LetraMF.'"'.
									 ' and eci.DT_Emissao = "'.$registro->DT_Emissao.'"'.
									 ' and eci.COO = "'.$registro->Nr_Doc.'"'.
									 ' and eci.Cancelado="N" '.
									 ' and eci.Id_Produto>0 '.
									 ' order by eci.Seq_Item';
					}else{
						$con_item = 'select nfi.Id_Produto, nfi.Prod_Descricao, nfi.Perc_Comissao, nfi.Valor_Comissao, '.
									 ' nfi.Quantidade_Estoque, nfi.Valor_Unitario, nfi.Valor_Total, '.
									 ' nfi.Perc_ComissaoG, nfi.Valor_ComissaoG '.
									 ' from nota_fiscal_item nfi '.
									 ' where nfi.Dominio = "'.$_SESSION['Dominio'].'"'.
									 ' and nfi.Empresa="'.$registro->Empresa.'" '.
									 ' and nfi.Nr_Nota = "'.$registro->Nr_Nota.'" '.
									 ' order by nfi.Seq_Item';
					}

					$res_item = consulta_sql($con_item);
					$nrows_item = consulta_num_registros($res_item);

					if($nrows_item>0){
						for($nfi=0;$nfi<$nrows_item;$nfi++){
							$reg_item = consulta_ler_objeto($res_item);

							$coluna =0;

							$valor = ' ';
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $frm_txt_IL);
							$coluna++;
							
							
							$cons_prd = 'select Codigo_Produto, Descricao_Completa from produto '.
									   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
									   ' and Id_Produto = "'.$reg_item->Id_Produto.'"';
							$res_prd = consulta_sql($cons_prd);
							$reg_prd = consulta_ler_linha($res_prd);
							consulta_limpa($res_prd);
							$desc_prod = $reg_prd[1];

							$valor = $reg_prd[0].'-'.$reg_prd[1];
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_IL);
							$coluna++;

							$valor = '';
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_IL);
							$coluna++;
							
							$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-2, $_REQUEST['linha_ini'], $coluna-1);
				
							$valor = formata_qtd($reg_item->Quantidade_Estoque,3,false);
							$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_I);
							$coluna++;

							$valor = $reg_item->Valor_Unitario;
							$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor_I);
							$coluna++;

							if($comissao_itens){
								$valor = $reg_item->Valor_Total;
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor_I);
								$coluna++;

								$valor = formata_qtd($reg_item->Perc_Comissao, 2, true);
								if($registro->Gerente == (-2)){
									$valor = formata_qtd($reg_item->Perc_ComissaoG, 2, true);
								}
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_I);
								$coluna++;

								$valor = $reg_item->Valor_Comissao;
								if($registro->Gerente == (-2)){
									$valor = $reg_item->Valor_ComissaoG;
								}
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor_I);
								$coluna++;

								$valor = $reg_item->Valor_Total - $reg_item->Valor_Comissao;
								if($registro->Gerente == (-2)){
									$valor = $reg_item->Valor_Total - $reg_item->Valor_ComissaoG;
								}
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor_I);
								$coluna++;
							}else{
								$valor = $reg_item->Valor_Total;
								$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_valor_I);
								$coluna++;
								
								$valor = '';
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_I);
								$coluna++;

								$valor = '';
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_I);
								$coluna++;

								$valor = ' ';
								$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$valor, $fmt_txt_I);
								$coluna++;
								
								$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
							}
							$_REQUEST['linha_ini']++;							
						}
					}
					consulta_limpa($res_item);
				}
            }
		}		

		if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){
            $coluna=0;           
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Venda:', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;           

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;  

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
				
            }else{
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_produto, $fmt_valor_B);				
				$coluna++;  
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_desconto, $fmt_valor_B);
				$coluna++; 
            }
			
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido, $fmt_valor_B);
			$coluna++;          
           
			$_REQUEST['linha_ini']++;

			$coluna=0;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Devolues:', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;
            
            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
				
			}else{
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_produto, $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_desconto, $fmt_valor_B);
				$coluna++;
            }
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_venda, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_comissao, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_liquido, $fmt_valor_B);
			$coluna++;
           
            $_REQUEST['linha_ini']++;


            $coluna=0;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total do '.$label.' - Saldo:', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;
            
            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
				
            }else{
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_produto+$total_dev_produto, $fmt_valor_B);
				$coluna++;
			
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_desconto+$total_dev_desconto, $fmt_valor_B);
				$coluna++;			
            }			
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao+$total_dev_comissao, $fmt_valor_B);
			$coluna++;
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido+$total_dev_liquido, $fmt_valor_B);
			$coluna++;            

            $_REQUEST['linha_ini']++;

            $total_geral_liquido += $total_vend_liquido;
            $total_geral_produto += $total_vend_produto;
            $total_geral_venda += $total_vend_venda;
            $total_geral_desconto += $total_vend_desconto;
            $total_geral_comissao += $total_vend_comissao;

            $total_geraldev_liquido += $total_dev_liquido;
            $total_geraldev_produto += $total_dev_produto;
            $total_geraldev_venda += $total_dev_venda;
            $total_geraldev_desconto += $total_dev_desconto;
            $total_geraldev_comissao += $total_dev_comissao;

         }else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){

            if(($_REQUEST['tipo_rel']=='SD')&&($ok_vendedor)){
				$_REQUEST['linha_ini']++;
				$_REQUEST['linha_ini']++;
            }
			$coluna=0;
			
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	$desc_vendedor, $fmt_txt_BL);
			$coluna++;           
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++;  
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
			$coluna++; 
			
			$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
			
            if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
				$coluna++;  
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaAV+$total_dev_vendaAV, $fmt_valor_B);
				$coluna++;  
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaPZ, $fmt_valor_B);
				$coluna++;  
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_vendaCF, $fmt_valor_B);
				$coluna++; 

				if(($total_vend_venda+$total_dev_venda)!=0){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round($total_vend_comissao/($total_vend_venda+$total_dev_venda)*100,2), $fmt_txt_B);
				}else{
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				}
				$coluna++; 
            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda, $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_dev_venda, $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_venda+$total_dev_venda, $fmt_valor_B);
				$coluna++;
				
				if(($total_vend_venda+$total_dev_venda)!=0){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round(($total_vend_comissao+$total_dev_comissao)/($total_vend_venda+$total_dev_venda)*100,2), $fmt_txt_B);
				}else{
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				}
				$coluna++;
            }else{
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $total_vend_produto, $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $total_vend_desconto, $fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $total_vend_venda, $fmt_valor_B);
				$coluna++;	

				if($total_vend_venda!=0){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	round($total_vend_comissao/$total_vend_venda*100,2), $fmt_txt_B);
				}else{
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				}
				$coluna++;	
            }
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_comissao+$total_dev_comissao, $fmt_valor_B);
			$coluna++;	
           
			//if($cod_dominio_pz!=$_SESSION['Dominio']){
			if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_vend_liquido+$total_dev_liquido, $fmt_valor_B);
				$coluna++;					
			}

            $_REQUEST['linha_ini']++;

            if($_REQUEST['tipo_rel']=='SD'){
				//tambem totalizar o dia
				exibe_dias_vendedor($worksheet1, $lista_vendedor,$cod_dominio_pz,$cod_dominio,$fmt_txt_B,$fmt_txt_BR,$fmt_valor_B);
				$lista_vendedor = array();
            }

            $total_geral_produto  += $total_vend_produto;
            $total_geral_desconto += $total_vend_desconto;
            $total_geral_venda    += $total_vend_venda;
            $total_geral_comissao += $total_vend_comissao;
            $total_geral_liquido  += $total_vend_liquido;

            $total_geraldev_produto  += $total_dev_produto;
            $total_geraldev_desconto += $total_dev_desconto;
            $total_geraldev_venda    += $total_dev_venda;
            $total_geraldev_comissao += $total_dev_comissao;
            $total_geraldev_liquido  += $total_dev_liquido;

            $total_geral_vendaAV     += $total_vend_vendaAV;
            $total_geraldev_vendaAV  += $total_dev_vendaAV;
            $total_geral_vendaPZ     += $total_vend_vendaPZ;
            $total_geral_vendaCF     += $total_vend_vendaCF;

		}

		//TOTAL GERAL
		if($_REQUEST['vendedor']==''){
            if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){	
				$coluna=0;

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total Geral - Venda:', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;			

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;	
					
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;
					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
									
				}else{	
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_produto, $fmt_valor_B);
					$coluna++;	
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_desconto, $fmt_valor_B);
					$coluna++;	
				}

				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_venda, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_comissao, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_liquido, $fmt_valor_B);
				$coluna++;	

				$_REQUEST['linha_ini']++;
				
				$coluna=0;

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total Geral - Devolues:', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
								

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;
					
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;
					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
									
				}else{	
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
								
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_produto, $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_desconto, $fmt_valor_B);
					$coluna++;				
				}


				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_venda, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_comissao, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_liquido, $fmt_valor_B);
				$coluna++;
				
				$_REQUEST['linha_ini']++;

				$coluna=0;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total Geral - Saldo:', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;				

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;
					
					$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
					$coluna++;
					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-5, $_REQUEST['linha_ini'], $coluna-1);
				
				}else{					
					$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_produto+$total_geraldev_produto, $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_desconto+$total_geraldev_desconto, $fmt_valor_B);
					$coluna++;
				}
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_venda+$total_geraldev_venda, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_comissao+$total_geraldev_comissao, $fmt_valor_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_liquido+$total_geraldev_liquido, $fmt_valor_B);
				$coluna++;				

				$_REQUEST['linha_ini']++;

            }else if($_REQUEST['tipo_rel']=='S'){
				$coluna=0;			
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'Total Geral:', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_BL);
				$coluna++;	
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				
				
				if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){

					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_venda+$total_geraldev_venda, $fmt_valor_B);
					$coluna++;

					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_vendaAV+$total_geraldev_vendaAV, $fmt_valor_B);
					$coluna++;

					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_vendaPZ, $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_vendaCF, $fmt_valor_B);
					$coluna++;

				}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_venda, $fmt_valor_B);
					$coluna++;	
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geraldev_venda, $fmt_valor_B);
					$coluna++;	
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_venda+$total_geraldev_venda, $fmt_valor_B);
					$coluna++;						
				}else{
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_produto+$total_geraldev_produto, $fmt_valor_B);
					$coluna++;	
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_desconto+$total_geraldev_desconto, $fmt_valor_B);
					$coluna++;	
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	($total_geral_produto+$total_geraldev_produto) - ($total_geral_desconto+$total_geraldev_desconto), $fmt_valor_B);
					$coluna++;						
				}
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna,	'', $fmt_txt_B);
				$coluna++;	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $total_geral_comissao, $fmt_valor_B);
				$coluna++;	
				
				
				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){	
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna,	$total_geral_liquido, $fmt_valor_B);
					$coluna++;	
					
				}
				$_REQUEST['linha_ini']++;				
			}
        }

        //resumo dos totais por dia
        if($_REQUEST['tipo_rel']=='SD'){
            $totais_sd=array();
            $totais_sd['valor_venda_total']=0;
            $totais_sd['valor_dev_total']=0;
            $totais_sd['valor_saldo_total']=0;
            $totais_sd['valor_comissao_total']=0;
            $totais_sd['valor_liq_total']=0;
            $totais_sd['valor_vista_total']=0;
            $totais_sd['valor_prazo_total']=0;
            $totais_sd['valor_cupom_total']=0;
            $totais_sd['valor_produto_total']=0;
            $totais_sd['valor_desconto_total']=0;
            ksort($lista_geral);
            //var_dump($lista_geral);
            //calcula os totais (sinttico por dia)
            foreach($lista_geral as $diaT => $valorT){
                $dadosT = $lista_geral[$diaT];
                if(($cod_dominio_pz==$_SESSION['Dominio'])||( Zathura() )){
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda']);
					$totais_sd['valor_vista_total']+=($dadosT['total_dia_vend_vendaAV']+$dadosT['total_dia_dev_vendaAV']);
					$totais_sd['valor_prazo_total']+=($dadosT['total_dia_vend_vendaPZ']);
					$totais_sd['valor_cupom_total']+=($dadosT['total_dia_vend_vendaCF']);
                }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']);
					$totais_sd['valor_dev_total']+=($dadosT['total_dia_dev_venda']);
					$totais_sd['valor_saldo_total']+=($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda']);
				}else{
					$totais_sd['valor_produto_total']+=($dadosT['total_dia_vend_produto']);
					$totais_sd['valor_desconto_total']+=($dadosT['total_dia_vend_desconto']);
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']);
				}
				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
					$totais_sd['valor_liq_total']+=$dadosT['total_dia_vend_liquido'];
				}
				//comum  todos os domnios
				$totais_sd['valor_comissao_total']+=$dadosT['total_dia_vend_comissao'];
            }
            $_REQUEST['linha_ini']++;
			$_REQUEST['linha_ini']++;

			$coluna=0;           
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, 'TOTAL GERAL',$fmt_txt_BL);
			$coluna++;
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BL);
			$coluna++;	
			
			$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BL);
			$coluna++;  
			$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
							

            if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_venda_total'],	$fmt_valor_B);
				$coluna++; 
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_vista_total'],	$fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_prazo_total'],	$fmt_valor_B);
				$coluna++; 
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_cupom_total'],	$fmt_valor_B);
				$coluna++;  

				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BL);
				$coluna++; 				
				
            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_venda_total'],	$fmt_valor_B);
				$coluna++; 	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_dev_total'], $fmt_valor_B);
				$coluna++; 	
				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_saldo_total'],	$fmt_valor_B);
				$coluna++; 	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BL);
				$coluna++; 
            }else{
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_produto_total'],	$fmt_valor_B);
				$coluna++;

				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_desconto_total'],	$fmt_valor_B);
				$coluna++;

				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_venda_total'],	$fmt_valor_B);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BL);
				$coluna++;	
            }
			
			$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_comissao_total'],	$fmt_valor_B);
			$coluna++;           

            //if($cod_dominio_pz!=$_SESSION['Dominio']){
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){				
				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $totais_sd['valor_liq_total'],	$fmt_valor_B);
				$coluna++;				
            }

           $_REQUEST['linha_ini']++;

            foreach($lista_geral as $diaT => $valorT){
				$dadosT = $lista_geral[$diaT];

				$coluna=0;				
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, 'Total do Dia: '.dataf($diaT),	$fmt_txt_BR);
				$coluna++;
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BR);
				$coluna++;	
				
				$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',	$fmt_txt_BR);
				$coluna++;
				
				$worksheet1->merge_cells($_REQUEST['linha_ini'], $coluna-3, $_REQUEST['linha_ini'], $coluna-1);
				

				if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'],	$fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_vendaAV']+$dadosT['total_dia_dev_vendaAV'], $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_vendaPZ'],	$fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_vendaCF'],	$fmt_valor_B);
					$coluna++;

					if(($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])!=0){
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, round($dadosT['total_dia_vend_comissao']/($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])*100,2), $fmt_txt_B);
					}else{
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '',$fmt_txt_B);
					}
					$coluna++;
				}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_venda'], $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_dev_venda'], $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'], $fmt_valor_B);
					$coluna++;					

					$perc_comissao=0;
					if(($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])>0){
						$perc_comissao = round($dadosT['total_dia_vend_comissao']/($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])*100,2);
					}					
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $perc_comissao, $fmt_txt_B);
					$coluna++;
				}else{
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_produto'], $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_desconto'], $fmt_valor_B);
					$coluna++;
					
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_venda'], $fmt_valor_B);
					$coluna++;
					
					
					if($dadosT['total_dia_vend_venda']!=0){
						$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, round($dadosT['total_dia_vend_comissao']/$dadosT['total_dia_vend_venda']*100,2), $fmt_txt_B);
					}else{
						$worksheet1->write_string($_REQUEST['linha_ini'], $coluna, '', $fmt_txt_B);
					}
					$coluna++;
				}

				$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_comissao'],	$fmt_valor_B);
				$coluna++;				

				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){	
					$worksheet1->write_number($_REQUEST['linha_ini'], $coluna, $dadosT['total_dia_vend_liquido'], $fmt_valor_B);
					$coluna++;
				}

				$_REQUEST['linha_ini']++;

            }
		}
	}else{
		$_REQUEST['linha_ini']++;		
		$coluna=0;
		
		$worksheet1->write($_REQUEST['linha_ini'], $coluna, 'No existem registros para este filtro!');
		$coluna++;		
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();
	

?>