<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	
	define('FPDF_FONTPATH', '../../fpdf/font/');
	require('../../fpdf/fpdf.php');
if(session::usr_conectado($_REQUEST['USER_ID']) ){

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$label = label_vendedor_ou_rep_comercial('S');
	$filtro = '';


	$cod_dominio = '122'; //122 ou 191
	$cod_dominio_pz = '83';

	$gera_comissao = BuscaParam('COMISSAO_AUTO');

	//$_REQUEST['tipo_rel'] = 'D';
	$comissao_itens = (($gera_comissao == "P") && ($_REQUEST['tipo_rel'] == 'A'));
	//$comissao_itens = false;

	class PDF extends FPDF{
        var $TipoRel;

        function Header($tipo_cab='tudo'){
            if ($this->DefOrientation=='P'){
                $tamanho_total_linha = 190;
            }else{
                $tamanho_total_linha = 275;
            }
            $this->SetFillColor(255,255,255);
            $date=getdate();
            $hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
            $hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);

            $consulta_usuario = 'select Nome from usuario '.
                                ' where Dominio="'.$_SESSION["Dominio"].'"'.
                                ' and Usuario = "'.base64_decode_si($_REQUEST['USER_ID']).'"';
            $res = consulta_sql($consulta_usuario);
            $row = consulta_ler_linha($res);
            $nome_usuario = $row[0];
            consulta_limpa($res);

            $cons_emp = 'select Nome_Razao from pessoa '.
                        ' where Dominio="'.$_SESSION["Dominio"].'"'.
                        ' and Pessoa = "'.$_SESSION['Empresa_Codigo'].'"';
            $res_emp = consulta_sql($cons_emp);
            $row_emp = consulta_ler_linha($res_emp);

            $nome_razao = $row_emp[0];
            consulta_limpa($res_emp);

            //Seleciona fonte Arial 8
            $this->SetFont('Arial','B',10);
            //Imprime Cabealho
            $this->Cell(1,  15, ' ', 0,0,'C');
            if($this->Logotipo){
				$h=60;
				$w=0;
				$x=28;
				$y=5;
				$logo=busca_imagem_empresa('logo_menu.jpg', '../../');
				if(file_exists($logo)){
					$logoInfo = getimagesize($logo);
					//largura da imagem em mm
					$logoWmm = ($logoInfo[0]/72)*25.4;
					//altura da imagem em mm
					$logoHmm = ($logoInfo[1]/72)*25.4;
					$nImgH = round($h/3, 0);
					$nImgW = round($logoWmm * ($nImgH/$logoHmm), 0);
					$xImg = round(($w-$nImgW)/2+$x, 0);
					$yImg = $y;
					$this->Image($logo, $xImg, $yImg, $nImgW, $nImgH);
				}
				$this->Cell(30, 15, " ", 0,0,'L');
            }else if ($tipo_cab=='tudo'){
				$this->Cell(30, 15, "Data: ".dataf($hoje), 0,0,'L');
            }else{
				$this->Cell(30, 15, " ", 0,0,'L');
            }
            $lns_cabecalho = $this->Lines_MultiCell(($tamanho_total_linha-60),5,$this->Cabecalho,1);
            $y=$this->y;
            $this->MultiCell(($tamanho_total_linha-60), (15/($lns_cabecalho*5)) * 5, $this->Cabecalho, 0,'C');
            $this->y=$y;

            if($this->Logotipo){

            }else if ($tipo_cab=='tudo'){
				$this->Cell(30, 15, "Hora: ".($hora), 0,0,'R');
            }

            $this->Cell(1,  15, ' ', 0,1,'C');

            //Seleciona fonte Arial 8
            $this->SetFont('Arial','',8);
            //Imprime Cabealho
            if ($tipo_cab=='tudo'){
				$this->Cell(1,  10, ' ', 0,0,'C');
				$this->Cell(($tamanho_total_linha/2), 10,$nome_razao, 0,0,'L'); //config_pad('sistema_licenca')
				$this->Cell(($tamanho_total_linha/2), 10, $nome_usuario, 0,0,'R');
				$this->Cell(1,  10, ' ', 0,1,'C');
            }

            if($this->Sub_Cabecalho_Texto!=''){
				$this->SetFont('Arial',$this->Sub_Cabecalho_Style,10);
				$lns_cabecalho = $this->Lines_MultiCell($tamanho_total_linha,5,$this->Sub_Cabecalho_Texto,$this->Sub_Cabecalho_Border);
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,0,'C');
				$y=$this->y;
				$this->MultiCell($tamanho_total_linha, 5 , $this->Sub_Cabecalho_Texto, $this->Sub_Cabecalho_Border,$this->Sub_Cabecalho_Align);
				$this->y=$y;
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,1,'C');
				$this->x=$this->lMargin;
				$this->y=$y+($lns_cabecalho*5);
				$this->SetAutoPageBreak(true,30);
				$this->SetFont('Arial','',8);
            }else if($this->CabecalhoGrid_Texto != ''){
                $this->Cell(1,  5, ' ', 0,0,'C');
                $this->SetFont('Arial','B',8);

                foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');

				//quebra de pgina - cabecalho do item
				if(isset($this->CabecalhoGrid_Texto_Item)){
					$this->Cell(1,  5, ' ', 0,0,'C');
					$this->SetFont('Arial','B',8);
					foreach($this->CabecalhoGrid_Texto_Item as $key => $reg){
						$tamanho = $this->CabecalhoGrid_Tamanho_Item[$key];
						$tamanho = $tamanho/100;
						$tamanho = $tamanho_total_linha*$tamanho;
						$valor = $this->CabecalhoGrid_Texto_Item[$key];
						$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border_Item[$key],0,$this->CabecalhoGrid_Align_Item[$key]);
					}
					$this->Cell(1,  5, ' ', 0,1,'C');
				}
            }
            $this->SetFont('Arial','',8);
		}
	}


	//DEFINE VALOR DAS COMISSES
	$con_comissao = 'select Empresa, Nr_Comissao, Valor_NF, Vendedor '.
				  ' from comissao '.
				  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				//  ' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
				  //' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
				  //' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" '.
					' and Valor_Comissao = 0 '.
				  // ' and TipoMov = "F" '.
				  ' and Situacao = "A" ';

	if($gera_comissao=='Q'){
		if ($_SESSION['Dominio']==2){
			$con_comissao.= ' and DT_Emissao >= "2018-01-01" ';
		}else{
			$con_comissao.= ' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
                            ' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" ';
		}//Adicionado em 05/06/2023 por @isabel
	}else{
        if(($gera_comissao=='T')&&($_SESSION['Dominio']==11)){
        }else{
            $con_comissao.= ' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
                            ' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" ';
        }
    }

    if($_REQUEST['pessoa']!=''){
        $con_comissao.= ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';
    }

    if($_REQUEST['vendedor']!=''){
        $con_comissao.= ' and Vendedor = "'.$_REQUEST['vendedor'].'" ';
    }

	/**Modificado para Dominio 431 em 06-03-2023  */
	$dom_comissao_zero = (($_SESSION['Dominio'] == '359xx')||( $_SESSION['Dominio'] == '431' ));
	/*if( !$dom_comissao_zero  ){
		$con_comissao .=   ' and Valor_Comissao = 0 ';
	}*/

	//echo ' <br> linha 189: '. $con_comissao ;

    $res_comissao = consulta_sql($con_comissao);
    $nro_comissao = consulta_num_registros($res_comissao);

    if($nro_comissao>0){
        for($c=0;$c<$nro_comissao;$c++){
            $reg_comissao = consulta_ler_linha($res_comissao);
            financeiro_gera_comissao_define_valor($reg_comissao[0],
                                                   $reg_comissao[1],
                                                   $reg_comissao[3],
                                                   $reg_comissao[2]);
        }
    }
    consulta_limpa($res_comissao);

    $consulta = ' select Empresa, Nr_Comissao, Tipo, Nr_Nota, Nr_Doc, Modelo, Serie, SubSerie, DT_Emissao, Pessoa, Valor_NF, '.
                  ' Valor_Comissao, Vendedor, Situacao, Observacao, Contas_Baixa, Contas_Recebe, TipoMov, ECF_NrFab, ECF_LetraMF, '.
                  ' HR_Emissao, Gerente '.
                  ' from comissao '.
                  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
				//  ' AND Empresa="'.$_SESSION['Empresa_Codigo'].'"'.
                  ' and DT_Emissao >= "'.datad($_REQUEST['data_ini']).'" '.
                  ' and DT_Emissao <= "'.datad($_REQUEST['data_fim']).'" '.
                //  ' and Valor_Comissao <> 0'.
                  ' and Situacao <> "C" and Situacao <> "E" ';

    $filtro = 'Perodo: De "'.$_REQUEST['data_ini'].'"'.
                ' At "'.$_REQUEST['data_fim'].'"';

    if($_REQUEST['pessoa']!=''){
        $consulta.= ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';

        $con_pessoa_cliente = 'select Nome_Listas from pessoa '.
                               ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                               ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';
        $res_pessoa_cliente = consulta_sql($con_pessoa_cliente);
        $reg_pessoa_cliente = consulta_ler_linha($res_pessoa_cliente);
        consulta_limpa($res_pessoa_cliente);

        $filtro.= ' Cliente: "'.$_REQUEST['pessoa'].'-'.$reg_pessoa_cliente[0].'" ';
    }

    if($_REQUEST['vendedor']!=''){
        $consulta.= ' and Vendedor = "'.$_REQUEST['vendedor'].'" ';

        $con_pessoa_vendedor = 'select Nome_Listas from pessoa '.
                                ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                ' and Pessoa = "'.$_REQUEST['vendedor'].'" ';
        $res_pessoa_vendedor = consulta_sql($con_pessoa_vendedor);
        $reg_pessoa_vendedor = consulta_ler_linha($res_pessoa_vendedor);
        consulta_limpa($res_pessoa_vendedor);

        $filtro.= ' '.$label.': "'.$_REQUEST['vendedor'].'-'.$reg_pessoa_vendedor[0].'" ';
    }

	/**Modificacao realizada em 06-03-2023 para Dominio 431 por @isabel , refeito em 20/03/2023 
	 * se for dominio diferente dos que querem,  mostrar as comissoes que nao forem zero
	 * para os que pediram  mostra todas as comisses
	*/
	//if( !$dom_comissao_zero  ){
		$consulta .=   ' and ((Valor_Comissao <> 0) or (Situacao <> "A")) ';
	//}

    $consulta.= ' order by Vendedor, DT_Emissao, Nr_Comissao ';

	//echo '<br> linha 255 '.  $consulta ;

    function exibe_dias_vendedor(&$pdf, $lista_vendedor,$cod_dominio_pz,$cod_dominio){
        foreach($lista_vendedor as $dia => $valor){
            $dados = $lista_vendedor[$dia];

            $lns = 5;
            $larg = 275;

            $pdf->SetFont('Arial','',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','',8);
            $pdf->SetAutoPageBreak(false,30);

            $y=$pdf->y;
            $pdf->MultiCell((3/100)*$larg, $lns, '', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((37/100)*$larg, $lns, 'Total do Dia: '.dataf($dia), '', 'L');
            $pdf->y=$y;

            if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_vendaAV']+$dados['total_dia_dev_vendaAV'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_vendaPZ'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_vendaCF'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				if(($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])!=0){
					$pdf->MultiCell((10/100)*$larg, $lns, round($dados['total_dia_vend_comissao']/($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])*100,2), '', 'R');
				}else{
					$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				}

				$pdf->y=$y;

            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_venda'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_dev_venda'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'], false), '', 'R');
				$pdf->y=$y;

				$perc_comissao=0;
				if(($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])>0){
					$perc_comissao = round($dados['total_dia_vend_comissao']/($dados['total_dia_vend_venda']+$dados['total_dia_dev_venda'])*100,2);
				}
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, $perc_comissao, '', 'R');
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_produto'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_desconto'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_venda'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				if($dados['total_dia_vend_venda']!=0){
					$pdf->MultiCell((10/100)*$larg, $lns, round($dados['total_dia_vend_comissao']/$dados['total_dia_vend_venda']*100,2), '', 'R');
				}else{
					$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				}
				$pdf->y=$y;
            }

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_comissao'], false), '', 'R');
            $pdf->y=$y;
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
                $y=$pdf->y;
                $pdf->MultiCell((10/100)*$larg, $lns, to_money($dados['total_dia_vend_liquido'], false), '', 'R');
                $pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

		}
	}

	$pdf=new PDF('L');

	$pdf->Open();
	$pdf->Cabecalho =  'Relatrio de Comisses';
	$pdf->Cabecalho_Filtro =  $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	set_time_limit(60);
	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);
	if($nrows>0){

        $k=0;

        if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){
            $pdf->CabecalhoGrid_Texto[$k] = 'Data Comisso';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'C';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            $pdf->CabecalhoGrid_Texto[$k] = 'Nr Doc';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'C';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
				$pdf->CabecalhoGrid_Tamanho[$k] = '40';
				$pdf->CabecalhoGrid_Align[$k] = 'L';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$ncampos = 7;
            }else{
				$pdf->CabecalhoGrid_Texto[$k] = 'Cliente';
				$pdf->CabecalhoGrid_Tamanho[$k] = '20';
				$pdf->CabecalhoGrid_Align[$k] = 'L';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Produto';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Desconto';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$ncampos = 9;
            }

            $pdf->CabecalhoGrid_Texto[$k] = 'Valor NF';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            $pdf->CabecalhoGrid_Texto[$k] = 'Comisso (%)';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            $pdf->CabecalhoGrid_Texto[$k] = 'Valor Comisso';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            $pdf->CabecalhoGrid_Texto[$k] = 'Valor Lquido';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

		}else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){
            $pdf->CabecalhoGrid_Texto[$k] = $label;
            $pdf->CabecalhoGrid_Tamanho[$k] = '40';
            $pdf->CabecalhoGrid_Align[$k] = 'L';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            if(($cod_dominio_pz==$_SESSION['Dominio'])||  Zathura() ){
				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Venda';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = ' Vista';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = ' Prazo';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Cupom';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;
            }else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Venda';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Devoluo';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Saldo';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;
            }else{
				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Produto';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Desconto';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;

				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Venda';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;
            }

            $pdf->CabecalhoGrid_Texto[$k] = 'Comisso (%)';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;

            $pdf->CabecalhoGrid_Texto[$k] = 'Valor Comisso';
            $pdf->CabecalhoGrid_Tamanho[$k] = '10';
            $pdf->CabecalhoGrid_Align[$k] = 'R';
            $pdf->CabecalhoGrid_Border[$k] = 'TB';
            $k++;
            //if($cod_dominio_pz!=$_SESSION['Dominio']){
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
				$pdf->CabecalhoGrid_Texto[$k] = 'Valor Lquido';
				$pdf->CabecalhoGrid_Tamanho[$k] = '10';
				$pdf->CabecalhoGrid_Align[$k] = 'R';
				$pdf->CabecalhoGrid_Border[$k] = 'TB';
				$k++;
            }

            $ncampos = 7;
		}

		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		if(($_REQUEST['tipo_rel']=='D') || ($comissao_itens)){
            $lns = 5;
            $larg = 275;

            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);

            $m = 0;

            $pdf->CabecalhoGrid_Texto_Item[$m] = '';
            $pdf->CabecalhoGrid_Tamanho_Item[$m] = '4';
            $pdf->CabecalhoGrid_Align_Item[$m] = 'C';
            $pdf->CabecalhoGrid_Border_Item[$m] = 'B';
            $m++;

            $pdf->CabecalhoGrid_Texto_Item[$m] = 'Produto';
            $pdf->CabecalhoGrid_Tamanho_Item[$m] = '8';
            $pdf->CabecalhoGrid_Align_Item[$m] = 'L';
            $pdf->CabecalhoGrid_Border_Item[$m] = 'B';
            $m++;

            $pdf->CabecalhoGrid_Texto_Item[$m] = 'Descrio';
            $pdf->CabecalhoGrid_Tamanho_Item[$m] = '27';
            $pdf->CabecalhoGrid_Align_Item[$m] = 'L';
            $pdf->CabecalhoGrid_Border_Item[$m] = 'B';
            $m++;

            $pdf->CabecalhoGrid_Texto_Item[$m] = 'Quantidade';
            $pdf->CabecalhoGrid_Tamanho_Item[$m] = '10';
            $pdf->CabecalhoGrid_Align_Item[$m] = 'R';
            $pdf->CabecalhoGrid_Border_Item[$m] = 'B';
            $m++;

            $pdf->CabecalhoGrid_Texto_Item[$m] = 'Valor Unitrio';
            $pdf->CabecalhoGrid_Tamanho_Item[$m] = '10';
            $pdf->CabecalhoGrid_Align_Item[$m] = 'R';
            $pdf->CabecalhoGrid_Border_Item[$m] = 'B';
            $m++;

            if($comissao_itens){
				$pdf->CabecalhoGrid_Texto_Item[$m] = 'Valor Total';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '10';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'R';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;

				$pdf->CabecalhoGrid_Texto_Item[$m] = 'Perc.';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '11';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'R';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;

				$pdf->CabecalhoGrid_Texto_Item[$m] = 'Comisso';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '10';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'R';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;

				$pdf->CabecalhoGrid_Texto_Item[$m] = 'Lquido';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '10';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'R';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;
            }else{
				$pdf->CabecalhoGrid_Texto_Item[$m] = '';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '11';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'C';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;

				$pdf->CabecalhoGrid_Texto_Item[$m] = 'Valor Total';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '15';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'R';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;

				$pdf->CabecalhoGrid_Texto_Item[$m] = '';
				$pdf->CabecalhoGrid_Tamanho_Item[$m] = '5';
				$pdf->CabecalhoGrid_Align_Item[$m] = 'C';
				$pdf->CabecalhoGrid_Border_Item[$m] = 'B';
				$m++;
            }

            /* $pdf->Cell(1,      $lns, ' ', 0,1,'C');

            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);
            $pdf->SetFont('Arial','',8); */

            if($comissao_itens){
				$ncampos_item = 9;
            }else{
				$ncampos_item = 8;
            }

            //monta o subcabealho
            for($t=0;$t<$ncampos_item;$t++){
				$y=$pdf->y;
				$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$t]/100)*$larg, $lns, $pdf->CabecalhoGrid_Texto_Item[$t], $pdf->CabecalhoGrid_Border_Item[$t], $pdf->CabecalhoGrid_Align_Item[$t]);
				$pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);
		}

		$id_vendedor = '';
		$desc_vendedor = '';

		$valor_produto = 0;
		$total_produto = 0;
		$valor_liquido = 0;

		$total_vend_produto = 0;
		$total_vend_desconto = 0;
		$total_vend_venda = 0;
		$total_vend_comissao = 0;
		$total_vend_liquido = 0;

		$total_dev_produto = 0;
		$total_dev_desconto = 0;
		$total_dev_venda = 0;
		$total_dev_comissao = 0;
		$total_dev_liquido = 0;

		$total_geral_produto = 0;
		$total_geral_desconto = 0;
		$total_geral_venda = 0;
		$total_geral_comissao = 0;
		$total_geral_liquido = 0;

		$total_geraldev_produto = 0;
		$total_geraldev_desconto = 0;
		$total_geraldev_venda = 0;
		$total_geraldev_comissao = 0;
		$total_geraldev_liquido = 0;

		$total_geral_vendaAV=0;
		$total_geraldev_vendaAV=0;
		$total_geral_vendaPZ=0;
		$total_geral_vendaCF=0;

		$total_vend_vendaAV=0;
		$total_dev_vendaAV=0;
		$total_vend_vendaPZ=0;
		$total_vend_vendaCF=0;

		//total dia
		$total_dia_vend_produto = 0;
		$total_dia_vend_desconto = 0;
		$total_dia_vend_venda = 0;
		$total_dia_vend_comissao = 0;
		$total_dia_vend_liquido = 0;

		$total_dia_dev_produto = 0;
		$total_dia_dev_desconto = 0;
		$total_dia_dev_venda = 0;
		$total_dia_dev_comissao = 0;
		$total_dia_dev_liquido = 0;

		$total_dia_vend_vendaAV=0;
		$total_dia_dev_vendaAV=0;
		$total_dia_vend_vendaPZ=0;
		$total_dia_vend_vendaCF=0;

		$data_do_dia = '';
		$lista_vendedor = array();
		$ok_vendedor = false;

			//echo ' <br> linha 717: '. $nrows ;
		for($i=0;$i<$nrows;$i++){
            $registro = consulta_ler_objeto($resultado);
            set_time_limit(60);

			/**Modificacao realizada para DOM 431 em 07-03-2023 por @isabel */
			if( $dom_comissao_zero && ($registro->Vendedor == 125) ){
				$registro->Valor_Comissao = 0;
			}

            if($id_vendedor!=$registro->Vendedor){
				$lns = 5;
				if($id_vendedor !=''){

					$lns = 5;
					$larg = 275;

					if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){

						$pdf->SetFont('Arial','B',8);
						$pdf->Cell(1,      $lns, '', 0,0,'C');
						$pdf->SetFont('Arial','B',8);
						$pdf->SetAutoPageBreak(false,30);

						$y=$pdf->y;
						$pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Venda:', '', 'L');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;
						}else{
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto, false), '', 'R');
							$pdf->y=$y;
						}

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido, false), '', 'R');
						$pdf->y=$y;

						$pdf->Cell(1,      $lns, ' ', 0,1,'C');
						//Prxima Linha
						$pdf->x=$pdf->lMargin;
						$pdf->y=$y+$lns;
						$pdf->SetAutoPageBreak(true,30);

						$pdf->SetFont('Arial','B',8);
						$pdf->Cell(1,      $lns, '', 0,0,'C');
						$pdf->SetFont('Arial','B',8);
						$pdf->SetAutoPageBreak(false,30);

						$y=$pdf->y;
						$pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Devolues:', '', 'L');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;
						}else{
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_produto, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_desconto, false), '', 'R');
							$pdf->y=$y;
						}

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_venda, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_comissao, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_liquido, false), '', 'R');
						$pdf->y=$y;

						$pdf->Cell(1,      $lns, ' ', 0,1,'C');
						//Prxima Linha
						$pdf->x=$pdf->lMargin;
						$pdf->y=$y+$lns;
						$pdf->SetAutoPageBreak(true,30);

						$pdf->SetFont('Arial','B',8);
						$pdf->Cell(1,      $lns, '', 0,0,'C');
						$pdf->SetFont('Arial','B',8);
						$pdf->SetAutoPageBreak(false,30);

						$y=$pdf->y;
						$pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Saldo:', '', 'L');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
							$pdf->y=$y;
						}else{
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto+$total_dev_produto, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto+$total_dev_desconto, false), '', 'R');
							$pdf->y=$y;
						}

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao+$total_dev_comissao, false), '', 'R');
						$pdf->y=$y;

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido+$total_dev_liquido, false), '', 'R');
						$pdf->y=$y;

						$pdf->Cell(1,      $lns, ' ', 0,1,'C');
						//Prxima Linha
						$pdf->x=$pdf->lMargin;
						$pdf->y=$y+$lns;
						$pdf->SetAutoPageBreak(true,30);

						$total_geral_produto += $total_vend_produto;
						$total_geral_desconto += $total_vend_desconto;
						$total_geral_venda += $total_vend_venda;
						$total_geral_comissao += $total_vend_comissao;
						$total_geral_liquido += $total_vend_liquido;

						$total_geraldev_produto += $total_dev_produto;
						$total_geraldev_desconto += $total_dev_desconto;
						$total_geraldev_venda += $total_dev_venda;
						$total_geraldev_comissao += $total_dev_comissao;
						$total_geraldev_liquido += $total_dev_liquido;

					}else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){
						if(($_REQUEST['tipo_rel']=='SD')&&($ok_vendedor)){
							$pdf->AddPage();
						}
						$ok_vendedor = true;

						$pdf->SetFont('Arial','B',8);
						$pdf->Cell(1,      $lns, '', 0,0,'C');
						$pdf->SetFont('Arial','B',8);
						$pdf->SetAutoPageBreak(false,30);

						$y=$pdf->y;
						$pdf->MultiCell((40/100)*$larg, $lns, $desc_vendedor, '', 'L');
						$pdf->y=$y;
						if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaAV+$total_dev_vendaAV, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaPZ, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaCF, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							if(($total_vend_venda+$total_dev_venda)!=0){
								$pdf->MultiCell((10/100)*$larg, $lns, round($total_vend_comissao/($total_vend_venda+$total_dev_venda)*100,2), '', 'R');
							}else{
								$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
							}

							$pdf->y=$y;

						}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_venda, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							if(($total_vend_venda+$total_dev_venda)!=0){
								$pdf->MultiCell((10/100)*$larg, $lns, round(($total_vend_comissao+$total_dev_comissao)/($total_vend_venda+$total_dev_venda)*100,2), '', 'R');
							}else{
								$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
							}
							$pdf->y=$y;
						}else{
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto, false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							// to_money($total_vend_venda, @isabel
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda,  false), '', 'R');
							$pdf->y=$y;

							$y=$pdf->y;
							if($total_vend_venda!=0){
								$pdf->MultiCell((10/100)*$larg, $lns, round($total_vend_comissao/$total_vend_venda*100,2), '', 'R');
							}else{
								$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
							}
							$pdf->y=$y;
						}

						$y=$pdf->y;
						$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao+$total_dev_comissao, false), '', 'R');
						$pdf->y=$y;
						//if($cod_dominio_pz!=$_SESSION['Dominio']){
						if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
							$y=$pdf->y;
							$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido+$total_dev_liquido, false), '', 'R');
							$pdf->y=$y;
						}

						$pdf->Cell(1,      $lns, ' ', 0,1,'C');
						//Prxima Linha
						$pdf->x=$pdf->lMargin;
						$pdf->y=$y+$lns;
						$pdf->SetAutoPageBreak(true,30);

						if($_REQUEST['tipo_rel']=='SD'){
							//tambem totalizar o dia
							exibe_dias_vendedor($pdf, $lista_vendedor,$cod_dominio_pz,$cod_dominio);
							$lista_vendedor = array();
						}

						$total_geral_produto += $total_vend_produto;
						$total_geral_desconto += $total_vend_desconto;
						$total_geral_venda += $total_vend_venda;
						$total_geral_comissao += $total_vend_comissao;
						$total_geral_liquido += $total_vend_liquido;

						$total_geraldev_produto += $total_dev_produto;
						$total_geraldev_desconto += $total_dev_desconto;
						$total_geraldev_venda += $total_dev_venda;
						$total_geraldev_comissao += $total_dev_comissao;
						$total_geraldev_liquido += $total_dev_liquido;

						$total_geral_vendaAV+= $total_vend_vendaAV;
						$total_geraldev_vendaAV+= $total_dev_vendaAV;
						$total_geral_vendaPZ+= $total_vend_vendaPZ;
						$total_geral_vendaCF+= $total_vend_vendaCF;

						//estava aqui
					}
					//$data_do_dia = '';

					$total_vend_produto = 0;
					$total_vend_desconto = 0;
					$total_vend_venda = 0;
					$total_vend_comissao = 0;
					$total_vend_liquido = 0;

					$total_dev_produto = 0;
					$total_dev_desconto = 0;
					$total_dev_venda = 0;
					$total_dev_comissao = 0;
					$total_dev_liquido = 0;

					$total_vend_vendaAV=0;
					$total_dev_vendaAV=0;
					$total_vend_vendaPZ=0;
					$total_vend_vendaCF=0;
				}

				$id_vendedor = $registro->Vendedor;

				$con_vendedor = 'select Pessoa, Nome_Listas from pessoa '.
							   ' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							   ' and Pessoa = "'.$registro->Vendedor.'"'.
							   ' order by Nome_Listas ';
				$res_vendedor = consulta_sql($con_vendedor);
				$reg_vendedor = consulta_ler_linha($res_vendedor);
				consulta_limpa($res_vendedor);

				$label_emp = empresa_representante($registro->Vendedor,'S');

				$desc_vendedor = $label_emp;

				if(($_REQUEST['tipo_rel']!='S')&&($_REQUEST['tipo_rel']!='SD')){
					$pdf->SetFont('Arial','B',8);
					$pdf->SetAutoPageBreak(true,45);
					$pdf->Cell(1,      $lns, '', 0,0,'C');
					$pdf->SetAutoPageBreak(false,30);

					$pdf->SetFont('Arial','B',8);
					$larg = 275;

					$y=$pdf->y;
					$pdf->MultiCell($larg, $lns, ' '.$label.': '.$desc_vendedor, 'T', 'L');
					$pdf->y=$y;


					$pdf->Cell(1,      $lns, ' ', 0,1,'C');
					//Prxima Linha
					$pdf->x=$pdf->lMargin;
					$pdf->y=$y+$lns;
					$pdf->SetAutoPageBreak(true,30);
				}
            }
            /*
            if($_REQUEST['tipo_rel']=='SD'){

                  //echo 'Data: '.$registro->DT_Emissao.'<BR>';
                  if($data_do_dia!=$registro->DT_Emissao){
                    if($data_do_dia!=''){
                        //echo 'Total Dia: '.$data_do_dia.' != '.$registro->DT_Emissao.'<BR>';
                        $lns = 5;
                        $larg = 275;

                        $pdf->SetFont('Arial','',8);
                        $pdf->Cell(1,      $lns, '', 0,0,'C');
                        $pdf->SetFont('Arial','',8);
                        $pdf->SetAutoPageBreak(false,30);

                        $y=$pdf->y;
                        $pdf->MultiCell((3/100)*$larg, $lns, '', '', 'L');
                        $pdf->y=$y;

                        $y=$pdf->y;
                        $pdf->MultiCell((37/100)*$larg, $lns, 'Total do Dia: '.dataf($data_do_dia), '', 'L');
                        $pdf->y=$y;

                        if($cod_dominio_pz==$_SESSION['Dominio']){
                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_venda+$total_dia_dev_venda)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_vendaAV+$total_dia_dev_vendaAV)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_vendaPZ)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_vendaCF)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, round($total_dia_vend_comissao/($total_dia_vend_venda+$total_dia_dev_venda)*100,2), '', 'R');
                           $pdf->y=$y;

                        }else  if($cod_dominio==$_SESSION['Dominio']){
                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_venda)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_dev_venda)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_venda+$total_dia_dev_venda)), '', 'R');
                           $pdf->y=$y;

                           $perc_comissao=0;
                           if(($total_dia_vend_venda+$total_dia_dev_venda)>0){
                              $perc_comissao = round($total_dia_vend_comissao/($total_dia_vend_venda+$total_dia_dev_venda)*100,2);
                           }
                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, $perc_comissao, '', 'R');
                           $pdf->y=$y;
                        }else{
                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_produto)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_desconto)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_venda)), '', 'R');
                           $pdf->y=$y;

                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, round($total_dia_vend_comissao/$total_dia_vend_venda*100,2), '', 'R');
                           $pdf->y=$y;
                        }

                        $y=$pdf->y;
                        $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_comissao)), '', 'R');
                        $pdf->y=$y;
                        if($cod_dominio_pz!=$_SESSION['Dominio']){
                           $y=$pdf->y;
                           $pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_dia_vend_liquido)), '', 'R');
                           $pdf->y=$y;
                        }

                        $pdf->Cell(1,      $lns, ' ', 0,1,'C');
                        //Prxima Linha
                        $pdf->x=$pdf->lMargin;
                        $pdf->y=$y+$lns;
                        $pdf->SetAutoPageBreak(true,30);

                        $total_dia_vend_produto = 0;
                        $total_dia_vend_desconto = 0;
                        $total_dia_vend_venda = 0;
                        $total_dia_vend_comissao = 0;
                        $total_dia_vend_liquido = 0;

                        $total_dia_dev_produto = 0;
                        $total_dia_dev_desconto = 0;
                        $total_dia_dev_venda = 0;
                        $total_dia_dev_comissao = 0;
                        $total_dia_dev_liquido = 0;

                        $total_dia_vend_vendaAV=0;
                        $total_dia_dev_vendaAV=0;
                        $total_dia_vend_vendaPZ=0;
                        $total_dia_vend_vendaCF=0;
                    }
                     //$data_do_dia = $registro->DT_Emissao;
                     //echo 'Vend: '.$id_vendedor.' - Data: '.$data_do_dia.' - ';
                  }
            }
            */

            $data_do_dia = $registro->DT_Emissao;
            $lns = 0;
            $larg = 275;

            if(($_REQUEST['tipo_rel']!='S')&&($_REQUEST['tipo_rel']!='SD')){
				$k = 0;
				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetAutoPageBreak(false,30);
				$pdf->SetFont('Arial','',8);

				if(($_REQUEST['tipo_rel']=='D') || ($comissao_itens)){
					$pdf->SetFillColor(220,220,220);
				}

				$rowarr[$k]  =  dataf($registro->DT_Emissao);
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				if($registro->Nr_Doc==0){
					$nr_nf = '';
				}else if($registro->Modelo=='2D'){
					$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-2D';
				}else{
					$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo;
				}

				$rowarr[$k] = $nr_nf;
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				//somente para o detalhado
				if($_REQUEST['tipo_rel']=='D'){
					if(($registro->Modelo=='2D') && ($registro->Pessoa==0)){
						$pessoa = 'VENDA VIA ECF - CONSUMIDOR FINAL';
					}else if($registro->Pessoa==0){
						$pessoa = 'CONSUMIDOR NO IDENTIFICADO';
					}else{
						$con_pessoa = 'select Nome_Listas from pessoa '.
							' Where Dominio = "'.$_SESSION['Dominio'].'"'.
							' and Pessoa = "'.$registro->Pessoa.'"';
						$res_pessoa = consulta_sql($con_pessoa);
						$reg_pessoa = consulta_ler_linha($res_pessoa);
						consulta_limpa($res_pessoa);
						$pessoa = $registro->Pessoa.'-'.$reg_pessoa[0];
					}
					$rowarr[$k] = $pessoa;
					$vl_linha[$k] = $rowarr[$k];        //CLIENTE
					$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;
				}

				if($_REQUEST['tipo_rel']=='A'){
					$con_pessoa = 'select Nome_Listas from pessoa '.
								' Where Dominio = "'.$_SESSION['Dominio'].'"'.
								' and Pessoa = "'.$registro->Pessoa.'"';
					$res_pessoa = consulta_sql($con_pessoa);
					$reg_pessoa = consulta_ler_linha($res_pessoa);
					consulta_limpa($res_pessoa);

					$pessoa = $registro->Pessoa.'-'.$reg_pessoa[0];

					$rowarr[$k] = $pessoa;
					$vl_linha[$k] = $rowarr[$k];        //CLIENTE
					$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;
				}

				if($registro->Modelo!='2D'){
					if($registro->Nr_Nota>0){
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                        ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                        ' and Empresa = "'.$registro->Empresa.'" '.
                                        ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                          ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                          ' and Empresa = "'.$registro->Empresa.'" '.
                                          ' and EmissaoPT = "P" '.
                                          ' and Modelo = "'.$registro->Modelo.'" '.
                                          ' and Serie = "'.$registro->Serie.'" '.
                                          ' and SubSerie = "'.$registro->SubSerie.'" '.
                                          ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
				}else{
					$reg_nota_fiscal[0] = 0;
				}
				$valor_desconto = $reg_nota_fiscal[0];
				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$valor_desconto = 0;
				}

				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF + $registro->Valor_Comissao);

					if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
						$con_nota_fiscal = 'SELECT Total_Produtos FROM nota_fiscal '.
										   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										   ' AND Empresa = "'.$registro->Empresa.'" '.
										   ' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
						$res_nota_fiscal = consulta_sql($con_nota_fiscal);
						$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
						consulta_limpa($res_nota_fiscal);
						$valor_liquido = $reg_nota_fiscal[0];
					}

					$total_dev_produto -= $valor_produto;
					$total_dev_desconto -= $valor_desconto;
					$total_dev_liquido -= $valor_liquido;
				}else{
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF - $registro->Valor_Comissao);

					if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
						$con_nota_fiscal = 'SELECT Total_Produtos FROM nota_fiscal '.
										' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
										' AND Empresa = "'.$registro->Empresa.'" '.
										' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
						$res_nota_fiscal = consulta_sql($con_nota_fiscal);
						$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
						consulta_limpa($res_nota_fiscal);
						$valor_liquido = $reg_nota_fiscal[0];
					}

					$total_vend_produto  += $valor_produto;
					$total_vend_desconto += $valor_desconto;
					$total_vend_liquido  += $valor_liquido;
				}

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){

				}else{
					$rowarr[$k] = to_money($valor_produto, false);
					if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
						$rowarr[$k] = '-'.$rowarr[$k];
					}
					$vl_linha[$k] = $rowarr[$k];
					$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;

					$rowarr[$k] = to_money($valor_desconto, false);
					if((($registro->TipoMov=='D')||($registro->TipoMov=='C'))&&($valor_desconto!=0)){
						$rowarr[$k] = '-'.$rowarr[$k];
					}
					$vl_linha[$k] = $rowarr[$k];
					$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;
				}

				//echo $registro->Valor_NF;
				$rowarr[$k] = to_money($registro->Valor_NF, false);
				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$rowarr[$k] = '-'.$rowarr[$k];
				}
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$percentual_comissao = 0;
				if($registro->Valor_NF > 0){
					$percentual_comissao = round(($registro->Valor_Comissao/$registro->Valor_NF*100),2);
				}

				if(($gera_comissao == "P") && (($registro->Modelo == "55") || ($registro->Modelo == "01"))){
					$con_nota_fiscal = 'SELECT Total_ICMS_ST_Valor FROM nota_fiscal '.
									 ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
									 ' AND Empresa = "'.$registro->Empresa.'" '.
									 ' AND Nr_Nota = "'.$registro->Nr_Nota.'" ';
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
					if(($registro->Valor_NF - $reg_nota_fiscal[0]) > 0){
						$percentual_comissao = round(($registro->Valor_Comissao/($registro->Valor_NF - $reg_nota_fiscal[0])*100),2);
					}
				}

				if($registro->Valor_NF>0){
					$rowarr[$k] =  formata_qtd($percentual_comissao, 2, true); //PERCENTUAL
				}else{
					$rowarr[$k] = 0;
				}
				/**Modificacao para no constar as comisses do vendedor 125 Dominio 431 em 07-03-2023  */
				if( $dom_comissao_zero && $registro->Vendedor == 125){
					$rowarr[$k] = 0;
				}
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				
				/**Modificacao para no constar as comisses do vendedor 125 Dominio 431 em 07-03-2023  */
				// if( $dom_comissao_zero && $registro->Vendedor == 125){
				// 	$rowarr[$k] = 0;
				// }else{
					$rowarr[$k]  =  to_money($registro->Valor_Comissao, false);  //VALOR COMISSAO
				// }
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

				$rowarr[$k]  =  to_money($valor_liquido, false);  //VALOR LIQUIDO
				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$rowarr[$k] = '-'.$rowarr[$k];
				}
				$vl_linha[$k] = $rowarr[$k];
				$lns_linha[$k] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg,5,$rowarr[$k],0);
				if($lns_linha[$k]>$lns){
					$lns = $lns_linha[$k];
				}
				$k++;

                $lns = $lns * 5;

				for($k=0;$k<$ncampos;$k++){
					$valor = $vl_linha[$k];
					$y=$pdf->y;
					$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$k]/100)*$larg, ($lns/($lns_linha[$k]* 5)) * 5, $valor, 0,$pdf->CabecalhoGrid_Align[$k],1);
					$pdf->y=$y;
				}

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

            }else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){

				if($registro->Modelo!='2D'){
					if($registro->Nr_Nota>0){
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                        ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                        ' and Empresa = "'.$registro->Empresa.'" '.
                                        ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nota_fiscal = 'select Total_Desconto from nota_fiscal '.
                                          ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                          ' and Empresa = "'.$registro->Empresa.'" '.
                                          ' and EmissaoPT = "P" '.
                                          ' and Modelo = "'.$registro->Modelo.'" '.
                                          ' and Serie = "'.$registro->Serie.'" '.
                                          ' and SubSerie = "'.$registro->SubSerie.'" '.
                                          ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					$res_nota_fiscal = consulta_sql($con_nota_fiscal);
					$reg_nota_fiscal = consulta_ler_linha($res_nota_fiscal);
					consulta_limpa($res_nota_fiscal);
				}else{
					$reg_nota_fiscal[0]=0;
				}
				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$valor_desconto = 0;
				}
				$valor_desconto = $reg_nota_fiscal[0];

				if($_REQUEST['tipo_rel']=='SD'){
					if(!isset($lista_vendedor[$registro->DT_Emissao])){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_produto']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_desconto']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_liquido']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto'] =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido']  =0;

						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_venda']     =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_vendaAV']   =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_venda']    =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaCF']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  =0;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_comissao'] =0;
					}

					if(!isset($lista_geral[$registro->DT_Emissao])){
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_produto']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_desconto']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_liquido']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto'] =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido']  =0;

						$lista_geral[$registro->DT_Emissao]['total_dia_dev_venda']     =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_dev_vendaAV']   =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_venda']    =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaCF']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  =0;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_comissao'] =0;
					}
				}

				if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF + $registro->Valor_Comissao);

					$total_vend_liquido  -= $valor_liquido;
					$total_vend_desconto -= $valor_desconto;
					$total_vend_produto  -= $valor_produto;

					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto'] -=$valor_produto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto']-=$valor_desconto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido'] -=$valor_liquido;

						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto'] -=$valor_produto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto']-=$valor_desconto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido'] -=$valor_liquido;
					}
				}else{
					$valor_produto = ($registro->Valor_NF + $valor_desconto);
					$valor_liquido = ($registro->Valor_NF - $registro->Valor_Comissao);

					$total_vend_liquido  += $valor_liquido;
					$total_vend_desconto += $valor_desconto;
					$total_vend_produto  += $valor_produto;

					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_produto'] +=$valor_produto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_desconto']+=$valor_desconto;
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_liquido'] +=$valor_liquido;

						$lista_geral[$registro->DT_Emissao]['total_dia_vend_produto'] +=$valor_produto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_desconto']+=$valor_desconto;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_liquido'] +=$valor_liquido;
					}
				}
            }

            //calcula o total por dia

            if(($registro->TipoMov=='D')||($registro->TipoMov=='C')){
				$total_dev_venda-= $registro->Valor_NF;
				$total_dev_comissao+= $registro->Valor_Comissao; // positivo a devoluo pois no BD  armazenado o valor negativo ( + * - = -)
				//$total_geral_venda-= $registro->Valor_NF;
				$total_dev_vendaAV-= $registro->Valor_NF;
				$total_venda_dia[$registro->DT_Emissao]-= $registro->Valor_NF;

				if($_REQUEST['tipo_rel']=='SD'){
					$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_venda']    -= $registro->Valor_NF;
					$lista_vendedor[$registro->DT_Emissao]['total_dia_dev_vendaAV']  -= $registro->Valor_NF;

					$lista_geral[$registro->DT_Emissao]['total_dia_dev_venda']    -= $registro->Valor_NF;
					$lista_geral[$registro->DT_Emissao]['total_dia_dev_vendaAV']  -= $registro->Valor_NF;
				}

            }else{
				$total_vend_venda+= $registro->Valor_NF;
				$total_vend_comissao+= $registro->Valor_Comissao;
				$total_venda_dia[$registro->DT_Emissao]+= $registro->Valor_NF;

				//$total_geral_venda+= $registro->Valor_NF;

				if($_REQUEST['tipo_rel']=='SD'){
					$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_venda']  += $registro->Valor_NF;
					$lista_geral[$registro->DT_Emissao]['total_dia_vend_venda']  += $registro->Valor_NF;
				}

				//TODO: Thiago Fazer Funo
				//se cupom
				if(($registro->Modelo=='2D')||($registro->Modelo=='65')||($registro->Modelo=='59')){ //CF/NFC-e/SAT-CF-e
					$total_vend_vendaCF+=$registro->Valor_NF;
					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaCF']  += $registro->Valor_NF;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaCF']  += $registro->Valor_NF;
					}
				}else if($registro->Tipo=='E'){
					//else se manual
					$total_vend_vendaAV+=$registro->Valor_NF;
					if($_REQUEST['tipo_rel']=='SD'){
						$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
						$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
					}
				}else{
					//else
					if($registro->Nr_Nota>0){
						$con_nf = 'select Nr_Nota, Forma_Pagto from nota_fiscal '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'" '.
								   ' and Empresa = "'.$registro->Empresa.'" '.
								   ' and Nr_Nota = "'.$registro->Nr_Nota.'" ';
					}else{
						$con_nf = 'select Nr_Nota, Forma_Pagto from nota_fiscal '.
								  ' where Dominio = "'.$_SESSION['Dominio'].'" '.
								  ' and Empresa = "'.$registro->Empresa.'" '.
								  ' and EmissaoPT = "P" '.
								  ' and Modelo = "'.$registro->Modelo.'" '.
								  ' and Serie = "'.$registro->Serie.'" '.
								  ' and SubSerie = "'.$registro->SubSerie.'" '.
								  ' and NrDoc = "'.$registro->Nr_Doc.'" ';
					}
					$res_nf = consulta_sql($con_nf);
					$reg_nf = consulta_ler_linha($res_nf);
					consulta_limpa($res_nf);
					//busca nota pra saber se avista ou a prazo
					if($reg_nf[0]>0){
						//se plano <=1
						if($reg_nf[1]<=1){
							$total_vend_vendaAV+=$registro->Valor_NF;
							if($_REQUEST['tipo_rel']=='SD'){
								$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
								$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaAV']  += $registro->Valor_NF;
							}
						}else{
							$total_vend_vendaPZ+=$registro->Valor_NF;
							if($_REQUEST['tipo_rel']=='SD'){
								$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  += $registro->Valor_NF;
								$lista_geral[$registro->DT_Emissao]['total_dia_vend_vendaPZ']  += $registro->Valor_NF;
							}
						}
					}
				}
				//TODO: Thiago Fim Funo
            }

            //$total_vend_comissao+= $registro->Valor_Comissao;
            if($_REQUEST['tipo_rel']=='SD'){
				$lista_vendedor[$registro->DT_Emissao]['total_dia_vend_comissao']  += $registro->Valor_Comissao;
				$lista_geral[$registro->DT_Emissao]['total_dia_vend_comissao']  += $registro->Valor_Comissao;
            }
            //$total_dia_vend_comissao+= $registro->Valor_Comissao;
            //$total_geral_comissao+= $registro->Valor_Comissao;

			/*
            $total_dia_vend_produto+= $total_vend_produto;
            $total_dia_vend_desconto+= $total_vend_desconto;
            $total_dia_vend_venda+= $total_vend_venda;
            $total_dia_vend_comissao+= $total_vend_comissao;
            $total_dia_vend_liquido+= $total_vend_liquido;

            $total_dia_dev_produto+= $total_dev_produto;
            $total_dia_dev_desconto+= $total_dev_desconto;
            $total_dia_dev_venda+= $total_dev_venda;
            $total_dia_dev_comissao+= $total_dev_comissao;
            $total_dia_dev_liquido+= $total_dev_liquido;

            $total_dia_vend_vendaAV+= $total_vend_vendaAV;
            $total_dia_dev_vendaAV+= $total_dev_vendaAV;
            $total_dia_vend_vendaPZ+= $total_vend_vendaPZ;
            $total_dia_vend_vendaCF+= $total_vend_vendaCF;
			*/

            if(($_REQUEST['tipo_rel']=='D') || ($comissao_itens)){
				if(($registro->Tipo == 'E')&&($registro->Observacao!='')){
					$k = 0;
					$lns = 0;

					$pdf->Cell(1,      $lns, ' ', 0,0,'C');
					$pdf->SetAutoPageBreak(false,30);
					$pdf->SetFont('Arial','',7);

					$rowarr[$k] = ' ';
					$vl_linha[$k] = $rowarr[$k];
					$lns_linha[$k] = $pdf->Lines_MultiCell((100/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;

					$rowarr[$k] = 'Obs: '.$registro->Observacao;
					$vl_linha[$k] = $rowarr[$k];
					$lns_linha[$k] = $pdf->Lines_MultiCell((100/100)*$larg,5,$rowarr[$k],0);
					if($lns_linha[$k]>$lns){
						$lns = $lns_linha[$k];
					}
					$k++;

					$lns = $lns * 5;

					$a=0;
					$valor = $vl_linha[$a];
					$y=$pdf->y;
					$pdf->MultiCell((4/100)*$larg, ($lns/($lns_linha[$a]* 3)) * 3, $valor, 0,'L');
					$pdf->y=$y;
					$a++;


					$valor = $vl_linha[$a];
					$y=$pdf->y;
					$pdf->MultiCell((96/100)*$larg, ($lns/($lns_linha[$a]* 3)) * 3, $valor, 0,'L');
					$pdf->y=$y;
					$a++;

					$pdf->Cell(1,      $lns, ' ', 0,1,'C');
					//Prxima Linha
					$pdf->x=$pdf->lMargin;
					$pdf->y=$y+$lns;
					$pdf->SetAutoPageBreak(true,30);

				}else{
					if($registro->Modelo == '2D'){
						$con_item = 'select eci.Id_Produto, eci.Descricao_Produto as Prod_Descricao, eci.Perc_Comissao, eci.Valor_Comissao, '.
									 ' eci.Quantidade as Quantidade_Estoque, eci.Preco as Valor_Unitario, eci.ValorTotal as Valor_Total,'.
									 ' eci.Perc_ComissaoG, eci.Valor_ComissaoG '.
									 ' from ecf_cupom_item eci '.
									 ' Where eci.Dominio = "'.$_SESSION['Dominio'].'"'.
									 ' and eci.Empresa = "'.$registro->Empresa.'"'.
									 ' and eci.NrFab = "'.$registro->ECF_NrFab.'"'.
									 ' and eci.LetraMF = "'.$registro->ECF_LetraMF.'"'.
									 ' and eci.DT_Emissao = "'.$registro->DT_Emissao.'"'.
									 ' and eci.COO = "'.$registro->Nr_Doc.'"'.
									 ' and eci.Cancelado="N" '.
									 ' and eci.Id_Produto>0 '.
									 ' order by eci.Seq_Item';
					}else{
						$con_item = 'select nfi.Id_Produto, nfi.Prod_Descricao, nfi.Perc_Comissao, nfi.Valor_Comissao, '.
									 ' nfi.Quantidade_Estoque, nfi.Valor_Unitario, nfi.Valor_Total, '.
									 ' nfi.Perc_ComissaoG, nfi.Valor_ComissaoG '.
									 ' from nota_fiscal_item nfi '.
									 ' where nfi.Dominio = "'.$_SESSION['Dominio'].'"'.
									 ' and nfi.Empresa="'.$registro->Empresa.'" '.
									 ' and nfi.Nr_Nota = "'.$registro->Nr_Nota.'" '.
									 ' order by nfi.Seq_Item';
					}

					$res_item = consulta_sql($con_item);
					$nrows_item = consulta_num_registros($res_item);

					if($nrows_item>0){
						for($nfi=0;$nfi<$nrows_item;$nfi++){

							$reg_item = consulta_ler_objeto($res_item);

							//$pdf->SetFillColor(225,225,225);
							$pdf->SetFillColor(220,220,220);

							$k = 0;
							$m = 0;
							$lns = 0;

							$pdf->SetFont('Arial','',7);
							$pdf->Cell(1,      $lns, ' ', 0,0,'C');
							$pdf->SetAutoPageBreak(false,30);
							$pdf->SetFont('Arial','',7);

							$rowarr[$m]  =  ' ';
							$vl_linha[$m] = $rowarr[$m];
							$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
							if($lns_linha[$m]>$lns){
								$lns = $lns_linha[$m];
							}
							$m++;

							$rowarr[$m]  =  $reg_item->Id_Produto;
							$vl_linha[$m] = $rowarr[$m];
							$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
							if($lns_linha[$m]>$lns){
								$lns = $lns_linha[$m];
							}
							$m++;

							if($reg_item->Prod_Descricao!=''){
								$desc_prod = $reg_item->Prod_Descricao;
							}else{
								$cons_prd = 'select Codigo_Produto, Descricao_Completa from produto '.
										   ' where Dominio = "'.$_SESSION["Dominio"].'"'.
										   ' and Id_Produto = "'.$reg_item->Id_Produto.'"';
								$res_prd = consulta_sql($cons_prd);
								$reg_prd = consulta_ler_linha($res_prd);
								consulta_limpa($res_prd);
								$desc_prod = $reg_prd[1];
							}

							$rowarr[$m]  =  $desc_prod;
							$vl_linha[$m] = $rowarr[$m];
							$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
							if($lns_linha[$m]>$lns){
								$lns = $lns_linha[$m];
							}
							$m++;

							$rowarr[$m]  =  formata_qtd($reg_item->Quantidade_Estoque,3,false);
							$vl_linha[$m] = $rowarr[$m];
							$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
							if($lns_linha[$m]>$lns){
								$lns = $lns_linha[$m];
							}
							$m++;

							$rowarr[$m]  =  to_money($reg_item->Valor_Unitario, false);
							$vl_linha[$m] = $rowarr[$m];
							$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
							if($lns_linha[$m]>$lns){
								$lns = $lns_linha[$m];
							}
							$m++;

							if($comissao_itens){
								$rowarr[$m]  =  to_money($reg_item->Valor_Total, false);
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

								$rowarr[$m]  =  formata_qtd($reg_item->Perc_Comissao, 2, true);
								if($registro->Gerente == (-2)){
									$rowarr[$m] = formata_qtd($reg_item->Perc_ComissaoG, 2, true);
								}
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

								$rowarr[$m]  =  to_money($reg_item->Valor_Comissao, false);
								if($registro->Gerente == (-2)){
									$rowarr[$m] = to_money($reg_item->Valor_ComissaoG, false);
								}
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

								$rowarr[$m]  =  to_money($reg_item->Valor_Total - $reg_item->Valor_Comissao, false);
								if($registro->Gerente == (-2)){
									$rowarr[$m] = to_money($reg_item->Valor_Total - $reg_item->Valor_ComissaoG, false);
								}
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;
							}else{
								$rowarr[$m]  =  '';
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

								$rowarr[$m]  =  to_money($reg_item->Valor_Total, false);
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

								$rowarr[$m]  =  ' ';
								$vl_linha[$m] = $rowarr[$m];
								$lns_linha[$m] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg,$lns,$rowarr[$m],0);
								if($lns_linha[$m]>$lns){
									$lns = $lns_linha[$m];
								}
								$m++;

							}

							$lns = $lns * 5;

							for($m=0;$m<$ncampos_item;$m++){
								$valor = $vl_linha[$m];
								$y=$pdf->y;
								$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$m]/100)*$larg, ($lns/($lns_linha[$m]*3))*3, $valor, 0,$pdf->CabecalhoGrid_Align_Item[$m]);
								$pdf->y=$y;
							}

							$pdf->Cell(1,      $lns, ' ', 0,1,'C');
							//Prxima Linha
							$pdf->x=$pdf->lMargin;
							$pdf->y=$y+$lns;
							$pdf->SetAutoPageBreak(true,30);
						}
					}
					consulta_limpa($res_item);
				}
            }
		}

		$larg = 275;
		$lns = 5;

		if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){

            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);


            $y=$pdf->y;
            $pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Venda:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto, false), '', 'R');
				$pdf->y=$y;
            }

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido, false), '', 'R');
            $pdf->y=$y;


            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);



            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);


            $y=$pdf->y;
            $pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Devolues:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_produto, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_desconto, false), '', 'R');
				$pdf->y=$y;
            }

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_venda, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_comissao, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_liquido, false), '', 'R');
            $pdf->y=$y;


            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);


            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);


            $y=$pdf->y;
            $pdf->MultiCell((30/100)*$larg, $lns, 'Total do '.$label.' - Saldo:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto+$total_dev_produto, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto+$total_dev_desconto, false), '', 'R');
				$pdf->y=$y;
            }

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao+$total_dev_comissao, false), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido+$total_dev_liquido, false), '', 'R');
            $pdf->y=$y;


            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $total_geral_liquido += $total_vend_liquido;
            $total_geral_produto += $total_vend_produto;
            $total_geral_venda += $total_vend_venda;
            $total_geral_desconto += $total_vend_desconto;
            $total_geral_comissao += $total_vend_comissao;

            $total_geraldev_liquido += $total_dev_liquido;
            $total_geraldev_produto += $total_dev_produto;
            $total_geraldev_venda += $total_dev_venda;
            $total_geraldev_desconto += $total_dev_desconto;
            $total_geraldev_comissao += $total_dev_comissao;

        }else if(($_REQUEST['tipo_rel']=='S')||($_REQUEST['tipo_rel']=='SD')){

            $larg = 275;
            if(($_REQUEST['tipo_rel']=='SD')&&($ok_vendedor)){
				$pdf->AddPage();
            }

            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);

            $y=$pdf->y;
            $pdf->MultiCell((40/100)*$larg, $lns, $desc_vendedor, '', 'L');
            $pdf->y=$y;
            if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaAV+$total_dev_vendaAV, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaPZ, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_vendaCF, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				if(($total_vend_venda+$total_dev_venda)!=0){
					$pdf->MultiCell((10/100)*$larg, $lns, round($total_vend_comissao/($total_vend_venda+$total_dev_venda)*100,2), '', 'R');
				}else{
					$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				}
				$pdf->y=$y;
            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_dev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				if(($total_vend_venda+$total_dev_venda)!=0){
					$pdf->MultiCell((10/100)*$larg, $lns, round(($total_vend_comissao+$total_dev_comissao)/($total_vend_venda+$total_dev_venda)*100,2), '', 'R');
				}else{
					$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				}
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_produto, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_desconto, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_venda+$total_dev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				if($total_vend_venda!=0){
					$pdf->MultiCell((10/100)*$larg, $lns, round($total_vend_comissao/$total_vend_venda*100,2), '', 'R');
				}else{
					$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				}
				$pdf->y=$y;
            }

            $y=$pdf->y;
			$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_comissao+$total_dev_comissao, false), '', 'R');
			$pdf->y=$y;
			//if($cod_dominio_pz!=$_SESSION['Dominio']){
			if(($cod_dominio_pz!=$_SESSION['Dominio'])&&(  !Zathura() )){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_vend_liquido+$total_dev_liquido, false), '', 'R');
				$pdf->y=$y;
			}

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            if($_REQUEST['tipo_rel']=='SD'){
				//tambem totalizar o dia
				exibe_dias_vendedor($pdf, $lista_vendedor,$cod_dominio_pz,$cod_dominio);
				$lista_vendedor = array();
            }

            $total_geral_produto  += $total_vend_produto;
            $total_geral_desconto += $total_vend_desconto;
            $total_geral_venda    += $total_vend_venda;
            $total_geral_comissao += $total_vend_comissao;
            $total_geral_liquido  += $total_vend_liquido;

            $total_geraldev_produto  += $total_dev_produto;
            $total_geraldev_desconto += $total_dev_desconto;
            $total_geraldev_venda    += $total_dev_venda;
            $total_geraldev_comissao += $total_dev_comissao;
            $total_geraldev_liquido  += $total_dev_liquido;

            $total_geral_vendaAV     += $total_vend_vendaAV;
            $total_geraldev_vendaAV  += $total_dev_vendaAV;
            $total_geral_vendaPZ     += $total_vend_vendaPZ;
            $total_geral_vendaCF     += $total_vend_vendaCF;

		}

		//TOTAL GERAL
		if($_REQUEST['vendedor']==''){
            if(($_REQUEST['tipo_rel']=='A')||($_REQUEST['tipo_rel']=='D')){

				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, 'Total Geral - Venda:', 'T', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, '', 'T', 'L');
				$pdf->y=$y;

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', 'T', 'R');
					$pdf->y=$y;
				}else{
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_produto, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_desconto, false), 'T', 'R');
					$pdf->y=$y;
				}

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_venda, false), 'T', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', 'T', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_comissao, false), 'T', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_liquido, false), 'T', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, 'Total Geral - Devolues:', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
					$pdf->y=$y;
				}else{
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_produto, false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_desconto, false), '', 'R');
					$pdf->y=$y;
				}

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_comissao, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_liquido, false), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, 'Total Geral - Saldo:', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((20/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns,  '', '', 'R');
					$pdf->y=$y;
				}else{
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_produto+$total_geraldev_produto, false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_desconto+$total_geraldev_desconto, false), '', 'R');
					$pdf->y=$y;
				}

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_venda+$total_geraldev_venda, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_comissao+$total_geraldev_comissao, false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_liquido+$total_geraldev_liquido, false), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

            }else if($_REQUEST['tipo_rel']=='S'){
				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((40/100)*$larg, $lns, 'Total Geral:', 'T', 'L');
				$pdf->y=$y;
				if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_venda+$total_geraldev_venda, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_vendaAV+$total_geraldev_vendaAV, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_vendaPZ, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_vendaCF, false), 'T', 'R');
					$pdf->y=$y;

				}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_venda, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geraldev_venda, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_venda+$total_geraldev_venda, false), 'T', 'R');
					$pdf->y=$y;
				}else{
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_produto+$total_geraldev_produto, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_desconto+$total_geraldev_desconto, false), 'T', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money(($total_geral_produto+$total_geraldev_produto) - ($total_geral_desconto+$total_geraldev_desconto), false), 'T', 'R');
					$pdf->y=$y;
				}
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', 'T', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_comissao+$total_geraldev_comissao, false), 'T', 'R');
				$pdf->y=$y;
				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&(!Zathura() )){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($total_geral_liquido, false), 'T', 'R');
					$pdf->y=$y;
				}
				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				/*
				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((40/100)*$larg, $lns, 'Total Geral - Devoluo:', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geraldev_produto)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geraldev_desconto)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geraldev_venda)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geraldev_comissao)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geraldev_liquido)), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

				$pdf->SetFont('Arial','B',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetFont('Arial','B',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((40/100)*$larg, $lns, 'Total Geral - Saldo:', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geral_produto+$total_geraldev_produto)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geral_desconto+$total_geraldev_desconto)), '', 'R');
				$pdf->y=$y;


				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geral_venda+$total_geraldev_venda)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geral_comissao+$total_geraldev_comissao)), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, str_replace('"','',to_money($total_geral_liquido+$total_geraldev_liquido)), '', 'R');
				$pdf->y=$y;

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);
				*/
			}
        }

        //resumo dos totais por dia
        if($_REQUEST['tipo_rel']=='SD'){
            $totais_sd=array();
            $totais_sd['valor_venda_total']=0;
            $totais_sd['valor_dev_total']=0;
            $totais_sd['valor_saldo_total']=0;
            $totais_sd['valor_comissao_total']=0;
            $totais_sd['valor_liq_total']=0;
            $totais_sd['valor_vista_total']=0;
            $totais_sd['valor_prazo_total']=0;
            $totais_sd['valor_cupom_total']=0;
            $totais_sd['valor_produto_total']=0;
            $totais_sd['valor_desconto_total']=0;
            ksort($lista_geral);
            //var_dump($lista_geral);
            //calcula os totais (sinttico por dia)
            foreach($lista_geral as $diaT => $valorT){
                $dadosT = $lista_geral[$diaT];
                if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura()){
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda']);
					$totais_sd['valor_vista_total']+=($dadosT['total_dia_vend_vendaAV']+$dadosT['total_dia_dev_vendaAV']);
					$totais_sd['valor_prazo_total']+=($dadosT['total_dia_vend_vendaPZ']);
					$totais_sd['valor_cupom_total']+=($dadosT['total_dia_vend_vendaCF']);
                }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']);
					$totais_sd['valor_dev_total']+=($dadosT['total_dia_dev_venda']);
					$totais_sd['valor_saldo_total']+=($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda']);
				}else{
					$totais_sd['valor_produto_total']+=($dadosT['total_dia_vend_produto']);
					$totais_sd['valor_desconto_total']+=($dadosT['total_dia_vend_desconto']);
					$totais_sd['valor_venda_total']+=($dadosT['total_dia_vend_venda']);
				}
				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&(!Zathura() )){
					$totais_sd['valor_liq_total']+=$dadosT['total_dia_vend_liquido'];
				}
				//comum  todos os domnios
				$totais_sd['valor_comissao_total']+=$dadosT['total_dia_vend_comissao'];
            }
            $pdf->AddPage();

            $lns = 5;
            $larg = 275;

            $pdf->SetFont('Arial','B',8);
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetFont('Arial','B',8);
            $pdf->SetAutoPageBreak(false,30);

            $y=$pdf->y;
            $pdf->MultiCell((3/100)*$larg, $lns, '', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((37/100)*$larg, $lns, 'TOTAL GERAL', '', 'L');
            $pdf->y=$y;

            if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_venda_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_vista_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_prazo_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_cupom_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				$pdf->y=$y;
            }else  if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_venda_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_dev_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_saldo_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				$pdf->y=$y;
            }else{
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_produto_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_desconto_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_venda_total'], false), '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
				$pdf->y=$y;
            }

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_comissao_total'], false), '', 'R');
            $pdf->y=$y;

            //if($cod_dominio_pz!=$_SESSION['Dominio']){
            if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($totais_sd['valor_liq_total'], false), '', 'R');
				$pdf->y=$y;
            }

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            foreach($lista_geral as $diaT => $valorT){
				$dadosT = $lista_geral[$diaT];

				$lns = 5;
				$larg = 275;

				$pdf->SetFont('Arial','',8);
				$pdf->Cell(1,      $lns, '', 0,0,'C');
				$pdf->SetFont('Arial','',8);
				$pdf->SetAutoPageBreak(false,30);

				$y=$pdf->y;
				$pdf->MultiCell((3/100)*$larg, $lns, '', '', 'L');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((37/100)*$larg, $lns, 'Total do Dia: '.dataf($diaT), '', 'L');
				$pdf->y=$y;

				if(($cod_dominio_pz==$_SESSION['Dominio'])|| Zathura() ){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_vendaAV']+$dadosT['total_dia_dev_vendaAV'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_vendaPZ'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_vendaCF'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					if(($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])!=0){
						$pdf->MultiCell((10/100)*$larg, $lns, round($dadosT['total_dia_vend_comissao']/($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])*100,2), '', 'R');
					}else{
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
					}
					$pdf->y=$y;

				}else if(($cod_dominio==$_SESSION['Dominio'])||($_SESSION['Dominio']==191)){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_venda'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_dev_venda'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'], false), '', 'R');
					$pdf->y=$y;

					$perc_comissao=0;
					if(($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])>0){
					$perc_comissao = round($dadosT['total_dia_vend_comissao']/($dadosT['total_dia_vend_venda']+$dadosT['total_dia_dev_venda'])*100,2);
					}
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, $perc_comissao, '', 'R');
					$pdf->y=$y;

				}else{
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_produto'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_desconto'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_venda'], false), '', 'R');
					$pdf->y=$y;

					$y=$pdf->y;
					if($dadosT['total_dia_vend_venda']!=0){
						$pdf->MultiCell((10/100)*$larg, $lns, round($dadosT['total_dia_vend_comissao']/$dadosT['total_dia_vend_venda']*100,2), '', 'R');
					}else{
						$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'R');
					}
					$pdf->y=$y;
				}

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_comissao'], false), '', 'R');
				$pdf->y=$y;

				//if($cod_dominio_pz!=$_SESSION['Dominio']){
				if(($cod_dominio_pz!=$_SESSION['Dominio'])&&( !Zathura() )){
					$y=$pdf->y;
					$pdf->MultiCell((10/100)*$larg, $lns, to_money($dadosT['total_dia_vend_liquido'], false), '', 'R');
					$pdf->y=$y;
				}

				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);

            }
		}
	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(275, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
	}

	consulta_limpa($resultado);
	echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
	
}
?>