<?php
	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');

	session::usr_conectado($_REQUEST['USER_ID']);

	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');

	function HeaderingExcel($filename){
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	HeaderingExcel('COMISSOES.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'RELATRIO COMISSES';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$fmt_branco =& $workbook->add_format();
	$fmt_branco->set_size(10);

	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$worksheet1->write_string(0,0,'RELATRIO DE COMISSES',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_align('vcenter');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	$formatottl =& $workbook->add_format();
	$formatottl->set_align('left');
	$formatottl->set_pattern();
	$formatottl->set_fg_color(40);
	$formatottl->set_bold(1);
	$formatottl->set_border(1);

	$fmt_titulo =& $workbook->add_format();
	$fmt_titulo->set_align('left');
	$fmt_titulo->set_size(8);

	$fmt_cabec =& $workbook->add_format();
	$fmt_cabec->set_align('center');
	$fmt_cabec->set_align('vcenter');
	$fmt_cabec->set_pattern();
	$fmt_cabec->set_fg_color(40);
	$fmt_cabec->set_size(8);
	$fmt_cabec->set_border(1);
	$fmt_cabec->set_bold(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');
	$formatotl->set_size(10);
	$formatotl->font='Tahoma';

	$formatotl_filtro =& $workbook->add_format();
	$formatotl_filtro->set_align('left');
	$formatotl_filtro->set_size(10);
	$formatotl_filtro->font='Tahoma';

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	$fmt_txt =& $workbook->add_format();
	$fmt_txt->set_border(1);
	$fmt_txt->set_size(8);
	$fmt_txt->set_align('center');

	$fmt_txtb =& $workbook->add_format();
	$fmt_txtb->set_border(1);
	$fmt_txtb->set_size(8);
	$fmt_txtb->set_bold(1);
	$fmt_txtb->set_align('center');
	$fmt_txtb->set_pattern();
	$fmt_txtb->set_fg_color('silver');

	$fmt_valor =& $workbook->add_format();
	$fmt_valor->set_border(1);
	$fmt_valor->set_align('right');
	$fmt_valor->set_size(8);
	$fmt_valor->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$fmt_valorb =& $workbook->add_format();
	$fmt_valorb->set_border(1);
	$fmt_valorb->set_align('right');
	$fmt_valorb->set_size(8);
	$fmt_valorb->set_bold(1);
	$fmt_valorb->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$fmt_valorb->set_pattern();
	$fmt_valorb->set_fg_color('silver');

	$fmt_total =& $workbook->add_format();
	$fmt_total->set_border(1);
	$fmt_total->set_align('right');
	$fmt_total->set_size(8);
	$fmt_total->set_bold(1);
	$fmt_total->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$vendedor = $_REQUEST['vendedor'];
	$cliente = $_REQUEST['pessoa'];
	$data_ini = $_REQUEST['data_ini'];
	$data_fim = $_REQUEST['data_fim'];
	$tp_grupo = 'Dia';
	if($_REQUEST['tipo_rel']=='SA'){
		$tp_grupo = 'Ano';
	}else if($_REQUEST['tipo_rel']=='SM'){
		$tp_grupo = 'Ms';
	}

	$dia_ini = data2nr($data_ini);

	$label = label_vendedor_ou_rep_comercial('S');

	$listaAnoMes = array();

	$start = new DateTime(datad($data_ini));
	$start->modify('first day of this month');
	$end = new DateTime(datad($data_fim));
	$end->modify('first day of next month');
	if($_REQUEST['tipo_rel']=='SA'){
		$interval = DateInterval::createFromDateString('1 year');
	}else{
		$interval = DateInterval::createFromDateString('1 month');
	}
	$period = new DatePeriod($start, $interval, $end);

	foreach($period as $dt){
		$ano = $dt->format('Y');
		$mes = $dt->format('m');
		
		$listaAnoMes[$anoMes]['Ano'] = $ano;
		
		if($_REQUEST['tipo_rel']=='SA'){
			$mes = '';
			$listaAnoMes[$anoMes]['Mes'] = '';
			$listaAnoMes[$anoMes]['Mes_Descricao'] = $ano;
		}else{
			$listaAnoMes[$anoMes]['Mes'] = $mes;
			$listaAnoMes[$anoMes]['Mes_Descricao'] = MesExtenso($mes).'/'.$ano;
		}
		$anoMes = $ano.$mes;
	}

	$listaRel = array();

	$consulta = 'SELECT Nr_Comissao, Tipo, Nr_Nota, Nr_Doc, Modelo, Serie, DT_Pagto, Pessoa, Valor_NF, '.
		   ' Valor_Comissao, Vendedor, Situacao, Observacao, Contas_Baixa, Contas_Recebe '.
		   ' FROM comissao '.
		   ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
		   ' AND DT_Pagto >= "'.datad($data_ini).'" '.
		   ' AND DT_Pagto <= "'.datad($data_fim).'" '.
		   ' AND Valor_Comissao <> 0';

	$filtro = 'Perodo: De "'.$data_ini.'"'.
		 ' At "'.$data_fim.'"';

	if($_REQUEST['pessoa'] != ''){
		$consulta.= ' and Pessoa = "'.$_REQUEST['pessoa'].'" ';
		$filtro.= ' Pessoa: "'.$_REQUEST['pessoa'].'" ';
	}

	if($_REQUEST['vendedor'] != ''){
		$consulta.= ' and Vendedor = "'.$_REQUEST['vendedor'].'" ';
		$filtro.= ' '.$label.': "'.$_REQUEST['vendedor'].'" ';
	}

    $consulta.= ' ORDER BY Vendedor, DT_Pagto, Nr_Comissao ';
    $resultado = consulta_sql($consulta);
    while($registro = consulta_ler_objeto($resultado)){
		$chave = $registro->Vendedor;

		if(!isset($listaRel[$chave])){
			$con_vendedor = 'SELECT Nome_Listas FROM pessoa '.
						 ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
						 ' AND Pessoa = "'.$registro->Vendedor.'"';
			$res_vendedor = consulta_sql($con_vendedor);
			$reg_vendedor = consulta_ler_linha($res_vendedor);
			consulta_limpa($res_vendedor);

			$nomeVendedor = isset($reg_vendedor) ? $reg_vendedor[0] : 'N/a';

			$listaRel[$chave]['Vendedor'] = $registro->Vendedor;
			$listaRel[$chave]['Vendedor_Nome'] = $nomeVendedor;
			$listaRel[$chave]['Lista_Meses'] = array();
			$listaRel[$chave]['Valor_Total_Vendedor'] = 0;

			foreach($listaAnoMes as $regAnoMes){
				$chaveAnoMes = $regAnoMes['Ano'].$regAnoMes['Mes'];

				//$listaRel[$chave]['Lista_Meses'][$chaveAnoMes]['Ano'] = $regAnoMes['Ano'];
				//$listaRel[$chave]['Lista_Meses'][$chaveAnoMes]['Mes'] = $regAnoMes['Mes'];
				//$listaRel[$chave]['Lista_Meses'][$chaveAnoMes]['Mes_Descricao'] = $regAnoMes['Mes_Descricao'];
				$listaRel[$chave]['Lista_Meses'][$chaveAnoMes]['Valor_Total_Comissao'] = 0;
			}
		}

		$ano = substr($registro->DT_Pagto, 0, 4);
		$mes = substr($registro->DT_Pagto, 5, 2);
		if($_REQUEST['tipo_rel']=='SA'){
			$mes = '';
		}
		$anoMes = $ano.$mes;

		$listaRel[$chave]['Valor_Total_Vendedor']+= $registro->Valor_Comissao;
		$listaRel[$chave]['Lista_Meses'][$anoMes]['Valor_Total_Comissao']+= $registro->Valor_Comissao;
	}

	$worksheet1->write(7, 0, 'Filtro: '.$filtro);

	$linha_ini = 9;
	$coluna = 0;

	if(!empty($listaRel)){
		$worksheet1->set_column($coluna, $coluna, 62);
		$worksheet1->write_string($linha_ini, $coluna, 'Vendedor', $formatott);
		$coluna++;

		foreach($listaAnoMes as $regAnoMes){
			$worksheet1->set_column($coluna, $coluna, 14);
			$worksheet1->write_string($linha_ini, $coluna, $regAnoMes['Mes_Descricao'], $formatott);
			$coluna++;
		}

		$worksheet1->set_column($coluna, $coluna, 20);
		$worksheet1->write_string($linha_ini, $coluna, 'Total do Vendedor', $formatott);
		$coluna++;

		$linha_ini++;

		foreach($listaRel as $registro){
			$coluna = 0;

			$worksheet1->write_string($linha_ini, $coluna, $registro['Vendedor'].' - '.$registro['Vendedor_Nome'], $formatotl);
			$coluna++;

			foreach($registro['Lista_Meses'] as $registroMes){
				$worksheet1->write_number($linha_ini, $coluna, $registroMes['Valor_Total_Comissao'], $formatotpreco);
				$coluna++;
			}

			$worksheet1->write_number($linha_ini, $coluna, $registro['Valor_Total_Vendedor'].' - '.$registro['Vendedor_Nome'], $formatotpreco);
			$coluna++;

			$linha_ini++;
		}

		/* $linha_ini++;

		$coluna = 0;

		$worksheet1->write_string($linha_ini, $coluna, 'Total Geral: ', $formatotl);
		$coluna++;

		$worksheet1->write_number($linha_ini, $coluna, 123, $formatotpreco);
		$coluna++; */
	}else{
		$worksheet1->write($linha_ini, $coluna, "No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'insert into relatorio_tmp ( '.
			 ' Dominio, '.
			 ' Usuario, '.
			 ' Descricao ) values ('.
			 '"'.$_SESSION['Dominio'].'", '.
			 '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
			 '"")';
	consulta_sql($insert);
	$workbook->close();
?>