<?php
	//error_reporting(E_ALL);
	//ini_set('display_errors', true);
	//ini_set('display_startup_errors', true);

	require_once('../../includes/header.inc');
	require_once('../../includes/base_class.inc');
	session::usr_conectado($_REQUEST['USER_ID']);
	require_once('../../includes/write_excel/Worksheet.php');
	require_once('../../includes/write_excel/Workbook.php');
	set_time_limit(30);

	function HeaderingExcel($filename) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-Disposition: attachment; filename=$filename" );
		header("Expires: 0");
		header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
		header("Pragma: public");
	}

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');

	$cod_dominio = 83;

	$filtro = '';

	$label = label_vendedor_ou_rep_comercial('S');

	// HTTP headers
	HeaderingExcel('COMISSES.xls');

	// Creating a workbook
	$workbook = new Workbook("-");
	// Creating the first worksheet
	$titulo_sheet = 'COMISSES';
	$worksheet1 =& $workbook->add_worksheet($titulo_sheet);

	// Format for the headings
	$formatot =& $workbook->add_format();
	$formatot->set_size(18);

	$formatost =& $workbook->add_format();
	$formatost->set_size(14);

	$worksheet1->write_string(0,0,'RELATRIO DE COMISSES',$formatot);
	//$worksheet1->write_string(0,0,'RELATRIO DE KARDEX',$formatot);
	$worksheet1->write(2,0,config_pad('sistema_licenca'));
	$worksheet1->write(3,0,"Data: ".$hoje." - Hora: ".$hora);
	$worksheet1->write(5,0,"Usurio: ".base64_decode($_REQUEST['USER_ID']));

	// Format for the headings
	$formatott =& $workbook->add_format();
	$formatott->set_align('center');
	$formatott->set_pattern();
	$formatott->set_fg_color(40);
	$formatott->set_bold(1);
	$formatott->set_border(1);

	// Format for the headings
	$formatotl =& $workbook->add_format();
	$formatotl->set_border(1);
	$formatotl->set_align('left');

	// Format for the headings
	$formatotlb =& $workbook->add_format();
	$formatotlb->set_border(1);
	$formatotlb->set_align('left');
	$formatotlb->set_bold(1);

	// Format for the headings
	$formatotc =& $workbook->add_format();
	$formatotc->set_border(1);
	$formatotc->set_align('center');

	// Format for the headings
	$formatotqtd =& $workbook->add_format();
	$formatotqtd->set_border(1);
	$formatotqtd->set_align('right');
	$formatotqtd->set_num_format('#,##0.000_);-#,##0.000_)');

	$formatotpreco =& $workbook->add_format();
	$formatotpreco->set_border(1);
	$formatotpreco->set_align('right');
	$formatotpreco->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');

	$formatotpreco_b =& $workbook->add_format();
	$formatotpreco_b->set_border(1);
	$formatotpreco_b->set_align('right');
	$formatotpreco_b->set_num_format('R$ #,##0.00_);(R$ #,##0.00)');
	$formatotpreco_b->set_bold(1);

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	// Format for the headings
	$formatot_blank =& $workbook->add_format();
	$formatot_blank->set_border(0);
	$formatot_blank->set_align('left');

	$fmt_perc =& $workbook->add_format();
	$fmt_perc->set_border(1);
	$fmt_perc->set_align('right');
	$fmt_perc->set_num_format('0.00%;-0.00%');

	$fmt_perc_b =& $workbook->add_format();
	$fmt_perc_b->set_border(1);
	$fmt_perc_b->set_bold(1);
	$fmt_perc_b->set_align('right');
	$fmt_perc_b->set_num_format('0,00%;-0,00%');

	$formato_data =& $workbook->add_format();
	$formato_data->set_border(1);
	$formato_data->set_align('center');
	$formato_data->set_num_format('dd/mm/yyyy');

	$lista_geral = array();

	$consulta = 'SELECT Nr_Comissao, Tipo, Nr_Nota, Nr_Doc, '.
               ' Modelo, Serie, DT_Pagto, Pessoa, Valor_NF, '.
               ' Valor_Comissao, Vendedor, Situacao, Observacao, '.
               ' Contas_Baixa, Contas_Recebe, Empresa, DT_Comissao, Situacao, DT_Emissao, TipoMov '.
               ' FROM comissao '.
               ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
               ' AND Situacao <> "E" '.
               ' AND Situacao <> "C" '.
               ' AND ( ( ( DT_Pagto >= "'.datad($_REQUEST['data_ini']).'" '.
               ' AND DT_Pagto <= "'.datad($_REQUEST['data_fim']).'" ) ) OR ( '.
               ' ( DT_Comissao >= "'.datad($_REQUEST['data_ini']).'" '.
               ' AND DT_Comissao <= "'.datad($_REQUEST['data_fim']).'" ) ) ) ';

	$filtro = 'Perodo: De "'.$_REQUEST['data_ini'].'"'.
             ' At "'.$_REQUEST['data_fim'].'"';

	if($_REQUEST['pessoa'] != ''){
		$consulta.= ' AND Pessoa = "'.$_REQUEST['pessoa'].'" ';

		$cons_cliente = 'SELECT Nome_Razao, Pessoa FROM pessoa '.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$_REQUEST['pessoa'].'"';
		$res_cliente = consulta_sql($cons_cliente);
		$reg_cliente = consulta_ler_linha($res_cliente);
		consulta_limpa($res_cliente);

		$filtro.= ' Cliente: "'.$reg_cliente[0].'"';

		//$filtro.= ' Pessoa: "'.$_REQUEST['pessoa'].'" ';
	}

	if($_REQUEST['vendedor'] != ''){
		$consulta.= ' AND Vendedor = "'.$_REQUEST['vendedor'].'" ';

		$vendedor = $_REQUEST['vendedor'];

		$cons_vend = 'SELECT Nome_Razao, Pessoa FROM pessoa '.
				   ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
				   ' AND Pessoa = "'.$vendedor.'"';
		$res_vend = consulta_sql($cons_vend);
		$reg_vend = consulta_ler_linha($res_vend);
		consulta_limpa($res_vend);

		$label_emp = empresa_representante($vendedor);

		$filtro.= ' '.$label.': "'.$label_emp.'"';
		//$filtro.= ' '.$label.': "'.$_REQUEST['vendedor'].'" ';
	}

	if($_REQUEST['empresa'] != ''){
		$consulta.= ' AND Empresa = "'.$_REQUEST['empresa'].'" ';

		$cons_empresa = 'SELECT Nome_Listas FROM pessoa '.
					  ' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
					  ' AND Pessoa = "'.$_REQUEST['empresa'].'"';
		$res_empresa = consulta_sql($cons_empresa);
		$reg_empresa = consulta_ler_linha($res_empresa);
		consulta_limpa($res_empresa);

		$filtro.= ' Empresa: "'.$reg_empresa[0].'"';
		//$filtro.= ' Empresa: "'.$_REQUEST['empresa'].'" ';
	}

	if($_REQUEST['nr_doc'] != ''){
		$consulta.= ' AND Nr_Doc = "'.$_REQUEST['nr_doc'].'" ';
		$filtro.= ' Nr Doc: "'.$_REQUEST['nr_doc'].'" ';
	}
	//Modificao para a Dimel 83 (351 apenas para teste )
	if( ($_SESSION['Dominio']=='83')||($_SESSION['Dominio']=='351XXX')){
		if($_REQUEST['tipo_doc'] != ''){
			if($_REQUEST['tipo_doc'] == 'C'){
				$consulta.= ' AND (Modelo = "2D" OR Modelo = "59"  ) ';
				$filtro.= ' Tipo Doc: "Cupom" ';
			}else if($_REQUEST['tipo_doc'] == 'N'){
				$consulta.= ' AND Modelo != "2D" AND  Modelo != "59" ';
				$filtro.= ' Tipo Doc: "Nota Fiscal" ';
			}
		}
	}else{
		if($_REQUEST['tipo_doc'] != ''){
			if($_REQUEST['tipo_doc'] == 'C'){
				$consulta.= ' AND Modelo = "2D" ';
				$filtro.= ' Tipo Doc: "Cupom" ';
			}else if($_REQUEST['tipo_doc'] == 'N'){
				$consulta.= ' AND Modelo != "2D" ';
				$filtro.= ' Tipo Doc: "Nota Fiscal" ';
			}
		}

	}

	

	//$consulta.= ' ORDER BY Vendedor, DT_Pagto, Nr_Comissao ';
	$consulta.= ' ORDER BY Nr_Comissao ';

	$resultado = consulta_sql($consulta);
	$nrows = consulta_num_registros($resultado);

	$worksheet1->write(7,0,"Filtro: ".$filtro);

	for($i=0;$i<$nrows;$i++){
		$registro = consulta_ler_objeto($resultado);
		set_time_limit(60);

		if(!isset($lista_geral[$registro->Vendedor])){
			$label_emp = empresa_representante($registro->Vendedor, 'S');

			$desc_vendedor = $label_emp;

			$lista_geral[$registro->Vendedor]['Vendedor'] = $registro->Vendedor;
			$lista_geral[$registro->Vendedor]['Vendedor_Desc'] = $desc_vendedor;
			$lista_geral[$registro->Vendedor]['Notas'] = array();
		}

		if($registro->Nr_Doc == 0){
			$nr_nf = '';
		}else if($registro->Modelo == '2D'){
			$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo;
		}else{
			$nr_nf = $registro->Nr_Doc.'/'.$registro->Serie.'-'.$registro->Modelo;
		}

		$nr_pedido = '';
		if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura()){
			if($registro->Modelo == '2D'){
				$con_cupo = 'SELECT Nr_Pedido FROM ecf_cupom '.
							' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
							' AND Empresa = "'.$registro->Empresa.'"'.
							' AND NrFab = "'.$registro->Serie.'"'.
							' AND DT_Emissao = "'.$registro->DT_Emissao.'"'.
							' AND COO = "'.$registro->NrDoc.'"';
				$res_cupo = consulta_sql($con_cupo);
				$reg_cupo = consulta_ler_linha($res_cupo);
				consulta_limpa($res_cupo);
				if($reg_cupo[0] > 0){
					$nr_pedido = $reg_cupo[0];
				}
			}else{
				$con_nota = 'SELECT Pedido_Nr FROM nota_fiscal '.
							' WHERE Dominio = "'.$_SESSION["Dominio"].'"'.
							' AND Empresa = "'.$registro->Empresa.'"'.
							' AND Nr_Nota = "'.$registro->Nr_Nota.'"';
				$res_nota = consulta_sql($con_nota);
				$reg_nota = consulta_ler_linha($res_nota);
				consulta_limpa($res_nota);
				if($reg_nota[0] > 0){
					$nr_pedido = $reg_nota[0];
				}
			}
		}

		if(($registro->Modelo == '2D') && ($registro->Pessoa == 0)){
			$pessoa = 'VENDA VIA ECF - CONSUMIDOR FINAL';
		}else if($registro->Pessoa==0){
			$pessoa = 'CONSUMIDOR NO IDENTIFICADO';
		}else{
			$con_pessoa = 'SELECT Nome_Listas FROM pessoa '.
					   ' WHERE Dominio = "'.$_SESSION['Dominio'].'"'.
					   ' AND Pessoa = "'.$registro->Pessoa.'"';
			$res_pessoa = consulta_sql($con_pessoa);
			$reg_pessoa = consulta_ler_linha($res_pessoa);
			consulta_limpa($res_pessoa);

			$pessoa = $registro->Pessoa.'-'.$reg_pessoa[0];
		}

		$con_nota = 'SELECT Nat_Op_CFOP FROM nota_fiscal '.
				  ' WHERE Dominio = "'.$_SESSION['Dominio'].'" '.
				  ' AND Empresa = "'.$registro->Empresa.'"'.
				  ' AND Nr_Nota = "'.$registro->Nr_Nota.'"';
		$res_nota = consulta_sql($con_nota);
		$reg_nota = consulta_ler_linha($res_nota);
		consulta_limpa($res_nota);

		$situacao = $registro->Situacao;

		if($situacao == 'F'){
			$situacao = 'Fechada';
		}

		if($situacao == 'P'){
			$situacao = 'Definida';
		}

		if($situacao == 'A'){
			$situacao = 'A Definir';
		}

		$lista_geral[$registro->Vendedor]['Notas'][$i]['Nr_NF'] = $nr_nf;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Nr_Pedido'] = $nr_pedido;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Nr_Doc'] = $registro->Nr_Doc;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Serie'] = $registro->Serie;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Modelo'] = $registro->Modelo;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Valor_NF'] = $registro->Valor_NF;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Contas_Baixa'] = $registro->Contas_Baixa;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Contas_Recebe'] = $registro->Contas_Recebe;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Tipo'] = $registro->Tipo;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Observacao'] = $registro->Observacao;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Pessoa'] = $pessoa;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['DT_Comissao'] = $registro->DT_Comissao;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Nat_Op_CFOP'] = $reg_nota[0];
		$lista_geral[$registro->Vendedor]['Notas'][$i]['DT_Pagto'] = $registro->DT_Pagto;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Situacao'] = $situacao;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['Valor_Comissao'] = $registro->Valor_Comissao;
		$lista_geral[$registro->Vendedor]['Notas'][$i]['TipoMov'] = $registro->TipoMov;
	}

	if(!empty($lista_geral)){
		$linha_ini = 9;

		$coluna = 0;
		$worksheet1->set_column($coluna,$coluna,16);
		$worksheet1->write_string($linha_ini,$coluna,'Nr NF',$formatott);
		$coluna++;

		if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura() ){
			$worksheet1->set_column($coluna,$coluna,10);
			$worksheet1->write_string($linha_ini,$coluna,'Nr Ped.',$formatott);
			$coluna++;
		}

		$worksheet1->set_column($coluna,$coluna,14);
		$worksheet1->write_string($linha_ini,$coluna,'Valor NF',$formatott);
		$coluna++;

		//if($_SESSION['Dominio'] != $cod_dominio){
		if(($_SESSION['Dominio'] != $cod_dominio)&&( !Zathura() )){
			$worksheet1->set_column($coluna,$coluna,12);
			$worksheet1->write_string($linha_ini,$coluna,'Data Baixa',$formatott);
			$coluna++;

			$worksheet1->set_column($coluna,$coluna,12);
			$worksheet1->write_string($linha_ini,$coluna,'Data Recebe',$formatott);
			$coluna++;
		}

		$worksheet1->set_column($coluna,$coluna,30);
		$worksheet1->write_string($linha_ini,$coluna,'Cliente',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,12);
		$worksheet1->write_string($linha_ini,$coluna,'DT Comisso',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,8);
		$worksheet1->write_string($linha_ini,$coluna,'CFOP',$formatott);
		$coluna++;

		//if($_SESSION['Dominio'] != $cod_dominio){
		if(($_SESSION['Dominio'] != $cod_dominio)&&( !Zathura() )){
			$worksheet1->set_column($coluna,$coluna,12);
			$worksheet1->write_string($linha_ini,$coluna,'Data Pagto',$formatott);
			$coluna++;
		}

		$worksheet1->set_column($coluna,$coluna,10);
		$worksheet1->write_string($linha_ini,$coluna,'Sit. Atual',$formatott);
		$coluna++;

		$worksheet1->set_column($coluna,$coluna,16);
		$worksheet1->write_string($linha_ini,$coluna,'Valor Comisso',$formatott);
		$coluna++;

		$worksheet1->repeat_rows(0,$linha_ini);
		$linha_ini++;

		$total_geral_nf = 0;
		$total_geral_comissao = 0;

		foreach($lista_geral as $chave => $registro){
			$total_vendedor_nf = 0;
			$total_vendedor_comissao = 0;

			$coluna = 0;
			//$linha_ini++;

			if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura() ){
				$worksheet1->write_string($linha_ini,$coluna, ' '.$label.': '.$registro['Vendedor_Desc'], $formatotlb);
				$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+7);
				for($lb=0;$lb<=6;$lb++){
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
				}
			}else{
				$worksheet1->write_string($linha_ini,$coluna, ' '.$label.': '.$registro['Vendedor_Desc'], $formatotlb);
				$worksheet1->merge_cells($linha_ini, $coluna, $linha_ini, $coluna+9);
				for($lb=0;$lb<=8;$lb++){
					$coluna++;
					$worksheet1->write_blank($linha_ini,$coluna,$formatotc); //acertar bordas
				}
			}

			//$coluna++;
	
			$linha_ini++;

			foreach($registro['Notas'] as $nota){
				$coluna = 0;

				$worksheet1->write_string($linha_ini,$coluna,$nota['Nr_NF'],$formatotc);
				$coluna++;

				if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura()){
					$worksheet1->write_string($linha_ini,$coluna,$nota['Nr_Pedido'],$formatotc);
					$coluna++;
				}

				$worksheet1->write_number($linha_ini,$coluna,$nota['Valor_NF'],$formatotpreco);
				$coluna++;

				//if($_SESSION['Dominio'] != $cod_dominio){
				if(($_SESSION['Dominio'] != $cod_dominio)&&(!Zathura() )){
					if($nota['Tipo'] == 'E'){
						$worksheet1->write_string($linha_ini,$coluna,$nota['Observacao'],$formatotl);
						$coluna++;

						$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
						$coluna++;
					}else{
						$data_baixa = dataf($nota['Contas_Baixa']);
						if($data_baixa == '00/00/0000'){
							$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
							$coluna++;
						}else{
							$worksheet1->write_number($linha_ini,$coluna,data2nr($data_baixa),$formato_data);
							$coluna++;
						}

						$data_recebe = dataf($nota['Contas_Recebe']);
						if($data_recebe == '00/00/0000'){
							$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
							$coluna++;
						}else{
							$worksheet1->write_number($linha_ini,$coluna,data2nr($data_recebe),$formato_data);
							$coluna++;
						}
					}
				}

				$worksheet1->write_string($linha_ini,$coluna,$nota['Pessoa'],$formatotl);
				$coluna++;

				$data_comissao = dataf($nota['DT_Comissao']);
				if($data_comissao == '00/00/0000'){
					$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
					$coluna++;
				}else{
					$worksheet1->write_number($linha_ini,$coluna,data2nr($data_comissao),$formato_data);
					$coluna++;
				}

				$worksheet1->write_string($linha_ini,$coluna,$nota['Nat_Op_CFOP'],$formatotc);
				$coluna++;

				//if($_SESSION['Dominio'] != $cod_dominio){
				if(($_SESSION['Dominio'] != $cod_dominio)&&( !Zathura() )){
					$data_pagto = dataf($nota['DT_Pagto']);
					if($data_pagto == '00/00/0000'){
						$worksheet1->write_string($linha_ini,$coluna,'',$formatotl);
						$coluna++;
					}else{
						$worksheet1->write_number($linha_ini,$coluna,data2nr($data_pagto),$formato_data);
						$coluna++;
					}
				}

				$worksheet1->write_string($linha_ini,$coluna,$nota['Situacao'],$formatotc);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$nota['Valor_Comissao'],$formatotpreco);
				$coluna++;

				$valor_nf = $nota['Valor_NF'];
				if($nota['TipoMov'] == 'D'){
					$valor_nf = $valor_nf * (-1);
				}

				$total_vendedor_nf+= $valor_nf;
				$total_vendedor_comissao+= $nota['Valor_Comissao'];

				$total_geral_nf+= $valor_nf;
				$total_geral_comissao+= $nota['Valor_Comissao'];

				$linha_ini++;
			}

			$coluna = 0;
			//$linha_ini++;

			$worksheet1->write_string($linha_ini,$coluna,'Total '.$label.':',$formatotlb);
			$coluna++;

			//if($_SESSION['Dominio'] == $cod_dominio){
			if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura()){
				$worksheet1->write_string($linha_ini,$coluna,'',$formatotlb);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$total_vendedor_nf,$formatotpreco_b);
				$coluna++;

				for($col=$coluna;$col<7;$col++){
					$worksheet1->write_string($linha_ini,$col,'',$formatotlb);
					$coluna++;
				}
				$worksheet1->write_number($linha_ini,$coluna,$total_vendedor_comissao,$formatotpreco_b);
				$coluna++;
			}else{
				//$coluna++
				$worksheet1->write_number($linha_ini,$coluna,$total_vendedor_nf,$formatotpreco_b);
				$coluna++;

				for($col=$coluna;$col<9;$col++){
					$worksheet1->write_string($linha_ini,$col,'',$formatotlb);
					$coluna++;
				}
				$worksheet1->write_number($linha_ini,$coluna,$total_vendedor_comissao,$formatotpreco_b);
				$coluna++;
			}

			$linha_ini++;
			$linha_ini++;
		}

		if($_REQUEST['vendedor'] == ''){
			$coluna = 0;

			$worksheet1->write_string($linha_ini,$coluna,'Total Geral:',$formatotlb);
			$coluna++;

			//if($_SESSION['Dominio'] == $cod_dominio){
			if(($_SESSION['Dominio'] == $cod_dominio)|| Zathura() ){
				$worksheet1->write_string($linha_ini,$coluna,'',$formatotlb);
				$coluna++;

				$worksheet1->write_number($linha_ini,$coluna,$total_geral_nf,$formatotpreco_b);
				$coluna++;

				for($col=$coluna;$col<7;$col++){
					$worksheet1->write_string($linha_ini,$col,'',$formatotlb);
					$coluna++;
				}
				$worksheet1->write_number($linha_ini,$coluna,$total_geral_comissao,$formatotpreco_b);
				$coluna++;
			}else{
				$worksheet1->write_number($linha_ini,$coluna,$total_geral_nf,$formatotpreco_b);
				$coluna++;

				for($col=$coluna;$col<9;$col++){
					$worksheet1->write_string($linha_ini,$col,'',$formatotlb);
					$coluna++;
				}
				$worksheet1->write_number($linha_ini,$coluna,$total_geral_comissao,$formatotpreco_b);
				$coluna++;
			}
		}
	}else{
		$worksheet1->write(10, 0, "No existem registros para este filtro!");
	}

	//ESTA VARIAVEL  PARA CONTROLAR O TEMPO QUE APARECE O DIV NO MOMENTO DE GERAR O EXCEL
	$insert = 'INSERT INTO relatorio_tmp ( '.
             ' Dominio, '.
             ' Usuario, '.
             ' Descricao ) VALUES ('.
             '"'.$_SESSION['Dominio'].'", '.
             '"'.base64_decode_si($_REQUEST['USER_ID']).'", '.
             '"")';
	consulta_sql($insert);

	$workbook->close();
?>