<?
    require_once('../../includes/header.inc');
    require_once('../../includes/base_class.inc');
    define('FPDF_FONTPATH', '../../fpdf/font/');
    require('../../fpdf/fpdf.php');
	
if(session::usr_conectado($_REQUEST['USER_ID']) ){

	$hora = nr2hora(hora_atual());
	$hoje = data_atual('data');
	$label = label_vendedor_ou_rep_comercial('S');

	$empresa = $_REQUEST['empresa'];
	$dt_ini = $_REQUEST['dt_ini'];
	$dt_fim = $_REQUEST['dt_fim'];
	$nrfab = $_REQUEST['nrfab'];
	$tipo_rel = $_REQUEST['tipo_rel'];

	class PDF extends FPDF{
        var $TipoRel;

        function Header($tipo_cab='tudo'){
			if ($this->DefOrientation=='P'){
				$tamanho_total_linha = 190;
			}else{
				$tamanho_total_linha = 275;
			}
			$this->SetFillColor(255,255,255);
			$date=getdate();
			$hoje = fill_full($date['year'],4).'-'.fill_full($date['mon'],2).'-'.fill_full($date['mday'],2);
			$hora = fill_full($date['hours'],2).':'.fill_full($date['minutes'],2).':'.fill_full($date['seconds'],2);


			$this->SetFont('Arial','B',10);
			//Imprime Cabealho

			$this->Cell(1,  5, ' ', 0,0,'C');
			$this->Cell(30, 5, " ", 0,0,'L');

			$lns_cabecalho = $this->Lines_MultiCell(($tamanho_total_linha-60),5,$this->Cabecalho,1);
			$y=$this->y;
			$this->MultiCell(($tamanho_total_linha-60), (5/($lns_cabecalho*5)) * 5, $this->Cabecalho, 0,'C');
			$this->y=$y;
			if($tipo_cab=='tudo'){
				$this->SetFont('Arial','',8);
				$this->Cell(30, 5, dataf($hoje).' '.($hora), 0,0,'R');
			}
			$this->Cell(1,  5, ' ', 0,1,'C');

			//linha
			$this->Cell(1,  (5/($lns_cabecalho*5)) * 5, ' ', 0,0,'C');
			$this->MultiCell(($tamanho_total_linha), (5/($lns_cabecalho*5)) * 5, ' ', 'T', 'C');
			$this->Cell(1,  (5/($lns_cabecalho*5)) * 5, ' ', 0,1,'C');


			if($this->Sub_Cabecalho_Texto!=''){
				$this->SetFont('Arial',$this->Sub_Cabecalho_Style,10);
				$lns_cabecalho = $this->Lines_MultiCell($tamanho_total_linha,5,$this->Sub_Cabecalho_Texto,$this->Sub_Cabecalho_Border);
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,0,'C');
				$y=$this->y;
				$this->MultiCell($tamanho_total_linha, 5 , $this->Sub_Cabecalho_Texto, $this->Sub_Cabecalho_Border,$this->Sub_Cabecalho_Align);
				$this->y=$y;
				$this->Cell(1,  ($lns_cabecalho*5), ' ', 0,1,'C');
				$this->x=$this->lMargin;
				$this->y=$y+($lns_cabecalho*5);
				$this->SetAutoPageBreak(true,30);
				$this->SetFont('Arial','',6);
			}

			if($this->CabecalhoGrid_Texto=='comparativo_reducao'){
				/* if($this->TipoRel=='A'){

                 $this->SetFont('Arial','B',6);
                 $lns = 4;
                 //primeira linha do cabealho

                 $this->Cell(1,  $lns, ' ', 0,0,'C');
                 $this->SetAutoPageBreak(false,30);

                 $this->SetFillColor(220,220,220);

                 $y=$this->y;
                 $this->MultiCell((7/100)*190, $lns, 'Nr Cupom','T','C', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((15/100)*190, $lns, 'Sub Total','T','R', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((12/100)*190, $lns, 'Valor Acrscimo','T','R', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((12/100)*190, $lns, 'Valor Desconto','T','R', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((15/100)*190, $lns, 'Valor Venda','T','R', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((9/100)*190, $lns, '','T','C', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((10/100)*190, $lns, 'Finalizadora','T','L', 1);
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((20/100)*190, $lns, $label,'T','L', 1);
                 $this->y=$y;

                 $this->Cell(1,      $lns, ' ', 0,1,'C');

                 $this->x=$this->lMargin;
                 $this->y=$y+$lns;
                 $this->SetAutoPageBreak(true,30);

                 $this->SetFillColor(255,255,255);

                 //Prxima Linha
                 $this->Cell(1,      $lns, '', 0,0,'C');
                 $this->SetAutoPageBreak(false,30);

                 $y=$this->y;
                 $this->MultiCell((4/100)*190, $lns,'','B','C');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((39/100)*190, $lns,'Produto','B','L');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((8/100)*190, $lns, 'Tributo','B','L');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((8/100)*190, $lns, 'Quantidade','B','R');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((15/100)*190, $lns, 'Valor Unitrio','B','R');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((15/100)*190, $lns, 'Valor Total','B','R');
                 $this->y=$y;

                 $y=$this->y;
                 $this->MultiCell((11/100)*190, $lns,'','B','C');
                 $this->y=$y;

                 $this->Cell(1,      $lns, ' ', 0,1,'C');

                 $this->x=$this->lMargin;
                 $this->y=$y+$lns;
                 $this->SetAutoPageBreak(true,30);
                 $this->SetFont('Arial','',6);

				} */
			}else if($this->CabecalhoGrid_Texto!=''){

				$this->Cell(1,  5, ' ', 0,0,'C');
				$this->SetFont('Arial','B',6);

				foreach($this->CabecalhoGrid_Texto as $key => $reg){
					$tamanho = $this->CabecalhoGrid_Tamanho[$key];
					$tamanho = $tamanho/100;
					$tamanho = $tamanho_total_linha*$tamanho;
					$valor = $this->CabecalhoGrid_Texto[$key];
					$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border[$key],0,$this->CabecalhoGrid_Align[$key]);
				}
				$this->Cell(1,  5, ' ', 0,1,'C');

				//quebra de pgina - cabecalho do item
				if(isset($this->CabecalhoGrid_Texto_Item)){
					foreach($this->CabecalhoGrid_Texto_Item as $key => $reg){
						$tamanho = $this->CabecalhoGrid_Tamanho_Item[$key];
						$tamanho = $tamanho/100;
						$tamanho = $tamanho_total_linha*$tamanho;
						$valor = $this->CabecalhoGrid_Texto_Item[$key];
						$this->Cell($tamanho, 5, $valor, $this->CabecalhoGrid_Border_Item[$key],0,$this->CabecalhoGrid_Align_Item[$key]);
					}
					$this->Cell(1,  5, ' ', 0,1,'C');
				}             
			}
			$this->SetFont('Arial','',6);
        }
    }

    $filtro = '';

    $cons_reducao = 'select DT_Mov, CRZ, CRO, COO_Ini, COO_Fim, '.
                     ' GT_Ini, GT_Fim, DH_Reducao '.
                     ' from ecf_reducao '.
                     ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                     ' and Empresa = "'.$empresa.'"'.
                     ' and NrFab = "'.$nrfab.'" '.
                     ' and DT_Mov >= "'.datad($dt_ini).'"'.
                     ' and DT_Mov <= "'.datad($dt_fim).'"'.
                     ' order by DT_Mov, COO_Ini, CRZ ';


    $lista_empresas = lista_empresas();
    $filtro.= 'Data: De "'.$dt_ini.'" At "'.$dt_fim.'"';
    $filtro.= ' Empresa: "'.nome_empresa($lista_empresas,$empresa).'"';

    if($nrfab!=''){
        $cons_ecf = 'select NrCaixa from ecf '.
                    ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                    ' and Empresa = "'.$empresa.'"'.
                    ' and NrFab = "'.$nrfab.'"';
        $res_ecf = consulta_sql($cons_ecf);
        $reg_ecf = consulta_ler_linha($res_ecf);
        consulta_limpa($res_ecf);
        //$filtro.= ' NrFab: "'.$nrfab.'"';
        $filtro.= ' ECF: "'.$reg_ecf[0].'"';
    }

    if($tipo_rel!=''){
        if($tipo_rel=='A'){
           $tipo = 'Analtico';
        }else{
           $tipo = 'Sinttico';
        }
        $filtro.= ' Tipo: "'.$tipo.'"';
    }


	$pdf=new PDF('P');
	$pdf->Open();
	$pdf->Cabecalho = 'Relatrio Comparativo da Reduo Z';
	$pdf->CabecalhoGrid_Texto = ''; //comparativo_reducao
	$pdf->Cabecalho_Filtro = $filtro;
	$pdf->Sub_Cabecalho_Texto =  '';
	$pdf->Sub_Cabecalho_Style =  'B';
	$pdf->Sub_Cabecalho_Align =  'L';
	$pdf->Sub_Cabecalho_Border =  0;

	$pdf->TipoRel = $tipo_rel;

	set_time_limit(60);
	$res_reducao = consulta_sql($cons_reducao);
	$nrows_reducao = consulta_num_registros($res_reducao);
	if($nrows_reducao>0){

        $pdf->AddPage();
        $pdf->SetFont('Arial','',5);

        $id_data = '';
        $venda_bruta = 0;
        $venda_liq_red = 0;
        $venda_liq_base = 0;

        $vl_trib = 0;
        $vl_nao_trib = 0;
        $vl_outras_oper = 0;

        $totalT_trib_baseG = 0;
        $totalT_trib_valorG = 0;
        $totalS_trib_baseG = 0;
        $totalS_trib_valorG = 0;
        $totalT_nao_trib_baseG = 0;
        $totalS_nao_trib_baseG = 0;

        for ($e=0;$e<$nrows_reducao;$e++){

			$reg_reducao = consulta_ler_objeto($res_reducao);
			set_time_limit(60);
			$lns = 3;
			$larg = 190;

			$pdf->SetFont('Arial','',6);

			$aliq_trib = array();
			$aliq_nao_trib = array();
			$aliq_outras = array();

			for($a=0;$a<16;$a++){
				$aliq_trib[$a]['d'] = '';
				$aliq_nao_trib[$a]['d'] = '';
				$aliq_outras[$a]['d'] = '';

				$aliq_trib[$a]['b'] = '';
				$aliq_nao_trib[$a]['b'] = '';
				$aliq_outras[$a]['b'] = '';

				$aliq_trib[$a]['v'] = '';

			}

			$totalT_trib_base = 0;
			$totalT_trib_valor = 0;
			$totalS_trib_base = 0;
			$totalS_trib_valor = 0;
			$totalT_nao_trib_base = 0;
			$totalS_nao_trib_base = 0;

			$cont_trib = 0;
			$cont_nao_trib = 0;
			$cont_outras = 0;

			$cons_red_det = 'select TributoSeq, TributoCod, Valor '.
                             ' from ecf_reducao_det '.
                             ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                             ' and Empresa = "'.$empresa.'"'.
                             ' and NrFab = "'.$nrfab.'" '.
                             ' and DT_Mov = "'.$reg_reducao->DT_Mov.'" '.
                             ' and CRZ = "'.$reg_reducao->CRZ.'" '.
                             ' and CRO = "'.$reg_reducao->CRO.'" '.
                             ' and (Valor <> "" or Valor <> 0)';
			$res_red_det = consulta_sql($cons_red_det);
			$nro_red_det = consulta_num_registros($res_red_det);

			for($r=0;$r<$nro_red_det;$r++){
                $reg_red_det = consulta_ler_objeto($res_red_det);

                //Aliquota Tributavel
                if($reg_red_det->TributoSeq>0){
                    $vl_trib+= ($reg_red_det->Valor);
                    $venda_liq_red+= ($reg_red_det->Valor);

                    $tributo = $reg_red_det->TributoCod;
                    $vl_tributo = '';
                    $compara_tributo = '';
                    if((substr($tributo,0,1)=='T')||(substr($tributo,0,1)=='S')){
                        $vl_tributo = substr($reg_red_det->TributoCod,1,4);
                        $compara_tributo = substr($reg_red_det->TributoCod,0,1);
                        $tributo = fill_full($reg_red_det->TributoSeq,2).$reg_red_det->TributoCod;
                    }else{
                        $vl_tributo = substr($reg_red_det->TributoCod,3,6);
                        $compara_tributo = substr($reg_red_det->TributoCod,2,1);
                        $tributo = $reg_red_det->TributoCod;
                    }

                    //$aliq_trib[$cont_trib]['d'] = fill_full($reg_red_det->TributoSeq,2).$reg_red_det->TributoCod;
                    $aliq_trib[$cont_trib]['d'] = $tributo;
                    $aliq_trib[$cont_trib]['b'] = $reg_red_det->Valor;
                    $aliq_trib[$cont_trib]['v'] = $reg_red_det->Valor*($vl_tributo)/10000;
                    $aliq_trib[$cont_trib]['v'] = str2nr(formata_valor(str_replace('"','',to_money($aliq_trib[$cont_trib]['v']))));

                    if($compara_tributo=='T'){
                        $totalT_trib_base+= $aliq_trib[$cont_trib]['b'];
                        $totalT_trib_valor+= $aliq_trib[$cont_trib]['v'];
                        $totalT_trib_baseG+= $aliq_trib[$cont_trib]['b'];
                        $totalT_trib_valorG+= $aliq_trib[$cont_trib]['v'];
                    }else{
                        $totalS_trib_base+= $aliq_trib[$cont_trib]['b'];
                        $totalS_trib_valor+= $aliq_trib[$cont_trib]['v'];
                        $totalS_trib_baseG+= $aliq_trib[$cont_trib]['b'];
                        $totalS_trib_valorG+= $aliq_trib[$cont_trib]['v'];
                    }

                    $aliq_trib[$cont_trib]['b'] = str_replace('"','',to_money($aliq_trib[$cont_trib]['b']));
                    $aliq_trib[$cont_trib]['v'] = str_replace('"','',to_money($aliq_trib[$cont_trib]['v']));

                    $cont_trib++;


                }else{
                    //Aliquota No Tributavel
                    if((substr($reg_red_det->TributoCod,0,1)=='N') ||
                        (substr($reg_red_det->TributoCod,0,1)=='I') ||
                        (substr($reg_red_det->TributoCod,0,1)=='F')){
						$vl_nao_trib+= ($reg_red_det->Valor);
						$venda_liq_red+= ($reg_red_det->Valor);

                        $aliq_nao_trib[$cont_nao_trib]['d'] = $reg_red_det->TributoCod;
                        $aliq_nao_trib[$cont_nao_trib]['b'] = $reg_red_det->Valor;

                        if(substr($reg_red_det->TributoCod,1,1)=='S'){
							$totalS_nao_trib_base+= $aliq_nao_trib[$cont_nao_trib]['b'];
							$totalS_nao_trib_baseG+= $aliq_nao_trib[$cont_nao_trib]['b'];
                        }else{
                            $totalT_nao_trib_base+= $aliq_nao_trib[$cont_nao_trib]['b'];
                            $totalT_nao_trib_baseG+= $aliq_nao_trib[$cont_nao_trib]['b'];
                        }
                        $aliq_nao_trib[$cont_nao_trib]['b'] = str_replace('"','',to_money($aliq_nao_trib[$cont_nao_trib]['b']));

                        $cont_nao_trib++;

                    }else{
						//Outras Operacoes
						$vl_outras_oper+= ($reg_red_det->Valor);
						$aliq_outras[$cont_outras]['d'] = $reg_red_det->TributoCod;
						$aliq_outras[$cont_outras]['b'] = $reg_red_det->Valor;
						$aliq_outras[$cont_outras]['b'] = str_replace('"','',to_money($aliq_outras[$cont_outras]['b']));

                        $cont_outras++;

                    }
				}
			}
			consulta_limpa($res_red_det);

			$maior = '';
			if($cont_trib>$cont_nao_trib){
                $maior = $cont_trib;
			}else{
                $maior = $cont_nao_trib;
			}

			if($maior<$cont_outras){
                $maior = $cont_outras;
			}


			$cons_liq_base = 'select sum(SubTotal+Acrescimo-Desconto) '.
                              ' from ecf_cupom '.
                              ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                              ' and Empresa = "'.$empresa.'" '.
                              ' and NrFab = "'.$nrfab.'" '.
                              ' and DT_Emissao = "'.$reg_reducao->DT_Mov.'" '.
                              ' and Cancelado = "N" ';
            $res_liq_base = consulta_sql($cons_liq_base);
            $reg_liq_base = consulta_ler_linha($res_liq_base);
            consulta_limpa($res_liq_base);
/*
             $nro_liq_base = consulta_num_registros($res_liq_base);

             if($nro_liq_base>0){
                for($b=0;$b<$nro_liq_base;$b++){
                    $reg_liq_base = consulta_ler_linha($res_liq_base);

                    $venda_liq_base+= (($reg_liq_base[0]+$reg_liq_base[1])-($reg_liq_base[2]));
                }
             }
*/

            $venda_liq_base = $reg_liq_base[0];

            $lns = 1;
            $larg = 190;

            $pdf->SetAutoPageBreak(true,30);

            //linha
            $pdf->Cell(1,      $lns, '', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);

            $y=$pdf->y;
            $pdf->MultiCell($larg, $lns, '', 'T', 'C');
            $pdf->y=$y;

            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $lns = 3;
            $pdf->SetFont('Arial','B',6);
            $pdf->SetAutoPageBreak(true,55);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','B',6);

            $y=$pdf->y;
            $pdf->MultiCell((13/100)*$larg, $lns, 'Dados da Reduo Z', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $pdf->SetFont('Arial','',6);
            $y=$pdf->y;
            $pdf->MultiCell((4/100)*$larg, $lns, 'ECF:', '', 'C');
            $pdf->y=$y;

            $cons_caixa = 'select NrCaixa from ecf '.
                           ' where Dominio = "'.$_SESSION['Dominio'].'"'.
                           ' and Empresa = "'.$empresa.'"'.
                           ' and NrFab = "'.$nrfab.'"';
            $res_caixa = consulta_sql($cons_caixa);
            $reg_caixa = consulta_ler_linha($res_caixa);
            consulta_limpa($res_caixa);

            $y=$pdf->y;
            $pdf->MultiCell((5/100)*$larg, $lns, $reg_caixa[0], '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, 'Data Movimento:', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, dataf($reg_reducao->DT_Mov), '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((70/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $lns = 4;
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $lns = 3;
            $pdf->SetFont('Arial','',6);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',6);

            $pdf->SetFont('Arial','U',6);

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, 'Venda Bruta:', '', 'L');
            $pdf->y=$y;

            $pdf->SetFont('Arial','',6);

            $venda_bruta+= ($reg_reducao->GT_Fim-$reg_reducao->GT_Ini);
            $y=$pdf->y;
            $pdf->MultiCell((22/100)*$larg, $lns, str_replace('"','',to_money($venda_bruta)), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((3/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $pdf->SetFont('Arial','U',6);

            $y=$pdf->y;
            $pdf->MultiCell((12/100)*$larg, $lns, 'Venda Lq. Reduo:', '', 'L');
            $pdf->y=$y;

            $pdf->SetFont('Arial','',6);


            $y=$pdf->y;
            $pdf->MultiCell((18/100)*$larg, $lns, str_replace('"','',to_money($venda_liq_red)), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((3/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $pdf->SetFont('Arial','U',6);

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, 'Venda Lq. Base:', '', 'L');
            $pdf->y=$y;

            $pdf->SetFont('Arial','B',6);

            //Comparar venda liq. reduo com venda liq. base; se diferente, preencher venda liq. base com cor vermelha
            if($venda_liq_red!=$venda_liq_base){
                $pdf->SetTextColor(255,0,0);
                //255 0 0 - Vermelho
                //0 0 255 - Azul
            }else{
                $pdf->SetTextColor(0);
            }
            $y=$pdf->y;
            $pdf->MultiCell((20/100)*$larg, $lns, str_replace('"','',to_money($venda_liq_base)), '', 'R');
            $pdf->y=$y;

            $pdf->SetTextColor(0);

            $y=$pdf->y;
            $pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $lns = 4;
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $lns = 3;
            $pdf->SetFont('Arial','',6);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',6);

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, 'COO Inicial:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, $reg_reducao->COO_Ini, '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, 'COO Final:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, $reg_reducao->COO_Fim, '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((4/100)*$larg, $lns, 'CRZ:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, $reg_reducao->CRZ, '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((4/100)*$larg, $lns, 'CRO:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, $reg_reducao->CRO, '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((16/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $lns = 4;
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $lns = 3;
            $pdf->SetFont('Arial','',6);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',6);

            $y=$pdf->y;
            $pdf->MultiCell((16/100)*$larg, $lns, 'Alquotas Tributveis:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((20/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((15/100)*$larg, $lns, 'Alquotas  No Tributveis:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((16/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((11/100)*$larg, $lns, 'Outras Operaes:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((22/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $lns = 4;
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);

            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetFont('Arial','',6);
            $pdf->SetAutoPageBreak(false,30);

            $pdf->SetFont('Arial','U',6);
            $y=$pdf->y;
			$pdf->MultiCell((8/100)*$larg, $lns, 'Totalizador', '', 'L');
			$pdf->y=$y;
			$pdf->SetFont('Arial','',6);

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, 'Base', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, 'Valor', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$pdf->SetFont('Arial','U',6);
			$y=$pdf->y;
			$pdf->MultiCell((8/100)*$larg, $lns, 'Totalizador', '', 'L');
			$pdf->y=$y;
			$pdf->SetFont('Arial','',6);

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, 'Base', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$pdf->SetFont('Arial','U',6);
			$y=$pdf->y;
			$pdf->MultiCell((10/100)*$larg, $lns, 'Totalizador', '', 'L');
			$pdf->y=$y;
			$pdf->SetFont('Arial','',6);

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, 'Base', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$lns = 4;
			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);

			for($j=0;$j<$maior;$j++){

				$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				$pdf->SetFont('Arial','',6);
				$pdf->SetAutoPageBreak(false,30);

				$pdf->SetFont('Arial','B',6);
				$y=$pdf->y;
				$pdf->MultiCell((8/100)*$larg, $lns, $aliq_trib[$j]['d'], '', 'L');
				$pdf->y=$y;
				$pdf->SetFont('Arial','',6);

				$y=$pdf->y;
				$pdf->MultiCell((12/100)*$larg, $lns, $aliq_trib[$j]['b'], '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((12/100)*$larg, $lns, $aliq_trib[$j]['v'], '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
				$pdf->y=$y;

				$pdf->SetFont('Arial','B',6);
				$y=$pdf->y;
				$pdf->MultiCell((8/100)*$larg, $lns, $aliq_nao_trib[$j]['d'], '', 'L');
				$pdf->y=$y;
				$pdf->SetFont('Arial','',6);

				$y=$pdf->y;
				$pdf->MultiCell((12/100)*$larg, $lns, $aliq_nao_trib[$j]['b'], '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
				$pdf->y=$y;

				//negrito
				$pdf->SetFont('Arial','B',6);
				//$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				//$pdf->SetAutoPageBreak(false,30);
				//$pdf->SetFont('Arial','B',6);

				$y=$pdf->y;
				$pdf->MultiCell((10/100)*$larg, $lns, $aliq_outras[$j]['d'], '', 'L');
				$pdf->y=$y;

				$pdf->SetFont('Arial','',6);
				//$pdf->Cell(1,      $lns, ' ', 0,0,'C');
				//$pdf->SetAutoPageBreak(false,30);
				//$pdf->SetFont('Arial','',6);

				$y=$pdf->y;
				$pdf->MultiCell((12/100)*$larg, $lns, $aliq_outras[$j]['b'], '', 'R');
				$pdf->y=$y;

				$y=$pdf->y;
				$pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
				$pdf->y=$y;

				$lns = 4;
				$pdf->Cell(1,      $lns, ' ', 0,1,'C');
				//Prxima Linha
				$pdf->x=$pdf->lMargin;
				$pdf->y=$y+$lns;
				$pdf->SetAutoPageBreak(true,30);
			}

            $lns = 3;
            $pdf->SetFont('Arial','',6);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',6);

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, 'Total ICMS:', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_trib_base)), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_trib_valor)), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_nao_trib_base)), '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((12/100)*$larg, $lns, '', '', 'R');
            $pdf->y=$y;

            $y=$pdf->y;
            $pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
            $pdf->y=$y;

            $lns = 4;
            $pdf->Cell(1,      $lns, ' ', 0,1,'C');
            //Prxima Linha
            $pdf->x=$pdf->lMargin;
            $pdf->y=$y+$lns;
            $pdf->SetAutoPageBreak(true,30);


            $lns = 3;
            $pdf->SetFont('Arial','',6);
            $pdf->Cell(1,      $lns, ' ', 0,0,'C');
            $pdf->SetAutoPageBreak(false,30);
            $pdf->SetFont('Arial','',6);

            $y=$pdf->y;
            $pdf->MultiCell((8/100)*$larg, $lns, 'Total ISS:', '', 'L');
            $pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_trib_base)), '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_trib_valor)), '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_nao_trib_base)), '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((12/100)*$larg, $lns, '', '', 'R');
			$pdf->y=$y;

			$y=$pdf->y;
			$pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
			$pdf->y=$y;

			$lns = 4;
			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);


			if($tipo_rel=='A'){

                $cons_ecf = 'select ecfcup.NrFab, '.
                            ' ecfcup.SubTotal, ecfcup.Desconto, ecfcup.Acrescimo, ecfcup.Cancelado, '.
                            ' ecfcup.Pessoa_Nome, ecfcup.Pessoa_CNPJ, ecfcup.Vendedor, '.
                            ' ecfcup.CCF, ecfcup.COO, ecfcup.DT_Emissao, ecfcup.HR_Emissao '.
                            ' from ecf_cupom ecfcup '.
                            ' where ecfcup.Dominio = "'.$_SESSION['Dominio'].'" '.
                            ' and ecfcup.Empresa = "'.$empresa.'" '.
                            ' and ecfcup.NrFab = "'.$nrfab.'" '.
                            ' and ecfcup.DT_Emissao = "'.$reg_reducao->DT_Mov.'" '.
                            ' order by ecfcup.DT_Emissao, ecfcup.CCF, ecfcup.COO ';
                $res_ecf = consulta_sql($cons_ecf);
                $nro_ecf = consulta_num_registros($res_ecf);

                if($nro_ecf>0){

					$lns = 5;
					$larg = 190;
					$k=0;

					$pdf->SetFont('Arial','B',6);
					$pdf->Cell(1,      $lns, ' ', 0,0,'C');
					$pdf->SetAutoPageBreak(false,30);
					$pdf->SetFont('Arial','B',6);

					$pdf->SetFillColor(220,220,220);

					$y=$pdf->y;
					$pdf->MultiCell((7/100)*190, $lns, 'Nr Cupom','T','C', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((15/100)*190, $lns, 'Sub Total','T','R', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((12/100)*190, $lns, 'Valor Acrscimo','T','R', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((12/100)*190, $lns, 'Valor Desconto','T','R', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((15/100)*190, $lns, 'Valor Venda','T','R', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((9/100)*190, $lns, '','T','C', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((10/100)*190, $lns, 'Finalizadora','T','L', 1);
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((20/100)*190, $lns, $label,'T','L', 1);
					$pdf->y=$y;

					$pdf->Cell(1,      $lns, ' ', 0,1,'C');
					//Prxima Linha
					$pdf->x=$pdf->lMargin;
					$pdf->y=$y+$lns;
					$pdf->SetAutoPageBreak(true,30);


					$c=0;

					$pdf->CabecalhoGrid_Texto[$c] = 'Nr Cupom';
					$pdf->CabecalhoGrid_Tamanho[$c] = '7';
					$pdf->CabecalhoGrid_Align[$c] = 'C';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = 'Sub Total';
					$pdf->CabecalhoGrid_Tamanho[$c] = '15';
					$pdf->CabecalhoGrid_Align[$c] = 'R';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = 'Valor Acrscimo';
					$pdf->CabecalhoGrid_Tamanho[$c] = '12';
					$pdf->CabecalhoGrid_Align[$c] = 'R';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = 'Valor Desconto';
					$pdf->CabecalhoGrid_Tamanho[$c] = '12';
					$pdf->CabecalhoGrid_Align[$c] = 'R';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = 'Valor Venda';
					$pdf->CabecalhoGrid_Tamanho[$c] = '15';
					$pdf->CabecalhoGrid_Align[$c] = 'R';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = ' ';
					$pdf->CabecalhoGrid_Tamanho[$c] = '9';
					$pdf->CabecalhoGrid_Align[$c] = 'C';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = 'Finalizadora';
					$pdf->CabecalhoGrid_Tamanho[$c] = '10';
					$pdf->CabecalhoGrid_Align[$c] = 'L';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$pdf->CabecalhoGrid_Texto[$c] = $label;
					$pdf->CabecalhoGrid_Tamanho[$c] = '20';
					$pdf->CabecalhoGrid_Align[$c] = 'L';
					$pdf->CabecalhoGrid_Border[$c] = 'TB';
					$c++;

					$lns = 5;
					$larg = 190;

					$pdf->SetFont('Arial','B',6);
					$pdf->Cell(1,      $lns, ' ', 0,0,'C');
					$pdf->SetAutoPageBreak(false,30);
					$pdf->SetFont('Arial','B',6);

					$y=$pdf->y;
					$pdf->MultiCell((4/100)*190, $lns,'','B','C');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((39/100)*190, $lns,'Produto','B','L');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((8/100)*190, $lns, 'Tributo','B','L');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((8/100)*190, $lns, 'Quantidade','B','R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((15/100)*190, $lns, 'Valor Unitrio','B','R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((15/100)*190, $lns, 'Valor Total','B','R');
					$pdf->y=$y;

					$y=$pdf->y;
					$pdf->MultiCell((11/100)*190, $lns,'','B','C');
					$pdf->y=$y;

					$pdf->Cell(1,      $lns, ' ', 0,1,'C');
					//Prxima Linha
					$pdf->x=$pdf->lMargin;
					$pdf->y=$y+$lns;
					$pdf->SetAutoPageBreak(true,30);


					$p=0;

					$pdf->CabecalhoGrid_Texto_Item[$p] = '';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '4';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'C';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = 'Produto';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '39';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'L';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = 'Tributo';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '8';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'L';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = 'Quantidade';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '8';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'R';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = 'Valor Unitrio';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '15';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'R';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = 'Valor Total';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '15';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'R';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$pdf->CabecalhoGrid_Texto_Item[$p] = '';
					$pdf->CabecalhoGrid_Tamanho_Item[$p] = '11';
					$pdf->CabecalhoGrid_Align_Item[$p] = 'C';
					$pdf->CabecalhoGrid_Border_Item[$p] = 'TB';
					$p++;

					$ncampos_item = 7;

					//$pdf->AddPage();
					$pdf->SetFont('Arial','',6);

					//$pdf->SetAutoPageBreak(true,30);

					$ncampos = 8;

					for($k=0;$k<$nro_ecf;$k++){
						$reg_ecf = consulta_ler_objeto($res_ecf);
						set_time_limit(60);

						$lns = 0;
						$larg = 190;
						$c=0;

						$pdf->SetFillColor(220,220,220);

						$pdf->SetFont('Arial','',6);
						$pdf->Cell(1,      $lns, ' ', 0,0,'C');
						$pdf->SetAutoPageBreak(false,30);
						$pdf->SetFont('Arial','',6);


						$rowarr[$c] = $reg_ecf->COO;
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$rowarr[$c] = str_replace('"','',to_money($reg_ecf->SubTotal));
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$rowarr[$c] = str_replace('"','',to_money($reg_ecf->Acrescimo));
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$rowarr[$c] = str_replace('"','',to_money($reg_ecf->Desconto));
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$vl_venda = to_money(($reg_ecf->SubTotal+$reg_ecf->Acrescimo)-($reg_ecf->Desconto));
						$rowarr[$c] = str_replace('"','', $vl_venda);
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;


						$cup_canc = '';
						if($reg_ecf->Cancelado=='S'){
							$cup_canc = 'Cancelado';
						}else{
							$cup_canc = '';
						}
						$rowarr[$c] = $cup_canc;
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$cons_fin = 'select DISTINCT(Desc_Finaliz) from ecf_cupom_fin '.
								   ' where Dominio = "'.$_SESSION['Dominio'].'"'.
								   ' and Empresa = "'.$empresa.'"'.
								   ' and NrFab = "'.$nrfab.'"'.
								   ' and DT_Emissao = "'.$reg_ecf->DT_Emissao.'"'.
								   ' and COO = "'.$reg_ecf->COO.'"';
						$res_fin = consulta_sql($cons_fin);
						$nro_fin = consulta_num_registros($res_fin);

						$finaliz = '';
						for($f=0;$f<$nro_fin;$f++){
							$reg_fin = consulta_ler_linha($res_fin);

							$desc_fin = substr($reg_fin[0],0,3);
							if(($desc_fin=='Car')||($desc_fin=='Che')){
								$desc_fin = strtoupper($desc_fin);
							}

							if($nro_fin>1){
								$finaliz.= '/';
								$finaliz.= $desc_fin;
							}else{
								$finaliz = $desc_fin;
							}
						}
						consulta_limpa($res_fin);

						$rowarr[$c] = $finaliz;
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$cons_vend = 'select Pessoa, Nome_Listas from pessoa '.
									' where Dominio = "'.$_SESSION['Dominio'].'" '.
									' and Pessoa = "'.$reg_ecf->Vendedor.'" ';
						$res_vend = consulta_sql($cons_vend);
						$reg_vend = consulta_ler_linha($res_vend);
						consulta_limpa($res_vend);

						$label_emp = empresa_representante($reg_ecf->Vendedor,'S');

						$rowarr[$c] = $label_emp;
						$vl_linha[$c] = $rowarr[$c];
						$lns_linha[$c] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg,5,$rowarr[$c],0);
						if ($lns_linha[$c]>$lns){
							$lns = $lns_linha[$c];
						}
						$c++;

						$lns = $lns * 3;

						for ($c=0;$c<$ncampos;$c++){
							$valor = $vl_linha[$c];
							$y=$pdf->y;
							$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho[$c]/100)*$larg, ($lns/($lns_linha[$c]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align[$c], 1);
							$pdf->y=$y;
						}

						$pdf->Cell(1,      $lns, ' ', 0,1,'C');
						//Prxima Linha
						$pdf->x=$pdf->lMargin;
						$pdf->y=$y+$lns;
						$pdf->SetAutoPageBreak(true,30);

						$pdf->SetFillColor(255,255,255);


						$cons_item = 'select Seq_Item, Id_Produto, Codigo_Produto, Descricao_Produto, '.
                                    ' Quantidade, Unidade_Medida, TributoSeq, TributoCod, '.
                                    ' Preco, ValorTotal, Desconto, '.
                                    ' Acrescimo, Cancelado, COO '.
                                    ' from ecf_cupom_item '.
                                    ' where Dominio = "'.$_SESSION['Dominio'].'" '.
                                    ' and Empresa = "'.$empresa.'" '.
                                    ' and NrFab = "'.$nrfab.'" '.
                                    ' and COO = "'.$reg_ecf->COO.'"'.
                                    ' order by Dominio, Empresa, NrFab, COO, Seq_Item ';

                        $res_item = consulta_sql($cons_item);
                        $nrows_item = consulta_num_registros($res_item);
                        if($nrows_item>0){                          

                            for($i=0;$i<$nrows_item;$i++){
								$reg_item = consulta_ler_objeto($res_item);
								set_time_limit(60);

								$lns = 0;
								$larg = 190;
								$p=0;

								$pdf->SetFont('Arial','',6);
								$pdf->Cell(1,      $lns, ' ', 0,0,'C');                              
								$pdf->SetAutoPageBreak(false,30);
								$pdf->SetFont('Arial','',6);

								$rowarr[$p] = '';
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;

								$rowarr[$p] = fill_full($reg_item->Codigo_Produto,14).' - '.$reg_item->Descricao_Produto;
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;
                             
								$tributo = $reg_item->TributoCod;
								if((substr($tributo,0,1)=='T')||(substr($tributo,0,1)=='S')){
									$tributo = fill_full($reg_item->TributoSeq,2).$reg_item->TributoCod;
								}else{
									$tributo = $reg_item->TributoCod;
								}
								$rowarr[$p] = $reg_item->TributoCod;
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;
                             
								$rowarr[$p] = formata_qtd($reg_item->Quantidade,3,false);
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;

								$rowarr[$p] = str_replace('"','',to_money($reg_item->Preco));
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;

								$rowarr[$p] = str_replace('"','',to_money($reg_item->ValorTotal));
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;
                              
								$item_canc = '';
								if($reg_item->Cancelado=='S'){
									$item_canc = 'Item Cancelado';
								}else{
									$item_canc = '';
								}
								$rowarr[$p] = $item_canc;
								$vl_linha[$p] = $rowarr[$p];
								$lns_linha[$p] = $pdf->Lines_MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg,5,$rowarr[$p],0);
								if ($lns_linha[$p]>$lns){
									$lns = $lns_linha[$p];
								}
								$p++;

								$lns = $lns * 3;

								for ($p=0;$p<$ncampos_item;$p++){
									$valor = $vl_linha[$p];
									$y=$pdf->y;
									$pdf->MultiCell(($pdf->CabecalhoGrid_Tamanho_Item[$p]/100)*$larg, ($lns/($lns_linha[$p]* 3)) * 3, $valor, 0,$pdf->CabecalhoGrid_Align_Item[$p]);
									$pdf->y=$y;
								}
                  
								$pdf->Cell(1,      $lns, ' ', 0,1,'C');
								//Prxima Linha
								$pdf->x=$pdf->lMargin;
								$pdf->y=$y+$lns;
								$pdf->SetAutoPageBreak(true,30);
							}
							consulta_limpa($res_item);
						}
					}
					consulta_limpa($res_ecf);
                }

			}//fim analitico
			$venda_bruta = 0;
			$venda_liq_red = 0;
			$venda_liq_base = 0;
			$finaliz = '';
			/*
			$pdf->Cell(1,      $lns, ' ', 0,0,'C');
			$pdf->SetFont('Arial','',6);
			$pdf->SetAutoPageBreak(false,30);

			$y=$pdf->y;
			$pdf->MultiCell((100/100)*$larg, $lns,'','','C');
			$pdf->y=$y;

			$pdf->Cell(1,      $lns, ' ', 0,1,'C');
			//Prxima Linha
			$pdf->x=$pdf->lMargin;
			$pdf->y=$y+$lns;
			$pdf->SetAutoPageBreak(true,30);
			*/

		}

		$lns = 3;
		$pdf->SetFont('Arial','B',6);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','B',6);

		$y=$pdf->y;
		$pdf->MultiCell($larg, $lns, 'Total Geral', 'T', 'L');
		$pdf->y=$y;

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->SetFont('Arial','',6);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','',6);

		$y=$pdf->y;
		$pdf->MultiCell((16/100)*$larg, $lns, 'Alquotas Tributveis:', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((20/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((15/100)*$larg, $lns, 'Alquotas  No Tributveis:', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((16/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((33/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$lns = 4;
		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetFont('Arial','',6);
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, 'Base', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, 'Valor', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, 'Base', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$lns = 4;
		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$lns = 3;
		$pdf->SetFont('Arial','',6);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','',6);

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, 'Total ICMS:', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_trib_baseG)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_trib_valorG)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalT_nao_trib_baseG)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, '', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$lns = 4;
		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);


		$lns = 3;
		$pdf->SetFont('Arial','',6);
		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);
		$pdf->SetFont('Arial','',6);

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, 'Total ISS:', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_trib_base)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_trib_valor)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((4/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((8/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, str_replace('"','',to_money($totalS_nao_trib_base)), '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((6/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((5/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((10/100)*$larg, $lns, '', '', 'L');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((12/100)*$larg, $lns, '', '', 'R');
		$pdf->y=$y;

		$y=$pdf->y;
		$pdf->MultiCell((11/100)*$larg, $lns, '', '', 'C');
		$pdf->y=$y;

		$lns = 4;
		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      $lns, ' ', 0,0,'C');
		$pdf->SetFont('Arial','',6);
		$pdf->SetAutoPageBreak(false,30);

		$pdf->Cell(1,      $lns, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+$lns;
		$pdf->SetAutoPageBreak(true,30);

	}else{
		$pdf->CabecalhoGrid_Texto= '';
		$pdf->AddPage();
		$pdf->SetFont('Arial','',8);

		$pdf->SetAutoPageBreak(true,30);

		$pdf->Cell(1,      5, '', 0,0,'C');
		$pdf->SetAutoPageBreak(false,30);

		$y=$pdf->y;
		$pdf->MultiCell(275, 5, 'No existem registros para este filtro!', 0,'L');
		$pdf->y=$y;

		$pdf->Cell(1,      5, ' ', 0,1,'C');
		//Prxima Linha
		$pdf->x=$pdf->lMargin;
		$pdf->y=$y+5;
		$pdf->SetAutoPageBreak(true,30);
    }

    consulta_limpa($res_reducao);
    echo $pdf->Output('Relatorio_'.config_pad('sistema_sigla').'.pdf','I');
}
?>